(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["Zinc"] = factory();
	else
		root["Zinc"] = factory();
})(this, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ([
/* 0 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(1);var PACKAGE=__webpack_require__(2),version=PACKAGE.version,Zinc=function(){this.Revision=version,this.defaultMaterialColor=16777215,this.defaultOpacity=1,this.modelPrefix=void 0,this.Geometry=(__webpack_require__(3).Geometry),this.Glyph=(__webpack_require__(16).Glyph),this.Glyphset=(__webpack_require__(18).Glyphset),this.Pointset=(__webpack_require__(22).Pointset),this.Label=(__webpack_require__(17).Label),this.Lines=(__webpack_require__(24).Lines),this.TextureArray=(__webpack_require__(25).TextureArray),this.TextureSlides=(__webpack_require__(27).TextureSlides),this.Renderer=(__webpack_require__(30).Renderer),this.Scene=(__webpack_require__(32).Scene),this.GeometryCSG=(__webpack_require__(51).GeometryCSG),this.GlyphsetCSG=(__webpack_require__(57).GlyphsetCSG),this.Viewport=(__webpack_require__(44).Viewport),this.CameraControls=(__webpack_require__(44).CameraControls),this.SmoothCameraTransition=(__webpack_require__(44).SmoothCameraTransition),this.RayCaster=(__webpack_require__(44).RayCaster),this.CameraAutoTumble=(__webpack_require__(44).CameraAutoTumble),this.StereoEffect=(__webpack_require__(44).StereoEffect),this.loadExternalFile=(__webpack_require__(5).loadExternalFile),this.loadExternalFiles=(__webpack_require__(5).loadExternalFiles),this.THREE=__webpack_require__(4)};/**
 * Provides a global namespace for the Zinc javascript library and some default parameters for it.
 * 
 * @namespace
 * @author Alan Wu
 */module.exports=new Zinc;

/***/ }),
/* 1 */
/***/ ((module) => {

"use strict";
module.exports = require("url-polyfill");

/***/ }),
/* 2 */
/***/ ((module) => {

"use strict";
module.exports = /*#__PURE__*/JSON.parse('{"name":"zincjs","version":"1.16.2","description":"ZincJS (Web-based-Zinc-Visualisation)","main":"build/zinc.js","directories":{"doc":"docs"},"files":["package.json","LICENSE","README.md","src/*","build/zinc.js","build/zinc.frontend.js","build/zinc.js.map","webpack.config.js"],"scripts":{"build-bundle":"webpack --config webpack.frontend.js; webpack --config webpack.backend.js","build-backend":"webpack --config webpack.backend.js","test":"npm --prefix ./test install && npm --prefix ./test run test-ci","changelog":"auto-changelog -p --output CHANGELOG.md --template keepachangelog","jsdoc":"jsdoc -c jsdoc_conf.json","version":"npm run build-bundle;npm run jsdoc;npm run changelog; git add CHANGELOG.md docs","release:beta":"npm version prerelease --preid=beta; npm publish --tag beta","release:minor":"npm version minor; npm publish","release:patch":"npm version patch;  npm publish"},"repository":{"type":"git","url":"git+https://github.com/alan-wu/ZincJS.git"},"keywords":["library","webgl","3d","zincjs"],"author":"Alan Wu <alan.wu@auckland.ac.nz>","license":"MIT","bugs":{"url":"https://github.com/alan-wu/ZincJS/issues"},"homepage":"http://alan-wu.github.io/ZincJS/","devDependencies":{"@babel/core":"^7.23.9","@babel/preset-env":"^7.23.9","auto-changelog":"^2.4.0","babel-loader":"^9.1.3","babel-preset-minify":"^0.5.1","file-loader":"^6.2.0","jsdoc":"^4.0.2","raw-loader":"^4.0.2","webpack":"^5.90.3","webpack-cli":"^5.1.4","webpack-node-externals":"^3.0.0"},"dependencies":{"css-element-queries":"^1.2.2","lodash":"^4.17.19","promise-polyfill":"^8.1.3","three":"^0.130.1","three-spritetext":"1.6.2","url-loader":"^4.1.1","url-polyfill":"^1.1.7","webworkify-webpack":"^2.1.5"}}');

/***/ }),
/* 3 */
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

var THREE=__webpack_require__(4),toBufferGeometry=(__webpack_require__(5).toBufferGeometry),createMeshForGeometry=(geometryIn,materialIn,options)=>{// First copy the geometry
var geometry=toBufferGeometry(geometryIn,options),isTransparent=!1;1>options.opacity&&(isTransparent=!0);var material;if(geometry._video===void 0){var morphTargets=options.localTimeEnabled||options.localMorphColour;materialIn?(material=materialIn,material.morphTargets=morphTargets,material.morphNormals=options.localTimeEnabled):geometry instanceof THREE.BufferGeometry&&geometry.attributes.color===void 0?material=new THREE.MeshPhongMaterial({color:options.colour,morphTargets:morphTargets,morphNormals:options.localTimeEnabled,transparent:isTransparent,opacity:options.opacity,side:THREE.DoubleSide}):material=new THREE.MeshPhongMaterial({color:options.colour,morphTargets:morphTargets,morphNormals:options.localTimeEnabled,vertexColors:THREE.VertexColors,transparent:isTransparent,opacity:options.opacity,side:THREE.DoubleSide}),options.localMorphColour&&geometry.morphAttributes.color&&(material.onBeforeCompile=(__webpack_require__(9).augmentMorphColor)())}else{var videoTexture=geometry._video.createCanvasVideoTexture();material=new THREE.MeshBasicMaterial({morphTargets:options.localTimeEnabled,color:new THREE.Color(1,1,1),transparent:isTransparent,opacity:options.opacity,map:videoTexture,side:THREE.DoubleSide}),this.videoHandler=geometry._video}return new THREE.Mesh(geometry,material)},Geometry=function(){// THREE.Geometry or THREE.BufferGeometry
/**
   * Create the mesh for rendering
   * 
   * @param {THREE.Geomtry} geometryIn - Geometry to be rendered.
   * @param {THREE.Material} materialIn - Material to be set for the geometry.
   * @param {Object} options - Provide various options
   * @param {THREE.Color}  options.colour - colour to be set for the geometry
   * @param {Boolean} options.localTimeEnabled - A flag to indicate either the geometry is
   * time dependent.
   * @param {Boolean} options.localMorphColour - A flag to indicate either the colour is
   * time dependent.
   * @param {Number} options.opacity - Opacity to be set for the geometry
   */ /**
   * Calculate the UV for texture rendering.
   */ /**
   * Handle transparent mesh, create a clone for backside rendering if it is
   * transparent.
   */ /**
	 * Set wireframe display for this geometry.
	 * 
	 * @param {Boolean} wireframe - Flag to turn on/off wireframe display.
	 */ /**
   * Edit Vertice in index.
   */(__webpack_require__(10).ZincObject).call(this),this.videoHandler=void 0,this.isGeometry=!0,this.createMesh=(geometryIn,materialIn,options)=>{//Skip if there is a morph already
if(!(this.morph&&this.morph.geometry&&null!=geometryIn)){var mesh=createMeshForGeometry(geometryIn,materialIn,options);this.setMesh(mesh,options.localTimeEnabled,options.localMorphColour)}},this.calculateUVs=()=>{this.geometry.computeBoundingBox();var max=this.geometry.boundingBox.max,min=this.geometry.boundingBox.min,offset=new THREE.Vector2(0-min.x,0-min.y),range=new THREE.Vector2(max.x-min.x,max.y-min.y);this.geometry.faceVertexUvs[0]=[];for(var i=0;i<this.geometry.faces.length;i++){var v1=this.geometry.vertices[this.geometry.faces[i].a],v2=this.geometry.vertices[this.geometry.faces[i].b],v3=this.geometry.vertices[this.geometry.faces[i].c];geometry.faceVertexUvs[0].push([new THREE.Vector2((v1.x+offset.x)/range.x,(v1.y+offset.y)/range.y),new THREE.Vector2((v2.x+offset.x)/range.x,(v2.y+offset.y)/range.y),new THREE.Vector2((v3.x+offset.x)/range.x,(v3.y+offset.y)/range.y)])}geometry.uvsNeedUpdate=!0},this.checkTransparentMesh=function(){this._lod.checkTransparentMesh()},this.setWireframe=wireframe=>{this.morph.material.wireframe=wireframe},this.editVertices=function(coords,i){if(coords&&coords.length){var mesh=this.getMorph(),attribute=mesh.geometry.getAttribute("position");if(!mesh||0>i)return;var index=3*i;coords.forEach(coord=>{attribute.array[index++]=coord[0],attribute.array[index++]=coord[1],attribute.array[index++]=coord[2]}),attribute.needsUpdate=!0,mesh.geometry.computeBoundingBox(),mesh.geometry.computeBoundingSphere(),this.boundingBoxUpdateRequired=!0}}};/**
 * Provides an object which stores geometry and provides method which controls its animations.
 * This is created when a valid json file containging geometry is read into a {@link Zinc.Scene}
 * object.
 * 
 * @class
 * @author Alan Wu
 * @return {Geometry}
 */Geometry.prototype=Object.create((__webpack_require__(10).ZincObject).prototype),exports.Geometry=Geometry;

/***/ }),
/* 4 */
/***/ ((module) => {

"use strict";
module.exports = require("three");

/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

function _readOnlyError(r){throw new TypeError("\""+r+"\" is read-only")}var THREE=__webpack_require__(4),THREEGeometry=(__webpack_require__(6).Geometry),SpriteText=(__webpack_require__(7)["default"]);function resolveURL(url){var actualURL=url,prefix=(__webpack_require__(0).modelPrefix);if(prefix){"/"!=prefix[prefix.length-1]&&(prefix+"/",_readOnlyError("prefix"));/^(?:[a-z]+:)?\/\//i.test(url)||(actualURL=prefix+url)}return actualURL}function createNewURL(target,reference){var getNewURL=(target,reference)=>{try{var newURL=new URL(target,reference).href;//Make sure the target url does not contain parameters
if(target&&2>target.split("?").length){var paramsStrings=reference.split("?");//There are parameters, add them to the target
2===paramsStrings.length&&(newURL=newURL+"?"+paramsStrings[1])}return newURL}catch(_unused){console.error("There is an issue creating the url link with: ".concat(target,"."))}};if(!Array.isArray(target))return getNewURL(target,reference);var urls=[];return target.forEach(url=>{urls.push(getNewURL(url,reference))}),urls}/*
 * Calculate the bounding box of a mesh, values will be
 * set for cachedBox, b1, v1 and v2 and they need to be
 * defined. 
 */function getBoundingBox(mesh,cachedBox,b1,v1,v2){var influences=mesh.morphTargetInfluences,attributes=void 0;mesh.geometry&&(attributes=mesh.geometry.morphAttributes);var found=!1;if(influences&&attributes&&attributes.position){v1.set(0,0,0),v2.set(0,0,0);for(var i=0;i<influences.length;i++)0<influences[i]&&(found=!0,b1.setFromArray(attributes.position[i].array),v1.add(b1.min.multiplyScalar(influences[i])),v2.add(b1.max.multiplyScalar(influences[i])));found&&cachedBox.set(v1,v2)}found||cachedBox.setFromBufferAttribute(mesh.geometry.attributes.position),mesh.updateWorldMatrix(!0,!0),cachedBox.applyMatrix4(mesh.matrixWorld)}//Convenient function
function loadExternalFile(url,data,callback,errorCallback){// Set up an asynchronous request
var request=new XMLHttpRequest;// Hook the event that gets called as the request progresses
request.open("GET",resolveURL(url),!0),request.onreadystatechange=()=>{4==request.readyState&&(200==request.status?callback(request.responseText,data):errorCallback(url))},request.send(null)}function loadExternalFiles(urls,callback,errorCallback){// Callback for a single file
function partialCallback(text,urlIndex){result[urlIndex]=text,numComplete++,numComplete==numUrls&&callback(result)}for(var numUrls=urls.length,numComplete=0,result=[],i=0;i<numUrls;i++)loadExternalFile(urls[i],i,partialCallback,errorCallback)}//Get the colours at index
exports.getColorsRGB=(colors,index)=>{var index_in_colors=Math.floor(index/3),remainder=index%3,hex_value=0;0==remainder?hex_value=colors[index_in_colors].r:1==remainder?hex_value=colors[index_in_colors].g:2==remainder&&(hex_value=colors[index_in_colors].b);var mycolor=new THREE.Color(hex_value);return[mycolor.r,mycolor.g,mycolor.b]},exports.updateMorphColorAttribute=function(targetGeometry,morph){if(morph&&targetGeometry&&targetGeometry.morphAttributes&&targetGeometry.morphAttributes.color){var morphColors=targetGeometry.morphAttributes.color,influences=morph.morphTargetInfluences,length=influences.length;targetGeometry.deleteAttribute("morphColor0"),targetGeometry.deleteAttribute("morphColor1");for(var bound=0,morphArray=[],i=0;1>bound||i<length;i++)0<influences[i]&&(bound++,morphArray.push([i,influences[i]]));2==morphArray.length?(targetGeometry.setAttribute("morphColor0",morphColors[morphArray[0][0]]),targetGeometry.setAttribute("morphColor1",morphColors[morphArray[1][0]])):1==morphArray.length&&(targetGeometry.setAttribute("morphColor0",morphColors[morphArray[0][0]]),targetGeometry.setAttribute("morphColor1",morphColors[morphArray[0][0]]))}},exports.toBufferGeometry=(geometryIn,options)=>{var geometry;return geometryIn instanceof THREEGeometry?(options.localTimeEnabled&&!geometryIn.morphNormalsReady&&(null==geometryIn.morphNormals||0==geometryIn.morphNormals.length)&&geometryIn.computeMorphNormals(),geometry=geometryIn.toIndexedBufferGeometry(),options.localMorphColour&&copyMorphColorsToIndexedBufferGeometry(geometryIn,geometry)):geometryIn instanceof THREE.BufferGeometry&&(geometry=geometryIn.clone()),geometry.colorsNeedUpdate=!0,geometry.computeBoundingBox(),geometry.computeBoundingSphere(),geometryIn._video&&(geometry._video=geometryIn._video),geometry},exports.copyMorphColorsToBufferGeometry=(geometry,bufferGeometry)=>{if(geometry&&geometry.morphColors&&0<geometry.morphColors.length){for(var array=[],morphColors=geometry.morphColors,getColorsRGB=(__webpack_require__(5).getColorsRGB),i=0,l=morphColors.length;i<l;i++){for(var morphColor=morphColors[i],colorArray=[],j=0;j<geometry.faces.length;j++){var face=geometry.faces[j],color=getColorsRGB(morphColor.colors,face.a);colorArray.push(color[0],color[1],color[2]),color=getColorsRGB(morphColor.colors,face.b),colorArray.push(color[0],color[1],color[2]),color=getColorsRGB(morphColor.colors,face.c),colorArray.push(color[0],color[1],color[2])}var attribute=new THREE.Float32BufferAttribute(3*(3*geometry.faces.length),3);attribute.name=morphColor.name,array.push(attribute.copyArray(colorArray))}bufferGeometry.morphAttributes.color=array}};var copyMorphColorsToIndexedBufferGeometry=(geometry,bufferGeometry)=>{if(geometry&&geometry.morphColors&&0<geometry.morphColors.length){for(var array=[],morphColors=geometry.morphColors,getColorsRGB=(__webpack_require__(5).getColorsRGB),i=0,l=morphColors.length;i<l;i++){for(var color,morphColor=morphColors[i],colorArray=[],j=0;j<3*morphColor.colors.length;j++)color=getColorsRGB(morphColor.colors,j),colorArray.push(color[0],color[1],color[2]);var attribute=new THREE.Float32BufferAttribute(colorArray,3);attribute.name=morphColor.name,array.push(attribute)}bufferGeometry.morphAttributes.color=array}};/**
 * Merges a set of attributes into a single instance. All attributes must have compatible properties and types.
 * Instances of {@link InterleavedBufferAttribute} are not supported.
 *
 * @param {Array<BufferAttribute>} attributes - The attributes to merge.
 * @return {?BufferAttribute} The merged attribute. Returns `null` if the merge does not succeed.
 */function mergeAttributes(attributes){for(var TypedArray,itemSize,normalized,attribute,gpuType=-1,arrayLength=0,i=0;i<attributes.length;++i){if(attribute=attributes[i],void 0===TypedArray&&(TypedArray=attribute.array.constructor),TypedArray!==attribute.array.constructor)return console.error("THREE.BufferGeometryUtils: .mergeAttributes() failed. BufferAttribute.array must be of consistent array types across matching attributes."),null;if(void 0===itemSize&&(itemSize=attribute.itemSize),itemSize!==attribute.itemSize)return console.error("THREE.BufferGeometryUtils: .mergeAttributes() failed. BufferAttribute.itemSize must be consistent across matching attributes."),null;if(void 0===normalized&&(normalized=attribute.normalized),normalized!==attribute.normalized)return console.error("THREE.BufferGeometryUtils: .mergeAttributes() failed. BufferAttribute.normalized must be consistent across matching attributes."),null;if(-1===gpuType&&(gpuType=attribute.gpuType),gpuType!==attribute.gpuType)return console.error("THREE.BufferGeometryUtils: .mergeAttributes() failed. BufferAttribute.gpuType must be consistent across matching attributes."),null;arrayLength+=attribute.count*itemSize}for(var _attribute,array=new TypedArray(arrayLength),result=new THREE.BufferAttribute(array,itemSize,normalized),offset=0,_i=0;_i<attributes.length;++_i){if(_attribute=attributes[_i],_attribute.isInterleavedBufferAttribute)for(var tupleOffset=offset/itemSize,j=0,l=_attribute.count;j<l;j++)for(var value,c=0;c<itemSize;c++)value=_attribute.getComponent(j,c),result.setComponent(j+tupleOffset,c,value);else array.set(_attribute.array,offset);offset+=_attribute.count*itemSize}return void 0!==gpuType&&(result.gpuType=gpuType),result}/**
 * Merges a set of geometries into a single instance. All geometries must have compatible attributes.
 *
 * @param {Array<BufferGeometry>} geometries - The geometries to merge.
 * @param {boolean} [useGroups=false] - Whether to use groups or not.
 * @return {?BufferGeometry} The merged geometry. Returns `null` if the merge does not succeed.
 */exports.mergeGeometries=function(geometries){for(var useGroups=!!(1<arguments.length&&arguments[1]!==void 0)&&arguments[1],isIndexed=null!==geometries[0].index,attributesUsed=new Set(Object.keys(geometries[0].attributes)),morphAttributesUsed=new Set(Object.keys(geometries[0].morphAttributes)),attributes={},morphAttributes={},morphTargetsRelative=geometries[0].morphTargetsRelative,mergedGeometry=new THREE.BufferGeometry,offset=0,i=0;i<geometries.length;++i){var geometry=geometries[i],attributesCount=0;// ensure that all geometries are indexed, or none
if(isIndexed!==(null!==geometry.index))return console.error("THREE.BufferGeometryUtils: .mergeGeometries() failed with geometry at index "+i+". All geometries must have compatible attributes; make sure index attribute exists among all geometries, or in none of them."),null;// gather attributes, exit early if they're different
for(var name in geometry.attributes){if(!attributesUsed.has(name))return console.error("THREE.BufferGeometryUtils: .mergeGeometries() failed with geometry at index "+i+". All geometries must have compatible attributes; make sure \""+name+"\" attribute exists among all geometries, or in none of them."),null;attributes[name]===void 0&&(attributes[name]=[]),attributes[name].push(geometry.attributes[name]),attributesCount++}// ensure geometries have the same number of attributes
if(attributesCount!==attributesUsed.size)return console.error("THREE.BufferGeometryUtils: .mergeGeometries() failed with geometry at index "+i+". Make sure all geometries have the same number of attributes."),null;// gather morph attributes, exit early if they're different
if(morphTargetsRelative!==geometry.morphTargetsRelative)return console.error("THREE.BufferGeometryUtils: .mergeGeometries() failed with geometry at index "+i+". .morphTargetsRelative must be consistent throughout all geometries."),null;for(var _name in geometry.morphAttributes){if(!morphAttributesUsed.has(_name))return console.error("THREE.BufferGeometryUtils: .mergeGeometries() failed with geometry at index "+i+".  .morphAttributes must be consistent throughout all geometries."),null;morphAttributes[_name]===void 0&&(morphAttributes[_name]=[]),morphAttributes[_name].push(geometry.morphAttributes[_name])}if(useGroups){var count=void 0;if(isIndexed)count=geometry.index.count;else if(void 0!==geometry.attributes.position)count=geometry.attributes.position.count;else return console.error("THREE.BufferGeometryUtils: .mergeGeometries() failed with geometry at index "+i+". The geometry must have either an index or a position attribute"),null;mergedGeometry.addGroup(offset,count,i),offset+=count}}// merge indices
if(isIndexed){for(var index,indexOffset=0,mergedIndex=[],_i2=0;_i2<geometries.length;++_i2){index=geometries[_i2].index;for(var j=0;j<index.count;++j)mergedIndex.push(index.getX(j)+indexOffset);indexOffset+=geometries[_i2].attributes.position.count}mergedGeometry.setIndex(mergedIndex)}// merge attributes
for(var _name2 in attributes){var mergedAttribute=mergeAttributes(attributes[_name2]);if(!mergedAttribute)return console.error("THREE.BufferGeometryUtils: .mergeGeometries() failed while trying to merge the "+_name2+" attribute."),null;mergedGeometry.setAttribute(_name2,mergedAttribute)}// merge morph attributes
for(var _name3 in morphAttributes){var numMorphTargets=morphAttributes[_name3][0].length;if(0===numMorphTargets)break;mergedGeometry.morphAttributes=mergedGeometry.morphAttributes||{},mergedGeometry.morphAttributes[_name3]=[];for(var morphAttributesToMerge,_i3=0;_i3<numMorphTargets;++_i3){morphAttributesToMerge=[];for(var _j=0;_j<morphAttributes[_name3].length;++_j)morphAttributesToMerge.push(morphAttributes[_name3][_j][_i3]);var mergedMorphAttribute=mergeAttributes(morphAttributesToMerge);if(!mergedMorphAttribute)return console.error("THREE.BufferGeometryUtils: .mergeGeometries() failed while trying to merge the "+_name3+" morphAttribute."),null;mergedGeometry.morphAttributes[_name3].push(mergedMorphAttribute)}}return mergedGeometry},exports.mergeVertices=function(geometry){var tolerance=1<arguments.length&&void 0!==arguments[1]?arguments[1]:1e-4;tolerance=Math.max(tolerance,Number.EPSILON);// next value for triangle indices
// attributes and new attribute arrays
// initialize the arrays
for(var name,hashToIndex={},indices=geometry.getIndex(),positions=geometry.getAttribute("position"),vertexCount=indices?indices.count:positions.count,nextIndex=0,attributeNames=Object.keys(geometry.attributes),attrArrays={},morphAttrsArrays={},newIndices=[],getters=["getX","getY","getZ","getW"],i=0,l=attributeNames.length;i<l;i++){name=attributeNames[i],attrArrays[name]=[];var morphAttr=geometry.morphAttributes[name];morphAttr&&(morphAttrsArrays[name]=Array(morphAttr.length).fill().map(()=>[]))}// convert the error tolerance to an amount of decimal places to truncate to
for(var decimalShift=Math.log10(1/tolerance),shiftMultiplier=Math.pow(10,decimalShift),i=0;i<vertexCount;i++){// Generate a hash for the vertex attributes at the current index 'i'
for(var index=indices?indices.getX(i):i,hash="",j=0,l=attributeNames.length;j<l;j++)for(var name=attributeNames[j],attribute=geometry.getAttribute(name),itemSize=attribute.itemSize,k=0;k<itemSize;k++)// double tilde truncates the decimal value
hash+="".concat(~~(attribute[getters[k]](index)*shiftMultiplier),",");// Add another reference to the vertex if it's already
// used by another index
if(hash in hashToIndex)newIndices.push(hashToIndex[hash]);else{// copy data to the new index in the attribute arrays
for(var j=0,l=attributeNames.length;j<l;j++)for(var getterFunc,name=attributeNames[j],attribute=geometry.getAttribute(name),morphAttr=geometry.morphAttributes[name],itemSize=attribute.itemSize,newarray=attrArrays[name],newMorphArrays=morphAttrsArrays[name],k=0;k<itemSize;k++)if(getterFunc=getters[k],newarray.push(attribute[getterFunc](index)),morphAttr)for(var m=0,ml=morphAttr.length;m<ml;m++)newMorphArrays[m].push(morphAttr[m][getterFunc](index));hashToIndex[hash]=nextIndex,newIndices.push(nextIndex),nextIndex++}}// Generate typed arrays from new attribute arrays and update
// the attributeBuffers
for(var result=geometry.clone(),i=0,l=attributeNames.length;i<l;i++){var attribute,name=attributeNames[i],oldAttribute=geometry.getAttribute(name),buffer=new oldAttribute.array.constructor(attrArrays[name]);// Update the attribute arrays
if(oldAttribute.isInterleavedBufferAttribute?attribute=new THREE.BufferAttribute(buffer,oldAttribute.itemSize,oldAttribute.itemSize):(attribute=geometry.getAttribute(name).clone(),attribute.setArray(buffer)),result.setAttribute(name,attribute),name in morphAttrsArrays)for(var morphAttribute,j=0;j<morphAttrsArrays[name].length;j++)morphAttribute=geometry.morphAttributes[name][j].clone(),morphAttribute.setArray(new morphAttribute.array.constructor(morphAttrsArrays[name][j])),result.morphAttributes[name][j]=morphAttribute}// Generate an index buffer typed array
var cons=Uint8Array;newIndices.length>=Math.pow(2,8)&&(cons=Uint16Array),newIndices.length>=Math.pow(2,16)&&(cons=Uint32Array);var newIndexBuffer=new cons(newIndices),newIndices=null;return null===indices?newIndices=new THREE.BufferAttribute(newIndexBuffer,1):(newIndices=geometry.getIndex().clone(),newIndices.setArray(newIndexBuffer)),result.setIndex(newIndices),result};function PhongToToon(materialIn){if(materialIn.isMeshPhongMaterial){var material=new THREE.MeshToonMaterial({color:materialIn.color.clone(),morphTargets:materialIn.morphTargets,morphNormals:materialIn.morphNormals,vertexColors:materialIn.vertexColors,transparent:materialIn.transparent,opacity:materialIn.opacity,side:materialIn.side});return materialIn.map&&(material.map=materialIn.map),material}return materialIn}/**
 * Create and return a new buffer geometry with the size of length,
 * and initial coords.
 */function createBufferGeometry(length,coords){if(coords&&length>=coords.length){var geometry=new THREE.BufferGeometry,vertices=new Float32Array(3*length),i=0;return coords.forEach(coord=>{vertices[i++]=coord[0],vertices[i++]=coord[1],vertices[i++]=coord[2]}),geometry.setAttribute("position",new THREE.BufferAttribute(vertices,3)),geometry.setDrawRange(0,coords.length),geometry}}function getCircularTexture(){var image=new Image;image.src=__webpack_require__(8);var texture=new THREE.Texture;return texture.image=image,texture.needsUpdate=!0,texture}function createNewSpriteText(text,height,colour,font,pixel,weight){var sprite=new SpriteText(text,height,colour,font,pixel,weight);return sprite.fontFace=font,sprite.fontSize=pixel,sprite.fontWeight=weight,sprite.material.map.generateMipmaps=!1,sprite.material.map.anisotropy=4,sprite.material.sizeAttenuation=!1,sprite.material.alphaTest=.5,sprite.material.transparent=!0,sprite.material.depthWrite=!1,sprite.material.depthTest=!1,sprite.center.set(.5,-1.2),sprite.renderOrder=1e4,sprite}/*
 * Check if the compare path match with the region or/and group.
 * comparePath should be in the form of regionPath/Group.
 * * can be used as wildcard.
 * comparePath will be used to compare both region and group if it
 * is a single string without /
 */function isRegionGroup(regionPath,groupName,comparePath){if(comparePath){var region=regionPath?regionPath:"",group=groupName?groupName:"",n=comparePath.lastIndexOf("/");if(-1<n){var r=void 0,g=void 0;if(r=comparePath.substring(0,n),g=comparePath.substring(n+1),("*"===r||"**"===r||r.toLowerCase()===region.toLowerCase())&&("*"===g||"**"===g||g.toLowerCase()===group.toLowerCase()))return!0}else//one single value if one of the region / group matches
if(region.toLowerCase()===comparePath.toLowerCase()||group.toLowerCase()===comparePath.toLowerCase())return!0}return!1}exports.getBoundingBox=getBoundingBox,exports.createNewURL=createNewURL,exports.createBufferGeometry=createBufferGeometry,exports.getCircularTexture=getCircularTexture,exports.resolveURL=resolveURL,exports.loadExternalFile=loadExternalFile,exports.loadExternalFiles=loadExternalFiles,exports.PhongToToon=PhongToToon,exports.createNewSpriteText=createNewSpriteText,exports.isRegionGroup=isRegionGroup;

/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Face3: () => (/* binding */ Face3),
/* harmony export */   Geometry: () => (/* binding */ Geometry)
/* harmony export */ });
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(three__WEBPACK_IMPORTED_MODULE_0__);
var _m1=new three__WEBPACK_IMPORTED_MODULE_0__.Matrix4,_obj=new three__WEBPACK_IMPORTED_MODULE_0__.Object3D,_offset=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_temp=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3;function Geometry(){// update flags
this.uuid=three__WEBPACK_IMPORTED_MODULE_0__.MathUtils.generateUUID(),this.name="",this.type="Geometry",this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.normals=[],this.uvs=[],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingBox=null,this.boundingSphere=null,this.elementsNeedUpdate=!1,this.verticesNeedUpdate=!1,this.uvsNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.lineDistancesNeedUpdate=!1,this.groupsNeedUpdate=!1,this.morphNormalsReady=!1}Geometry.prototype=Object.assign(Object.create(three__WEBPACK_IMPORTED_MODULE_0__.EventDispatcher.prototype),{constructor:Geometry,isGeometry:!0,applyMatrix4:function applyMatrix4(matrix){for(var vertex,normalMatrix=new three__WEBPACK_IMPORTED_MODULE_0__.Matrix3().getNormalMatrix(matrix),i=0,il=this.vertices.length;i<il;i++)vertex=this.vertices[i],vertex.applyMatrix4(matrix);for(var face,_i=0,_il=this.faces.length;_i<_il;_i++){face=this.faces[_i],face.normal.applyMatrix3(normalMatrix).normalize();for(var j=0,jl=face.vertexNormals.length;j<jl;j++)face.vertexNormals[j].applyMatrix3(normalMatrix).normalize()}return null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this.verticesNeedUpdate=!0,this.normalsNeedUpdate=!0,this},rotateX:function rotateX(angle){return _m1.makeRotationX(angle),this.applyMatrix4(_m1),this},rotateY:function rotateY(angle){return _m1.makeRotationY(angle),this.applyMatrix4(_m1),this},rotateZ:function rotateZ(angle){return _m1.makeRotationZ(angle),this.applyMatrix4(_m1),this},translate:function translate(x,y,z){return _m1.makeTranslation(x,y,z),this.applyMatrix4(_m1),this},scale:function scale(x,y,z){return _m1.makeScale(x,y,z),this.applyMatrix4(_m1),this},lookAt:function lookAt(vector){return _obj.lookAt(vector),_obj.updateMatrix(),this.applyMatrix4(_obj.matrix),this},fromBufferGeometry:function fromBufferGeometry(geometry){function addFace(a,b,c,materialIndex){var vertexColors=void 0===color?[]:[scope.colors[a].clone(),scope.colors[b].clone(),scope.colors[c].clone()],vertexNormals=void 0===normal?[]:[new three__WEBPACK_IMPORTED_MODULE_0__.Vector3().fromBufferAttribute(normal,a),new three__WEBPACK_IMPORTED_MODULE_0__.Vector3().fromBufferAttribute(normal,b),new three__WEBPACK_IMPORTED_MODULE_0__.Vector3().fromBufferAttribute(normal,c)],face=new Face3(a,b,c,vertexNormals,vertexColors,materialIndex);scope.faces.push(face),void 0!==uv&&scope.faceVertexUvs[0].push([new three__WEBPACK_IMPORTED_MODULE_0__.Vector2().fromBufferAttribute(uv,a),new three__WEBPACK_IMPORTED_MODULE_0__.Vector2().fromBufferAttribute(uv,b),new three__WEBPACK_IMPORTED_MODULE_0__.Vector2().fromBufferAttribute(uv,c)]),void 0!==uv2&&scope.faceVertexUvs[1].push([new three__WEBPACK_IMPORTED_MODULE_0__.Vector2().fromBufferAttribute(uv2,a),new three__WEBPACK_IMPORTED_MODULE_0__.Vector2().fromBufferAttribute(uv2,b),new three__WEBPACK_IMPORTED_MODULE_0__.Vector2().fromBufferAttribute(uv2,c)])}var scope=this,index=null===geometry.index?void 0:geometry.index,attributes=geometry.attributes;if(void 0===attributes.position)return console.error("THREE.Geometry.fromBufferGeometry(): Position attribute required for conversion."),this;var position=attributes.position,normal=attributes.normal,color=attributes.color,uv=attributes.uv,uv2=attributes.uv2;void 0!==uv2&&(this.faceVertexUvs[1]=[]);for(var i=0;i<position.count;i++)scope.vertices.push(new three__WEBPACK_IMPORTED_MODULE_0__.Vector3().fromBufferAttribute(position,i)),void 0!==color&&scope.colors.push(new three__WEBPACK_IMPORTED_MODULE_0__.Color().fromBufferAttribute(color,i));var groups=geometry.groups;if(0<groups.length)for(var _i2=0;_i2<groups.length;_i2++)for(var group=groups[_i2],start=group.start,count=group.count,j=start,jl=start+count;j<jl;j+=3)void 0===index?addFace(j,j+1,j+2,group.materialIndex):addFace(index.getX(j),index.getX(j+1),index.getX(j+2),group.materialIndex);else if(void 0!==index)for(var _i3=0;_i3<index.count;_i3+=3)addFace(index.getX(_i3),index.getX(_i3+1),index.getX(_i3+2));else for(var _i4=0;_i4<position.count;_i4+=3)addFace(_i4,_i4+1,_i4+2);return this.computeFaceNormals(),null!==geometry.boundingBox&&(this.boundingBox=geometry.boundingBox.clone()),null!==geometry.boundingSphere&&(this.boundingSphere=geometry.boundingSphere.clone()),this},center:function center(){return this.computeBoundingBox(),this.boundingBox.getCenter(_offset).negate(),this.translate(_offset.x,_offset.y,_offset.z),this},normalize:function normalize(){this.computeBoundingSphere();var center=this.boundingSphere.center,radius=this.boundingSphere.radius,s=0===radius?1:1/radius,matrix=new three__WEBPACK_IMPORTED_MODULE_0__.Matrix4;return matrix.set(s,0,0,-s*center.x,0,s,0,-s*center.y,0,0,s,-s*center.z,0,0,0,1),this.applyMatrix4(matrix),this},computeFaceNormals:function computeFaceNormals(){for(var cb=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,ab=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,f=0,fl=this.faces.length;f<fl;f++){var face=this.faces[f],vA=this.vertices[face.a],vB=this.vertices[face.b],vC=this.vertices[face.c];cb.subVectors(vC,vB),ab.subVectors(vA,vB),cb.cross(ab),cb.normalize(),face.normal.copy(cb)}},computeVertexNormals:function computeVertexNormals(){for(var areaWeighted=!(0<arguments.length&&void 0!==arguments[0])||arguments[0],vertices=Array(this.vertices.length),v=0,vl=this.vertices.length;v<vl;v++)vertices[v]=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3;if(areaWeighted)// vertex normals weighted by triangle areas
// http://www.iquilezles.org/www/articles/normals/normals.htm
for(var cb=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,ab=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,f=0,fl=this.faces.length;f<fl;f++){var face=this.faces[f],vA=this.vertices[face.a],vB=this.vertices[face.b],vC=this.vertices[face.c];cb.subVectors(vC,vB),ab.subVectors(vA,vB),cb.cross(ab),vertices[face.a].add(cb),vertices[face.b].add(cb),vertices[face.c].add(cb)}else{this.computeFaceNormals();for(var _face,_f=0,_fl=this.faces.length;_f<_fl;_f++)_face=this.faces[_f],vertices[_face.a].add(_face.normal),vertices[_face.b].add(_face.normal),vertices[_face.c].add(_face.normal)}for(var _v=0,_vl=this.vertices.length;_v<_vl;_v++)vertices[_v].normalize();for(var _f2=0,_fl2=this.faces.length;_f2<_fl2;_f2++){var _face2=this.faces[_f2],vertexNormals=_face2.vertexNormals;3===vertexNormals.length?(vertexNormals[0].copy(vertices[_face2.a]),vertexNormals[1].copy(vertices[_face2.b]),vertexNormals[2].copy(vertices[_face2.c])):(vertexNormals[0]=vertices[_face2.a].clone(),vertexNormals[1]=vertices[_face2.b].clone(),vertexNormals[2]=vertices[_face2.c].clone())}return 0<this.faces.length&&(this.normalsNeedUpdate=!0),vertices},computeFlatVertexNormals:function computeFlatVertexNormals(){this.computeFaceNormals();for(var f=0,fl=this.faces.length;f<fl;f++){var face=this.faces[f],vertexNormals=face.vertexNormals;3===vertexNormals.length?(vertexNormals[0].copy(face.normal),vertexNormals[1].copy(face.normal),vertexNormals[2].copy(face.normal)):(vertexNormals[0]=face.normal.clone(),vertexNormals[1]=face.normal.clone(),vertexNormals[2]=face.normal.clone())}0<this.faces.length&&(this.normalsNeedUpdate=!0)},computeMorphNormals:function computeMorphNormals(){// save original normals
// - create temp variables on first access
//   otherwise just copy (for faster repeated calls)
for(var face,f=0,fl=this.faces.length;f<fl;f++){face=this.faces[f],face.__originalFaceNormal?face.__originalFaceNormal.copy(face.normal):face.__originalFaceNormal=face.normal.clone(),face.__originalVertexNormals||(face.__originalVertexNormals=[]);for(var i=0,il=face.vertexNormals.length;i<il;i++)face.__originalVertexNormals[i]?face.__originalVertexNormals[i].copy(face.vertexNormals[i]):face.__originalVertexNormals[i]=face.vertexNormals[i].clone()}// use temp geometry to compute face and vertex normals for each morph
var tmpGeo=new Geometry;tmpGeo.faces=this.faces;for(var _i5=0,_il2=this.morphTargets.length;_i5<_il2;_i5++){// create on first access
if(!this.morphNormals[_i5]){this.morphNormals[_i5]={},this.morphNormals[_i5].faceNormals=[],this.morphNormals[_i5].vertexNormals=[];for(var dstNormalsFace=this.morphNormals[_i5].faceNormals,dstNormalsVertex=this.morphNormals[_i5].vertexNormals,_f3=0,_fl3=this.faces.length;_f3<_fl3;_f3++){var faceNormal=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_vertexNormals={a:new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,b:new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,c:new three__WEBPACK_IMPORTED_MODULE_0__.Vector3};dstNormalsFace.push(faceNormal),dstNormalsVertex.push(_vertexNormals)}}var morphNormals=this.morphNormals[_i5];// set vertices to morph target
tmpGeo.vertices=this.morphTargets[_i5].vertices,tmpGeo.computeFaceNormals();var vertexNormals=tmpGeo.computeVertexNormals();if(vertexNormals&&0<vertexNormals.length){this.morphTargets[_i5].normals=Array(this.vertices.length);for(var v=0;v<vertexNormals.length;v++)this.morphTargets[_i5].normals[v]=vertexNormals[v].clone()}// store morph normals
for(var _f4=0,_fl4=this.faces.length;_f4<_fl4;_f4++){var _face3=this.faces[_f4],_faceNormal=morphNormals.faceNormals[_f4],_vertexNormals2=morphNormals.vertexNormals[_f4];_faceNormal.copy(_face3.normal),_vertexNormals2.a.copy(_face3.vertexNormals[0]),_vertexNormals2.b.copy(_face3.vertexNormals[1]),_vertexNormals2.c.copy(_face3.vertexNormals[2])}}// restore original normals
for(var _face4,_f5=0,_fl5=this.faces.length;_f5<_fl5;_f5++)_face4=this.faces[_f5],_face4.normal=_face4.__originalFaceNormal,_face4.vertexNormals=_face4.__originalVertexNormals;this.morphNormalsReady=!0},computeBoundingBox:function computeBoundingBox(){null===this.boundingBox&&(this.boundingBox=new three__WEBPACK_IMPORTED_MODULE_0__.Box3),this.boundingBox.setFromPoints(this.vertices)},computeBoundingSphere:function computeBoundingSphere(){null===this.boundingSphere&&(this.boundingSphere=new three__WEBPACK_IMPORTED_MODULE_0__.Sphere),this.boundingSphere.setFromPoints(this.vertices)},mergeMorph:function mergeMorph(geometry,matrix){var m=this.morphTargets.length,morphTargets1=this.morphTargets,morphTargets2=geometry.morphTargets,n=this.morphColors.length,morphColors1=this.morphColors,morphColors2=geometry.morphColors;if(0<m&&m==morphTargets2.length)for(var i=0,l=morphTargets1.length;i<l;i++){for(var morphTarget1=morphTargets1[i],morphTarget2=morphTargets2[i],k=0,kl=morphTarget2.vertices.length;k<kl;k++){var vertex=morphTarget2.vertices[k],vertexCopy=vertex.clone();void 0!==matrix&&vertexCopy.applyMatrix4(matrix),morphTarget1.vertices.push(vertexCopy)}if(morphTarget1.normals&&morphTarget2.normals)for(var _k=0;_k<morphTarget2.normals.length;_k+=3)_temp.set(morphTarget2.normals2[_k],morphTarget2.normals2[_k+1],morphTarget2.normals2[_k+2]),void 0!==matrix&&_temp.applyMatrix4(matrix),morphTarget1.normals.push(_temp.x,_temp.y,_temp.z)}if(0<n&&n==morphColors2.length)for(var _i6=0,_l=morphColors1.length;_i6<_l;_i6++)for(var morphColor1=morphColors1[_i6],morphColor2=morphColors2[_i6],_k2=0,_kl=morphColor2.colors;_k2<_kl;_k2++)morphColor1.colors.push(morphColor2.colors[_k2].clone())},merge:function merge(geometry,matrix){var materialIndexOffset=2<arguments.length&&arguments[2]!==void 0?arguments[2]:0;if(!(geometry&&geometry.isGeometry))return void console.error("THREE.Geometry.merge(): geometry not an instance of THREE.Geometry.",geometry);var normalMatrix,vertexOffset=this.vertices.length,vertices1=this.vertices,vertices2=geometry.vertices,normals2=geometry.normals,faces1=this.faces,faces2=geometry.faces,colors1=this.colors,colors2=geometry.colors;matrix!==void 0&&(normalMatrix=new three__WEBPACK_IMPORTED_MODULE_0__.Matrix3().getNormalMatrix(matrix));// vertices
for(var i=0,il=vertices2.length;i<il;i++){var vertex=vertices2[i],vertexCopy=vertex.clone();matrix!==void 0&&vertexCopy.applyMatrix4(matrix),vertices1.push(vertexCopy)}for(var _i7=0;_i7<normals2.length;_i7+=3)_temp.set(normals2[_i7],normals2[_i7+1],normals2[_i7+2]),void 0!==matrix&&_temp.applyMatrix4(matrix),this.normals.push(_temp.x,_temp.y,_temp.z);// colors
for(var _i8=0,_il3=colors2.length;_i8<_il3;_i8++)"number"==typeof colors2[_i8]?colors1.push(colors2[_i8]):colors1.push(colors2[_i8].clone());// faces
for(var _i9=0,_il4=faces2.length;_i9<_il4;_i9++){var face=faces2[_i9],normal=void 0,color=void 0,faceVertexNormals=face.vertexNormals,faceVertexColors=face.vertexColors,faceCopy=new Face3(face.a+vertexOffset,face.b+vertexOffset,face.c+vertexOffset);faceCopy.normal.copy(face.normal),normalMatrix!==void 0&&faceCopy.normal.applyMatrix3(normalMatrix).normalize();for(var j=0,jl=faceVertexNormals.length;j<jl;j++)normal=faceVertexNormals[j].clone(),void 0!==normalMatrix&&normal.applyMatrix3(normalMatrix).normalize(),faceCopy.vertexNormals.push(normal);faceCopy.color.copy(face.color);for(var _j=0,_jl=faceVertexColors.length;_j<_jl;_j++)color=faceVertexColors[_j],faceCopy.vertexColors.push(color.clone());faceCopy.materialIndex=face.materialIndex+materialIndexOffset,faces1.push(faceCopy)}// uvs
for(var faceVertexUvs2,_i10=0,_il5=geometry.faceVertexUvs.length;_i10<_il5;_i10++){faceVertexUvs2=geometry.faceVertexUvs[_i10],this.faceVertexUvs[_i10]===void 0&&(this.faceVertexUvs[_i10]=[]);for(var _j2=0,_jl2=faceVertexUvs2.length;_j2<_jl2;_j2++){for(var uvs2=faceVertexUvs2[_j2],uvsCopy=[],k=0,kl=uvs2.length;k<kl;k++)uvsCopy.push(uvs2[k].clone());this.faceVertexUvs[_i10].push(uvsCopy)}}this.mergeMorph(geometry,matrix)},mergeMesh:function mergeMesh(mesh){return mesh&&mesh.isMesh?void(mesh.matrixAutoUpdate&&mesh.updateMatrix(),this.merge(mesh.geometry,mesh.matrix)):void console.error("THREE.Geometry.mergeMesh(): mesh not an instance of THREE.Mesh.",mesh)},/*
	 * Checks for duplicate vertices with hashmap.
	 * Duplicated vertices are removed
	 * and faces' vertices are updated.
	 */mergeVertices:function mergeVertices(){// Hashmap for looking up vertices by position coordinates (and making sure they are unique)
for(var precisionPoints=0<arguments.length&&void 0!==arguments[0]?arguments[0]:4,verticesMap={},unique=[],changes=[],precision=Math.pow(10,precisionPoints),i=0,il=this.vertices.length;i<il;i++){var v=this.vertices[i],key=Math.round(v.x*precision)+"_"+Math.round(v.y*precision)+"_"+Math.round(v.z*precision);void 0===verticesMap[key]?(verticesMap[key]=i,unique.push(this.vertices[i]),changes[i]=unique.length-1):changes[i]=changes[verticesMap[key]]}// if faces are completely degenerate after merging vertices, we
// have to remove them from the geometry.
for(var face,faceIndicesToRemove=[],_i11=0,_il6=this.faces.length;_i11<_il6;_i11++){face=this.faces[_i11],face.a=changes[face.a],face.b=changes[face.b],face.c=changes[face.c];// if any duplicate vertices are found in a Face3
// we have to remove the face as nothing can be saved
for(var indices=[face.a,face.b,face.c],n=0;3>n;n++)if(indices[n]===indices[(n+1)%3]){faceIndicesToRemove.push(_i11);break}}for(var idx,_i12=faceIndicesToRemove.length-1;0<=_i12;_i12--){idx=faceIndicesToRemove[_i12],this.faces.splice(idx,1);for(var j=0,jl=this.faceVertexUvs.length;j<jl;j++)this.faceVertexUvs[j].splice(idx,1)}// Use unique set of vertices
var diff=this.vertices.length-unique.length;return this.vertices=unique,diff},setFromPoints:function setFromPoints(points){this.vertices=[];for(var point,i=0,l=points.length;i<l;i++)point=points[i],this.vertices.push(new three__WEBPACK_IMPORTED_MODULE_0__.Vector3(point.x,point.y,point.z||0));return this},sortFacesByMaterialIndex:function sortFacesByMaterialIndex(){// sort faces
// tag faces
for(var faces=this.faces,length=faces.length,i=0;i<length;i++)faces[i]._id=i;faces.sort(function(a,b){return a.materialIndex-b.materialIndex});// sort uvs
var newUvs1,newUvs2,uvs1=this.faceVertexUvs[0],uvs2=this.faceVertexUvs[1];uvs1&&uvs1.length===length&&(newUvs1=[]),uvs2&&uvs2.length===length&&(newUvs2=[]);for(var id,_i13=0;_i13<length;_i13++)id=faces[_i13]._id,newUvs1&&newUvs1.push(uvs1[id]),newUvs2&&newUvs2.push(uvs2[id]);newUvs1&&(this.faceVertexUvs[0]=newUvs1),newUvs2&&(this.faceVertexUvs[1]=newUvs2)},toJSON:function toJSON(){function setBit(value,position,enabled){return enabled?value|1<<position:value&~(1<<position)}function getNormalIndex(normal){var hash=normal.x.toString()+normal.y.toString()+normal.z.toString();return void 0===normalsHash[hash]?(normalsHash[hash]=normals.length/3,normals.push(normal.x,normal.y,normal.z),normalsHash[hash]):normalsHash[hash]}function getColorIndex(color){var hash=color.r.toString()+color.g.toString()+color.b.toString();return void 0===colorsHash[hash]?(colorsHash[hash]=colors.length,colors.push(color.getHex()),colorsHash[hash]):colorsHash[hash]}function getUvIndex(uv){var hash=uv.x.toString()+uv.y.toString();return void 0===uvsHash[hash]?(uvsHash[hash]=uvs.length/2,uvs.push(uv.x,uv.y),uvsHash[hash]):uvsHash[hash]}var data={metadata:{version:4.5,type:"Geometry",generator:"Geometry.toJSON"}};// standard Geometry serialization
if(data.uuid=this.uuid,data.type=this.type,""!==this.name&&(data.name=this.name),void 0!==this.parameters){var parameters=this.parameters;for(var key in parameters)void 0!==parameters[key]&&(data[key]=parameters[key]);return data}for(var vertex,vertices=[],i=0;i<this.vertices.length;i++)vertex=this.vertices[i],vertices.push(vertex.x,vertex.y,vertex.z);for(var faces=[],normals=[],normalsHash={},colors=[],colorsHash={},uvs=[],uvsHash={},_i14=0;_i14<this.faces.length;_i14++){var face=this.faces[_i14],hasMaterial=!0,hasFaceUv=!1,hasFaceVertexUv=void 0!==this.faceVertexUvs[0][_i14],hasFaceNormal=0<face.normal.length(),hasFaceVertexNormal=0<face.vertexNormals.length,hasFaceColor=1!==face.color.r||1!==face.color.g||1!==face.color.b,hasFaceVertexColor=0<face.vertexColors.length,faceType=0;// deprecated
if(faceType=setBit(faceType,0,0),faceType=setBit(faceType,1,hasMaterial),faceType=setBit(faceType,2,hasFaceUv),faceType=setBit(faceType,3,hasFaceVertexUv),faceType=setBit(faceType,4,hasFaceNormal),faceType=setBit(faceType,5,hasFaceVertexNormal),faceType=setBit(faceType,6,hasFaceColor),faceType=setBit(faceType,7,hasFaceVertexColor),faces.push(faceType),faces.push(face.a,face.b,face.c),faces.push(face.materialIndex),hasFaceVertexUv){var faceVertexUvs=this.faceVertexUvs[0][_i14];faces.push(getUvIndex(faceVertexUvs[0]),getUvIndex(faceVertexUvs[1]),getUvIndex(faceVertexUvs[2]))}if(hasFaceNormal&&faces.push(getNormalIndex(face.normal)),hasFaceVertexNormal){var vertexNormals=face.vertexNormals;faces.push(getNormalIndex(vertexNormals[0]),getNormalIndex(vertexNormals[1]),getNormalIndex(vertexNormals[2]))}if(hasFaceColor&&faces.push(getColorIndex(face.color)),hasFaceVertexColor){var vertexColors=face.vertexColors;faces.push(getColorIndex(vertexColors[0]),getColorIndex(vertexColors[1]),getColorIndex(vertexColors[2]))}}return data.data={},data.data.vertices=vertices,data.data.normals=normals,0<colors.length&&(data.data.colors=colors),0<uvs.length&&(data.data.uvs=[uvs]),data.data.faces=faces,data},clone:function clone(){/*
		 // Handle primitives

		 const parameters = this.parameters;

		 if ( parameters !== undefined ) {

		 const values = [];

		 for ( const key in parameters ) {

		 values.push( parameters[ key ] );

		 }

		 const geometry = Object.create( this.constructor.prototype );
		 this.constructor.apply( geometry, values );
		 return geometry;

		 }

		 return new this.constructor().copy( this );
		 */return new Geometry().copy(this)},copy:function copy(source){this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingBox=null,this.boundingSphere=null,this.name=source.name;for(var vertices=source.vertices,i=0,il=vertices.length;i<il;i++)this.vertices.push(vertices[i].clone());// colors
for(var colors=source.colors,_i15=0,_il7=colors.length;_i15<_il7;_i15++)this.colors.push(colors[_i15].clone());// faces
for(var faces=source.faces,_i16=0,_il8=faces.length;_i16<_il8;_i16++)this.faces.push(faces[_i16].clone());// face vertex uvs
for(var faceVertexUvs,_i17=0,_il9=source.faceVertexUvs.length;_i17<_il9;_i17++){faceVertexUvs=source.faceVertexUvs[_i17],void 0===this.faceVertexUvs[_i17]&&(this.faceVertexUvs[_i17]=[]);for(var j=0,jl=faceVertexUvs.length;j<jl;j++){for(var uv,uvs=faceVertexUvs[j],uvsCopy=[],k=0,kl=uvs.length;k<kl;k++)uv=uvs[k],uvsCopy.push(uv.clone());this.faceVertexUvs[_i17].push(uvsCopy)}}// morph targets
for(var morphTarget,morphTargets=source.morphTargets,_i18=0,_il10=morphTargets.length;_i18<_il10;_i18++){// vertices
if(morphTarget={},morphTarget.name=morphTargets[_i18].name,void 0!==morphTargets[_i18].vertices){morphTarget.vertices=[];for(var _j3=0,_jl3=morphTargets[_i18].vertices.length;_j3<_jl3;_j3++)morphTarget.vertices.push(morphTargets[_i18].vertices[_j3].clone())}// normals
if(void 0!==morphTargets[_i18].normals){morphTarget.normals=[];for(var _j4=0,_jl4=morphTargets[_i18].normals.length;_j4<_jl4;_j4++)morphTarget.normals.push(morphTargets[_i18].normals[_j4].clone())}this.morphTargets.push(morphTarget)}// morph normals
for(var morphNormal,morphNormals=source.morphNormals,_i19=0,_il11=morphNormals.length;_i19<_il11;_i19++){// vertex normals
if(morphNormal={},void 0!==morphNormals[_i19].vertexNormals){morphNormal.vertexNormals=[];for(var _j5=0,_jl5=morphNormals[_i19].vertexNormals.length;_j5<_jl5;_j5++){var srcVertexNormal=morphNormals[_i19].vertexNormals[_j5],destVertexNormal={};destVertexNormal.a=srcVertexNormal.a.clone(),destVertexNormal.b=srcVertexNormal.b.clone(),destVertexNormal.c=srcVertexNormal.c.clone(),morphNormal.vertexNormals.push(destVertexNormal)}}// face normals
if(void 0!==morphNormals[_i19].faceNormals){morphNormal.faceNormals=[];for(var _j6=0,_jl6=morphNormals[_i19].faceNormals.length;_j6<_jl6;_j6++)morphNormal.faceNormals.push(morphNormals[_i19].faceNormals[_j6].clone())}this.morphNormals.push(morphNormal)}// skin weights
for(var skinWeights=source.skinWeights,_i20=0,_il12=skinWeights.length;_i20<_il12;_i20++)this.skinWeights.push(skinWeights[_i20].clone());// skin indices
for(var skinIndices=source.skinIndices,_i21=0,_il13=skinIndices.length;_i21<_il13;_i21++)this.skinIndices.push(skinIndices[_i21].clone());// line distances
for(var lineDistances=source.lineDistances,_i22=0,_il14=lineDistances.length;_i22<_il14;_i22++)this.lineDistances.push(lineDistances[_i22]);// bounding box
var boundingBox=source.boundingBox;null!==boundingBox&&(this.boundingBox=boundingBox.clone());// bounding sphere
var boundingSphere=source.boundingSphere;return null!==boundingSphere&&(this.boundingSphere=boundingSphere.clone()),this.elementsNeedUpdate=source.elementsNeedUpdate,this.verticesNeedUpdate=source.verticesNeedUpdate,this.uvsNeedUpdate=source.uvsNeedUpdate,this.normalsNeedUpdate=source.normalsNeedUpdate,this.colorsNeedUpdate=source.colorsNeedUpdate,this.lineDistancesNeedUpdate=source.lineDistancesNeedUpdate,this.groupsNeedUpdate=source.groupsNeedUpdate,this},computeGroups(){var group,i,groups=[],materialIndex=void 0,faces=this.faces;for(i=0;i<faces.length;i++){var face=faces[i];// materials
face.materialIndex!==materialIndex&&(materialIndex=face.materialIndex,void 0!==group&&(group.count=3*i-group.start,groups.push(group)),group={start:3*i,materialIndex:materialIndex})}return void 0!==group&&(group.count=3*i-group.start,groups.push(group)),groups},toBufferGeometry:function toBufferGeometry(){var geometry=new DirectGeometry().fromGeometry(this),buffergeometry=new three__WEBPACK_IMPORTED_MODULE_0__.BufferGeometry,positions=new Float32Array(3*geometry.vertices.length);if(buffergeometry.setAttribute("position",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(positions,3).copyVector3sArray(geometry.vertices)),0<geometry.normals.length){var normals=new Float32Array(3*geometry.normals.length);buffergeometry.setAttribute("normal",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(normals,3).copyVector3sArray(geometry.normals))}if(0<geometry.colors.length){var colors=new Float32Array(3*geometry.colors.length);buffergeometry.setAttribute("color",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(colors,3).copyColorsArray(geometry.colors))}if(0<geometry.uvs.length){var uvs=new Float32Array(2*geometry.uvs.length);buffergeometry.setAttribute("uv",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(uvs,2).copyVector2sArray(geometry.uvs))}if(0<geometry.uvs2.length){var uvs2=new Float32Array(2*geometry.uvs2.length);buffergeometry.setAttribute("uv2",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(uvs2,2).copyVector2sArray(geometry.uvs2))}// groups
// morphs
for(var name in buffergeometry.groups=geometry.groups,geometry.morphTargets){for(var array=[],morphTargets=geometry.morphTargets[name],i=0,l=morphTargets.length;i<l;i++){var morphTarget=morphTargets[i],attribute=new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(3*morphTarget.data.length,3);attribute.name=morphTarget.name,array.push(attribute.copyVector3sArray(morphTarget.data))}buffergeometry.morphAttributes[name]=array}// skinning
if(0<geometry.skinIndices.length){var skinIndices=new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(4*geometry.skinIndices.length,4);buffergeometry.setAttribute("skinIndex",skinIndices.copyVector4sArray(geometry.skinIndices))}if(0<geometry.skinWeights.length){var skinWeights=new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(4*geometry.skinWeights.length,4);buffergeometry.setAttribute("skinWeight",skinWeights.copyVector4sArray(geometry.skinWeights))}//
return null!==geometry.boundingSphere&&(buffergeometry.boundingSphere=geometry.boundingSphere.clone()),null!==geometry.boundingBox&&(buffergeometry.boundingBox=geometry.boundingBox.clone()),buffergeometry},toIndexedBufferGeometry:function toIndexedBufferGeometry(){//const geometry = new DirectGeometry().fromGeometry( this );
var buffergeometry=new three__WEBPACK_IMPORTED_MODULE_0__.BufferGeometry,positions=new Float32Array(3*this.vertices.length);if(buffergeometry.setAttribute("position",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(positions,3).copyVector3sArray(this.vertices)),0<this.normals.length){var normals=new Float32Array(this.normals.length),buffer=new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(normals,3).copyArray(this.normals);buffergeometry.setAttribute("normal",buffer)}if(0<this.uvs.length&&0<this.uvs[0].length){var uvs=new Float32Array(2*this.uvs[0].length);buffergeometry.setAttribute("uv",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(uvs,2).copyArray(this.uvs[0]))}if(1<this.uvs.length&&0<this.uvs[1].length){var uvs2=new Float32Array(2*this.uvs[1].length);buffergeometry.setAttribute("uv2",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(uvs2,2).copyArray(this.uvs[1]))}if(0<this.colors.length){for(var colorArray=[],i=0;i<this.colors.length;i++)colorArray.push(new three__WEBPACK_IMPORTED_MODULE_0__.Color(this.colors[i]));var colors=new Float32Array(3*colorArray.length);buffergeometry.setAttribute("color",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(colors,3).copyColorsArray(colorArray))}else{for(var colorsArray=new Float32Array(3*this.vertices.length),_i23=0;_i23<3*this.vertices.length;_i23++)colorsArray[_i23]=1;buffergeometry.setAttribute("color",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(colorsArray,3))}if(0<this.faces.length){for(var _colors=[],indices=[],_i24=0;_i24<this.faces.length;_i24++){indices.push(this.faces[_i24].a,this.faces[_i24].b,this.faces[_i24].c);var vertexColors=this.faces[_i24].vertexColors;if(3===vertexColors.length)_colors.push(vertexColors[0],vertexColors[1],vertexColors[2]);else{var color=this.faces[_i24].color;_colors.push(color,color,color)}}// if ( colors.length > 0 ) {
//        const colorsArray = new Float32Array( colors.length * 3 );
//        buffergeometry.setAttribute( 'color', new BufferAttribute( colorsArray, 3 ).copyColorsArray( colors ) );
//      }
buffergeometry.setIndex(indices),buffergeometry.groups=this.computeGroups()}// morphs
if(0<this.morphTargets.length){for(var array=[],normalsArray=[],_i25=0,l=this.morphTargets.length;_i25<l;_i25++){var morphTarget=this.morphTargets[_i25],attribute=new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(3*morphTarget.vertices.length,3);if(attribute.name=morphTarget.name,array.push(attribute.copyVector3sArray(morphTarget.vertices)),morphTarget.normals){var _attribute=new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(3*morphTarget.normals.length,3);_attribute.name=morphTarget.name,normalsArray.push(_attribute.copyVector3sArray(morphTarget.normals))}}buffergeometry.morphAttributes.position=array,buffergeometry.morphAttributes.normal=normalsArray}// skinning
if(0<this.skinIndices.length){var skinIndices=new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(4*this.skinIndices.length,4);buffergeometry.setAttribute("skinIndex",skinIndices.copyVector4sArray(this.skinIndices))}if(0<this.skinWeights.length){var skinWeights=new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(4*this.skinWeights.length,4);buffergeometry.setAttribute("skinWeight",skinWeights.copyVector4sArray(this.skinWeights))}//
return null!==this.boundingSphere&&(buffergeometry.boundingSphere=this.boundingSphere.clone()),null!==this.boundingBox&&(buffergeometry.boundingBox=this.boundingBox.clone()),buffergeometry},computeTangents:function computeTangents(){console.error("THREE.Geometry: .computeTangents() has been removed.")},computeLineDistances:function computeLineDistances(){console.error("THREE.Geometry: .computeLineDistances() has been removed. Use THREE.Line.computeLineDistances() instead.")},applyMatrix:function applyMatrix(matrix){return console.warn("THREE.Geometry: .applyMatrix() has been renamed to .applyMatrix4()."),this.applyMatrix4(matrix)},dispose:function dispose(){this.dispatchEvent({type:"dispose"})}}),Geometry.createBufferGeometryFromObject=function(object){var buffergeometry=new three__WEBPACK_IMPORTED_MODULE_0__.BufferGeometry,geometry=object.geometry;if(object.isPoints||object.isLine){var positions=new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(3*geometry.vertices.length,3),colors=new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(3*geometry.colors.length,3);if(buffergeometry.setAttribute("position",positions.copyVector3sArray(geometry.vertices)),buffergeometry.setAttribute("color",colors.copyColorsArray(geometry.colors)),geometry.lineDistances&&geometry.lineDistances.length===geometry.vertices.length){var lineDistances=new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(geometry.lineDistances.length,1);buffergeometry.setAttribute("lineDistance",lineDistances.copyArray(geometry.lineDistances))}null!==geometry.boundingSphere&&(buffergeometry.boundingSphere=geometry.boundingSphere.clone()),null!==geometry.boundingBox&&(buffergeometry.boundingBox=geometry.boundingBox.clone())}else object.isMesh&&(buffergeometry=geometry.toBufferGeometry());return buffergeometry};class DirectGeometry{constructor(){// this.lineDistances = [];
// update flags
this.vertices=[],this.normals=[],this.colors=[],this.uvs=[],this.uvs2=[],this.groups=[],this.morphTargets={},this.skinWeights=[],this.skinIndices=[],this.boundingBox=null,this.boundingSphere=null,this.verticesNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.uvsNeedUpdate=!1,this.groupsNeedUpdate=!1}computeGroups(geometry){var group,i,groups=[],materialIndex=void 0,faces=geometry.faces;for(i=0;i<faces.length;i++){var face=faces[i];// materials
face.materialIndex!==materialIndex&&(materialIndex=face.materialIndex,group!==void 0&&(group.count=3*i-group.start,groups.push(group)),group={start:3*i,materialIndex:materialIndex})}group!==void 0&&(group.count=3*i-group.start,groups.push(group)),this.groups=groups}fromGeometry(geometry){var morphTargetsPosition,faces=geometry.faces,vertices=geometry.vertices,faceVertexUvs=geometry.faceVertexUvs,hasFaceVertexUv=faceVertexUvs[0]&&0<faceVertexUvs[0].length,hasFaceVertexUv2=faceVertexUvs[1]&&0<faceVertexUvs[1].length,morphTargets=geometry.morphTargets,morphTargetsLength=morphTargets.length;// morphs
if(0<morphTargetsLength){morphTargetsPosition=[];for(var i=0;i<morphTargetsLength;i++)morphTargetsPosition[i]={name:morphTargets[i].name,data:[]};this.morphTargets.position=morphTargetsPosition}var morphTargetsNormal,morphNormals=geometry.morphNormals,morphNormalsLength=morphNormals.length;if(0<morphNormalsLength){morphTargetsNormal=[];for(var _i26=0;_i26<morphNormalsLength;_i26++)morphTargetsNormal[_i26]={name:morphNormals[_i26].name,data:[]};this.morphTargets.normal=morphTargetsNormal}// skins
var skinIndices=geometry.skinIndices,skinWeights=geometry.skinWeights,hasSkinIndices=skinIndices.length===vertices.length,hasSkinWeights=skinWeights.length===vertices.length;0<vertices.length&&0===faces.length&&console.error("THREE.DirectGeometry: Faceless geometries are not supported.");for(var face,_i27=0;_i27<faces.length;_i27++){face=faces[_i27],this.vertices.push(vertices[face.a],vertices[face.b],vertices[face.c]);var vertexNormals=face.vertexNormals;if(3===vertexNormals.length)this.normals.push(vertexNormals[0],vertexNormals[1],vertexNormals[2]);else{var normal=face.normal;this.normals.push(normal,normal,normal)}var vertexColors=face.vertexColors;if(3===vertexColors.length)this.colors.push(vertexColors[0],vertexColors[1],vertexColors[2]);else{var color=face.color;this.colors.push(color,color,color)}if(!0===hasFaceVertexUv){var vertexUvs=faceVertexUvs[0][_i27];void 0===vertexUvs?(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv ",_i27),this.uvs.push(new three__WEBPACK_IMPORTED_MODULE_0__.Vector2,new three__WEBPACK_IMPORTED_MODULE_0__.Vector2,new three__WEBPACK_IMPORTED_MODULE_0__.Vector2)):this.uvs.push(vertexUvs[0],vertexUvs[1],vertexUvs[2])}if(!0===hasFaceVertexUv2){var _vertexUvs=faceVertexUvs[1][_i27];void 0===_vertexUvs?(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv2 ",_i27),this.uvs2.push(new three__WEBPACK_IMPORTED_MODULE_0__.Vector2,new three__WEBPACK_IMPORTED_MODULE_0__.Vector2,new three__WEBPACK_IMPORTED_MODULE_0__.Vector2)):this.uvs2.push(_vertexUvs[0],_vertexUvs[1],_vertexUvs[2])}// morphs
for(var morphTarget,j=0;j<morphTargetsLength;j++)morphTarget=morphTargets[j].vertices,morphTargetsPosition[j].data.push(morphTarget[face.a],morphTarget[face.b],morphTarget[face.c]);for(var morphNormal,_j7=0;_j7<morphNormalsLength;_j7++)morphNormal=morphNormals[_j7].vertexNormals[_i27],morphTargetsNormal[_j7].data.push(morphNormal.a,morphNormal.b,morphNormal.c);// skins
hasSkinIndices&&this.skinIndices.push(skinIndices[face.a],skinIndices[face.b],skinIndices[face.c]),hasSkinWeights&&this.skinWeights.push(skinWeights[face.a],skinWeights[face.b],skinWeights[face.c])}return this.computeGroups(geometry),this.verticesNeedUpdate=geometry.verticesNeedUpdate,this.normalsNeedUpdate=geometry.normalsNeedUpdate,this.colorsNeedUpdate=geometry.colorsNeedUpdate,this.uvsNeedUpdate=geometry.uvsNeedUpdate,this.groupsNeedUpdate=geometry.groupsNeedUpdate,null!==geometry.boundingSphere&&(this.boundingSphere=geometry.boundingSphere.clone()),null!==geometry.boundingBox&&(this.boundingBox=geometry.boundingBox.clone()),this}}class Face3{constructor(a,b,c,normal,color){var materialIndex=5<arguments.length&&arguments[5]!==void 0?arguments[5]:0;this.a=a,this.b=b,this.c=c,this.normal=normal&&normal.isVector3?normal:new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,this.vertexNormals=Array.isArray(normal)?normal:[],this.color=color&&color.isColor?color:new three__WEBPACK_IMPORTED_MODULE_0__.Color,this.vertexColors=Array.isArray(color)?color:[],this.materialIndex=materialIndex}clone(){return new this.constructor().copy(this)}copy(source){this.a=source.a,this.b=source.b,this.c=source.c,this.normal.copy(source.normal),this.color.copy(source.color),this.materialIndex=source.materialIndex;for(var i=0,il=source.vertexNormals.length;i<il;i++)this.vertexNormals[i]=source.vertexNormals[i].clone();for(var _i28=0,_il15=source.vertexColors.length;_i28<_il15;_i28++)this.vertexColors[_i28]=source.vertexColors[_i28].clone();return this}}

/***/ }),
/* 7 */
/***/ ((module) => {

"use strict";
module.exports = require("three-spritetext");

/***/ }),
/* 8 */
/***/ ((module) => {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAAZiS0dEAAAAAAAA+UO7fwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9sHDgwCEMBJZu0AAAAdaVRYdENvbW1lbnQAAAAAAENyZWF0ZWQgd2l0aCBHSU1QZC5lBwAABM5JREFUWMO1V0tPG2cUPZ4Hxh6DazIOrjFNqJs0FIMqWFgWQkatsmvVbtggKlSVRVf5AWz4AWz4AUSKEChll19QJYSXkECuhFxsHjEhxCYm+DWGMZ5HF72DJq4bAzFXurI0M/I5997v3u9cC65vTJVn2lX/xHINQOYSBLTLEuIuCWw4Z3IGAEvf6ASmVHjNzHCXBG4A0AjACsAOwEbO0nsFQBnAGYASAIl+ZRMR7SolMEdsByD09fV5R0ZGgg8ePPjW5/N1iqLYpuu6RZblciKR2I9Go69evnwZnZ+fjwI4IS8AKBIRzeQfJWCANwKwh0KhtrGxsYehUOin1tbW+zzP23ietzY2NnIAoGmaLsuyUiqVyvl8XtrY2NiamZn589mzZxsAUgCOAeQAnFI2tI+VxIjaAeDzoaGh7xYWFuZOTk6OZVk+12uYqqq6JEnn0Wg0OT4+/geAXwGEAdwDIFJQXC1wO4DWR48e/RCPxxclSSroVzRFUbSDg4P848ePFwH8DuAhkWih83TRQWxFOXgAwvDwcOfo6OhvXV1d39tsNtuVBwTDWBwOh1UUxVsMw1hXVlbSdCgNV43uYSvrHg6H24aHh38eHBz85TrgF9FYLHA4HLzH43FvbW2d7u/vG+dANp8FpqIlbd3d3V8Fg8EfBUFw4BONZVmL3+9vHhkZCQL4AoAHgJPK8G+yzC0XDofdoVAo5PP5vkadTBAEtr+/39ff3x8gAp/RPOEqx2qjx+NpvXv3bk9DQ0NDvQgwDIOWlhZrMBj8kgi0UJdxRgYMArzL5XJ7vd57qLPZ7Xamp6fnNgBXtQxcjFuHw+Hyer3t9SYgCAITCAScAJoBNNEY/08GOFVVrfVMv7kMNDntFD1vjIAPrlRN0xjckOm6biFQ3jwNPwDMZrOnqVTqfb3Bi8Wivru7W/VCYkwPlKOjo0IikXh7EwQikYgE4Nw0CfXKDCipVCoTj8df3QABbW1tLUc6oUgkFPMkVACUNjc337148eKvw8PDbJ2jP1taWkoCyNDVXDSECmNSK4qiKNLq6urW8+fPI/UicHx8rD59+jSVy+WOAKSJhKENwFItLtoxk8mwsixzHR0dHe3t7c5PAU+n09rs7OzJkydPYqVSaQfANoDXALIk31S2smU1TWMPDg7K5XKZ7+3t9TudTut1U7+wsFCcmJiIpdPpbQBxADsAknQWymYCOukBHYCuKApisdhpMpnURFEU79y503TVyKenpzOTk5M7e3t7MQKPV0Zv1gNm+awB0MvlshqLxfLb29uyJElWURSbXC4XXyvqxcXFs6mpqeTc3Nzu3t7e3wQcA7BPZ8Cov1pNlJplmQtAG8MwHV6v95tAINA5MDBwPxAIuLu6upr8fr/VAN3c3JQjkcjZ+vp6fnl5+d2bN29SuVzuNYAEpf01CdRChUL+X1VskHACuA3Ay3Fcu9vt7nA6nZ7m5uYWQRCaNE3jVVW15PP580KhIGUymWw2m00DOAJwSP4WwPtq4LX2Ao6USxNlQyS/RcQcdLGwlNIz6vEMAaZpNzCk2Pll94LK/cDYimxERiBwG10sxjgvEZBE0UpE6vxj+0Ct5bTaXthgEhRmja8QWNkkPGsuIpfdjpkK+cZUWTC0KredVmtD/gdlSl6EG4AMvQAAAABJRU5ErkJggg=="

/***/ }),
/* 9 */
/***/ ((__unused_webpack_module, exports) => {

/**
 * Provide additional shaders to render time dependent color.
 */exports.augmentMorphColor=function(){return function(shader){shader.vertexShader=shader.vertexShader.replace("#include <color_pars_vertex>",["varying vec3 vColor;","attribute vec3 morphColor0;","attribute vec3 morphColor1;"].join("\n")),shader.vertexShader=shader.vertexShader.replace("#include <color_vertex>",["vColor.xyz = color.xyz;","#ifdef USE_MORPHTARGETS","vColor = morphColor0 * morphTargetInfluences[ 0 ];","vColor += morphColor1 * morphTargetInfluences[ 1 ];","#endif"].join("\n"))}};

/***/ }),
/* 10 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),createBufferGeometry=(__webpack_require__(5).createBufferGeometry),resolveURL=(__webpack_require__(5).resolveURL),uniqueiId=0,getUniqueId=function(){return"pr"+uniqueiId++},ZincObject=function(){// THREE.Mesh
/**
	 * Groupname given to this geometry.
	 */ /**
	 * Total duration of the animation, this value interacts with the 
	 * {@link Renderer#playRate} to produce the actual duration of the
	 * animation. Actual time in second = duration / playRate.
	 */ //Draw range is only used by primitives added
//programatically with addVertices function
//Default value of colour
this.isZincObject=!0,this.geometry=void 0,this.morph=void 0,this.group=new THREE.Group,this._lod=new((__webpack_require__(11).LOD))(this),this.groupName=void 0,this.timeEnabled=!1,this.morphColour=!1,this.inbuildTime=0,this.mixer=void 0,this.animationGroup=void 0,this.duration=6e3,this.clipAction=void 0,this.userData={},this.videoHandler=void 0,this.marker=void 0,this.markerNumber=void 0,this.markerUpdateRequired=!0,this.closestVertexIndex=-1,this.boundingBoxUpdateRequired=!0,this.cachedBoundingBox=new THREE.Box3,this.anatomicalId=void 0,this.region=void 0,this.animationClip=void 0,this.markerMode="inherited",this.uuid=getUniqueId(),this._v1=new THREE.Vector3,this._v2=new THREE.Vector3,this._b1=new THREE.Box3,this.center=new THREE.Vector3,this.radius=0,this.visible=!0,this.drawRange=-1,this.origColour=void 0,this.origVertexColors=!1,this.isPickable=!0};/**
 * Provides the base object for other primitive types.
 * This class contains multiple base methods.
 * 
 * @class
 * @author Alan Wu
 * @return {ZincObject}
 */ /**
 * Set the duration of the animation of this object.
 * 
 * @param {Number} durationIn - Duration of the animation.
 */ /**
 * Get the duration of the animation of this object.
 * 
 * @return {Number}
 */ /**
 * Set the region this object belongs to.
 *
 * @param {Region} region
 */ /**
 * Get the region this object belongs to.
 * 
 * @return {Region}
 */ /**
 * Get the threejs object3D. 
 * 
 * @return {Object}
 */ /**
 * Get the threejs object3D. 
 * 
 * @return {Object}
 */ /**
 * Set the internal threejs object3D. 
 */ /**
 * Handle transparent mesh, create a clone for backside rendering if it is
 * transparent.
 */ /**
 * Set the mesh function for zincObject.
 * 
 * @param {THREE.Mesh} mesh - Mesh to be set for this zinc object.
 * @param {Boolean} localTimeEnabled - A flag to indicate either the mesh is
 * time dependent.
 * @param {Boolean} localMorphColour - A flag to indicate either the colour is
 * time dependent.
 */ /**
 * Set isPickable for this ZincObject.
 * 
 * @param {String} isPickable - Boolean to enable object pick.
 */ /**
 * Set the anatomicalId for this ZincObject.
 * 
 * @param {String} anatomicalId - Id to be set.
 */ /**
 * Set the name for this ZincObject.
 * 
 * @param {String} groupNameIn - Name to be set.
 */ /**
 * Get the local time of this geometry, it returns a value between 
 * 0 and the duration.
 * 
 * @return {Number}
 */ /**
 * Set the local time of this geometry.
 * 
 * @param {Number} time - Can be any value between 0 to duration.
 */ /**
 * Check if the geometry is time varying.
 * 
 * @return {Boolean}
 */ /**
 * Get the visibility of this Geometry.
 * 
 */ /**
 * Set the visibility of this Geometry.
 * 
 * @param {Boolean} visible - a boolean flag indicate the visibility to be set 
 */ /**
 * Set the opacity of this Geometry. This function will also set the isTransparent
 * flag according to the provided alpha value.
 * 
 * @param {Number} alpah - Alpha value to set for this geometry, 
 * can be any value between from 0 to 1.0.
 */ /**
 * The rendering will be culled if it is outside of the frustrum
 * when this flag is set to true, it should be set to false if
 * morphing is enabled.
 * 
 * @param {Boolean} flag - Set frustrum culling on/off based on this flag.
 */ /**
 * Set rather a zinc object should be displayed using per vertex colour or
 * not.
 * 
 * @param {Boolean} vertexColors - Set display with vertex color on/off.
 */ /**
 * Get the colour of the mesh.
 * 
 * @return {THREE.Color}
 */ /**
 * Set the colour of the mesh.
 * 
 * @param {THREE.Color} colour - Colour to be set for this geometry.
 */ /**
 * Set the colour of the mesh.
 * 
 * @param {THREE.Color} colour - Colour to be set for this geometry.
 */ /**
 * Get the colour of the mesh in hex string form.
 * 
 * @return {String}
 */ /**
 * Set the colour of the mesh using hex in string form.
 * 
 * @param {String} hex - The colour value in hex form.
 */ /**
 * Set the emissive rgb of the mesh using rgb.
 * 
 * @param {String} colour - The colour value in rgb form.
 */ /**
 * Set the material of the geometry.
 * 
 * @param {THREE.Material} material - Material to be set for this geometry.
 */ /**
 * Get the index of the closest vertex to centroid.
 * 
 * @return {Number} - integer index in the array
 */ /**
 * Get the  closest vertex to centroid.
 * 
 * @return {THREE.Vector3}
 */ /**
 * Get the bounding box of this geometry.
 * 
 * @return {THREE.Box3}.
 */ /**
 * Clear this geometry and free the memory.
 */ /**
 * Check if marker is enabled based on the objects settings with 
 * the provided scene options.
 * 
 * @return {Boolean} 
 */ /**
 * Update the marker's position and size based on current viewport. 
 */ /**
 * Get the windows coordinates.
 * 
 * @return {Object} - position and rather the closest vertex is on screen.
 */ /**
 * Set marker mode for this zinc object which determine rather the
 * markers should be displayed or not.
 *
 * @param {string} mode - There are three options:
 * "on" - marker is enabled regardless of settings of scene
 * "off" - marker is disabled regardless of settings of scene
 * "inherited" - Marker settings on scene will determine the visibility
 *  of the marker.
 * 
 * @return {Boolean} 
 */ //Update the geometry and colours depending on the morph.
/**
 * Add lod from an url into the lod object.
 */ /**
 * Add lod from an url into the lod object.
 */ /**
 * Set the objects position.
 */ /**
 * Set the objects scale.
 */ZincObject.prototype.setDuration=function(durationIn){this.duration=durationIn,this.clipAction&&this.clipAction.setDuration(this.duration)},ZincObject.prototype.getDuration=function(){return this.duration},ZincObject.prototype.setRegion=function(region){this.region=region},ZincObject.prototype.getRegion=function(){return this.region},ZincObject.prototype.getMorph=function(){var morph=this._lod.getCurrentMorph();return morph?morph:this.morph},ZincObject.prototype.getGroup=function(){return this.group},ZincObject.prototype.setMorph=function(mesh){this.morph=mesh,this.group.add(this.morph);//this is the base level object
var distance=this._lod.calculateDistance("far");this._lod.addLevel(mesh,distance),this._lod.setMaterial(mesh.material)},ZincObject.prototype.checkTransparentMesh=function(){},ZincObject.prototype.setMesh=function(mesh,localTimeEnabled,localMorphColour){this.animationGroup=new THREE.AnimationObjectGroup(mesh),this.mixer=new THREE.AnimationMixer(this.animationGroup);var geometry=mesh.geometry;if(this.geometry=mesh.geometry,this.clipAction=void 0,geometry&&geometry.morphAttributes){var morphAttribute=geometry.morphAttributes.position;morphAttribute||(morphAttribute=geometry.morphAttributes.color?geometry.morphAttributes.color:geometry.morphAttributes.normal),morphAttribute&&(this.animationClip=THREE.AnimationClip.CreateClipsFromMorphTargetSequences(morphAttribute,10,!0),this.animationClip&&null!=this.animationClip[0]&&(this.clipAction=this.mixer.clipAction(this.animationClip[0]).setDuration(this.duration),this.clipAction.loop=THREE.loopOnce,this.clipAction.clampWhenFinished=!0,this.clipAction.play()))}this.timeEnabled=localTimeEnabled,this.morphColour=localMorphColour,mesh.userData=this,mesh.matrixAutoUpdate=!1,this.setMorph(mesh),this.checkTransparentMesh(),this.timeEnabled?this.setFrustumCulled(!1):this.morphColour&&(geometry.setAttribute("morphTarget0",geometry.getAttribute("position")),geometry.setAttribute("morphTarget1",geometry.getAttribute("position"))),this.boundingBoxUpdateRequired=!0},ZincObject.prototype.setIsPickable=function(isPickable){this.isPickable!==isPickable&&(this.isPickable=isPickable,this.region&&(this.region.pickableUpdateRequired=!0))},ZincObject.prototype.setAnatomicalId=function(anatomicalId){this.anatomicalId=anatomicalId},ZincObject.prototype.setName=function(groupNameIn){this.groupName=groupNameIn,this._lod.setName(groupNameIn)},ZincObject.prototype.getCurrentTime=function(){if(this.clipAction){var ratio=this.clipAction.time/this.clipAction._clip.duration;return this.duration*ratio}return this.inbuildTime},ZincObject.prototype.setMorphTime=function(time){var timeChanged=!1;if(this.clipAction){var ratio=time/this.duration,actualDuration=this.clipAction._clip.duration,newTime=ratio*actualDuration;newTime!=this.clipAction.time&&(this.clipAction.time=newTime,timeChanged=!0),timeChanged&&this.isTimeVarying()&&this.mixer.update(0)}else{var _newTime=time;_newTime=time>this.duration?this.duration:0>time?0:time,_newTime!=this.inbuildTime&&(this.inbuildTime=_newTime,timeChanged=!0)}timeChanged&&(this.boundingBoxUpdateRequired=!0,this._lod.updateMorphColorAttribute(!0),this.timeEnabled&&(this.markerUpdateRequired=!0))},ZincObject.prototype.isTimeVarying=function(){return!!(this.timeEnabled||this.morphColour)},ZincObject.prototype.getVisibility=function(){return this.visible},ZincObject.prototype.setVisibility=function(visible){visible!==this.visible&&(this.visible=visible,this.group.visible=visible,this.region&&(this.region.pickableUpdateRequired=!0))},ZincObject.prototype.setAlpha=function(alpha){var material=this._lod._material,isTransparent=!1;1>alpha&&(isTransparent=!0),material.opacity=alpha,material.transparent=isTransparent,this.checkTransparentMesh()},ZincObject.prototype.setFrustumCulled=function(flag){//multilayers - set for all layers
this._lod.setFrustumCulled(flag)},ZincObject.prototype.setVertexColors=function(vertexColors){//multilayers - set for all
this._lod.setVertexColors(vertexColors)},ZincObject.prototype.getColour=function(){return this._lod._material?this._lod._material.color:void 0},ZincObject.prototype.setColour=function(colour){this._lod.setColour(colour)},ZincObject.prototype.setGreyScale=function(flag){if(flag){if(!this.origColour&&this._lod._material)return this.origColour=this._lod._material.color,this.origVertexColors=this._lod._material.vertexColors,this._lod.setVertexColors(!1),this._lod.setColour(new THREE.Color().setHex(12303291)),!0;}else if(this.origColour)return this._lod.setColour(this.origColour),this._lod.setVertexColors(this.origVertexColors),this.origColour=void 0,!0;return!1},ZincObject.prototype.getColourHex=function(){return!this.morphColour&&this._lod._material&&this._lod._material.color?this._lod._material.color.getHexString():void 0},ZincObject.prototype.setColourHex=function(hex){this._lod._material.color.setHex(hex),this._lod._secondaryMaterial&&this._lod._secondaryMaterial.color.setHex(hex)},ZincObject.prototype.setEmissiveRGB=function(colour){this._lod._material&&this._lod._material.emissive&&this._lod._material.emissive.setRGB(...colour),this._lod._secondaryMaterial&&this._lod._secondaryMaterial.emissive.setRGB(...colour)},ZincObject.prototype.setMaterial=function(material){this._lod.setMaterial(material)},ZincObject.prototype.getClosestVertexIndex=function(){var closestIndex=-1,morph=this.getMorph();if(morph&&morph.geoemtry){var position=morph.geometry.attributes.position;if(this._b1.setFromBufferAttribute(position),this._b1.getCenter(this._v1),position)for(var distance=-1,currentDistance=0,i=0;i<position.count;i++)this._v2.fromArray(position.array,3*i),currentDistance=this._v2.distanceTo(this._v1),-1==distance?distance=currentDistance:distance>currentDistance&&(distance=currentDistance,closestIndex=i)}return closestIndex},ZincObject.prototype.getClosestVertex=function(applyMatrixWorld){var position=new THREE.Vector3;-1==this.closestVertexIndex&&(this.closestVertexIndex=this.getClosestVertexIndex());var morph=this.getMorph();if(morph&&morph.geometry&&0<=this.closestVertexIndex){var influences=morph.morphTargetInfluences,attributes=morph.geometry.morphAttributes;if(influences&&attributes&&attributes.position){for(var found=!1,i=0;i<influences.length;i++)0<influences[i]&&(found=!0,this._v1.fromArray(attributes.position[i].array,3*this.closestVertexIndex),position.add(this._v1.multiplyScalar(influences[i])));if(found)return applyMatrixWorld?position.applyMatrix4(morph.matrixWorld):position}else return position.fromArray(morph.geometry.attributes.position.array,3*this.closestVertexIndex),applyMatrixWorld?position.applyMatrix4(morph.matrixWorld):position}return this.getBoundingBox(),position.copy(this.center),applyMatrixWorld?position.applyMatrix4(this.morph.matrixWorld):position},ZincObject.prototype.getBoundingBox=function(){if(this.visible){var morph=this._lod.getCurrentMorph();if(morph&&morph.visible)return this.boundingBoxUpdateRequired&&((__webpack_require__(5).getBoundingBox)(morph,this.cachedBoundingBox,this._b1,this._v1,this._v2),this.cachedBoundingBox.getCenter(this.center),this.radius=this.center.distanceTo(this.cachedBoundingBox.max),this.boundingBoxUpdateRequired=!1),this.cachedBoundingBox}},ZincObject.prototype.dispose=function(){//multilayyers
this._lod.dispose(),this.animationGroup=void 0,this.mixer=void 0,this.morph=void 0,this.group=void 0,this.clipAction=void 0,this.groupName=void 0},ZincObject.prototype.markerIsRequired=function(options){return!!(this.visible&&("on"===this.markerMode||options&&options.displayMarkers&&"inherited"===this.markerMode))},ZincObject.prototype.updateMarker=function(playAnimation,options){if(!1==playAnimation&&this.markerIsRequired(options)){var ndcToBeUpdated=options.ndcToBeUpdated;if(this.groupName){if(this.marker||(this.marker=new((__webpack_require__(14).Marker))(this),this.markerUpdateRequired=!0),this.markerUpdateRequired){var position=this.getClosestVertex(!1);position&&(this.marker.setPosition(position.x,position.y,position.z),this.markerUpdateRequired=!1)}this.marker.isEnabled()||(options.markersList&&!(this.marker.uuid in options.markersList)&&(ndcToBeUpdated=!0,options.markersList[this.marker.uuid]=this.marker),this.marker.enable(),this.group.add(this.marker.morph)),this.marker.setNumber(this.markerNumber),this.markerImgURL?this.marker.loadUserSprite(this.markerImgURL):this.marker.setDefaultSprite(),options&&options.camera&&(ndcToBeUpdated||options.markerCluster.markerUpdateRequired)&&(this.marker.updateNDC(options.camera.cameraObject),options.markerCluster.markerUpdateRequired=!0)}}else this.marker&&this.marker.isEnabled()&&(this.marker.disable(),this.group.remove(this.marker.morph),options.markersList&&this.marker.uuid in options.markersList&&(options.markerCluster.markerUpdateRequired=!0,delete options.markersList[this.marker.uuid])),this.markerUpdateRequired=!0},ZincObject.prototype.processMarkerVisual=function(min,max){this.marker&&this.marker.isEnabled()&&this.marker.updateVisual(min,max)},ZincObject.prototype.initiateMorphColor=function(){1==this.morphColour&&this._lod.updateMorphColorAttribute(!1)},ZincObject.prototype.setRenderOrder=function(renderOrder){//multiilayers
this._lod.setRenderOrder(renderOrder)},ZincObject.prototype.getClosestVertexDOMElementCoords=function(scene){if(scene&&scene.camera){var inView=!0,position=this.getClosestVertex(!0);return position.project(scene.camera),position.z=Math.min(Math.max(position.z,0),1),(1<position.x||-1>position.x||1<position.y||-1>position.y)&&(inView=!1),scene.getZincCameraControls().getRelativeCoordsFromNDC(position.x,position.y,position),{position,inView}}},ZincObject.prototype.setMarkerMode=function(mode,options){mode!==this.markerMode&&(this.markerMode="on"===mode||"off"===mode?mode:"inherited",this.region&&(this.region.pickableUpdateRequired=!0)),options&&(this.markerNumber=options.number,this.markerImgURL=options.imgURL)},ZincObject.prototype.render=function(delta,playAnimation,cameraControls,options){if(this.visible&&!(this.timeEnabled&&playAnimation)&&this._lod.update(cameraControls,this.center),!0==playAnimation){if(this.clipAction&&this.isTimeVarying())this.mixer.update(delta);else{var targetTime=this.inbuildTime+delta;targetTime>this.duration&&(targetTime-=this.duration),this.inbuildTime=targetTime}//multilayers
this.visible&&0!=delta&&(this.boundingBoxUpdateRequired=!0,1==this.morphColour&&this._lod.updateMorphColorAttribute(!0))}this.updateMarker(playAnimation,options)},ZincObject.prototype.addLOD=function(loader,level,url,index,preload){this._lod.addLevelFromURL(loader,level,url,index,preload)},ZincObject.prototype.addVertices=function(coords){var mesh=this.getMorph(),geometry=void 0;if(!mesh)geometry=createBufferGeometry(500,coords),this.drawRange=coords.length;else if(-1<this.drawRange){var positionAttribute=mesh.geometry.getAttribute("position");coords.forEach(coord=>{positionAttribute.setXYZ(this.drawRange,coord[0],coord[1],coord[2]),++this.drawRange}),positionAttribute.needsUpdate=!0,mesh.geometry.setDrawRange(0,this.drawRange),mesh.geometry.computeBoundingBox(),mesh.geometry.computeBoundingSphere(),geometry=mesh.geoemtry,this.boundingBoxUpdateRequired=!0}return geometry},ZincObject.prototype.setPosition=function(x,y,z){var group=this.getGroup();group&&(group.position.set(x,y,z),group.updateMatrix(),this.boundingBoxUpdateRequired=!0)},ZincObject.prototype.loadAdditionalSources=function(primitivesLoader){primitivesLoader.load(resolveURL(filename),meshloader(region,colour,opacity,localTimeEnabled,localMorphColour,void 0,void 0,void 0,void 0,finishCallback),this.onProgress(filename),this.onError(finishCallback))},ZincObject.prototype.setScaleAll=function(scale){var group=this.getGroup();group&&(group.scale.set(scale,scale,scale),group.updateMatrix(),this.boundingBoxUpdateRequired=!0)},exports.ZincObject=ZincObject;

/***/ }),
/* 11 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),updateMorphColorAttribute=(__webpack_require__(5).updateMorphColorAttribute),toBufferGeometry=(__webpack_require__(5).toBufferGeometry),LOD=function(parent){this.levels=[],this._currentLevel=0,this._renderOrder=1,this._material=void 0,this._secondaryMaterial=void 0,this._loader=void 0,this._parent=parent,this.addLevel=(object,distanceIn)=>{if(object){var l,distance=Math.abs(distanceIn);for(l=0;l<this.levels.length&&!(distance<this.levels[l].distance);l++);this.levels.splice(l,0,{distance:distance,morph:object,loaded:!0,loading:!1,url:""}),object.renderOrder=this._renderOrder}},this.levelLoaded=(object,distanceIn)=>{if(object){for(var distance=Math.abs(distanceIn),l=0;l<this.levels.length;l++)if(distance===this.levels[l].distance){this._parent.group.add(object),this.levels[l].morph=object,this.levels[l].loaded=!0,this.levels[l].loading=!1;break}this.checkTransparentMesh()}},this.addLevelFromURL=(loader,level,url,index,preload)=>{this._loader=loader;var l,distance=this.calculateDistance(level);for(l=0;l<this.levels.length&&!(distance<this.levels[l].distance);l++);this.levels.splice(l,0,{distance:distance,morph:void 0,loaded:!1,loading:!1,url:url,index:index}),preload&&this.loadLevel(l)},this.loadLevel=index=>{var level=this.levels[index];return level.morph||level.loaded||level.loading||(level.loading=!0,this._loader.load(level.url,this.lodLoader(level.distance),void 0,void 0,{index:level.index})),void 0===level.morph},this.calculateDistance=function(level){this._parent.getBoundingBox();var radius=this._parent.radius,distance=0;return"far"===level?distance=4.5*radius:"medium"===level?distance=2.5*radius:"close"==level&&(distance=0),distance},this.containsLevels=()=>!!(this.levels&&1<this.levels.length),this.checkTransparentMesh=()=>{var level=this.levels[this._currentLevel];this._material&&(this._material.transparent?(!this._secondaryMaterial&&(this._secondaryMaterial=this._material.clone(),this._secondaryMaterial.side=THREE.FrontSide),this._secondaryMaterial.opacity=this._material.opacity,this._secondaryMaterial.emissive&&this._secondaryMaterial.emissive.copy(this._material.emissive),this._secondaryMaterial.needsUpdate=!0,!level.secondaryMesh&&(level.secondaryMesh=new THREE.Mesh(level.morph.geometry,this._secondaryMaterial),level.secondaryMesh.renderOrder=level.morph.renderOrder+1,level.secondaryMesh.userData=level.morph.userData,level.secondaryMesh.name=level.morph.name),this._material.side=THREE.BackSide,this._material.needsUpdate=!0,!level.secondaryMesh.parent&&(level.morph.add(level.secondaryMesh),this._parent.animationGroup&&this._parent.animationGroup.add(level.secondaryMesh))):(level.secondaryMesh&&(level.morph.remove(level.secondaryMesh),this._parent.animationGroup&&(this._parent.animationGroup.uncache(level.secondaryMesh),this._parent.animationGroup.remove(level.secondaryMesh))),this._material.side=THREE.DoubleSide,this._material.needsUpdate=!0))},this.dispose=()=>{this.levels.forEach(level=>{level.morph&&level.morph.geometry&&level.morph.geometry.dispose()}),this._material&&this._material.dispose(),this._secondaryMaterial&&this._secondaryMaterial.dispose()},this.getCurrentLevel=()=>this._currentLevel,this.getCurrentMorph=()=>{var level=this.levels[this._currentLevel];return level&&level.morph?level.morph:this._parent.morph},this.lodLoader=function(distance){return geometryIn=>{var material=this._material,options={localTimeEnabled:this._parent.timeEnabled,localMorphColour:this._parent.morphColour},geometry=toBufferGeometry(geometryIn,options),mesh=void 0;this._parent.isGeometry?mesh=new THREE.Mesh(geometry,material):this._parent.isLines&&(mesh=new((__webpack_require__(12).LineSegments))(geometry,material)),mesh.userData=this._parent,mesh.renderOrder=this._renderOrder,geometryIn.dispose(),this.levelLoaded(mesh,distance)}},this.updateMorphColorAttribute=currentOnly=>{//Multilayers - set all
if(this._material&&(this._material.vertexColors==THREE.VertexColors||!0==this._material.vertexColors))if(currentOnly){var morph=this.getCurrentMorph();updateMorphColorAttribute(morph.geometry,morph)}else this.levels.forEach(level=>{level.morph&&level.morph.geometry&&updateMorphColorAttribute(level.morph.geometry,level.morph)})},this.setColour=colour=>{this._material.color=colour,this._secondaryMaterial&&(this._secondaryMaterial.color=colour),updateGeometryColour()},this.setFrustumCulled=flag=>{this.levels.forEach(level=>{level.morph&&(level.morph.frustumCulled=flag),level.secondaryMesh&&(level.secondaryMesh.frustumCulled=flag)})},this.setMaterial=material=>{material&&(!this._material||this._material.id!==material.id)&&(this._material=material,this._secondaryMaterial&&this._secondaryMaterial.dispose(),this._secondaryMaterial=material.clone(),this._secondaryMaterial.side=THREE.FrontSide,this._secondaryMaterial.transparent=!0,this.levels.forEach(level=>{level.morph&&(level.morph.material=this._material,level.morph.geometry&&(level.morph.geometry.colorsNeedUpdate=!0)),level.secondaryMesh&&(level.secondaryMesh.material=this._secondaryMaterial)}))},this.setName=name=>{this.levels.forEach(level=>{level.morph&&(level.morph.name=name),level.secondaryMesh&&(level.secondaryMesh.name=name)})},this.setRenderOrder=order=>{this._renderOrder=order,this.levels.forEach(level=>{level.morph&&(level.morph.renderOrder=order),level.secondaryMesh&&(level.secondaryMesh.renderOrder=order)})},this.setVertexColors=vertexColors=>{this._material.vertexColors=vertexColors,updateGeometryColour(),this._secondaryMaterial&&(this._secondaryMaterial.vertexColors=vertexColors)},this.update=(camera,center)=>{var levels=this.levels;if(1<levels.length){var i,l,distance=camera.cameraObject.position.distanceTo(center),visibleIndex=-1,optimalIndex=-1;//Found a visible index that is within range of the LOD
for(i=0,l=levels.length;i<l&&distance>=levels[i].distance;i++)levels[i].morph?(-1<visibleIndex&&levels[visibleIndex].morph&&(levels[visibleIndex].morph.visible=!1),visibleIndex=i,levels[i].morph.visible=!0,optimalIndex=-1):optimalIndex=i;for(-1<optimalIndex&&this.loadLevel(optimalIndex);i<l;i++)levels[i].morph&&(-1<visibleIndex?levels[i].morph.visible=!1:(levels[i].morph.visible=!0,visibleIndex=i));this._currentLevel!=visibleIndex&&(this._currentLevel=visibleIndex,this.checkTransparentMesh())}},this.toggleMarker=(marker,flag)=>{this.levels.forEach(level=>{level.morph&&(flag?level.morph.add(marker):level.morph.remove(marker))})};var updateGeometryColour=()=>{this.levels.forEach(level=>{level.morph&&level.morph.geometry&&(level.morph.geometry.colorsNeedUpdate=!0)})}};/**
 * Provides an object which stores meshes at different levels based
 * on specified distance.
 * This object is ued by zincObject to provide mesh at different LODs.
 * A layer is displayed when the distance from the camera is greater 
 * than its specified distance and closest compared to other layers.
 * This is intended to be an internal object used only by Zinc Object.
 * 
 * This object assumes the centroid and bounding box are consistent between
 * different level of layers.
 * 
 * @class
 * @author Alan Wu
 * @return {LOD}
 */exports.LOD=LOD;

/***/ }),
/* 12 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LineSegments: () => (/* binding */ LineSegments)
/* harmony export */ });
/* harmony import */ var _Line_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(three__WEBPACK_IMPORTED_MODULE_1__);
var _start=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_1__.Vector3,_end=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_1__.Vector3;class LineSegments extends _Line_js__WEBPACK_IMPORTED_MODULE_0__.Line{constructor(geometry,material){super(geometry,material),this.type="LineSegments"}computeLineDistances(){var geometry=this.geometry;if(!geometry.isBufferGeometry)geometry.isGeometry&&console.error("THREE.LineSegments.computeLineDistances() no longer supports THREE.Geometry. Use THREE.BufferGeometry instead.");else// we assume non-indexed geometry
if(null===geometry.index){for(var positionAttribute=geometry.attributes.position,lineDistances=[],i=0,l=positionAttribute.count;i<l;i+=2)_start.fromBufferAttribute(positionAttribute,i),_end.fromBufferAttribute(positionAttribute,i+1),lineDistances[i]=0==i?0:lineDistances[i-1],lineDistances[i+1]=lineDistances[i]+_start.distanceTo(_end);geometry.setAttribute("lineDistance",new three__WEBPACK_IMPORTED_MODULE_1__.Float32BufferAttribute(lineDistances,1))}else console.warn("THREE.LineSegments.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");return this}}LineSegments.prototype.isLineSegments=!0;

/***/ }),
/* 13 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Line: () => (/* binding */ Line)
/* harmony export */ });
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(three__WEBPACK_IMPORTED_MODULE_0__);
var _start=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_end=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_inverseMatrix=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Matrix4,_ray=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Ray,_sphere=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Sphere,_morphA=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_morphB=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_tempA=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_tempB=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Vector3;class Line extends three__WEBPACK_IMPORTED_MODULE_0__.Object3D{constructor(){var geometry=0<arguments.length&&arguments[0]!==void 0?arguments[0]:new three__WEBPACK_IMPORTED_MODULE_0__.BufferGeometry,material=1<arguments.length&&arguments[1]!==void 0?arguments[1]:new three__WEBPACK_IMPORTED_MODULE_0__.LineBasicMaterial;super(),this.type="Line",this.geometry=geometry,this.material=material,this.updateMorphTargets()}copy(source){return super.copy(source),this.material=source.material,this.geometry=source.geometry,this}computeLineDistances(){var geometry=this.geometry;if(!geometry.isBufferGeometry)geometry.isGeometry&&console.error("THREE.Line.computeLineDistances() no longer supports THREE.Geometry. Use THREE.BufferGeometry instead.");else// we assume non-indexed geometry
if(null===geometry.index){for(var positionAttribute=geometry.attributes.position,lineDistances=[0],i=1,l=positionAttribute.count;i<l;i++)_start.fromBufferAttribute(positionAttribute,i-1),_end.fromBufferAttribute(positionAttribute,i),lineDistances[i]=lineDistances[i-1],lineDistances[i]+=_start.distanceTo(_end);geometry.setAttribute("lineDistance",new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(lineDistances,1))}else console.warn("THREE.Line.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");return this}raycast(raycaster,intersects){var geometry=this.geometry,matrixWorld=this.matrixWorld,threshold=raycaster.params.Line.threshold,drawRange=geometry.drawRange,morphPosition=geometry.morphAttributes.position;// Checking boundingSphere distance to ray
if(null===geometry.boundingSphere&&geometry.computeBoundingSphere(),_sphere.copy(geometry.boundingSphere),_sphere.applyMatrix4(matrixWorld),_sphere.radius+=threshold,!1!==raycaster.ray.intersectsSphere(_sphere)){_inverseMatrix.copy(matrixWorld).invert(),_ray.copy(raycaster.ray).applyMatrix4(_inverseMatrix);var localThreshold=threshold/((this.scale.x+this.scale.y+this.scale.z)/3),localThresholdSq=localThreshold*localThreshold,vStart=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,vEnd=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,interSegment=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,interRay=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,step=this.isLineSegments?2:1;if(geometry.isBufferGeometry){var index=geometry.index,attributes=geometry.attributes,positionAttribute=attributes.position;if(null!==index)for(var start=Math.max(0,drawRange.start),end=Math.min(index.count,drawRange.start+drawRange.count),i=start;i<end-1;i+=step){var a=index.getX(i),b=index.getX(i+1);calculatePosition(vStart,vEnd,this,positionAttribute,morphPosition,a,b);var distSq=_ray.distanceSqToSegment(vStart,vEnd,interRay,interSegment);if(!(distSq>localThresholdSq)){interRay.applyMatrix4(this.matrixWorld);//Move back to world space for distance calculation
var distance=raycaster.ray.origin.distanceTo(interRay);distance<raycaster.near||distance>raycaster.far||intersects.push({distance:distance,// What do we want? intersection point on the ray or on the segment??
// point: raycaster.ray.at( distance ),
point:interSegment.clone().applyMatrix4(this.matrixWorld),index:i,face:null,faceIndex:null,object:this})}}else for(var _start2=Math.max(0,drawRange.start),_end2=Math.min(positionAttribute.count,drawRange.start+drawRange.count),_i=_start2;_i<_end2-1;_i+=step){calculatePosition(vStart,vEnd,this,positionAttribute,morphPosition,_i,_i+1);var _distSq=_ray.distanceSqToSegment(vStart,vEnd,interRay,interSegment);if(!(_distSq>localThresholdSq)){interRay.applyMatrix4(this.matrixWorld);//Move back to world space for distance calculation
var _distance=raycaster.ray.origin.distanceTo(interRay);_distance<raycaster.near||_distance>raycaster.far||intersects.push({distance:_distance,// What do we want? intersection point on the ray or on the segment??
// point: raycaster.ray.at( distance ),
point:interSegment.clone().applyMatrix4(this.matrixWorld),index:_i,face:null,faceIndex:null,object:this})}}}else geometry.isGeometry&&console.error("THREE.Line.raycast() no longer supports THREE.Geometry. Use THREE.BufferGeometry instead.")}//
}updateMorphTargets(){var geometry=this.geometry;if(geometry.isBufferGeometry){var morphAttributes=geometry.morphAttributes,keys=Object.keys(morphAttributes);if(0<keys.length){var morphAttribute=morphAttributes[keys[0]];if(morphAttribute!==void 0){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(var name,m=0,ml=morphAttribute.length;m<ml;m++)name=morphAttribute[m].name||m+"",this.morphTargetInfluences.push(0),this.morphTargetDictionary[name]=m}}}else{var morphTargets=geometry.morphTargets;morphTargets!==void 0&&0<morphTargets.length&&console.error("THREE.Line.updateMorphTargets() does not support THREE.Geometry. Use THREE.BufferGeometry instead.")}}}function calculatePosition(vStart,vEnd,object,position,morphPosition,a,b){vStart.fromBufferAttribute(position,a),vEnd.fromBufferAttribute(position,b);var morphInfluences=object.morphTargetInfluences;if(object.material.morphTargets&&morphPosition&&morphInfluences){_morphA.set(0,0,0),_morphB.set(0,0,0);for(var i=0,il=morphPosition.length;i<il;i++){var influence=morphInfluences[i],morphAttribute=morphPosition[i];0!==influence&&(_tempA.fromBufferAttribute(morphAttribute,a),_tempB.fromBufferAttribute(morphAttribute,b),_morphA.addScaledVector(_tempA.sub(vStart),influence),_morphB.addScaledVector(_tempB.sub(vEnd),influence))}vStart.add(_morphA),vEnd.add(_morphB)}}Line.prototype.isLine=!0;

/***/ }),
/* 14 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),markerImage=new Image(128,128);markerImage.src=__webpack_require__(15);var texture=new THREE.Texture;texture.image=markerImage,texture.needsUpdate=!0;var size=[.02,.03,1],spriteMaterial=new THREE.SpriteMaterial({map:texture,alphaTest:.5,transparent:!0,depthTest:!1,depthWrite:!1,sizeAttenuation:!1}),createNewSpriteText=(__webpack_require__(5).createNewSpriteText),Marker=function(zincObject){(__webpack_require__(10).ZincObject).call(this),this.texture=texture;var sprite=void 0,userTexture=void 0,userMaterial=void 0,userSprite=void 0,userUrl=void 0,defaultDisplay=!0;this.morph=new THREE.Group,this.group=this.morph,this.parent=zincObject,this.isMarker=!0;var enabled=!1;this.ndc=new THREE.Vector3;var number=void 0,label=void 0,initialise=()=>{sprite=new THREE.Sprite(spriteMaterial),sprite.center.set(.5,0),this.morph.add(sprite),this.morph.position.set(0,0,0),this.morph.renderOrder=1e4,sprite.scale.set(size[0],size[1],size[2]),sprite.userData=this};/**
   * Set the position of the marker.
   * 
   * @param {Number} x - x coordinate to be set.
   * @param {Number} y - y coordinate to be set.
   * @param {Number} z - z coordinate to be set.
   */ /**
   * Set the size of the marker.
   * 
   * @param {Number} size - size to be set.
   */ /**
   * Clean up this object,
   */ /**
   * Set the visibility of this Geometry.
   * 
   * @param {Boolean} visible - a boolean flag indicate the visibility to be set 
   */ /**
   * Enable and visualise the marker.
   */ /**
   * Disable and hide the marker.
   */this.updateVisual=(min,max)=>{var scale=1,porportion=0;min!==max&&(porportion=1-(this.ndc.z-min)/(max-min),scale=.6+.4*porportion),this.setSpriteSize(scale)},this.updateNDC=camera=>(this.ndc.copy(this.morph.position),this.ndc.project(camera),this.ndc.z=Math.min(Math.max(this.ndc.z,0),1),this.ndc),this.setPosition=(x,y,z)=>{this.morph.position.set(x,y,z)},this.setSpriteSize=size=>{sprite.scale.set(.015,.02,1),sprite.scale.multiplyScalar(size)},this.setUserSprite=()=>{userSprite&&(this.morph.add(userSprite),defaultDisplay&&(this.morph.remove(sprite),label&&this.morph.remove(label),defaultDisplay=!1))},this.setImageForUserSprite=(image,size)=>{userSprite&&(this.morph.remove(userSprite),userSprite=void 0),userTexture&&userTexture.dispose(),userMaterial&&userMaterial.dispose(),userTexture=new THREE.Texture,userTexture.image=image,userTexture.needsUpdate=!0,userMaterial=new THREE.SpriteMaterial({map:userTexture,alphaTest:.5,transparent:!0,depthTest:!1,depthWrite:!1,sizeAttenuation:!1}),size||(size=[.05,.05,1]),userSprite=new THREE.Sprite(userMaterial),userSprite.center.set(.5,0),userSprite.scale.set(size[0],size[1],size[2]),userSprite.userData=this,this.setUserSprite()},this.setDefaultSprite=()=>{defaultDisplay||(defaultDisplay=!0,this.morph.add(sprite),userSprite&&this.morph.remove(userSprite),label&&this.morph.add(label))},this.loadUserSprite=(url,size)=>{if(url)if(url!==userUrl){userUrl=url;var userImage=new Image(128,128);userImage.crossOrigin="anonymous",userImage.onload=()=>{this.setImageForUserSprite(userImage,size)},userImage.src=url}else this.setUserSprite()},this.dispose=()=>{this.morph&&this.morph.clear(),sprite&&(sprite.clear(),sprite=void 0),label&&(label.material.map.dispose(),label.material.dispose(),label=void 0)},this.isEnabled=()=>enabled,this.setNumber=numberIn=>{(!numberIn||number!=numberIn)&&label&&(this.morph.remove(label),label.material.map.dispose(),label.material.dispose(),label=void 0),!label&&numberIn&&(label=createNewSpriteText(numberIn,.012,"black","Asap",120,700),this.morph.add(label)),number=numberIn},this.getNumber=()=>number?number:1,this.setVisibility=function(visible){visible!==this.visible&&(this.visible=visible,this.group.visible=visible,this.parent.region&&(this.parent.region.pickableUpdateRequired=!0))},this.enable=()=>{enabled=!0,this.morph.visible=!0,this.visible=!0},this.disable=()=>{enabled=!1,this.morph.visible=!1,this.visible=!1},initialise()};/**
 * A special graphics type with a tear drop shape.
 * It is currently used to mark the location of a
 * {@link zincObject}.
 * 
 * @class
 * @author Alan Wu
 * @return {Marker}
 */Marker.prototype=Object.create((__webpack_require__(10).ZincObject).prototype),exports.Marker=Marker;

/***/ }),
/* 15 */
/***/ ((module) => {

module.exports = "data:image/svg+xml;base64,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"

/***/ }),
/* 16 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),Glyph=function(geometry,materialIn,idIn,glyphsetIn){(__webpack_require__(10).ZincObject).call(this);var material;materialIn&&(material=materialIn.clone(),material.vertexColors=THREE.FaceColors);this.id=idIn;var label=void 0,labelString=void 0;this.isGlyph=!0;var _position=[0,0,0];/**
   * Create a glyph using mesh
   * @param   {THREE.Mesh} meshIn - Mesh to create the glyph from
   *
   * @returns {Boolean} true if successful
   */ /**
   * Get the {Glyphset} containing this glyph.
   *
   * @returns {Boolean} true if successful
   */ /**
   * Set and update the text containing this glyph.
   * @param   {String} text - Label to be set for this instance
   */ /**
   * Display label with the choosen colour. It will replace the current
   * label.
   * @param   {THREE.Color} colour - Colour for the label.
   */ /**
   * Hide label with the choosen colour.
   */ /**
   * Get the label of this glyph
   * @return {Label}
   */ /**
   * Get the mesh of this glyph.
   * @return {THREE.Mesh}
   */ /**
   * Set the transformation of this glyph.
   * @param {Array} position - Three components vectors containing position of the
   * transformation.
   * @param {Array} axis1 - Three components vectors containing axis1 rotation of the
   * transformation.
   * @param {Array} axis2 - Three components vectors containing axis2 rotation of the
   * transformation.
   * @param {Array} position - Three components vectors containing axis3 rotation of the
   * transformation.
   */ /**
   * Set the color of the glyph and its label.
   * 
   * @param {THREE.Color} color - Colour to be set.
   */ /**
   * Clear and free its memory.
   */this.fromMesh=meshIn=>!!(meshIn&&meshIn.isMesh)&&(this.morph=meshIn.clone(),this.morph.userData=this,this.group.add(this.morph),!0),geometry&&material&&this.fromMesh(new THREE.Mesh(geometry,material)),this.getGlyphset=function(){return glyphsetIn},this.setLabel=text=>{text&&("string"==typeof text||text instanceof String)&&(labelString=text,this.morph&&(this.morph.name=text))},this.showLabel=colour=>{label&&(_position=label.getPosition(),this.group.remove(label.getSprite()),label.dispose(),label=void 0),labelString&&("string"==typeof labelString||labelString instanceof String)&&(label=new((__webpack_require__(17).Label))(labelString,colour),label.setPosition(_position[0],_position[1],_position[2]),this.group.add(label.getSprite()))},this.hideLabel=()=>{label&&(_position=label.getPosition(),this.group.remove(label.getSprite()),label.dispose(),label=void 0)},this.getLabel=()=>labelString,this.getMesh=()=>this.morph,this.setTransformation=(position,axis1,axis2,axis3)=>{this.morph&&(this.morph.matrix.elements[0]=axis1[0],this.morph.matrix.elements[1]=axis1[1],this.morph.matrix.elements[2]=axis1[2],this.morph.matrix.elements[3]=0,this.morph.matrix.elements[4]=axis2[0],this.morph.matrix.elements[5]=axis2[1],this.morph.matrix.elements[6]=axis2[2],this.morph.matrix.elements[7]=0,this.morph.matrix.elements[8]=axis3[0],this.morph.matrix.elements[9]=axis3[1],this.morph.matrix.elements[10]=axis3[2],this.morph.matrix.elements[11]=0,this.morph.matrix.elements[12]=position[0],this.morph.matrix.elements[13]=position[1],this.morph.matrix.elements[14]=position[2],this.morph.matrix.elements[15]=1,this.morph.matrixAutoUpdate=!1),_position=[...position],label&&label.setPosition(position[0],position[1],position[2])},this.setColour=color=>{label&&label.setColour(color),this.secondaryMesh&&this.secondaryMesh.material&&(this.secondaryMesh.material.color=colour),this.geometry&&(this.geometry.colorsNeedUpdate=!0)},this.dispose=()=>{this.material&&this.material.dispose(),this.morph=void 0}};/**
 * Zinc representation of glyph graphic, it contains the colours, 
 * geometry and transformation of the glyph.
 * 
 * @param {THREE.Geometry} geometry - Geometry of the glyph .
 * @param {THREE.Material} materialIn - Material of the glyph.
 * @param {Number} idIn - Id of the glyph.
 * 
 * @class
 * @author Alan Wu
 * @return {Glyph}
 */Glyph.prototype=Object.create((__webpack_require__(10).ZincObject).prototype),exports.Glyph=Glyph;

/***/ }),
/* 17 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var SpriteText=(__webpack_require__(7)["default"]);/**
 * Bitmap labels, this is used with {@link Glyph} to
 * provide labels.
 *
 * @param {String} textIn - Text to be displayed dwith the label.
 * @param {THREE.Color} colour - Colour to be set for the label.
 *
 * @class
 * @author Alan Wu
 * @return {Label}
 */exports.Label=function(textIn,colour){var text=textIn,sprite=void 0;/**
   * Get the current position in an array containing the x, y and z
   * coordinates.
   *
   * @return {Array}
   */ /**
   * Set the position of the label in  3D coordinates.
   *
   * @param {Number} x - x coordinate to be set.
   * @param {Number} y - y coordinate to be set.
   * @param {Number} z - z coordinate to be set.
   */ /**
   * Set the colour of the label
   *
   * @param {THREE.Color} colour - colour to be set
   */ /**
   * Scale the label.
   *
   * @param {Number} scaling - Scale to be set.
   */ /**
   * Free up the memory
   */ /**
   * Get the intrnal sprite.
   *
   * @return {THREE.Sprite}
   */ /**
   * Get the text.
   *
   * @return {String}
   */sprite=colour?new SpriteText(text,.015,colour.getStyle()):new SpriteText(text,.015),sprite.fontFace="Asap",sprite.fontWeight=700,sprite.material.map.generateMipmaps=!1,sprite.material.sizeAttenuation=!1,sprite.center.x=-.05,sprite.center.y=0,this.getPosition=()=>sprite?[sprite.position.x,sprite.position.y,sprite.position.z]:[0,0,0],this.setPosition=(x,y,z)=>{sprite&&sprite.position.set(x,y,z)},this.setColour=colour=>{console.log(sprite),colour&&(sprite.color=colour.getStyle())},this.setScale=scaling=>{sprite&&0<scaling&&sprite.scale.set(scaling,scaling,1)},this.dispose=()=>{//sprite.dispose();
},this.getSprite=()=>sprite,this.getString=()=>text};

/***/ }),
/* 18 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),JSONLoader=(__webpack_require__(19).JSONLoader),Glyphset=function(){(__webpack_require__(10).ZincObject).call(this);var glyphList=[],axis1s=void 0,axis2s=void 0,axis3s=void 0,positions=void 0,scales=void 0,colors=void 0,labels=void 0,numberOfTimeSteps=0,numberOfVertices=0,baseSize=[0,0,0],offset=[0,0,0],scaleFactors=[0,0,0],repeat_mode="NONE";this.ready=!1;var morphColours=!1,morphVertices=!1;this.isGlyphset=!0;var _transformMatrix=new THREE.Matrix4,_bot_colour=new THREE.Color,_top_colour=new THREE.Color,_boundingBox1=new THREE.Box3,_boundingBox2=new THREE.Box3,_boundingBox3=new THREE.Box3,_points=[],_current_positions=[],_current_axis1s=[],_current_axis2s=[],_current_axis3s=[],_current_scales=[],_current_colors=[],_glyph_axis_array=[];this.globalScale=1;for(var i=0;8>i;i++)_points[i]=new THREE.Vector3;/**
   * Copy glyphset data into this glyphset then load the glyph's geoemtry 
   * with the provided glyphURL. FinishCallback will be called once
   * glyph is loaded.
   * 
   * @param {Array} glyphsetData - contains the informations about the glyphs.
   * @param {String} glyphURL - URL to the geometry which will be applied to all
   * all the glyphs in the glyphset once loaded.
   * @param {Function} finishCallback - User's function to be called once glyph's
   * geometry is loaded.
   */this.load=(glyphsetData,glyphURL,finishCallback,isInline,displayLabels)=>{axis1s=glyphsetData.axis1,axis2s=glyphsetData.axis2,axis3s=glyphsetData.axis3,positions=glyphsetData.positions,scales=glyphsetData.scale,colors=glyphsetData.colors,labels=glyphsetData.label,morphColours=glyphsetData.metadata.MorphColours,morphVertices=glyphsetData.metadata.MorphVertices,numberOfTimeSteps=glyphsetData.metadata.number_of_time_steps,repeat_mode=glyphsetData.metadata.repeat_mode,numberOfVertices=glyphsetData.metadata.number_of_vertices,"AXES_2D"==repeat_mode||"MIRROR"==repeat_mode?numberOfVertices*=2:"AXES_3D"==repeat_mode&&(numberOfVertices*=3),baseSize=glyphsetData.metadata.base_size,offset=glyphsetData.metadata.offset,scaleFactors=glyphsetData.metadata.scale_factors;var loader=new JSONLoader;this.geometry=new THREE.BufferGeometry;var instancedMesh=new THREE.InstancedMesh(this.geometry,void 0,numberOfVertices);if(this.setMorph(instancedMesh),isInline){var object=loader.parse(glyphURL);meshloader(finishCallback,displayLabels)(object.geometry,object.materials),object.geometry.dispose()}else loader.crossOrigin="Anonymous",loader.load(glyphURL,meshloader(finishCallback,displayLabels))};/**
   * Calculate the actual transformation value that can be applied 
   * to the transformation matrix.
   * 
   * @returns {Array}
   */var resolve_glyph_axes=(point,axis1,axis2,axis3,scale,return_arrays)=>{if("NONE"==repeat_mode||"MIRROR"==repeat_mode){for(var sign,axis_scale=[0,0,0],final_axis1=[0,0,0],final_axis2=[0,0,0],final_axis3=[0,0,0],final_point=[0,0,0],mirrored_axis1=[0,0,0],mirrored_axis2=[0,0,0],mirrored_axis3=[0,0,0],mirrored_point=[0,0,0],j=0;3>j;j++)sign=0>scale[j]?-1:1,axis_scale[j]=(sign*baseSize[j]+scale[j]*scaleFactors[j])*this.globalScale;for(var j=0;3>j;j++)final_axis1[j]=axis1[j]*axis_scale[0],final_axis2[j]=axis2[j]*axis_scale[1],final_axis3[j]=axis3[j]*axis_scale[2],final_point[j]=point[j]+offset[0]*final_axis1[j]+offset[1]*final_axis2[j]+offset[2]*final_axis3[j],"MIRROR"==repeat_mode&&(mirrored_axis1[j]=-final_axis1[j],mirrored_axis2[j]=-final_axis2[j],mirrored_axis3[j]=-final_axis3[j],mirrored_point[j]=final_point[j],0>scale[0]&&(final_point[j]-=final_axis1[j],mirrored_point[j]-=mirrored_axis1[j]));/* if required, reverse axis3 to maintain right-handed coordinate system */0>final_axis3[0]*(final_axis1[1]*final_axis2[2]-final_axis1[2]*final_axis2[1])+final_axis3[1]*(final_axis1[2]*final_axis2[0]-final_axis1[0]*final_axis2[2])+final_axis3[2]*(final_axis1[0]*final_axis2[1]-final_axis1[1]*final_axis2[0])&&(final_axis3[0]=-final_axis3[0],final_axis3[1]=-final_axis3[1],final_axis3[2]=-final_axis3[2]),return_arrays[0]=[final_point,final_axis1,final_axis2,final_axis3],"MIRROR"==repeat_mode&&(0>mirrored_axis3[0]*(mirrored_axis1[1]*mirrored_axis2[2]-mirrored_axis1[2]*mirrored_axis2[1])+mirrored_axis3[1]*(mirrored_axis1[2]*mirrored_axis2[0]-mirrored_axis1[0]*mirrored_axis2[2])+mirrored_axis3[2]*(mirrored_axis1[0]*mirrored_axis2[1]-mirrored_axis1[1]*mirrored_axis2[0])&&(mirrored_axis3[0]=-mirrored_axis3[0],mirrored_axis3[1]=-mirrored_axis3[1],mirrored_axis3[2]=-mirrored_axis3[2]),return_arrays[1]=[mirrored_point,mirrored_axis1,mirrored_axis2,mirrored_axis3])}else if("AXES_2D"==repeat_mode||"AXES_3D"==repeat_mode){for(var sign,_axis_scale=[0,0,0],_final_point=[0,0,0],j=0;3>j;j++)sign=0>scale[j]?-1:1,_axis_scale[j]=(sign*baseSize[0]+scale[j]*scaleFactors[0])*this.globalScale;for(var j=0;3>j;j++)_final_point[j]=point[j]+offset[0]*_axis_scale[0]*axis1[j]+offset[1]*_axis_scale[1]*axis2[j]+offset[2]*_axis_scale[2]*axis3[j];for(var number_of_glyphs="AXES_2D"==glyph_repeat_mode?2:3,k=0;k<number_of_glyphs;k++){var use_axis1=void 0,use_axis2=void 0,use_scale=scale[k],_final_axis=[0,0,0],_final_axis2=[0,0,0],_final_axis3=[0,0,0];0==k?(use_axis1=axis1,use_axis2=axis2):1==k?(use_axis1=axis2,use_axis2="AXES_2D"==glyph_repeat_mode?axis1:axis3):(use_axis1=axis3,use_axis2=axis1);var final_scale1=(baseSize[0]+use_scale*scaleFactors[0])*this.globalScale;_final_axis[0]=use_axis1[0]*final_scale1,_final_axis[1]=use_axis1[1]*final_scale1,_final_axis[2]=use_axis1[2]*final_scale1,_final_axis3[0]=_final_axis[1]*use_axis2[2]-use_axis2[1]*_final_axis[2],_final_axis3[1]=_final_axis[2]*use_axis2[0]-use_axis2[2]*_final_axis[0],_final_axis3[2]=_final_axis[0]*use_axis2[1]-_final_axis[1]*use_axis2[0];var magnitude=Math.sqrt(_final_axis3[0]*_final_axis3[0]+_final_axis3[1]*_final_axis3[1]+_final_axis3[2]*_final_axis3[2]);if(0<magnitude){var _scaling=(baseSize[2]+use_scale*scaleFactors[2])*this.globalScale/magnitude;"AXES_2D"==repeat_mode&&0<k&&(_scaling*=-1),_final_axis3[0]*=_scaling,_final_axis3[1]*=_scaling,_final_axis3[2]*=_scaling}if(_final_axis2[0]=_final_axis3[1]*_final_axis[2]-_final_axis[1]*_final_axis3[2],_final_axis2[1]=_final_axis3[2]*_final_axis[0]-_final_axis[2]*_final_axis3[0],_final_axis2[2]=_final_axis3[0]*_final_axis[1]-_final_axis3[1]*_final_axis[0],magnitude=Math.sqrt(_final_axis2[0]*_final_axis2[0]+_final_axis2[1]*_final_axis2[1]+_final_axis2[2]*_final_axis2[2]),0<magnitude){var scaling=(baseSize[1]+use_scale*scaleFactors[1])*this.globalScale/magnitude;_final_axis2[0]*=scaling,_final_axis2[1]*=scaling,_final_axis2[2]*=scaling}return_arrays[k]=[_final_point,_final_axis,_final_axis2,_final_axis3]}}return return_arrays},updateGlyphsetTransformation=(current_positions,current_axis1s,current_axis2s,current_axis3s,current_scales)=>{var numberOfGlyphs=1;"AXES_2D"==repeat_mode||"MIRROR"==repeat_mode?numberOfGlyphs=2:"AXES_3D"==repeat_mode&&(numberOfGlyphs=3);var numberOfPositions=current_positions.length/3,current_glyph_index=0;_glyph_axis_array.length=numberOfGlyphs;for(var _i=0;_i<numberOfPositions;_i++){var current_index=3*_i,current_position=[current_positions[current_index],current_positions[current_index+1],current_positions[current_index+2]],current_axis1=[current_axis1s[current_index],current_axis1s[current_index+1],current_axis1s[current_index+2]],current_axis2=[current_axis2s[current_index],current_axis2s[current_index+1],current_axis2s[current_index+2]],current_axis3=[current_axis3s[current_index],current_axis3s[current_index+1],current_axis3s[current_index+2]],current_scale=[current_scales[current_index],current_scales[current_index+1],current_scales[current_index+2]],arrays=resolve_glyph_axes(current_position,current_axis1,current_axis2,current_axis3,current_scale,_glyph_axis_array);if(arrays.length==numberOfGlyphs)for(var j=0;j<numberOfGlyphs;j++){_transformMatrix.elements[0]=arrays[j][1][0],_transformMatrix.elements[1]=arrays[j][1][1],_transformMatrix.elements[2]=arrays[j][1][2],_transformMatrix.elements[3]=0,_transformMatrix.elements[4]=arrays[j][2][0],_transformMatrix.elements[5]=arrays[j][2][1],_transformMatrix.elements[6]=arrays[j][2][2],_transformMatrix.elements[7]=0,_transformMatrix.elements[8]=arrays[j][3][0],_transformMatrix.elements[9]=arrays[j][3][1],_transformMatrix.elements[10]=arrays[j][3][2],_transformMatrix.elements[11]=0,_transformMatrix.elements[12]=arrays[j][0][0],_transformMatrix.elements[13]=arrays[j][0][1],_transformMatrix.elements[14]=arrays[j][0][2],_transformMatrix.elements[15]=1,this.morph.setMatrixAt(current_glyph_index,_transformMatrix);var glyph=glyphList[current_glyph_index];glyph&&glyph.setTransformation(arrays[j][0],arrays[j][1],arrays[j][2],arrays[j][3]),current_glyph_index++}}this.morph.instanceMatrix.needsUpdate=!0},updateGlyphsetHexColors=current_colors=>{var numberOfGlyphs=1;"AXES_2D"==repeat_mode||"MIRROR"==repeat_mode?numberOfGlyphs=2:"AXES_3D"==repeat_mode&&(numberOfGlyphs=3);for(var hex_values,numberOfColours=current_colors.length,current_glyph_index=0,_i2=0;_i2<numberOfColours;_i2++){hex_values=current_colors[_i2];for(var j=0;j<numberOfGlyphs;j++){_bot_colour.setHex(hex_values),this.morph.setColorAt(current_glyph_index,_bot_colour);var glyph=glyphList[current_glyph_index];glyph&&glyph.setColour(_bot_colour),current_glyph_index++}}this.morph.instanceColor.needsUpdate=!0},updateMorphGlyphsets=()=>{var current_positions=_current_positions,current_axis1s=_current_axis1s,current_axis2s=_current_axis2s,current_axis3s=_current_axis3s,current_scales=_current_scales,current_colors=_current_colors,current_time=this.inbuildTime/this.duration*(numberOfTimeSteps-1),bottom_frame=Math.floor(current_time),proportion=1-(current_time-bottom_frame),top_frame=Math.ceil(current_time);if(morphVertices){var bottom_positions=positions[bottom_frame.toString()],top_positions=positions[top_frame.toString()],bottom_axis1=axis1s[bottom_frame.toString()],top_axis1=axis1s[top_frame.toString()],bottom_axis2=axis2s[bottom_frame.toString()],top_axis2=axis2s[top_frame.toString()],bottom_axis3=axis3s[bottom_frame.toString()],top_axis3=axis3s[top_frame.toString()],bottom_scale=scales[bottom_frame.toString()],top_scale=scales[top_frame.toString()];_current_positions.length=bottom_positions.length,_current_axis1s.length=bottom_positions.length,_current_axis2s.length=bottom_positions.length,_current_axis3s.length=bottom_positions.length,_current_scales.length=bottom_positions.length;for(var _i3=0;_i3<bottom_positions.length;_i3++)current_positions[_i3]=proportion*bottom_positions[_i3]+(1-proportion)*top_positions[_i3],current_axis1s[_i3]=proportion*bottom_axis1[_i3]+(1-proportion)*top_axis1[_i3],current_axis2s[_i3]=proportion*bottom_axis2[_i3]+(1-proportion)*top_axis2[_i3],current_axis3s[_i3]=proportion*bottom_axis3[_i3]+(1-proportion)*top_axis3[_i3],current_scales[_i3]=proportion*bottom_scale[_i3]+(1-proportion)*top_scale[_i3]}else current_positions=positions[0],current_axis1s=axis1s[0],current_axis2s=axis2s[0],current_axis3s=axis3s[0],current_scales=scales[0];if(updateGlyphsetTransformation(current_positions,current_axis1s,current_axis2s,current_axis3s,current_scales),this.boundingBoxUpdateRequired=!0,null!=colors){if(morphColours){var bottom_colors=colors[bottom_frame.toString()],top_colors=colors[top_frame.toString()];current_colors.length=bottom_colors.length;for(var _i4=0;_i4<bottom_colors.length;_i4++)_bot_colour.setHex(bottom_colors[_i4]),_top_colour.setHex(top_colors[_i4]),_bot_colour.setRGB(_bot_colour.r*proportion+_top_colour.r*(1-proportion),_bot_colour.g*proportion+_top_colour.g*(1-proportion),_bot_colour.b*proportion+_top_colour.b*(1-proportion)),current_colors[_i4]=_bot_colour.getHex();/*
        for (var i = 0; i < bottom_colors.length; i++) {
          current_colors.push(proportion * bottom_colors[i] + (1.0 - proportion) * top_colors[i]);
        }
        */}else current_colors=colors[0];updateGlyphsetHexColors(current_colors)}};/**
   * Update transformation for each of the glyph in this glyphset.
   */ /**
   * Update colour for each of the glyph in this glyphset.
   */ /**
   * Update the current states of the glyphs in this glyphset, this includes transformation and
   * colour for each of them. This is called when glyphset and glyphs are initialised and whenever
   * the internal time has been updated.
   */ /**
   * Display the label of the glyphs in the glyphset.
   */this.showLabel=()=>{for(var _i5=0;_i5<glyphList.length;_i5++)glyphList[_i5].showLabel(this.morph.material?this.morph.material.color:void 0)},this.hideLabel=()=>{for(var _i6=0;_i6<glyphList.length;_i6++)glyphList[_i6].hideLabel()};/**
   * Create the glyphs in the glyphset.
   * 
   * @param {Boolean} displayLabels -Flag to determine either the labels should be display or not.
   */var createGlyphs=displayLabels=>{for(var _i7=0;_i7<numberOfVertices;_i7++){var glyph=new((__webpack_require__(16).Glyph))(void 0,void 0,_i7,this),label=labels?labels[_i7]:void 0;label=label?label:this.groupName,label&&glyph.setLabel(label),0<numberOfTimeSteps&&glyph.setFrustumCulled(!1),glyphList[_i7]=glyph,this.morph.add(glyph.getGroup())}//Update the transformation of the glyphs.
displayLabels&&this.showLabel(),updateGlyphsetTransformation(positions[0],axis1s[0],axis2s[0],axis3s[0],scales[0]),colors!=null&&updateGlyphsetHexColors(colors[0]),this.ready=!0,this.boundingBoxUpdateRequired=!0};/**
   * Add a custom {@link Glyph} to this {@link Glyphset}.
   * 
   * @param {Glyph} Glyph to be added.
   */this.addCustomGlyph=glyph=>{glyph.isGlyph&&glyphList.push(glyph),this.ready=!0,this.boundingBoxUpdateRequired=!0},this.addMeshAsGlyph=(mesh,id)=>{if(mesh.isMesh){var glyph=new((__webpack_require__(16).Glyph))(void 0,void 0,id,this);return glyph.fromMesh(mesh),glyphList.push(glyph),this.morph.add(glyph.getGroup()),this.ready=!0,this.boundingBoxUpdateRequired=!0,glyph}},this.forEachGlyph=callbackFunction=>{for(var _i8=0;_i8<glyphList.length;_i8++)callbackFunction(glyphList[_i8])};var meshloader=(finishCallback,displayLabels)=>(geometry,materials)=>{var tempGeometry=geometry.toBufferGeometry();this.geometry.copy(tempGeometry),this.geometry.computeBoundingSphere(),this.geometry.computeBoundingBox(),tempGeometry.dispose(),materials&&materials[0]&&(this.morph.material=materials[0]),createGlyphs(displayLabels),this.morph.name=this.groupName,this.morph.userData=this,this.setMorph(this.morph),geometry.dispose(),null!=finishCallback&&"function"==typeof finishCallback&&finishCallback(this)};/**
 * Get the index of the closest vertex to centroid.
 */ /**
   * Get the  closest vertex to centroid.
   */ /**
   * Get the bounding box for the whole set of glyphs.
   * 
   * @return {Three.Box3};
   */ /**
   * Set the local time of this glyphset.
   * 
   * @param {Number} time - Can be any value between 0 to duration.
   */ /**
   * Check if the glyphset is time varying.
   * 
   * @return {Boolean}
   */ /**
   * Get the current inbuild time of the 
   * 
   * @return {Number}
   */ /**
   * Set the objects scale.
   * 
   * @return {THREE.Box3}.
   */ /**
   * Clear this glyphset and its list of glyphs which will release them from the memory.
   */ /**
   * Update the glyphsets if required the render.
   */this.getClosestVertexIndex=function(){var closestIndex=-1;if(this.morph&&this.ready){this.getBoundingBox().getCenter(this._v1);for(var current_index,current_positions=positions[0],numberOfPositions=current_positions.length/3,distance=-1,currentDistance=0,_i9=0;_i9<numberOfPositions;_i9++)current_index=3*_i9,this._v2.set(current_positions[current_index],current_positions[current_index+1],current_positions[current_index+2]),currentDistance=this._v1.distanceTo(this._v2),-1==distance?(distance=currentDistance,closestIndex=_i9):distance>currentDistance&&(distance=currentDistance,closestIndex=_i9)}return closestIndex},this.getClosestVertex=function(){if(-1==this.closestVertexIndex&&(this.closestVertexIndex=this.getClosestVertexIndex()),0<=this.closestVertexIndex&&this.morph)/*
      if (glyphList && glyphList[this.closestVertexIndex]) {
        glyphList[this.closestVertexIndex].getBoundingBox().getCenter(position);
      }
      */{var position=new THREE.Vector3;return this.morph.getMatrixAt(this.closestVertexIndex,_transformMatrix),position.setFromMatrixPosition(_transformMatrix),position}},this.getBoundingBox=()=>{if(this.morph&&this.ready&&this.morph.visible){if(this.boundingBoxUpdateRequired){_boundingBox1.setFromBufferAttribute(this.morph.geometry.attributes.position);for(var _i10=0;_i10<numberOfVertices;_i10++)this.morph.getMatrixAt(_i10,_transformMatrix),_boundingBox2.copy(_boundingBox1).applyMatrix4(_transformMatrix),0==_i10?_boundingBox3.copy(_boundingBox2):_boundingBox3.union(_boundingBox2);if(_boundingBox3)this.cachedBoundingBox.copy(_boundingBox3),this.morph.updateWorldMatrix(!0,!0),this.cachedBoundingBox.applyMatrix4(this.morph.matrixWorld),this.boundingBoxUpdateRequired=!1;else return}return this.cachedBoundingBox}},this.setMorphTime=time=>{this.inbuildTime=time>this.duration?this.duration:0>time?0:time,(morphColours||morphVertices)&&(updateMorphGlyphsets(),morphVertices&&(this.markerUpdateRequired=!0))},this.isTimeVarying=()=>!!((!1===this.ready||0<numberOfTimeSteps)&&(morphColours||morphVertices)),this.getCurrentTime=()=>this.inbuildTime,this.setScaleAll=function(scale){this.globalScale=scale,updateMorphGlyphsets()},this.dispose=()=>{for(var _i11=glyphList.length-1;0<=_i11;_i11--)glyphList[_i11].dispose();this.geometry&&this.geometry.dispose(),this.morph&&this.morph.material.dispose(),axis1s=void 0,axis2s=void 0,axis3s=void 0,positions=void 0,scales=void 0,colors=void 0,this.ready=!1,this.groupName=void 0},this.render=(delta,playAnimation,options)=>{if(!0==playAnimation){var targetTime=this.inbuildTime+delta;targetTime>this.duration&&(targetTime-=this.duration),this.inbuildTime=targetTime,(morphColours||morphVertices)&&updateMorphGlyphsets()}this.updateMarker(playAnimation,options)}};/**
 * This is a container of {@link Glyph} and their graphical properties 
 * including transformations, colors, number of time steps, duration of animations
 * and group name. Please note that all glyphs in the glyphset share the same geometry
 * however they may have different transformations.
 * 
 * @class
 * @author Alan Wu
 * @return {Glyphset}
 */Glyphset.prototype=Object.create((__webpack_require__(10).ZincObject).prototype),exports.Glyphset=Glyphset;

/***/ }),
/* 19 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JSONLoader: () => (/* binding */ JSONLoader)
/* harmony export */ });
var THREE=__webpack_require__(4),Loader=(__webpack_require__(20).Loader),LoaderUtils=THREE.LoaderUtils,AnimationClip=THREE.AnimationClip,Vector3=THREE.Vector3,Vector4=THREE.Vector4,Color=THREE.Color,Vector2=THREE.Vector2,Face3=(__webpack_require__(6).Face3),Geometry=(__webpack_require__(6).Geometry),FileLoader=THREE.FileLoader,DefaultLoadingManager=THREE.DefaultLoadingManager,VideoHandler=(__webpack_require__(21).VideoHandler);/**
 * @author mrdoob / http://mrdoob.com/
 * @author alteredq / http://alteredqualia.com/
 */function JSONLoader(manager){"boolean"==typeof manager&&(console.warn("THREE.JSONLoader: showStatus parameter has been removed from constructor."),manager=void 0),this.manager=manager===void 0?DefaultLoadingManager:manager,this.withCredentials=!1,this.paramsString=""}Object.assign(JSONLoader.prototype,{load:function load(url,onLoad,onProgress,onError){var scope=this,texturePath=this.texturePath&&"string"==typeof this.texturePath?this.texturePath:LoaderUtils.extractUrlBase(url),loader=new FileLoader(this.manager),params=url.split("?");//There are parameters, add them to the target
this.paramsString=2===url.length?paramsStrings[1]:"",loader.setWithCredentials(this.withCredentials),loader.load(url,function(text){var json;try{json=JSON.parse(text)}catch(e){if(console.error("The loader has encountered an error while parsing the content of a resource."),onError)return void onError({responseURL:url})}var metadata=json.metadata;if(metadata!==void 0){var type=metadata.type;if(type!==void 0&&"object"===type.toLowerCase())return void console.error("THREE.JSONLoader: "+url+" should be loaded with THREE.ObjectLoader instead.")}if(scope&&scope.parse)try{var object=scope.parse(json,texturePath);onLoad(object.geometry,object.materials)}catch(e){if(console.error("The loader has encountered aon loading the geometry"),console.error(e),onError)return void onError({responseURL:url})}},onProgress,onError)},setTexturePath:function setTexturePath(value){this.texturePath=value},parse:function(){function parseModel(json,geometry){function isBitSet(value,position){return value&1<<position}var i,j,fi,offset,zLength,colorIndex,normalIndex,uvIndex,materialIndex,type,isQuad,hasMaterial,hasFaceVertexUv,hasFaceNormal,hasFaceVertexNormal,hasFaceColor,hasFaceVertexColor,vertex,face,faceA,faceB,hex,normal,uvLayer,uv,u,v,faces=json.faces,vertices=json.vertices,normals=json.normals,colors=json.colors,scale=json.scale,nUvLayers=0;if(void 0!==json.uvs){// disregard empty arrays
for(i=0;i<json.uvs.length;i++)json.uvs[i].length&&nUvLayers++;for(i=0;i<nUvLayers;i++)geometry.faceVertexUvs[i]=[]}for(offset=0,zLength=vertices.length;offset<zLength;)vertex=new Vector3,vertex.x=vertices[offset++]*scale,vertex.y=vertices[offset++]*scale,vertex.z=vertices[offset++]*scale,geometry.vertices.push(vertex);if(offset=0,zLength=faces.length,json.uvs)for(i=0;i<json.uvs.length;i++){geometry.uvs[i]=[];for(var k=0;k<json.uvs[i].length;k++)geometry.uvs[i][k]=json.uvs[i][k]}if(normals)for(i=0;i<normals.length;i++)geometry.normals[i]=normals[i];if(colors)for(i=0;i<colors.length;i++)geometry.colors[i]=colors[i];for(;offset<zLength;)// console.log("type", type, "bits", isQuad, hasMaterial, hasFaceVertexUv, hasFaceNormal, hasFaceVertexNormal, hasFaceColor, hasFaceVertexColor);
if(type=faces[offset++],isQuad=isBitSet(type,0),hasMaterial=isBitSet(type,1),hasFaceVertexUv=isBitSet(type,3),hasFaceNormal=isBitSet(type,4),hasFaceVertexNormal=isBitSet(type,5),hasFaceColor=isBitSet(type,6),hasFaceVertexColor=isBitSet(type,7),isQuad){if(faceA=new Face3,faceA.a=faces[offset],faceA.b=faces[offset+1],faceA.c=faces[offset+3],faceB=new Face3,faceB.a=faces[offset+1],faceB.b=faces[offset+2],faceB.c=faces[offset+3],offset+=4,hasMaterial&&(materialIndex=faces[offset++],faceA.materialIndex=materialIndex,faceB.materialIndex=materialIndex),fi=geometry.faces.length,hasFaceVertexUv)for(i=0;i<nUvLayers;i++)for(uvLayer=json.uvs[i],geometry.faceVertexUvs[i][fi]=[],geometry.faceVertexUvs[i][fi+1]=[],j=0;4>j;j++)uvIndex=faces[offset++],u=uvLayer[2*uvIndex],v=uvLayer[2*uvIndex+1],uv=new Vector2(u,v),2!==j&&geometry.faceVertexUvs[i][fi].push(uv),0!==j&&geometry.faceVertexUvs[i][fi+1].push(uv);if(hasFaceNormal&&(normalIndex=3*faces[offset++],faceA.normal.set(normals[normalIndex++],normals[normalIndex++],normals[normalIndex]),faceB.normal.copy(faceA.normal)),hasFaceVertexNormal)for(i=0;4>i;i++)normalIndex=3*faces[offset++],normal=new Vector3(normals[normalIndex++],normals[normalIndex++],normals[normalIndex]),2!==i&&faceA.vertexNormals.push(normal),0!==i&&faceB.vertexNormals.push(normal);if(hasFaceColor&&(colorIndex=faces[offset++],hex=colors[colorIndex],faceA.color.setHex(hex),faceB.color.setHex(hex)),hasFaceVertexColor)for(i=0;4>i;i++)colorIndex=faces[offset++],hex=colors[colorIndex],2!==i&&faceA.vertexColors.push(new Color(hex)),0!==i&&faceB.vertexColors.push(new Color(hex));geometry.faces.push(faceA),geometry.faces.push(faceB)}else{if(face=new Face3,face.a=faces[offset++],face.b=faces[offset++],face.c=faces[offset++],hasMaterial&&(materialIndex=faces[offset++],face.materialIndex=materialIndex),fi=geometry.faces.length,hasFaceVertexUv)for(i=0;i<nUvLayers;i++)for(uvLayer=json.uvs[i],geometry.faceVertexUvs[i][fi]=[],j=0;3>j;j++)uvIndex=faces[offset++],u=uvLayer[2*uvIndex],v=uvLayer[2*uvIndex+1],uv=new Vector2(u,v),geometry.faceVertexUvs[i][fi].push(uv);if(hasFaceNormal&&(normalIndex=3*faces[offset++],face.normal.set(normals[normalIndex++],normals[normalIndex++],normals[normalIndex])),hasFaceVertexNormal)for(i=0;3>i;i++)normalIndex=3*faces[offset++],normal=new Vector3(normals[normalIndex++],normals[normalIndex++],normals[normalIndex]),face.vertexNormals.push(normal);if(hasFaceColor&&(colorIndex=faces[offset++],face.color.setHex(colors[colorIndex])),hasFaceVertexColor)for(i=0;3>i;i++)colorIndex=faces[offset++],face.vertexColors.push(new Color(colors[colorIndex]));geometry.faces.push(face)}}function parseSkin(json,geometry){var influencesPerVertex=json.influencesPerVertex===void 0?2:json.influencesPerVertex;if(json.skinWeights)for(var i=0,l=json.skinWeights.length;i<l;i+=influencesPerVertex){var x=json.skinWeights[i],y=1<influencesPerVertex?json.skinWeights[i+1]:0,z=2<influencesPerVertex?json.skinWeights[i+2]:0,w=3<influencesPerVertex?json.skinWeights[i+3]:0;geometry.skinWeights.push(new Vector4(x,y,z,w))}if(json.skinIndices)for(var i=0,l=json.skinIndices.length;i<l;i+=influencesPerVertex){var a=json.skinIndices[i],b=1<influencesPerVertex?json.skinIndices[i+1]:0,c=2<influencesPerVertex?json.skinIndices[i+2]:0,d=3<influencesPerVertex?json.skinIndices[i+3]:0;geometry.skinIndices.push(new Vector4(a,b,c,d))}geometry.bones=json.bones,geometry.bones&&0<geometry.bones.length&&(geometry.skinWeights.length!==geometry.skinIndices.length||geometry.skinIndices.length!==geometry.vertices.length)&&console.warn("When skinning, number of vertices ("+geometry.vertices.length+"), skinIndices ("+geometry.skinIndices.length+"), and skinWeights ("+geometry.skinWeights.length+") should match.")}function parseMorphing(json,geometry){var scale=json.scale;if(json.morphTargets!==void 0)for(var i=0,l=json.morphTargets.length;i<l;i++){geometry.morphTargets[i]={},geometry.morphTargets[i].name=json.morphTargets[i].name,geometry.morphTargets[i].vertices=[];for(var vertex,dstVertices=geometry.morphTargets[i].vertices,srcVertices=json.morphTargets[i].vertices,v=0,vl=srcVertices.length;v<vl;v+=3)vertex=new Vector3,vertex.x=srcVertices[v]*scale,vertex.y=srcVertices[v+1]*scale,vertex.z=srcVertices[v+2]*scale,dstVertices.push(vertex)}if(void 0!==json.morphNormals)for(var i=0,l=json.morphNormals.length;i<l;i++)if(geometry.morphTargets[i]){geometry.morphTargets[i].normals=[];for(var normals,dstNormals=geometry.morphTargets[i].normals,srcNormals=json.morphNormals[i].normals,v=0,vl=srcNormals.length;v<vl;v+=3)normals=new Vector3,normals.x=srcNormals[v],normals.y=srcNormals[v+1],normals.z=srcNormals[v+2],dstNormals.push(normals);geometry.morphNormalsReady=!0}if(void 0!==json.morphColors){var i,l,c,cl,dstColors,srcColors,color;for(i=0,l=json.morphColors.length;i<l;i++)for(geometry.morphColors[i]={},geometry.morphColors[i].name=json.morphColors[i].name,geometry.morphColors[i].colors=[],dstColors=geometry.morphColors[i].colors,srcColors=json.morphColors[i].colors,(c=0,cl=srcColors.length);c<cl;c+=3)color=new THREE.Color(16755200),color.setRGB(srcColors[c],srcColors[c+1],srcColors[c+2]),dstColors.push(color)}}function parseAnimations(json,geometry){var outputAnimations=[],animations=[];// parse old style Bone/Hierarchy animations
json.animation!==void 0&&animations.push(json.animation),json.animations!==void 0&&(json.animations.length?animations=animations.concat(json.animations):animations.push(json.animations));for(var clip,i=0;i<animations.length;i++)clip=AnimationClip.parseAnimation(animations[i],geometry.bones),clip&&outputAnimations.push(clip);// parse implicit morph animations
if(geometry.morphTargets){// TODO: Figure out what an appropraite FPS is for morph target animations -- defaulting to 10, but really it is completely arbitrary.
var morphAnimationClips=AnimationClip.CreateClipsFromMorphTargetSequences(geometry.morphTargets,10);outputAnimations=outputAnimations.concat(morphAnimationClips)}0<outputAnimations.length&&(geometry.animations=outputAnimations)}return function(json,texturePath){void 0!==json.data&&(json=json.data),json.scale=void 0===json.scale?1:1/json.scale;var geometry=new Geometry;if(geometry.morphColors=[],parseModel(json,geometry),parseSkin(json,geometry),parseMorphing(json,geometry),parseAnimations(json,geometry),geometry.computeFaceNormals(),geometry.computeBoundingSphere(),void 0===json.materials||0===json.materials.length)return{geometry:geometry};var materials=Loader.prototype.initMaterials(json.materials,texturePath,"Anonymous");if(json.materials[0].video){var fullPath=texturePath+json.materials[0].video;this.paramsString&&(fullPath+="?".concat(this.paramsString));var videoHandler=new VideoHandler(fullPath);geometry._video=videoHandler}return materials&&0<materials.length&&(materials[0].side=json.materials[0].singleSided?THREE.FrontSide:json.materials[0].flipSided?THREE.BackSide:THREE.DoubleSide,json.materials[0].specularCoef&&(materials[0].shininess=Math.floor(json.materials[0].specularCoef/3))),{geometry:geometry,materials:materials}}}()});

/***/ }),
/* 20 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Loader: () => (/* binding */ Loader)
/* harmony export */ });
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(three__WEBPACK_IMPORTED_MODULE_0__);
var THREE=__webpack_require__(4);/**
 * @author alteredq / http://alteredqualia.com/
 */function Loader(){}Loader.Handlers={handlers:[],add:function add(regex,loader){this.handlers.push(regex,loader)},get:function get(file){for(var handlers=this.handlers,i=0,l=handlers.length;i<l;i+=2){var regex=handlers[i],loader=handlers[i+1];if(regex.test(file))return loader}return null}},Object.assign(Loader.prototype,{crossOrigin:"anonymous",onLoadStart:function onLoadStart(){},onLoadProgress:function onLoadProgress(){},onLoadComplete:function onLoadComplete(){},initMaterials:function initMaterials(materials,texturePath,crossOrigin){for(var array=[],i=0;i<materials.length;++i)array[i]=this.createMaterial(materials[i],texturePath,crossOrigin);return array},createMaterial:function(){var BlendingMode={NoBlending:three__WEBPACK_IMPORTED_MODULE_0__.NoBlending,NormalBlending:three__WEBPACK_IMPORTED_MODULE_0__.NormalBlending,AdditiveBlending:three__WEBPACK_IMPORTED_MODULE_0__.AdditiveBlending,SubtractiveBlending:three__WEBPACK_IMPORTED_MODULE_0__.SubtractiveBlending,MultiplyBlending:three__WEBPACK_IMPORTED_MODULE_0__.MultiplyBlending,CustomBlending:three__WEBPACK_IMPORTED_MODULE_0__.CustomBlending},color=new three__WEBPACK_IMPORTED_MODULE_0__.Color,textureLoader=new three__WEBPACK_IMPORTED_MODULE_0__.TextureLoader,materialLoader=new three__WEBPACK_IMPORTED_MODULE_0__.MaterialLoader;return function(m,texturePath,crossOrigin){function loadTexture(path,repeat,offset,wrap,anisotropy){var texture,fullPath=texturePath+path,loader=Loader.Handlers.get(fullPath);null===loader?(textureLoader.setCrossOrigin(crossOrigin),texture=textureLoader.load(fullPath)):texture=loader.load(fullPath),void 0!==repeat&&(texture.repeat.fromArray(repeat),1!==repeat[0]&&(texture.wrapS=three__WEBPACK_IMPORTED_MODULE_0__.RepeatWrapping),1!==repeat[1]&&(texture.wrapT=three__WEBPACK_IMPORTED_MODULE_0__.RepeatWrapping)),void 0!==offset&&texture.offset.fromArray(offset),void 0!==wrap&&("repeat"===wrap[0]&&(texture.wrapS=three__WEBPACK_IMPORTED_MODULE_0__.RepeatWrapping),"mirror"===wrap[0]&&(texture.wrapS=three__WEBPACK_IMPORTED_MODULE_0__.MirroredRepeatWrapping),"repeat"===wrap[1]&&(texture.wrapT=three__WEBPACK_IMPORTED_MODULE_0__.RepeatWrapping),"mirror"===wrap[1]&&(texture.wrapT=three__WEBPACK_IMPORTED_MODULE_0__.MirroredRepeatWrapping)),void 0!==anisotropy&&(texture.anisotropy=anisotropy);var uuid=three__WEBPACK_IMPORTED_MODULE_0__.MathUtils.generateUUID();return textures[uuid]=texture,uuid}//
// convert from old material format
var textures={},json={uuid:three__WEBPACK_IMPORTED_MODULE_0__.MathUtils.generateUUID(),type:"MeshLambertMaterial"};for(var name in m){var value=m[name];switch(name){case"DbgColor":case"DbgIndex":case"opticalDensity":case"illumination":break;case"DbgName":json.name=value;break;case"blending":json.blending=BlendingMode[value];break;case"colorAmbient":case"mapAmbient":console.warn("THREE.Loader.createMaterial:",name,"is no longer supported.");break;case"colorDiffuse":json.color=color.fromArray(value).getHex();break;case"colorSpecular":json.specular=color.fromArray(value).getHex();break;case"colorEmissive":json.emissive=color.fromArray(value).getHex();break;case"specularCoef":json.shininess=value;break;case"shading":"basic"===value.toLowerCase()&&(json.type="MeshBasicMaterial"),"phong"===value.toLowerCase()&&(json.type="MeshPhongMaterial"),"standard"===value.toLowerCase()&&(json.type="MeshStandardMaterial");break;case"mapDiffuse":json.map=loadTexture(value,m.mapDiffuseRepeat,m.mapDiffuseOffset,m.mapDiffuseWrap,m.mapDiffuseAnisotropy);break;case"mapDiffuseRepeat":case"mapDiffuseOffset":case"mapDiffuseWrap":case"mapDiffuseAnisotropy":break;case"mapEmissive":json.emissiveMap=loadTexture(value,m.mapEmissiveRepeat,m.mapEmissiveOffset,m.mapEmissiveWrap,m.mapEmissiveAnisotropy);break;case"mapEmissiveRepeat":case"mapEmissiveOffset":case"mapEmissiveWrap":case"mapEmissiveAnisotropy":break;case"mapLight":json.lightMap=loadTexture(value,m.mapLightRepeat,m.mapLightOffset,m.mapLightWrap,m.mapLightAnisotropy);break;case"mapLightRepeat":case"mapLightOffset":case"mapLightWrap":case"mapLightAnisotropy":break;case"mapAO":json.aoMap=loadTexture(value,m.mapAORepeat,m.mapAOOffset,m.mapAOWrap,m.mapAOAnisotropy);break;case"mapAORepeat":case"mapAOOffset":case"mapAOWrap":case"mapAOAnisotropy":break;case"mapBump":json.bumpMap=loadTexture(value,m.mapBumpRepeat,m.mapBumpOffset,m.mapBumpWrap,m.mapBumpAnisotropy);break;case"mapBumpScale":json.bumpScale=value;break;case"mapBumpRepeat":case"mapBumpOffset":case"mapBumpWrap":case"mapBumpAnisotropy":break;case"mapNormal":json.normalMap=loadTexture(value,m.mapNormalRepeat,m.mapNormalOffset,m.mapNormalWrap,m.mapNormalAnisotropy);break;case"mapNormalFactor":json.normalScale=value;break;case"mapNormalRepeat":case"mapNormalOffset":case"mapNormalWrap":case"mapNormalAnisotropy":break;case"mapSpecular":json.specularMap=loadTexture(value,m.mapSpecularRepeat,m.mapSpecularOffset,m.mapSpecularWrap,m.mapSpecularAnisotropy);break;case"mapSpecularRepeat":case"mapSpecularOffset":case"mapSpecularWrap":case"mapSpecularAnisotropy":break;case"mapMetalness":json.metalnessMap=loadTexture(value,m.mapMetalnessRepeat,m.mapMetalnessOffset,m.mapMetalnessWrap,m.mapMetalnessAnisotropy);break;case"mapMetalnessRepeat":case"mapMetalnessOffset":case"mapMetalnessWrap":case"mapMetalnessAnisotropy":break;case"mapRoughness":json.roughnessMap=loadTexture(value,m.mapRoughnessRepeat,m.mapRoughnessOffset,m.mapRoughnessWrap,m.mapRoughnessAnisotropy);break;case"mapRoughnessRepeat":case"mapRoughnessOffset":case"mapRoughnessWrap":case"mapRoughnessAnisotropy":break;case"mapAlpha":json.alphaMap=loadTexture(value,m.mapAlphaRepeat,m.mapAlphaOffset,m.mapAlphaWrap,m.mapAlphaAnisotropy);break;case"mapAlphaRepeat":case"mapAlphaOffset":case"mapAlphaWrap":case"mapAlphaAnisotropy":break;case"flipSided":json.side=three__WEBPACK_IMPORTED_MODULE_0__.BackSide;break;case"doubleSided":json.side=three__WEBPACK_IMPORTED_MODULE_0__.DoubleSide;break;case"transparency":console.warn("THREE.Loader.createMaterial: transparency has been renamed to opacity"),json.opacity=value;break;case"depthTest":case"depthWrite":case"colorWrite":case"opacity":case"reflectivity":case"transparent":case"visible":case"wireframe":json[name]=value;break;case"vertexColors":!0===value&&(json.vertexColors=three__WEBPACK_IMPORTED_MODULE_0__.VertexColors),"face"===value&&(json.vertexColors=three__WEBPACK_IMPORTED_MODULE_0__.FaceColors);break;default:console.error("THREE.Loader.createMaterial: Unsupported",name,value)}}return"MeshBasicMaterial"===json.type&&delete json.emissive,"MeshPhongMaterial"!==json.type&&delete json.specular,1>json.opacity&&(json.transparent=!0),materialLoader.setTextures(textures),materialLoader.parse(json)}}()});

/***/ }),
/* 21 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4);/**
 * Provide basic functionality to display video as texture.
 * VideoTexture is used for creating and updating a video projected onto a Three.js texture
 * 
 * @class
 * @param {Object} containerIn - Container to create the renderer on.
 * @author Alan Wu
 * @return {VideoHandler}
 */exports.VideoHandler=function(srcIn){var _this=this;this.video=void 0,this.videoTexture=void 0;var lastPlayPos=0,currentPlayPos=0,bufferingDetected=!1;// videoPlaneLoaded connects the video to the video texture once it has loaded
//this should be handle by scene... check the sync at 
this.setMorphTime=function(time,duration){var actualTime=time/duration*_this.video.duration;_this.video.currentTime=actualTime},this.getVideoDuration=function(){return _this.video.duration},this.createCanvasVideoTexture=function(){return _this.videoTexture=new THREE.VideoTexture(_this.video),_this.videoTexture.minFilter=THREE.LinearFilter,_this.videoTexture.magFilter=THREE.LinearFilter,_this.videoTexture.format=THREE.RGBFormat,_this.video.currentTime=0,_this.videoTexture},this.getCurrentTime=function(duration){return _this.video?duration*(_this.video.currentTime/_this.video.duration):0},this.isReadyToPlay=function(){// video.readyState 3 means we have data to load for the current time and foreseeable future
return!!(_this.video&&3<=_this.video.readyState)},function initialise(){document&&(_this.video=document.createElement("video"),_this.video.crossOrigin="anonymous",_this.video.src=srcIn,_this.video.load(),_this.video.loop=!0)}()};

/***/ }),
/* 22 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),Points=(__webpack_require__(23).Points),toBufferGeometry=(__webpack_require__(5).toBufferGeometry),getCircularTexture=(__webpack_require__(5).getCircularTexture),Label=(__webpack_require__(17).Label),Pointset=function(){(__webpack_require__(10).ZincObject).call(this),this.isPointset=!0;var labelSets=[];/**
   * Create the pointsets using geometry and material.
   *
   * @param {THREE.Geomtry} geometryIn - Geometry of points to be rendered.
   * @param {THREE.Material} materialIn - Material to be set for the lines.
   * @param {Object} options - Provide various options
   * @param {Boolean} options.localTimeEnabled - A flag to indicate either the lines is
   * time dependent.
   * @param {Boolean} options.localMorphColour - A flag to indicate either the colour is
   * time dependent.
   */this.createMesh=(geometryIn,materialIn,options)=>{if(geometryIn&&materialIn){var geometry=toBufferGeometry(geometryIn,options),texture=getCircularTexture();materialIn.map=texture;var point=new Points(geometry,materialIn);this.setMesh(point,options.localTimeEnabled,options.localMorphColour)}};var addLabel=(index,coord,labelText,colourHex)=>{if(labelText){var colour=new THREE.Color(colourHex),label=new Label(labelText,colour);label.setPosition(coord[0],coord[1],coord[2]);var sprite=label.getSprite();sprite.material.sizeAttenuation=!1,sprite.material.alphaTest=.5,sprite.material.transparent=!0,sprite.material.depthWrite=!1,sprite.material.depthTest=!1,this.group.add(sprite),labelSets[index]=label}};/**
   * Add points to existing mesh if it exists, otherwise
   * create a new one and add to it.
   * @param {Array} coords  -An array of three components coordinates.
   * @param {Array|String} labels - An array of strings, these are only added
   * if the number of coords equals to the number labels provided.
   * @param {Number} colour - A hex value of the colour for the points
   */ /**
   * Set the colour of the pointset and its label using the hex value
   *
   * @param {Number} hex - hex value of color to be set
   */ /**
   * Set the colour of the pointset and its label
   *
   * @param {THREE.Color} colour - colour to be set
   */ /**
   * Set the size of the points.
   *
   * @param {Number} size - size to be set.
   */ /**
   * Turn size attenuation on/off based on the flag.
   *
   * @param {Boolean} flag - Determin either size attenuation
   * should be on or off.
   */ /**
   * Get vertices at index
   */ /**
   * Edit Vertice in index.
   */ /**
 * Turn size attenuation on/off based on the flag.
 *
 * @param {Boolean} flag - Determin either size attenuation
 * should be on or off.
 */this.addPoints=(coords,labels,colour)=>{if(coords&&0<coords.length){var current=this.drawRange-1,geometry=this.addVertices(coords),mesh=this.getMorph();if(!mesh){var material=new THREE.PointsMaterial({alphaTest:.5,size:10,color:colour,sizeAttenuation:!1});geometry.colorsNeedUpdate=!0,this.createMesh(geometry,material,{localTimeEnabled:!1,localMorphColour:!1})}var end=current+coords.length,index=0;if(Array.isArray(labels)&&labels.length===coords.length||"string"==typeof labels)for(current;current+index<end;){var labelText="string"==typeof labels?labels:labels[index];addLabel(index,coords[index],labelText,colour),index++}this.region&&(this.region.pickableUpdateRequired=!0)}},this.setColourHex=function(hex){this._lod._material.color.setHex(hex),this._lod._secondaryMaterial&&this._lod._secondaryMaterial.color.setHex(hex);for(var i=0;i<labelSets.length;i++)labelSets[i]&&labelSets[i].setColour(this._lod._material.color)},this.setColour=colour=>{this._lod.setColour(colour);for(var i=0;i<labelSets.length;i++)labelSets[i]&&labelSets[i].setColour(this._lod._material.color)},this.setSize=size=>{this.morph&&this.morph.material&&(this.morph.material.size=size,this.morph.material.needsUpdate=!0)},this.setSizeAttenuation=flag=>{this.morph&&this.morph.material&&(this.morph.material.sizeAttenuation=flag,this.morph.material.needsUpdate=!0)},this.getVerticesByIndex=function(index){if(0<=index&&this.drawRange>index){var positionAttribute=this.getMorph().geometry.getAttribute("position");return[positionAttribute.getX(index),positionAttribute.getY(index),positionAttribute.getZ(index)]}},this.editVertices=function(coords,i){if(coords&&coords.length){var mesh=this.getMorph(),maxIndex=i+coords.length-1;if(!mesh||0>i||maxIndex>=this.drawRange)return;var positionAttribute=mesh.geometry.getAttribute("position"),index=i;coords.forEach(coord=>{var label=labelSets[index];label&&label.setPosition(coord[0],coord[1],coord[2]),positionAttribute.setXYZ(index++,coord[0],coord[1],coord[2])}),positionAttribute.needsUpdate=!0,this.boundingBoxUpdateRequired=!0}},this.render=(delta,playAnimation,cameraControls,options)=>{this.morph&&cameraControls&&(this.morph.sizePerPixel=cameraControls.pixelHeight),Pointset.prototype.render.call(this,delta,playAnimation,cameraControls,options)}};/**
 * Provides an object which stores points and provides method which controls its position.
 * This is created when a valid json file containing point is read into a {@link Zinc.Scene}
 * object.
 *
 * @class
 * @author Alan Wu
 * @return {Pointset}
 */Pointset.prototype=Object.create((__webpack_require__(10).ZincObject).prototype),exports.Pointset=Pointset;

/***/ }),
/* 23 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Points: () => (/* binding */ Points)
/* harmony export */ });
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(three__WEBPACK_IMPORTED_MODULE_0__);
var _inverseMatrix=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Matrix4,_ray=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Ray,_sphere=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Sphere,_position=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_morphA=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_tempA=/*@__PURE__*/new three__WEBPACK_IMPORTED_MODULE_0__.Vector3;class Points extends three__WEBPACK_IMPORTED_MODULE_0__.Object3D{constructor(){var geometry=0<arguments.length&&arguments[0]!==void 0?arguments[0]:new three__WEBPACK_IMPORTED_MODULE_0__.BufferGeometry,material=1<arguments.length&&arguments[1]!==void 0?arguments[1]:new three__WEBPACK_IMPORTED_MODULE_0__.PointsMaterial;super(),this.type="Points",this.geometry=geometry,this.material=material,this.sizePerPixel=1,this.updateMorphTargets()}copy(source){return super.copy(source),this.material=source.material,this.geometry=source.geometry,this}raycast(raycaster,intersects){var geometry=this.geometry,matrixWorld=this.matrixWorld,threshold=raycaster.params.Points.threshold,drawRange=geometry.drawRange;// Checking boundingSphere distance to ray
if(null===geometry.boundingSphere&&geometry.computeBoundingSphere(),_sphere.copy(geometry.boundingSphere),_sphere.applyMatrix4(matrixWorld),_sphere.radius+=threshold,!1!==raycaster.ray.intersectsSphere(_sphere)){_inverseMatrix.copy(matrixWorld).invert(),_ray.copy(raycaster.ray).applyMatrix4(_inverseMatrix);var localThreshold=threshold/((this.scale.x+this.scale.y+this.scale.z)/3)*this.material.size*this.sizePerPixel,localThresholdSq=localThreshold*localThreshold;if(geometry.isBufferGeometry){var index=geometry.index,attributes=geometry.attributes,positionAttribute=attributes.position,morphPosition=geometry.morphAttributes.position;if(null!==index)for(var a,start=Math.max(0,drawRange.start),end=Math.min(index.count,drawRange.start+drawRange.count),i=start;i<end;i++)a=index.getX(i),calculatePosition(this,positionAttribute,morphPosition,a),testPoint(_position,a,localThresholdSq,matrixWorld,raycaster,intersects,this);else for(var _start=Math.max(0,drawRange.start),_end=Math.min(positionAttribute.count,drawRange.start+drawRange.count),_i=_start;_i<_end;_i++)calculatePosition(this,positionAttribute,morphPosition,_i),testPoint(_position,_i,localThresholdSq,matrixWorld,raycaster,intersects,this)}else console.error("THREE.Points.raycast() no longer supports THREE.Geometry. Use THREE.BufferGeometry instead.")}//
}updateMorphTargets(){var geometry=this.geometry;if(geometry.isBufferGeometry){var morphAttributes=geometry.morphAttributes,keys=Object.keys(morphAttributes);if(0<keys.length){var morphAttribute=morphAttributes[keys[0]];if(morphAttribute!==void 0){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(var name,m=0,ml=morphAttribute.length;m<ml;m++)name=morphAttribute[m].name||m+"",this.morphTargetInfluences.push(0),this.morphTargetDictionary[name]=m}}}else{var morphTargets=geometry.morphTargets;morphTargets!==void 0&&0<morphTargets.length&&console.error("THREE.Points.updateMorphTargets() does not support THREE.Geometry. Use THREE.BufferGeometry instead.")}}}Points.prototype.isPoints=!0;function testPoint(point,index,localThresholdSq,matrixWorld,raycaster,intersects,object){var rayPointDistanceSq=_ray.distanceSqToPoint(point);if(rayPointDistanceSq<localThresholdSq){var intersectPoint=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3;_ray.closestPointToPoint(point,intersectPoint),intersectPoint.applyMatrix4(matrixWorld);var distance=raycaster.ray.origin.distanceTo(intersectPoint);if(distance<raycaster.near||distance>raycaster.far)return;intersects.push({distance:distance,distanceToRay:Math.sqrt(rayPointDistanceSq),point:intersectPoint,index:index,face:null,object:object})}}function calculatePosition(object,position,morphPosition,a){_position.fromBufferAttribute(position,a);var morphInfluences=object.morphTargetInfluences;if(object.material.morphTargets&&morphPosition&&morphInfluences){_morphA.set(0,0,0);for(var i=0,il=morphPosition.length;i<il;i++){var influence=morphInfluences[i],morphAttribute=morphPosition[i];0!==influence&&(_tempA.fromBufferAttribute(morphAttribute,a),_morphA.addScaledVector(_tempA.sub(_position),influence))}_position.add(_morphA)}}

/***/ }),
/* 24 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),toBufferGeometry=(__webpack_require__(5).toBufferGeometry),Lines=function(){/**
   * Create the line segements using geometry and material.
   * 
   * @param {THREE.Geomtry} geometryIn - Geometry of lines to be rendered.
   * @param {THREE.Material} materialIn - Material to be set for the lines.
   * @param {Object} options - Provide various options
   * @param {Boolean} options.localTimeEnabled - A flag to indicate either the lines is
   * time dependent.
   * @param {Boolean} options.localMorphColour - A flag to indicate either the colour is
   * time dependent.
   */ /**
   * Set the width for the lines.
   * 
   * @param {Number} width - Width of the lines.
   */ /**
   * Add new lines to existing lines if it exists, otherwise
   * create a new one and add to it.
   * @param {Array} coords  -An array of three components coordinates.

   * @param {Number} colour - A hex value of the colour for the points
   */(__webpack_require__(10).ZincObject).call(this),this.isLines=!0,this.createLineSegment=(geometryIn,materialIn,options)=>{if(geometryIn&&materialIn){var geometry=toBufferGeometry(geometryIn,options);options.localMorphColour&&geometry.morphAttributes.color&&(materialIn.onBeforeCompile=(__webpack_require__(9).augmentMorphColor)());var line=new((__webpack_require__(12).LineSegments))(geometry,materialIn);this.setMesh(line,options.localTimeEnabled,options.localMorphColour)}},this.setWidth=width=>{this.morph&&this.morph.material&&(this.morph.material.linewidth=width,this.morph.material.needsUpdate=!0)},this.addLines=(coords,colour)=>{if(coords&&0<coords.length){var geometry=this.addVertices(coords),mesh=this.getMorph();if(!mesh){var material=new THREE.LineBasicMaterial({color:colour});geometry.colorsNeedUpdate=!0,this.createLineSegment(geometry,material,{localTimeEnabled:!1,localMorphColour:!1})}this.region&&(this.region.pickableUpdateRequired=!0)}}};/**
 * Provides an object which stores lines.
 * This is created when a valid json file containing lines is read into a {@link Zinc.Scene}
 * object.
 * 
 * @class
 * @author Alan Wu
 * @return {Lines}
 */Lines.prototype=Object.create((__webpack_require__(10).ZincObject).prototype),exports.Lines=Lines;

/***/ }),
/* 25 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

function asyncGeneratorStep(n,t,e,r,o,a,c){try{var i=n[a](c),u=i.value}catch(n){return void e(n)}i.done?t(u):Promise.resolve(u).then(r,o)}function _asyncToGenerator(n){return function(){var t=this,e=arguments;return new Promise(function(r,o){function _next(n){asyncGeneratorStep(a,r,o,_next,_throw,"next",n)}function _throw(n){asyncGeneratorStep(a,r,o,_next,_throw,"throw",n)}var a=n.apply(t,e);_next(void 0)})}}var THREE=__webpack_require__(4),TextureArray=function(){var _this=this;/**
   * Read images from an array containg src locations.
   * 
   * @async
   * @param {Array} srcArrays - List of source location of the images.
   */ /**
   * Get and create the material containing shaders and the textures.
   * The texture must be read and ready before calling this function.
   * 
   *
   * @param {Object} options - Customise the material with the options object.
   * @param {String} options.fs - string of the fragment shader used for 
   * visualisation.
   * @param {String} options.vs - string of the vertex shader used for 
   * visualisation.
   * @param {Object} options.uniforms - Containing the data to be passed into the shaders.
   * @param {String} options.glslVersion - Version of glsl used for compile this shader.
   * 
   */(__webpack_require__(26).Texture).call(this),this.isTextureArray=!0,this.loadFromImages=/*#__PURE__*/function(){var _ref=_asyncToGenerator(function*(srcArrays){var w=1,h=1,d=0;if(srcArrays&&srcArrays.length){_this.isLoading=!0;var image=new Image;image.crossOrigin="Anonymous";for(var data,canvas=document.createElement("canvas"),length=0,dataStacks=Array(srcArrays.length),i=0;i<srcArrays.length;i++)data=yield _this.imageToUint8Array(_this,image,srcArrays[i],canvas),data&&data.array&&(w=data.width,h=data.height,dataStacks[d]=data.array,length+=dataStacks[d].length,d++);var fullArray=new Uint8Array(length);length=0,dataStacks.forEach(data=>{fullArray.set(data,length),length+=data.length}),_this.impl=new THREE.DataTexture2DArray(fullArray,w,h,d),_this.size={width:w,height:h,depth:d},_this.isLoading=!1,_this.impl.needsUpdate=!0}});return function(){return _ref.apply(this,arguments)}}(),this.getMaterial=options=>{if(this.impl){var material;if(!options)material=new THREE.MeshBasicMaterial({color:new THREE.Color(1,1,1),transparent:!1,opacity:1,map:this.impl,side:THREE.DoubleSide});else if(options.vs&&options.fs){var transparent=!0;"transparent"in options&&(transparent=options.transparent);var side=THREE.FrontSide;options.side&&(side=options.side),material=new THREE.ShaderMaterial({transparent,uniforms:options.uniforms,vertexShader:options.vs,fragmentShader:options.fs,side}),options.glslVersion&&(material.glslVersion=options.glslVersion)}if(material)return material.needsUpdate=!0,material}}};/**
 * Texture array object for holding array of images into
 * texures unit that can be used by other texture primitives.
 * 
 * @class
 * @author Alan Wu
 * @return {TextureArray}
 */TextureArray.prototype=Object.create((__webpack_require__(26).Texture).prototype),exports.TextureArray=TextureArray;

/***/ }),
/* 26 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

function asyncGeneratorStep(n,t,e,r,o,a,c){try{var i=n[a](c),u=i.value}catch(n){return void e(n)}i.done?t(u):Promise.resolve(u).then(r,o)}function _asyncToGenerator(n){return function(){var t=this,e=arguments;return new Promise(function(r,o){function _next(n){asyncGeneratorStep(a,r,o,_next,_throw,"next",n)}function _throw(n){asyncGeneratorStep(a,r,o,_next,_throw,"throw",n)}var a=n.apply(t,e);_next(void 0)})}}var THREE=__webpack_require__(4),Texture=function(){this.isTexture=!0,this.impl=void 0,this.isLoading=!1,this.size={width:1,height:1,depth:0}};/**
 * Base texture object for importing images and turning them into
 * texures unit that can be used by other texture primitives.
 * 
 * @class
 * @author Alan Wu
 * @return {Texture}
 */ /**
 * Read an image from src.
 * 
 * @async
 * @param {Image} img - An image object.
 * @param {String} src - Source location of the image.
 * 
 * @return {Promise} img on resolve.
 */ /**
  @typedef IMAGE_UINT8_RETURN
  @type {Set}
  @property {Uint8Array} array - Array containing the uint8 image value.
  @property {Number} width - Phyiscal image width.
  @property {Number} height - Phyiscal image height.
  */ /**
 * Read an image from src and turn it into Uint8Array.
 * 
 * @async
 * @param {Image} img - An image object.
 * @param {String} src - Source location of the image.
 * @param {Canvas} canvas - Canvas html element used for the conversion.
 * 
 * @return {IMAGE_UNIT8_RETURN}
 */ /**
 * Return true if the texture is ready for consumption.
 * 
 * @return {Boolean}
 */ /**
 * Return true if  the texture is ready for consumption, otherwise false.
 * 
 * @return {Boolean}
 */Texture.prototype.loadImage=function(img,src){return new Promise((resolve,reject)=>{img.onload=()=>resolve(img),img.onerror=reject,img.src=src})},Texture.prototype.imageToUint8Array=/*#__PURE__*/function(){var _ref=_asyncToGenerator(function*(instance,img,src,canvas){yield instance.loadImage(img,src),canvas.width=img.width,canvas.height=img.height;var ctx=canvas.getContext("2d");return ctx.drawImage(img,0,0),{array:new Uint8Array(ctx.getImageData(0,0,canvas.width,canvas.height).data.buffer),width:canvas.width,height:canvas.height}});return function(){return _ref.apply(this,arguments)}}(),Texture.prototype.loadFromImages=/*#__PURE__*/function(){var _ref2=_asyncToGenerator(function*(){});return function(){return _ref2.apply(this,arguments)}}(),Texture.prototype.isReady=function(){return!(!this.impl||this.isLoading)},Texture.prototype.getMaterial=function(){if(this.impl)return new THREE.MeshBasicMaterial({color:new THREE.Color(1,1,1),transparent:!1,opacity:1,map:this.impl,side:THREE.DoubleSide})},exports.Texture=Texture;

/***/ }),
/* 27 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter(function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable})),t.push.apply(t,o)}return t}function _objectSpread(e){for(var t,r=1;r<arguments.length;r++)t=null==arguments[r]?{}:arguments[r],r%2?ownKeys(Object(t),!0).forEach(function(r){_defineProperty(e,r,t[r])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach(function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))});return e}function _defineProperty(e,r,t){return(r=_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function _toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}var THREE=__webpack_require__(4),shader=__webpack_require__(28),TextureSlides=function(textureIn){(__webpack_require__(29).TexturePrimitive).call(this,textureIn),this.isTextureSlides=!0;var textureSettings=[],idTextureMap={};this.morph=new THREE.Group,this.group=this.morph,this.morph.userData=this;var edgesLine=void 0,flipY=!0;/**
    @typedef SLIDE_SETTINGS
    @type {Set}
    @property {String} direction - the value must be x, y or z, specify the
    direction the slide should be facing.
    @property {Number} value - Normalised value of the location on direction.
    @property {String} id - ID of the mesh, it is only available if the settings
    is returned from {@link TextureSlides.createSlide} or
    {@link TextureSlides.getTextureSettings}.
   */ /**
   * Create the slides required for visualisation based on the slide settings.
   * The slides themselves are {THREE.PlanGeometry} objects.
   *
   * @param {SLIDE_SETTINGS} slideSettings - An array to each slide settings.
   */this.createSlides=slideSettings=>{slideSettings.forEach(slide=>this.createSlide(slide))};/**
   * Set the value of the uniforms for a specific mesh in this
   * texture slide object.
   *
   * @param {THREE.Mesh} mesh - Mesh to be modified
   * @param {SLIDE_SETTINGS} slideSettings - Slide settings.
   */var setUniformSlideSettingsOfMesh=(mesh,settings)=>{var material=mesh.material,uniforms=material.uniforms;switch(mesh.rotation.x=0,mesh.rotation.y=0,mesh.rotation.z=0,mesh.position.x=0,mesh.position.y=0,mesh.position.z=0,settings.direction){case"x":var rotation=-Math.PI/2;mesh.rotation.y=rotation,uniforms.direction.value=1,uniforms.slide.value.set(settings.value,0,0),mesh.position.x=settings.value;break;case"y":mesh.rotation.x=Math.PI/2,uniforms.direction.value=2,uniforms.slide.value.set(0,settings.value,0),mesh.position.y=settings.value;break;case"z":uniforms.direction.value=3,uniforms.slide.value.set(0,0,settings.value),mesh.position.z=settings.value;break;default:}material.needsUpdate=!0,this.boundingBoxUpdateRequired=!0};/**
   * Modify the mesh based on a setting
   *
   * @param {SLIDE_SETTINGS} settings - s.
   */this.modifySlideSettings=settings=>{settings&&settings.id&&settings.id in idTextureMap&&idTextureMap[settings.id]&&setUniformSlideSettingsOfMesh(idTextureMap[settings.id],settings)},this.createSlide=settings=>{if(this.texture&&this.texture.isTextureArray&&this.texture.isReady()&&settings&&settings.direction&&void 0!==settings.value){var geometry=new THREE.PlaneGeometry(1,1);geometry.translate(.5,.5,0);var uniforms=shader.getUniforms();uniforms.diffuse.value=this.texture.impl,uniforms.depth.value=this.texture.size.depth,uniforms.flipY.value=flipY;var options={fs:shader.fs,vs:shader.vs,uniforms:uniforms,glslVersion:shader.glslVersion,side:THREE.DoubleSide,transparent:!1},material=this.texture.getMaterial(options);material.needsUpdate=!0;var mesh=new THREE.Mesh(geometry,material);mesh.name=this.groupName,mesh.userData=this;var slideSettings={value:settings.value,direction:settings.direction,id:mesh.id};return textureSettings.push(slideSettings),setUniformSlideSettingsOfMesh(mesh,slideSettings),idTextureMap[mesh.id]=mesh,this.morph.add(mesh),this.boundingBoxUpdateRequired=!0,slideSettings}},this.getTextureSettings=()=>[...textureSettings],this.getTextureSettingsWithId=id=>{for(var i=0;i<textureSettings.length;i++)if(id===textureSettings[i].id)return _objectSpread({},textureSettings[i])},this.getSlides=()=>this.morph?[...this.morph.children]:[],this.removeSlide=slide=>{slide&&this.removeSlideWithId(slide.id)},this.removeSlideWithId=id=>{if(this.morph&&id in idTextureMap&&idTextureMap[id]){if(this.morph.getObjectById(id)){var slide=idTextureMap[id];this.morph.remove(slide),slide.clear(),slide.geometry&&slide.geometry.dispose(),slide.material&&slide.material.dispose(),this.boundingBoxUpdateRequired=!0}var index=textureSettings.findIndex(item=>item.id===id);-1<index&&textureSettings.splice(index,1)}},this.dispose=()=>{this.morph.children.forEach(slide=>{slide.geometry&&slide.geometry.dispose(),slide.material&&slide.material.dispose()}),(__webpack_require__(29).TexturePrimitive).prototype.dispose.call(this),this.boundingBoxUpdateRequired=!0};//Expand the boundingbox with slide settings
var expandBoxWithSettings=(box,settings,vector)=>{if(settings)switch(settings.direction.value){case 1:vector.copy(settings.slide.value),box.expandByPoint(vector),vector.setY(1),vector.setZ(1),box.expandByPoint(vector);break;case 2:vector.copy(settings.slide.value),box.expandByPoint(vector),vector.setX(1),vector.setZ(1),box.expandByPoint(vector);break;case 3:vector.copy(settings.slide.value),box.expandByPoint(vector),vector.setX(1),vector.setY(1),box.expandByPoint(vector);break;default:}};/**
   * Get the bounding box of this slides.
   * It uses the max and min of the slides position and the
   * transformation to calculate the position of the box.
   *
   * @return {THREE.Box3}.
   */this.getBoundingBox=()=>{if(this.morph&&this.morph.children&&this.morph.visible&&this.boundingBoxUpdateRequired){this.cachedBoundingBox.makeEmpty();var vector=new THREE.Vector3(0,0,0);this.morph.children.forEach(slide=>{expandBoxWithSettings(this.cachedBoundingBox,slide.material.uniforms,vector)}),this.morph.updateMatrixWorld(!0,!0),this.cachedBoundingBox.applyMatrix4(this.morph.matrixWorld),this.boundingBoxUpdateRequired=!1}return this.cachedBoundingBox},this.applyTransformation=(rotation,position,scale)=>{var matrix=new THREE.Matrix4;matrix.set(rotation[0],rotation[1],rotation[2],0,rotation[3],rotation[4],rotation[5],0,rotation[6],rotation[7],rotation[8],0,0,0,0,0);var quaternion=new THREE.Quaternion().setFromRotationMatrix(matrix);this.morph.position.set(...position),this.morph.quaternion.copy(quaternion),this.morph.scale.set(...scale),this.morph.updateMatrix(),this.boundingBoxUpdateRequired=!0},this.setRenderOrder=order=>{//multiilayers
this.morph.renderOrder=order},this.initialise=(textureData,finishCallback)=>{if(textureData){var locations=textureData.locations;locations&&0<locations.length&&(this.applyTransformation(locations[0].orientation,locations[0].position,locations[0].scale),"flipY"in locations[0]&&(flipY=locations[0].flipY)),this.createSlides(textureData.settings.slides),finishCallback!=null&&"function"==typeof finishCallback&&finishCallback(this)}},this.showEdges=color=>{if(!edgesLine){var geometry=new THREE.BoxGeometry(1,1,1);geometry.translate(.5,.5,.5);var edges=new THREE.EdgesGeometry(geometry);edgesLine=new THREE.LineSegments(edges,new THREE.LineBasicMaterial({color})),this.group.add(edgesLine)}else edgesLine.material.color=color;edgesLine.visible=!0},this.hideEdges=()=>{edgesLine&&(edgesLine.visible=!1)}};/**
 * Provides a class which create a texture stacks in a block
 * with shaders allowing slices of texture to be displayed.
 *
 * @param {TextureArray} textureIn - An object of texture array
 * holding texture information.
 *
 * @class
 * @author Alan Wu
 * @return {TextureSlides}
 */TextureSlides.prototype=Object.create((__webpack_require__(29).TexturePrimitive).prototype),TextureSlides.prototype.constructor=TextureSlides,exports.TextureSlides=TextureSlides;

/***/ }),
/* 28 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),glslVersion=THREE.GLSL3,fs="\nprecision highp float;\nprecision highp int;\nprecision highp sampler2DArray;\n\nuniform sampler2DArray diffuse;\nuniform bool discardAlpha;\nin vec3 vUw;\n\nout vec4 outColor;\n\nvoid main() {\n\n  vec4 color = texture( diffuse, vUw );\n\n  // lighten a bit\n  if (discardAlpha && color.a == 0.0) discard;\n\n  outColor = vec4( color.rgba );\n\n}\n",vs="\nout vec3 vUw;\nuniform float depth;\nuniform vec3 slide;\nuniform int direction;\nuniform bool flipY;\n\nvoid main() {\n\n  vec3 slidePos = position.xyz;\n  gl_Position = projectionMatrix * modelViewMatrix * vec4( position.xyz, 1.0 );\n\n  if (direction == 1)\n    slidePos = vec3(slide.x, position.y, position.x);\n  if (direction == 2)\n    slidePos = vec3(position.x, slide.y, position.y);\n  if (direction == 3)\n    slidePos = vec3(position.x, position.y, slide.z);\n\n  if (flipY) \n    slidePos.y = 1.0 - slidePos.y;\n\n  vUw.xyz = vec3(slidePos.x, slidePos.y, slidePos.z * depth);\n\n}\n",getUniforms=function(){return{diffuse:{value:void 0},depth:{value:1},slide:{value:new THREE.Vector3(0,0,1)},direction:{value:1},flipY:{value:!0},discardAlpha:{value:!0}}};exports.fs=fs,exports.vs=vs,exports.glslVersion=glslVersion,exports.getUniforms=getUniforms;

/***/ }),
/* 29 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),resolveURL=(__webpack_require__(5).resolveURL),TexturePrimitive=function(textureIn){/**
   * Load texture data into this primitves.
   *
   * @param {Object} textureData - contains the informations about the textures.
   * @param {Function} finishCallback - User's function to be called once texture's
   *  is loaded.
   */ /**
   * Initialise a texture based on the provided textureData, this should be used
   * internally only.
   *
   * @param {Object} textureData - contains the informations about the textures.
   * @param {Function} finishCallback - User's function to be called once texture's
   *  is loaded.
   */(__webpack_require__(10).ZincObject).call(this),this.isTexturePrimitive=!0,this.texture=textureIn,this.load=(textureData,finishCallback)=>{if(textureData&&textureData.images&&textureData.images.source){var texture=new((__webpack_require__(25).TextureArray)),imgArray=[];textureData.images.source.forEach(img=>{imgArray.push(resolveURL(img))});var _this=this;texture.loadFromImages(imgArray).then(()=>{_this.texture=texture,_this.initialise(textureData,finishCallback)})}},this.initialise=(textureData,finishCallback)=>{finishCallback!=null&&"function"==typeof finishCallback&&finishCallback(this)}};/**
 * Provides a base class object which stores textures and rendering object.
 *
 * @class
 * @author Alan Wu
 * @return {TexturePrimitive}
 */TexturePrimitive.prototype=Object.create((__webpack_require__(10).ZincObject).prototype),TexturePrimitive.prototype.constructor=TexturePrimitive,exports.TexturePrimitive=TexturePrimitive;

/***/ }),
/* 30 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),ResizeSensor=__webpack_require__(31);/**
 * Create a Zinc 3D renderer in the container provided.
 * The primary function of a Zinc 3D renderer is to display the current
 * scene (@link Scene} set to the renderer and each scene may contain as
 * many geometries, glyphset and other primitives as the system can support.
 * Zinc.Renderer also allows additional scenes to be displayed.
 *
 * @param {Object} containerIn - Container to create the renderer on.
 * @class
 * @author Alan Wu
 * @return {Renderer}
 */exports.Renderer=function(containerIn){var container=containerIn,renderer=void 0,currentScene=void 0,clock=new THREE.Clock(!1);//myGezincGeometriestains a tuple of the threejs mesh, timeEnabled, morphColour flag, unique id and morph
this.playAnimation=!0;/* default animation update rate, rate is 1000 and duration
    is default to 6000, 6s to finish a full animation */var playRate=1e3,preRenderCallbackFunctions={},preRenderCallbackFunctions_id=0,postRenderCallbackFunctions={},postRenderCallbackFunctions_id=0,contextLostCallbackFunctions={},contextLostCallbackFunctions_id=0,contextRestoredCallbackFunctions={},contextRestoredCallbackFunctions_id=0,animated_id=void 0,cameraOrtho=void 0,sceneOrtho=void 0,logoSprite=void 0,sceneMap=[],additionalActiveScenes=[],scenesGroup=new THREE.Group,canvas=void 0,sensor=void 0,isRendering=!1,isInitialised=!1,currentSize=[0,0],currentOffset=[0,0];this.getDrawingWidth=()=>{if(container)return container.clientWidth;return canvas?"undefined"==typeof canvas.clientWidth?Math.round(canvas.width):Math.round(canvas.clientWidth):0},this.getDrawingHeight=()=>{if(container)return container.clientHeight;return canvas?"undefined"==typeof canvas.clientHeight?Math.round(canvas.height):Math.round(canvas.clientHeight):0},this.onWindowResize=()=>{currentScene.onWindowResize();var width=this.getDrawingWidth(),height=this.getDrawingHeight();if(renderer!=null){var localRect;container?(localRect=container.getBoundingClientRect(),renderer.setSize(width,height)):canvas&&("undefined"==typeof canvas.getBoundingClientRect?renderer.setSize(width,height,!1):(localRect=canvas.getBoundingClientRect(),canvas.width=width,canvas.height=height,renderer.setSize(width,height,!1))),localRect&&(currentOffset[0]=localRect.left,currentOffset[1]=localRect.top);var target=new THREE.Vector2;renderer.getSize(target),currentSize[0]=target.x,currentSize[1]=target.y}},this.initialiseVisualisation=parameters=>{if(!isInitialised){if(parameters=parameters||{},void 0===parameters.antialias){var onMobile=!1;try{/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)&&(onMobile=!0)}catch(err){onMobile=!1}parameters.antialias=!onMobile}parameters.canvas&&(container=void 0,canvas=parameters.canvas),renderer=new THREE.WebGLRenderer(parameters),void 0!==container&&container.appendChild(renderer.domElement),renderer.setClearColor(16777215,1),canvas&&canvas.style&&(canvas.style.height="100%",canvas.style.width="100%");var domCanvas=renderer.domElement;domCanvas.addEventListener("webglcontextlost",onContextLost,!1),domCanvas.addEventListener("webglcontextrestored",onContextRestored,!1),renderer.autoClear=!1;var scene=this.createScene("default");this.setCurrentScene(scene),isInitialised=!0}};var onContextLost=event=>{event.preventDefault();for(var key of Object.keys(preRenderCallbackFunctions))contextLostCallbackFunctions.hasOwnProperty(key)&&contextLostCallbackFunctions[key].call()},onContextRestored=event=>{event.preventDefault();for(var key of Object.keys(preRenderCallbackFunctions))contextRestoredCallbackFunctions.hasOwnProperty(key)&&contextRestoredCallbackFunctions[key].call()};/**
	 * Get the current scene on display.
	 * @return {Zinc.Scene};
	 */this.getCurrentScene=()=>currentScene,this.setCurrentScene=sceneIn=>{if(sceneIn){this.removeActiveScene(sceneIn);var oldScene=currentScene;currentScene=sceneIn,oldScene&&oldScene.setInteractiveControlEnable(!1),currentScene.setInteractiveControlEnable(!0),currentScene.setAdditionalScenesGroup(scenesGroup),this.onWindowResize()}},this.getSceneByName=name=>sceneMap[name],this.createScene=name=>{if(null==sceneMap[name]){var new_scene;return new_scene=canvas?new((__webpack_require__(32).Scene))(canvas,renderer):new((__webpack_require__(32).Scene))(container,renderer),sceneMap[name]=new_scene,new_scene.sceneName=name,new_scene}};/**
	 * Reset the viewport of the current scene to its original state.
	 */this.resetView=()=>{currentScene.resetView()},this.viewAll=()=>{if(currentScene){var boundingBox=currentScene.getBoundingBox();if(boundingBox){for(var boundingBox2,i=0;i<additionalActiveScenes.length;i++)boundingBox2=additionalActiveScenes[i].getBoundingBox(),boundingBox2&&boundingBox.union(boundingBox2);currentScene.viewAllWithBoundingBox(boundingBox)}}},this.loadModelsURL=(urls,colours,opacities,timeEnabled,morphColour,finishCallback)=>{currentScene.loadModelsURL(urls,colours,opacities,timeEnabled,morphColour,finishCallback)};/**
	 * Load the viewport from an external location provided by the url. This should be
	 * called from {@link Zinc.Scene};
	 * @param {String} URL - address to the file containing viewport information.
	 * @deprecated
	 */this.loadViewURL=url=>{currentScene.loadViewURL(url)},this.loadFromViewURL=(jsonFilePrefix,finishCallback)=>{currentScene.loadFromViewURL(jsonFilePrefix,finishCallback)},this.updateDirectionalLight=()=>{currentScene.updateDirectionalLight()};var runAnimation=()=>{isRendering?(animated_id=requestAnimationFrame(runAnimation),this.render()):(cancelAnimationFrame(animated_id),animated_id=void 0)};/**
	 * Stop the animation and renderer to get into the render loop.
	 */this.stopAnimate=()=>{isRendering&&(clock.stop(),isRendering=!1)},this.animate=()=>{isRendering||(clock.start(),isRendering=!0,runAnimation())};Date.now();/**
	 * Add a callback function which will be called when the gl context is lost.
	 * @param {Function} callbackFunction - callbackFunction to be added.
	 *
	 * @return {Number}
	 */this.addContextLostCallbackFunction=callbackFunction=>(++contextLostCallbackFunctions_id,contextLostCallbackFunctions[contextLostCallbackFunctions_id]=callbackFunction,contextLostCallbackFunctions_id),this.removeContextLostCallbackFunction=id=>{id in contextLostCallbackFunctions&&delete contextLostCallbackFunctions[id]},this.addContextRestoredCallbackFunction=callbackFunction=>(++contextRestoredCallbackFunctions_id,contextRestoredCallbackFunctions[contextRestoredCallbackFunctions_id]=callbackFunction,contextRestoredCallbackFunctions_id),this.removeContextRestoredCallbackFunction=id=>{id in contextRestoredCallbackFunctions_id&&delete contextRestoredCallbackFunctions_id[id]},this.addPreRenderCallbackFunction=callbackFunction=>(++preRenderCallbackFunctions_id,preRenderCallbackFunctions[preRenderCallbackFunctions_id]=callbackFunction,preRenderCallbackFunctions_id),this.removePreRenderCallbackFunction=id=>{id in preRenderCallbackFunctions&&delete preRenderCallbackFunctions[id]},this.addPostRenderCallbackFunction=callbackFunction=>(++postRenderCallbackFunctions_id,postRenderCallbackFunctions[postRenderCallbackFunctions_id]=callbackFunction,postRenderCallbackFunctions_id),this.removePostRenderCallbackFunction=id=>{id in postRenderCallbackFunctions&&delete postRenderCallbackFunctions[id]},this.getPlayRate=()=>playRate,this.setPlayRate=playRateIn=>{playRate=playRateIn},this.getCurrentTime=()=>currentScene.getCurrentTime(),this.setMorphsTime=time=>{currentScene.setMorphsTime(time)},this.getZincGeometryByID=id=>currentScene.getZincGeometryByID(id),this.addToScene=object=>{currentScene.addObject(object)},this.addToOrthoScene=object=>{if(null==sceneOrtho&&(sceneOrtho=new THREE.Scene),null==cameraOrtho){var width=this.getDrawingWidth(),height=this.getDrawingHeight();cameraOrtho=new THREE.OrthographicCamera(-width/2,width/2,height/2,-height/2,1,10),cameraOrtho.position.z=10}sceneOrtho.add(object)};var createHUDSprites=logoSprite=>texture=>{texture.needsUpdate=!0;var material=new THREE.SpriteMaterial({map:texture}),imagewidth=material.map.image.width,imageheight=material.map.image.height;logoSprite.material=material,logoSprite.scale.set(imagewidth,imageheight,1);var width=this.getDrawingWidth(),height=this.getDrawingHeight();logoSprite.position.set((width-imagewidth)/2,(-height+imageheight)/2,1),this.addToOrthoScene(logoSprite)};/**
	 * Render the current and all additional scenes. It will first update all geometries and glyphsets
	 * in scenes, clear depth buffer and render the ortho scene, call the preRenderCallbackFunctions stack
	 * , render the scenes then postRenderCallback.
	 */ /**
	 * Get the internal {@link Three.Renderer}, to gain access to ThreeJS APIs.
	 */ /**
	 * Check if a scene is currently active.
	 * @param {Zinc.Scene} sceneIn - Scene to check if it is currently
	 * rendered.
	 */ /**
	 * Add additional active scene for rendering, this scene will also be rendered but
	 * viewport of the currentScene will be used.
	 * @param {Zinc.Scene} additionalScene - Scene to be added to the rendering.
	 */ /**
	 * Remove a currenrtly active scene from the renderer, this scene will also be rendered but
	 * viewport of the currentScene will be used.
	 * @param {Zinc.Scene} additionalScene - Scene to be removed from rendering.
	 */ /**
	 * Clear all additional scenes from rendering except for curentScene.
	 */ /**
   * Dispose all memory allocated, this will effetively destroy all scenes.
   */ /**
	 * Transition from the current viewport to the endingScene's viewport in the specified duration.
	 *
	 * @param {Zinc.Scene} endingScene - Viewport of this scene will be used as the destination.
	 * @param {Number} duration - Amount of time to transition from current viewport to the
	 * endingScene's viewport.
	 */this.addLogo=()=>{logoSprite=new THREE.Sprite;THREE.ImageUtils.loadTexture("images/abi_big_logo_transparent_small.png",void 0,createHUDSprites(logoSprite))},this.render=()=>{sensor||(container?0<container.clientWidth&&0<container.clientHeight&&(sensor=new ResizeSensor(container,this.onWindowResize)):canvas&&0<canvas.width&&0<canvas.height&&(sensor=new ResizeSensor(canvas,this.onWindowResize)));var delta=clock.getDelta();currentScene.renderGeometries(playRate,delta,this.playAnimation);for(var sceneItem,i=0;i<additionalActiveScenes.length;i++)sceneItem=additionalActiveScenes[i],sceneItem.renderGeometries(playRate,delta,this.playAnimation);cameraOrtho!=null&&sceneOrtho!=null&&(renderer.clearDepth(),renderer.render(sceneOrtho,cameraOrtho));for(var key of Object.keys(preRenderCallbackFunctions))preRenderCallbackFunctions.hasOwnProperty(key)&&preRenderCallbackFunctions[key].call();currentScene.render(renderer);for(var _key of Object.keys(postRenderCallbackFunctions))postRenderCallbackFunctions.hasOwnProperty(_key)&&postRenderCallbackFunctions[_key].call()},this.forceContextLoss=()=>{renderer.forceContextLoss()},this.forceContextRestore=()=>{renderer.forceContextRestore()},this.getThreeJSRenderer=()=>renderer,this.isSceneActive=sceneIn=>{if(currentScene===sceneIn)return!0;for(var sceneItem,i=0;i<additionalActiveScenes.length;i++)if(sceneItem=additionalActiveScenes[i],sceneItem===sceneIn)return!0;return!1},this.addActiveScene=additionalScene=>{this.isSceneActive(additionalScene)||(additionalActiveScenes.push(additionalScene),scenesGroup.add(additionalScene.getThreeJSScene()))},this.removeActiveScene=additionalScene=>{for(var sceneItem,i=0;i<additionalActiveScenes.length;i++)if(sceneItem=additionalActiveScenes[i],sceneItem===additionalScene)return additionalActiveScenes.splice(i,1),void scenesGroup.remove(additionalScene.getThreeJSScene())},this.clearAllActiveScene=()=>{for(var i=0;i<additionalActiveScenes.length;i++)scenesGroup.remove(additionalActiveScenes[i].getThreeJSScene());additionalActiveScenes.splice(0,additionalActiveScenes.length)},this.dispose=()=>{var _renderer;for(var key in isRendering&&cancelAnimationFrame(animated_id),sceneMap)sceneMap.hasOwnProperty(key)&&sceneMap[key].clearAll();sceneMap=[],additionalActiveScenes=[],scenesGroup=new THREE.Group,this.stopAnimate(),preRenderCallbackFunctions={},preRenderCallbackFunctions_id=0,postRenderCallbackFunctions={},postRenderCallbackFunctions=0,contextLostCallbackFunctions={},contextLostCallbackFunctions_id=0,contextRestoredCallbackFunctions={},contextRestoredCallbackFunctions_id=0,cameraOrtho=void 0,sceneOrtho=void 0,logoSprite=void 0;var scene=this.createScene("default");this.setCurrentScene(scene),sensor=void 0,null===(_renderer=renderer)||void 0===_renderer||_renderer.dispose()},this.transitionScene=(endingScene,duration)=>{if(currentScene){var currentCamera=currentScene.getZincCameraControls(),boundingBox=endingScene.getBoundingBox();if(boundingBox){var radius=boundingBox.min.distanceTo(boundingBox.max)/2,centreX=(boundingBox.min.x+boundingBox.max.x)/2,centreY=(boundingBox.min.y+boundingBox.max.y)/2,centreZ=(boundingBox.min.z+boundingBox.max.z)/2,endingViewport=currentCamera.getViewportFromCentreAndRadius(centreX,centreY,centreZ,radius,40,radius*4),startingViewport=currentCamera.getCurrentViewport();currentCamera.cameraTransition(startingViewport,endingViewport,duration),currentCamera.enableCameraTransition()}}},this.isWebGL2=()=>!!renderer&&renderer.capabilities.isWebGL2};

/***/ }),
/* 31 */
/***/ ((module) => {

"use strict";
module.exports = require("css-element-queries/src/ResizeSensor");

/***/ }),
/* 32 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),MarkerCluster=(__webpack_require__(33).MarkerCluster),SceneLoader=(__webpack_require__(35).SceneLoader),SceneExporter=(__webpack_require__(42).SceneExporter),Viewport=(__webpack_require__(44).Viewport),createBufferGeometry=(__webpack_require__(5).createBufferGeometry),getCircularTexture=(__webpack_require__(5).getCircularTexture),createNewSpriteText=(__webpack_require__(5).createNewSpriteText),uniqueiId=0,getUniqueId=function(){return"sc"+uniqueiId++},defaultMetadata=function(){return{Duration:"6 secs",OriginalDuration:"-",TimeStamps:{}}},defaultDuration=6e3;/**
 * A Scene contains {@link Region},and 
 * {@link CameraControls} which controls the viewport and additional features.
 * It is the main object used for controlling what is and what is not displayed
 * on the renderer.
 * 
 * @class
 * @param {Object} containerIn - Container to create the renderer on.
 * @author Alan Wu
 * @return {Scene}
 */exports.Scene=function(containerIn,rendererIn){var _this=this,container=containerIn,videoHandler=void 0,sceneLoader=new SceneLoader(this),minimap=void 0,zincObjectAddedCallbacks={},zincObjectAddedCallbacks_id=0,zincObjectRemovedCallbacks={},zincObjectRemovedCallbacks_id=0,scene=new THREE.Scene,miniAxesScene=new THREE.Scene,rootRegion=new((__webpack_require__(45).Region))(void 0,this);scene.add(rootRegion.getGroup());var tempGroup=new THREE.Group;scene.add(tempGroup),this.directionalLight=void 0,this.ambient=void 0,this.camera=void 0;var duration=6e3,zincCameraControls=void 0;this.sceneName=void 0;var stereoEffectFlag=!1,stereoEffect=void 0;this.autoClearFlag=!0,this.displayMarkers=!1,this.displayMinimap=!1,this.displayMiniAxes=!1,this.minimapScissor={x_offset:16,y_offset:16,width:128,height:128,align:"top-right",updateRequired:!0};var scissor={x:0,y:0},metadata=defaultMetadata(),_markerTarget=new THREE.Vector2,pickableObjectsList=[];this.forcePickableObjectsUpdate=!1,this.uuid=getUniqueId();var markerCluster=new MarkerCluster(this);markerCluster.disable(),scene.add(markerCluster.group);var axisDisplay={main:[],mini:[]},_v3=new THREE.Vector3(0,0,0),getDrawingWidth=()=>container?"undefined"==typeof container.clientWidth?container.width:container.clientWidth:0,getDrawingHeight=()=>container?"undefined"==typeof container.clientHeight?container.height:container.clientHeight:0;/**
   * This function returns a three component array, which contains
   * [totalsize, totalLoaded and errorDownload] of all the downloads happening
   * in this scene.
   * @returns {Array} 
   */this.getDownloadProgress=()=>sceneLoader.getDownloadProgress(),this.onWindowResize=()=>{var wHeight=getDrawingHeight();this.camera.aspect=getDrawingWidth()/wHeight,this.camera.updateProjectionMatrix(),this.minimapScissor.updateRequired=!0,zincCameraControls.onResize(),zincCameraControls.calculateHeightPerPixelAtZeroDepth(wHeight)},this.resetView=()=>{this.onWindowResize(),zincCameraControls.resetView()},this.changeZoomByScrollRateUnit=unit=>{zincCameraControls.changeZoomByScrollRateUnit(unit)};//Setup the camera for this scene, it also initialise the lighting
var setupCamera=()=>{this.camera=new THREE.PerspectiveCamera(40,getDrawingWidth()/getDrawingHeight(),0,10),this.ambient=new THREE.AmbientLight(16777215,.2),scene.add(this.ambient),this.directionalLight=new THREE.DirectionalLight(16777215,.8),scene.add(this.directionalLight),zincCameraControls=new((__webpack_require__(44).CameraControls))(this.camera,rendererIn.domElement,rendererIn,this),zincCameraControls.setDirectionalLight(this.directionalLight),zincCameraControls.resetView(),minimap=new((__webpack_require__(50).Minimap))(this)};setupCamera(),this.loadView=settings=>{var viewPort=new Viewport;return viewPort.setFromObject(settings),zincCameraControls.setCurrentCameraSettings(viewPort),!0},this.setupMultipleViews=(defaultView,entries)=>{for(var[name,settings]of Object.entries(entries)){var viewport=new Viewport;viewport.setFromObject(settings),zincCameraControls.addViewport(name,viewport)}zincCameraControls.setDefaultViewport(defaultView)},this.getBoundingBox=()=>rootRegion.getBoundingBox(!0),this.viewAllWithBoundingBox=boundingBox=>{if(boundingBox){var viewport=zincCameraControls.getViewportFromBoundingBox(boundingBox,1);zincCameraControls.setCurrentCameraSettings(viewport),zincCameraControls.calculateHeightPerPixelAtZeroDepth(getDrawingHeight()),markerCluster.markerUpdateRequired=!0}},this.viewAll=()=>{var boundingBox=this.getBoundingBox();this.viewAllWithBoundingBox(boundingBox),markerCluster.markerUpdateRequired=!0},this.forEachGeometry=callbackFunction=>{rootRegion.forEachGeometry(callbackFunction,!0)},this.forEachGlyphset=callbackFunction=>{rootRegion.forEachGlyphset(callbackFunction,!0)},this.forEachPointset=callbackFunction=>{rootRegion.forEachPointset(callbackFunction,!0)},this.forEachLine=callbackFunction=>{rootRegion.forEachLine(callbackFunction,!0)},this.findGeometriesWithGroupName=GroupName=>rootRegion.findGeometriesWithGroupName(GroupName,!0),this.findPointsetsWithGroupName=GroupName=>rootRegion.findPointsetsWithGroupName(GroupName,!0),this.findGlyphsetsWithGroupName=GroupName=>rootRegion.findGlyphsetsWithGroupName(GroupName,!0),this.findLinesWithGroupName=GroupName=>rootRegion.findLinesWithGroupName(GroupName,!0),this.findObjectsWithGroupName=GroupName=>rootRegion.findObjectsWithGroupName(GroupName,!0),this.findObjectsWithAnatomicalId=anatomicalId=>rootRegion.findObjectsWithAnatomicalId(anatomicalId,!0),this.getBoundingBoxOfZincObjects=objectsArray=>{for(var box,boundingBox=void 0,i=0;i<objectsArray.length;i++)box=objectsArray[i].getBoundingBox(),box&&(boundingBox?boundingBox.union(box):boundingBox=box);return boundingBox},this.vectorToScreenXY=point=>{point.project(this.camera);var width=getDrawingWidth(),height=getDrawingHeight(),widthHalf=width/2,heightHalf=height/2;return point.x=point.x*widthHalf+widthHalf,point.y=-(point.y*heightHalf)+heightHalf,point},this.getObjectsScreenXY=zincObjects=>{if(zincObjects&&0<zincObjects.length){var boundingBox=this.getBoundingBoxOfZincObjects(zincObjects),center=new THREE.Vector3;return boundingBox.getCenter(center),this.vectorToScreenXY(center)}},this.getNamedObjectsScreenXY=name=>{var zincObjects=this.findObjectsWithGroupName(name);return this.getObjectsScreenXY(zincObjects)},this.addZincObject=zincObject=>{zincObject&&(rootRegion.addZincObject(zincObject),zincCameraControls&&zincCameraControls.calculateMaxAllowedDistance(this))},this.loadGlyphsetURL=(metaurl,glyphurl,groupName,finishCallback)=>{sceneLoader.loadGlyphsetURL(rootRegion,metaurl,glyphurl,groupName,finishCallback)},this.loadPointsetURL=(url,timeEnabled,morphColour,groupName,finishCallback)=>{sceneLoader.loadPointsetURL(rootRegion,url,timeEnabled,morphColour,groupName,finishCallback)},this.loadLinesURL=(url,timeEnabled,morphColour,groupName,finishCallback)=>{sceneLoader.loadLinesURL(rootRegion,url,timeEnabled,morphColour,groupName,finishCallback)},this.loadSTL=(url,groupName,finishCallback)=>{sceneLoader.loadSTL(rootRegion,url,groupName,finishCallback)},this.loadOBJ=(url,groupName,finishCallback)=>{sceneLoader.loadOBJ(rootRegion,url,groupName,finishCallback)},this.loadMetadataURL=(url,finishCallback,allCompletedCallback,options)=>{sceneLoader.loadMetadataURL(rootRegion,url,finishCallback,allCompletedCallback,options)},this.loadModelsURL=(urls,colours,opacities,timeEnabled,morphColour,finishCallback)=>{sceneLoader.loadModelsURL(rootRegion.urls,colours,opacities,timeEnabled,morphColour,finishCallback)},this.loadViewURL=url=>{sceneLoader.loadViewURL(url)},this.loadFromViewURL=(jsonFilePrefix,finishCallback)=>{sceneLoader.loadFromViewURL(jsonFilePrefix,finishCallback)},this.loadGLTF=(url,finishCallback,allCompletedCallback,options)=>{sceneLoader.loadGLTF(rootRegion,url,finishCallback,allCompletedCallback,options)},this.updateDirectionalLight=()=>{zincCameraControls.updateDirectionalLight()},this.addObject=object=>{scene.add(object)},this.removeObject=object=>{scene.remove(object)},this.getCurrentTime=()=>{if(videoHandler!=null)return videoHandler.getCurrentTime(duration);var time=rootRegion.getCurrentTime();return-1===time?0:time},this.setMorphsTime=time=>{videoHandler!=null&&videoHandler.setMorphTime(time,duration),rootRegion.setMorphTime(time,!0)},this.isTimeVarying=()=>!!(videoHandler&&videoHandler.video&&!videoHandler.video.error)||rootRegion.isTimeVarying(),this.renderGeometries=(playRate,delta,playAnimation)=>{// Let video dictates the progress if one is present
var options={};if(options.camera=zincCameraControls,options.displayMarkers=this.displayMarkers,options.markerCluster=markerCluster,options.markersList=markerCluster.markers,options.ndcToBeUpdated=!1,playAnimation&&(options.markerCluster.markerUpdateRequired=!0),!videoHandler)0==sceneLoader.toBeDownloaded?(options.ndcToBeUpdated=zincCameraControls.update(delta),options.ndcToBeUpdated&&zincCameraControls.calculateHeightPerPixelAtZeroDepth(getDrawingHeight()),rootRegion.renderGeometries(playRate,delta,playAnimation,zincCameraControls,options,!0)):zincCameraControls.update(0);else if(videoHandler.isReadyToPlay()){playAnimation?videoHandler.video.play():videoHandler.video.pause();var currentTime=videoHandler.video.currentTime/videoHandler.getVideoDuration()*duration;0==sceneLoader.toBeDownloaded?(zincCameraControls.setTime(currentTime),options.ndcToBeUpdated=zincCameraControls.update(0),options.ndcToBeUpdated&&zincCameraControls.calculateHeightPerPixelAtZeroDepth(getDrawingHeight()),rootRegion.setMorphTime(currentTime,!0),rootRegion.renderGeometries(0,0,playAnimation,zincCameraControls,options,!0)):zincCameraControls.update(0)}else myPlayRate=0},this.getThreeJSScene=()=>scene,this.setVideoHandler=videoHandlerIn=>{videoHandler||(videoHandler=videoHandlerIn)},this.setAdditionalScenesGroup=scenesGroup=>{scene.add(scenesGroup)};var getWindowsPosition=(align,x_offset,y_offset,width,height,renderer_width,renderer_height)=>{var x=0,y=0;return y=align.includes("top")?renderer_height-height-y_offset:align.includes("bottom")?y_offset:Math.floor((renderer_height-height)/2),x=align.includes("left")?x_offset:align.includes("right")?renderer_width-x_offset-width:Math.floor((renderer_width-width)/2),{x:x,y:y}},renderMinimap=renderer=>{(this.displayMinimap||this.displayMiniAxes)&&(renderer.setScissorTest(!0),renderer.getSize(_markerTarget),this.minimapScissor.updateRequired&&(scissor=getWindowsPosition(this.minimapScissor.align,this.minimapScissor.x_offset,this.minimapScissor.y_offset,this.minimapScissor.width,this.minimapScissor.height,_markerTarget.x,_markerTarget.y),this.minimapScissor.updateRequired=!1),renderer.setScissor(scissor.x,scissor.y,this.minimapScissor.width,this.minimapScissor.height),renderer.setViewport(scissor.x,scissor.y,this.minimapScissor.width,this.minimapScissor.height),minimap.updateCamera(),this.displayMiniAxes?renderer.render(miniAxesScene,minimap.camera):(scene.add(minimap.mask),renderer.render(scene,minimap.camera),scene.remove(minimap.mask)),renderer.setScissorTest(!1),renderer.setViewport(0,0,_markerTarget.x,_markerTarget.y))};/**
   * Render the scene.
   * @private
   */this.render=renderer=>{this.autoClearFlag&&renderer.clear(),stereoEffectFlag&&stereoEffect?stereoEffect.render(scene,this.camera):(renderer.render(scene,this.camera),renderMinimap(renderer))},this.setInteractiveControlEnable=flag=>{!0==flag?zincCameraControls.enable():zincCameraControls.disable()},this.getZincCameraControls=()=>zincCameraControls,this.getThreeJSScene=()=>scene,this.setDuration=durationIn=>{rootRegion.setDuration(durationIn),duration=durationIn,zincCameraControls.setPathDuration(durationIn),sceneLoader.duration=durationIn},this.getDuration=()=>duration,this.setStereoEffectEnable=stereoFlag=>{!0!=stereoFlag||stereoEffect||(stereoEffect=new __webpack_require__(44).StereoEffect(rendererIn)),rendererIn.setSize(getDrawingWidth(),getDrawingHeight()),this.camera.updateProjectionMatrix(),stereoEffectFlag=stereoFlag},this.objectIsInScene=zincObject=>rootRegion.objectIsInRegion(zincObject,!0),this.alignBoundingBoxToCameraView=(boundingBox,transitionTime)=>{if(boundingBox){boundingBox.getCenter(_v3);var viewport=this.getZincCameraControls().getCurrentViewport(),target=new THREE.Vector3(viewport.targetPosition[0],viewport.targetPosition[1],viewport.targetPosition[2]),eyePosition=new THREE.Vector3(viewport.eyePosition[0],viewport.eyePosition[1],viewport.eyePosition[2]),newVec1=new THREE.Vector3,newVec2=new THREE.Vector3;newVec1.subVectors(target,eyePosition).normalize(),newVec2.subVectors(target,_v3).normalize();var newVec3=new THREE.Vector3;newVec3.crossVectors(newVec1,newVec2);var angle=newVec1.angleTo(newVec2);0<transitionTime?(this.getZincCameraControls().rotateCameraTransition(newVec3,angle,transitionTime),this.getZincCameraControls().enableCameraTransition()):this.getZincCameraControls().rotateAboutLookAtpoint(newVec3,angle),markerCluster.markerUpdateRequired=!0}},this.translateBoundingBoxToCameraView=(boundingBox,scaleRadius,transitionTime)=>{if(boundingBox){var oldViewport=this.getZincCameraControls().getCurrentViewport(),viewport=this.getZincCameraControls().getViewportFromBoundingBox(boundingBox,scaleRadius);0<transitionTime&&(this.getZincCameraControls().cameraTransition(oldViewport,viewport,transitionTime),this.getZincCameraControls().enableCameraTransition()),markerCluster.markerUpdateRequired=!0}},this.alignObjectToCameraView=(zincObject,transitionTime)=>{if(this.objectIsInScene(zincObject)){var boundingBox=zincObject.getBoundingBox();this.alignBoundingBoxToCameraView(boundingBox,transitionTime)}},this.setCameraTargetToObject=zincObject=>{if(this.objectIsInScene(zincObject)){var boundingBox=zincObject.getBoundingBox(),viewport=this.getZincCameraControls().getCurrentViewport();boundingBox.getCenter(_v3);var target=new THREE.Vector3(viewport.targetPosition[0],viewport.targetPosition[1],viewport.targetPosition[2]),eyePosition=new THREE.Vector3(viewport.eyePosition[0],viewport.eyePosition[1],viewport.eyePosition[2]),newVec1=new THREE.Vector3,newVec2=new THREE.Vector3;newVec1.subVectors(eyePosition,target),newVec2.addVectors(_v3,newVec1),viewport.eyePosition[0]=newVec2.x,viewport.eyePosition[1]=newVec2.y,viewport.eyePosition[2]=newVec2.z,viewport.targetPosition[0]=_v3.x,viewport.targetPosition[1]=_v3.y,viewport.targetPosition[2]=_v3.z,this.getZincCameraControls().setCurrentCameraSettings(viewport),markerCluster.markerUpdateRequired=!0}},this.isStereoEffectEnable=()=>stereoEffectFlag,this.removeZincObject=zincObject=>{rootRegion.removeZincObject(zincObject),zincCameraControls&&zincCameraControls.calculateMaxAllowedDistance(this),markerCluster.markerUpdateRequired=!0},this.updatePickableThreeJSObjects=()=>{pickableObjectsList.length=0,markerCluster.isEnabled&&pickableObjectsList.push(markerCluster.group),rootRegion.getPickableThreeJSObjects(pickableObjectsList,!0),this.forcePickableObjectsUpdate=!1},this.getPickableThreeJSObjects=()=>((this.forcePickableObjectsUpdate||rootRegion.checkPickableUpdateRequred(!0))&&this.updatePickableThreeJSObjects(),pickableObjectsList),this.getNormalisedMinimapCoordinates=(renderer,event)=>{if(this.displayMinimap){var target=new THREE.Vector2;renderer.getSize(target);var offsetY=target.y-event.clientY;if(scissor.x+this.minimapScissor.width>event.clientX&&event.clientX>scissor.x&&scissor.y+this.minimapScissor.height>offsetY&&offsetY>scissor.y){var x=2*((event.clientX-scissor.x)/this.minimapScissor.width)-1,y=2*((offsetY-scissor.y)/this.minimapScissor.height)-1;return{x:x,y:y}}}},this.getMinimapDiffFromNormalised=(x,y)=>minimap?minimap.getDiffFromNormalised(x,y):void 0,this.isWebGL2=()=>rendererIn.isWebGL2(),this.clearAll=()=>{markerCluster.clear(),rootRegion.clear(!0),this.clearZincObjectAddedCallbacks(),this.clearZincObjectRemovedCallbacks(),sceneLoader.toBeDwonloaded=0,zincCameraControls&&zincCameraControls.calculateMaxAllowedDistance(this),markerCluster.markerUpdateRequired=!0},this.addMetadataTimeStamp=(key,time)=>{metadata.TimeStamps[key]=convertDurationObjectTomSec(time)},this.getMetadataTag=key=>metadata[key],this.getMetadata=()=>metadata,this.setMetadataTag=(key,value)=>{metadata[key]=value},this.removeMetadataTag=key=>{delete metadata[key]},this.resetMetadata=()=>{metadata=defaultMetadata()},this.resetDuration=()=>{this.setDuration(defaultDuration)};// Turn the object into a readable string {years: years,months: months, 
// weeks: weeks, days: days, hours: hours, mins: mins, secs: secs } 
var convertDurationObjectToString=duration=>[...(duration.years?["".concat(duration.years,"years")]:[]),...(duration.months?["".concat(duration.months,"months")]:[]),...(duration.weeks?["".concat(duration.weeks,"weeks")]:[]),...(duration.days?["".concat(duration.days,"days")]:[]),...(duration.hours?["".concat(duration.hours,"hours")]:[]),...(duration.mins?["".concat(duration.mins,"mins")]:[]),...(duration.secs?["".concat(duration.secs,"secs")]:[])].join(" "),convertDurationObjectTomSec=duration=>duration.years?31536e6*duration.years:0+duration.months?2592e6*duration.months:0+duration.weeks?6048e5*duration.weeks:0+duration.days?864e5*duration.days:0+duration.hours?36e5*duration.hours:0+duration.mins?6e4*duration.mins:0+duration.secs?1e3*duration.secs:0;// Turn the object into a number representing milliesecond {years: years,months: months, 
// weeks: weeks, days: days, hours: hours, mins: mins, secs: secs } 
// Set the readable duration and timer using an object
// with the following format {years: years,months: months, weeks: weeks, days: days,
// hours: hours, mins: mins, secs: secs } 
// Set the readable original duration using an object
// with the following format {years: years,months: months, weeks: weeks, days: days,
// hours: hours, mins: mins, secs: secs } 
/**
   * Export the scene in GLTF format, it can either return it in
   * string or binary form.
   * 
   * @param {Boolean} binary - Indicate it should be exported as binary or
   * text.
   * 
   * @return {Promise} The exported data if the promise resolve successfully
   */ /**
   * Get the root region of the scene.
   * 
   * @return {Region} Return the root region of the scene
   */ /**
   * Create points in region specified in the path 
   *
   */ /**
   * Create points in region specified in the path 
   *
   */ /**
	 * Add a callback function which will be called everytime zinc object is added.
	 * @param {Function} callbackFunction - callbackFunction to be added.
	 * 
	 * @return {Number}
	 */ /**
	 * Add a callback function which will be called everytime zinc object is removed.
	 * @param {Function} callbackFunction - callbackFunction to be added.
	 * 
	 * @return {Number}
	 */ /**
	 * Remove a callback function that is previously added to the scene.
	 * @param {Number} id - identifier of the previously added callback function.
	 */ /**
	 * Remove a callback function that is previously added to the scene.
	 * @param {Number} id - identifier of the previously added callback function.
	 */ /**
	 * Clear all zinc object callback function
	 */ /**
	 * Clear all zinc object callback function
	 */ /**
	 * Used to trigger zinc object added callback
	 */ /**
	 * Used to trigger zinc object removed callback
	 */ /*
	 * Add temporary points to the scene which can be removed
   * with clearTemporaryPrimitives method.
	 */ /*
	 * Add temporary lines to the scene which can be removed
   * with clearTemporaryPrimitives method.
	 */ /*
	 * Remove object from temporary objects list
	 */ /*
	 * Remove all temporary primitives.
   * Return number of primitives removed;
	 */ /*
	 * Create primitive based on the bounding box of scene and
   * add to specify region and group name.
	 */ /*
	 * Create primitive based on the bounding box of scene and
   * add to specify region and group name.
	 */ /*
	 * Enable marker cluster to work with markers
	 */ /*
	 * Destory static axis display object
	 */ /*
	 * Create static axis display object
	 */ /*
	 * Enable static axis display, createAxisDisplay must be called
   * before the axis can be display.
	 */this.setDurationFromObject=duration=>{var string=convertDurationObjectToString(duration),millisec=convertDurationObjectTomSec(duration);this.setMetadataTag("Duration",string),this.setDuration(millisec)},this.setOriginalDurationFromObject=duration=>{var string=convertDurationObjectToString(duration);this.setMetadataTag("OriginalDuration",string)},this.exportGLTF=binary=>{var exporter=new SceneExporter(this);return exporter.exportGLTF(binary)},this.getRootRegion=()=>rootRegion,this.createLines=(regionPath,groupName,coords,colour)=>{var region=rootRegion.findChildFromPath(regionPath);return void 0===region&&(region=rootRegion.createChildFromPath(regionPath)),region.createLines(groupName,coords,colour)},this.createPoints=(regionPath,groupName,coords,labels,colour)=>{var region=rootRegion.findChildFromPath(regionPath);return void 0===region&&(region=rootRegion.createChildFromPath(regionPath)),region.createPoints(groupName,coords,labels,colour)},this.addZincObjectAddedCallbacks=callbackFunction=>(++zincObjectAddedCallbacks_id,zincObjectAddedCallbacks[zincObjectAddedCallbacks_id]=callbackFunction,zincObjectAddedCallbacks_id),this.addZincObjectRemovedCallbacks=callbackFunction=>(++zincObjectRemovedCallbacks_id,zincObjectRemovedCallbacks[zincObjectRemovedCallbacks_id]=callbackFunction,zincObjectRemovedCallbacks_id),this.removeZincObjectAddedCallbacks=id=>{id in zincObjectAddedCallbacks_id&&delete zincObjectAddedCallbacks[id]},this.removeZincObjectRemovedCallbacks=id=>{id in zincObjectRemovedCallbacks_id&&delete zincObjectRemovedCallbacks[id]},this.clearZincObjectAddedCallbacks=()=>{zincObjectAddedCallbacks={},zincObjectAddedCallbacks_id=0},this.clearZincObjectRemovedCallbacks=()=>{zincObjectRemovedCallbacks={},zincObjectRemovedCallbacks_id=0},this.triggerObjectAddedCallback=zincObject=>{for(var key in zincObjectAddedCallbacks)zincObjectAddedCallbacks.hasOwnProperty(key)&&zincObjectAddedCallbacks[key](zincObject)},this.triggerObjectRemovedCallback=zincObject=>{for(var key in zincObjectRemovedCallbacks)zincObjectRemovedCallbacks.hasOwnProperty(key)&&zincObjectRemovedCallbacks[key](zincObject)},this.addTemporaryPoints=(coords,colour)=>{var geometry=createBufferGeometry(coords.length,coords),material=new THREE.PointsMaterial({alphaTest:.5,size:15,color:colour,sizeAttenuation:!1}),texture=getCircularTexture();material.map=texture;var point=new((__webpack_require__(23).Points))(geometry,material);return tempGroup.add(point),point},this.addTemporaryLines=(coords,colour)=>{var geometry=createBufferGeometry(coords.length,coords),material=new THREE.LineBasicMaterial({color:colour}),line=new((__webpack_require__(12).LineSegments))(geometry,material);return tempGroup.add(line),line},this.removeTemporaryPrimitive=object=>{tempGroup.remove(object),object.geometry.dispose(),object.material.dispose()},this.clearTemporaryPrimitives=()=>{var i=0,children=tempGroup.children;return children.forEach(child=>{child.geometry.dispose(),child.material.dispose(),i++}),tempGroup.clear(),i},this.addBoundingBoxPrimitive=function(regionPath,group,colour,opacity,visibility){var boundingBox=5<arguments.length&&void 0!==arguments[5]?arguments[5]:void 0,region=rootRegion.findChildFromPath(regionPath);void 0===region&&(region=rootRegion.createChildFromPath(regionPath));var box=boundingBox?boundingBox:_this.getBoundingBox();_v3.set(0,0,0);var dim=_v3.subVectors(box.max,box.min),boxGeo=new THREE.BoxGeometry(dim.x,dim.y,dim.z),primitive=region.createGeometryFromThreeJSGeometry(group,boxGeo,colour,opacity,visibility,1e4);return dim.addVectors(box.min,box.max).multiplyScalar(.5),primitive.setPosition(dim.x,dim.y,dim.z),primitive},this.addSlicesPrimitive=function(regionPath,groups,colours,opacity,visibility){var boundingBox=5<arguments.length&&arguments[5]!==void 0?arguments[5]:void 0;if(groups&&3<=groups.length&&colours&&3<=colours.length){var region=rootRegion.findChildFromPath(regionPath);void 0===region&&(region=rootRegion.createChildFromPath(regionPath));var box=boundingBox?boundingBox:_this.getBoundingBox();_v3.set(0,0,0);var dim=_v3.subVectors(box.max,box.min),primitives=[],index=0;return["x","y","z"].forEach(direction=>{var planeGeo;switch(direction){//YZ plane
case"x":planeGeo=new THREE.PlaneGeometry(dim.z,dim.y),planeGeo.rotateY(Math.PI/2);// code block
break;//XZ plane
case"y":planeGeo=new THREE.PlaneGeometry(dim.x,dim.z),planeGeo.rotateX(Math.PI/2);// code block
break;//XY plane
case"z":planeGeo=new THREE.PlaneGeometry(dim.x,dim.y);// code block
break;default:}var primitive=region.createGeometryFromThreeJSGeometry(groups[index],planeGeo,colours[index],opacity,visibility,10001);primitives.push(primitive),index++}),dim.addVectors(box.min,box.max).multiplyScalar(.5),primitives.forEach(primitive=>{primitive.setPosition(dim.x,dim.y,dim.z)}),primitives}},this.enableMarkerCluster=flag=>{flag?(markerCluster.markerUpdateRequired=!0,markerCluster.enable()):(markerCluster.markerUpdateRequired=!1,markerCluster.disable()),this.forcePickableObjectsUpdate=!0},this.destroyAxisDisplay=()=>{this.displayMiniAxes=!1,axisDisplay.main&&(this.enableAxisDisplay(!1,!1),axisDisplay.main.forEach(axis=>{axis.dispose&&axis.dispose()})),axisDisplay.mini&&(this.enableAxisDisplay(!1,!0),axisDisplay.mini.forEach(axis=>{axis.dispose&&axis.dispose()})),axisDisplay={main:[],mini:[]}},this.createAxisDisplay=function(){var fitBoundingBox=!!(0<arguments.length&&arguments[0]!==void 0)&&arguments[0];_this.destroyAxisDisplay();var XYZ=[{name:"x",dir:new THREE.Vector3(1,0,0),colour:"red",hex:16733525},{name:"y",dir:new THREE.Vector3(0,1,0),colour:"green",hex:5635925},{name:"z",dir:new THREE.Vector3(0,0,1),colour:"blue",hex:5592575}],boundingBox=_this.getBoundingBox(),size=boundingBox.min.distanceTo(boundingBox.max),origin=new THREE.Vector3(0,0,0);fitBoundingBox&&origin.copy(boundingBox.min),XYZ.forEach(xyzObj=>{var arrowHelper=new THREE.ArrowHelper(xyzObj.dir,origin,size,xyzObj.hex);axisDisplay.main.push(arrowHelper);var miniArrowHelper=new THREE.ArrowHelper(xyzObj.dir,boundingBox.getCenter(_v3),size/2,xyzObj.hex);axisDisplay.mini.push(miniArrowHelper);/*
      const miniLabel = createNewSpriteText(xyzObj.name, 0.1, xyzObj.colour, "Asap", 120, 400);
      const miniPosition = xyzObj.dir.clone().multiplyScalar(size/2).add(_v3[xyzObj.name]);
      miniLabel.position.set(miniPosition.x, miniPosition.y, miniPosition.z);
      axisDisplay.mini.push(miniLabel);
      */var axesLabel=createNewSpriteText(xyzObj.name,.036,xyzObj.colour,"Asap",120,700),position=xyzObj.dir.clone().multiplyScalar(size).add(origin);axesLabel.position.set(position.x,position.y,position.z),axisDisplay.main.push(axesLabel)})},this.enableAxisDisplay=function(enable){var _axisDisplay,miniaxes=!!(1<arguments.length&&arguments[1]!==void 0)&&arguments[1];miniaxes&&null!==(_axisDisplay=axisDisplay)&&void 0!==_axisDisplay&&null!==(_axisDisplay=_axisDisplay.mini)&&void 0!==_axisDisplay&&_axisDisplay.length?(_this.displayMiniAxes=enable,axisDisplay.mini.forEach(axis=>{enable?miniAxesScene.add(axis):miniAxesScene.remove(axis)})):!miniaxes&&axisDisplay.main&&axisDisplay.main.forEach(axis=>{enable?scene.add(axis):scene.remove(axis)})}};

/***/ }),
/* 33 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter(function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable})),t.push.apply(t,o)}return t}function _objectSpread(e){for(var t,r=1;r<arguments.length;r++)t=null==arguments[r]?{}:arguments[r],r%2?ownKeys(Object(t),!0).forEach(function(r){_defineProperty(e,r,t[r])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach(function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))});return e}function _defineProperty(e,r,t){return(r=_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function _toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}var THREE=__webpack_require__(4),markerImage=new Image(128,128);markerImage.src=__webpack_require__(34);var texture=new THREE.Texture;texture.image=markerImage,texture.needsUpdate=!0;var size=[.02,.03,1],spriteMaterial=new THREE.SpriteMaterial({map:texture,alphaTest:.5,transparent:!0,depthTest:!1,depthWrite:!1,sizeAttenuation:!1}),createNewSpriteText=(__webpack_require__(5).createNewSpriteText),MarkerCluster=function(sceneIn){(__webpack_require__(10).ZincObject).call(this),this.texture=texture;var sprite=void 0;this.morph=new THREE.Group,this.group=this.morph,this.isMarkerCluster=!0;var enabled=!0,sprites=[];this.markers={};var _v21=new THREE.Vector2,_v22=new THREE.Vector2,start=Date.now();/**
   * Set the size of the marker.
   * 
   * @param {Number} size - size to be set.
   */this.setSpriteSize=size=>{sprite.scale.set(.015,.02,1),sprite.scale.multiplyScalar(size)},this.clear=()=>{this.group.clear(),this.markers={}},this.dispose=()=>{this.clear(),this.morph&&this.morph.clear()};var createNewSprite=index=>{//Group is needed to set the position after scaling
//the sprite
var localGroup=new THREE.Group,sprite=new THREE.Sprite(spriteMaterial);return sprite.clusterIndex=index,sprite.center.set(.5,0),sprite.position.set(0,0,0),sprite.renderOrder=1e4,sprite.scale.set(size[0],size[1],size[2]),sprite.userData=this,localGroup.add(sprite),this.group.add(localGroup),{group:localGroup,marker:sprite,label:void 0,number:0,min:[0,0,0],max:[1,1,1]}},activateSpriteForCluster=(sprite,cluster,number)=>{sprite.group.visible=!0,sprite.group.position.set(cluster.coords[0],cluster.coords[1],cluster.coords[2]),(sprite.label===void 0||number!==sprite.number)&&(sprite.label&&(sprite.group.remove(sprite.label),sprite.label.material.map.dispose(),sprite.label.material.dispose()),sprite.label=createNewSpriteText(number,.012,"black","Asap",120,700),sprite.number=number,sprite.group.add(sprite.label)),sprite.min=cluster.min,sprite.max=cluster.max},drawClusters=clusters=>{var currentIndex=0;for(clusters.forEach(cluster=>{var length=cluster.members.length,number=0;1===length?cluster.members[0].setVisibility(!0):(cluster.members.forEach(marker=>{number+=marker.getNumber(),marker.setVisibility(!1)}),!sprites[currentIndex]&&sprites.push(createNewSprite(currentIndex)),activateSpriteForCluster(sprites[currentIndex],cluster,number),currentIndex++)}),currentIndex;currentIndex<sprites.length;currentIndex++)sprites[currentIndex].group.visible=!1},getCluster=(markersObj,clusters)=>{var first=!0,newCluster={members:[],coords:[0,0,0],min:[0,0,0],max:[1,1,1]},dist=0;for(var prop in markersObj)first?(_v21.set(markersObj[prop].ndc.x,markersObj[prop].ndc.y),this._b1.setFromPoints([markersObj[prop].morph.position]),first=!1,newCluster.members.push(markersObj[prop]),newCluster.coords=[markersObj[prop].morph.position.x,markersObj[prop].morph.position.y,markersObj[prop].morph.position.z],clusters.push(newCluster),delete markersObj[prop]):(_v22.set(markersObj[prop].ndc.x,markersObj[prop].ndc.y),dist=_v21.distanceTo(_v22),.1>dist&&(newCluster.members.push(markersObj[prop]),this._b1.expandByPoint(markersObj[prop].morph.position),delete markersObj[prop]));newCluster.min=[this._b1.min.x,this._b1.min.y,this._b1.min.z],newCluster.max=[this._b1.max.x,this._b1.max.y,this._b1.max.z],!0!=first&&getCluster(markersObj,clusters)};//Get clusters based on the ndc coordinate for each cluster.
/**
   * Enable and visualise the marker.
   */ /**
   * Disable and hide the marker.
   */this.calculate=()=>{if(enabled){var current=Date.now();if(500<current-start){var clusters=[];getCluster(_objectSpread({},this.markers),clusters),drawClusters(clusters),start=Date.now(),this.markerUpdateRequired=!1}}},this.isEnabled=()=>enabled,this.enable=()=>{enabled=!0,this.morph.visible=!0},this.disable=()=>{//turn all markers back on
for(var prop in enabled=!1,this.morph.visible=!1,this.markers){var _this$markers$prop;null!==(_this$markers$prop=this.markers[prop])&&void 0!==_this$markers$prop&&_this$markers$prop.isMarker&&this.markers[prop].isEnabled()&&this.markers[prop].setVisibility(!0)}},this.zoomToCluster=index=>!!(void 0!==index&&-1<index&&(this._v1.set(...sprites[index].min),this._v2.set(...sprites[index].max),Math.abs(0<this._v1.distanceTo(this._v2))))&&(this._b1.set(this._v1,this._v2),sceneIn.translateBoundingBoxToCameraView(this._b1,3,300),this.markerUpdateRequired=!0,!0),this.clusterIsVisible=index=>{if(index!==void 0&&-1<index&&sprites[index]){var _sprites$index$group;return null===(_sprites$index$group=sprites[index].group)||void 0===_sprites$index$group?void 0:_sprites$index$group.visible}return!1}};/**
 * A special graphics type with a tear drop shape.
 * It forms a cluster a marker based on distance.
 * 
 * @class
 * @author Alan Wu
 * @return {Marker}
 */MarkerCluster.prototype=Object.create((__webpack_require__(10).ZincObject).prototype),exports.MarkerCluster=MarkerCluster;

/***/ }),
/* 34 */
/***/ ((module) => {

module.exports = "data:image/svg+xml;base64,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"

/***/ }),
/* 35 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),resolveURL=(__webpack_require__(5).resolveURL),createNewURL=(__webpack_require__(5).createNewURL),isRegionGroup=(__webpack_require__(5).isRegionGroup),STLLoader=(__webpack_require__(36).STLLoader),OBJLoader=(__webpack_require__(37).OBJLoader),PrimitivesLoader=(__webpack_require__(38).PrimitivesLoader);/**
 * A helper class to help with reading / importing primitives and
 * settings into a {@link Scene}.
 *
 * @class
 * @param {Object} containerIn - Container to create the renderer on.
 * @author Alan Wu
 * @return {SceneLoader}
 */exports.SceneLoader=function(sceneIn){var scene=sceneIn;this.toBeDownloaded=0,this.progressMap={};var viewLoaded=!1,errorDownload=!1,primitivesLoader=new PrimitivesLoader;/**
   * This function returns a three component array, which contains
   * [totalsize, totalLoaded and errorDownload] of all the downloads happening
   * in this scene.
   * @returns {Array}
   */this.getDownloadProgress=()=>{var totalSize=0,totalLoaded=0,unknownFound=!1;for(var key in this.progressMap){var progress=this.progressMap[key];totalSize+=progress[1],totalLoaded+=progress[0],0==progress[1]&&(unknownFound=!0)}return unknownFound&&(totalSize=0),[totalSize,totalLoaded,errorDownload]},this.onProgress=id=>xhr=>{this.progressMap[id]=[xhr.loaded,xhr.total]},this.onError=finishCallback=>xhr=>{--this.toBeDownloaded,errorDownload=!0,console.error("There is an issue with external resource ".concat(null!==xhr&&void 0!==xhr&&xhr.responseURL?": "+(null===xhr||void 0===xhr?void 0:xhr.responseURL):"","."));finishCallback&&finishCallback({type:"Error",xhr})};var loadMultipleViews=(referenceURL,views)=>{var defaultView=views.Default;if(views.Inline)scene.setupMultipleViews(defaultView,views.Entries);else{var promises=[],_loop=function _loop(key){referenceURL&&(newURL=createNewURL(value,referenceURL),promises.push(new Promise((resolve,reject)=>{// Add parameters if we are sent them
fetch(newURL).then(response=>response.json()).then(data=>resolve({key:key,data:data})).catch(data=>reject(data))})))};for(var[key,value]of Object.entries(views.Entries))_loop(key);Promise.all(promises).then(values=>{var entries={};values.forEach(entry=>{entries[entry.key]=entry.data}),scene.setupMultipleViews(defaultView,entries);var zincCameraControls=scene.getZincCameraControls();zincCameraControls&&zincCameraControls.setCurrentViewport(defaultView),viewLoaded=!0})}};/**
   * Load the viewport from an external location provided by the url.
   * @param {String} URL - address to the file containing viewport information.
   */this.loadViewURL=(url,finishCallback)=>{this.toBeDownloaded+=1;var xmlhttp=new XMLHttpRequest;xmlhttp.onreadystatechange=()=>{if(4==xmlhttp.readyState)if(200==xmlhttp.status){var viewData=JSON.parse(xmlhttp.responseText);scene.setupMultipleViews("default",{default:viewData}),scene.resetView(),viewLoaded=!0,--this.toBeDownloaded,null!=finishCallback&&"function"==typeof finishCallback&&finishCallback()}else this.onError(finishCallback)({responseURL:url})};var requestURL=resolveURL(url);xmlhttp.open("GET",requestURL,!0),xmlhttp.send()},this.loadModelsURL=(region,urls,colours,opacities,timeEnabled,morphColour,finishCallback)=>{var number=urls.length;this.toBeDownloaded+=number;for(var i=0;i<number;i++){var filename=urls[i],colour=(__webpack_require__(0).defaultMaterialColor),opacity=(__webpack_require__(0).defaultOpacity);colours!=null&&colours[i]!=null&&(colour=!!colours[i]),opacities!=null&&opacities[i]!=null&&(opacity=opacities[i]);var localTimeEnabled=0;timeEnabled!=null&&timeEnabled[i]!=null&&(localTimeEnabled=!!timeEnabled[i]);var localMorphColour=0;morphColour!=null&&morphColour[i]!=null&&(localMorphColour=!!morphColour[i]),primitivesLoader.load(resolveURL(filename),meshloader(region,colour,opacity,localTimeEnabled,localMorphColour,void 0,void 0,void 0,void 0,finishCallback),this.onProgress(filename),this.onError(finishCallback))}},this.loadFromViewURL=(targetRegion,jsonFilePrefix,finishCallback)=>{var xmlhttp=new XMLHttpRequest;xmlhttp.onreadystatechange=()=>{if(4==xmlhttp.readyState&&200==xmlhttp.status){var viewData=JSON.parse(xmlhttp.responseText);scene.loadView(viewData);for(var filename,urls=[],filename_prefix=jsonFilePrefix+"_",i=0;i<viewData.numberOfResources;i++)filename=filename_prefix+(i+1)+".json",urls.push(filename);this.loadModelsURL(targetRegion,urls,viewData.colour,viewData.opacity,viewData.timeEnabled,viewData.morphColour,finishCallback)}};var requestURL=resolveURL(jsonFilePrefix+"_view.json");xmlhttp.open("GET",requestURL,!0),xmlhttp.send()};//Internal loader for a regular zinc geometry.
var linesloader=(region,localTimeEnabled,localMorphColour,groupName,anatomicalId,renderOrder,lod,tubeLines,finishCallback)=>(geometry,materials)=>{var newLines=tubeLines?new((__webpack_require__(39).TubeLines)):new((__webpack_require__(24).Lines)),material=void 0;materials&&materials[0]&&(material=new THREE.LineBasicMaterial({color:materials[0].color.clone()}),1>materials[0].opacity&&(material.transparent=!0),material.opacity=materials[0].opacity,material.morphTargets=localTimeEnabled,material.vertexColors=materials[0].vertexColors);var options={localTimeEnabled:localTimeEnabled,localMorphColour:localMorphColour};if(newLines&&(newLines.createLineSegment(geometry,material,options),newLines.setName(groupName),newLines.setAnatomicalId(anatomicalId),newLines.setRenderOrder(renderOrder),region.addZincObject(newLines),newLines.setDuration(scene.getDuration()),lod&&lod.levels))for(var[key,value]of Object.entries(lod.levels))newLines.addLOD(primitivesLoader,key,value.URL,value.Index,lod.preload);--this.toBeDownloaded,geometry.dispose(),null!=finishCallback&&"function"==typeof finishCallback&&finishCallback(newLines)};/**
   * Load lines into this scene object.
   *
   * @param {Boolean} timeEnabled - Indicate if  morphing is enabled.
   * @param {Boolean} morphColour - Indicate if color morphing is enabled.
   * @param {STRING} groupName - name to assign the pointset's groupname to.
   * @param {Function} finishCallback - Callback function which will be called
   * once the glyphset is succssfully load in.
   */this.loadLinesURL=(region,url,timeEnabled,morphColour,groupName,finishCallback,options)=>{var localTimeEnabled=0;this.toBeDownloaded+=1;var isInline=!!(null!==options&&void 0!==options&&options.isInline)&&options.isInline,anatomicalId=null!==options&&void 0!==options&&options.anatomicalId?options.anatomicalId:void 0,renderOrder=null!==options&&void 0!==options&&options.renderOrder?options.renderOrder:void 0;timeEnabled!=null&&(localTimeEnabled=!!timeEnabled);var localMorphColour=0;morphColour!=null&&(localMorphColour=!!morphColour);var tubeLines=options.tubeLines&&!localTimeEnabled&&!localMorphColour;if(isInline){var object=primitivesLoader.parse(url);linesloader(region,localTimeEnabled,localMorphColour,groupName,anatomicalId,renderOrder,options.lod,tubeLines,finishCallback)(object.geometry,object.materials)}else primitivesLoader.load(url,linesloader(region,localTimeEnabled,localMorphColour,groupName,anatomicalId,renderOrder,options.lod,tubeLines,finishCallback),this.onProgress(url),this.onError(finishCallback),options.loaderOptions)};var loadGlyphset=(region,glyphsetData,glyphurl,groupName,finishCallback,options)=>{var isInline=options&&options.isInline?options.isInline:void 0,anatomicalId=options&&options.anatomicalId?options.anatomicalId:void 0,displayLabels=options&&options.displayLabels?options.displayLabels:void 0,renderOrder=options&&options.renderOrder?options.renderOrder:void 0,newGlyphset=new((__webpack_require__(18).Glyphset));newGlyphset.setDuration(scene.getDuration()),newGlyphset.groupName=groupName;var myCallback=()=>{--this.toBeDownloaded,finishCallback!=null&&"function"==typeof finishCallback&&finishCallback(newGlyphset)};++this.toBeDownloaded,isInline?newGlyphset.load(glyphsetData,glyphurl,myCallback,isInline,displayLabels):newGlyphset.load(glyphsetData,resolveURL(glyphurl),myCallback,isInline,displayLabels),newGlyphset.setAnatomicalId(anatomicalId),newGlyphset.setRenderOrder(renderOrder),region.addZincObject(newGlyphset)},onLoadGlyphsetReady=(region,xmlhttp,glyphurl,groupName,finishCallback,options)=>()=>{if(4==xmlhttp.readyState&&200==xmlhttp.status){var glyphsetData=JSON.parse(xmlhttp.responseText);loadGlyphset(region,glyphsetData,glyphurl,groupName,finishCallback,options)}},pointsetloader=(region,localTimeEnabled,localMorphColour,groupName,anatomicalId,renderOrder,finishCallback)=>(geometry,materials)=>{var newPointset=new((__webpack_require__(22).Pointset)),material=new THREE.PointsMaterial({alphaTest:.5,size:10,sizeAttenuation:!1});materials&&materials[0]&&(1>materials[0].opacity&&(material.transparent=!0),material.opacity=materials[0].opacity,material.color=materials[0].color,material.morphTargets=localTimeEnabled,material.vertexColors=materials[0].vertexColors);var options={};options.localTimeEnabled=localTimeEnabled,options.localMorphColour=localMorphColour,newPointset&&(newPointset.createMesh(geometry,material,options),newPointset.setName(groupName),newPointset.setAnatomicalId(anatomicalId),region.addZincObject(newPointset),newPointset.setDuration(scene.getDuration()),newPointset.setRenderOrder(renderOrder)),geometry.dispose(),--this.toBeDownloaded,null!=finishCallback&&"function"==typeof finishCallback&&finishCallback(newPointset)};//Load a glyphset into this scene.
//Internal loader for zinc pointset.
/**
   * Read a STL file into this scene, the geometry will be presented as
   * {@link Zinc.Geometry}.
   *
   * @param {STRING} url - location to the STL file.
   * @param {STRING} groupName - name to assign the geometry's groupname to.
   * @param {Function} finishCallback - Callback function which will be called
   * once the STL geometry is succssfully loaded.
   */this.loadSTL=(region,url,groupName,finishCallback)=>{this.toBeDownloaded+=1;var colour=(__webpack_require__(0).defaultMaterialColor),opacity=(__webpack_require__(0).defaultOpacity),loader=new STLLoader;loader.crossOrigin="Anonymous",loader.load(resolveURL(url),meshloader(region,colour,opacity,!1,!1,groupName,void 0,void 0,void 0,finishCallback))},this.loadOBJ=(region,url,groupName,finishCallback)=>{this.toBeDownloaded+=1;var colour=(__webpack_require__(0).defaultMaterialColor),opacity=(__webpack_require__(0).defaultOpacity),loader=new OBJLoader;loader.crossOrigin="Anonymous",loader.load(resolveURL(url),meshloader(region,colour,opacity,!1,!1,groupName,void 0,void 0,void 0,finishCallback))};/**
   * Load a geometry into this scene, this is a subsequent called from
   * {@link Zinc.Scene#loadMetadataURL}, although it can be used to read
   * in geometry into the scene externally.
   *
   * @param {String} url - regular json model file providing geometry.
   * @param {Boolean} timeEnabled - Indicate if geometry morphing is enabled.
   * @param {Boolean} morphColour - Indicate if color morphing is enabled.
   * @param {STRING} groupName - name to assign the geometry's groupname to.
   * @param {STRING} fileFormat - name supported formats are STL, OBJ and JSON.
   * @param {Function} finishCallback - Callback function which will be called
   * once the geometry is succssfully loaded in.
   */var loadSurfaceURL=(region,url,timeEnabled,morphColour,groupName,finishCallback,options)=>{this.toBeDownloaded+=1;var colour=(__webpack_require__(0).defaultMaterialColor),opacity=(__webpack_require__(0).defaultOpacity),localTimeEnabled=0,isInline=!!(options&&options.isInline)&&options.isInline,fileFormat=options&&options.fileFormat?options.fileFormat:void 0,anatomicalId=options&&options.anatomicalId?options.anatomicalId:void 0,renderOrder=options&&options.renderOrder?options.renderOrder:void 0;timeEnabled!=null&&(localTimeEnabled=!!timeEnabled);var localMorphColour=0;morphColour!=null&&(localMorphColour=!!morphColour);var loader=primitivesLoader;if(fileFormat!==void 0)if("STL"==fileFormat)loader=new STLLoader;else if("OBJ"==fileFormat)return loader=new OBJLoader,loader.crossOrigin="Anonymous",void loader.load(url,objloader(region,colour,opacity,localTimeEnabled,localMorphColour,groupName,anatomicalId,finishCallback),this.onProgress(url),this.onError,options.loaderOptions);if(isInline){var object=primitivesLoader.parse(url);meshloader(region,colour,opacity,localTimeEnabled,localMorphColour,groupName,anatomicalId,renderOrder,options,finishCallback)(object.geometry,object.materials)}else loader.crossOrigin="Anonymous",primitivesLoader.load(url,meshloader(region,colour,opacity,localTimeEnabled,localMorphColour,groupName,anatomicalId,renderOrder,options,finishCallback),this.onProgress(url),this.onError(finishCallback),options.loaderOptions)},metaFinishCallback=function metaFinishCallback(numberOfDownloaded,finishCallback,allCompletedCallback){var downloadedItem=0;return zincObject=>{if(++downloadedItem,zincObject&&null!=finishCallback&&"function"==typeof finishCallback&&finishCallback(zincObject),downloadedItem==numberOfDownloaded&&(!1==viewLoaded&&scene.viewAll(),null!=allCompletedCallback&&"function"==typeof allCompletedCallback)){allCompletedCallback();var zincCameraControls=scene.getZincCameraControls();zincCameraControls&&zincCameraControls.calculateMaxAllowedDistance(scene)}}};//Object to keep track of number of items downloaded and when all items are downloaded
//allCompletedCallback is called
/**
   * Load a pointset into this scene object.
   *
   * @param {Boolean} timeEnabled - Indicate if  morphing is enabled.
   * @param {Boolean} morphColour - Indicate if color morphing is enabled.
   * @param {STRING} groupName - name to assign the pointset's groupname to.
   * @param {Function} finishCallback - Callback function which will be called
   * once the glyphset is succssfully load in.
   */this.loadPointsetURL=(region,url,timeEnabled,morphColour,groupName,finishCallback,options)=>{var localTimeEnabled=0;this.toBeDownloaded+=1,timeEnabled!=null&&(localTimeEnabled=!!timeEnabled);var localMorphColour=0;morphColour!=null&&(localMorphColour=!!morphColour);var isInline=!!(options&&options.isInline)&&options.isInline,anatomicalId=options&&options.anatomicalId?options.anatomicalId:void 0,renderOrder=options&&options.renderOrder?options.renderOrder:void 0;if(isInline){var object=primitivesLoader.parse(url);pointsetloader(region,localTimeEnabled,localMorphColour,groupName,anatomicalId,renderOrder,finishCallback)(object.geometry,object.materials)}else primitivesLoader.load(url,pointsetloader(region,localTimeEnabled,localMorphColour,groupName,anatomicalId,renderOrder,finishCallback),this.onProgress(url),this.onError(finishCallback),options.loaderOptions)};var loadTexture=(region,referenceURL,textureData,groupName,finishCallback,options)=>{var isInline=options&&options.isInline?options.isInline:void 0,anatomicalId=options&&options.anatomicalId?options.anatomicalId:void 0,renderOrder=options&&options.renderOrder?options.renderOrder:void 0,newTexture=void 0;if(textureData){if(referenceURL&&textureData.images&&textureData.images.source)for(var _newURL,source=textureData.images.source,i=0;i<source.length;i++)_newURL=createNewURL(source[i],referenceURL),textureData.images.source[i]=_newURL;if("slides"===textureData.type&&(newTexture=new((__webpack_require__(27).TextureSlides))),newTexture){newTexture.groupName=groupName;var myCallback=()=>{region.addZincObject(newTexture),--this.toBeDownloaded,null!=finishCallback&&"function"==typeof finishCallback&&finishCallback(newTexture)};++this.toBeDownloaded,newTexture.load(textureData,myCallback,isInline),newTexture.setAnatomicalId(anatomicalId),newTexture.setRenderOrder(renderOrder)}}},onLoadTextureReady=(region,xmlhttp,groupName,finishCallback,options)=>()=>{if(4==xmlhttp.readyState&&200==xmlhttp.status){var textureData=JSON.parse(xmlhttp.responseText);loadTexture(region,xmlhttp.responseURL,textureData,groupName,finishCallback,options)}};//Load a glyphset into this scene.
/**
   * Load a texture into this scene object.
   *
   * @param {STRING} groupName - name to assign the pointset's groupname to.
   * @param {Function} finishCallback - Callback function which will be called
   * once the glyphset is succssfully load in.
   */this.loadTextureURL=(region,url,groupName,finishCallback,options)=>{var isInline=!!(options&&options.isInline)&&options.isInline;if(isInline)loadTexture(region,void 0,url,groupName,finishCallback,options);else{var xmlhttp=new XMLHttpRequest;xmlhttp.onreadystatechange=onLoadTextureReady(region,xmlhttp,groupName,finishCallback,options),xmlhttp.open("GET",resolveURL(url),!0),xmlhttp.send()}},this.loadGlyphsetURL=(region,metaurl,glyphurl,groupName,finishCallback,options)=>{var isInline=!!(options&&options.isInline)&&options.isInline;if(isInline)loadGlyphset(region,metaurl,glyphurl,groupName,finishCallback,options);else{var xmlhttp=new XMLHttpRequest;xmlhttp.onreadystatechange=onLoadGlyphsetReady(region,xmlhttp,glyphurl,groupName,finishCallback,options),xmlhttp.open("GET",resolveURL(metaurl),!0),xmlhttp.send()}};/**
   * Add a user provided {THREE.Geometry} into  the scene as zinc geometry.
   *
   * @param {Three.Geometry} geometry - The threejs geometry to be added as {@link Zinc.Geometry}.
   * @param {THREE.Color} color - Colour to be assigned to this geometry, overrided if materialIn is provided.
   * @param {Number} opacity - Opacity to be set for this geometry, overrided if materialIn is provided.
   * @param {Boolean} localTimeEnabled - Set this to true if morph geometry is present, overrided if materialIn is provided.
   * @param {Boolean} localMorphColour - Set this to true if morph colour is present, overrided if materialIn is provided.
   * @param {Boolean} external - Set this to true if morph geometry is present, overrided if materialIn is provided.
   * @param {Function} finishCallback - Callback once the geometry has been added succssfully.
   * @param {THREE.Material} materialIn - Material to be set for this geometry if it is present.
   *
   * @returns {Zinc.Geometry}
   */var addZincGeometry=(region,geometryIn,colour,opacity,localTimeEnabled,localMorphColour,finishCallback,materialIn,groupName,renderOrder,anatomicalId)=>{var options={colour:colour,opacity:opacity,localTimeEnabled:localTimeEnabled,localMorphColour:localMorphColour},newGeometry=new((__webpack_require__(3).Geometry));return newGeometry.createMesh(geometryIn,materialIn,options),newGeometry.getMorph()?(newGeometry.setName(groupName),newGeometry.setRenderOrder(renderOrder),newGeometry.setAnatomicalId(anatomicalId),region&&region.addZincObject(newGeometry),newGeometry.setDuration(scene.getDuration()),null!=finishCallback&&"function"==typeof finishCallback&&finishCallback(newGeometry),newGeometry.videoHandler&&scene.setVideoHandler(newGeometry.videoHandler),newGeometry):void 0},meshloader=(region,colour,opacity,localTimeEnabled,localMorphColour,groupName,anatomicalId,renderOrder,options,finishCallback)=>(geometry,materials)=>{var material;materials&&materials[0]&&(material=materials[0]);var zincGeometry=addZincGeometry(region,geometry,colour,opacity,localTimeEnabled,localMorphColour,void 0,material,groupName,renderOrder,anatomicalId);if(options.lod&&options.lod.levels)for(var[key,value]of Object.entries(options.lod.levels))zincGeometry.addLOD(primitivesLoader,key,value.URL,value.Index,options.lod.preload);--this.toBeDownloaded,geometry.dispose(),null!=finishCallback&&"function"==typeof finishCallback&&finishCallback(zincGeometry)},parseDuration=durationString=>{var regex=/P(?:(\d+)Y)?(?:(\d+)M)?(?:(\d+)W)?(?:(\d+)D)?(?:T(?:(\d+)H)?(?:(\d+)M)?(?:(\d+)S)?)?$/,[,years,months,weeks,days,hours,mins,secs]=durationString.match(regex);return{years:years,months:months,weeks:weeks,days:days,hours:hours,mins:mins,secs:secs}};//Internal loader for a regular zinc geometry.
//Turn ISO 8601 duration string into an array.
//Load settings from metadata item.
this.loadSettings=item=>{if(item){//duration uses the ISO 8601 standard - PnYnMnDTnHnMnS
if(item.Duration){var duration=parseDuration(item.Duration);scene.setDurationFromObject(duration)}if(item.OriginalDuration){var _duration=parseDuration(item.OriginalDuration);scene.setOriginalDurationFromObject(_duration)}if(item.TimeStamps)for(var key in item.TimeStamps){var time=parseDuration(item.TimeStamps[key]);scene.addMetadataTimeStamp(key,time)}}};//Function to process each of the graphical metadata item except for view and
//settings.
var readPrimitivesItem=(region,referenceURL,item,order,finishCallback)=>{if(item){var _newURL2=void 0,isInline=!1;item.URL?(_newURL2=item.URL,referenceURL&&(_newURL2=createNewURL(_newURL2,referenceURL))):item.Inline&&(_newURL2=item.Inline.URL,isInline=!0);var lod={};if(item.LOD&&item.LOD.Levels){lod.preload=!!item.LOD.Preload,lod.levels={};for(var[key,value]of Object.entries(item.LOD.Levels))lod.levels[key]={},lod.levels[key].URL=createNewURL(value.URL,referenceURL),lod.levels[key].Index=value.Index}var groupName=item.GroupName;(groupName===void 0||""===groupName)&&(groupName="_Unnamed");var options={loaderOptions:{index:item.Index},isInline:isInline,fileFormat:item.FileFormat,anatomicalId:item.AnatomicalId,compression:item.compression,tubeLines:item.tubeLines,lod:lod,renderOrder:order};switch(item.Type){case"Surfaces":loadSurfaceURL(region,_newURL2,item.MorphVertices,item.MorphColours,groupName,finishCallback,options);break;case"Glyph":var newGeometryURL;isInline?newGeometryURL=item.Inline.GlyphGeometriesURL:(newGeometryURL=item.GlyphGeometriesURL,newGeometryURL=createNewURL(item.GlyphGeometriesURL,referenceURL)),item.DisplayLabels&&(options.displayLabels=!0),this.loadGlyphsetURL(region,_newURL2,newGeometryURL,groupName,finishCallback,options);break;case"Points":this.loadPointsetURL(region,_newURL2,item.MorphVertices,item.MorphColours,groupName,finishCallback,options);break;case"Lines":this.loadLinesURL(region,_newURL2,item.MorphVertices,item.MorphColours,groupName,finishCallback,options);break;case"Texture":this.loadTextureURL(region,_newURL2,groupName,finishCallback,options);break;default:}}},readViewAndSettingsItem=(referenceURL,item,finishCallback)=>{if(item){var _newURL3=void 0,isInline=!1;switch(item.URL?(_newURL3=item.URL,referenceURL&&(_newURL3=createNewURL(item.URL,referenceURL))):item.Inline&&(_newURL3=item.Inline.URL,isInline=!0),item.Type){case"View":isInline?(scene.setupMultipleViews("default",{default:_newURL3}),viewLoaded=!0,null!=finishCallback&&"function"==typeof finishCallback&&finishCallback()):this.loadViewURL(_newURL3,finishCallback);break;case"Settings":this.loadSettings(item);break;default:}}};//Function to read the view item first
/**
   * Load GLTF into this scene object.
   *
   * @param {String} url - URL to the GLTF file
   * @param {Function} finishCallback - Callback function which will be called
   * once the glyphset is succssfully load in.
   */this.loadGLTF=(region,url,finishCallback,allCompletedCallback,options)=>{var GLTFToZincJSLoader=new((__webpack_require__(40).GLTFToZincJSLoader));GLTFToZincJSLoader.load(scene,region,url,finishCallback,allCompletedCallback,options)};var loadRegions=(currentRegion,referenceURL,regions,callback)=>{if(regions.Primitives&&regions.Primitives.forEach(primitive=>{var order=1;primitive.Order&&(order=primitive.Order),readPrimitivesItem(currentRegion,referenceURL,primitive,order,callback)}),regions.Transformation&&currentRegion.setTransformation(regions.Transformation),regions.Children)for(var[regionName,value]of Object.entries(regions.Children)){var childRegion=currentRegion.findOrCreateChildFromPath(regionName);childRegion&&loadRegions(childRegion,referenceURL,value,callback)}},supplementPrimitivesArray=(array,options)=>{var _options$enabled,_options$enabled2,newArray=array,include=null===options||void 0===options||null===(_options$enabled=options.enabled)||void 0===_options$enabled?void 0:_options$enabled.include,exclude=null===options||void 0===options||null===(_options$enabled2=options.enabled)||void 0===_options$enabled2?void 0:_options$enabled2.exclude,tubeLines=null===options||void 0===options?void 0:options.tubeLines;return(null!==include&&void 0!==include&&include.length||null!==exclude&&void 0!==exclude&&exclude.length)&&(include&&(newArray=array.filter(item=>{if("View"===item.Type)return!0;for(var i=0;i<include.length;i++)if(isRegionGroup(item.RegionPath,item.GroupName,include[i]))return!0;return!1})),exclude&&(newArray=newArray.filter(item=>{if("View"===item.Type)return!0;for(var i=0;i<exclude.length;i++)if(isRegionGroup(item.RegionPath,item.GroupName,exclude[i]))return!1;return!0}))),tubeLines&&newArray.forEach(item=>{"Lines"===item.Type&&(item.tubeLines=!0)}),newArray},supplementMetadataInArray=(metadata,options)=>Array.isArray(metadata)?supplementPrimitivesArray(metadata,options):metadata,getNumberOfDownloadsInArray=(array,includeViews)=>{if(Array.isArray(array)){for(var count=0,i=0;i<array.length;i++)array[i].Type&&(includeViews&&"View"===array[i].Type||"Surfaces"===array[i].Type||"Glyph"===array[i].Type||"Points"===array[i].Type||"Lines"===array[i].Type||"Texture"===array[i].Type)&&count++;return count}return 0},getNumberOfObjectsInRegions=regionJson=>{var counts=regionJson.Primitives?getNumberOfDownloadsInArray(regionJson.Primitives,!1):0;return regionJson.Children&&Object.values(regionJson.Children).forEach(childRegion=>{counts+=getNumberOfObjectsInRegions(childRegion)}),counts},getNumberOfObjects=metadata=>{if(Array.isArray(metadata))return getNumberOfDownloadsInArray(metadata,!0);return"object"==typeof metadata&&null!==metadata&&"2.0"===metadata.Version?getNumberOfObjectsInRegions(metadata.Regions):void 0},readVersionOneRegionPath=(region,referenceURL,item,order,callback)=>{var targetRegion=region;//Render order is set to i * 2 to account for front and back rendering
item.RegionPath&&""!==item.RegionPath&&(targetRegion=region.findOrCreateChildFromPath(item.RegionPath)),readPrimitivesItem(targetRegion,referenceURL,item,2*order,callback)},loadVersionOne=(targetRegion,metadata,referenceURL,finishCallback,allCompletedCallback,options)=>{// view file does not receive callback
// Prioritise the view file and settings before loading anything else
for(var filteredMetada=supplementMetadataInArray(metadata,options),numberOfObjects=getNumberOfObjects(filteredMetada),callback=new metaFinishCallback(numberOfObjects,finishCallback,allCompletedCallback),i=0;i<metadata.length;i++)readViewAndSettingsItem(referenceURL,filteredMetada[i],callback);for(var _i=0;_i<metadata.length;_i++)readVersionOneRegionPath(targetRegion,referenceURL,filteredMetada[_i],_i,callback)},loadVersionTwo=(targetRegion,metadata,referenceURL,finishCallback,allCompletedCallback)=>{var numberOfObjects=getNumberOfObjects(metadata),callback=new metaFinishCallback(numberOfObjects,finishCallback,allCompletedCallback);// view file does not receive callback
metadata.Settings&&this.loadSettings(metadata.Settings),metadata.Views&&loadMultipleViews(referenceURL,metadata.Views,referenceURL),metadata.Regions&&loadRegions(targetRegion,referenceURL,metadata.Regions,callback)};/**
    * Load a metadata file from the provided URL into this scene. Once
    * succssful scene proceeds to read each items into scene for visualisations.
    *
    * @param {String} url - Location of the metadata file
    * @param {Function} finishCallback - Callback function which will be called
    * @param {options} Optional settings, it can be used to ignore some regions/groups
    * in the metadata file. Only supports version 1 at this moment.
    * for each glyphset and geometry that has been written in.
    */this.loadMetadataURL=(targetRegion,url,finishCallback,allCompletedCallback,options)=>{var xmlhttp=new XMLHttpRequest,requestURL=resolveURL(url);xmlhttp.onreadystatechange=()=>{if(4==xmlhttp.readyState&&200==xmlhttp.status){scene.resetMetadata(),scene.resetDuration(),viewLoaded=!1;var referenceURL=xmlhttp.responseURL;referenceURL===void 0&&(referenceURL=new URL(requestURL).href);var metadata=JSON.parse(xmlhttp.responseText);Array.isArray(metadata)?loadVersionOne(targetRegion,metadata,referenceURL,finishCallback,allCompletedCallback,options):"object"==typeof metadata&&null!==metadata&&"2.0"==metadata.Version&&loadVersionTwo(targetRegion,metadata,referenceURL,finishCallback,allCompletedCallback)}},xmlhttp.open("GET",requestURL,!0),xmlhttp.send()}};

/***/ }),
/* 36 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STLLoader: () => (/* binding */ STLLoader)
/* harmony export */ });
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(three__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Description: A THREE loader for STL ASCII files, as created by Solidworks and other CAD programs.
 *
 * Supports both binary and ASCII encoded files, with automatic detection of type.
 *
 * The loader returns a non-indexed buffer geometry.
 *
 * Limitations:
 *  Binary decoding supports "Magics" color format (http://en.wikipedia.org/wiki/STL_(file_format)#Color_in_binary_STL).
 *  There is perhaps some question as to how valid it is to always assume little-endian-ness.
 *  ASCII decoding assumes file is UTF-8.
 *
 * Usage:
 *  const loader = new STLLoader();
 *  loader.load( './models/stl/slotted_disk.stl', function ( geometry ) {
 *    scene.add( new THREE.Mesh( geometry ) );
 *  });
 *
 * For binary STLs geometry might contain colors for vertices. To use it:
 *  // use the same code to load STL as above
 *  if (geometry.hasColors) {
 *    material = new THREE.MeshPhongMaterial({ opacity: geometry.alpha, vertexColors: true });
 *  } else { .... }
 *  const mesh = new THREE.Mesh( geometry, material );
 *
 * For ASCII STLs containing multiple solids, each solid is assigned to a different group.
 * Groups can be used to assign a different color by defining an array of materials with the same length of
 * geometry.groups and passing it to the Mesh constructor:
 *
 * const mesh = new THREE.Mesh( geometry, material );
 *
 * For example:
 *
 *  const materials = [];
 *  const nGeometryGroups = geometry.groups.length;
 *
 *  const colorMap = ...; // Some logic to index colors.
 *
 *  for (let i = 0; i < nGeometryGroups; i++) {
 *
 *		const material = new THREE.MeshPhongMaterial({
 *			color: colorMap[i],
 *			wireframe: false
 *		});
 *
 *  }
 *
 *  materials.push(material);
 *  const mesh = new THREE.Mesh(geometry, materials);
 */class STLLoader extends three__WEBPACK_IMPORTED_MODULE_0__.Loader{constructor(manager){super(manager)}load(url,onLoad,onProgress,onError){var scope=this,loader=new three__WEBPACK_IMPORTED_MODULE_0__.FileLoader(this.manager);loader.setPath(this.path),loader.setResponseType("arraybuffer"),loader.setRequestHeader(this.requestHeader),loader.setWithCredentials(this.withCredentials),loader.load(url,function(text){try{onLoad(scope.parse(text))}catch(e){onError?onError(e):console.error(e),scope.manager.itemError(url)}},onProgress,onError)}parse(data){function matchDataViewAt(query,reader,offset){// Check if each byte in query matches the corresponding byte from the current offset
for(var i=0,il=query.length;i<il;i++)if(query[i]!==reader.getUint8(offset+i,!1))return!1;return!0}// start
var binData=function(buffer){if("string"==typeof buffer){for(var array_buffer=new Uint8Array(buffer.length),i=0;i<buffer.length;i++)array_buffer[i]=255&buffer.charCodeAt(i);// implicitly assumes little-endian
return array_buffer.buffer||array_buffer}return buffer}(data);return function(data){var reader=new DataView(data),n_faces=reader.getUint32(80,!0);if(80+32/8+n_faces*(3*(32/8)+3*(3*(32/8))+16/8)===reader.byteLength)return!0;// An ASCII STL data must begin with 'solid ' as the first six bytes.
// However, ASCII STLs lacking the SPACE after the 'd' are known to be
// plentiful.  So, check the first 5 bytes for 'solid'.
// Several encodings, such as UTF-8, precede the text with up to 5 bytes:
// https://en.wikipedia.org/wiki/Byte_order_mark#Byte_order_marks_by_encoding
// Search for "solid" to start anywhere after those prefixes.
// US-ASCII ordinal values for 's', 'o', 'l', 'i', 'd'
for(var solid=[115,111,108,105,100],off=0;5>off;off++)// If "solid" text is matched to the current offset, declare it to be an ASCII STL.
if(matchDataViewAt(solid,reader,off))return!1;// Couldn't find "solid" text at the beginning; it is binary STL.
return!0}(binData)?function(data){// process STL header
// check for default color in header ("COLOR=rgba" sequence).
for(var r,g,b,colors,defaultR,defaultG,defaultB,alpha,reader=new DataView(data),faces=reader.getUint32(80,!0),hasColors=!1,index=0;index<80-10;index++)1129270351==reader.getUint32(index,!1)/*COLO*/&&82==reader.getUint8(index+4)/*'R'*/&&61==reader.getUint8(index+5)/*'='*/&&(hasColors=!0,colors=new Float32Array(3*(3*faces)),defaultR=reader.getUint8(index+6)/255,defaultG=reader.getUint8(index+7)/255,defaultB=reader.getUint8(index+8)/255,alpha=reader.getUint8(index+9)/255);for(var geometry=new three__WEBPACK_IMPORTED_MODULE_0__.BufferGeometry,vertices=new Float32Array(3*(3*faces)),normals=new Float32Array(3*(3*faces)),face=0;face<faces;face++){var start=84+face*(12*4+2),normalX=reader.getFloat32(start,!0),normalY=reader.getFloat32(start+4,!0),normalZ=reader.getFloat32(start+8,!0);if(hasColors){var packedColor=reader.getUint16(start+48,!0);0==(32768&packedColor)?(r=(31&packedColor)/31,g=(31&packedColor>>5)/31,b=(31&packedColor>>10)/31):(r=defaultR,g=defaultG,b=defaultB)}for(var i=1;3>=i;i++){var vertexstart=start+12*i,componentIdx=3*(3*face)+3*(i-1);vertices[componentIdx]=reader.getFloat32(vertexstart,!0),vertices[componentIdx+1]=reader.getFloat32(vertexstart+4,!0),vertices[componentIdx+2]=reader.getFloat32(vertexstart+8,!0),normals[componentIdx]=normalX,normals[componentIdx+1]=normalY,normals[componentIdx+2]=normalZ,hasColors&&(colors[componentIdx]=r,colors[componentIdx+1]=g,colors[componentIdx+2]=b)}}return geometry.setAttribute("position",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(vertices,3)),geometry.setAttribute("normal",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(normals,3)),hasColors&&(geometry.setAttribute("color",new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(colors,3)),geometry.hasColors=!0,geometry.alpha=alpha),geometry}(binData):function(data){for(var result,geometry=new three__WEBPACK_IMPORTED_MODULE_0__.BufferGeometry,patternSolid=/solid([\s\S]*?)endsolid/g,patternFace=/facet([\s\S]*?)endfacet/g,faceCounter=0,patternFloat=/[\s]+([+-]?(?:\d*)(?:\.\d*)?(?:[eE][+-]?\d+)?)/.source,patternVertex=new RegExp("vertex"+patternFloat+patternFloat+patternFloat,"g"),patternNormal=new RegExp("normal"+patternFloat+patternFloat+patternFloat,"g"),vertices=[],normals=[],normal=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,groupCount=0,startVertex=0,endVertex=0;null!==(result=patternSolid.exec(data));){startVertex=endVertex;for(var solid=result[0];null!==(result=patternFace.exec(solid));){for(var vertexCountPerFace=0,normalCountPerFace=0,text=result[0];null!==(result=patternNormal.exec(text));)normal.x=parseFloat(result[1]),normal.y=parseFloat(result[2]),normal.z=parseFloat(result[3]),normalCountPerFace++;for(;null!==(result=patternVertex.exec(text));)vertices.push(parseFloat(result[1]),parseFloat(result[2]),parseFloat(result[3])),normals.push(normal.x,normal.y,normal.z),vertexCountPerFace++,endVertex++;// every face have to own ONE valid normal
1!==normalCountPerFace&&console.error("THREE.STLLoader: Something isn't right with the normal of face number "+faceCounter),3!==vertexCountPerFace&&console.error("THREE.STLLoader: Something isn't right with the vertices of face number "+faceCounter),faceCounter++}var start=startVertex,count=endVertex-startVertex;geometry.addGroup(start,count,groupCount),groupCount++}return geometry.setAttribute("position",new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(vertices,3)),geometry.setAttribute("normal",new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(normals,3)),geometry}(function(buffer){return"string"==typeof buffer?buffer:three__WEBPACK_IMPORTED_MODULE_0__.LoaderUtils.decodeText(new Uint8Array(buffer))}(data))}}

/***/ }),
/* 37 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OBJLoader: () => (/* binding */ OBJLoader)
/* harmony export */ });
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(three__WEBPACK_IMPORTED_MODULE_0__);
// o object_name | g group_name
var _object_pattern=/^[og]\s*(.+)?/,_material_library_pattern=/^mtllib /,_material_use_pattern=/^usemtl /,_map_use_pattern=/^usemap /,_vA=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_vB=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_vC=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_ab=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_cb=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3;// mtllib file_reference
// usemtl material_name
// usemap map_name
function ParserState(){var state={objects:[],object:{},vertices:[],normals:[],colors:[],uvs:[],materials:{},materialLibraries:[],startObject:function startObject(name,fromDeclaration){// If the current object (initial from reset) is not from a g/o declaration in the parsed
// file. We need to use it for the first parsed g/o to keep things in sync.
if(this.object&&!1===this.object.fromDeclaration)return this.object.name=name,void(this.object.fromDeclaration=!1!==fromDeclaration);var previousMaterial=this.object&&"function"==typeof this.object.currentMaterial?this.object.currentMaterial():void 0;// Inherit previous objects material.
// Spec tells us that a declared material must be set to all objects until a new material is declared.
// If a usemtl declaration is encountered while this new object is being parsed, it will
// overwrite the inherited material. Exception being that there was already face declarations
// to the inherited material, then it will be preserved for proper MultiMaterial continuation.
if(this.object&&"function"==typeof this.object._finalize&&this.object._finalize(!0),this.object={name:name||"",fromDeclaration:!1!==fromDeclaration,geometry:{vertices:[],normals:[],colors:[],uvs:[],hasUVIndices:!1},materials:[],smooth:!0,startMaterial:function startMaterial(name,libraries){var previous=this._finalize(!1);// New usemtl declaration overwrites an inherited material, except if faces were declared
// after the material, then it must be preserved for proper MultiMaterial continuation.
previous&&(previous.inherited||0>=previous.groupCount)&&this.materials.splice(previous.index,1);var material={index:this.materials.length,name:name||"",mtllib:Array.isArray(libraries)&&0<libraries.length?libraries[libraries.length-1]:"",smooth:void 0===previous?this.smooth:previous.smooth,groupStart:void 0===previous?0:previous.groupEnd,groupEnd:-1,groupCount:-1,inherited:!1,clone:function clone(index){var cloned={index:"number"==typeof index?index:this.index,name:this.name,mtllib:this.mtllib,smooth:this.smooth,groupStart:0,groupEnd:-1,groupCount:-1,inherited:!1};return cloned.clone=this.clone.bind(cloned),cloned}};return this.materials.push(material),material},currentMaterial:function currentMaterial(){return 0<this.materials.length?this.materials[this.materials.length-1]:void 0},_finalize:function _finalize(end){var lastMultiMaterial=this.currentMaterial();// Ignore objects tail materials if no face declarations followed them before a new o/g started.
if(lastMultiMaterial&&-1===lastMultiMaterial.groupEnd&&(lastMultiMaterial.groupEnd=this.geometry.vertices.length/3,lastMultiMaterial.groupCount=lastMultiMaterial.groupEnd-lastMultiMaterial.groupStart,lastMultiMaterial.inherited=!1),end&&1<this.materials.length)for(var mi=this.materials.length-1;0<=mi;mi--)0>=this.materials[mi].groupCount&&this.materials.splice(mi,1);// Guarantee at least one empty material, this makes the creation later more straight forward.
return end&&0===this.materials.length&&this.materials.push({name:"",smooth:this.smooth}),lastMultiMaterial}},previousMaterial&&previousMaterial.name&&"function"==typeof previousMaterial.clone){var declared=previousMaterial.clone(0);declared.inherited=!0,this.object.materials.push(declared)}this.objects.push(this.object)},finalize:function finalize(){this.object&&"function"==typeof this.object._finalize&&this.object._finalize(!0)},parseVertexIndex:function parseVertexIndex(value,len){var index=parseInt(value,10);return 3*(0<=index?index-1:index+len/3)},parseNormalIndex:function parseNormalIndex(value,len){var index=parseInt(value,10);return 3*(0<=index?index-1:index+len/3)},parseUVIndex:function parseUVIndex(value,len){var index=parseInt(value,10);return 2*(0<=index?index-1:index+len/2)},addVertex:function addVertex(a,b,c){var src=this.vertices,dst=this.object.geometry.vertices;dst.push(src[a+0],src[a+1],src[a+2]),dst.push(src[b+0],src[b+1],src[b+2]),dst.push(src[c+0],src[c+1],src[c+2])},addVertexPoint:function addVertexPoint(a){var src=this.vertices,dst=this.object.geometry.vertices;dst.push(src[a+0],src[a+1],src[a+2])},addVertexLine:function addVertexLine(a){var src=this.vertices,dst=this.object.geometry.vertices;dst.push(src[a+0],src[a+1],src[a+2])},addNormal:function addNormal(a,b,c){var src=this.normals,dst=this.object.geometry.normals;dst.push(src[a+0],src[a+1],src[a+2]),dst.push(src[b+0],src[b+1],src[b+2]),dst.push(src[c+0],src[c+1],src[c+2])},addFaceNormal:function addFaceNormal(a,b,c){var src=this.vertices,dst=this.object.geometry.normals;_vA.fromArray(src,a),_vB.fromArray(src,b),_vC.fromArray(src,c),_cb.subVectors(_vC,_vB),_ab.subVectors(_vA,_vB),_cb.cross(_ab),_cb.normalize(),dst.push(_cb.x,_cb.y,_cb.z),dst.push(_cb.x,_cb.y,_cb.z),dst.push(_cb.x,_cb.y,_cb.z)},addColor:function addColor(a,b,c){var src=this.colors,dst=this.object.geometry.colors;void 0!==src[a]&&dst.push(src[a+0],src[a+1],src[a+2]),void 0!==src[b]&&dst.push(src[b+0],src[b+1],src[b+2]),void 0!==src[c]&&dst.push(src[c+0],src[c+1],src[c+2])},addUV:function addUV(a,b,c){var src=this.uvs,dst=this.object.geometry.uvs;dst.push(src[a+0],src[a+1]),dst.push(src[b+0],src[b+1]),dst.push(src[c+0],src[c+1])},addDefaultUV:function addDefaultUV(){var dst=this.object.geometry.uvs;dst.push(0,0),dst.push(0,0),dst.push(0,0)},addUVLine:function addUVLine(a){var src=this.uvs,dst=this.object.geometry.uvs;dst.push(src[a+0],src[a+1])},addFace:function addFace(a,b,c,ua,ub,uc,na,nb,nc){var vLen=this.vertices.length,ia=this.parseVertexIndex(a,vLen),ib=this.parseVertexIndex(b,vLen),ic=this.parseVertexIndex(c,vLen);// normals
if(this.addVertex(ia,ib,ic),this.addColor(ia,ib,ic),void 0!==na&&""!==na){var nLen=this.normals.length;ia=this.parseNormalIndex(na,nLen),ib=this.parseNormalIndex(nb,nLen),ic=this.parseNormalIndex(nc,nLen),this.addNormal(ia,ib,ic)}else this.addFaceNormal(ia,ib,ic);// uvs
if(void 0!==ua&&""!==ua){var uvLen=this.uvs.length;ia=this.parseUVIndex(ua,uvLen),ib=this.parseUVIndex(ub,uvLen),ic=this.parseUVIndex(uc,uvLen),this.addUV(ia,ib,ic),this.object.geometry.hasUVIndices=!0}else// add placeholder values (for inconsistent face definitions)
this.addDefaultUV()},addPointGeometry:function addPointGeometry(vertices){this.object.geometry.type="Points";for(var index,vLen=this.vertices.length,vi=0,l=vertices.length;vi<l;vi++)index=this.parseVertexIndex(vertices[vi],vLen),this.addVertexPoint(index),this.addColor(index)},addLineGeometry:function addLineGeometry(vertices,uvs){this.object.geometry.type="Line";for(var vLen=this.vertices.length,uvLen=this.uvs.length,vi=0,l=vertices.length;vi<l;vi++)this.addVertexLine(this.parseVertexIndex(vertices[vi],vLen));for(var uvi=0,_l=uvs.length;uvi<_l;uvi++)this.addUVLine(this.parseUVIndex(uvs[uvi],uvLen))}};return state.startObject("",!1),state}//
class OBJLoader extends three__WEBPACK_IMPORTED_MODULE_0__.Loader{constructor(manager){super(manager),this.materials=null}load(url,onLoad,onProgress,onError){var scope=this,loader=new three__WEBPACK_IMPORTED_MODULE_0__.FileLoader(this.manager);loader.setPath(this.path),loader.setRequestHeader(this.requestHeader),loader.setWithCredentials(this.withCredentials),loader.load(url,function(text){try{onLoad(scope.parse(text))}catch(e){onError?onError(e):console.error(e),scope.manager.itemError(url)}},onProgress,onError)}setMaterials(materials){return this.materials=materials,this}parse(text){var state=new ParserState;-1!==text.indexOf("\r\n")&&(text=text.replace(/\r\n/g,"\n")),-1!==text.indexOf("\\\n")&&(text=text.replace(/\\\n/g,""));// Faster to just trim left side of the line. Use if available.
for(var lines=text.split("\n"),line="",lineFirstChar="",lineLength=0,result=[],trimLeft="function"==typeof"".trimLeft,i=0,l=lines.length;i<l;i++)if(line=lines[i],line=trimLeft?line.trimLeft():line.trim(),(lineLength=line.length,0!==lineLength&&(lineFirstChar=line.charAt(0),"#"!==lineFirstChar)))// @todo invoke passed in handler if any
if("v"===lineFirstChar){var data=line.split(/\s+/);switch(data[0]){case"v":state.vertices.push(parseFloat(data[1]),parseFloat(data[2]),parseFloat(data[3])),7<=data.length?state.colors.push(parseFloat(data[4]),parseFloat(data[5]),parseFloat(data[6])):state.colors.push(void 0,void 0,void 0);break;case"vn":state.normals.push(parseFloat(data[1]),parseFloat(data[2]),parseFloat(data[3]));break;case"vt":state.uvs.push(parseFloat(data[1]),parseFloat(data[2]))}}else if("f"===lineFirstChar){// Parse the face vertex data into an easy to work with format
for(var vertex,lineData=line.substr(1).trim(),vertexData=lineData.split(/\s+/),faceVertices=[],j=0,jl=vertexData.length;j<jl;j++)if(vertex=vertexData[j],0<vertex.length){var vertexParts=vertex.split("/");faceVertices.push(vertexParts)}// Draw an edge between the first vertex and all subsequent vertices to form an n-gon
for(var v1=faceVertices[0],_j=1,_jl=faceVertices.length-1;_j<_jl;_j++){var v2=faceVertices[_j],v3=faceVertices[_j+1];state.addFace(v1[0],v2[0],v3[0],v1[1],v2[1],v3[1],v1[2],v2[2],v3[2])}}else if("l"===lineFirstChar){var lineParts=line.substring(1).trim().split(" "),lineVertices=[],lineUVs=[];if(-1===line.indexOf("/"))lineVertices=lineParts;else for(var parts,li=0,llen=lineParts.length;li<llen;li++)parts=lineParts[li].split("/"),""!==parts[0]&&lineVertices.push(parts[0]),""!==parts[1]&&lineUVs.push(parts[1]);state.addLineGeometry(lineVertices,lineUVs)}else if("p"===lineFirstChar){var _lineData=line.substr(1).trim(),pointData=_lineData.split(" ");state.addPointGeometry(pointData)}else if(null!==(result=_object_pattern.exec(line))){// o object_name
// or
// g group_name
// WORKAROUND: https://bugs.chromium.org/p/v8/issues/detail?id=2869
// let name = result[ 0 ].substr( 1 ).trim();
var name=(" "+result[0].substr(1).trim()).substr(1);state.startObject(name)}else if(_material_use_pattern.test(line))// material
state.object.startMaterial(line.substring(7).trim(),state.materialLibraries);else if(_material_library_pattern.test(line))// mtl file
state.materialLibraries.push(line.substring(7).trim());else if(_map_use_pattern.test(line))// the line is parsed but ignored since the loader assumes textures are defined MTL files
// (according to https://www.okino.com/conv/imp_wave.htm, 'usemap' is the old-style Wavefront texture reference method)
console.warn("THREE.OBJLoader: Rendering identifier \"usemap\" not supported. Textures must be defined in MTL files.");else if("s"===lineFirstChar){// smooth shading
// @todo Handle files that have varying smooth values for a set of faces inside one geometry,
// but does not define a usemtl for each face set.
// This should be detected and a dummy material created (later MultiMaterial and geometry groups).
// This requires some care to not create extra material on each smooth value for "normal" obj files.
// where explicit usemtl defines geometry groups.
// Example asset: examples/models/obj/cerberus/Cerberus.obj
/*
					 * http://paulbourke.net/dataformats/obj/
					 * or
					 * http://www.cs.utah.edu/~boulos/cs3505/obj_spec.pdf
					 *
					 * From chapter "Grouping" Syntax explanation "s group_number":
					 * "group_number is the smoothing group number. To turn off smoothing groups, use a value of 0 or off.
					 * Polygonal elements use group numbers to put elements in different smoothing groups. For free-form
					 * surfaces, smoothing groups are either turned on or off; there is no difference between values greater
					 * than 0."
					 */if(result=line.split(" "),1<result.length){var value=result[1].trim().toLowerCase();state.object.smooth="0"!==value&&"off"!==value}else// ZBrush can produce "s" lines #11707
state.object.smooth=!0;var material=state.object.currentMaterial();material&&(material.smooth=state.object.smooth)}else{// Handle null terminated files without exception
if("\0"===line)continue;console.warn("THREE.OBJLoader: Unexpected line: \""+line+"\"")}state.finalize();var container=new three__WEBPACK_IMPORTED_MODULE_0__.Group;container.materialLibraries=[].concat(state.materialLibraries);var hasPrimitives=1!==state.objects.length||0!==state.objects[0].geometry.vertices.length;if(!0==hasPrimitives)for(var _i=0,_l2=state.objects.length;_i<_l2;_i++){var object=state.objects[_i],geometry=object.geometry,materials=object.materials,isLine="Line"===geometry.type,isPoints="Points"===geometry.type,hasVertexColors=!1;// Skip o/g line declarations that did not follow with any faces
if(0!==geometry.vertices.length){var buffergeometry=new three__WEBPACK_IMPORTED_MODULE_0__.BufferGeometry;buffergeometry.setAttribute("position",new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(geometry.vertices,3)),0<geometry.normals.length&&buffergeometry.setAttribute("normal",new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(geometry.normals,3)),0<geometry.colors.length&&(hasVertexColors=!0,buffergeometry.setAttribute("color",new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(geometry.colors,3))),!0===geometry.hasUVIndices&&buffergeometry.setAttribute("uv",new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(geometry.uvs,2));for(var createdMaterials=[],mi=0,miLen=materials.length;mi<miLen;mi++){var sourceMaterial=materials[mi],materialHash=sourceMaterial.name+"_"+sourceMaterial.smooth+"_"+hasVertexColors,_material=state.materials[materialHash];if(null!==this.materials)// mtl etc. loaders probably can't create line materials correctly, copy properties to a line material.
if(_material=this.materials.create(sourceMaterial.name),isLine&&_material&&!(_material instanceof three__WEBPACK_IMPORTED_MODULE_0__.LineBasicMaterial)){var materialLine=new three__WEBPACK_IMPORTED_MODULE_0__.LineBasicMaterial;three__WEBPACK_IMPORTED_MODULE_0__.Material.prototype.copy.call(materialLine,_material),materialLine.color.copy(_material.color),_material=materialLine}else if(isPoints&&_material&&!(_material instanceof three__WEBPACK_IMPORTED_MODULE_0__.PointsMaterial)){var materialPoints=new three__WEBPACK_IMPORTED_MODULE_0__.PointsMaterial({size:10,sizeAttenuation:!1});three__WEBPACK_IMPORTED_MODULE_0__.Material.prototype.copy.call(materialPoints,_material),materialPoints.color.copy(_material.color),materialPoints.map=_material.map,_material=materialPoints}void 0===_material&&(_material=isLine?new three__WEBPACK_IMPORTED_MODULE_0__.LineBasicMaterial:isPoints?new three__WEBPACK_IMPORTED_MODULE_0__.PointsMaterial({size:1,sizeAttenuation:!1}):new three__WEBPACK_IMPORTED_MODULE_0__.MeshPhongMaterial,_material.name=sourceMaterial.name,_material.flatShading=!sourceMaterial.smooth,_material.vertexColors=hasVertexColors,state.materials[materialHash]=_material),createdMaterials.push(_material)}// Create mesh
var mesh=void 0;if(1<createdMaterials.length){for(var _sourceMaterial,_mi=0,_miLen=materials.length;_mi<_miLen;_mi++)_sourceMaterial=materials[_mi],buffergeometry.addGroup(_sourceMaterial.groupStart,_sourceMaterial.groupCount,_mi);mesh=isLine?new three__WEBPACK_IMPORTED_MODULE_0__.LineSegments(buffergeometry,createdMaterials):isPoints?new three__WEBPACK_IMPORTED_MODULE_0__.Points(buffergeometry,createdMaterials):new three__WEBPACK_IMPORTED_MODULE_0__.Mesh(buffergeometry,createdMaterials)}else mesh=isLine?new three__WEBPACK_IMPORTED_MODULE_0__.LineSegments(buffergeometry,createdMaterials[0]):isPoints?new three__WEBPACK_IMPORTED_MODULE_0__.Points(buffergeometry,createdMaterials[0]):new three__WEBPACK_IMPORTED_MODULE_0__.Mesh(buffergeometry,createdMaterials[0]);mesh.name=object.name,container.add(mesh)}// Create materials
}else// if there is only the default parser state object with no geometry data, interpret data as point cloud
if(0<state.vertices.length){var _material2=new three__WEBPACK_IMPORTED_MODULE_0__.PointsMaterial({size:1,sizeAttenuation:!1}),_buffergeometry=new three__WEBPACK_IMPORTED_MODULE_0__.BufferGeometry;_buffergeometry.setAttribute("position",new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(state.vertices,3)),0<state.colors.length&&void 0!==state.colors[0]&&(_buffergeometry.setAttribute("color",new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute(state.colors,3)),_material2.vertexColors=!0);var points=new three__WEBPACK_IMPORTED_MODULE_0__.Points(_buffergeometry,_material2);container.add(points)}return container}}

/***/ }),
/* 38 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter(function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable})),t.push.apply(t,o)}return t}function _objectSpread(e){for(var t,r=1;r<arguments.length;r++)t=null==arguments[r]?{}:arguments[r],r%2?ownKeys(Object(t),!0).forEach(function(r){_defineProperty(e,r,t[r])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach(function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))});return e}function _defineProperty(e,r,t){return(r=_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function _toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}var JSONLoader=(__webpack_require__(19).JSONLoader),THREE=__webpack_require__(4),FileLoader=THREE.FileLoader,mergeGeometries=geometries=>{var merge=(geometry1,geometry2)=>{geometry1.merge(geometry2)};if(geometries&&0<geometries.length){for(;1<geometries.length;){var geometry2=geometries.splice(1,1);merge(geometries[0],geometry2[0])}return geometries[0]}},IndexedSourcesHandler=function IndexedSourcesHandler(urlIn,crossOrigin,onDownloadedCallback){var loader=new FileLoader,jsonLoader=new JSONLoader;loader.crossOrigin=crossOrigin;var url=urlIn,onDownloaded=onDownloadedCallback,data=void 0,downloading=!1,finished=!1,error=void 0,items=[],processItemDownloaded=item=>{var modelData=data[item.index];if(modelData){var obj=jsonLoader.parse(modelData);item.onLoad(obj.geometry,obj.materials)}else processItemError(item,{responseURL:url})},processItemError=item=>{item.onError&&(!error&&(error={responseURL:url}),item.onError(error))};this.downloadCompleted=args=>{try{data=JSON.parse(args[0]),downloading=!1,finished=!0,Array.isArray(data)?items.forEach(item=>processItemDownloaded(item)):items.forEach(item=>processItemError(item))}catch(_unused){items.forEach(item=>processItemError(item))}};var errorHandling=()=>xhr=>{error=xhr,finished=!0,downloading=!1,items.forEach(item=>{processItemError(item)})},progressHandling=()=>xhr=>{items.forEach(item=>{item.onProgress&&item.onProgress(xhr)})};this.load=(index,onLoad,onProgress,onError)=>{var item={index,onLoad,onProgress,onError};finished?data?processItemDownloaded(item):processItemError(error):downloading?items.push(item):(items.push(item),downloading=!0,loader.load(url,onDownloaded,progressHandling,errorHandling))}},MultiSourcesHandler=function MultiSourcesHandler(numberIn,onLoadCallback){var allData=[],number=numberIn,onLoad=onLoadCallback,totalDownloaded=0;this.itemDownloaded=(order,args)=>{if(allData[order]=args,totalDownloaded++,totalDownloaded==number){//All geometries will be merged into the first one
for(var materials=allData[0][1],geometries=allData.map(data=>data[0]),geometry=mergeGeometries(geometries),i=1;i<number;i++)allData[order][0].dispose(),allData[order][1].forEach(material=>material.dispose());onLoad(geometry,materials)}}};exports.PrimitivesLoader=function(){var concurrentDownloads=0,MAX_DOWNLOAD=20;this.crossOrigin="Anonymous";var loader=new JSONLoader,waitingList=[],indexedLoaders={},loadFromMultipleSources=(urls,onLoad,onProgress,onError,options)=>{var number=urls.length,msHandler=new MultiSourcesHandler(number,onLoad),order=0;//The order here will give us hint on the sequence on merging the primitives
urls.forEach(url=>{var newOptions=options?_objectSpread({},options):{};newOptions.msHandler=msHandler,newOptions.order=order,order++,loadFromSingleSource(url,onLoad,onProgress,onError,newOptions)})},handleIndexedSource=(url,onLoad,onProgress,onError,options)=>{var newOptions=options?_objectSpread({},options):{},indexedLoader=indexedLoaders[url];if(!indexedLoader)if(MAX_DOWNLOAD>concurrentDownloads){var onLoadCallback=new onFinally(void 0,this,newOptions);++concurrentDownloads,indexedLoader=new IndexedSourcesHandler(url,this.crossOrigin,onLoadCallback),indexedLoaders[url]=indexedLoader}else waitingList.push({url,onLoad,onProgress,onError,options});indexedLoader&&(newOptions.isHandler=indexedLoader,indexedLoader.load(options.index,onLoad,onProgress,onError))},loadFromSingleSource=(url,onLoad,onProgress,onError,options)=>{if(options&&options.index!==void 0)handleIndexedSource(url,onLoad,onProgress,onError,options);else//Standard loading
if(MAX_DOWNLOAD>concurrentDownloads){++concurrentDownloads;var onLoadCallback=new onFinally(onLoad,this,options),onErrorCallback=new onFinally(onError,this,options);loader.crossOrigin=this.crossOrigin,loader.load(url,onLoadCallback,onProgress,onErrorCallback)}else waitingList.push({url,onLoad,onProgress,onError,options})};//URL to loader pair
//Load the first file then the rest will be handled separately
this.load=(url,onLoad,onProgress,onError,options)=>{Array.isArray(url)?loadFromMultipleSources(url,onLoad,onProgress,onError,options):loadFromSingleSource(url,onLoad,onProgress,onError,options)},this.loadFromWaitingList=()=>{for(;MAX_DOWNLOAD>concurrentDownloads;){var item=waitingList.shift();if(item)this.load(item.url,item.onLoad,item.onProgress,item.onError,item.options);else return}},this.itemRemainingCheck=()=>{if(0===waitingList.length&&0==concurrentDownloads)for(var key in indexedLoaders)indexedLoaders.hasOwnProperty(key)&&delete indexedLoaders[key]};var onFinally=function onFinally(callback,loader,options){return function(){--concurrentDownloads;for(var _len=arguments.length,args=Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];null!==options&&void 0!==options&&options.msHandler?options.msHandler.itemDownloaded(options.order,args):null!==options&&void 0!==options&&options.isHandler?options.isHandler.downloadCompleted(args):callback&&callback(...args),loader.loadFromWaitingList(),loader.itemRemainingCheck()}};this.parse=data=>loader.parse(data)};

/***/ }),
/* 39 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),mergeGeometries=(__webpack_require__(5).mergeGeometries),TubeLines=function(){(__webpack_require__(10).ZincObject).call(this),this.isTubeLines=!0;var dataIn={},geometryConfig={radius:1,radialSegments:8,smooth:!1};/**
     * Create the line segements using geometry and material.
     * 
     * @param {THREE.Geomtry} geometryIn - Geometry of lines to be rendered.
     * @param {THREE.Material} materialIn - Material to be set for the lines.
     * @param {Object} options - Provide various options
     * @param {Boolean} options.localTimeEnabled - A flag to indicate either the lines is
     * time dependent.
     * @param {Boolean} options.localMorphColour - A flag to indicate either the colour is
     * time dependent.
     */this.createLineSegment=(geometryIn,materialIn,options)=>{if(geometryIn&&materialIn){dataIn={geometryIn,materialIn,options};var geometry=getTubeLinesGeometry(geometryIn.vertices),material=new THREE.MeshStandardMaterial({color:materialIn.color}),mesh=new THREE.Mesh(geometry,material);this.setMesh(mesh,options.localTimeEnabled,options.localMorphColour)}},this.setWidth=width=>{this.morph&&this.morph.material&&(this.morph.material.linewidth=width,this.morph.material.needsUpdate=!0)},this.setAlpha=function(alpha){var mesh=this.getMorph();mesh.material.opacity=alpha,mesh.material.transparent=1>alpha,mesh.material.depthWrite=.5<alpha},this.setWireframe=wireframe=>{var mesh=this.getMorph();mesh.material.wireframe=wireframe},this.setTubeLines=(radius,radialSegments)=>{if(radius&&radialSegments){var{geometryIn}=dataIn,mesh=this.getMorph();mesh.geometry.dispose(),geometryConfig=Object.assign(geometryConfig,{radius,radialSegments}),mesh.geometry=getTubeLinesGeometry(geometryIn.vertices)}};/**
     * Get merged geometry from list of geometry vertices
     * 
     * @param {Array} vertices - An array of THREE.Vector3 vertices.
     * @returns {Object}
     */var getTubeLinesGeometry=vertices=>{var finalGeometry,{radius,radialSegments,smooth}=geometryConfig;if(smooth){var curve=new THREE.CatmullRomCurve3(vertices);finalGeometry=new THREE.TubeGeometry(curve,vertices.length,radius,radialSegments,!1)}else{for(var geometries=[],i=0;i+1<vertices.length;i+=2){var _curve=new THREE.LineCurve3(vertices[i],vertices[i+1]),tubeGeometry=new THREE.TubeGeometry(_curve,1,radius,radialSegments,!1);geometries.push(tubeGeometry)}finalGeometry=mergeGeometries(geometries,!0),geometries.forEach(g=>g.dispose())}return finalGeometry}};/**
 * Provides an object which stores lines.
 * This is created when a valid json file containing lines is read into a {@link Zinc.Scene}
 * object.
 * 
 * @class
 * @author Alan Wu
 * @return {TubeLines}
 */TubeLines.prototype=Object.create((__webpack_require__(10).ZincObject).prototype),exports.TubeLines=TubeLines;

/***/ }),
/* 40 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),GLTFLoader=(__webpack_require__(41).GLTFLoader),GLTFToZincJSLoader=function(){var _this=this;/**
   * Load GLTF into this scene object.
   * 
   * @param {String} url - URL to the GLTF file
   * @param {Function} finishCallback - Callback function which will be called
   * once the glyphset is succssfully load in.
   */this.parseGLTFObjects=(object,region,depth,finishCallback)=>{var childRegion=region;if(0!==depth)if("Object3D"!==object.type){var zincGeometry;if("Mesh"===object.type?zincGeometry=new((__webpack_require__(3).Geometry)):"LineSegments"===object.type?zincGeometry=new((__webpack_require__(24).Lines)):"Points"===object.type&&(zincGeometry=new((__webpack_require__(22).Pointset))),zincGeometry){var localTimeEnabled=!1,localMorphColour=!1;object.geometry&&object.geometry.morphAttributes&&(localTimeEnabled=!!object.geometry.morphAttributes.position,localMorphColour=!!object.geometry.morphAttributes.color),zincGeometry.setMesh(object.clone(),localTimeEnabled,localMorphColour);var morph=zincGeometry.getMorph();zincGeometry.groupName=morph.name,morph.matrixAutoUpdate=!0,region.addZincObject(zincGeometry),null!=finishCallback&&"function"==typeof finishCallback&&finishCallback(zincGeometry)}}else if(""!==object.name&&(region&&(childRegion=region.findOrCreateChildFromPath(object.name)),childRegion)){var group=childRegion.getGroup();group.position.copy(object.position),group.rotation.copy(object.rotation),group.quaternion.copy(object.quaternion),group.matrixAutoUpdate=!0}depth++,object.children.forEach(child=>{_this.parseGLTFObjects(child,childRegion,depth,finishCallback)})},this.setCamera=scene=>{scene.viewAll();var cameraControls=scene.getZincCameraControls(),viewport=cameraControls.getCurrentViewport();cameraControls.addViewport("default",viewport),cameraControls.setDefaultViewport("default")},this.load=(scene,region,url,finishCallback,allCompletedCallback)=>{var path=url.substring(0,url.lastIndexOf("/")+1),filename=url.substring(url.lastIndexOf("/")+1,url.length),loader=new GLTFLoader().setPath(path);loader.load(filename,function(gltf){console.log(gltf),_this.parseGLTFObjects(gltf.scene,region,0,finishCallback),_this.setCamera(scene),allCompletedCallback!=null&&"function"==typeof allCompletedCallback&&allCompletedCallback()})}};exports.GLTFToZincJSLoader=GLTFToZincJSLoader;

/***/ }),
/* 41 */
/***/ ((module) => {

"use strict";
module.exports = require("three/examples/jsm/loaders/GLTFLoader");

/***/ }),
/* 42 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var GLTFExporter=(__webpack_require__(43).GLTFExporter),SceneExporter=function(sceneIn){var scene=sceneIn;this.exportGLTF=binary=>{var rootRegion=scene.getRootRegion(),zincObjects=rootRegion.getAllObjects(!0),animations=[];zincObjects.forEach(zincObject=>{zincObject.animationClip&&animations.push({clip:zincObject.animationClip[0],mesh:zincObject.getMorph()})});var exporter=new GLTFExporter,options={binary,animations};return new Promise(resolve=>{exporter.parse(scene.getThreeJSScene(),function(gltf){resolve(gltf)},options)})}};/**
 * Provides an object which uses for exporting the scene
 * 
 * @class
 * @author Alan Wu
 * @return {SceneExporter}
 */exports.SceneExporter=SceneExporter;

/***/ }),
/* 43 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GLTFExporter: () => (/* binding */ GLTFExporter)
/* harmony export */ });
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(three__WEBPACK_IMPORTED_MODULE_0__);
class GLTFExporter{constructor(){this.pluginCallbacks=[],this.register(function(writer){return new GLTFLightExtension(writer)}),this.register(function(writer){return new GLTFMaterialsUnlitExtension(writer)}),this.register(function(writer){return new GLTFMaterialsPBRSpecularGlossiness(writer)})}register(callback){return-1===this.pluginCallbacks.indexOf(callback)&&this.pluginCallbacks.push(callback),this}unregister(callback){return-1!==this.pluginCallbacks.indexOf(callback)&&this.pluginCallbacks.splice(this.pluginCallbacks.indexOf(callback),1),this}/**
	 * Parse scenes and generate GLTF output
	 * @param  {Scene or [THREE.Scenes]} input   Scene or Array of THREE.Scenes
	 * @param  {Function} onDone  Callback on completed
	 * @param  {Object} options options
	 */parse(input,onDone,options){for(var writer=new GLTFWriter,plugins=[],i=0,il=this.pluginCallbacks.length;i<il;i++)plugins.push(this.pluginCallbacks[i](writer));writer.setPlugins(plugins),writer.write(input,onDone,options)}}//------------------------------------------------------------------------------
// Constants
//------------------------------------------------------------------------------
var WEBGL_CONSTANTS={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,FLOAT:5126,UNSIGNED_INT:5125,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,REPEAT:10497},THREE_TO_WEBGL={};THREE_TO_WEBGL[three__WEBPACK_IMPORTED_MODULE_0__.NearestFilter]=WEBGL_CONSTANTS.NEAREST,THREE_TO_WEBGL[three__WEBPACK_IMPORTED_MODULE_0__.NearestMipmapNearestFilter]=WEBGL_CONSTANTS.NEAREST_MIPMAP_NEAREST,THREE_TO_WEBGL[three__WEBPACK_IMPORTED_MODULE_0__.NearestMipmapLinearFilter]=WEBGL_CONSTANTS.NEAREST_MIPMAP_LINEAR,THREE_TO_WEBGL[three__WEBPACK_IMPORTED_MODULE_0__.LinearFilter]=WEBGL_CONSTANTS.LINEAR,THREE_TO_WEBGL[three__WEBPACK_IMPORTED_MODULE_0__.LinearMipmapNearestFilter]=WEBGL_CONSTANTS.LINEAR_MIPMAP_NEAREST,THREE_TO_WEBGL[three__WEBPACK_IMPORTED_MODULE_0__.LinearMipmapLinearFilter]=WEBGL_CONSTANTS.LINEAR_MIPMAP_LINEAR,THREE_TO_WEBGL[three__WEBPACK_IMPORTED_MODULE_0__.ClampToEdgeWrapping]=WEBGL_CONSTANTS.CLAMP_TO_EDGE,THREE_TO_WEBGL[three__WEBPACK_IMPORTED_MODULE_0__.RepeatWrapping]=WEBGL_CONSTANTS.REPEAT,THREE_TO_WEBGL[three__WEBPACK_IMPORTED_MODULE_0__.MirroredRepeatWrapping]=WEBGL_CONSTANTS.MIRRORED_REPEAT;var PATH_PROPERTIES={scale:"scale",position:"translation",quaternion:"rotation",morphTargetInfluences:"weights"},GLB_HEADER_BYTES=12,GLB_HEADER_MAGIC=1179937895,GLB_VERSION=2,GLB_CHUNK_PREFIX_BYTES=8,GLB_CHUNK_TYPE_JSON=1313821514,GLB_CHUNK_TYPE_BIN=5130562;// GLB constants
// https://github.com/KhronosGroup/glTF/blob/master/specification/2.0/README.md#glb-file-format-specification
//------------------------------------------------------------------------------
// Utility functions
//------------------------------------------------------------------------------
/**
 * Compare two arrays
 * @param  {Array} array1 Array 1 to compare
 * @param  {Array} array2 Array 2 to compare
 * @return {Boolean}        Returns true if both arrays are equal
 */function equalArray(array1,array2){return array1.length===array2.length&&array1.every(function(element,index){return element===array2[index]})}/**
 * Converts a string to an ArrayBuffer.
 * @param  {string} text
 * @return {ArrayBuffer}
 */function stringToArrayBuffer(text){if(window.TextEncoder!==void 0)return new TextEncoder().encode(text).buffer;for(var value,array=new Uint8Array(new ArrayBuffer(text.length)),i=0,il=text.length;i<il;i++)// Replacing multi-byte character with space(0x20).
value=text.charCodeAt(i),array[i]=255<value?32:value;return array.buffer}/**
 * Is identity matrix
 *
 * @param {Matrix4} matrix
 * @returns {Boolean} Returns true, if parameter is identity matrix
 */function isIdentityMatrix(matrix){return equalArray(matrix.elements,[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1])}/**
 * Get the min and max vectors from the given attribute
 * @param  {BufferAttribute} attribute Attribute to find the min/max in range from start to start + count
 * @param  {Integer} start
 * @param  {Integer} count
 * @return {Object} Object containing the `min` and `max` values (As an array of attribute.itemSize components)
 */function getMinMax(attribute,start,count){for(var output={min:Array(attribute.itemSize).fill(Number.POSITIVE_INFINITY),max:Array(attribute.itemSize).fill(Number.NEGATIVE_INFINITY)},i=start;i<start+count;i++)for(var value,a=0;a<attribute.itemSize;a++)value=void 0,4<attribute.itemSize?value=attribute.array[i*attribute.itemSize+a]:0===a?value=attribute.getX(i):1===a?value=attribute.getY(i):2===a?value=attribute.getZ(i):3==a&&(value=attribute.getW(i)),output.min[a]=Math.min(output.min[a],value),output.max[a]=Math.max(output.max[a],value);return output}/**
 * Get the required size + padding for a buffer, rounded to the next 4-byte boundary.
 * https://github.com/KhronosGroup/glTF/tree/master/specification/2.0#data-alignment
 *
 * @param {Integer} bufferSize The size the original buffer.
 * @returns {Integer} new buffer size with required padding.
 *
 */function getPaddedBufferSize(bufferSize){return 4*Math.ceil(bufferSize/4)}/**
 * Returns a buffer aligned to 4-byte boundary.
 *
 * @param {ArrayBuffer} arrayBuffer Buffer to pad
 * @param {Integer} paddingByte (Optional)
 * @returns {ArrayBuffer} The same buffer if it's already aligned to 4-byte boundary or a new buffer
 */function getPaddedArrayBuffer(arrayBuffer){var paddingByte=1<arguments.length&&arguments[1]!==void 0?arguments[1]:0,paddedLength=getPaddedBufferSize(arrayBuffer.byteLength);if(paddedLength!==arrayBuffer.byteLength){var array=new Uint8Array(paddedLength);if(array.set(new Uint8Array(arrayBuffer)),0!==paddingByte)for(var i=arrayBuffer.byteLength;i<paddedLength;i++)array[i]=paddingByte;return array.buffer}return arrayBuffer}var cachedCanvas=null;/**
 * Writer
 */class GLTFWriter{constructor(){this.plugins=[],this.options={},this.pending=[],this.buffers=[],this.byteOffset=0,this.buffers=[],this.nodeMap=new Map,this.skins=[],this.extensionsUsed={},this.uids=new Map,this.uid=0,this.json={asset:{version:"2.0",generator:"THREE.GLTFExporter"}},this.cache={meshes:new Map,attributes:new Map,attributesNormalized:new Map,materials:new Map,textures:new Map,images:new Map}}setPlugins(plugins){this.plugins=plugins}/**
	 * Parse scenes and generate GLTF output
	 * @param  {Scene or [THREE.Scenes]} input   Scene or Array of THREE.Scenes
	 * @param  {Function} onDone  Callback on completed
	 * @param  {Object} options options
	 */write(input,onDone,options){this.options=Object.assign({},{// default options
binary:!1,trs:!1,onlyVisible:!0,truncateDrawRange:!0,embedImages:!0,maxTextureSize:1/0,animations:[],includeCustomExtensions:!1},options),0<this.options.animations.length&&(this.options.trs=!0),this.processInput(input);var writer=this;Promise.all(this.pending).then(function(){var buffers=writer.buffers,json=writer.json,options=writer.options,extensionsUsed=writer.extensionsUsed,blob=new Blob(buffers,{type:"application/octet-stream"}),extensionsUsedList=Object.keys(extensionsUsed);// Merge buffers.
// Declare extensions.
if(0<extensionsUsedList.length&&(json.extensionsUsed=extensionsUsedList),json.buffers&&0<json.buffers.length&&(json.buffers[0].byteLength=blob.size),!0===options.binary){// https://github.com/KhronosGroup/glTF/blob/master/specification/2.0/README.md#glb-file-format-specification
var reader=new window.FileReader;reader.readAsArrayBuffer(blob),reader.onloadend=function(){// Binary chunk.
var binaryChunk=getPaddedArrayBuffer(reader.result),binaryChunkPrefix=new DataView(new ArrayBuffer(GLB_CHUNK_PREFIX_BYTES));binaryChunkPrefix.setUint32(0,binaryChunk.byteLength,!0),binaryChunkPrefix.setUint32(4,GLB_CHUNK_TYPE_BIN,!0);// JSON chunk.
var jsonChunk=getPaddedArrayBuffer(stringToArrayBuffer(JSON.stringify(json)),32),jsonChunkPrefix=new DataView(new ArrayBuffer(GLB_CHUNK_PREFIX_BYTES));jsonChunkPrefix.setUint32(0,jsonChunk.byteLength,!0),jsonChunkPrefix.setUint32(4,GLB_CHUNK_TYPE_JSON,!0);// GLB header.
var header=new ArrayBuffer(GLB_HEADER_BYTES),headerView=new DataView(header);headerView.setUint32(0,GLB_HEADER_MAGIC,!0),headerView.setUint32(4,GLB_VERSION,!0);var totalByteLength=GLB_HEADER_BYTES+jsonChunkPrefix.byteLength+jsonChunk.byteLength+binaryChunkPrefix.byteLength+binaryChunk.byteLength;headerView.setUint32(8,totalByteLength,!0);var glbBlob=new Blob([header,jsonChunkPrefix,jsonChunk,binaryChunkPrefix,binaryChunk],{type:"application/octet-stream"}),glbReader=new window.FileReader;glbReader.readAsArrayBuffer(glbBlob),glbReader.onloadend=function(){onDone(glbReader.result)}}}else if(json.buffers&&0<json.buffers.length){var _reader=new window.FileReader;_reader.readAsDataURL(blob),_reader.onloadend=function(){var base64data=_reader.result;json.buffers[0].uri=base64data,onDone(json)}}else onDone(json)})}/**
	 * Serializes a userData.
	 *
	 * @param {THREE.Object3D|THREE.Material} object
	 * @param {Object} objectDef
	 */serializeUserData(object,objectDef){if(!(object.userData&&object.userData.isZincObject)&&0!==Object.keys(object.userData).length){var options=this.options,extensionsUsed=this.extensionsUsed;try{var json=JSON.parse(JSON.stringify(object.userData));if(options.includeCustomExtensions&&json.gltfExtensions){for(var extensionName in void 0===objectDef.extensions&&(objectDef.extensions={}),json.gltfExtensions)objectDef.extensions[extensionName]=json.gltfExtensions[extensionName],extensionsUsed[extensionName]=!0;delete json.gltfExtensions}0<Object.keys(json).length&&(objectDef.extras=json)}catch(error){console.warn("THREE.GLTFExporter: userData of '"+object.name+"' "+"won't be serialized because of JSON.stringify error - "+error.message)}}}/**
	 * Assign and return a temporal unique id for an object
	 * especially which doesn't have .uuid
	 * @param  {Object} object
	 * @return {Integer}
	 */getUID(object){return this.uids.has(object)||this.uids.set(object,this.uid++),this.uids.get(object)}/**
	 * Checks if normal attribute values are normalized.
	 *
	 * @param {BufferAttribute} normal
	 * @returns {Boolean}
	 */isNormalizedNormalAttribute(normal){var cache=this.cache;if(cache.attributesNormalized.has(normal))return!1;for(var v=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,i=0,il=normal.count;i<il;i++)// 0.0005 is from glTF-validator
if(5e-4<Math.abs(v.fromBufferAttribute(normal,i).length()-1))return!1;return!0}/**
	 * Creates normalized normal buffer attribute.
	 *
	 * @param {BufferAttribute} normal
	 * @returns {BufferAttribute}
	 *
	 */createNormalizedNormalAttribute(normal){var cache=this.cache;if(cache.attributesNormalized.has(normal))return cache.attributesNormalized.get(normal);for(var attribute=normal.clone(),v=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,i=0,il=attribute.count;i<il;i++)v.fromBufferAttribute(attribute,i),0===v.x&&0===v.y&&0===v.z?v.setX(1):v.normalize(),attribute.setXYZ(i,v.x,v.y,v.z);return cache.attributesNormalized.set(normal,attribute),attribute}/**
	 * Applies a texture transform, if present, to the map definition. Requires
	 * the KHR_texture_transform extension.
	 *
	 * @param {Object} mapDef
	 * @param {THREE.Texture} texture
	 */applyTextureTransform(mapDef,texture){var didTransform=!1,transformDef={};(0!==texture.offset.x||0!==texture.offset.y)&&(transformDef.offset=texture.offset.toArray(),didTransform=!0),0!==texture.rotation&&(transformDef.rotation=texture.rotation,didTransform=!0),(1!==texture.repeat.x||1!==texture.repeat.y)&&(transformDef.scale=texture.repeat.toArray(),didTransform=!0),didTransform&&(mapDef.extensions=mapDef.extensions||{},mapDef.extensions.KHR_texture_transform=transformDef,this.extensionsUsed.KHR_texture_transform=!0)}/**
	 * Process a buffer to append to the default one.
	 * @param  {ArrayBuffer} buffer
	 * @return {Integer}
	 */processBuffer(buffer){var json=this.json,buffers=this.buffers;return json.buffers||(json.buffers=[{byteLength:0}]),buffers.push(buffer),0}/**
	 * Process and generate a BufferView
	 * @param  {BufferAttribute} attribute
	 * @param  {number} componentType
	 * @param  {number} start
	 * @param  {number} count
	 * @param  {number} target (Optional) Target usage of the BufferView
	 * @return {Object}
	 */processBufferView(attribute,componentType,start,count,target){var json=this.json;json.bufferViews||(json.bufferViews=[]);// Create a new dataview and dump the attribute's array into it
var componentSize=componentType===WEBGL_CONSTANTS.UNSIGNED_BYTE?1:componentType===WEBGL_CONSTANTS.UNSIGNED_SHORT?2:4;for(var byteLength=getPaddedBufferSize(count*attribute.itemSize*componentSize),dataView=new DataView(new ArrayBuffer(byteLength)),offset=0,i=start;i<start+count;i++)for(var value,a=0;a<attribute.itemSize;a++)value=void 0,4<attribute.itemSize?value=attribute.array[i*attribute.itemSize+a]:0===a?value=attribute.getX(i):1===a?value=attribute.getY(i):2===a?value=attribute.getZ(i):3==a&&(value=attribute.getW(i)),componentType===WEBGL_CONSTANTS.FLOAT?dataView.setFloat32(offset,value,!0):componentType===WEBGL_CONSTANTS.UNSIGNED_INT?dataView.setUint32(offset,value,!0):componentType===WEBGL_CONSTANTS.UNSIGNED_SHORT?dataView.setUint16(offset,value,!0):componentType===WEBGL_CONSTANTS.UNSIGNED_BYTE&&dataView.setUint8(offset,value),offset+=componentSize;var bufferViewDef={buffer:this.processBuffer(dataView.buffer),byteOffset:this.byteOffset,byteLength:byteLength};target!==void 0&&(bufferViewDef.target=target),target===WEBGL_CONSTANTS.ARRAY_BUFFER&&(bufferViewDef.byteStride=attribute.itemSize*componentSize),this.byteOffset+=byteLength,json.bufferViews.push(bufferViewDef);// @TODO Merge bufferViews where possible.
var output={id:json.bufferViews.length-1,byteLength:0};return output}/**
	 * Process and generate a BufferView from an image Blob.
	 * @param {Blob} blob
	 * @return {Promise<Integer>}
	 */processBufferViewImage(blob){var writer=this,json=writer.json;return json.bufferViews||(json.bufferViews=[]),new Promise(function(resolve){var reader=new window.FileReader;reader.readAsArrayBuffer(blob),reader.onloadend=function(){var buffer=getPaddedArrayBuffer(reader.result),bufferViewDef={buffer:writer.processBuffer(buffer),byteOffset:writer.byteOffset,byteLength:buffer.byteLength};writer.byteOffset+=buffer.byteLength,resolve(json.bufferViews.push(bufferViewDef)-1)}})}/**
	 * Process attribute to generate an accessor
	 * @param  {BufferAttribute} attribute Attribute to process
	 * @param  {THREE.BufferGeometry} geometry (Optional) Geometry used for truncated draw range
	 * @param  {Integer} start (Optional)
	 * @param  {Integer} count (Optional)
	 * @return {Integer|null} Index of the processed accessor on the "accessors" array
	 */processAccessor(attribute,geometry,start,count){var componentType,options=this.options,json=this.json;// Detect the component type of the attribute array (float, uint or ushort)
if(attribute.array.constructor===Float32Array)componentType=WEBGL_CONSTANTS.FLOAT;else if(attribute.array.constructor===Uint32Array)componentType=WEBGL_CONSTANTS.UNSIGNED_INT;else if(attribute.array.constructor===Uint16Array)componentType=WEBGL_CONSTANTS.UNSIGNED_SHORT;else if(attribute.array.constructor===Uint8Array)componentType=WEBGL_CONSTANTS.UNSIGNED_BYTE;else throw new Error("THREE.GLTFExporter: Unsupported bufferAttribute component type.");// @TODO Indexed buffer geometry with drawRange not supported yet
if(void 0===start&&(start=0),void 0===count&&(count=attribute.count),options.truncateDrawRange&&void 0!==geometry&&null===geometry.index){var end=start+count,end2=geometry.drawRange.count===1/0?attribute.count:geometry.drawRange.start+geometry.drawRange.count;start=Math.max(start,geometry.drawRange.start),count=Math.min(end,end2)-start,0>count&&(count=0)}// Skip creating an accessor if the attribute doesn't have data to export
if(0===count)return null;var bufferViewTarget,minMax=getMinMax(attribute,start,count);void 0!==geometry&&(bufferViewTarget=attribute===geometry.index?WEBGL_CONSTANTS.ELEMENT_ARRAY_BUFFER:WEBGL_CONSTANTS.ARRAY_BUFFER);var bufferView=this.processBufferView(attribute,componentType,start,count,bufferViewTarget),accessorDef={bufferView:bufferView.id,byteOffset:bufferView.byteOffset,componentType:componentType,count:count,max:minMax.max,min:minMax.min,type:{1:"SCALAR",2:"VEC2",3:"VEC3",4:"VEC4",16:"MAT4"}[attribute.itemSize]};return!0===attribute.normalized&&(accessorDef.normalized=!0),json.accessors||(json.accessors=[]),json.accessors.push(accessorDef)-1}/**
	 * Process image
	 * @param  {Image} image to process
	 * @param  {Integer} format of the image (e.g. RGBFormat, RGBAFormat etc)
	 * @param  {Boolean} flipY before writing out the image
	 * @return {Integer}     Index of the processed texture in the "images" array
	 */processImage(image,format,flipY){var writer=this,cache=writer.cache,json=writer.json,options=writer.options,pending=writer.pending;cache.images.has(image)||cache.images.set(image,{});var cachedImages=cache.images.get(image),mimeType=format===three__WEBPACK_IMPORTED_MODULE_0__.RGBAFormat?"image/png":"image/jpeg",key=mimeType+":flipY/"+flipY.toString();if(void 0!==cachedImages[key])return cachedImages[key];json.images||(json.images=[]);var imageDef={mimeType:mimeType};if(options.embedImages){var canvas=cachedCanvas=cachedCanvas||document.createElement("canvas");canvas.width=Math.min(image.width,options.maxTextureSize),canvas.height=Math.min(image.height,options.maxTextureSize);var ctx=canvas.getContext("2d");if(!0===flipY&&(ctx.translate(0,canvas.height),ctx.scale(1,-1)),"undefined"!=typeof HTMLImageElement&&image instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&image instanceof HTMLCanvasElement||"undefined"!=typeof OffscreenCanvas&&image instanceof OffscreenCanvas||"undefined"!=typeof ImageBitmap&&image instanceof ImageBitmap)ctx.drawImage(image,0,0,canvas.width,canvas.height);else{format!==three__WEBPACK_IMPORTED_MODULE_0__.RGBAFormat&&format!==three__WEBPACK_IMPORTED_MODULE_0__.RGBFormat&&console.error("GLTFExporter: Only RGB and RGBA formats are supported."),(image.width>options.maxTextureSize||image.height>options.maxTextureSize)&&console.warn("GLTFExporter: Image size is bigger than maxTextureSize",image);var data=new Uint8ClampedArray(4*(image.height*image.width));if(format===three__WEBPACK_IMPORTED_MODULE_0__.RGBAFormat)for(var i=0;i<data.length;i+=4)data[i+0]=image.data[i+0],data[i+1]=image.data[i+1],data[i+2]=image.data[i+2],data[i+3]=image.data[i+3];else for(var _i=0,j=0;_i<data.length;_i+=4,j+=3)data[_i+0]=image.data[j+0],data[_i+1]=image.data[j+1],data[_i+2]=image.data[j+2],data[_i+3]=255;ctx.putImageData(new ImageData(data,image.width,image.height),0,0)}!0===options.binary?pending.push(new Promise(function(resolve){canvas.toBlob(function(blob){writer.processBufferViewImage(blob).then(function(bufferViewIndex){imageDef.bufferView=bufferViewIndex,resolve()})},mimeType)})):imageDef.uri=canvas.toDataURL(mimeType)}else imageDef.uri=image.src;var index=json.images.push(imageDef)-1;return cachedImages[key]=index,index}/**
	 * Process sampler
	 * @param  {Texture} map Texture to process
	 * @return {Integer}     Index of the processed texture in the "samplers" array
	 */processSampler(map){var json=this.json;json.samplers||(json.samplers=[]);var samplerDef={magFilter:THREE_TO_WEBGL[map.magFilter],minFilter:THREE_TO_WEBGL[map.minFilter],wrapS:THREE_TO_WEBGL[map.wrapS],wrapT:THREE_TO_WEBGL[map.wrapT]};return json.samplers.push(samplerDef)-1}/**
	 * Process texture
	 * @param  {Texture} map Map to process
	 * @return {Integer} Index of the processed texture in the "textures" array
	 */processTexture(map){var cache=this.cache,json=this.json;if(cache.textures.has(map))return cache.textures.get(map);json.textures||(json.textures=[]);var textureDef={sampler:this.processSampler(map),source:this.processImage(map.image,map.format,map.flipY)};map.name&&(textureDef.name=map.name),this._invokeAll(function(ext){ext.writeTexture&&ext.writeTexture(map,textureDef)});var index=json.textures.push(textureDef)-1;return cache.textures.set(map,index),index}/**
	 * Process material
	 * @param  {THREE.Material} material Material to process
	 * @return {Integer|null} Index of the processed material in the "materials" array
	 */processMaterial(material){var cache=this.cache,json=this.json;if(cache.materials.has(material))return cache.materials.get(material);if(material.isShaderMaterial)return console.warn("GLTFExporter: THREE.ShaderMaterial not supported."),null;json.materials||(json.materials=[]);// @QUESTION Should we avoid including any attribute that has the default value?
var materialDef={pbrMetallicRoughness:{}};!0!==material.isMeshStandardMaterial&&!0!==material.isMeshBasicMaterial&&console.warn("GLTFExporter: Use MeshStandardMaterial or MeshBasicMaterial for best results.");// pbrMetallicRoughness.baseColorFactor
var color=material.color.toArray().concat([material.opacity]);// pbrMetallicRoughness.metallicRoughnessTexture
if(equalArray(color,[1,1,1,1])||(materialDef.pbrMetallicRoughness.baseColorFactor=color),material.isMeshStandardMaterial?(materialDef.pbrMetallicRoughness.metallicFactor=material.metalness,materialDef.pbrMetallicRoughness.roughnessFactor=material.roughness):(materialDef.pbrMetallicRoughness.metallicFactor=.5,materialDef.pbrMetallicRoughness.roughnessFactor=.5),material.metalnessMap||material.roughnessMap)if(material.metalnessMap===material.roughnessMap){var metalRoughMapDef={index:this.processTexture(material.metalnessMap)};this.applyTextureTransform(metalRoughMapDef,material.metalnessMap),materialDef.pbrMetallicRoughness.metallicRoughnessTexture=metalRoughMapDef}else console.warn("THREE.GLTFExporter: Ignoring metalnessMap and roughnessMap because they are not the same Texture.");// pbrMetallicRoughness.baseColorTexture or pbrSpecularGlossiness diffuseTexture
if(material.map){var baseColorMapDef={index:this.processTexture(material.map)};this.applyTextureTransform(baseColorMapDef,material.map),materialDef.pbrMetallicRoughness.baseColorTexture=baseColorMapDef}if(material.emissive){// note: emissive components are limited to stay within the 0 - 1 range to accommodate glTF spec. see #21849 and #22000.
var emissive=material.emissive.clone().multiplyScalar(material.emissiveIntensity),maxEmissiveComponent=Math.max(emissive.r,emissive.g,emissive.b);// emissiveTexture
if(1<maxEmissiveComponent&&(emissive.multiplyScalar(1/maxEmissiveComponent),console.warn("THREE.GLTFExporter: Some emissive components exceed 1; emissive has been limited")),0<maxEmissiveComponent&&(materialDef.emissiveFactor=emissive.toArray()),material.emissiveMap){var emissiveMapDef={index:this.processTexture(material.emissiveMap)};this.applyTextureTransform(emissiveMapDef,material.emissiveMap),materialDef.emissiveTexture=emissiveMapDef}}// normalTexture
if(material.normalMap){var normalMapDef={index:this.processTexture(material.normalMap)};material.normalScale&&-1!==material.normalScale.x&&(material.normalScale.x!==material.normalScale.y&&console.warn("THREE.GLTFExporter: Normal scale components are different, ignoring Y and exporting X."),normalMapDef.scale=material.normalScale.x),this.applyTextureTransform(normalMapDef,material.normalMap),materialDef.normalTexture=normalMapDef}// occlusionTexture
if(material.aoMap){var occlusionMapDef={index:this.processTexture(material.aoMap),texCoord:1};1!==material.aoMapIntensity&&(occlusionMapDef.strength=material.aoMapIntensity),this.applyTextureTransform(occlusionMapDef,material.aoMap),materialDef.occlusionTexture=occlusionMapDef}// alphaMode
material.transparent?materialDef.alphaMode="BLEND":0<material.alphaTest&&(materialDef.alphaMode="MASK",materialDef.alphaCutoff=material.alphaTest),material.side===three__WEBPACK_IMPORTED_MODULE_0__.DoubleSide&&(materialDef.doubleSided=!0),""!==material.name&&(materialDef.name=material.name),this.serializeUserData(material,materialDef),this._invokeAll(function(ext){ext.writeMaterial&&ext.writeMaterial(material,materialDef)});var index=json.materials.push(materialDef)-1;return cache.materials.set(material,index),index}/**
	 * Process mesh
	 * @param  {THREE.Mesh} mesh Mesh to process
	 * @return {Integer|null} Index of the processed mesh in the "meshes" array
	 */processMesh(mesh){var cache=this.cache,json=this.json,meshCacheKeyParts=[mesh.geometry.uuid];if(Array.isArray(mesh.material))for(var i=0,l=mesh.material.length;i<l;i++)meshCacheKeyParts.push(mesh.material[i].uuid);else meshCacheKeyParts.push(mesh.material.uuid);var meshCacheKey=meshCacheKeyParts.join(":");if(cache.meshes.has(meshCacheKey))return cache.meshes.get(meshCacheKey);var mode,geometry=mesh.geometry;// Use the correct mode
if(mode=mesh.isLineSegments?WEBGL_CONSTANTS.LINES:mesh.isLineLoop?WEBGL_CONSTANTS.LINE_LOOP:mesh.isLine?WEBGL_CONSTANTS.LINE_STRIP:mesh.isPoints?WEBGL_CONSTANTS.POINTS:mesh.material.wireframe?WEBGL_CONSTANTS.LINES:WEBGL_CONSTANTS.TRIANGLES,!0!==geometry.isBufferGeometry)throw new Error("THREE.GLTFExporter: Geometry is not of type THREE.BufferGeometry.");var meshDef={},attributes={},primitives=[],targets=[],nameConversion={uv:"TEXCOORD_0",uv2:"TEXCOORD_1",color:"COLOR_0",skinWeight:"WEIGHTS_0",skinIndex:"JOINTS_0"},originalNormal=geometry.getAttribute("normal");// Conversion between attributes names in threejs and gltf spec
void 0===originalNormal||this.isNormalizedNormalAttribute(originalNormal)||(console.warn("THREE.GLTFExporter: Creating normalized normal attribute from the non-normalized one."),geometry.setAttribute("normal",this.createNormalizedNormalAttribute(originalNormal)));// @QUESTION Detect if .vertexColors = true?
// For every attribute create an accessor
var modifiedAttribute=null;for(var attributeName in geometry.attributes)// Ignore morph target attributes, which are exported later.
if("morph"!==attributeName.substr(0,5)){var attribute=geometry.attributes[attributeName];attributeName=nameConversion[attributeName]||attributeName.toUpperCase();// Prefix all geometry attributes except the ones specifically
// listed in the spec; non-spec attributes are considered custom.
var validVertexAttributes=/^(POSITION|NORMAL|TANGENT|TEXCOORD_\d+|COLOR_\d+|JOINTS_\d+|WEIGHTS_\d+)$/;if(validVertexAttributes.test(attributeName)||(attributeName="_"+attributeName),cache.attributes.has(this.getUID(attribute))){attributes[attributeName]=cache.attributes.get(this.getUID(attribute));continue}// JOINTS_0 must be UNSIGNED_BYTE or UNSIGNED_SHORT.
modifiedAttribute=null;var array=attribute.array;"JOINTS_0"!==attributeName||array instanceof Uint16Array||array instanceof Uint8Array||(console.warn("GLTFExporter: Attribute \"skinIndex\" converted to type UNSIGNED_SHORT."),modifiedAttribute=new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(new Uint16Array(array),attribute.itemSize,attribute.normalized));var accessor=this.processAccessor(modifiedAttribute||attribute,geometry);null!==accessor&&(attributes[attributeName]=accessor,cache.attributes.set(this.getUID(attribute),accessor))}// Skip if no exportable attributes found
if(void 0!==originalNormal&&geometry.setAttribute("normal",originalNormal),0===Object.keys(attributes).length)return null;// Morph targets
if(void 0!==mesh.morphTargetInfluences&&0<mesh.morphTargetInfluences.length){var weights=[],targetNames=[],reverseDictionary={};if(void 0!==mesh.morphTargetDictionary)for(var key in mesh.morphTargetDictionary)reverseDictionary[mesh.morphTargetDictionary[key]]=key;for(var _i2=0;_i2<mesh.morphTargetInfluences.length;++_i2){var target={},warned=!1;for(var _attributeName in geometry.morphAttributes){// glTF 2.0 morph supports only POSITION/NORMAL/TANGENT.
// Three.js doesn't support TANGENT yet.
if("position"!=_attributeName&&"normal"!==_attributeName&&"color"!==_attributeName){warned||(console.warn("GLTFExporter: Only POSITION and NORMAL morph are supported."),warned=!0);continue}var _attribute=geometry.morphAttributes[_attributeName][_i2],gltfAttributeName=_attributeName.toUpperCase();nameConversion[_attributeName]&&(gltfAttributeName=nameConversion[_attributeName]);// Three.js morph attribute has absolute values while the one of glTF has relative values.
//
// glTF 2.0 Specification:
// https://github.com/KhronosGroup/glTF/tree/master/specification/2.0#morph-targets
var baseAttribute=geometry.attributes[_attributeName];if(cache.attributes.has(this.getUID(_attribute))){target[gltfAttributeName]=cache.attributes.get(this.getUID(_attribute));continue}// Clones attribute not to override
var relativeAttribute=baseAttribute.clone();if(!geometry.morphTargetsRelative)if(baseAttribute)for(var j=0,jl=_attribute.count;j<jl;j++)baseAttribute.count>j&&relativeAttribute.setXYZ(j,_attribute.getX(j)-baseAttribute.getX(j),_attribute.getY(j)-baseAttribute.getY(j),_attribute.getZ(j)-baseAttribute.getZ(j));else for(var _j=0,_jl=_attribute.count;_j<_jl;_j++)relativeAttribute.setXYZ(_j,0,0,0);target[gltfAttributeName]=this.processAccessor(relativeAttribute,geometry),cache.attributes.set(this.getUID(baseAttribute),target[gltfAttributeName])}targets.push(target),weights.push(mesh.morphTargetInfluences[_i2]),void 0!==mesh.morphTargetDictionary&&targetNames.push(reverseDictionary[_i2])}meshDef.weights=weights,0<targetNames.length&&(meshDef.extras={},meshDef.extras.targetNames=targetNames)}var isMultiMaterial=Array.isArray(mesh.material);if(isMultiMaterial&&0===geometry.groups.length)return null;for(var primitive,materials=isMultiMaterial?mesh.material:[mesh.material],groups=isMultiMaterial?geometry.groups:[{materialIndex:0,start:void 0,count:void 0}],_i3=0,il=groups.length;_i3<il;_i3++){if(primitive={mode:mode,attributes:attributes},this.serializeUserData(geometry,primitive),0<targets.length&&(primitive.targets=targets),null!==geometry.index){var cacheKey=this.getUID(geometry.index);(void 0!==groups[_i3].start||void 0!==groups[_i3].count)&&(cacheKey+=":"+groups[_i3].start+":"+groups[_i3].count),cache.attributes.has(cacheKey)?primitive.indices=cache.attributes.get(cacheKey):(primitive.indices=this.processAccessor(geometry.index,geometry,groups[_i3].start,groups[_i3].count),cache.attributes.set(cacheKey,primitive.indices)),null===primitive.indices&&delete primitive.indices}var material=this.processMaterial(materials[groups[_i3].materialIndex]);null!==material&&(primitive.material=material),primitives.push(primitive)}meshDef.primitives=primitives,json.meshes||(json.meshes=[]),this._invokeAll(function(ext){ext.writeMesh&&ext.writeMesh(mesh,meshDef)});var index=json.meshes.push(meshDef)-1;return cache.meshes.set(meshCacheKey,index),index}/**
	 * Process camera
	 * @param  {THREE.Camera} camera Camera to process
	 * @return {Integer}      Index of the processed mesh in the "camera" array
	 */processCamera(camera){var json=this.json;json.cameras||(json.cameras=[]);var isOrtho=camera.isOrthographicCamera,cameraDef={type:isOrtho?"orthographic":"perspective"};return isOrtho?cameraDef.orthographic={xmag:2*camera.right,ymag:2*camera.top,zfar:0>=camera.far?.001:camera.far,znear:0>camera.near?0:camera.near}:cameraDef.perspective={aspectRatio:camera.aspect,yfov:three__WEBPACK_IMPORTED_MODULE_0__.MathUtils.degToRad(camera.fov),zfar:0>=camera.far?.001:camera.far,znear:0>camera.near?0:camera.near},""!==camera.name&&(cameraDef.name=camera.type),json.cameras.push(cameraDef)-1}/**
	 * Creates glTF animation entry from AnimationClip object.
	 *
	 * Status:
	 * - Only properties listed in PATH_PROPERTIES may be animated.
	 *
	 * @param {THREE.AnimationClip} clip
	 * @param {THREE.Object3D} root
	 * @return {number|null}
	 */processAnimation(clip,root){var json=this.json,nodeMap=this.nodeMap;json.animations||(json.animations=[]),clip=GLTFExporter.Utils.mergeMorphTargetTracks(clip.clone(),root);for(var tracks=clip.tracks,channels=[],samplers=[],i=0;i<tracks.length;++i){var track=tracks[i],trackBinding=three__WEBPACK_IMPORTED_MODULE_0__.PropertyBinding.parseTrackName(track.name),trackNode=three__WEBPACK_IMPORTED_MODULE_0__.PropertyBinding.findNode(root,trackBinding.nodeName),trackProperty=PATH_PROPERTIES[trackBinding.propertyName];if("bones"===trackBinding.objectName&&(!0===trackNode.isSkinnedMesh?trackNode=trackNode.skeleton.getBoneByName(trackBinding.objectIndex):trackNode=void 0),!trackNode||!trackProperty)return console.warn("THREE.GLTFExporter: Could not export animation track \"%s\".",track.name),null;var inputItemSize=1,outputItemSize=track.values.length/track.times.length;trackProperty===PATH_PROPERTIES.morphTargetInfluences&&(outputItemSize/=trackNode.morphTargetInfluences.length);var interpolation=void 0;// @TODO export CubicInterpolant(InterpolateSmooth) as CUBICSPLINE
// Detecting glTF cubic spline interpolant by checking factory method's special property
// GLTFCubicSplineInterpolant is a custom interpolant and track doesn't return
// valid value from .getInterpolation().
!0===track.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline?(interpolation="CUBICSPLINE",outputItemSize/=3):track.getInterpolation()===three__WEBPACK_IMPORTED_MODULE_0__.InterpolateDiscrete?interpolation="STEP":interpolation="LINEAR",samplers.push({input:this.processAccessor(new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(track.times,inputItemSize)),output:this.processAccessor(new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(track.values,outputItemSize)),interpolation:interpolation}),channels.push({sampler:samplers.length-1,target:{node:nodeMap.get(trackNode),path:trackProperty}})}return json.animations.push({name:clip.name||"clip_"+json.animations.length,samplers:samplers,channels:channels}),json.animations.length-1}/**
	 * @param {THREE.Object3D} object
	 * @return {number|null}
	 */processSkin(object){var json=this.json,nodeMap=this.nodeMap,node=json.nodes[nodeMap.get(object)],skeleton=object.skeleton;if(skeleton===void 0)return null;var rootJoint=object.skeleton.bones[0];if(rootJoint===void 0)return null;for(var joints=[],inverseBindMatrices=new Float32Array(16*skeleton.bones.length),temporaryBoneInverse=new three__WEBPACK_IMPORTED_MODULE_0__.Matrix4,i=0;i<skeleton.bones.length;++i)joints.push(nodeMap.get(skeleton.bones[i])),temporaryBoneInverse.copy(skeleton.boneInverses[i]),temporaryBoneInverse.multiply(object.bindMatrix).toArray(inverseBindMatrices,16*i);json.skins===void 0&&(json.skins=[]),json.skins.push({inverseBindMatrices:this.processAccessor(new three__WEBPACK_IMPORTED_MODULE_0__.BufferAttribute(inverseBindMatrices,16)),joints:joints,skeleton:nodeMap.get(rootJoint)});var skinIndex=node.skin=json.skins.length-1;return skinIndex}/**
	 * Process Object3D node
	 * @param  {THREE.Object3D} node Object3D to processNode
	 * @return {Integer} Index of the node in the nodes list
	 */processNode(object){var json=this.json,options=this.options,nodeMap=this.nodeMap;json.nodes||(json.nodes=[]);var nodeDef={};if(options.trs){var rotation=object.quaternion.toArray(),position=object.position.toArray(),scale=object.scale.toArray();equalArray(rotation,[0,0,0,1])||(nodeDef.rotation=rotation),equalArray(position,[0,0,0])||(nodeDef.translation=position),equalArray(scale,[1,1,1])||(nodeDef.scale=scale)}else object.matrixAutoUpdate&&object.updateMatrix(),!1===isIdentityMatrix(object.matrix)&&(nodeDef.matrix=object.matrix.elements);// We don't export empty strings name because it represents no-name in Three.js.
if(""!==object.name&&(nodeDef.name=object.name+""),this.serializeUserData(object,nodeDef),object.isMesh||object.isLine||object.isPoints){var meshIndex=this.processMesh(object);null!==meshIndex&&(nodeDef.mesh=meshIndex)}else object.isCamera&&(nodeDef.camera=this.processCamera(object));if(object.isSkinnedMesh&&this.skins.push(object),0<object.children.length){for(var child,children=[],i=0,l=object.children.length;i<l;i++)if(child=object.children[i],child.visible||!1===options.onlyVisible){var _nodeIndex=this.processNode(child);null!==_nodeIndex&&children.push(_nodeIndex)}0<children.length&&(nodeDef.children=children)}this._invokeAll(function(ext){ext.writeNode&&ext.writeNode(object,nodeDef)});var nodeIndex=json.nodes.push(nodeDef)-1;return nodeMap.set(object,nodeIndex),nodeIndex}/**
	 * Process Scene
	 * @param  {Scene} node Scene to process
	 */processScene(scene){var json=this.json,options=this.options;json.scenes||(json.scenes=[],json.scene=0);var sceneDef={};""!==scene.name&&(sceneDef.name=scene.name),json.scenes.push(sceneDef);for(var child,nodes=[],i=0,l=scene.children.length;i<l;i++)if(child=scene.children[i],child.visible||!1===options.onlyVisible){var nodeIndex=this.processNode(child);null!==nodeIndex&&nodes.push(nodeIndex)}0<nodes.length&&(sceneDef.nodes=nodes),this.serializeUserData(scene,sceneDef)}/**
	 * Creates a Scene to hold a list of objects and parse it
	 * @param  {Array} objects List of objects to process
	 */processObjects(objects){var scene=new three__WEBPACK_IMPORTED_MODULE_0__.Scene;scene.name="AuxScene";for(var i=0;i<objects.length;i++)// We push directly to children instead of calling `add` to prevent
// modify the .parent and break its original scene and hierarchy
scene.children.push(objects[i]);this.processScene(scene)}/**
	 * @param {THREE.Object3D|Array<THREE.Object3D>} input
	 */processInput(input){var options=this.options;input=input instanceof Array?input:[input],this._invokeAll(function(ext){ext.beforeParse&&ext.beforeParse(input)});for(var objectsWithoutScene=[],i=0;i<input.length;i++)input[i]instanceof three__WEBPACK_IMPORTED_MODULE_0__.Scene?this.processScene(input[i]):objectsWithoutScene.push(input[i]);0<objectsWithoutScene.length&&this.processObjects(objectsWithoutScene);for(var _i4=0;_i4<this.skins.length;++_i4)this.processSkin(this.skins[_i4]);for(var _i5=0;_i5<options.animations.length;++_i5)this.processAnimation(options.animations[_i5].clip,options.animations[_i5].mesh);this._invokeAll(function(ext){ext.afterParse&&ext.afterParse(input)})}_invokeAll(func){for(var i=0,il=this.plugins.length;i<il;i++)func(this.plugins[i])}}/**
 * Punctual Lights Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_lights_punctual
 */class GLTFLightExtension{constructor(writer){this.writer=writer,this.name="KHR_lights_punctual"}writeNode(light,nodeDef){if(light.isLight){if(!light.isDirectionalLight&&!light.isPointLight&&!light.isSpotLight)return void console.warn("THREE.GLTFExporter: Only directional, point, and spot lights are supported.",light);var writer=this.writer,json=writer.json,extensionsUsed=writer.extensionsUsed,lightDef={};light.name&&(lightDef.name=light.name),lightDef.color=light.color.toArray(),lightDef.intensity=light.intensity,light.isDirectionalLight?lightDef.type="directional":light.isPointLight?(lightDef.type="point",0<light.distance&&(lightDef.range=light.distance)):light.isSpotLight&&(lightDef.type="spot",0<light.distance&&(lightDef.range=light.distance),lightDef.spot={},lightDef.spot.innerConeAngle=-1*((light.penumbra-1)*light.angle),lightDef.spot.outerConeAngle=light.angle),void 0!==light.decay&&2!==light.decay&&console.warn("THREE.GLTFExporter: Light decay may be lost. glTF is physically-based, "+"and expects light.decay=2."),light.target&&(light.target.parent!==light||0!==light.target.position.x||0!==light.target.position.y||-1!==light.target.position.z)&&console.warn("THREE.GLTFExporter: Light direction may be lost. For best results, "+"make light.target a child of the light with position 0,0,-1."),extensionsUsed[this.name]||(json.extensions=json.extensions||{},json.extensions[this.name]={lights:[]},extensionsUsed[this.name]=!0);var lights=json.extensions[this.name].lights;lights.push(lightDef),nodeDef.extensions=nodeDef.extensions||{},nodeDef.extensions[this.name]={light:lights.length-1}}}}/**
 * Unlit Materials Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_materials_unlit
 */class GLTFMaterialsUnlitExtension{constructor(writer){this.writer=writer,this.name="KHR_materials_unlit"}writeMaterial(material,materialDef){if(material.isMeshBasicMaterial){var writer=this.writer,extensionsUsed=writer.extensionsUsed;materialDef.extensions=materialDef.extensions||{},materialDef.extensions[this.name]={},extensionsUsed[this.name]=!0,materialDef.pbrMetallicRoughness.metallicFactor=0,materialDef.pbrMetallicRoughness.roughnessFactor=.9}}}/**
 * Specular-Glossiness Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_materials_pbrSpecularGlossiness
 */class GLTFMaterialsPBRSpecularGlossiness{constructor(writer){this.writer=writer,this.name="KHR_materials_pbrSpecularGlossiness"}writeMaterial(material,materialDef){if(material.isGLTFSpecularGlossinessMaterial){var writer=this.writer,extensionsUsed=writer.extensionsUsed,extensionDef={};materialDef.pbrMetallicRoughness.baseColorFactor&&(extensionDef.diffuseFactor=materialDef.pbrMetallicRoughness.baseColorFactor);var specularFactor=[1,1,1];if(material.specular.toArray(specularFactor,0),extensionDef.specularFactor=specularFactor,extensionDef.glossinessFactor=material.glossiness,materialDef.pbrMetallicRoughness.baseColorTexture&&(extensionDef.diffuseTexture=materialDef.pbrMetallicRoughness.baseColorTexture),material.specularMap){var specularMapDef={index:writer.processTexture(material.specularMap)};writer.applyTextureTransform(specularMapDef,material.specularMap),extensionDef.specularGlossinessTexture=specularMapDef}materialDef.extensions=materialDef.extensions||{},materialDef.extensions[this.name]=extensionDef,extensionsUsed[this.name]=!0}}}/**
 * Static utility functions
 */GLTFExporter.Utils={insertKeyframe:function insertKeyframe(track,time){var index,tolerance=.001,valueSize=track.getValueSize(),times=new track.TimeBufferType(track.times.length+1),values=new track.ValueBufferType(track.values.length+valueSize),interpolant=track.createInterpolant(new track.ValueBufferType(valueSize));// 1ms
if(0===track.times.length){times[0]=time;for(var i=0;i<valueSize;i++)values[i]=0;index=0}else if(time<track.times[0]){if(Math.abs(track.times[0]-time)<tolerance)return 0;times[0]=time,times.set(track.times,1),values.set(interpolant.evaluate(time),0),values.set(track.values,valueSize),index=0}else if(time>track.times[track.times.length-1]){if(Math.abs(track.times[track.times.length-1]-time)<tolerance)return track.times.length-1;times[times.length-1]=time,times.set(track.times,0),values.set(track.values,0),values.set(interpolant.evaluate(time),track.values.length),index=times.length-1}else for(var _i6=0;_i6<track.times.length;_i6++){if(Math.abs(track.times[_i6]-time)<tolerance)return _i6;if(track.times[_i6]<time&&track.times[_i6+1]>time){times.set(track.times.slice(0,_i6+1),0),times[_i6+1]=time,times.set(track.times.slice(_i6+1),_i6+2),values.set(track.values.slice(0,(_i6+1)*valueSize),0),values.set(interpolant.evaluate(time),(_i6+1)*valueSize),values.set(track.values.slice((_i6+1)*valueSize),(_i6+2)*valueSize),index=_i6+1;break}}return track.times=times,track.values=values,index},mergeMorphTargetTracks:function mergeMorphTargetTracks(clip,root){for(var tracks=[],mergedTracks={},sourceTracks=clip.tracks,i=0;i<sourceTracks.length;++i){var sourceTrack=sourceTracks[i],sourceTrackBinding=three__WEBPACK_IMPORTED_MODULE_0__.PropertyBinding.parseTrackName(sourceTrack.name),sourceTrackNode=three__WEBPACK_IMPORTED_MODULE_0__.PropertyBinding.findNode(root,sourceTrackBinding.nodeName);if("morphTargetInfluences"!==sourceTrackBinding.propertyName||void 0===sourceTrackBinding.propertyIndex){tracks.push(sourceTrack);continue}if(sourceTrack.createInterpolant!==sourceTrack.InterpolantFactoryMethodDiscrete&&sourceTrack.createInterpolant!==sourceTrack.InterpolantFactoryMethodLinear){if(sourceTrack.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline)// This should never happen, because glTF morph target animations
// affect all targets already.
throw new Error("THREE.GLTFExporter: Cannot merge tracks with glTF CUBICSPLINE interpolation.");console.warn("THREE.GLTFExporter: Morph target interpolation mode not yet supported. Using LINEAR instead."),sourceTrack=sourceTrack.clone(),sourceTrack.setInterpolation(three__WEBPACK_IMPORTED_MODULE_0__.InterpolateLinear)}var targetCount=sourceTrackNode.morphTargetInfluences.length,targetIndex=sourceTrackNode.morphTargetDictionary[sourceTrackBinding.propertyIndex];if(void 0===targetIndex)throw new Error("THREE.GLTFExporter: Morph target name not found: "+sourceTrackBinding.propertyIndex);var mergedTrack=void 0;// If this is the first time we've seen this object, create a new
// track to store merged keyframe data for each morph target.
if(void 0===mergedTracks[sourceTrackNode.uuid]){mergedTrack=sourceTrack.clone();for(var values=new mergedTrack.ValueBufferType(targetCount*mergedTrack.times.length),j=0;j<mergedTrack.times.length;j++)values[j*targetCount+targetIndex]=mergedTrack.values[j];// We need to take into consideration the intended target node
// of our original un-merged morphTarget animation.
mergedTrack.name=(sourceTrackBinding.nodeName||"")+".morphTargetInfluences",mergedTrack.values=values,mergedTracks[sourceTrackNode.uuid]=mergedTrack,tracks.push(mergedTrack);continue}var sourceInterpolant=sourceTrack.createInterpolant(new sourceTrack.ValueBufferType(1));mergedTrack=mergedTracks[sourceTrackNode.uuid];// For every existing keyframe of the merged track, write a (possibly
// interpolated) value from the source track.
for(var _j2=0;_j2<mergedTrack.times.length;_j2++)mergedTrack.values[_j2*targetCount+targetIndex]=sourceInterpolant.evaluate(mergedTrack.times[_j2]);// For every existing keyframe of the source track, write a (possibly
// new) keyframe to the merged track. Values from the previous loop may
// be written again, but keyframes are de-duplicated.
for(var keyframeIndex,_j3=0;_j3<sourceTrack.times.length;_j3++)keyframeIndex=this.insertKeyframe(mergedTrack,sourceTrack.times[_j3]),mergedTrack.values[keyframeIndex*targetCount+targetIndex]=sourceTrack.values[_j3]}return clip.tracks=tracks,clip}};

/***/ }),
/* 44 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),resolveURL=(__webpack_require__(5).resolveURL),Viewport=function(){this.nearPlane=.168248,this.farPlane=6.82906,this.eyePosition=[.5,-2.86496,.5],this.targetPosition=[.5,.5,.5],this.upVector=[0,0,1];var _this=this;this.setFromObject=_ref=>{var{nearPlane,farPlane,eyePosition,targetPosition,upVector}=_ref;_this.nearPlane=nearPlane,_this.farPlane=farPlane,_this.eyePosition=eyePosition,_this.targetPosition=targetPosition,_this.upVector=upVector}},CameraControls=function(object,domElement,renderer,scene){var MODE={NONE:-1,DEFAULT:0,PATH:1,SMOOTH_CAMERA_TRANSITION:2,AUTO_TUMBLE:3,ROTATE_TRANSITION:4,MINIMAP:5,SYNC_CONTROL:6},STATE={NONE:-1,ROTATE:0,ZOOM:1,PAN:2,TOUCH_ROTATE:3,TOUCH_ZOOM:4,TOUCH_PAN:5,SCROLL:6,KEYBOARD_ZOOM:7,KEYBOARD_ROTATE:8,KEYBOARD_PAN:9},ROTATE_DIRECTION={NONE:-1,FREE:1,HORIZONTAL:2,VERTICAL:3},KEYBOARD={ARROWLEFT:37,ARROWUP:38,ARROWRIGHT:39,ARROWDOWN:40,NUMPADADD:107,NUMPADSUBTRACT:109,EQUAL:187,MINUS:189},CLICK_ACTION={};/** 
   * Actions states.
   * Available states are NONE, ROTATE, ZOOM, PAN, TOUCH_ROTATE, TOUCH_ZOOM, TOUCH_PAN and SCROLL.
   * @property {Object} 
   */ /** 
   * Available click actions are MAIN, AUXILIARY and SECONARY.
   * @property {Object} 
   */CLICK_ACTION.MAIN=STATE.ROTATE,CLICK_ACTION.AUXILIARY=STATE.ZOOM,CLICK_ACTION.SECONDARY=STATE.PAN,this.cameraObject=object,this.domElement=domElement===void 0?document:domElement,this.renderer=renderer,this.scene=scene,this.tumble_rate=1.5,this.pointer_x=0,this.pointer_y=0,this.pointer_x_start=0,this.pointer_y_start=0,this.previous_pointer_x=0,this.previous_pointer_y=0,this.near_plane_fly_debt=0,this.touchZoomDistanceStart=0,this.touchZoomDistanceEnd=0,this.directionalLight=0,this.zoomRate=50,this.rotateRate=50,this.panRate=100,this.pixelHeight=1;var duration=6e3,enabled=!0,inbuildTime=0,cameraPath=void 0,numberOfCameraPoint=void 0,updateLightWithPathFlag=!1,playRate=500,deviceOrientationControl=void 0,defaultViewport="default",currentMode=MODE.DEFAULT,smoothCameraTransitionObject=void 0,rotateCameraTransitionObject=void 0,cameraAutoTumbleObject=void 0,zoomSize=0,rotateMode=ROTATE_DIRECTION.FREE;this._state=STATE.NONE;var zincRayCaster;this.targetTouchId=-1;var rect=void 0,_a=new THREE.Vector3,_b=new THREE.Vector3,_c=new THREE.Vector3,_new_b=new THREE.Vector3,_new_c=new THREE.Vector3,_axis=new THREE.Vector3,_v=new THREE.Vector3,_rel_eye=new THREE.Vector3,sceneSphere=new THREE.Sphere,_tempEye=new THREE.Vector3,hasUpdated=!1,ndcControl=void 0,maxDist=0,viewports={default:new Viewport};viewports.default.nearPlane=.1,viewports.default.farPlane=2e3,viewports.default.eyePosition=[0,0,0],viewports.default.targetPosition=[0,0,-1],viewports.default.upVector=[0,1,0],this.cameraObject.target===void 0&&(this.cameraObject.target=new THREE.Vector3(...viewports.default.targetPosition)),this.calculateMaxAllowedDistance=scene=>{var box=scene.getBoundingBox();if(box){box.getBoundingSphere(sceneSphere),maxDist=6*sceneSphere.radius;var currentDist=0;this.cameraObject&&(currentDist=this.cameraObject.position.distanceTo(sceneSphere.center)),maxDist=currentDist>maxDist?1.5*currentDist:maxDist}else maxDist=0},this.addViewport=(viewportName,viewport)=>{viewportName&&viewport&&(viewports[viewportName]=viewport)},this.setDefaultViewport=defaultName=>!!(defaultName&&defaultName in viewports)&&(defaultViewport=defaultName,!0),this.getDefaultViewport=()=>defaultViewport,this.getViewportOfName=name=>viewports[name],this.setCurrentViewport=name=>!!(name in viewports)&&(this.setCurrentCameraSettings(viewports[name]),!0),this.setRotationMode=mode=>{switch(mode){case"none":rotateMode=ROTATE_DIRECTION.NONE;break;case"horizontal":rotateMode=ROTATE_DIRECTION.HORIZONTAL;break;case"vertical":rotateMode=ROTATE_DIRECTION.VERTICAL;break;case"free":default:rotateMode=ROTATE_DIRECTION.FREE}},this.onResize=()=>{rect&&(rect=void 0),ndcControl&&ndcControl.setCurrentCameraSettings(this.cameraObject,viewports[defaultViewport])},this.getVisibleHeightAtZDepth=depth=>{// compensate for cameras not positioned at z=0
var cameraOffset=this.cameraObject.position.distanceTo(this.cameraObject.target);depth<cameraOffset?depth-=cameraOffset:depth+=cameraOffset;// vertical fov in radians
var vFOV=this.cameraObject.fov*Math.PI/180;// Math.abs to ensure the result is always positive
return 2*Math.tan(vFOV/2)*Math.abs(depth)},this.calculateHeightPerPixelAtZeroDepth=wHeight=>{var height=this.getVisibleHeightAtZDepth(0);return this.pixelHeight=height/wHeight,this.pixelHeight},this.getNDCFromDocumentCoords=(x,y,positionIn)=>{updateRect(!1);var position=positionIn?positionIn:new THREE.Vector2,out_x=2*((x-rect.left)/rect.width)-1,out_y=2*-((y-rect.top)/rect.height)+1;return position.set(out_x,out_y)},this.getRelativeCoordsFromNDC=(x,y,positionIn)=>{updateRect(!1);var position=positionIn?positionIn:new THREE.Vector2;return position.x=(x+1)*rect.width/2,position.y=(1-y)*rect.height/2,position},this.setMouseButtonAction=(buttonName,actionName)=>{CLICK_ACTION[buttonName]=STATE[actionName]};/**
	 * 
	 * @param {HTML} element 
	 * @param {Number} index 
	 */var setCanvasTabindex=(element,index)=>{element instanceof HTMLCanvasElement&&(element.tabIndex=index)},checkTravelDistance=()=>{if(0<maxDist){var newDist=_tempEye.distanceTo(sceneSphere.center);return maxDist>newDist||this.cameraObject.position.distanceTo(sceneSphere.center)>newDist}return!0},translateViewport=translation=>{_tempEye.copy(this.cameraObject.position).add(translation),checkTravelDistance()&&(this.cameraObject.target.add(translation),this.cameraObject.position.add(translation),this.updateDirectionalLight())},onDocumentMouseDown=event=>{updateRect(!1);// Check if mouse event hapens inside the minimap
var minimapCoordinates;if(currentMode===MODE.DEFAULT&&(minimapCoordinates=this.scene.getNormalisedMinimapCoordinates(this.renderer,event)),!minimapCoordinates)0==event.button?event.ctrlKey?this._state=CLICK_ACTION.AUXILIARY:event.shiftKey?this._state=CLICK_ACTION.SECONDARY:this._state=CLICK_ACTION.MAIN:1==event.button?(event.preventDefault(),this._state=CLICK_ACTION.AUXILIARY):2==event.button&&(this._state=CLICK_ACTION.SECONDARY),this.pointer_x=event.clientX-rect.left,this.pointer_y=event.clientY-rect.top,this.pointer_x_start=this.pointer_x,this.pointer_y_start=this.pointer_y,this.previous_pointer_x=this.pointer_x,this.previous_pointer_y=this.pointer_y;else{currentMode=MODE.MINIMAP;var translation=this.scene.getMinimapDiffFromNormalised(minimapCoordinates.x,minimapCoordinates.y);translateViewport(translation)}},onDocumentMouseMove=event=>{if(updateRect(!1),rect)if(this.pointer_x=event.clientX-rect.left,this.pointer_y=event.clientY-rect.top,currentMode===MODE.MINIMAP){var minimapCoordinates=this.scene.getNormalisedMinimapCoordinates(this.renderer,event);if(minimapCoordinates){var translation=this.scene.getMinimapDiffFromNormalised(minimapCoordinates.x,minimapCoordinates.y);translateViewport(translation)}}else this._state===STATE.NONE&&void 0!==zincRayCaster&&zincRayCaster.move(this,event.clientX,event.clientY,this.renderer)},onDocumentMouseUp=event=>{this._state=STATE.NONE,currentMode==MODE.MINIMAP&&(currentMode=MODE.DEFAULT),zincRayCaster!==void 0&&this.pointer_x_start==event.clientX-rect.left&&this.pointer_y_start==event.clientY-rect.top&&zincRayCaster.pick(this,event.clientX,event.clientY,this.renderer)},onDocumentMouseLeave=event=>{this._state=STATE.NONE},onDocumentTouchStart=event=>{updateRect(!1);var len=event.touches.length;if(1==len){var _rect,_rect2;this._state=STATE.TOUCH_ROTATE,this.pointer_x=event.touches[0].clientX-(null===(_rect=rect)||void 0===_rect?void 0:_rect.left),this.pointer_y=event.touches[0].clientY-(null===(_rect2=rect)||void 0===_rect2?void 0:_rect2.top),this.pointer_x_start=this.pointer_x,this.pointer_y_start=this.pointer_y,this.previous_pointer_x=this.pointer_x,this.previous_pointer_y=this.pointer_y}else if(2==len){this._state=STATE.TOUCH_ZOOM;var dx=event.touches[0].clientX-event.touches[1].clientX,dy=event.touches[0].clientY-event.touches[1].clientY;this.touchZoomDistanceEnd=this.touchZoomDistanceStart=Math.sqrt(dx*dx+dy*dy)}else if(3==len){var _rect3,_rect4;this._state=STATE.TOUCH_PAN,this.targetTouchId=event.touches[0].identifier,this.pointer_x=event.touches[0].clientX-(null===(_rect3=rect)||void 0===_rect3?void 0:_rect3.left),this.pointer_y=event.touches[0].clientY-(null===(_rect4=rect)||void 0===_rect4?void 0:_rect4.top),this.previous_pointer_x=this.pointer_x,this.previous_pointer_y=this.pointer_y}},onDocumentTouchMove=event=>{event.preventDefault(),event.stopPropagation();var len=event.touches.length;if(1==len)this.pointer_x=event.touches[0].clientX-rect.left,this.pointer_y=event.touches[0].clientY-rect.top;else if(2==len){if(this._state===STATE.TOUCH_ZOOM){var dx=event.touches[0].clientX-event.touches[1].clientX,dy=event.touches[0].clientY-event.touches[1].clientY;this.touchZoomDistanceEnd=Math.sqrt(dx*dx+dy*dy)}}else if(3==len&&this._state===STATE.TOUCH_PAN)for(var i=0;3>i;i++)event.touches[i].identifier==this.targetTouchId&&(this.pointer_x=event.touches[0].clientX-rect.left,this.pointer_y=event.touches[0].clientY-rect.top)},onDocumentTouchEnd=event=>{var len=event.touches.length;this.touchZoomDistanceStart=this.touchZoomDistanceEnd=0,this.targetTouchId=-1,this._state=STATE.NONE,1==len&&zincRayCaster!==void 0&&this.pointer_x_start==event.touches[0].clientX-rect.left&&this.pointer_y_start==event.touches[0].clientY-rect.top&&zincRayCaster.pick(this.cameraObject,event.touches[0].clientX,event.touches[0].clientY,this.renderer)},onDocumentEnter=()=>{updateRect(!0)},updateRect=forced=>{//Use intersectionObserver to reset the rect for ray tracing.
if(forced||rect===void 0){var observer=new IntersectionObserver(entries=>{for(var entry of entries)rect=entry.boundingClientRect;observer.disconnect()});observer.observe(this.domElement)}},onDocumentWheelEvent=event=>{updateRect(!1),this._state=STATE.SCROLL;var changes=0;0<event.deltaY?changes=this.zoomRate:0>event.deltaY&&(changes=-1*this.zoomRate),zoomSize+=changes,event.preventDefault(),event.stopImmediatePropagation()},onDocumentKeydownEvent=event=>{updateRect(!1);var changes=0;if(event.keyCode===KEYBOARD.EQUAL||event.keyCode===KEYBOARD.MINUS||event.keyCode===KEYBOARD.NUMPADADD||event.keyCode===KEYBOARD.NUMPADSUBTRACT){this._state=STATE.KEYBOARD_ZOOM;var unit=1;event.shiftKey&&(unit*=2),event.keyCode===KEYBOARD.EQUAL||event.keyCode===KEYBOARD.NUMPADADD?changes=-1*(this.zoomRate*unit):(event.keyCode===KEYBOARD.MINUS||event.keyCode===KEYBOARD.NUMPADSUBTRACT)&&(changes=this.zoomRate*unit),zoomSize+=changes}else(event.keyCode===KEYBOARD.ARROWLEFT||event.keyCode===KEYBOARD.ARROWUP||event.keyCode===KEYBOARD.ARROWRIGHT||event.keyCode===KEYBOARD.ARROWDOWN)&&(event.shiftKey?(this._state=STATE.KEYBOARD_ROTATE,this.pointer_x_start=this.pointer_x,this.pointer_y_start=this.pointer_y,changes=this.rotateRate):(this._state=STATE.KEYBOARD_PAN,changes=this.panRate),this.previous_pointer_x=this.pointer_x,this.previous_pointer_y=this.pointer_y,event.keyCode===KEYBOARD.ARROWLEFT?this.pointer_x-=changes:event.keyCode===KEYBOARD.ARROWUP?this.pointer_y-=changes:event.keyCode===KEYBOARD.ARROWRIGHT?this.pointer_x+=changes:event.keyCode===KEYBOARD.ARROWDOWN&&(this.pointer_y+=changes));Object.values(KEYBOARD).includes(event.keyCode)&&event.preventDefault()},onDocumentKeyupEvent=event=>{this._state=STATE.NONE},translate=()=>{if("undefined"!=typeof this.cameraObject){var height=rect.height,distance=this.cameraObject.position.distanceTo(this.cameraObject.target),fact=0;this.cameraObject.far>this.cameraObject.near&&distance>=this.cameraObject.near&&distance<=this.cameraObject.far&&(fact=(distance-this.cameraObject.near)/(this.cameraObject.far-this.cameraObject.near)),_b.set(this.previous_pointer_x,height-this.previous_pointer_y,0),_c.set(this.previous_pointer_x,height-this.previous_pointer_y,1),_new_b.set(this.pointer_x,height-this.pointer_y,0),_new_c.set(this.pointer_x,height-this.pointer_y,1),_b.unproject(this.cameraObject),_c.unproject(this.cameraObject),_new_b.unproject(this.cameraObject),_new_c.unproject(this.cameraObject);var translate_rate=-.002;_new_b.sub(_b).multiplyScalar(1-fact),_new_c.sub(_c).multiplyScalar(fact),_new_b.add(_new_c).multiplyScalar(translate_rate),translateViewport(_new_b)}this.previous_pointer_x=this.pointer_x,this.previous_pointer_y=this.pointer_y};//Make sure the camera does not travel beyond limit
this.getVectorsFromRotateAboutLookAtPoints=(axis,angle)=>{axis.normalize(),_v.copy(this.cameraObject.position).sub(this.cameraObject.target),_rel_eye.copy(_v),_v.normalize(),.8<Math.abs(_v.dot(axis))&&_v.copy(this.cameraObject.up),_b.crossVectors(axis,_v).normalize(),_c.crossVectors(axis,_b);var rel_eyea=axis.dot(_rel_eye),rel_eyeb=_b.dot(_rel_eye),rel_eyec=_c.dot(_rel_eye),upa=axis.dot(this.cameraObject.up),upb=_b.dot(this.cameraObject.up),upc=_c.dot(this.cameraObject.up),cos_angle=Math.cos(angle),sin_angle=Math.sin(angle);return _new_b.set(cos_angle*_b.x+sin_angle*_c.x,cos_angle*_b.y+sin_angle*_c.y,cos_angle*_b.z+sin_angle*_c.z),_new_c.set(cos_angle*_c.x-sin_angle*_b.x,cos_angle*_c.y-sin_angle*_b.y,cos_angle*_c.z-sin_angle*_b.z),_v.copy(this.cameraObject.target),_v.x=_v.x+axis.x*rel_eyea+_new_b.x*rel_eyeb+_new_c.x*rel_eyec,_v.y=_v.y+axis.y*rel_eyea+_new_b.y*rel_eyeb+_new_c.y*rel_eyec,_v.z=_v.z+axis.z*rel_eyea+_new_b.z*rel_eyeb+_new_c.z*rel_eyec,_a.set(axis.x*upa+_new_b.x*upb+_new_c.x*upc,axis.y*upa+_new_b.y*upb+_new_c.y*upc,axis.z*upa+_new_b.z*upb+_new_c.z*upc),{position:_v,up:_a}},this.rotateAboutLookAtpoint=(axis,angle)=>{var returned_values=this.getVectorsFromRotateAboutLookAtPoints(axis,angle);this.cameraObject.position.copy(returned_values.position),this.updateDirectionalLight(),this.cameraObject.up.copy(returned_values.up)};var tumble=()=>{if("undefined"!=typeof this.cameraObject){var _rect5,_rect6,width=null===(_rect5=rect)||void 0===_rect5?void 0:_rect5.width,height=null===(_rect6=rect)||void 0===_rect6?void 0:_rect6.height;if(0<width&&0<height){var radius=.25*(width+height),delta_x=0,delta_y=0;(rotateMode===ROTATE_DIRECTION.FREE||rotateMode===ROTATE_DIRECTION.HORIZONTAL)&&(delta_x=this.pointer_x-this.previous_pointer_x),(rotateMode===ROTATE_DIRECTION.FREE||rotateMode===ROTATE_DIRECTION.VERTICAL)&&(delta_y=this.previous_pointer_y-this.pointer_y);var tangent_dist=Math.sqrt(delta_x*delta_x+delta_y*delta_y);if(0<tangent_dist){var dx=1*-delta_y/tangent_dist,dy=1*delta_x/tangent_dist,d=0;// Do not allow rotation on other direction around the origin if rotateMode is not free
if(rotateMode===ROTATE_DIRECTION.FREE){var _d=dx*(this.pointer_x-.5*(width-1))+dy*(.5*(height-1)-this.pointer_y);_d>radius?_d=radius:_d<-radius&&(_d=-radius)}var phi=Math.acos(d/radius)-.5*Math.PI,angle=this.tumble_rate*tangent_dist/radius;_a.copy(this.cameraObject.position).sub(this.cameraObject.target).normalize(),_b.copy(this.cameraObject.up).normalize(),_c.copy(_b).cross(_a).normalize().multiplyScalar(dx),_b.multiplyScalar(dy),_axis.addVectors(_c,_b).multiplyScalar(Math.cos(phi)),_a.multiplyScalar(Math.sin(phi)),_axis.add(_a),this.rotateAboutLookAtpoint(_axis,-angle)}}}this.previous_pointer_x=this.pointer_x,this.previous_pointer_y=this.pointer_y},calculateZoomDelta=()=>{var delta=0;return this._state===STATE.ZOOM?delta=this.previous_pointer_y-this.pointer_y:this._state===STATE.SCROLL||this._state===STATE.KEYBOARD_ZOOM?delta=zoomSize:(delta=-1*(this.touchZoomDistanceEnd-this.touchZoomDistanceStart),this.touchZoomDistanceStart=this.touchZoomDistanceEnd),delta};this.changeZoomByScrollRateUnit=unit=>{var delta_y=unit*this.zoomRate;this.changeZoomByValue(delta_y)},this.changeZoomByValue=delta_y=>{if("undefined"!=typeof this.cameraObject){var height=rect.height,a=this.cameraObject.position.clone();a.sub(this.cameraObject.target);var dist=a.length(),dy=1.5*delta_y/height;if(.01<dist+dy*dist&&(a.normalize(),_tempEye.copy(this.cameraObject.position),_tempEye.x+=a.x*dy*dist,_tempEye.y+=a.y*dy*dist,_tempEye.z+=a.z*dy*dist,checkTravelDistance())){this.cameraObject.position.copy(_tempEye),this.updateDirectionalLight();var near_far_minimum_ratio=1e-5;if(near_far_minimum_ratio*this.cameraObject.far<this.cameraObject.near+dy*dist+this.near_plane_fly_debt)0!=this.near_plane_fly_debt&&(this.near_plane_fly_debt+=dy*dist,0<this.near_plane_fly_debt?(this.cameraObject.near+=this.near_plane_fly_debt,this.cameraObject.far+=this.near_plane_fly_debt,this.near_plane_fly_debt=0):(this.cameraObject.near+=dy*dist,this.cameraObject.far+=dy*dist));else{if(0==this.near_plane_fly_debt){var diff=this.cameraObject.near-near_far_minimum_ratio*this.cameraObject.far;this.cameraObject.near=near_far_minimum_ratio*this.cameraObject.far,this.cameraObject.far-=diff,this.near_plane_fly_debt-=near_far_minimum_ratio*this.cameraObject.far}this.near_plane_fly_debt+=dy*dist}hasUpdated=!0}}};var flyZoom=()=>{var delta_y=calculateZoomDelta();this.changeZoomByValue(delta_y),this._state===STATE.ZOOM&&(this.previous_pointer_x=this.pointer_x,this.previous_pointer_y=this.pointer_y),(this._state===STATE.SCROLL||this._state===STATE.KEYBOARD_ZOOM)&&(zoomSize=0,this._state=STATE.NONE)};this.setDirectionalLight=directionalLightIn=>{this.directionalLight=directionalLightIn},this.updateDirectionalLight=()=>{0!=this.directionalLight&&this.directionalLight.position.set(this.cameraObject.position.x,this.cameraObject.position.y,this.cameraObject.position.z)},this.enable=function(){enabled=!0,this.domElement&&this.domElement.addEventListener&&(setCanvasTabindex(this.domElement,0),this.domElement.addEventListener("mousedown",onDocumentMouseDown,!1),this.domElement.addEventListener("mousemove",onDocumentMouseMove,!1),this.domElement.addEventListener("mouseup",onDocumentMouseUp,!1),this.domElement.addEventListener("mouseleave",onDocumentMouseLeave,!1),this.domElement.addEventListener("touchstart",onDocumentTouchStart,!1),this.domElement.addEventListener("touchmove",onDocumentTouchMove,!1),this.domElement.addEventListener("touchend",onDocumentTouchEnd,!1),this.domElement.addEventListener("wheel",onDocumentWheelEvent,!1),this.domElement.addEventListener("mouseenter",onDocumentEnter,!1),this.domElement.addEventListener("contextmenu",event=>{event.preventDefault()},!1),this.domElement.addEventListener("keydown",onDocumentKeydownEvent,!1),this.domElement.addEventListener("keyup",onDocumentKeyupEvent,!1))},this.disable=function(){enabled=!1,this.domElement&&this.domElement.removeEventListener&&(this.domElement.removeEventListener("mousedown",onDocumentMouseDown,!1),this.domElement.removeEventListener("mousemove",onDocumentMouseMove,!1),this.domElement.removeEventListener("mouseup",onDocumentMouseUp,!1),this.domElement.removeEventListener("mouseleave",onDocumentMouseLeave,!1),this.domElement.removeEventListener("touchstart",onDocumentTouchStart,!1),this.domElement.removeEventListener("touchmove",onDocumentTouchMove,!1),this.domElement.removeEventListener("touchend",onDocumentTouchEnd,!1),this.domElement.removeEventListener("wheel",onDocumentWheelEvent,!1),this.domElement.removeEventListener("mouseenter",onDocumentEnter,!1),this.domElement.removeEventListener("contextmenu",event=>{event.preventDefault()},!1),this.domElement.removeEventListener("keydown",onDocumentKeydownEvent,!1),this.domElement.removeEventListener("keyup",onDocumentKeyupEvent,!1),setCanvasTabindex(this.domElement,-1))},this.loadPath=pathData=>{cameraPath=pathData.CameraPath,numberOfCameraPoint=pathData.NumberOfPoints},this.loadPathURL=(path_url,finishCallback)=>{var xmlhttp=new XMLHttpRequest;xmlhttp.onreadystatechange=()=>{if(4==xmlhttp.readyState&&200==xmlhttp.status){var pathData=JSON.parse(xmlhttp.responseText);this.loadPath(pathData),finishCallback!=null&&"function"==typeof finishCallback&&finishCallback()}};var requestURL=resolveURL(path_url);xmlhttp.open("GET",requestURL,!0),xmlhttp.send()},this.setPathDuration=durationIn=>{duration=durationIn,smoothCameraTransitionObject&&smoothCameraTransitionObject.setDuration(duration),rotateCameraTransitionObject&&rotateCameraTransitionObject.setDuration(duration)},this.getPlayRate=()=>playRate,this.setPlayRate=playRateIn=>{playRate=playRateIn};/**
   * Update the internal timer by the set amount, this can
   * be used to force a time update by setting delta to zero.
   * 
   * @param {Number} delta - The amount of time to increment
   * the time by.
   */var updateTime=delta=>{var targetTime=inbuildTime+delta;targetTime>duration&&(targetTime-=duration),inbuildTime=targetTime};/**
   * Get the current inbuild time,
   * 
   * @return {Number}
   */this.getTime=()=>inbuildTime,this.setTime=timeIn=>{inbuildTime=timeIn>duration?duration:0>timeIn?0:timeIn},this.getNumberOfTimeFrame=()=>numberOfCameraPoint,this.getCurrentTimeFrame=()=>{if(2<numberOfCameraPoint){var current_time=inbuildTime/duration*(numberOfCameraPoint-1),bottom_frame=Math.floor(current_time),proportion=1-(current_time-bottom_frame),top_frame=Math.ceil(current_time);return bottom_frame==top_frame?bottom_frame==numberOfCameraPoint-1?[bottom_frame-1,top_frame,0]:[bottom_frame,top_frame+1,1]:[bottom_frame,top_frame,proportion]}return 1==numberOfCameraPoint?[0,0,0]:void 0},this.setCurrentTimeFrame=targetTimeFrame=>{2<numberOfCameraPoint&&(inbuildTime=duration*targetTimeFrame/(numberOfCameraPoint-1),0>inbuildTime&&(inbuildTime=0),inbuildTime>duration&&(inbuildTime=duration))};/**
   * Update the progress on the path by the specified amount - delta.
   * 
   * @param {Number} delta - The amount of time to increment
   */var updatePath=delta=>{if(currentMode===MODE.PATH&&(updateTime(delta),cameraPath)){for(var time_frame=this.getCurrentTimeFrame(),bottom_frame=time_frame[0],top_frame=time_frame[1],proportion=time_frame[2],bot_pos=[cameraPath[3*bottom_frame],cameraPath[3*bottom_frame+1],cameraPath[3*bottom_frame+2]],top_pos=[cameraPath[3*top_frame],cameraPath[3*top_frame+1],cameraPath[3*top_frame+2]],current_positions=[],i=0;i<bot_pos.length;i++)current_positions.push(proportion*bot_pos[i]+(1-proportion)*top_pos[i]);this.cameraObject.position.set(current_positions[0],current_positions[1],current_positions[2]),this.cameraObject.target.set(top_pos[0],top_pos[1],top_pos[2]),deviceOrientationControl&&this.cameraObject.lookAt(this.cameraObject.target),updateLightWithPathFlag&&(this.directionalLight.position.set(current_positions[0],current_positions[1],current_positions[2]),this.directionalLight.target.position.set(top_pos[0],top_pos[1],top_pos[2]))}};/**
   * Force recalculation of the current path.
   */this.calculatePathNow=()=>{updatePath(0)};// handle synchronised control based on information in the idc
var handleSyncControl=()=>{this._state===STATE.ROTATE||this._state===STATE.TOUCH_ROTATE||this._state===STATE.KEYBOARD_ROTATE?tumble():this._state===STATE.PAN||this._state===STATE.TOUCH_PAN||this._state===STATE.KEYBOARD_PAN?(translate(),ndcControl.triggerCallback()):(this._state===STATE.ZOOM||this._state===STATE.TOUCH_ZOOM||this._state===STATE.SCROLL||this._state===STATE.KEYBOARD_ZOOM)&&(ndcControl.zoom(calculateZoomDelta()),this.previous_pointer_x=this.pointer_x,this.previous_pointer_y=this.pointer_y,(this._state===STATE.SCROLL||this._state===STATE.KEYBOARD_ZOOM)&&(this._state=STATE.NONE),zoomSize=0,ndcControl.triggerCallback())};/**
   * Update all controls related changes - including calculation of the viewport.
   * 
   * @param {Number} timeChanged - Time eclipse since last called.
   */ /**
   * Switch to path mode and begin traveling through the camera path.
   */ /**
   * Stop playing path and switch back to normal control.
   */ /**
   * Check rather the control is currently in path mode.
   * 
   * @return {Boolean}
   */ /**
   * Enable directional light update as the camera
   * is traveling through path.
   * 
   * @param {Boolean} flag
   */ /**
   * Enable rotation using the devices's accelerometer.
   */ /**
   * Disable rotation using the devices's accelerometer.
   */ /**
   * Check rather device orientation based on accelerometer is on.
   */ /**
   * Reset the viewport settings to the one provided by default viewport.
   */ /**
   * Set the current camera settings with the provided viewport.
   * 
   * @param {Viewport} newViewport - viewport settings.
   */ /**
   * Get the viewport based on centre, radius, view_angle and clip distance.
   * 
   * @param {Number} centreX - x coordinate of the centre.
   * @param {Number} centreY - y coordinate of the centre.
   * @param {Number} centreZ - z coordinate of the centre.
   * @param {Number} radius - radius if the viewport.
   * @param {Number} view_angle - view angle.
   * @param {Number} clip_distance - clip_distance between the near and far plane.
   * 
   * @return {Viewport}
   */ /**
   * Get the viewport for the boudning box
   * 
   * @param {Number} boundingBox - y coordinate of the centre.
   * @return {Viewport}
   */ /**
   * Get the current camera viewport.
   * 
   * @return {Viewport}
   */ /**
   * Setup a smooth transition object which transition the camera from one 
   * viewport to the other in the specified duration. This will not work if 
   * {@link rotateCameraTransition} is active.
   * To use this object, the transition must be enabled using
   * {@link enableCameraTransition}.
   * 
   * @param {Viewport} startingViewport - the starting viewport
   * @param {Viewport} endingViewport - the viewport ti end the transistion with.
   * @param {Number} durationIn - duration of the smooth transition.
   */ /**
   * Setup a rotate camera transition object which rotate the 
   * camera by the specified the angle in the specified 
   * duration. This will not work if {@link cameraTransition}
   * is active.
   * To use this object, the transition must be enabled using
   * {@link enableCameraTransition}.
   * 
   * @param {THREE.Vector3} axis - the starting viewport
   * @param {Number} angle - the viewport ti end the transistion with.
   * @param {Number} duration - duration of the smooth transition.
   */ /**
   * Enable camera transition, {@link rotateCameraTransition} amd
   * {@link cameraTransition} must be called before camera transition can
   * be enabled.
   */ /**
   * Pause the camera transition.
   */ /**
   * Stop the camera transition and remove camera transition
   * and rotate camera transition.
   */ /**
   * Check if camera transition is active.
   */ /**
   * Setup auto tumble object of the camera which will rotate the camera
   * around the target as if the user is rotating the camera by mouse/touch
   * interaction.
   * The tumbling will only be enabled with {@link enabelAutoTumble}. 
   * 
   * @param {Array} tumbleDirectionIn - direction of the mouse/touch.
   * @param {Number} tumbleRateIn - Speed of the tumbling.
   * @param {Boolean} stopOnCameraInputIn - Disable the tumbling once the user
   * start interacting with the scene.
   */ /**
   * Enable autotumble.
   */ /**
   * Disable the autotumble.
   */ /**
   * Update the autotumble object.
   */ /**
   * Check rather autotumble is active.
   * 
   * @return {Boolean}
   */ /**
   * Create an internal raycaster object and enable it for picking.
   * 
   * @param {Scene} sceneIn - The scene to pick from, it can be different from the
   * camera's scene.
   * @param {requestCallback} callbackFunctionIn - The callback for pick event.
   * @param {requestCallback} hoverCallbackFunctionIn - The callback for hover
   * over event.
   */ /**
   * Disable raycaster and remove the internal ray caster object.
   */ /**
   * Check rather the camera is in syncControl mode.
   * 
   * @return {Boolean}
   */ /**
   * Enable syncControl.
   */ /**
   * Disable syncControl.
   */this.update=timeChanged=>{var delta=timeChanged*playRate,controlEnabled=enabled,updated=!0;return currentMode===MODE.PATH?updatePath(delta):currentMode===MODE.SMOOTH_CAMERA_TRANSITION&&smoothCameraTransitionObject?(smoothCameraTransitionObject.update(delta),smoothCameraTransitionObject.isTransitionCompleted()&&(null==smoothCameraTransitionObject,currentMode=MODE.DEFAULT),controlEnabled=!1):currentMode===MODE.ROTATE_CAMERA_TRANSITION&&rotateCameraTransitionObject?(rotateCameraTransitionObject.update(delta),rotateCameraTransitionObject.isTransitionCompleted()&&(null==rotateCameraTransitionObject,currentMode=MODE.DEFAULT),controlEnabled=!1):currentMode===MODE.AUTO_TUMBLE&&cameraAutoTumbleObject?cameraAutoTumbleObject.update(delta):currentMode===MODE.SYNC_CONTROL&&ndcControl?(handleSyncControl(),controlEnabled=!1):updated=!1,controlEnabled&&(this._state!==STATE.NONE&&(updated=!0),this._state===STATE.ROTATE||this._state===STATE.TOUCH_ROTATE||this._state===STATE.KEYBOARD_ROTATE?tumble():this._state===STATE.PAN||this._state===STATE.TOUCH_PAN||this._state===STATE.KEYBOARD_PAN?translate():(this._state===STATE.ZOOM||this._state===STATE.TOUCH_ZOOM||this._state===STATE.SCROLL||this._state===STATE.KEYBOARD_ZOOM)&&flyZoom(),this._state!==STATE.NONE&&currentMode===MODE.AUTO_TUMBLE&&cameraAutoTumbleObject&&cameraAutoTumbleObject.stopOnCameraInput,this._state===STATE.SCROLL&&(this._state=STATE.NONE)),deviceOrientationControl?(updated=!0,deviceOrientationControl.update()):this.cameraObject.lookAt(this.cameraObject.target),updated=updated||hasUpdated,hasUpdated=!1,updated},this.playPath=()=>{currentMode=MODE.PATH},this.stopPath=()=>{currentMode=MODE.DEFAULT},this.isPlayingPath=()=>currentMode===MODE.PATH,this.enableDirectionalLightUpdateWithPath=flag=>{updateLightWithPathFlag=flag},this.enableDeviceOrientation=()=>{deviceOrientationControl||(deviceOrientationControl=new ModifiedDeviceOrientationControls(this.cameraObject))},this.disableDeviceOrientation=()=>{deviceOrientationControl&&(deviceOrientationControl.dispose(),deviceOrientationControl=void 0)},this.isDeviceOrientationEnabled=()=>!!deviceOrientationControl,this.resetView=()=>{var viewport=viewports[defaultViewport];this.cameraObject.near=viewport.nearPlane,this.cameraObject.far=viewport.farPlane,this.cameraObject.position.set(viewport.eyePosition[0],viewport.eyePosition[1],viewport.eyePosition[2]),this.cameraObject.target.set(viewport.targetPosition[0],viewport.targetPosition[1],viewport.targetPosition[2]),this.cameraObject.up.set(viewport.upVector[0],viewport.upVector[1],viewport.upVector[2]),this.cameraObject.updateProjectionMatrix(),this.updateDirectionalLight()},this.setCurrentCameraSettings=newViewport=>{newViewport.nearPlane&&(this.cameraObject.near=newViewport.nearPlane),newViewport.farPlane&&(this.cameraObject.far=newViewport.farPlane),newViewport.eyePosition&&this.cameraObject.position.set(newViewport.eyePosition[0],newViewport.eyePosition[1],newViewport.eyePosition[2]),newViewport.targetPosition&&this.cameraObject.target.set(newViewport.targetPosition[0],newViewport.targetPosition[1],newViewport.targetPosition[2]),newViewport.upVector&&this.cameraObject.up.set(newViewport.upVector[0],newViewport.upVector[1],newViewport.upVector[2]),this.cameraObject.updateProjectionMatrix(),this.updateDirectionalLight(),hasUpdated=!0},this.getViewportFromCentreAndRadius=(centreX,centreY,centreZ,radius,view_angle,clip_distance)=>{var eyex=this.cameraObject.position.x-this.cameraObject.target.x,eyey=this.cameraObject.position.y-this.cameraObject.target.y,eyez=this.cameraObject.position.z-this.cameraObject.target.z,fact=1/Math.sqrt(eyex*eyex+eyey*eyey+eyez*eyez);eyex*=fact,eyey*=fact,eyez*=fact;/* look at the centre of the sphere */var localTargetPosition=[centreX,centreY,centreZ],eye_distance=radius/Math.tan(view_angle*Math.PI/360),localEyePosition=[centreX+eyex*eye_distance,centreY+eyey*eye_distance,centreZ+eyez*eye_distance],localFarPlane=eye_distance+clip_distance,localNearPlane=0,nearClippingFactor=.95;/* shift the eye position to achieve the desired view_angle */localNearPlane=clip_distance>nearClippingFactor*eye_distance?(1-nearClippingFactor)*eye_distance:eye_distance-clip_distance;var newViewport=new Viewport;return newViewport.nearPlane=localNearPlane,newViewport.farPlane=localFarPlane,newViewport.eyePosition=localEyePosition,newViewport.targetPosition=localTargetPosition,newViewport.upVector=[this.cameraObject.up.x,this.cameraObject.up.y,this.cameraObject.up.z],newViewport},this.getViewportFromBoundingBox=(boundingBox,radiusScale)=>{var radius=boundingBox.min.distanceTo(boundingBox.max)/2*radiusScale,centreX=(boundingBox.min.x+boundingBox.max.x)/2,centreY=(boundingBox.min.y+boundingBox.max.y)/2,centreZ=(boundingBox.min.z+boundingBox.max.z)/2,clip_factor=4,viewport=this.getViewportFromCentreAndRadius(centreX,centreY,centreZ,radius,40,radius*clip_factor);return viewport},this.getCurrentViewport=()=>{var currentViewport=new Viewport;return currentViewport.nearPlane=this.cameraObject.near,currentViewport.farPlane=this.cameraObject.far,currentViewport.eyePosition[0]=this.cameraObject.position.x,currentViewport.eyePosition[1]=this.cameraObject.position.y,currentViewport.eyePosition[2]=this.cameraObject.position.z,currentViewport.targetPosition[0]=this.cameraObject.target.x,currentViewport.targetPosition[1]=this.cameraObject.target.y,currentViewport.targetPosition[2]=this.cameraObject.target.z,currentViewport.upVector[0]=this.cameraObject.up.x,currentViewport.upVector[1]=this.cameraObject.up.y,currentViewport.upVector[2]=this.cameraObject.up.z,currentViewport},this.getDefaultEyePosition=()=>eyePosition,this.getDefaultTargetPosition=()=>targetPosition,this.cameraTransition=(startingViewport,endingViewport,durationIn)=>{rotateCameraTransitionObject==null&&(smoothCameraTransitionObject=new SmoothCameraTransition(startingViewport,endingViewport,this,durationIn))},this.rotateCameraTransition=(axis,angle,duration)=>{smoothCameraTransitionObject==null&&(rotateCameraTransitionObject=new RotateCameraTransition(axis,angle,this,duration))},this.enableCameraTransition=()=>{smoothCameraTransitionObject&&(currentMode=MODE.SMOOTH_CAMERA_TRANSITION),rotateCameraTransitionObject&&(currentMode=MODE.ROTATE_CAMERA_TRANSITION)},this.pauseCameraTransition=()=>{currentMode=MODE.DEFAULT},this.stopCameraTransition=()=>{currentMode=MODE.DEFAULT,smoothCameraTransitionObject=void 0,rotateCameraTransitionObject=void 0},this.isTransitioningCamera=()=>currentMode===MODE.SMOOTH_CAMERA_TRANSITION||currentMode===MODE.ROTATE_CAMERA_TRANSITION,this.autoTumble=(tumbleDirectionIn,tumbleRateIn,stopOnCameraInputIn)=>{cameraAutoTumbleObject=new CameraAutoTumble(tumbleDirectionIn,tumbleRateIn,stopOnCameraInputIn,this)},this.enableAutoTumble=()=>{currentMode=MODE.AUTO_TUMBLE},this.stopAutoTumble=()=>{currentMode=MODE.DEFAULT,cameraAutoTumbleObject=void 0},this.updateAutoTumble=()=>{cameraAutoTumbleObject&&(cameraAutoTumbleObject.requireUpdate=!0)},this.isAutoTumble=()=>currentMode===MODE.AUTO_TUMBLE,this.enableRaycaster=(sceneIn,callbackFunctionIn,hoverCallbackFunctionIn)=>{zincRayCaster==null&&(zincRayCaster=new RayCaster(sceneIn,this.scene,callbackFunctionIn,hoverCallbackFunctionIn,this.renderer))},this.disableRaycaster=()=>{zincRayCaster.disable(),zincRayCaster=void 0},this.isSyncControl=()=>currentMpde===MODE.SYNC_CONTROL,this.enableSyncControl=()=>(currentMode=MODE.SYNC_CONTROL,ndcControl||(ndcControl=new NDCCameraControl),ndcControl.setCurrentCameraSettings(this.cameraObject,viewports[defaultViewport]),ndcControl),this.disableSyncControl=()=>{currentMode=MODE.DEFAULT,this.cameraObject.zoom=1,this.cameraObject.updateProjectionMatrix()},this.enable()},SmoothCameraTransition=function SmoothCameraTransition(startingViewport,endingViewport,targetCameraIn,durationIn){var startingEyePosition=startingViewport.eyePosition,startingTargetPosition=startingViewport.targetPosition,startingUp=startingViewport.upVector,endingEyePosition=endingViewport.eyePosition,endingTargetPosition=endingViewport.targetPosition,endingUp=endingViewport.upVector,targetCamera=targetCameraIn,duration=durationIn,inbuildTime=0,enabled=!0,updateLightWithPathFlag=!0,completed=!1;targetCamera.near=Math.min(startingViewport.nearPlane,endingViewport.nearPlane),targetCamera.far=Math.max(startingViewport.farPlane,endingViewport.farPlane),targetCamera.cameraObject.up.set(endingViewport.upVector[0],endingViewport.upVector[1],endingViewport.upVector[2]),this.setDuration=newDuration=>{duration=newDuration};var updateTime=delta=>{var targetTime=inbuildTime+delta;targetTime>duration&&(targetTime=duration),inbuildTime=targetTime},updateCameraSettings=()=>{var ratio=inbuildTime/duration,eyePosition=[startingEyePosition[0]*(1-ratio)+endingEyePosition[0]*ratio,startingEyePosition[1]*(1-ratio)+endingEyePosition[1]*ratio,startingEyePosition[2]*(1-ratio)+endingEyePosition[2]*ratio],targetPosition=[startingTargetPosition[0]*(1-ratio)+endingTargetPosition[0]*ratio,startingTargetPosition[1]*(1-ratio)+endingTargetPosition[1]*ratio,startingTargetPosition[2]*(1-ratio)+endingTargetPosition[2]*ratio],upVector=[startingUp[0]*(1-ratio)+endingUp[0]*ratio,startingUp[1]*(1-ratio)+endingUp[1]*ratio,startingUp[2]*(1-ratio)+endingUp[2]*ratio];targetCamera.cameraObject.position.set(eyePosition[0],eyePosition[1],eyePosition[2]),targetCamera.cameraObject.target.set(targetPosition[0],targetPosition[1],targetPosition[2])};this.update=delta=>{!1===this.enabled||(updateTime(delta),updateCameraSettings(),inbuildTime==duration&&(completed=!0))},this.isTransitionCompleted=()=>completed},RotateCameraTransition=function RotateCameraTransition(axisIn,angleIn,targetCameraIn,durationIn){var axis=axisIn,angle=angleIn,targetCamera=targetCameraIn,duration=durationIn,inbuildTime=0,enabled=!0,ratio=inbuildTime/duration,completed=!1;this.setDuration=newDuration=>{duration=newDuration};var updateCameraSettings=delta=>{var previousTime=inbuildTime,targetTime=inbuildTime+delta;targetTime>duration&&(targetTime=duration),inbuildTime=targetTime;var actualDelta=inbuildTime-previousTime,ratio=actualDelta/duration,alpha=ratio*angle;targetCamera.rotateAboutLookAtpoint(axis,alpha)};this.update=delta=>{!1===this.enabled||(updateCameraSettings(delta),inbuildTime==duration&&(completed=!0))},this.isTransitionCompleted=()=>completed},RayCaster=function RayCaster(sceneIn,hostSceneIn,callbackFunctionIn,hoverCallbackFunctionIn,rendererIn){var scene=sceneIn,hostScene=hostSceneIn,renderer=rendererIn,callbackFunction=callbackFunctionIn,hoverCallbackFunction=hoverCallbackFunctionIn,enabled=!0,raycaster=new THREE.Raycaster;raycaster.params.Line.threshold=.1,raycaster.params.Points.threshold=1;var mouse=new THREE.Vector2,awaiting=!1,lastHoveredDate=new Date,lastHoveredEmpty=!1,timeDiff=0,pickedObjects=[],lastPosition={zincCamera:void 0,x:-1,y:-1},pickableObjects=void 0;this.enable=()=>{enable=!0},this.disable=()=>{enable=!1},this.getIntersectsObject=zincCamera=>{if(hostScene!==scene){var threejsScene=scene.getThreeJSScene();renderer.render(threejsScene,zincCamera.cameraObject)}var objects=pickableObjects?pickableObjects:scene.getPickableThreeJSObjects();//Reset pickedObjects array 
return pickedObjects.length=0,raycaster.intersectObjects(objects,!0,pickedObjects)},this.setPickableObjects=zincObjects=>{zincObjects===void 0?pickableObjects=void 0:(pickableObjects=[],zincObjects.forEach(zincObject=>{zincObject.getGroup()&&zincObject.getGroup().visible&&pickableObjects.push(zincObject.getGroup())}))},this.getIntersectsObjectWithOrigin=(zincCamera,origin,direction)=>(raycaster.set(origin,direction),this.getIntersectsObject(zincCamera)),this.getIntersectsObjectWithCamera=(zincCamera,x,y)=>(zincCamera.getNDCFromDocumentCoords(x,y,mouse),raycaster.setFromCamera(mouse,zincCamera.cameraObject),this.getIntersectsObject(zincCamera)),this.pick=(zincCamera,x,y)=>{if(enabled&&renderer&&scene&&zincCamera&&callbackFunction){this.getIntersectsObjectWithCamera(zincCamera,x,y);for(var zincObject,length=pickedObjects.length,i=0;i<length;i++)if(zincObject=pickedObjects[i].object?pickedObjects[i].object.userData:void 0,zincObject&&zincObject.isMarkerCluster&&zincObject.visible&&zincObject.clusterIsVisible(pickedObjects[i].object.clusterIndex)&&zincObject.zoomToCluster(pickedObjects[i].object.clusterIndex))//Can zoom into cluster
return;callbackFunction(pickedObjects,x,y)}};var hovered=(zincCamera,x,y)=>{if(enabled&&renderer&&scene&&zincCamera&&hoverCallbackFunction){if(this.getIntersectsObjectWithCamera(zincCamera,x,y),lastHoveredDate.setTime(Date.now()),0===pickedObjects.length){//skip hovered callback if the previous one is empty
if(lastHoveredEmpty)return;lastHoveredEmpty=!0}else lastHoveredEmpty=!1;hoverCallbackFunction(pickedObjects,x,y)}};this.move=(zincCamera,x,y)=>{enabled&&renderer&&scene&&zincCamera&&hoverCallbackFunction&&(scene.displayMarkers?hovered(zincCamera,x,y):(lastPosition.zincCamera=zincCamera,lastPosition.x=x,lastPosition.y=y,!awaiting&&(timeDiff=lastHoveredDate?Date.now()-lastHoveredDate.getTime():250,250<=timeDiff?hovered(zincCamera,x,y):(awaiting=!0,setTimeout(awaitMove(lastPosition),timeDiff)))))};var awaitMove=lastPosition=>function(){awaiting=!1,hovered(lastPosition.zincCamera,lastPosition.x,lastPosition.y)}},CameraAutoTumble=function CameraAutoTumble(tumbleDirectionIn,tumbleRateIn,stopOnCameraInputIn,targetCameraIn){var tumbleAxis=new THREE.Vector3,angle=-tumbleRateIn,targetCamera=targetCameraIn,enabled=!0,updateLightWithPathFlag=!0,tumbleDirection=tumbleDirectionIn;this.stopOnCameraInput=stopOnCameraInputIn,this.requireUpdate=!0;var b=new THREE.Vector3,c=new THREE.Vector3,computeTumbleAxisAngle=tumbleDirection=>{var tangent_dist=Math.sqrt(tumbleDirection[0]*tumbleDirection[0]+tumbleDirection[1]*tumbleDirection[1]),width=4*Math.abs(tumbleDirection[0]),height=4*Math.abs(tumbleDirection[1]),radius=.25*(width+height),dx=-tumbleDirection[1]/tangent_dist,dy=tumbleDirection[0]/tangent_dist,d=dx*tumbleDirection[0]+dy*-tumbleDirection[1];d>radius?d=radius:d<-radius&&(d=-radius);var phi=Math.acos(d/radius)-.5*Math.PI;/* get axis to rotate about */tumbleAxis.copy(targetCamera.cameraObject.position).sub(targetCamera.cameraObject.target).normalize(),b.copy(targetCamera.cameraObject.up).normalize(),c.crossVectors(b,tumbleAxis).normalize().multiplyScalar(dx),b.multiplyScalar(dy),b.add(c).multiplyScalar(Math.cos(phi)),tumbleAxis.multiplyScalar(Math.sin(phi)).add(b)};this.update=delta=>{!1===this.enabled||(this.requireUpdate&&(computeTumbleAxisAngle(tumbleDirection),this.requireUpdate=!1),targetCamera.rotateAboutLookAtpoint(tumbleAxis,angle*delta/1e3))}},StereoCameraZoomFixed=function StereoCameraZoomFixed(){this.type="StereoCamera",this.aspect=1,this.cameraL=new THREE.PerspectiveCamera,this.cameraL.layers.enable(1),this.cameraL.matrixAutoUpdate=!1,this.cameraR=new THREE.PerspectiveCamera,this.cameraR.layers.enable(2),this.cameraR.matrixAutoUpdate=!1};/**
 * Object with containg viewport information used in ZincJS.
 * 
 * @class
 * @author Alan Wu
 * @return {Viewport}
 */ /**
 * Provides the basic controls for a scene.
 * 
 * @class
 * @author Alan Wu
 * @return {CameraControls}
 */ /**
 * @author mrdoob / http://mrdoob.com/
 */Object.assign(StereoCameraZoomFixed.prototype,{update:(()=>{var focus,fov,aspect,near,far,zoom,eyeRight=new THREE.Matrix4,eyeLeft=new THREE.Matrix4;return function update(camera){var needsUpdate=focus!==camera.focus||fov!==camera.fov||aspect!==camera.aspect*this.aspect||near!==camera.near||far!==camera.far||zoom!==camera.zoom;if(needsUpdate){focus=camera.focus,fov=camera.fov,aspect=camera.aspect*this.aspect,near=camera.near,far=camera.far,zoom=camera.zoom;// Off-axis stereoscopic effect based on
// http://paulbourke.net/stereographics/stereorender/
var xmin,xmax,projectionMatrix=camera.projectionMatrix.clone(),eyeSep=.064/2,eyeSepOnProjection=eyeSep*near/focus,ymax=near*Math.tan(.5*(THREE.Math.DEG2RAD*fov))/camera.zoom;// translate xOffset
// for left eye
// for right eye
eyeLeft.elements[12]=-eyeSep,eyeRight.elements[12]=eyeSep,xmin=-ymax*aspect+eyeSepOnProjection,xmax=ymax*aspect+eyeSepOnProjection,projectionMatrix.elements[0]=2*near/(xmax-xmin),projectionMatrix.elements[8]=(xmax+xmin)/(xmax-xmin),this.cameraL.projectionMatrix.copy(projectionMatrix),xmin=-ymax*aspect-eyeSepOnProjection,xmax=ymax*aspect-eyeSepOnProjection,projectionMatrix.elements[0]=2*near/(xmax-xmin),projectionMatrix.elements[8]=(xmax+xmin)/(xmax-xmin),this.cameraR.projectionMatrix.copy(projectionMatrix)}this.cameraL.matrixWorld.copy(camera.matrixWorld).multiply(eyeLeft),this.cameraR.matrixWorld.copy(camera.matrixWorld).multiply(eyeRight)}})()});/** the following StereoEffect is written by third party */ /**
 * @author alteredq / http://alteredqualia.com/
 * @authod mrdoob / http://mrdoob.com/
 * @authod arodic / http://aleksandarrodic.com/
 * @authod fonserbc / http://fonserbc.github.io/
*/var StereoEffect=function StereoEffect(renderer){var _stereo=new StereoCameraZoomFixed;_stereo.aspect=.5,this.setSize=(width,height)=>{renderer.setSize(width,height)},this.render=(scene,camera)=>{scene.updateMatrixWorld(),null===camera.parent&&camera.updateMatrixWorld(),_stereo.update(camera);var size=renderer.getSize();renderer.setScissorTest(!0),renderer.clear(),renderer.setScissor(0,0,size.width/2,size.height),renderer.setViewport(0,0,size.width/2,size.height),renderer.render(scene,_stereo.cameraL),renderer.setScissor(size.width/2,0,size.width/2,size.height),renderer.setViewport(size.width/2,0,size.width/2,size.height),renderer.render(scene,_stereo.cameraR),renderer.setScissorTest(!1)}},ModifiedDeviceOrientationControls=function ModifiedDeviceOrientationControls(object){var scope=this;this.object=object,this.object.rotation.reorder("YXZ"),this.enabled=!0,this.deviceOrientation={},this.screenOrientation=0;var onDeviceOrientationChangeEvent=event=>{scope.deviceOrientation=event},onScreenOrientationChangeEvent=()=>{"undefined"!=typeof window&&(scope.screenOrientation=window.orientation||0)},setObjectQuaternion=(()=>{var zee=new THREE.Vector3(0,0,1),euler=new THREE.Euler,q0=new THREE.Quaternion,q1=new THREE.Quaternion(-Math.sqrt(.5),0,0,Math.sqrt(.5));// - PI/2 around the x-axis
return(cameraObject,alpha,beta,gamma,orient)=>{var vector=new THREE.Vector3(0,0,1);vector.subVectors(cameraObject.target,cameraObject.position),euler.set(beta,alpha,-gamma,"YXZ");// 'ZXY' for the device, but 'YXZ' for us
var quaternion=new THREE.Quaternion;// orient the device
// camera looks out the back of the device, not the top
// adjust for screen orientation
quaternion.setFromEuler(euler),quaternion.multiply(q1),quaternion.multiply(q0.setFromAxisAngle(zee,-orient)),vector.applyQuaternion(quaternion),vector.addVectors(cameraObject.position,vector),cameraObject.lookAt(vector)}})();// The angles alpha, beta and gamma form a set of intrinsic Tait-Bryan angles of type Z-X'-Y''
this.connect=()=>{onScreenOrientationChangeEvent(),"undefined"!=typeof window&&(window.addEventListener("orientationchange",onScreenOrientationChangeEvent,!1),window.addEventListener("deviceorientation",onDeviceOrientationChangeEvent,!1)),scope.enabled=!0},this.disconnect=()=>{"undefined"!=typeof window&&(window.removeEventListener("orientationchange",onScreenOrientationChangeEvent,!1),window.removeEventListener("deviceorientation",onDeviceOrientationChangeEvent,!1)),scope.enabled=!1},this.update=()=>{if(!1!==scope.enabled){// Z
// X'
// Y''
// O
var alpha=scope.deviceOrientation.alpha?THREE.Math.degToRad(scope.deviceOrientation.alpha):0,beta=scope.deviceOrientation.beta?THREE.Math.degToRad(scope.deviceOrientation.beta):0,gamma=scope.deviceOrientation.gamma?THREE.Math.degToRad(scope.deviceOrientation.gamma):0,orient=scope.screenOrientation?THREE.Math.degToRad(scope.screenOrientation):0;setObjectQuaternion(scope.object,alpha,beta,gamma,orient)}},this.dispose=function(){this.disconnect()},this.connect()},NDCCameraControl=function NDCCameraControl(){var camera=void 0,targetCamera=void 0,defaultViewport=void 0,position=new THREE.Vector3,target=new THREE.Vector3,v1=new THREE.Vector3,v2=new THREE.Vector3,eventCallback=void 0;//return top left and size
this.setCurrentCameraSettings=(cameraIn,defaultViewportIn)=>{camera=cameraIn.clone(),targetCamera=cameraIn,defaultViewport=defaultViewportIn,camera.near=defaultViewport.nearPlane,defaultViewport.farPlane&&(camera.far=defaultViewport.farPlane),defaultViewport.eyePosition&&camera.position.set(defaultViewport.eyePosition[0],defaultViewport.eyePosition[1],defaultViewport.eyePosition[2]),defaultViewport.upVector&&camera.up.set(defaultViewport.upVector[0],defaultViewport.upVector[1],defaultViewport.upVector[2]),defaultViewport.targetPosition&&(camera.target=new THREE.Vector3(defaultViewport.targetPosition[0],defaultViewport.targetPosition[1],defaultViewport.targetPosition[2]),camera.lookAt(camera.target)),camera.updateProjectionMatrix(),position.copy(camera.position).project(camera),target.copy(camera.target).project(camera)},this.getCurrentPosition=()=>(target.copy(targetCamera.target).project(camera),[target.x,target.y]),this.zoom=delta=>{var scaledDelta=.002*delta,zoom=Math.max(targetCamera.zoom-scaledDelta,1);targetCamera.zoom=zoom,targetCamera.updateProjectionMatrix()},this.zoomToBox=(box,zoom)=>{box.getCenter(v1),v1.project(camera),this.setCenterZoom([v1.x,v1.y],zoom)},this.getPanZoom=()=>({target:this.getCurrentPosition(),zoom:targetCamera.zoom}),this.setCenterZoom=(center,zoom)=>{v1.set(center[0],center[1],target.z).unproject(camera),v2.copy(v1).sub(targetCamera.target),targetCamera.target.copy(v1),targetCamera.lookAt(targetCamera.target),targetCamera.position.add(v2),targetCamera.zoom=zoom,targetCamera.updateProjectionMatrix()},this.setEventCallback=callback=>{(callback===void 0||"function"==typeof callback)&&(eventCallback=callback)},this.triggerCallback=()=>{eventCallback!==void 0&&"function"==typeof eventCallback&&eventCallback()}};/**
 * @author richt / http://richt.me
 * @author WestLangley / http://github.com/WestLangley
 *
 * W3C Device Orientation control (http://w3c.github.io/deviceorientation/spec-source-orientation.html)
 */exports.Viewport=Viewport,exports.CameraControls=CameraControls,exports.SmoothCameraTransition=SmoothCameraTransition,exports.RotateCameraTransition=RotateCameraTransition,exports.RayCaster=RayCaster,exports.CameraAutoTumble=CameraAutoTumble,exports.StereoEffect=StereoEffect,exports.NDCCameraControl=NDCCameraControl;

/***/ }),
/* 45 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var{Group,Matrix4}=__webpack_require__(4),Pointset=(__webpack_require__(22).Pointset),Lines=(__webpack_require__(24).Lines),Lines2=(__webpack_require__(46).Lines2),Geometry=(__webpack_require__(3).Geometry),THREE=__webpack_require__(4),uniqueiId=0,getUniqueId=function(){return"re"+uniqueiId++},Region=function(parentIn,sceneIn){var parent=parentIn,group=new Group;group.matrixAutoUpdate=!1,group.userData=this;var children=[],name="",zincObjects=[],scene=sceneIn,tMatrix=new Matrix4,duration=3e3;/**
   * Hide all primitives belong to this region.
   */ /**
   * Show all primitives belong to this region.
   */ /**
   * Set the visibility and propagate it down the hierarchies
   * depending on the flag.
   * 
   * @param {Boolean} flag - A flag indicating either the visibilty to be on/off.
   */ /**
   * Get the visibility of the region and its children.
   * 
   * @return {Boolean}
   */ /**
   * Get the {THREE.Group} containing all child regions and their
   * primitives.
   * 
   * @return {THREE.Group}
   */ /**
   * Set the transformation with a {THREE.Matrix4} matrix, this will affect
   * all primitives in this and its child regions
   * 
   * @param {THREE.Matrix4} transformation - The transformation matrix
   * used for the transformation.
   */ /**
   * Set the name of this region.
   * 
   * @param {String} nameIn - Name to be set for this region. It must be defined
   * and non-empty.
   */ /**
   * Get the name of this region.
   * 
   * @return {String}
   */ /**
   * Get the parent region.
   * 
   * @return {Region}
   */ /**
   * Get the array of each hierarachy from the root region to this region.
   * 
   * @return {Array}
   */ /**
   * Get the full paths from the root region to this region.
   * 
   * @return {String}
   */ /**
   * Create a new child region with the provided name.
   * @param {String} nameIn - Name to be set for the new child region.
   * 
   * @return {Region}
   */ /**
   * Get the child region with matching childName.
   * @param {String} childName - Name to be matched.
   * 
   * @return {Region}
   */ /**
   * Find a child region using the path array.
   * @param {Array} pathArray - Array containing regions' name at each
   * hierarchy to match.
   * 
   * @return {Region}
   */ /**
   * Find the region using the provided relative path.
   * 
   * @param {String} path - Relative paths from this region
   * to the child region.
   * 
   * @return {Region}
   */ /**
   * Create a new child using the path array. All required new regions
   * down the path will be created.
   * 
   * @param {Array} pathArray - Array containing regions' name, new regions
   * will be created along the path if not found.
   * 
   * @return {Region}
   */ /**
   * Create a new child using the path. All required new regions
   * down the path will be created.
   * 
   * @param {String} path - Relative paths from the region
   * to the child region.
   * 
   * @return {Region}
   */ /**
   * Return existing region if it exists, otherwise, create a new
   * region with the provided path.
   * 
   * @param {String} path - Relative paths from the region
   * to the child region.
   * 
   * @return {Region}
   */ /**
   * Add a zinc object into this region, the morph will be added
   * to the group.
   * 
   * @param {ZincObject} zincObject - Zinc object to be added into
   * this region.
   */ /**
   * Remove a ZincObject from this region if it presents. This will eventually
   * destroy the object and free up the memory.
   * 
   * @param {ZincObject} zincObject - object to be removed from this region.
   */ /**
   * Return true if pickable objects require an update.
   * 
   * @param {Boolean} transverse - Check child regions as well
   * if this is set to true.
   * 
   * @return {Boolean}
   */ /**
   * Get all pickable objects.
   */ /**
   * Set the default duration value for all zinc objects
   * that are to be loaded into this region.
   * 
   * @param {Number} durationIn - duration of the scene.
   */ /**
   * Get the default duration value.
   * returns {Number}
   */ /**
   * Get the bounding box of all the object in this and child regions only.
   * Do not include the matrix transformation here, it is done at the primitives
   * level.
   * 
   * @returns {THREE.Box3} 
   */ /**
   * Clear and dispose all objects belong to this region.
   * 
   * @param {Boolean} transverse - Clear and dispose child regions as well
   * if this is set to true.
   */ /**
   * Check if a zincObject is a member of this region.
   * 
   * @param {ZincObject} zincObject - The ZincObject to be checked.
   * @param {Boolean} transverse - Also check the child regions.
   * 
   * @return {Boolean}
   */ /**
   * A function which iterates through the list of geometries and call the callback
   * function with the geometries as the argument.
   * 
   * @param {Function} callbackFunction - Callback function with the geometry
   * as an argument.
   * @param {Boolean} transverse - Also perform the same callback function for
   * all child regions if this is set to be true.
   */ /**
   * A function which iterates through the list of glyphsets and call the callback
   * function with the glyphset as the argument.
   * 
   * @param {Function} callbackFunction - Callback function with the glyphset
   * as an argument.
   * @param {Boolean} transverse - Also perform the same callback function for
   * all child regions if this is set to be true.
   */ /**
   * A function which iterates through the list of pointsets and call the callback
   * function with the pointset as the argument.
   * 
   * @param {Function} callbackFunction - Callback function with the pointset
   * as an argument.
   * @param {Boolean} transverse - Also perform the same callback function for
   * all child regions if this is set to be true.
   */ /**
  * A function which iterates through the list of lines and call the callback
  * function with the lines as the argument.
  * 
  * @param {Function} callbackFunction - Callback function with the lines
  * as an argument.
   * @param {Boolean} transverse - Also perform the same callback function for
   * all child regions if this is set to be true.
  */ /** 
   * Find and return all zinc objects in this and child regions with 
   * the matching GroupName.
   * 
   * @param {String} groupName - Groupname to match with.
   * @param {Boolean} transverse - Also look for the object with groupName
   * in child regions if set to true.
   * @returns {Array}
   */ /** 
   * Find and return all geometries in this and child regions with 
   * the matching GroupName.
   * 
   * @param {String} groupName - Groupname to match with.
   * @param {Boolean} transverse - Also look for the object with groupName
   * in child regions if set to true.
   * @returns {Array}
   */ /** 
   * Find and return all pointsets in this and child regions with
   * the matching groupName.
   * 
   * @param {String} groupName - Groupname to match with.
   * @param {Boolean} transverse - Also look for the object with groupName
   * in child regions if set to true.
   * @returns {Array}
   */ /** 
   * Find and return all glyphsets in this and child regions with
   * the matching groupName.
   * 
   * @param {String} groupName - Groupname to match with.
   * @param {Boolean} transverse - Also look for the object with groupName
   * in child regions if set to true.
   * @returns {Array}
   */ /** 
   * Find and return all lines in this and child regions with
   * the matching groupName.
   * 
   * @param {String} groupName - Groupname to match with.
   * @param {Boolean} transverse - Also look for the object with groupName
   * in child regions if set to true.
   * @returns {Array}
   */ /** 
   * Get all zinc objects in this region.
   * 
   * @param {Boolean} transverse - Include zinc objects in child regions if this is
   * set to true.
   * @returns {Array}
   */ /** 
   * Get all child regions.
   * 
   * @param {Boolean} transverse - Include all regions which are descendants of 
   * this reigon when this is set to true.
   * @returns {Array}
   */ /**
   * Get the current time of the region.
   * Return -1 if no graphics in the region.
   * 
   * @return {Number}
   */ /**
   * Set the current time of all the objects of this region.
   * 
   * @param {Number} time  - Value to set the time to.
   * @param {Boolean} transverse - Set the time for chidl regions if
   * this is set to true.
   */ /**
   * Check if any object in this region is time varying.
   * 
   * @return {Boolean}
   */ /**
   * Update geometries and glyphsets based on the calculated time.
   * @private
   */ /**
   * Update geometries and glyphsets based on the calculated time.
   */ /**
   * Update geometries and glyphsets based on the calculated time.
   */ /**
   * Add a new geometry
   */tMatrix.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this.pickableUpdateRequired=!0,this.isRegion=!0,this.uuid=getUniqueId(),this.hideAllPrimitives=()=>{children.forEach(child=>child.hideAllPrimitives()),zincObjects.forEach(zincObject=>zincObject.setVisibility(!1))},this.showAllPrimitives=()=>{children.forEach(child=>child.showAllPrimitives()),zincObjects.forEach(zincObject=>zincObject.setVisibility(!0))},this.setVisibility=flag=>{flag!=group.visible&&(group.visible=flag,this.pickableUpdateRequired=!0)},this.getVisibility=()=>group.visible,this.getGroup=()=>group,this.setTransformation=transformation=>{tMatrix.set(...transformation),group.matrix.copy(tMatrix),group.updateMatrixWorld()},this.setName=nameIn=>{nameIn&&""!==nameIn&&(name=nameIn)},this.getName=()=>name,this.getParent=()=>parent,this.getFullSeparatedPath=()=>{var paths=[];if(""!==name){paths.push(name);for(var parentName,p=parent;p!==void 0;)parentName=p.getName(),""!==parentName&&paths.unshift(parentName),p=p.getParent()}return paths},this.getFullPath=()=>{var paths=this.getFullSeparatedPath();if(0<paths.length){var fullPath=paths.shift();return paths.forEach(path=>{fullPath=fullPath.concat("/",path)}),fullPath}return""},this.createChild=nameIn=>{var childRegion=new Region(this,scene);return childRegion.setName(nameIn),children.push(childRegion),group.add(childRegion.getGroup()),childRegion},this.getChildWithName=childName=>{if(childName)for(var lowerChildName=childName.toLowerCase(),i=0;i<children.length;i++)if(children[i].getName().toLowerCase()===lowerChildName)return children[i]},this.findChildFromSeparatedPath=pathArray=>{if(pathArray&&0<pathArray.length&&""===pathArray[0]&&pathArray.shift(),pathArray&&0<pathArray.length){var childRegion=this.getChildWithName(pathArray[0]);return childRegion?(pathArray.shift(),childRegion.findChildFromSeparatedPath(pathArray)):void 0}return this},this.findChildFromPath=path=>{var pathArray=path.split("/");return this.findChildFromSeparatedPath(pathArray)},this.createChildFromSeparatedPath=pathArray=>{if(0<pathArray.length&&""===pathArray[0]&&pathArray.shift(),0<pathArray.length){var childRegion=this.getChildWithName(pathArray[0]);return childRegion||(childRegion=this.createChild(pathArray[0])),pathArray.shift(),childRegion.createChildFromSeparatedPath(pathArray)}return this},this.createChildFromPath=path=>{var pathArray=path.split("/");return this.createChildFromSeparatedPath(pathArray)},this.findOrCreateChildFromPath=path=>{var childRegion=this.findChildFromPath(path);return childRegion||(childRegion=this.createChildFromPath(path)),childRegion},this.addZincObject=zincObject=>{zincObject&&(zincObject.setRegion(this),group.add(zincObject.getGroup()),zincObjects.push(zincObject),this.pickableUpdateRequired=!0,scene&&scene.triggerObjectAddedCallback(zincObject))},this.removeZincObject=zincObject=>{for(var i=0;i<zincObjects.length;i++)if(zincObject===zincObjects[i])return group.remove(zincObject.getGroup()),zincObjects.splice(i,1),scene&&scene.triggerObjectRemovedCallback(zincObject),zincObject.dispose(),void(this.pickableUpdateRequired=!0)},this.checkPickableUpdateRequred=transverse=>{if(this.pickableUpdateRequired)return!0;if(transverse)for(var flag=!1,i=0;i<children.length;i++)if(flag=children[i].checkPickableUpdateRequred(transverse),flag)return!0;return!1},this.getPickableThreeJSObjects=(objectsList,transverse)=>(group.visible&&(zincObjects.forEach(zincObject=>{if(zincObject.isPickable&&zincObject.getGroup()&&zincObject.getGroup().visible){var marker=zincObject.marker;marker&&marker.isEnabled()&&objectsList.push(marker.getMorph()),objectsList.push(zincObject.getGroup())}}),transverse&&children.forEach(childRegion=>{childRegion.getPickableThreeJSObjects(objectsList,transverse)}),this.pickableUpdateRequired=!1),objectsList),this.setDuration=durationIn=>{duration=durationIn,zincObjects.forEach(zincObject=>zincObject.setDuration(durationIn)),children.forEach(childRegion=>childRegion.setDuration(durationIn))},this.getDuration=()=>duration,this.getBoundingBox=transverse=>{var boundingBox1,boundingBox2;return zincObjects.forEach(zincObject=>{boundingBox2=zincObject.getBoundingBox(),boundingBox2&&(null==boundingBox1?boundingBox1=boundingBox2.clone():boundingBox1.union(boundingBox2))}),transverse&&children.forEach(childRegion=>{boundingBox2=childRegion.getBoundingBox(transverse),boundingBox2&&(null==boundingBox1?boundingBox1=boundingBox2.clone():boundingBox1.union(boundingBox2))}),boundingBox1},this.clear=transverse=>{transverse&&children.forEach(childRegion=>childRegion.clear(transverse)),zincObjects.forEach(zincObject=>{group.remove(zincObject.getGroup()),zincObject.dispose()}),children=[],zincObjects=[]},this.objectIsInRegion=(zincObject,transverse)=>{for(var i=0;i<zincObjects.length;i++)if(zincObject===zincObjects[i])return!0;if(transverse)for(var _i=0;_i<children.length;_i++)if(children[_i].objectIsInRegion(zincObject,transverse))return!0;return!1},this.forEachGeometry=(callbackFunction,transverse)=>{zincObjects.forEach(zincObject=>{zincObject.isGeometry&&callbackFunction(zincObject)}),transverse&&children.forEach(childRegion=>childRegion.forEachGeometry(callbackFunction,transverse))},this.forEachGlyphset=(callbackFunction,transverse)=>{zincObjects.forEach(zincObject=>{zincObject.isGlyphset&&callbackFunction(zincObject)}),transverse&&children.forEach(childRegion=>childRegion.forEachGlyphset(callbackFunction,transverse))},this.forEachPointset=(callbackFunction,transverse)=>{zincObjects.forEach(zincObject=>{zincObject.isPointset&&callbackFunction(zincObject)}),transverse&&children.forEach(childRegion=>childRegion.forEachPointset(callbackFunction,transverse))},this.forEachLine=(callbackFunction,transverse)=>{zincObjects.forEach(zincObject=>{zincObject.isLines&&callbackFunction(zincObject)}),transverse&&children.forEach(childRegion=>childRegion.forEachLine(callbackFunction,transverse))},this.findObjectsWithAnatomicalId=(anatomicalId,transverse)=>{var objectsArray=[];return zincObjects.forEach(zincObject=>{zincObject.anatomicalId===anatomicalId&&objectsArray.push(zincObject)}),transverse&&children.forEach(childRegion=>{var childObjects=childRegion.findObjectsWithAnatomicalId(anatomicalId,transverse);objectsArray.push(...childObjects)}),objectsArray},this.findObjectsWithGroupName=(groupName,transverse)=>{var objectsArray=[];return zincObjects.forEach(zincObject=>{var lowerObjectName=zincObject.groupName?zincObject.groupName.toLowerCase():zincObject.groupName,lowerGroupName=groupName?groupName.toLowerCase():groupName;lowerObjectName===lowerGroupName&&objectsArray.push(zincObject)}),transverse&&children.forEach(childRegion=>{var childObjects=childRegion.findObjectsWithGroupName(groupName,transverse);objectsArray.push(...childObjects)}),objectsArray},this.findGeometriesWithGroupName=(groupName,transverse)=>{var primitivesArray=this.findObjectsWithGroupName(groupName,transverse),geometriesArray=primitivesArray.filter(primitive=>primitive.isGeometry);return geometriesArray},this.findPointsetsWithGroupName=(groupName,transverse)=>{var primitivesArray=this.findObjectsWithGroupName(groupName,transverse),pointsetsArray=primitivesArray.filter(primitive=>primitive.isPointset);return pointsetsArray},this.findGlyphsetsWithGroupName=(groupName,transverse)=>{var primitivesArray=this.findObjectsWithGroupName(groupName,transverse),glyphsetsArray=primitivesArray.filter(primitive=>primitive.isGlyphset);return glyphsetsArray},this.findLinesWithGroupName=(groupName,transverse)=>{var primitivesArray=this.findObjectsWithGroupName(groupName,transverse),linesArray=primitivesArray.filter(primitive=>primitive.isLines);return linesArray},this.getAllObjects=transverse=>{var objectsArray=[...zincObjects];return transverse&&children.forEach(childRegion=>{var childObjects=childRegion.getAllObjects(transverse);objectsArray.push(...childObjects)}),objectsArray},this.getChildRegions=transverse=>{var objectsArray=[...children];return transverse&&children.forEach(childRegion=>{var childObjects=childRegion.getChildRegions(transverse);objectsArray.push(...childObjects)}),objectsArray},this.getCurrentTime=()=>{if(zincObjects[0]!=null)return zincObjects[0].getCurrentTime();for(var time,i=0;i<children.length;i++)if(time=children[i].getCurrentTime(),-1!==time)return time;return-1},this.setMorphTime=(time,transverse)=>{zincObjects.forEach(zincObject=>{zincObject.setMorphTime(time)}),transverse&&children.forEach(childRegion=>{childRegion.setMorphTime(time)})},this.isTimeVarying=()=>{for(var i=0;i<zincObjects.length;i++)if(zincObjects[i].isTimeVarying())return!0;for(var _i2=0;_i2<children.length;_i2++)if(children[_i2].isTimeVarying())return!0;return!1},this.renderGeometries=(playRate,delta,playAnimation,cameraControls,options,transverse)=>{var _options$markerCluste,allObjects=this.getAllObjects(transverse);// Let video dictates the progress if one is present
allObjects.forEach(zincObject=>{zincObject.render(playRate*delta,playAnimation,cameraControls,options)}),options&&!1===playAnimation&&null!==(_options$markerCluste=options.markerCluster)&&void 0!==_options$markerCluste&&_options$markerCluste.markerUpdateRequired&&options.markerCluster.calculate()},this.createPoints=(groupName,coords,labels,colour)=>{var isNew=!1,zincObjects=this.findObjectsWithGroupName(groupName,!1),index=zincObjects.findIndex(zincObject=>zincObject.isPointset),pointset=-1<index?zincObjects[index]:new Pointset;return pointset.addPoints(coords,labels,colour),-1===index?(pointset.setName(groupName),this.addZincObject(pointset),isNew=!0):this.pickableUpdateRequired=!0,{zincObject:pointset,isNew}},this.createLines=(groupName,coords,colour)=>{var isNew=!1,zincObjects=this.findObjectsWithGroupName(groupName,!1),index=zincObjects.findIndex(zincObject=>zincObject.isLines),lines=-1<index?zincObjects[index]:new Lines2;return lines.addLines(coords,colour),-1===index?(lines.setName(groupName),this.addZincObject(lines),isNew=!0):this.pickableUpdateRequired=!0,{zincObject:lines,isNew}},this.createGeometryFromThreeJSGeometry=(groupName,geometry,colour,opacity,visibility,renderOrder)=>{var zincGeometry=new Geometry,material=new THREE.MeshPhongMaterial({color:colour,morphTargets:!1,morphNormals:!1,transparent:!0,opacity:opacity,side:THREE.DoubleSide});return zincGeometry.createMesh(geometry,material,{localTimeEnabled:!1,localMorphColour:!1}),zincGeometry.getMorph()?(zincGeometry.setVisibility(!1),zincGeometry.setName(groupName),zincGeometry.setRenderOrder(renderOrder),this.addZincObject(zincGeometry),zincGeometry):void 0}};/**
 * Provides a hierachical structure to objects, Each region
 * may contain multiple child regions and {@link ZincObject}.
 * 
 * @class
 * @author Alan Wu
 * @return {Region}
 */exports.Region=Region;

/***/ }),
/* 46 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),toBufferGeometry=(__webpack_require__(5).toBufferGeometry),LineSegments2=(__webpack_require__(47).LineSegments2),LineMaterial=(__webpack_require__(49).LineMaterial),LineSegmentsGeometry=(__webpack_require__(48).LineSegmentsGeometry),Lines2=function(){(__webpack_require__(24).Lines).call(this),this.isLines2=!0;var positions=Array(300);/**
   * Create the line segements using geometry and material.
   * 
   * @param {Array} arrayIn - Geometry of lines to be rendered.
   * @param {THREE.Material} materialIn - Material to be set for the lines.
   * @param {Object} options - Provide various options
   * @param {Boolean} options.localTimeEnabled - A flag to indicate either the lines is
   * time dependent.
   * @param {Boolean} options.localMorphColour - A flag to indicate either the colour is
   * time dependent.
   */ /**
   * Set the width for the lines.
   * 
   * @param {Number} width - Width of the lines.
   */ /**
   * Add new vertices into the array
   */ /**
   * Get the vertices by face index
   */ /**
   * Edit Vertice in index.
   */ /**
   * Add new lines to existing lines if it exists, otherwise
   * create a new one and add to it.
   * @param {Array} coords  -An array of three components coordinates.

   * @param {Number} colour - A hex value of the colour for the points
   */this.createLineSegment=(arrayIn,materialIn,options)=>{if(arrayIn&&materialIn){var linesGeometry=new LineSegmentsGeometry;linesGeometry.setPositions(arrayIn),linesGeometry.colorsNeedUpdate=!0;var line=new LineSegments2(linesGeometry,materialIn);line.scale.set(1,1,1),line.computeLineDistances(),this.setMesh(line,options.localTimeEnabled,options.localMorphColour)}},this.setWidth=width=>{this.morph&&this.morph.material&&(this.morph.material.linewidth=width,this.morph.material.needsUpdate=!0)},this.addVertices=function(coords){if(coords&&coords.length){var mesh=this.getMorph();mesh||(this.drawRange=0);var index=3*this.drawRange;//fill the rest of the array.
if(coords.forEach(coord=>{positions[index++]=coord[0],positions[index++]=coord[1],positions[index++]=coord[2],this.drawRange++}),!mesh)for(;300>index;)positions[index++]=coords[0][0],positions[index++]=coords[0][1],positions[index++]=coords[0][2];mesh&&(mesh.geometry.setPositions(positions),mesh.computeLineDistances(),this.boundingBoxUpdateRequired=!0)}return positions},this.getVerticesByFaceIndex=function(faceIndex){var vIndex=3*(2*faceIndex),mesh=this.getMorph();if(mesh&&3*this.drawRange>vIndex){var position=mesh.geometry.getAttribute("instanceStart");return[[position.data.array[vIndex],position.data.array[++vIndex],position.data.array[++vIndex]],[position.data.array[++vIndex],position.data.array[++vIndex],position.data.array[++vIndex]]]}return[]},this.editVertices=function(coords,i){if(coords&&coords.length){var mesh=this.getMorph(),maxIndex=i+coords.length-1;if(!mesh||0>i||maxIndex>=this.drawRange)return;var index=3*i;for(coords.forEach(coord=>{positions[index++]=coord[0],positions[index++]=coord[1],positions[index++]=coord[2]}),index=3*this.drawRange;300>index;)positions[index++]=coords[0][0],positions[index++]=coords[0][1],positions[index++]=coords[0][2];mesh.geometry.setPositions(positions),mesh.computeLineDistances(),this.boundingBoxUpdateRequired=!0}return positions},this.addLines=(coords,colour)=>{if(coords&&0<coords.length){this.addVertices(coords);var mesh=this.getMorph();if(!mesh){var material=new LineMaterial({color:colour,linewidth:1,vertexColors:!1,worldUnits:!1});material.resolution.set(window.innerWidth,window.innerHeight);this.createLineSegment(positions,material,{localTimeEnabled:!1,localMorphColour:!1})}this.region&&(this.region.pickableUpdateRequired=!0)}},this.render=()=>{var material=this.getMorph().material;material.resolution.set(window.innerWidth,window.innerHeight)}};/**
 * Provides an object which stores lines.
 * This is created when a valid json file containing lines is read into a {@link Zinc.Scene}
 * object.
 * 
 * @class
 * @author Alan Wu
 * @return {Lines}
 */Lines2.prototype=Object.create((__webpack_require__(24).Lines).prototype),Lines2.prototype.constructor=Lines2,exports.Lines2=Lines2;

/***/ }),
/* 47 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LineSegments2: () => (/* binding */ LineSegments2)
/* harmony export */ });
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(three__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _LineSegmentsGeometry_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48);
/* harmony import */ var _LineMaterial_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(49);
var _start=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_end=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_start4=new three__WEBPACK_IMPORTED_MODULE_0__.Vector4,_end4=new three__WEBPACK_IMPORTED_MODULE_0__.Vector4,_ssOrigin=new three__WEBPACK_IMPORTED_MODULE_0__.Vector4,_ssOrigin3=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_mvMatrix=new three__WEBPACK_IMPORTED_MODULE_0__.Matrix4,_line=new three__WEBPACK_IMPORTED_MODULE_0__.Line3,_closestPoint=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,_box=new three__WEBPACK_IMPORTED_MODULE_0__.Box3,_sphere=new three__WEBPACK_IMPORTED_MODULE_0__.Sphere,_clipToWorldVector=new three__WEBPACK_IMPORTED_MODULE_0__.Vector4;class LineSegments2 extends three__WEBPACK_IMPORTED_MODULE_0__.Mesh{constructor(){var geometry=0<arguments.length&&arguments[0]!==void 0?arguments[0]:new _LineSegmentsGeometry_js__WEBPACK_IMPORTED_MODULE_1__.LineSegmentsGeometry,material=1<arguments.length&&arguments[1]!==void 0?arguments[1]:new _LineMaterial_js__WEBPACK_IMPORTED_MODULE_2__.LineMaterial({color:16777215*Math.random()});super(geometry,material),this.type="LineSegments2"}// for backwards-compatability, but could be a method of LineSegmentsGeometry...
computeLineDistances(){for(var geometry=this.geometry,instanceStart=geometry.attributes.instanceStart,instanceEnd=geometry.attributes.instanceEnd,lineDistances=new Float32Array(2*instanceStart.count),i=0,j=0,l=instanceStart.count;i<l;i++,j+=2)_start.fromBufferAttribute(instanceStart,i),_end.fromBufferAttribute(instanceEnd,i),lineDistances[j]=0==j?0:lineDistances[j-1],lineDistances[j+1]=lineDistances[j]+_start.distanceTo(_end);var instanceDistanceBuffer=new three__WEBPACK_IMPORTED_MODULE_0__.InstancedInterleavedBuffer(lineDistances,2,1);// d0, d1
// d1
return geometry.setAttribute("instanceDistanceStart",new three__WEBPACK_IMPORTED_MODULE_0__.InterleavedBufferAttribute(instanceDistanceBuffer,1,0)),geometry.setAttribute("instanceDistanceEnd",new three__WEBPACK_IMPORTED_MODULE_0__.InterleavedBufferAttribute(instanceDistanceBuffer,1,1)),this}raycast(raycaster,intersects){null===raycaster.camera&&console.error("LineSegments2: \"Raycaster.camera\" needs to be set in order to raycast against LineSegments2.");var threshold=void 0===raycaster.params.Line2?0:raycaster.params.Line2.threshold||0,ray=raycaster.ray,camera=raycaster.camera,projectionMatrix=camera.projectionMatrix,matrixWorld=this.matrixWorld,geometry=this.geometry,material=this.material,resolution=material.resolution,lineWidth=material.linewidth+threshold,instanceStart=geometry.attributes.instanceStart,instanceEnd=geometry.attributes.instanceEnd,near=-camera.near,ssMaxWidth=2*Math.max(lineWidth/resolution.width,lineWidth/resolution.height);// camera forward is negative
// clip space is [ - 1, 1 ] so multiply by two to get the full
// width in clip space
null===geometry.boundingSphere&&geometry.computeBoundingSphere(),_sphere.copy(geometry.boundingSphere).applyMatrix4(matrixWorld);var distanceToSphere=Math.max(camera.near,_sphere.distanceToPoint(ray.origin));// get the w component to scale the world space line width
_clipToWorldVector.set(0,0,-distanceToSphere,1).applyMatrix4(camera.projectionMatrix),_clipToWorldVector.multiplyScalar(1/_clipToWorldVector.w),_clipToWorldVector.applyMatrix4(camera.projectionMatrixInverse);// increase the sphere bounds by the worst case line screen space width
var sphereMargin=.5*Math.abs(ssMaxWidth/_clipToWorldVector.w);if(_sphere.radius+=sphereMargin,!1!==raycaster.ray.intersectsSphere(_sphere)){null===geometry.boundingBox&&geometry.computeBoundingBox(),_box.copy(geometry.boundingBox).applyMatrix4(matrixWorld);var distanceToBox=Math.max(camera.near,_box.distanceToPoint(ray.origin));// get the w component to scale the world space line width
_clipToWorldVector.set(0,0,-distanceToBox,1).applyMatrix4(camera.projectionMatrix),_clipToWorldVector.multiplyScalar(1/_clipToWorldVector.w),_clipToWorldVector.applyMatrix4(camera.projectionMatrixInverse);// increase the sphere bounds by the worst case line screen space width
var boxMargin=.5*Math.abs(ssMaxWidth/_clipToWorldVector.w);if(_box.max.x+=boxMargin,_box.max.y+=boxMargin,_box.max.z+=boxMargin,_box.min.x-=boxMargin,_box.min.y-=boxMargin,_box.min.z-=boxMargin,!1!==raycaster.ray.intersectsBox(_box)){ray.at(1,_ssOrigin),_ssOrigin.w=1,_ssOrigin.applyMatrix4(camera.matrixWorldInverse),_ssOrigin.applyMatrix4(projectionMatrix),_ssOrigin.multiplyScalar(1/_ssOrigin.w),_ssOrigin.x*=resolution.x/2,_ssOrigin.y*=resolution.y/2,_ssOrigin.z=0,_ssOrigin3.copy(_ssOrigin),_mvMatrix.multiplyMatrices(camera.matrixWorldInverse,matrixWorld);for(var i=0,l=instanceStart.count;i<l;i++){_start4.fromBufferAttribute(instanceStart,i),_end4.fromBufferAttribute(instanceEnd,i),_start4.w=1,_end4.w=1,_start4.applyMatrix4(_mvMatrix),_end4.applyMatrix4(_mvMatrix);// skip the segment if it's entirely behind the camera
var isBehindCameraNear=_start4.z>near&&_end4.z>near;if(!isBehindCameraNear){// trim the segment if it extends behind camera near
if(_start4.z>near){var deltaDist=_start4.z-_end4.z,t=(_start4.z-near)/deltaDist;_start4.lerp(_end4,t)}else if(_end4.z>near){var _deltaDist=_end4.z-_start4.z,_t=(_end4.z-near)/_deltaDist;_end4.lerp(_start4,_t)}// clip space
_start4.applyMatrix4(projectionMatrix),_end4.applyMatrix4(projectionMatrix),_start4.multiplyScalar(1/_start4.w),_end4.multiplyScalar(1/_end4.w),_start4.x*=resolution.x/2,_start4.y*=resolution.y/2,_end4.x*=resolution.x/2,_end4.y*=resolution.y/2,_line.start.copy(_start4),_line.start.z=0,_line.end.copy(_end4),_line.end.z=0;// get closest point on ray to segment
var param=_line.closestPointToPointParameter(_ssOrigin3,!0);_line.at(param,_closestPoint);// check if the intersection point is within clip space
var zPos=three__WEBPACK_IMPORTED_MODULE_0__.MathUtils.lerp(_start4.z,_end4.z,param),isInClipSpace=-1<=zPos&&1>=zPos,isInside=_ssOrigin3.distanceTo(_closestPoint)<.5*lineWidth;if(isInClipSpace&&isInside){_line.start.fromBufferAttribute(instanceStart,i),_line.end.fromBufferAttribute(instanceEnd,i),_line.start.applyMatrix4(matrixWorld),_line.end.applyMatrix4(matrixWorld);var pointOnLine=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3,point=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3;ray.distanceSqToSegment(_line.start,_line.end,point,pointOnLine),intersects.push({point:point,pointOnLine:pointOnLine,distance:ray.origin.distanceTo(point),object:this,face:null,faceIndex:i,uv:null,uv2:null})}}}}//
// pick a point 1 unit out along the ray to avoid the ray origin
// sitting at the camera origin which will cause "w" to be 0 when
// applying the projection matrix.
}//
// check if we intersect the box bounds
}}LineSegments2.prototype.LineSegments2=!0;

/***/ }),
/* 48 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LineSegmentsGeometry: () => (/* binding */ LineSegmentsGeometry)
/* harmony export */ });
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(three__WEBPACK_IMPORTED_MODULE_0__);
var _box=new three__WEBPACK_IMPORTED_MODULE_0__.Box3,_vector=new three__WEBPACK_IMPORTED_MODULE_0__.Vector3;class LineSegmentsGeometry extends three__WEBPACK_IMPORTED_MODULE_0__.InstancedBufferGeometry{constructor(){super(),this.type="LineSegmentsGeometry";this.setIndex([0,2,1,2,3,1,2,4,3,4,5,3,4,6,5,6,7,5]),this.setAttribute("position",new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute([-1,2,0,1,2,0,-1,1,0,1,1,0,-1,0,0,1,0,0,-1,-1,0,1,-1,0],3)),this.setAttribute("uv",new three__WEBPACK_IMPORTED_MODULE_0__.Float32BufferAttribute([-1,2,1,2,-1,1,1,1,-1,-1,1,-1,-1,-2,1,-2],2))}applyMatrix4(matrix){var start=this.attributes.instanceStart,end=this.attributes.instanceEnd;return void 0!==start&&(start.applyMatrix4(matrix),end.applyMatrix4(matrix),start.needsUpdate=!0),null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this}setPositions(array){var lineSegments;array instanceof Float32Array?lineSegments=array:Array.isArray(array)&&(lineSegments=new Float32Array(array));var instanceBuffer=new three__WEBPACK_IMPORTED_MODULE_0__.InstancedInterleavedBuffer(lineSegments,6,1);// xyz, xyz
return this.setAttribute("instanceStart",new three__WEBPACK_IMPORTED_MODULE_0__.InterleavedBufferAttribute(instanceBuffer,3,0)),this.setAttribute("instanceEnd",new three__WEBPACK_IMPORTED_MODULE_0__.InterleavedBufferAttribute(instanceBuffer,3,3)),this.computeBoundingBox(),this.computeBoundingSphere(),this}setColors(array){var colors;array instanceof Float32Array?colors=array:Array.isArray(array)&&(colors=new Float32Array(array));var instanceColorBuffer=new three__WEBPACK_IMPORTED_MODULE_0__.InstancedInterleavedBuffer(colors,6,1);// rgb, rgb
// rgb
return this.setAttribute("instanceColorStart",new three__WEBPACK_IMPORTED_MODULE_0__.InterleavedBufferAttribute(instanceColorBuffer,3,0)),this.setAttribute("instanceColorEnd",new three__WEBPACK_IMPORTED_MODULE_0__.InterleavedBufferAttribute(instanceColorBuffer,3,3)),this}fromWireframeGeometry(geometry){return this.setPositions(geometry.attributes.position.array),this}fromEdgesGeometry(geometry){return this.setPositions(geometry.attributes.position.array),this}fromMesh(mesh){// set colors, maybe
return this.fromWireframeGeometry(new three__WEBPACK_IMPORTED_MODULE_0__.WireframeGeometry(mesh.geometry)),this}fromLineSegments(lineSegments){var geometry=lineSegments.geometry;return geometry.isGeometry?void console.error("THREE.LineSegmentsGeometry no longer supports Geometry. Use THREE.BufferGeometry instead."):(geometry.isBufferGeometry&&this.setPositions(geometry.attributes.position.array),this);// set colors, maybe
}computeBoundingBox(){null===this.boundingBox&&(this.boundingBox=new three__WEBPACK_IMPORTED_MODULE_0__.Box3);var start=this.attributes.instanceStart,end=this.attributes.instanceEnd;start!==void 0&&end!==void 0&&(this.boundingBox.setFromBufferAttribute(start),_box.setFromBufferAttribute(end),this.boundingBox.union(_box))}computeBoundingSphere(){null===this.boundingSphere&&(this.boundingSphere=new three__WEBPACK_IMPORTED_MODULE_0__.Sphere),null===this.boundingBox&&this.computeBoundingBox();var start=this.attributes.instanceStart,end=this.attributes.instanceEnd;if(start!==void 0&&end!==void 0){var center=this.boundingSphere.center;this.boundingBox.getCenter(center);for(var maxRadiusSq=0,i=0,il=start.count;i<il;i++)_vector.fromBufferAttribute(start,i),maxRadiusSq=Math.max(maxRadiusSq,center.distanceToSquared(_vector)),_vector.fromBufferAttribute(end,i),maxRadiusSq=Math.max(maxRadiusSq,center.distanceToSquared(_vector));this.boundingSphere.radius=Math.sqrt(maxRadiusSq),isNaN(this.boundingSphere.radius)&&console.error("THREE.LineSegmentsGeometry.computeBoundingSphere(): Computed radius is NaN. The instanced position data is likely to have NaN values.",this)}}toJSON(){// todo
}applyMatrix(matrix){return console.warn("THREE.LineSegmentsGeometry: applyMatrix() has been renamed to applyMatrix4()."),this.applyMatrix4(matrix)}}LineSegmentsGeometry.prototype.isLineSegmentsGeometry=!0;

/***/ }),
/* 49 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LineMaterial: () => (/* binding */ LineMaterial)
/* harmony export */ });
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var three__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(three__WEBPACK_IMPORTED_MODULE_0__);
/**
 * parameters = {
 *  color: <hex>,
 *  linewidth: <float>,
 *  dashed: <boolean>,
 *  dashScale: <float>,
 *  dashSize: <float>,
 *  dashOffset: <float>,
 *  gapSize: <float>,
 *  resolution: <Vector2>, // to be set by renderer
 * }
 */three__WEBPACK_IMPORTED_MODULE_0__.UniformsLib.line={linewidth:{value:1},resolution:{value:new three__WEBPACK_IMPORTED_MODULE_0__.Vector2(1,1)},dashScale:{value:1},dashSize:{value:1},dashOffset:{value:0},gapSize:{value:1},// todo FIX - maybe change to totalSize
opacity:{value:1}},three__WEBPACK_IMPORTED_MODULE_0__.ShaderLib.line={uniforms:three__WEBPACK_IMPORTED_MODULE_0__.UniformsUtils.merge([three__WEBPACK_IMPORTED_MODULE_0__.UniformsLib.common,three__WEBPACK_IMPORTED_MODULE_0__.UniformsLib.fog,three__WEBPACK_IMPORTED_MODULE_0__.UniformsLib.line]),vertexShader:/* glsl */"\n\t\t#include <common>\n\t\t#include <color_pars_vertex>\n\t\t#include <fog_pars_vertex>\n\t\t#include <logdepthbuf_pars_vertex>\n\t\t#include <clipping_planes_pars_vertex>\n\n\t\tuniform float linewidth;\n\t\tuniform vec2 resolution;\n\n\t\tattribute vec3 instanceStart;\n\t\tattribute vec3 instanceEnd;\n\n\t\tattribute vec3 instanceColorStart;\n\t\tattribute vec3 instanceColorEnd;\n\n\t\tvarying vec2 vUv;\n\n\t\t#ifdef USE_DASH\n\n\t\t\tuniform float dashScale;\n\t\t\tattribute float instanceDistanceStart;\n\t\t\tattribute float instanceDistanceEnd;\n\t\t\tvarying float vLineDistance;\n\n\t\t#endif\n\n\t\tvoid trimSegment( const in vec4 start, inout vec4 end ) {\n\n\t\t\t// trim end segment so it terminates between the camera plane and the near plane\n\n\t\t\t// conservative estimate of the near plane\n\t\t\tfloat a = projectionMatrix[ 2 ][ 2 ]; // 3nd entry in 3th column\n\t\t\tfloat b = projectionMatrix[ 3 ][ 2 ]; // 3nd entry in 4th column\n\t\t\tfloat nearEstimate = - 0.5 * b / a;\n\n\t\t\tfloat alpha = ( nearEstimate - start.z ) / ( end.z - start.z );\n\n\t\t\tend.xyz = mix( start.xyz, end.xyz, alpha );\n\n\t\t}\n\n\t\tvoid main() {\n\n\t\t\t#ifdef USE_COLOR\n\n\t\t\t\tvColor.xyz = ( position.y < 0.5 ) ? instanceColorStart : instanceColorEnd;\n\n\t\t\t#endif\n\n\t\t\t#ifdef USE_DASH\n\n\t\t\t\tvLineDistance = ( position.y < 0.5 ) ? dashScale * instanceDistanceStart : dashScale * instanceDistanceEnd;\n\n\t\t\t#endif\n\n\t\t\tfloat aspect = resolution.x / resolution.y;\n\n\t\t\tvUv = uv;\n\n\t\t\t// camera space\n\t\t\tvec4 start = modelViewMatrix * vec4( instanceStart, 1.0 );\n\t\t\tvec4 end = modelViewMatrix * vec4( instanceEnd, 1.0 );\n\n\t\t\t// special case for perspective projection, and segments that terminate either in, or behind, the camera plane\n\t\t\t// clearly the gpu firmware has a way of addressing this issue when projecting into ndc space\n\t\t\t// but we need to perform ndc-space calculations in the shader, so we must address this issue directly\n\t\t\t// perhaps there is a more elegant solution -- WestLangley\n\n\t\t\tbool perspective = ( projectionMatrix[ 2 ][ 3 ] == - 1.0 ); // 4th entry in the 3rd column\n\n\t\t\tif ( perspective ) {\n\n\t\t\t\tif ( start.z < 0.0 && end.z >= 0.0 ) {\n\n\t\t\t\t\ttrimSegment( start, end );\n\n\t\t\t\t} else if ( end.z < 0.0 && start.z >= 0.0 ) {\n\n\t\t\t\t\ttrimSegment( end, start );\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\t// clip space\n\t\t\tvec4 clipStart = projectionMatrix * start;\n\t\t\tvec4 clipEnd = projectionMatrix * end;\n\n\t\t\t// ndc space\n\t\t\tvec2 ndcStart = clipStart.xy / clipStart.w;\n\t\t\tvec2 ndcEnd = clipEnd.xy / clipEnd.w;\n\n\t\t\t// direction\n\t\t\tvec2 dir = ndcEnd - ndcStart;\n\n\t\t\t// account for clip-space aspect ratio\n\t\t\tdir.x *= aspect;\n\t\t\tdir = normalize( dir );\n\n\t\t\t// perpendicular to dir\n\t\t\tvec2 offset = vec2( dir.y, - dir.x );\n\n\t\t\t// undo aspect ratio adjustment\n\t\t\tdir.x /= aspect;\n\t\t\toffset.x /= aspect;\n\n\t\t\t// sign flip\n\t\t\tif ( position.x < 0.0 ) offset *= - 1.0;\n\n\t\t\t// endcaps\n\t\t\tif ( position.y < 0.0 ) {\n\n\t\t\t\toffset += - dir;\n\n\t\t\t} else if ( position.y > 1.0 ) {\n\n\t\t\t\toffset += dir;\n\n\t\t\t}\n\n\t\t\t// adjust for linewidth\n\t\t\toffset *= linewidth;\n\n\t\t\t// adjust for clip-space to screen-space conversion // maybe resolution should be based on viewport ...\n\t\t\toffset /= resolution.y;\n\n\t\t\t// select end\n\t\t\tvec4 clip = ( position.y < 0.5 ) ? clipStart : clipEnd;\n\n\t\t\t// back to clip space\n\t\t\toffset *= clip.w;\n\n\t\t\tclip.xy += offset;\n\n\t\t\tgl_Position = clip;\n\n\t\t\tvec4 mvPosition = ( position.y < 0.5 ) ? start : end; // this is an approximation\n\n\t\t\t#include <logdepthbuf_vertex>\n\t\t\t#include <clipping_planes_vertex>\n\t\t\t#include <fog_vertex>\n\n\t\t}",fragmentShader:/* glsl */"\n\t\tuniform vec3 diffuse;\n\t\tuniform float opacity;\n\n\t\t#ifdef USE_DASH\n\n\t\t\tuniform float dashSize;\n\t\t\tuniform float dashOffset;\n\t\t\tuniform float gapSize;\n\n\t\t#endif\n\n\t\tvarying float vLineDistance;\n\n\t\t#include <common>\n\t\t#include <color_pars_fragment>\n\t\t#include <fog_pars_fragment>\n\t\t#include <logdepthbuf_pars_fragment>\n\t\t#include <clipping_planes_pars_fragment>\n\n\t\tvarying vec2 vUv;\n\n\t\tvoid main() {\n\n\t\t\t#include <clipping_planes_fragment>\n\n\t\t\t#ifdef USE_DASH\n\n\t\t\t\tif ( vUv.y < - 1.0 || vUv.y > 1.0 ) discard; // discard endcaps\n\n\t\t\t\tif ( mod( vLineDistance + dashOffset, dashSize + gapSize ) > dashSize ) discard; // todo - FIX\n\n\t\t\t#endif\n\n\t\t\tfloat alpha = opacity;\n\n\t\t\t#ifdef ALPHA_TO_COVERAGE\n\n\t\t\t// artifacts appear on some hardware if a derivative is taken within a conditional\n\t\t\tfloat a = vUv.x;\n\t\t\tfloat b = ( vUv.y > 0.0 ) ? vUv.y - 1.0 : vUv.y + 1.0;\n\t\t\tfloat len2 = a * a + b * b;\n\t\t\tfloat dlen = fwidth( len2 );\n\n\t\t\tif ( abs( vUv.y ) > 1.0 ) {\n\n\t\t\t\talpha = 1.0 - smoothstep( 1.0 - dlen, 1.0 + dlen, len2 );\n\n\t\t\t}\n\n\t\t\t#else\n\n\t\t\tif ( abs( vUv.y ) > 1.0 ) {\n\n\t\t\t\tfloat a = vUv.x;\n\t\t\t\tfloat b = ( vUv.y > 0.0 ) ? vUv.y - 1.0 : vUv.y + 1.0;\n\t\t\t\tfloat len2 = a * a + b * b;\n\n\t\t\t\tif ( len2 > 1.0 ) discard;\n\n\t\t\t}\n\n\t\t\t#endif\n\n\t\t\tvec4 diffuseColor = vec4( diffuse, alpha );\n\n\t\t\t#include <logdepthbuf_fragment>\n\t\t\t#include <color_fragment>\n\n\t\t\tgl_FragColor = vec4( diffuseColor.rgb, alpha );\n\n\t\t\t#include <tonemapping_fragment>\n\t\t\t#include <encodings_fragment>\n\t\t\t#include <fog_fragment>\n\t\t\t#include <premultiplied_alpha_fragment>\n\n\t\t}"};class LineMaterial extends three__WEBPACK_IMPORTED_MODULE_0__.ShaderMaterial{constructor(parameters){super({type:"LineMaterial",uniforms:three__WEBPACK_IMPORTED_MODULE_0__.UniformsUtils.clone(three__WEBPACK_IMPORTED_MODULE_0__.ShaderLib.line.uniforms),vertexShader:three__WEBPACK_IMPORTED_MODULE_0__.ShaderLib.line.vertexShader,fragmentShader:three__WEBPACK_IMPORTED_MODULE_0__.ShaderLib.line.fragmentShader,clipping:!0// required for clipping support
}),Object.defineProperties(this,{color:{enumerable:!0,get:function get(){return this.uniforms.diffuse.value},set:function set(value){this.uniforms.diffuse.value=value}},linewidth:{enumerable:!0,get:function get(){return this.uniforms.linewidth.value},set:function set(value){this.uniforms.linewidth.value=value}},dashed:{enumerable:!0,get:function get(){return!!("USE_DASH"in this.defines)},set(value){!!value!==!!("USE_DASH"in this.defines)&&(this.needsUpdate=!0),!0===value?this.defines.USE_DASH="":delete this.defines.USE_DASH}},dashScale:{enumerable:!0,get:function get(){return this.uniforms.dashScale.value},set:function set(value){this.uniforms.dashScale.value=value}},dashSize:{enumerable:!0,get:function get(){return this.uniforms.dashSize.value},set:function set(value){this.uniforms.dashSize.value=value}},dashOffset:{enumerable:!0,get:function get(){return this.uniforms.dashOffset.value},set:function set(value){this.uniforms.dashOffset.value=value}},gapSize:{enumerable:!0,get:function get(){return this.uniforms.gapSize.value},set:function set(value){this.uniforms.gapSize.value=value}},opacity:{enumerable:!0,get:function get(){return this.uniforms.opacity.value},set:function set(value){this.uniforms.opacity.value=value}},resolution:{enumerable:!0,get:function get(){return this.uniforms.resolution.value},set:function set(value){this.uniforms.resolution.value.copy(value)}},alphaToCoverage:{enumerable:!0,get:function get(){return!!("ALPHA_TO_COVERAGE"in this.defines)},set:function set(value){!!value!==!!("ALPHA_TO_COVERAGE"in this.defines)&&(this.needsUpdate=!0),!0===value?(this.defines.ALPHA_TO_COVERAGE="",this.extensions.derivatives=!0):(delete this.defines.ALPHA_TO_COVERAGE,this.extensions.derivatives=!1)}}}),this.setValues(parameters)}}LineMaterial.prototype.isLineMaterial=!0;

/***/ }),
/* 50 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4);/**
 * This provide a full scale minimap. It will always
 * display the whole map.
 * 
 * @class
 * @author Alan Wu
 * @return {Minimap}
 */exports.Minimap=function(sceneIn){var targetScene=sceneIn;this.camera=new THREE.OrthographicCamera(-.5,.5,.5,-.5,.01,10),this.helper=void 0;var geometry=new THREE.BufferGeometry,vertices=new Float32Array([-1,-1,1,1,-1,1,1,1,1,1,1,1,-1,1,1,-1,-1,1]),positionAttributes=new THREE.BufferAttribute(vertices,3);geometry.setAttribute("position",positionAttributes);var material=new THREE.MeshBasicMaterial({color:3355443,depthTest:!1,depthWrite:!1,opacity:.5,transparent:!0});this.mask=new THREE.Mesh(geometry,material);var _box=new THREE.Box3,_center=new THREE.Vector3;this.getDiffFromNormalised=(x,y)=>{_box.setFromBufferAttribute(positionAttributes).getCenter(_center);var coord=_center.clone().project(this.camera),new_coord=new THREE.Vector3(x,y,coord.z).unproject(this.camera);return new_coord.sub(_center)};var setCurrentCameraSettings=(diameter,newViewport)=>{targetScene.camera.near&&(this.camera.near=targetScene.camera.near),newViewport.farPlane&&(this.camera.far=newViewport.farPlane),newViewport.eyePosition&&this.camera.position.set(newViewport.eyePosition[0],newViewport.eyePosition[1],newViewport.eyePosition[2]),newViewport.upVector&&this.camera.up.set(newViewport.upVector[0],newViewport.upVector[1],newViewport.upVector[2]),newViewport.targetPosition&&this.camera.lookAt(new THREE.Vector3(newViewport.targetPosition[0],newViewport.targetPosition[1],newViewport.targetPosition[2])),this.camera.zoom=1/diameter,this.camera.updateProjectionMatrix()};this.getBoundary=()=>{var target=new THREE.Vector3().copy(targetScene.camera.target).project(targetScene.camera),v1=new THREE.Vector3(-1,-1,target.z).unproject(targetScene.camera),v2=new THREE.Vector3(1,-1,target.z).unproject(targetScene.camera),v3=new THREE.Vector3(1,1,target.z).unproject(targetScene.camera),v4=new THREE.Vector3(-1,1,target.z).unproject(targetScene.camera);positionAttributes.copyVector3sArray([v1,v2,v3,v3,v4,v1]),positionAttributes.needsUpdate=!0},this.updateCamera=()=>{this.getBoundary();var cameraControl=targetScene.getZincCameraControls(),boundingBox=targetScene.getBoundingBox();if(boundingBox){// enlarge radius to keep image within edge of window
var diameter=boundingBox.min.distanceTo(boundingBox.max),radius=diameter/2,centreX=(boundingBox.min.x+boundingBox.max.x)/2,centreY=(boundingBox.min.y+boundingBox.max.y)/2,centreZ=(boundingBox.min.z+boundingBox.max.z)/2,viewport=cameraControl.getViewportFromCentreAndRadius(centreX,centreY,centreZ,radius,40,radius*4);setCurrentCameraSettings(diameter,viewport)}}};

/***/ }),
/* 51 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),ThreeBSP=__webpack_require__(52)(THREE),Geometry=(__webpack_require__(3).Geometry),work=__webpack_require__(53),Promise=(__webpack_require__(54)["default"]),JSONLoader=THREE.BufferGeometryLoader,GeometryCSG=function(hostIn){//ZincGeoemtry of the main geometry
var host;hostIn&&hostIn.isGeometry&&(host=hostIn);var core=void 0,worker=void 0,onProgress=!1,myResolve=void 0,createGeometryFromJSON=json=>{var material=host.getMorph().material.clone();material.morphTargets=!1;var newGeometry=new Geometry,JSONParser=new JSONLoader,geometry=JSONParser.parse(json),mesh=new THREE.Mesh(geometry.geometry,material);return newGeometry.geometry=mesh.geometry,mesh.userData=newGeometry,newGeometry.setMorph(mesh),newGeometry},workerEventHandler=ev=>{switch(ev.data.action){case"message":console.log(ev.data.message);break;case"result":var csg=new GeometryCSG(createGeometryFromJSON(ev.data.object));myResolve&&myResolve(csg),myResolve=void 0,onProgress=!1;break;default:throw"Cannot handle specified action."}},initialise=hostIn=>{if(void 0!==work&&(worker=work(/*require.resolve*/(55))),!worker)core=new((__webpack_require__(56).GeometryCSGInternal))(hostIn);else if(hostIn&&hostIn.isGeometry){var mesh=hostIn.getMorph(),json=mesh.geometry.clone().applyMatrix(mesh.matrix).toJSON();worker.addEventListener("message",function(ev){workerEventHandler(ev)}),worker.postMessage({action:"initialise",object:json})}};this.getHostGeometry=()=>{var tempCSG=new ThreeBSP(host.getMorph());return new createZincGeometry(tempCSG)},this.getGeometry=()=>host;var createZincGeometry=csgMesh=>{var material=host.getMorph().material.clone();material.morphTargets=!1;var newMesh=csgMesh.toMesh(material),newGeometry=new Geometry;return newGeometry.geometry=newMesh.geometry,newMesh.userData=newGeometry,newGeometry.setMorph(newMesh),newGeometry};this.setCSG=CSG=>{core.setCSG(CSG)};var sendToWork=(guestGeometry,action,resolve,reject)=>{if(!onProgress){var mesh=guestGeometry.getMorph(),json=mesh.geometry.clone().applyMatrix(mesh.matrix).toJSON();myResolve=resolve,onProgress=!0,worker.postMessage({action:action,object:json})}else reject("On progress")};this.intersect=guestGeometry=>new Promise((resolve,reject)=>{if(worker)sendToWork(guestGeometry,"intersect",resolve,reject);else{var result=core.intersect(guestGeometry),newCSG=new GeometryCSG(createZincGeometry(result));newCSG.setCSG(result),resolve(newCSG)}}),this.subtract=guestGeometry=>new Promise((resolve,reject)=>{if(worker)sendToWork(guestGeometry,"intersect",resolve,reject);else{var result=core.subtract(guestGeometry),newCSG=new GeometryCSG(createZincGeometry(result));newCSG.setCSG(result),resolve(newCSG)}}),this.union=guestGeometry=>new Promise((resolve,reject)=>{if(worker)sendToWork(guestGeometry,"intersect",resolve,reject);else{var result=core.union(guestGeometry),newCSG=new GeometryCSG(createZincGeometry(result));newCSG.setCSG(result),resolve(newCSG)}}),this.terminateWorker=()=>{worker&&worker.terminate()},initialise(hostIn)};//const work = undefined;
exports.GeometryCSG=GeometryCSG;

/***/ }),
/* 52 */
/***/ ((module) => {

"use strict";
var ThreeBSP,EPSILON=1e-5,COPLANAR=0,FRONT=1,BACK=2,SPANNING=3;module.exports=function(THREE){var ThreeBSP=function(geometry){// Convert THREE.Geometry to ThreeBSP
var i,_length_i,face,vertex,faceVertexUvs,uvs,polygon,polygons=[];if(geometry.isBufferGeometry&&(geometry=new THREE.Geometry().fromBufferGeometry(geometry)),geometry instanceof THREE.Geometry)this.matrix=new THREE.Matrix4;else if(geometry.isMesh)geometry.updateMatrix(),this.matrix=geometry.matrix.clone(),geometry=geometry.geometry,geometry.isBufferGeometry&&(geometry=new THREE.Geometry().fromBufferGeometry(geometry)),geometry.mergeVertices(),geometry.computeVertexNormals(!1);else{if(geometry instanceof ThreeBSP.Node)return this.tree=geometry,this.matrix=new THREE.Matrix4,this;throw"ThreeBSP: Given geometry is unsupported"}for(i=0,_length_i=geometry.faces.length;i<_length_i;i++){if(face=geometry.faces[i],faceVertexUvs=geometry.faceVertexUvs[0][i],polygon=new ThreeBSP.Polygon,face instanceof THREE.Face3)vertex=geometry.vertices[face.a],uvs=faceVertexUvs?new THREE.Vector2(faceVertexUvs[0].x,faceVertexUvs[0].y):null,vertex=new ThreeBSP.Vertex(vertex.x,vertex.y,vertex.z,face.vertexNormals[0],uvs),vertex.applyMatrix4(this.matrix),polygon.vertices.push(vertex),vertex=geometry.vertices[face.b],uvs=faceVertexUvs?new THREE.Vector2(faceVertexUvs[1].x,faceVertexUvs[1].y):null,vertex=new ThreeBSP.Vertex(vertex.x,vertex.y,vertex.z,face.vertexNormals[2],uvs),vertex.applyMatrix4(this.matrix),polygon.vertices.push(vertex),vertex=geometry.vertices[face.c],uvs=faceVertexUvs?new THREE.Vector2(faceVertexUvs[2].x,faceVertexUvs[2].y):null,vertex=new ThreeBSP.Vertex(vertex.x,vertex.y,vertex.z,face.vertexNormals[2],uvs),vertex.applyMatrix4(this.matrix),polygon.vertices.push(vertex);else if(typeof THREE.Face4)vertex=geometry.vertices[face.a],uvs=faceVertexUvs?new THREE.Vector2(faceVertexUvs[0].x,faceVertexUvs[0].y):null,vertex=new ThreeBSP.Vertex(vertex.x,vertex.y,vertex.z,face.vertexNormals[0],uvs),vertex.applyMatrix4(this.matrix),polygon.vertices.push(vertex),vertex=geometry.vertices[face.b],uvs=faceVertexUvs?new THREE.Vector2(faceVertexUvs[1].x,faceVertexUvs[1].y):null,vertex=new ThreeBSP.Vertex(vertex.x,vertex.y,vertex.z,face.vertexNormals[1],uvs),vertex.applyMatrix4(this.matrix),polygon.vertices.push(vertex),vertex=geometry.vertices[face.c],uvs=faceVertexUvs?new THREE.Vector2(faceVertexUvs[2].x,faceVertexUvs[2].y):null,vertex=new ThreeBSP.Vertex(vertex.x,vertex.y,vertex.z,face.vertexNormals[2],uvs),vertex.applyMatrix4(this.matrix),polygon.vertices.push(vertex),vertex=geometry.vertices[face.d],uvs=faceVertexUvs?new THREE.Vector2(faceVertexUvs[3].x,faceVertexUvs[3].y):null,vertex=new ThreeBSP.Vertex(vertex.x,vertex.y,vertex.z,face.vertexNormals[3],uvs),vertex.applyMatrix4(this.matrix),polygon.vertices.push(vertex);else throw"Invalid face type at index "+i;polygon.calculateProperties(),polygons.push(polygon)}this.tree=new ThreeBSP.Node(polygons)};return ThreeBSP.prototype.subtract=function(other_tree){var a=this.tree.clone(),b=other_tree.tree.clone();return a.invert(),a.clipTo(b),b.clipTo(a),b.invert(),b.clipTo(a),b.invert(),a.build(b.allPolygons()),a.invert(),a=new ThreeBSP(a),a.matrix=this.matrix,a},ThreeBSP.prototype.union=function(other_tree){var a=this.tree.clone(),b=other_tree.tree.clone();return a.clipTo(b),b.clipTo(a),b.invert(),b.clipTo(a),b.invert(),a.build(b.allPolygons()),a=new ThreeBSP(a),a.matrix=this.matrix,a},ThreeBSP.prototype.intersect=function(other_tree){var a=this.tree.clone(),b=other_tree.tree.clone();return a.invert(),b.clipTo(a),b.invert(),a.clipTo(b),b.clipTo(a),a.build(b.allPolygons()),a.invert(),a=new ThreeBSP(a),a.matrix=this.matrix,a},ThreeBSP.prototype.toGeometry=function(){var i,j,polygon,polygon_vertice_count,vertex_idx_a,vertex_idx_b,vertex_idx_c,vertex,face,verticeUvs,matrix=new THREE.Matrix4().getInverse(this.matrix),geometry=new THREE.Geometry,polygons=this.tree.allPolygons(),polygon_count=polygons.length,vertice_dict={};for(i=0;i<polygon_count;i++)for(polygon=polygons[i],polygon_vertice_count=polygon.vertices.length,j=2;j<polygon_vertice_count;j++)verticeUvs=[],vertex=polygon.vertices[0],verticeUvs.push(new THREE.Vector2(vertex.uv.x,vertex.uv.y)),vertex=new THREE.Vector3(vertex.x,vertex.y,vertex.z),vertex.applyMatrix4(matrix),"undefined"==typeof vertice_dict[vertex.x+","+vertex.y+","+vertex.z]?(geometry.vertices.push(vertex),vertex_idx_a=vertice_dict[vertex.x+","+vertex.y+","+vertex.z]=geometry.vertices.length-1):vertex_idx_a=vertice_dict[vertex.x+","+vertex.y+","+vertex.z],vertex=polygon.vertices[j-1],verticeUvs.push(new THREE.Vector2(vertex.uv.x,vertex.uv.y)),vertex=new THREE.Vector3(vertex.x,vertex.y,vertex.z),vertex.applyMatrix4(matrix),"undefined"==typeof vertice_dict[vertex.x+","+vertex.y+","+vertex.z]?(geometry.vertices.push(vertex),vertex_idx_b=vertice_dict[vertex.x+","+vertex.y+","+vertex.z]=geometry.vertices.length-1):vertex_idx_b=vertice_dict[vertex.x+","+vertex.y+","+vertex.z],vertex=polygon.vertices[j],verticeUvs.push(new THREE.Vector2(vertex.uv.x,vertex.uv.y)),vertex=new THREE.Vector3(vertex.x,vertex.y,vertex.z),vertex.applyMatrix4(matrix),"undefined"==typeof vertice_dict[vertex.x+","+vertex.y+","+vertex.z]?(geometry.vertices.push(vertex),vertex_idx_c=vertice_dict[vertex.x+","+vertex.y+","+vertex.z]=geometry.vertices.length-1):vertex_idx_c=vertice_dict[vertex.x+","+vertex.y+","+vertex.z],face=new THREE.Face3(vertex_idx_a,vertex_idx_b,vertex_idx_c,new THREE.Vector3(polygon.normal.x,polygon.normal.y,polygon.normal.z)),geometry.faces.push(face),geometry.faceVertexUvs[0].push(verticeUvs);return geometry},ThreeBSP.prototype.toBufferGeometry=function(){var geometry=this.toGeometry(),bufferGeometry=new THREE.BufferGeometry().fromGeometry(geometry);return bufferGeometry},ThreeBSP.prototype.toMesh=function(material){var geometry=this.toBufferGeometry(),mesh=new THREE.Mesh(geometry,material);return mesh.position.setFromMatrixPosition(this.matrix),mesh.rotation.setFromRotationMatrix(this.matrix),mesh},ThreeBSP.Polygon=function(vertices){vertices instanceof Array||(vertices=[]),this.vertices=vertices,0<vertices.length?this.calculateProperties():this.normal=this.w=void 0},ThreeBSP.Polygon.prototype.calculateProperties=function(){var a=this.vertices[0],b=this.vertices[1],c=this.vertices[2];return this.normal=b.clone().subtract(a).cross(c.clone().subtract(a)).normalize(),this.w=this.normal.clone().dot(a),this},ThreeBSP.Polygon.prototype.clone=function(){var i,vertice_count,polygon=new ThreeBSP.Polygon;for(i=0,vertice_count=this.vertices.length;i<vertice_count;i++)polygon.vertices.push(this.vertices[i].clone());return polygon.calculateProperties(),polygon},ThreeBSP.Polygon.prototype.flip=function(){var i,vertices=[];for(this.normal.multiplyScalar(-1),this.w*=-1,i=this.vertices.length-1;0<=i;i--)vertices.push(this.vertices[i]);return this.vertices=vertices,this},ThreeBSP.Polygon.prototype.classifyVertex=function(vertex){var side_value=this.normal.dot(vertex)-this.w;return side_value<-EPSILON?BACK:side_value>EPSILON?FRONT:COPLANAR},ThreeBSP.Polygon.prototype.classifySide=function(polygon){var i,vertex,classification,num_positive=0,num_negative=0,vertice_count=polygon.vertices.length;for(i=0;i<vertice_count;i++)vertex=polygon.vertices[i],classification=this.classifyVertex(vertex),classification===FRONT?num_positive++:classification===BACK&&num_negative++;return 0<num_positive&&0===num_negative?FRONT:0===num_positive&&0<num_negative?BACK:0===num_positive&&0===num_negative?COPLANAR:SPANNING},ThreeBSP.Polygon.prototype.splitPolygon=function(polygon,coplanar_front,coplanar_back,front,back){var classification=this.classifySide(polygon);if(classification===COPLANAR)(0<this.normal.dot(polygon.normal)?coplanar_front:coplanar_back).push(polygon);else if(classification===FRONT)front.push(polygon);else if(classification===BACK)back.push(polygon);else{var vertice_count,i,j,ti,tj,vi,vj,t,v,f=[],b=[];for(i=0,vertice_count=polygon.vertices.length;i<vertice_count;i++)j=(i+1)%vertice_count,vi=polygon.vertices[i],vj=polygon.vertices[j],ti=this.classifyVertex(vi),tj=this.classifyVertex(vj),ti!=BACK&&f.push(vi),ti!=FRONT&&b.push(vi),(ti|tj)==SPANNING&&(t=(this.w-this.normal.dot(vi))/this.normal.dot(vj.clone().subtract(vi)),v=vi.interpolate(vj,t),f.push(v),b.push(v));3<=f.length&&front.push(new ThreeBSP.Polygon(f).calculateProperties()),3<=b.length&&back.push(new ThreeBSP.Polygon(b).calculateProperties())}},ThreeBSP.Vertex=function(x,y,z,normal,uv){this.x=x,this.y=y,this.z=z,this.normal=normal||new THREE.Vector3,this.uv=uv||new THREE.Vector2},ThreeBSP.Vertex.prototype.clone=function(){return new ThreeBSP.Vertex(this.x,this.y,this.z,this.normal.clone(),this.uv.clone())},ThreeBSP.Vertex.prototype.add=function(vertex){return this.x+=vertex.x,this.y+=vertex.y,this.z+=vertex.z,this},ThreeBSP.Vertex.prototype.subtract=function(vertex){return this.x-=vertex.x,this.y-=vertex.y,this.z-=vertex.z,this},ThreeBSP.Vertex.prototype.multiplyScalar=function(scalar){return this.x*=scalar,this.y*=scalar,this.z*=scalar,this},ThreeBSP.Vertex.prototype.cross=function(vertex){var x=this.x,y=this.y,z=this.z;return this.x=y*vertex.z-z*vertex.y,this.y=z*vertex.x-x*vertex.z,this.z=x*vertex.y-y*vertex.x,this},ThreeBSP.Vertex.prototype.normalize=function(){var length=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z);return this.x/=length,this.y/=length,this.z/=length,this},ThreeBSP.Vertex.prototype.dot=function(vertex){return this.x*vertex.x+this.y*vertex.y+this.z*vertex.z},ThreeBSP.Vertex.prototype.lerp=function(a,t){return this.add(a.clone().subtract(this).multiplyScalar(t)),this.normal.add(a.normal.clone().sub(this.normal).multiplyScalar(t)),this.uv.add(a.uv.clone().sub(this.uv).multiplyScalar(t)),this},ThreeBSP.Vertex.prototype.interpolate=function(other,t){return this.clone().lerp(other,t)},ThreeBSP.Vertex.prototype.applyMatrix4=function(m){// input: THREE.Matrix4 affine matrix
var x=this.x,y=this.y,z=this.z,e=m.elements;return this.x=e[0]*x+e[4]*y+e[8]*z+e[12],this.y=e[1]*x+e[5]*y+e[9]*z+e[13],this.z=e[2]*x+e[6]*y+e[10]*z+e[14],this},ThreeBSP.Node=function(polygons){var i,polygon_count,front=[],back=[];if(this.polygons=[],this.front=this.back=void 0,polygons instanceof Array&&0!==polygons.length){for(this.divider=polygons[0].clone(),i=0,polygon_count=polygons.length;i<polygon_count;i++)this.divider.splitPolygon(polygons[i],this.polygons,this.polygons,front,back);0<front.length&&(this.front=new ThreeBSP.Node(front)),0<back.length&&(this.back=new ThreeBSP.Node(back))}},ThreeBSP.Node.isConvex=function(polygons){var i,j;for(i=0;i<polygons.length;i++)for(j=0;j<polygons.length;j++)if(i!==j&&polygons[i].classifySide(polygons[j])!==BACK)return!1;return!0},ThreeBSP.Node.prototype.build=function(polygons){var i,polygon_count,front=[],back=[];for(this.divider||(this.divider=polygons[0].clone()),i=0,polygon_count=polygons.length;i<polygon_count;i++)this.divider.splitPolygon(polygons[i],this.polygons,this.polygons,front,back);0<front.length&&(!this.front&&(this.front=new ThreeBSP.Node),this.front.build(front)),0<back.length&&(!this.back&&(this.back=new ThreeBSP.Node),this.back.build(back))},ThreeBSP.Node.prototype.allPolygons=function(){var polygons=this.polygons.slice();return this.front&&(polygons=polygons.concat(this.front.allPolygons())),this.back&&(polygons=polygons.concat(this.back.allPolygons())),polygons},ThreeBSP.Node.prototype.clone=function(){var node=new ThreeBSP.Node;return node.divider=this.divider.clone(),node.polygons=this.polygons.map(function(polygon){return polygon.clone()}),node.front=this.front&&this.front.clone(),node.back=this.back&&this.back.clone(),node},ThreeBSP.Node.prototype.invert=function(){var i,polygon_count,temp;for(i=0,polygon_count=this.polygons.length;i<polygon_count;i++)this.polygons[i].flip();return this.divider.flip(),this.front&&this.front.invert(),this.back&&this.back.invert(),temp=this.front,this.front=this.back,this.back=temp,this},ThreeBSP.Node.prototype.clipPolygons=function(polygons){var i,polygon_count,front,back;if(!this.divider)return polygons.slice();for(front=[],back=[],(i=0,polygon_count=polygons.length);i<polygon_count;i++)this.divider.splitPolygon(polygons[i],front,back,front,back);return this.front&&(front=this.front.clipPolygons(front)),back=this.back?this.back.clipPolygons(back):[],front.concat(back)},ThreeBSP.Node.prototype.clipTo=function(node){this.polygons=node.clipPolygons(this.polygons),this.front&&this.front.clipTo(node),this.back&&this.back.clipTo(node)},ThreeBSP};

/***/ }),
/* 53 */
/***/ ((module) => {

"use strict";
module.exports = require("webworkify-webpack");

/***/ }),
/* 54 */
/***/ ((module) => {

"use strict";
module.exports = require("promise-polyfill");

/***/ }),
/* 55 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Geometry=(__webpack_require__(3).Geometry),THREE=__webpack_require__(4),JSONLoader=THREE.BufferGeometryLoader;module.exports=function(self){var core=void 0,geometryFromJSON=function geometryFromJSON(object){var JSONParser=new JSONLoader,geometry=JSONParser.parse(object),material=new THREE.MeshPhongMaterial,mesh=new THREE.Mesh(geometry.geometry,material),host=new Geometry;return host.setMorph(mesh),host},initialise=function initialise(object){var host=geometryFromJSON(object);core=new((__webpack_require__(56).GeometryCSGInternal))(host),self.postMessage({action:"message",message:"Initialised"})},intersect=function intersect(object){if(core){var guest=geometryFromJSON(object),result=core.intersect(guest),json=result.toBufferGeometry().toJSON();self.postMessage({action:"result",object:json})}},subtract=function subtract(object){if(core){var guest=geometryFromJSON(object),result=core.subtract(guest),json=result.toBufferGeometry().toJSON();self.postMessage({action:"result",object:json})}},union=function union(object){if(core){var guest=geometryFromJSON(object),result=core.union(guest),json=result.toBufferGeometry().toJSON();self.postMessage({action:"result",object:json})}};self.addEventListener("message",function(ev){switch(ev.data.action){case"initialise":initialise(ev.data.object);break;case"intersect":intersect(ev.data.object);break;case"subtract":subtract(ev.data.object);break;case"union":union(ev.data.object);break;default:throw"Cannot handle specified action."}})};

/***/ }),
/* 56 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),ThreeBSP=__webpack_require__(52)(THREE),Geometry=(__webpack_require__(3).Geometry),GeometryCSG=(__webpack_require__(51).GeometryCSG),GeometryCSGInternal=function(hostIn){//ZincGeoemtry of the main geometry
var host;hostIn&&hostIn.isGeometry&&(host=hostIn);var hostCSG;this.setGeometry=hostIn=>{hostIn&&hostIn.isGeometry&&(host=hostIn),hostCSG=void 0},this.setCSG=csg=>{hostCSG=csg};var prepareCSG=guestGeometry=>{if(host&&host.morph&&guestGeometry&&guestGeometry.morph){hostCSG===void 0&&(hostCSG=new ThreeBSP(host.morph));var guestCSG=new ThreeBSP(guestGeometry.morph);return guestCSG}};this.intersect=guestGeometry=>{var guestCSG=prepareCSG(guestGeometry);return hostCSG&&guestCSG?hostCSG.intersect(guestCSG):void 0},this.subtract=guestGeometry=>{var guestCSG=prepareCSG(guestGeometry);return hostCSG&&guestCSG?hostCSG.subtract(guestCSG):void 0},this.union=guestGeometry=>{var guestCSG=prepareCSG(guestGeometry);return hostCSG&&guestCSG?hostCSG.union(guestCSG):void 0}};exports.GeometryCSGInternal=GeometryCSGInternal;

/***/ }),
/* 57 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var THREE=__webpack_require__(4),ThreeBSP=__webpack_require__(52)(THREE),Glyphset=(__webpack_require__(18).Glyphset),GlyphsetCSG=function(hostIn){var host;hostIn&&hostIn.isGlyphset&&(host=hostIn);var hostCSGs=[];this.setGlyphset=hostIn=>{hostIn&&hostIn.isGlyphset&&(host=hostIn),hostCSG=void 0},this.getGlyphset=()=>host;var prepareCSGForGlyphs=()=>glyph=>{var mesh=glyph.getMesh(),label=glyph.getLabel();if(mesh){var csg=new ThreeBSP(mesh.geometry.clone().applyMatrix(mesh.matrix)),store=[];store.csg=csg,store.label=label,mesh.material&&(store.material=mesh.material.clone()),hostCSGs.push(store)}},prepareCSG=guestGeometry=>{if(host&&guestGeometry&&guestGeometry.getMorph()){0==hostCSGs.length&&host.forEachGlyph(prepareCSGForGlyphs());var guestCSG=new ThreeBSP(guestGeometry.getMorph());return guestCSG}};this.intersect=guestGeometry=>{var guestCSG=prepareCSG(guestGeometry);if(0<hostCSGs.length&&guestCSG){for(var glyphset=new((__webpack_require__(18).Glyphset)),i=0;i<hostCSGs.length;i++){var _hostCSG=hostCSGs[i],intersect=_hostCSG.csg.intersect(guestCSG),mesh=intersect.toMesh();if(mesh&&mesh.geometry&&0<mesh.geometry.vertices.length){_hostCSG.material&&(mesh.material=_hostCSG.material,mesh.material.side=THREE.DoubleSide,mesh.material.clippingPlanes=null);var glyph=glyphset.addMeshAsGlyph(mesh,i+1);glyph.setLabel(_hostCSG.label)}}var newCSG=new GlyphsetCSG(glyphset);return newCSG}}};/**
 * Provides an object which takes in a glyphset, convert it into a CSG and further
 * action such as intersect with another geometry may be performed.
 * 
 * @class
 * @author Alan Wu
 * @return {GlyphsetCSG}
 */exports.GlyphsetCSG=GlyphsetCSG;

/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__(0);
/******/ 	
/******/ 	return __webpack_exports__;
/******/ })()
;
});
//# sourceMappingURL=zinc.js.map