"use strict";
exports.__esModule = true;
var constants_1 = require("../../util/constants");
function registerReadyCallback(compiler, cb) {
    compiler.hooks.failed.tap(constants_1.MOCHAPACK_NAME, function (error) { return cb(error, null); });
    compiler.hooks.done.tap(constants_1.MOCHAPACK_NAME, function (stats) {
        if (stats.hasErrors()) {
            var jsonStats = stats.toJson();
            var err = jsonStats.errors[0];
            cb(err, stats);
        }
        else {
            cb(null, stats);
        }
    });
}
exports["default"] = registerReadyCallback;
//# sourceMappingURL=registerReadyCallback.js.map