/// <reference types="node" />
import EventEmitter from 'events';
import { Configuration as WebpackConfig, Stats } from 'webpack';
import Mocha from 'mocha';
import { MochapackOptions } from '../cli/argsParser/optionsFromParsedArgs/types';
export default class TestRunner extends EventEmitter {
    entries: Array<string>;
    includes: Array<string>;
    options: MochapackOptions;
    cwd: string;
    constructor(entries: Array<string>, includes: Array<string>, options: MochapackOptions, cwd: string);
    prepareMocha(webpackConfig: WebpackConfig, stats: Stats): Mocha;
    run(): Promise<number>;
    watch(): Promise<void>;
    private createWebpackConfig;
}
