"use strict";
exports.__esModule = true;
exports.mochapackDefaults = void 0;
var MOCHAPACK_GROUP = 'Mochapack:';
exports.mochapackDefaults = {
    interactive: !!process.stdout.isTTY,
    'clear-terminal': false
};
var mochapackOptions = {
    quiet: {
        alias: 'q',
        type: 'boolean',
        describe: 'Suppress informational messages',
        group: MOCHAPACK_GROUP
    },
    interactive: {
        type: 'boolean',
        "default": exports.mochapackDefaults.interactive,
        describe: 'Force interactive mode (default enabled in terminal)',
        group: MOCHAPACK_GROUP
    },
    'clear-terminal': {
        type: 'boolean',
        "default": exports.mochapackDefaults['clear-terminal'],
        describe: 'Clear current terminal, purging its history',
        group: MOCHAPACK_GROUP
    },
    glob: {
        type: 'string',
        describe: 'Test files matching <pattern> (only valid for directory entry)',
        group: MOCHAPACK_GROUP,
        requiresArg: true
    }
};
exports["default"] = mochapackOptions;
//# sourceMappingURL=mochapackOptions.js.map