"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var path_1 = __importDefault(require("path"));
var sortChunks_1 = __importDefault(require("./sortChunks"));
var getAffectedModuleIds_1 = __importDefault(require("./getAffectedModuleIds"));
function getBuildStats(stats, outputPath) {
    var _a = stats.compilation, chunks = _a.chunks, chunkGraph = _a.chunkGraph, chunkGroups = _a.chunkGroups, modules = _a.modules, moduleGraph = _a.moduleGraph, builtModules = _a.builtModules;
    var sortedChunks = sortChunks_1["default"](chunks, chunkGroups);
    var affectedModules = getAffectedModuleIds_1["default"](chunks, chunkGraph, modules, moduleGraph, builtModules);
    var entries = [];
    var js = [];
    var pathHelper = function (f) { return path_1["default"].join(outputPath, f); };
    sortedChunks.forEach(function (chunk) {
        var files = Array.from(chunk.files);
        if (chunk.isOnlyInitial()) {
            // only entry files
            var entry = files[0];
            entries.push(entry);
        }
        if (chunkGraph
            .getChunkModules(chunk)
            .some(function (module) { return affectedModules.indexOf(chunkGraph.getModuleId(module)) !== -1; })) {
            files.forEach(function (file) {
                if (/\.js$/.test(file)) {
                    js.push(file);
                }
            });
        }
    });
    var buildStats = {
        affectedModules: affectedModules,
        affectedFiles: js.map(pathHelper),
        entries: entries.map(pathHelper)
    };
    return buildStats;
}
exports["default"] = getBuildStats;
//# sourceMappingURL=getBuildStats.js.map