import Chunk from 'webpack/lib/Chunk';
import ChunkGraph from 'webpack/lib/ChunkGraph';
import Module from 'webpack/lib/Module';
import ModuleGraph from 'webpack/lib/ModuleGraph';
/**
 * Builds a list with ids of all affected modules in the following way:
 *  - affected directly by a file change
 *  - affected indirectly by a change of it's dependencies and so on
 *
 * @param chunks Set<Chunk>
 * @param modules Set<Module>
 * @return {Array.<number>}
 */
export default function getAffectedModuleIds(chunks: Set<Chunk>, chunkGraph: ChunkGraph, modules: Set<Module>, moduleGraph: ModuleGraph, webpackBuiltModules?: WeakSet<Module>): Array<number | string>;
