import { Compiler } from 'webpack';
export declare type SourceMap = {
    sources: Array<any>;
    version: number;
    mappings: any;
    sourcesContent: any;
};
/**
 * webpack/lib/Module.js
 */
export declare type Module = {
    id: number;
    rawRequest: string;
    built: boolean;
    dependencies: Array<{
        module: Module;
    }>;
    readableIdentifier: any | null;
    chunks: Array<Chunk>;
    getChunks: () => Array<Chunk>;
    blocks: Array<DependenciesBlock>;
};
/**
 * Webpack build error or warning
 */
export declare type WebpackError = Error & {
    message: string;
    file?: string | null;
    module?: Module | null;
};
/**
 * webpack/lib/Chunk.js
 */
export declare type Chunk = {
    id: number | string;
    modules: Array<Module>;
    chunks: Array<Chunk>;
    parents: Array<Chunk>;
    files: Array<string>;
    isOnlyInitial: () => boolean;
    getModules: () => Array<Module>;
};
/**
 * webpack/lib/ChunkGroup.js
 */
export declare type ChunkGroup = {
    chunks: Array<Chunk>;
};
/**
 * webpack/lib/DependenciesBlock.js
 * webpack/lib/AsyncDependenciesBlock.js
 */
export declare type DependenciesBlock = {
    chunkGroup?: ChunkGroup;
};
/**
 * webpack/lib/Compilation.js
 */
export declare type Compilation = {
    compiler: Compiler;
    plugin: (hook: string, fn: () => void) => void;
    modules: Module[];
    chunks: Chunk[];
    chunkGroups: ChunkGroup[];
    errors: Array<string | WebpackError>;
    warnings: Array<string | WebpackError>;
    assets: {
        [key: string]: {
            size: () => number;
            source: () => string;
            map: () => SourceMap;
        };
    };
};
