"use strict";
/*  eslint-disable no-underscore-dangle */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
// see https://github.com/nodejs/node/blob/master/lib/module.js
var module_1 = __importDefault(require("module"));
// the module in which the require() call originated
var requireCaller;
// all custom registered resolvers
var pathResolvers = [];
// keep original Module._resolveFilename
// @ts-ignore
var originalResolveFilename = module_1["default"]._resolveFilename;
// override Module._resolveFilename
// @ts-ignore
module_1["default"]._resolveFilename = function _resolveFilename() {
    var parameters = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        parameters[_i] = arguments[_i];
    }
    var parent = parameters[1];
    // store require() caller (the module in which this require() call originated)
    requireCaller = parent;
    return originalResolveFilename.apply(this, parameters);
};
// keep original Module._findPath
// @ts-ignore
var originalFindPath = module_1["default"]._findPath;
// override Module._findPath
// @ts-ignore
module_1["default"]._findPath = function _findPath() {
    var parameters = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        parameters[_i] = arguments[_i];
    }
    var request = parameters[0];
    // try to resolve the path with custom resolvers
    for (var _a = 0, pathResolvers_1 = pathResolvers; _a < pathResolvers_1.length; _a++) {
        var resolve = pathResolvers_1[_a];
        var resolved = resolve(request, requireCaller);
        if (typeof resolved !== 'undefined') {
            return resolved;
        }
    }
    // and when none found try to resolve path with original resolver
    var filename = originalFindPath.apply(this, parameters);
    if (filename !== false) {
        return filename;
    }
    return false;
};
function registerRequireHook(dotExt, resolve) {
    // cache source code after resolving to avoid another access to the fs
    var sourceCache = {};
    // store all files that were affected by this hook
    var affectedFiles = {};
    var resolvePath = function (path, parent) {
        // get CommonJS module source code for this require() call
        var _a = resolve(path, parent), resolvedPath = _a.path, source = _a.source;
        // if no CommonJS module source code returned - skip this require() hook
        if (resolvedPath == null) {
            return undefined;
        }
        // flush require() cache
        delete require.cache[resolvedPath];
        // put the CommonJS module source code into the hash
        sourceCache[resolvedPath] = source;
        // return the path to be require()d in order to get the CommonJS module source code
        return resolvedPath;
    };
    var resolveSource = function (path) {
        var source = sourceCache[path];
        delete sourceCache[path];
        return source;
    };
    pathResolvers.push(resolvePath);
    // keep original extension loader
    // @ts-ignore
    var originalLoader = module_1["default"]._extensions[dotExt];
    // override extension loader
    // @ts-ignore
    module_1["default"]._extensions[dotExt] = function (module, filename) {
        var source = resolveSource(filename);
        if (typeof source === 'undefined') {
            // load the file with the original loader
            // @ts-ignore
            ;
            (originalLoader || module_1["default"]._extensions['.js'])(module, filename);
            return;
        }
        affectedFiles[filename] = true;
        // compile javascript module from its source
        module._compile(source, filename);
    };
    return function unmout() {
        pathResolvers = pathResolvers.filter(function (r) { return r !== resolvePath; });
        // @ts-ignore
        module_1["default"]._extensions[dotExt] = originalLoader;
        Object.keys(affectedFiles).forEach(function (path) {
            delete require.cache[path];
            delete sourceCache[path];
            delete affectedFiles[path];
        });
    };
}
exports["default"] = registerRequireHook;
//# sourceMappingURL=registerRequireHook.js.map