"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var lodash_1 = require("lodash");
var mocha_1 = __importDefault(require("mocha"));
var getReporterConstructor_1 = __importDefault(require("./getReporterConstructor"));
var loadUI_1 = __importDefault(require("./loadUI"));
/**
 * Uses the options set on the instance of Mocha to set its reporter for
 *   Mochapack
 */
var setReporterInMochaOptions = function (mocha, cwd) {
    var reporter = getReporterConstructor_1["default"](mocha.options.reporter, cwd);
    mocha.reporter(reporter, mocha.options.reporterOptions);
};
/**
 * Uses the options set on the instance of Mocha to set its UI for Mochapack
 */
var setUiInMochaOptions = function (mocha, ui, cwd) {
    mocha.ui(loadUI_1["default"](ui, cwd));
};
/**
 * Adds specified files to the instance of Mocha
 */
var addFilesToMochaInstance = function (mocha, files) {
    var clonedMocha = lodash_1.cloneDeep(mocha);
    if (files) {
        files.forEach(function (file) {
            clonedMocha = clonedMocha.addFile(file);
        });
    }
    return clonedMocha;
};
/**
 * Initializes an instance of Mocha on behalf of the user with their provided
 *   options
 */
var initMocha = function (options, cwd) {
    var mochaInstance = new mocha_1["default"](options.constructor);
    mochaInstance = addFilesToMochaInstance(mochaInstance, options.cli.file);
    if (options.cli.invert)
        mochaInstance.invert();
    setReporterInMochaOptions(mochaInstance, cwd);
    setUiInMochaOptions(mochaInstance, options.constructor.ui, cwd);
    return mochaInstance;
};
exports["default"] = initMocha;
//# sourceMappingURL=index.js.map