"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var path_1 = __importDefault(require("path"));
var lodash_1 = require("lodash");
var mocha_1 = require("mocha");
var getReporterConstructor = function (reporter, cwd) {
    // If reporter is already loaded, just return it
    if (lodash_1.isFunction(reporter))
        return reporter;
    // Try to load built-in reporter like 'spec'
    if (!lodash_1.isUndefined(mocha_1.reporters[reporter]))
        return mocha_1.reporters[reporter];
    var loadedReporter = null;
    try {
        // Try to load reporter from node_modules
        // eslint-disable-next-line global-require, import/no-dynamic-require
        loadedReporter = require(reporter);
    }
    catch (e) {
        // Try to load reporter from cwd
        // eslint-disable-next-line global-require, import/no-dynamic-require
        loadedReporter = require(path_1["default"].resolve(cwd, reporter));
    }
    return loadedReporter;
};
exports["default"] = getReporterConstructor;
//# sourceMappingURL=getReporterConstructor.js.map