"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
exports.pruneMochaYargsOutput = exports.parseMochaArgs = void 0;
var lodash_1 = require("lodash");
var mocha_1 = __importDefault(require("mocha"));
var errors_1 = require("mocha/lib/errors");
var one_and_dones_1 = require("mocha/lib/cli/one-and-dones");
var run_helpers_1 = require("mocha/lib/cli/run-helpers");
var run_option_metadata_1 = require("mocha/lib/cli/run-option-metadata");
var yargs_1 = __importDefault(require("yargs"));
var mochaOptions_1 = __importDefault(require("./mochaOptions"));
// Used to establish parity with Mocha's builder function in lib/cli/run.js
var mochaChecks = function (yargsInstance, argv) {
    // "one-and-dones"; let yargs handle help and version
    Object.keys(one_and_dones_1.ONE_AND_DONES).forEach(function (opt) {
        if (argv[opt]) {
            one_and_dones_1.ONE_AND_DONES[opt].call(null, yargsInstance);
            process.exit();
        }
    });
    // yargs.implies() isn't flexible enough to handle this
    if (argv.invert && !('fgrep' in argv || 'grep' in argv)) {
        throw errors_1.createMissingArgumentError('"--invert" requires one of "--fgrep <str>" or "--grep <regexp>"', '--fgrep|--grep', 'string|regexp');
    }
    if (argv.compilers) {
        throw errors_1.createUnsupportedError("--compilers is DEPRECATED and no longer supported.\n      See https://git.io/vdcSr for migration information.");
    }
    /**
     * Commented out here to provide backward compatibility for now
     */
    /*
    if (argv.opts) {
      throw createUnsupportedError(
        `--opts: configuring Mocha via 'mocha.opts' is DEPRECATED and no longer supported.
        Please use a configuration file instead.`
      )
    }
    */
    // load requires first, because it can impact "plugin" validation
    run_helpers_1.handleRequires(argv.require);
    // necessary since mocha 8.2.0 version
    if (run_helpers_1.validatePlugin) {
        run_helpers_1.validatePlugin(argv, 'reporter', mocha_1["default"].reporters);
        run_helpers_1.validatePlugin(argv, 'ui', mocha_1["default"].interfaces);
    }
    else {
        run_helpers_1.validateLegacyPlugin(argv, 'reporter', mocha_1["default"].reporters);
        run_helpers_1.validateLegacyPlugin(argv, 'ui', mocha_1["default"].interfaces);
    }
    return true;
};
/**
 * Parses CLI arguments for Mocha using Yargs as closely as possible to how
 *   Mocha parses arguments when run from their CLI.
 *
 * This is done to keep Mocha somewhat at arm's length, and not pollute the
 *   standard Mochapack args parser with Mocha-specific options/settings
 *
 * Note that some of this correlates with the builder in Mocha's lib/cli/run.js
 *
 * @param argv Arguments provided via CLI
 */
exports.parseMochaArgs = function (argv) {
    var yargsOutput = yargs_1["default"]
        .options(mochaOptions_1["default"])
        .check(function (args) { return mochaChecks(yargs_1["default"], args); })
        .alias(run_option_metadata_1.aliases)
        .array(run_option_metadata_1.types.array)
        .boolean(run_option_metadata_1.types.boolean)
        .string(run_option_metadata_1.types.string)
        .number(run_option_metadata_1.types.number)
        .parse(argv);
    var files = yargsOutput._;
    files = files.length ? files : ['./test'];
    // Mocha checks prevent unrecognized UI from being passed along as a string
    if (yargsOutput.ui && yargsOutput.ui !== yargsOutput.u)
        yargsOutput.ui = yargsOutput.u;
    return __assign(__assign({}, yargsOutput), { files: files });
};
/**
 * Need to ensure any keys unknown to Mocha are not included in Yargs output
 */
exports.pruneMochaYargsOutput = function (yargsOutput) {
    return lodash_1.pick(yargsOutput, __spreadArrays(Object.keys(mochaOptions_1["default"]), ['files']));
};
//# sourceMappingURL=parseMochaArgs.js.map