import { MochapackOptions } from './cli/argsParser/optionsFromParsedArgs/types';
export default class Mochapack {
    private options;
    constructor(options: MochapackOptions);
    /**
     * Current working directory of Mochapack when initialized
     */
    cwd: string;
    /**
     * Files to run test against
     *
     * @private
     */
    entries: Array<string>;
    /**
     * Files to include into the bundle
     *
     * @private
     */
    includes: Array<string>;
    /**
     * Default options
     *
     * @private
     */
    defaultOptions: {
        mocha: {
            constructor: {
                bail: boolean;
                reporter: string;
                reporterOptions: {};
                ui: string;
                ignoreLeaks: boolean;
                fullStackTrace: boolean;
                inlineDiffs: boolean;
                timeout: number;
                slow: number;
                asyncOnly: boolean;
                delay: boolean;
                forbidOnly: boolean;
            };
            cli: {
                invert: boolean;
            };
        };
    };
    /**
     * Add file run test against
     *
     * @public
     * @param {string} file file or glob
     * @return {Mochapack}
     */
    addEntry(file: string): Mochapack;
    /**
     * Add file to include into the test bundle
     *
     * @public
     * @param {string} file absolute path to module
     * @return {Mochapack}
     */
    addInclude(file: string): Mochapack;
    /**
     * Builds a test runner that can be used for run or watch mode
     */
    private buildTestRunner;
    /**
     * Run tests
     *
     * @public
     * @return {Promise<number>} a Promise that gets resolved with the number of failed tests or rejected with build error
     */
    run(): Promise<number>;
    /**
     * Run tests and rerun them on changes
     * @public
     */
    watch(): Promise<void>;
}
