import { URLSearchParams } from 'url';
import * as PropertySymbol from './PropertySymbol.cjs';
import Browser from './browser/Browser.cjs';
import BrowserContext from './browser/BrowserContext.cjs';
import BrowserFrame from './browser/BrowserFrame.cjs';
import BrowserPage from './browser/BrowserPage.cjs';
import DetachedBrowser from './browser/detached-browser/DetachedBrowser.cjs';
import DetachedBrowserContext from './browser/detached-browser/DetachedBrowserContext.cjs';
import DetachedBrowserFrame from './browser/detached-browser/DetachedBrowserFrame.cjs';
import DetachedBrowserPage from './browser/detached-browser/DetachedBrowserPage.cjs';
import BrowserErrorCaptureEnum from './browser/enums/BrowserErrorCaptureEnum.cjs';
import BrowserNavigationCrossOriginPolicyEnum from './browser/enums/BrowserNavigationCrossOriginPolicyEnum.cjs';
import Clipboard from './clipboard/Clipboard.cjs';
import ClipboardItem from './clipboard/ClipboardItem.cjs';
import VirtualConsole from './console/VirtualConsole.cjs';
import VirtualConsolePrinter from './console/VirtualConsolePrinter.cjs';
import VirtualConsoleLogLevelEnum from './console/enums/VirtualConsoleLogLevelEnum.cjs';
import VirtualConsoleLogTypeEnum from './console/enums/VirtualConsoleLogTypeEnum.cjs';
import CSSRule from './css/CSSRule.cjs';
import CSSStyleSheet from './css/CSSStyleSheet.cjs';
import CSSStyleDeclaration from './css/declaration/CSSStyleDeclaration.cjs';
import CSSContainerRule from './css/rules/CSSContainerRule.cjs';
import CSSFontFaceRule from './css/rules/CSSFontFaceRule.cjs';
import CSSKeyframeRule from './css/rules/CSSKeyframeRule.cjs';
import CSSKeyframesRule from './css/rules/CSSKeyframesRule.cjs';
import CSSMediaRule from './css/rules/CSSMediaRule.cjs';
import CSSStyleRule from './css/rules/CSSStyleRule.cjs';
import CSSSupportsRule from './css/rules/CSSSupportsRule.cjs';
import CustomElementRegistry from './custom-element/CustomElementRegistry.cjs';
import DOMParser from './dom-parser/DOMParser.cjs';
import DataTransfer from './event/DataTransfer.cjs';
import DataTransferItem from './event/DataTransferItem.cjs';
import DataTransferItemList from './event/DataTransferItemList.cjs';
import Event from './event/Event.cjs';
import EventPhaseEnum from './event/EventPhaseEnum.cjs';
import EventTarget from './event/EventTarget.cjs';
import Touch from './event/Touch.cjs';
import UIEvent from './event/UIEvent.cjs';
import AnimationEvent from './event/events/AnimationEvent.cjs';
import ClipboardEvent from './event/events/ClipboardEvent.cjs';
import CustomEvent from './event/events/CustomEvent.cjs';
import ErrorEvent from './event/events/ErrorEvent.cjs';
import FocusEvent from './event/events/FocusEvent.cjs';
import HashChangeEvent from './event/events/HashChangeEvent.cjs';
import InputEvent from './event/events/InputEvent.cjs';
import KeyboardEvent from './event/events/KeyboardEvent.cjs';
import MediaQueryListEvent from './event/events/MediaQueryListEvent.cjs';
import MouseEvent from './event/events/MouseEvent.cjs';
import PointerEvent from './event/events/PointerEvent.cjs';
import ProgressEvent from './event/events/ProgressEvent.cjs';
import SubmitEvent from './event/events/SubmitEvent.cjs';
import TouchEvent from './event/events/TouchEvent.cjs';
import WheelEvent from './event/events/WheelEvent.cjs';
import DOMException from './exception/DOMException.cjs';
import AbortController from './fetch/AbortController.cjs';
import AbortSignal from './fetch/AbortSignal.cjs';
import Headers from './fetch/Headers.cjs';
import Request from './fetch/Request.cjs';
import Response from './fetch/Response.cjs';
import Blob from './file/Blob.cjs';
import File from './file/File.cjs';
import FileReader from './file/FileReader.cjs';
import FormData from './form-data/FormData.cjs';
import History from './history/History.cjs';
import IntersectionObserver from './intersection-observer/IntersectionObserver.cjs';
import IntersectionObserverEntry from './intersection-observer/IntersectionObserverEntry.cjs';
import Location from './location/Location.cjs';
import MutationObserver from './mutation-observer/MutationObserver.cjs';
import MutationRecord from './mutation-observer/MutationRecord.cjs';
import Attr from './nodes/attr/Attr.cjs';
import Comment from './nodes/comment/Comment.cjs';
import DocumentFragment from './nodes/document-fragment/DocumentFragment.cjs';
import DocumentType from './nodes/document-type/DocumentType.cjs';
import Document from './nodes/document/Document.cjs';
import DOMRect from './dom/DOMRect.cjs';
import DOMRectReadOnly from './dom/DOMRectReadOnly.cjs';
import Element from './nodes/element/Element.cjs';
import HTMLCollection from './nodes/element/HTMLCollection.cjs';
import HTMLAnchorElement from './nodes/html-anchor-element/HTMLAnchorElement.cjs';
import HTMLAreaElement from './nodes/html-area-element/HTMLAreaElement.cjs';
import HTMLAudioElement from './nodes/html-audio-element/HTMLAudioElement.cjs';
import HTMLBaseElement from './nodes/html-base-element/HTMLBaseElement.cjs';
import HTMLBodyElement from './nodes/html-body-element/HTMLBodyElement.cjs';
import HTMLBRElement from './nodes/html-br-element/HTMLBRElement.cjs';
import HTMLButtonElement from './nodes/html-button-element/HTMLButtonElement.cjs';
import HTMLCanvasElement from './nodes/html-canvas-element/HTMLCanvasElement.cjs';
import HTMLDListElement from './nodes/html-d-list-element/HTMLDListElement.cjs';
import HTMLDataElement from './nodes/html-data-element/HTMLDataElement.cjs';
import HTMLDataListElement from './nodes/html-data-list-element/HTMLDataListElement.cjs';
import HTMLDetailsElement from './nodes/html-details-element/HTMLDetailsElement.cjs';
import HTMLDialogElement from './nodes/html-dialog-element/HTMLDialogElement.cjs';
import HTMLDivElement from './nodes/html-div-element/HTMLDivElement.cjs';
import HTMLDocument from './nodes/html-document/HTMLDocument.cjs';
import HTMLElement from './nodes/html-element/HTMLElement.cjs';
import HTMLEmbedElement from './nodes/html-embed-element/HTMLEmbedElement.cjs';
import HTMLFieldSetElement from './nodes/html-field-set-element/HTMLFieldSetElement.cjs';
import HTMLFormControlsCollection from './nodes/html-form-element/HTMLFormControlsCollection.cjs';
import HTMLFormElement from './nodes/html-form-element/HTMLFormElement.cjs';
import HTMLHeadElement from './nodes/html-head-element/HTMLHeadElement.cjs';
import HTMLHeadingElement from './nodes/html-heading-element/HTMLHeadingElement.cjs';
import HTMLHRElement from './nodes/html-hr-element/HTMLHRElement.cjs';
import HTMLHtmlElement from './nodes/html-html-element/HTMLHtmlElement.cjs';
import HTMLIFrameElement from './nodes/html-iframe-element/HTMLIFrameElement.cjs';
import HTMLImageElement from './nodes/html-image-element/HTMLImageElement.cjs';
import Image from './nodes/html-image-element/Image.cjs';
import FileList from './nodes/html-input-element/FileList.cjs';
import HTMLInputElement from './nodes/html-input-element/HTMLInputElement.cjs';
import HTMLLabelElement from './nodes/html-label-element/HTMLLabelElement.cjs';
import HTMLLegendElement from './nodes/html-legend-element/HTMLLegendElement.cjs';
import HTMLLIElement from './nodes/html-li-element/HTMLLIElement.cjs';
import HTMLLinkElement from './nodes/html-link-element/HTMLLinkElement.cjs';
import HTMLMapElement from './nodes/html-map-element/HTMLMapElement.cjs';
import HTMLMediaElement from './nodes/html-media-element/HTMLMediaElement.cjs';
import MediaStream from './nodes/html-media-element/MediaStream.cjs';
import MediaStreamTrack from './nodes/html-media-element/MediaStreamTrack.cjs';
import RemotePlayback from './nodes/html-media-element/RemotePlayback.cjs';
import TextTrack from './nodes/html-media-element/TextTrack.cjs';
import TextTrackCue from './nodes/html-media-element/TextTrackCue.cjs';
import TextTrackCueList from './nodes/html-media-element/TextTrackCueList.cjs';
import TextTrackList from './nodes/html-media-element/TextTrackList.cjs';
import VTTCue from './nodes/html-media-element/VTTCue.cjs';
import HTMLMenuElement from './nodes/html-menu-element/HTMLMenuElement.cjs';
import HTMLMetaElement from './nodes/html-meta-element/HTMLMetaElement.cjs';
import HTMLMeterElement from './nodes/html-meter-element/HTMLMeterElement.cjs';
import HTMLModElement from './nodes/html-mod-element/HTMLModElement.cjs';
import HTMLOListElement from './nodes/html-o-list-element/HTMLOListElement.cjs';
import HTMLObjectElement from './nodes/html-object-element/HTMLObjectElement.cjs';
import HTMLOptGroupElement from './nodes/html-opt-group-element/HTMLOptGroupElement.cjs';
import HTMLOptionElement from './nodes/html-option-element/HTMLOptionElement.cjs';
import HTMLOutputElement from './nodes/html-output-element/HTMLOutputElement.cjs';
import HTMLParagraphElement from './nodes/html-paragraph-element/HTMLParagraphElement.cjs';
import HTMLParamElement from './nodes/html-param-element/HTMLParamElement.cjs';
import HTMLPictureElement from './nodes/html-picture-element/HTMLPictureElement.cjs';
import HTMLPreElement from './nodes/html-pre-element/HTMLPreElement.cjs';
import HTMLProgressElement from './nodes/html-progress-element/HTMLProgressElement.cjs';
import HTMLQuoteElement from './nodes/html-quote-element/HTMLQuoteElement.cjs';
import HTMLScriptElement from './nodes/html-script-element/HTMLScriptElement.cjs';
import HTMLSelectElement from './nodes/html-select-element/HTMLSelectElement.cjs';
import HTMLSlotElement from './nodes/html-slot-element/HTMLSlotElement.cjs';
import HTMLSourceElement from './nodes/html-source-element/HTMLSourceElement.cjs';
import HTMLSpanElement from './nodes/html-span-element/HTMLSpanElement.cjs';
import HTMLStyleElement from './nodes/html-style-element/HTMLStyleElement.cjs';
import HTMLTableCaptionElement from './nodes/html-table-caption-element/HTMLTableCaptionElement.cjs';
import HTMLTableCellElement from './nodes/html-table-cell-element/HTMLTableCellElement.cjs';
import HTMLTableColElement from './nodes/html-table-col-element/HTMLTableColElement.cjs';
import HTMLTableElement from './nodes/html-table-element/HTMLTableElement.cjs';
import HTMLTableRowElement from './nodes/html-table-row-element/HTMLTableRowElement.cjs';
import HTMLTableSectionElement from './nodes/html-table-section-element/HTMLTableSectionElement.cjs';
import HTMLTemplateElement from './nodes/html-template-element/HTMLTemplateElement.cjs';
import HTMLTextAreaElement from './nodes/html-text-area-element/HTMLTextAreaElement.cjs';
import HTMLTimeElement from './nodes/html-time-element/HTMLTimeElement.cjs';
import HTMLTitleElement from './nodes/html-title-element/HTMLTitleElement.cjs';
import HTMLTrackElement from './nodes/html-track-element/HTMLTrackElement.cjs';
import HTMLUListElement from './nodes/html-u-list-element/HTMLUListElement.cjs';
import HTMLUnknownElement from './nodes/html-unknown-element/HTMLUnknownElement.cjs';
import HTMLVideoElement from './nodes/html-video-element/HTMLVideoElement.cjs';
import Node from './nodes/node/Node.cjs';
import ProcessingInstruction from './nodes/processing-instruction/ProcessingInstruction.cjs';
import ShadowRoot from './nodes/shadow-root/ShadowRoot.cjs';
import SVGElement from './nodes/svg-element/SVGElement.cjs';
import SVGGraphicsElement from './nodes/svg-graphics-element/SVGGraphicsElement.cjs';
import SVGSVGElement from './nodes/svg-svg-element/SVGSVGElement.cjs';
import Text from './nodes/text/Text.cjs';
import XMLDocument from './nodes/xml-document/XMLDocument.cjs';
import PermissionStatus from './permissions/PermissionStatus.cjs';
import Permissions from './permissions/Permissions.cjs';
import Range from './range/Range.cjs';
import ResizeObserver from './resize-observer/ResizeObserver.cjs';
import Screen from './screen/Screen.cjs';
import Selection from './selection/Selection.cjs';
import Storage from './storage/Storage.cjs';
import NodeFilter from './tree-walker/NodeFilter.cjs';
import NodeIterator from './tree-walker/NodeIterator.cjs';
import TreeWalker from './tree-walker/TreeWalker.cjs';
import URL from './url/URL.cjs';
import BrowserWindow from './window/BrowserWindow.cjs';
import DetachedWindowAPI from './window/DetachedWindowAPI.cjs';
import GlobalWindow from './window/GlobalWindow.cjs';
import Window from './window/Window.cjs';
import XMLParser from './xml-parser/XMLParser.cjs';
import XMLSerializer from './xml-serializer/XMLSerializer.cjs';
import type IBrowser from './browser/types/IBrowser.cjs';
import type IBrowserContext from './browser/types/IBrowserContext.cjs';
import type IBrowserFrame from './browser/types/IBrowserFrame.cjs';
import type IBrowserPage from './browser/types/IBrowserPage.cjs';
import type IBrowserSettings from './browser/types/IBrowserSettings.cjs';
import type IOptionalBrowserSettings from './browser/types/IOptionalBrowserSettings.cjs';
import type IEventInit from './event/IEventInit.cjs';
import type TEventListener from './event/TEventListener.cjs';
import type ITouchInit from './event/ITouchInit.cjs';
import type IUIEventInit from './event/IUIEventInit.cjs';
import type IAnimationEventInit from './event/events/IAnimationEventInit.cjs';
import type IClipboardEventInit from './event/events/IClipboardEventInit.cjs';
import type ICustomEventInit from './event/events/ICustomEventInit.cjs';
import type IErrorEventInit from './event/events/IErrorEventInit.cjs';
import type IFocusEventInit from './event/events/IFocusEventInit.cjs';
import type IHashChangeEventInit from './event/events/IHashChangeEventInit.cjs';
import type IInputEventInit from './event/events/IInputEventInit.cjs';
import type IKeyboardEventInit from './event/events/IKeyboardEventInit.cjs';
import type IMediaQueryListInit from './event/events/IMediaQueryListInit.cjs';
import type IMouseEventInit from './event/events/IMouseEventInit.cjs';
import type IProgressEventInit from './event/events/IProgressEventInit.cjs';
import type ISubmitEventInit from './event/events/ISubmitEventInit.cjs';
import type ITouchEventInit from './event/events/ITouchEventInit.cjs';
import type IWheelEventInit from './event/events/IWheelEventInit.cjs';
export type { IAnimationEventInit, IBrowser, IBrowserContext, IBrowserFrame, IBrowserPage, IBrowserSettings, IClipboardEventInit, ICustomEventInit, IErrorEventInit, IEventInit, TEventListener, IFocusEventInit, IHashChangeEventInit, IInputEventInit, IKeyboardEventInit, IMediaQueryListInit, IMouseEventInit, IOptionalBrowserSettings, IProgressEventInit, ISubmitEventInit, ITouchEventInit, ITouchInit, IUIEventInit, IWheelEventInit };
export { AbortController, AbortSignal, AnimationEvent, Attr, Blob, Browser, BrowserContext, BrowserErrorCaptureEnum, BrowserFrame, BrowserNavigationCrossOriginPolicyEnum, BrowserPage, BrowserWindow, Clipboard, ClipboardEvent, ClipboardItem, Comment, CSSContainerRule, CSSFontFaceRule, CSSKeyframeRule, CSSKeyframesRule, CSSMediaRule, CSSRule, CSSStyleDeclaration, CSSStyleRule, CSSStyleSheet, CSSSupportsRule, CustomElementRegistry, CustomEvent, DataTransfer, DataTransferItem, DataTransferItemList, DetachedBrowser, DetachedBrowserContext, DetachedBrowserFrame, DetachedBrowserPage, DetachedWindowAPI, Document, DocumentFragment, DocumentType, DOMException, DOMParser, DOMRect, DOMRectReadOnly, Element, ErrorEvent, Event, EventPhaseEnum, EventTarget, File, FileList, FileReader, FocusEvent, FormData, GlobalWindow, HashChangeEvent, Headers, History, HTMLAnchorElement, HTMLAreaElement, HTMLAudioElement, HTMLBaseElement, HTMLBodyElement, HTMLBRElement, HTMLButtonElement, HTMLCanvasElement, HTMLCollection, HTMLDataElement, HTMLDataListElement, HTMLDetailsElement, HTMLDialogElement, HTMLDivElement, HTMLDListElement, HTMLDocument, HTMLElement, HTMLEmbedElement, HTMLFieldSetElement, HTMLFormControlsCollection, HTMLFormElement, HTMLHeadElement, HTMLHeadingElement, HTMLHRElement, HTMLHtmlElement, HTMLIFrameElement, HTMLImageElement, HTMLInputElement, HTMLLabelElement, HTMLLegendElement, HTMLLIElement, HTMLLinkElement, HTMLMapElement, HTMLMediaElement, HTMLMenuElement, HTMLMetaElement, HTMLMeterElement, HTMLModElement, HTMLObjectElement, HTMLOListElement, HTMLOptGroupElement, HTMLOptionElement, HTMLOutputElement, HTMLParagraphElement, HTMLParamElement, HTMLPictureElement, HTMLPreElement, HTMLProgressElement, HTMLQuoteElement, HTMLScriptElement, HTMLSelectElement, HTMLSlotElement, HTMLSourceElement, HTMLSpanElement, HTMLStyleElement, HTMLTableCaptionElement, HTMLTableCellElement, HTMLTableColElement, HTMLTableElement, HTMLTableRowElement, HTMLTableSectionElement, HTMLTemplateElement, HTMLTextAreaElement, HTMLTimeElement, HTMLTitleElement, HTMLTrackElement, HTMLUListElement, HTMLUnknownElement, HTMLVideoElement, Image, InputEvent, IntersectionObserver, IntersectionObserverEntry, KeyboardEvent, Location, MediaQueryListEvent, MediaStream, MediaStreamTrack, MouseEvent, MutationObserver, MutationRecord, Node, NodeFilter, NodeIterator, Permissions, PermissionStatus, PointerEvent, ProcessingInstruction, ProgressEvent, PropertySymbol, Range, RemotePlayback, Request, ResizeObserver, Response, Screen, Selection, ShadowRoot, Storage, SubmitEvent, SVGElement, SVGGraphicsElement, SVGSVGElement, Text, TextTrack, TextTrackCue, TextTrackCueList, TextTrackList, Touch, TouchEvent, TreeWalker, UIEvent, URL, URLSearchParams, VirtualConsole, VirtualConsoleLogLevelEnum, VirtualConsoleLogTypeEnum, VirtualConsolePrinter, VTTCue, WheelEvent, Window, XMLDocument, XMLParser, XMLSerializer };
//# sourceMappingURL=index.d.ts.map