import { _ as c, q as h, a as g, T as r, E as l } from "./index-B04zLAsd.js";
import { C as M } from "./ContentMixin-BituPimg.js";
import { D as C } from "./style-48GmCpQg.js";
import { MultiFlatmapVuer as y } from "@abi-software/flatmapvuer";
import { resolveComponent as p, openBlock as m, createElementBlock as v, createVNode as I, createBlock as S, createCommentVNode as F } from "vue";
const w = '<svg width="72px" height="72px" viewBox="0 0 24 24" fill="yellow"><path d="M11.0748 3.25583C11.4141 2.42845 12.5859 2.42845 12.9252 3.25583L14.6493 7.45955C14.793 7.80979 15.1221 8.04889 15.4995 8.07727L20.0303 8.41798C20.922 8.48504 21.2841 9.59942 20.6021 10.1778L17.1369 13.1166C16.8482 13.3614 16.7225 13.7483 16.8122 14.1161L17.8882 18.5304C18.1 19.3992 17.152 20.0879 16.3912 19.618L12.5255 17.2305C12.2034 17.0316 11.7966 17.0316 11.4745 17.2305L7.60881 19.618C6.84796 20.0879 5.90001 19.3992 6.1118 18.5304L7.18785 14.1161C7.2775 13.7483 7.1518 13.3614 6.86309 13.1166L3.3979 10.1778C2.71588 9.59942 3.07796 8.48504 3.96971 8.41798L8.50046 8.07727C8.87794 8.04889 9.20704 7.80979 9.35068 7.45955L11.0748 3.25583Z" stroke="#000000" stroke-width="2"/></svg>', d = (e) => [
  {
    display: "Open AC Map",
    key: "AC"
  },
  {
    display: "Open FC Map",
    key: "FC"
  },
  {
    display: "Open 3D Human Map",
    key: "3D"
  }
], k = {
  name: "MultiFlatmap",
  mixins: [M, C],
  components: {
    MultiFlatmapVuer: y,
    HelpModeDialog: h
  },
  data: function() {
    return {
      availableSpecies: g(),
      flatmapReady: !1,
      scaffoldResource: {},
      showStarInLegend: !1,
      speciesHasChanged: !1,
      openMapOptions: d(),
      zoomLevel: 6
    };
  },
  methods: {
    getState: function() {
      if (this.flatmapReady) return this.$refs.multiflatmap.getState();
    },
    flatmapPanZoomCallback: function(e) {
      if (this.mouseHovered) {
        const t = {
          paneIndex: this.entry.id,
          eventType: "panZoom",
          payload: e,
          type: this.entry.type
        };
        this.$emit("resource-selected", t);
      }
    },
    /**
     * Perform a local search on this contentvuer
     */
    search: function(e) {
      return this.$refs.multiflatmap.getCurrentFlatmap().searchAndShowResult(e, !0, !0);
    },
    /**
     * Append the list of suggested terms to suggestions
     */
    searchSuggestions: function(e, t) {
      const a = this.$refs.multiflatmap.getCurrentFlatmap();
      if (e && a.mapImp) {
        const n = a.mapImp.search(e);
        (n.__featureIds || n.featureIds).forEach((o) => {
          const s = a.mapImp.annotation(o);
          s && s.label && t.push(s.label);
        });
      }
    },
    onPathwaySelectionChanged: function(e) {
      const { label: t, property: a, checked: n, selectionsTitle: i } = e;
      r.sendEvent({
        event: "interaction_event",
        event_name: "portal_maps_pathway_change",
        category: t + " [" + a + "] " + n,
        location: i
      });
    },
    onSidebarAnnotationClose: function() {
      this.flatmapReady && this.$refs.multiflatmap.getCurrentFlatmap().annotationEventCallback({}, { type: "aborted" });
    },
    onOpenPubmedUrl: function(e) {
      r.sendEvent({
        event: "interaction_event",
        event_name: "portal_maps_pubmed_url",
        file_path: e,
        location: "map_popup_button"
      });
    },
    zoomToFeatures: function(e, t) {
      let a = e.name;
      const n = this.getFlatmapImp();
      if (a) {
        const i = n.search(a);
        i.featureIds.length > 0 ? (t && n.selectFeatures(i.featureIds), n.zoomToFeatures(i.featureIds)) : n.clearSearchResults();
      } else
        n.clearSearchResults();
    },
    updateProvCard: function() {
      const e = this.getFlatmapImp();
      if (e) {
        let t = { id: this.entry.id, prov: e.mapMetadata };
        l.emit("mapImpProv", t), this.$emit("flatmap-provenance-ready", t);
      }
    },
    contextRestored: function(e) {
      e && (this.flatmapMarkerUpdate(e.mapImp), this.updateViewerSettings(), this.speciesHasChanged && (this.speciesHasChanged = !1, this.$emit("species-changed", this.activeSpecies)));
    },
    flatmapChanged: async function(e) {
      this.activeSpecies = e, this.openMapOptions = d();
      const t = this.getFlatmapImp();
      this.updateProvCard(), t && (t.contextLost ? this.speciesHasChanged = !0 : (this.flatmapMarkerUpdate(t), this.updateViewerSettings(), this.speciesHasChanged = !1, this.$emit("species-changed", e))), r.sendEvent({
        event: "interaction_event",
        event_name: "portal_maps_species_change",
        category: this.activeSpecies
      });
    },
    multiFlatmapReady: function(e) {
      if (e) {
        e.enablePanZoomEvents(!0), this.flatmapReady = !0;
        const t = e.mapImp;
        this.flatmapMarkerUpdate(t), this.updateProvCard(), this.updateViewerSettings(), this.loadConnectivityExplorerConfig(e).then(() => {
          l.emit("mapLoaded", e);
        });
      }
    },
    getFlatmapImp: function() {
      if (this.entry.type === "MultiFlatmap" && this.flatmapReady && this.$refs.multiflatmap)
        return this.$refs.multiflatmap.getCurrentFlatmap().mapImp;
    },
    flatmapAreaSearch() {
      let a = {
        type: "Facets",
        label: "Unused",
        val: this.getFlatmapImp().visibleMarkerAnatomicalIds().map((n) => this.idNamePair[n])
      };
      l.emit("PopoverActionClick", a);
    },
    restoreFeaturedMarkers: function(e) {
      this.settingsStore.resetFeaturedMarkerIdentifier();
      const t = this.settingsStore.featuredMarkers;
      this.updateFeaturedMarkers(t, e);
    },
    // updateFeaturedMarkers will step through the featured markers and add them to the map
    updateFeaturedMarkers: function(e, t) {
      this.showStarInLegend = !1;
      for (let a = 0; a < e.length; ++a)
        e[a] && (this.settingsStore.featuredMarkerIdentifiers[a] || this.addFeaturedMarker(e[a], a, t) && (this.showStarInLegend = !0));
    },
    // addFeaturedMarker: add a featured marker to the map at the specified uberon location
    addFeaturedMarker: function(e, t, a) {
      const n = this.settingsStore.featuredMarkerSpecies[t];
      if (n && !this.activeSpecies.startsWith(n))
        return !1;
      let i = a;
      if (i || (i = this.getFlatmapImp()), i) {
        let o = document.createElement("div");
        o.innerHTML = w;
        const s = i.addMarker(e, {
          element: o,
          className: "highlight-marker",
          cluster: !1
        });
        return this.settingsStore.updateFeaturedMarkerIdentifier({
          index: t,
          markerIdentifier: s
        }), !0;
      }
      return !1;
    },
    /**
     * Change the view mode of the current flatmap
     */
    changeViewingMode: function(e) {
      this.$refs.multiflatmap.getCurrentFlatmap().changeViewingMode(e);
    },
    showConnectivity: function(e) {
      if (this != null && this.alive && this.flatmapReady && this.$refs.multiflatmap) {
        const { featureIds: t, offset: a } = e, n = this.$refs.multiflatmap.getCurrentFlatmap();
        n && n.moveMap(t, {
          offsetX: a ? -150 : 0,
          zoom: 4
        });
      }
    },
    showConnectivityTooltips: function(e) {
      this != null && this.alive && this.flatmapReady && this.$refs.multiflatmap.getCurrentFlatmap().showConnectivityTooltips(e);
    },
    showConnectivitiesByReference: function(e) {
      if (this != null && this.alive && this.flatmapReady && this.$refs.multiflatmap) {
        const t = this.$refs.multiflatmap.getCurrentFlatmap();
        t && t.showConnectivitiesByReference(e);
      }
    },
    changeConnectivitySource: function(e, t) {
      if (this != null && this.alive && this.flatmapReady) {
        const a = this.$refs.multiflatmap.getCurrentFlatmap(), n = a.mapImp.mapMetadata.uuid;
        t.includes(n) || (t.push(n), a.changeConnectivitySource(e));
      }
    },
    updateViewerSettings: function() {
      const {
        backgroundDisplay: e,
        viewingMode: t,
        flightPathDisplay: a,
        organsDisplay: n,
        outlinesDisplay: i,
        connectionType: o
      } = this.settingsStore.globalSettings;
      if (this.flatmapReady) {
        const s = this.$refs.multiflatmap.getCurrentFlatmap();
        s.changeViewingMode(t), s.setFlightPath3D(a), s.setColour(n), s.setOutlines(i), s.backgroundChangeCallback(e), s.setConnectionType(o);
      }
    },
    setVisibilityFilter: function(e) {
      if (this != null && this.alive && this.flatmapReady && this.$refs.multiflatmap) {
        const t = this.$refs.multiflatmap.getCurrentFlatmap();
        t && t.setVisibilityFilter(e);
      }
    },
    getKnowledgeTooltip: async function(e) {
      if (this != null && this.alive && this.flatmapReady) {
        const t = e.data[0];
        this.$refs.multiflatmap.getCurrentFlatmap().searchAndShowResult(t.id, !0, !1);
      }
    }
  },
  computed: {
    facetSpecies() {
      return this.settingsStore.facets.species;
    },
    featuredMarkers() {
      return this.settingsStore.featuredMarkers;
    },
    displayMinimap() {
      return this.settingsStore.displayMinimap;
    }
  },
  watch: {
    featuredMarkers: function(e) {
      this.flatmapReady && this.updateFeaturedMarkers(e, void 0);
    }
  },
  mounted: function() {
    this.getFeaturedDatasets();
  }
}, b = { class: "viewer-container" };
function R(e, t, a, n, i, o) {
  const s = p("MultiFlatmapVuer"), f = p("HelpModeDialog");
  return m(), v("div", b, [
    I(s, {
      availableSpecies: e.availableSpecies,
      onContextRestored: o.contextRestored,
      onFlatmapChanged: o.flatmapChanged,
      onReady: o.multiFlatmapReady,
      state: e.entry.state,
      mapManager: e.mapManager,
      onResourceSelected: t[0] || (t[0] = (u) => e.flatmapResourceSelected(e.entry.type, u)),
      style: { height: "100%", width: "100%" },
      initial: e.entry.resource,
      helpMode: e.helpMode,
      helpModeActiveItem: e.helpModeActiveItem,
      helpModeDialog: e.useHelpModeDialog,
      onHelpModeLastItem: e.onHelpModeLastItem,
      onShownTooltip: e.onTooltipShown,
      onShownMapTooltip: e.onMapTooltipShown,
      onAnnotationOpen: e.onAnnotationOpen,
      onAnnotationClose: e.onAnnotationClose,
      onUpdateOfflineAnnotationEnabled: e.updateOfflineAnnotationEnabled,
      annotationSidebar: e.annotationSidebar,
      onConnectivityInfoOpen: e.onConnectivityInfoOpen,
      onConnectivityError: e.onConnectivityError,
      onConnectivityInfoClose: e.onConnectivityInfoClose,
      onNeuronConnectionFeatureClick: e.onNeuronConnectionFeatureClick,
      connectivityInfoSidebar: e.connectivityInfoSidebar,
      ref: "multiflatmap",
      displayMinimap: o.displayMinimap,
      showStarInLegend: e.showStarInLegend,
      enableOpenMapUI: !0,
      openMapOptions: e.openMapOptions,
      flatmapAPI: e.flatmapAPI,
      render: e.visible,
      sparcAPI: e.apiLocation,
      showLocalSettings: e.showLocalSettings,
      showOpenMapButton: e.showOpenMapButton,
      onPanZoomCallback: o.flatmapPanZoomCallback,
      onOpenMap: e.openMap,
      onFinishHelpMode: e.endHelp,
      onPathwaySelectionChanged: o.onPathwaySelectionChanged,
      onOpenPubmedUrl: o.onOpenPubmedUrl,
      onMapmanagerLoaded: e.onMapmanagerLoaded,
      showPathwayFilter: !1,
      onTrackEvent: e.trackEvent
    }, null, 8, ["availableSpecies", "onContextRestored", "onFlatmapChanged", "onReady", "state", "mapManager", "initial", "helpMode", "helpModeActiveItem", "helpModeDialog", "onHelpModeLastItem", "onShownTooltip", "onShownMapTooltip", "onAnnotationOpen", "onAnnotationClose", "onUpdateOfflineAnnotationEnabled", "annotationSidebar", "onConnectivityInfoOpen", "onConnectivityError", "onConnectivityInfoClose", "onNeuronConnectionFeatureClick", "connectivityInfoSidebar", "displayMinimap", "showStarInLegend", "openMapOptions", "flatmapAPI", "render", "sparcAPI", "showLocalSettings", "showOpenMapButton", "onPanZoomCallback", "onOpenMap", "onFinishHelpMode", "onPathwaySelectionChanged", "onOpenPubmedUrl", "onMapmanagerLoaded", "onTrackEvent"]),
    e.helpMode && e.useHelpModeDialog ? (m(), S(f, {
      key: 0,
      ref: "multiflatmapHelp",
      multiflatmapRef: e.multiflatmapRef,
      lastItem: e.helpModeLastItem,
      onShowNext: e.onHelpModeShowNext,
      onFinishHelpMode: e.onFinishHelpMode
    }, null, 8, ["multiflatmapRef", "lastItem", "onShowNext", "onFinishHelpMode"])) : F("", !0)
  ]);
}
const E = /* @__PURE__ */ c(k, [["render", R], ["__scopeId", "data-v-3d3287ed"]]);
export {
  E as default
};
