import os

basedir = os.path.abspath(os.path.dirname(__file__))


class Config(object):
    PENNSIEVE_API_HOST = os.environ.get("PENNSIEVE_API_HOST", "https://api.pennsieve.io")
    PENNSIEVE_API_SECRET = os.environ.get("PENNSIEVE_API_SECRET", "local-secret-key")
    PENNSIEVE_API_TOKEN = os.environ.get("PENNSIEVE_API_TOKEN", "local-api-key")
    PENNSIEVE_EMBARGO_TEAM_ID = os.environ.get("PENNSIEVE_EMBARGO_TEAM_ID")
    PENNSIEVE_ORGANIZATION = os.environ.get("PENNSIEVE_ORGANIZATION")
    DATABASE_URL = os.environ.get('DATABASE_URL')
    DISCOVER_API_HOST = os.environ.get(
        "DISCOVER_API_HOST", "https://api.pennsieve.io/discover"
    )
    GRAPHENEDB_BOLT_PASSWORD = os.environ.get("GRAPHENEDB_BOLT_PASSWORD")
    GRAPHENEDB_BOLT_URL = os.environ.get("GRAPHENEDB_BOLT_URL")
    GRAPHENEDB_BOLT_USER = os.environ.get("GRAPHENEDB_BOLT_USER")
    MONGODB_COLLECTION = os.environ.get("MONGODB_COLLECTION")
    MONGODB_NAME = os.environ.get("MONGODB_NAME")
    MONGODB_URI = os.environ.get("MONGODB_URI")
    SES_ARN = os.environ.get("SES_ARN")
    SES_SENDER = os.environ.get("SES_SENDER")
    METRICS_EMAIL_ADDRESS = os.environ.get("METRICS_EMAIL_ADDRESS", "metrics@sparc.science")
    TESTING_EMAIL_ADDRESS = os.environ.get("TESTING_EMAIL_ADDRESS")
    COMMS_EMAIL = os.environ.get("COMMS_EMAIL")
    SPARC_PORTAL_AWS_KEY = os.environ.get("SPARC_PORTAL_USER_ID")
    SPARC_PORTAL_AWS_SECRET = os.environ.get("SPARC_PORTAL_USER_SECRET")
    OSPARC_API_HOST = os.environ.get("OSPARC_API_HOST", "https://osparc.io/v0")
    AWS_REGION = os.environ.get("AWS_REGION", "us-east-1")
    BIOLUCIDA_ENDPOINT = os.environ.get("BIOLUCIDA_ENDPOINT", "https://sparc.biolucida.net/api/v1")
    BIOLUCIDA_USERNAME = os.environ.get("BIOLUCIDA_USERNAME", "major-user")
    BIOLUCIDA_PASSWORD = os.environ.get("BIOLUCIDA_PASSWORD", "local-password")
    KNOWLEDGEBASE_KEY = os.environ.get("KNOWLEDGEBASE_KEY", "secret-key")
    DEPLOY_ENV = os.environ.get("DEPLOY_ENV", "development")
    SPARC_API_DEBUGGING = os.environ.get("SPARC_API_DEBUGGING", "TRUE")
    SPARC_APP_HOST = os.environ.get("SPARC_APP_HOST", "https://sparc-app.herokuapp.com")
    SCI_CRUNCH_HOST = os.environ.get("SCICRUNCH_HOST", "https://scicrunch.org/api/1/elastic/SPARC_PortalDatasets_pr")
    MAPSTATE_TABLENAME = os.environ.get("MAPSTATE_TABLENAME", "mapstates")
    ANNOTATIONSTATE_TABLENAME = os.environ.get("ANNOTATION_TABLENAME", "annotationstates")
    SCAFFOLDSTATE_TABLENAME = os.environ.get("SCAFFOLDSTATE_TABLENAME", "scaffoldstates")
    FEATURED_DATASET_ID_SELECTOR_TABLENAME = os.environ.get("FEATURED_DATASET_ID_SELECTOR_TABLENAME", "featured_dataset_selector_state")
    PROTOCOL_METRICS_TABLENAME = os.environ.get("PROTOCOL_METRICS_TABLENAME", "protocol_metrics_state")
    MONTHLYSTATS_TABLENAME = os.environ.get("MONTHLYSTATS_TABLENAME", "monthlystats")
    WRIKE_TOKEN = os.environ.get("WRIKE_TOKEN")
    DRC_FEEDBACK_FOLDER_ID = os.environ.get("DRC_FEEDBACK_FOLDER_ID", "IEADBYQEI4MM37FH")
    DRC_WRIKE_CUSTOM_STATUS_ID = os.environ.get("DRC_WRIKE_CUSTOM_STATUS_ID", "IEADBYQEJMBJODZU")
    NEWS_AND_EVENTS_FOLDER_ID = os.environ.get("NEWS_AND_EVENTS_FOLDER_ID", "IEADBYQEI4TFTY2U")
    NEWS_TEMPLATE_TASK_ID = os.environ.get("NEWS_TEMPLATE_TASK_ID", "IEADBYQEKQ56O2FS")
    EVENT_TEMPLATE_TASK_ID = os.environ.get("EVENT_TEMPLATE_TASK_ID", "IEADBYQEKQ6DXDOJ")
    TOOLS_AND_RESOURCES_FOLDER_ID = os.environ.get("TOOLS_AND_RESOURCES_FOLDER_ID", "IEADBYQEI46DRBAD")
    TOOLS_AND_RESOURCES_TEMPLATE_TASK_ID = os.environ.get("TOOLS_AND_RESOURCES_TEMPLATE_TASK_ID", "IEADBYQEKQ6DQI6I")
    COMMUNITY_SPOTLIGHT_FOLDER_ID = os.environ.get("COMMUNITY_SPOTLIGHT_FOLDER_ID", "IEADBYQEI4VVKGPZ")
    COMMUNITY_SPOTLIGHT_TEMPLATE_TASK_ID = os.environ.get("COMMUNITY_SPOTLIGHT_TEMPLATE_TASK_ID", "IEADBYQEKQ6O6OCU")
    COMMS_LEAD_1_WRIKE_ID = os.environ.get("COMMS_LEAD_1_WRIKE_ID", "KUANMWS4")
    COMMS_LEAD_2_WRIKE_ID = os.environ.get("COMMS_LEAD_2_WRIKE_ID", "KUAMBOTN")
    COMMS_LEAD_3_WRIKE_ID = os.environ.get("COMMS_LEAD_3_WRIKE_ID", "KUAPGH66")
    SUE_WRIKE_ID = "KUAMBOTN"
    JYL_WRIKE_ID = "KUAIUASR"
    COMMS_WRIKE_CUSTOM_STATUS_ID = os.environ.get("COMMS_WRIKE_CUSTOM_STATUS_ID", "IEADBYQEJMAAAAAA")
    SIM_CORE_TECH_LEAD_WRIKE_ID = os.environ.get("SIM_CORE_TECH_LEAD_WRIKE_ID")
    MAP_CORE_TECH_LEAD_WRIKE_ID = os.environ.get("MAP_CORE_TECH_LEAD_WRIKE_ID")
    DAT_CORE_TECH_LEAD_WRIKE_ID = os.environ.get("DAT_CORE_TECH_LEAD_WRIKE_ID")
    K_CORE_TECH_LEAD_WRIKE_ID = os.environ.get("K_CORE_TECH_LEAD_WRIKE_ID")
    CCB_HEAD_WRIKE_ID = os.environ.get("CCB_HEAD_WRIKE_ID")
    MODERATOR_WRIKE_ID = os.environ.get("MODERATOR_WRIKE_ID")
    OSPARC_API_URL = os.environ.get("OSPARC_API_URL", "https://api.osparc.io")
    OSPARC_API_KEY = os.environ.get("OSPARC_API_KEY")
    OSPARC_API_SECRET = os.environ.get("OSPARC_API_SECRET")
    DIRECT_DOWNLOAD_LIMIT = int(os.environ.get("DIRECT_DOWNLOAD_LIMIT", "20971520"))
    DEFAULT_S3_BUCKET_NAME = "prd-sparc-discover50-use1"
    NEUROLUCIDA_HOST = os.environ.get("NEUROLUCIDA_HOST", "https://sparc.biolucida.net:8081")
    SCI_CRUNCH_INTERLEX_HOST = os.environ.get("SCI_CRUNCH_INTERLEX_HOST", "https://scicrunch.org/api/1/elastic/Interlex_pr")
    SCI_CRUNCH_SCIGRAPH_HOST = os.environ.get("SCI_CRUNCH_SCIGRAPH_HOST", "https://scicrunch.org/api/1/sparc-scigraph")
    SCI_CRUNCH_CITATIONS_HOST = os.environ.get("SCI_CRUNCH_CITATIONS_HOST", "https://api.scicrunch.io/elastic/v2/SPARC_Citations_pr")
    SCI_CRUNCH_QDB_HOST = os.environ.get("SCI_CRUNCH_QDB_HOST", "https://services.scicrunch.io/quantdb/api/1/values")
    README_API_KEY =  os.environ.get("README_API_KEY")
    HUBSPOT_API_TOKEN = os.environ.get("HUBSPOT_API_TOKEN")
    HUBSPOT_CLIENT_SECRET = os.environ.get("HUBSPOT_CLIENT_SECRET")
    EMAIL_OCTOPUS_API_KEY = os.environ.get("EMAIL_OCTOPUS_API_KEY")
    EMAIL_OCTOPUS_MASTER_LIST_ID = os.environ.get("EMAIL_OCTOPUS_MASTER_LIST_ID")
    LOG_LEVEL = os.environ.get("LOG_LEVEL", "WARNING")
    REVA_3D_TRACING_PRIMARY_FOLDER_COLLECTION_ID = os.environ.get("REVA_3D_TRACING_PRIMARY_FOLDER_COLLECTION_ID")
    REVA_MICRO_CT_PRIMARY_FOLDER_COLLECTION_ID = os.environ.get("REVA_MICRO_CT_PRIMARY_FOLDER_COLLECTION_ID")
    SPARC_GITHUB_ORG = os.environ.get("SPARC_GITHUB_ORG", "nih-sparc")
    SPARC_TECH_LEADS_GITHUB_TOKEN = os.environ.get("SPARC_TECH_LEADS_GITHUB_TOKEN", "")
    GITHUB_ISSUE_ASSIGNEES = os.environ.get("GITHUB_ISSUE_ASSIGNEES", "").split(",")
    SPARC_ISSUES_GITHUB_REPO = os.environ.get("SPARC_ISSUES_GITHUB_REPO", "sparc-app-issues")
    PROTOCOLS_IO_HOST = os.environ.get("PROTOCOLS_IO_HOST", "https://www.protocols.io")
    PROTOCOLS_IO_TOKEN = os.environ.get("PROTOCOLS_IO_TOKEN", "")
    HUBSPOT_GRANT_SEEKER_PIPELINE_ID = os.environ.get("HUBSPOT_GRANT_SEEKER_PIPELINE_ID", "default")
    HUBSPOT_ONBOARDING_PIPELINE_ID = os.environ.get("HUBSPOT_ONBOARDING_PIPELINE_ID", "55416921")
    HUBSPOT_GRANT_SEEKER_PIPELINE_INITIAL_STAGE_ID = os.environ.get("HUBSPOT_GRANT_SEEKER_PIPELINE_INITIAL_STAGE_ID", "appointmentscheduled")
    HUBSPOT_ONBOARDING_PIPELINE_INITIAL_STAGE_ID = os.environ.get("HUBSPOT_ONBOARDING_PIPELINE_INITIAL_STAGE_ID", "110981262")
    HUBSPOT_V3_API = os.environ.get("HUBSPOT_V3_API", "https://api.hubapi.com/crm/v3")
    ANBC_LEAD_SOURCE = os.environ.get("ANBC_LEAD_SOURCE", "ANBC partnership")
    SERVICES_EMAIL = os.environ.get("SERVICES_EMAIL", "services@sparc.science")
    MAILERSEND_API_KEY = os.environ.get("MAILERSEND_API_KEY", "")
    # Metrics
    GOOGLE_API_GA_SCOPE = os.environ.get("GOOGLE_API_GA_SCOPE", "https://www.googleapis.com/auth/analytics.readonly")
    GOOGLE_API_SPREADS_SCOPE = os.environ.get("GOOGLE_API_SPREADS_SCOPE", "https://www.googleapis.com/auth/spreadsheets")
    GOOGLE_API_DRIVE_SCOPE = os.environ.get("GOOGLE_API_DRIVE_SCOPE", "https://www.googleapis.com/auth/drive")
    GOOGLE_API_GA_KEY_PATH = os.environ.get("GOOGLE_API_GA_KEY_PATH")
    GOOGLE_API_GA_VIEW_ID = os.environ.get("GOOGLE_API_GA_VIEW_ID", "198433812")
    EVENTS_SPREADS_ID = os.environ.get("EVENTS_SPREADS_ID", "1SmgquFqUZLsBty5CJBNkRGCmXj_OQiY-dT6WN9L684c")
    EVENTS_ATTACHMENTS_FOLDER = os.environ.get("EVENTS_ATTACHMENTS_FOLDER", "1WO7wZdamhZYse_MjPaHzqZQ7FMlHsf15")
    ALGOLIA_APP_ID = os.environ.get("ALGOLIA_APP_ID")
    ALGOLIA_API_KEY = os.environ.get("ALGOLIA_API_KEY")
    ALGOLIA_INDEX = os.environ.get("ALGOLIA_INDEX", "k-core_dev")
    CTF_CDA_API_HOST = os.environ.get("CTF_CDA_API_HOST", "preview.contentful.com")
    CTF_CDA_ACCESS_TOKEN = os.environ.get("CTF_CDA_ACCESS_TOKEN")
    CTF_CMA_API_HOST = os.environ.get("CTF_CMA_API_HOST", "api.contentful.com")
    CTF_CMA_ACCESS_TOKEN = os.environ.get("CTF_CMA_ACCESS_TOKEN")
    CTF_SPACE_ID = os.environ.get("CTF_SPACE_ID")
    CTF_HOMEPAGE_ID = os.environ.get("CTF_HOMEPAGE_ID", '4qJ9WUWXg09FAUvCnbGxBY')
    NUXT_TURNSTILE_SECRET_KEY = os.environ.get("NUXT_TURNSTILE_SECRET_KEY")
    TURNSTILE_URL = os.environ.get("TURNSTILE_URL", "https://challenges.cloudflare.com/turnstile/v0/siteverify")
    PMR_HOST = os.environ.get("PMR_HOST", "https://models.physiomeproject.org")
