import { NodePath } from 'ast-types/lib/node-path';
/**
 * Helper functions to work with docblock comments.
 */
/**
 * Extracts the text from a docblock comment
 * @param {rawDocblock} str
 * @return str stripped from stars and spaces
 */
export declare function parseDocblock(str: string): string;
/**
 * Given a path, this function returns the closest preceding docblock if it
 * exists.
 */
export default function getDocblock(path: NodePath, { commentIndex }?: {
    commentIndex?: number;
}): string | null;
