import { PNG } from 'pngjs';

/**
 * Adjusts the canvas size of an image.
 *
 * @param {PNG} image - The input image.
 * @param {number} width - The target width of the image.
 * @param {number} height - The target height of the image.
 *
 * @returns {PNG} The new image with adjusted canvas size.
 */
declare const adjustCanvas: (image: PNG, width: number, height: number) => PNG;

export { adjustCanvas };
