"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var os_1 = require("os");
var chalk_1 = __importDefault(require("chalk"));
var RequestShortener_1 = __importDefault(require("webpack/lib/RequestShortener"));
var formatUtil_1 = require("./formatUtil");
var createGetFile = function (requestShortener) { return function (e) {
    /* istanbul ignore if */
    if (e.file) {
        // webpack does this also, so there must be case when this happens
        return e.file;
    }
    if (e.module &&
        e.module.readableIdentifier &&
        typeof e.module.readableIdentifier === 'function') {
        // if we got a module, build a file path to the module without loader information
        return formatUtil_1.stripLoaderFromPath(e.module.readableIdentifier(requestShortener));
    }
    /* istanbul ignore next */
    return null;
}; };
// helper to transform strings in errors
var ensureWebpackErrors = function (errors) {
    return errors.map(function (e) {
        /* istanbul ignore if */
        if (typeof e === 'string') {
            // webpack does this also, so there must be case when this happens
            return { message: e };
        }
        return e;
    });
};
var prependWarning = function (message) {
    return chalk_1["default"].yellow('Warning') + " " + message;
};
var prependError = function (message) { return chalk_1["default"].red('Error') + " " + message; };
function createStatsFormatter(rootPath) {
    var requestShortener = new RequestShortener_1["default"](rootPath);
    var getFile = createGetFile(requestShortener);
    var formatError = function (err) {
        var lines = [];
        var file = getFile(err);
        /* istanbul ignore else */
        if (file != null) {
            lines.push("in " + chalk_1["default"].underline(file));
            lines.push('');
        }
        else {
            // got no file, that happens only for more generic errors like the following from node-sass
            //    Missing binding /mochapack-example/node_modules/node-sass/vendor/linux-x64-48/binding.node
            //    Node Sass could not find a binding for your current environment: Linux 64-bit with Node.js 6.x
            //    ...
            // just print 2 lines like file
            lines.push('');
            lines.push('');
        }
        lines.push(formatUtil_1.formatErrorMessage(err.message));
        return lines.join(os_1.EOL);
    };
    return function statsFormatter(stats) {
        var compilation = stats.compilation;
        return {
            errors: ensureWebpackErrors(compilation.errors)
                .map(formatError)
                .map(prependError),
            warnings: ensureWebpackErrors(compilation.warnings)
                .map(formatError)
                .map(prependWarning)
        };
    };
}
exports["default"] = createStatsFormatter;
//# sourceMappingURL=createStatsFormatter.js.map