"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
exports.buildProgressPlugin = void 0;
var chalk_1 = __importDefault(require("chalk"));
var progress_1 = __importDefault(require("progress"));
var webpack_1 = require("webpack");
exports.buildProgressPlugin = function () {
    var bar = new progress_1["default"]("  [:bar] " + chalk_1["default"].bold(':percent') + " (" + chalk_1["default"].dim(':msg') + ")", {
        total: 100,
        complete: '=',
        incomplete: ' ',
        width: 25
    });
    return new webpack_1.ProgressPlugin(function (percent, msg) {
        bar.update(percent, {
            msg: percent === 1 ? 'completed' : msg
        });
        if (percent === 1) {
            bar.terminate();
        }
    });
};
//# sourceMappingURL=buildProgressPlugin.js.map