"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
exports.entryLoader = exports.EntryConfig = void 0;
var path_1 = require("path");
var loader_utils_1 = __importDefault(require("loader-utils"));
var createEntry_1 = __importDefault(require("../util/createEntry"));
var EntryConfig = /** @class */ (function () {
    function EntryConfig() {
        this.files = [];
    }
    EntryConfig.prototype.addFile = function (file) {
        var normalizedFile = path_1.normalize(file);
        this.files.push(normalizedFile);
    };
    EntryConfig.prototype.removeFile = function (file) {
        var normalizedFile = path_1.normalize(file);
        this.files = this.files.filter(function (f) { return f !== normalizedFile; });
    };
    EntryConfig.prototype.getFiles = function () {
        return this.files;
    };
    return EntryConfig;
}());
exports.EntryConfig = EntryConfig;
exports.entryLoader = function entryLoader() {
    var _this = this;
    var loaderOptions = loader_utils_1["default"].getOptions(this);
    var config = loaderOptions.entryConfig;
    // Remove all dependencies of the loader result
    this.clearDependencies();
    var entries = config.getFiles();
    // add all entries as dependencies
    // note this.addDependency requires an absolute path
    entries.forEach(function (e) { return _this.addDependency(e); });
    // build source code
    var dependencies = entries.map(function (file) { return loader_utils_1["default"].stringifyRequest(_this, file); });
    var sourceCode = createEntry_1["default"](dependencies);
    this.callback(null, sourceCode, null);
};
exports["default"] = exports.entryLoader;
//# sourceMappingURL=entryLoader.js.map