import { Module, Chunk } from '../types';
/**
 * Builds a list with ids of all affected modules in the following way:
 *  - affected directly by a file change
 *  - affected indirectly by a change of it's dependencies and so on
 *
 * @param chunks Array<Chunk>
 * @param modules Array<Module>
 * @return {Array.<number>}
 */
export default function getAffectedModuleIds(chunks: Array<Chunk>, modules: Array<Module>): Array<number | string>;
