import { ParsedMochaArgs } from './types';
/**
 * Parses CLI arguments for Mocha using Yargs as closely as possible to how
 *   Mocha parses arguments when run from their CLI.
 *
 * This is done to keep Mocha somewhat at arm's length, and not pollute the
 *   standard Mochapack args parser with Mocha-specific options/settings
 *
 * Note that some of this correlates with the builder in Mocha's lib/cli/run.js
 *
 * @param argv Arguments provided via CLI
 */
export declare const parseMochaArgs: (argv: string[]) => ParsedMochaArgs;
/**
 * Need to ensure any keys unknown to Mocha are not included in Yargs output
 */
export declare const pruneMochaYargsOutput: (yargsOutput: ParsedMochaArgs) => ParsedMochaArgs;
