"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var fs_1 = require("fs");
var path_1 = require("path");
var interpret_1 = __importDefault(require("interpret"));
var lodash_1 = require("lodash");
/**
 * Ensures that .js extension comes first, or whichever extension is shorter
 */
var sortExtensions = function (ext1, ext2) {
    if (ext1 === '.js')
        return -1;
    if (ext2 === '.js')
        return 1;
    return ext1.length - ext2.length;
};
var extensions = Object.keys(interpret_1["default"].extensions).sort(sortExtensions);
var findConfigFile = function (dirPath, baseName) {
    for (var _i = 0, extensions_1 = extensions; _i < extensions_1.length; _i++) {
        var extension = extensions_1[_i];
        var filePath = path_1.resolve(dirPath, "" + baseName + extension);
        if (fs_1.existsSync(filePath))
            return filePath;
    }
    return null;
};
var getConfigExtension = function (configPath) {
    for (var _i = 0, _a = extensions.reverse(); _i < _a.length; _i++) {
        var extension = _a[_i];
        var configPathIncludesExtension = configPath.indexOf(extension, configPath.length - extension.length) > -1;
        if (configPathIncludesExtension)
            return extension;
    }
    return path_1.extname(configPath);
};
/**
 * Registers a compiler
 */
var registerCompiler = function (moduleDescriptor) {
    if (!moduleDescriptor)
        return;
    if (lodash_1.isString(moduleDescriptor)) {
        require(moduleDescriptor); // eslint-disable-line global-require, import/no-dynamic-require
    }
    else if (!lodash_1.isArray(moduleDescriptor)) {
        var module_1 = require(moduleDescriptor.module); // eslint-disable-line global-require, import/no-dynamic-require
        moduleDescriptor.register(module_1);
    }
    else {
        for (var _i = 0, moduleDescriptor_1 = moduleDescriptor; _i < moduleDescriptor_1.length; _i++) {
            var descriptor = moduleDescriptor_1[_i];
            try {
                registerCompiler(descriptor);
                break;
            }
            catch (e) {
                if (!e.message.includes('Cannot find module'))
                    throw e;
            }
        }
    }
};
/**
 * Determines the path to a config that requires precompile and registers the
 *   compiler
 */
var requireWithPrecompilerPath = function (configPath, configExtension) {
    var configDirPath = path_1.dirname(configPath);
    var configBaseName = path_1.basename(configPath, configExtension);
    var configPathPrecompiled = findConfigFile(configDirPath, configBaseName);
    if (configPathPrecompiled != null) {
        // Found a config that needs to be precompiled
        var configExtensionPrecompiled = getConfigExtension(configPathPrecompiled);
        // Register compiler
        registerCompiler(interpret_1["default"].extensions[configExtensionPrecompiled]);
        return configPathPrecompiled;
    }
    return undefined;
};
/**
 * Finds the Webpack config if available and registers the compiler according
 *   to the applicable extension
 */
var findConfig = function (configPath, configExtension) {
    var config;
    var requirePath;
    var configFound = false;
    if (fs_1.existsSync(configPath)) {
        // Config exists, register compiler for non-js extensions
        registerCompiler(interpret_1["default"].extensions[configExtension]);
        requirePath = configPath;
        configFound = true;
    }
    else if (configExtension === '.js') {
        // Config does not exist, check for config that requires precompile
        requirePath = requireWithPrecompilerPath(configPath, configExtension);
        configFound = !lodash_1.isUndefined(requirePath);
    }
    if (configFound) {
        config = require(requirePath); // eslint-disable-line global-require, import/no-dynamic-require
    }
    return config;
};
/**
 * Requires in the user's Webpack config
 */
var requireWebpackConfig = function (webpackConfig, required, env, mode) { return __awaiter(void 0, void 0, void 0, function () {
    var configPath, configExtension, foundConfig, config;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                configPath = path_1.resolve(webpackConfig);
                configExtension = getConfigExtension(configPath);
                foundConfig = findConfig(configPath, configExtension);
                if (lodash_1.isUndefined(foundConfig) && required)
                    throw new Error("Webpack config could not be found: " + webpackConfig);
                config = foundConfig
                    ? foundConfig["default"] || foundConfig
                    : {};
                if (!lodash_1.isFunction(config)) return [3 /*break*/, 2];
                return [4 /*yield*/, Promise.resolve(config(env))];
            case 1:
                config = _a.sent();
                _a.label = 2;
            case 2:
                if (lodash_1.isArray(config)) {
                    throw new Error('Passing multiple configs as an Array is not supported. Please provide a single config instead.');
                }
                if (mode != null)
                    config.mode = mode;
                return [2 /*return*/, config];
        }
    });
}); };
exports["default"] = requireWebpackConfig;
//# sourceMappingURL=requireWebpackConfig.js.map