"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var fs_1 = __importDefault(require("fs"));
var exists_1 = require("../../../../util/exists");
var parseArgv_1 = __importDefault(require("../../parseArgv"));
var defaultConfig = 'mochapack.opts';
function handleMissingConfig(config) {
    if (config) {
        throw new Error("Options file '" + config + "' not found");
    }
    return {};
}
var createStripSurroundingChar = function (c) { return function (s) {
    if (s.indexOf(c) === 0 &&
        s.lastIndexOf(c) === s.length - 1 &&
        s.indexOf(c) !== s.lastIndexOf(c)) {
        return s.substring(1, s.length - 1);
    }
    return s;
}; };
var stripSingleQuotes = createStripSurroundingChar("'");
var stripDoubleQuotes = createStripSurroundingChar('"');
var removeSurroundingQuotes = function (str) {
    var stripped = stripDoubleQuotes(str);
    if (stripped !== str) {
        // strip only once
        return stripped;
    }
    return stripSingleQuotes(str);
};
function parseMochaOptsFile(explicitConfig) {
    var config = explicitConfig || defaultConfig;
    if (!exists_1.existsFileSync(config)) {
        return handleMissingConfig(explicitConfig);
    }
    var argv = fs_1["default"]
        .readFileSync(config, 'utf8')
        .replace(/\\\s/g, '%20')
        .split(/\s/)
        .filter(Boolean)
        .map(function (value) { return value.replace(/%20/g, ' '); })
        .map(removeSurroundingQuotes);
    var defaultOptions = parseArgv_1["default"](argv);
    return defaultOptions;
}
exports["default"] = parseMochaOptsFile;
//# sourceMappingURL=parseMochaOptsFile.js.map