"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
exports.mergeMochaConfigWithConstructorOptions = exports.mergeMochaConfigWithCliOptions = void 0;
var lodash_1 = require("lodash");
var config_1 = require("mocha/lib/cli/config");
var mochaOptionsFromParsedArgs_1 = require("./mochaOptionsFromParsedArgs");
var parseMochaOptsFile_1 = __importDefault(require("./parseMochaOptsFile"));
/**
 * Don't reinvent the wheel here, use Mocha's config file loading function
 *   under the hood
 */
var loadMochaConfigFile = function (configPath) {
    return config_1.loadConfig(configPath);
};
/**
 * Don't reinvent the wheel here, use Mocha's config file loading function
 *   under the hood
 */
var loadMochaOptsFile = function (optsFilePath) {
    return parseMochaOptsFile_1["default"](optsFilePath);
};
/**
 * Merges configuration from config and/or opts file with options from CLI
 */
var mergeMochaConfigWithOptions = function (options, optionsOutputType, configPath, optsFilePath) {
    var configContents = {};
    if (configPath)
        configContents = loadMochaConfigFile(configPath);
    if (optsFilePath)
        configContents = lodash_1.defaults(configContents, loadMochaOptsFile(optsFilePath));
    if (optionsOutputType === 'cli') {
        return lodash_1.defaults({}, options, lodash_1.pick(configContents, mochaOptionsFromParsedArgs_1.mochaCliOptionArgs));
    }
    return lodash_1.defaults({}, options, lodash_1.omit(configContents, mochaOptionsFromParsedArgs_1.mochaCliOptionArgs));
};
/**
 * If a config file is present, the options in it will be merged with those
 *   provided in the `options`. The values in `options` are preferred over
 *   those in the config file.
 *
 * @param options A `MochaOptions` object to extract options from
 * @param configPath Path to a Mocha config file
 */
exports.mergeMochaConfigWithCliOptions = function (options, configPath, optsFilePath) {
    return mergeMochaConfigWithOptions(options, 'cli', configPath, optsFilePath);
};
/**
 * If a config file is present, the options in it will be merged with those
 *   provided in the `options`. The values in `options` are preferred over
 *   those in the config file.
 *
 * @param options A `MochaOptions` object to extract options from
 * @param configPath Path to a Mocha config file
 */
exports.mergeMochaConfigWithConstructorOptions = function (options, configPath, optsFilePath) {
    return mergeMochaConfigWithOptions(options, 'constructor', configPath, optsFilePath);
};
//# sourceMappingURL=mergeMochaConfigWithOptions.js.map