"use strict";
exports.__esModule = true;
var lodash_1 = require("lodash");
/**
 * Converts top-level keys of an object to camelCase
 *
 * @param obj An object to convert keys for
 */
var camelizeKeys = function (obj) {
    var output = {};
    Object.keys(obj).forEach(function (key) {
        output[lodash_1.camelCase(key)] = obj[key];
    });
    return output;
};
exports["default"] = { camelizeKeys: camelizeKeys };
//# sourceMappingURL=utils.js.map