import { MochaOptions } from 'mocha';
import { MochaCliOptions } from '../types';
/**
 * If a config file is present, the options in it will be merged with those
 *   provided in the `options`. The values in `options` are preferred over
 *   those in the config file.
 *
 * @param options A `MochaOptions` object to extract options from
 * @param configPath Path to a Mocha config file
 */
export declare const mergeMochaConfigWithCliOptions: (options: MochaOptions, configPath?: string, optsFilePath?: string) => MochaCliOptions;
/**
 * If a config file is present, the options in it will be merged with those
 *   provided in the `options`. The values in `options` are preferred over
 *   those in the config file.
 *
 * @param options A `MochaOptions` object to extract options from
 * @param configPath Path to a Mocha config file
 */
export declare const mergeMochaConfigWithConstructorOptions: (options: MochaOptions, configPath?: string, optsFilePath?: string) => MochaOptions;
