import CSSRule from '../CSSRule.cjs';
import * as PropertySymbol from '../../PropertySymbol.cjs';
import CSSStyleDeclaration from '../declaration/CSSStyleDeclaration.cjs';
/**
 * CSSRule interface.
 */
export default class CSSStyleRule extends CSSRule {
    #private;
    readonly type: import("../CSSRuleTypeEnum.cjs").default;
    readonly selectorText = "";
    readonly styleMap: Map<any, any>;
    [PropertySymbol.cssText]: string;
    /**
     * Returns style.
     *
     * @returns Style.
     */
    get style(): CSSStyleDeclaration;
    /**
     * Returns css text.
     *
     * @returns CSS text.
     */
    get cssText(): string;
}
//# sourceMappingURL=CSSStyleRule.d.ts.map