import {
  Comment,
  Fragment,
  Teleport,
  Text,
  Transition,
  cloneVNode,
  computed,
  createBaseVNode,
  createBlock,
  createCommentVNode,
  createElementBlock,
  createTextVNode,
  createVNode,
  defineComponent,
  getCurrentInstance,
  getCurrentScope,
  inject,
  isRef,
  markRaw,
  mergeProps,
  nextTick,
  normalizeClass,
  normalizeStyle,
  onActivated,
  onBeforeMount,
  onBeforeUnmount,
  onDeactivated,
  onMounted,
  onScopeDispose,
  onUnmounted,
  onUpdated,
  openBlock,
  provide,
  reactive,
  readonly,
  ref,
  renderList,
  renderSlot,
  resolveComponent,
  resolveDirective,
  resolveDynamicComponent,
  shallowRef,
  toDisplayString,
  toHandlerKey,
  toHandlers,
  toRaw,
  toRef,
  toRefs,
  unref,
  useSlots,
  vModelText,
  vShow,
  warn,
  watch,
  watchEffect,
  withCtx,
  withDirectives,
  withKeys,
  withModifiers
} from "./chunk-HM42ZP2D.js";
import {
  __commonJS,
  __esm,
  __export,
  __toCommonJS,
  __toESM
} from "./chunk-EWTE5DHJ.js";

// node_modules/plotly.js/src/version.js
var require_version = __commonJS({
  "node_modules/plotly.js/src/version.js"(exports2) {
    "use strict";
    exports2.version = "2.35.3";
  }
});

// node_modules/native-promise-only/lib/npo.src.js
var require_npo_src = __commonJS({
  "node_modules/native-promise-only/lib/npo.src.js"(exports2, module2) {
    (function UMD(name, context, definition) {
      context[name] = context[name] || definition();
      if (typeof module2 != "undefined" && module2.exports) {
        module2.exports = context[name];
      } else if (typeof define == "function" && define.amd) {
        define(function $AMD$() {
          return context[name];
        });
      }
    })("Promise", typeof global != "undefined" ? global : exports2, function DEF() {
      "use strict";
      var builtInProp, cycle, scheduling_queue, ToString = Object.prototype.toString, timer = typeof setImmediate != "undefined" ? function timer2(fn) {
        return setImmediate(fn);
      } : setTimeout;
      try {
        Object.defineProperty({}, "x", {});
        builtInProp = function builtInProp2(obj, name, val, config) {
          return Object.defineProperty(obj, name, {
            value: val,
            writable: true,
            configurable: config !== false
          });
        };
      } catch (err) {
        builtInProp = function builtInProp2(obj, name, val) {
          obj[name] = val;
          return obj;
        };
      }
      scheduling_queue = /* @__PURE__ */ function Queue() {
        var first, last, item;
        function Item(fn, self2) {
          this.fn = fn;
          this.self = self2;
          this.next = void 0;
        }
        return {
          add: function add(fn, self2) {
            item = new Item(fn, self2);
            if (last) {
              last.next = item;
            } else {
              first = item;
            }
            last = item;
            item = void 0;
          },
          drain: function drain() {
            var f = first;
            first = last = cycle = void 0;
            while (f) {
              f.fn.call(f.self);
              f = f.next;
            }
          }
        };
      }();
      function schedule(fn, self2) {
        scheduling_queue.add(fn, self2);
        if (!cycle) {
          cycle = timer(scheduling_queue.drain);
        }
      }
      function isThenable(o) {
        var _then, o_type = typeof o;
        if (o != null && (o_type == "object" || o_type == "function")) {
          _then = o.then;
        }
        return typeof _then == "function" ? _then : false;
      }
      function notify() {
        for (var i = 0; i < this.chain.length; i++) {
          notifyIsolated(
            this,
            this.state === 1 ? this.chain[i].success : this.chain[i].failure,
            this.chain[i]
          );
        }
        this.chain.length = 0;
      }
      function notifyIsolated(self2, cb, chain) {
        var ret, _then;
        try {
          if (cb === false) {
            chain.reject(self2.msg);
          } else {
            if (cb === true) {
              ret = self2.msg;
            } else {
              ret = cb.call(void 0, self2.msg);
            }
            if (ret === chain.promise) {
              chain.reject(TypeError("Promise-chain cycle"));
            } else if (_then = isThenable(ret)) {
              _then.call(ret, chain.resolve, chain.reject);
            } else {
              chain.resolve(ret);
            }
          }
        } catch (err) {
          chain.reject(err);
        }
      }
      function resolve(msg) {
        var _then, self2 = this;
        if (self2.triggered) {
          return;
        }
        self2.triggered = true;
        if (self2.def) {
          self2 = self2.def;
        }
        try {
          if (_then = isThenable(msg)) {
            schedule(function() {
              var def_wrapper = new MakeDefWrapper(self2);
              try {
                _then.call(
                  msg,
                  function $resolve$() {
                    resolve.apply(def_wrapper, arguments);
                  },
                  function $reject$() {
                    reject.apply(def_wrapper, arguments);
                  }
                );
              } catch (err) {
                reject.call(def_wrapper, err);
              }
            });
          } else {
            self2.msg = msg;
            self2.state = 1;
            if (self2.chain.length > 0) {
              schedule(notify, self2);
            }
          }
        } catch (err) {
          reject.call(new MakeDefWrapper(self2), err);
        }
      }
      function reject(msg) {
        var self2 = this;
        if (self2.triggered) {
          return;
        }
        self2.triggered = true;
        if (self2.def) {
          self2 = self2.def;
        }
        self2.msg = msg;
        self2.state = 2;
        if (self2.chain.length > 0) {
          schedule(notify, self2);
        }
      }
      function iteratePromises(Constructor, arr, resolver, rejecter) {
        for (var idx = 0; idx < arr.length; idx++) {
          (function IIFE(idx2) {
            Constructor.resolve(arr[idx2]).then(
              function $resolver$(msg) {
                resolver(idx2, msg);
              },
              rejecter
            );
          })(idx);
        }
      }
      function MakeDefWrapper(self2) {
        this.def = self2;
        this.triggered = false;
      }
      function MakeDef(self2) {
        this.promise = self2;
        this.state = 0;
        this.triggered = false;
        this.chain = [];
        this.msg = void 0;
      }
      function Promise2(executor) {
        if (typeof executor != "function") {
          throw TypeError("Not a function");
        }
        if (this.__NPO__ !== 0) {
          throw TypeError("Not a promise");
        }
        this.__NPO__ = 1;
        var def = new MakeDef(this);
        this["then"] = function then(success, failure) {
          var o = {
            success: typeof success == "function" ? success : true,
            failure: typeof failure == "function" ? failure : false
          };
          o.promise = new this.constructor(function extractChain(resolve2, reject2) {
            if (typeof resolve2 != "function" || typeof reject2 != "function") {
              throw TypeError("Not a function");
            }
            o.resolve = resolve2;
            o.reject = reject2;
          });
          def.chain.push(o);
          if (def.state !== 0) {
            schedule(notify, def);
          }
          return o.promise;
        };
        this["catch"] = function $catch$(failure) {
          return this.then(void 0, failure);
        };
        try {
          executor.call(
            void 0,
            function publicResolve(msg) {
              resolve.call(def, msg);
            },
            function publicReject(msg) {
              reject.call(def, msg);
            }
          );
        } catch (err) {
          reject.call(def, err);
        }
      }
      var PromisePrototype = builtInProp(
        {},
        "constructor",
        Promise2,
        /*configurable=*/
        false
      );
      Promise2.prototype = PromisePrototype;
      builtInProp(
        PromisePrototype,
        "__NPO__",
        0,
        /*configurable=*/
        false
      );
      builtInProp(Promise2, "resolve", function Promise$resolve(msg) {
        var Constructor = this;
        if (msg && typeof msg == "object" && msg.__NPO__ === 1) {
          return msg;
        }
        return new Constructor(function executor(resolve2, reject2) {
          if (typeof resolve2 != "function" || typeof reject2 != "function") {
            throw TypeError("Not a function");
          }
          resolve2(msg);
        });
      });
      builtInProp(Promise2, "reject", function Promise$reject(msg) {
        return new this(function executor(resolve2, reject2) {
          if (typeof resolve2 != "function" || typeof reject2 != "function") {
            throw TypeError("Not a function");
          }
          reject2(msg);
        });
      });
      builtInProp(Promise2, "all", function Promise$all(arr) {
        var Constructor = this;
        if (ToString.call(arr) != "[object Array]") {
          return Constructor.reject(TypeError("Not an array"));
        }
        if (arr.length === 0) {
          return Constructor.resolve([]);
        }
        return new Constructor(function executor(resolve2, reject2) {
          if (typeof resolve2 != "function" || typeof reject2 != "function") {
            throw TypeError("Not a function");
          }
          var len = arr.length, msgs = Array(len), count = 0;
          iteratePromises(Constructor, arr, function resolver(idx, msg) {
            msgs[idx] = msg;
            if (++count === len) {
              resolve2(msgs);
            }
          }, reject2);
        });
      });
      builtInProp(Promise2, "race", function Promise$race(arr) {
        var Constructor = this;
        if (ToString.call(arr) != "[object Array]") {
          return Constructor.reject(TypeError("Not an array"));
        }
        return new Constructor(function executor(resolve2, reject2) {
          if (typeof resolve2 != "function" || typeof reject2 != "function") {
            throw TypeError("Not a function");
          }
          iteratePromises(Constructor, arr, function resolver(idx, msg) {
            resolve2(msg);
          }, reject2);
        });
      });
      return Promise2;
    });
  }
});

// node_modules/@plotly/d3/d3.js
var require_d3 = __commonJS({
  "node_modules/@plotly/d3/d3.js"(exports2, module2) {
    !(function() {
      var d3 = {
        version: "3.8.2"
      };
      var d3_arraySlice = [].slice, d3_array = function(list) {
        return d3_arraySlice.call(list);
      };
      var d3_document = self.document;
      function d3_documentElement(node) {
        return node && (node.ownerDocument || node.document || node).documentElement;
      }
      function d3_window(node) {
        return node && (node.ownerDocument && node.ownerDocument.defaultView || node.document && node || node.defaultView);
      }
      if (d3_document) {
        try {
          d3_array(d3_document.documentElement.childNodes)[0].nodeType;
        } catch (e) {
          d3_array = function(list) {
            var i = list.length, array = new Array(i);
            while (i--) array[i] = list[i];
            return array;
          };
        }
      }
      if (!Date.now) Date.now = function() {
        return +/* @__PURE__ */ new Date();
      };
      if (d3_document) {
        try {
          d3_document.createElement("DIV").style.setProperty("opacity", 0, "");
        } catch (error) {
          var d3_element_prototype = this.Element.prototype, d3_element_setAttribute = d3_element_prototype.setAttribute, d3_element_setAttributeNS = d3_element_prototype.setAttributeNS, d3_style_prototype = this.CSSStyleDeclaration.prototype, d3_style_setProperty = d3_style_prototype.setProperty;
          d3_element_prototype.setAttribute = function(name, value) {
            d3_element_setAttribute.call(this, name, value + "");
          };
          d3_element_prototype.setAttributeNS = function(space, local, value) {
            d3_element_setAttributeNS.call(this, space, local, value + "");
          };
          d3_style_prototype.setProperty = function(name, value, priority) {
            d3_style_setProperty.call(this, name, value + "", priority);
          };
        }
      }
      d3.ascending = d3_ascending;
      function d3_ascending(a, b) {
        return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
      }
      d3.descending = function(a, b) {
        return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
      };
      d3.min = function(array, f) {
        var i = -1, n = array.length, a, b;
        if (arguments.length === 1) {
          while (++i < n) if ((b = array[i]) != null && b >= b) {
            a = b;
            break;
          }
          while (++i < n) if ((b = array[i]) != null && a > b) a = b;
        } else {
          while (++i < n) if ((b = f.call(array, array[i], i)) != null && b >= b) {
            a = b;
            break;
          }
          while (++i < n) if ((b = f.call(array, array[i], i)) != null && a > b) a = b;
        }
        return a;
      };
      d3.max = function(array, f) {
        var i = -1, n = array.length, a, b;
        if (arguments.length === 1) {
          while (++i < n) if ((b = array[i]) != null && b >= b) {
            a = b;
            break;
          }
          while (++i < n) if ((b = array[i]) != null && b > a) a = b;
        } else {
          while (++i < n) if ((b = f.call(array, array[i], i)) != null && b >= b) {
            a = b;
            break;
          }
          while (++i < n) if ((b = f.call(array, array[i], i)) != null && b > a) a = b;
        }
        return a;
      };
      d3.extent = function(array, f) {
        var i = -1, n = array.length, a, b, c;
        if (arguments.length === 1) {
          while (++i < n) if ((b = array[i]) != null && b >= b) {
            a = c = b;
            break;
          }
          while (++i < n) if ((b = array[i]) != null) {
            if (a > b) a = b;
            if (c < b) c = b;
          }
        } else {
          while (++i < n) if ((b = f.call(array, array[i], i)) != null && b >= b) {
            a = c = b;
            break;
          }
          while (++i < n) if ((b = f.call(array, array[i], i)) != null) {
            if (a > b) a = b;
            if (c < b) c = b;
          }
        }
        return [a, c];
      };
      function d3_number(x) {
        return x === null ? NaN : +x;
      }
      function d3_numeric(x) {
        return !isNaN(x);
      }
      d3.sum = function(array, f) {
        var s = 0, n = array.length, a, i = -1;
        if (arguments.length === 1) {
          while (++i < n) if (d3_numeric(a = +array[i])) s += a;
        } else {
          while (++i < n) if (d3_numeric(a = +f.call(array, array[i], i))) s += a;
        }
        return s;
      };
      d3.mean = function(array, f) {
        var s = 0, n = array.length, a, i = -1, j = n;
        if (arguments.length === 1) {
          while (++i < n) if (d3_numeric(a = d3_number(array[i]))) s += a;
          else --j;
        } else {
          while (++i < n) if (d3_numeric(a = d3_number(f.call(array, array[i], i)))) s += a;
          else --j;
        }
        if (j) return s / j;
      };
      d3.quantile = function(values, p) {
        var H = (values.length - 1) * p + 1, h = Math.floor(H), v = +values[h - 1], e = H - h;
        return e ? v + e * (values[h] - v) : v;
      };
      d3.median = function(array, f) {
        var numbers = [], n = array.length, a, i = -1;
        if (arguments.length === 1) {
          while (++i < n) if (d3_numeric(a = d3_number(array[i]))) numbers.push(a);
        } else {
          while (++i < n) if (d3_numeric(a = d3_number(f.call(array, array[i], i)))) numbers.push(a);
        }
        if (numbers.length) return d3.quantile(numbers.sort(d3_ascending), 0.5);
      };
      d3.variance = function(array, f) {
        var n = array.length, m = 0, a, d, s = 0, i = -1, j = 0;
        if (arguments.length === 1) {
          while (++i < n) {
            if (d3_numeric(a = d3_number(array[i]))) {
              d = a - m;
              m += d / ++j;
              s += d * (a - m);
            }
          }
        } else {
          while (++i < n) {
            if (d3_numeric(a = d3_number(f.call(array, array[i], i)))) {
              d = a - m;
              m += d / ++j;
              s += d * (a - m);
            }
          }
        }
        if (j > 1) return s / (j - 1);
      };
      d3.deviation = function() {
        var v = d3.variance.apply(this, arguments);
        return v ? Math.sqrt(v) : v;
      };
      function d3_bisector(compare) {
        return {
          left: function(a, x, lo2, hi2) {
            if (arguments.length < 3) lo2 = 0;
            if (arguments.length < 4) hi2 = a.length;
            while (lo2 < hi2) {
              var mid = lo2 + hi2 >>> 1;
              if (compare(a[mid], x) < 0) lo2 = mid + 1;
              else hi2 = mid;
            }
            return lo2;
          },
          right: function(a, x, lo2, hi2) {
            if (arguments.length < 3) lo2 = 0;
            if (arguments.length < 4) hi2 = a.length;
            while (lo2 < hi2) {
              var mid = lo2 + hi2 >>> 1;
              if (compare(a[mid], x) > 0) hi2 = mid;
              else lo2 = mid + 1;
            }
            return lo2;
          }
        };
      }
      var d3_bisect = d3_bisector(d3_ascending);
      d3.bisectLeft = d3_bisect.left;
      d3.bisect = d3.bisectRight = d3_bisect.right;
      d3.bisector = function(f) {
        return d3_bisector(f.length === 1 ? function(d, x) {
          return d3_ascending(f(d), x);
        } : f);
      };
      d3.shuffle = function(array, i02, i12) {
        if ((m = arguments.length) < 3) {
          i12 = array.length;
          if (m < 2) i02 = 0;
        }
        var m = i12 - i02, t, i;
        while (m) {
          i = Math.random() * m-- | 0;
          t = array[m + i02], array[m + i02] = array[i + i02], array[i + i02] = t;
        }
        return array;
      };
      d3.permute = function(array, indexes) {
        var i = indexes.length, permutes = new Array(i);
        while (i--) permutes[i] = array[indexes[i]];
        return permutes;
      };
      d3.pairs = function(array) {
        var i = 0, n = array.length - 1, p02, p12 = array[0], pairs = new Array(n < 0 ? 0 : n);
        while (i < n) pairs[i] = [p02 = p12, p12 = array[++i]];
        return pairs;
      };
      d3.transpose = function(matrix) {
        if (!(n = matrix.length)) return [];
        for (var i = -1, m = d3.min(matrix, d3_transposeLength), transpose = new Array(m); ++i < m; ) {
          for (var j = -1, n, row = transpose[i] = new Array(n); ++j < n; ) {
            row[j] = matrix[j][i];
          }
        }
        return transpose;
      };
      function d3_transposeLength(d) {
        return d.length;
      }
      d3.zip = function() {
        return d3.transpose(arguments);
      };
      d3.keys = function(map2) {
        var keys = [];
        for (var key in map2) keys.push(key);
        return keys;
      };
      d3.values = function(map2) {
        var values = [];
        for (var key in map2) values.push(map2[key]);
        return values;
      };
      d3.entries = function(map2) {
        var entries = [];
        for (var key in map2) entries.push({
          key,
          value: map2[key]
        });
        return entries;
      };
      d3.merge = function(arrays) {
        var n = arrays.length, m, i = -1, j = 0, merged, array;
        while (++i < n) j += arrays[i].length;
        merged = new Array(j);
        while (--n >= 0) {
          array = arrays[n];
          m = array.length;
          while (--m >= 0) {
            merged[--j] = array[m];
          }
        }
        return merged;
      };
      var abs = Math.abs;
      d3.range = function(start, stop, step) {
        if (arguments.length < 3) {
          step = 1;
          if (arguments.length < 2) {
            stop = start;
            start = 0;
          }
        }
        if ((stop - start) / step === Infinity) throw new Error("infinite range");
        var range = [], k = d3_range_integerScale(abs(step)), i = -1, j;
        start *= k, stop *= k, step *= k;
        if (step < 0) while ((j = start + step * ++i) > stop) range.push(j / k);
        else while ((j = start + step * ++i) < stop) range.push(j / k);
        return range;
      };
      function d3_range_integerScale(x) {
        var k = 1;
        while (x * k % 1) k *= 10;
        return k;
      }
      function d3_class(ctor, properties) {
        for (var key in properties) {
          Object.defineProperty(ctor.prototype, key, {
            value: properties[key],
            enumerable: false
          });
        }
      }
      d3.map = function(object, f) {
        var map2 = new d3_Map();
        if (object instanceof d3_Map) {
          object.forEach(function(key2, value) {
            map2.set(key2, value);
          });
        } else if (Array.isArray(object)) {
          var i = -1, n = object.length, o;
          if (arguments.length === 1) while (++i < n) map2.set(i, object[i]);
          else while (++i < n) map2.set(f.call(object, o = object[i], i), o);
        } else {
          for (var key in object) map2.set(key, object[key]);
        }
        return map2;
      };
      function d3_Map() {
        this._ = /* @__PURE__ */ Object.create(null);
      }
      var d3_map_proto = "__proto__", d3_map_zero = "\0";
      d3_class(d3_Map, {
        has: d3_map_has,
        get: function(key) {
          return this._[d3_map_escape(key)];
        },
        set: function(key, value) {
          return this._[d3_map_escape(key)] = value;
        },
        remove: d3_map_remove,
        keys: d3_map_keys,
        values: function() {
          var values = [];
          for (var key in this._) values.push(this._[key]);
          return values;
        },
        entries: function() {
          var entries = [];
          for (var key in this._) entries.push({
            key: d3_map_unescape(key),
            value: this._[key]
          });
          return entries;
        },
        size: d3_map_size,
        empty: d3_map_empty,
        forEach: function(f) {
          for (var key in this._) f.call(this, d3_map_unescape(key), this._[key]);
        }
      });
      function d3_map_escape(key) {
        return (key += "") === d3_map_proto || key[0] === d3_map_zero ? d3_map_zero + key : key;
      }
      function d3_map_unescape(key) {
        return (key += "")[0] === d3_map_zero ? key.slice(1) : key;
      }
      function d3_map_has(key) {
        return d3_map_escape(key) in this._;
      }
      function d3_map_remove(key) {
        return (key = d3_map_escape(key)) in this._ && delete this._[key];
      }
      function d3_map_keys() {
        var keys = [];
        for (var key in this._) keys.push(d3_map_unescape(key));
        return keys;
      }
      function d3_map_size() {
        var size = 0;
        for (var key in this._) ++size;
        return size;
      }
      function d3_map_empty() {
        for (var key in this._) return false;
        return true;
      }
      d3.nest = function() {
        var nest = {}, keys = [], sortKeys = [], sortValues, rollup;
        function map2(mapType, array, depth) {
          if (depth >= keys.length) return rollup ? rollup.call(nest, array) : sortValues ? array.sort(sortValues) : array;
          var i = -1, n = array.length, key = keys[depth++], keyValue, object, setter, valuesByKey = new d3_Map(), values;
          while (++i < n) {
            if (values = valuesByKey.get(keyValue = key(object = array[i]))) {
              values.push(object);
            } else {
              valuesByKey.set(keyValue, [object]);
            }
          }
          if (mapType) {
            object = mapType();
            setter = function(keyValue2, values2) {
              object.set(keyValue2, map2(mapType, values2, depth));
            };
          } else {
            object = {};
            setter = function(keyValue2, values2) {
              object[keyValue2] = map2(mapType, values2, depth);
            };
          }
          valuesByKey.forEach(setter);
          return object;
        }
        function entries(map3, depth) {
          if (depth >= keys.length) return map3;
          var array = [], sortKey = sortKeys[depth++];
          map3.forEach(function(key, keyMap) {
            array.push({
              key,
              values: entries(keyMap, depth)
            });
          });
          return sortKey ? array.sort(function(a, b) {
            return sortKey(a.key, b.key);
          }) : array;
        }
        nest.map = function(array, mapType) {
          return map2(mapType, array, 0);
        };
        nest.entries = function(array) {
          return entries(map2(d3.map, array, 0), 0);
        };
        nest.key = function(d) {
          keys.push(d);
          return nest;
        };
        nest.sortKeys = function(order) {
          sortKeys[keys.length - 1] = order;
          return nest;
        };
        nest.sortValues = function(order) {
          sortValues = order;
          return nest;
        };
        nest.rollup = function(f) {
          rollup = f;
          return nest;
        };
        return nest;
      };
      d3.set = function(array) {
        var set = new d3_Set();
        if (array) for (var i = 0, n = array.length; i < n; ++i) set.add(array[i]);
        return set;
      };
      function d3_Set() {
        this._ = /* @__PURE__ */ Object.create(null);
      }
      d3_class(d3_Set, {
        has: d3_map_has,
        add: function(key) {
          this._[d3_map_escape(key += "")] = true;
          return key;
        },
        remove: d3_map_remove,
        values: d3_map_keys,
        size: d3_map_size,
        empty: d3_map_empty,
        forEach: function(f) {
          for (var key in this._) f.call(this, d3_map_unescape(key));
        }
      });
      d3.behavior = {};
      function d3_identity(d) {
        return d;
      }
      d3.rebind = function(target, source) {
        var i = 1, n = arguments.length, method;
        while (++i < n) target[method = arguments[i]] = d3_rebind(target, source, source[method]);
        return target;
      };
      function d3_rebind(target, source, method) {
        return function() {
          var value = method.apply(source, arguments);
          return value === source ? target : value;
        };
      }
      function d3_vendorSymbol(object, name) {
        if (name in object) return name;
        name = name.charAt(0).toUpperCase() + name.slice(1);
        for (var i = 0, n = d3_vendorPrefixes.length; i < n; ++i) {
          var prefixName = d3_vendorPrefixes[i] + name;
          if (prefixName in object) return prefixName;
        }
      }
      var d3_vendorPrefixes = ["webkit", "ms", "moz", "Moz", "o", "O"];
      function d3_noop() {
      }
      d3.dispatch = function() {
        var dispatch = new d3_dispatch(), i = -1, n = arguments.length;
        while (++i < n) dispatch[arguments[i]] = d3_dispatch_event(dispatch);
        return dispatch;
      };
      function d3_dispatch() {
      }
      d3_dispatch.prototype.on = function(type, listener) {
        var i = type.indexOf("."), name = "";
        if (i >= 0) {
          name = type.slice(i + 1);
          type = type.slice(0, i);
        }
        if (type) return arguments.length < 2 ? this[type].on(name) : this[type].on(name, listener);
        if (arguments.length === 2) {
          if (listener == null) for (type in this) {
            if (this.hasOwnProperty(type)) this[type].on(name, null);
          }
          return this;
        }
      };
      function d3_dispatch_event(dispatch) {
        var listeners = [], listenerByName = new d3_Map();
        function event() {
          var z2 = listeners, i = -1, n = z2.length, l;
          while (++i < n) if (l = z2[i].on) l.apply(this, arguments);
          return dispatch;
        }
        event.on = function(name, listener) {
          var l = listenerByName.get(name), i;
          if (arguments.length < 2) return l && l.on;
          if (l) {
            l.on = null;
            listeners = listeners.slice(0, i = listeners.indexOf(l)).concat(listeners.slice(i + 1));
            listenerByName.remove(name);
          }
          if (listener) listeners.push(listenerByName.set(name, {
            on: listener
          }));
          return dispatch;
        };
        return event;
      }
      d3.event = null;
      function d3_eventPreventDefault() {
        d3.event.preventDefault();
      }
      function d3_eventSource() {
        var e = d3.event, s;
        while (s = e.sourceEvent) e = s;
        return e;
      }
      function d3_eventDispatch(target) {
        var dispatch = new d3_dispatch(), i = 0, n = arguments.length;
        while (++i < n) dispatch[arguments[i]] = d3_dispatch_event(dispatch);
        dispatch.of = function(thiz, argumentz) {
          return function(e12) {
            try {
              var e02 = e12.sourceEvent = d3.event;
              e12.target = target;
              d3.event = e12;
              dispatch[e12.type].apply(thiz, argumentz);
            } finally {
              d3.event = e02;
            }
          };
        };
        return dispatch;
      }
      d3.requote = function(s) {
        return s.replace(d3_requote_re, "\\$&");
      };
      var d3_requote_re = /[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;
      var d3_subclass = {}.__proto__ ? function(object, prototype) {
        object.__proto__ = prototype;
      } : function(object, prototype) {
        for (var property in prototype) object[property] = prototype[property];
      };
      function d3_selection(groups) {
        d3_subclass(groups, d3_selectionPrototype);
        return groups;
      }
      var d3_select = function(s, n) {
        return n.querySelector(s);
      }, d3_selectAll = function(s, n) {
        return n.querySelectorAll(s);
      }, d3_selectMatches = function(n, s) {
        var d3_selectMatcher = n.matches || n[d3_vendorSymbol(n, "matchesSelector")];
        d3_selectMatches = function(n2, s2) {
          return d3_selectMatcher.call(n2, s2);
        };
        return d3_selectMatches(n, s);
      };
      if (typeof Sizzle === "function") {
        d3_select = function(s, n) {
          return Sizzle(s, n)[0] || null;
        };
        d3_selectAll = Sizzle;
        d3_selectMatches = Sizzle.matchesSelector;
      }
      d3.selection = function() {
        return d3.select(d3_document.documentElement);
      };
      var d3_selectionPrototype = d3.selection.prototype = [];
      d3_selectionPrototype.select = function(selector) {
        var subgroups = [], subgroup, subnode, group, node;
        selector = d3_selection_selector(selector);
        for (var j = -1, m = this.length; ++j < m; ) {
          subgroups.push(subgroup = []);
          subgroup.parentNode = (group = this[j]).parentNode;
          for (var i = -1, n = group.length; ++i < n; ) {
            if (node = group[i]) {
              subgroup.push(subnode = selector.call(node, node.__data__, i, j));
              if (subnode && "__data__" in node) subnode.__data__ = node.__data__;
            } else {
              subgroup.push(null);
            }
          }
        }
        return d3_selection(subgroups);
      };
      function d3_selection_selector(selector) {
        return typeof selector === "function" ? selector : function() {
          return d3_select(selector, this);
        };
      }
      d3_selectionPrototype.selectAll = function(selector) {
        var subgroups = [], subgroup, node;
        selector = d3_selection_selectorAll(selector);
        for (var j = -1, m = this.length; ++j < m; ) {
          for (var group = this[j], i = -1, n = group.length; ++i < n; ) {
            if (node = group[i]) {
              subgroups.push(subgroup = d3_array(selector.call(node, node.__data__, i, j)));
              subgroup.parentNode = node;
            }
          }
        }
        return d3_selection(subgroups);
      };
      function d3_selection_selectorAll(selector) {
        return typeof selector === "function" ? selector : function() {
          return d3_selectAll(selector, this);
        };
      }
      var d3_nsXhtml = "http://www.w3.org/1999/xhtml";
      var d3_nsPrefix = {
        svg: "http://www.w3.org/2000/svg",
        xhtml: d3_nsXhtml,
        xlink: "http://www.w3.org/1999/xlink",
        xml: "http://www.w3.org/XML/1998/namespace",
        xmlns: "http://www.w3.org/2000/xmlns/"
      };
      d3.ns = {
        prefix: d3_nsPrefix,
        qualify: function(name) {
          var i = name.indexOf(":"), prefix = name;
          if (i >= 0 && (prefix = name.slice(0, i)) !== "xmlns") name = name.slice(i + 1);
          return d3_nsPrefix.hasOwnProperty(prefix) ? {
            space: d3_nsPrefix[prefix],
            local: name
          } : name;
        }
      };
      d3_selectionPrototype.attr = function(name, value) {
        if (arguments.length < 2) {
          if (typeof name === "string") {
            var node = this.node();
            name = d3.ns.qualify(name);
            return name.local ? node.getAttributeNS(name.space, name.local) : node.getAttribute(name);
          }
          for (value in name) this.each(d3_selection_attr(value, name[value]));
          return this;
        }
        return this.each(d3_selection_attr(name, value));
      };
      function d3_selection_attr(name, value) {
        name = d3.ns.qualify(name);
        function attrNull() {
          this.removeAttribute(name);
        }
        function attrNullNS() {
          this.removeAttributeNS(name.space, name.local);
        }
        function attrConstant() {
          this.setAttribute(name, value);
        }
        function attrConstantNS() {
          this.setAttributeNS(name.space, name.local, value);
        }
        function attrFunction() {
          var x = value.apply(this, arguments);
          if (x == null) this.removeAttribute(name);
          else this.setAttribute(name, x);
        }
        function attrFunctionNS() {
          var x = value.apply(this, arguments);
          if (x == null) this.removeAttributeNS(name.space, name.local);
          else this.setAttributeNS(name.space, name.local, x);
        }
        return value == null ? name.local ? attrNullNS : attrNull : typeof value === "function" ? name.local ? attrFunctionNS : attrFunction : name.local ? attrConstantNS : attrConstant;
      }
      function d3_collapse(s) {
        return s.trim().replace(/\s+/g, " ");
      }
      d3_selectionPrototype.classed = function(name, value) {
        if (arguments.length < 2) {
          if (typeof name === "string") {
            var node = this.node(), n = (name = d3_selection_classes(name)).length, i = -1;
            if (value = node.classList) {
              while (++i < n) if (!value.contains(name[i])) return false;
            } else {
              value = node.getAttribute("class");
              while (++i < n) if (!d3_selection_classedRe(name[i]).test(value)) return false;
            }
            return true;
          }
          for (value in name) this.each(d3_selection_classed(value, name[value]));
          return this;
        }
        return this.each(d3_selection_classed(name, value));
      };
      function d3_selection_classedRe(name) {
        return new RegExp("(?:^|\\s+)" + d3.requote(name) + "(?:\\s+|$)", "g");
      }
      function d3_selection_classes(name) {
        return (name + "").trim().split(/^|\s+/);
      }
      function d3_selection_classed(name, value) {
        name = d3_selection_classes(name).map(d3_selection_classedName);
        var n = name.length;
        function classedConstant() {
          var i = -1;
          while (++i < n) name[i](this, value);
        }
        function classedFunction() {
          var i = -1, x = value.apply(this, arguments);
          while (++i < n) name[i](this, x);
        }
        return typeof value === "function" ? classedFunction : classedConstant;
      }
      function d3_selection_classedName(name) {
        var re2 = d3_selection_classedRe(name);
        return function(node, value) {
          if (c = node.classList) return value ? c.add(name) : c.remove(name);
          var c = node.getAttribute("class") || "";
          if (value) {
            re2.lastIndex = 0;
            if (!re2.test(c)) node.setAttribute("class", d3_collapse(c + " " + name));
          } else {
            node.setAttribute("class", d3_collapse(c.replace(re2, " ")));
          }
        };
      }
      d3_selectionPrototype.style = function(name, value, priority) {
        var n = arguments.length;
        if (n < 3) {
          if (typeof name !== "string") {
            if (n < 2) value = "";
            for (priority in name) this.each(d3_selection_style(priority, name[priority], value));
            return this;
          }
          if (n < 2) {
            var node = this.node();
            return d3_window(node).getComputedStyle(node, null).getPropertyValue(name);
          }
          priority = "";
        }
        return this.each(d3_selection_style(name, value, priority));
      };
      function d3_selection_style(name, value, priority) {
        function styleNull() {
          this.style.removeProperty(name);
        }
        function styleConstant() {
          this.style.setProperty(name, value, priority);
        }
        function styleFunction() {
          var x = value.apply(this, arguments);
          if (x == null) this.style.removeProperty(name);
          else this.style.setProperty(name, x, priority);
        }
        return value == null ? styleNull : typeof value === "function" ? styleFunction : styleConstant;
      }
      d3_selectionPrototype.property = function(name, value) {
        if (arguments.length < 2) {
          if (typeof name === "string") return this.node()[name];
          for (value in name) this.each(d3_selection_property(value, name[value]));
          return this;
        }
        return this.each(d3_selection_property(name, value));
      };
      function d3_selection_property(name, value) {
        function propertyNull() {
          delete this[name];
        }
        function propertyConstant() {
          this[name] = value;
        }
        function propertyFunction() {
          var x = value.apply(this, arguments);
          if (x == null) delete this[name];
          else this[name] = x;
        }
        return value == null ? propertyNull : typeof value === "function" ? propertyFunction : propertyConstant;
      }
      d3_selectionPrototype.text = function(value) {
        return arguments.length ? this.each(typeof value === "function" ? function() {
          var v = value.apply(this, arguments);
          this.textContent = v == null ? "" : v;
        } : value == null ? function() {
          this.textContent = "";
        } : function() {
          this.textContent = value;
        }) : this.node().textContent;
      };
      d3_selectionPrototype.html = function(value) {
        return arguments.length ? this.each(typeof value === "function" ? function() {
          var v = value.apply(this, arguments);
          this.innerHTML = v == null ? "" : v;
        } : value == null ? function() {
          this.innerHTML = "";
        } : function() {
          this.innerHTML = value;
        }) : this.node().innerHTML;
      };
      d3_selectionPrototype.append = function(name) {
        name = d3_selection_creator(name);
        return this.select(function() {
          return this.appendChild(name.apply(this, arguments));
        });
      };
      function d3_selection_creator(name) {
        function create() {
          var document2 = this.ownerDocument, namespace = this.namespaceURI;
          return namespace === d3_nsXhtml && document2.documentElement.namespaceURI === d3_nsXhtml ? document2.createElement(name) : document2.createElementNS(namespace, name);
        }
        function createNS() {
          return this.ownerDocument.createElementNS(name.space, name.local);
        }
        return typeof name === "function" ? name : (name = d3.ns.qualify(name)).local ? createNS : create;
      }
      d3_selectionPrototype.insert = function(name, before) {
        name = d3_selection_creator(name);
        before = d3_selection_selector(before);
        return this.select(function() {
          return this.insertBefore(name.apply(this, arguments), before.apply(this, arguments) || null);
        });
      };
      d3_selectionPrototype.remove = function() {
        return this.each(d3_selectionRemove);
      };
      function d3_selectionRemove() {
        var parent = this.parentNode;
        if (parent) parent.removeChild(this);
      }
      d3_selectionPrototype.data = function(value, key) {
        var i = -1, n = this.length, group, node;
        if (!arguments.length) {
          value = new Array(n = (group = this[0]).length);
          while (++i < n) {
            if (node = group[i]) {
              value[i] = node.__data__;
            }
          }
          return value;
        }
        function bind(group2, groupData) {
          var i2, n2 = group2.length, m = groupData.length, n02 = Math.min(n2, m), updateNodes = new Array(m), enterNodes = new Array(m), exitNodes = new Array(n2), node2, nodeData;
          if (key) {
            var nodeByKeyValue = new d3_Map(), keyValues = new Array(n2), keyValue;
            for (i2 = -1; ++i2 < n2; ) {
              if (node2 = group2[i2]) {
                if (nodeByKeyValue.has(keyValue = key.call(node2, node2.__data__, i2))) {
                  exitNodes[i2] = node2;
                } else {
                  nodeByKeyValue.set(keyValue, node2);
                }
                keyValues[i2] = keyValue;
              }
            }
            for (i2 = -1; ++i2 < m; ) {
              if (!(node2 = nodeByKeyValue.get(keyValue = key.call(groupData, nodeData = groupData[i2], i2)))) {
                enterNodes[i2] = d3_selection_dataNode(nodeData);
              } else if (node2 !== true) {
                updateNodes[i2] = node2;
                node2.__data__ = nodeData;
              }
              nodeByKeyValue.set(keyValue, true);
            }
            for (i2 = -1; ++i2 < n2; ) {
              if (i2 in keyValues && nodeByKeyValue.get(keyValues[i2]) !== true) {
                exitNodes[i2] = group2[i2];
              }
            }
          } else {
            for (i2 = -1; ++i2 < n02; ) {
              node2 = group2[i2];
              nodeData = groupData[i2];
              if (node2) {
                node2.__data__ = nodeData;
                updateNodes[i2] = node2;
              } else {
                enterNodes[i2] = d3_selection_dataNode(nodeData);
              }
            }
            for (; i2 < m; ++i2) {
              enterNodes[i2] = d3_selection_dataNode(groupData[i2]);
            }
            for (; i2 < n2; ++i2) {
              exitNodes[i2] = group2[i2];
            }
          }
          enterNodes.update = updateNodes;
          enterNodes.parentNode = updateNodes.parentNode = exitNodes.parentNode = group2.parentNode;
          enter.push(enterNodes);
          update.push(updateNodes);
          exit.push(exitNodes);
        }
        var enter = d3_selection_enter([]), update = d3_selection([]), exit = d3_selection([]);
        if (typeof value === "function") {
          while (++i < n) {
            bind(group = this[i], value.call(group, group.parentNode.__data__, i));
          }
        } else {
          while (++i < n) {
            bind(group = this[i], value);
          }
        }
        update.enter = function() {
          return enter;
        };
        update.exit = function() {
          return exit;
        };
        return update;
      };
      function d3_selection_dataNode(data) {
        return {
          __data__: data
        };
      }
      d3_selectionPrototype.datum = function(value) {
        return arguments.length ? this.property("__data__", value) : this.property("__data__");
      };
      d3_selectionPrototype.filter = function(filter) {
        var subgroups = [], subgroup, group, node;
        if (typeof filter !== "function") filter = d3_selection_filter(filter);
        for (var j = 0, m = this.length; j < m; j++) {
          subgroups.push(subgroup = []);
          subgroup.parentNode = (group = this[j]).parentNode;
          for (var i = 0, n = group.length; i < n; i++) {
            if ((node = group[i]) && filter.call(node, node.__data__, i, j)) {
              subgroup.push(node);
            }
          }
        }
        return d3_selection(subgroups);
      };
      function d3_selection_filter(selector) {
        return function() {
          return d3_selectMatches(this, selector);
        };
      }
      d3_selectionPrototype.order = function() {
        for (var j = -1, m = this.length; ++j < m; ) {
          for (var group = this[j], i = group.length - 1, next = group[i], node; --i >= 0; ) {
            if (node = group[i]) {
              if (next && next !== node.nextSibling) next.parentNode.insertBefore(node, next);
              next = node;
            }
          }
        }
        return this;
      };
      d3_selectionPrototype.sort = function(comparator) {
        comparator = d3_selection_sortComparator.apply(this, arguments);
        for (var j = -1, m = this.length; ++j < m; ) this[j].sort(comparator);
        return this.order();
      };
      function d3_selection_sortComparator(comparator) {
        if (!arguments.length) comparator = d3_ascending;
        return function(a, b) {
          return a && b ? comparator(a.__data__, b.__data__) : !a - !b;
        };
      }
      d3_selectionPrototype.each = function(callback) {
        return d3_selection_each(this, function(node, i, j) {
          callback.call(node, node.__data__, i, j);
        });
      };
      function d3_selection_each(groups, callback) {
        for (var j = 0, m = groups.length; j < m; j++) {
          for (var group = groups[j], i = 0, n = group.length, node; i < n; i++) {
            if (node = group[i]) callback(node, i, j);
          }
        }
        return groups;
      }
      d3_selectionPrototype.call = function(callback) {
        var args = d3_array(arguments);
        callback.apply(args[0] = this, args);
        return this;
      };
      d3_selectionPrototype.empty = function() {
        return !this.node();
      };
      d3_selectionPrototype.node = function() {
        for (var j = 0, m = this.length; j < m; j++) {
          for (var group = this[j], i = 0, n = group.length; i < n; i++) {
            var node = group[i];
            if (node) return node;
          }
        }
        return null;
      };
      d3_selectionPrototype.size = function() {
        var n = 0;
        d3_selection_each(this, function() {
          ++n;
        });
        return n;
      };
      function d3_selection_enter(selection) {
        d3_subclass(selection, d3_selection_enterPrototype);
        return selection;
      }
      var d3_selection_enterPrototype = [];
      d3.selection.enter = d3_selection_enter;
      d3.selection.enter.prototype = d3_selection_enterPrototype;
      d3_selection_enterPrototype.append = d3_selectionPrototype.append;
      d3_selection_enterPrototype.empty = d3_selectionPrototype.empty;
      d3_selection_enterPrototype.node = d3_selectionPrototype.node;
      d3_selection_enterPrototype.call = d3_selectionPrototype.call;
      d3_selection_enterPrototype.size = d3_selectionPrototype.size;
      d3_selection_enterPrototype.select = function(selector) {
        var subgroups = [], subgroup, subnode, upgroup, group, node;
        for (var j = -1, m = this.length; ++j < m; ) {
          upgroup = (group = this[j]).update;
          subgroups.push(subgroup = []);
          subgroup.parentNode = group.parentNode;
          for (var i = -1, n = group.length; ++i < n; ) {
            if (node = group[i]) {
              subgroup.push(upgroup[i] = subnode = selector.call(group.parentNode, node.__data__, i, j));
              subnode.__data__ = node.__data__;
            } else {
              subgroup.push(null);
            }
          }
        }
        return d3_selection(subgroups);
      };
      d3_selection_enterPrototype.insert = function(name, before) {
        if (arguments.length < 2) before = d3_selection_enterInsertBefore(this);
        return d3_selectionPrototype.insert.call(this, name, before);
      };
      function d3_selection_enterInsertBefore(enter) {
        var i02, j02;
        return function(d, i, j) {
          var group = enter[j].update, n = group.length, node;
          if (j != j02) j02 = j, i02 = 0;
          if (i >= i02) i02 = i + 1;
          while (!(node = group[i02]) && ++i02 < n) ;
          return node;
        };
      }
      d3.select = function(node) {
        var group;
        if (typeof node === "string") {
          group = [d3_select(node, d3_document)];
          group.parentNode = d3_document.documentElement;
        } else {
          group = [node];
          group.parentNode = d3_documentElement(node);
        }
        return d3_selection([group]);
      };
      d3.selectAll = function(nodes) {
        var group;
        if (typeof nodes === "string") {
          group = d3_array(d3_selectAll(nodes, d3_document));
          group.parentNode = d3_document.documentElement;
        } else {
          group = d3_array(nodes);
          group.parentNode = null;
        }
        return d3_selection([group]);
      };
      d3_selectionPrototype.on = function(type, listener, capture) {
        var n = arguments.length;
        if (n < 3) {
          if (typeof type !== "string") {
            if (n < 2) listener = false;
            for (capture in type) this.each(d3_selection_on(capture, type[capture], listener));
            return this;
          }
          if (n < 2) return (n = this.node()["__on" + type]) && n._;
          capture = false;
        }
        return this.each(d3_selection_on(type, listener, capture));
      };
      function d3_selection_on(type, listener, capture) {
        var name = "__on" + type, i = type.indexOf("."), wrap = d3_selection_onListener;
        if (i > 0) type = type.slice(0, i);
        var filter = d3_selection_onFilters.get(type);
        if (filter) type = filter, wrap = d3_selection_onFilter;
        function onRemove() {
          var l = this[name];
          if (l) {
            this.removeEventListener(type, l, l.$);
            delete this[name];
          }
        }
        function onAdd() {
          var l = wrap(listener, d3_array(arguments));
          onRemove.call(this);
          this.addEventListener(type, this[name] = l, l.$ = capture);
          l._ = listener;
        }
        function removeAll() {
          var re2 = new RegExp("^__on([^.]+)" + d3.requote(type) + "$"), match;
          for (var name2 in this) {
            if (match = name2.match(re2)) {
              var l = this[name2];
              this.removeEventListener(match[1], l, l.$);
              delete this[name2];
            }
          }
        }
        return i ? listener ? onAdd : onRemove : listener ? d3_noop : removeAll;
      }
      var d3_selection_onFilters = d3.map({
        mouseenter: "mouseover",
        mouseleave: "mouseout"
      });
      if (d3_document) {
        d3_selection_onFilters.forEach(function(k) {
          if ("on" + k in d3_document) d3_selection_onFilters.remove(k);
        });
      }
      function d3_selection_onListener(listener, argumentz) {
        return function(e) {
          var o = d3.event;
          d3.event = e;
          argumentz[0] = this.__data__;
          try {
            listener.apply(this, argumentz);
          } finally {
            d3.event = o;
          }
        };
      }
      function d3_selection_onFilter(listener, argumentz) {
        var l = d3_selection_onListener(listener, argumentz);
        return function(e) {
          var target = this, related = e.relatedTarget;
          if (!related || related !== target && !(related.compareDocumentPosition(target) & 8)) {
            l.call(target, e);
          }
        };
      }
      var d3_event_dragSelect, d3_event_dragId = 0;
      function d3_event_dragSuppress(node) {
        var name = ".dragsuppress-" + ++d3_event_dragId, click = "click" + name, w = d3.select(d3_window(node)).on("touchmove" + name, d3_eventPreventDefault).on("dragstart" + name, d3_eventPreventDefault).on("selectstart" + name, d3_eventPreventDefault);
        if (d3_event_dragSelect == null) {
          d3_event_dragSelect = "onselectstart" in node ? false : d3_vendorSymbol(node.style, "userSelect");
        }
        if (d3_event_dragSelect) {
          var style = d3_documentElement(node).style, select = style[d3_event_dragSelect];
          style[d3_event_dragSelect] = "none";
        }
        return function(suppressClick) {
          w.on(name, null);
          if (d3_event_dragSelect) style[d3_event_dragSelect] = select;
          if (suppressClick) {
            var off = function() {
              w.on(click, null);
            };
            w.on(click, function() {
              d3_eventPreventDefault();
              off();
            }, true);
            setTimeout(off, 0);
          }
        };
      }
      d3.mouse = function(container) {
        return d3_mousePoint(container, d3_eventSource());
      };
      var d3_mouse_bug44083 = this.navigator && /WebKit/.test(this.navigator.userAgent) ? -1 : 0;
      function d3_mousePoint(container, e) {
        if (e.changedTouches) e = e.changedTouches[0];
        var svg = container.ownerSVGElement || container;
        if (svg.createSVGPoint) {
          var point = svg.createSVGPoint();
          if (d3_mouse_bug44083 < 0) {
            var window2 = d3_window(container);
            if (window2.scrollX || window2.scrollY) {
              svg = d3.select("body").append("svg").style({
                position: "absolute",
                top: 0,
                left: 0,
                margin: 0,
                padding: 0,
                border: "none"
              }, "important");
              var ctm = svg[0][0].getScreenCTM();
              d3_mouse_bug44083 = !(ctm.f || ctm.e);
              svg.remove();
            }
          }
          if (d3_mouse_bug44083) point.x = e.pageX, point.y = e.pageY;
          else point.x = e.clientX, point.y = e.clientY;
          point = point.matrixTransform(container.getScreenCTM().inverse());
          return [point.x, point.y];
        }
        var rect = container.getBoundingClientRect();
        return [e.clientX - rect.left - container.clientLeft, e.clientY - rect.top - container.clientTop];
      }
      d3.touch = function(container, touches, identifier) {
        if (arguments.length < 3) identifier = touches, touches = d3_eventSource().changedTouches;
        if (touches) for (var i = 0, n = touches.length, touch; i < n; ++i) {
          if ((touch = touches[i]).identifier === identifier) {
            return d3_mousePoint(container, touch);
          }
        }
      };
      d3.behavior.drag = function() {
        var event = d3_eventDispatch(drag, "drag", "dragstart", "dragend"), origin = null, mousedown = dragstart(d3_noop, d3.mouse, d3_window, "mousemove", "mouseup"), touchstart = dragstart(d3_behavior_dragTouchId, d3.touch, d3_identity, "touchmove", "touchend");
        function drag() {
          this.on("mousedown.drag", mousedown).on("touchstart.drag", touchstart);
        }
        function dragstart(id2, position, subject, move, end) {
          return function() {
            var that = this, target = d3.event.target.correspondingElement || d3.event.target, parent = that.parentNode, dispatch = event.of(that, arguments), dragged = 0, dragId = id2(), dragName = ".drag" + (dragId == null ? "" : "-" + dragId), dragOffset, dragSubject = d3.select(subject(target)).on(move + dragName, moved).on(end + dragName, ended), dragRestore = d3_event_dragSuppress(target), position0 = position(parent, dragId);
            if (origin) {
              dragOffset = origin.apply(that, arguments);
              dragOffset = [dragOffset.x - position0[0], dragOffset.y - position0[1]];
            } else {
              dragOffset = [0, 0];
            }
            dispatch({
              type: "dragstart"
            });
            function moved() {
              var position1 = position(parent, dragId), dx, dy;
              if (!position1) return;
              dx = position1[0] - position0[0];
              dy = position1[1] - position0[1];
              dragged |= dx | dy;
              position0 = position1;
              dispatch({
                type: "drag",
                x: position1[0] + dragOffset[0],
                y: position1[1] + dragOffset[1],
                dx,
                dy
              });
            }
            function ended() {
              if (!position(parent, dragId)) return;
              dragSubject.on(move + dragName, null).on(end + dragName, null);
              dragRestore(dragged);
              dispatch({
                type: "dragend"
              });
            }
          };
        }
        drag.origin = function(x) {
          if (!arguments.length) return origin;
          origin = x;
          return drag;
        };
        return d3.rebind(drag, event, "on");
      };
      function d3_behavior_dragTouchId() {
        return d3.event.changedTouches[0].identifier;
      }
      d3.touches = function(container, touches) {
        if (arguments.length < 2) touches = d3_eventSource().touches;
        return touches ? d3_array(touches).map(function(touch) {
          var point = d3_mousePoint(container, touch);
          point.identifier = touch.identifier;
          return point;
        }) : [];
      };
      var ε = 1e-6, ε2 = ε * ε, π = Math.PI, τ = 2 * π, τε = τ - ε, halfπ = π / 2, d3_radians = π / 180, d3_degrees = 180 / π;
      function d3_sgn(x) {
        return x > 0 ? 1 : x < 0 ? -1 : 0;
      }
      function d3_cross2d(a, b, c) {
        return (b[0] - a[0]) * (c[1] - a[1]) - (b[1] - a[1]) * (c[0] - a[0]);
      }
      function d3_acos(x) {
        return x > 1 ? 0 : x < -1 ? π : Math.acos(x);
      }
      function d3_asin(x) {
        return x > 1 ? halfπ : x < -1 ? -halfπ : Math.asin(x);
      }
      function d3_sinh(x) {
        return ((x = Math.exp(x)) - 1 / x) / 2;
      }
      function d3_cosh(x) {
        return ((x = Math.exp(x)) + 1 / x) / 2;
      }
      function d3_tanh(x) {
        return ((x = Math.exp(2 * x)) - 1) / (x + 1);
      }
      function d3_haversin(x) {
        return (x = Math.sin(x / 2)) * x;
      }
      var ρ = Math.SQRT2, ρ2 = 2, ρ4 = 4;
      d3.interpolateZoom = function(p02, p12) {
        var ux0 = p02[0], uy0 = p02[1], w02 = p02[2], ux1 = p12[0], uy1 = p12[1], w12 = p12[2], dx = ux1 - ux0, dy = uy1 - uy0, d2 = dx * dx + dy * dy, i, S;
        if (d2 < ε2) {
          S = Math.log(w12 / w02) / ρ;
          i = function(t) {
            return [ux0 + t * dx, uy0 + t * dy, w02 * Math.exp(ρ * t * S)];
          };
        } else {
          var d12 = Math.sqrt(d2), b02 = (w12 * w12 - w02 * w02 + ρ4 * d2) / (2 * w02 * ρ2 * d12), b12 = (w12 * w12 - w02 * w02 - ρ4 * d2) / (2 * w12 * ρ2 * d12), r02 = Math.log(Math.sqrt(b02 * b02 + 1) - b02), r12 = Math.log(Math.sqrt(b12 * b12 + 1) - b12);
          S = (r12 - r02) / ρ;
          i = function(t) {
            var s = t * S, coshr0 = d3_cosh(r02), u = w02 / (ρ2 * d12) * (coshr0 * d3_tanh(ρ * s + r02) - d3_sinh(r02));
            return [ux0 + u * dx, uy0 + u * dy, w02 * coshr0 / d3_cosh(ρ * s + r02)];
          };
        }
        i.duration = S * 1e3;
        return i;
      };
      d3.behavior.zoom = function() {
        var view = {
          x: 0,
          y: 0,
          k: 1
        }, translate0, center0, center, size = [960, 500], scaleExtent = d3_behavior_zoomInfinity, duration = 250, zooming = 0, mousedown = "mousedown.zoom", mousemove = "mousemove.zoom", mouseup = "mouseup.zoom", mousewheelTimer, touchstart = "touchstart.zoom", touchtime, event = d3_eventDispatch(zoom, "zoomstart", "zoom", "zoomend"), x02, x12, y02, y12;
        if (!d3_behavior_zoomWheel) {
          d3_behavior_zoomWheel = "onwheel" in d3_document ? (d3_behavior_zoomDelta = function() {
            return -d3.event.deltaY * (d3.event.deltaMode ? 120 : 1);
          }, "wheel") : "onmousewheel" in d3_document ? (d3_behavior_zoomDelta = function() {
            return d3.event.wheelDelta;
          }, "mousewheel") : (d3_behavior_zoomDelta = function() {
            return -d3.event.detail;
          }, "MozMousePixelScroll");
        }
        function zoom(g) {
          g.on(mousedown, mousedowned).on(d3_behavior_zoomWheel + ".zoom", mousewheeled).on("dblclick.zoom", dblclicked).on(touchstart, touchstarted);
        }
        zoom.event = function(g) {
          g.each(function() {
            var dispatch = event.of(this, arguments), view1 = view;
            if (d3_transitionInheritId) {
              d3.select(this).transition().each("start.zoom", function() {
                view = this.__chart__ || {
                  x: 0,
                  y: 0,
                  k: 1
                };
                zoomstarted(dispatch);
              }).tween("zoom:zoom", function() {
                var dx = size[0], dy = size[1], cx = center0 ? center0[0] : dx / 2, cy = center0 ? center0[1] : dy / 2, i = d3.interpolateZoom([(cx - view.x) / view.k, (cy - view.y) / view.k, dx / view.k], [(cx - view1.x) / view1.k, (cy - view1.y) / view1.k, dx / view1.k]);
                return function(t) {
                  var l = i(t), k = dx / l[2];
                  this.__chart__ = view = {
                    x: cx - l[0] * k,
                    y: cy - l[1] * k,
                    k
                  };
                  zoomed(dispatch);
                };
              }).each("interrupt.zoom", function() {
                zoomended(dispatch);
              }).each("end.zoom", function() {
                zoomended(dispatch);
              });
            } else {
              this.__chart__ = view;
              zoomstarted(dispatch);
              zoomed(dispatch);
              zoomended(dispatch);
            }
          });
        };
        zoom.translate = function(_) {
          if (!arguments.length) return [view.x, view.y];
          view = {
            x: +_[0],
            y: +_[1],
            k: view.k
          };
          rescale();
          return zoom;
        };
        zoom.scale = function(_) {
          if (!arguments.length) return view.k;
          view = {
            x: view.x,
            y: view.y,
            k: null
          };
          scaleTo(+_);
          rescale();
          return zoom;
        };
        zoom.scaleExtent = function(_) {
          if (!arguments.length) return scaleExtent;
          scaleExtent = _ == null ? d3_behavior_zoomInfinity : [+_[0], +_[1]];
          return zoom;
        };
        zoom.center = function(_) {
          if (!arguments.length) return center;
          center = _ && [+_[0], +_[1]];
          return zoom;
        };
        zoom.size = function(_) {
          if (!arguments.length) return size;
          size = _ && [+_[0], +_[1]];
          return zoom;
        };
        zoom.duration = function(_) {
          if (!arguments.length) return duration;
          duration = +_;
          return zoom;
        };
        zoom.x = function(z2) {
          if (!arguments.length) return x12;
          x12 = z2;
          x02 = z2.copy();
          view = {
            x: 0,
            y: 0,
            k: 1
          };
          return zoom;
        };
        zoom.y = function(z2) {
          if (!arguments.length) return y12;
          y12 = z2;
          y02 = z2.copy();
          view = {
            x: 0,
            y: 0,
            k: 1
          };
          return zoom;
        };
        function location(p) {
          return [(p[0] - view.x) / view.k, (p[1] - view.y) / view.k];
        }
        function point(l) {
          return [l[0] * view.k + view.x, l[1] * view.k + view.y];
        }
        function scaleTo(s) {
          view.k = Math.max(scaleExtent[0], Math.min(scaleExtent[1], s));
        }
        function translateTo(p, l) {
          l = point(l);
          view.x += p[0] - l[0];
          view.y += p[1] - l[1];
        }
        function zoomTo(that, p, l, k) {
          that.__chart__ = {
            x: view.x,
            y: view.y,
            k: view.k
          };
          scaleTo(Math.pow(2, k));
          translateTo(center0 = p, l);
          that = d3.select(that);
          if (duration > 0) that = that.transition().duration(duration);
          that.call(zoom.event);
        }
        function rescale() {
          if (x12) x12.domain(x02.range().map(function(x) {
            return (x - view.x) / view.k;
          }).map(x02.invert));
          if (y12) y12.domain(y02.range().map(function(y) {
            return (y - view.y) / view.k;
          }).map(y02.invert));
        }
        function zoomstarted(dispatch) {
          if (!zooming++) dispatch({
            type: "zoomstart"
          });
        }
        function zoomed(dispatch) {
          rescale();
          dispatch({
            type: "zoom",
            scale: view.k,
            translate: [view.x, view.y]
          });
        }
        function zoomended(dispatch) {
          if (!--zooming) dispatch({
            type: "zoomend"
          }), center0 = null;
        }
        function mousedowned() {
          var that = this, dispatch = event.of(that, arguments), dragged = 0, subject = d3.select(d3_window(that)).on(mousemove, moved).on(mouseup, ended), location0 = location(d3.mouse(that)), dragRestore = d3_event_dragSuppress(that);
          d3_selection_interrupt.call(that);
          zoomstarted(dispatch);
          function moved() {
            dragged = 1;
            translateTo(d3.mouse(that), location0);
            zoomed(dispatch);
          }
          function ended() {
            subject.on(mousemove, null).on(mouseup, null);
            dragRestore(dragged);
            zoomended(dispatch);
          }
        }
        function touchstarted() {
          var that = this, dispatch = event.of(that, arguments), locations0 = {}, distance0 = 0, scale0, zoomName = ".zoom-" + d3.event.changedTouches[0].identifier, touchmove = "touchmove" + zoomName, touchend = "touchend" + zoomName, targets = [], subject = d3.select(that), dragRestore = d3_event_dragSuppress(that);
          started();
          zoomstarted(dispatch);
          subject.on(mousedown, null).on(touchstart, started);
          function relocate() {
            var touches = d3.touches(that);
            scale0 = view.k;
            touches.forEach(function(t) {
              if (t.identifier in locations0) locations0[t.identifier] = location(t);
            });
            return touches;
          }
          function started() {
            var target = d3.event.target;
            d3.select(target).on(touchmove, moved).on(touchend, ended);
            targets.push(target);
            var changed = d3.event.changedTouches;
            for (var i = 0, n = changed.length; i < n; ++i) {
              locations0[changed[i].identifier] = null;
            }
            var touches = relocate(), now = Date.now();
            if (touches.length === 1) {
              if (now - touchtime < 500) {
                var p = touches[0];
                zoomTo(that, p, locations0[p.identifier], Math.floor(Math.log(view.k) / Math.LN2) + 1);
                d3_eventPreventDefault();
              }
              touchtime = now;
            } else if (touches.length > 1) {
              var p = touches[0], q = touches[1], dx = p[0] - q[0], dy = p[1] - q[1];
              distance0 = dx * dx + dy * dy;
            }
          }
          function moved() {
            var touches = d3.touches(that), p02, l02, p12, l12;
            d3_selection_interrupt.call(that);
            for (var i = 0, n = touches.length; i < n; ++i, l12 = null) {
              p12 = touches[i];
              if (l12 = locations0[p12.identifier]) {
                if (l02) break;
                p02 = p12, l02 = l12;
              }
            }
            if (l12) {
              var distance1 = (distance1 = p12[0] - p02[0]) * distance1 + (distance1 = p12[1] - p02[1]) * distance1, scale1 = distance0 && Math.sqrt(distance1 / distance0);
              p02 = [(p02[0] + p12[0]) / 2, (p02[1] + p12[1]) / 2];
              l02 = [(l02[0] + l12[0]) / 2, (l02[1] + l12[1]) / 2];
              scaleTo(scale1 * scale0);
            }
            touchtime = null;
            translateTo(p02, l02);
            zoomed(dispatch);
          }
          function ended() {
            if (d3.event.touches.length) {
              var changed = d3.event.changedTouches;
              for (var i = 0, n = changed.length; i < n; ++i) {
                delete locations0[changed[i].identifier];
              }
              for (var identifier in locations0) {
                return void relocate();
              }
            }
            d3.selectAll(targets).on(zoomName, null);
            subject.on(mousedown, mousedowned).on(touchstart, touchstarted);
            dragRestore();
            zoomended(dispatch);
          }
        }
        function mousewheeled() {
          var dispatch = event.of(this, arguments);
          if (mousewheelTimer) clearTimeout(mousewheelTimer);
          else d3_selection_interrupt.call(this), translate0 = location(center0 = center || d3.mouse(this)), zoomstarted(dispatch);
          mousewheelTimer = setTimeout(function() {
            mousewheelTimer = null;
            zoomended(dispatch);
          }, 50);
          d3_eventPreventDefault();
          scaleTo(Math.pow(2, d3_behavior_zoomDelta() * 2e-3) * view.k);
          translateTo(center0, translate0);
          zoomed(dispatch);
        }
        function dblclicked() {
          var p = d3.mouse(this), k = Math.log(view.k) / Math.LN2;
          zoomTo(this, p, location(p), d3.event.shiftKey ? Math.ceil(k) - 1 : Math.floor(k) + 1);
        }
        return d3.rebind(zoom, event, "on");
      };
      var d3_behavior_zoomInfinity = [0, Infinity], d3_behavior_zoomDelta, d3_behavior_zoomWheel;
      d3.color = d3_color;
      function d3_color() {
      }
      d3_color.prototype.toString = function() {
        return this.rgb() + "";
      };
      d3.hsl = d3_hsl;
      function d3_hsl(h, s, l) {
        return this instanceof d3_hsl ? void (this.h = +h, this.s = +s, this.l = +l) : arguments.length < 2 ? h instanceof d3_hsl ? new d3_hsl(h.h, h.s, h.l) : d3_rgb_parse("" + h, d3_rgb_hsl, d3_hsl) : new d3_hsl(h, s, l);
      }
      var d3_hslPrototype = d3_hsl.prototype = new d3_color();
      d3_hslPrototype.brighter = function(k) {
        k = Math.pow(0.7, arguments.length ? k : 1);
        return new d3_hsl(this.h, this.s, this.l / k);
      };
      d3_hslPrototype.darker = function(k) {
        k = Math.pow(0.7, arguments.length ? k : 1);
        return new d3_hsl(this.h, this.s, k * this.l);
      };
      d3_hslPrototype.rgb = function() {
        return d3_hsl_rgb(this.h, this.s, this.l);
      };
      function d3_hsl_rgb(h, s, l) {
        var m12, m2;
        h = isNaN(h) ? 0 : (h %= 360) < 0 ? h + 360 : h;
        s = isNaN(s) ? 0 : s < 0 ? 0 : s > 1 ? 1 : s;
        l = l < 0 ? 0 : l > 1 ? 1 : l;
        m2 = l <= 0.5 ? l * (1 + s) : l + s - l * s;
        m12 = 2 * l - m2;
        function v(h2) {
          if (h2 > 360) h2 -= 360;
          else if (h2 < 0) h2 += 360;
          if (h2 < 60) return m12 + (m2 - m12) * h2 / 60;
          if (h2 < 180) return m2;
          if (h2 < 240) return m12 + (m2 - m12) * (240 - h2) / 60;
          return m12;
        }
        function vv2(h2) {
          return Math.round(v(h2) * 255);
        }
        return new d3_rgb(vv2(h + 120), vv2(h), vv2(h - 120));
      }
      d3.hcl = d3_hcl;
      function d3_hcl(h, c, l) {
        return this instanceof d3_hcl ? void (this.h = +h, this.c = +c, this.l = +l) : arguments.length < 2 ? h instanceof d3_hcl ? new d3_hcl(h.h, h.c, h.l) : h instanceof d3_lab ? d3_lab_hcl(h.l, h.a, h.b) : d3_lab_hcl((h = d3_rgb_lab((h = d3.rgb(h)).r, h.g, h.b)).l, h.a, h.b) : new d3_hcl(h, c, l);
      }
      var d3_hclPrototype = d3_hcl.prototype = new d3_color();
      d3_hclPrototype.brighter = function(k) {
        return new d3_hcl(this.h, this.c, Math.min(100, this.l + d3_lab_K * (arguments.length ? k : 1)));
      };
      d3_hclPrototype.darker = function(k) {
        return new d3_hcl(this.h, this.c, Math.max(0, this.l - d3_lab_K * (arguments.length ? k : 1)));
      };
      d3_hclPrototype.rgb = function() {
        return d3_hcl_lab(this.h, this.c, this.l).rgb();
      };
      function d3_hcl_lab(h, c, l) {
        if (isNaN(h)) h = 0;
        if (isNaN(c)) c = 0;
        return new d3_lab(l, Math.cos(h *= d3_radians) * c, Math.sin(h) * c);
      }
      d3.lab = d3_lab;
      function d3_lab(l, a, b) {
        return this instanceof d3_lab ? void (this.l = +l, this.a = +a, this.b = +b) : arguments.length < 2 ? l instanceof d3_lab ? new d3_lab(l.l, l.a, l.b) : l instanceof d3_hcl ? d3_hcl_lab(l.h, l.c, l.l) : d3_rgb_lab((l = d3_rgb(l)).r, l.g, l.b) : new d3_lab(l, a, b);
      }
      var d3_lab_K = 18;
      var d3_lab_X = 0.95047, d3_lab_Y = 1, d3_lab_Z = 1.08883;
      var d3_labPrototype = d3_lab.prototype = new d3_color();
      d3_labPrototype.brighter = function(k) {
        return new d3_lab(Math.min(100, this.l + d3_lab_K * (arguments.length ? k : 1)), this.a, this.b);
      };
      d3_labPrototype.darker = function(k) {
        return new d3_lab(Math.max(0, this.l - d3_lab_K * (arguments.length ? k : 1)), this.a, this.b);
      };
      d3_labPrototype.rgb = function() {
        return d3_lab_rgb(this.l, this.a, this.b);
      };
      function d3_lab_rgb(l, a, b) {
        var y = (l + 16) / 116, x = y + a / 500, z2 = y - b / 200;
        x = d3_lab_xyz(x) * d3_lab_X;
        y = d3_lab_xyz(y) * d3_lab_Y;
        z2 = d3_lab_xyz(z2) * d3_lab_Z;
        return new d3_rgb(d3_xyz_rgb(3.2404542 * x - 1.5371385 * y - 0.4985314 * z2), d3_xyz_rgb(-0.969266 * x + 1.8760108 * y + 0.041556 * z2), d3_xyz_rgb(0.0556434 * x - 0.2040259 * y + 1.0572252 * z2));
      }
      function d3_lab_hcl(l, a, b) {
        return l > 0 ? new d3_hcl(Math.atan2(b, a) * d3_degrees, Math.sqrt(a * a + b * b), l) : new d3_hcl(NaN, NaN, l);
      }
      function d3_lab_xyz(x) {
        return x > 0.206893034 ? x * x * x : (x - 4 / 29) / 7.787037;
      }
      function d3_xyz_lab(x) {
        return x > 8856e-6 ? Math.pow(x, 1 / 3) : 7.787037 * x + 4 / 29;
      }
      function d3_xyz_rgb(r) {
        return Math.round(255 * (r <= 304e-5 ? 12.92 * r : 1.055 * Math.pow(r, 1 / 2.4) - 0.055));
      }
      d3.rgb = d3_rgb;
      function d3_rgb(r, g, b) {
        return this instanceof d3_rgb ? void (this.r = ~~r, this.g = ~~g, this.b = ~~b) : arguments.length < 2 ? r instanceof d3_rgb ? new d3_rgb(r.r, r.g, r.b) : d3_rgb_parse("" + r, d3_rgb, d3_hsl_rgb) : new d3_rgb(r, g, b);
      }
      function d3_rgbNumber(value) {
        return new d3_rgb(value >> 16, value >> 8 & 255, value & 255);
      }
      function d3_rgbString(value) {
        return d3_rgbNumber(value) + "";
      }
      var d3_rgbPrototype = d3_rgb.prototype = new d3_color();
      d3_rgbPrototype.brighter = function(k) {
        k = Math.pow(0.7, arguments.length ? k : 1);
        var r = this.r, g = this.g, b = this.b, i = 30;
        if (!r && !g && !b) return new d3_rgb(i, i, i);
        if (r && r < i) r = i;
        if (g && g < i) g = i;
        if (b && b < i) b = i;
        return new d3_rgb(Math.min(255, r / k), Math.min(255, g / k), Math.min(255, b / k));
      };
      d3_rgbPrototype.darker = function(k) {
        k = Math.pow(0.7, arguments.length ? k : 1);
        return new d3_rgb(k * this.r, k * this.g, k * this.b);
      };
      d3_rgbPrototype.hsl = function() {
        return d3_rgb_hsl(this.r, this.g, this.b);
      };
      d3_rgbPrototype.toString = function() {
        return "#" + d3_rgb_hex(this.r) + d3_rgb_hex(this.g) + d3_rgb_hex(this.b);
      };
      function d3_rgb_hex(v) {
        return v < 16 ? "0" + Math.max(0, v).toString(16) : Math.min(255, v).toString(16);
      }
      function d3_rgb_parse(format2, rgb, hsl) {
        var r = 0, g = 0, b = 0, m12, m2, color;
        m12 = /([a-z]+)\((.*)\)/.exec(format2 = format2.toLowerCase());
        if (m12) {
          m2 = m12[2].split(",");
          switch (m12[1]) {
            case "hsl": {
              return hsl(parseFloat(m2[0]), parseFloat(m2[1]) / 100, parseFloat(m2[2]) / 100);
            }
            case "rgb": {
              return rgb(d3_rgb_parseNumber(m2[0]), d3_rgb_parseNumber(m2[1]), d3_rgb_parseNumber(m2[2]));
            }
          }
        }
        if (color = d3_rgb_names.get(format2)) {
          return rgb(color.r, color.g, color.b);
        }
        if (format2 != null && format2.charAt(0) === "#" && !isNaN(color = parseInt(format2.slice(1), 16))) {
          if (format2.length === 4) {
            r = (color & 3840) >> 4;
            r = r >> 4 | r;
            g = color & 240;
            g = g >> 4 | g;
            b = color & 15;
            b = b << 4 | b;
          } else if (format2.length === 7) {
            r = (color & 16711680) >> 16;
            g = (color & 65280) >> 8;
            b = color & 255;
          }
        }
        return rgb(r, g, b);
      }
      function d3_rgb_hsl(r, g, b) {
        var min = Math.min(r /= 255, g /= 255, b /= 255), max = Math.max(r, g, b), d = max - min, h, s, l = (max + min) / 2;
        if (d) {
          s = l < 0.5 ? d / (max + min) : d / (2 - max - min);
          if (r == max) h = (g - b) / d + (g < b ? 6 : 0);
          else if (g == max) h = (b - r) / d + 2;
          else h = (r - g) / d + 4;
          h *= 60;
        } else {
          h = NaN;
          s = l > 0 && l < 1 ? 0 : h;
        }
        return new d3_hsl(h, s, l);
      }
      function d3_rgb_lab(r, g, b) {
        r = d3_rgb_xyz(r);
        g = d3_rgb_xyz(g);
        b = d3_rgb_xyz(b);
        var x = d3_xyz_lab((0.4124564 * r + 0.3575761 * g + 0.1804375 * b) / d3_lab_X), y = d3_xyz_lab((0.2126729 * r + 0.7151522 * g + 0.072175 * b) / d3_lab_Y), z2 = d3_xyz_lab((0.0193339 * r + 0.119192 * g + 0.9503041 * b) / d3_lab_Z);
        return d3_lab(116 * y - 16, 500 * (x - y), 200 * (y - z2));
      }
      function d3_rgb_xyz(r) {
        return (r /= 255) <= 0.04045 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
      }
      function d3_rgb_parseNumber(c) {
        var f = parseFloat(c);
        return c.charAt(c.length - 1) === "%" ? Math.round(f * 2.55) : f;
      }
      var d3_rgb_names = d3.map({
        aliceblue: 15792383,
        antiquewhite: 16444375,
        aqua: 65535,
        aquamarine: 8388564,
        azure: 15794175,
        beige: 16119260,
        bisque: 16770244,
        black: 0,
        blanchedalmond: 16772045,
        blue: 255,
        blueviolet: 9055202,
        brown: 10824234,
        burlywood: 14596231,
        cadetblue: 6266528,
        chartreuse: 8388352,
        chocolate: 13789470,
        coral: 16744272,
        cornflowerblue: 6591981,
        cornsilk: 16775388,
        crimson: 14423100,
        cyan: 65535,
        darkblue: 139,
        darkcyan: 35723,
        darkgoldenrod: 12092939,
        darkgray: 11119017,
        darkgreen: 25600,
        darkgrey: 11119017,
        darkkhaki: 12433259,
        darkmagenta: 9109643,
        darkolivegreen: 5597999,
        darkorange: 16747520,
        darkorchid: 10040012,
        darkred: 9109504,
        darksalmon: 15308410,
        darkseagreen: 9419919,
        darkslateblue: 4734347,
        darkslategray: 3100495,
        darkslategrey: 3100495,
        darkturquoise: 52945,
        darkviolet: 9699539,
        deeppink: 16716947,
        deepskyblue: 49151,
        dimgray: 6908265,
        dimgrey: 6908265,
        dodgerblue: 2003199,
        firebrick: 11674146,
        floralwhite: 16775920,
        forestgreen: 2263842,
        fuchsia: 16711935,
        gainsboro: 14474460,
        ghostwhite: 16316671,
        gold: 16766720,
        goldenrod: 14329120,
        gray: 8421504,
        green: 32768,
        greenyellow: 11403055,
        grey: 8421504,
        honeydew: 15794160,
        hotpink: 16738740,
        indianred: 13458524,
        indigo: 4915330,
        ivory: 16777200,
        khaki: 15787660,
        lavender: 15132410,
        lavenderblush: 16773365,
        lawngreen: 8190976,
        lemonchiffon: 16775885,
        lightblue: 11393254,
        lightcoral: 15761536,
        lightcyan: 14745599,
        lightgoldenrodyellow: 16448210,
        lightgray: 13882323,
        lightgreen: 9498256,
        lightgrey: 13882323,
        lightpink: 16758465,
        lightsalmon: 16752762,
        lightseagreen: 2142890,
        lightskyblue: 8900346,
        lightslategray: 7833753,
        lightslategrey: 7833753,
        lightsteelblue: 11584734,
        lightyellow: 16777184,
        lime: 65280,
        limegreen: 3329330,
        linen: 16445670,
        magenta: 16711935,
        maroon: 8388608,
        mediumaquamarine: 6737322,
        mediumblue: 205,
        mediumorchid: 12211667,
        mediumpurple: 9662683,
        mediumseagreen: 3978097,
        mediumslateblue: 8087790,
        mediumspringgreen: 64154,
        mediumturquoise: 4772300,
        mediumvioletred: 13047173,
        midnightblue: 1644912,
        mintcream: 16121850,
        mistyrose: 16770273,
        moccasin: 16770229,
        navajowhite: 16768685,
        navy: 128,
        oldlace: 16643558,
        olive: 8421376,
        olivedrab: 7048739,
        orange: 16753920,
        orangered: 16729344,
        orchid: 14315734,
        palegoldenrod: 15657130,
        palegreen: 10025880,
        paleturquoise: 11529966,
        palevioletred: 14381203,
        papayawhip: 16773077,
        peachpuff: 16767673,
        peru: 13468991,
        pink: 16761035,
        plum: 14524637,
        powderblue: 11591910,
        purple: 8388736,
        rebeccapurple: 6697881,
        red: 16711680,
        rosybrown: 12357519,
        royalblue: 4286945,
        saddlebrown: 9127187,
        salmon: 16416882,
        sandybrown: 16032864,
        seagreen: 3050327,
        seashell: 16774638,
        sienna: 10506797,
        silver: 12632256,
        skyblue: 8900331,
        slateblue: 6970061,
        slategray: 7372944,
        slategrey: 7372944,
        snow: 16775930,
        springgreen: 65407,
        steelblue: 4620980,
        tan: 13808780,
        teal: 32896,
        thistle: 14204888,
        tomato: 16737095,
        turquoise: 4251856,
        violet: 15631086,
        wheat: 16113331,
        white: 16777215,
        whitesmoke: 16119285,
        yellow: 16776960,
        yellowgreen: 10145074
      });
      d3_rgb_names.forEach(function(key, value) {
        d3_rgb_names.set(key, d3_rgbNumber(value));
      });
      function d3_functor(v) {
        return typeof v === "function" ? v : function() {
          return v;
        };
      }
      d3.functor = d3_functor;
      d3.xhr = d3_xhrType(d3_identity);
      function d3_xhrType(response) {
        return function(url, mimeType, callback) {
          if (arguments.length === 2 && typeof mimeType === "function") callback = mimeType, mimeType = null;
          return d3_xhr(url, mimeType, response, callback);
        };
      }
      function d3_xhr(url, mimeType, response, callback) {
        var xhr = {}, dispatch = d3.dispatch("beforesend", "progress", "load", "error"), headers = {}, request = new XMLHttpRequest(), responseType = null;
        if (self.XDomainRequest && !("withCredentials" in request) && /^(http(s)?:)?\/\//.test(url)) request = new XDomainRequest();
        "onload" in request ? request.onload = request.onerror = respond : request.onreadystatechange = function() {
          request.readyState > 3 && respond();
        };
        function respond() {
          var status = request.status, result;
          if (!status && d3_xhrHasResponse(request) || status >= 200 && status < 300 || status === 304) {
            try {
              result = response.call(xhr, request);
            } catch (e) {
              dispatch.error.call(xhr, e);
              return;
            }
            dispatch.load.call(xhr, result);
          } else {
            dispatch.error.call(xhr, request);
          }
        }
        request.onprogress = function(event) {
          var o = d3.event;
          d3.event = event;
          try {
            dispatch.progress.call(xhr, request);
          } finally {
            d3.event = o;
          }
        };
        xhr.header = function(name, value) {
          name = (name + "").toLowerCase();
          if (arguments.length < 2) return headers[name];
          if (value == null) delete headers[name];
          else headers[name] = value + "";
          return xhr;
        };
        xhr.mimeType = function(value) {
          if (!arguments.length) return mimeType;
          mimeType = value == null ? null : value + "";
          return xhr;
        };
        xhr.responseType = function(value) {
          if (!arguments.length) return responseType;
          responseType = value;
          return xhr;
        };
        xhr.response = function(value) {
          response = value;
          return xhr;
        };
        ["get", "post"].forEach(function(method) {
          xhr[method] = function() {
            return xhr.send.apply(xhr, [method].concat(d3_array(arguments)));
          };
        });
        xhr.send = function(method, data, callback2) {
          if (arguments.length === 2 && typeof data === "function") callback2 = data, data = null;
          request.open(method, url, true);
          if (mimeType != null && !("accept" in headers)) headers["accept"] = mimeType + ",*/*";
          if (request.setRequestHeader) for (var name in headers) request.setRequestHeader(name, headers[name]);
          if (mimeType != null && request.overrideMimeType) request.overrideMimeType(mimeType);
          if (responseType != null) request.responseType = responseType;
          if (callback2 != null) xhr.on("error", callback2).on("load", function(request2) {
            callback2(null, request2);
          });
          dispatch.beforesend.call(xhr, request);
          request.send(data == null ? null : data);
          return xhr;
        };
        xhr.abort = function() {
          request.abort();
          return xhr;
        };
        d3.rebind(xhr, dispatch, "on");
        return callback == null ? xhr : xhr.get(d3_xhr_fixCallback(callback));
      }
      function d3_xhr_fixCallback(callback) {
        return callback.length === 1 ? function(error, request) {
          callback(error == null ? request : null);
        } : callback;
      }
      function d3_xhrHasResponse(request) {
        var type = request.responseType;
        return type && type !== "text" ? request.response : request.responseText;
      }
      d3.dsv = function(delimiter, mimeType) {
        var reFormat = new RegExp('["' + delimiter + "\n]"), delimiterCode = delimiter.charCodeAt(0);
        function dsv(url, row, callback) {
          if (arguments.length < 3) callback = row, row = null;
          var xhr = d3_xhr(url, mimeType, row == null ? response : typedResponse(row), callback);
          xhr.row = function(_) {
            return arguments.length ? xhr.response((row = _) == null ? response : typedResponse(_)) : row;
          };
          return xhr;
        }
        function response(request) {
          return dsv.parse(request.responseText);
        }
        function typedResponse(f) {
          return function(request) {
            return dsv.parse(request.responseText, f);
          };
        }
        dsv.parse = function(text, f) {
          var o;
          return dsv.parseRows(text, function(row, i) {
            if (o) return o(row, i - 1);
            var a = function(d) {
              var obj = {};
              var len = row.length;
              for (var k = 0; k < len; ++k) {
                obj[row[k]] = d[k];
              }
              return obj;
            };
            o = f ? function(row2, i2) {
              return f(a(row2), i2);
            } : a;
          });
        };
        dsv.parseRows = function(text, f) {
          var EOL = {}, EOF = {}, rows = [], N = text.length, I = 0, n = 0, t, eol;
          function token() {
            if (I >= N) return EOF;
            if (eol) return eol = false, EOL;
            var j = I;
            if (text.charCodeAt(j) === 34) {
              var i = j;
              while (i++ < N) {
                if (text.charCodeAt(i) === 34) {
                  if (text.charCodeAt(i + 1) !== 34) break;
                  ++i;
                }
              }
              I = i + 2;
              var c = text.charCodeAt(i + 1);
              if (c === 13) {
                eol = true;
                if (text.charCodeAt(i + 2) === 10) ++I;
              } else if (c === 10) {
                eol = true;
              }
              return text.slice(j + 1, i).replace(/""/g, '"');
            }
            while (I < N) {
              var c = text.charCodeAt(I++), k = 1;
              if (c === 10) eol = true;
              else if (c === 13) {
                eol = true;
                if (text.charCodeAt(I) === 10) ++I, ++k;
              } else if (c !== delimiterCode) continue;
              return text.slice(j, I - k);
            }
            return text.slice(j);
          }
          while ((t = token()) !== EOF) {
            var a = [];
            while (t !== EOL && t !== EOF) {
              a.push(t);
              t = token();
            }
            if (f && (a = f(a, n++)) == null) continue;
            rows.push(a);
          }
          return rows;
        };
        dsv.format = function(rows) {
          if (Array.isArray(rows[0])) return dsv.formatRows(rows);
          var fieldSet = new d3_Set(), fields = [];
          rows.forEach(function(row) {
            for (var field in row) {
              if (!fieldSet.has(field)) {
                fields.push(fieldSet.add(field));
              }
            }
          });
          return [fields.map(formatValue).join(delimiter)].concat(rows.map(function(row) {
            return fields.map(function(field) {
              return formatValue(row[field]);
            }).join(delimiter);
          })).join("\n");
        };
        dsv.formatRows = function(rows) {
          return rows.map(formatRow).join("\n");
        };
        function formatRow(row) {
          return row.map(formatValue).join(delimiter);
        }
        function formatValue(text) {
          return reFormat.test(text) ? '"' + text.replace(/\"/g, '""') + '"' : text;
        }
        return dsv;
      };
      d3.csv = d3.dsv(",", "text/csv");
      d3.tsv = d3.dsv("	", "text/tab-separated-values");
      var d3_timer_queueHead, d3_timer_queueTail, d3_timer_interval, d3_timer_timeout, d3_timer_frame = this[d3_vendorSymbol(this, "requestAnimationFrame")] || function(callback) {
        setTimeout(callback, 17);
      };
      d3.timer = function() {
        d3_timer.apply(this, arguments);
      };
      function d3_timer(callback, delay, then) {
        var n = arguments.length;
        if (n < 2) delay = 0;
        if (n < 3) then = Date.now();
        var time = then + delay, timer = {
          c: callback,
          t: time,
          n: null
        };
        if (d3_timer_queueTail) d3_timer_queueTail.n = timer;
        else d3_timer_queueHead = timer;
        d3_timer_queueTail = timer;
        if (!d3_timer_interval) {
          d3_timer_timeout = clearTimeout(d3_timer_timeout);
          d3_timer_interval = 1;
          d3_timer_frame(d3_timer_step);
        }
        return timer;
      }
      function d3_timer_step() {
        var now = d3_timer_mark(), delay = d3_timer_sweep() - now;
        if (delay > 24) {
          if (isFinite(delay)) {
            clearTimeout(d3_timer_timeout);
            d3_timer_timeout = setTimeout(d3_timer_step, delay);
          }
          d3_timer_interval = 0;
        } else {
          d3_timer_interval = 1;
          d3_timer_frame(d3_timer_step);
        }
      }
      d3.timer.flush = function() {
        d3_timer_mark();
        d3_timer_sweep();
      };
      function d3_timer_mark() {
        var now = Date.now(), timer = d3_timer_queueHead;
        while (timer) {
          if (now >= timer.t && timer.c(now - timer.t)) timer.c = null;
          timer = timer.n;
        }
        return now;
      }
      function d3_timer_sweep() {
        var t03, t13 = d3_timer_queueHead, time = Infinity;
        while (t13) {
          if (t13.c) {
            if (t13.t < time) time = t13.t;
            t13 = (t03 = t13).n;
          } else {
            t13 = t03 ? t03.n = t13.n : d3_timer_queueHead = t13.n;
          }
        }
        d3_timer_queueTail = t03;
        return time;
      }
      d3.round = function(x, n) {
        return n ? Math.round(x * (n = Math.pow(10, n))) / n : Math.round(x);
      };
      d3.geom = {};
      function d3_geom_pointX(d) {
        return d[0];
      }
      function d3_geom_pointY(d) {
        return d[1];
      }
      d3.geom.hull = function(vertices) {
        var x = d3_geom_pointX, y = d3_geom_pointY;
        if (arguments.length) return hull(vertices);
        function hull(data) {
          if (data.length < 3) return [];
          var fx = d3_functor(x), fy = d3_functor(y), i, n = data.length, points = [], flippedPoints = [];
          for (i = 0; i < n; i++) {
            points.push([+fx.call(this, data[i], i), +fy.call(this, data[i], i), i]);
          }
          points.sort(d3_geom_hullOrder);
          for (i = 0; i < n; i++) flippedPoints.push([points[i][0], -points[i][1]]);
          var upper = d3_geom_hullUpper(points), lower = d3_geom_hullUpper(flippedPoints);
          var skipLeft = lower[0] === upper[0], skipRight = lower[lower.length - 1] === upper[upper.length - 1], polygon = [];
          for (i = upper.length - 1; i >= 0; --i) polygon.push(data[points[upper[i]][2]]);
          for (i = +skipLeft; i < lower.length - skipRight; ++i) polygon.push(data[points[lower[i]][2]]);
          return polygon;
        }
        hull.x = function(_) {
          return arguments.length ? (x = _, hull) : x;
        };
        hull.y = function(_) {
          return arguments.length ? (y = _, hull) : y;
        };
        return hull;
      };
      function d3_geom_hullUpper(points) {
        var n = points.length, hull = [0, 1], hs2 = 2;
        for (var i = 2; i < n; i++) {
          while (hs2 > 1 && d3_cross2d(points[hull[hs2 - 2]], points[hull[hs2 - 1]], points[i]) <= 0) --hs2;
          hull[hs2++] = i;
        }
        return hull.slice(0, hs2);
      }
      function d3_geom_hullOrder(a, b) {
        return a[0] - b[0] || a[1] - b[1];
      }
      d3.geom.polygon = function(coordinates) {
        d3_subclass(coordinates, d3_geom_polygonPrototype);
        return coordinates;
      };
      var d3_geom_polygonPrototype = d3.geom.polygon.prototype = [];
      d3_geom_polygonPrototype.area = function() {
        var i = -1, n = this.length, a, b = this[n - 1], area = 0;
        while (++i < n) {
          a = b;
          b = this[i];
          area += a[1] * b[0] - a[0] * b[1];
        }
        return area * 0.5;
      };
      d3_geom_polygonPrototype.centroid = function(k) {
        var i = -1, n = this.length, x = 0, y = 0, a, b = this[n - 1], c;
        if (!arguments.length) k = -1 / (6 * this.area());
        while (++i < n) {
          a = b;
          b = this[i];
          c = a[0] * b[1] - b[0] * a[1];
          x += (a[0] + b[0]) * c;
          y += (a[1] + b[1]) * c;
        }
        return [x * k, y * k];
      };
      d3_geom_polygonPrototype.clip = function(subject) {
        var input, closed = d3_geom_polygonClosed(subject), i = -1, n = this.length - d3_geom_polygonClosed(this), j, m, a = this[n - 1], b, c, d;
        while (++i < n) {
          input = subject.slice();
          subject.length = 0;
          b = this[i];
          c = input[(m = input.length - closed) - 1];
          j = -1;
          while (++j < m) {
            d = input[j];
            if (d3_geom_polygonInside(d, a, b)) {
              if (!d3_geom_polygonInside(c, a, b)) {
                subject.push(d3_geom_polygonIntersect(c, d, a, b));
              }
              subject.push(d);
            } else if (d3_geom_polygonInside(c, a, b)) {
              subject.push(d3_geom_polygonIntersect(c, d, a, b));
            }
            c = d;
          }
          if (closed) subject.push(subject[0]);
          a = b;
        }
        return subject;
      };
      function d3_geom_polygonInside(p, a, b) {
        return (b[0] - a[0]) * (p[1] - a[1]) < (b[1] - a[1]) * (p[0] - a[0]);
      }
      function d3_geom_polygonIntersect(c, d, a, b) {
        var x12 = c[0], x3 = a[0], x21 = d[0] - x12, x43 = b[0] - x3, y12 = c[1], y3 = a[1], y21 = d[1] - y12, y43 = b[1] - y3, ua2 = (x43 * (y12 - y3) - y43 * (x12 - x3)) / (y43 * x21 - x43 * y21);
        return [x12 + ua2 * x21, y12 + ua2 * y21];
      }
      function d3_geom_polygonClosed(coordinates) {
        var a = coordinates[0], b = coordinates[coordinates.length - 1];
        return !(a[0] - b[0] || a[1] - b[1]);
      }
      var d3_geom_voronoiEdges, d3_geom_voronoiCells, d3_geom_voronoiBeaches, d3_geom_voronoiBeachPool = [], d3_geom_voronoiFirstCircle, d3_geom_voronoiCircles, d3_geom_voronoiCirclePool = [];
      function d3_geom_voronoiBeach() {
        d3_geom_voronoiRedBlackNode(this);
        this.edge = this.site = this.circle = null;
      }
      function d3_geom_voronoiCreateBeach(site) {
        var beach = d3_geom_voronoiBeachPool.pop() || new d3_geom_voronoiBeach();
        beach.site = site;
        return beach;
      }
      function d3_geom_voronoiDetachBeach(beach) {
        d3_geom_voronoiDetachCircle(beach);
        d3_geom_voronoiBeaches.remove(beach);
        d3_geom_voronoiBeachPool.push(beach);
        d3_geom_voronoiRedBlackNode(beach);
      }
      function d3_geom_voronoiRemoveBeach(beach) {
        var circle = beach.circle, x = circle.x, y = circle.cy, vertex = {
          x,
          y
        }, previous = beach.P, next = beach.N, disappearing = [beach];
        d3_geom_voronoiDetachBeach(beach);
        var lArc = previous;
        while (lArc.circle && abs(x - lArc.circle.x) < ε && abs(y - lArc.circle.cy) < ε) {
          previous = lArc.P;
          disappearing.unshift(lArc);
          d3_geom_voronoiDetachBeach(lArc);
          lArc = previous;
        }
        disappearing.unshift(lArc);
        d3_geom_voronoiDetachCircle(lArc);
        var rArc = next;
        while (rArc.circle && abs(x - rArc.circle.x) < ε && abs(y - rArc.circle.cy) < ε) {
          next = rArc.N;
          disappearing.push(rArc);
          d3_geom_voronoiDetachBeach(rArc);
          rArc = next;
        }
        disappearing.push(rArc);
        d3_geom_voronoiDetachCircle(rArc);
        var nArcs = disappearing.length, iArc;
        for (iArc = 1; iArc < nArcs; ++iArc) {
          rArc = disappearing[iArc];
          lArc = disappearing[iArc - 1];
          d3_geom_voronoiSetEdgeEnd(rArc.edge, lArc.site, rArc.site, vertex);
        }
        lArc = disappearing[0];
        rArc = disappearing[nArcs - 1];
        rArc.edge = d3_geom_voronoiCreateEdge(lArc.site, rArc.site, null, vertex);
        d3_geom_voronoiAttachCircle(lArc);
        d3_geom_voronoiAttachCircle(rArc);
      }
      function d3_geom_voronoiAddBeach(site) {
        var x = site.x, directrix = site.y, lArc, rArc, dxl, dxr, node = d3_geom_voronoiBeaches._;
        while (node) {
          dxl = d3_geom_voronoiLeftBreakPoint(node, directrix) - x;
          if (dxl > ε) node = node.L;
          else {
            dxr = x - d3_geom_voronoiRightBreakPoint(node, directrix);
            if (dxr > ε) {
              if (!node.R) {
                lArc = node;
                break;
              }
              node = node.R;
            } else {
              if (dxl > -ε) {
                lArc = node.P;
                rArc = node;
              } else if (dxr > -ε) {
                lArc = node;
                rArc = node.N;
              } else {
                lArc = rArc = node;
              }
              break;
            }
          }
        }
        var newArc = d3_geom_voronoiCreateBeach(site);
        d3_geom_voronoiBeaches.insert(lArc, newArc);
        if (!lArc && !rArc) return;
        if (lArc === rArc) {
          d3_geom_voronoiDetachCircle(lArc);
          rArc = d3_geom_voronoiCreateBeach(lArc.site);
          d3_geom_voronoiBeaches.insert(newArc, rArc);
          newArc.edge = rArc.edge = d3_geom_voronoiCreateEdge(lArc.site, newArc.site);
          d3_geom_voronoiAttachCircle(lArc);
          d3_geom_voronoiAttachCircle(rArc);
          return;
        }
        if (!rArc) {
          newArc.edge = d3_geom_voronoiCreateEdge(lArc.site, newArc.site);
          return;
        }
        d3_geom_voronoiDetachCircle(lArc);
        d3_geom_voronoiDetachCircle(rArc);
        var lSite = lArc.site, ax = lSite.x, ay = lSite.y, bx = site.x - ax, by = site.y - ay, rSite = rArc.site, cx = rSite.x - ax, cy = rSite.y - ay, d = 2 * (bx * cy - by * cx), hb = bx * bx + by * by, hc2 = cx * cx + cy * cy, vertex = {
          x: (cy * hb - by * hc2) / d + ax,
          y: (bx * hc2 - cx * hb) / d + ay
        };
        d3_geom_voronoiSetEdgeEnd(rArc.edge, lSite, rSite, vertex);
        newArc.edge = d3_geom_voronoiCreateEdge(lSite, site, null, vertex);
        rArc.edge = d3_geom_voronoiCreateEdge(site, rSite, null, vertex);
        d3_geom_voronoiAttachCircle(lArc);
        d3_geom_voronoiAttachCircle(rArc);
      }
      function d3_geom_voronoiLeftBreakPoint(arc, directrix) {
        var site = arc.site, rfocx = site.x, rfocy = site.y, pby2 = rfocy - directrix;
        if (!pby2) return rfocx;
        var lArc = arc.P;
        if (!lArc) return -Infinity;
        site = lArc.site;
        var lfocx = site.x, lfocy = site.y, plby2 = lfocy - directrix;
        if (!plby2) return lfocx;
        var hl = lfocx - rfocx, aby2 = 1 / pby2 - 1 / plby2, b = hl / plby2;
        if (aby2) return (-b + Math.sqrt(b * b - 2 * aby2 * (hl * hl / (-2 * plby2) - lfocy + plby2 / 2 + rfocy - pby2 / 2))) / aby2 + rfocx;
        return (rfocx + lfocx) / 2;
      }
      function d3_geom_voronoiRightBreakPoint(arc, directrix) {
        var rArc = arc.N;
        if (rArc) return d3_geom_voronoiLeftBreakPoint(rArc, directrix);
        var site = arc.site;
        return site.y === directrix ? site.x : Infinity;
      }
      function d3_geom_voronoiCell(site) {
        this.site = site;
        this.edges = [];
      }
      d3_geom_voronoiCell.prototype.prepare = function() {
        var halfEdges = this.edges, iHalfEdge = halfEdges.length, edge;
        while (iHalfEdge--) {
          edge = halfEdges[iHalfEdge].edge;
          if (!edge.b || !edge.a) halfEdges.splice(iHalfEdge, 1);
        }
        halfEdges.sort(d3_geom_voronoiHalfEdgeOrder);
        return halfEdges.length;
      };
      function d3_geom_voronoiCloseCells(extent) {
        var x02 = extent[0][0], x12 = extent[1][0], y02 = extent[0][1], y12 = extent[1][1], x2, y2, x3, y3, cells = d3_geom_voronoiCells, iCell = cells.length, cell, iHalfEdge, halfEdges, nHalfEdges, start, end;
        while (iCell--) {
          cell = cells[iCell];
          if (!cell || !cell.prepare()) continue;
          halfEdges = cell.edges;
          nHalfEdges = halfEdges.length;
          iHalfEdge = 0;
          while (iHalfEdge < nHalfEdges) {
            end = halfEdges[iHalfEdge].end(), x3 = end.x, y3 = end.y;
            start = halfEdges[++iHalfEdge % nHalfEdges].start(), x2 = start.x, y2 = start.y;
            if (abs(x3 - x2) > ε || abs(y3 - y2) > ε) {
              halfEdges.splice(iHalfEdge, 0, new d3_geom_voronoiHalfEdge(d3_geom_voronoiCreateBorderEdge(cell.site, end, abs(x3 - x02) < ε && y12 - y3 > ε ? {
                x: x02,
                y: abs(x2 - x02) < ε ? y2 : y12
              } : abs(y3 - y12) < ε && x12 - x3 > ε ? {
                x: abs(y2 - y12) < ε ? x2 : x12,
                y: y12
              } : abs(x3 - x12) < ε && y3 - y02 > ε ? {
                x: x12,
                y: abs(x2 - x12) < ε ? y2 : y02
              } : abs(y3 - y02) < ε && x3 - x02 > ε ? {
                x: abs(y2 - y02) < ε ? x2 : x02,
                y: y02
              } : null), cell.site, null));
              ++nHalfEdges;
            }
          }
        }
      }
      function d3_geom_voronoiHalfEdgeOrder(a, b) {
        return b.angle - a.angle;
      }
      function d3_geom_voronoiCircle() {
        d3_geom_voronoiRedBlackNode(this);
        this.x = this.y = this.arc = this.site = this.cy = null;
      }
      function d3_geom_voronoiAttachCircle(arc) {
        var lArc = arc.P, rArc = arc.N;
        if (!lArc || !rArc) return;
        var lSite = lArc.site, cSite = arc.site, rSite = rArc.site;
        if (lSite === rSite) return;
        var bx = cSite.x, by = cSite.y, ax = lSite.x - bx, ay = lSite.y - by, cx = rSite.x - bx, cy = rSite.y - by;
        var d = 2 * (ax * cy - ay * cx);
        if (d >= -ε2) return;
        var ha2 = ax * ax + ay * ay, hc2 = cx * cx + cy * cy, x = (cy * ha2 - ay * hc2) / d, y = (ax * hc2 - cx * ha2) / d, cy = y + by;
        var circle = d3_geom_voronoiCirclePool.pop() || new d3_geom_voronoiCircle();
        circle.arc = arc;
        circle.site = cSite;
        circle.x = x + bx;
        circle.y = cy + Math.sqrt(x * x + y * y);
        circle.cy = cy;
        arc.circle = circle;
        var before = null, node = d3_geom_voronoiCircles._;
        while (node) {
          if (circle.y < node.y || circle.y === node.y && circle.x <= node.x) {
            if (node.L) node = node.L;
            else {
              before = node.P;
              break;
            }
          } else {
            if (node.R) node = node.R;
            else {
              before = node;
              break;
            }
          }
        }
        d3_geom_voronoiCircles.insert(before, circle);
        if (!before) d3_geom_voronoiFirstCircle = circle;
      }
      function d3_geom_voronoiDetachCircle(arc) {
        var circle = arc.circle;
        if (circle) {
          if (!circle.P) d3_geom_voronoiFirstCircle = circle.N;
          d3_geom_voronoiCircles.remove(circle);
          d3_geom_voronoiCirclePool.push(circle);
          d3_geom_voronoiRedBlackNode(circle);
          arc.circle = null;
        }
      }
      function d3_geom_clipLine(x02, y02, x12, y12) {
        return function(line) {
          var a = line.a, b = line.b, ax = a.x, ay = a.y, bx = b.x, by = b.y, t03 = 0, t13 = 1, dx = bx - ax, dy = by - ay, r;
          r = x02 - ax;
          if (!dx && r > 0) return;
          r /= dx;
          if (dx < 0) {
            if (r < t03) return;
            if (r < t13) t13 = r;
          } else if (dx > 0) {
            if (r > t13) return;
            if (r > t03) t03 = r;
          }
          r = x12 - ax;
          if (!dx && r < 0) return;
          r /= dx;
          if (dx < 0) {
            if (r > t13) return;
            if (r > t03) t03 = r;
          } else if (dx > 0) {
            if (r < t03) return;
            if (r < t13) t13 = r;
          }
          r = y02 - ay;
          if (!dy && r > 0) return;
          r /= dy;
          if (dy < 0) {
            if (r < t03) return;
            if (r < t13) t13 = r;
          } else if (dy > 0) {
            if (r > t13) return;
            if (r > t03) t03 = r;
          }
          r = y12 - ay;
          if (!dy && r < 0) return;
          r /= dy;
          if (dy < 0) {
            if (r > t13) return;
            if (r > t03) t03 = r;
          } else if (dy > 0) {
            if (r < t03) return;
            if (r < t13) t13 = r;
          }
          if (t03 > 0) line.a = {
            x: ax + t03 * dx,
            y: ay + t03 * dy
          };
          if (t13 < 1) line.b = {
            x: ax + t13 * dx,
            y: ay + t13 * dy
          };
          return line;
        };
      }
      function d3_geom_voronoiClipEdges(extent) {
        var edges = d3_geom_voronoiEdges, clip = d3_geom_clipLine(extent[0][0], extent[0][1], extent[1][0], extent[1][1]), i = edges.length, e;
        while (i--) {
          e = edges[i];
          if (!d3_geom_voronoiConnectEdge(e, extent) || !clip(e) || abs(e.a.x - e.b.x) < ε && abs(e.a.y - e.b.y) < ε) {
            e.a = e.b = null;
            edges.splice(i, 1);
          }
        }
      }
      function d3_geom_voronoiConnectEdge(edge, extent) {
        var vb = edge.b;
        if (vb) return true;
        var va2 = edge.a, x02 = extent[0][0], x12 = extent[1][0], y02 = extent[0][1], y12 = extent[1][1], lSite = edge.l, rSite = edge.r, lx = lSite.x, ly = lSite.y, rx = rSite.x, ry = rSite.y, fx = (lx + rx) / 2, fy = (ly + ry) / 2, fm, fb;
        if (ry === ly) {
          if (fx < x02 || fx >= x12) return;
          if (lx > rx) {
            if (!va2) va2 = {
              x: fx,
              y: y02
            };
            else if (va2.y >= y12) return;
            vb = {
              x: fx,
              y: y12
            };
          } else {
            if (!va2) va2 = {
              x: fx,
              y: y12
            };
            else if (va2.y < y02) return;
            vb = {
              x: fx,
              y: y02
            };
          }
        } else {
          fm = (lx - rx) / (ry - ly);
          fb = fy - fm * fx;
          if (fm < -1 || fm > 1) {
            if (lx > rx) {
              if (!va2) va2 = {
                x: (y02 - fb) / fm,
                y: y02
              };
              else if (va2.y >= y12) return;
              vb = {
                x: (y12 - fb) / fm,
                y: y12
              };
            } else {
              if (!va2) va2 = {
                x: (y12 - fb) / fm,
                y: y12
              };
              else if (va2.y < y02) return;
              vb = {
                x: (y02 - fb) / fm,
                y: y02
              };
            }
          } else {
            if (ly < ry) {
              if (!va2) va2 = {
                x: x02,
                y: fm * x02 + fb
              };
              else if (va2.x >= x12) return;
              vb = {
                x: x12,
                y: fm * x12 + fb
              };
            } else {
              if (!va2) va2 = {
                x: x12,
                y: fm * x12 + fb
              };
              else if (va2.x < x02) return;
              vb = {
                x: x02,
                y: fm * x02 + fb
              };
            }
          }
        }
        edge.a = va2;
        edge.b = vb;
        return true;
      }
      function d3_geom_voronoiEdge(lSite, rSite) {
        this.l = lSite;
        this.r = rSite;
        this.a = this.b = null;
      }
      function d3_geom_voronoiCreateEdge(lSite, rSite, va2, vb) {
        var edge = new d3_geom_voronoiEdge(lSite, rSite);
        d3_geom_voronoiEdges.push(edge);
        if (va2) d3_geom_voronoiSetEdgeEnd(edge, lSite, rSite, va2);
        if (vb) d3_geom_voronoiSetEdgeEnd(edge, rSite, lSite, vb);
        d3_geom_voronoiCells[lSite.i].edges.push(new d3_geom_voronoiHalfEdge(edge, lSite, rSite));
        d3_geom_voronoiCells[rSite.i].edges.push(new d3_geom_voronoiHalfEdge(edge, rSite, lSite));
        return edge;
      }
      function d3_geom_voronoiCreateBorderEdge(lSite, va2, vb) {
        var edge = new d3_geom_voronoiEdge(lSite, null);
        edge.a = va2;
        edge.b = vb;
        d3_geom_voronoiEdges.push(edge);
        return edge;
      }
      function d3_geom_voronoiSetEdgeEnd(edge, lSite, rSite, vertex) {
        if (!edge.a && !edge.b) {
          edge.a = vertex;
          edge.l = lSite;
          edge.r = rSite;
        } else if (edge.l === rSite) {
          edge.b = vertex;
        } else {
          edge.a = vertex;
        }
      }
      function d3_geom_voronoiHalfEdge(edge, lSite, rSite) {
        var va2 = edge.a, vb = edge.b;
        this.edge = edge;
        this.site = lSite;
        this.angle = rSite ? Math.atan2(rSite.y - lSite.y, rSite.x - lSite.x) : edge.l === lSite ? Math.atan2(vb.x - va2.x, va2.y - vb.y) : Math.atan2(va2.x - vb.x, vb.y - va2.y);
      }
      d3_geom_voronoiHalfEdge.prototype = {
        start: function() {
          return this.edge.l === this.site ? this.edge.a : this.edge.b;
        },
        end: function() {
          return this.edge.l === this.site ? this.edge.b : this.edge.a;
        }
      };
      function d3_geom_voronoiRedBlackTree() {
        this._ = null;
      }
      function d3_geom_voronoiRedBlackNode(node) {
        node.U = node.C = node.L = node.R = node.P = node.N = null;
      }
      d3_geom_voronoiRedBlackTree.prototype = {
        insert: function(after, node) {
          var parent, grandpa, uncle;
          if (after) {
            node.P = after;
            node.N = after.N;
            if (after.N) after.N.P = node;
            after.N = node;
            if (after.R) {
              after = after.R;
              while (after.L) after = after.L;
              after.L = node;
            } else {
              after.R = node;
            }
            parent = after;
          } else if (this._) {
            after = d3_geom_voronoiRedBlackFirst(this._);
            node.P = null;
            node.N = after;
            after.P = after.L = node;
            parent = after;
          } else {
            node.P = node.N = null;
            this._ = node;
            parent = null;
          }
          node.L = node.R = null;
          node.U = parent;
          node.C = true;
          after = node;
          while (parent && parent.C) {
            grandpa = parent.U;
            if (parent === grandpa.L) {
              uncle = grandpa.R;
              if (uncle && uncle.C) {
                parent.C = uncle.C = false;
                grandpa.C = true;
                after = grandpa;
              } else {
                if (after === parent.R) {
                  d3_geom_voronoiRedBlackRotateLeft(this, parent);
                  after = parent;
                  parent = after.U;
                }
                parent.C = false;
                grandpa.C = true;
                d3_geom_voronoiRedBlackRotateRight(this, grandpa);
              }
            } else {
              uncle = grandpa.L;
              if (uncle && uncle.C) {
                parent.C = uncle.C = false;
                grandpa.C = true;
                after = grandpa;
              } else {
                if (after === parent.L) {
                  d3_geom_voronoiRedBlackRotateRight(this, parent);
                  after = parent;
                  parent = after.U;
                }
                parent.C = false;
                grandpa.C = true;
                d3_geom_voronoiRedBlackRotateLeft(this, grandpa);
              }
            }
            parent = after.U;
          }
          this._.C = false;
        },
        remove: function(node) {
          if (node.N) node.N.P = node.P;
          if (node.P) node.P.N = node.N;
          node.N = node.P = null;
          var parent = node.U, sibling, left = node.L, right = node.R, next, red;
          if (!left) next = right;
          else if (!right) next = left;
          else next = d3_geom_voronoiRedBlackFirst(right);
          if (parent) {
            if (parent.L === node) parent.L = next;
            else parent.R = next;
          } else {
            this._ = next;
          }
          if (left && right) {
            red = next.C;
            next.C = node.C;
            next.L = left;
            left.U = next;
            if (next !== right) {
              parent = next.U;
              next.U = node.U;
              node = next.R;
              parent.L = node;
              next.R = right;
              right.U = next;
            } else {
              next.U = parent;
              parent = next;
              node = next.R;
            }
          } else {
            red = node.C;
            node = next;
          }
          if (node) node.U = parent;
          if (red) return;
          if (node && node.C) {
            node.C = false;
            return;
          }
          do {
            if (node === this._) break;
            if (node === parent.L) {
              sibling = parent.R;
              if (sibling.C) {
                sibling.C = false;
                parent.C = true;
                d3_geom_voronoiRedBlackRotateLeft(this, parent);
                sibling = parent.R;
              }
              if (sibling.L && sibling.L.C || sibling.R && sibling.R.C) {
                if (!sibling.R || !sibling.R.C) {
                  sibling.L.C = false;
                  sibling.C = true;
                  d3_geom_voronoiRedBlackRotateRight(this, sibling);
                  sibling = parent.R;
                }
                sibling.C = parent.C;
                parent.C = sibling.R.C = false;
                d3_geom_voronoiRedBlackRotateLeft(this, parent);
                node = this._;
                break;
              }
            } else {
              sibling = parent.L;
              if (sibling.C) {
                sibling.C = false;
                parent.C = true;
                d3_geom_voronoiRedBlackRotateRight(this, parent);
                sibling = parent.L;
              }
              if (sibling.L && sibling.L.C || sibling.R && sibling.R.C) {
                if (!sibling.L || !sibling.L.C) {
                  sibling.R.C = false;
                  sibling.C = true;
                  d3_geom_voronoiRedBlackRotateLeft(this, sibling);
                  sibling = parent.L;
                }
                sibling.C = parent.C;
                parent.C = sibling.L.C = false;
                d3_geom_voronoiRedBlackRotateRight(this, parent);
                node = this._;
                break;
              }
            }
            sibling.C = true;
            node = parent;
            parent = parent.U;
          } while (!node.C);
          if (node) node.C = false;
        }
      };
      function d3_geom_voronoiRedBlackRotateLeft(tree, node) {
        var p = node, q = node.R, parent = p.U;
        if (parent) {
          if (parent.L === p) parent.L = q;
          else parent.R = q;
        } else {
          tree._ = q;
        }
        q.U = parent;
        p.U = q;
        p.R = q.L;
        if (p.R) p.R.U = p;
        q.L = p;
      }
      function d3_geom_voronoiRedBlackRotateRight(tree, node) {
        var p = node, q = node.L, parent = p.U;
        if (parent) {
          if (parent.L === p) parent.L = q;
          else parent.R = q;
        } else {
          tree._ = q;
        }
        q.U = parent;
        p.U = q;
        p.L = q.R;
        if (p.L) p.L.U = p;
        q.R = p;
      }
      function d3_geom_voronoiRedBlackFirst(node) {
        while (node.L) node = node.L;
        return node;
      }
      function d3_geom_voronoi(sites, bbox) {
        var site = sites.sort(d3_geom_voronoiVertexOrder).pop(), x02, y02, circle;
        d3_geom_voronoiEdges = [];
        d3_geom_voronoiCells = new Array(sites.length);
        d3_geom_voronoiBeaches = new d3_geom_voronoiRedBlackTree();
        d3_geom_voronoiCircles = new d3_geom_voronoiRedBlackTree();
        while (true) {
          circle = d3_geom_voronoiFirstCircle;
          if (site && (!circle || site.y < circle.y || site.y === circle.y && site.x < circle.x)) {
            if (site.x !== x02 || site.y !== y02) {
              d3_geom_voronoiCells[site.i] = new d3_geom_voronoiCell(site);
              d3_geom_voronoiAddBeach(site);
              x02 = site.x, y02 = site.y;
            }
            site = sites.pop();
          } else if (circle) {
            d3_geom_voronoiRemoveBeach(circle.arc);
          } else {
            break;
          }
        }
        if (bbox) d3_geom_voronoiClipEdges(bbox), d3_geom_voronoiCloseCells(bbox);
        var diagram = {
          cells: d3_geom_voronoiCells,
          edges: d3_geom_voronoiEdges
        };
        d3_geom_voronoiBeaches = d3_geom_voronoiCircles = d3_geom_voronoiEdges = d3_geom_voronoiCells = null;
        return diagram;
      }
      function d3_geom_voronoiVertexOrder(a, b) {
        return b.y - a.y || b.x - a.x;
      }
      d3.geom.voronoi = function(points) {
        var x = d3_geom_pointX, y = d3_geom_pointY, fx = x, fy = y, clipExtent = d3_geom_voronoiClipExtent;
        if (points) return voronoi(points);
        function voronoi(data) {
          var polygons = new Array(data.length), x02 = clipExtent[0][0], y02 = clipExtent[0][1], x12 = clipExtent[1][0], y12 = clipExtent[1][1];
          d3_geom_voronoi(sites(data), clipExtent).cells.forEach(function(cell, i) {
            var edges = cell.edges, site = cell.site, polygon = polygons[i] = edges.length ? edges.map(function(e) {
              var s = e.start();
              return [s.x, s.y];
            }) : site.x >= x02 && site.x <= x12 && site.y >= y02 && site.y <= y12 ? [[x02, y12], [x12, y12], [x12, y02], [x02, y02]] : [];
            polygon.point = data[i];
          });
          return polygons;
        }
        function sites(data) {
          return data.map(function(d, i) {
            return {
              x: Math.round(fx(d, i) / ε) * ε,
              y: Math.round(fy(d, i) / ε) * ε,
              i
            };
          });
        }
        voronoi.links = function(data) {
          return d3_geom_voronoi(sites(data)).edges.filter(function(edge) {
            return edge.l && edge.r;
          }).map(function(edge) {
            return {
              source: data[edge.l.i],
              target: data[edge.r.i]
            };
          });
        };
        voronoi.triangles = function(data) {
          var triangles = [];
          d3_geom_voronoi(sites(data)).cells.forEach(function(cell, i) {
            var site = cell.site, edges = cell.edges.sort(d3_geom_voronoiHalfEdgeOrder), j = -1, m = edges.length, e02, s02, e12 = edges[m - 1].edge, s12 = e12.l === site ? e12.r : e12.l;
            while (++j < m) {
              e02 = e12;
              s02 = s12;
              e12 = edges[j].edge;
              s12 = e12.l === site ? e12.r : e12.l;
              if (i < s02.i && i < s12.i && d3_geom_voronoiTriangleArea(site, s02, s12) < 0) {
                triangles.push([data[i], data[s02.i], data[s12.i]]);
              }
            }
          });
          return triangles;
        };
        voronoi.x = function(_) {
          return arguments.length ? (fx = d3_functor(x = _), voronoi) : x;
        };
        voronoi.y = function(_) {
          return arguments.length ? (fy = d3_functor(y = _), voronoi) : y;
        };
        voronoi.clipExtent = function(_) {
          if (!arguments.length) return clipExtent === d3_geom_voronoiClipExtent ? null : clipExtent;
          clipExtent = _ == null ? d3_geom_voronoiClipExtent : _;
          return voronoi;
        };
        voronoi.size = function(_) {
          if (!arguments.length) return clipExtent === d3_geom_voronoiClipExtent ? null : clipExtent && clipExtent[1];
          return voronoi.clipExtent(_ && [[0, 0], _]);
        };
        return voronoi;
      };
      var d3_geom_voronoiClipExtent = [[-1e6, -1e6], [1e6, 1e6]];
      function d3_geom_voronoiTriangleArea(a, b, c) {
        return (a.x - c.x) * (b.y - a.y) - (a.x - b.x) * (c.y - a.y);
      }
      d3.geom.delaunay = function(vertices) {
        return d3.geom.voronoi().triangles(vertices);
      };
      d3.geom.quadtree = function(points, x12, y12, x2, y2) {
        var x = d3_geom_pointX, y = d3_geom_pointY, compat;
        if (compat = arguments.length) {
          x = d3_geom_quadtreeCompatX;
          y = d3_geom_quadtreeCompatY;
          if (compat === 3) {
            y2 = y12;
            x2 = x12;
            y12 = x12 = 0;
          }
          return quadtree(points);
        }
        function quadtree(data) {
          var d, fx = d3_functor(x), fy = d3_functor(y), xs2, ys2, i, n, x1_, y1_, x2_, y2_;
          if (x12 != null) {
            x1_ = x12, y1_ = y12, x2_ = x2, y2_ = y2;
          } else {
            x2_ = y2_ = -(x1_ = y1_ = Infinity);
            xs2 = [], ys2 = [];
            n = data.length;
            if (compat) for (i = 0; i < n; ++i) {
              d = data[i];
              if (d.x < x1_) x1_ = d.x;
              if (d.y < y1_) y1_ = d.y;
              if (d.x > x2_) x2_ = d.x;
              if (d.y > y2_) y2_ = d.y;
              xs2.push(d.x);
              ys2.push(d.y);
            }
            else for (i = 0; i < n; ++i) {
              var x_ = +fx(d = data[i], i), y_ = +fy(d, i);
              if (x_ < x1_) x1_ = x_;
              if (y_ < y1_) y1_ = y_;
              if (x_ > x2_) x2_ = x_;
              if (y_ > y2_) y2_ = y_;
              xs2.push(x_);
              ys2.push(y_);
            }
          }
          var dx = x2_ - x1_, dy = y2_ - y1_;
          if (dx > dy) y2_ = y1_ + dx;
          else x2_ = x1_ + dy;
          function insert(n2, d2, x3, y3, x13, y13, x22, y22) {
            if (isNaN(x3) || isNaN(y3)) return;
            if (n2.leaf) {
              var nx = n2.x, ny = n2.y;
              if (nx != null) {
                if (abs(nx - x3) + abs(ny - y3) < 0.01) {
                  insertChild(n2, d2, x3, y3, x13, y13, x22, y22);
                } else {
                  var nPoint = n2.point;
                  n2.x = n2.y = n2.point = null;
                  insertChild(n2, nPoint, nx, ny, x13, y13, x22, y22);
                  insertChild(n2, d2, x3, y3, x13, y13, x22, y22);
                }
              } else {
                n2.x = x3, n2.y = y3, n2.point = d2;
              }
            } else {
              insertChild(n2, d2, x3, y3, x13, y13, x22, y22);
            }
          }
          function insertChild(n2, d2, x3, y3, x13, y13, x22, y22) {
            var xm = (x13 + x22) * 0.5, ym = (y13 + y22) * 0.5, right = x3 >= xm, below = y3 >= ym, i2 = below << 1 | right;
            n2.leaf = false;
            n2 = n2.nodes[i2] || (n2.nodes[i2] = d3_geom_quadtreeNode());
            if (right) x13 = xm;
            else x22 = xm;
            if (below) y13 = ym;
            else y22 = ym;
            insert(n2, d2, x3, y3, x13, y13, x22, y22);
          }
          var root = d3_geom_quadtreeNode();
          root.add = function(d2) {
            insert(root, d2, +fx(d2, ++i), +fy(d2, i), x1_, y1_, x2_, y2_);
          };
          root.visit = function(f) {
            d3_geom_quadtreeVisit(f, root, x1_, y1_, x2_, y2_);
          };
          root.find = function(point) {
            return d3_geom_quadtreeFind(root, point[0], point[1], x1_, y1_, x2_, y2_);
          };
          i = -1;
          if (x12 == null) {
            while (++i < n) {
              insert(root, data[i], xs2[i], ys2[i], x1_, y1_, x2_, y2_);
            }
            --i;
          } else data.forEach(root.add);
          xs2 = ys2 = data = d = null;
          return root;
        }
        quadtree.x = function(_) {
          return arguments.length ? (x = _, quadtree) : x;
        };
        quadtree.y = function(_) {
          return arguments.length ? (y = _, quadtree) : y;
        };
        quadtree.extent = function(_) {
          if (!arguments.length) return x12 == null ? null : [[x12, y12], [x2, y2]];
          if (_ == null) x12 = y12 = x2 = y2 = null;
          else x12 = +_[0][0], y12 = +_[0][1], x2 = +_[1][0], y2 = +_[1][1];
          return quadtree;
        };
        quadtree.size = function(_) {
          if (!arguments.length) return x12 == null ? null : [x2 - x12, y2 - y12];
          if (_ == null) x12 = y12 = x2 = y2 = null;
          else x12 = y12 = 0, x2 = +_[0], y2 = +_[1];
          return quadtree;
        };
        return quadtree;
      };
      function d3_geom_quadtreeCompatX(d) {
        return d.x;
      }
      function d3_geom_quadtreeCompatY(d) {
        return d.y;
      }
      function d3_geom_quadtreeNode() {
        return {
          leaf: true,
          nodes: [],
          point: null,
          x: null,
          y: null
        };
      }
      function d3_geom_quadtreeVisit(f, node, x12, y12, x2, y2) {
        if (!f(node, x12, y12, x2, y2)) {
          var sx = (x12 + x2) * 0.5, sy = (y12 + y2) * 0.5, children = node.nodes;
          if (children[0]) d3_geom_quadtreeVisit(f, children[0], x12, y12, sx, sy);
          if (children[1]) d3_geom_quadtreeVisit(f, children[1], sx, y12, x2, sy);
          if (children[2]) d3_geom_quadtreeVisit(f, children[2], x12, sy, sx, y2);
          if (children[3]) d3_geom_quadtreeVisit(f, children[3], sx, sy, x2, y2);
        }
      }
      function d3_geom_quadtreeFind(root, x, y, x02, y02, x3, y3) {
        var minDistance2 = Infinity, closestPoint;
        (function find(node, x12, y12, x2, y2) {
          if (x12 > x3 || y12 > y3 || x2 < x02 || y2 < y02) return;
          if (point = node.point) {
            var point, dx = x - node.x, dy = y - node.y, distance2 = dx * dx + dy * dy;
            if (distance2 < minDistance2) {
              var distance = Math.sqrt(minDistance2 = distance2);
              x02 = x - distance, y02 = y - distance;
              x3 = x + distance, y3 = y + distance;
              closestPoint = point;
            }
          }
          var children = node.nodes, xm = (x12 + x2) * 0.5, ym = (y12 + y2) * 0.5, right = x >= xm, below = y >= ym;
          for (var i = below << 1 | right, j = i + 4; i < j; ++i) {
            if (node = children[i & 3]) switch (i & 3) {
              case 0:
                find(node, x12, y12, xm, ym);
                break;
              case 1:
                find(node, xm, y12, x2, ym);
                break;
              case 2:
                find(node, x12, ym, xm, y2);
                break;
              case 3:
                find(node, xm, ym, x2, y2);
                break;
            }
          }
        })(root, x02, y02, x3, y3);
        return closestPoint;
      }
      d3.interpolateRgb = d3_interpolateRgb;
      function d3_interpolateRgb(a, b) {
        a = d3.rgb(a);
        b = d3.rgb(b);
        var ar2 = a.r, ag2 = a.g, ab = a.b, br2 = b.r - ar2, bg2 = b.g - ag2, bb = b.b - ab;
        return function(t) {
          return "#" + d3_rgb_hex(Math.round(ar2 + br2 * t)) + d3_rgb_hex(Math.round(ag2 + bg2 * t)) + d3_rgb_hex(Math.round(ab + bb * t));
        };
      }
      d3.interpolateObject = d3_interpolateObject;
      function d3_interpolateObject(a, b) {
        var i = {}, c = {}, k;
        for (k in a) {
          if (k in b) {
            i[k] = d3_interpolate(a[k], b[k]);
          } else {
            c[k] = a[k];
          }
        }
        for (k in b) {
          if (!(k in a)) {
            c[k] = b[k];
          }
        }
        return function(t) {
          for (k in i) c[k] = i[k](t);
          return c;
        };
      }
      d3.interpolateNumber = d3_interpolateNumber;
      function d3_interpolateNumber(a, b) {
        a = +a, b = +b;
        return function(t) {
          return a * (1 - t) + b * t;
        };
      }
      d3.interpolateString = d3_interpolateString;
      function d3_interpolateString(a, b) {
        var bi2 = d3_interpolate_numberA.lastIndex = d3_interpolate_numberB.lastIndex = 0, am, bm, bs2, i = -1, s = [], q = [];
        a = a + "", b = b + "";
        while ((am = d3_interpolate_numberA.exec(a)) && (bm = d3_interpolate_numberB.exec(b))) {
          if ((bs2 = bm.index) > bi2) {
            bs2 = b.slice(bi2, bs2);
            if (s[i]) s[i] += bs2;
            else s[++i] = bs2;
          }
          if ((am = am[0]) === (bm = bm[0])) {
            if (s[i]) s[i] += bm;
            else s[++i] = bm;
          } else {
            s[++i] = null;
            q.push({
              i,
              x: d3_interpolateNumber(am, bm)
            });
          }
          bi2 = d3_interpolate_numberB.lastIndex;
        }
        if (bi2 < b.length) {
          bs2 = b.slice(bi2);
          if (s[i]) s[i] += bs2;
          else s[++i] = bs2;
        }
        return s.length < 2 ? q[0] ? (b = q[0].x, function(t) {
          return b(t) + "";
        }) : function() {
          return b;
        } : (b = q.length, function(t) {
          for (var i2 = 0, o; i2 < b; ++i2) s[(o = q[i2]).i] = o.x(t);
          return s.join("");
        });
      }
      var d3_interpolate_numberA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g, d3_interpolate_numberB = new RegExp(d3_interpolate_numberA.source, "g");
      d3.interpolate = d3_interpolate;
      function d3_interpolate(a, b) {
        var i = d3.interpolators.length, f;
        while (--i >= 0 && !(f = d3.interpolators[i](a, b))) ;
        return f;
      }
      d3.interpolators = [function(a, b) {
        var t = typeof b;
        return (t === "string" ? d3_rgb_names.has(b.toLowerCase()) || /^(#|rgb\(|hsl\()/i.test(b) ? d3_interpolateRgb : d3_interpolateString : b instanceof d3_color ? d3_interpolateRgb : Array.isArray(b) ? d3_interpolateArray : t === "object" && isNaN(b) ? d3_interpolateObject : d3_interpolateNumber)(a, b);
      }];
      d3.interpolateArray = d3_interpolateArray;
      function d3_interpolateArray(a, b) {
        var x = [], c = [], na2 = a.length, nb = b.length, n02 = Math.min(a.length, b.length), i;
        for (i = 0; i < n02; ++i) x.push(d3_interpolate(a[i], b[i]));
        for (; i < na2; ++i) c[i] = a[i];
        for (; i < nb; ++i) c[i] = b[i];
        return function(t) {
          for (i = 0; i < n02; ++i) c[i] = x[i](t);
          return c;
        };
      }
      var d3_ease_default = function() {
        return d3_identity;
      };
      var d3_ease = d3.map({
        linear: d3_ease_default,
        poly: d3_ease_poly,
        quad: function() {
          return d3_ease_quad;
        },
        cubic: function() {
          return d3_ease_cubic;
        },
        sin: function() {
          return d3_ease_sin;
        },
        exp: function() {
          return d3_ease_exp;
        },
        circle: function() {
          return d3_ease_circle;
        },
        elastic: d3_ease_elastic,
        back: d3_ease_back,
        bounce: function() {
          return d3_ease_bounce;
        }
      });
      var d3_ease_mode = d3.map({
        "in": d3_identity,
        out: d3_ease_reverse,
        "in-out": d3_ease_reflect,
        "out-in": function(f) {
          return d3_ease_reflect(d3_ease_reverse(f));
        }
      });
      d3.ease = function(name) {
        var i = name.indexOf("-"), t = i >= 0 ? name.slice(0, i) : name, m = i >= 0 ? name.slice(i + 1) : "in";
        t = d3_ease.get(t) || d3_ease_default;
        m = d3_ease_mode.get(m) || d3_identity;
        return d3_ease_clamp(m(t.apply(null, d3_arraySlice.call(arguments, 1))));
      };
      function d3_ease_clamp(f) {
        return function(t) {
          return t <= 0 ? 0 : t >= 1 ? 1 : f(t);
        };
      }
      function d3_ease_reverse(f) {
        return function(t) {
          return 1 - f(1 - t);
        };
      }
      function d3_ease_reflect(f) {
        return function(t) {
          return 0.5 * (t < 0.5 ? f(2 * t) : 2 - f(2 - 2 * t));
        };
      }
      function d3_ease_quad(t) {
        return t * t;
      }
      function d3_ease_cubic(t) {
        return t * t * t;
      }
      function d3_ease_cubicInOut(t) {
        if (t <= 0) return 0;
        if (t >= 1) return 1;
        var t2 = t * t, t3 = t2 * t;
        return 4 * (t < 0.5 ? t3 : 3 * (t - t2) + t3 - 0.75);
      }
      function d3_ease_poly(e) {
        return function(t) {
          return Math.pow(t, e);
        };
      }
      function d3_ease_sin(t) {
        return 1 - Math.cos(t * halfπ);
      }
      function d3_ease_exp(t) {
        return Math.pow(2, 10 * (t - 1));
      }
      function d3_ease_circle(t) {
        return 1 - Math.sqrt(1 - t * t);
      }
      function d3_ease_elastic(a, p) {
        var s;
        if (arguments.length < 2) p = 0.45;
        if (arguments.length) s = p / τ * Math.asin(1 / a);
        else a = 1, s = p / 4;
        return function(t) {
          return 1 + a * Math.pow(2, -10 * t) * Math.sin((t - s) * τ / p);
        };
      }
      function d3_ease_back(s) {
        if (!s) s = 1.70158;
        return function(t) {
          return t * t * ((s + 1) * t - s);
        };
      }
      function d3_ease_bounce(t) {
        return t < 1 / 2.75 ? 7.5625 * t * t : t < 2 / 2.75 ? 7.5625 * (t -= 1.5 / 2.75) * t + 0.75 : t < 2.5 / 2.75 ? 7.5625 * (t -= 2.25 / 2.75) * t + 0.9375 : 7.5625 * (t -= 2.625 / 2.75) * t + 0.984375;
      }
      d3.interpolateHcl = d3_interpolateHcl;
      function d3_interpolateHcl(a, b) {
        a = d3.hcl(a);
        b = d3.hcl(b);
        var ah2 = a.h, ac2 = a.c, al = a.l, bh2 = b.h - ah2, bc2 = b.c - ac2, bl = b.l - al;
        if (isNaN(bc2)) bc2 = 0, ac2 = isNaN(ac2) ? b.c : ac2;
        if (isNaN(bh2)) bh2 = 0, ah2 = isNaN(ah2) ? b.h : ah2;
        else if (bh2 > 180) bh2 -= 360;
        else if (bh2 < -180) bh2 += 360;
        return function(t) {
          return d3_hcl_lab(ah2 + bh2 * t, ac2 + bc2 * t, al + bl * t) + "";
        };
      }
      d3.interpolateHsl = d3_interpolateHsl;
      function d3_interpolateHsl(a, b) {
        a = d3.hsl(a);
        b = d3.hsl(b);
        var ah2 = a.h, as2 = a.s, al = a.l, bh2 = b.h - ah2, bs2 = b.s - as2, bl = b.l - al;
        if (isNaN(bs2)) bs2 = 0, as2 = isNaN(as2) ? b.s : as2;
        if (isNaN(bh2)) bh2 = 0, ah2 = isNaN(ah2) ? b.h : ah2;
        else if (bh2 > 180) bh2 -= 360;
        else if (bh2 < -180) bh2 += 360;
        return function(t) {
          return d3_hsl_rgb(ah2 + bh2 * t, as2 + bs2 * t, al + bl * t) + "";
        };
      }
      d3.interpolateLab = d3_interpolateLab;
      function d3_interpolateLab(a, b) {
        a = d3.lab(a);
        b = d3.lab(b);
        var al = a.l, aa2 = a.a, ab = a.b, bl = b.l - al, ba2 = b.a - aa2, bb = b.b - ab;
        return function(t) {
          return d3_lab_rgb(al + bl * t, aa2 + ba2 * t, ab + bb * t) + "";
        };
      }
      d3.interpolateRound = d3_interpolateRound;
      function d3_interpolateRound(a, b) {
        b -= a;
        return function(t) {
          return Math.round(a + b * t);
        };
      }
      d3.transform = function(string) {
        var g = d3_document.createElementNS(d3.ns.prefix.svg, "g");
        return (d3.transform = function(string2) {
          if (string2 != null) {
            g.setAttribute("transform", string2);
            var t = g.transform.baseVal.consolidate();
          }
          return new d3_transform(t ? t.matrix : d3_transformIdentity);
        })(string);
      };
      function d3_transform(m) {
        var r02 = [m.a, m.b], r12 = [m.c, m.d], kx = d3_transformNormalize(r02), kz = d3_transformDot(r02, r12), ky = d3_transformNormalize(d3_transformCombine(r12, r02, -kz)) || 0;
        if (r02[0] * r12[1] < r12[0] * r02[1]) {
          r02[0] *= -1;
          r02[1] *= -1;
          kx *= -1;
          kz *= -1;
        }
        this.rotate = (kx ? Math.atan2(r02[1], r02[0]) : Math.atan2(-r12[0], r12[1])) * d3_degrees;
        this.translate = [m.e, m.f];
        this.scale = [kx, ky];
        this.skew = ky ? Math.atan2(kz, ky) * d3_degrees : 0;
      }
      d3_transform.prototype.toString = function() {
        return "translate(" + this.translate + ")rotate(" + this.rotate + ")skewX(" + this.skew + ")scale(" + this.scale + ")";
      };
      function d3_transformDot(a, b) {
        return a[0] * b[0] + a[1] * b[1];
      }
      function d3_transformNormalize(a) {
        var k = Math.sqrt(d3_transformDot(a, a));
        if (k) {
          a[0] /= k;
          a[1] /= k;
        }
        return k;
      }
      function d3_transformCombine(a, b, k) {
        a[0] += k * b[0];
        a[1] += k * b[1];
        return a;
      }
      var d3_transformIdentity = {
        a: 1,
        b: 0,
        c: 0,
        d: 1,
        e: 0,
        f: 0
      };
      d3.interpolateTransform = d3_interpolateTransform;
      function d3_interpolateTransformPop(s) {
        return s.length ? s.pop() + "," : "";
      }
      function d3_interpolateTranslate(ta2, tb, s, q) {
        if (ta2[0] !== tb[0] || ta2[1] !== tb[1]) {
          var i = s.push("translate(", null, ",", null, ")");
          q.push({
            i: i - 4,
            x: d3_interpolateNumber(ta2[0], tb[0])
          }, {
            i: i - 2,
            x: d3_interpolateNumber(ta2[1], tb[1])
          });
        } else if (tb[0] || tb[1]) {
          s.push("translate(" + tb + ")");
        }
      }
      function d3_interpolateRotate(ra2, rb, s, q) {
        if (ra2 !== rb) {
          if (ra2 - rb > 180) rb += 360;
          else if (rb - ra2 > 180) ra2 += 360;
          q.push({
            i: s.push(d3_interpolateTransformPop(s) + "rotate(", null, ")") - 2,
            x: d3_interpolateNumber(ra2, rb)
          });
        } else if (rb) {
          s.push(d3_interpolateTransformPop(s) + "rotate(" + rb + ")");
        }
      }
      function d3_interpolateSkew(wa2, wb, s, q) {
        if (wa2 !== wb) {
          q.push({
            i: s.push(d3_interpolateTransformPop(s) + "skewX(", null, ")") - 2,
            x: d3_interpolateNumber(wa2, wb)
          });
        } else if (wb) {
          s.push(d3_interpolateTransformPop(s) + "skewX(" + wb + ")");
        }
      }
      function d3_interpolateScale(ka2, kb, s, q) {
        if (ka2[0] !== kb[0] || ka2[1] !== kb[1]) {
          var i = s.push(d3_interpolateTransformPop(s) + "scale(", null, ",", null, ")");
          q.push({
            i: i - 4,
            x: d3_interpolateNumber(ka2[0], kb[0])
          }, {
            i: i - 2,
            x: d3_interpolateNumber(ka2[1], kb[1])
          });
        } else if (kb[0] !== 1 || kb[1] !== 1) {
          s.push(d3_interpolateTransformPop(s) + "scale(" + kb + ")");
        }
      }
      function d3_interpolateTransform(a, b) {
        var s = [], q = [];
        a = d3.transform(a), b = d3.transform(b);
        d3_interpolateTranslate(a.translate, b.translate, s, q);
        d3_interpolateRotate(a.rotate, b.rotate, s, q);
        d3_interpolateSkew(a.skew, b.skew, s, q);
        d3_interpolateScale(a.scale, b.scale, s, q);
        a = b = null;
        return function(t) {
          var i = -1, n = q.length, o;
          while (++i < n) s[(o = q[i]).i] = o.x(t);
          return s.join("");
        };
      }
      function d3_uninterpolateNumber(a, b) {
        b = (b -= a = +a) || 1 / b;
        return function(x) {
          return (x - a) / b;
        };
      }
      function d3_uninterpolateClamp(a, b) {
        b = (b -= a = +a) || 1 / b;
        return function(x) {
          return Math.max(0, Math.min(1, (x - a) / b));
        };
      }
      d3.layout = {};
      d3.layout.bundle = function() {
        return function(links) {
          var paths = [], i = -1, n = links.length;
          while (++i < n) paths.push(d3_layout_bundlePath(links[i]));
          return paths;
        };
      };
      function d3_layout_bundlePath(link) {
        var start = link.source, end = link.target, lca = d3_layout_bundleLeastCommonAncestor(start, end), points = [start];
        while (start !== lca) {
          start = start.parent;
          points.push(start);
        }
        var k = points.length;
        while (end !== lca) {
          points.splice(k, 0, end);
          end = end.parent;
        }
        return points;
      }
      function d3_layout_bundleAncestors(node) {
        var ancestors = [], parent = node.parent;
        while (parent != null) {
          ancestors.push(node);
          node = parent;
          parent = parent.parent;
        }
        ancestors.push(node);
        return ancestors;
      }
      function d3_layout_bundleLeastCommonAncestor(a, b) {
        if (a === b) return a;
        var aNodes = d3_layout_bundleAncestors(a), bNodes = d3_layout_bundleAncestors(b), aNode = aNodes.pop(), bNode = bNodes.pop(), sharedNode = null;
        while (aNode === bNode) {
          sharedNode = aNode;
          aNode = aNodes.pop();
          bNode = bNodes.pop();
        }
        return sharedNode;
      }
      d3.layout.chord = function() {
        var chord = {}, chords, groups, matrix, n, padding = 0, sortGroups, sortSubgroups, sortChords;
        function relayout() {
          var subgroups = {}, groupSums = [], groupIndex = d3.range(n), subgroupIndex = [], k, x, x02, i, j;
          chords = [];
          groups = [];
          k = 0, i = -1;
          while (++i < n) {
            x = 0, j = -1;
            while (++j < n) {
              x += matrix[i][j];
            }
            groupSums.push(x);
            subgroupIndex.push(d3.range(n));
            k += x;
          }
          if (sortGroups) {
            groupIndex.sort(function(a, b) {
              return sortGroups(groupSums[a], groupSums[b]);
            });
          }
          if (sortSubgroups) {
            subgroupIndex.forEach(function(d, i2) {
              d.sort(function(a, b) {
                return sortSubgroups(matrix[i2][a], matrix[i2][b]);
              });
            });
          }
          k = (τ - padding * n) / k;
          x = 0, i = -1;
          while (++i < n) {
            x02 = x, j = -1;
            while (++j < n) {
              var di2 = groupIndex[i], dj = subgroupIndex[di2][j], v = matrix[di2][dj], a02 = x, a12 = x += v * k;
              subgroups[di2 + "-" + dj] = {
                index: di2,
                subindex: dj,
                startAngle: a02,
                endAngle: a12,
                value: v
              };
            }
            groups[di2] = {
              index: di2,
              startAngle: x02,
              endAngle: x,
              value: groupSums[di2]
            };
            x += padding;
          }
          i = -1;
          while (++i < n) {
            j = i - 1;
            while (++j < n) {
              var source = subgroups[i + "-" + j], target = subgroups[j + "-" + i];
              if (source.value || target.value) {
                chords.push(source.value < target.value ? {
                  source: target,
                  target: source
                } : {
                  source,
                  target
                });
              }
            }
          }
          if (sortChords) resort();
        }
        function resort() {
          chords.sort(function(a, b) {
            return sortChords((a.source.value + a.target.value) / 2, (b.source.value + b.target.value) / 2);
          });
        }
        chord.matrix = function(x) {
          if (!arguments.length) return matrix;
          n = (matrix = x) && matrix.length;
          chords = groups = null;
          return chord;
        };
        chord.padding = function(x) {
          if (!arguments.length) return padding;
          padding = x;
          chords = groups = null;
          return chord;
        };
        chord.sortGroups = function(x) {
          if (!arguments.length) return sortGroups;
          sortGroups = x;
          chords = groups = null;
          return chord;
        };
        chord.sortSubgroups = function(x) {
          if (!arguments.length) return sortSubgroups;
          sortSubgroups = x;
          chords = null;
          return chord;
        };
        chord.sortChords = function(x) {
          if (!arguments.length) return sortChords;
          sortChords = x;
          if (chords) resort();
          return chord;
        };
        chord.chords = function() {
          if (!chords) relayout();
          return chords;
        };
        chord.groups = function() {
          if (!groups) relayout();
          return groups;
        };
        return chord;
      };
      d3.layout.force = function() {
        var force = {}, event = d3.dispatch("start", "tick", "end"), timer, size = [1, 1], drag, alpha, friction = 0.9, linkDistance = d3_layout_forceLinkDistance, linkStrength = d3_layout_forceLinkStrength, charge = -30, chargeDistance2 = d3_layout_forceChargeDistance2, gravity = 0.1, theta2 = 0.64, nodes = [], links = [], distances, strengths, charges;
        function repulse(node) {
          return function(quad, x12, _, x2) {
            if (quad.point !== node) {
              var dx = quad.cx - node.x, dy = quad.cy - node.y, dw = x2 - x12, dn = dx * dx + dy * dy;
              if (dw * dw / theta2 < dn) {
                if (dn < chargeDistance2) {
                  var k = quad.charge / dn;
                  node.px -= dx * k;
                  node.py -= dy * k;
                }
                return true;
              }
              if (quad.point && dn && dn < chargeDistance2) {
                var k = quad.pointCharge / dn;
                node.px -= dx * k;
                node.py -= dy * k;
              }
            }
            return !quad.charge;
          };
        }
        force.tick = function() {
          if ((alpha *= 0.99) < 5e-3) {
            timer = null;
            event.end({
              type: "end",
              alpha: alpha = 0
            });
            return true;
          }
          var n = nodes.length, m = links.length, q, i, o, s, t, l, k, x, y;
          for (i = 0; i < m; ++i) {
            o = links[i];
            s = o.source;
            t = o.target;
            x = t.x - s.x;
            y = t.y - s.y;
            if (l = x * x + y * y) {
              l = alpha * strengths[i] * ((l = Math.sqrt(l)) - distances[i]) / l;
              x *= l;
              y *= l;
              t.x -= x * (k = s.weight + t.weight ? s.weight / (s.weight + t.weight) : 0.5);
              t.y -= y * k;
              s.x += x * (k = 1 - k);
              s.y += y * k;
            }
          }
          if (k = alpha * gravity) {
            x = size[0] / 2;
            y = size[1] / 2;
            i = -1;
            if (k) while (++i < n) {
              o = nodes[i];
              o.x += (x - o.x) * k;
              o.y += (y - o.y) * k;
            }
          }
          if (charge) {
            d3_layout_forceAccumulate(q = d3.geom.quadtree(nodes), alpha, charges);
            i = -1;
            while (++i < n) {
              if (!(o = nodes[i]).fixed) {
                q.visit(repulse(o));
              }
            }
          }
          i = -1;
          while (++i < n) {
            o = nodes[i];
            if (o.fixed) {
              o.x = o.px;
              o.y = o.py;
            } else {
              o.x -= (o.px - (o.px = o.x)) * friction;
              o.y -= (o.py - (o.py = o.y)) * friction;
            }
          }
          event.tick({
            type: "tick",
            alpha
          });
        };
        force.nodes = function(x) {
          if (!arguments.length) return nodes;
          nodes = x;
          return force;
        };
        force.links = function(x) {
          if (!arguments.length) return links;
          links = x;
          return force;
        };
        force.size = function(x) {
          if (!arguments.length) return size;
          size = x;
          return force;
        };
        force.linkDistance = function(x) {
          if (!arguments.length) return linkDistance;
          linkDistance = typeof x === "function" ? x : +x;
          return force;
        };
        force.distance = force.linkDistance;
        force.linkStrength = function(x) {
          if (!arguments.length) return linkStrength;
          linkStrength = typeof x === "function" ? x : +x;
          return force;
        };
        force.friction = function(x) {
          if (!arguments.length) return friction;
          friction = +x;
          return force;
        };
        force.charge = function(x) {
          if (!arguments.length) return charge;
          charge = typeof x === "function" ? x : +x;
          return force;
        };
        force.chargeDistance = function(x) {
          if (!arguments.length) return Math.sqrt(chargeDistance2);
          chargeDistance2 = x * x;
          return force;
        };
        force.gravity = function(x) {
          if (!arguments.length) return gravity;
          gravity = +x;
          return force;
        };
        force.theta = function(x) {
          if (!arguments.length) return Math.sqrt(theta2);
          theta2 = x * x;
          return force;
        };
        force.alpha = function(x) {
          if (!arguments.length) return alpha;
          x = +x;
          if (alpha) {
            if (x > 0) {
              alpha = x;
            } else {
              timer.c = null, timer.t = NaN, timer = null;
              event.end({
                type: "end",
                alpha: alpha = 0
              });
            }
          } else if (x > 0) {
            event.start({
              type: "start",
              alpha: alpha = x
            });
            timer = d3_timer(force.tick);
          }
          return force;
        };
        force.start = function() {
          var i, n = nodes.length, m = links.length, w = size[0], h = size[1], neighbors, o;
          for (i = 0; i < n; ++i) {
            (o = nodes[i]).index = i;
            o.weight = 0;
          }
          for (i = 0; i < m; ++i) {
            o = links[i];
            if (typeof o.source == "number") o.source = nodes[o.source];
            if (typeof o.target == "number") o.target = nodes[o.target];
            ++o.source.weight;
            ++o.target.weight;
          }
          for (i = 0; i < n; ++i) {
            o = nodes[i];
            if (isNaN(o.x)) o.x = position("x", w);
            if (isNaN(o.y)) o.y = position("y", h);
            if (isNaN(o.px)) o.px = o.x;
            if (isNaN(o.py)) o.py = o.y;
          }
          distances = [];
          if (typeof linkDistance === "function") for (i = 0; i < m; ++i) distances[i] = +linkDistance.call(this, links[i], i);
          else for (i = 0; i < m; ++i) distances[i] = linkDistance;
          strengths = [];
          if (typeof linkStrength === "function") for (i = 0; i < m; ++i) strengths[i] = +linkStrength.call(this, links[i], i);
          else for (i = 0; i < m; ++i) strengths[i] = linkStrength;
          charges = [];
          if (typeof charge === "function") for (i = 0; i < n; ++i) charges[i] = +charge.call(this, nodes[i], i);
          else for (i = 0; i < n; ++i) charges[i] = charge;
          function position(dimension, size2) {
            if (!neighbors) {
              neighbors = new Array(n);
              for (j = 0; j < n; ++j) {
                neighbors[j] = [];
              }
              for (j = 0; j < m; ++j) {
                var o2 = links[j];
                neighbors[o2.source.index].push(o2.target);
                neighbors[o2.target.index].push(o2.source);
              }
            }
            var candidates = neighbors[i], j = -1, l = candidates.length, x;
            while (++j < l) if (!isNaN(x = candidates[j][dimension])) return x;
            return Math.random() * size2;
          }
          return force.resume();
        };
        force.resume = function() {
          return force.alpha(0.1);
        };
        force.stop = function() {
          return force.alpha(0);
        };
        force.drag = function() {
          if (!drag) drag = d3.behavior.drag().origin(d3_identity).on("dragstart.force", d3_layout_forceDragstart).on("drag.force", dragmove).on("dragend.force", d3_layout_forceDragend);
          if (!arguments.length) return drag;
          this.on("mouseover.force", d3_layout_forceMouseover).on("mouseout.force", d3_layout_forceMouseout).call(drag);
        };
        function dragmove(d) {
          d.px = d3.event.x, d.py = d3.event.y;
          force.resume();
        }
        return d3.rebind(force, event, "on");
      };
      function d3_layout_forceDragstart(d) {
        d.fixed |= 2;
      }
      function d3_layout_forceDragend(d) {
        d.fixed &= ~6;
      }
      function d3_layout_forceMouseover(d) {
        d.fixed |= 4;
        d.px = d.x, d.py = d.y;
      }
      function d3_layout_forceMouseout(d) {
        d.fixed &= ~4;
      }
      function d3_layout_forceAccumulate(quad, alpha, charges) {
        var cx = 0, cy = 0;
        quad.charge = 0;
        if (!quad.leaf) {
          var nodes = quad.nodes, n = nodes.length, i = -1, c;
          while (++i < n) {
            c = nodes[i];
            if (c == null) continue;
            d3_layout_forceAccumulate(c, alpha, charges);
            quad.charge += c.charge;
            cx += c.charge * c.cx;
            cy += c.charge * c.cy;
          }
        }
        if (quad.point) {
          if (!quad.leaf) {
            quad.point.x += Math.random() - 0.5;
            quad.point.y += Math.random() - 0.5;
          }
          var k = alpha * charges[quad.point.index];
          quad.charge += quad.pointCharge = k;
          cx += k * quad.point.x;
          cy += k * quad.point.y;
        }
        quad.cx = cx / quad.charge;
        quad.cy = cy / quad.charge;
      }
      var d3_layout_forceLinkDistance = 20, d3_layout_forceLinkStrength = 1, d3_layout_forceChargeDistance2 = Infinity;
      d3.layout.hierarchy = function() {
        var sort = d3_layout_hierarchySort, children = d3_layout_hierarchyChildren, value = d3_layout_hierarchyValue;
        function hierarchy(root) {
          var stack = [root], nodes = [], node;
          root.depth = 0;
          while ((node = stack.pop()) != null) {
            nodes.push(node);
            if ((childs = children.call(hierarchy, node, node.depth)) && (n = childs.length)) {
              var n, childs, child;
              while (--n >= 0) {
                stack.push(child = childs[n]);
                child.parent = node;
                child.depth = node.depth + 1;
              }
              if (value) node.value = 0;
              node.children = childs;
            } else {
              if (value) node.value = +value.call(hierarchy, node, node.depth) || 0;
              delete node.children;
            }
          }
          d3_layout_hierarchyVisitAfter(root, function(node2) {
            var childs2, parent;
            if (sort && (childs2 = node2.children)) childs2.sort(sort);
            if (value && (parent = node2.parent)) parent.value += node2.value;
          });
          return nodes;
        }
        hierarchy.sort = function(x) {
          if (!arguments.length) return sort;
          sort = x;
          return hierarchy;
        };
        hierarchy.children = function(x) {
          if (!arguments.length) return children;
          children = x;
          return hierarchy;
        };
        hierarchy.value = function(x) {
          if (!arguments.length) return value;
          value = x;
          return hierarchy;
        };
        hierarchy.revalue = function(root) {
          if (value) {
            d3_layout_hierarchyVisitBefore(root, function(node) {
              if (node.children) node.value = 0;
            });
            d3_layout_hierarchyVisitAfter(root, function(node) {
              var parent;
              if (!node.children) node.value = +value.call(hierarchy, node, node.depth) || 0;
              if (parent = node.parent) parent.value += node.value;
            });
          }
          return root;
        };
        return hierarchy;
      };
      function d3_layout_hierarchyRebind(object, hierarchy) {
        d3.rebind(object, hierarchy, "sort", "children", "value");
        object.nodes = object;
        object.links = d3_layout_hierarchyLinks;
        return object;
      }
      function d3_layout_hierarchyVisitBefore(node, callback) {
        var nodes = [node];
        while ((node = nodes.pop()) != null) {
          callback(node);
          if ((children = node.children) && (n = children.length)) {
            var n, children;
            while (--n >= 0) nodes.push(children[n]);
          }
        }
      }
      function d3_layout_hierarchyVisitAfter(node, callback) {
        var nodes = [node], nodes2 = [];
        while ((node = nodes.pop()) != null) {
          nodes2.push(node);
          if ((children = node.children) && (n = children.length)) {
            var i = -1, n, children;
            while (++i < n) nodes.push(children[i]);
          }
        }
        while ((node = nodes2.pop()) != null) {
          callback(node);
        }
      }
      function d3_layout_hierarchyChildren(d) {
        return d.children;
      }
      function d3_layout_hierarchyValue(d) {
        return d.value;
      }
      function d3_layout_hierarchySort(a, b) {
        return b.value - a.value;
      }
      function d3_layout_hierarchyLinks(nodes) {
        return d3.merge(nodes.map(function(parent) {
          return (parent.children || []).map(function(child) {
            return {
              source: parent,
              target: child
            };
          });
        }));
      }
      d3.layout.partition = function() {
        var hierarchy = d3.layout.hierarchy(), size = [1, 1];
        function position(node, x, dx, dy) {
          var children = node.children;
          node.x = x;
          node.y = node.depth * dy;
          node.dx = dx;
          node.dy = dy;
          if (children && (n = children.length)) {
            var i = -1, n, c, d;
            dx = node.value ? dx / node.value : 0;
            while (++i < n) {
              position(c = children[i], x, d = c.value * dx, dy);
              x += d;
            }
          }
        }
        function depth(node) {
          var children = node.children, d = 0;
          if (children && (n = children.length)) {
            var i = -1, n;
            while (++i < n) d = Math.max(d, depth(children[i]));
          }
          return 1 + d;
        }
        function partition(d, i) {
          var nodes = hierarchy.call(this, d, i);
          position(nodes[0], 0, size[0], size[1] / depth(nodes[0]));
          return nodes;
        }
        partition.size = function(x) {
          if (!arguments.length) return size;
          size = x;
          return partition;
        };
        return d3_layout_hierarchyRebind(partition, hierarchy);
      };
      d3.layout.pie = function() {
        var value = Number, sort = d3_layout_pieSortByValue, startAngle = 0, endAngle = τ, padAngle = 0;
        function pie(data) {
          var n = data.length, values = data.map(function(d, i) {
            return +value.call(pie, d, i);
          }), a = +(typeof startAngle === "function" ? startAngle.apply(this, arguments) : startAngle), da2 = (typeof endAngle === "function" ? endAngle.apply(this, arguments) : endAngle) - a, p = Math.min(Math.abs(da2) / n, +(typeof padAngle === "function" ? padAngle.apply(this, arguments) : padAngle)), pa2 = p * (da2 < 0 ? -1 : 1), sum = d3.sum(values), k = sum ? (da2 - n * pa2) / sum : 0, index = d3.range(n), arcs = [], v;
          if (sort != null) index.sort(sort === d3_layout_pieSortByValue ? function(i, j) {
            return values[j] - values[i];
          } : function(i, j) {
            return sort(data[i], data[j]);
          });
          index.forEach(function(i) {
            arcs[i] = {
              data: data[i],
              value: v = values[i],
              startAngle: a,
              endAngle: a += v * k + pa2,
              padAngle: p
            };
          });
          return arcs;
        }
        pie.value = function(_) {
          if (!arguments.length) return value;
          value = _;
          return pie;
        };
        pie.sort = function(_) {
          if (!arguments.length) return sort;
          sort = _;
          return pie;
        };
        pie.startAngle = function(_) {
          if (!arguments.length) return startAngle;
          startAngle = _;
          return pie;
        };
        pie.endAngle = function(_) {
          if (!arguments.length) return endAngle;
          endAngle = _;
          return pie;
        };
        pie.padAngle = function(_) {
          if (!arguments.length) return padAngle;
          padAngle = _;
          return pie;
        };
        return pie;
      };
      var d3_layout_pieSortByValue = {};
      d3.layout.stack = function() {
        var values = d3_identity, order = d3_layout_stackOrderDefault, offset = d3_layout_stackOffsetZero, out = d3_layout_stackOut, x = d3_layout_stackX, y = d3_layout_stackY;
        function stack(data, index) {
          if (!(n = data.length)) return data;
          var series = data.map(function(d, i2) {
            return values.call(stack, d, i2);
          });
          var points = series.map(function(d) {
            return d.map(function(v, i2) {
              return [x.call(stack, v, i2), y.call(stack, v, i2)];
            });
          });
          var orders = order.call(stack, points, index);
          series = d3.permute(series, orders);
          points = d3.permute(points, orders);
          var offsets = offset.call(stack, points, index);
          var m = series[0].length, n, i, j, o;
          for (j = 0; j < m; ++j) {
            out.call(stack, series[0][j], o = offsets[j], points[0][j][1]);
            for (i = 1; i < n; ++i) {
              out.call(stack, series[i][j], o += points[i - 1][j][1], points[i][j][1]);
            }
          }
          return data;
        }
        stack.values = function(x2) {
          if (!arguments.length) return values;
          values = x2;
          return stack;
        };
        stack.order = function(x2) {
          if (!arguments.length) return order;
          order = typeof x2 === "function" ? x2 : d3_layout_stackOrders.get(x2) || d3_layout_stackOrderDefault;
          return stack;
        };
        stack.offset = function(x2) {
          if (!arguments.length) return offset;
          offset = typeof x2 === "function" ? x2 : d3_layout_stackOffsets.get(x2) || d3_layout_stackOffsetZero;
          return stack;
        };
        stack.x = function(z2) {
          if (!arguments.length) return x;
          x = z2;
          return stack;
        };
        stack.y = function(z2) {
          if (!arguments.length) return y;
          y = z2;
          return stack;
        };
        stack.out = function(z2) {
          if (!arguments.length) return out;
          out = z2;
          return stack;
        };
        return stack;
      };
      function d3_layout_stackX(d) {
        return d.x;
      }
      function d3_layout_stackY(d) {
        return d.y;
      }
      function d3_layout_stackOut(d, y02, y) {
        d.y0 = y02;
        d.y = y;
      }
      var d3_layout_stackOrders = d3.map({
        "inside-out": function(data) {
          var n = data.length, i, j, max = data.map(d3_layout_stackMaxIndex), sums = data.map(d3_layout_stackReduceSum), index = d3.range(n).sort(function(a, b) {
            return max[a] - max[b];
          }), top = 0, bottom = 0, tops = [], bottoms = [];
          for (i = 0; i < n; ++i) {
            j = index[i];
            if (top < bottom) {
              top += sums[j];
              tops.push(j);
            } else {
              bottom += sums[j];
              bottoms.push(j);
            }
          }
          return bottoms.reverse().concat(tops);
        },
        reverse: function(data) {
          return d3.range(data.length).reverse();
        },
        "default": d3_layout_stackOrderDefault
      });
      var d3_layout_stackOffsets = d3.map({
        silhouette: function(data) {
          var n = data.length, m = data[0].length, sums = [], max = 0, i, j, o, y02 = [];
          for (j = 0; j < m; ++j) {
            for (i = 0, o = 0; i < n; i++) o += data[i][j][1];
            if (o > max) max = o;
            sums.push(o);
          }
          for (j = 0; j < m; ++j) {
            y02[j] = (max - sums[j]) / 2;
          }
          return y02;
        },
        wiggle: function(data) {
          var n = data.length, x = data[0], m = x.length, i, j, k, s12, s2, s3, dx, o, o02, y02 = [];
          y02[0] = o = o02 = 0;
          for (j = 1; j < m; ++j) {
            for (i = 0, s12 = 0; i < n; ++i) s12 += data[i][j][1];
            for (i = 0, s2 = 0, dx = x[j][0] - x[j - 1][0]; i < n; ++i) {
              for (k = 0, s3 = (data[i][j][1] - data[i][j - 1][1]) / (2 * dx); k < i; ++k) {
                s3 += (data[k][j][1] - data[k][j - 1][1]) / dx;
              }
              s2 += s3 * data[i][j][1];
            }
            y02[j] = o -= s12 ? s2 / s12 * dx : 0;
            if (o < o02) o02 = o;
          }
          for (j = 0; j < m; ++j) y02[j] -= o02;
          return y02;
        },
        expand: function(data) {
          var n = data.length, m = data[0].length, k = 1 / n, i, j, o, y02 = [];
          for (j = 0; j < m; ++j) {
            for (i = 0, o = 0; i < n; i++) o += data[i][j][1];
            if (o) for (i = 0; i < n; i++) data[i][j][1] /= o;
            else for (i = 0; i < n; i++) data[i][j][1] = k;
          }
          for (j = 0; j < m; ++j) y02[j] = 0;
          return y02;
        },
        zero: d3_layout_stackOffsetZero
      });
      function d3_layout_stackOrderDefault(data) {
        return d3.range(data.length);
      }
      function d3_layout_stackOffsetZero(data) {
        var j = -1, m = data[0].length, y02 = [];
        while (++j < m) y02[j] = 0;
        return y02;
      }
      function d3_layout_stackMaxIndex(array) {
        var i = 1, j = 0, v = array[0][1], k, n = array.length;
        for (; i < n; ++i) {
          if ((k = array[i][1]) > v) {
            j = i;
            v = k;
          }
        }
        return j;
      }
      function d3_layout_stackReduceSum(d) {
        return d.reduce(d3_layout_stackSum, 0);
      }
      function d3_layout_stackSum(p, d) {
        return p + d[1];
      }
      d3.layout.histogram = function() {
        var frequency = true, valuer = Number, ranger = d3_layout_histogramRange, binner = d3_layout_histogramBinSturges;
        function histogram(data, i) {
          var bins = [], values = data.map(valuer, this), range = ranger.call(this, values, i), thresholds = binner.call(this, range, values, i), bin, i = -1, n = values.length, m = thresholds.length - 1, k = frequency ? 1 : 1 / n, x;
          while (++i < m) {
            bin = bins[i] = [];
            bin.dx = thresholds[i + 1] - (bin.x = thresholds[i]);
            bin.y = 0;
          }
          if (m > 0) {
            i = -1;
            while (++i < n) {
              x = values[i];
              if (x >= range[0] && x <= range[1]) {
                bin = bins[d3.bisect(thresholds, x, 1, m) - 1];
                bin.y += k;
                bin.push(data[i]);
              }
            }
          }
          return bins;
        }
        histogram.value = function(x) {
          if (!arguments.length) return valuer;
          valuer = x;
          return histogram;
        };
        histogram.range = function(x) {
          if (!arguments.length) return ranger;
          ranger = d3_functor(x);
          return histogram;
        };
        histogram.bins = function(x) {
          if (!arguments.length) return binner;
          binner = typeof x === "number" ? function(range) {
            return d3_layout_histogramBinFixed(range, x);
          } : d3_functor(x);
          return histogram;
        };
        histogram.frequency = function(x) {
          if (!arguments.length) return frequency;
          frequency = !!x;
          return histogram;
        };
        return histogram;
      };
      function d3_layout_histogramBinSturges(range, values) {
        return d3_layout_histogramBinFixed(range, Math.ceil(Math.log(values.length) / Math.LN2 + 1));
      }
      function d3_layout_histogramBinFixed(range, n) {
        var x = -1, b = +range[0], m = (range[1] - b) / n, f = [];
        while (++x <= n) f[x] = m * x + b;
        return f;
      }
      function d3_layout_histogramRange(values) {
        return [d3.min(values), d3.max(values)];
      }
      d3.layout.pack = function() {
        var hierarchy = d3.layout.hierarchy().sort(d3_layout_packSort), padding = 0, size = [1, 1], radius;
        function pack(d, i) {
          var nodes = hierarchy.call(this, d, i), root = nodes[0], w = size[0], h = size[1], r = radius == null ? Math.sqrt : typeof radius === "function" ? radius : function() {
            return radius;
          };
          root.x = root.y = 0;
          d3_layout_hierarchyVisitAfter(root, function(d2) {
            d2.r = +r(d2.value);
          });
          d3_layout_hierarchyVisitAfter(root, d3_layout_packSiblings);
          if (padding) {
            var dr2 = padding * (radius ? 1 : Math.max(2 * root.r / w, 2 * root.r / h)) / 2;
            d3_layout_hierarchyVisitAfter(root, function(d2) {
              d2.r += dr2;
            });
            d3_layout_hierarchyVisitAfter(root, d3_layout_packSiblings);
            d3_layout_hierarchyVisitAfter(root, function(d2) {
              d2.r -= dr2;
            });
          }
          d3_layout_packTransform(root, w / 2, h / 2, radius ? 1 : 1 / Math.max(2 * root.r / w, 2 * root.r / h));
          return nodes;
        }
        pack.size = function(_) {
          if (!arguments.length) return size;
          size = _;
          return pack;
        };
        pack.radius = function(_) {
          if (!arguments.length) return radius;
          radius = _ == null || typeof _ === "function" ? _ : +_;
          return pack;
        };
        pack.padding = function(_) {
          if (!arguments.length) return padding;
          padding = +_;
          return pack;
        };
        return d3_layout_hierarchyRebind(pack, hierarchy);
      };
      function d3_layout_packSort(a, b) {
        return a.value - b.value;
      }
      function d3_layout_packInsert(a, b) {
        var c = a._pack_next;
        a._pack_next = b;
        b._pack_prev = a;
        b._pack_next = c;
        c._pack_prev = b;
      }
      function d3_layout_packSplice(a, b) {
        a._pack_next = b;
        b._pack_prev = a;
      }
      function d3_layout_packIntersects(a, b) {
        var dx = b.x - a.x, dy = b.y - a.y, dr2 = a.r + b.r;
        return 0.999 * dr2 * dr2 > dx * dx + dy * dy;
      }
      function d3_layout_packSiblings(node) {
        if (!(nodes = node.children) || !(n = nodes.length)) return;
        var nodes, xMin = Infinity, xMax = -Infinity, yMin = Infinity, yMax = -Infinity, a, b, c, i, j, k, n;
        function bound(node2) {
          xMin = Math.min(node2.x - node2.r, xMin);
          xMax = Math.max(node2.x + node2.r, xMax);
          yMin = Math.min(node2.y - node2.r, yMin);
          yMax = Math.max(node2.y + node2.r, yMax);
        }
        nodes.forEach(d3_layout_packLink);
        a = nodes[0];
        a.x = -a.r;
        a.y = 0;
        bound(a);
        if (n > 1) {
          b = nodes[1];
          b.x = b.r;
          b.y = 0;
          bound(b);
          if (n > 2) {
            c = nodes[2];
            d3_layout_packPlace(a, b, c);
            bound(c);
            d3_layout_packInsert(a, c);
            a._pack_prev = c;
            d3_layout_packInsert(c, b);
            b = a._pack_next;
            for (i = 3; i < n; i++) {
              d3_layout_packPlace(a, b, c = nodes[i]);
              var isect = 0, s12 = 1, s2 = 1;
              for (j = b._pack_next; j !== b; j = j._pack_next, s12++) {
                if (d3_layout_packIntersects(j, c)) {
                  isect = 1;
                  break;
                }
              }
              if (isect == 1) {
                for (k = a._pack_prev; k !== j._pack_prev; k = k._pack_prev, s2++) {
                  if (d3_layout_packIntersects(k, c)) {
                    break;
                  }
                }
              }
              if (isect) {
                if (s12 < s2 || s12 == s2 && b.r < a.r) d3_layout_packSplice(a, b = j);
                else d3_layout_packSplice(a = k, b);
                i--;
              } else {
                d3_layout_packInsert(a, c);
                b = c;
                bound(c);
              }
            }
          }
        }
        var cx = (xMin + xMax) / 2, cy = (yMin + yMax) / 2, cr2 = 0;
        for (i = 0; i < n; i++) {
          c = nodes[i];
          c.x -= cx;
          c.y -= cy;
          cr2 = Math.max(cr2, c.r + Math.sqrt(c.x * c.x + c.y * c.y));
        }
        node.r = cr2;
        nodes.forEach(d3_layout_packUnlink);
      }
      function d3_layout_packLink(node) {
        node._pack_next = node._pack_prev = node;
      }
      function d3_layout_packUnlink(node) {
        delete node._pack_next;
        delete node._pack_prev;
      }
      function d3_layout_packTransform(node, x, y, k) {
        var children = node.children;
        node.x = x += k * node.x;
        node.y = y += k * node.y;
        node.r *= k;
        if (children) {
          var i = -1, n = children.length;
          while (++i < n) d3_layout_packTransform(children[i], x, y, k);
        }
      }
      function d3_layout_packPlace(a, b, c) {
        var db = a.r + c.r, dx = b.x - a.x, dy = b.y - a.y;
        if (db && (dx || dy)) {
          var da2 = b.r + c.r, dc2 = dx * dx + dy * dy;
          da2 *= da2;
          db *= db;
          var x = 0.5 + (db - da2) / (2 * dc2), y = Math.sqrt(Math.max(0, 2 * da2 * (db + dc2) - (db -= dc2) * db - da2 * da2)) / (2 * dc2);
          c.x = a.x + x * dx + y * dy;
          c.y = a.y + x * dy - y * dx;
        } else {
          c.x = a.x + db;
          c.y = a.y;
        }
      }
      d3.layout.tree = function() {
        var hierarchy = d3.layout.hierarchy().sort(null).value(null), separation = d3_layout_treeSeparation, size = [1, 1], nodeSize = null;
        function tree(d, i) {
          var nodes = hierarchy.call(this, d, i), root0 = nodes[0], root1 = wrapTree(root0);
          d3_layout_hierarchyVisitAfter(root1, firstWalk), root1.parent.m = -root1.z;
          d3_layout_hierarchyVisitBefore(root1, secondWalk);
          if (nodeSize) d3_layout_hierarchyVisitBefore(root0, sizeNode);
          else {
            var left = root0, right = root0, bottom = root0;
            d3_layout_hierarchyVisitBefore(root0, function(node) {
              if (node.x < left.x) left = node;
              if (node.x > right.x) right = node;
              if (node.depth > bottom.depth) bottom = node;
            });
            var tx = separation(left, right) / 2 - left.x, kx = size[0] / (right.x + separation(right, left) / 2 + tx), ky = size[1] / (bottom.depth || 1);
            d3_layout_hierarchyVisitBefore(root0, function(node) {
              node.x = (node.x + tx) * kx;
              node.y = node.depth * ky;
            });
          }
          return nodes;
        }
        function wrapTree(root0) {
          var root1 = {
            A: null,
            children: [root0]
          }, queue = [root1], node1;
          while ((node1 = queue.pop()) != null) {
            for (var children = node1.children, child, i = 0, n = children.length; i < n; ++i) {
              queue.push((children[i] = child = {
                _: children[i],
                parent: node1,
                children: (child = children[i].children) && child.slice() || [],
                A: null,
                a: null,
                z: 0,
                m: 0,
                c: 0,
                s: 0,
                t: null,
                i
              }).a = child);
            }
          }
          return root1.children[0];
        }
        function firstWalk(v) {
          var children = v.children, siblings = v.parent.children, w = v.i ? siblings[v.i - 1] : null;
          if (children.length) {
            d3_layout_treeShift(v);
            var midpoint = (children[0].z + children[children.length - 1].z) / 2;
            if (w) {
              v.z = w.z + separation(v._, w._);
              v.m = v.z - midpoint;
            } else {
              v.z = midpoint;
            }
          } else if (w) {
            v.z = w.z + separation(v._, w._);
          }
          v.parent.A = apportion(v, w, v.parent.A || siblings[0]);
        }
        function secondWalk(v) {
          v._.x = v.z + v.parent.m;
          v.m += v.parent.m;
        }
        function apportion(v, w, ancestor) {
          if (w) {
            var vip = v, vop = v, vim = w, vom = vip.parent.children[0], sip = vip.m, sop = vop.m, sim = vim.m, som = vom.m, shift;
            while (vim = d3_layout_treeRight(vim), vip = d3_layout_treeLeft(vip), vim && vip) {
              vom = d3_layout_treeLeft(vom);
              vop = d3_layout_treeRight(vop);
              vop.a = v;
              shift = vim.z + sim - vip.z - sip + separation(vim._, vip._);
              if (shift > 0) {
                d3_layout_treeMove(d3_layout_treeAncestor(vim, v, ancestor), v, shift);
                sip += shift;
                sop += shift;
              }
              sim += vim.m;
              sip += vip.m;
              som += vom.m;
              sop += vop.m;
            }
            if (vim && !d3_layout_treeRight(vop)) {
              vop.t = vim;
              vop.m += sim - sop;
            }
            if (vip && !d3_layout_treeLeft(vom)) {
              vom.t = vip;
              vom.m += sip - som;
              ancestor = v;
            }
          }
          return ancestor;
        }
        function sizeNode(node) {
          node.x *= size[0];
          node.y = node.depth * size[1];
        }
        tree.separation = function(x) {
          if (!arguments.length) return separation;
          separation = x;
          return tree;
        };
        tree.size = function(x) {
          if (!arguments.length) return nodeSize ? null : size;
          nodeSize = (size = x) == null ? sizeNode : null;
          return tree;
        };
        tree.nodeSize = function(x) {
          if (!arguments.length) return nodeSize ? size : null;
          nodeSize = (size = x) == null ? null : sizeNode;
          return tree;
        };
        return d3_layout_hierarchyRebind(tree, hierarchy);
      };
      function d3_layout_treeSeparation(a, b) {
        return a.parent == b.parent ? 1 : 2;
      }
      function d3_layout_treeLeft(v) {
        var children = v.children;
        return children.length ? children[0] : v.t;
      }
      function d3_layout_treeRight(v) {
        var children = v.children, n;
        return (n = children.length) ? children[n - 1] : v.t;
      }
      function d3_layout_treeMove(wm, wp2, shift) {
        var change = shift / (wp2.i - wm.i);
        wp2.c -= change;
        wp2.s += shift;
        wm.c += change;
        wp2.z += shift;
        wp2.m += shift;
      }
      function d3_layout_treeShift(v) {
        var shift = 0, change = 0, children = v.children, i = children.length, w;
        while (--i >= 0) {
          w = children[i];
          w.z += shift;
          w.m += shift;
          shift += w.s + (change += w.c);
        }
      }
      function d3_layout_treeAncestor(vim, v, ancestor) {
        return vim.a.parent === v.parent ? vim.a : ancestor;
      }
      d3.layout.cluster = function() {
        var hierarchy = d3.layout.hierarchy().sort(null).value(null), separation = d3_layout_treeSeparation, size = [1, 1], nodeSize = false;
        function cluster(d, i) {
          var nodes = hierarchy.call(this, d, i), root = nodes[0], previousNode, x = 0;
          d3_layout_hierarchyVisitAfter(root, function(node) {
            var children = node.children;
            if (children && children.length) {
              node.x = d3_layout_clusterX(children);
              node.y = d3_layout_clusterY(children);
            } else {
              node.x = previousNode ? x += separation(node, previousNode) : 0;
              node.y = 0;
              previousNode = node;
            }
          });
          var left = d3_layout_clusterLeft(root), right = d3_layout_clusterRight(root), x02 = left.x - separation(left, right) / 2, x12 = right.x + separation(right, left) / 2;
          d3_layout_hierarchyVisitAfter(root, nodeSize ? function(node) {
            node.x = (node.x - root.x) * size[0];
            node.y = (root.y - node.y) * size[1];
          } : function(node) {
            node.x = (node.x - x02) / (x12 - x02) * size[0];
            node.y = (1 - (root.y ? node.y / root.y : 1)) * size[1];
          });
          return nodes;
        }
        cluster.separation = function(x) {
          if (!arguments.length) return separation;
          separation = x;
          return cluster;
        };
        cluster.size = function(x) {
          if (!arguments.length) return nodeSize ? null : size;
          nodeSize = (size = x) == null;
          return cluster;
        };
        cluster.nodeSize = function(x) {
          if (!arguments.length) return nodeSize ? size : null;
          nodeSize = (size = x) != null;
          return cluster;
        };
        return d3_layout_hierarchyRebind(cluster, hierarchy);
      };
      function d3_layout_clusterY(children) {
        return 1 + d3.max(children, function(child) {
          return child.y;
        });
      }
      function d3_layout_clusterX(children) {
        return children.reduce(function(x, child) {
          return x + child.x;
        }, 0) / children.length;
      }
      function d3_layout_clusterLeft(node) {
        var children = node.children;
        return children && children.length ? d3_layout_clusterLeft(children[0]) : node;
      }
      function d3_layout_clusterRight(node) {
        var children = node.children, n;
        return children && (n = children.length) ? d3_layout_clusterRight(children[n - 1]) : node;
      }
      d3.layout.treemap = function() {
        var hierarchy = d3.layout.hierarchy(), round = Math.round, size = [1, 1], padding = null, pad2 = d3_layout_treemapPadNull, sticky = false, stickies, mode = "squarify", ratio = 0.5 * (1 + Math.sqrt(5));
        function scale(children, k) {
          var i = -1, n = children.length, child, area;
          while (++i < n) {
            area = (child = children[i]).value * (k < 0 ? 0 : k);
            child.area = isNaN(area) || area <= 0 ? 0 : area;
          }
        }
        function squarify(node) {
          var children = node.children;
          if (children && children.length) {
            var rect = pad2(node), row = [], remaining = children.slice(), child, best = Infinity, score, u = mode === "slice" ? rect.dx : mode === "dice" ? rect.dy : mode === "slice-dice" ? node.depth & 1 ? rect.dy : rect.dx : Math.min(rect.dx, rect.dy), n;
            scale(remaining, rect.dx * rect.dy / node.value);
            row.area = 0;
            while ((n = remaining.length) > 0) {
              row.push(child = remaining[n - 1]);
              row.area += child.area;
              if (mode !== "squarify" || (score = worst(row, u)) <= best) {
                remaining.pop();
                best = score;
              } else {
                row.area -= row.pop().area;
                position(row, u, rect, false);
                u = Math.min(rect.dx, rect.dy);
                row.length = row.area = 0;
                best = Infinity;
              }
            }
            if (row.length) {
              position(row, u, rect, true);
              row.length = row.area = 0;
            }
            children.forEach(squarify);
          }
        }
        function stickify(node) {
          var children = node.children;
          if (children && children.length) {
            var rect = pad2(node), remaining = children.slice(), child, row = [];
            scale(remaining, rect.dx * rect.dy / node.value);
            row.area = 0;
            while (child = remaining.pop()) {
              row.push(child);
              row.area += child.area;
              if (child.z != null) {
                position(row, child.z ? rect.dx : rect.dy, rect, !remaining.length);
                row.length = row.area = 0;
              }
            }
            children.forEach(stickify);
          }
        }
        function worst(row, u) {
          var s = row.area, r, rmax = 0, rmin = Infinity, i = -1, n = row.length;
          while (++i < n) {
            if (!(r = row[i].area)) continue;
            if (r < rmin) rmin = r;
            if (r > rmax) rmax = r;
          }
          s *= s;
          u *= u;
          return s ? Math.max(u * rmax * ratio / s, s / (u * rmin * ratio)) : Infinity;
        }
        function position(row, u, rect, flush) {
          var i = -1, n = row.length, x = rect.x, y = rect.y, v = u ? round(row.area / u) : 0, o;
          if (u == rect.dx) {
            if (flush || v > rect.dy) v = rect.dy;
            while (++i < n) {
              o = row[i];
              o.x = x;
              o.y = y;
              o.dy = v;
              x += o.dx = Math.min(rect.x + rect.dx - x, v ? round(o.area / v) : 0);
            }
            o.z = true;
            o.dx += rect.x + rect.dx - x;
            rect.y += v;
            rect.dy -= v;
          } else {
            if (flush || v > rect.dx) v = rect.dx;
            while (++i < n) {
              o = row[i];
              o.x = x;
              o.y = y;
              o.dx = v;
              y += o.dy = Math.min(rect.y + rect.dy - y, v ? round(o.area / v) : 0);
            }
            o.z = false;
            o.dy += rect.y + rect.dy - y;
            rect.x += v;
            rect.dx -= v;
          }
        }
        function treemap(d) {
          var nodes = stickies || hierarchy(d), root = nodes[0];
          root.x = root.y = 0;
          if (root.value) root.dx = size[0], root.dy = size[1];
          else root.dx = root.dy = 0;
          if (stickies) hierarchy.revalue(root);
          scale([root], root.dx * root.dy / root.value);
          (stickies ? stickify : squarify)(root);
          if (sticky) stickies = nodes;
          return nodes;
        }
        treemap.size = function(x) {
          if (!arguments.length) return size;
          size = x;
          return treemap;
        };
        treemap.padding = function(x) {
          if (!arguments.length) return padding;
          function padFunction(node) {
            var p = x.call(treemap, node, node.depth);
            return p == null ? d3_layout_treemapPadNull(node) : d3_layout_treemapPad(node, typeof p === "number" ? [p, p, p, p] : p);
          }
          function padConstant(node) {
            return d3_layout_treemapPad(node, x);
          }
          var type;
          pad2 = (padding = x) == null ? d3_layout_treemapPadNull : (type = typeof x) === "function" ? padFunction : type === "number" ? (x = [x, x, x, x], padConstant) : padConstant;
          return treemap;
        };
        treemap.round = function(x) {
          if (!arguments.length) return round != Number;
          round = x ? Math.round : Number;
          return treemap;
        };
        treemap.sticky = function(x) {
          if (!arguments.length) return sticky;
          sticky = x;
          stickies = null;
          return treemap;
        };
        treemap.ratio = function(x) {
          if (!arguments.length) return ratio;
          ratio = x;
          return treemap;
        };
        treemap.mode = function(x) {
          if (!arguments.length) return mode;
          mode = x + "";
          return treemap;
        };
        return d3_layout_hierarchyRebind(treemap, hierarchy);
      };
      function d3_layout_treemapPadNull(node) {
        return {
          x: node.x,
          y: node.y,
          dx: node.dx,
          dy: node.dy
        };
      }
      function d3_layout_treemapPad(node, padding) {
        var x = node.x + padding[3], y = node.y + padding[0], dx = node.dx - padding[1] - padding[3], dy = node.dy - padding[0] - padding[2];
        if (dx < 0) {
          x += dx / 2;
          dx = 0;
        }
        if (dy < 0) {
          y += dy / 2;
          dy = 0;
        }
        return {
          x,
          y,
          dx,
          dy
        };
      }
      d3.random = {
        normal: function(mu2, sigma) {
          var n = arguments.length;
          if (n < 2) sigma = 1;
          if (n < 1) mu2 = 0;
          return function() {
            var x, y, r;
            do {
              x = Math.random() * 2 - 1;
              y = Math.random() * 2 - 1;
              r = x * x + y * y;
            } while (!r || r > 1);
            return mu2 + sigma * x * Math.sqrt(-2 * Math.log(r) / r);
          };
        },
        logNormal: function() {
          var random = d3.random.normal.apply(d3, arguments);
          return function() {
            return Math.exp(random());
          };
        },
        bates: function(m) {
          var random = d3.random.irwinHall(m);
          return function() {
            return random() / m;
          };
        },
        irwinHall: function(m) {
          return function() {
            for (var s = 0, j = 0; j < m; j++) s += Math.random();
            return s;
          };
        }
      };
      d3.scale = {};
      function d3_scaleExtent(domain) {
        var start = domain[0], stop = domain[domain.length - 1];
        return start < stop ? [start, stop] : [stop, start];
      }
      function d3_scaleRange(scale) {
        return scale.rangeExtent ? scale.rangeExtent() : d3_scaleExtent(scale.range());
      }
      function d3_scale_bilinear(domain, range, uninterpolate, interpolate) {
        var u = uninterpolate(domain[0], domain[1]), i = interpolate(range[0], range[1]);
        return function(x) {
          return i(u(x));
        };
      }
      function d3_scale_nice(domain, nice) {
        var i02 = 0, i12 = domain.length - 1, x02 = domain[i02], x12 = domain[i12], dx;
        if (x12 < x02) {
          dx = i02, i02 = i12, i12 = dx;
          dx = x02, x02 = x12, x12 = dx;
        }
        domain[i02] = nice.floor(x02);
        domain[i12] = nice.ceil(x12);
        return domain;
      }
      function d3_scale_niceStep(step) {
        return step ? {
          floor: function(x) {
            return Math.floor(x / step) * step;
          },
          ceil: function(x) {
            return Math.ceil(x / step) * step;
          }
        } : d3_scale_niceIdentity;
      }
      var d3_scale_niceIdentity = {
        floor: d3_identity,
        ceil: d3_identity
      };
      function d3_scale_polylinear(domain, range, uninterpolate, interpolate) {
        var u = [], i = [], j = 0, k = Math.min(domain.length, range.length) - 1;
        if (domain[k] < domain[0]) {
          domain = domain.slice().reverse();
          range = range.slice().reverse();
        }
        while (++j <= k) {
          u.push(uninterpolate(domain[j - 1], domain[j]));
          i.push(interpolate(range[j - 1], range[j]));
        }
        return function(x) {
          var j2 = d3.bisect(domain, x, 1, k) - 1;
          return i[j2](u[j2](x));
        };
      }
      d3.scale.linear = function() {
        return d3_scale_linear([0, 1], [0, 1], d3_interpolate, false);
      };
      function d3_scale_linear(domain, range, interpolate, clamp) {
        var output, input;
        function rescale() {
          var linear = Math.min(domain.length, range.length) > 2 ? d3_scale_polylinear : d3_scale_bilinear, uninterpolate = clamp ? d3_uninterpolateClamp : d3_uninterpolateNumber;
          output = linear(domain, range, uninterpolate, interpolate);
          input = linear(range, domain, uninterpolate, d3_interpolate);
          return scale;
        }
        function scale(x) {
          return output(x);
        }
        scale.invert = function(y) {
          return input(y);
        };
        scale.domain = function(x) {
          if (!arguments.length) return domain;
          domain = x.map(Number);
          return rescale();
        };
        scale.range = function(x) {
          if (!arguments.length) return range;
          range = x;
          return rescale();
        };
        scale.rangeRound = function(x) {
          return scale.range(x).interpolate(d3_interpolateRound);
        };
        scale.clamp = function(x) {
          if (!arguments.length) return clamp;
          clamp = x;
          return rescale();
        };
        scale.interpolate = function(x) {
          if (!arguments.length) return interpolate;
          interpolate = x;
          return rescale();
        };
        scale.ticks = function(m) {
          return d3_scale_linearTicks(domain, m);
        };
        scale.tickFormat = function(m, format2) {
          return d3_scale_linearTickFormat(domain, m, format2);
        };
        scale.nice = function(m) {
          d3_scale_linearNice(domain, m);
          return rescale();
        };
        scale.copy = function() {
          return d3_scale_linear(domain, range, interpolate, clamp);
        };
        return rescale();
      }
      function d3_scale_linearRebind(scale, linear) {
        return d3.rebind(scale, linear, "range", "rangeRound", "interpolate", "clamp");
      }
      function d3_scale_linearNice(domain, m) {
        d3_scale_nice(domain, d3_scale_niceStep(d3_scale_linearTickRange(domain, m)[2]));
        d3_scale_nice(domain, d3_scale_niceStep(d3_scale_linearTickRange(domain, m)[2]));
        return domain;
      }
      function d3_scale_linearTickRange(domain, m) {
        if (m == null) m = 10;
        var extent = d3_scaleExtent(domain), span = extent[1] - extent[0], step = Math.pow(10, Math.floor(Math.log(span / m) / Math.LN10)), err = m / span * step;
        if (err <= 0.15) step *= 10;
        else if (err <= 0.35) step *= 5;
        else if (err <= 0.75) step *= 2;
        extent[0] = Math.ceil(extent[0] / step) * step;
        extent[1] = Math.floor(extent[1] / step) * step + step * 0.5;
        extent[2] = step;
        return extent;
      }
      function d3_scale_linearTicks(domain, m) {
        return d3.range.apply(d3, d3_scale_linearTickRange(domain, m));
      }
      var d3_scale_linearFormatSignificant = {
        s: 1,
        g: 1,
        p: 1,
        r: 1,
        e: 1
      };
      function d3_scale_linearPrecision(value) {
        return -Math.floor(Math.log(value) / Math.LN10 + 0.01);
      }
      function d3_scale_linearFormatPrecision(type, range) {
        var p = d3_scale_linearPrecision(range[2]);
        return type in d3_scale_linearFormatSignificant ? Math.abs(p - d3_scale_linearPrecision(Math.max(abs(range[0]), abs(range[1])))) + +(type !== "e") : p - (type === "%") * 2;
      }
      d3.scale.log = function() {
        return d3_scale_log(d3.scale.linear().domain([0, 1]), 10, true, [1, 10]);
      };
      function d3_scale_log(linear, base, positive, domain) {
        function log(x) {
          return (positive ? Math.log(x < 0 ? 0 : x) : -Math.log(x > 0 ? 0 : -x)) / Math.log(base);
        }
        function pow(x) {
          return positive ? Math.pow(base, x) : -Math.pow(base, -x);
        }
        function scale(x) {
          return linear(log(x));
        }
        scale.invert = function(x) {
          return pow(linear.invert(x));
        };
        scale.domain = function(x) {
          if (!arguments.length) return domain;
          positive = x[0] >= 0;
          linear.domain((domain = x.map(Number)).map(log));
          return scale;
        };
        scale.base = function(_) {
          if (!arguments.length) return base;
          base = +_;
          linear.domain(domain.map(log));
          return scale;
        };
        scale.nice = function() {
          var niced = d3_scale_nice(domain.map(log), positive ? Math : d3_scale_logNiceNegative);
          linear.domain(niced);
          domain = niced.map(pow);
          return scale;
        };
        scale.ticks = function() {
          var extent = d3_scaleExtent(domain), ticks = [], u = extent[0], v = extent[1], i = Math.floor(log(u)), j = Math.ceil(log(v)), n = base % 1 ? 2 : base;
          if (isFinite(j - i)) {
            if (positive) {
              for (; i < j; i++) for (var k = 1; k < n; k++) ticks.push(pow(i) * k);
              ticks.push(pow(i));
            } else {
              ticks.push(pow(i));
              for (; i++ < j; ) for (var k = n - 1; k > 0; k--) ticks.push(pow(i) * k);
            }
            for (i = 0; ticks[i] < u; i++) {
            }
            for (j = ticks.length; ticks[j - 1] > v; j--) {
            }
            ticks = ticks.slice(i, j);
          }
          return ticks;
        };
        scale.copy = function() {
          return d3_scale_log(linear.copy(), base, positive, domain);
        };
        return d3_scale_linearRebind(scale, linear);
      }
      var d3_scale_logNiceNegative = {
        floor: function(x) {
          return -Math.ceil(-x);
        },
        ceil: function(x) {
          return -Math.floor(-x);
        }
      };
      d3.scale.pow = function() {
        return d3_scale_pow(d3.scale.linear(), 1, [0, 1]);
      };
      function d3_scale_pow(linear, exponent, domain) {
        var powp = d3_scale_powPow(exponent), powb = d3_scale_powPow(1 / exponent);
        function scale(x) {
          return linear(powp(x));
        }
        scale.invert = function(x) {
          return powb(linear.invert(x));
        };
        scale.domain = function(x) {
          if (!arguments.length) return domain;
          linear.domain((domain = x.map(Number)).map(powp));
          return scale;
        };
        scale.ticks = function(m) {
          return d3_scale_linearTicks(domain, m);
        };
        scale.tickFormat = function(m, format2) {
          return d3_scale_linearTickFormat(domain, m, format2);
        };
        scale.nice = function(m) {
          return scale.domain(d3_scale_linearNice(domain, m));
        };
        scale.exponent = function(x) {
          if (!arguments.length) return exponent;
          powp = d3_scale_powPow(exponent = x);
          powb = d3_scale_powPow(1 / exponent);
          linear.domain(domain.map(powp));
          return scale;
        };
        scale.copy = function() {
          return d3_scale_pow(linear.copy(), exponent, domain);
        };
        return d3_scale_linearRebind(scale, linear);
      }
      function d3_scale_powPow(e) {
        return function(x) {
          return x < 0 ? -Math.pow(-x, e) : Math.pow(x, e);
        };
      }
      d3.scale.sqrt = function() {
        return d3.scale.pow().exponent(0.5);
      };
      d3.scale.ordinal = function() {
        return d3_scale_ordinal([], {
          t: "range",
          a: [[]]
        });
      };
      function d3_scale_ordinal(domain, ranger) {
        var index, range, rangeBand;
        function scale(x) {
          return range[((index.get(x) || (ranger.t === "range" ? index.set(x, domain.push(x)) : NaN)) - 1) % range.length];
        }
        function steps(start, step) {
          return d3.range(domain.length).map(function(i) {
            return start + step * i;
          });
        }
        scale.domain = function(x) {
          if (!arguments.length) return domain;
          domain = [];
          index = new d3_Map();
          var i = -1, n = x.length, xi2;
          while (++i < n) if (!index.has(xi2 = x[i])) index.set(xi2, domain.push(xi2));
          return scale[ranger.t].apply(scale, ranger.a);
        };
        scale.range = function(x) {
          if (!arguments.length) return range;
          range = x;
          rangeBand = 0;
          ranger = {
            t: "range",
            a: arguments
          };
          return scale;
        };
        scale.rangePoints = function(x, padding) {
          if (arguments.length < 2) padding = 0;
          var start = x[0], stop = x[1], step = domain.length < 2 ? (start = (start + stop) / 2, 0) : (stop - start) / (domain.length - 1 + padding);
          range = steps(start + step * padding / 2, step);
          rangeBand = 0;
          ranger = {
            t: "rangePoints",
            a: arguments
          };
          return scale;
        };
        scale.rangeRoundPoints = function(x, padding) {
          if (arguments.length < 2) padding = 0;
          var start = x[0], stop = x[1], step = domain.length < 2 ? (start = stop = Math.round((start + stop) / 2), 0) : (stop - start) / (domain.length - 1 + padding) | 0;
          range = steps(start + Math.round(step * padding / 2 + (stop - start - (domain.length - 1 + padding) * step) / 2), step);
          rangeBand = 0;
          ranger = {
            t: "rangeRoundPoints",
            a: arguments
          };
          return scale;
        };
        scale.rangeBands = function(x, padding, outerPadding) {
          if (arguments.length < 2) padding = 0;
          if (arguments.length < 3) outerPadding = padding;
          var reverse = x[1] < x[0], start = x[reverse - 0], stop = x[1 - reverse], step = (stop - start) / (domain.length - padding + 2 * outerPadding);
          range = steps(start + step * outerPadding, step);
          if (reverse) range.reverse();
          rangeBand = step * (1 - padding);
          ranger = {
            t: "rangeBands",
            a: arguments
          };
          return scale;
        };
        scale.rangeRoundBands = function(x, padding, outerPadding) {
          if (arguments.length < 2) padding = 0;
          if (arguments.length < 3) outerPadding = padding;
          var reverse = x[1] < x[0], start = x[reverse - 0], stop = x[1 - reverse], step = Math.floor((stop - start) / (domain.length - padding + 2 * outerPadding));
          range = steps(start + Math.round((stop - start - (domain.length - padding) * step) / 2), step);
          if (reverse) range.reverse();
          rangeBand = Math.round(step * (1 - padding));
          ranger = {
            t: "rangeRoundBands",
            a: arguments
          };
          return scale;
        };
        scale.rangeBand = function() {
          return rangeBand;
        };
        scale.rangeExtent = function() {
          return d3_scaleExtent(ranger.a[0]);
        };
        scale.copy = function() {
          return d3_scale_ordinal(domain, ranger);
        };
        return scale.domain(domain);
      }
      d3.scale.category10 = function() {
        return d3.scale.ordinal().range(d3_category10);
      };
      d3.scale.category20 = function() {
        return d3.scale.ordinal().range(d3_category20);
      };
      d3.scale.category20b = function() {
        return d3.scale.ordinal().range(d3_category20b);
      };
      d3.scale.category20c = function() {
        return d3.scale.ordinal().range(d3_category20c);
      };
      var d3_category10 = [2062260, 16744206, 2924588, 14034728, 9725885, 9197131, 14907330, 8355711, 12369186, 1556175].map(d3_rgbString);
      var d3_category20 = [2062260, 11454440, 16744206, 16759672, 2924588, 10018698, 14034728, 16750742, 9725885, 12955861, 9197131, 12885140, 14907330, 16234194, 8355711, 13092807, 12369186, 14408589, 1556175, 10410725].map(d3_rgbString);
      var d3_category20b = [3750777, 5395619, 7040719, 10264286, 6519097, 9216594, 11915115, 13556636, 9202993, 12426809, 15186514, 15190932, 8666169, 11356490, 14049643, 15177372, 8077683, 10834324, 13528509, 14589654].map(d3_rgbString);
      var d3_category20c = [3244733, 7057110, 10406625, 13032431, 15095053, 16616764, 16625259, 16634018, 3253076, 7652470, 10607003, 13101504, 7695281, 10394312, 12369372, 14342891, 6513507, 9868950, 12434877, 14277081].map(d3_rgbString);
      d3.scale.quantile = function() {
        return d3_scale_quantile([], []);
      };
      function d3_scale_quantile(domain, range) {
        var thresholds;
        function rescale() {
          var k = 0, q = range.length;
          thresholds = [];
          while (++k < q) thresholds[k - 1] = d3.quantile(domain, k / q);
          return scale;
        }
        function scale(x) {
          if (!isNaN(x = +x)) return range[d3.bisect(thresholds, x)];
        }
        scale.domain = function(x) {
          if (!arguments.length) return domain;
          domain = x.map(d3_number).filter(d3_numeric).sort(d3_ascending);
          return rescale();
        };
        scale.range = function(x) {
          if (!arguments.length) return range;
          range = x;
          return rescale();
        };
        scale.quantiles = function() {
          return thresholds;
        };
        scale.invertExtent = function(y) {
          y = range.indexOf(y);
          return y < 0 ? [NaN, NaN] : [y > 0 ? thresholds[y - 1] : domain[0], y < thresholds.length ? thresholds[y] : domain[domain.length - 1]];
        };
        scale.copy = function() {
          return d3_scale_quantile(domain, range);
        };
        return rescale();
      }
      d3.scale.quantize = function() {
        return d3_scale_quantize(0, 1, [0, 1]);
      };
      function d3_scale_quantize(x02, x12, range) {
        var kx, i;
        function scale(x) {
          return range[Math.max(0, Math.min(i, Math.floor(kx * (x - x02))))];
        }
        function rescale() {
          kx = range.length / (x12 - x02);
          i = range.length - 1;
          return scale;
        }
        scale.domain = function(x) {
          if (!arguments.length) return [x02, x12];
          x02 = +x[0];
          x12 = +x[x.length - 1];
          return rescale();
        };
        scale.range = function(x) {
          if (!arguments.length) return range;
          range = x;
          return rescale();
        };
        scale.invertExtent = function(y) {
          y = range.indexOf(y);
          y = y < 0 ? NaN : y / kx + x02;
          return [y, y + 1 / kx];
        };
        scale.copy = function() {
          return d3_scale_quantize(x02, x12, range);
        };
        return rescale();
      }
      d3.scale.threshold = function() {
        return d3_scale_threshold([0.5], [0, 1]);
      };
      function d3_scale_threshold(domain, range) {
        function scale(x) {
          if (x <= x) return range[d3.bisect(domain, x)];
        }
        scale.domain = function(_) {
          if (!arguments.length) return domain;
          domain = _;
          return scale;
        };
        scale.range = function(_) {
          if (!arguments.length) return range;
          range = _;
          return scale;
        };
        scale.invertExtent = function(y) {
          y = range.indexOf(y);
          return [domain[y - 1], domain[y]];
        };
        scale.copy = function() {
          return d3_scale_threshold(domain, range);
        };
        return scale;
      }
      d3.scale.identity = function() {
        return d3_scale_identity([0, 1]);
      };
      function d3_scale_identity(domain) {
        function identity(x) {
          return +x;
        }
        identity.invert = identity;
        identity.domain = identity.range = function(x) {
          if (!arguments.length) return domain;
          domain = x.map(identity);
          return identity;
        };
        identity.ticks = function(m) {
          return d3_scale_linearTicks(domain, m);
        };
        identity.tickFormat = function(m, format2) {
          return d3_scale_linearTickFormat(domain, m, format2);
        };
        identity.copy = function() {
          return d3_scale_identity(domain);
        };
        return identity;
      }
      d3.svg = {};
      function d3_zero() {
        return 0;
      }
      d3.svg.arc = function() {
        var innerRadius = d3_svg_arcInnerRadius, outerRadius = d3_svg_arcOuterRadius, cornerRadius = d3_zero, padRadius = d3_svg_arcAuto, startAngle = d3_svg_arcStartAngle, endAngle = d3_svg_arcEndAngle, padAngle = d3_svg_arcPadAngle;
        function arc() {
          var r02 = Math.max(0, +innerRadius.apply(this, arguments)), r12 = Math.max(0, +outerRadius.apply(this, arguments)), a02 = startAngle.apply(this, arguments) - halfπ, a12 = endAngle.apply(this, arguments) - halfπ, da2 = Math.abs(a12 - a02), cw = a02 > a12 ? 0 : 1;
          if (r12 < r02) rc2 = r12, r12 = r02, r02 = rc2;
          if (da2 >= τε) return circleSegment(r12, cw) + (r02 ? circleSegment(r02, 1 - cw) : "") + "Z";
          var rc2, cr2, rp2, ap2, p02 = 0, p12 = 0, x02, y02, x12, y12, x2, y2, x3, y3, path = [];
          if (ap2 = (+padAngle.apply(this, arguments) || 0) / 2) {
            rp2 = padRadius === d3_svg_arcAuto ? Math.sqrt(r02 * r02 + r12 * r12) : +padRadius.apply(this, arguments);
            if (!cw) p12 *= -1;
            if (r12) p12 = d3_asin(rp2 / r12 * Math.sin(ap2));
            if (r02) p02 = d3_asin(rp2 / r02 * Math.sin(ap2));
          }
          if (r12) {
            x02 = r12 * Math.cos(a02 + p12);
            y02 = r12 * Math.sin(a02 + p12);
            x12 = r12 * Math.cos(a12 - p12);
            y12 = r12 * Math.sin(a12 - p12);
            var l12 = Math.abs(a12 - a02 - 2 * p12) <= π ? 0 : 1;
            if (p12 && d3_svg_arcSweep(x02, y02, x12, y12) === cw ^ l12) {
              var h12 = (a02 + a12) / 2;
              x02 = r12 * Math.cos(h12);
              y02 = r12 * Math.sin(h12);
              x12 = y12 = null;
            }
          } else {
            x02 = y02 = 0;
          }
          if (r02) {
            x2 = r02 * Math.cos(a12 - p02);
            y2 = r02 * Math.sin(a12 - p02);
            x3 = r02 * Math.cos(a02 + p02);
            y3 = r02 * Math.sin(a02 + p02);
            var l02 = Math.abs(a02 - a12 + 2 * p02) <= π ? 0 : 1;
            if (p02 && d3_svg_arcSweep(x2, y2, x3, y3) === 1 - cw ^ l02) {
              var h02 = (a02 + a12) / 2;
              x2 = r02 * Math.cos(h02);
              y2 = r02 * Math.sin(h02);
              x3 = y3 = null;
            }
          } else {
            x2 = y2 = 0;
          }
          if (da2 > ε && (rc2 = Math.min(Math.abs(r12 - r02) / 2, +cornerRadius.apply(this, arguments))) > 1e-3) {
            cr2 = r02 < r12 ^ cw ? 0 : 1;
            var rc1 = rc2, rc0 = rc2;
            if (da2 < π) {
              var oc2 = x3 == null ? [x2, y2] : x12 == null ? [x02, y02] : d3_geom_polygonIntersect([x02, y02], [x3, y3], [x12, y12], [x2, y2]), ax = x02 - oc2[0], ay = y02 - oc2[1], bx = x12 - oc2[0], by = y12 - oc2[1], kc2 = 1 / Math.sin(Math.acos((ax * bx + ay * by) / (Math.sqrt(ax * ax + ay * ay) * Math.sqrt(bx * bx + by * by))) / 2), lc2 = Math.sqrt(oc2[0] * oc2[0] + oc2[1] * oc2[1]);
              rc0 = Math.min(rc2, (r02 - lc2) / (kc2 - 1));
              rc1 = Math.min(rc2, (r12 - lc2) / (kc2 + 1));
            }
            if (x12 != null) {
              var t30 = d3_svg_arcCornerTangents(x3 == null ? [x2, y2] : [x3, y3], [x02, y02], r12, rc1, cw), t122 = d3_svg_arcCornerTangents([x12, y12], [x2, y2], r12, rc1, cw);
              if (rc2 === rc1) {
                path.push("M", t30[0], "A", rc1, ",", rc1, " 0 0,", cr2, " ", t30[1], "A", r12, ",", r12, " 0 ", 1 - cw ^ d3_svg_arcSweep(t30[1][0], t30[1][1], t122[1][0], t122[1][1]), ",", cw, " ", t122[1], "A", rc1, ",", rc1, " 0 0,", cr2, " ", t122[0]);
              } else {
                path.push("M", t30[0], "A", rc1, ",", rc1, " 0 1,", cr2, " ", t122[0]);
              }
            } else {
              path.push("M", x02, ",", y02);
            }
            if (x3 != null) {
              var t03 = d3_svg_arcCornerTangents([x02, y02], [x3, y3], r02, -rc0, cw), t21 = d3_svg_arcCornerTangents([x2, y2], x12 == null ? [x02, y02] : [x12, y12], r02, -rc0, cw);
              if (rc2 === rc0) {
                path.push("L", t21[0], "A", rc0, ",", rc0, " 0 0,", cr2, " ", t21[1], "A", r02, ",", r02, " 0 ", cw ^ d3_svg_arcSweep(t21[1][0], t21[1][1], t03[1][0], t03[1][1]), ",", 1 - cw, " ", t03[1], "A", rc0, ",", rc0, " 0 0,", cr2, " ", t03[0]);
              } else {
                path.push("L", t21[0], "A", rc0, ",", rc0, " 0 0,", cr2, " ", t03[0]);
              }
            } else {
              path.push("L", x2, ",", y2);
            }
          } else {
            path.push("M", x02, ",", y02);
            if (x12 != null) path.push("A", r12, ",", r12, " 0 ", l12, ",", cw, " ", x12, ",", y12);
            path.push("L", x2, ",", y2);
            if (x3 != null) path.push("A", r02, ",", r02, " 0 ", l02, ",", 1 - cw, " ", x3, ",", y3);
          }
          path.push("Z");
          return path.join("");
        }
        function circleSegment(r12, cw) {
          return "M0," + r12 + "A" + r12 + "," + r12 + " 0 1," + cw + " 0," + -r12 + "A" + r12 + "," + r12 + " 0 1," + cw + " 0," + r12;
        }
        arc.innerRadius = function(v) {
          if (!arguments.length) return innerRadius;
          innerRadius = d3_functor(v);
          return arc;
        };
        arc.outerRadius = function(v) {
          if (!arguments.length) return outerRadius;
          outerRadius = d3_functor(v);
          return arc;
        };
        arc.cornerRadius = function(v) {
          if (!arguments.length) return cornerRadius;
          cornerRadius = d3_functor(v);
          return arc;
        };
        arc.padRadius = function(v) {
          if (!arguments.length) return padRadius;
          padRadius = v == d3_svg_arcAuto ? d3_svg_arcAuto : d3_functor(v);
          return arc;
        };
        arc.startAngle = function(v) {
          if (!arguments.length) return startAngle;
          startAngle = d3_functor(v);
          return arc;
        };
        arc.endAngle = function(v) {
          if (!arguments.length) return endAngle;
          endAngle = d3_functor(v);
          return arc;
        };
        arc.padAngle = function(v) {
          if (!arguments.length) return padAngle;
          padAngle = d3_functor(v);
          return arc;
        };
        arc.centroid = function() {
          var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2, a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - halfπ;
          return [Math.cos(a) * r, Math.sin(a) * r];
        };
        return arc;
      };
      var d3_svg_arcAuto = "auto";
      function d3_svg_arcInnerRadius(d) {
        return d.innerRadius;
      }
      function d3_svg_arcOuterRadius(d) {
        return d.outerRadius;
      }
      function d3_svg_arcStartAngle(d) {
        return d.startAngle;
      }
      function d3_svg_arcEndAngle(d) {
        return d.endAngle;
      }
      function d3_svg_arcPadAngle(d) {
        return d && d.padAngle;
      }
      function d3_svg_arcSweep(x02, y02, x12, y12) {
        return (x02 - x12) * y02 - (y02 - y12) * x02 > 0 ? 0 : 1;
      }
      function d3_svg_arcCornerTangents(p02, p12, r12, rc2, cw) {
        var x01 = p02[0] - p12[0], y01 = p02[1] - p12[1], lo2 = (cw ? rc2 : -rc2) / Math.sqrt(x01 * x01 + y01 * y01), ox = lo2 * y01, oy = -lo2 * x01, x12 = p02[0] + ox, y12 = p02[1] + oy, x2 = p12[0] + ox, y2 = p12[1] + oy, x3 = (x12 + x2) / 2, y3 = (y12 + y2) / 2, dx = x2 - x12, dy = y2 - y12, d2 = dx * dx + dy * dy, r = r12 - rc2, D = x12 * y2 - x2 * y12, d = (dy < 0 ? -1 : 1) * Math.sqrt(Math.max(0, r * r * d2 - D * D)), cx0 = (D * dy - dx * d) / d2, cy0 = (-D * dx - dy * d) / d2, cx1 = (D * dy + dx * d) / d2, cy1 = (-D * dx + dy * d) / d2, dx0 = cx0 - x3, dy0 = cy0 - y3, dx1 = cx1 - x3, dy1 = cy1 - y3;
        if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1) cx0 = cx1, cy0 = cy1;
        return [[cx0 - ox, cy0 - oy], [cx0 * r12 / r, cy0 * r12 / r]];
      }
      function d3_true() {
        return true;
      }
      function d3_svg_line(projection) {
        var x = d3_geom_pointX, y = d3_geom_pointY, defined = d3_true, interpolate = d3_svg_lineLinear, interpolateKey = interpolate.key, tension = 0.7;
        function line(data) {
          var segments = [], points = [], i = -1, n = data.length, d, fx = d3_functor(x), fy = d3_functor(y);
          function segment() {
            segments.push("M", interpolate(projection(points), tension));
          }
          while (++i < n) {
            if (defined.call(this, d = data[i], i)) {
              points.push([+fx.call(this, d, i), +fy.call(this, d, i)]);
            } else if (points.length) {
              segment();
              points = [];
            }
          }
          if (points.length) segment();
          return segments.length ? segments.join("") : null;
        }
        line.x = function(_) {
          if (!arguments.length) return x;
          x = _;
          return line;
        };
        line.y = function(_) {
          if (!arguments.length) return y;
          y = _;
          return line;
        };
        line.defined = function(_) {
          if (!arguments.length) return defined;
          defined = _;
          return line;
        };
        line.interpolate = function(_) {
          if (!arguments.length) return interpolateKey;
          if (typeof _ === "function") interpolateKey = interpolate = _;
          else interpolateKey = (interpolate = d3_svg_lineInterpolators.get(_) || d3_svg_lineLinear).key;
          return line;
        };
        line.tension = function(_) {
          if (!arguments.length) return tension;
          tension = _;
          return line;
        };
        return line;
      }
      d3.svg.line = function() {
        return d3_svg_line(d3_identity);
      };
      var d3_svg_lineInterpolators = d3.map({
        linear: d3_svg_lineLinear,
        "linear-closed": d3_svg_lineLinearClosed,
        step: d3_svg_lineStep,
        "step-before": d3_svg_lineStepBefore,
        "step-after": d3_svg_lineStepAfter,
        basis: d3_svg_lineBasis,
        "basis-open": d3_svg_lineBasisOpen,
        "basis-closed": d3_svg_lineBasisClosed,
        bundle: d3_svg_lineBundle,
        cardinal: d3_svg_lineCardinal,
        "cardinal-open": d3_svg_lineCardinalOpen,
        "cardinal-closed": d3_svg_lineCardinalClosed,
        monotone: d3_svg_lineMonotone
      });
      d3_svg_lineInterpolators.forEach(function(key, value) {
        value.key = key;
        value.closed = /-closed$/.test(key);
      });
      function d3_svg_lineLinear(points) {
        return points.length > 1 ? points.join("L") : points + "Z";
      }
      function d3_svg_lineLinearClosed(points) {
        return points.join("L") + "Z";
      }
      function d3_svg_lineStep(points) {
        var i = 0, n = points.length, p = points[0], path = [p[0], ",", p[1]];
        while (++i < n) path.push("H", (p[0] + (p = points[i])[0]) / 2, "V", p[1]);
        if (n > 1) path.push("H", p[0]);
        return path.join("");
      }
      function d3_svg_lineStepBefore(points) {
        var i = 0, n = points.length, p = points[0], path = [p[0], ",", p[1]];
        while (++i < n) path.push("V", (p = points[i])[1], "H", p[0]);
        return path.join("");
      }
      function d3_svg_lineStepAfter(points) {
        var i = 0, n = points.length, p = points[0], path = [p[0], ",", p[1]];
        while (++i < n) path.push("H", (p = points[i])[0], "V", p[1]);
        return path.join("");
      }
      function d3_svg_lineCardinalOpen(points, tension) {
        return points.length < 4 ? d3_svg_lineLinear(points) : points[1] + d3_svg_lineHermite(points.slice(1, -1), d3_svg_lineCardinalTangents(points, tension));
      }
      function d3_svg_lineCardinalClosed(points, tension) {
        return points.length < 3 ? d3_svg_lineLinearClosed(points) : points[0] + d3_svg_lineHermite((points.push(points[0]), points), d3_svg_lineCardinalTangents([points[points.length - 2]].concat(points, [points[1]]), tension));
      }
      function d3_svg_lineCardinal(points, tension) {
        return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite(points, d3_svg_lineCardinalTangents(points, tension));
      }
      function d3_svg_lineHermite(points, tangents) {
        if (tangents.length < 1 || points.length != tangents.length && points.length != tangents.length + 2) {
          return d3_svg_lineLinear(points);
        }
        var quad = points.length != tangents.length, path = "", p02 = points[0], p = points[1], t03 = tangents[0], t = t03, pi2 = 1;
        if (quad) {
          path += "Q" + (p[0] - t03[0] * 2 / 3) + "," + (p[1] - t03[1] * 2 / 3) + "," + p[0] + "," + p[1];
          p02 = points[1];
          pi2 = 2;
        }
        if (tangents.length > 1) {
          t = tangents[1];
          p = points[pi2];
          pi2++;
          path += "C" + (p02[0] + t03[0]) + "," + (p02[1] + t03[1]) + "," + (p[0] - t[0]) + "," + (p[1] - t[1]) + "," + p[0] + "," + p[1];
          for (var i = 2; i < tangents.length; i++, pi2++) {
            p = points[pi2];
            t = tangents[i];
            path += "S" + (p[0] - t[0]) + "," + (p[1] - t[1]) + "," + p[0] + "," + p[1];
          }
        }
        if (quad) {
          var lp2 = points[pi2];
          path += "Q" + (p[0] + t[0] * 2 / 3) + "," + (p[1] + t[1] * 2 / 3) + "," + lp2[0] + "," + lp2[1];
        }
        return path;
      }
      function d3_svg_lineCardinalTangents(points, tension) {
        var tangents = [], a = (1 - tension) / 2, p02, p12 = points[0], p2 = points[1], i = 1, n = points.length;
        while (++i < n) {
          p02 = p12;
          p12 = p2;
          p2 = points[i];
          tangents.push([a * (p2[0] - p02[0]), a * (p2[1] - p02[1])]);
        }
        return tangents;
      }
      function d3_svg_lineBasis(points) {
        if (points.length < 3) return d3_svg_lineLinear(points);
        var i = 1, n = points.length, pi2 = points[0], x02 = pi2[0], y02 = pi2[1], px = [x02, x02, x02, (pi2 = points[1])[0]], py = [y02, y02, y02, pi2[1]], path = [x02, ",", y02, "L", d3_svg_lineDot4(d3_svg_lineBasisBezier3, px), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, py)];
        points.push(points[n - 1]);
        while (++i <= n) {
          pi2 = points[i];
          px.shift();
          px.push(pi2[0]);
          py.shift();
          py.push(pi2[1]);
          d3_svg_lineBasisBezier(path, px, py);
        }
        points.pop();
        path.push("L", pi2);
        return path.join("");
      }
      function d3_svg_lineBasisOpen(points) {
        if (points.length < 4) return d3_svg_lineLinear(points);
        var path = [], i = -1, n = points.length, pi2, px = [0], py = [0];
        while (++i < 3) {
          pi2 = points[i];
          px.push(pi2[0]);
          py.push(pi2[1]);
        }
        path.push(d3_svg_lineDot4(d3_svg_lineBasisBezier3, px) + "," + d3_svg_lineDot4(d3_svg_lineBasisBezier3, py));
        --i;
        while (++i < n) {
          pi2 = points[i];
          px.shift();
          px.push(pi2[0]);
          py.shift();
          py.push(pi2[1]);
          d3_svg_lineBasisBezier(path, px, py);
        }
        return path.join("");
      }
      function d3_svg_lineBasisClosed(points) {
        var path, i = -1, n = points.length, m = n + 4, pi2, px = [], py = [];
        while (++i < 4) {
          pi2 = points[i % n];
          px.push(pi2[0]);
          py.push(pi2[1]);
        }
        path = [d3_svg_lineDot4(d3_svg_lineBasisBezier3, px), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, py)];
        --i;
        while (++i < m) {
          pi2 = points[i % n];
          px.shift();
          px.push(pi2[0]);
          py.shift();
          py.push(pi2[1]);
          d3_svg_lineBasisBezier(path, px, py);
        }
        return path.join("");
      }
      function d3_svg_lineBundle(points, tension) {
        var n = points.length - 1;
        if (n) {
          var x02 = points[0][0], y02 = points[0][1], dx = points[n][0] - x02, dy = points[n][1] - y02, i = -1, p, t;
          while (++i <= n) {
            p = points[i];
            t = i / n;
            p[0] = tension * p[0] + (1 - tension) * (x02 + t * dx);
            p[1] = tension * p[1] + (1 - tension) * (y02 + t * dy);
          }
        }
        return d3_svg_lineBasis(points);
      }
      function d3_svg_lineDot4(a, b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2] + a[3] * b[3];
      }
      var d3_svg_lineBasisBezier1 = [0, 2 / 3, 1 / 3, 0], d3_svg_lineBasisBezier2 = [0, 1 / 3, 2 / 3, 0], d3_svg_lineBasisBezier3 = [0, 1 / 6, 2 / 3, 1 / 6];
      function d3_svg_lineBasisBezier(path, x, y) {
        path.push("C", d3_svg_lineDot4(d3_svg_lineBasisBezier1, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier1, y), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier2, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier2, y), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, y));
      }
      function d3_svg_lineSlope(p02, p12) {
        return (p12[1] - p02[1]) / (p12[0] - p02[0]);
      }
      function d3_svg_lineFiniteDifferences(points) {
        var i = 0, j = points.length - 1, m = [], p02 = points[0], p12 = points[1], d = m[0] = d3_svg_lineSlope(p02, p12);
        while (++i < j) {
          m[i] = (d + (d = d3_svg_lineSlope(p02 = p12, p12 = points[i + 1]))) / 2;
        }
        m[i] = d;
        return m;
      }
      function d3_svg_lineMonotoneTangents(points) {
        var tangents = [], d, a, b, s, m = d3_svg_lineFiniteDifferences(points), i = -1, j = points.length - 1;
        while (++i < j) {
          d = d3_svg_lineSlope(points[i], points[i + 1]);
          if (abs(d) < ε) {
            m[i] = m[i + 1] = 0;
          } else {
            a = m[i] / d;
            b = m[i + 1] / d;
            s = a * a + b * b;
            if (s > 9) {
              s = d * 3 / Math.sqrt(s);
              m[i] = s * a;
              m[i + 1] = s * b;
            }
          }
        }
        i = -1;
        while (++i <= j) {
          s = (points[Math.min(j, i + 1)][0] - points[Math.max(0, i - 1)][0]) / (6 * (1 + m[i] * m[i]));
          tangents.push([s || 0, m[i] * s || 0]);
        }
        return tangents;
      }
      function d3_svg_lineMonotone(points) {
        return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite(points, d3_svg_lineMonotoneTangents(points));
      }
      d3.svg.line.radial = function() {
        var line = d3_svg_line(d3_svg_lineRadial);
        line.radius = line.x, delete line.x;
        line.angle = line.y, delete line.y;
        return line;
      };
      function d3_svg_lineRadial(points) {
        var point, i = -1, n = points.length, r, a;
        while (++i < n) {
          point = points[i];
          r = point[0];
          a = point[1] - halfπ;
          point[0] = r * Math.cos(a);
          point[1] = r * Math.sin(a);
        }
        return points;
      }
      function d3_svg_area(projection) {
        var x02 = d3_geom_pointX, x12 = d3_geom_pointX, y02 = 0, y12 = d3_geom_pointY, defined = d3_true, interpolate = d3_svg_lineLinear, interpolateKey = interpolate.key, interpolateReverse = interpolate, L = "L", tension = 0.7;
        function area(data) {
          var segments = [], points0 = [], points1 = [], i = -1, n = data.length, d, fx0 = d3_functor(x02), fy0 = d3_functor(y02), fx1 = x02 === x12 ? function() {
            return x;
          } : d3_functor(x12), fy1 = y02 === y12 ? function() {
            return y;
          } : d3_functor(y12), x, y;
          function segment() {
            segments.push("M", interpolate(projection(points1), tension), L, interpolateReverse(projection(points0.reverse()), tension), "Z");
          }
          while (++i < n) {
            if (defined.call(this, d = data[i], i)) {
              points0.push([x = +fx0.call(this, d, i), y = +fy0.call(this, d, i)]);
              points1.push([+fx1.call(this, d, i), +fy1.call(this, d, i)]);
            } else if (points0.length) {
              segment();
              points0 = [];
              points1 = [];
            }
          }
          if (points0.length) segment();
          return segments.length ? segments.join("") : null;
        }
        area.x = function(_) {
          if (!arguments.length) return x12;
          x02 = x12 = _;
          return area;
        };
        area.x0 = function(_) {
          if (!arguments.length) return x02;
          x02 = _;
          return area;
        };
        area.x1 = function(_) {
          if (!arguments.length) return x12;
          x12 = _;
          return area;
        };
        area.y = function(_) {
          if (!arguments.length) return y12;
          y02 = y12 = _;
          return area;
        };
        area.y0 = function(_) {
          if (!arguments.length) return y02;
          y02 = _;
          return area;
        };
        area.y1 = function(_) {
          if (!arguments.length) return y12;
          y12 = _;
          return area;
        };
        area.defined = function(_) {
          if (!arguments.length) return defined;
          defined = _;
          return area;
        };
        area.interpolate = function(_) {
          if (!arguments.length) return interpolateKey;
          if (typeof _ === "function") interpolateKey = interpolate = _;
          else interpolateKey = (interpolate = d3_svg_lineInterpolators.get(_) || d3_svg_lineLinear).key;
          interpolateReverse = interpolate.reverse || interpolate;
          L = interpolate.closed ? "M" : "L";
          return area;
        };
        area.tension = function(_) {
          if (!arguments.length) return tension;
          tension = _;
          return area;
        };
        return area;
      }
      d3_svg_lineStepBefore.reverse = d3_svg_lineStepAfter;
      d3_svg_lineStepAfter.reverse = d3_svg_lineStepBefore;
      d3.svg.area = function() {
        return d3_svg_area(d3_identity);
      };
      d3.svg.area.radial = function() {
        var area = d3_svg_area(d3_svg_lineRadial);
        area.radius = area.x, delete area.x;
        area.innerRadius = area.x0, delete area.x0;
        area.outerRadius = area.x1, delete area.x1;
        area.angle = area.y, delete area.y;
        area.startAngle = area.y0, delete area.y0;
        area.endAngle = area.y1, delete area.y1;
        return area;
      };
      function d3_source(d) {
        return d.source;
      }
      function d3_target(d) {
        return d.target;
      }
      d3.svg.chord = function() {
        var source = d3_source, target = d3_target, radius = d3_svg_chordRadius, startAngle = d3_svg_arcStartAngle, endAngle = d3_svg_arcEndAngle;
        function chord(d, i) {
          var s = subgroup(this, source, d, i), t = subgroup(this, target, d, i);
          return "M" + s.p0 + arc(s.r, s.p1, s.a1 - s.a0) + (equals(s, t) ? curve(s.r, s.p1, s.r, s.p0) : curve(s.r, s.p1, t.r, t.p0) + arc(t.r, t.p1, t.a1 - t.a0) + curve(t.r, t.p1, s.r, s.p0)) + "Z";
        }
        function subgroup(self2, f, d, i) {
          var subgroup2 = f.call(self2, d, i), r = radius.call(self2, subgroup2, i), a02 = startAngle.call(self2, subgroup2, i) - halfπ, a12 = endAngle.call(self2, subgroup2, i) - halfπ;
          return {
            r,
            a0: a02,
            a1: a12,
            p0: [r * Math.cos(a02), r * Math.sin(a02)],
            p1: [r * Math.cos(a12), r * Math.sin(a12)]
          };
        }
        function equals(a, b) {
          return a.a0 == b.a0 && a.a1 == b.a1;
        }
        function arc(r, p, a) {
          return "A" + r + "," + r + " 0 " + +(a > π) + ",1 " + p;
        }
        function curve(r02, p02, r12, p12) {
          return "Q 0,0 " + p12;
        }
        chord.radius = function(v) {
          if (!arguments.length) return radius;
          radius = d3_functor(v);
          return chord;
        };
        chord.source = function(v) {
          if (!arguments.length) return source;
          source = d3_functor(v);
          return chord;
        };
        chord.target = function(v) {
          if (!arguments.length) return target;
          target = d3_functor(v);
          return chord;
        };
        chord.startAngle = function(v) {
          if (!arguments.length) return startAngle;
          startAngle = d3_functor(v);
          return chord;
        };
        chord.endAngle = function(v) {
          if (!arguments.length) return endAngle;
          endAngle = d3_functor(v);
          return chord;
        };
        return chord;
      };
      function d3_svg_chordRadius(d) {
        return d.radius;
      }
      d3.svg.diagonal = function() {
        var source = d3_source, target = d3_target, projection = d3_svg_diagonalProjection;
        function diagonal(d, i) {
          var p02 = source.call(this, d, i), p3 = target.call(this, d, i), m = (p02.y + p3.y) / 2, p = [p02, {
            x: p02.x,
            y: m
          }, {
            x: p3.x,
            y: m
          }, p3];
          p = p.map(projection);
          return "M" + p[0] + "C" + p[1] + " " + p[2] + " " + p[3];
        }
        diagonal.source = function(x) {
          if (!arguments.length) return source;
          source = d3_functor(x);
          return diagonal;
        };
        diagonal.target = function(x) {
          if (!arguments.length) return target;
          target = d3_functor(x);
          return diagonal;
        };
        diagonal.projection = function(x) {
          if (!arguments.length) return projection;
          projection = x;
          return diagonal;
        };
        return diagonal;
      };
      function d3_svg_diagonalProjection(d) {
        return [d.x, d.y];
      }
      d3.svg.diagonal.radial = function() {
        var diagonal = d3.svg.diagonal(), projection = d3_svg_diagonalProjection, projection_ = diagonal.projection;
        diagonal.projection = function(x) {
          return arguments.length ? projection_(d3_svg_diagonalRadialProjection(projection = x)) : projection;
        };
        return diagonal;
      };
      function d3_svg_diagonalRadialProjection(projection) {
        return function() {
          var d = projection.apply(this, arguments), r = d[0], a = d[1] - halfπ;
          return [r * Math.cos(a), r * Math.sin(a)];
        };
      }
      d3.svg.symbol = function() {
        var type = d3_svg_symbolType, size = d3_svg_symbolSize;
        function symbol(d, i) {
          return (d3_svg_symbols.get(type.call(this, d, i)) || d3_svg_symbolCircle)(size.call(this, d, i));
        }
        symbol.type = function(x) {
          if (!arguments.length) return type;
          type = d3_functor(x);
          return symbol;
        };
        symbol.size = function(x) {
          if (!arguments.length) return size;
          size = d3_functor(x);
          return symbol;
        };
        return symbol;
      };
      function d3_svg_symbolSize() {
        return 64;
      }
      function d3_svg_symbolType() {
        return "circle";
      }
      function d3_svg_symbolCircle(size) {
        var r = Math.sqrt(size / π);
        return "M0," + r + "A" + r + "," + r + " 0 1,1 0," + -r + "A" + r + "," + r + " 0 1,1 0," + r + "Z";
      }
      var d3_svg_symbols = d3.map({
        circle: d3_svg_symbolCircle,
        cross: function(size) {
          var r = Math.sqrt(size / 5) / 2;
          return "M" + -3 * r + "," + -r + "H" + -r + "V" + -3 * r + "H" + r + "V" + -r + "H" + 3 * r + "V" + r + "H" + r + "V" + 3 * r + "H" + -r + "V" + r + "H" + -3 * r + "Z";
        },
        diamond: function(size) {
          var ry = Math.sqrt(size / (2 * d3_svg_symbolTan30)), rx = ry * d3_svg_symbolTan30;
          return "M0," + -ry + "L" + rx + ",0 0," + ry + " " + -rx + ",0Z";
        },
        square: function(size) {
          var r = Math.sqrt(size) / 2;
          return "M" + -r + "," + -r + "L" + r + "," + -r + " " + r + "," + r + " " + -r + "," + r + "Z";
        },
        "triangle-down": function(size) {
          var rx = Math.sqrt(size / d3_svg_symbolSqrt3), ry = rx * d3_svg_symbolSqrt3 / 2;
          return "M0," + ry + "L" + rx + "," + -ry + " " + -rx + "," + -ry + "Z";
        },
        "triangle-up": function(size) {
          var rx = Math.sqrt(size / d3_svg_symbolSqrt3), ry = rx * d3_svg_symbolSqrt3 / 2;
          return "M0," + -ry + "L" + rx + "," + ry + " " + -rx + "," + ry + "Z";
        }
      });
      d3.svg.symbolTypes = d3_svg_symbols.keys();
      var d3_svg_symbolSqrt3 = Math.sqrt(3), d3_svg_symbolTan30 = Math.tan(30 * d3_radians);
      d3_selectionPrototype.transition = function(name) {
        var id2 = d3_transitionInheritId || ++d3_transitionId, ns = d3_transitionNamespace(name), subgroups = [], subgroup, node, transition = d3_transitionInherit || {
          time: Date.now(),
          ease: d3_ease_cubicInOut,
          delay: 0,
          duration: 250
        };
        for (var j = -1, m = this.length; ++j < m; ) {
          subgroups.push(subgroup = []);
          for (var group = this[j], i = -1, n = group.length; ++i < n; ) {
            if (node = group[i]) d3_transitionNode(node, i, ns, id2, transition);
            subgroup.push(node);
          }
        }
        return d3_transition(subgroups, ns, id2);
      };
      d3_selectionPrototype.interrupt = function(name) {
        return this.each(name == null ? d3_selection_interrupt : d3_selection_interruptNS(d3_transitionNamespace(name)));
      };
      var d3_selection_interrupt = d3_selection_interruptNS(d3_transitionNamespace());
      function d3_selection_interruptNS(ns) {
        return function() {
          var lock, activeId, active;
          if ((lock = this[ns]) && (active = lock[activeId = lock.active])) {
            active.timer.c = null;
            active.timer.t = NaN;
            if (--lock.count) delete lock[activeId];
            else delete this[ns];
            lock.active += 0.5;
            active.event && active.event.interrupt.call(this, this.__data__, active.index);
          }
        };
      }
      function d3_transition(groups, ns, id2) {
        d3_subclass(groups, d3_transitionPrototype);
        groups.namespace = ns;
        groups.id = id2;
        return groups;
      }
      var d3_transitionPrototype = [], d3_transitionId = 0, d3_transitionInheritId, d3_transitionInherit;
      d3_transitionPrototype.call = d3_selectionPrototype.call;
      d3_transitionPrototype.empty = d3_selectionPrototype.empty;
      d3_transitionPrototype.node = d3_selectionPrototype.node;
      d3_transitionPrototype.size = d3_selectionPrototype.size;
      d3.transition = function(selection, name) {
        return selection && selection.transition ? d3_transitionInheritId ? selection.transition(name) : selection : d3.selection().transition(selection);
      };
      d3.transition.prototype = d3_transitionPrototype;
      d3_transitionPrototype.select = function(selector) {
        var id2 = this.id, ns = this.namespace, subgroups = [], subgroup, subnode, node;
        selector = d3_selection_selector(selector);
        for (var j = -1, m = this.length; ++j < m; ) {
          subgroups.push(subgroup = []);
          for (var group = this[j], i = -1, n = group.length; ++i < n; ) {
            if ((node = group[i]) && (subnode = selector.call(node, node.__data__, i, j))) {
              if ("__data__" in node) subnode.__data__ = node.__data__;
              d3_transitionNode(subnode, i, ns, id2, node[ns][id2]);
              subgroup.push(subnode);
            } else {
              subgroup.push(null);
            }
          }
        }
        return d3_transition(subgroups, ns, id2);
      };
      d3_transitionPrototype.selectAll = function(selector) {
        var id2 = this.id, ns = this.namespace, subgroups = [], subgroup, subnodes, node, subnode, transition;
        selector = d3_selection_selectorAll(selector);
        for (var j = -1, m = this.length; ++j < m; ) {
          for (var group = this[j], i = -1, n = group.length; ++i < n; ) {
            if (node = group[i]) {
              transition = node[ns][id2];
              subnodes = selector.call(node, node.__data__, i, j);
              subgroups.push(subgroup = []);
              for (var k = -1, o = subnodes.length; ++k < o; ) {
                if (subnode = subnodes[k]) d3_transitionNode(subnode, k, ns, id2, transition);
                subgroup.push(subnode);
              }
            }
          }
        }
        return d3_transition(subgroups, ns, id2);
      };
      d3_transitionPrototype.filter = function(filter) {
        var subgroups = [], subgroup, group, node;
        if (typeof filter !== "function") filter = d3_selection_filter(filter);
        for (var j = 0, m = this.length; j < m; j++) {
          subgroups.push(subgroup = []);
          for (var group = this[j], i = 0, n = group.length; i < n; i++) {
            if ((node = group[i]) && filter.call(node, node.__data__, i, j)) {
              subgroup.push(node);
            }
          }
        }
        return d3_transition(subgroups, this.namespace, this.id);
      };
      d3_transitionPrototype.tween = function(name, tween) {
        var id2 = this.id, ns = this.namespace;
        if (arguments.length < 2) return this.node()[ns][id2].tween.get(name);
        return d3_selection_each(this, tween == null ? function(node) {
          node[ns][id2].tween.remove(name);
        } : function(node) {
          node[ns][id2].tween.set(name, tween);
        });
      };
      function d3_transition_tween(groups, name, value, tween) {
        var id2 = groups.id, ns = groups.namespace;
        return d3_selection_each(groups, typeof value === "function" ? function(node, i, j) {
          node[ns][id2].tween.set(name, tween(value.call(node, node.__data__, i, j)));
        } : (value = tween(value), function(node) {
          node[ns][id2].tween.set(name, value);
        }));
      }
      d3_transitionPrototype.attr = function(nameNS, value) {
        if (arguments.length < 2) {
          for (value in nameNS) this.attr(value, nameNS[value]);
          return this;
        }
        var interpolate = nameNS == "transform" ? d3_interpolateTransform : d3_interpolate, name = d3.ns.qualify(nameNS);
        function attrNull() {
          this.removeAttribute(name);
        }
        function attrNullNS() {
          this.removeAttributeNS(name.space, name.local);
        }
        function attrTween(b) {
          return b == null ? attrNull : (b += "", function() {
            var a = this.getAttribute(name), i;
            return a !== b && (i = interpolate(a, b), function(t) {
              this.setAttribute(name, i(t));
            });
          });
        }
        function attrTweenNS(b) {
          return b == null ? attrNullNS : (b += "", function() {
            var a = this.getAttributeNS(name.space, name.local), i;
            return a !== b && (i = interpolate(a, b), function(t) {
              this.setAttributeNS(name.space, name.local, i(t));
            });
          });
        }
        return d3_transition_tween(this, "attr." + nameNS, value, name.local ? attrTweenNS : attrTween);
      };
      d3_transitionPrototype.attrTween = function(nameNS, tween) {
        var name = d3.ns.qualify(nameNS);
        function attrTween(d, i) {
          var f = tween.call(this, d, i, this.getAttribute(name));
          return f && function(t) {
            this.setAttribute(name, f(t));
          };
        }
        function attrTweenNS(d, i) {
          var f = tween.call(this, d, i, this.getAttributeNS(name.space, name.local));
          return f && function(t) {
            this.setAttributeNS(name.space, name.local, f(t));
          };
        }
        return this.tween("attr." + nameNS, name.local ? attrTweenNS : attrTween);
      };
      d3_transitionPrototype.style = function(name, value, priority) {
        var n = arguments.length;
        if (n < 3) {
          if (typeof name !== "string") {
            if (n < 2) value = "";
            for (priority in name) this.style(priority, name[priority], value);
            return this;
          }
          priority = "";
        }
        function styleNull() {
          this.style.removeProperty(name);
        }
        function styleString(b) {
          return b == null ? styleNull : (b += "", function() {
            var a = d3_window(this).getComputedStyle(this, null).getPropertyValue(name), i;
            return a !== b && (i = d3_interpolate(a, b), function(t) {
              this.style.setProperty(name, i(t), priority);
            });
          });
        }
        return d3_transition_tween(this, "style." + name, value, styleString);
      };
      d3_transitionPrototype.styleTween = function(name, tween, priority) {
        if (arguments.length < 3) priority = "";
        function styleTween(d, i) {
          var f = tween.call(this, d, i, d3_window(this).getComputedStyle(this, null).getPropertyValue(name));
          return f && function(t) {
            this.style.setProperty(name, f(t), priority);
          };
        }
        return this.tween("style." + name, styleTween);
      };
      d3_transitionPrototype.text = function(value) {
        return d3_transition_tween(this, "text", value, d3_transition_text);
      };
      function d3_transition_text(b) {
        if (b == null) b = "";
        return function() {
          this.textContent = b;
        };
      }
      d3_transitionPrototype.remove = function() {
        var ns = this.namespace;
        return this.each("end.transition", function() {
          var p;
          if (this[ns].count < 2 && (p = this.parentNode)) p.removeChild(this);
        });
      };
      d3_transitionPrototype.ease = function(value) {
        var id2 = this.id, ns = this.namespace;
        if (arguments.length < 1) return this.node()[ns][id2].ease;
        if (typeof value !== "function") value = d3.ease.apply(d3, arguments);
        return d3_selection_each(this, function(node) {
          node[ns][id2].ease = value;
        });
      };
      d3_transitionPrototype.delay = function(value) {
        var id2 = this.id, ns = this.namespace;
        if (arguments.length < 1) return this.node()[ns][id2].delay;
        return d3_selection_each(this, typeof value === "function" ? function(node, i, j) {
          node[ns][id2].delay = +value.call(node, node.__data__, i, j);
        } : (value = +value, function(node) {
          node[ns][id2].delay = value;
        }));
      };
      d3_transitionPrototype.duration = function(value) {
        var id2 = this.id, ns = this.namespace;
        if (arguments.length < 1) return this.node()[ns][id2].duration;
        return d3_selection_each(this, typeof value === "function" ? function(node, i, j) {
          node[ns][id2].duration = Math.max(1, value.call(node, node.__data__, i, j));
        } : (value = Math.max(1, value), function(node) {
          node[ns][id2].duration = value;
        }));
      };
      d3_transitionPrototype.each = function(type, listener) {
        var id2 = this.id, ns = this.namespace;
        if (arguments.length < 2) {
          var inherit = d3_transitionInherit, inheritId = d3_transitionInheritId;
          try {
            d3_transitionInheritId = id2;
            d3_selection_each(this, function(node, i, j) {
              d3_transitionInherit = node[ns][id2];
              type.call(node, node.__data__, i, j);
            });
          } finally {
            d3_transitionInherit = inherit;
            d3_transitionInheritId = inheritId;
          }
        } else {
          d3_selection_each(this, function(node) {
            var transition = node[ns][id2];
            (transition.event || (transition.event = d3.dispatch("start", "end", "interrupt"))).on(type, listener);
          });
        }
        return this;
      };
      d3_transitionPrototype.transition = function() {
        var id0 = this.id, id1 = ++d3_transitionId, ns = this.namespace, subgroups = [], subgroup, group, node, transition;
        for (var j = 0, m = this.length; j < m; j++) {
          subgroups.push(subgroup = []);
          for (var group = this[j], i = 0, n = group.length; i < n; i++) {
            if (node = group[i]) {
              transition = node[ns][id0];
              d3_transitionNode(node, i, ns, id1, {
                time: transition.time,
                ease: transition.ease,
                delay: transition.delay + transition.duration,
                duration: transition.duration
              });
            }
            subgroup.push(node);
          }
        }
        return d3_transition(subgroups, ns, id1);
      };
      function d3_transitionNamespace(name) {
        return name == null ? "__transition__" : "__transition_" + name + "__";
      }
      function d3_transitionNode(node, i, ns, id2, inherit) {
        var lock = node[ns] || (node[ns] = {
          active: 0,
          count: 0
        }), transition = lock[id2], time, timer, duration, ease, tweens;
        function schedule(elapsed) {
          var delay = transition.delay;
          timer.t = delay + time;
          if (delay <= elapsed) return start(elapsed - delay);
          timer.c = start;
        }
        function start(elapsed) {
          var activeId = lock.active, active = lock[activeId];
          if (active) {
            active.timer.c = null;
            active.timer.t = NaN;
            --lock.count;
            delete lock[activeId];
            active.event && active.event.interrupt.call(node, node.__data__, active.index);
          }
          for (var cancelId in lock) {
            if (+cancelId < id2) {
              var cancel = lock[cancelId];
              cancel.timer.c = null;
              cancel.timer.t = NaN;
              --lock.count;
              delete lock[cancelId];
            }
          }
          timer.c = tick;
          d3_timer(function() {
            if (timer.c && tick(elapsed || 1)) {
              timer.c = null;
              timer.t = NaN;
            }
            return 1;
          }, 0, time);
          lock.active = id2;
          transition.event && transition.event.start.call(node, node.__data__, i);
          tweens = [];
          transition.tween.forEach(function(key, value) {
            if (value = value.call(node, node.__data__, i)) {
              tweens.push(value);
            }
          });
          ease = transition.ease;
          duration = transition.duration;
        }
        function tick(elapsed) {
          var t = elapsed / duration, e = ease(t), n = tweens.length;
          while (n > 0) {
            tweens[--n].call(node, e);
          }
          if (t >= 1) {
            transition.event && transition.event.end.call(node, node.__data__, i);
            if (--lock.count) delete lock[id2];
            else delete node[ns];
            return 1;
          }
        }
        if (!transition) {
          time = inherit.time;
          timer = d3_timer(schedule, 0, time);
          transition = lock[id2] = {
            tween: new d3_Map(),
            time,
            timer,
            delay: inherit.delay,
            duration: inherit.duration,
            ease: inherit.ease,
            index: i
          };
          inherit = null;
          ++lock.count;
        }
      }
      d3.svg.axis = function() {
        var scale = d3.scale.linear(), orient = d3_svg_axisDefaultOrient, innerTickSize = 6, outerTickSize = 6, tickPadding = 3, tickArguments_ = [10], tickValues = null, tickFormat_;
        function axis(g) {
          g.each(function() {
            var g2 = d3.select(this);
            var scale0 = this.__chart__ || scale, scale1 = this.__chart__ = scale.copy();
            var ticks = tickValues == null ? scale1.ticks ? scale1.ticks.apply(scale1, tickArguments_) : scale1.domain() : tickValues, tickFormat = tickFormat_ == null ? scale1.tickFormat ? scale1.tickFormat.apply(scale1, tickArguments_) : d3_identity : tickFormat_, tick = g2.selectAll(".tick").data(ticks, scale1), tickEnter = tick.enter().insert("g", ".domain").attr("class", "tick").style("opacity", ε), tickExit = d3.transition(tick.exit()).style("opacity", ε).remove(), tickUpdate = d3.transition(tick.order()).style("opacity", 1), tickSpacing = Math.max(innerTickSize, 0) + tickPadding, tickTransform;
            var range = d3_scaleRange(scale1), path = g2.selectAll(".domain").data([0]), pathUpdate = (path.enter().append("path").attr("class", "domain"), d3.transition(path));
            tickEnter.append("line");
            tickEnter.append("text");
            var lineEnter = tickEnter.select("line"), lineUpdate = tickUpdate.select("line"), text = tick.select("text").text(tickFormat), textEnter = tickEnter.select("text"), textUpdate = tickUpdate.select("text"), sign = orient === "top" || orient === "left" ? -1 : 1, x12, x2, y12, y2;
            if (orient === "bottom" || orient === "top") {
              tickTransform = d3_svg_axisX, x12 = "x", y12 = "y", x2 = "x2", y2 = "y2";
              text.attr("dy", sign < 0 ? "0em" : ".71em").style("text-anchor", "middle");
              pathUpdate.attr("d", "M" + range[0] + "," + sign * outerTickSize + "V0H" + range[1] + "V" + sign * outerTickSize);
            } else {
              tickTransform = d3_svg_axisY, x12 = "y", y12 = "x", x2 = "y2", y2 = "x2";
              text.attr("dy", ".32em").style("text-anchor", sign < 0 ? "end" : "start");
              pathUpdate.attr("d", "M" + sign * outerTickSize + "," + range[0] + "H0V" + range[1] + "H" + sign * outerTickSize);
            }
            lineEnter.attr(y2, sign * innerTickSize);
            textEnter.attr(y12, sign * tickSpacing);
            lineUpdate.attr(x2, 0).attr(y2, sign * innerTickSize);
            textUpdate.attr(x12, 0).attr(y12, sign * tickSpacing);
            if (scale1.rangeBand) {
              var x = scale1, dx = x.rangeBand() / 2;
              scale0 = scale1 = function(d) {
                return x(d) + dx;
              };
            } else if (scale0.rangeBand) {
              scale0 = scale1;
            } else {
              tickExit.call(tickTransform, scale1, scale0);
            }
            tickEnter.call(tickTransform, scale0, scale1);
            tickUpdate.call(tickTransform, scale1, scale1);
          });
        }
        axis.scale = function(x) {
          if (!arguments.length) return scale;
          scale = x;
          return axis;
        };
        axis.orient = function(x) {
          if (!arguments.length) return orient;
          orient = x in d3_svg_axisOrients ? x + "" : d3_svg_axisDefaultOrient;
          return axis;
        };
        axis.ticks = function() {
          if (!arguments.length) return tickArguments_;
          tickArguments_ = d3_array(arguments);
          return axis;
        };
        axis.tickValues = function(x) {
          if (!arguments.length) return tickValues;
          tickValues = x;
          return axis;
        };
        axis.tickFormat = function(x) {
          if (!arguments.length) return tickFormat_;
          tickFormat_ = x;
          return axis;
        };
        axis.tickSize = function(x) {
          var n = arguments.length;
          if (!n) return innerTickSize;
          innerTickSize = +x;
          outerTickSize = +arguments[n - 1];
          return axis;
        };
        axis.innerTickSize = function(x) {
          if (!arguments.length) return innerTickSize;
          innerTickSize = +x;
          return axis;
        };
        axis.outerTickSize = function(x) {
          if (!arguments.length) return outerTickSize;
          outerTickSize = +x;
          return axis;
        };
        axis.tickPadding = function(x) {
          if (!arguments.length) return tickPadding;
          tickPadding = +x;
          return axis;
        };
        axis.tickSubdivide = function() {
          return arguments.length && axis;
        };
        return axis;
      };
      var d3_svg_axisDefaultOrient = "bottom", d3_svg_axisOrients = {
        top: 1,
        right: 1,
        bottom: 1,
        left: 1
      };
      function d3_svg_axisX(selection, x02, x12) {
        selection.attr("transform", function(d) {
          var v02 = x02(d);
          return "translate(" + (isFinite(v02) ? v02 : x12(d)) + ",0)";
        });
      }
      function d3_svg_axisY(selection, y02, y12) {
        selection.attr("transform", function(d) {
          var v02 = y02(d);
          return "translate(0," + (isFinite(v02) ? v02 : y12(d)) + ")";
        });
      }
      d3.svg.brush = function() {
        var event = d3_eventDispatch(brush, "brushstart", "brush", "brushend"), x = null, y = null, xExtent = [0, 0], yExtent = [0, 0], xExtentDomain, yExtentDomain, xClamp = true, yClamp = true, resizes = d3_svg_brushResizes[0];
        function brush(g) {
          g.each(function() {
            var g2 = d3.select(this).style("pointer-events", "all").style("-webkit-tap-highlight-color", "rgba(0,0,0,0)").on("mousedown.brush", brushstart).on("touchstart.brush", brushstart);
            var background = g2.selectAll(".background").data([0]);
            background.enter().append("rect").attr("class", "background").style("visibility", "hidden").style("cursor", "crosshair");
            g2.selectAll(".extent").data([0]).enter().append("rect").attr("class", "extent").style("cursor", "move");
            var resize = g2.selectAll(".resize").data(resizes, d3_identity);
            resize.exit().remove();
            resize.enter().append("g").attr("class", function(d) {
              return "resize " + d;
            }).style("cursor", function(d) {
              return d3_svg_brushCursor[d];
            }).append("rect").attr("x", function(d) {
              return /[ew]$/.test(d) ? -3 : null;
            }).attr("y", function(d) {
              return /^[ns]/.test(d) ? -3 : null;
            }).attr("width", 6).attr("height", 6).style("visibility", "hidden");
            resize.style("display", brush.empty() ? "none" : null);
            var gUpdate = d3.transition(g2), backgroundUpdate = d3.transition(background), range;
            if (x) {
              range = d3_scaleRange(x);
              backgroundUpdate.attr("x", range[0]).attr("width", range[1] - range[0]);
              redrawX(gUpdate);
            }
            if (y) {
              range = d3_scaleRange(y);
              backgroundUpdate.attr("y", range[0]).attr("height", range[1] - range[0]);
              redrawY(gUpdate);
            }
            redraw(gUpdate);
          });
        }
        brush.event = function(g) {
          g.each(function() {
            var event_ = event.of(this, arguments), extent1 = {
              x: xExtent,
              y: yExtent,
              i: xExtentDomain,
              j: yExtentDomain
            }, extent0 = this.__chart__ || extent1;
            this.__chart__ = extent1;
            if (d3_transitionInheritId) {
              d3.select(this).transition().each("start.brush", function() {
                xExtentDomain = extent0.i;
                yExtentDomain = extent0.j;
                xExtent = extent0.x;
                yExtent = extent0.y;
                event_({
                  type: "brushstart"
                });
              }).tween("brush:brush", function() {
                var xi2 = d3_interpolateArray(xExtent, extent1.x), yi2 = d3_interpolateArray(yExtent, extent1.y);
                xExtentDomain = yExtentDomain = null;
                return function(t) {
                  xExtent = extent1.x = xi2(t);
                  yExtent = extent1.y = yi2(t);
                  event_({
                    type: "brush",
                    mode: "resize"
                  });
                };
              }).each("end.brush", function() {
                xExtentDomain = extent1.i;
                yExtentDomain = extent1.j;
                event_({
                  type: "brush",
                  mode: "resize"
                });
                event_({
                  type: "brushend"
                });
              });
            } else {
              event_({
                type: "brushstart"
              });
              event_({
                type: "brush",
                mode: "resize"
              });
              event_({
                type: "brushend"
              });
            }
          });
        };
        function redraw(g) {
          g.selectAll(".resize").attr("transform", function(d) {
            return "translate(" + xExtent[+/e$/.test(d)] + "," + yExtent[+/^s/.test(d)] + ")";
          });
        }
        function redrawX(g) {
          g.select(".extent").attr("x", xExtent[0]);
          g.selectAll(".extent,.n>rect,.s>rect").attr("width", xExtent[1] - xExtent[0]);
        }
        function redrawY(g) {
          g.select(".extent").attr("y", yExtent[0]);
          g.selectAll(".extent,.e>rect,.w>rect").attr("height", yExtent[1] - yExtent[0]);
        }
        function brushstart() {
          var target = this, eventTarget = d3.select(d3.event.target), event_ = event.of(target, arguments), g = d3.select(target), resizing = eventTarget.datum(), resizingX = !/^(n|s)$/.test(resizing) && x, resizingY = !/^(e|w)$/.test(resizing) && y, dragging = eventTarget.classed("extent"), dragRestore = d3_event_dragSuppress(target), center, origin = d3.mouse(target), offset;
          var w = d3.select(d3_window(target)).on("keydown.brush", keydown).on("keyup.brush", keyup);
          if (d3.event.changedTouches) {
            w.on("touchmove.brush", brushmove).on("touchend.brush", brushend);
          } else {
            w.on("mousemove.brush", brushmove).on("mouseup.brush", brushend);
          }
          g.interrupt().selectAll("*").interrupt();
          if (dragging) {
            origin[0] = xExtent[0] - origin[0];
            origin[1] = yExtent[0] - origin[1];
          } else if (resizing) {
            var ex = +/w$/.test(resizing), ey = +/^n/.test(resizing);
            offset = [xExtent[1 - ex] - origin[0], yExtent[1 - ey] - origin[1]];
            origin[0] = xExtent[ex];
            origin[1] = yExtent[ey];
          } else if (d3.event.altKey) center = origin.slice();
          g.style("pointer-events", "none").selectAll(".resize").style("display", null);
          d3.select("body").style("cursor", eventTarget.style("cursor"));
          event_({
            type: "brushstart"
          });
          brushmove();
          function keydown() {
            if (d3.event.keyCode == 32) {
              if (!dragging) {
                center = null;
                origin[0] -= xExtent[1];
                origin[1] -= yExtent[1];
                dragging = 2;
              }
              d3_eventPreventDefault();
            }
          }
          function keyup() {
            if (d3.event.keyCode == 32 && dragging == 2) {
              origin[0] += xExtent[1];
              origin[1] += yExtent[1];
              dragging = 0;
              d3_eventPreventDefault();
            }
          }
          function brushmove() {
            var point = d3.mouse(target), moved = false;
            if (offset) {
              point[0] += offset[0];
              point[1] += offset[1];
            }
            if (!dragging) {
              if (d3.event.altKey) {
                if (!center) center = [(xExtent[0] + xExtent[1]) / 2, (yExtent[0] + yExtent[1]) / 2];
                origin[0] = xExtent[+(point[0] < center[0])];
                origin[1] = yExtent[+(point[1] < center[1])];
              } else center = null;
            }
            if (resizingX && move1(point, x, 0)) {
              redrawX(g);
              moved = true;
            }
            if (resizingY && move1(point, y, 1)) {
              redrawY(g);
              moved = true;
            }
            if (moved) {
              redraw(g);
              event_({
                type: "brush",
                mode: dragging ? "move" : "resize"
              });
            }
          }
          function move1(point, scale, i) {
            var range = d3_scaleRange(scale), r02 = range[0], r12 = range[1], position = origin[i], extent = i ? yExtent : xExtent, size = extent[1] - extent[0], min, max;
            if (dragging) {
              r02 -= position;
              r12 -= size + position;
            }
            min = (i ? yClamp : xClamp) ? Math.max(r02, Math.min(r12, point[i])) : point[i];
            if (dragging) {
              max = (min += position) + size;
            } else {
              if (center) position = Math.max(r02, Math.min(r12, 2 * center[i] - min));
              if (position < min) {
                max = min;
                min = position;
              } else {
                max = position;
              }
            }
            if (extent[0] != min || extent[1] != max) {
              if (i) yExtentDomain = null;
              else xExtentDomain = null;
              extent[0] = min;
              extent[1] = max;
              return true;
            }
          }
          function brushend() {
            brushmove();
            g.style("pointer-events", "all").selectAll(".resize").style("display", brush.empty() ? "none" : null);
            d3.select("body").style("cursor", null);
            w.on("mousemove.brush", null).on("mouseup.brush", null).on("touchmove.brush", null).on("touchend.brush", null).on("keydown.brush", null).on("keyup.brush", null);
            dragRestore();
            event_({
              type: "brushend"
            });
          }
        }
        brush.x = function(z2) {
          if (!arguments.length) return x;
          x = z2;
          resizes = d3_svg_brushResizes[!x << 1 | !y];
          return brush;
        };
        brush.y = function(z2) {
          if (!arguments.length) return y;
          y = z2;
          resizes = d3_svg_brushResizes[!x << 1 | !y];
          return brush;
        };
        brush.clamp = function(z2) {
          if (!arguments.length) return x && y ? [xClamp, yClamp] : x ? xClamp : y ? yClamp : null;
          if (x && y) xClamp = !!z2[0], yClamp = !!z2[1];
          else if (x) xClamp = !!z2;
          else if (y) yClamp = !!z2;
          return brush;
        };
        brush.extent = function(z2) {
          var x02, x12, y02, y12, t;
          if (!arguments.length) {
            if (x) {
              if (xExtentDomain) {
                x02 = xExtentDomain[0], x12 = xExtentDomain[1];
              } else {
                x02 = xExtent[0], x12 = xExtent[1];
                if (x.invert) x02 = x.invert(x02), x12 = x.invert(x12);
                if (x12 < x02) t = x02, x02 = x12, x12 = t;
              }
            }
            if (y) {
              if (yExtentDomain) {
                y02 = yExtentDomain[0], y12 = yExtentDomain[1];
              } else {
                y02 = yExtent[0], y12 = yExtent[1];
                if (y.invert) y02 = y.invert(y02), y12 = y.invert(y12);
                if (y12 < y02) t = y02, y02 = y12, y12 = t;
              }
            }
            return x && y ? [[x02, y02], [x12, y12]] : x ? [x02, x12] : y && [y02, y12];
          }
          if (x) {
            x02 = z2[0], x12 = z2[1];
            if (y) x02 = x02[0], x12 = x12[0];
            xExtentDomain = [x02, x12];
            if (x.invert) x02 = x(x02), x12 = x(x12);
            if (x12 < x02) t = x02, x02 = x12, x12 = t;
            if (x02 != xExtent[0] || x12 != xExtent[1]) xExtent = [x02, x12];
          }
          if (y) {
            y02 = z2[0], y12 = z2[1];
            if (x) y02 = y02[1], y12 = y12[1];
            yExtentDomain = [y02, y12];
            if (y.invert) y02 = y(y02), y12 = y(y12);
            if (y12 < y02) t = y02, y02 = y12, y12 = t;
            if (y02 != yExtent[0] || y12 != yExtent[1]) yExtent = [y02, y12];
          }
          return brush;
        };
        brush.clear = function() {
          if (!brush.empty()) {
            xExtent = [0, 0], yExtent = [0, 0];
            xExtentDomain = yExtentDomain = null;
          }
          return brush;
        };
        brush.empty = function() {
          return !!x && xExtent[0] == xExtent[1] || !!y && yExtent[0] == yExtent[1];
        };
        return d3.rebind(brush, event, "on");
      };
      var d3_svg_brushCursor = {
        n: "ns-resize",
        e: "ew-resize",
        s: "ns-resize",
        w: "ew-resize",
        nw: "nwse-resize",
        ne: "nesw-resize",
        se: "nwse-resize",
        sw: "nesw-resize"
      };
      var d3_svg_brushResizes = [["n", "e", "s", "w", "nw", "ne", "se", "sw"], ["e", "w"], ["n", "s"], []];
      d3.text = d3_xhrType(function(request) {
        return request.responseText;
      });
      d3.json = function(url, callback) {
        return d3_xhr(url, "application/json", d3_json, callback);
      };
      function d3_json(request) {
        return JSON.parse(request.responseText);
      }
      d3.html = function(url, callback) {
        return d3_xhr(url, "text/html", d3_html, callback);
      };
      function d3_html(request) {
        var range = d3_document.createRange();
        range.selectNode(d3_document.body);
        return range.createContextualFragment(request.responseText);
      }
      d3.xml = d3_xhrType(function(request) {
        return request.responseXML;
      });
      if (typeof define === "function" && define.amd) define(d3);
      else if (typeof module2 === "object" && module2.exports) module2.exports = d3;
      else this.d3 = d3;
    }).apply(self);
  }
});

// node_modules/d3-time/src/interval.js
function newInterval(floori, offseti, count, field) {
  function interval(date) {
    return floori(date = arguments.length === 0 ? /* @__PURE__ */ new Date() : /* @__PURE__ */ new Date(+date)), date;
  }
  interval.floor = function(date) {
    return floori(date = /* @__PURE__ */ new Date(+date)), date;
  };
  interval.ceil = function(date) {
    return floori(date = new Date(date - 1)), offseti(date, 1), floori(date), date;
  };
  interval.round = function(date) {
    var d02 = interval(date), d12 = interval.ceil(date);
    return date - d02 < d12 - date ? d02 : d12;
  };
  interval.offset = function(date, step) {
    return offseti(date = /* @__PURE__ */ new Date(+date), step == null ? 1 : Math.floor(step)), date;
  };
  interval.range = function(start, stop, step) {
    var range = [], previous;
    start = interval.ceil(start);
    step = step == null ? 1 : Math.floor(step);
    if (!(start < stop) || !(step > 0)) return range;
    do
      range.push(previous = /* @__PURE__ */ new Date(+start)), offseti(start, step), floori(start);
    while (previous < start && start < stop);
    return range;
  };
  interval.filter = function(test) {
    return newInterval(function(date) {
      if (date >= date) while (floori(date), !test(date)) date.setTime(date - 1);
    }, function(date, step) {
      if (date >= date) {
        if (step < 0) while (++step <= 0) {
          while (offseti(date, -1), !test(date)) {
          }
        }
        else while (--step >= 0) {
          while (offseti(date, 1), !test(date)) {
          }
        }
      }
    });
  };
  if (count) {
    interval.count = function(start, end) {
      t0.setTime(+start), t1.setTime(+end);
      floori(t0), floori(t1);
      return Math.floor(count(t0, t1));
    };
    interval.every = function(step) {
      step = Math.floor(step);
      return !isFinite(step) || !(step > 0) ? null : !(step > 1) ? interval : interval.filter(field ? function(d) {
        return field(d) % step === 0;
      } : function(d) {
        return interval.count(0, d) % step === 0;
      });
    };
  }
  return interval;
}
var t0, t1;
var init_interval = __esm({
  "node_modules/d3-time/src/interval.js"() {
    t0 = /* @__PURE__ */ new Date();
    t1 = /* @__PURE__ */ new Date();
  }
});

// node_modules/d3-time/src/millisecond.js
var millisecond, millisecond_default, milliseconds;
var init_millisecond = __esm({
  "node_modules/d3-time/src/millisecond.js"() {
    init_interval();
    millisecond = newInterval(function() {
    }, function(date, step) {
      date.setTime(+date + step);
    }, function(start, end) {
      return end - start;
    });
    millisecond.every = function(k) {
      k = Math.floor(k);
      if (!isFinite(k) || !(k > 0)) return null;
      if (!(k > 1)) return millisecond;
      return newInterval(function(date) {
        date.setTime(Math.floor(date / k) * k);
      }, function(date, step) {
        date.setTime(+date + step * k);
      }, function(start, end) {
        return (end - start) / k;
      });
    };
    millisecond_default = millisecond;
    milliseconds = millisecond.range;
  }
});

// node_modules/d3-time/src/duration.js
var durationSecond, durationMinute, durationHour, durationDay, durationWeek;
var init_duration = __esm({
  "node_modules/d3-time/src/duration.js"() {
    durationSecond = 1e3;
    durationMinute = 6e4;
    durationHour = 36e5;
    durationDay = 864e5;
    durationWeek = 6048e5;
  }
});

// node_modules/d3-time/src/second.js
var second, second_default, seconds;
var init_second = __esm({
  "node_modules/d3-time/src/second.js"() {
    init_interval();
    init_duration();
    second = newInterval(function(date) {
      date.setTime(date - date.getMilliseconds());
    }, function(date, step) {
      date.setTime(+date + step * durationSecond);
    }, function(start, end) {
      return (end - start) / durationSecond;
    }, function(date) {
      return date.getUTCSeconds();
    });
    second_default = second;
    seconds = second.range;
  }
});

// node_modules/d3-time/src/minute.js
var minute, minute_default, minutes;
var init_minute = __esm({
  "node_modules/d3-time/src/minute.js"() {
    init_interval();
    init_duration();
    minute = newInterval(function(date) {
      date.setTime(date - date.getMilliseconds() - date.getSeconds() * durationSecond);
    }, function(date, step) {
      date.setTime(+date + step * durationMinute);
    }, function(start, end) {
      return (end - start) / durationMinute;
    }, function(date) {
      return date.getMinutes();
    });
    minute_default = minute;
    minutes = minute.range;
  }
});

// node_modules/d3-time/src/hour.js
var hour, hour_default, hours;
var init_hour = __esm({
  "node_modules/d3-time/src/hour.js"() {
    init_interval();
    init_duration();
    hour = newInterval(function(date) {
      date.setTime(date - date.getMilliseconds() - date.getSeconds() * durationSecond - date.getMinutes() * durationMinute);
    }, function(date, step) {
      date.setTime(+date + step * durationHour);
    }, function(start, end) {
      return (end - start) / durationHour;
    }, function(date) {
      return date.getHours();
    });
    hour_default = hour;
    hours = hour.range;
  }
});

// node_modules/d3-time/src/day.js
var day, day_default, days;
var init_day = __esm({
  "node_modules/d3-time/src/day.js"() {
    init_interval();
    init_duration();
    day = newInterval(function(date) {
      date.setHours(0, 0, 0, 0);
    }, function(date, step) {
      date.setDate(date.getDate() + step);
    }, function(start, end) {
      return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * durationMinute) / durationDay;
    }, function(date) {
      return date.getDate() - 1;
    });
    day_default = day;
    days = day.range;
  }
});

// node_modules/d3-time/src/week.js
function weekday(i) {
  return newInterval(function(date) {
    date.setDate(date.getDate() - (date.getDay() + 7 - i) % 7);
    date.setHours(0, 0, 0, 0);
  }, function(date, step) {
    date.setDate(date.getDate() + step * 7);
  }, function(start, end) {
    return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * durationMinute) / durationWeek;
  });
}
var sunday, monday, tuesday, wednesday, thursday, friday, saturday, sundays, mondays, tuesdays, wednesdays, thursdays, fridays, saturdays;
var init_week = __esm({
  "node_modules/d3-time/src/week.js"() {
    init_interval();
    init_duration();
    sunday = weekday(0);
    monday = weekday(1);
    tuesday = weekday(2);
    wednesday = weekday(3);
    thursday = weekday(4);
    friday = weekday(5);
    saturday = weekday(6);
    sundays = sunday.range;
    mondays = monday.range;
    tuesdays = tuesday.range;
    wednesdays = wednesday.range;
    thursdays = thursday.range;
    fridays = friday.range;
    saturdays = saturday.range;
  }
});

// node_modules/d3-time/src/month.js
var month, month_default, months;
var init_month = __esm({
  "node_modules/d3-time/src/month.js"() {
    init_interval();
    month = newInterval(function(date) {
      date.setDate(1);
      date.setHours(0, 0, 0, 0);
    }, function(date, step) {
      date.setMonth(date.getMonth() + step);
    }, function(start, end) {
      return end.getMonth() - start.getMonth() + (end.getFullYear() - start.getFullYear()) * 12;
    }, function(date) {
      return date.getMonth();
    });
    month_default = month;
    months = month.range;
  }
});

// node_modules/d3-time/src/year.js
var year, year_default, years;
var init_year = __esm({
  "node_modules/d3-time/src/year.js"() {
    init_interval();
    year = newInterval(function(date) {
      date.setMonth(0, 1);
      date.setHours(0, 0, 0, 0);
    }, function(date, step) {
      date.setFullYear(date.getFullYear() + step);
    }, function(start, end) {
      return end.getFullYear() - start.getFullYear();
    }, function(date) {
      return date.getFullYear();
    });
    year.every = function(k) {
      return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : newInterval(function(date) {
        date.setFullYear(Math.floor(date.getFullYear() / k) * k);
        date.setMonth(0, 1);
        date.setHours(0, 0, 0, 0);
      }, function(date, step) {
        date.setFullYear(date.getFullYear() + step * k);
      });
    };
    year_default = year;
    years = year.range;
  }
});

// node_modules/d3-time/src/utcMinute.js
var utcMinute, utcMinute_default, utcMinutes;
var init_utcMinute = __esm({
  "node_modules/d3-time/src/utcMinute.js"() {
    init_interval();
    init_duration();
    utcMinute = newInterval(function(date) {
      date.setUTCSeconds(0, 0);
    }, function(date, step) {
      date.setTime(+date + step * durationMinute);
    }, function(start, end) {
      return (end - start) / durationMinute;
    }, function(date) {
      return date.getUTCMinutes();
    });
    utcMinute_default = utcMinute;
    utcMinutes = utcMinute.range;
  }
});

// node_modules/d3-time/src/utcHour.js
var utcHour, utcHour_default, utcHours;
var init_utcHour = __esm({
  "node_modules/d3-time/src/utcHour.js"() {
    init_interval();
    init_duration();
    utcHour = newInterval(function(date) {
      date.setUTCMinutes(0, 0, 0);
    }, function(date, step) {
      date.setTime(+date + step * durationHour);
    }, function(start, end) {
      return (end - start) / durationHour;
    }, function(date) {
      return date.getUTCHours();
    });
    utcHour_default = utcHour;
    utcHours = utcHour.range;
  }
});

// node_modules/d3-time/src/utcDay.js
var utcDay, utcDay_default, utcDays;
var init_utcDay = __esm({
  "node_modules/d3-time/src/utcDay.js"() {
    init_interval();
    init_duration();
    utcDay = newInterval(function(date) {
      date.setUTCHours(0, 0, 0, 0);
    }, function(date, step) {
      date.setUTCDate(date.getUTCDate() + step);
    }, function(start, end) {
      return (end - start) / durationDay;
    }, function(date) {
      return date.getUTCDate() - 1;
    });
    utcDay_default = utcDay;
    utcDays = utcDay.range;
  }
});

// node_modules/d3-time/src/utcWeek.js
function utcWeekday(i) {
  return newInterval(function(date) {
    date.setUTCDate(date.getUTCDate() - (date.getUTCDay() + 7 - i) % 7);
    date.setUTCHours(0, 0, 0, 0);
  }, function(date, step) {
    date.setUTCDate(date.getUTCDate() + step * 7);
  }, function(start, end) {
    return (end - start) / durationWeek;
  });
}
var utcSunday, utcMonday, utcTuesday, utcWednesday, utcThursday, utcFriday, utcSaturday, utcSundays, utcMondays, utcTuesdays, utcWednesdays, utcThursdays, utcFridays, utcSaturdays;
var init_utcWeek = __esm({
  "node_modules/d3-time/src/utcWeek.js"() {
    init_interval();
    init_duration();
    utcSunday = utcWeekday(0);
    utcMonday = utcWeekday(1);
    utcTuesday = utcWeekday(2);
    utcWednesday = utcWeekday(3);
    utcThursday = utcWeekday(4);
    utcFriday = utcWeekday(5);
    utcSaturday = utcWeekday(6);
    utcSundays = utcSunday.range;
    utcMondays = utcMonday.range;
    utcTuesdays = utcTuesday.range;
    utcWednesdays = utcWednesday.range;
    utcThursdays = utcThursday.range;
    utcFridays = utcFriday.range;
    utcSaturdays = utcSaturday.range;
  }
});

// node_modules/d3-time/src/utcMonth.js
var utcMonth, utcMonth_default, utcMonths;
var init_utcMonth = __esm({
  "node_modules/d3-time/src/utcMonth.js"() {
    init_interval();
    utcMonth = newInterval(function(date) {
      date.setUTCDate(1);
      date.setUTCHours(0, 0, 0, 0);
    }, function(date, step) {
      date.setUTCMonth(date.getUTCMonth() + step);
    }, function(start, end) {
      return end.getUTCMonth() - start.getUTCMonth() + (end.getUTCFullYear() - start.getUTCFullYear()) * 12;
    }, function(date) {
      return date.getUTCMonth();
    });
    utcMonth_default = utcMonth;
    utcMonths = utcMonth.range;
  }
});

// node_modules/d3-time/src/utcYear.js
var utcYear, utcYear_default, utcYears;
var init_utcYear = __esm({
  "node_modules/d3-time/src/utcYear.js"() {
    init_interval();
    utcYear = newInterval(function(date) {
      date.setUTCMonth(0, 1);
      date.setUTCHours(0, 0, 0, 0);
    }, function(date, step) {
      date.setUTCFullYear(date.getUTCFullYear() + step);
    }, function(start, end) {
      return end.getUTCFullYear() - start.getUTCFullYear();
    }, function(date) {
      return date.getUTCFullYear();
    });
    utcYear.every = function(k) {
      return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : newInterval(function(date) {
        date.setUTCFullYear(Math.floor(date.getUTCFullYear() / k) * k);
        date.setUTCMonth(0, 1);
        date.setUTCHours(0, 0, 0, 0);
      }, function(date, step) {
        date.setUTCFullYear(date.getUTCFullYear() + step * k);
      });
    };
    utcYear_default = utcYear;
    utcYears = utcYear.range;
  }
});

// node_modules/d3-time/src/index.js
var src_exports = {};
__export(src_exports, {
  timeDay: () => day_default,
  timeDays: () => days,
  timeFriday: () => friday,
  timeFridays: () => fridays,
  timeHour: () => hour_default,
  timeHours: () => hours,
  timeInterval: () => newInterval,
  timeMillisecond: () => millisecond_default,
  timeMilliseconds: () => milliseconds,
  timeMinute: () => minute_default,
  timeMinutes: () => minutes,
  timeMonday: () => monday,
  timeMondays: () => mondays,
  timeMonth: () => month_default,
  timeMonths: () => months,
  timeSaturday: () => saturday,
  timeSaturdays: () => saturdays,
  timeSecond: () => second_default,
  timeSeconds: () => seconds,
  timeSunday: () => sunday,
  timeSundays: () => sundays,
  timeThursday: () => thursday,
  timeThursdays: () => thursdays,
  timeTuesday: () => tuesday,
  timeTuesdays: () => tuesdays,
  timeWednesday: () => wednesday,
  timeWednesdays: () => wednesdays,
  timeWeek: () => sunday,
  timeWeeks: () => sundays,
  timeYear: () => year_default,
  timeYears: () => years,
  utcDay: () => utcDay_default,
  utcDays: () => utcDays,
  utcFriday: () => utcFriday,
  utcFridays: () => utcFridays,
  utcHour: () => utcHour_default,
  utcHours: () => utcHours,
  utcMillisecond: () => millisecond_default,
  utcMilliseconds: () => milliseconds,
  utcMinute: () => utcMinute_default,
  utcMinutes: () => utcMinutes,
  utcMonday: () => utcMonday,
  utcMondays: () => utcMondays,
  utcMonth: () => utcMonth_default,
  utcMonths: () => utcMonths,
  utcSaturday: () => utcSaturday,
  utcSaturdays: () => utcSaturdays,
  utcSecond: () => second_default,
  utcSeconds: () => seconds,
  utcSunday: () => utcSunday,
  utcSundays: () => utcSundays,
  utcThursday: () => utcThursday,
  utcThursdays: () => utcThursdays,
  utcTuesday: () => utcTuesday,
  utcTuesdays: () => utcTuesdays,
  utcWednesday: () => utcWednesday,
  utcWednesdays: () => utcWednesdays,
  utcWeek: () => utcSunday,
  utcWeeks: () => utcSundays,
  utcYear: () => utcYear_default,
  utcYears: () => utcYears
});
var init_src = __esm({
  "node_modules/d3-time/src/index.js"() {
    init_interval();
    init_millisecond();
    init_second();
    init_minute();
    init_hour();
    init_day();
    init_week();
    init_month();
    init_year();
    init_utcMinute();
    init_utcHour();
    init_utcDay();
    init_utcWeek();
    init_utcMonth();
    init_utcYear();
  }
});

// node_modules/d3-time-format/src/locale.js
function localDate(d) {
  if (0 <= d.y && d.y < 100) {
    var date = new Date(-1, d.m, d.d, d.H, d.M, d.S, d.L);
    date.setFullYear(d.y);
    return date;
  }
  return new Date(d.y, d.m, d.d, d.H, d.M, d.S, d.L);
}
function utcDate(d) {
  if (0 <= d.y && d.y < 100) {
    var date = new Date(Date.UTC(-1, d.m, d.d, d.H, d.M, d.S, d.L));
    date.setUTCFullYear(d.y);
    return date;
  }
  return new Date(Date.UTC(d.y, d.m, d.d, d.H, d.M, d.S, d.L));
}
function newDate(y, m, d) {
  return { y, m, d, H: 0, M: 0, S: 0, L: 0 };
}
function formatLocale(locale3) {
  var locale_dateTime = locale3.dateTime, locale_date = locale3.date, locale_time = locale3.time, locale_periods = locale3.periods, locale_weekdays = locale3.days, locale_shortWeekdays = locale3.shortDays, locale_months = locale3.months, locale_shortMonths = locale3.shortMonths;
  var periodRe = formatRe(locale_periods), periodLookup = formatLookup(locale_periods), weekdayRe = formatRe(locale_weekdays), weekdayLookup = formatLookup(locale_weekdays), shortWeekdayRe = formatRe(locale_shortWeekdays), shortWeekdayLookup = formatLookup(locale_shortWeekdays), monthRe = formatRe(locale_months), monthLookup = formatLookup(locale_months), shortMonthRe = formatRe(locale_shortMonths), shortMonthLookup = formatLookup(locale_shortMonths);
  var formats = {
    "a": formatShortWeekday,
    "A": formatWeekday,
    "b": formatShortMonth,
    "B": formatMonth,
    "c": null,
    "d": formatDayOfMonth,
    "e": formatDayOfMonth,
    "f": formatMicroseconds,
    "g": formatYearISO,
    "G": formatFullYearISO,
    "H": formatHour24,
    "I": formatHour12,
    "j": formatDayOfYear,
    "L": formatMilliseconds,
    "m": formatMonthNumber,
    "M": formatMinutes,
    "p": formatPeriod,
    "q": formatQuarter,
    "Q": formatUnixTimestamp,
    "s": formatUnixTimestampSeconds,
    "S": formatSeconds,
    "u": formatWeekdayNumberMonday,
    "U": formatWeekNumberSunday,
    "V": formatWeekNumberISO,
    "w": formatWeekdayNumberSunday,
    "W": formatWeekNumberMonday,
    "x": null,
    "X": null,
    "y": formatYear,
    "Y": formatFullYear,
    "Z": formatZone,
    "%": formatLiteralPercent
  };
  var utcFormats = {
    "a": formatUTCShortWeekday,
    "A": formatUTCWeekday,
    "b": formatUTCShortMonth,
    "B": formatUTCMonth,
    "c": null,
    "d": formatUTCDayOfMonth,
    "e": formatUTCDayOfMonth,
    "f": formatUTCMicroseconds,
    "g": formatUTCYearISO,
    "G": formatUTCFullYearISO,
    "H": formatUTCHour24,
    "I": formatUTCHour12,
    "j": formatUTCDayOfYear,
    "L": formatUTCMilliseconds,
    "m": formatUTCMonthNumber,
    "M": formatUTCMinutes,
    "p": formatUTCPeriod,
    "q": formatUTCQuarter,
    "Q": formatUnixTimestamp,
    "s": formatUnixTimestampSeconds,
    "S": formatUTCSeconds,
    "u": formatUTCWeekdayNumberMonday,
    "U": formatUTCWeekNumberSunday,
    "V": formatUTCWeekNumberISO,
    "w": formatUTCWeekdayNumberSunday,
    "W": formatUTCWeekNumberMonday,
    "x": null,
    "X": null,
    "y": formatUTCYear,
    "Y": formatUTCFullYear,
    "Z": formatUTCZone,
    "%": formatLiteralPercent
  };
  var parses = {
    "a": parseShortWeekday,
    "A": parseWeekday,
    "b": parseShortMonth,
    "B": parseMonth,
    "c": parseLocaleDateTime,
    "d": parseDayOfMonth,
    "e": parseDayOfMonth,
    "f": parseMicroseconds,
    "g": parseYear,
    "G": parseFullYear,
    "H": parseHour24,
    "I": parseHour24,
    "j": parseDayOfYear,
    "L": parseMilliseconds,
    "m": parseMonthNumber,
    "M": parseMinutes,
    "p": parsePeriod,
    "q": parseQuarter,
    "Q": parseUnixTimestamp,
    "s": parseUnixTimestampSeconds,
    "S": parseSeconds,
    "u": parseWeekdayNumberMonday,
    "U": parseWeekNumberSunday,
    "V": parseWeekNumberISO,
    "w": parseWeekdayNumberSunday,
    "W": parseWeekNumberMonday,
    "x": parseLocaleDate,
    "X": parseLocaleTime,
    "y": parseYear,
    "Y": parseFullYear,
    "Z": parseZone,
    "%": parseLiteralPercent
  };
  formats.x = newFormat(locale_date, formats);
  formats.X = newFormat(locale_time, formats);
  formats.c = newFormat(locale_dateTime, formats);
  utcFormats.x = newFormat(locale_date, utcFormats);
  utcFormats.X = newFormat(locale_time, utcFormats);
  utcFormats.c = newFormat(locale_dateTime, utcFormats);
  function newFormat(specifier, formats2) {
    return function(date) {
      var string = [], i = -1, j = 0, n = specifier.length, c, pad2, format2;
      if (!(date instanceof Date)) date = /* @__PURE__ */ new Date(+date);
      while (++i < n) {
        if (specifier.charCodeAt(i) === 37) {
          string.push(specifier.slice(j, i));
          if ((pad2 = pads[c = specifier.charAt(++i)]) != null) c = specifier.charAt(++i);
          else pad2 = c === "e" ? " " : "0";
          if (format2 = formats2[c]) c = format2(date, pad2);
          string.push(c);
          j = i + 1;
        }
      }
      string.push(specifier.slice(j, i));
      return string.join("");
    };
  }
  function newParse(specifier, Z) {
    return function(string) {
      var d = newDate(1900, void 0, 1), i = parseSpecifier(d, specifier, string += "", 0), week, day2;
      if (i != string.length) return null;
      if ("Q" in d) return new Date(d.Q);
      if ("s" in d) return new Date(d.s * 1e3 + ("L" in d ? d.L : 0));
      if (Z && !("Z" in d)) d.Z = 0;
      if ("p" in d) d.H = d.H % 12 + d.p * 12;
      if (d.m === void 0) d.m = "q" in d ? d.q : 0;
      if ("V" in d) {
        if (d.V < 1 || d.V > 53) return null;
        if (!("w" in d)) d.w = 1;
        if ("Z" in d) {
          week = utcDate(newDate(d.y, 0, 1)), day2 = week.getUTCDay();
          week = day2 > 4 || day2 === 0 ? utcMonday.ceil(week) : utcMonday(week);
          week = utcDay_default.offset(week, (d.V - 1) * 7);
          d.y = week.getUTCFullYear();
          d.m = week.getUTCMonth();
          d.d = week.getUTCDate() + (d.w + 6) % 7;
        } else {
          week = localDate(newDate(d.y, 0, 1)), day2 = week.getDay();
          week = day2 > 4 || day2 === 0 ? monday.ceil(week) : monday(week);
          week = day_default.offset(week, (d.V - 1) * 7);
          d.y = week.getFullYear();
          d.m = week.getMonth();
          d.d = week.getDate() + (d.w + 6) % 7;
        }
      } else if ("W" in d || "U" in d) {
        if (!("w" in d)) d.w = "u" in d ? d.u % 7 : "W" in d ? 1 : 0;
        day2 = "Z" in d ? utcDate(newDate(d.y, 0, 1)).getUTCDay() : localDate(newDate(d.y, 0, 1)).getDay();
        d.m = 0;
        d.d = "W" in d ? (d.w + 6) % 7 + d.W * 7 - (day2 + 5) % 7 : d.w + d.U * 7 - (day2 + 6) % 7;
      }
      if ("Z" in d) {
        d.H += d.Z / 100 | 0;
        d.M += d.Z % 100;
        return utcDate(d);
      }
      return localDate(d);
    };
  }
  function parseSpecifier(d, specifier, string, j) {
    var i = 0, n = specifier.length, m = string.length, c, parse;
    while (i < n) {
      if (j >= m) return -1;
      c = specifier.charCodeAt(i++);
      if (c === 37) {
        c = specifier.charAt(i++);
        parse = parses[c in pads ? specifier.charAt(i++) : c];
        if (!parse || (j = parse(d, string, j)) < 0) return -1;
      } else if (c != string.charCodeAt(j++)) {
        return -1;
      }
    }
    return j;
  }
  function parsePeriod(d, string, i) {
    var n = periodRe.exec(string.slice(i));
    return n ? (d.p = periodLookup[n[0].toLowerCase()], i + n[0].length) : -1;
  }
  function parseShortWeekday(d, string, i) {
    var n = shortWeekdayRe.exec(string.slice(i));
    return n ? (d.w = shortWeekdayLookup[n[0].toLowerCase()], i + n[0].length) : -1;
  }
  function parseWeekday(d, string, i) {
    var n = weekdayRe.exec(string.slice(i));
    return n ? (d.w = weekdayLookup[n[0].toLowerCase()], i + n[0].length) : -1;
  }
  function parseShortMonth(d, string, i) {
    var n = shortMonthRe.exec(string.slice(i));
    return n ? (d.m = shortMonthLookup[n[0].toLowerCase()], i + n[0].length) : -1;
  }
  function parseMonth(d, string, i) {
    var n = monthRe.exec(string.slice(i));
    return n ? (d.m = monthLookup[n[0].toLowerCase()], i + n[0].length) : -1;
  }
  function parseLocaleDateTime(d, string, i) {
    return parseSpecifier(d, locale_dateTime, string, i);
  }
  function parseLocaleDate(d, string, i) {
    return parseSpecifier(d, locale_date, string, i);
  }
  function parseLocaleTime(d, string, i) {
    return parseSpecifier(d, locale_time, string, i);
  }
  function formatShortWeekday(d) {
    return locale_shortWeekdays[d.getDay()];
  }
  function formatWeekday(d) {
    return locale_weekdays[d.getDay()];
  }
  function formatShortMonth(d) {
    return locale_shortMonths[d.getMonth()];
  }
  function formatMonth(d) {
    return locale_months[d.getMonth()];
  }
  function formatPeriod(d) {
    return locale_periods[+(d.getHours() >= 12)];
  }
  function formatQuarter(d) {
    return 1 + ~~(d.getMonth() / 3);
  }
  function formatUTCShortWeekday(d) {
    return locale_shortWeekdays[d.getUTCDay()];
  }
  function formatUTCWeekday(d) {
    return locale_weekdays[d.getUTCDay()];
  }
  function formatUTCShortMonth(d) {
    return locale_shortMonths[d.getUTCMonth()];
  }
  function formatUTCMonth(d) {
    return locale_months[d.getUTCMonth()];
  }
  function formatUTCPeriod(d) {
    return locale_periods[+(d.getUTCHours() >= 12)];
  }
  function formatUTCQuarter(d) {
    return 1 + ~~(d.getUTCMonth() / 3);
  }
  return {
    format: function(specifier) {
      var f = newFormat(specifier += "", formats);
      f.toString = function() {
        return specifier;
      };
      return f;
    },
    parse: function(specifier) {
      var p = newParse(specifier += "", false);
      p.toString = function() {
        return specifier;
      };
      return p;
    },
    utcFormat: function(specifier) {
      var f = newFormat(specifier += "", utcFormats);
      f.toString = function() {
        return specifier;
      };
      return f;
    },
    utcParse: function(specifier) {
      var p = newParse(specifier += "", true);
      p.toString = function() {
        return specifier;
      };
      return p;
    }
  };
}
function pad(value, fill, width) {
  var sign = value < 0 ? "-" : "", string = (sign ? -value : value) + "", length = string.length;
  return sign + (length < width ? new Array(width - length + 1).join(fill) + string : string);
}
function requote(s) {
  return s.replace(requoteRe, "\\$&");
}
function formatRe(names) {
  return new RegExp("^(?:" + names.map(requote).join("|") + ")", "i");
}
function formatLookup(names) {
  var map2 = {}, i = -1, n = names.length;
  while (++i < n) map2[names[i].toLowerCase()] = i;
  return map2;
}
function parseWeekdayNumberSunday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 1));
  return n ? (d.w = +n[0], i + n[0].length) : -1;
}
function parseWeekdayNumberMonday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 1));
  return n ? (d.u = +n[0], i + n[0].length) : -1;
}
function parseWeekNumberSunday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.U = +n[0], i + n[0].length) : -1;
}
function parseWeekNumberISO(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.V = +n[0], i + n[0].length) : -1;
}
function parseWeekNumberMonday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.W = +n[0], i + n[0].length) : -1;
}
function parseFullYear(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 4));
  return n ? (d.y = +n[0], i + n[0].length) : -1;
}
function parseYear(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.y = +n[0] + (+n[0] > 68 ? 1900 : 2e3), i + n[0].length) : -1;
}
function parseZone(d, string, i) {
  var n = /^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string.slice(i, i + 6));
  return n ? (d.Z = n[1] ? 0 : -(n[2] + (n[3] || "00")), i + n[0].length) : -1;
}
function parseQuarter(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 1));
  return n ? (d.q = n[0] * 3 - 3, i + n[0].length) : -1;
}
function parseMonthNumber(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.m = n[0] - 1, i + n[0].length) : -1;
}
function parseDayOfMonth(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.d = +n[0], i + n[0].length) : -1;
}
function parseDayOfYear(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 3));
  return n ? (d.m = 0, d.d = +n[0], i + n[0].length) : -1;
}
function parseHour24(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.H = +n[0], i + n[0].length) : -1;
}
function parseMinutes(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.M = +n[0], i + n[0].length) : -1;
}
function parseSeconds(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.S = +n[0], i + n[0].length) : -1;
}
function parseMilliseconds(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 3));
  return n ? (d.L = +n[0], i + n[0].length) : -1;
}
function parseMicroseconds(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 6));
  return n ? (d.L = Math.floor(n[0] / 1e3), i + n[0].length) : -1;
}
function parseLiteralPercent(d, string, i) {
  var n = percentRe.exec(string.slice(i, i + 1));
  return n ? i + n[0].length : -1;
}
function parseUnixTimestamp(d, string, i) {
  var n = numberRe.exec(string.slice(i));
  return n ? (d.Q = +n[0], i + n[0].length) : -1;
}
function parseUnixTimestampSeconds(d, string, i) {
  var n = numberRe.exec(string.slice(i));
  return n ? (d.s = +n[0], i + n[0].length) : -1;
}
function formatDayOfMonth(d, p) {
  return pad(d.getDate(), p, 2);
}
function formatHour24(d, p) {
  return pad(d.getHours(), p, 2);
}
function formatHour12(d, p) {
  return pad(d.getHours() % 12 || 12, p, 2);
}
function formatDayOfYear(d, p) {
  return pad(1 + day_default.count(year_default(d), d), p, 3);
}
function formatMilliseconds(d, p) {
  return pad(d.getMilliseconds(), p, 3);
}
function formatMicroseconds(d, p) {
  return formatMilliseconds(d, p) + "000";
}
function formatMonthNumber(d, p) {
  return pad(d.getMonth() + 1, p, 2);
}
function formatMinutes(d, p) {
  return pad(d.getMinutes(), p, 2);
}
function formatSeconds(d, p) {
  return pad(d.getSeconds(), p, 2);
}
function formatWeekdayNumberMonday(d) {
  var day2 = d.getDay();
  return day2 === 0 ? 7 : day2;
}
function formatWeekNumberSunday(d, p) {
  return pad(sunday.count(year_default(d) - 1, d), p, 2);
}
function dISO(d) {
  var day2 = d.getDay();
  return day2 >= 4 || day2 === 0 ? thursday(d) : thursday.ceil(d);
}
function formatWeekNumberISO(d, p) {
  d = dISO(d);
  return pad(thursday.count(year_default(d), d) + (year_default(d).getDay() === 4), p, 2);
}
function formatWeekdayNumberSunday(d) {
  return d.getDay();
}
function formatWeekNumberMonday(d, p) {
  return pad(monday.count(year_default(d) - 1, d), p, 2);
}
function formatYear(d, p) {
  return pad(d.getFullYear() % 100, p, 2);
}
function formatYearISO(d, p) {
  d = dISO(d);
  return pad(d.getFullYear() % 100, p, 2);
}
function formatFullYear(d, p) {
  return pad(d.getFullYear() % 1e4, p, 4);
}
function formatFullYearISO(d, p) {
  var day2 = d.getDay();
  d = day2 >= 4 || day2 === 0 ? thursday(d) : thursday.ceil(d);
  return pad(d.getFullYear() % 1e4, p, 4);
}
function formatZone(d) {
  var z2 = d.getTimezoneOffset();
  return (z2 > 0 ? "-" : (z2 *= -1, "+")) + pad(z2 / 60 | 0, "0", 2) + pad(z2 % 60, "0", 2);
}
function formatUTCDayOfMonth(d, p) {
  return pad(d.getUTCDate(), p, 2);
}
function formatUTCHour24(d, p) {
  return pad(d.getUTCHours(), p, 2);
}
function formatUTCHour12(d, p) {
  return pad(d.getUTCHours() % 12 || 12, p, 2);
}
function formatUTCDayOfYear(d, p) {
  return pad(1 + utcDay_default.count(utcYear_default(d), d), p, 3);
}
function formatUTCMilliseconds(d, p) {
  return pad(d.getUTCMilliseconds(), p, 3);
}
function formatUTCMicroseconds(d, p) {
  return formatUTCMilliseconds(d, p) + "000";
}
function formatUTCMonthNumber(d, p) {
  return pad(d.getUTCMonth() + 1, p, 2);
}
function formatUTCMinutes(d, p) {
  return pad(d.getUTCMinutes(), p, 2);
}
function formatUTCSeconds(d, p) {
  return pad(d.getUTCSeconds(), p, 2);
}
function formatUTCWeekdayNumberMonday(d) {
  var dow = d.getUTCDay();
  return dow === 0 ? 7 : dow;
}
function formatUTCWeekNumberSunday(d, p) {
  return pad(utcSunday.count(utcYear_default(d) - 1, d), p, 2);
}
function UTCdISO(d) {
  var day2 = d.getUTCDay();
  return day2 >= 4 || day2 === 0 ? utcThursday(d) : utcThursday.ceil(d);
}
function formatUTCWeekNumberISO(d, p) {
  d = UTCdISO(d);
  return pad(utcThursday.count(utcYear_default(d), d) + (utcYear_default(d).getUTCDay() === 4), p, 2);
}
function formatUTCWeekdayNumberSunday(d) {
  return d.getUTCDay();
}
function formatUTCWeekNumberMonday(d, p) {
  return pad(utcMonday.count(utcYear_default(d) - 1, d), p, 2);
}
function formatUTCYear(d, p) {
  return pad(d.getUTCFullYear() % 100, p, 2);
}
function formatUTCYearISO(d, p) {
  d = UTCdISO(d);
  return pad(d.getUTCFullYear() % 100, p, 2);
}
function formatUTCFullYear(d, p) {
  return pad(d.getUTCFullYear() % 1e4, p, 4);
}
function formatUTCFullYearISO(d, p) {
  var day2 = d.getUTCDay();
  d = day2 >= 4 || day2 === 0 ? utcThursday(d) : utcThursday.ceil(d);
  return pad(d.getUTCFullYear() % 1e4, p, 4);
}
function formatUTCZone() {
  return "+0000";
}
function formatLiteralPercent() {
  return "%";
}
function formatUnixTimestamp(d) {
  return +d;
}
function formatUnixTimestampSeconds(d) {
  return Math.floor(+d / 1e3);
}
var pads, numberRe, percentRe, requoteRe;
var init_locale = __esm({
  "node_modules/d3-time-format/src/locale.js"() {
    init_src();
    pads = { "-": "", "_": " ", "0": "0" };
    numberRe = /^\s*\d+/;
    percentRe = /^%/;
    requoteRe = /[\\^$*+?|[\]().{}]/g;
  }
});

// node_modules/d3-time-format/src/defaultLocale.js
function defaultLocale(definition) {
  locale = formatLocale(definition);
  timeFormat = locale.format;
  timeParse = locale.parse;
  utcFormat = locale.utcFormat;
  utcParse = locale.utcParse;
  return locale;
}
var locale, timeFormat, timeParse, utcFormat, utcParse;
var init_defaultLocale = __esm({
  "node_modules/d3-time-format/src/defaultLocale.js"() {
    init_locale();
    defaultLocale({
      dateTime: "%x, %X",
      date: "%-m/%-d/%Y",
      time: "%-I:%M:%S %p",
      periods: ["AM", "PM"],
      days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
      shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
      months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
      shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
    });
  }
});

// node_modules/d3-time-format/src/isoFormat.js
function formatIsoNative(date) {
  return date.toISOString();
}
var isoSpecifier, formatIso, isoFormat_default;
var init_isoFormat = __esm({
  "node_modules/d3-time-format/src/isoFormat.js"() {
    init_defaultLocale();
    isoSpecifier = "%Y-%m-%dT%H:%M:%S.%LZ";
    formatIso = Date.prototype.toISOString ? formatIsoNative : utcFormat(isoSpecifier);
    isoFormat_default = formatIso;
  }
});

// node_modules/d3-time-format/src/isoParse.js
function parseIsoNative(string) {
  var date = new Date(string);
  return isNaN(date) ? null : date;
}
var parseIso, isoParse_default;
var init_isoParse = __esm({
  "node_modules/d3-time-format/src/isoParse.js"() {
    init_isoFormat();
    init_defaultLocale();
    parseIso = +/* @__PURE__ */ new Date("2000-01-01T00:00:00.000Z") ? parseIsoNative : utcParse(isoSpecifier);
    isoParse_default = parseIso;
  }
});

// node_modules/d3-time-format/src/index.js
var src_exports2 = {};
__export(src_exports2, {
  isoFormat: () => isoFormat_default,
  isoParse: () => isoParse_default,
  timeFormat: () => timeFormat,
  timeFormatDefaultLocale: () => defaultLocale,
  timeFormatLocale: () => formatLocale,
  timeParse: () => timeParse,
  utcFormat: () => utcFormat,
  utcParse: () => utcParse
});
var init_src2 = __esm({
  "node_modules/d3-time-format/src/index.js"() {
    init_defaultLocale();
    init_locale();
    init_isoFormat();
    init_isoParse();
  }
});

// node_modules/d3-format/src/formatDecimal.js
function formatDecimal_default(x) {
  return Math.abs(x = Math.round(x)) >= 1e21 ? x.toLocaleString("en").replace(/,/g, "") : x.toString(10);
}
function formatDecimalParts(x, p) {
  if ((i = (x = p ? x.toExponential(p - 1) : x.toExponential()).indexOf("e")) < 0) return null;
  var i, coefficient = x.slice(0, i);
  return [
    coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
    +x.slice(i + 1)
  ];
}
var init_formatDecimal = __esm({
  "node_modules/d3-format/src/formatDecimal.js"() {
  }
});

// node_modules/d3-format/src/exponent.js
function exponent_default(x) {
  return x = formatDecimalParts(Math.abs(x)), x ? x[1] : NaN;
}
var init_exponent = __esm({
  "node_modules/d3-format/src/exponent.js"() {
    init_formatDecimal();
  }
});

// node_modules/d3-format/src/formatGroup.js
function formatGroup_default(grouping, thousands) {
  return function(value, width) {
    var i = value.length, t = [], j = 0, g = grouping[0], length = 0;
    while (i > 0 && g > 0) {
      if (length + g + 1 > width) g = Math.max(1, width - length);
      t.push(value.substring(i -= g, i + g));
      if ((length += g + 1) > width) break;
      g = grouping[j = (j + 1) % grouping.length];
    }
    return t.reverse().join(thousands);
  };
}
var init_formatGroup = __esm({
  "node_modules/d3-format/src/formatGroup.js"() {
  }
});

// node_modules/d3-format/src/formatNumerals.js
function formatNumerals_default(numerals) {
  return function(value) {
    return value.replace(/[0-9]/g, function(i) {
      return numerals[+i];
    });
  };
}
var init_formatNumerals = __esm({
  "node_modules/d3-format/src/formatNumerals.js"() {
  }
});

// node_modules/d3-format/src/formatSpecifier.js
function formatSpecifier(specifier) {
  if (!(match = re.exec(specifier))) throw new Error("invalid format: " + specifier);
  var match;
  return new FormatSpecifier({
    fill: match[1],
    align: match[2],
    sign: match[3],
    symbol: match[4],
    zero: match[5],
    width: match[6],
    comma: match[7],
    precision: match[8] && match[8].slice(1),
    trim: match[9],
    type: match[10]
  });
}
function FormatSpecifier(specifier) {
  this.fill = specifier.fill === void 0 ? " " : specifier.fill + "";
  this.align = specifier.align === void 0 ? ">" : specifier.align + "";
  this.sign = specifier.sign === void 0 ? "-" : specifier.sign + "";
  this.symbol = specifier.symbol === void 0 ? "" : specifier.symbol + "";
  this.zero = !!specifier.zero;
  this.width = specifier.width === void 0 ? void 0 : +specifier.width;
  this.comma = !!specifier.comma;
  this.precision = specifier.precision === void 0 ? void 0 : +specifier.precision;
  this.trim = !!specifier.trim;
  this.type = specifier.type === void 0 ? "" : specifier.type + "";
}
var re;
var init_formatSpecifier = __esm({
  "node_modules/d3-format/src/formatSpecifier.js"() {
    re = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;
    formatSpecifier.prototype = FormatSpecifier.prototype;
    FormatSpecifier.prototype.toString = function() {
      return this.fill + this.align + this.sign + this.symbol + (this.zero ? "0" : "") + (this.width === void 0 ? "" : Math.max(1, this.width | 0)) + (this.comma ? "," : "") + (this.precision === void 0 ? "" : "." + Math.max(0, this.precision | 0)) + (this.trim ? "~" : "") + this.type;
    };
  }
});

// node_modules/d3-format/src/formatTrim.js
function formatTrim_default(s) {
  out: for (var n = s.length, i = 1, i02 = -1, i12; i < n; ++i) {
    switch (s[i]) {
      case ".":
        i02 = i12 = i;
        break;
      case "0":
        if (i02 === 0) i02 = i;
        i12 = i;
        break;
      default:
        if (!+s[i]) break out;
        if (i02 > 0) i02 = 0;
        break;
    }
  }
  return i02 > 0 ? s.slice(0, i02) + s.slice(i12 + 1) : s;
}
var init_formatTrim = __esm({
  "node_modules/d3-format/src/formatTrim.js"() {
  }
});

// node_modules/d3-format/src/formatPrefixAuto.js
function formatPrefixAuto_default(x, p) {
  var d = formatDecimalParts(x, p);
  if (!d) return x + "";
  var coefficient = d[0], exponent = d[1], i = exponent - (prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent / 3))) * 3) + 1, n = coefficient.length;
  return i === n ? coefficient : i > n ? coefficient + new Array(i - n + 1).join("0") : i > 0 ? coefficient.slice(0, i) + "." + coefficient.slice(i) : "0." + new Array(1 - i).join("0") + formatDecimalParts(x, Math.max(0, p + i - 1))[0];
}
var prefixExponent;
var init_formatPrefixAuto = __esm({
  "node_modules/d3-format/src/formatPrefixAuto.js"() {
    init_formatDecimal();
  }
});

// node_modules/d3-format/src/formatRounded.js
function formatRounded_default(x, p) {
  var d = formatDecimalParts(x, p);
  if (!d) return x + "";
  var coefficient = d[0], exponent = d[1];
  return exponent < 0 ? "0." + new Array(-exponent).join("0") + coefficient : coefficient.length > exponent + 1 ? coefficient.slice(0, exponent + 1) + "." + coefficient.slice(exponent + 1) : coefficient + new Array(exponent - coefficient.length + 2).join("0");
}
var init_formatRounded = __esm({
  "node_modules/d3-format/src/formatRounded.js"() {
    init_formatDecimal();
  }
});

// node_modules/d3-format/src/formatTypes.js
var formatTypes_default;
var init_formatTypes = __esm({
  "node_modules/d3-format/src/formatTypes.js"() {
    init_formatDecimal();
    init_formatPrefixAuto();
    init_formatRounded();
    formatTypes_default = {
      "%": function(x, p) {
        return (x * 100).toFixed(p);
      },
      "b": function(x) {
        return Math.round(x).toString(2);
      },
      "c": function(x) {
        return x + "";
      },
      "d": formatDecimal_default,
      "e": function(x, p) {
        return x.toExponential(p);
      },
      "f": function(x, p) {
        return x.toFixed(p);
      },
      "g": function(x, p) {
        return x.toPrecision(p);
      },
      "o": function(x) {
        return Math.round(x).toString(8);
      },
      "p": function(x, p) {
        return formatRounded_default(x * 100, p);
      },
      "r": formatRounded_default,
      "s": formatPrefixAuto_default,
      "X": function(x) {
        return Math.round(x).toString(16).toUpperCase();
      },
      "x": function(x) {
        return Math.round(x).toString(16);
      }
    };
  }
});

// node_modules/d3-format/src/identity.js
function identity_default(x) {
  return x;
}
var init_identity = __esm({
  "node_modules/d3-format/src/identity.js"() {
  }
});

// node_modules/d3-format/src/locale.js
function locale_default(locale3) {
  var group = locale3.grouping === void 0 || locale3.thousands === void 0 ? identity_default : formatGroup_default(map.call(locale3.grouping, Number), locale3.thousands + ""), currencyPrefix = locale3.currency === void 0 ? "" : locale3.currency[0] + "", currencySuffix = locale3.currency === void 0 ? "" : locale3.currency[1] + "", decimal = locale3.decimal === void 0 ? "." : locale3.decimal + "", numerals = locale3.numerals === void 0 ? identity_default : formatNumerals_default(map.call(locale3.numerals, String)), percent = locale3.percent === void 0 ? "%" : locale3.percent + "", minus = locale3.minus === void 0 ? "-" : locale3.minus + "", nan = locale3.nan === void 0 ? "NaN" : locale3.nan + "";
  function newFormat(specifier) {
    specifier = formatSpecifier(specifier);
    var fill = specifier.fill, align = specifier.align, sign = specifier.sign, symbol = specifier.symbol, zero = specifier.zero, width = specifier.width, comma = specifier.comma, precision = specifier.precision, trim = specifier.trim, type = specifier.type;
    if (type === "n") comma = true, type = "g";
    else if (!formatTypes_default[type]) precision === void 0 && (precision = 12), trim = true, type = "g";
    if (zero || fill === "0" && align === "=") zero = true, fill = "0", align = "=";
    var prefix = symbol === "$" ? currencyPrefix : symbol === "#" && /[boxX]/.test(type) ? "0" + type.toLowerCase() : "", suffix = symbol === "$" ? currencySuffix : /[%p]/.test(type) ? percent : "";
    var formatType = formatTypes_default[type], maybeSuffix = /[defgprs%]/.test(type);
    precision = precision === void 0 ? 6 : /[gprs]/.test(type) ? Math.max(1, Math.min(21, precision)) : Math.max(0, Math.min(20, precision));
    function format2(value) {
      var valuePrefix = prefix, valueSuffix = suffix, i, n, c;
      if (type === "c") {
        valueSuffix = formatType(value) + valueSuffix;
        value = "";
      } else {
        value = +value;
        var valueNegative = value < 0 || 1 / value < 0;
        value = isNaN(value) ? nan : formatType(Math.abs(value), precision);
        if (trim) value = formatTrim_default(value);
        if (valueNegative && +value === 0 && sign !== "+") valueNegative = false;
        valuePrefix = (valueNegative ? sign === "(" ? sign : minus : sign === "-" || sign === "(" ? "" : sign) + valuePrefix;
        valueSuffix = (type === "s" ? prefixes[8 + prefixExponent / 3] : "") + valueSuffix + (valueNegative && sign === "(" ? ")" : "");
        if (maybeSuffix) {
          i = -1, n = value.length;
          while (++i < n) {
            if (c = value.charCodeAt(i), 48 > c || c > 57) {
              valueSuffix = (c === 46 ? decimal + value.slice(i + 1) : value.slice(i)) + valueSuffix;
              value = value.slice(0, i);
              break;
            }
          }
        }
      }
      if (comma && !zero) value = group(value, Infinity);
      var length = valuePrefix.length + value.length + valueSuffix.length, padding = length < width ? new Array(width - length + 1).join(fill) : "";
      if (comma && zero) value = group(padding + value, padding.length ? width - valueSuffix.length : Infinity), padding = "";
      switch (align) {
        case "<":
          value = valuePrefix + value + valueSuffix + padding;
          break;
        case "=":
          value = valuePrefix + padding + value + valueSuffix;
          break;
        case "^":
          value = padding.slice(0, length = padding.length >> 1) + valuePrefix + value + valueSuffix + padding.slice(length);
          break;
        default:
          value = padding + valuePrefix + value + valueSuffix;
          break;
      }
      return numerals(value);
    }
    format2.toString = function() {
      return specifier + "";
    };
    return format2;
  }
  function formatPrefix2(specifier, value) {
    var f = newFormat((specifier = formatSpecifier(specifier), specifier.type = "f", specifier)), e = Math.max(-8, Math.min(8, Math.floor(exponent_default(value) / 3))) * 3, k = Math.pow(10, -e), prefix = prefixes[8 + e / 3];
    return function(value2) {
      return f(k * value2) + prefix;
    };
  }
  return {
    format: newFormat,
    formatPrefix: formatPrefix2
  };
}
var map, prefixes;
var init_locale2 = __esm({
  "node_modules/d3-format/src/locale.js"() {
    init_exponent();
    init_formatGroup();
    init_formatNumerals();
    init_formatSpecifier();
    init_formatTrim();
    init_formatTypes();
    init_formatPrefixAuto();
    init_identity();
    map = Array.prototype.map;
    prefixes = ["y", "z", "a", "f", "p", "n", "µ", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y"];
  }
});

// node_modules/d3-format/src/defaultLocale.js
function defaultLocale2(definition) {
  locale2 = locale_default(definition);
  format = locale2.format;
  formatPrefix = locale2.formatPrefix;
  return locale2;
}
var locale2, format, formatPrefix;
var init_defaultLocale2 = __esm({
  "node_modules/d3-format/src/defaultLocale.js"() {
    init_locale2();
    defaultLocale2({
      decimal: ".",
      thousands: ",",
      grouping: [3],
      currency: ["$", ""],
      minus: "-"
    });
  }
});

// node_modules/d3-format/src/precisionFixed.js
function precisionFixed_default(step) {
  return Math.max(0, -exponent_default(Math.abs(step)));
}
var init_precisionFixed = __esm({
  "node_modules/d3-format/src/precisionFixed.js"() {
    init_exponent();
  }
});

// node_modules/d3-format/src/precisionPrefix.js
function precisionPrefix_default(step, value) {
  return Math.max(0, Math.max(-8, Math.min(8, Math.floor(exponent_default(value) / 3))) * 3 - exponent_default(Math.abs(step)));
}
var init_precisionPrefix = __esm({
  "node_modules/d3-format/src/precisionPrefix.js"() {
    init_exponent();
  }
});

// node_modules/d3-format/src/precisionRound.js
function precisionRound_default(step, max) {
  step = Math.abs(step), max = Math.abs(max) - step;
  return Math.max(0, exponent_default(max) - exponent_default(step)) + 1;
}
var init_precisionRound = __esm({
  "node_modules/d3-format/src/precisionRound.js"() {
    init_exponent();
  }
});

// node_modules/d3-format/src/index.js
var src_exports3 = {};
__export(src_exports3, {
  FormatSpecifier: () => FormatSpecifier,
  format: () => format,
  formatDefaultLocale: () => defaultLocale2,
  formatLocale: () => locale_default,
  formatPrefix: () => formatPrefix,
  formatSpecifier: () => formatSpecifier,
  precisionFixed: () => precisionFixed_default,
  precisionPrefix: () => precisionPrefix_default,
  precisionRound: () => precisionRound_default
});
var init_src3 = __esm({
  "node_modules/d3-format/src/index.js"() {
    init_defaultLocale2();
    init_locale2();
    init_formatSpecifier();
    init_precisionFixed();
    init_precisionPrefix();
    init_precisionRound();
  }
});

// node_modules/is-string-blank/index.js
var require_is_string_blank = __commonJS({
  "node_modules/is-string-blank/index.js"(exports2, module2) {
    "use strict";
    module2.exports = function(str) {
      var l = str.length, a;
      for (var i = 0; i < l; i++) {
        a = str.charCodeAt(i);
        if ((a < 9 || a > 13) && a !== 32 && a !== 133 && a !== 160 && a !== 5760 && a !== 6158 && (a < 8192 || a > 8205) && a !== 8232 && a !== 8233 && a !== 8239 && a !== 8287 && a !== 8288 && a !== 12288 && a !== 65279) {
          return false;
        }
      }
      return true;
    };
  }
});

// node_modules/fast-isnumeric/index.js
var require_fast_isnumeric = __commonJS({
  "node_modules/fast-isnumeric/index.js"(exports2, module2) {
    "use strict";
    var allBlankCharCodes = require_is_string_blank();
    module2.exports = function(n) {
      var type = typeof n;
      if (type === "string") {
        var original = n;
        n = +n;
        if (n === 0 && allBlankCharCodes(original)) return false;
      } else if (type !== "number") return false;
      return n - n < 1;
    };
  }
});

// node_modules/plotly.js/src/constants/numerical.js
var require_numerical = __commonJS({
  "node_modules/plotly.js/src/constants/numerical.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      /**
       * Standardize all missing data in calcdata to use undefined
       * never null or NaN.
       * That way we can use !==undefined, or !== BADNUM,
       * to test for real data
       */
      BADNUM: void 0,
      /*
       * Limit certain operations to well below floating point max value
       * to avoid glitches: Make sure that even when you multiply it by the
       * number of pixels on a giant screen it still works
       */
      FP_SAFE: Number.MAX_VALUE * 1e-4,
      /*
       * conversion of date units to milliseconds
       * year and month constants are marked "AVG"
       * to remind us that not all years and months
       * have the same length
       */
      ONEMAXYEAR: 316224e5,
      // 366 * ONEDAY
      ONEAVGYEAR: 315576e5,
      // 365.25 days
      ONEMINYEAR: 31536e6,
      // 365 * ONEDAY
      ONEMAXQUARTER: 79488e5,
      // 92 * ONEDAY
      ONEAVGQUARTER: 78894e5,
      // 1/4 of ONEAVGYEAR
      ONEMINQUARTER: 76896e5,
      // 89 * ONEDAY
      ONEMAXMONTH: 26784e5,
      // 31 * ONEDAY
      ONEAVGMONTH: 26298e5,
      // 1/12 of ONEAVGYEAR
      ONEMINMONTH: 24192e5,
      // 28 * ONEDAY
      ONEWEEK: 6048e5,
      // 7 * ONEDAY
      ONEDAY: 864e5,
      // 24 * ONEHOUR
      ONEHOUR: 36e5,
      ONEMIN: 6e4,
      ONESEC: 1e3,
      ONEMILLI: 1,
      ONEMICROSEC: 1e-3,
      /*
       * For fast conversion btwn world calendars and epoch ms, the Julian Day Number
       * of the unix epoch. From calendars.instance().newDate(1970, 1, 1).toJD()
       */
      EPOCHJD: 24405875e-1,
      /*
       * Are two values nearly equal? Compare to 1PPM
       */
      ALMOST_EQUAL: 1 - 1e-6,
      /*
       * If we're asked to clip a non-positive log value, how far off-screen
       * do we put it?
       */
      LOG_CLIP: 10,
      /*
       * not a number, but for displaying numbers: the "minus sign" symbol is
       * wider than the regular ascii dash "-"
       */
      MINUS_SIGN: "−"
    };
  }
});

// node_modules/base64-arraybuffer/dist/base64-arraybuffer.es5.js
var base64_arraybuffer_es5_exports = {};
__export(base64_arraybuffer_es5_exports, {
  decode: () => decode,
  encode: () => encode
});
var chars, lookup, i, encode, decode;
var init_base64_arraybuffer_es5 = __esm({
  "node_modules/base64-arraybuffer/dist/base64-arraybuffer.es5.js"() {
    chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    lookup = typeof Uint8Array === "undefined" ? [] : new Uint8Array(256);
    for (i = 0; i < chars.length; i++) {
      lookup[chars.charCodeAt(i)] = i;
    }
    encode = function(arraybuffer) {
      var bytes = new Uint8Array(arraybuffer), i, len = bytes.length, base64 = "";
      for (i = 0; i < len; i += 3) {
        base64 += chars[bytes[i] >> 2];
        base64 += chars[(bytes[i] & 3) << 4 | bytes[i + 1] >> 4];
        base64 += chars[(bytes[i + 1] & 15) << 2 | bytes[i + 2] >> 6];
        base64 += chars[bytes[i + 2] & 63];
      }
      if (len % 3 === 2) {
        base64 = base64.substring(0, base64.length - 1) + "=";
      } else if (len % 3 === 1) {
        base64 = base64.substring(0, base64.length - 2) + "==";
      }
      return base64;
    };
    decode = function(base64) {
      var bufferLength = base64.length * 0.75, len = base64.length, i, p = 0, encoded1, encoded2, encoded3, encoded4;
      if (base64[base64.length - 1] === "=") {
        bufferLength--;
        if (base64[base64.length - 2] === "=") {
          bufferLength--;
        }
      }
      var arraybuffer = new ArrayBuffer(bufferLength), bytes = new Uint8Array(arraybuffer);
      for (i = 0; i < len; i += 4) {
        encoded1 = lookup[base64.charCodeAt(i)];
        encoded2 = lookup[base64.charCodeAt(i + 1)];
        encoded3 = lookup[base64.charCodeAt(i + 2)];
        encoded4 = lookup[base64.charCodeAt(i + 3)];
        bytes[p++] = encoded1 << 2 | encoded2 >> 4;
        bytes[p++] = (encoded2 & 15) << 4 | encoded3 >> 2;
        bytes[p++] = (encoded3 & 3) << 6 | encoded4 & 63;
      }
      return arraybuffer;
    };
  }
});

// node_modules/plotly.js/src/lib/is_plain_object.js
var require_is_plain_object = __commonJS({
  "node_modules/plotly.js/src/lib/is_plain_object.js"(exports2, module2) {
    "use strict";
    module2.exports = function isPlainObject(obj) {
      if (window && window.process && window.process.versions) {
        return Object.prototype.toString.call(obj) === "[object Object]";
      }
      return Object.prototype.toString.call(obj) === "[object Object]" && Object.getPrototypeOf(obj).hasOwnProperty("hasOwnProperty");
    };
  }
});

// node_modules/plotly.js/src/lib/array.js
var require_array = __commonJS({
  "node_modules/plotly.js/src/lib/array.js"(exports2) {
    "use strict";
    var b64decode = (init_base64_arraybuffer_es5(), __toCommonJS(base64_arraybuffer_es5_exports)).decode;
    var isPlainObject = require_is_plain_object();
    var isArray = Array.isArray;
    var ab = ArrayBuffer;
    var dv2 = DataView;
    function isTypedArray(a) {
      return ab.isView(a) && !(a instanceof dv2);
    }
    exports2.isTypedArray = isTypedArray;
    function isArrayOrTypedArray(a) {
      return isArray(a) || isTypedArray(a);
    }
    exports2.isArrayOrTypedArray = isArrayOrTypedArray;
    function isArray1D(a) {
      return !isArrayOrTypedArray(a[0]);
    }
    exports2.isArray1D = isArray1D;
    exports2.ensureArray = function(out, n) {
      if (!isArray(out)) out = [];
      out.length = n;
      return out;
    };
    var typedArrays = {
      u1c: typeof Uint8ClampedArray === "undefined" ? void 0 : Uint8ClampedArray,
      // not supported in numpy?
      i1: typeof Int8Array === "undefined" ? void 0 : Int8Array,
      u1: typeof Uint8Array === "undefined" ? void 0 : Uint8Array,
      i2: typeof Int16Array === "undefined" ? void 0 : Int16Array,
      u2: typeof Uint16Array === "undefined" ? void 0 : Uint16Array,
      i4: typeof Int32Array === "undefined" ? void 0 : Int32Array,
      u4: typeof Uint32Array === "undefined" ? void 0 : Uint32Array,
      f4: typeof Float32Array === "undefined" ? void 0 : Float32Array,
      f8: typeof Float64Array === "undefined" ? void 0 : Float64Array
      /* TODO: potentially add Big Int
      
          i8: typeof BigInt64Array === 'undefined' ? undefined :
                     BigInt64Array,
      
          u8: typeof BigUint64Array === 'undefined' ? undefined :
                     BigUint64Array,
          */
    };
    typedArrays.uint8c = typedArrays.u1c;
    typedArrays.uint8 = typedArrays.u1;
    typedArrays.int8 = typedArrays.i1;
    typedArrays.uint16 = typedArrays.u2;
    typedArrays.int16 = typedArrays.i2;
    typedArrays.uint32 = typedArrays.u4;
    typedArrays.int32 = typedArrays.i4;
    typedArrays.float32 = typedArrays.f4;
    typedArrays.float64 = typedArrays.f8;
    function isArrayBuffer(a) {
      return a.constructor === ArrayBuffer;
    }
    exports2.isArrayBuffer = isArrayBuffer;
    exports2.decodeTypedArraySpec = function(vIn) {
      var out = [];
      var v = coerceTypedArraySpec(vIn);
      var dtype = v.dtype;
      var T = typedArrays[dtype];
      if (!T) throw new Error('Error in dtype: "' + dtype + '"');
      var BYTES_PER_ELEMENT = T.BYTES_PER_ELEMENT;
      var buffer = v.bdata;
      if (!isArrayBuffer(buffer)) {
        buffer = b64decode(buffer);
      }
      var shape = v.shape === void 0 ? (
        // detect 1-d length
        [buffer.byteLength / BYTES_PER_ELEMENT]
      ) : (
        // convert number to string and split to array
        ("" + v.shape).split(",")
      );
      shape.reverse();
      var ndim = shape.length;
      var nj, j;
      var ni2 = +shape[0];
      var rowBytes = BYTES_PER_ELEMENT * ni2;
      var pos = 0;
      if (ndim === 1) {
        out = new T(buffer);
      } else if (ndim === 2) {
        nj = +shape[1];
        for (j = 0; j < nj; j++) {
          out[j] = new T(buffer, pos, ni2);
          pos += rowBytes;
        }
      } else if (ndim === 3) {
        nj = +shape[1];
        var nk = +shape[2];
        for (var k = 0; k < nk; k++) {
          out[k] = [];
          for (j = 0; j < nj; j++) {
            out[k][j] = new T(buffer, pos, ni2);
            pos += rowBytes;
          }
        }
      } else {
        throw new Error("ndim: " + ndim + 'is not supported with the shape:"' + v.shape + '"');
      }
      out.bdata = v.bdata;
      out.dtype = v.dtype;
      out.shape = shape.reverse().join(",");
      vIn._inputArray = out;
      return out;
    };
    exports2.isTypedArraySpec = function(v) {
      return isPlainObject(v) && v.hasOwnProperty("dtype") && typeof v.dtype === "string" && v.hasOwnProperty("bdata") && (typeof v.bdata === "string" || isArrayBuffer(v.bdata)) && (v.shape === void 0 || v.hasOwnProperty("shape") && (typeof v.shape === "string" || typeof v.shape === "number"));
    };
    function coerceTypedArraySpec(v) {
      return {
        bdata: v.bdata,
        dtype: v.dtype,
        shape: v.shape
      };
    }
    exports2.concat = function() {
      var args = [];
      var allArray = true;
      var totalLen = 0;
      var _constructor, arg0, i, argi, posi, leni, out, j;
      for (i = 0; i < arguments.length; i++) {
        argi = arguments[i];
        leni = argi.length;
        if (leni) {
          if (arg0) args.push(argi);
          else {
            arg0 = argi;
            posi = leni;
          }
          if (isArray(argi)) {
            _constructor = false;
          } else {
            allArray = false;
            if (!totalLen) {
              _constructor = argi.constructor;
            } else if (_constructor !== argi.constructor) {
              _constructor = false;
            }
          }
          totalLen += leni;
        }
      }
      if (!totalLen) return [];
      if (!args.length) return arg0;
      if (allArray) return arg0.concat.apply(arg0, args);
      if (_constructor) {
        out = new _constructor(totalLen);
        out.set(arg0);
        for (i = 0; i < args.length; i++) {
          argi = args[i];
          out.set(argi, posi);
          posi += argi.length;
        }
        return out;
      }
      out = new Array(totalLen);
      for (j = 0; j < arg0.length; j++) out[j] = arg0[j];
      for (i = 0; i < args.length; i++) {
        argi = args[i];
        for (j = 0; j < argi.length; j++) out[posi + j] = argi[j];
        posi += j;
      }
      return out;
    };
    exports2.maxRowLength = function(z2) {
      return _rowLength(z2, Math.max, 0);
    };
    exports2.minRowLength = function(z2) {
      return _rowLength(z2, Math.min, Infinity);
    };
    function _rowLength(z2, fn, len0) {
      if (isArrayOrTypedArray(z2)) {
        if (isArrayOrTypedArray(z2[0])) {
          var len = len0;
          for (var i = 0; i < z2.length; i++) {
            len = fn(len, z2[i].length);
          }
          return len;
        } else {
          return z2.length;
        }
      }
      return 0;
    }
  }
});

// node_modules/plotly.js/src/lib/nested_property.js
var require_nested_property = __commonJS({
  "node_modules/plotly.js/src/lib/nested_property.js"(exports2, module2) {
    "use strict";
    var isNumeric = require_fast_isnumeric();
    var isArrayOrTypedArray = require_array().isArrayOrTypedArray;
    module2.exports = function nestedProperty(container, propStr) {
      if (isNumeric(propStr)) propStr = String(propStr);
      else if (typeof propStr !== "string" || propStr.substr(propStr.length - 4) === "[-1]") {
        throw "bad property string";
      }
      var propParts = propStr.split(".");
      var indexed;
      var indices;
      var i, j;
      for (j = 0; j < propParts.length; j++) {
        if (String(propParts[j]).slice(0, 2) === "__") {
          throw "bad property string";
        }
      }
      j = 0;
      while (j < propParts.length) {
        indexed = String(propParts[j]).match(/^([^\[\]]*)((\[\-?[0-9]*\])+)$/);
        if (indexed) {
          if (indexed[1]) propParts[j] = indexed[1];
          else if (j === 0) propParts.splice(0, 1);
          else throw "bad property string";
          indices = indexed[2].substr(1, indexed[2].length - 2).split("][");
          for (i = 0; i < indices.length; i++) {
            j++;
            propParts.splice(j, 0, Number(indices[i]));
          }
        }
        j++;
      }
      if (typeof container !== "object") {
        return badContainer(container, propStr, propParts);
      }
      return {
        set: npSet(container, propParts, propStr),
        get: npGet(container, propParts),
        astr: propStr,
        parts: propParts,
        obj: container
      };
    };
    function npGet(cont, parts) {
      return function() {
        var curCont = cont;
        var curPart;
        var allSame;
        var out;
        var i;
        var j;
        for (i = 0; i < parts.length - 1; i++) {
          curPart = parts[i];
          if (curPart === -1) {
            allSame = true;
            out = [];
            for (j = 0; j < curCont.length; j++) {
              out[j] = npGet(curCont[j], parts.slice(i + 1))();
              if (out[j] !== out[0]) allSame = false;
            }
            return allSame ? out[0] : out;
          }
          if (typeof curPart === "number" && !isArrayOrTypedArray(curCont)) {
            return void 0;
          }
          curCont = curCont[curPart];
          if (typeof curCont !== "object" || curCont === null) {
            return void 0;
          }
        }
        if (typeof curCont !== "object" || curCont === null) return void 0;
        out = curCont[parts[i]];
        if (out === null) return void 0;
        return out;
      };
    }
    var ARGS_PATTERN = /(^|\.)args\[/;
    function isDeletable(val, propStr) {
      return val === void 0 || val === null && !propStr.match(ARGS_PATTERN);
    }
    function npSet(cont, parts, propStr) {
      return function(val) {
        var curCont = cont;
        var propPart = "";
        var containerLevels = [[cont, propPart]];
        var toDelete = isDeletable(val, propStr);
        var curPart;
        var i;
        for (i = 0; i < parts.length - 1; i++) {
          curPart = parts[i];
          if (typeof curPart === "number" && !isArrayOrTypedArray(curCont)) {
            throw "array index but container is not an array";
          }
          if (curPart === -1) {
            toDelete = !setArrayAll(curCont, parts.slice(i + 1), val, propStr);
            if (toDelete) break;
            else return;
          }
          if (!checkNewContainer(curCont, curPart, parts[i + 1], toDelete)) {
            break;
          }
          curCont = curCont[curPart];
          if (typeof curCont !== "object" || curCont === null) {
            throw "container is not an object";
          }
          propPart = joinPropStr(propPart, curPart);
          containerLevels.push([curCont, propPart]);
        }
        if (toDelete) {
          if (i === parts.length - 1) {
            delete curCont[parts[i]];
            if (Array.isArray(curCont) && +parts[i] === curCont.length - 1) {
              while (curCont.length && curCont[curCont.length - 1] === void 0) {
                curCont.pop();
              }
            }
          }
        } else curCont[parts[i]] = val;
      };
    }
    function joinPropStr(propStr, newPart) {
      var toAdd = newPart;
      if (isNumeric(newPart)) toAdd = "[" + newPart + "]";
      else if (propStr) toAdd = "." + newPart;
      return propStr + toAdd;
    }
    function setArrayAll(containerArray, innerParts, val, propStr) {
      var arrayVal = isArrayOrTypedArray(val);
      var allSet = true;
      var thisVal = val;
      var thisPropStr = propStr.replace("-1", 0);
      var deleteThis = arrayVal ? false : isDeletable(val, thisPropStr);
      var firstPart = innerParts[0];
      var i;
      for (i = 0; i < containerArray.length; i++) {
        thisPropStr = propStr.replace("-1", i);
        if (arrayVal) {
          thisVal = val[i % val.length];
          deleteThis = isDeletable(thisVal, thisPropStr);
        }
        if (deleteThis) allSet = false;
        if (!checkNewContainer(containerArray, i, firstPart, deleteThis)) {
          continue;
        }
        npSet(containerArray[i], innerParts, propStr.replace("-1", i))(thisVal);
      }
      return allSet;
    }
    function checkNewContainer(container, part, nextPart, toDelete) {
      if (container[part] === void 0) {
        if (toDelete) return false;
        if (typeof nextPart === "number") container[part] = [];
        else container[part] = {};
      }
      return true;
    }
    function badContainer(container, propStr, propParts) {
      return {
        set: function() {
          throw "bad container";
        },
        get: function() {
        },
        astr: propStr,
        parts: propParts,
        obj: container
      };
    }
  }
});

// node_modules/plotly.js/src/lib/keyed_container.js
var require_keyed_container = __commonJS({
  "node_modules/plotly.js/src/lib/keyed_container.js"(exports2, module2) {
    "use strict";
    var nestedProperty = require_nested_property();
    var SIMPLE_PROPERTY_REGEX = /^\w*$/;
    var NONE = 0;
    var NAME = 1;
    var VALUE = 2;
    var BOTH = 3;
    var UNSET = 4;
    module2.exports = function keyedContainer(baseObj, path, keyName, valueName) {
      keyName = keyName || "name";
      valueName = valueName || "value";
      var i, arr, baseProp;
      var changeTypes = {};
      if (path && path.length) {
        baseProp = nestedProperty(baseObj, path);
        arr = baseProp.get();
      } else {
        arr = baseObj;
      }
      path = path || "";
      var indexLookup = {};
      if (arr) {
        for (i = 0; i < arr.length; i++) {
          indexLookup[arr[i][keyName]] = i;
        }
      }
      var isSimpleValueProp = SIMPLE_PROPERTY_REGEX.test(valueName);
      var obj = {
        set: function(name, value) {
          var changeType = value === null ? UNSET : NONE;
          if (!arr) {
            if (!baseProp || changeType === UNSET) return;
            arr = [];
            baseProp.set(arr);
          }
          var idx = indexLookup[name];
          if (idx === void 0) {
            if (changeType === UNSET) return;
            changeType = changeType | BOTH;
            idx = arr.length;
            indexLookup[name] = idx;
          } else if (value !== (isSimpleValueProp ? arr[idx][valueName] : nestedProperty(arr[idx], valueName).get())) {
            changeType = changeType | VALUE;
          }
          var newValue = arr[idx] = arr[idx] || {};
          newValue[keyName] = name;
          if (isSimpleValueProp) {
            newValue[valueName] = value;
          } else {
            nestedProperty(newValue, valueName).set(value);
          }
          if (value !== null) {
            changeType = changeType & ~UNSET;
          }
          changeTypes[idx] = changeTypes[idx] | changeType;
          return obj;
        },
        get: function(name) {
          if (!arr) return;
          var idx = indexLookup[name];
          if (idx === void 0) {
            return void 0;
          } else if (isSimpleValueProp) {
            return arr[idx][valueName];
          } else {
            return nestedProperty(arr[idx], valueName).get();
          }
        },
        rename: function(name, newName) {
          var idx = indexLookup[name];
          if (idx === void 0) return obj;
          changeTypes[idx] = changeTypes[idx] | NAME;
          indexLookup[newName] = idx;
          delete indexLookup[name];
          arr[idx][keyName] = newName;
          return obj;
        },
        remove: function(name) {
          var idx = indexLookup[name];
          if (idx === void 0) return obj;
          var object = arr[idx];
          if (Object.keys(object).length > 2) {
            changeTypes[idx] = changeTypes[idx] | VALUE;
            return obj.set(name, null);
          }
          if (isSimpleValueProp) {
            for (i = idx; i < arr.length; i++) {
              changeTypes[i] = changeTypes[i] | BOTH;
            }
            for (i = idx; i < arr.length; i++) {
              indexLookup[arr[i][keyName]]--;
            }
            arr.splice(idx, 1);
            delete indexLookup[name];
          } else {
            nestedProperty(object, valueName).set(null);
            changeTypes[idx] = changeTypes[idx] | VALUE | UNSET;
          }
          return obj;
        },
        constructUpdate: function() {
          var astr, idx;
          var update = {};
          var changed = Object.keys(changeTypes);
          for (var i2 = 0; i2 < changed.length; i2++) {
            idx = changed[i2];
            astr = path + "[" + idx + "]";
            if (arr[idx]) {
              if (changeTypes[idx] & NAME) {
                update[astr + "." + keyName] = arr[idx][keyName];
              }
              if (changeTypes[idx] & VALUE) {
                if (isSimpleValueProp) {
                  update[astr + "." + valueName] = changeTypes[idx] & UNSET ? null : arr[idx][valueName];
                } else {
                  update[astr + "." + valueName] = changeTypes[idx] & UNSET ? null : nestedProperty(arr[idx], valueName).get();
                }
              }
            } else {
              update[astr] = null;
            }
          }
          return update;
        }
      };
      return obj;
    };
  }
});

// node_modules/plotly.js/src/lib/relative_attr.js
var require_relative_attr = __commonJS({
  "node_modules/plotly.js/src/lib/relative_attr.js"(exports2, module2) {
    "use strict";
    var ASCEND = /^(.*)(\.[^\.\[\]]+|\[\d\])$/;
    var SIMPLEATTR = /^[^\.\[\]]+$/;
    module2.exports = function(baseAttr, relativeAttr) {
      while (relativeAttr) {
        var match = baseAttr.match(ASCEND);
        if (match) baseAttr = match[1];
        else if (baseAttr.match(SIMPLEATTR)) baseAttr = "";
        else throw new Error("bad relativeAttr call:" + [baseAttr, relativeAttr]);
        if (relativeAttr.charAt(0) === "^") relativeAttr = relativeAttr.slice(1);
        else break;
      }
      if (baseAttr && relativeAttr.charAt(0) !== "[") {
        return baseAttr + "." + relativeAttr;
      }
      return baseAttr + relativeAttr;
    };
  }
});

// node_modules/plotly.js/src/lib/to_log_range.js
var require_to_log_range = __commonJS({
  "node_modules/plotly.js/src/lib/to_log_range.js"(exports2, module2) {
    "use strict";
    var isNumeric = require_fast_isnumeric();
    module2.exports = function toLogRange(val, range) {
      if (val > 0) return Math.log(val) / Math.LN10;
      var newVal = Math.log(Math.min(range[0], range[1])) / Math.LN10;
      if (!isNumeric(newVal)) newVal = Math.log(Math.max(range[0], range[1])) / Math.LN10 - 6;
      return newVal;
    };
  }
});

// node_modules/plotly.js/src/lib/relink_private.js
var require_relink_private = __commonJS({
  "node_modules/plotly.js/src/lib/relink_private.js"(exports2, module2) {
    "use strict";
    var isArrayOrTypedArray = require_array().isArrayOrTypedArray;
    var isPlainObject = require_is_plain_object();
    module2.exports = function relinkPrivateKeys(toContainer, fromContainer) {
      for (var k in fromContainer) {
        var fromVal = fromContainer[k];
        var toVal = toContainer[k];
        if (toVal === fromVal) continue;
        if (k.charAt(0) === "_" || typeof fromVal === "function") {
          if (k in toContainer) continue;
          toContainer[k] = fromVal;
        } else if (isArrayOrTypedArray(fromVal) && isArrayOrTypedArray(toVal) && isPlainObject(fromVal[0])) {
          if (k === "customdata" || k === "ids") continue;
          var minLen = Math.min(fromVal.length, toVal.length);
          for (var j = 0; j < minLen; j++) {
            if (toVal[j] !== fromVal[j] && isPlainObject(fromVal[j]) && isPlainObject(toVal[j])) {
              relinkPrivateKeys(toVal[j], fromVal[j]);
            }
          }
        } else if (isPlainObject(fromVal) && isPlainObject(toVal)) {
          relinkPrivateKeys(toVal, fromVal);
          if (!Object.keys(toVal).length) delete toContainer[k];
        }
      }
    };
  }
});

// node_modules/plotly.js/src/lib/mod.js
var require_mod = __commonJS({
  "node_modules/plotly.js/src/lib/mod.js"(exports2, module2) {
    "use strict";
    function mod(v, d) {
      var out = v % d;
      return out < 0 ? out + d : out;
    }
    function modHalf(v, d) {
      return Math.abs(v) > d / 2 ? v - Math.round(v / d) * d : v;
    }
    module2.exports = {
      mod,
      modHalf
    };
  }
});

// node_modules/tinycolor2/cjs/tinycolor.js
var require_tinycolor = __commonJS({
  "node_modules/tinycolor2/cjs/tinycolor.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? module2.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, global2.tinycolor = factory());
    })(exports2, function() {
      "use strict";
      function _typeof(obj) {
        "@babel/helpers - typeof";
        return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
          return typeof obj2;
        } : function(obj2) {
          return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
        }, _typeof(obj);
      }
      var trimLeft = /^\s+/;
      var trimRight = /\s+$/;
      function tinycolor(color, opts) {
        color = color ? color : "";
        opts = opts || {};
        if (color instanceof tinycolor) {
          return color;
        }
        if (!(this instanceof tinycolor)) {
          return new tinycolor(color, opts);
        }
        var rgb = inputToRGB(color);
        this._originalInput = color, this._r = rgb.r, this._g = rgb.g, this._b = rgb.b, this._a = rgb.a, this._roundA = Math.round(100 * this._a) / 100, this._format = opts.format || rgb.format;
        this._gradientType = opts.gradientType;
        if (this._r < 1) this._r = Math.round(this._r);
        if (this._g < 1) this._g = Math.round(this._g);
        if (this._b < 1) this._b = Math.round(this._b);
        this._ok = rgb.ok;
      }
      tinycolor.prototype = {
        isDark: function isDark() {
          return this.getBrightness() < 128;
        },
        isLight: function isLight() {
          return !this.isDark();
        },
        isValid: function isValid() {
          return this._ok;
        },
        getOriginalInput: function getOriginalInput() {
          return this._originalInput;
        },
        getFormat: function getFormat() {
          return this._format;
        },
        getAlpha: function getAlpha() {
          return this._a;
        },
        getBrightness: function getBrightness() {
          var rgb = this.toRgb();
          return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1e3;
        },
        getLuminance: function getLuminance() {
          var rgb = this.toRgb();
          var RsRGB, GsRGB, BsRGB, R, G, B;
          RsRGB = rgb.r / 255;
          GsRGB = rgb.g / 255;
          BsRGB = rgb.b / 255;
          if (RsRGB <= 0.03928) R = RsRGB / 12.92;
          else R = Math.pow((RsRGB + 0.055) / 1.055, 2.4);
          if (GsRGB <= 0.03928) G = GsRGB / 12.92;
          else G = Math.pow((GsRGB + 0.055) / 1.055, 2.4);
          if (BsRGB <= 0.03928) B = BsRGB / 12.92;
          else B = Math.pow((BsRGB + 0.055) / 1.055, 2.4);
          return 0.2126 * R + 0.7152 * G + 0.0722 * B;
        },
        setAlpha: function setAlpha(value) {
          this._a = boundAlpha(value);
          this._roundA = Math.round(100 * this._a) / 100;
          return this;
        },
        toHsv: function toHsv() {
          var hsv = rgbToHsv(this._r, this._g, this._b);
          return {
            h: hsv.h * 360,
            s: hsv.s,
            v: hsv.v,
            a: this._a
          };
        },
        toHsvString: function toHsvString() {
          var hsv = rgbToHsv(this._r, this._g, this._b);
          var h = Math.round(hsv.h * 360), s = Math.round(hsv.s * 100), v = Math.round(hsv.v * 100);
          return this._a == 1 ? "hsv(" + h + ", " + s + "%, " + v + "%)" : "hsva(" + h + ", " + s + "%, " + v + "%, " + this._roundA + ")";
        },
        toHsl: function toHsl() {
          var hsl = rgbToHsl(this._r, this._g, this._b);
          return {
            h: hsl.h * 360,
            s: hsl.s,
            l: hsl.l,
            a: this._a
          };
        },
        toHslString: function toHslString() {
          var hsl = rgbToHsl(this._r, this._g, this._b);
          var h = Math.round(hsl.h * 360), s = Math.round(hsl.s * 100), l = Math.round(hsl.l * 100);
          return this._a == 1 ? "hsl(" + h + ", " + s + "%, " + l + "%)" : "hsla(" + h + ", " + s + "%, " + l + "%, " + this._roundA + ")";
        },
        toHex: function toHex(allow3Char) {
          return rgbToHex(this._r, this._g, this._b, allow3Char);
        },
        toHexString: function toHexString(allow3Char) {
          return "#" + this.toHex(allow3Char);
        },
        toHex8: function toHex8(allow4Char) {
          return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);
        },
        toHex8String: function toHex8String(allow4Char) {
          return "#" + this.toHex8(allow4Char);
        },
        toRgb: function toRgb() {
          return {
            r: Math.round(this._r),
            g: Math.round(this._g),
            b: Math.round(this._b),
            a: this._a
          };
        },
        toRgbString: function toRgbString() {
          return this._a == 1 ? "rgb(" + Math.round(this._r) + ", " + Math.round(this._g) + ", " + Math.round(this._b) + ")" : "rgba(" + Math.round(this._r) + ", " + Math.round(this._g) + ", " + Math.round(this._b) + ", " + this._roundA + ")";
        },
        toPercentageRgb: function toPercentageRgb() {
          return {
            r: Math.round(bound01(this._r, 255) * 100) + "%",
            g: Math.round(bound01(this._g, 255) * 100) + "%",
            b: Math.round(bound01(this._b, 255) * 100) + "%",
            a: this._a
          };
        },
        toPercentageRgbString: function toPercentageRgbString() {
          return this._a == 1 ? "rgb(" + Math.round(bound01(this._r, 255) * 100) + "%, " + Math.round(bound01(this._g, 255) * 100) + "%, " + Math.round(bound01(this._b, 255) * 100) + "%)" : "rgba(" + Math.round(bound01(this._r, 255) * 100) + "%, " + Math.round(bound01(this._g, 255) * 100) + "%, " + Math.round(bound01(this._b, 255) * 100) + "%, " + this._roundA + ")";
        },
        toName: function toName() {
          if (this._a === 0) {
            return "transparent";
          }
          if (this._a < 1) {
            return false;
          }
          return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;
        },
        toFilter: function toFilter(secondColor) {
          var hex8String = "#" + rgbaToArgbHex(this._r, this._g, this._b, this._a);
          var secondHex8String = hex8String;
          var gradientType = this._gradientType ? "GradientType = 1, " : "";
          if (secondColor) {
            var s = tinycolor(secondColor);
            secondHex8String = "#" + rgbaToArgbHex(s._r, s._g, s._b, s._a);
          }
          return "progid:DXImageTransform.Microsoft.gradient(" + gradientType + "startColorstr=" + hex8String + ",endColorstr=" + secondHex8String + ")";
        },
        toString: function toString(format2) {
          var formatSet = !!format2;
          format2 = format2 || this._format;
          var formattedString = false;
          var hasAlpha = this._a < 1 && this._a >= 0;
          var needsAlphaFormat = !formatSet && hasAlpha && (format2 === "hex" || format2 === "hex6" || format2 === "hex3" || format2 === "hex4" || format2 === "hex8" || format2 === "name");
          if (needsAlphaFormat) {
            if (format2 === "name" && this._a === 0) {
              return this.toName();
            }
            return this.toRgbString();
          }
          if (format2 === "rgb") {
            formattedString = this.toRgbString();
          }
          if (format2 === "prgb") {
            formattedString = this.toPercentageRgbString();
          }
          if (format2 === "hex" || format2 === "hex6") {
            formattedString = this.toHexString();
          }
          if (format2 === "hex3") {
            formattedString = this.toHexString(true);
          }
          if (format2 === "hex4") {
            formattedString = this.toHex8String(true);
          }
          if (format2 === "hex8") {
            formattedString = this.toHex8String();
          }
          if (format2 === "name") {
            formattedString = this.toName();
          }
          if (format2 === "hsl") {
            formattedString = this.toHslString();
          }
          if (format2 === "hsv") {
            formattedString = this.toHsvString();
          }
          return formattedString || this.toHexString();
        },
        clone: function clone() {
          return tinycolor(this.toString());
        },
        _applyModification: function _applyModification(fn, args) {
          var color = fn.apply(null, [this].concat([].slice.call(args)));
          this._r = color._r;
          this._g = color._g;
          this._b = color._b;
          this.setAlpha(color._a);
          return this;
        },
        lighten: function lighten() {
          return this._applyModification(_lighten, arguments);
        },
        brighten: function brighten() {
          return this._applyModification(_brighten, arguments);
        },
        darken: function darken() {
          return this._applyModification(_darken, arguments);
        },
        desaturate: function desaturate() {
          return this._applyModification(_desaturate, arguments);
        },
        saturate: function saturate() {
          return this._applyModification(_saturate, arguments);
        },
        greyscale: function greyscale() {
          return this._applyModification(_greyscale, arguments);
        },
        spin: function spin() {
          return this._applyModification(_spin, arguments);
        },
        _applyCombination: function _applyCombination(fn, args) {
          return fn.apply(null, [this].concat([].slice.call(args)));
        },
        analogous: function analogous() {
          return this._applyCombination(_analogous, arguments);
        },
        complement: function complement() {
          return this._applyCombination(_complement, arguments);
        },
        monochromatic: function monochromatic() {
          return this._applyCombination(_monochromatic, arguments);
        },
        splitcomplement: function splitcomplement() {
          return this._applyCombination(_splitcomplement, arguments);
        },
        // Disabled until https://github.com/bgrins/TinyColor/issues/254
        // polyad: function (number) {
        //   return this._applyCombination(polyad, [number]);
        // },
        triad: function triad() {
          return this._applyCombination(polyad, [3]);
        },
        tetrad: function tetrad() {
          return this._applyCombination(polyad, [4]);
        }
      };
      tinycolor.fromRatio = function(color, opts) {
        if (_typeof(color) == "object") {
          var newColor = {};
          for (var i in color) {
            if (color.hasOwnProperty(i)) {
              if (i === "a") {
                newColor[i] = color[i];
              } else {
                newColor[i] = convertToPercentage(color[i]);
              }
            }
          }
          color = newColor;
        }
        return tinycolor(color, opts);
      };
      function inputToRGB(color) {
        var rgb = {
          r: 0,
          g: 0,
          b: 0
        };
        var a = 1;
        var s = null;
        var v = null;
        var l = null;
        var ok = false;
        var format2 = false;
        if (typeof color == "string") {
          color = stringInputToObject(color);
        }
        if (_typeof(color) == "object") {
          if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {
            rgb = rgbToRgb(color.r, color.g, color.b);
            ok = true;
            format2 = String(color.r).substr(-1) === "%" ? "prgb" : "rgb";
          } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {
            s = convertToPercentage(color.s);
            v = convertToPercentage(color.v);
            rgb = hsvToRgb(color.h, s, v);
            ok = true;
            format2 = "hsv";
          } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {
            s = convertToPercentage(color.s);
            l = convertToPercentage(color.l);
            rgb = hslToRgb(color.h, s, l);
            ok = true;
            format2 = "hsl";
          }
          if (color.hasOwnProperty("a")) {
            a = color.a;
          }
        }
        a = boundAlpha(a);
        return {
          ok,
          format: color.format || format2,
          r: Math.min(255, Math.max(rgb.r, 0)),
          g: Math.min(255, Math.max(rgb.g, 0)),
          b: Math.min(255, Math.max(rgb.b, 0)),
          a
        };
      }
      function rgbToRgb(r, g, b) {
        return {
          r: bound01(r, 255) * 255,
          g: bound01(g, 255) * 255,
          b: bound01(b, 255) * 255
        };
      }
      function rgbToHsl(r, g, b) {
        r = bound01(r, 255);
        g = bound01(g, 255);
        b = bound01(b, 255);
        var max = Math.max(r, g, b), min = Math.min(r, g, b);
        var h, s, l = (max + min) / 2;
        if (max == min) {
          h = s = 0;
        } else {
          var d = max - min;
          s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
          switch (max) {
            case r:
              h = (g - b) / d + (g < b ? 6 : 0);
              break;
            case g:
              h = (b - r) / d + 2;
              break;
            case b:
              h = (r - g) / d + 4;
              break;
          }
          h /= 6;
        }
        return {
          h,
          s,
          l
        };
      }
      function hslToRgb(h, s, l) {
        var r, g, b;
        h = bound01(h, 360);
        s = bound01(s, 100);
        l = bound01(l, 100);
        function hue2rgb(p2, q2, t) {
          if (t < 0) t += 1;
          if (t > 1) t -= 1;
          if (t < 1 / 6) return p2 + (q2 - p2) * 6 * t;
          if (t < 1 / 2) return q2;
          if (t < 2 / 3) return p2 + (q2 - p2) * (2 / 3 - t) * 6;
          return p2;
        }
        if (s === 0) {
          r = g = b = l;
        } else {
          var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
          var p = 2 * l - q;
          r = hue2rgb(p, q, h + 1 / 3);
          g = hue2rgb(p, q, h);
          b = hue2rgb(p, q, h - 1 / 3);
        }
        return {
          r: r * 255,
          g: g * 255,
          b: b * 255
        };
      }
      function rgbToHsv(r, g, b) {
        r = bound01(r, 255);
        g = bound01(g, 255);
        b = bound01(b, 255);
        var max = Math.max(r, g, b), min = Math.min(r, g, b);
        var h, s, v = max;
        var d = max - min;
        s = max === 0 ? 0 : d / max;
        if (max == min) {
          h = 0;
        } else {
          switch (max) {
            case r:
              h = (g - b) / d + (g < b ? 6 : 0);
              break;
            case g:
              h = (b - r) / d + 2;
              break;
            case b:
              h = (r - g) / d + 4;
              break;
          }
          h /= 6;
        }
        return {
          h,
          s,
          v
        };
      }
      function hsvToRgb(h, s, v) {
        h = bound01(h, 360) * 6;
        s = bound01(s, 100);
        v = bound01(v, 100);
        var i = Math.floor(h), f = h - i, p = v * (1 - s), q = v * (1 - f * s), t = v * (1 - (1 - f) * s), mod = i % 6, r = [v, q, p, p, t, v][mod], g = [t, v, v, q, p, p][mod], b = [p, p, t, v, v, q][mod];
        return {
          r: r * 255,
          g: g * 255,
          b: b * 255
        };
      }
      function rgbToHex(r, g, b, allow3Char) {
        var hex = [pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16))];
        if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {
          return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);
        }
        return hex.join("");
      }
      function rgbaToHex(r, g, b, a, allow4Char) {
        var hex = [pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16)), pad2(convertDecimalToHex(a))];
        if (allow4Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1) && hex[3].charAt(0) == hex[3].charAt(1)) {
          return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);
        }
        return hex.join("");
      }
      function rgbaToArgbHex(r, g, b, a) {
        var hex = [pad2(convertDecimalToHex(a)), pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16))];
        return hex.join("");
      }
      tinycolor.equals = function(color1, color2) {
        if (!color1 || !color2) return false;
        return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();
      };
      tinycolor.random = function() {
        return tinycolor.fromRatio({
          r: Math.random(),
          g: Math.random(),
          b: Math.random()
        });
      };
      function _desaturate(color, amount) {
        amount = amount === 0 ? 0 : amount || 10;
        var hsl = tinycolor(color).toHsl();
        hsl.s -= amount / 100;
        hsl.s = clamp01(hsl.s);
        return tinycolor(hsl);
      }
      function _saturate(color, amount) {
        amount = amount === 0 ? 0 : amount || 10;
        var hsl = tinycolor(color).toHsl();
        hsl.s += amount / 100;
        hsl.s = clamp01(hsl.s);
        return tinycolor(hsl);
      }
      function _greyscale(color) {
        return tinycolor(color).desaturate(100);
      }
      function _lighten(color, amount) {
        amount = amount === 0 ? 0 : amount || 10;
        var hsl = tinycolor(color).toHsl();
        hsl.l += amount / 100;
        hsl.l = clamp01(hsl.l);
        return tinycolor(hsl);
      }
      function _brighten(color, amount) {
        amount = amount === 0 ? 0 : amount || 10;
        var rgb = tinycolor(color).toRgb();
        rgb.r = Math.max(0, Math.min(255, rgb.r - Math.round(255 * -(amount / 100))));
        rgb.g = Math.max(0, Math.min(255, rgb.g - Math.round(255 * -(amount / 100))));
        rgb.b = Math.max(0, Math.min(255, rgb.b - Math.round(255 * -(amount / 100))));
        return tinycolor(rgb);
      }
      function _darken(color, amount) {
        amount = amount === 0 ? 0 : amount || 10;
        var hsl = tinycolor(color).toHsl();
        hsl.l -= amount / 100;
        hsl.l = clamp01(hsl.l);
        return tinycolor(hsl);
      }
      function _spin(color, amount) {
        var hsl = tinycolor(color).toHsl();
        var hue = (hsl.h + amount) % 360;
        hsl.h = hue < 0 ? 360 + hue : hue;
        return tinycolor(hsl);
      }
      function _complement(color) {
        var hsl = tinycolor(color).toHsl();
        hsl.h = (hsl.h + 180) % 360;
        return tinycolor(hsl);
      }
      function polyad(color, number) {
        if (isNaN(number) || number <= 0) {
          throw new Error("Argument to polyad must be a positive number");
        }
        var hsl = tinycolor(color).toHsl();
        var result = [tinycolor(color)];
        var step = 360 / number;
        for (var i = 1; i < number; i++) {
          result.push(tinycolor({
            h: (hsl.h + i * step) % 360,
            s: hsl.s,
            l: hsl.l
          }));
        }
        return result;
      }
      function _splitcomplement(color) {
        var hsl = tinycolor(color).toHsl();
        var h = hsl.h;
        return [tinycolor(color), tinycolor({
          h: (h + 72) % 360,
          s: hsl.s,
          l: hsl.l
        }), tinycolor({
          h: (h + 216) % 360,
          s: hsl.s,
          l: hsl.l
        })];
      }
      function _analogous(color, results, slices) {
        results = results || 6;
        slices = slices || 30;
        var hsl = tinycolor(color).toHsl();
        var part = 360 / slices;
        var ret = [tinycolor(color)];
        for (hsl.h = (hsl.h - (part * results >> 1) + 720) % 360; --results; ) {
          hsl.h = (hsl.h + part) % 360;
          ret.push(tinycolor(hsl));
        }
        return ret;
      }
      function _monochromatic(color, results) {
        results = results || 6;
        var hsv = tinycolor(color).toHsv();
        var h = hsv.h, s = hsv.s, v = hsv.v;
        var ret = [];
        var modification = 1 / results;
        while (results--) {
          ret.push(tinycolor({
            h,
            s,
            v
          }));
          v = (v + modification) % 1;
        }
        return ret;
      }
      tinycolor.mix = function(color1, color2, amount) {
        amount = amount === 0 ? 0 : amount || 50;
        var rgb1 = tinycolor(color1).toRgb();
        var rgb2 = tinycolor(color2).toRgb();
        var p = amount / 100;
        var rgba = {
          r: (rgb2.r - rgb1.r) * p + rgb1.r,
          g: (rgb2.g - rgb1.g) * p + rgb1.g,
          b: (rgb2.b - rgb1.b) * p + rgb1.b,
          a: (rgb2.a - rgb1.a) * p + rgb1.a
        };
        return tinycolor(rgba);
      };
      tinycolor.readability = function(color1, color2) {
        var c12 = tinycolor(color1);
        var c2 = tinycolor(color2);
        return (Math.max(c12.getLuminance(), c2.getLuminance()) + 0.05) / (Math.min(c12.getLuminance(), c2.getLuminance()) + 0.05);
      };
      tinycolor.isReadable = function(color1, color2, wcag2) {
        var readability = tinycolor.readability(color1, color2);
        var wcag2Parms, out;
        out = false;
        wcag2Parms = validateWCAG2Parms(wcag2);
        switch (wcag2Parms.level + wcag2Parms.size) {
          case "AAsmall":
          case "AAAlarge":
            out = readability >= 4.5;
            break;
          case "AAlarge":
            out = readability >= 3;
            break;
          case "AAAsmall":
            out = readability >= 7;
            break;
        }
        return out;
      };
      tinycolor.mostReadable = function(baseColor, colorList, args) {
        var bestColor = null;
        var bestScore = 0;
        var readability;
        var includeFallbackColors, level, size;
        args = args || {};
        includeFallbackColors = args.includeFallbackColors;
        level = args.level;
        size = args.size;
        for (var i = 0; i < colorList.length; i++) {
          readability = tinycolor.readability(baseColor, colorList[i]);
          if (readability > bestScore) {
            bestScore = readability;
            bestColor = tinycolor(colorList[i]);
          }
        }
        if (tinycolor.isReadable(baseColor, bestColor, {
          level,
          size
        }) || !includeFallbackColors) {
          return bestColor;
        } else {
          args.includeFallbackColors = false;
          return tinycolor.mostReadable(baseColor, ["#fff", "#000"], args);
        }
      };
      var names = tinycolor.names = {
        aliceblue: "f0f8ff",
        antiquewhite: "faebd7",
        aqua: "0ff",
        aquamarine: "7fffd4",
        azure: "f0ffff",
        beige: "f5f5dc",
        bisque: "ffe4c4",
        black: "000",
        blanchedalmond: "ffebcd",
        blue: "00f",
        blueviolet: "8a2be2",
        brown: "a52a2a",
        burlywood: "deb887",
        burntsienna: "ea7e5d",
        cadetblue: "5f9ea0",
        chartreuse: "7fff00",
        chocolate: "d2691e",
        coral: "ff7f50",
        cornflowerblue: "6495ed",
        cornsilk: "fff8dc",
        crimson: "dc143c",
        cyan: "0ff",
        darkblue: "00008b",
        darkcyan: "008b8b",
        darkgoldenrod: "b8860b",
        darkgray: "a9a9a9",
        darkgreen: "006400",
        darkgrey: "a9a9a9",
        darkkhaki: "bdb76b",
        darkmagenta: "8b008b",
        darkolivegreen: "556b2f",
        darkorange: "ff8c00",
        darkorchid: "9932cc",
        darkred: "8b0000",
        darksalmon: "e9967a",
        darkseagreen: "8fbc8f",
        darkslateblue: "483d8b",
        darkslategray: "2f4f4f",
        darkslategrey: "2f4f4f",
        darkturquoise: "00ced1",
        darkviolet: "9400d3",
        deeppink: "ff1493",
        deepskyblue: "00bfff",
        dimgray: "696969",
        dimgrey: "696969",
        dodgerblue: "1e90ff",
        firebrick: "b22222",
        floralwhite: "fffaf0",
        forestgreen: "228b22",
        fuchsia: "f0f",
        gainsboro: "dcdcdc",
        ghostwhite: "f8f8ff",
        gold: "ffd700",
        goldenrod: "daa520",
        gray: "808080",
        green: "008000",
        greenyellow: "adff2f",
        grey: "808080",
        honeydew: "f0fff0",
        hotpink: "ff69b4",
        indianred: "cd5c5c",
        indigo: "4b0082",
        ivory: "fffff0",
        khaki: "f0e68c",
        lavender: "e6e6fa",
        lavenderblush: "fff0f5",
        lawngreen: "7cfc00",
        lemonchiffon: "fffacd",
        lightblue: "add8e6",
        lightcoral: "f08080",
        lightcyan: "e0ffff",
        lightgoldenrodyellow: "fafad2",
        lightgray: "d3d3d3",
        lightgreen: "90ee90",
        lightgrey: "d3d3d3",
        lightpink: "ffb6c1",
        lightsalmon: "ffa07a",
        lightseagreen: "20b2aa",
        lightskyblue: "87cefa",
        lightslategray: "789",
        lightslategrey: "789",
        lightsteelblue: "b0c4de",
        lightyellow: "ffffe0",
        lime: "0f0",
        limegreen: "32cd32",
        linen: "faf0e6",
        magenta: "f0f",
        maroon: "800000",
        mediumaquamarine: "66cdaa",
        mediumblue: "0000cd",
        mediumorchid: "ba55d3",
        mediumpurple: "9370db",
        mediumseagreen: "3cb371",
        mediumslateblue: "7b68ee",
        mediumspringgreen: "00fa9a",
        mediumturquoise: "48d1cc",
        mediumvioletred: "c71585",
        midnightblue: "191970",
        mintcream: "f5fffa",
        mistyrose: "ffe4e1",
        moccasin: "ffe4b5",
        navajowhite: "ffdead",
        navy: "000080",
        oldlace: "fdf5e6",
        olive: "808000",
        olivedrab: "6b8e23",
        orange: "ffa500",
        orangered: "ff4500",
        orchid: "da70d6",
        palegoldenrod: "eee8aa",
        palegreen: "98fb98",
        paleturquoise: "afeeee",
        palevioletred: "db7093",
        papayawhip: "ffefd5",
        peachpuff: "ffdab9",
        peru: "cd853f",
        pink: "ffc0cb",
        plum: "dda0dd",
        powderblue: "b0e0e6",
        purple: "800080",
        rebeccapurple: "663399",
        red: "f00",
        rosybrown: "bc8f8f",
        royalblue: "4169e1",
        saddlebrown: "8b4513",
        salmon: "fa8072",
        sandybrown: "f4a460",
        seagreen: "2e8b57",
        seashell: "fff5ee",
        sienna: "a0522d",
        silver: "c0c0c0",
        skyblue: "87ceeb",
        slateblue: "6a5acd",
        slategray: "708090",
        slategrey: "708090",
        snow: "fffafa",
        springgreen: "00ff7f",
        steelblue: "4682b4",
        tan: "d2b48c",
        teal: "008080",
        thistle: "d8bfd8",
        tomato: "ff6347",
        turquoise: "40e0d0",
        violet: "ee82ee",
        wheat: "f5deb3",
        white: "fff",
        whitesmoke: "f5f5f5",
        yellow: "ff0",
        yellowgreen: "9acd32"
      };
      var hexNames = tinycolor.hexNames = flip(names);
      function flip(o) {
        var flipped = {};
        for (var i in o) {
          if (o.hasOwnProperty(i)) {
            flipped[o[i]] = i;
          }
        }
        return flipped;
      }
      function boundAlpha(a) {
        a = parseFloat(a);
        if (isNaN(a) || a < 0 || a > 1) {
          a = 1;
        }
        return a;
      }
      function bound01(n, max) {
        if (isOnePointZero(n)) n = "100%";
        var processPercent = isPercentage(n);
        n = Math.min(max, Math.max(0, parseFloat(n)));
        if (processPercent) {
          n = parseInt(n * max, 10) / 100;
        }
        if (Math.abs(n - max) < 1e-6) {
          return 1;
        }
        return n % max / parseFloat(max);
      }
      function clamp01(val) {
        return Math.min(1, Math.max(0, val));
      }
      function parseIntFromHex(val) {
        return parseInt(val, 16);
      }
      function isOnePointZero(n) {
        return typeof n == "string" && n.indexOf(".") != -1 && parseFloat(n) === 1;
      }
      function isPercentage(n) {
        return typeof n === "string" && n.indexOf("%") != -1;
      }
      function pad2(c) {
        return c.length == 1 ? "0" + c : "" + c;
      }
      function convertToPercentage(n) {
        if (n <= 1) {
          n = n * 100 + "%";
        }
        return n;
      }
      function convertDecimalToHex(d) {
        return Math.round(parseFloat(d) * 255).toString(16);
      }
      function convertHexToDecimal(h) {
        return parseIntFromHex(h) / 255;
      }
      var matchers = function() {
        var CSS_INTEGER = "[-\\+]?\\d+%?";
        var CSS_NUMBER = "[-\\+]?\\d*\\.\\d+%?";
        var CSS_UNIT = "(?:" + CSS_NUMBER + ")|(?:" + CSS_INTEGER + ")";
        var PERMISSIVE_MATCH3 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
        var PERMISSIVE_MATCH4 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
        return {
          CSS_UNIT: new RegExp(CSS_UNIT),
          rgb: new RegExp("rgb" + PERMISSIVE_MATCH3),
          rgba: new RegExp("rgba" + PERMISSIVE_MATCH4),
          hsl: new RegExp("hsl" + PERMISSIVE_MATCH3),
          hsla: new RegExp("hsla" + PERMISSIVE_MATCH4),
          hsv: new RegExp("hsv" + PERMISSIVE_MATCH3),
          hsva: new RegExp("hsva" + PERMISSIVE_MATCH4),
          hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
          hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
          hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
          hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/
        };
      }();
      function isValidCSSUnit(color) {
        return !!matchers.CSS_UNIT.exec(color);
      }
      function stringInputToObject(color) {
        color = color.replace(trimLeft, "").replace(trimRight, "").toLowerCase();
        var named = false;
        if (names[color]) {
          color = names[color];
          named = true;
        } else if (color == "transparent") {
          return {
            r: 0,
            g: 0,
            b: 0,
            a: 0,
            format: "name"
          };
        }
        var match;
        if (match = matchers.rgb.exec(color)) {
          return {
            r: match[1],
            g: match[2],
            b: match[3]
          };
        }
        if (match = matchers.rgba.exec(color)) {
          return {
            r: match[1],
            g: match[2],
            b: match[3],
            a: match[4]
          };
        }
        if (match = matchers.hsl.exec(color)) {
          return {
            h: match[1],
            s: match[2],
            l: match[3]
          };
        }
        if (match = matchers.hsla.exec(color)) {
          return {
            h: match[1],
            s: match[2],
            l: match[3],
            a: match[4]
          };
        }
        if (match = matchers.hsv.exec(color)) {
          return {
            h: match[1],
            s: match[2],
            v: match[3]
          };
        }
        if (match = matchers.hsva.exec(color)) {
          return {
            h: match[1],
            s: match[2],
            v: match[3],
            a: match[4]
          };
        }
        if (match = matchers.hex8.exec(color)) {
          return {
            r: parseIntFromHex(match[1]),
            g: parseIntFromHex(match[2]),
            b: parseIntFromHex(match[3]),
            a: convertHexToDecimal(match[4]),
            format: named ? "name" : "hex8"
          };
        }
        if (match = matchers.hex6.exec(color)) {
          return {
            r: parseIntFromHex(match[1]),
            g: parseIntFromHex(match[2]),
            b: parseIntFromHex(match[3]),
            format: named ? "name" : "hex"
          };
        }
        if (match = matchers.hex4.exec(color)) {
          return {
            r: parseIntFromHex(match[1] + "" + match[1]),
            g: parseIntFromHex(match[2] + "" + match[2]),
            b: parseIntFromHex(match[3] + "" + match[3]),
            a: convertHexToDecimal(match[4] + "" + match[4]),
            format: named ? "name" : "hex8"
          };
        }
        if (match = matchers.hex3.exec(color)) {
          return {
            r: parseIntFromHex(match[1] + "" + match[1]),
            g: parseIntFromHex(match[2] + "" + match[2]),
            b: parseIntFromHex(match[3] + "" + match[3]),
            format: named ? "name" : "hex"
          };
        }
        return false;
      }
      function validateWCAG2Parms(parms) {
        var level, size;
        parms = parms || {
          level: "AA",
          size: "small"
        };
        level = (parms.level || "AA").toUpperCase();
        size = (parms.size || "small").toLowerCase();
        if (level !== "AA" && level !== "AAA") {
          level = "AA";
        }
        if (size !== "small" && size !== "large") {
          size = "small";
        }
        return {
          level,
          size
        };
      }
      return tinycolor;
    });
  }
});

// node_modules/plotly.js/src/lib/extend.js
var require_extend = __commonJS({
  "node_modules/plotly.js/src/lib/extend.js"(exports2) {
    "use strict";
    var isPlainObject = require_is_plain_object();
    var isArray = Array.isArray;
    function primitivesLoopSplice(source, target) {
      var i, value;
      for (i = 0; i < source.length; i++) {
        value = source[i];
        if (value !== null && typeof value === "object") {
          return false;
        }
        if (value !== void 0) {
          target[i] = value;
        }
      }
      return true;
    }
    exports2.extendFlat = function() {
      return _extend(arguments, false, false, false);
    };
    exports2.extendDeep = function() {
      return _extend(arguments, true, false, false);
    };
    exports2.extendDeepAll = function() {
      return _extend(arguments, true, true, false);
    };
    exports2.extendDeepNoArrays = function() {
      return _extend(arguments, true, false, true);
    };
    function _extend(inputs, isDeep, keepAllKeys, noArrayCopies) {
      var target = inputs[0];
      var length = inputs.length;
      var input, key, src, copy, copyIsArray, clone, allPrimitives;
      if (length === 2 && isArray(target) && isArray(inputs[1]) && target.length === 0) {
        allPrimitives = primitivesLoopSplice(inputs[1], target);
        if (allPrimitives) {
          return target;
        } else {
          target.splice(0, target.length);
        }
      }
      for (var i = 1; i < length; i++) {
        input = inputs[i];
        for (key in input) {
          src = target[key];
          copy = input[key];
          if (noArrayCopies && isArray(copy)) {
            target[key] = copy;
          } else if (isDeep && copy && (isPlainObject(copy) || (copyIsArray = isArray(copy)))) {
            if (copyIsArray) {
              copyIsArray = false;
              clone = src && isArray(src) ? src : [];
            } else {
              clone = src && isPlainObject(src) ? src : {};
            }
            target[key] = _extend([clone, copy], isDeep, keepAllKeys, noArrayCopies);
          } else if (typeof copy !== "undefined" || keepAllKeys) {
            target[key] = copy;
          }
        }
      }
      return target;
    }
  }
});

// node_modules/plotly.js/src/plots/font_attributes.js
var require_font_attributes = __commonJS({
  "node_modules/plotly.js/src/plots/font_attributes.js"(exports2, module2) {
    "use strict";
    module2.exports = function(opts) {
      var variantValues = opts.variantValues;
      var editType = opts.editType;
      var colorEditType = opts.colorEditType;
      if (colorEditType === void 0) colorEditType = editType;
      var weight = {
        editType,
        valType: "integer",
        min: 1,
        max: 1e3,
        extras: ["normal", "bold"],
        dflt: "normal",
        description: [
          "Sets the weight (or boldness) of the font."
        ].join(" ")
      };
      if (opts.noNumericWeightValues) {
        weight.valType = "enumerated";
        weight.values = weight.extras;
        weight.extras = void 0;
        weight.min = void 0;
        weight.max = void 0;
      }
      var attrs = {
        family: {
          valType: "string",
          noBlank: true,
          strict: true,
          editType,
          description: [
            "HTML font family - the typeface that will be applied by the web browser.",
            "The web browser will only be able to apply a font if it is available on the system",
            "which it operates. Provide multiple font families, separated by commas, to indicate",
            "the preference in which to apply fonts if they aren't available on the system.",
            "The Chart Studio Cloud (at https://chart-studio.plotly.com or on-premise) generates images on a server,",
            "where only a select number of",
            "fonts are installed and supported.",
            "These include *Arial*, *Balto*, *Courier New*, *Droid Sans*, *Droid Serif*,",
            "*Droid Sans Mono*, *Gravitas One*, *Old Standard TT*, *Open Sans*, *Overpass*,",
            "*PT Sans Narrow*, *Raleway*, *Times New Roman*."
          ].join(" ")
        },
        size: {
          valType: "number",
          min: 1,
          editType
        },
        color: {
          valType: "color",
          editType: colorEditType
        },
        weight,
        style: {
          editType,
          valType: "enumerated",
          values: ["normal", "italic"],
          dflt: "normal",
          description: [
            "Sets whether a font should be styled with a normal or italic face from its family."
          ].join(" ")
        },
        variant: opts.noFontVariant ? void 0 : {
          editType,
          valType: "enumerated",
          values: variantValues || [
            "normal",
            "small-caps",
            "all-small-caps",
            "all-petite-caps",
            "petite-caps",
            "unicase"
          ],
          dflt: "normal",
          description: [
            "Sets the variant of the font."
          ].join(" ")
        },
        textcase: opts.noFontTextcase ? void 0 : {
          editType,
          valType: "enumerated",
          values: ["normal", "word caps", "upper", "lower"],
          dflt: "normal",
          description: [
            "Sets capitalization of text.",
            "It can be used to make text appear in all-uppercase or all-lowercase,",
            "or with each word capitalized."
          ].join(" ")
        },
        lineposition: opts.noFontLineposition ? void 0 : {
          editType,
          valType: "flaglist",
          flags: ["under", "over", "through"],
          extras: ["none"],
          dflt: "none",
          description: [
            "Sets the kind of decoration line(s) with text,",
            "such as an *under*, *over* or *through*",
            "as well as combinations e.g. *under+over*, etc."
          ].join(" ")
        },
        shadow: opts.noFontShadow ? void 0 : {
          editType,
          valType: "string",
          dflt: opts.autoShadowDflt ? "auto" : "none",
          description: [
            "Sets the shape and color of the shadow behind text.",
            "*auto* places minimal shadow and applies contrast text font color.",
            "See https://developer.mozilla.org/en-US/docs/Web/CSS/text-shadow for additional options."
          ].join(" ")
        },
        editType,
        // blank strings so compress_attributes can remove
        // TODO - that's uber hacky... better solution?
        description: "" + (opts.description || "")
      };
      if (opts.autoSize) attrs.size.dflt = "auto";
      if (opts.autoColor) attrs.color.dflt = "auto";
      if (opts.arrayOk) {
        attrs.family.arrayOk = true;
        attrs.weight.arrayOk = true;
        attrs.style.arrayOk = true;
        if (!opts.noFontVariant) {
          attrs.variant.arrayOk = true;
        }
        if (!opts.noFontTextcase) {
          attrs.textcase.arrayOk = true;
        }
        if (!opts.noFontLineposition) {
          attrs.lineposition.arrayOk = true;
        }
        if (!opts.noFontShadow) {
          attrs.shadow.arrayOk = true;
        }
        attrs.size.arrayOk = true;
        attrs.color.arrayOk = true;
      }
      return attrs;
    };
  }
});

// node_modules/plotly.js/src/components/fx/constants.js
var require_constants = __commonJS({
  "node_modules/plotly.js/src/components/fx/constants.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      // hover labels for multiple horizontal bars get tilted by this angle
      YANGLE: 60,
      // size and display constants for hover text
      // pixel size of hover arrows
      HOVERARROWSIZE: 6,
      // pixels padding around text
      HOVERTEXTPAD: 3,
      // hover font
      HOVERFONTSIZE: 13,
      HOVERFONT: "Arial, sans-serif",
      // minimum time (msec) between hover calls
      HOVERMINTIME: 50,
      // ID suffix (with fullLayout._uid) for hover events in the throttle cache
      HOVERID: "-hover"
    };
  }
});

// node_modules/plotly.js/src/components/fx/layout_attributes.js
var require_layout_attributes = __commonJS({
  "node_modules/plotly.js/src/components/fx/layout_attributes.js"(exports2, module2) {
    "use strict";
    var constants = require_constants();
    var fontAttrs = require_font_attributes();
    var font = fontAttrs({
      editType: "none",
      description: "Sets the default hover label font used by all traces on the graph."
    });
    font.family.dflt = constants.HOVERFONT;
    font.size.dflt = constants.HOVERFONTSIZE;
    module2.exports = {
      clickmode: {
        valType: "flaglist",
        flags: ["event", "select"],
        dflt: "event",
        editType: "plot",
        extras: ["none"],
        description: [
          "Determines the mode of single click interactions.",
          "*event* is the default value and emits the `plotly_click`",
          "event. In addition this mode emits the `plotly_selected` event",
          "in drag modes *lasso* and *select*, but with no event data attached",
          "(kept for compatibility reasons).",
          "The *select* flag enables selecting single",
          "data points via click. This mode also supports persistent selections,",
          "meaning that pressing Shift while clicking, adds to / subtracts from an",
          "existing selection. *select* with `hovermode`: *x* can be confusing, consider",
          "explicitly setting `hovermode`: *closest* when using this feature.",
          "Selection events are sent accordingly as long as *event* flag is set as well.",
          "When the *event* flag is missing, `plotly_click` and `plotly_selected`",
          "events are not fired."
        ].join(" ")
      },
      dragmode: {
        valType: "enumerated",
        values: [
          "zoom",
          "pan",
          "select",
          "lasso",
          "drawclosedpath",
          "drawopenpath",
          "drawline",
          "drawrect",
          "drawcircle",
          "orbit",
          "turntable",
          false
        ],
        dflt: "zoom",
        editType: "modebar",
        description: [
          "Determines the mode of drag interactions.",
          "*select* and *lasso* apply only to scatter traces with",
          "markers or text. *orbit* and *turntable* apply only to",
          "3D scenes."
        ].join(" ")
      },
      hovermode: {
        valType: "enumerated",
        values: ["x", "y", "closest", false, "x unified", "y unified"],
        dflt: "closest",
        editType: "modebar",
        description: [
          "Determines the mode of hover interactions.",
          "If *closest*, a single hoverlabel will appear",
          "for the *closest* point within the `hoverdistance`.",
          "If *x* (or *y*), multiple hoverlabels will appear for multiple points",
          "at the *closest* x- (or y-) coordinate within the `hoverdistance`,",
          "with the caveat that no more than one hoverlabel will appear per trace.",
          "If *x unified* (or *y unified*), a single hoverlabel will appear",
          "multiple points at the closest x- (or y-) coordinate within the `hoverdistance`",
          "with the caveat that no more than one hoverlabel will appear per trace.",
          "In this mode, spikelines are enabled by default perpendicular to the specified axis.",
          "If false, hover interactions are disabled."
        ].join(" ")
      },
      hoversubplots: {
        valType: "enumerated",
        values: ["single", "overlaying", "axis"],
        dflt: "overlaying",
        editType: "none",
        description: [
          "Determines expansion of hover effects to other subplots",
          "If *single* just the axis pair of the primary point is included without overlaying subplots.",
          "If *overlaying* all subplots using the main axis and occupying the same space are included.",
          "If *axis*, also include stacked subplots using the same axis",
          "when `hovermode` is set to *x*, *x unified*, *y* or *y unified*."
        ].join(" ")
      },
      hoverdistance: {
        valType: "integer",
        min: -1,
        dflt: 20,
        editType: "none",
        description: [
          "Sets the default distance (in pixels) to look for data",
          "to add hover labels (-1 means no cutoff, 0 means no looking for data).",
          "This is only a real distance for hovering on point-like objects,",
          "like scatter points. For area-like objects (bars, scatter fills, etc)",
          "hovering is on inside the area and off outside, but these objects",
          "will not supersede hover on point-like objects in case of conflict."
        ].join(" ")
      },
      spikedistance: {
        valType: "integer",
        min: -1,
        dflt: -1,
        editType: "none",
        description: [
          "Sets the default distance (in pixels) to look for data to draw",
          "spikelines to (-1 means no cutoff, 0 means no looking for data).",
          "As with hoverdistance, distance does not apply to area-like objects.",
          "In addition, some objects can be hovered on but will not generate",
          "spikelines, such as scatter fills."
        ].join(" ")
      },
      hoverlabel: {
        bgcolor: {
          valType: "color",
          editType: "none",
          description: [
            "Sets the background color of all hover labels on graph"
          ].join(" ")
        },
        bordercolor: {
          valType: "color",
          editType: "none",
          description: [
            "Sets the border color of all hover labels on graph."
          ].join(" ")
        },
        font,
        grouptitlefont: fontAttrs({
          editType: "none",
          description: [
            "Sets the font for group titles in hover (unified modes).",
            "Defaults to `hoverlabel.font`."
          ].join(" ")
        }),
        align: {
          valType: "enumerated",
          values: ["left", "right", "auto"],
          dflt: "auto",
          editType: "none",
          description: [
            "Sets the horizontal alignment of the text content within hover label box.",
            "Has an effect only if the hover label text spans more two or more lines"
          ].join(" ")
        },
        namelength: {
          valType: "integer",
          min: -1,
          dflt: 15,
          editType: "none",
          description: [
            "Sets the default length (in number of characters) of the trace name in",
            "the hover labels for all traces. -1 shows the whole name",
            "regardless of length. 0-3 shows the first 0-3 characters, and",
            "an integer >3 will show the whole name if it is less than that",
            "many characters, but if it is longer, will truncate to",
            "`namelength - 3` characters and add an ellipsis."
          ].join(" ")
        },
        editType: "none"
      },
      selectdirection: {
        valType: "enumerated",
        values: ["h", "v", "d", "any"],
        dflt: "any",
        description: [
          "When `dragmode` is set to *select*, this limits the selection of the drag to",
          "horizontal, vertical or diagonal. *h* only allows horizontal selection,",
          "*v* only vertical, *d* only diagonal and *any* sets no limit."
        ].join(" "),
        editType: "none"
      }
    };
  }
});

// node_modules/plotly.js/src/components/fx/attributes.js
var require_attributes = __commonJS({
  "node_modules/plotly.js/src/components/fx/attributes.js"(exports2, module2) {
    "use strict";
    var fontAttrs = require_font_attributes();
    var hoverLabelAttrs = require_layout_attributes().hoverlabel;
    var extendFlat = require_extend().extendFlat;
    module2.exports = {
      hoverlabel: {
        bgcolor: extendFlat({}, hoverLabelAttrs.bgcolor, {
          arrayOk: true,
          description: "Sets the background color of the hover labels for this trace"
        }),
        bordercolor: extendFlat({}, hoverLabelAttrs.bordercolor, {
          arrayOk: true,
          description: "Sets the border color of the hover labels for this trace."
        }),
        font: fontAttrs({
          arrayOk: true,
          editType: "none",
          description: "Sets the font used in hover labels."
        }),
        align: extendFlat({}, hoverLabelAttrs.align, { arrayOk: true }),
        namelength: extendFlat({}, hoverLabelAttrs.namelength, { arrayOk: true }),
        editType: "none"
      }
    };
  }
});

// node_modules/plotly.js/src/plots/attributes.js
var require_attributes2 = __commonJS({
  "node_modules/plotly.js/src/plots/attributes.js"(exports2, module2) {
    "use strict";
    var fontAttrs = require_font_attributes();
    var fxAttrs = require_attributes();
    module2.exports = {
      type: {
        valType: "enumerated",
        values: [],
        // listed dynamically
        dflt: "scatter",
        editType: "calc+clearAxisTypes",
        _noTemplating: true
        // we handle this at a higher level
      },
      visible: {
        valType: "enumerated",
        values: [true, false, "legendonly"],
        dflt: true,
        editType: "calc",
        description: [
          "Determines whether or not this trace is visible.",
          "If *legendonly*, the trace is not drawn,",
          "but can appear as a legend item",
          "(provided that the legend itself is visible)."
        ].join(" ")
      },
      showlegend: {
        valType: "boolean",
        dflt: true,
        editType: "style",
        description: [
          "Determines whether or not an item corresponding to this",
          "trace is shown in the legend."
        ].join(" ")
      },
      legend: {
        valType: "subplotid",
        dflt: "legend",
        editType: "style",
        description: [
          "Sets the reference to a legend to show this trace in.",
          "References to these legends are *legend*, *legend2*, *legend3*, etc.",
          "Settings for these legends are set in the layout, under",
          "`layout.legend`, `layout.legend2`, etc."
        ].join(" ")
      },
      legendgroup: {
        valType: "string",
        dflt: "",
        editType: "style",
        description: [
          "Sets the legend group for this trace.",
          "Traces and shapes part of the same legend group hide/show at the same time",
          "when toggling legend items."
        ].join(" ")
      },
      legendgrouptitle: {
        text: {
          valType: "string",
          dflt: "",
          editType: "style",
          description: [
            "Sets the title of the legend group."
          ].join(" ")
        },
        font: fontAttrs({
          editType: "style",
          description: [
            "Sets this legend group's title font."
          ].join(" ")
        }),
        editType: "style"
      },
      legendrank: {
        valType: "number",
        dflt: 1e3,
        editType: "style",
        description: [
          "Sets the legend rank for this trace.",
          "Items and groups with smaller ranks are presented on top/left side while",
          "with *reversed* `legend.traceorder` they are on bottom/right side.",
          "The default legendrank is 1000,",
          "so that you can use ranks less than 1000 to place certain items before all unranked items,",
          "and ranks greater than 1000 to go after all unranked items.",
          "When having unranked or equal rank items shapes would be displayed after traces",
          "i.e. according to their order in data and layout."
        ].join(" ")
      },
      legendwidth: {
        valType: "number",
        min: 0,
        editType: "style",
        description: "Sets the width (in px or fraction) of the legend for this trace."
      },
      opacity: {
        valType: "number",
        min: 0,
        max: 1,
        dflt: 1,
        editType: "style",
        description: "Sets the opacity of the trace."
      },
      name: {
        valType: "string",
        editType: "style",
        description: [
          "Sets the trace name.",
          "The trace name appears as the legend item and on hover."
        ].join(" ")
      },
      uid: {
        valType: "string",
        editType: "plot",
        anim: true,
        description: [
          "Assign an id to this trace,",
          "Use this to provide object constancy between traces during animations",
          "and transitions."
        ].join(" ")
      },
      ids: {
        valType: "data_array",
        editType: "calc",
        anim: true,
        description: [
          "Assigns id labels to each datum.",
          "These ids for object constancy of data points during animation.",
          "Should be an array of strings, not numbers or any other type."
        ].join(" ")
      },
      customdata: {
        valType: "data_array",
        editType: "calc",
        description: [
          "Assigns extra data each datum.",
          "This may be useful when listening to hover, click and selection events.",
          "Note that, *scatter* traces also appends customdata items in the markers",
          "DOM elements"
        ].join(" ")
      },
      meta: {
        valType: "any",
        arrayOk: true,
        editType: "plot",
        description: [
          "Assigns extra meta information associated with this trace",
          "that can be used in various text attributes.",
          "Attributes such as trace `name`, graph, axis and colorbar `title.text`, annotation `text`",
          "`rangeselector`, `updatemenues` and `sliders` `label` text",
          "all support `meta`.",
          "To access the trace `meta` values in an attribute in the same trace, simply use",
          "`%{meta[i]}` where `i` is the index or key of the `meta`",
          "item in question.",
          "To access trace `meta` in layout attributes, use",
          "`%{data[n[.meta[i]}` where `i` is the index or key of the `meta`",
          "and `n` is the trace index."
        ].join(" ")
      },
      // N.B. these cannot be 'data_array' as they do not have the same length as
      // other data arrays and arrayOk attributes in general
      //
      // Maybe add another valType:
      // https://github.com/plotly/plotly.js/issues/1894
      selectedpoints: {
        valType: "any",
        editType: "calc",
        description: [
          "Array containing integer indices of selected points.",
          "Has an effect only for traces that support selections.",
          "Note that an empty array means an empty selection where the `unselected`",
          "are turned on for all points, whereas, any other non-array values means no",
          "selection all where the `selected` and `unselected` styles have no effect."
        ].join(" ")
      },
      hoverinfo: {
        valType: "flaglist",
        flags: ["x", "y", "z", "text", "name"],
        extras: ["all", "none", "skip"],
        arrayOk: true,
        dflt: "all",
        editType: "none",
        description: [
          "Determines which trace information appear on hover.",
          "If `none` or `skip` are set, no information is displayed upon hovering.",
          "But, if `none` is set, click and hover events are still fired."
        ].join(" ")
      },
      hoverlabel: fxAttrs.hoverlabel,
      stream: {
        token: {
          valType: "string",
          noBlank: true,
          strict: true,
          editType: "calc",
          description: [
            "The stream id number links a data trace on a plot with a stream.",
            "See https://chart-studio.plotly.com/settings for more details."
          ].join(" ")
        },
        maxpoints: {
          valType: "number",
          min: 0,
          max: 1e4,
          dflt: 500,
          editType: "calc",
          description: [
            "Sets the maximum number of points to keep on the plots from an",
            "incoming stream.",
            "If `maxpoints` is set to *50*, only the newest 50 points will",
            "be displayed on the plot."
          ].join(" ")
        },
        editType: "calc"
      },
      transforms: {
        _isLinkedToArray: "transform",
        editType: "calc",
        description: [
          "WARNING: All transforms are deprecated and may be removed from the API in next major version.",
          "An array of operations that manipulate the trace data,",
          "for example filtering or sorting the data arrays."
        ].join(" ")
      },
      uirevision: {
        valType: "any",
        editType: "none",
        description: [
          "Controls persistence of some user-driven changes to the trace:",
          "`constraintrange` in `parcoords` traces, as well as some",
          "`editable: true` modifications such as `name` and `colorbar.title`.",
          "Defaults to `layout.uirevision`.",
          "Note that other user-driven trace attribute changes are controlled",
          "by `layout` attributes:",
          "`trace.visible` is controlled by `layout.legend.uirevision`,",
          "`selectedpoints` is controlled by `layout.selectionrevision`,",
          "and `colorbar.(x|y)` (accessible with `config: {editable: true}`)",
          "is controlled by `layout.editrevision`.",
          "Trace changes are tracked by `uid`, which only falls back on trace",
          "index if no `uid` is provided. So if your app can add/remove traces",
          "before the end of the `data` array, such that the same trace has a",
          "different index, you can still preserve user-driven changes if you",
          "give each trace a `uid` that stays with it as it moves."
        ].join(" ")
      }
    };
  }
});

// node_modules/plotly.js/src/components/colorscale/scales.js
var require_scales = __commonJS({
  "node_modules/plotly.js/src/components/colorscale/scales.js"(exports2, module2) {
    "use strict";
    var tinycolor = require_tinycolor();
    var scales = {
      Greys: [
        [0, "rgb(0,0,0)"],
        [1, "rgb(255,255,255)"]
      ],
      YlGnBu: [
        [0, "rgb(8,29,88)"],
        [0.125, "rgb(37,52,148)"],
        [0.25, "rgb(34,94,168)"],
        [0.375, "rgb(29,145,192)"],
        [0.5, "rgb(65,182,196)"],
        [0.625, "rgb(127,205,187)"],
        [0.75, "rgb(199,233,180)"],
        [0.875, "rgb(237,248,217)"],
        [1, "rgb(255,255,217)"]
      ],
      Greens: [
        [0, "rgb(0,68,27)"],
        [0.125, "rgb(0,109,44)"],
        [0.25, "rgb(35,139,69)"],
        [0.375, "rgb(65,171,93)"],
        [0.5, "rgb(116,196,118)"],
        [0.625, "rgb(161,217,155)"],
        [0.75, "rgb(199,233,192)"],
        [0.875, "rgb(229,245,224)"],
        [1, "rgb(247,252,245)"]
      ],
      YlOrRd: [
        [0, "rgb(128,0,38)"],
        [0.125, "rgb(189,0,38)"],
        [0.25, "rgb(227,26,28)"],
        [0.375, "rgb(252,78,42)"],
        [0.5, "rgb(253,141,60)"],
        [0.625, "rgb(254,178,76)"],
        [0.75, "rgb(254,217,118)"],
        [0.875, "rgb(255,237,160)"],
        [1, "rgb(255,255,204)"]
      ],
      Bluered: [
        [0, "rgb(0,0,255)"],
        [1, "rgb(255,0,0)"]
      ],
      // modified RdBu based on
      // http://www.kennethmoreland.com/color-maps/
      RdBu: [
        [0, "rgb(5,10,172)"],
        [0.35, "rgb(106,137,247)"],
        [0.5, "rgb(190,190,190)"],
        [0.6, "rgb(220,170,132)"],
        [0.7, "rgb(230,145,90)"],
        [1, "rgb(178,10,28)"]
      ],
      // Scale for non-negative numeric values
      Reds: [
        [0, "rgb(220,220,220)"],
        [0.2, "rgb(245,195,157)"],
        [0.4, "rgb(245,160,105)"],
        [1, "rgb(178,10,28)"]
      ],
      // Scale for non-positive numeric values
      Blues: [
        [0, "rgb(5,10,172)"],
        [0.35, "rgb(40,60,190)"],
        [0.5, "rgb(70,100,245)"],
        [0.6, "rgb(90,120,245)"],
        [0.7, "rgb(106,137,247)"],
        [1, "rgb(220,220,220)"]
      ],
      Picnic: [
        [0, "rgb(0,0,255)"],
        [0.1, "rgb(51,153,255)"],
        [0.2, "rgb(102,204,255)"],
        [0.3, "rgb(153,204,255)"],
        [0.4, "rgb(204,204,255)"],
        [0.5, "rgb(255,255,255)"],
        [0.6, "rgb(255,204,255)"],
        [0.7, "rgb(255,153,255)"],
        [0.8, "rgb(255,102,204)"],
        [0.9, "rgb(255,102,102)"],
        [1, "rgb(255,0,0)"]
      ],
      Rainbow: [
        [0, "rgb(150,0,90)"],
        [0.125, "rgb(0,0,200)"],
        [0.25, "rgb(0,25,255)"],
        [0.375, "rgb(0,152,255)"],
        [0.5, "rgb(44,255,150)"],
        [0.625, "rgb(151,255,0)"],
        [0.75, "rgb(255,234,0)"],
        [0.875, "rgb(255,111,0)"],
        [1, "rgb(255,0,0)"]
      ],
      Portland: [
        [0, "rgb(12,51,131)"],
        [0.25, "rgb(10,136,186)"],
        [0.5, "rgb(242,211,56)"],
        [0.75, "rgb(242,143,56)"],
        [1, "rgb(217,30,30)"]
      ],
      Jet: [
        [0, "rgb(0,0,131)"],
        [0.125, "rgb(0,60,170)"],
        [0.375, "rgb(5,255,255)"],
        [0.625, "rgb(255,255,0)"],
        [0.875, "rgb(250,0,0)"],
        [1, "rgb(128,0,0)"]
      ],
      Hot: [
        [0, "rgb(0,0,0)"],
        [0.3, "rgb(230,0,0)"],
        [0.6, "rgb(255,210,0)"],
        [1, "rgb(255,255,255)"]
      ],
      Blackbody: [
        [0, "rgb(0,0,0)"],
        [0.2, "rgb(230,0,0)"],
        [0.4, "rgb(230,210,0)"],
        [0.7, "rgb(255,255,255)"],
        [1, "rgb(160,200,255)"]
      ],
      Earth: [
        [0, "rgb(0,0,130)"],
        [0.1, "rgb(0,180,180)"],
        [0.2, "rgb(40,210,40)"],
        [0.4, "rgb(230,230,50)"],
        [0.6, "rgb(120,70,20)"],
        [1, "rgb(255,255,255)"]
      ],
      Electric: [
        [0, "rgb(0,0,0)"],
        [0.15, "rgb(30,0,100)"],
        [0.4, "rgb(120,0,100)"],
        [0.6, "rgb(160,90,0)"],
        [0.8, "rgb(230,200,0)"],
        [1, "rgb(255,250,220)"]
      ],
      Viridis: [
        [0, "#440154"],
        [0.06274509803921569, "#48186a"],
        [0.12549019607843137, "#472d7b"],
        [0.18823529411764706, "#424086"],
        [0.25098039215686274, "#3b528b"],
        [0.3137254901960784, "#33638d"],
        [0.3764705882352941, "#2c728e"],
        [0.4392156862745098, "#26828e"],
        [0.5019607843137255, "#21918c"],
        [0.5647058823529412, "#1fa088"],
        [0.6274509803921569, "#28ae80"],
        [0.6901960784313725, "#3fbc73"],
        [0.7529411764705882, "#5ec962"],
        [0.8156862745098039, "#84d44b"],
        [0.8784313725490196, "#addc30"],
        [0.9411764705882353, "#d8e219"],
        [1, "#fde725"]
      ],
      Cividis: [
        [0, "rgb(0,32,76)"],
        [0.058824, "rgb(0,42,102)"],
        [0.117647, "rgb(0,52,110)"],
        [0.176471, "rgb(39,63,108)"],
        [0.235294, "rgb(60,74,107)"],
        [0.294118, "rgb(76,85,107)"],
        [0.352941, "rgb(91,95,109)"],
        [0.411765, "rgb(104,106,112)"],
        [0.470588, "rgb(117,117,117)"],
        [0.529412, "rgb(131,129,120)"],
        [0.588235, "rgb(146,140,120)"],
        [0.647059, "rgb(161,152,118)"],
        [0.705882, "rgb(176,165,114)"],
        [0.764706, "rgb(192,177,109)"],
        [0.823529, "rgb(209,191,102)"],
        [0.882353, "rgb(225,204,92)"],
        [0.941176, "rgb(243,219,79)"],
        [1, "rgb(255,233,69)"]
      ]
    };
    var defaultScale = scales.RdBu;
    function getScale(scl, dflt) {
      if (!dflt) dflt = defaultScale;
      if (!scl) return dflt;
      function parseScale() {
        try {
          scl = scales[scl] || JSON.parse(scl);
        } catch (e) {
          scl = dflt;
        }
      }
      if (typeof scl === "string") {
        parseScale();
        if (typeof scl === "string") parseScale();
      }
      if (!isValidScaleArray(scl)) return dflt;
      return scl;
    }
    function isValidScaleArray(scl) {
      var highestVal = 0;
      if (!Array.isArray(scl) || scl.length < 2) return false;
      if (!scl[0] || !scl[scl.length - 1]) return false;
      if (+scl[0][0] !== 0 || +scl[scl.length - 1][0] !== 1) return false;
      for (var i = 0; i < scl.length; i++) {
        var si2 = scl[i];
        if (si2.length !== 2 || +si2[0] < highestVal || !tinycolor(si2[1]).isValid()) {
          return false;
        }
        highestVal = +si2[0];
      }
      return true;
    }
    function isValidScale(scl) {
      if (scales[scl] !== void 0) return true;
      else return isValidScaleArray(scl);
    }
    module2.exports = {
      scales,
      defaultScale,
      get: getScale,
      isValid: isValidScale
    };
  }
});

// node_modules/plotly.js/src/components/color/attributes.js
var require_attributes3 = __commonJS({
  "node_modules/plotly.js/src/components/color/attributes.js"(exports2) {
    "use strict";
    exports2.defaults = [
      "#1f77b4",
      // muted blue
      "#ff7f0e",
      // safety orange
      "#2ca02c",
      // cooked asparagus green
      "#d62728",
      // brick red
      "#9467bd",
      // muted purple
      "#8c564b",
      // chestnut brown
      "#e377c2",
      // raspberry yogurt pink
      "#7f7f7f",
      // middle gray
      "#bcbd22",
      // curry yellow-green
      "#17becf"
      // blue-teal
    ];
    exports2.defaultLine = "#444";
    exports2.lightLine = "#eee";
    exports2.background = "#fff";
    exports2.borderLine = "#BEC8D9";
    exports2.lightFraction = 100 * (14 - 4) / (15 - 4);
  }
});

// node_modules/plotly.js/src/components/color/index.js
var require_color = __commonJS({
  "node_modules/plotly.js/src/components/color/index.js"(exports2, module2) {
    "use strict";
    var tinycolor = require_tinycolor();
    var isNumeric = require_fast_isnumeric();
    var isTypedArray = require_array().isTypedArray;
    var color = module2.exports = {};
    var colorAttrs = require_attributes3();
    color.defaults = colorAttrs.defaults;
    var defaultLine = color.defaultLine = colorAttrs.defaultLine;
    color.lightLine = colorAttrs.lightLine;
    var background = color.background = colorAttrs.background;
    color.tinyRGB = function(tc2) {
      var c = tc2.toRgb();
      return "rgb(" + Math.round(c.r) + ", " + Math.round(c.g) + ", " + Math.round(c.b) + ")";
    };
    color.rgb = function(cstr) {
      return color.tinyRGB(tinycolor(cstr));
    };
    color.opacity = function(cstr) {
      return cstr ? tinycolor(cstr).getAlpha() : 0;
    };
    color.addOpacity = function(cstr, op2) {
      var c = tinycolor(cstr).toRgb();
      return "rgba(" + Math.round(c.r) + ", " + Math.round(c.g) + ", " + Math.round(c.b) + ", " + op2 + ")";
    };
    color.combine = function(front, back) {
      var fc2 = tinycolor(front).toRgb();
      if (fc2.a === 1) return tinycolor(front).toRgbString();
      var bc2 = tinycolor(back || background).toRgb();
      var bcflat = bc2.a === 1 ? bc2 : {
        r: 255 * (1 - bc2.a) + bc2.r * bc2.a,
        g: 255 * (1 - bc2.a) + bc2.g * bc2.a,
        b: 255 * (1 - bc2.a) + bc2.b * bc2.a
      };
      var fcflat = {
        r: bcflat.r * (1 - fc2.a) + fc2.r * fc2.a,
        g: bcflat.g * (1 - fc2.a) + fc2.g * fc2.a,
        b: bcflat.b * (1 - fc2.a) + fc2.b * fc2.a
      };
      return tinycolor(fcflat).toRgbString();
    };
    color.interpolate = function(first, second2, factor) {
      var fc2 = tinycolor(first).toRgb();
      var sc2 = tinycolor(second2).toRgb();
      var ic2 = {
        r: factor * fc2.r + (1 - factor) * sc2.r,
        g: factor * fc2.g + (1 - factor) * sc2.g,
        b: factor * fc2.b + (1 - factor) * sc2.b
      };
      return tinycolor(ic2).toRgbString();
    };
    color.contrast = function(cstr, lightAmount, darkAmount) {
      var tc2 = tinycolor(cstr);
      if (tc2.getAlpha() !== 1) tc2 = tinycolor(color.combine(cstr, background));
      var newColor = tc2.isDark() ? lightAmount ? tc2.lighten(lightAmount) : background : darkAmount ? tc2.darken(darkAmount) : defaultLine;
      return newColor.toString();
    };
    color.stroke = function(s, c) {
      var tc2 = tinycolor(c);
      s.style({ stroke: color.tinyRGB(tc2), "stroke-opacity": tc2.getAlpha() });
    };
    color.fill = function(s, c) {
      var tc2 = tinycolor(c);
      s.style({
        fill: color.tinyRGB(tc2),
        "fill-opacity": tc2.getAlpha()
      });
    };
    color.clean = function(container) {
      if (!container || typeof container !== "object") return;
      var keys = Object.keys(container);
      var i, j, key, val;
      for (i = 0; i < keys.length; i++) {
        key = keys[i];
        val = container[key];
        if (key.substr(key.length - 5) === "color") {
          if (Array.isArray(val)) {
            for (j = 0; j < val.length; j++) val[j] = cleanOne(val[j]);
          } else container[key] = cleanOne(val);
        } else if (key.substr(key.length - 10) === "colorscale" && Array.isArray(val)) {
          for (j = 0; j < val.length; j++) {
            if (Array.isArray(val[j])) val[j][1] = cleanOne(val[j][1]);
          }
        } else if (Array.isArray(val)) {
          var el0 = val[0];
          if (!Array.isArray(el0) && el0 && typeof el0 === "object") {
            for (j = 0; j < val.length; j++) color.clean(val[j]);
          }
        } else if (val && typeof val === "object" && !isTypedArray(val)) color.clean(val);
      }
    };
    function cleanOne(val) {
      if (isNumeric(val) || typeof val !== "string") return val;
      var valTrim = val.trim();
      if (valTrim.substr(0, 3) !== "rgb") return val;
      var match = valTrim.match(/^rgba?\s*\(([^()]*)\)$/);
      if (!match) return val;
      var parts = match[1].trim().split(/\s*[\s,]\s*/);
      var rgba = valTrim.charAt(3) === "a" && parts.length === 4;
      if (!rgba && parts.length !== 3) return val;
      for (var i = 0; i < parts.length; i++) {
        if (!parts[i].length) return val;
        parts[i] = Number(parts[i]);
        if (!(parts[i] >= 0)) {
          return val;
        }
        if (i === 3) {
          if (parts[i] > 1) parts[i] = 1;
        } else if (parts[i] >= 1) {
          return val;
        }
      }
      var rgbStr = Math.round(parts[0] * 255) + ", " + Math.round(parts[1] * 255) + ", " + Math.round(parts[2] * 255);
      if (rgba) return "rgba(" + rgbStr + ", " + parts[3] + ")";
      return "rgb(" + rgbStr + ")";
    }
  }
});

// node_modules/plotly.js/src/constants/interactions.js
var require_interactions = __commonJS({
  "node_modules/plotly.js/src/constants/interactions.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      /**
       * Timing information for interactive elements
       */
      SHOW_PLACEHOLDER: 100,
      HIDE_PLACEHOLDER: 1e3,
      // opacity dimming fraction for points that are not in selection
      DESELECTDIM: 0.2
    };
  }
});

// node_modules/plotly.js/src/lib/regex.js
var require_regex = __commonJS({
  "node_modules/plotly.js/src/lib/regex.js"(exports2) {
    "use strict";
    exports2.counter = function(head, tail, openEnded, matchBeginning) {
      var fullTail = (tail || "") + (openEnded ? "" : "$");
      var startWithPrefix = matchBeginning === false ? "" : "^";
      if (head === "xy") {
        return new RegExp(startWithPrefix + "x([2-9]|[1-9][0-9]+)?y([2-9]|[1-9][0-9]+)?" + fullTail);
      }
      return new RegExp(startWithPrefix + head + "([2-9]|[1-9][0-9]+)?" + fullTail);
    };
  }
});

// node_modules/plotly.js/src/lib/coerce.js
var require_coerce = __commonJS({
  "node_modules/plotly.js/src/lib/coerce.js"(exports2) {
    "use strict";
    var isNumeric = require_fast_isnumeric();
    var tinycolor = require_tinycolor();
    var extendFlat = require_extend().extendFlat;
    var baseTraceAttrs = require_attributes2();
    var colorscales = require_scales();
    var Color = require_color();
    var DESELECTDIM = require_interactions().DESELECTDIM;
    var nestedProperty = require_nested_property();
    var counterRegex = require_regex().counter;
    var modHalf = require_mod().modHalf;
    var isArrayOrTypedArray = require_array().isArrayOrTypedArray;
    var isTypedArraySpec = require_array().isTypedArraySpec;
    var decodeTypedArraySpec = require_array().decodeTypedArraySpec;
    exports2.valObjectMeta = {
      data_array: {
        // You can use *dflt=[] to force said array to exist though.
        description: [
          "An {array} of data.",
          "The value must represent an {array} or it will be ignored,",
          "but this array can be provided in several forms:",
          "(1) a regular {array} object",
          "(2) a typed array (e.g. Float32Array)",
          "(3) an object with keys dtype, bdata, and optionally shape.",
          "In this 3rd form, dtype is one of",
          "*f8*, *f4*.",
          "*i4*, *u4*,",
          "*i2*, *u2*,",
          "*i1*, *u1* or *u1c* for Uint8ClampedArray.",
          "In addition to shorthand `dtype` above one could also use the following forms:",
          "*float64*, *float32*,",
          "*int32*, *uint32*,",
          "*int16*, *uint16*,",
          "*int8*, *uint8* or *uint8c* for Uint8ClampedArray.",
          "`bdata` is either a base64-encoded string or the ArrayBuffer of",
          "an integer or float typed array.",
          "For either multi-dimensional arrays you must also",
          "provide its dimensions separated by comma via `shape`.",
          "For example using `dtype`: *f4* and `shape`: *5,100* you can",
          "declare a 2-D array that has 5 rows and 100 columns",
          "containing float32 values i.e. 4 bits per value.",
          "`shape` is optional for one dimensional arrays."
        ].join(" "),
        requiredOpts: [],
        otherOpts: ["dflt"],
        coerceFunction: function(v, propOut, dflt) {
          propOut.set(
            isArrayOrTypedArray(v) ? v : isTypedArraySpec(v) ? decodeTypedArraySpec(v) : dflt
          );
        }
      },
      enumerated: {
        description: [
          "Enumerated value type. The available values are listed",
          "in `values`."
        ].join(" "),
        requiredOpts: ["values"],
        otherOpts: ["dflt", "coerceNumber", "arrayOk"],
        coerceFunction: function(v, propOut, dflt, opts) {
          if (opts.coerceNumber) v = +v;
          if (opts.values.indexOf(v) === -1) propOut.set(dflt);
          else propOut.set(v);
        },
        validateFunction: function(v, opts) {
          if (opts.coerceNumber) v = +v;
          var values = opts.values;
          for (var i = 0; i < values.length; i++) {
            var k = String(values[i]);
            if (k.charAt(0) === "/" && k.charAt(k.length - 1) === "/") {
              var regex = new RegExp(k.substr(1, k.length - 2));
              if (regex.test(v)) return true;
            } else if (v === values[i]) return true;
          }
          return false;
        }
      },
      boolean: {
        description: "A boolean (true/false) value.",
        requiredOpts: [],
        otherOpts: ["dflt"],
        coerceFunction: function(v, propOut, dflt) {
          if (v === true || v === false) propOut.set(v);
          else propOut.set(dflt);
        }
      },
      number: {
        description: [
          "A number or a numeric value",
          "(e.g. a number inside a string).",
          "When applicable, values greater (less) than `max` (`min`)",
          "are coerced to the `dflt`."
        ].join(" "),
        requiredOpts: [],
        otherOpts: ["dflt", "min", "max", "arrayOk"],
        coerceFunction: function(v, propOut, dflt, opts) {
          if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
          if (!isNumeric(v) || opts.min !== void 0 && v < opts.min || opts.max !== void 0 && v > opts.max) {
            propOut.set(dflt);
          } else propOut.set(+v);
        }
      },
      integer: {
        description: [
          "An integer or an integer inside a string.",
          "When applicable, values greater (less) than `max` (`min`)",
          "are coerced to the `dflt`."
        ].join(" "),
        requiredOpts: [],
        otherOpts: ["dflt", "min", "max", "arrayOk", "extras"],
        coerceFunction: function(v, propOut, dflt, opts) {
          if ((opts.extras || []).indexOf(v) !== -1) {
            propOut.set(v);
            return;
          }
          if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
          if (v % 1 || !isNumeric(v) || opts.min !== void 0 && v < opts.min || opts.max !== void 0 && v > opts.max) {
            propOut.set(dflt);
          } else propOut.set(+v);
        }
      },
      string: {
        description: [
          "A string value.",
          "Numbers are converted to strings except for attributes with",
          "`strict` set to true."
        ].join(" "),
        requiredOpts: [],
        // TODO 'values shouldn't be in there (edge case: 'dash' in Scatter)
        otherOpts: ["dflt", "noBlank", "strict", "arrayOk", "values"],
        coerceFunction: function(v, propOut, dflt, opts) {
          if (typeof v !== "string") {
            var okToCoerce = typeof v === "number";
            if (opts.strict === true || !okToCoerce) propOut.set(dflt);
            else propOut.set(String(v));
          } else if (opts.noBlank && !v) propOut.set(dflt);
          else propOut.set(v);
        }
      },
      color: {
        description: [
          "A string describing color.",
          "Supported formats:",
          "- hex (e.g. '#d3d3d3')",
          "- rgb (e.g. 'rgb(255, 0, 0)')",
          "- rgba (e.g. 'rgb(255, 0, 0, 0.5)')",
          "- hsl (e.g. 'hsl(0, 100%, 50%)')",
          "- hsv (e.g. 'hsv(0, 100%, 100%)')",
          "- named colors (full list: http://www.w3.org/TR/css3-color/#svg-color)"
        ].join(" "),
        requiredOpts: [],
        otherOpts: ["dflt", "arrayOk"],
        coerceFunction: function(v, propOut, dflt) {
          if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
          if (tinycolor(v).isValid()) propOut.set(v);
          else propOut.set(dflt);
        }
      },
      colorlist: {
        description: [
          "A list of colors.",
          "Must be an {array} containing valid colors."
        ].join(" "),
        requiredOpts: [],
        otherOpts: ["dflt"],
        coerceFunction: function(v, propOut, dflt) {
          function isColor(color) {
            return tinycolor(color).isValid();
          }
          if (!Array.isArray(v) || !v.length) propOut.set(dflt);
          else if (v.every(isColor)) propOut.set(v);
          else propOut.set(dflt);
        }
      },
      colorscale: {
        description: [
          "A Plotly colorscale either picked by a name:",
          "(any of",
          Object.keys(colorscales.scales).join(", "),
          ")",
          "customized as an {array} of 2-element {arrays} where",
          "the first element is the normalized color level value",
          "(starting at *0* and ending at *1*),",
          "and the second item is a valid color string."
        ].join(" "),
        requiredOpts: [],
        otherOpts: ["dflt"],
        coerceFunction: function(v, propOut, dflt) {
          propOut.set(colorscales.get(v, dflt));
        }
      },
      angle: {
        description: [
          "A number (in degree) between -180 and 180."
        ].join(" "),
        requiredOpts: [],
        otherOpts: ["dflt", "arrayOk"],
        coerceFunction: function(v, propOut, dflt) {
          if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
          if (v === "auto") propOut.set("auto");
          else if (!isNumeric(v)) propOut.set(dflt);
          else propOut.set(modHalf(+v, 360));
        }
      },
      subplotid: {
        description: [
          "An id string of a subplot type (given by dflt), optionally",
          "followed by an integer >1. e.g. if dflt='geo', we can have",
          "'geo', 'geo2', 'geo3', ..."
        ].join(" "),
        requiredOpts: ["dflt"],
        otherOpts: ["regex"],
        coerceFunction: function(v, propOut, dflt, opts) {
          var regex = opts.regex || counterRegex(dflt);
          if (typeof v === "string" && regex.test(v)) {
            propOut.set(v);
            return;
          }
          propOut.set(dflt);
        },
        validateFunction: function(v, opts) {
          var dflt = opts.dflt;
          if (v === dflt) return true;
          if (typeof v !== "string") return false;
          if (counterRegex(dflt).test(v)) return true;
          return false;
        }
      },
      flaglist: {
        description: [
          "A string representing a combination of flags",
          "(order does not matter here).",
          "Combine any of the available `flags` with *+*.",
          "(e.g. ('lines+markers')).",
          "Values in `extras` cannot be combined."
        ].join(" "),
        requiredOpts: ["flags"],
        otherOpts: ["dflt", "extras", "arrayOk"],
        coerceFunction: function(v, propOut, dflt, opts) {
          if ((opts.extras || []).indexOf(v) !== -1) {
            propOut.set(v);
            return;
          }
          if (typeof v !== "string") {
            propOut.set(dflt);
            return;
          }
          var vParts = v.split("+");
          var i = 0;
          while (i < vParts.length) {
            var vi2 = vParts[i];
            if (opts.flags.indexOf(vi2) === -1 || vParts.indexOf(vi2) < i) {
              vParts.splice(i, 1);
            } else i++;
          }
          if (!vParts.length) propOut.set(dflt);
          else propOut.set(vParts.join("+"));
        }
      },
      any: {
        description: "Any type.",
        requiredOpts: [],
        otherOpts: ["dflt", "values", "arrayOk"],
        coerceFunction: function(v, propOut, dflt) {
          if (v === void 0) {
            propOut.set(dflt);
          } else {
            propOut.set(
              isTypedArraySpec(v) ? decodeTypedArraySpec(v) : v
            );
          }
        }
      },
      info_array: {
        description: [
          "An {array} of plot information."
        ].join(" "),
        requiredOpts: ["items"],
        // set `dimensions=2` for a 2D array or '1-2' for either
        // `items` may be a single object instead of an array, in which case
        // `freeLength` must be true.
        // if `dimensions='1-2'` and items is a 1D array, then the value can
        // either be a matching 1D array or an array of such matching 1D arrays
        otherOpts: ["dflt", "freeLength", "dimensions"],
        coerceFunction: function(v, propOut, dflt, opts) {
          function coercePart(v2, opts2, dflt2) {
            var out;
            var propPart = { set: function(v3) {
              out = v3;
            } };
            if (dflt2 === void 0) dflt2 = opts2.dflt;
            exports2.valObjectMeta[opts2.valType].coerceFunction(v2, propPart, dflt2, opts2);
            return out;
          }
          if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
          if (!isArrayOrTypedArray(v)) {
            propOut.set(dflt);
            return;
          }
          var twoD = opts.dimensions === 2 || opts.dimensions === "1-2" && Array.isArray(v) && isArrayOrTypedArray(v[0]);
          var items = opts.items;
          var vOut = [];
          var arrayItems = Array.isArray(items);
          var arrayItems2D = arrayItems && twoD && isArrayOrTypedArray(items[0]);
          var innerItemsOnly = twoD && arrayItems && !arrayItems2D;
          var len = arrayItems && !innerItemsOnly ? items.length : v.length;
          var i, j, row, item, len2, vNew;
          dflt = Array.isArray(dflt) ? dflt : [];
          if (twoD) {
            for (i = 0; i < len; i++) {
              vOut[i] = [];
              row = isArrayOrTypedArray(v[i]) ? v[i] : [];
              if (innerItemsOnly) len2 = items.length;
              else if (arrayItems) len2 = items[i].length;
              else len2 = row.length;
              for (j = 0; j < len2; j++) {
                if (innerItemsOnly) item = items[j];
                else if (arrayItems) item = items[i][j];
                else item = items;
                vNew = coercePart(row[j], item, (dflt[i] || [])[j]);
                if (vNew !== void 0) vOut[i][j] = vNew;
              }
            }
          } else {
            for (i = 0; i < len; i++) {
              vNew = coercePart(v[i], arrayItems ? items[i] : items, dflt[i]);
              if (vNew !== void 0) vOut[i] = vNew;
            }
          }
          propOut.set(vOut);
        },
        validateFunction: function(v, opts) {
          if (!isArrayOrTypedArray(v)) return false;
          var items = opts.items;
          var arrayItems = Array.isArray(items);
          var twoD = opts.dimensions === 2;
          if (!opts.freeLength && v.length !== items.length) return false;
          for (var i = 0; i < v.length; i++) {
            if (twoD) {
              if (!isArrayOrTypedArray(v[i]) || !opts.freeLength && v[i].length !== items[i].length) {
                return false;
              }
              for (var j = 0; j < v[i].length; j++) {
                if (!validate(v[i][j], arrayItems ? items[i][j] : items)) {
                  return false;
                }
              }
            } else if (!validate(v[i], arrayItems ? items[i] : items)) return false;
          }
          return true;
        }
      }
    };
    exports2.coerce = function(containerIn, containerOut, attributes, attribute, dflt) {
      var opts = nestedProperty(attributes, attribute).get();
      var propIn = nestedProperty(containerIn, attribute);
      var propOut = nestedProperty(containerOut, attribute);
      var v = propIn.get();
      var template = containerOut._template;
      if (v === void 0 && template) {
        v = nestedProperty(template, attribute).get();
        template = 0;
      }
      if (dflt === void 0) dflt = opts.dflt;
      if (opts.arrayOk) {
        if (isArrayOrTypedArray(v)) {
          propOut.set(v);
          return v;
        } else {
          if (isTypedArraySpec(v)) {
            v = decodeTypedArraySpec(v);
            propOut.set(v);
            return v;
          }
        }
      }
      var coerceFunction = exports2.valObjectMeta[opts.valType].coerceFunction;
      coerceFunction(v, propOut, dflt, opts);
      var out = propOut.get();
      if (template && out === dflt && !validate(v, opts)) {
        v = nestedProperty(template, attribute).get();
        coerceFunction(v, propOut, dflt, opts);
        out = propOut.get();
      }
      return out;
    };
    exports2.coerce2 = function(containerIn, containerOut, attributes, attribute, dflt) {
      var propIn = nestedProperty(containerIn, attribute);
      var propOut = exports2.coerce(containerIn, containerOut, attributes, attribute, dflt);
      var valIn = propIn.get();
      return valIn !== void 0 && valIn !== null ? propOut : false;
    };
    exports2.coerceFont = function(coerce, attr, dfltObj, opts) {
      if (!opts) opts = {};
      dfltObj = extendFlat({}, dfltObj);
      dfltObj = extendFlat(dfltObj, opts.overrideDflt || {});
      var out = {
        family: coerce(attr + ".family", dfltObj.family),
        size: coerce(attr + ".size", dfltObj.size),
        color: coerce(attr + ".color", dfltObj.color),
        weight: coerce(attr + ".weight", dfltObj.weight),
        style: coerce(attr + ".style", dfltObj.style)
      };
      if (!opts.noFontVariant) out.variant = coerce(attr + ".variant", dfltObj.variant);
      if (!opts.noFontLineposition) out.lineposition = coerce(attr + ".lineposition", dfltObj.lineposition);
      if (!opts.noFontTextcase) out.textcase = coerce(attr + ".textcase", dfltObj.textcase);
      if (!opts.noFontShadow) {
        var dfltShadow = dfltObj.shadow;
        if (dfltShadow === "none" && opts.autoShadowDflt) {
          dfltShadow = "auto";
        }
        out.shadow = coerce(attr + ".shadow", dfltShadow);
      }
      return out;
    };
    exports2.coercePattern = function(coerce, attr, markerColor, hasMarkerColorscale) {
      var shape = coerce(attr + ".shape");
      if (shape) {
        coerce(attr + ".solidity");
        coerce(attr + ".size");
        var fillmode = coerce(attr + ".fillmode");
        var isOverlay = fillmode === "overlay";
        if (!hasMarkerColorscale) {
          var bgcolor = coerce(
            attr + ".bgcolor",
            isOverlay ? markerColor : void 0
          );
          coerce(
            attr + ".fgcolor",
            isOverlay ? Color.contrast(bgcolor) : markerColor
          );
        }
        coerce(
          attr + ".fgopacity",
          isOverlay ? 0.5 : 1
        );
      }
    };
    exports2.coerceHoverinfo = function(traceIn, traceOut, layoutOut) {
      var moduleAttrs = traceOut._module.attributes;
      var attrs = moduleAttrs.hoverinfo ? moduleAttrs : baseTraceAttrs;
      var valObj = attrs.hoverinfo;
      var dflt;
      if (layoutOut._dataLength === 1) {
        var flags = valObj.dflt === "all" ? valObj.flags.slice() : valObj.dflt.split("+");
        flags.splice(flags.indexOf("name"), 1);
        dflt = flags.join("+");
      }
      return exports2.coerce(traceIn, traceOut, attrs, "hoverinfo", dflt);
    };
    exports2.coerceSelectionMarkerOpacity = function(traceOut, coerce) {
      if (!traceOut.marker) return;
      var mo2 = traceOut.marker.opacity;
      if (mo2 === void 0) return;
      var smoDflt;
      var usmoDflt;
      if (!isArrayOrTypedArray(mo2) && !traceOut.selected && !traceOut.unselected) {
        smoDflt = mo2;
        usmoDflt = DESELECTDIM * mo2;
      }
      coerce("selected.marker.opacity", smoDflt);
      coerce("unselected.marker.opacity", usmoDflt);
    };
    function validate(value, opts) {
      var valObjectDef = exports2.valObjectMeta[opts.valType];
      if (opts.arrayOk && isArrayOrTypedArray(value)) return true;
      if (valObjectDef.validateFunction) {
        return valObjectDef.validateFunction(value, opts);
      }
      var failed = {};
      var out = failed;
      var propMock = { set: function(v) {
        out = v;
      } };
      valObjectDef.coerceFunction(value, propMock, failed, opts);
      return out !== failed;
    }
    exports2.validate = validate;
  }
});

// node_modules/plotly.js/src/plot_api/plot_config.js
var require_plot_config = __commonJS({
  "node_modules/plotly.js/src/plot_api/plot_config.js"(exports2, module2) {
    "use strict";
    var configAttributes = {
      staticPlot: {
        valType: "boolean",
        dflt: false,
        description: [
          "Determines whether the graphs are interactive or not.",
          "If *false*, no interactivity, for export or image generation."
        ].join(" ")
      },
      typesetMath: {
        valType: "boolean",
        dflt: true,
        description: [
          "Determines whether math should be typeset or not,",
          "when MathJax (either v2 or v3) is present on the page."
        ].join(" ")
      },
      plotlyServerURL: {
        valType: "string",
        dflt: "",
        description: [
          "When set it determines base URL for",
          "the 'Edit in Chart Studio' `showEditInChartStudio`/`showSendToCloud` mode bar button",
          "and the showLink/sendData on-graph link.",
          "To enable sending your data to Chart Studio Cloud, you need to",
          "set both `plotlyServerURL` to 'https://chart-studio.plotly.com' and",
          "also set `showSendToCloud` to true."
        ].join(" ")
      },
      editable: {
        valType: "boolean",
        dflt: false,
        description: [
          "Determines whether the graph is editable or not.",
          "Sets all pieces of `edits`",
          "unless a separate `edits` config item overrides individual parts."
        ].join(" ")
      },
      edits: {
        annotationPosition: {
          valType: "boolean",
          dflt: false,
          description: [
            "Determines if the main anchor of the annotation is editable.",
            "The main anchor corresponds to the",
            "text (if no arrow) or the arrow (which drags the whole thing leaving",
            "the arrow length & direction unchanged)."
          ].join(" ")
        },
        annotationTail: {
          valType: "boolean",
          dflt: false,
          description: [
            "Has only an effect for annotations with arrows.",
            "Enables changing the length and direction of the arrow."
          ].join(" ")
        },
        annotationText: {
          valType: "boolean",
          dflt: false,
          description: "Enables editing annotation text."
        },
        axisTitleText: {
          valType: "boolean",
          dflt: false,
          description: "Enables editing axis title text."
        },
        colorbarPosition: {
          valType: "boolean",
          dflt: false,
          description: "Enables moving colorbars."
        },
        colorbarTitleText: {
          valType: "boolean",
          dflt: false,
          description: "Enables editing colorbar title text."
        },
        legendPosition: {
          valType: "boolean",
          dflt: false,
          description: "Enables moving the legend."
        },
        legendText: {
          valType: "boolean",
          dflt: false,
          description: "Enables editing the trace name fields from the legend"
        },
        shapePosition: {
          valType: "boolean",
          dflt: false,
          description: "Enables moving shapes."
        },
        titleText: {
          valType: "boolean",
          dflt: false,
          description: "Enables editing the global layout title."
        }
      },
      editSelection: {
        valType: "boolean",
        dflt: true,
        description: "Enables moving selections."
      },
      autosizable: {
        valType: "boolean",
        dflt: false,
        description: [
          "Determines whether the graphs are plotted with respect to",
          "layout.autosize:true and infer its container size."
        ].join(" ")
      },
      responsive: {
        valType: "boolean",
        dflt: false,
        description: [
          "Determines whether to change the layout size when window is resized.",
          "In v3, this option will be removed and will always be true."
        ].join(" ")
      },
      fillFrame: {
        valType: "boolean",
        dflt: false,
        description: [
          "When `layout.autosize` is turned on, determines whether the graph",
          "fills the container (the default) or the screen (if set to *true*)."
        ].join(" ")
      },
      frameMargins: {
        valType: "number",
        dflt: 0,
        min: 0,
        max: 0.5,
        description: [
          "When `layout.autosize` is turned on, set the frame margins",
          "in fraction of the graph size."
        ].join(" ")
      },
      scrollZoom: {
        valType: "flaglist",
        flags: ["cartesian", "gl3d", "geo", "mapbox", "map"],
        extras: [true, false],
        dflt: "gl3d+geo+map",
        description: [
          "Determines whether mouse wheel or two-finger scroll zooms is enable.",
          "Turned on by default for gl3d, geo, mapbox and map subplots",
          "(as these subplot types do not have zoombox via pan),",
          "but turned off by default for cartesian subplots.",
          "Set `scrollZoom` to *false* to disable scrolling for all subplots."
        ].join(" ")
      },
      doubleClick: {
        valType: "enumerated",
        values: [false, "reset", "autosize", "reset+autosize"],
        dflt: "reset+autosize",
        description: [
          "Sets the double click interaction mode.",
          "Has an effect only in cartesian plots.",
          "If *false*, double click is disable.",
          "If *reset*, double click resets the axis ranges to their initial values.",
          "If *autosize*, double click set the axis ranges to their autorange values.",
          "If *reset+autosize*, the odd double clicks resets the axis ranges",
          "to their initial values and even double clicks set the axis ranges",
          "to their autorange values."
        ].join(" ")
      },
      doubleClickDelay: {
        valType: "number",
        dflt: 300,
        min: 0,
        description: [
          "Sets the delay for registering a double-click in ms.",
          "This is the time interval (in ms) between first mousedown and",
          "2nd mouseup to constitute a double-click.",
          "This setting propagates to all on-subplot double clicks",
          "(except for geo, mapbox and map) and on-legend double clicks."
        ].join(" ")
      },
      showAxisDragHandles: {
        valType: "boolean",
        dflt: true,
        description: [
          "Set to *false* to omit cartesian axis pan/zoom drag handles."
        ].join(" ")
      },
      showAxisRangeEntryBoxes: {
        valType: "boolean",
        dflt: true,
        description: [
          "Set to *false* to omit direct range entry at the pan/zoom drag points,",
          "note that `showAxisDragHandles` must be enabled to have an effect."
        ].join(" ")
      },
      showTips: {
        valType: "boolean",
        dflt: true,
        description: [
          "Determines whether or not tips are shown while interacting",
          "with the resulting graphs."
        ].join(" ")
      },
      showLink: {
        valType: "boolean",
        dflt: false,
        description: [
          "Determines whether a link to Chart Studio Cloud is displayed",
          "at the bottom right corner of resulting graphs.",
          "Use with `sendData` and `linkText`."
        ].join(" ")
      },
      linkText: {
        valType: "string",
        dflt: "Edit chart",
        noBlank: true,
        description: [
          "Sets the text appearing in the `showLink` link."
        ].join(" ")
      },
      sendData: {
        valType: "boolean",
        dflt: true,
        description: [
          "If *showLink* is true, does it contain data",
          "just link to a Chart Studio Cloud file?"
        ].join(" ")
      },
      showSources: {
        valType: "any",
        dflt: false,
        description: [
          "Adds a source-displaying function to show sources on",
          "the resulting graphs."
        ].join(" ")
      },
      displayModeBar: {
        valType: "enumerated",
        values: ["hover", true, false],
        dflt: "hover",
        description: [
          "Determines the mode bar display mode.",
          "If *true*, the mode bar is always visible.",
          "If *false*, the mode bar is always hidden.",
          "If *hover*, the mode bar is visible while the mouse cursor",
          "is on the graph container."
        ].join(" ")
      },
      showSendToCloud: {
        valType: "boolean",
        dflt: false,
        description: [
          'Should we include a ModeBar button, labeled "Edit in Chart Studio",',
          "that sends this chart to chart-studio.plotly.com (formerly plot.ly) or another plotly server",
          "as specified by `plotlyServerURL` for editing, export, etc? Prior to version 1.43.0",
          "this button was included by default, now it is opt-in using this flag.",
          "Note that this button can (depending on `plotlyServerURL` being set) send your data",
          "to an external server. However that server does not persist your data",
          'until you arrive at the Chart Studio and explicitly click "Save".'
        ].join(" ")
      },
      showEditInChartStudio: {
        valType: "boolean",
        dflt: false,
        description: [
          "Same as `showSendToCloud`, but use a pencil icon instead of a floppy-disk.",
          "Note that if both `showSendToCloud` and `showEditInChartStudio` are turned,",
          "only `showEditInChartStudio` will be honored."
        ].join(" ")
      },
      modeBarButtonsToRemove: {
        valType: "any",
        dflt: [],
        description: [
          "Remove mode bar buttons by name.",
          "See ./components/modebar/buttons.js for the list of names."
        ].join(" ")
      },
      modeBarButtonsToAdd: {
        valType: "any",
        dflt: [],
        description: [
          "Add mode bar button using config objects",
          "See ./components/modebar/buttons.js for list of arguments.",
          "To enable predefined modebar buttons e.g. shape drawing, hover and spikelines,",
          "simply provide their string name(s). This could include:",
          "*v1hovermode*, *hoverclosest*, *hovercompare*, *togglehover*, *togglespikelines*,",
          "*drawline*, *drawopenpath*, *drawclosedpath*, *drawcircle*, *drawrect* and *eraseshape*.",
          "Please note that these predefined buttons will only be shown if they are compatible",
          "with all trace types used in a graph."
        ].join(" ")
      },
      modeBarButtons: {
        valType: "any",
        dflt: false,
        description: [
          "Define fully custom mode bar buttons as nested array,",
          "where the outer arrays represents button groups, and",
          "the inner arrays have buttons config objects or names of default buttons",
          "See ./components/modebar/buttons.js for more info."
        ].join(" ")
      },
      toImageButtonOptions: {
        valType: "any",
        dflt: {},
        description: [
          "Statically override options for toImage modebar button",
          "allowed keys are format, filename, width, height, scale",
          "see ../components/modebar/buttons.js"
        ].join(" ")
      },
      displaylogo: {
        valType: "boolean",
        dflt: true,
        description: [
          "Determines whether or not the plotly logo is displayed",
          "on the end of the mode bar."
        ].join(" ")
      },
      watermark: {
        valType: "boolean",
        dflt: false,
        description: "watermark the images with the company's logo"
      },
      plotGlPixelRatio: {
        valType: "number",
        dflt: 2,
        min: 1,
        max: 4,
        description: [
          "Set the pixel ratio during WebGL image export.",
          "This config option was formerly named `plot3dPixelRatio`",
          "which is now deprecated."
        ].join(" ")
      },
      setBackground: {
        valType: "any",
        dflt: "transparent",
        description: [
          "Set function to add the background color (i.e. `layout.paper_color`)",
          "to a different container.",
          "This function take the graph div as first argument and the current background",
          "color as second argument.",
          "Alternatively, set to string *opaque* to ensure there is white behind it."
        ].join(" ")
      },
      topojsonURL: {
        valType: "string",
        noBlank: true,
        dflt: "https://cdn.plot.ly/",
        description: [
          "Set the URL to topojson used in geo charts.",
          "By default, the topojson files are fetched from cdn.plot.ly.",
          "For example, set this option to:",
          "<path-to-plotly.js>/dist/topojson/",
          "to render geographical feature using the topojson files",
          "that ship with the plotly.js module."
        ].join(" ")
      },
      mapboxAccessToken: {
        valType: "string",
        dflt: null,
        description: [
          "Mapbox access token (required to plot mapbox trace types)",
          "If using an Mapbox Atlas server, set this option to ''",
          "so that plotly.js won't attempt to authenticate to the public Mapbox server."
        ].join(" ")
      },
      logging: {
        valType: "integer",
        min: 0,
        max: 2,
        dflt: 1,
        description: [
          "Turn all console logging on or off (errors will be thrown)",
          "This should ONLY be set via Plotly.setPlotConfig",
          "Available levels:",
          "0: no logs",
          "1: warnings and errors, but not informational messages",
          "2: verbose logs"
        ].join(" ")
      },
      notifyOnLogging: {
        valType: "integer",
        min: 0,
        max: 2,
        dflt: 0,
        description: [
          "Set on-graph logging (notifier) level",
          "This should ONLY be set via Plotly.setPlotConfig",
          "Available levels:",
          "0: no on-graph logs",
          "1: warnings and errors, but not informational messages",
          "2: verbose logs"
        ].join(" ")
      },
      queueLength: {
        valType: "integer",
        min: 0,
        dflt: 0,
        description: "Sets the length of the undo/redo queue."
      },
      globalTransforms: {
        valType: "any",
        dflt: [],
        description: [
          "Set global transform to be applied to all traces with no",
          "specification needed"
        ].join(" ")
      },
      locale: {
        valType: "string",
        dflt: "en-US",
        description: [
          "Which localization should we use?",
          "Should be a string like 'en' or 'en-US'."
        ].join(" ")
      },
      locales: {
        valType: "any",
        dflt: {},
        description: [
          "Localization definitions",
          "Locales can be provided either here (specific to one chart) or globally",
          "by registering them as modules.",
          "Should be an object of objects {locale: {dictionary: {...}, format: {...}}}",
          "{",
          "  da: {",
          "      dictionary: {'Reset axes': 'Nulstil aksler', ...},",
          "      format: {months: [...], shortMonths: [...]}",
          "  },",
          "  ...",
          "}",
          "All parts are optional. When looking for translation or format fields, we",
          "look first for an exact match in a config locale, then in a registered",
          "module. If those fail, we strip off any regionalization ('en-US' -> 'en')",
          "and try each (config, registry) again. The final fallback for translation",
          "is untranslated (which is US English) and for formats is the base English",
          "(the only consequence being the last fallback date format %x is DD/MM/YYYY",
          "instead of MM/DD/YYYY). Currently `grouping` and `currency` are ignored",
          "for our automatic number formatting, but can be used in custom formats."
        ].join(" ")
      }
    };
    var dfltConfig = {};
    function crawl(src, target) {
      for (var k in src) {
        var obj = src[k];
        if (obj.valType) {
          target[k] = obj.dflt;
        } else {
          if (!target[k]) {
            target[k] = {};
          }
          crawl(obj, target[k]);
        }
      }
    }
    crawl(configAttributes, dfltConfig);
    module2.exports = {
      configAttributes,
      dfltConfig
    };
  }
});

// node_modules/plotly.js/src/lib/notifier.js
var require_notifier = __commonJS({
  "node_modules/plotly.js/src/lib/notifier.js"(exports2, module2) {
    "use strict";
    var d3 = require_d3();
    var isNumeric = require_fast_isnumeric();
    var NOTEDATA = [];
    module2.exports = function(text, displayLength) {
      if (NOTEDATA.indexOf(text) !== -1) return;
      NOTEDATA.push(text);
      var ts2 = 1e3;
      if (isNumeric(displayLength)) ts2 = displayLength;
      else if (displayLength === "long") ts2 = 3e3;
      var notifierContainer = d3.select("body").selectAll(".plotly-notifier").data([0]);
      notifierContainer.enter().append("div").classed("plotly-notifier", true);
      var notes = notifierContainer.selectAll(".notifier-note").data(NOTEDATA);
      function killNote(transition) {
        transition.duration(700).style("opacity", 0).each("end", function(thisText) {
          var thisIndex = NOTEDATA.indexOf(thisText);
          if (thisIndex !== -1) NOTEDATA.splice(thisIndex, 1);
          d3.select(this).remove();
        });
      }
      notes.enter().append("div").classed("notifier-note", true).style("opacity", 0).each(function(thisText) {
        var note = d3.select(this);
        note.append("button").classed("notifier-close", true).html("&times;").on("click", function() {
          note.transition().call(killNote);
        });
        var p = note.append("p");
        var lines = thisText.split(/<br\s*\/?>/g);
        for (var i = 0; i < lines.length; i++) {
          if (i) p.append("br");
          p.append("span").text(lines[i]);
        }
        if (displayLength === "stick") {
          note.transition().duration(350).style("opacity", 1);
        } else {
          note.transition().duration(700).style("opacity", 1).transition().delay(ts2).call(killNote);
        }
      });
    };
  }
});

// node_modules/plotly.js/src/lib/loggers.js
var require_loggers = __commonJS({
  "node_modules/plotly.js/src/lib/loggers.js"(exports2, module2) {
    "use strict";
    var dfltConfig = require_plot_config().dfltConfig;
    var notifier = require_notifier();
    var loggers = module2.exports = {};
    loggers.log = function() {
      var i;
      if (dfltConfig.logging > 1) {
        var messages = ["LOG:"];
        for (i = 0; i < arguments.length; i++) {
          messages.push(arguments[i]);
        }
        console.trace.apply(console, messages);
      }
      if (dfltConfig.notifyOnLogging > 1) {
        var lines = [];
        for (i = 0; i < arguments.length; i++) {
          lines.push(arguments[i]);
        }
        notifier(lines.join("<br>"), "long");
      }
    };
    loggers.warn = function() {
      var i;
      if (dfltConfig.logging > 0) {
        var messages = ["WARN:"];
        for (i = 0; i < arguments.length; i++) {
          messages.push(arguments[i]);
        }
        console.trace.apply(console, messages);
      }
      if (dfltConfig.notifyOnLogging > 0) {
        var lines = [];
        for (i = 0; i < arguments.length; i++) {
          lines.push(arguments[i]);
        }
        notifier(lines.join("<br>"), "stick");
      }
    };
    loggers.error = function() {
      var i;
      if (dfltConfig.logging > 0) {
        var messages = ["ERROR:"];
        for (i = 0; i < arguments.length; i++) {
          messages.push(arguments[i]);
        }
        console.error.apply(console, messages);
      }
      if (dfltConfig.notifyOnLogging > 0) {
        var lines = [];
        for (i = 0; i < arguments.length; i++) {
          lines.push(arguments[i]);
        }
        notifier(lines.join("<br>"), "stick");
      }
    };
  }
});

// node_modules/plotly.js/src/lib/noop.js
var require_noop = __commonJS({
  "node_modules/plotly.js/src/lib/noop.js"(exports2, module2) {
    "use strict";
    module2.exports = function noop() {
    };
  }
});

// node_modules/plotly.js/src/lib/push_unique.js
var require_push_unique = __commonJS({
  "node_modules/plotly.js/src/lib/push_unique.js"(exports2, module2) {
    "use strict";
    module2.exports = function pushUnique(array, item) {
      if (item instanceof RegExp) {
        var itemStr = item.toString();
        for (var i = 0; i < array.length; i++) {
          if (array[i] instanceof RegExp && array[i].toString() === itemStr) {
            return array;
          }
        }
        array.push(item);
      } else if ((item || item === 0) && array.indexOf(item) === -1) array.push(item);
      return array;
    };
  }
});

// node_modules/gl-mat4/create.js
var require_create = __commonJS({
  "node_modules/gl-mat4/create.js"(exports2, module2) {
    module2.exports = create;
    function create() {
      var out = new Float32Array(16);
      out[0] = 1;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[4] = 0;
      out[5] = 1;
      out[6] = 0;
      out[7] = 0;
      out[8] = 0;
      out[9] = 0;
      out[10] = 1;
      out[11] = 0;
      out[12] = 0;
      out[13] = 0;
      out[14] = 0;
      out[15] = 1;
      return out;
    }
  }
});

// node_modules/gl-mat4/clone.js
var require_clone = __commonJS({
  "node_modules/gl-mat4/clone.js"(exports2, module2) {
    module2.exports = clone;
    function clone(a) {
      var out = new Float32Array(16);
      out[0] = a[0];
      out[1] = a[1];
      out[2] = a[2];
      out[3] = a[3];
      out[4] = a[4];
      out[5] = a[5];
      out[6] = a[6];
      out[7] = a[7];
      out[8] = a[8];
      out[9] = a[9];
      out[10] = a[10];
      out[11] = a[11];
      out[12] = a[12];
      out[13] = a[13];
      out[14] = a[14];
      out[15] = a[15];
      return out;
    }
  }
});

// node_modules/gl-mat4/copy.js
var require_copy = __commonJS({
  "node_modules/gl-mat4/copy.js"(exports2, module2) {
    module2.exports = copy;
    function copy(out, a) {
      out[0] = a[0];
      out[1] = a[1];
      out[2] = a[2];
      out[3] = a[3];
      out[4] = a[4];
      out[5] = a[5];
      out[6] = a[6];
      out[7] = a[7];
      out[8] = a[8];
      out[9] = a[9];
      out[10] = a[10];
      out[11] = a[11];
      out[12] = a[12];
      out[13] = a[13];
      out[14] = a[14];
      out[15] = a[15];
      return out;
    }
  }
});

// node_modules/gl-mat4/identity.js
var require_identity = __commonJS({
  "node_modules/gl-mat4/identity.js"(exports2, module2) {
    module2.exports = identity;
    function identity(out) {
      out[0] = 1;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[4] = 0;
      out[5] = 1;
      out[6] = 0;
      out[7] = 0;
      out[8] = 0;
      out[9] = 0;
      out[10] = 1;
      out[11] = 0;
      out[12] = 0;
      out[13] = 0;
      out[14] = 0;
      out[15] = 1;
      return out;
    }
  }
});

// node_modules/gl-mat4/transpose.js
var require_transpose = __commonJS({
  "node_modules/gl-mat4/transpose.js"(exports2, module2) {
    module2.exports = transpose;
    function transpose(out, a) {
      if (out === a) {
        var a01 = a[1], a02 = a[2], a03 = a[3], a12 = a[6], a13 = a[7], a23 = a[11];
        out[1] = a[4];
        out[2] = a[8];
        out[3] = a[12];
        out[4] = a01;
        out[6] = a[9];
        out[7] = a[13];
        out[8] = a02;
        out[9] = a12;
        out[11] = a[14];
        out[12] = a03;
        out[13] = a13;
        out[14] = a23;
      } else {
        out[0] = a[0];
        out[1] = a[4];
        out[2] = a[8];
        out[3] = a[12];
        out[4] = a[1];
        out[5] = a[5];
        out[6] = a[9];
        out[7] = a[13];
        out[8] = a[2];
        out[9] = a[6];
        out[10] = a[10];
        out[11] = a[14];
        out[12] = a[3];
        out[13] = a[7];
        out[14] = a[11];
        out[15] = a[15];
      }
      return out;
    }
  }
});

// node_modules/gl-mat4/invert.js
var require_invert = __commonJS({
  "node_modules/gl-mat4/invert.js"(exports2, module2) {
    module2.exports = invert;
    function invert(out, a) {
      var a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3], a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7], a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11], a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15], b00 = a00 * a11 - a01 * a10, b01 = a00 * a12 - a02 * a10, b02 = a00 * a13 - a03 * a10, b03 = a01 * a12 - a02 * a11, b04 = a01 * a13 - a03 * a11, b05 = a02 * a13 - a03 * a12, b06 = a20 * a31 - a21 * a30, b07 = a20 * a32 - a22 * a30, b08 = a20 * a33 - a23 * a30, b09 = a21 * a32 - a22 * a31, b10 = a21 * a33 - a23 * a31, b11 = a22 * a33 - a23 * a32, det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
      if (!det) {
        return null;
      }
      det = 1 / det;
      out[0] = (a11 * b11 - a12 * b10 + a13 * b09) * det;
      out[1] = (a02 * b10 - a01 * b11 - a03 * b09) * det;
      out[2] = (a31 * b05 - a32 * b04 + a33 * b03) * det;
      out[3] = (a22 * b04 - a21 * b05 - a23 * b03) * det;
      out[4] = (a12 * b08 - a10 * b11 - a13 * b07) * det;
      out[5] = (a00 * b11 - a02 * b08 + a03 * b07) * det;
      out[6] = (a32 * b02 - a30 * b05 - a33 * b01) * det;
      out[7] = (a20 * b05 - a22 * b02 + a23 * b01) * det;
      out[8] = (a10 * b10 - a11 * b08 + a13 * b06) * det;
      out[9] = (a01 * b08 - a00 * b10 - a03 * b06) * det;
      out[10] = (a30 * b04 - a31 * b02 + a33 * b00) * det;
      out[11] = (a21 * b02 - a20 * b04 - a23 * b00) * det;
      out[12] = (a11 * b07 - a10 * b09 - a12 * b06) * det;
      out[13] = (a00 * b09 - a01 * b07 + a02 * b06) * det;
      out[14] = (a31 * b01 - a30 * b03 - a32 * b00) * det;
      out[15] = (a20 * b03 - a21 * b01 + a22 * b00) * det;
      return out;
    }
  }
});

// node_modules/gl-mat4/adjoint.js
var require_adjoint = __commonJS({
  "node_modules/gl-mat4/adjoint.js"(exports2, module2) {
    module2.exports = adjoint;
    function adjoint(out, a) {
      var a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3], a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7], a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11], a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15];
      out[0] = a11 * (a22 * a33 - a23 * a32) - a21 * (a12 * a33 - a13 * a32) + a31 * (a12 * a23 - a13 * a22);
      out[1] = -(a01 * (a22 * a33 - a23 * a32) - a21 * (a02 * a33 - a03 * a32) + a31 * (a02 * a23 - a03 * a22));
      out[2] = a01 * (a12 * a33 - a13 * a32) - a11 * (a02 * a33 - a03 * a32) + a31 * (a02 * a13 - a03 * a12);
      out[3] = -(a01 * (a12 * a23 - a13 * a22) - a11 * (a02 * a23 - a03 * a22) + a21 * (a02 * a13 - a03 * a12));
      out[4] = -(a10 * (a22 * a33 - a23 * a32) - a20 * (a12 * a33 - a13 * a32) + a30 * (a12 * a23 - a13 * a22));
      out[5] = a00 * (a22 * a33 - a23 * a32) - a20 * (a02 * a33 - a03 * a32) + a30 * (a02 * a23 - a03 * a22);
      out[6] = -(a00 * (a12 * a33 - a13 * a32) - a10 * (a02 * a33 - a03 * a32) + a30 * (a02 * a13 - a03 * a12));
      out[7] = a00 * (a12 * a23 - a13 * a22) - a10 * (a02 * a23 - a03 * a22) + a20 * (a02 * a13 - a03 * a12);
      out[8] = a10 * (a21 * a33 - a23 * a31) - a20 * (a11 * a33 - a13 * a31) + a30 * (a11 * a23 - a13 * a21);
      out[9] = -(a00 * (a21 * a33 - a23 * a31) - a20 * (a01 * a33 - a03 * a31) + a30 * (a01 * a23 - a03 * a21));
      out[10] = a00 * (a11 * a33 - a13 * a31) - a10 * (a01 * a33 - a03 * a31) + a30 * (a01 * a13 - a03 * a11);
      out[11] = -(a00 * (a11 * a23 - a13 * a21) - a10 * (a01 * a23 - a03 * a21) + a20 * (a01 * a13 - a03 * a11));
      out[12] = -(a10 * (a21 * a32 - a22 * a31) - a20 * (a11 * a32 - a12 * a31) + a30 * (a11 * a22 - a12 * a21));
      out[13] = a00 * (a21 * a32 - a22 * a31) - a20 * (a01 * a32 - a02 * a31) + a30 * (a01 * a22 - a02 * a21);
      out[14] = -(a00 * (a11 * a32 - a12 * a31) - a10 * (a01 * a32 - a02 * a31) + a30 * (a01 * a12 - a02 * a11));
      out[15] = a00 * (a11 * a22 - a12 * a21) - a10 * (a01 * a22 - a02 * a21) + a20 * (a01 * a12 - a02 * a11);
      return out;
    }
  }
});

// node_modules/gl-mat4/determinant.js
var require_determinant = __commonJS({
  "node_modules/gl-mat4/determinant.js"(exports2, module2) {
    module2.exports = determinant;
    function determinant(a) {
      var a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3], a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7], a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11], a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15], b00 = a00 * a11 - a01 * a10, b01 = a00 * a12 - a02 * a10, b02 = a00 * a13 - a03 * a10, b03 = a01 * a12 - a02 * a11, b04 = a01 * a13 - a03 * a11, b05 = a02 * a13 - a03 * a12, b06 = a20 * a31 - a21 * a30, b07 = a20 * a32 - a22 * a30, b08 = a20 * a33 - a23 * a30, b09 = a21 * a32 - a22 * a31, b10 = a21 * a33 - a23 * a31, b11 = a22 * a33 - a23 * a32;
      return b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
    }
  }
});

// node_modules/gl-mat4/multiply.js
var require_multiply = __commonJS({
  "node_modules/gl-mat4/multiply.js"(exports2, module2) {
    module2.exports = multiply;
    function multiply(out, a, b) {
      var a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3], a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7], a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11], a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15];
      var b02 = b[0], b12 = b[1], b2 = b[2], b3 = b[3];
      out[0] = b02 * a00 + b12 * a10 + b2 * a20 + b3 * a30;
      out[1] = b02 * a01 + b12 * a11 + b2 * a21 + b3 * a31;
      out[2] = b02 * a02 + b12 * a12 + b2 * a22 + b3 * a32;
      out[3] = b02 * a03 + b12 * a13 + b2 * a23 + b3 * a33;
      b02 = b[4];
      b12 = b[5];
      b2 = b[6];
      b3 = b[7];
      out[4] = b02 * a00 + b12 * a10 + b2 * a20 + b3 * a30;
      out[5] = b02 * a01 + b12 * a11 + b2 * a21 + b3 * a31;
      out[6] = b02 * a02 + b12 * a12 + b2 * a22 + b3 * a32;
      out[7] = b02 * a03 + b12 * a13 + b2 * a23 + b3 * a33;
      b02 = b[8];
      b12 = b[9];
      b2 = b[10];
      b3 = b[11];
      out[8] = b02 * a00 + b12 * a10 + b2 * a20 + b3 * a30;
      out[9] = b02 * a01 + b12 * a11 + b2 * a21 + b3 * a31;
      out[10] = b02 * a02 + b12 * a12 + b2 * a22 + b3 * a32;
      out[11] = b02 * a03 + b12 * a13 + b2 * a23 + b3 * a33;
      b02 = b[12];
      b12 = b[13];
      b2 = b[14];
      b3 = b[15];
      out[12] = b02 * a00 + b12 * a10 + b2 * a20 + b3 * a30;
      out[13] = b02 * a01 + b12 * a11 + b2 * a21 + b3 * a31;
      out[14] = b02 * a02 + b12 * a12 + b2 * a22 + b3 * a32;
      out[15] = b02 * a03 + b12 * a13 + b2 * a23 + b3 * a33;
      return out;
    }
  }
});

// node_modules/gl-mat4/translate.js
var require_translate = __commonJS({
  "node_modules/gl-mat4/translate.js"(exports2, module2) {
    module2.exports = translate;
    function translate(out, a, v) {
      var x = v[0], y = v[1], z2 = v[2], a00, a01, a02, a03, a10, a11, a12, a13, a20, a21, a22, a23;
      if (a === out) {
        out[12] = a[0] * x + a[4] * y + a[8] * z2 + a[12];
        out[13] = a[1] * x + a[5] * y + a[9] * z2 + a[13];
        out[14] = a[2] * x + a[6] * y + a[10] * z2 + a[14];
        out[15] = a[3] * x + a[7] * y + a[11] * z2 + a[15];
      } else {
        a00 = a[0];
        a01 = a[1];
        a02 = a[2];
        a03 = a[3];
        a10 = a[4];
        a11 = a[5];
        a12 = a[6];
        a13 = a[7];
        a20 = a[8];
        a21 = a[9];
        a22 = a[10];
        a23 = a[11];
        out[0] = a00;
        out[1] = a01;
        out[2] = a02;
        out[3] = a03;
        out[4] = a10;
        out[5] = a11;
        out[6] = a12;
        out[7] = a13;
        out[8] = a20;
        out[9] = a21;
        out[10] = a22;
        out[11] = a23;
        out[12] = a00 * x + a10 * y + a20 * z2 + a[12];
        out[13] = a01 * x + a11 * y + a21 * z2 + a[13];
        out[14] = a02 * x + a12 * y + a22 * z2 + a[14];
        out[15] = a03 * x + a13 * y + a23 * z2 + a[15];
      }
      return out;
    }
  }
});

// node_modules/gl-mat4/scale.js
var require_scale = __commonJS({
  "node_modules/gl-mat4/scale.js"(exports2, module2) {
    module2.exports = scale;
    function scale(out, a, v) {
      var x = v[0], y = v[1], z2 = v[2];
      out[0] = a[0] * x;
      out[1] = a[1] * x;
      out[2] = a[2] * x;
      out[3] = a[3] * x;
      out[4] = a[4] * y;
      out[5] = a[5] * y;
      out[6] = a[6] * y;
      out[7] = a[7] * y;
      out[8] = a[8] * z2;
      out[9] = a[9] * z2;
      out[10] = a[10] * z2;
      out[11] = a[11] * z2;
      out[12] = a[12];
      out[13] = a[13];
      out[14] = a[14];
      out[15] = a[15];
      return out;
    }
  }
});

// node_modules/gl-mat4/rotate.js
var require_rotate = __commonJS({
  "node_modules/gl-mat4/rotate.js"(exports2, module2) {
    module2.exports = rotate;
    function rotate(out, a, rad, axis) {
      var x = axis[0], y = axis[1], z2 = axis[2], len = Math.sqrt(x * x + y * y + z2 * z2), s, c, t, a00, a01, a02, a03, a10, a11, a12, a13, a20, a21, a22, a23, b00, b01, b02, b10, b11, b12, b20, b21, b22;
      if (Math.abs(len) < 1e-6) {
        return null;
      }
      len = 1 / len;
      x *= len;
      y *= len;
      z2 *= len;
      s = Math.sin(rad);
      c = Math.cos(rad);
      t = 1 - c;
      a00 = a[0];
      a01 = a[1];
      a02 = a[2];
      a03 = a[3];
      a10 = a[4];
      a11 = a[5];
      a12 = a[6];
      a13 = a[7];
      a20 = a[8];
      a21 = a[9];
      a22 = a[10];
      a23 = a[11];
      b00 = x * x * t + c;
      b01 = y * x * t + z2 * s;
      b02 = z2 * x * t - y * s;
      b10 = x * y * t - z2 * s;
      b11 = y * y * t + c;
      b12 = z2 * y * t + x * s;
      b20 = x * z2 * t + y * s;
      b21 = y * z2 * t - x * s;
      b22 = z2 * z2 * t + c;
      out[0] = a00 * b00 + a10 * b01 + a20 * b02;
      out[1] = a01 * b00 + a11 * b01 + a21 * b02;
      out[2] = a02 * b00 + a12 * b01 + a22 * b02;
      out[3] = a03 * b00 + a13 * b01 + a23 * b02;
      out[4] = a00 * b10 + a10 * b11 + a20 * b12;
      out[5] = a01 * b10 + a11 * b11 + a21 * b12;
      out[6] = a02 * b10 + a12 * b11 + a22 * b12;
      out[7] = a03 * b10 + a13 * b11 + a23 * b12;
      out[8] = a00 * b20 + a10 * b21 + a20 * b22;
      out[9] = a01 * b20 + a11 * b21 + a21 * b22;
      out[10] = a02 * b20 + a12 * b21 + a22 * b22;
      out[11] = a03 * b20 + a13 * b21 + a23 * b22;
      if (a !== out) {
        out[12] = a[12];
        out[13] = a[13];
        out[14] = a[14];
        out[15] = a[15];
      }
      return out;
    }
  }
});

// node_modules/gl-mat4/rotateX.js
var require_rotateX = __commonJS({
  "node_modules/gl-mat4/rotateX.js"(exports2, module2) {
    module2.exports = rotateX;
    function rotateX(out, a, rad) {
      var s = Math.sin(rad), c = Math.cos(rad), a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7], a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11];
      if (a !== out) {
        out[0] = a[0];
        out[1] = a[1];
        out[2] = a[2];
        out[3] = a[3];
        out[12] = a[12];
        out[13] = a[13];
        out[14] = a[14];
        out[15] = a[15];
      }
      out[4] = a10 * c + a20 * s;
      out[5] = a11 * c + a21 * s;
      out[6] = a12 * c + a22 * s;
      out[7] = a13 * c + a23 * s;
      out[8] = a20 * c - a10 * s;
      out[9] = a21 * c - a11 * s;
      out[10] = a22 * c - a12 * s;
      out[11] = a23 * c - a13 * s;
      return out;
    }
  }
});

// node_modules/gl-mat4/rotateY.js
var require_rotateY = __commonJS({
  "node_modules/gl-mat4/rotateY.js"(exports2, module2) {
    module2.exports = rotateY;
    function rotateY(out, a, rad) {
      var s = Math.sin(rad), c = Math.cos(rad), a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3], a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11];
      if (a !== out) {
        out[4] = a[4];
        out[5] = a[5];
        out[6] = a[6];
        out[7] = a[7];
        out[12] = a[12];
        out[13] = a[13];
        out[14] = a[14];
        out[15] = a[15];
      }
      out[0] = a00 * c - a20 * s;
      out[1] = a01 * c - a21 * s;
      out[2] = a02 * c - a22 * s;
      out[3] = a03 * c - a23 * s;
      out[8] = a00 * s + a20 * c;
      out[9] = a01 * s + a21 * c;
      out[10] = a02 * s + a22 * c;
      out[11] = a03 * s + a23 * c;
      return out;
    }
  }
});

// node_modules/gl-mat4/rotateZ.js
var require_rotateZ = __commonJS({
  "node_modules/gl-mat4/rotateZ.js"(exports2, module2) {
    module2.exports = rotateZ;
    function rotateZ(out, a, rad) {
      var s = Math.sin(rad), c = Math.cos(rad), a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3], a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7];
      if (a !== out) {
        out[8] = a[8];
        out[9] = a[9];
        out[10] = a[10];
        out[11] = a[11];
        out[12] = a[12];
        out[13] = a[13];
        out[14] = a[14];
        out[15] = a[15];
      }
      out[0] = a00 * c + a10 * s;
      out[1] = a01 * c + a11 * s;
      out[2] = a02 * c + a12 * s;
      out[3] = a03 * c + a13 * s;
      out[4] = a10 * c - a00 * s;
      out[5] = a11 * c - a01 * s;
      out[6] = a12 * c - a02 * s;
      out[7] = a13 * c - a03 * s;
      return out;
    }
  }
});

// node_modules/gl-mat4/fromRotation.js
var require_fromRotation = __commonJS({
  "node_modules/gl-mat4/fromRotation.js"(exports2, module2) {
    module2.exports = fromRotation;
    function fromRotation(out, rad, axis) {
      var s, c, t;
      var x = axis[0];
      var y = axis[1];
      var z2 = axis[2];
      var len = Math.sqrt(x * x + y * y + z2 * z2);
      if (Math.abs(len) < 1e-6) {
        return null;
      }
      len = 1 / len;
      x *= len;
      y *= len;
      z2 *= len;
      s = Math.sin(rad);
      c = Math.cos(rad);
      t = 1 - c;
      out[0] = x * x * t + c;
      out[1] = y * x * t + z2 * s;
      out[2] = z2 * x * t - y * s;
      out[3] = 0;
      out[4] = x * y * t - z2 * s;
      out[5] = y * y * t + c;
      out[6] = z2 * y * t + x * s;
      out[7] = 0;
      out[8] = x * z2 * t + y * s;
      out[9] = y * z2 * t - x * s;
      out[10] = z2 * z2 * t + c;
      out[11] = 0;
      out[12] = 0;
      out[13] = 0;
      out[14] = 0;
      out[15] = 1;
      return out;
    }
  }
});

// node_modules/gl-mat4/fromRotationTranslation.js
var require_fromRotationTranslation = __commonJS({
  "node_modules/gl-mat4/fromRotationTranslation.js"(exports2, module2) {
    module2.exports = fromRotationTranslation;
    function fromRotationTranslation(out, q, v) {
      var x = q[0], y = q[1], z2 = q[2], w = q[3], x2 = x + x, y2 = y + y, z22 = z2 + z2, xx = x * x2, xy = x * y2, xz = x * z22, yy = y * y2, yz = y * z22, zz = z2 * z22, wx = w * x2, wy = w * y2, wz = w * z22;
      out[0] = 1 - (yy + zz);
      out[1] = xy + wz;
      out[2] = xz - wy;
      out[3] = 0;
      out[4] = xy - wz;
      out[5] = 1 - (xx + zz);
      out[6] = yz + wx;
      out[7] = 0;
      out[8] = xz + wy;
      out[9] = yz - wx;
      out[10] = 1 - (xx + yy);
      out[11] = 0;
      out[12] = v[0];
      out[13] = v[1];
      out[14] = v[2];
      out[15] = 1;
      return out;
    }
  }
});

// node_modules/gl-mat4/fromScaling.js
var require_fromScaling = __commonJS({
  "node_modules/gl-mat4/fromScaling.js"(exports2, module2) {
    module2.exports = fromScaling;
    function fromScaling(out, v) {
      out[0] = v[0];
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[4] = 0;
      out[5] = v[1];
      out[6] = 0;
      out[7] = 0;
      out[8] = 0;
      out[9] = 0;
      out[10] = v[2];
      out[11] = 0;
      out[12] = 0;
      out[13] = 0;
      out[14] = 0;
      out[15] = 1;
      return out;
    }
  }
});

// node_modules/gl-mat4/fromTranslation.js
var require_fromTranslation = __commonJS({
  "node_modules/gl-mat4/fromTranslation.js"(exports2, module2) {
    module2.exports = fromTranslation;
    function fromTranslation(out, v) {
      out[0] = 1;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[4] = 0;
      out[5] = 1;
      out[6] = 0;
      out[7] = 0;
      out[8] = 0;
      out[9] = 0;
      out[10] = 1;
      out[11] = 0;
      out[12] = v[0];
      out[13] = v[1];
      out[14] = v[2];
      out[15] = 1;
      return out;
    }
  }
});

// node_modules/gl-mat4/fromXRotation.js
var require_fromXRotation = __commonJS({
  "node_modules/gl-mat4/fromXRotation.js"(exports2, module2) {
    module2.exports = fromXRotation;
    function fromXRotation(out, rad) {
      var s = Math.sin(rad), c = Math.cos(rad);
      out[0] = 1;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[4] = 0;
      out[5] = c;
      out[6] = s;
      out[7] = 0;
      out[8] = 0;
      out[9] = -s;
      out[10] = c;
      out[11] = 0;
      out[12] = 0;
      out[13] = 0;
      out[14] = 0;
      out[15] = 1;
      return out;
    }
  }
});

// node_modules/gl-mat4/fromYRotation.js
var require_fromYRotation = __commonJS({
  "node_modules/gl-mat4/fromYRotation.js"(exports2, module2) {
    module2.exports = fromYRotation;
    function fromYRotation(out, rad) {
      var s = Math.sin(rad), c = Math.cos(rad);
      out[0] = c;
      out[1] = 0;
      out[2] = -s;
      out[3] = 0;
      out[4] = 0;
      out[5] = 1;
      out[6] = 0;
      out[7] = 0;
      out[8] = s;
      out[9] = 0;
      out[10] = c;
      out[11] = 0;
      out[12] = 0;
      out[13] = 0;
      out[14] = 0;
      out[15] = 1;
      return out;
    }
  }
});

// node_modules/gl-mat4/fromZRotation.js
var require_fromZRotation = __commonJS({
  "node_modules/gl-mat4/fromZRotation.js"(exports2, module2) {
    module2.exports = fromZRotation;
    function fromZRotation(out, rad) {
      var s = Math.sin(rad), c = Math.cos(rad);
      out[0] = c;
      out[1] = s;
      out[2] = 0;
      out[3] = 0;
      out[4] = -s;
      out[5] = c;
      out[6] = 0;
      out[7] = 0;
      out[8] = 0;
      out[9] = 0;
      out[10] = 1;
      out[11] = 0;
      out[12] = 0;
      out[13] = 0;
      out[14] = 0;
      out[15] = 1;
      return out;
    }
  }
});

// node_modules/gl-mat4/fromQuat.js
var require_fromQuat = __commonJS({
  "node_modules/gl-mat4/fromQuat.js"(exports2, module2) {
    module2.exports = fromQuat;
    function fromQuat(out, q) {
      var x = q[0], y = q[1], z2 = q[2], w = q[3], x2 = x + x, y2 = y + y, z22 = z2 + z2, xx = x * x2, yx = y * x2, yy = y * y2, zx = z2 * x2, zy = z2 * y2, zz = z2 * z22, wx = w * x2, wy = w * y2, wz = w * z22;
      out[0] = 1 - yy - zz;
      out[1] = yx + wz;
      out[2] = zx - wy;
      out[3] = 0;
      out[4] = yx - wz;
      out[5] = 1 - xx - zz;
      out[6] = zy + wx;
      out[7] = 0;
      out[8] = zx + wy;
      out[9] = zy - wx;
      out[10] = 1 - xx - yy;
      out[11] = 0;
      out[12] = 0;
      out[13] = 0;
      out[14] = 0;
      out[15] = 1;
      return out;
    }
  }
});

// node_modules/gl-mat4/frustum.js
var require_frustum = __commonJS({
  "node_modules/gl-mat4/frustum.js"(exports2, module2) {
    module2.exports = frustum;
    function frustum(out, left, right, bottom, top, near, far) {
      var rl = 1 / (right - left), tb = 1 / (top - bottom), nf2 = 1 / (near - far);
      out[0] = near * 2 * rl;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[4] = 0;
      out[5] = near * 2 * tb;
      out[6] = 0;
      out[7] = 0;
      out[8] = (right + left) * rl;
      out[9] = (top + bottom) * tb;
      out[10] = (far + near) * nf2;
      out[11] = -1;
      out[12] = 0;
      out[13] = 0;
      out[14] = far * near * 2 * nf2;
      out[15] = 0;
      return out;
    }
  }
});

// node_modules/gl-mat4/perspective.js
var require_perspective = __commonJS({
  "node_modules/gl-mat4/perspective.js"(exports2, module2) {
    module2.exports = perspective;
    function perspective(out, fovy, aspect, near, far) {
      var f = 1 / Math.tan(fovy / 2), nf2 = 1 / (near - far);
      out[0] = f / aspect;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[4] = 0;
      out[5] = f;
      out[6] = 0;
      out[7] = 0;
      out[8] = 0;
      out[9] = 0;
      out[10] = (far + near) * nf2;
      out[11] = -1;
      out[12] = 0;
      out[13] = 0;
      out[14] = 2 * far * near * nf2;
      out[15] = 0;
      return out;
    }
  }
});

// node_modules/gl-mat4/perspectiveFromFieldOfView.js
var require_perspectiveFromFieldOfView = __commonJS({
  "node_modules/gl-mat4/perspectiveFromFieldOfView.js"(exports2, module2) {
    module2.exports = perspectiveFromFieldOfView;
    function perspectiveFromFieldOfView(out, fov, near, far) {
      var upTan = Math.tan(fov.upDegrees * Math.PI / 180), downTan = Math.tan(fov.downDegrees * Math.PI / 180), leftTan = Math.tan(fov.leftDegrees * Math.PI / 180), rightTan = Math.tan(fov.rightDegrees * Math.PI / 180), xScale = 2 / (leftTan + rightTan), yScale = 2 / (upTan + downTan);
      out[0] = xScale;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[4] = 0;
      out[5] = yScale;
      out[6] = 0;
      out[7] = 0;
      out[8] = -((leftTan - rightTan) * xScale * 0.5);
      out[9] = (upTan - downTan) * yScale * 0.5;
      out[10] = far / (near - far);
      out[11] = -1;
      out[12] = 0;
      out[13] = 0;
      out[14] = far * near / (near - far);
      out[15] = 0;
      return out;
    }
  }
});

// node_modules/gl-mat4/ortho.js
var require_ortho = __commonJS({
  "node_modules/gl-mat4/ortho.js"(exports2, module2) {
    module2.exports = ortho;
    function ortho(out, left, right, bottom, top, near, far) {
      var lr2 = 1 / (left - right), bt = 1 / (bottom - top), nf2 = 1 / (near - far);
      out[0] = -2 * lr2;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[4] = 0;
      out[5] = -2 * bt;
      out[6] = 0;
      out[7] = 0;
      out[8] = 0;
      out[9] = 0;
      out[10] = 2 * nf2;
      out[11] = 0;
      out[12] = (left + right) * lr2;
      out[13] = (top + bottom) * bt;
      out[14] = (far + near) * nf2;
      out[15] = 1;
      return out;
    }
  }
});

// node_modules/gl-mat4/lookAt.js
var require_lookAt = __commonJS({
  "node_modules/gl-mat4/lookAt.js"(exports2, module2) {
    var identity = require_identity();
    module2.exports = lookAt;
    function lookAt(out, eye, center, up2) {
      var x02, x12, x2, y02, y12, y2, z02, z1, z2, len, eyex = eye[0], eyey = eye[1], eyez = eye[2], upx = up2[0], upy = up2[1], upz = up2[2], centerx = center[0], centery = center[1], centerz = center[2];
      if (Math.abs(eyex - centerx) < 1e-6 && Math.abs(eyey - centery) < 1e-6 && Math.abs(eyez - centerz) < 1e-6) {
        return identity(out);
      }
      z02 = eyex - centerx;
      z1 = eyey - centery;
      z2 = eyez - centerz;
      len = 1 / Math.sqrt(z02 * z02 + z1 * z1 + z2 * z2);
      z02 *= len;
      z1 *= len;
      z2 *= len;
      x02 = upy * z2 - upz * z1;
      x12 = upz * z02 - upx * z2;
      x2 = upx * z1 - upy * z02;
      len = Math.sqrt(x02 * x02 + x12 * x12 + x2 * x2);
      if (!len) {
        x02 = 0;
        x12 = 0;
        x2 = 0;
      } else {
        len = 1 / len;
        x02 *= len;
        x12 *= len;
        x2 *= len;
      }
      y02 = z1 * x2 - z2 * x12;
      y12 = z2 * x02 - z02 * x2;
      y2 = z02 * x12 - z1 * x02;
      len = Math.sqrt(y02 * y02 + y12 * y12 + y2 * y2);
      if (!len) {
        y02 = 0;
        y12 = 0;
        y2 = 0;
      } else {
        len = 1 / len;
        y02 *= len;
        y12 *= len;
        y2 *= len;
      }
      out[0] = x02;
      out[1] = y02;
      out[2] = z02;
      out[3] = 0;
      out[4] = x12;
      out[5] = y12;
      out[6] = z1;
      out[7] = 0;
      out[8] = x2;
      out[9] = y2;
      out[10] = z2;
      out[11] = 0;
      out[12] = -(x02 * eyex + x12 * eyey + x2 * eyez);
      out[13] = -(y02 * eyex + y12 * eyey + y2 * eyez);
      out[14] = -(z02 * eyex + z1 * eyey + z2 * eyez);
      out[15] = 1;
      return out;
    }
  }
});

// node_modules/gl-mat4/str.js
var require_str = __commonJS({
  "node_modules/gl-mat4/str.js"(exports2, module2) {
    module2.exports = str;
    function str(a) {
      return "mat4(" + a[0] + ", " + a[1] + ", " + a[2] + ", " + a[3] + ", " + a[4] + ", " + a[5] + ", " + a[6] + ", " + a[7] + ", " + a[8] + ", " + a[9] + ", " + a[10] + ", " + a[11] + ", " + a[12] + ", " + a[13] + ", " + a[14] + ", " + a[15] + ")";
    }
  }
});

// node_modules/gl-mat4/index.js
var require_gl_mat4 = __commonJS({
  "node_modules/gl-mat4/index.js"(exports2, module2) {
    module2.exports = {
      create: require_create(),
      clone: require_clone(),
      copy: require_copy(),
      identity: require_identity(),
      transpose: require_transpose(),
      invert: require_invert(),
      adjoint: require_adjoint(),
      determinant: require_determinant(),
      multiply: require_multiply(),
      translate: require_translate(),
      scale: require_scale(),
      rotate: require_rotate(),
      rotateX: require_rotateX(),
      rotateY: require_rotateY(),
      rotateZ: require_rotateZ(),
      fromRotation: require_fromRotation(),
      fromRotationTranslation: require_fromRotationTranslation(),
      fromScaling: require_fromScaling(),
      fromTranslation: require_fromTranslation(),
      fromXRotation: require_fromXRotation(),
      fromYRotation: require_fromYRotation(),
      fromZRotation: require_fromZRotation(),
      fromQuat: require_fromQuat(),
      frustum: require_frustum(),
      perspective: require_perspective(),
      perspectiveFromFieldOfView: require_perspectiveFromFieldOfView(),
      ortho: require_ortho(),
      lookAt: require_lookAt(),
      str: require_str()
    };
  }
});

// node_modules/plotly.js/src/lib/matrix.js
var require_matrix = __commonJS({
  "node_modules/plotly.js/src/lib/matrix.js"(exports2) {
    "use strict";
    var mat4X4 = require_gl_mat4();
    exports2.init2dArray = function(rowLength, colLength) {
      var array = new Array(rowLength);
      for (var i = 0; i < rowLength; i++) array[i] = new Array(colLength);
      return array;
    };
    exports2.transposeRagged = function(z2) {
      var maxlen = 0;
      var zlen = z2.length;
      var i, j;
      for (i = 0; i < zlen; i++) maxlen = Math.max(maxlen, z2[i].length);
      var t = new Array(maxlen);
      for (i = 0; i < maxlen; i++) {
        t[i] = new Array(zlen);
        for (j = 0; j < zlen; j++) t[i][j] = z2[j][i];
      }
      return t;
    };
    exports2.dot = function(x, y) {
      if (!(x.length && y.length) || x.length !== y.length) return null;
      var len = x.length;
      var out;
      var i;
      if (x[0].length) {
        out = new Array(len);
        for (i = 0; i < len; i++) out[i] = exports2.dot(x[i], y);
      } else if (y[0].length) {
        var yTranspose = exports2.transposeRagged(y);
        out = new Array(yTranspose.length);
        for (i = 0; i < yTranspose.length; i++) out[i] = exports2.dot(x, yTranspose[i]);
      } else {
        out = 0;
        for (i = 0; i < len; i++) out += x[i] * y[i];
      }
      return out;
    };
    exports2.translationMatrix = function(x, y) {
      return [[1, 0, x], [0, 1, y], [0, 0, 1]];
    };
    exports2.rotationMatrix = function(alpha) {
      var a = alpha * Math.PI / 180;
      return [
        [Math.cos(a), -Math.sin(a), 0],
        [Math.sin(a), Math.cos(a), 0],
        [0, 0, 1]
      ];
    };
    exports2.rotationXYMatrix = function(a, x, y) {
      return exports2.dot(
        exports2.dot(
          exports2.translationMatrix(x, y),
          exports2.rotationMatrix(a)
        ),
        exports2.translationMatrix(-x, -y)
      );
    };
    exports2.apply3DTransform = function(transform) {
      return function() {
        var args = arguments;
        var xyz = arguments.length === 1 ? args[0] : [args[0], args[1], args[2] || 0];
        return exports2.dot(transform, [xyz[0], xyz[1], xyz[2], 1]).slice(0, 3);
      };
    };
    exports2.apply2DTransform = function(transform) {
      return function() {
        var args = arguments;
        if (args.length === 3) {
          args = args[0];
        }
        var xy = arguments.length === 1 ? args[0] : [args[0], args[1]];
        return exports2.dot(transform, [xy[0], xy[1], 1]).slice(0, 2);
      };
    };
    exports2.apply2DTransform2 = function(transform) {
      var at2 = exports2.apply2DTransform(transform);
      return function(xys) {
        return at2(xys.slice(0, 2)).concat(at2(xys.slice(2, 4)));
      };
    };
    exports2.convertCssMatrix = function(m) {
      if (m) {
        var len = m.length;
        if (len === 16) return m;
        if (len === 6) {
          return [
            m[0],
            m[1],
            0,
            0,
            m[2],
            m[3],
            0,
            0,
            0,
            0,
            1,
            0,
            m[4],
            m[5],
            0,
            1
          ];
        }
      }
      return [
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      ];
    };
    exports2.inverseTransformMatrix = function(m) {
      var out = [];
      mat4X4.invert(out, m);
      return [
        [out[0], out[1], out[2], out[3]],
        [out[4], out[5], out[6], out[7]],
        [out[8], out[9], out[10], out[11]],
        [out[12], out[13], out[14], out[15]]
      ];
    };
  }
});

// node_modules/plotly.js/src/lib/dom.js
var require_dom = __commonJS({
  "node_modules/plotly.js/src/lib/dom.js"(exports2, module2) {
    "use strict";
    var d3 = require_d3();
    var loggers = require_loggers();
    var matrix = require_matrix();
    var mat4X4 = require_gl_mat4();
    function getGraphDiv(gd2) {
      var gdElement;
      if (typeof gd2 === "string") {
        gdElement = document.getElementById(gd2);
        if (gdElement === null) {
          throw new Error("No DOM element with id '" + gd2 + "' exists on the page.");
        }
        return gdElement;
      } else if (gd2 === null || gd2 === void 0) {
        throw new Error("DOM element provided is null or undefined");
      }
      return gd2;
    }
    function isPlotDiv(el) {
      var el3 = d3.select(el);
      return el3.node() instanceof HTMLElement && el3.size() && el3.classed("js-plotly-plot");
    }
    function removeElement(el) {
      var elParent = el && el.parentNode;
      if (elParent) elParent.removeChild(el);
    }
    function addStyleRule(selector, styleString) {
      addRelatedStyleRule("global", selector, styleString);
    }
    function addRelatedStyleRule(uid, selector, styleString) {
      var id2 = "plotly.js-style-" + uid;
      var style = document.getElementById(id2);
      if (!style) {
        style = document.createElement("style");
        style.setAttribute("id", id2);
        style.appendChild(document.createTextNode(""));
        document.head.appendChild(style);
      }
      var styleSheet = style.sheet;
      if (styleSheet.insertRule) {
        styleSheet.insertRule(selector + "{" + styleString + "}", 0);
      } else if (styleSheet.addRule) {
        styleSheet.addRule(selector, styleString, 0);
      } else loggers.warn("addStyleRule failed");
    }
    function deleteRelatedStyleRule(uid) {
      var id2 = "plotly.js-style-" + uid;
      var style = document.getElementById(id2);
      if (style) removeElement(style);
    }
    function getFullTransformMatrix(element) {
      var allElements = getElementAndAncestors(element);
      var out = [
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      ];
      allElements.forEach(function(e) {
        var t = getElementTransformMatrix(e);
        if (t) {
          var m = matrix.convertCssMatrix(t);
          out = mat4X4.multiply(out, out, m);
        }
      });
      return out;
    }
    function getElementTransformMatrix(element) {
      var style = window.getComputedStyle(element, null);
      var transform = style.getPropertyValue("-webkit-transform") || style.getPropertyValue("-moz-transform") || style.getPropertyValue("-ms-transform") || style.getPropertyValue("-o-transform") || style.getPropertyValue("transform");
      if (transform === "none") return null;
      return transform.replace("matrix", "").replace("3d", "").slice(1, -1).split(",").map(function(n) {
        return +n;
      });
    }
    function getElementAndAncestors(element) {
      var allElements = [];
      while (isTransformableElement(element)) {
        allElements.push(element);
        element = element.parentNode;
        if (typeof ShadowRoot === "function" && element instanceof ShadowRoot) {
          element = element.host;
        }
      }
      return allElements;
    }
    function isTransformableElement(element) {
      return element && (element instanceof Element || element instanceof HTMLElement);
    }
    function equalDomRects(a, b) {
      return a && b && a.top === b.top && a.left === b.left && a.right === b.right && a.bottom === b.bottom;
    }
    module2.exports = {
      getGraphDiv,
      isPlotDiv,
      removeElement,
      addStyleRule,
      addRelatedStyleRule,
      deleteRelatedStyleRule,
      getFullTransformMatrix,
      getElementTransformMatrix,
      getElementAndAncestors,
      equalDomRects
    };
  }
});

// node_modules/plotly.js/src/plots/animation_attributes.js
var require_animation_attributes = __commonJS({
  "node_modules/plotly.js/src/plots/animation_attributes.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      mode: {
        valType: "enumerated",
        dflt: "afterall",
        values: ["immediate", "next", "afterall"],
        description: [
          "Describes how a new animate call interacts with currently-running",
          "animations. If `immediate`, current animations are interrupted and",
          "the new animation is started. If `next`, the current frame is allowed",
          "to complete, after which the new animation is started. If `afterall`",
          "all existing frames are animated to completion before the new animation",
          "is started."
        ].join(" ")
      },
      direction: {
        valType: "enumerated",
        values: ["forward", "reverse"],
        dflt: "forward",
        description: [
          "The direction in which to play the frames triggered by the animation call"
        ].join(" ")
      },
      fromcurrent: {
        valType: "boolean",
        dflt: false,
        description: [
          "Play frames starting at the current frame instead of the beginning."
        ].join(" ")
      },
      frame: {
        duration: {
          valType: "number",
          min: 0,
          dflt: 500,
          description: [
            "The duration in milliseconds of each frame. If greater than the frame",
            "duration, it will be limited to the frame duration."
          ].join(" ")
        },
        redraw: {
          valType: "boolean",
          dflt: true,
          description: [
            "Redraw the plot at completion of the transition. This is desirable",
            "for transitions that include properties that cannot be transitioned,",
            "but may significantly slow down updates that do not require a full",
            "redraw of the plot"
          ].join(" ")
        }
      },
      transition: {
        duration: {
          valType: "number",
          min: 0,
          dflt: 500,
          editType: "none",
          description: [
            "The duration of the transition, in milliseconds. If equal to zero,",
            "updates are synchronous."
          ].join(" ")
        },
        easing: {
          valType: "enumerated",
          dflt: "cubic-in-out",
          values: [
            "linear",
            "quad",
            "cubic",
            "sin",
            "exp",
            "circle",
            "elastic",
            "back",
            "bounce",
            "linear-in",
            "quad-in",
            "cubic-in",
            "sin-in",
            "exp-in",
            "circle-in",
            "elastic-in",
            "back-in",
            "bounce-in",
            "linear-out",
            "quad-out",
            "cubic-out",
            "sin-out",
            "exp-out",
            "circle-out",
            "elastic-out",
            "back-out",
            "bounce-out",
            "linear-in-out",
            "quad-in-out",
            "cubic-in-out",
            "sin-in-out",
            "exp-in-out",
            "circle-in-out",
            "elastic-in-out",
            "back-in-out",
            "bounce-in-out"
          ],
          editType: "none",
          description: "The easing function used for the transition"
        },
        ordering: {
          valType: "enumerated",
          values: ["layout first", "traces first"],
          dflt: "layout first",
          editType: "none",
          description: [
            "Determines whether the figure's layout or traces smoothly transitions",
            "during updates that make both traces and layout change."
          ].join(" ")
        }
      }
    };
  }
});

// node_modules/plotly.js/src/plot_api/edit_types.js
var require_edit_types = __commonJS({
  "node_modules/plotly.js/src/plot_api/edit_types.js"(exports2, module2) {
    "use strict";
    var extendFlat = require_extend().extendFlat;
    var isPlainObject = require_is_plain_object();
    var traceOpts = {
      valType: "flaglist",
      extras: ["none"],
      flags: ["calc", "clearAxisTypes", "plot", "style", "markerSize", "colorbars"],
      description: [
        "trace attributes should include an `editType` string matching this flaglist.",
        "*calc* is the most extensive: a full (re)plot starting by clearing `gd.calcdata`",
        "to force it to be regenerated",
        "*clearAxisTypes* resets the types of the axes this trace is on, because new data could",
        "cause the automatic axis type detection to change. Log type will not be cleared, as that",
        "is never automatically chosen so must have been user-specified.",
        "*plot* (re)plots but without first clearing `gd.calcdata`.",
        "*style* only calls `module.style` (or module.editStyle) for all trace modules and redraws the legend.",
        "*markerSize* is like *style*, but propagate axis-range changes due to scatter `marker.size`",
        "*colorbars* only redraws colorbars."
      ].join(" ")
    };
    var layoutOpts = {
      valType: "flaglist",
      extras: ["none"],
      flags: [
        "calc",
        "plot",
        "legend",
        "ticks",
        "axrange",
        "layoutstyle",
        "modebar",
        "camera",
        "arraydraw",
        "colorbars"
      ],
      description: [
        "layout attributes should include an `editType` string matching this flaglist.",
        "*calc* is the most extensive: a full (re)plot starting by clearing `gd.calcdata`",
        "to force it to be regenerated",
        "*plot* (re)plots but without first clearing `gd.calcdata`.",
        "*legend* only redraws the legend.",
        "*ticks* only redraws axis ticks, labels, and gridlines.",
        "*axrange* minimal sequence when updating axis ranges.",
        "*layoutstyle* reapplies global and SVG cartesian axis styles.",
        "*modebar* just updates the modebar.",
        "*camera* just updates the camera settings for gl3d scenes.",
        "*arraydraw* allows component arrays to invoke the redraw routines just for the",
        "component(s) that changed.",
        "*colorbars* only redraws colorbars."
      ].join(" ")
    };
    var traceEditTypeFlags = traceOpts.flags.slice().concat(["fullReplot"]);
    var layoutEditTypeFlags = layoutOpts.flags.slice().concat("layoutReplot");
    module2.exports = {
      traces: traceOpts,
      layout: layoutOpts,
      /*
       * default (all false) edit flags for restyle (traces)
       * creates a new object each call, so the caller can mutate freely
       */
      traceFlags: function() {
        return falseObj(traceEditTypeFlags);
      },
      /*
       * default (all false) edit flags for relayout
       * creates a new object each call, so the caller can mutate freely
       */
      layoutFlags: function() {
        return falseObj(layoutEditTypeFlags);
      },
      /*
       * update `flags` with the `editType` values found in `attr`
       */
      update: function(flags, attr) {
        var editType = attr.editType;
        if (editType && editType !== "none") {
          var editTypeParts = editType.split("+");
          for (var i = 0; i < editTypeParts.length; i++) {
            flags[editTypeParts[i]] = true;
          }
        }
      },
      overrideAll
    };
    function falseObj(keys) {
      var out = {};
      for (var i = 0; i < keys.length; i++) out[keys[i]] = false;
      return out;
    }
    function overrideAll(attrs, editTypeOverride, overrideContainers) {
      var out = extendFlat({}, attrs);
      for (var key in out) {
        var attr = out[key];
        if (isPlainObject(attr)) {
          out[key] = overrideOne(attr, editTypeOverride, overrideContainers, key);
        }
      }
      if (overrideContainers === "from-root") out.editType = editTypeOverride;
      return out;
    }
    function overrideOne(attr, editTypeOverride, overrideContainers, key) {
      if (attr.valType) {
        var out = extendFlat({}, attr);
        out.editType = editTypeOverride;
        if (Array.isArray(attr.items)) {
          out.items = new Array(attr.items.length);
          for (var i = 0; i < attr.items.length; i++) {
            out.items[i] = overrideOne(attr.items[i], editTypeOverride, "from-root");
          }
        }
        return out;
      } else {
        return overrideAll(
          attr,
          editTypeOverride,
          key.charAt(0) === "_" ? "nested" : "from-root"
        );
      }
    }
  }
});

// node_modules/plotly.js/src/components/drawing/attributes.js
var require_attributes4 = __commonJS({
  "node_modules/plotly.js/src/components/drawing/attributes.js"(exports2) {
    "use strict";
    exports2.dash = {
      valType: "string",
      // string type usually doesn't take values... this one should really be
      // a special type or at least a special coercion function, from the GUI
      // you only get these values but elsewhere the user can supply a list of
      // dash lengths in px, and it will be honored
      values: ["solid", "dot", "dash", "longdash", "dashdot", "longdashdot"],
      dflt: "solid",
      editType: "style",
      description: [
        "Sets the dash style of lines. Set to a dash type string",
        "(*solid*, *dot*, *dash*, *longdash*, *dashdot*, or *longdashdot*)",
        "or a dash length list in px (eg *5px,10px,2px,2px*)."
      ].join(" ")
    };
    exports2.pattern = {
      shape: {
        valType: "enumerated",
        values: ["", "/", "\\", "x", "-", "|", "+", "."],
        dflt: "",
        arrayOk: true,
        editType: "style",
        description: [
          "Sets the shape of the pattern fill.",
          "By default, no pattern is used for filling the area."
        ].join(" ")
      },
      fillmode: {
        valType: "enumerated",
        values: ["replace", "overlay"],
        dflt: "replace",
        editType: "style",
        description: [
          "Determines whether `marker.color` should be used",
          "as a default to `bgcolor` or a `fgcolor`."
        ].join(" ")
      },
      bgcolor: {
        valType: "color",
        arrayOk: true,
        editType: "style",
        description: [
          "When there is no colorscale sets the color of background pattern fill.",
          "Defaults to a `marker.color` background when `fillmode` is *overlay*.",
          "Otherwise, defaults to a transparent background."
        ].join(" ")
      },
      fgcolor: {
        valType: "color",
        arrayOk: true,
        editType: "style",
        description: [
          "When there is no colorscale sets the color of foreground pattern fill.",
          "Defaults to a `marker.color` background when `fillmode` is *replace*.",
          "Otherwise, defaults to dark grey or white",
          "to increase contrast with the `bgcolor`."
        ].join(" ")
      },
      fgopacity: {
        valType: "number",
        editType: "style",
        min: 0,
        max: 1,
        description: [
          "Sets the opacity of the foreground pattern fill.",
          "Defaults to a 0.5 when `fillmode` is *overlay*.",
          "Otherwise, defaults to 1."
        ].join(" ")
      },
      size: {
        valType: "number",
        min: 0,
        dflt: 8,
        arrayOk: true,
        editType: "style",
        description: [
          "Sets the size of unit squares of the pattern fill in pixels,",
          "which corresponds to the interval of repetition of the pattern."
        ].join(" ")
      },
      solidity: {
        valType: "number",
        min: 0,
        max: 1,
        dflt: 0.3,
        arrayOk: true,
        editType: "style",
        description: [
          "Sets the solidity of the pattern fill.",
          "Solidity is roughly the fraction of the area filled by the pattern.",
          "Solidity of 0 shows only the background color without pattern",
          "and solidty of 1 shows only the foreground color without pattern."
        ].join(" ")
      },
      editType: "style",
      description: [
        "Sets the pattern within the marker."
      ].join(" ")
    };
  }
});

// node_modules/plotly.js/src/constants/docs.js
var require_docs = __commonJS({
  "node_modules/plotly.js/src/constants/docs.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      FORMAT_LINK: "https://github.com/d3/d3-format/tree/v1.4.5#d3-format",
      DATE_FORMAT_LINK: "https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format"
    };
  }
});

// node_modules/plotly.js/src/plots/template_attributes.js
var require_template_attributes = __commonJS({
  "node_modules/plotly.js/src/plots/template_attributes.js"(exports2) {
    "use strict";
    var docs = require_docs();
    var FORMAT_LINK = docs.FORMAT_LINK;
    var DATE_FORMAT_LINK = docs.DATE_FORMAT_LINK;
    function templateFormatStringDescription(opts) {
      var supportOther = opts && opts.supportOther;
      return [
        "Variables are inserted using %{variable},",
        'for example "y: %{y}"' + (supportOther ? " as well as %{xother}, {%_xother}, {%_xother_}, {%xother_}. When showing info for several points, *xother* will be added to those with different x positions from the first point. An underscore before or after *(x|y)other* will add a space on that side, only when this field is shown." : "."),
        `Numbers are formatted using d3-format's syntax %{variable:d3-format}, for example "Price: %{y:$.2f}".`,
        FORMAT_LINK,
        "for details on the formatting syntax.",
        `Dates are formatted using d3-time-format's syntax %{variable|d3-time-format}, for example "Day: %{2019-01-01|%A}".`,
        DATE_FORMAT_LINK,
        "for details on the date formatting syntax."
      ].join(" ");
    }
    function shapeTemplateFormatStringDescription() {
      return [
        "Variables are inserted using %{variable},",
        'for example "x0: %{x0}".',
        `Numbers are formatted using d3-format's syntax %{variable:d3-format}, for example "Price: %{x0:$.2f}". See`,
        FORMAT_LINK,
        "for details on the formatting syntax.",
        `Dates are formatted using d3-time-format's syntax %{variable|d3-time-format}, for example "Day: %{x0|%m %b %Y}". See`,
        DATE_FORMAT_LINK,
        "for details on the date formatting syntax.",
        "A single multiplication or division operation may be applied to numeric variables, and combined with",
        'd3 number formatting, for example "Length in cm: %{x0*2.54}", "%{slope*60:.1f} meters per second."',
        "For log axes, variable values are given in log units.",
        "For date axes, x/y coordinate variables and center variables use datetimes, while all other variable values use values in ms."
      ].join(" ");
    }
    function describeVariables(extra) {
      var descPart = extra.description ? " " + extra.description : "";
      var keys = extra.keys || [];
      if (keys.length > 0) {
        var quotedKeys = [];
        for (var i = 0; i < keys.length; i++) {
          quotedKeys[i] = "`" + keys[i] + "`";
        }
        descPart = descPart + "Finally, the template string has access to ";
        if (keys.length === 1) {
          descPart = descPart + "variable " + quotedKeys[0];
        } else {
          descPart = descPart + "variables " + quotedKeys.slice(0, -1).join(", ") + " and " + quotedKeys.slice(-1) + ".";
        }
      }
      return descPart;
    }
    exports2.hovertemplateAttrs = function(opts, extra) {
      opts = opts || {};
      extra = extra || {};
      var descPart = describeVariables(extra);
      var hovertemplate = {
        valType: "string",
        dflt: "",
        editType: opts.editType || "none",
        description: [
          "Template string used for rendering the information that appear on hover box.",
          "Note that this will override `hoverinfo`.",
          templateFormatStringDescription({ supportOther: true }),
          "The variables available in `hovertemplate` are the ones emitted as event data described at this link https://plotly.com/javascript/plotlyjs-events/#event-data.",
          "Additionally, every attributes that can be specified per-point (the ones that are `arrayOk: true`) are available.",
          descPart,
          'Anything contained in tag `<extra>` is displayed in the secondary box, for example "<extra>{fullData.name}</extra>".',
          "To hide the secondary box completely, use an empty tag `<extra></extra>`."
        ].join(" ")
      };
      if (opts.arrayOk !== false) {
        hovertemplate.arrayOk = true;
      }
      return hovertemplate;
    };
    exports2.texttemplateAttrs = function(opts, extra) {
      opts = opts || {};
      extra = extra || {};
      var descPart = describeVariables(extra);
      var texttemplate = {
        valType: "string",
        dflt: "",
        editType: opts.editType || "calc",
        description: [
          "Template string used for rendering the information text that appear on points.",
          "Note that this will override `textinfo`.",
          templateFormatStringDescription(),
          "Every attributes that can be specified per-point (the ones that are `arrayOk: true`) are available.",
          descPart
        ].join(" ")
      };
      if (opts.arrayOk !== false) {
        texttemplate.arrayOk = true;
      }
      return texttemplate;
    };
    exports2.shapeTexttemplateAttrs = function(opts, extra) {
      opts = opts || {};
      extra = extra || {};
      var newStr = opts.newshape ? "new " : "";
      var descPart = describeVariables(extra);
      var texttemplate = {
        valType: "string",
        dflt: "",
        editType: opts.editType || "arraydraw",
        description: [
          "Template string used for rendering the " + newStr + "shape's label.",
          "Note that this will override `text`.",
          shapeTemplateFormatStringDescription(),
          descPart
        ].join(" ")
      };
      return texttemplate;
    };
  }
});

// node_modules/plotly.js/src/components/shapes/label_texttemplate.js
var require_label_texttemplate = __commonJS({
  "node_modules/plotly.js/src/components/shapes/label_texttemplate.js"(exports2, module2) {
    "use strict";
    function d2l(v, axis) {
      return axis ? axis.d2l(v) : v;
    }
    function l2d(v, axis) {
      return axis ? axis.l2d(v) : v;
    }
    function x0Fn(shape) {
      return shape.x0;
    }
    function x1Fn(shape) {
      return shape.x1;
    }
    function y0Fn(shape) {
      return shape.y0;
    }
    function y1Fn(shape) {
      return shape.y1;
    }
    function x0shiftFn(shape) {
      return shape.x0shift || 0;
    }
    function x1shiftFn(shape) {
      return shape.x1shift || 0;
    }
    function y0shiftFn(shape) {
      return shape.y0shift || 0;
    }
    function y1shiftFn(shape) {
      return shape.y1shift || 0;
    }
    function dxFn(shape, xa2) {
      return d2l(shape.x1, xa2) + x1shiftFn(shape) - d2l(shape.x0, xa2) - x0shiftFn(shape);
    }
    function dyFn(shape, xa2, ya2) {
      return d2l(shape.y1, ya2) + y1shiftFn(shape) - d2l(shape.y0, ya2) - y0shiftFn(shape);
    }
    function widthFn(shape, xa2) {
      return Math.abs(dxFn(shape, xa2));
    }
    function heightFn(shape, xa2, ya2) {
      return Math.abs(dyFn(shape, xa2, ya2));
    }
    function lengthFn(shape, xa2, ya2) {
      return shape.type !== "line" ? void 0 : Math.sqrt(
        Math.pow(dxFn(shape, xa2), 2) + Math.pow(dyFn(shape, xa2, ya2), 2)
      );
    }
    function xcenterFn(shape, xa2) {
      return l2d((d2l(shape.x1, xa2) + x1shiftFn(shape) + d2l(shape.x0, xa2) + x0shiftFn(shape)) / 2, xa2);
    }
    function ycenterFn(shape, xa2, ya2) {
      return l2d((d2l(shape.y1, ya2) + y1shiftFn(shape) + d2l(shape.y0, ya2) + y0shiftFn(shape)) / 2, ya2);
    }
    function slopeFn(shape, xa2, ya2) {
      return shape.type !== "line" ? void 0 : dyFn(shape, xa2, ya2) / dxFn(shape, xa2);
    }
    module2.exports = {
      x0: x0Fn,
      x1: x1Fn,
      y0: y0Fn,
      y1: y1Fn,
      slope: slopeFn,
      dx: dxFn,
      dy: dyFn,
      width: widthFn,
      height: heightFn,
      length: lengthFn,
      xcenter: xcenterFn,
      ycenter: ycenterFn
    };
  }
});

// node_modules/plotly.js/src/components/shapes/draw_newshape/attributes.js
var require_attributes5 = __commonJS({
  "node_modules/plotly.js/src/components/shapes/draw_newshape/attributes.js"(exports2, module2) {
    "use strict";
    var overrideAll = require_edit_types().overrideAll;
    var basePlotAttributes = require_attributes2();
    var fontAttrs = require_font_attributes();
    var dash = require_attributes4().dash;
    var extendFlat = require_extend().extendFlat;
    var shapeTexttemplateAttrs = require_template_attributes().shapeTexttemplateAttrs;
    var shapeLabelTexttemplateVars = require_label_texttemplate();
    module2.exports = overrideAll({
      newshape: {
        visible: extendFlat({}, basePlotAttributes.visible, {
          description: [
            "Determines whether or not new shape is visible.",
            "If *legendonly*, the shape is not drawn,",
            "but can appear as a legend item",
            "(provided that the legend itself is visible)."
          ].join(" ")
        }),
        showlegend: {
          valType: "boolean",
          dflt: false,
          description: [
            "Determines whether or not new",
            "shape is shown in the legend."
          ].join(" ")
        },
        legend: extendFlat({}, basePlotAttributes.legend, {
          description: [
            "Sets the reference to a legend to show new shape in.",
            "References to these legends are *legend*, *legend2*, *legend3*, etc.",
            "Settings for these legends are set in the layout, under",
            "`layout.legend`, `layout.legend2`, etc."
          ].join(" ")
        }),
        legendgroup: extendFlat({}, basePlotAttributes.legendgroup, {
          description: [
            "Sets the legend group for new shape.",
            "Traces and shapes part of the same legend group hide/show at the same time",
            "when toggling legend items."
          ].join(" ")
        }),
        legendgrouptitle: {
          text: extendFlat({}, basePlotAttributes.legendgrouptitle.text, {}),
          font: fontAttrs({
            description: [
              "Sets this legend group's title font."
            ].join(" ")
          })
        },
        legendrank: extendFlat({}, basePlotAttributes.legendrank, {
          description: [
            "Sets the legend rank for new shape.",
            "Items and groups with smaller ranks are presented on top/left side while",
            "with *reversed* `legend.traceorder` they are on bottom/right side.",
            "The default legendrank is 1000,",
            "so that you can use ranks less than 1000 to place certain items before all unranked items,",
            "and ranks greater than 1000 to go after all unranked items."
          ].join(" ")
        }),
        legendwidth: extendFlat({}, basePlotAttributes.legendwidth, {
          description: "Sets the width (in px or fraction) of the legend for new shape."
        }),
        line: {
          color: {
            valType: "color",
            description: [
              "Sets the line color.",
              "By default uses either dark grey or white",
              "to increase contrast with background color."
            ].join(" ")
          },
          width: {
            valType: "number",
            min: 0,
            dflt: 4,
            description: "Sets the line width (in px)."
          },
          dash: extendFlat({}, dash, {
            dflt: "solid"
          })
        },
        fillcolor: {
          valType: "color",
          dflt: "rgba(0,0,0,0)",
          description: [
            "Sets the color filling new shapes' interior.",
            "Please note that if using a fillcolor with alpha greater than half,",
            "drag inside the active shape starts moving the shape underneath,",
            "otherwise a new shape could be started over."
          ].join(" ")
        },
        fillrule: {
          valType: "enumerated",
          values: ["evenodd", "nonzero"],
          dflt: "evenodd",
          description: [
            "Determines the path's interior.",
            "For more info please visit https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/fill-rule"
          ].join(" ")
        },
        opacity: {
          valType: "number",
          min: 0,
          max: 1,
          dflt: 1,
          description: "Sets the opacity of new shapes."
        },
        layer: {
          valType: "enumerated",
          values: ["below", "above", "between"],
          dflt: "above",
          description: [
            "Specifies whether new shapes are drawn below gridlines (*below*),",
            "between gridlines and traces (*between*) or above traces (*above*)."
          ].join(" ")
        },
        drawdirection: {
          valType: "enumerated",
          values: ["ortho", "horizontal", "vertical", "diagonal"],
          dflt: "diagonal",
          description: [
            "When `dragmode` is set to *drawrect*, *drawline* or *drawcircle*",
            "this limits the drag to be horizontal, vertical or diagonal.",
            "Using *diagonal* there is no limit e.g. in drawing lines in any direction.",
            "*ortho* limits the draw to be either horizontal or vertical.",
            "*horizontal* allows horizontal extend.",
            "*vertical* allows vertical extend."
          ].join(" ")
        },
        name: extendFlat({}, basePlotAttributes.name, {
          description: [
            "Sets new shape name.",
            "The name appears as the legend item."
          ].join(" ")
        }),
        label: {
          text: {
            valType: "string",
            dflt: "",
            description: [
              "Sets the text to display with the new shape.",
              "It is also used for legend item if `name` is not provided."
            ].join(" ")
          },
          texttemplate: shapeTexttemplateAttrs({ newshape: true }, { keys: Object.keys(shapeLabelTexttemplateVars) }),
          font: fontAttrs({
            description: "Sets the new shape label text font."
          }),
          textposition: {
            valType: "enumerated",
            values: [
              "top left",
              "top center",
              "top right",
              "middle left",
              "middle center",
              "middle right",
              "bottom left",
              "bottom center",
              "bottom right",
              "start",
              "middle",
              "end"
            ],
            description: [
              "Sets the position of the label text relative to the new shape.",
              "Supported values for rectangles, circles and paths are",
              "*top left*, *top center*, *top right*, *middle left*,",
              "*middle center*, *middle right*, *bottom left*, *bottom center*,",
              "and *bottom right*.",
              "Supported values for lines are *start*, *middle*, and *end*.",
              "Default: *middle center* for rectangles, circles, and paths; *middle* for lines."
            ].join(" ")
          },
          textangle: {
            valType: "angle",
            dflt: "auto",
            description: [
              "Sets the angle at which the label text is drawn",
              "with respect to the horizontal. For lines, angle *auto*",
              "is the same angle as the line. For all other shapes,",
              "angle *auto* is horizontal."
            ].join(" ")
          },
          xanchor: {
            valType: "enumerated",
            values: ["auto", "left", "center", "right"],
            dflt: "auto",
            description: [
              "Sets the label's horizontal position anchor",
              "This anchor binds the specified `textposition` to the *left*, *center*",
              "or *right* of the label text.",
              "For example, if `textposition` is set to *top right* and",
              "`xanchor` to *right* then the right-most portion of the",
              "label text lines up with the right-most edge of the",
              "new shape."
            ].join(" ")
          },
          yanchor: {
            valType: "enumerated",
            values: ["top", "middle", "bottom"],
            description: [
              "Sets the label's vertical position anchor",
              "This anchor binds the specified `textposition` to the *top*, *middle*",
              "or *bottom* of the label text.",
              "For example, if `textposition` is set to *top right* and",
              "`yanchor` to *top* then the top-most portion of the",
              "label text lines up with the top-most edge of the",
              "new shape."
            ].join(" ")
          },
          padding: {
            valType: "number",
            dflt: 3,
            min: 0,
            description: "Sets padding (in px) between edge of label and edge of new shape."
          }
        }
      },
      activeshape: {
        fillcolor: {
          valType: "color",
          dflt: "rgb(255,0,255)",
          description: "Sets the color filling the active shape' interior."
        },
        opacity: {
          valType: "number",
          min: 0,
          max: 1,
          dflt: 0.5,
          description: "Sets the opacity of the active shape."
        }
      }
    }, "none", "from-root");
  }
});

// node_modules/plotly.js/src/components/selections/draw_newselection/attributes.js
var require_attributes6 = __commonJS({
  "node_modules/plotly.js/src/components/selections/draw_newselection/attributes.js"(exports2, module2) {
    "use strict";
    var dash = require_attributes4().dash;
    var extendFlat = require_extend().extendFlat;
    module2.exports = {
      newselection: {
        mode: {
          valType: "enumerated",
          values: ["immediate", "gradual"],
          dflt: "immediate",
          editType: "none",
          description: [
            "Describes how a new selection is created.",
            "If `immediate`, a new selection is created after first mouse up.",
            "If `gradual`, a new selection is not created after first mouse.",
            "By adding to and subtracting from the initial selection,",
            "this option allows declaring extra outlines of the selection."
          ].join(" ")
        },
        line: {
          color: {
            valType: "color",
            editType: "none",
            description: [
              "Sets the line color.",
              "By default uses either dark grey or white",
              "to increase contrast with background color."
            ].join(" ")
          },
          width: {
            valType: "number",
            min: 1,
            dflt: 1,
            editType: "none",
            description: "Sets the line width (in px)."
          },
          dash: extendFlat({}, dash, {
            dflt: "dot",
            editType: "none"
          }),
          editType: "none"
        },
        // no drawdirection here noting that layout.selectdirection is used instead.
        editType: "none"
      },
      activeselection: {
        fillcolor: {
          valType: "color",
          dflt: "rgba(0,0,0,0)",
          editType: "none",
          description: "Sets the color filling the active selection' interior."
        },
        opacity: {
          valType: "number",
          min: 0,
          max: 1,
          dflt: 0.5,
          editType: "none",
          description: "Sets the opacity of the active selection."
        },
        editType: "none"
      }
    };
  }
});

// node_modules/plotly.js/src/plots/pad_attributes.js
var require_pad_attributes = __commonJS({
  "node_modules/plotly.js/src/plots/pad_attributes.js"(exports2, module2) {
    "use strict";
    module2.exports = function(opts) {
      var editType = opts.editType;
      return {
        t: {
          valType: "number",
          dflt: 0,
          editType,
          description: "The amount of padding (in px) along the top of the component."
        },
        r: {
          valType: "number",
          dflt: 0,
          editType,
          description: "The amount of padding (in px) on the right side of the component."
        },
        b: {
          valType: "number",
          dflt: 0,
          editType,
          description: "The amount of padding (in px) along the bottom of the component."
        },
        l: {
          valType: "number",
          dflt: 0,
          editType,
          description: "The amount of padding (in px) on the left side of the component."
        },
        editType
      };
    };
  }
});

// node_modules/plotly.js/src/plots/layout_attributes.js
var require_layout_attributes2 = __commonJS({
  "node_modules/plotly.js/src/plots/layout_attributes.js"(exports2, module2) {
    "use strict";
    var fontAttrs = require_font_attributes();
    var animationAttrs = require_animation_attributes();
    var colorAttrs = require_attributes3();
    var drawNewShapeAttrs = require_attributes5();
    var drawNewSelectionAttrs = require_attributes6();
    var padAttrs = require_pad_attributes();
    var extendFlat = require_extend().extendFlat;
    var globalFont = fontAttrs({
      editType: "calc",
      description: [
        "Sets the global font.",
        "Note that fonts used in traces and other",
        "layout components inherit from the global font."
      ].join(" ")
    });
    globalFont.family.dflt = '"Open Sans", verdana, arial, sans-serif';
    globalFont.size.dflt = 12;
    globalFont.color.dflt = colorAttrs.defaultLine;
    module2.exports = {
      font: globalFont,
      title: {
        text: {
          valType: "string",
          editType: "layoutstyle",
          description: [
            "Sets the plot's title.",
            "Note that before the existence of `title.text`, the title's",
            "contents used to be defined as the `title` attribute itself.",
            "This behavior has been deprecated."
          ].join(" ")
        },
        font: fontAttrs({
          editType: "layoutstyle",
          description: [
            "Sets the title font.",
            "Note that the title's font used to be customized",
            "by the now deprecated `titlefont` attribute."
          ].join(" ")
        }),
        subtitle: {
          text: {
            valType: "string",
            editType: "layoutstyle",
            description: "Sets the plot's subtitle."
          },
          font: fontAttrs({
            editType: "layoutstyle",
            description: "Sets the subtitle font."
          }),
          editType: "layoutstyle"
        },
        xref: {
          valType: "enumerated",
          dflt: "container",
          values: ["container", "paper"],
          editType: "layoutstyle",
          description: [
            "Sets the container `x` refers to.",
            "*container* spans the entire `width` of the plot.",
            "*paper* refers to the width of the plotting area only."
          ].join(" ")
        },
        yref: {
          valType: "enumerated",
          dflt: "container",
          values: ["container", "paper"],
          editType: "layoutstyle",
          description: [
            "Sets the container `y` refers to.",
            "*container* spans the entire `height` of the plot.",
            "*paper* refers to the height of the plotting area only."
          ].join(" ")
        },
        x: {
          valType: "number",
          min: 0,
          max: 1,
          dflt: 0.5,
          editType: "layoutstyle",
          description: [
            "Sets the x position with respect to `xref` in normalized",
            "coordinates from *0* (left) to *1* (right)."
          ].join(" ")
        },
        y: {
          valType: "number",
          min: 0,
          max: 1,
          dflt: "auto",
          editType: "layoutstyle",
          description: [
            "Sets the y position with respect to `yref` in normalized",
            "coordinates from *0* (bottom) to *1* (top).",
            "*auto* places the baseline of the title onto the",
            "vertical center of the top margin."
          ].join(" ")
        },
        xanchor: {
          valType: "enumerated",
          dflt: "auto",
          values: ["auto", "left", "center", "right"],
          editType: "layoutstyle",
          description: [
            "Sets the title's horizontal alignment with respect to its x position.",
            "*left* means that the title starts at x,",
            "*right* means that the title ends at x",
            "and *center* means that the title's center is at x.",
            "*auto* divides `xref` by three and calculates the `xanchor`",
            "value automatically based on the value of `x`."
          ].join(" ")
        },
        yanchor: {
          valType: "enumerated",
          dflt: "auto",
          values: ["auto", "top", "middle", "bottom"],
          editType: "layoutstyle",
          description: [
            "Sets the title's vertical alignment with respect to its y position.",
            "*top* means that the title's cap line is at y,",
            "*bottom* means that the title's baseline is at y",
            "and *middle* means that the title's midline is at y.",
            "*auto* divides `yref` by three and calculates the `yanchor`",
            "value automatically based on the value of `y`."
          ].join(" ")
        },
        pad: extendFlat(padAttrs({ editType: "layoutstyle" }), {
          description: [
            "Sets the padding of the title.",
            "Each padding value only applies when the corresponding",
            "`xanchor`/`yanchor` value is set accordingly. E.g. for left",
            "padding to take effect, `xanchor` must be set to *left*.",
            "The same rule applies if `xanchor`/`yanchor` is determined automatically.",
            "Padding is muted if the respective anchor value is *middle*/*center*."
          ].join(" ")
        }),
        automargin: {
          valType: "boolean",
          dflt: false,
          editType: "plot",
          description: [
            "Determines whether the title can automatically push the figure margins.",
            "If `yref='paper'` then the margin will expand to ensure that the title doesn’t",
            "overlap with the edges of the container. If `yref='container'` then the margins",
            "will ensure that the title doesn’t overlap with the plot area, tick labels,",
            "and axis titles. If `automargin=true` and the margins need to be expanded,",
            "then y will be set to a default 1 and yanchor will be set to an appropriate",
            "default to ensure that minimal margin space is needed. Note that when `yref='paper'`,",
            "only 1 or 0 are allowed y values. Invalid values will be reset to the default 1."
          ].join(" ")
        },
        editType: "layoutstyle"
      },
      uniformtext: {
        mode: {
          valType: "enumerated",
          values: [false, "hide", "show"],
          dflt: false,
          editType: "plot",
          description: [
            "Determines how the font size for various text",
            "elements are uniformed between each trace type.",
            "If the computed text sizes were smaller than",
            "the minimum size defined by `uniformtext.minsize`",
            "using *hide* option hides the text; and",
            "using *show* option shows the text without further downscaling.",
            "Please note that if the size defined by `minsize` is greater than",
            "the font size defined by trace, then the `minsize` is used."
          ].join(" ")
        },
        minsize: {
          valType: "number",
          min: 0,
          dflt: 0,
          editType: "plot",
          description: [
            "Sets the minimum text size between traces of the same type."
          ].join(" ")
        },
        editType: "plot"
      },
      autosize: {
        valType: "boolean",
        dflt: false,
        // autosize, width, and height get special editType treatment in _relayout
        // so we can handle noop resizes more efficiently
        editType: "none",
        description: [
          "Determines whether or not a layout width or height",
          "that has been left undefined by the user",
          "is initialized on each relayout.",
          "Note that, regardless of this attribute,",
          "an undefined layout width or height",
          "is always initialized on the first call to plot."
        ].join(" ")
      },
      width: {
        valType: "number",
        min: 10,
        dflt: 700,
        editType: "plot",
        description: [
          "Sets the plot's width (in px)."
        ].join(" ")
      },
      height: {
        valType: "number",
        min: 10,
        dflt: 450,
        editType: "plot",
        description: [
          "Sets the plot's height (in px)."
        ].join(" ")
      },
      minreducedwidth: {
        valType: "number",
        min: 2,
        dflt: 64,
        editType: "plot",
        description: "Minimum width of the plot with margin.automargin applied (in px)"
      },
      minreducedheight: {
        valType: "number",
        min: 2,
        dflt: 64,
        editType: "plot",
        description: "Minimum height of the plot with margin.automargin applied (in px)"
      },
      margin: {
        l: {
          valType: "number",
          min: 0,
          dflt: 80,
          editType: "plot",
          description: "Sets the left margin (in px)."
        },
        r: {
          valType: "number",
          min: 0,
          dflt: 80,
          editType: "plot",
          description: "Sets the right margin (in px)."
        },
        t: {
          valType: "number",
          min: 0,
          dflt: 100,
          editType: "plot",
          description: "Sets the top margin (in px)."
        },
        b: {
          valType: "number",
          min: 0,
          dflt: 80,
          editType: "plot",
          description: "Sets the bottom margin (in px)."
        },
        pad: {
          valType: "number",
          min: 0,
          dflt: 0,
          editType: "plot",
          description: [
            "Sets the amount of padding (in px)",
            "between the plotting area and the axis lines"
          ].join(" ")
        },
        autoexpand: {
          valType: "boolean",
          dflt: true,
          editType: "plot",
          description: [
            "Turns on/off margin expansion computations.",
            "Legends, colorbars, updatemenus, sliders, axis rangeselector and rangeslider",
            "are allowed to push the margins by defaults."
          ].join(" ")
        },
        editType: "plot"
      },
      computed: {
        valType: "any",
        editType: "none",
        description: [
          "Placeholder for exporting automargin-impacting values namely",
          "`margin.t`, `margin.b`, `margin.l` and `margin.r` in *full-json* mode."
        ].join(" ")
      },
      paper_bgcolor: {
        valType: "color",
        dflt: colorAttrs.background,
        editType: "plot",
        description: "Sets the background color of the paper where the graph is drawn."
      },
      plot_bgcolor: {
        // defined here, but set in cartesian.supplyLayoutDefaults
        // because it needs to know if there are (2D) axes or not
        valType: "color",
        dflt: colorAttrs.background,
        editType: "layoutstyle",
        description: [
          "Sets the background color of the plotting area in-between x and y axes."
        ].join(" ")
      },
      autotypenumbers: {
        valType: "enumerated",
        values: ["convert types", "strict"],
        dflt: "convert types",
        editType: "calc",
        description: [
          "Using *strict* a numeric string in trace data is not converted to a number.",
          "Using *convert types* a numeric string in trace data may be",
          "treated as a number during automatic axis `type` detection.",
          "This is the default value; however it could be overridden for individual axes."
        ].join(" ")
      },
      separators: {
        valType: "string",
        editType: "plot",
        description: [
          "Sets the decimal and thousand separators.",
          "For example, *. * puts a '.' before decimals and a space",
          "between thousands. In English locales, dflt is *.,* but",
          "other locales may alter this default."
        ].join(" ")
      },
      hidesources: {
        valType: "boolean",
        dflt: false,
        editType: "plot",
        description: [
          "Determines whether or not a text link citing the data source is",
          "placed at the bottom-right cored of the figure.",
          "Has only an effect only on graphs that have been generated via",
          "forked graphs from the Chart Studio Cloud (at https://chart-studio.plotly.com or on-premise)."
        ].join(" ")
      },
      showlegend: {
        // handled in legend.supplyLayoutDefaults
        // but included here because it's not in the legend object
        valType: "boolean",
        editType: "legend",
        description: [
          "Determines whether or not a legend is drawn.",
          "Default is `true` if there is a trace to show and any of these:",
          "a) Two or more traces would by default be shown in the legend.",
          "b) One pie trace is shown in the legend.",
          "c) One trace is explicitly given with `showlegend: true`."
        ].join(" ")
      },
      colorway: {
        valType: "colorlist",
        dflt: colorAttrs.defaults,
        editType: "calc",
        description: "Sets the default trace colors."
      },
      datarevision: {
        valType: "any",
        editType: "calc",
        description: [
          "If provided, a changed value tells `Plotly.react` that",
          "one or more data arrays has changed. This way you can modify",
          "arrays in-place rather than making a complete new copy for an",
          "incremental change.",
          "If NOT provided, `Plotly.react` assumes that data arrays are",
          "being treated as immutable, thus any data array with a",
          "different identity from its predecessor contains new data."
        ].join(" ")
      },
      uirevision: {
        valType: "any",
        editType: "none",
        description: [
          "Used to allow user interactions with the plot to persist after",
          "`Plotly.react` calls that are unaware of these interactions.",
          "If `uirevision` is omitted, or if it is given and it changed from",
          "the previous `Plotly.react` call, the exact new figure is used.",
          "If `uirevision` is truthy and did NOT change, any attribute",
          "that has been affected by user interactions and did not receive a",
          "different value in the new figure will keep the interaction value.",
          "`layout.uirevision` attribute serves as the default for",
          "`uirevision` attributes in various sub-containers. For finer",
          "control you can set these sub-attributes directly. For example,",
          "if your app separately controls the data on the x and y axes you",
          "might set `xaxis.uirevision=*time*` and `yaxis.uirevision=*cost*`.",
          "Then if only the y data is changed, you can update",
          "`yaxis.uirevision=*quantity*` and the y axis range will reset but",
          "the x axis range will retain any user-driven zoom."
        ].join(" ")
      },
      editrevision: {
        valType: "any",
        editType: "none",
        description: [
          "Controls persistence of user-driven changes in `editable: true`",
          "configuration, other than trace names and axis titles.",
          "Defaults to `layout.uirevision`."
        ].join(" ")
      },
      selectionrevision: {
        valType: "any",
        editType: "none",
        description: [
          "Controls persistence of user-driven changes in selected points",
          "from all traces."
        ].join(" ")
      },
      template: {
        valType: "any",
        editType: "calc",
        description: [
          "Default attributes to be applied to the plot. Templates can be",
          "created from existing plots using `Plotly.makeTemplate`, or",
          "created manually. They should be objects with format:",
          "`{layout: layoutTemplate, data: {[type]: [traceTemplate, ...]}, ...}`",
          "`layoutTemplate` and `traceTemplate` are objects matching the",
          "attribute structure of `layout` and a data trace. ",
          "Trace templates are applied cyclically to traces of each type.",
          "Container arrays (eg `annotations`) have special handling:",
          "An object ending in `defaults` (eg `annotationdefaults`) is applied",
          "to each array item. But if an item has a `templateitemname` key",
          "we look in the template array for an item with matching `name` and",
          "apply that instead. If no matching `name` is found we mark the item",
          "invisible. Any named template item not referenced is appended to",
          "the end of the array, so you can use this for a watermark annotation",
          "or a logo image, for example. To omit one of these items on the plot,",
          "make an item with matching `templateitemname` and `visible: false`."
        ].join(" ")
      },
      newshape: drawNewShapeAttrs.newshape,
      activeshape: drawNewShapeAttrs.activeshape,
      newselection: drawNewSelectionAttrs.newselection,
      activeselection: drawNewSelectionAttrs.activeselection,
      meta: {
        valType: "any",
        arrayOk: true,
        editType: "plot",
        description: [
          "Assigns extra meta information that can be used in various `text` attributes.",
          "Attributes such as the graph, axis and colorbar `title.text`, annotation `text`",
          "`trace.name` in legend items, `rangeselector`, `updatemenus` and `sliders` `label` text",
          "all support `meta`. One can access `meta` fields using template strings:",
          "`%{meta[i]}` where `i` is the index of the `meta`",
          "item in question.",
          "`meta` can also be an object for example `{key: value}` which can be accessed",
          "%{meta[key]}."
        ].join(" ")
      },
      transition: extendFlat({}, animationAttrs.transition, {
        description: [
          "Sets transition options used during Plotly.react updates."
        ].join(" "),
        editType: "none"
      }),
      _deprecated: {
        title: {
          valType: "string",
          editType: "layoutstyle",
          description: [
            "Value of `title` is no longer a simple *string* but a set of sub-attributes.",
            "To set the contents of the title, please use `title.text` now."
          ].join(" ")
        },
        titlefont: fontAttrs({
          editType: "layoutstyle",
          description: [
            "Former `titlefont` is now the sub-attribute `font` of `title`.",
            "To customize title font properties, please use `title.font` now."
          ].join(" ")
        })
      }
    };
  }
});

// vite:dep-pre-bundle:external-conversion:/home/cmiss/Jenkins/workspace/map-viewer-release/node_modules/maplibre-gl/dist/maplibre-gl.css
var maplibre_gl_exports = {};
import "/home/cmiss/Jenkins/workspace/map-viewer-release/node_modules/maplibre-gl/dist/maplibre-gl.css";
var init_maplibre_gl = __esm({
  "vite:dep-pre-bundle:external-conversion:/home/cmiss/Jenkins/workspace/map-viewer-release/node_modules/maplibre-gl/dist/maplibre-gl.css"() {
  }
});

// node_modules/plotly.js/src/registry.js
var require_registry = __commonJS({
  "node_modules/plotly.js/src/registry.js"(exports2) {
    "use strict";
    var Loggers = require_loggers();
    var noop = require_noop();
    var pushUnique = require_push_unique();
    var isPlainObject = require_is_plain_object();
    var addStyleRule = require_dom().addStyleRule;
    var ExtendModule = require_extend();
    var basePlotAttributes = require_attributes2();
    var baseLayoutAttributes = require_layout_attributes2();
    var extendFlat = ExtendModule.extendFlat;
    var extendDeepAll = ExtendModule.extendDeepAll;
    exports2.modules = {};
    exports2.allCategories = {};
    exports2.allTypes = [];
    exports2.subplotsRegistry = {};
    exports2.transformsRegistry = {};
    exports2.componentsRegistry = {};
    exports2.layoutArrayContainers = [];
    exports2.layoutArrayRegexes = [];
    exports2.traceLayoutAttributes = {};
    exports2.localeRegistry = {};
    exports2.apiMethodRegistry = {};
    exports2.collectableSubplotTypes = null;
    exports2.register = function register(_modules) {
      exports2.collectableSubplotTypes = null;
      if (!_modules) {
        throw new Error("No argument passed to Plotly.register.");
      } else if (_modules && !Array.isArray(_modules)) {
        _modules = [_modules];
      }
      for (var i = 0; i < _modules.length; i++) {
        var newModule = _modules[i];
        if (!newModule) {
          throw new Error("Invalid module was attempted to be registered!");
        }
        switch (newModule.moduleType) {
          case "trace":
            registerTraceModule(newModule);
            break;
          case "transform":
            registerTransformModule(newModule);
            break;
          case "component":
            registerComponentModule(newModule);
            break;
          case "locale":
            registerLocale(newModule);
            break;
          case "apiMethod":
            var name = newModule.name;
            exports2.apiMethodRegistry[name] = newModule.fn;
            break;
          default:
            throw new Error("Invalid module was attempted to be registered!");
        }
      }
    };
    exports2.getModule = function(trace) {
      var _module = exports2.modules[getTraceType(trace)];
      if (!_module) return false;
      return _module._module;
    };
    exports2.traceIs = function(traceType, category) {
      traceType = getTraceType(traceType);
      if (traceType === "various") return false;
      var _module = exports2.modules[traceType];
      if (!_module) {
        if (traceType) {
          Loggers.log("Unrecognized trace type " + traceType + ".");
        }
        _module = exports2.modules[basePlotAttributes.type.dflt];
      }
      return !!_module.categories[category];
    };
    exports2.getTransformIndices = function(data, type) {
      var indices = [];
      var transforms = data.transforms || [];
      for (var i = 0; i < transforms.length; i++) {
        if (transforms[i].type === type) {
          indices.push(i);
        }
      }
      return indices;
    };
    exports2.hasTransform = function(data, type) {
      var transforms = data.transforms || [];
      for (var i = 0; i < transforms.length; i++) {
        if (transforms[i].type === type) {
          return true;
        }
      }
      return false;
    };
    exports2.getComponentMethod = function(name, method) {
      var _module = exports2.componentsRegistry[name];
      if (!_module) return noop;
      return _module[method] || noop;
    };
    exports2.call = function() {
      var name = arguments[0];
      var args = [].slice.call(arguments, 1);
      return exports2.apiMethodRegistry[name].apply(null, args);
    };
    function registerTraceModule(_module) {
      var thisType = _module.name;
      var categoriesIn = _module.categories;
      var meta = _module.meta;
      if (exports2.modules[thisType]) {
        Loggers.log("Type " + thisType + " already registered");
        return;
      }
      if (!exports2.subplotsRegistry[_module.basePlotModule.name]) {
        registerSubplot(_module.basePlotModule);
      }
      var categoryObj = {};
      for (var i = 0; i < categoriesIn.length; i++) {
        categoryObj[categoriesIn[i]] = true;
        exports2.allCategories[categoriesIn[i]] = true;
      }
      exports2.modules[thisType] = {
        _module,
        categories: categoryObj
      };
      if (meta && Object.keys(meta).length) {
        exports2.modules[thisType].meta = meta;
      }
      exports2.allTypes.push(thisType);
      for (var componentName in exports2.componentsRegistry) {
        mergeComponentAttrsToTrace(componentName, thisType);
      }
      if (_module.layoutAttributes) {
        extendFlat(exports2.traceLayoutAttributes, _module.layoutAttributes);
      }
      var basePlotModule = _module.basePlotModule;
      var bpmName = basePlotModule.name;
      if (bpmName === "mapbox") {
        var styleRules = basePlotModule.constants.styleRules;
        for (var k in styleRules) {
          addStyleRule(".js-plotly-plot .plotly .mapboxgl-" + k, styleRules[k]);
        }
      }
      if (bpmName === "map") {
        init_maplibre_gl();
      }
      if ((bpmName === "geo" || bpmName === "mapbox" || bpmName === "map") && window.PlotlyGeoAssets === void 0) {
        window.PlotlyGeoAssets = { topojson: {} };
      }
    }
    function registerSubplot(_module) {
      var plotType = _module.name;
      if (exports2.subplotsRegistry[plotType]) {
        Loggers.log("Plot type " + plotType + " already registered.");
        return;
      }
      findArrayRegexps(_module);
      exports2.subplotsRegistry[plotType] = _module;
      for (var componentName in exports2.componentsRegistry) {
        mergeComponentAttrsToSubplot(componentName, _module.name);
      }
    }
    function registerComponentModule(_module) {
      if (typeof _module.name !== "string") {
        throw new Error("Component module *name* must be a string.");
      }
      var name = _module.name;
      exports2.componentsRegistry[name] = _module;
      if (_module.layoutAttributes) {
        if (_module.layoutAttributes._isLinkedToArray) {
          pushUnique(exports2.layoutArrayContainers, name);
        }
        findArrayRegexps(_module);
      }
      for (var traceType in exports2.modules) {
        mergeComponentAttrsToTrace(name, traceType);
      }
      for (var subplotName in exports2.subplotsRegistry) {
        mergeComponentAttrsToSubplot(name, subplotName);
      }
      for (var transformType in exports2.transformsRegistry) {
        mergeComponentAttrsToTransform(name, transformType);
      }
      if (_module.schema && _module.schema.layout) {
        extendDeepAll(baseLayoutAttributes, _module.schema.layout);
      }
    }
    function registerTransformModule(_module) {
      if (typeof _module.name !== "string") {
        throw new Error("Transform module *name* must be a string.");
      }
      var prefix = "Transform module " + _module.name;
      var hasTransform = typeof _module.transform === "function";
      var hasCalcTransform = typeof _module.calcTransform === "function";
      if (!hasTransform && !hasCalcTransform) {
        throw new Error(prefix + " is missing a *transform* or *calcTransform* method.");
      }
      if (hasTransform && hasCalcTransform) {
        Loggers.log([
          prefix + " has both a *transform* and *calcTransform* methods.",
          "Please note that all *transform* methods are executed",
          "before all *calcTransform* methods."
        ].join(" "));
      }
      if (!isPlainObject(_module.attributes)) {
        Loggers.log(prefix + " registered without an *attributes* object.");
      }
      if (typeof _module.supplyDefaults !== "function") {
        Loggers.log(prefix + " registered without a *supplyDefaults* method.");
      }
      exports2.transformsRegistry[_module.name] = _module;
      for (var componentName in exports2.componentsRegistry) {
        mergeComponentAttrsToTransform(componentName, _module.name);
      }
    }
    function registerLocale(_module) {
      var locale3 = _module.name;
      var baseLocale = locale3.split("-")[0];
      var newDict = _module.dictionary;
      var newFormat = _module.format;
      var hasDict = newDict && Object.keys(newDict).length;
      var hasFormat = newFormat && Object.keys(newFormat).length;
      var locales = exports2.localeRegistry;
      var localeObj = locales[locale3];
      if (!localeObj) locales[locale3] = localeObj = {};
      if (baseLocale !== locale3) {
        var baseLocaleObj = locales[baseLocale];
        if (!baseLocaleObj) locales[baseLocale] = baseLocaleObj = {};
        if (hasDict && baseLocaleObj.dictionary === localeObj.dictionary) {
          baseLocaleObj.dictionary = newDict;
        }
        if (hasFormat && baseLocaleObj.format === localeObj.format) {
          baseLocaleObj.format = newFormat;
        }
      }
      if (hasDict) localeObj.dictionary = newDict;
      if (hasFormat) localeObj.format = newFormat;
    }
    function findArrayRegexps(_module) {
      if (_module.layoutAttributes) {
        var arrayAttrRegexps = _module.layoutAttributes._arrayAttrRegexps;
        if (arrayAttrRegexps) {
          for (var i = 0; i < arrayAttrRegexps.length; i++) {
            pushUnique(exports2.layoutArrayRegexes, arrayAttrRegexps[i]);
          }
        }
      }
    }
    function mergeComponentAttrsToTrace(componentName, traceType) {
      var componentSchema = exports2.componentsRegistry[componentName].schema;
      if (!componentSchema || !componentSchema.traces) return;
      var traceAttrs = componentSchema.traces[traceType];
      if (traceAttrs) {
        extendDeepAll(exports2.modules[traceType]._module.attributes, traceAttrs);
      }
    }
    function mergeComponentAttrsToTransform(componentName, transformType) {
      var componentSchema = exports2.componentsRegistry[componentName].schema;
      if (!componentSchema || !componentSchema.transforms) return;
      var transformAttrs = componentSchema.transforms[transformType];
      if (transformAttrs) {
        extendDeepAll(exports2.transformsRegistry[transformType].attributes, transformAttrs);
      }
    }
    function mergeComponentAttrsToSubplot(componentName, subplotName) {
      var componentSchema = exports2.componentsRegistry[componentName].schema;
      if (!componentSchema || !componentSchema.subplots) return;
      var subplotModule = exports2.subplotsRegistry[subplotName];
      var subplotAttrs = subplotModule.layoutAttributes;
      var subplotAttr = subplotModule.attr === "subplot" ? subplotModule.name : subplotModule.attr;
      if (Array.isArray(subplotAttr)) subplotAttr = subplotAttr[0];
      var componentLayoutAttrs = componentSchema.subplots[subplotAttr];
      if (subplotAttrs && componentLayoutAttrs) {
        extendDeepAll(subplotAttrs, componentLayoutAttrs);
      }
    }
    function getTraceType(traceType) {
      if (typeof traceType === "object") traceType = traceType.type;
      return traceType;
    }
  }
});

// node_modules/plotly.js/src/lib/dates.js
var require_dates = __commonJS({
  "node_modules/plotly.js/src/lib/dates.js"(exports2) {
    "use strict";
    var timeFormat2 = (init_src2(), __toCommonJS(src_exports2)).timeFormat;
    var isNumeric = require_fast_isnumeric();
    var Loggers = require_loggers();
    var mod = require_mod().mod;
    var constants = require_numerical();
    var BADNUM = constants.BADNUM;
    var ONEDAY = constants.ONEDAY;
    var ONEHOUR = constants.ONEHOUR;
    var ONEMIN = constants.ONEMIN;
    var ONESEC = constants.ONESEC;
    var EPOCHJD = constants.EPOCHJD;
    var Registry = require_registry();
    var utcFormat2 = (init_src2(), __toCommonJS(src_exports2)).utcFormat;
    var DATETIME_REGEXP = /^\s*(-?\d\d\d\d|\d\d)(-(\d?\d)(-(\d?\d)([ Tt]([01]?\d|2[0-3])(:([0-5]\d)(:([0-5]\d(\.\d+)?))?(Z|z|[+\-]\d\d(:?\d\d)?)?)?)?)?)?\s*$/m;
    var DATETIME_REGEXP_CN = /^\s*(-?\d\d\d\d|\d\d)(-(\d?\di?)(-(\d?\d)([ Tt]([01]?\d|2[0-3])(:([0-5]\d)(:([0-5]\d(\.\d+)?))?(Z|z|[+\-]\d\d(:?\d\d)?)?)?)?)?)?\s*$/m;
    var YFIRST = (/* @__PURE__ */ new Date()).getFullYear() - 70;
    function isWorldCalendar(calendar) {
      return calendar && Registry.componentsRegistry.calendars && typeof calendar === "string" && calendar !== "gregorian";
    }
    exports2.dateTick0 = function(calendar, dayOfWeek) {
      var tick0 = _dateTick0(calendar, !!dayOfWeek);
      if (dayOfWeek < 2) return tick0;
      var v = exports2.dateTime2ms(tick0, calendar);
      v += ONEDAY * (dayOfWeek - 1);
      return exports2.ms2DateTime(v, 0, calendar);
    };
    function _dateTick0(calendar, sunday2) {
      if (isWorldCalendar(calendar)) {
        return sunday2 ? Registry.getComponentMethod("calendars", "CANONICAL_SUNDAY")[calendar] : Registry.getComponentMethod("calendars", "CANONICAL_TICK")[calendar];
      } else {
        return sunday2 ? "2000-01-02" : "2000-01-01";
      }
    }
    exports2.dfltRange = function(calendar) {
      if (isWorldCalendar(calendar)) {
        return Registry.getComponentMethod("calendars", "DFLTRANGE")[calendar];
      } else {
        return ["2000-01-01", "2001-01-01"];
      }
    };
    exports2.isJSDate = function(v) {
      return typeof v === "object" && v !== null && typeof v.getTime === "function";
    };
    var MIN_MS;
    var MAX_MS;
    exports2.dateTime2ms = function(s, calendar) {
      if (exports2.isJSDate(s)) {
        var tzOffset = s.getTimezoneOffset() * ONEMIN;
        var offsetTweak = (s.getUTCMinutes() - s.getMinutes()) * ONEMIN + (s.getUTCSeconds() - s.getSeconds()) * ONESEC + (s.getUTCMilliseconds() - s.getMilliseconds());
        if (offsetTweak) {
          var comb = 3 * ONEMIN;
          tzOffset = tzOffset - comb / 2 + mod(offsetTweak - tzOffset + comb / 2, comb);
        }
        s = Number(s) - tzOffset;
        if (s >= MIN_MS && s <= MAX_MS) return s;
        return BADNUM;
      }
      if (typeof s !== "string" && typeof s !== "number") return BADNUM;
      s = String(s);
      var isWorld = isWorldCalendar(calendar);
      var s02 = s.charAt(0);
      if (isWorld && (s02 === "G" || s02 === "g")) {
        s = s.substr(1);
        calendar = "";
      }
      var isChinese = isWorld && calendar.substr(0, 7) === "chinese";
      var match = s.match(isChinese ? DATETIME_REGEXP_CN : DATETIME_REGEXP);
      if (!match) return BADNUM;
      var y = match[1];
      var m = match[3] || "1";
      var d = Number(match[5] || 1);
      var H = Number(match[7] || 0);
      var M = Number(match[9] || 0);
      var S = Number(match[11] || 0);
      if (isWorld) {
        if (y.length === 2) return BADNUM;
        y = Number(y);
        var cDate;
        try {
          var calInstance = Registry.getComponentMethod("calendars", "getCal")(calendar);
          if (isChinese) {
            var isIntercalary = m.charAt(m.length - 1) === "i";
            m = parseInt(m, 10);
            cDate = calInstance.newDate(y, calInstance.toMonthIndex(y, m, isIntercalary), d);
          } else {
            cDate = calInstance.newDate(y, Number(m), d);
          }
        } catch (e) {
          return BADNUM;
        }
        if (!cDate) return BADNUM;
        return (cDate.toJD() - EPOCHJD) * ONEDAY + H * ONEHOUR + M * ONEMIN + S * ONESEC;
      }
      if (y.length === 2) {
        y = (Number(y) + 2e3 - YFIRST) % 100 + YFIRST;
      } else y = Number(y);
      m -= 1;
      var date = new Date(Date.UTC(2e3, m, d, H, M));
      date.setUTCFullYear(y);
      if (date.getUTCMonth() !== m) return BADNUM;
      if (date.getUTCDate() !== d) return BADNUM;
      return date.getTime() + S * ONESEC;
    };
    MIN_MS = exports2.MIN_MS = exports2.dateTime2ms("-9999");
    MAX_MS = exports2.MAX_MS = exports2.dateTime2ms("9999-12-31 23:59:59.9999");
    exports2.isDateTime = function(s, calendar) {
      return exports2.dateTime2ms(s, calendar) !== BADNUM;
    };
    function lpad(val, digits) {
      return String(val + Math.pow(10, digits)).substr(1);
    }
    var NINETYDAYS = 90 * ONEDAY;
    var THREEHOURS = 3 * ONEHOUR;
    var FIVEMIN = 5 * ONEMIN;
    exports2.ms2DateTime = function(ms2, r, calendar) {
      if (typeof ms2 !== "number" || !(ms2 >= MIN_MS && ms2 <= MAX_MS)) return BADNUM;
      if (!r) r = 0;
      var msecTenths = Math.floor(mod(ms2 + 0.05, 1) * 10);
      var msRounded = Math.round(ms2 - msecTenths / 10);
      var dateStr, h, m, s, msec10, d;
      if (isWorldCalendar(calendar)) {
        var dateJD = Math.floor(msRounded / ONEDAY) + EPOCHJD;
        var timeMs = Math.floor(mod(ms2, ONEDAY));
        try {
          dateStr = Registry.getComponentMethod("calendars", "getCal")(calendar).fromJD(dateJD).formatDate("yyyy-mm-dd");
        } catch (e) {
          dateStr = utcFormat2("G%Y-%m-%d")(new Date(msRounded));
        }
        if (dateStr.charAt(0) === "-") {
          while (dateStr.length < 11) dateStr = "-0" + dateStr.substr(1);
        } else {
          while (dateStr.length < 10) dateStr = "0" + dateStr;
        }
        h = r < NINETYDAYS ? Math.floor(timeMs / ONEHOUR) : 0;
        m = r < NINETYDAYS ? Math.floor(timeMs % ONEHOUR / ONEMIN) : 0;
        s = r < THREEHOURS ? Math.floor(timeMs % ONEMIN / ONESEC) : 0;
        msec10 = r < FIVEMIN ? timeMs % ONESEC * 10 + msecTenths : 0;
      } else {
        d = new Date(msRounded);
        dateStr = utcFormat2("%Y-%m-%d")(d);
        h = r < NINETYDAYS ? d.getUTCHours() : 0;
        m = r < NINETYDAYS ? d.getUTCMinutes() : 0;
        s = r < THREEHOURS ? d.getUTCSeconds() : 0;
        msec10 = r < FIVEMIN ? d.getUTCMilliseconds() * 10 + msecTenths : 0;
      }
      return includeTime(dateStr, h, m, s, msec10);
    };
    exports2.ms2DateTimeLocal = function(ms2) {
      if (!(ms2 >= MIN_MS + ONEDAY && ms2 <= MAX_MS - ONEDAY)) return BADNUM;
      var msecTenths = Math.floor(mod(ms2 + 0.05, 1) * 10);
      var d = new Date(Math.round(ms2 - msecTenths / 10));
      var dateStr = timeFormat2("%Y-%m-%d")(d);
      var h = d.getHours();
      var m = d.getMinutes();
      var s = d.getSeconds();
      var msec10 = d.getUTCMilliseconds() * 10 + msecTenths;
      return includeTime(dateStr, h, m, s, msec10);
    };
    function includeTime(dateStr, h, m, s, msec10) {
      if (h || m || s || msec10) {
        dateStr += " " + lpad(h, 2) + ":" + lpad(m, 2);
        if (s || msec10) {
          dateStr += ":" + lpad(s, 2);
          if (msec10) {
            var digits = 4;
            while (msec10 % 10 === 0) {
              digits -= 1;
              msec10 /= 10;
            }
            dateStr += "." + lpad(msec10, digits);
          }
        }
      }
      return dateStr;
    }
    exports2.cleanDate = function(v, dflt, calendar) {
      if (v === BADNUM) return dflt;
      if (exports2.isJSDate(v) || typeof v === "number" && isFinite(v)) {
        if (isWorldCalendar(calendar)) {
          Loggers.error("JS Dates and milliseconds are incompatible with world calendars", v);
          return dflt;
        }
        v = exports2.ms2DateTimeLocal(+v);
        if (!v && dflt !== void 0) return dflt;
      } else if (!exports2.isDateTime(v, calendar)) {
        Loggers.error("unrecognized date", v);
        return dflt;
      }
      return v;
    };
    var fracMatch = /%\d?f/g;
    var halfYearMatch = /%h/g;
    var quarterToHalfYear = {
      1: "1",
      2: "1",
      3: "2",
      4: "2"
    };
    function modDateFormat(fmt, x, formatter, calendar) {
      fmt = fmt.replace(fracMatch, function(match) {
        var digits = Math.min(+match.charAt(1) || 6, 6);
        var fracSecs = (x / 1e3 % 1 + 2).toFixed(digits).substr(2).replace(/0+$/, "") || "0";
        return fracSecs;
      });
      var d = new Date(Math.floor(x + 0.05));
      fmt = fmt.replace(halfYearMatch, function() {
        return quarterToHalfYear[formatter("%q")(d)];
      });
      if (isWorldCalendar(calendar)) {
        try {
          fmt = Registry.getComponentMethod("calendars", "worldCalFmt")(fmt, x, calendar);
        } catch (e) {
          return "Invalid";
        }
      }
      return formatter(fmt)(d);
    }
    var MAXSECONDS = [59, 59.9, 59.99, 59.999, 59.9999];
    function formatTime(x, tr2) {
      var timePart = mod(x + 0.05, ONEDAY);
      var timeStr = lpad(Math.floor(timePart / ONEHOUR), 2) + ":" + lpad(mod(Math.floor(timePart / ONEMIN), 60), 2);
      if (tr2 !== "M") {
        if (!isNumeric(tr2)) tr2 = 0;
        var sec = Math.min(mod(x / ONESEC, 60), MAXSECONDS[tr2]);
        var secStr = (100 + sec).toFixed(tr2).substr(1);
        if (tr2 > 0) {
          secStr = secStr.replace(/0+$/, "").replace(/[\.]$/, "");
        }
        timeStr += ":" + secStr;
      }
      return timeStr;
    }
    exports2.formatDate = function(x, fmt, tr2, formatter, calendar, extraFormat) {
      calendar = isWorldCalendar(calendar) && calendar;
      if (!fmt) {
        if (tr2 === "y") fmt = extraFormat.year;
        else if (tr2 === "m") fmt = extraFormat.month;
        else if (tr2 === "d") {
          fmt = extraFormat.dayMonth + "\n" + extraFormat.year;
        } else {
          return formatTime(x, tr2) + "\n" + modDateFormat(extraFormat.dayMonthYear, x, formatter, calendar);
        }
      }
      return modDateFormat(fmt, x, formatter, calendar);
    };
    var THREEDAYS = 3 * ONEDAY;
    exports2.incrementMonth = function(ms2, dMonth, calendar) {
      calendar = isWorldCalendar(calendar) && calendar;
      var timeMs = mod(ms2, ONEDAY);
      ms2 = Math.round(ms2 - timeMs);
      if (calendar) {
        try {
          var dateJD = Math.round(ms2 / ONEDAY) + EPOCHJD;
          var calInstance = Registry.getComponentMethod("calendars", "getCal")(calendar);
          var cDate = calInstance.fromJD(dateJD);
          if (dMonth % 12) calInstance.add(cDate, dMonth, "m");
          else calInstance.add(cDate, dMonth / 12, "y");
          return (cDate.toJD() - EPOCHJD) * ONEDAY + timeMs;
        } catch (e) {
          Loggers.error("invalid ms " + ms2 + " in calendar " + calendar);
        }
      }
      var y = new Date(ms2 + THREEDAYS);
      return y.setUTCMonth(y.getUTCMonth() + dMonth) + timeMs - THREEDAYS;
    };
    exports2.findExactDates = function(data, calendar) {
      var exactYears = 0;
      var exactMonths = 0;
      var exactDays = 0;
      var blankCount = 0;
      var d;
      var di2;
      var calInstance = isWorldCalendar(calendar) && Registry.getComponentMethod("calendars", "getCal")(calendar);
      for (var i = 0; i < data.length; i++) {
        di2 = data[i];
        if (!isNumeric(di2)) {
          blankCount++;
          continue;
        }
        if (di2 % ONEDAY) continue;
        if (calInstance) {
          try {
            d = calInstance.fromJD(di2 / ONEDAY + EPOCHJD);
            if (d.day() === 1) {
              if (d.month() === 1) exactYears++;
              else exactMonths++;
            } else exactDays++;
          } catch (e) {
          }
        } else {
          d = new Date(di2);
          if (d.getUTCDate() === 1) {
            if (d.getUTCMonth() === 0) exactYears++;
            else exactMonths++;
          } else exactDays++;
        }
      }
      exactMonths += exactYears;
      exactDays += exactMonths;
      var dataCount = data.length - blankCount;
      return {
        exactYears: exactYears / dataCount,
        exactMonths: exactMonths / dataCount,
        exactDays: exactDays / dataCount
      };
    };
  }
});

// node_modules/plotly.js/src/lib/identity.js
var require_identity2 = __commonJS({
  "node_modules/plotly.js/src/lib/identity.js"(exports2, module2) {
    "use strict";
    module2.exports = function identity(d) {
      return d;
    };
  }
});

// node_modules/plotly.js/src/lib/search.js
var require_search = __commonJS({
  "node_modules/plotly.js/src/lib/search.js"(exports2) {
    "use strict";
    var isNumeric = require_fast_isnumeric();
    var loggers = require_loggers();
    var identity = require_identity2();
    var BADNUM = require_numerical().BADNUM;
    var roundingError = 1e-9;
    exports2.findBin = function(val, bins, linelow) {
      if (isNumeric(bins.start)) {
        return linelow ? Math.ceil((val - bins.start) / bins.size - roundingError) - 1 : Math.floor((val - bins.start) / bins.size + roundingError);
      } else {
        var n12 = 0;
        var n2 = bins.length;
        var c = 0;
        var binSize = n2 > 1 ? (bins[n2 - 1] - bins[0]) / (n2 - 1) : 1;
        var n, test;
        if (binSize >= 0) {
          test = linelow ? lessThan : lessOrEqual;
        } else {
          test = linelow ? greaterOrEqual : greaterThan;
        }
        val += binSize * roundingError * (linelow ? -1 : 1) * (binSize >= 0 ? 1 : -1);
        while (n12 < n2 && c++ < 100) {
          n = Math.floor((n12 + n2) / 2);
          if (test(bins[n], val)) n12 = n + 1;
          else n2 = n;
        }
        if (c > 90) loggers.log("Long binary search...");
        return n12 - 1;
      }
    };
    function lessThan(a, b) {
      return a < b;
    }
    function lessOrEqual(a, b) {
      return a <= b;
    }
    function greaterThan(a, b) {
      return a > b;
    }
    function greaterOrEqual(a, b) {
      return a >= b;
    }
    exports2.sorterAsc = function(a, b) {
      return a - b;
    };
    exports2.sorterDes = function(a, b) {
      return b - a;
    };
    exports2.distinctVals = function(valsIn) {
      var vals = valsIn.slice();
      vals.sort(exports2.sorterAsc);
      var last;
      for (last = vals.length - 1; last > -1; last--) {
        if (vals[last] !== BADNUM) break;
      }
      var minDiff = vals[last] - vals[0] || 1;
      var errDiff = minDiff / (last || 1) / 1e4;
      var newVals = [];
      var preV;
      for (var i = 0; i <= last; i++) {
        var v = vals[i];
        var diff = v - preV;
        if (preV === void 0) {
          newVals.push(v);
          preV = v;
        } else if (diff > errDiff) {
          minDiff = Math.min(minDiff, diff);
          newVals.push(v);
          preV = v;
        }
      }
      return { vals: newVals, minDiff };
    };
    exports2.roundUp = function(val, arrayIn, reverse) {
      var low = 0;
      var high = arrayIn.length - 1;
      var mid;
      var c = 0;
      var dlow = reverse ? 0 : 1;
      var dhigh = reverse ? 1 : 0;
      var rounded = reverse ? Math.ceil : Math.floor;
      while (low < high && c++ < 100) {
        mid = rounded((low + high) / 2);
        if (arrayIn[mid] <= val) low = mid + dlow;
        else high = mid - dhigh;
      }
      return arrayIn[low];
    };
    exports2.sort = function(array, sortFn) {
      var notOrdered = 0;
      var notReversed = 0;
      for (var i = 1; i < array.length; i++) {
        var pairOrder = sortFn(array[i], array[i - 1]);
        if (pairOrder < 0) notOrdered = 1;
        else if (pairOrder > 0) notReversed = 1;
        if (notOrdered && notReversed) return array.sort(sortFn);
      }
      return notReversed ? array : array.reverse();
    };
    exports2.findIndexOfMin = function(arr, fn) {
      fn = fn || identity;
      var min = Infinity;
      var ind;
      for (var i = 0; i < arr.length; i++) {
        var v = fn(arr[i]);
        if (v < min) {
          min = v;
          ind = i;
        }
      }
      return ind;
    };
  }
});

// node_modules/plotly.js/src/lib/sort_object_keys.js
var require_sort_object_keys = __commonJS({
  "node_modules/plotly.js/src/lib/sort_object_keys.js"(exports2, module2) {
    "use strict";
    module2.exports = function sortObjectKeys(obj) {
      return Object.keys(obj).sort();
    };
  }
});

// node_modules/plotly.js/src/lib/stats.js
var require_stats = __commonJS({
  "node_modules/plotly.js/src/lib/stats.js"(exports2) {
    "use strict";
    var isNumeric = require_fast_isnumeric();
    var isArrayOrTypedArray = require_array().isArrayOrTypedArray;
    exports2.aggNums = function(f, v, a, len) {
      var i, b;
      if (!len || len > a.length) len = a.length;
      if (!isNumeric(v)) v = false;
      if (isArrayOrTypedArray(a[0])) {
        b = new Array(len);
        for (i = 0; i < len; i++) b[i] = exports2.aggNums(f, v, a[i]);
        a = b;
      }
      for (i = 0; i < len; i++) {
        if (!isNumeric(v)) v = a[i];
        else if (isNumeric(a[i])) v = f(+v, +a[i]);
      }
      return v;
    };
    exports2.len = function(data) {
      return exports2.aggNums(function(a) {
        return a + 1;
      }, 0, data);
    };
    exports2.mean = function(data, len) {
      if (!len) len = exports2.len(data);
      return exports2.aggNums(function(a, b) {
        return a + b;
      }, 0, data) / len;
    };
    exports2.geometricMean = function(data, len) {
      if (!len) len = exports2.len(data);
      return Math.pow(exports2.aggNums(function(a, b) {
        return a * b;
      }, 1, data), 1 / len);
    };
    exports2.midRange = function(numArr) {
      if (numArr === void 0 || numArr.length === 0) return void 0;
      return (exports2.aggNums(Math.max, null, numArr) + exports2.aggNums(Math.min, null, numArr)) / 2;
    };
    exports2.variance = function(data, len, mean) {
      if (!len) len = exports2.len(data);
      if (!isNumeric(mean)) mean = exports2.mean(data, len);
      return exports2.aggNums(function(a, b) {
        return a + Math.pow(b - mean, 2);
      }, 0, data) / len;
    };
    exports2.stdev = function(data, len, mean) {
      return Math.sqrt(exports2.variance(data, len, mean));
    };
    exports2.median = function(data) {
      var b = data.slice().sort();
      return exports2.interp(b, 0.5);
    };
    exports2.interp = function(arr, n) {
      if (!isNumeric(n)) throw "n should be a finite number";
      n = n * arr.length - 0.5;
      if (n < 0) return arr[0];
      if (n > arr.length - 1) return arr[arr.length - 1];
      var frac = n % 1;
      return frac * arr[Math.ceil(n)] + (1 - frac) * arr[Math.floor(n)];
    };
  }
});

// node_modules/plotly.js/src/lib/angles.js
var require_angles = __commonJS({
  "node_modules/plotly.js/src/lib/angles.js"(exports2, module2) {
    "use strict";
    var modModule = require_mod();
    var mod = modModule.mod;
    var modHalf = modModule.modHalf;
    var PI = Math.PI;
    var twoPI = 2 * PI;
    function deg2rad(deg) {
      return deg / 180 * PI;
    }
    function rad2deg(rad) {
      return rad / PI * 180;
    }
    function isFullCircle(aBnds) {
      return Math.abs(aBnds[1] - aBnds[0]) > twoPI - 1e-14;
    }
    function angleDelta(a, b) {
      return modHalf(b - a, twoPI);
    }
    function angleDist(a, b) {
      return Math.abs(angleDelta(a, b));
    }
    function isAngleInsideSector(a, aBnds) {
      if (isFullCircle(aBnds)) return true;
      var s02, s12;
      if (aBnds[0] < aBnds[1]) {
        s02 = aBnds[0];
        s12 = aBnds[1];
      } else {
        s02 = aBnds[1];
        s12 = aBnds[0];
      }
      s02 = mod(s02, twoPI);
      s12 = mod(s12, twoPI);
      if (s02 > s12) s12 += twoPI;
      var a02 = mod(a, twoPI);
      var a12 = a02 + twoPI;
      return a02 >= s02 && a02 <= s12 || a12 >= s02 && a12 <= s12;
    }
    function isPtInsideSector(r, a, rBnds, aBnds) {
      if (!isAngleInsideSector(a, aBnds)) return false;
      var r02, r12;
      if (rBnds[0] < rBnds[1]) {
        r02 = rBnds[0];
        r12 = rBnds[1];
      } else {
        r02 = rBnds[1];
        r12 = rBnds[0];
      }
      return r >= r02 && r <= r12;
    }
    function _path(r02, r12, a02, a12, cx, cy, isClosed) {
      cx = cx || 0;
      cy = cy || 0;
      var isCircle = isFullCircle([a02, a12]);
      var aStart, aMid, aEnd;
      var rStart, rEnd;
      if (isCircle) {
        aStart = 0;
        aMid = PI;
        aEnd = twoPI;
      } else {
        if (a02 < a12) {
          aStart = a02;
          aEnd = a12;
        } else {
          aStart = a12;
          aEnd = a02;
        }
      }
      if (r02 < r12) {
        rStart = r02;
        rEnd = r12;
      } else {
        rStart = r12;
        rEnd = r02;
      }
      function pt2(r, a) {
        return [r * Math.cos(a) + cx, cy - r * Math.sin(a)];
      }
      var largeArc = Math.abs(aEnd - aStart) <= PI ? 0 : 1;
      function arc(r, a, cw) {
        return "A" + [r, r] + " " + [0, largeArc, cw] + " " + pt2(r, a);
      }
      var p;
      if (isCircle) {
        if (rStart === null) {
          p = "M" + pt2(rEnd, aStart) + arc(rEnd, aMid, 0) + arc(rEnd, aEnd, 0) + "Z";
        } else {
          p = "M" + pt2(rStart, aStart) + arc(rStart, aMid, 0) + arc(rStart, aEnd, 0) + "ZM" + pt2(rEnd, aStart) + arc(rEnd, aMid, 1) + arc(rEnd, aEnd, 1) + "Z";
        }
      } else {
        if (rStart === null) {
          p = "M" + pt2(rEnd, aStart) + arc(rEnd, aEnd, 0);
          if (isClosed) p += "L0,0Z";
        } else {
          p = "M" + pt2(rStart, aStart) + "L" + pt2(rEnd, aStart) + arc(rEnd, aEnd, 0) + "L" + pt2(rStart, aEnd) + arc(rStart, aStart, 1) + "Z";
        }
      }
      return p;
    }
    function pathArc(r, a02, a12, cx, cy) {
      return _path(null, r, a02, a12, cx, cy, 0);
    }
    function pathSector(r, a02, a12, cx, cy) {
      return _path(null, r, a02, a12, cx, cy, 1);
    }
    function pathAnnulus(r02, r12, a02, a12, cx, cy) {
      return _path(r02, r12, a02, a12, cx, cy, 1);
    }
    module2.exports = {
      deg2rad,
      rad2deg,
      angleDelta,
      angleDist,
      isFullCircle,
      isAngleInsideSector,
      isPtInsideSector,
      pathArc,
      pathSector,
      pathAnnulus
    };
  }
});

// node_modules/plotly.js/src/lib/anchor_utils.js
var require_anchor_utils = __commonJS({
  "node_modules/plotly.js/src/lib/anchor_utils.js"(exports2) {
    "use strict";
    exports2.isLeftAnchor = function isLeftAnchor(opts) {
      return opts.xanchor === "left" || opts.xanchor === "auto" && opts.x <= 1 / 3;
    };
    exports2.isCenterAnchor = function isCenterAnchor(opts) {
      return opts.xanchor === "center" || opts.xanchor === "auto" && opts.x > 1 / 3 && opts.x < 2 / 3;
    };
    exports2.isRightAnchor = function isRightAnchor(opts) {
      return opts.xanchor === "right" || opts.xanchor === "auto" && opts.x >= 2 / 3;
    };
    exports2.isTopAnchor = function isTopAnchor(opts) {
      return opts.yanchor === "top" || opts.yanchor === "auto" && opts.y >= 2 / 3;
    };
    exports2.isMiddleAnchor = function isMiddleAnchor(opts) {
      return opts.yanchor === "middle" || opts.yanchor === "auto" && opts.y > 1 / 3 && opts.y < 2 / 3;
    };
    exports2.isBottomAnchor = function isBottomAnchor(opts) {
      return opts.yanchor === "bottom" || opts.yanchor === "auto" && opts.y <= 1 / 3;
    };
  }
});

// node_modules/plotly.js/src/lib/geometry2d.js
var require_geometry2d = __commonJS({
  "node_modules/plotly.js/src/lib/geometry2d.js"(exports2) {
    "use strict";
    var mod = require_mod().mod;
    exports2.segmentsIntersect = segmentsIntersect;
    function segmentsIntersect(x12, y12, x2, y2, x3, y3, x4, y4) {
      var a = x2 - x12;
      var b = x3 - x12;
      var c = x4 - x3;
      var d = y2 - y12;
      var e = y3 - y12;
      var f = y4 - y3;
      var det = a * f - c * d;
      if (det === 0) return null;
      var t = (b * f - c * e) / det;
      var u = (b * d - a * e) / det;
      if (u < 0 || u > 1 || t < 0 || t > 1) return null;
      return { x: x12 + a * t, y: y12 + d * t };
    }
    exports2.segmentDistance = function segmentDistance(x12, y12, x2, y2, x3, y3, x4, y4) {
      if (segmentsIntersect(x12, y12, x2, y2, x3, y3, x4, y4)) return 0;
      var x122 = x2 - x12;
      var y122 = y2 - y12;
      var x34 = x4 - x3;
      var y34 = y4 - y3;
      var ll12 = x122 * x122 + y122 * y122;
      var ll34 = x34 * x34 + y34 * y34;
      var dist2 = Math.min(
        perpDistance2(x122, y122, ll12, x3 - x12, y3 - y12),
        perpDistance2(x122, y122, ll12, x4 - x12, y4 - y12),
        perpDistance2(x34, y34, ll34, x12 - x3, y12 - y3),
        perpDistance2(x34, y34, ll34, x2 - x3, y2 - y3)
      );
      return Math.sqrt(dist2);
    };
    function perpDistance2(xab, yab, llab, xac, yac) {
      var fcAB = xac * xab + yac * yab;
      if (fcAB < 0) {
        return xac * xac + yac * yac;
      } else if (fcAB > llab) {
        var xbc = xac - xab;
        var ybc = yac - yab;
        return xbc * xbc + ybc * ybc;
      } else {
        var crossProduct = xac * yab - yac * xab;
        return crossProduct * crossProduct / llab;
      }
    }
    var locationCache;
    var workingPath;
    var workingTextWidth;
    exports2.getTextLocation = function getTextLocation(path, totalPathLen, positionOnPath, textWidth) {
      if (path !== workingPath || textWidth !== workingTextWidth) {
        locationCache = {};
        workingPath = path;
        workingTextWidth = textWidth;
      }
      if (locationCache[positionOnPath]) {
        return locationCache[positionOnPath];
      }
      var p02 = path.getPointAtLength(mod(positionOnPath - textWidth / 2, totalPathLen));
      var p12 = path.getPointAtLength(mod(positionOnPath + textWidth / 2, totalPathLen));
      var theta = Math.atan((p12.y - p02.y) / (p12.x - p02.x));
      var pCenter = path.getPointAtLength(mod(positionOnPath, totalPathLen));
      var x = (pCenter.x * 4 + p02.x + p12.x) / 6;
      var y = (pCenter.y * 4 + p02.y + p12.y) / 6;
      var out = { x, y, theta };
      locationCache[positionOnPath] = out;
      return out;
    };
    exports2.clearLocationCache = function() {
      workingPath = null;
    };
    exports2.getVisibleSegment = function getVisibleSegment(path, bounds, buffer) {
      var left = bounds.left;
      var right = bounds.right;
      var top = bounds.top;
      var bottom = bounds.bottom;
      var pMin = 0;
      var pTotal = path.getTotalLength();
      var pMax = pTotal;
      var pt0, ptTotal;
      function getDistToPlot(len) {
        var pt2 = path.getPointAtLength(len);
        if (len === 0) pt0 = pt2;
        else if (len === pTotal) ptTotal = pt2;
        var dx = pt2.x < left ? left - pt2.x : pt2.x > right ? pt2.x - right : 0;
        var dy = pt2.y < top ? top - pt2.y : pt2.y > bottom ? pt2.y - bottom : 0;
        return Math.sqrt(dx * dx + dy * dy);
      }
      var distToPlot = getDistToPlot(pMin);
      while (distToPlot) {
        pMin += distToPlot + buffer;
        if (pMin > pMax) return;
        distToPlot = getDistToPlot(pMin);
      }
      distToPlot = getDistToPlot(pMax);
      while (distToPlot) {
        pMax -= distToPlot + buffer;
        if (pMin > pMax) return;
        distToPlot = getDistToPlot(pMax);
      }
      return {
        min: pMin,
        max: pMax,
        len: pMax - pMin,
        total: pTotal,
        isClosed: pMin === 0 && pMax === pTotal && Math.abs(pt0.x - ptTotal.x) < 0.1 && Math.abs(pt0.y - ptTotal.y) < 0.1
      };
    };
    exports2.findPointOnPath = function findPointOnPath(path, val, coord, opts) {
      opts = opts || {};
      var pathLength = opts.pathLength || path.getTotalLength();
      var tolerance = opts.tolerance || 1e-3;
      var iterationLimit = opts.iterationLimit || 30;
      var mul = path.getPointAtLength(0)[coord] > path.getPointAtLength(pathLength)[coord] ? -1 : 1;
      var i = 0;
      var b02 = 0;
      var b12 = pathLength;
      var mid;
      var pt2;
      var diff;
      while (i < iterationLimit) {
        mid = (b02 + b12) / 2;
        pt2 = path.getPointAtLength(mid);
        diff = pt2[coord] - val;
        if (Math.abs(diff) < tolerance) {
          return pt2;
        } else {
          if (mul * diff > 0) {
            b12 = mid;
          } else {
            b02 = mid;
          }
          i++;
        }
      }
      return pt2;
    };
  }
});

// node_modules/plotly.js/src/lib/throttle.js
var require_throttle = __commonJS({
  "node_modules/plotly.js/src/lib/throttle.js"(exports2) {
    "use strict";
    var timerCache = {};
    exports2.throttle = function throttle(id2, minInterval, callback) {
      var cache = timerCache[id2];
      var now = Date.now();
      if (!cache) {
        for (var idi in timerCache) {
          if (timerCache[idi].ts < now - 6e4) {
            delete timerCache[idi];
          }
        }
        cache = timerCache[id2] = { ts: 0, timer: null };
      }
      _clearTimeout(cache);
      function exec() {
        callback();
        cache.ts = Date.now();
        if (cache.onDone) {
          cache.onDone();
          cache.onDone = null;
        }
      }
      if (now > cache.ts + minInterval) {
        exec();
        return;
      }
      cache.timer = setTimeout(function() {
        exec();
        cache.timer = null;
      }, minInterval);
    };
    exports2.done = function(id2) {
      var cache = timerCache[id2];
      if (!cache || !cache.timer) return Promise.resolve();
      return new Promise(function(resolve) {
        var previousOnDone = cache.onDone;
        cache.onDone = function onDone() {
          if (previousOnDone) previousOnDone();
          resolve();
          cache.onDone = null;
        };
      });
    };
    exports2.clear = function(id2) {
      if (id2) {
        _clearTimeout(timerCache[id2]);
        delete timerCache[id2];
      } else {
        for (var idi in timerCache) exports2.clear(idi);
      }
    };
    function _clearTimeout(cache) {
      if (cache && cache.timer !== null) {
        clearTimeout(cache.timer);
        cache.timer = null;
      }
    }
  }
});

// node_modules/plotly.js/src/lib/clear_responsive.js
var require_clear_responsive = __commonJS({
  "node_modules/plotly.js/src/lib/clear_responsive.js"(exports2, module2) {
    "use strict";
    module2.exports = function clearResponsive(gd2) {
      if (gd2._responsiveChartHandler) {
        window.removeEventListener("resize", gd2._responsiveChartHandler);
        delete gd2._responsiveChartHandler;
      }
    };
  }
});

// node_modules/is-mobile/index.js
var require_is_mobile = __commonJS({
  "node_modules/is-mobile/index.js"(exports2, module2) {
    "use strict";
    module2.exports = isMobile;
    module2.exports.isMobile = isMobile;
    module2.exports.default = isMobile;
    var mobileRE = /(android|bb\d+|meego).+mobile|armv7l|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series[46]0|samsungbrowser.*mobile|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i;
    var notMobileRE = /CrOS/;
    var tabletRE = /android|ipad|playbook|silk/i;
    function isMobile(opts) {
      if (!opts) opts = {};
      let ua2 = opts.ua;
      if (!ua2 && typeof navigator !== "undefined") ua2 = navigator.userAgent;
      if (ua2 && ua2.headers && typeof ua2.headers["user-agent"] === "string") {
        ua2 = ua2.headers["user-agent"];
      }
      if (typeof ua2 !== "string") return false;
      let result = mobileRE.test(ua2) && !notMobileRE.test(ua2) || !!opts.tablet && tabletRE.test(ua2);
      if (!result && opts.tablet && opts.featureDetect && navigator && navigator.maxTouchPoints > 1 && ua2.indexOf("Macintosh") !== -1 && ua2.indexOf("Safari") !== -1) {
        result = true;
      }
      return result;
    }
  }
});

// node_modules/plotly.js/src/lib/preserve_drawing_buffer.js
var require_preserve_drawing_buffer = __commonJS({
  "node_modules/plotly.js/src/lib/preserve_drawing_buffer.js"(exports2, module2) {
    "use strict";
    var isNumeric = require_fast_isnumeric();
    var isMobileOrTablet = require_is_mobile();
    module2.exports = function preserveDrawingBuffer(opts) {
      var ua2;
      if (opts && opts.hasOwnProperty("userAgent")) {
        ua2 = opts.userAgent;
      } else {
        ua2 = getUserAgent();
      }
      if (typeof ua2 !== "string") return true;
      var enable = isMobileOrTablet({
        ua: { headers: { "user-agent": ua2 } },
        tablet: true,
        featureDetect: false
      });
      if (!enable) {
        var allParts = ua2.split(" ");
        for (var i = 1; i < allParts.length; i++) {
          var part = allParts[i];
          if (part.indexOf("Safari") !== -1) {
            for (var k = i - 1; k > -1; k--) {
              var prevPart = allParts[k];
              if (prevPart.substr(0, 8) === "Version/") {
                var v = prevPart.substr(8).split(".")[0];
                if (isNumeric(v)) v = +v;
                if (v >= 13) return true;
              }
            }
          }
        }
      }
      return enable;
    };
    function getUserAgent() {
      var ua2;
      if (typeof navigator !== "undefined") {
        ua2 = navigator.userAgent;
      }
      if (ua2 && ua2.headers && typeof ua2.headers["user-agent"] === "string") {
        ua2 = ua2.headers["user-agent"];
      }
      return ua2;
    }
  }
});

// node_modules/plotly.js/src/lib/make_trace_groups.js
var require_make_trace_groups = __commonJS({
  "node_modules/plotly.js/src/lib/make_trace_groups.js"(exports2, module2) {
    "use strict";
    var d3 = require_d3();
    module2.exports = function makeTraceGroups(traceLayer, cdModule, cls) {
      var traces = traceLayer.selectAll("g." + cls.replace(/\s/g, ".")).data(cdModule, function(cd2) {
        return cd2[0].trace.uid;
      });
      traces.exit().remove();
      traces.enter().append("g").attr("class", cls);
      traces.order();
      var k = traceLayer.classed("rangeplot") ? "nodeRangePlot3" : "node3";
      traces.each(function(cd2) {
        cd2[0][k] = d3.select(this);
      });
      return traces;
    };
  }
});

// node_modules/plotly.js/src/lib/localize.js
var require_localize = __commonJS({
  "node_modules/plotly.js/src/lib/localize.js"(exports2, module2) {
    "use strict";
    var Registry = require_registry();
    module2.exports = function localize(gd2, s) {
      var locale3 = gd2._context.locale;
      for (var i = 0; i < 2; i++) {
        var locales = gd2._context.locales;
        for (var j = 0; j < 2; j++) {
          var dict = (locales[locale3] || {}).dictionary;
          if (dict) {
            var out = dict[s];
            if (out) return out;
          }
          locales = Registry.localeRegistry;
        }
        var baseLocale = locale3.split("-")[0];
        if (baseLocale === locale3) break;
        locale3 = baseLocale;
      }
      return s;
    };
  }
});

// node_modules/plotly.js/src/lib/filter_unique.js
var require_filter_unique = __commonJS({
  "node_modules/plotly.js/src/lib/filter_unique.js"(exports2, module2) {
    "use strict";
    module2.exports = function filterUnique(array) {
      var seen = {};
      var out = [];
      var j = 0;
      for (var i = 0; i < array.length; i++) {
        var item = array[i];
        if (seen[item] !== 1) {
          seen[item] = 1;
          out[j++] = item;
        }
      }
      return out;
    };
  }
});

// node_modules/plotly.js/src/lib/filter_visible.js
var require_filter_visible = __commonJS({
  "node_modules/plotly.js/src/lib/filter_visible.js"(exports2, module2) {
    "use strict";
    module2.exports = function filterVisible(container) {
      var filterFn = isCalcData(container) ? calcDataFilter : baseFilter;
      var out = [];
      for (var i = 0; i < container.length; i++) {
        var item = container[i];
        if (filterFn(item)) out.push(item);
      }
      return out;
    };
    function baseFilter(item) {
      return item.visible === true;
    }
    function calcDataFilter(item) {
      var trace = item[0].trace;
      return trace.visible === true && trace._length !== 0;
    }
    function isCalcData(cont) {
      return Array.isArray(cont) && Array.isArray(cont[0]) && cont[0][0] && cont[0][0].trace;
    }
  }
});

// node_modules/plotly.js/src/lib/increment.js
var require_increment = __commonJS({
  "node_modules/plotly.js/src/lib/increment.js"(exports2, module2) {
    "use strict";
    module2.exports = function incrementNumeric(x, delta) {
      if (!delta) return x;
      var scale = 1 / Math.abs(delta);
      var newX = scale > 1 ? (scale * x + scale * delta) / scale : x + delta;
      var lenX1 = String(newX).length;
      if (lenX1 > 16) {
        var lenDt = String(delta).length;
        var lenX0 = String(x).length;
        if (lenX1 >= lenX0 + lenDt) {
          var s = parseFloat(newX).toPrecision(12);
          if (s.indexOf("e+") === -1) newX = +s;
        }
      }
      return newX;
    };
  }
});

// node_modules/plotly.js/src/lib/clean_number.js
var require_clean_number = __commonJS({
  "node_modules/plotly.js/src/lib/clean_number.js"(exports2, module2) {
    "use strict";
    var isNumeric = require_fast_isnumeric();
    var BADNUM = require_numerical().BADNUM;
    var JUNK = /^['"%,$#\s']+|[, ]|['"%,$#\s']+$/g;
    module2.exports = function cleanNumber(v) {
      if (typeof v === "string") {
        v = v.replace(JUNK, "");
      }
      if (isNumeric(v)) return Number(v);
      return BADNUM;
    };
  }
});

// node_modules/plotly.js/src/lib/index.js
var require_lib = __commonJS({
  "node_modules/plotly.js/src/lib/index.js"(exports2, module2) {
    "use strict";
    var d3 = require_d3();
    var utcFormat2 = (init_src2(), __toCommonJS(src_exports2)).utcFormat;
    var d3Format = (init_src3(), __toCommonJS(src_exports3)).format;
    var isNumeric = require_fast_isnumeric();
    var numConstants = require_numerical();
    var MAX_SAFE = numConstants.FP_SAFE;
    var MIN_SAFE = -MAX_SAFE;
    var BADNUM = numConstants.BADNUM;
    var lib = module2.exports = {};
    lib.adjustFormat = function adjustFormat(formatStr) {
      if (!formatStr || /^\d[.]\df/.test(formatStr) || /[.]\d%/.test(formatStr)) return formatStr;
      if (formatStr === "0.f") return "~f";
      if (/^\d%/.test(formatStr)) return "~%";
      if (/^\ds/.test(formatStr)) return "~s";
      if (!/^[~,.0$]/.test(formatStr) && /[&fps]/.test(formatStr)) return "~" + formatStr;
      return formatStr;
    };
    var seenBadFormats = {};
    lib.warnBadFormat = function(f) {
      var key = String(f);
      if (!seenBadFormats[key]) {
        seenBadFormats[key] = 1;
        lib.warn('encountered bad format: "' + key + '"');
      }
    };
    lib.noFormat = function(value) {
      return String(value);
    };
    lib.numberFormat = function(formatStr) {
      var fn;
      try {
        fn = d3Format(lib.adjustFormat(formatStr));
      } catch (e) {
        lib.warnBadFormat(formatStr);
        return lib.noFormat;
      }
      return fn;
    };
    lib.nestedProperty = require_nested_property();
    lib.keyedContainer = require_keyed_container();
    lib.relativeAttr = require_relative_attr();
    lib.isPlainObject = require_is_plain_object();
    lib.toLogRange = require_to_log_range();
    lib.relinkPrivateKeys = require_relink_private();
    var arrayModule = require_array();
    lib.isArrayBuffer = arrayModule.isArrayBuffer;
    lib.isTypedArray = arrayModule.isTypedArray;
    lib.isArrayOrTypedArray = arrayModule.isArrayOrTypedArray;
    lib.isArray1D = arrayModule.isArray1D;
    lib.ensureArray = arrayModule.ensureArray;
    lib.concat = arrayModule.concat;
    lib.maxRowLength = arrayModule.maxRowLength;
    lib.minRowLength = arrayModule.minRowLength;
    var modModule = require_mod();
    lib.mod = modModule.mod;
    lib.modHalf = modModule.modHalf;
    var coerceModule = require_coerce();
    lib.valObjectMeta = coerceModule.valObjectMeta;
    lib.coerce = coerceModule.coerce;
    lib.coerce2 = coerceModule.coerce2;
    lib.coerceFont = coerceModule.coerceFont;
    lib.coercePattern = coerceModule.coercePattern;
    lib.coerceHoverinfo = coerceModule.coerceHoverinfo;
    lib.coerceSelectionMarkerOpacity = coerceModule.coerceSelectionMarkerOpacity;
    lib.validate = coerceModule.validate;
    var datesModule = require_dates();
    lib.dateTime2ms = datesModule.dateTime2ms;
    lib.isDateTime = datesModule.isDateTime;
    lib.ms2DateTime = datesModule.ms2DateTime;
    lib.ms2DateTimeLocal = datesModule.ms2DateTimeLocal;
    lib.cleanDate = datesModule.cleanDate;
    lib.isJSDate = datesModule.isJSDate;
    lib.formatDate = datesModule.formatDate;
    lib.incrementMonth = datesModule.incrementMonth;
    lib.dateTick0 = datesModule.dateTick0;
    lib.dfltRange = datesModule.dfltRange;
    lib.findExactDates = datesModule.findExactDates;
    lib.MIN_MS = datesModule.MIN_MS;
    lib.MAX_MS = datesModule.MAX_MS;
    var searchModule = require_search();
    lib.findBin = searchModule.findBin;
    lib.sorterAsc = searchModule.sorterAsc;
    lib.sorterDes = searchModule.sorterDes;
    lib.distinctVals = searchModule.distinctVals;
    lib.roundUp = searchModule.roundUp;
    lib.sort = searchModule.sort;
    lib.findIndexOfMin = searchModule.findIndexOfMin;
    lib.sortObjectKeys = require_sort_object_keys();
    var statsModule = require_stats();
    lib.aggNums = statsModule.aggNums;
    lib.len = statsModule.len;
    lib.mean = statsModule.mean;
    lib.geometricMean = statsModule.geometricMean;
    lib.median = statsModule.median;
    lib.midRange = statsModule.midRange;
    lib.variance = statsModule.variance;
    lib.stdev = statsModule.stdev;
    lib.interp = statsModule.interp;
    var matrixModule = require_matrix();
    lib.init2dArray = matrixModule.init2dArray;
    lib.transposeRagged = matrixModule.transposeRagged;
    lib.dot = matrixModule.dot;
    lib.translationMatrix = matrixModule.translationMatrix;
    lib.rotationMatrix = matrixModule.rotationMatrix;
    lib.rotationXYMatrix = matrixModule.rotationXYMatrix;
    lib.apply3DTransform = matrixModule.apply3DTransform;
    lib.apply2DTransform = matrixModule.apply2DTransform;
    lib.apply2DTransform2 = matrixModule.apply2DTransform2;
    lib.convertCssMatrix = matrixModule.convertCssMatrix;
    lib.inverseTransformMatrix = matrixModule.inverseTransformMatrix;
    var anglesModule = require_angles();
    lib.deg2rad = anglesModule.deg2rad;
    lib.rad2deg = anglesModule.rad2deg;
    lib.angleDelta = anglesModule.angleDelta;
    lib.angleDist = anglesModule.angleDist;
    lib.isFullCircle = anglesModule.isFullCircle;
    lib.isAngleInsideSector = anglesModule.isAngleInsideSector;
    lib.isPtInsideSector = anglesModule.isPtInsideSector;
    lib.pathArc = anglesModule.pathArc;
    lib.pathSector = anglesModule.pathSector;
    lib.pathAnnulus = anglesModule.pathAnnulus;
    var anchorUtils = require_anchor_utils();
    lib.isLeftAnchor = anchorUtils.isLeftAnchor;
    lib.isCenterAnchor = anchorUtils.isCenterAnchor;
    lib.isRightAnchor = anchorUtils.isRightAnchor;
    lib.isTopAnchor = anchorUtils.isTopAnchor;
    lib.isMiddleAnchor = anchorUtils.isMiddleAnchor;
    lib.isBottomAnchor = anchorUtils.isBottomAnchor;
    var geom2dModule = require_geometry2d();
    lib.segmentsIntersect = geom2dModule.segmentsIntersect;
    lib.segmentDistance = geom2dModule.segmentDistance;
    lib.getTextLocation = geom2dModule.getTextLocation;
    lib.clearLocationCache = geom2dModule.clearLocationCache;
    lib.getVisibleSegment = geom2dModule.getVisibleSegment;
    lib.findPointOnPath = geom2dModule.findPointOnPath;
    var extendModule = require_extend();
    lib.extendFlat = extendModule.extendFlat;
    lib.extendDeep = extendModule.extendDeep;
    lib.extendDeepAll = extendModule.extendDeepAll;
    lib.extendDeepNoArrays = extendModule.extendDeepNoArrays;
    var loggersModule = require_loggers();
    lib.log = loggersModule.log;
    lib.warn = loggersModule.warn;
    lib.error = loggersModule.error;
    var regexModule = require_regex();
    lib.counterRegex = regexModule.counter;
    var throttleModule = require_throttle();
    lib.throttle = throttleModule.throttle;
    lib.throttleDone = throttleModule.done;
    lib.clearThrottle = throttleModule.clear;
    var domModule = require_dom();
    lib.getGraphDiv = domModule.getGraphDiv;
    lib.isPlotDiv = domModule.isPlotDiv;
    lib.removeElement = domModule.removeElement;
    lib.addStyleRule = domModule.addStyleRule;
    lib.addRelatedStyleRule = domModule.addRelatedStyleRule;
    lib.deleteRelatedStyleRule = domModule.deleteRelatedStyleRule;
    lib.getFullTransformMatrix = domModule.getFullTransformMatrix;
    lib.getElementTransformMatrix = domModule.getElementTransformMatrix;
    lib.getElementAndAncestors = domModule.getElementAndAncestors;
    lib.equalDomRects = domModule.equalDomRects;
    lib.clearResponsive = require_clear_responsive();
    lib.preserveDrawingBuffer = require_preserve_drawing_buffer();
    lib.makeTraceGroups = require_make_trace_groups();
    lib._ = require_localize();
    lib.notifier = require_notifier();
    lib.filterUnique = require_filter_unique();
    lib.filterVisible = require_filter_visible();
    lib.pushUnique = require_push_unique();
    lib.increment = require_increment();
    lib.cleanNumber = require_clean_number();
    lib.ensureNumber = function ensureNumber(v) {
      if (!isNumeric(v)) return BADNUM;
      v = Number(v);
      return v > MAX_SAFE || v < MIN_SAFE ? BADNUM : v;
    };
    lib.isIndex = function(v, len) {
      if (len !== void 0 && v >= len) return false;
      return isNumeric(v) && v >= 0 && v % 1 === 0;
    };
    lib.noop = require_noop();
    lib.identity = require_identity2();
    lib.repeat = function(v, cnt) {
      var out = new Array(cnt);
      for (var i = 0; i < cnt; i++) {
        out[i] = v;
      }
      return out;
    };
    lib.swapAttrs = function(cont, attrList, part1, part2) {
      if (!part1) part1 = "x";
      if (!part2) part2 = "y";
      for (var i = 0; i < attrList.length; i++) {
        var attr = attrList[i];
        var xp2 = lib.nestedProperty(cont, attr.replace("?", part1));
        var yp2 = lib.nestedProperty(cont, attr.replace("?", part2));
        var temp = xp2.get();
        xp2.set(yp2.get());
        yp2.set(temp);
      }
    };
    lib.raiseToTop = function raiseToTop(elem) {
      elem.parentNode.appendChild(elem);
    };
    lib.cancelTransition = function(selection) {
      return selection.transition().duration(0);
    };
    lib.constrain = function(v, v02, v12) {
      if (v02 > v12) return Math.max(v12, Math.min(v02, v));
      return Math.max(v02, Math.min(v12, v));
    };
    lib.bBoxIntersect = function(a, b, pad2) {
      pad2 = pad2 || 0;
      return a.left <= b.right + pad2 && b.left <= a.right + pad2 && a.top <= b.bottom + pad2 && b.top <= a.bottom + pad2;
    };
    lib.simpleMap = function(array, func, x12, x2, opts) {
      var len = array.length;
      var out = new Array(len);
      for (var i = 0; i < len; i++) out[i] = func(array[i], x12, x2, opts);
      return out;
    };
    lib.randstr = function randstr(existing, bits, base, _recursion) {
      if (!base) base = 16;
      if (bits === void 0) bits = 24;
      if (bits <= 0) return "0";
      var digits = Math.log(Math.pow(2, bits)) / Math.log(base);
      var res = "";
      var i, b, x;
      for (i = 2; digits === Infinity; i *= 2) {
        digits = Math.log(Math.pow(2, bits / i)) / Math.log(base) * i;
      }
      var rem = digits - Math.floor(digits);
      for (i = 0; i < Math.floor(digits); i++) {
        x = Math.floor(Math.random() * base).toString(base);
        res = x + res;
      }
      if (rem) {
        b = Math.pow(base, rem);
        x = Math.floor(Math.random() * b).toString(base);
        res = x + res;
      }
      var parsed = parseInt(res, base);
      if (existing && existing[res] || parsed !== Infinity && parsed >= Math.pow(2, bits)) {
        if (_recursion > 10) {
          lib.warn("randstr failed uniqueness");
          return res;
        }
        return randstr(existing, bits, base, (_recursion || 0) + 1);
      } else return res;
    };
    lib.OptionControl = function(opt, optname) {
      if (!opt) opt = {};
      if (!optname) optname = "opt";
      var self2 = {};
      self2.optionList = [];
      self2._newoption = function(optObj) {
        optObj[optname] = opt;
        self2[optObj.name] = optObj;
        self2.optionList.push(optObj);
      };
      self2["_" + optname] = opt;
      return self2;
    };
    lib.smooth = function(arrayIn, FWHM) {
      FWHM = Math.round(FWHM) || 0;
      if (FWHM < 2) return arrayIn;
      var alen = arrayIn.length;
      var alen2 = 2 * alen;
      var wlen = 2 * FWHM - 1;
      var w = new Array(wlen);
      var arrayOut = new Array(alen);
      var i;
      var j;
      var k;
      var v;
      for (i = 0; i < wlen; i++) {
        w[i] = (1 - Math.cos(Math.PI * (i + 1) / FWHM)) / (2 * FWHM);
      }
      for (i = 0; i < alen; i++) {
        v = 0;
        for (j = 0; j < wlen; j++) {
          k = i + j + 1 - FWHM;
          if (k < -alen) k -= alen2 * Math.round(k / alen2);
          else if (k >= alen2) k -= alen2 * Math.floor(k / alen2);
          if (k < 0) k = -1 - k;
          else if (k >= alen) k = alen2 - 1 - k;
          v += arrayIn[k] * w[j];
        }
        arrayOut[i] = v;
      }
      return arrayOut;
    };
    lib.syncOrAsync = function(sequence, arg, finalStep) {
      var ret, fni;
      function continueAsync() {
        return lib.syncOrAsync(sequence, arg, finalStep);
      }
      while (sequence.length) {
        fni = sequence.splice(0, 1)[0];
        ret = fni(arg);
        if (ret && ret.then) {
          return ret.then(continueAsync);
        }
      }
      return finalStep && finalStep(arg);
    };
    lib.stripTrailingSlash = function(str) {
      if (str.substr(-1) === "/") return str.substr(0, str.length - 1);
      return str;
    };
    lib.noneOrAll = function(containerIn, containerOut, attrList) {
      if (!containerIn) return;
      var hasAny = false;
      var hasAll = true;
      var i;
      var val;
      for (i = 0; i < attrList.length; i++) {
        val = containerIn[attrList[i]];
        if (val !== void 0 && val !== null) hasAny = true;
        else hasAll = false;
      }
      if (hasAny && !hasAll) {
        for (i = 0; i < attrList.length; i++) {
          containerIn[attrList[i]] = containerOut[attrList[i]];
        }
      }
    };
    lib.mergeArray = function(traceAttr, cd2, cdAttr, fn) {
      var hasFn = typeof fn === "function";
      if (lib.isArrayOrTypedArray(traceAttr)) {
        var imax = Math.min(traceAttr.length, cd2.length);
        for (var i = 0; i < imax; i++) {
          var v = traceAttr[i];
          cd2[i][cdAttr] = hasFn ? fn(v) : v;
        }
      }
    };
    lib.mergeArrayCastPositive = function(traceAttr, cd2, cdAttr) {
      return lib.mergeArray(traceAttr, cd2, cdAttr, function(v) {
        var w = +v;
        return !isFinite(w) ? 0 : w > 0 ? w : 0;
      });
    };
    lib.fillArray = function(traceAttr, cd2, cdAttr, fn) {
      fn = fn || lib.identity;
      if (lib.isArrayOrTypedArray(traceAttr)) {
        for (var i = 0; i < cd2.length; i++) {
          cd2[i][cdAttr] = fn(traceAttr[i]);
        }
      }
    };
    lib.castOption = function(trace, ptNumber, astr, fn) {
      fn = fn || lib.identity;
      var val = lib.nestedProperty(trace, astr).get();
      if (lib.isArrayOrTypedArray(val)) {
        if (Array.isArray(ptNumber) && lib.isArrayOrTypedArray(val[ptNumber[0]])) {
          return fn(val[ptNumber[0]][ptNumber[1]]);
        } else {
          return fn(val[ptNumber]);
        }
      } else {
        return val;
      }
    };
    lib.extractOption = function(calcPt, trace, calcKey, traceKey) {
      if (calcKey in calcPt) return calcPt[calcKey];
      var traceVal = lib.nestedProperty(trace, traceKey).get();
      if (!Array.isArray(traceVal)) return traceVal;
    };
    function makePtIndex2PtNumber(indexToPoints) {
      var ptIndex2ptNumber = {};
      for (var k in indexToPoints) {
        var pts = indexToPoints[k];
        for (var j = 0; j < pts.length; j++) {
          ptIndex2ptNumber[pts[j]] = +k;
        }
      }
      return ptIndex2ptNumber;
    }
    lib.tagSelected = function(calcTrace, trace, ptNumber2cdIndex) {
      var selectedpoints = trace.selectedpoints;
      var indexToPoints = trace._indexToPoints;
      var ptIndex2ptNumber;
      if (indexToPoints) {
        ptIndex2ptNumber = makePtIndex2PtNumber(indexToPoints);
      }
      function isCdIndexValid(v) {
        return v !== void 0 && v < calcTrace.length;
      }
      for (var i = 0; i < selectedpoints.length; i++) {
        var ptIndex = selectedpoints[i];
        if (lib.isIndex(ptIndex) || lib.isArrayOrTypedArray(ptIndex) && lib.isIndex(ptIndex[0]) && lib.isIndex(ptIndex[1])) {
          var ptNumber = ptIndex2ptNumber ? ptIndex2ptNumber[ptIndex] : ptIndex;
          var cdIndex = ptNumber2cdIndex ? ptNumber2cdIndex[ptNumber] : ptNumber;
          if (isCdIndexValid(cdIndex)) {
            calcTrace[cdIndex].selected = 1;
          }
        }
      }
    };
    lib.selIndices2selPoints = function(trace) {
      var selectedpoints = trace.selectedpoints;
      var indexToPoints = trace._indexToPoints;
      if (indexToPoints) {
        var ptIndex2ptNumber = makePtIndex2PtNumber(indexToPoints);
        var out = [];
        for (var i = 0; i < selectedpoints.length; i++) {
          var ptIndex = selectedpoints[i];
          if (lib.isIndex(ptIndex)) {
            var ptNumber = ptIndex2ptNumber[ptIndex];
            if (lib.isIndex(ptNumber)) {
              out.push(ptNumber);
            }
          }
        }
        return out;
      } else {
        return selectedpoints;
      }
    };
    lib.getTargetArray = function(trace, transformOpts) {
      var target = transformOpts.target;
      if (typeof target === "string" && target) {
        var array = lib.nestedProperty(trace, target).get();
        return lib.isArrayOrTypedArray(array) ? array : false;
      } else if (lib.isArrayOrTypedArray(target)) {
        return target;
      }
      return false;
    };
    function minExtend(obj1, obj2, opt) {
      var objOut = {};
      if (typeof obj2 !== "object") obj2 = {};
      var arrayLen = opt === "pieLike" ? -1 : 3;
      var keys = Object.keys(obj1);
      var i, k, v;
      for (i = 0; i < keys.length; i++) {
        k = keys[i];
        v = obj1[k];
        if (k.charAt(0) === "_" || typeof v === "function") continue;
        else if (k === "module") objOut[k] = v;
        else if (Array.isArray(v)) {
          if (k === "colorscale" || arrayLen === -1) {
            objOut[k] = v.slice();
          } else {
            objOut[k] = v.slice(0, arrayLen);
          }
        } else if (lib.isTypedArray(v)) {
          if (arrayLen === -1) {
            objOut[k] = v.subarray();
          } else {
            objOut[k] = v.subarray(0, arrayLen);
          }
        } else if (v && typeof v === "object") objOut[k] = minExtend(obj1[k], obj2[k], opt);
        else objOut[k] = v;
      }
      keys = Object.keys(obj2);
      for (i = 0; i < keys.length; i++) {
        k = keys[i];
        v = obj2[k];
        if (typeof v !== "object" || !(k in objOut) || typeof objOut[k] !== "object") {
          objOut[k] = v;
        }
      }
      return objOut;
    }
    lib.minExtend = minExtend;
    lib.titleCase = function(s) {
      return s.charAt(0).toUpperCase() + s.substr(1);
    };
    lib.containsAny = function(s, fragments) {
      for (var i = 0; i < fragments.length; i++) {
        if (s.indexOf(fragments[i]) !== -1) return true;
      }
      return false;
    };
    lib.isIE = function() {
      return typeof window.navigator.msSaveBlob !== "undefined";
    };
    var IS_SAFARI_REGEX = /Version\/[\d\.]+.*Safari/;
    lib.isSafari = function() {
      return IS_SAFARI_REGEX.test(window.navigator.userAgent);
    };
    var IS_IOS_REGEX = /iPad|iPhone|iPod/;
    lib.isIOS = function() {
      return IS_IOS_REGEX.test(window.navigator.userAgent);
    };
    var FIREFOX_VERSION_REGEX = /Firefox\/(\d+)\.\d+/;
    lib.getFirefoxVersion = function() {
      var match = FIREFOX_VERSION_REGEX.exec(window.navigator.userAgent);
      if (match && match.length === 2) {
        var versionInt = parseInt(match[1]);
        if (!isNaN(versionInt)) {
          return versionInt;
        }
      }
      return null;
    };
    lib.isD3Selection = function(obj) {
      return obj instanceof d3.selection;
    };
    lib.ensureSingle = function(parent, nodeType, className, enterFn) {
      var sel = parent.select(nodeType + (className ? "." + className : ""));
      if (sel.size()) return sel;
      var layer = parent.append(nodeType);
      if (className) layer.classed(className, true);
      if (enterFn) layer.call(enterFn);
      return layer;
    };
    lib.ensureSingleById = function(parent, nodeType, id2, enterFn) {
      var sel = parent.select(nodeType + "#" + id2);
      if (sel.size()) return sel;
      var layer = parent.append(nodeType).attr("id", id2);
      if (enterFn) layer.call(enterFn);
      return layer;
    };
    lib.objectFromPath = function(path, value) {
      var keys = path.split(".");
      var tmpObj;
      var obj = tmpObj = {};
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var el = null;
        var parts = keys[i].match(/(.*)\[([0-9]+)\]/);
        if (parts) {
          key = parts[1];
          el = parts[2];
          tmpObj = tmpObj[key] = [];
          if (i === keys.length - 1) {
            tmpObj[el] = value;
          } else {
            tmpObj[el] = {};
          }
          tmpObj = tmpObj[el];
        } else {
          if (i === keys.length - 1) {
            tmpObj[key] = value;
          } else {
            tmpObj[key] = {};
          }
          tmpObj = tmpObj[key];
        }
      }
      return obj;
    };
    var dottedPropertyRegex = /^([^\[\.]+)\.(.+)?/;
    var indexedPropertyRegex = /^([^\.]+)\[([0-9]+)\](\.)?(.+)?/;
    function notValid(prop) {
      return prop.slice(0, 2) === "__";
    }
    lib.expandObjectPaths = function(data) {
      var match, key, prop, datum, idx, dest, trailingPath;
      if (typeof data === "object" && !Array.isArray(data)) {
        for (key in data) {
          if (data.hasOwnProperty(key)) {
            if (match = key.match(dottedPropertyRegex)) {
              datum = data[key];
              prop = match[1];
              if (notValid(prop)) continue;
              delete data[key];
              data[prop] = lib.extendDeepNoArrays(data[prop] || {}, lib.objectFromPath(key, lib.expandObjectPaths(datum))[prop]);
            } else if (match = key.match(indexedPropertyRegex)) {
              datum = data[key];
              prop = match[1];
              if (notValid(prop)) continue;
              idx = parseInt(match[2]);
              delete data[key];
              data[prop] = data[prop] || [];
              if (match[3] === ".") {
                trailingPath = match[4];
                dest = data[prop][idx] = data[prop][idx] || {};
                lib.extendDeepNoArrays(dest, lib.objectFromPath(trailingPath, lib.expandObjectPaths(datum)));
              } else {
                if (notValid(prop)) continue;
                data[prop][idx] = lib.expandObjectPaths(datum);
              }
            } else {
              if (notValid(key)) continue;
              data[key] = lib.expandObjectPaths(data[key]);
            }
          }
        }
      }
      return data;
    };
    lib.numSeparate = function(value, separators, separatethousands) {
      if (!separatethousands) separatethousands = false;
      if (typeof separators !== "string" || separators.length === 0) {
        throw new Error("Separator string required for formatting!");
      }
      if (typeof value === "number") {
        value = String(value);
      }
      var thousandsRe = /(\d+)(\d{3})/;
      var decimalSep = separators.charAt(0);
      var thouSep = separators.charAt(1);
      var x = value.split(".");
      var x12 = x[0];
      var x2 = x.length > 1 ? decimalSep + x[1] : "";
      if (thouSep && (x.length > 1 || x12.length > 4 || separatethousands)) {
        while (thousandsRe.test(x12)) {
          x12 = x12.replace(thousandsRe, "$1" + thouSep + "$2");
        }
      }
      return x12 + x2;
    };
    lib.TEMPLATE_STRING_REGEX = /%{([^\s%{}:]*)([:|\|][^}]*)?}/g;
    var SIMPLE_PROPERTY_REGEX = /^\w*$/;
    lib.templateString = function(string, obj) {
      var getterCache = {};
      return string.replace(lib.TEMPLATE_STRING_REGEX, function(dummy, key) {
        var v;
        if (SIMPLE_PROPERTY_REGEX.test(key)) {
          v = obj[key];
        } else {
          getterCache[key] = getterCache[key] || lib.nestedProperty(obj, key).get;
          v = getterCache[key]();
        }
        return lib.isValidTextValue(v) ? v : "";
      });
    };
    var hovertemplateWarnings = {
      max: 10,
      count: 0,
      name: "hovertemplate"
    };
    lib.hovertemplateString = function() {
      return templateFormatString.apply(hovertemplateWarnings, arguments);
    };
    var texttemplateWarnings = {
      max: 10,
      count: 0,
      name: "texttemplate"
    };
    lib.texttemplateString = function() {
      return templateFormatString.apply(texttemplateWarnings, arguments);
    };
    var MULT_DIV_REGEX = /^(\S+)([\*\/])(-?\d+(\.\d+)?)$/;
    function multDivParser(inputStr) {
      var match = inputStr.match(MULT_DIV_REGEX);
      if (match) return { key: match[1], op: match[2], number: Number(match[3]) };
      return { key: inputStr, op: null, number: null };
    }
    var texttemplateWarningsForShapes = {
      max: 10,
      count: 0,
      name: "texttemplate",
      parseMultDiv: true
    };
    lib.texttemplateStringForShapes = function() {
      return templateFormatString.apply(texttemplateWarningsForShapes, arguments);
    };
    var TEMPLATE_STRING_FORMAT_SEPARATOR = /^[:|\|]/;
    function templateFormatString(string, labels, d3locale) {
      var opts = this;
      var args = arguments;
      if (!labels) labels = {};
      var getterCache = {};
      return string.replace(lib.TEMPLATE_STRING_REGEX, function(match, rawKey, format2) {
        var isOther = rawKey === "xother" || rawKey === "yother";
        var isSpaceOther = rawKey === "_xother" || rawKey === "_yother";
        var isSpaceOtherSpace = rawKey === "_xother_" || rawKey === "_yother_";
        var isOtherSpace = rawKey === "xother_" || rawKey === "yother_";
        var hasOther = isOther || isSpaceOther || isOtherSpace || isSpaceOtherSpace;
        var key = rawKey;
        if (isSpaceOther || isSpaceOtherSpace) key = key.substring(1);
        if (isOtherSpace || isSpaceOtherSpace) key = key.substring(0, key.length - 1);
        var parsedOp = null;
        var parsedNumber = null;
        if (opts.parseMultDiv) {
          var _match = multDivParser(key);
          key = _match.key;
          parsedOp = _match.op;
          parsedNumber = _match.number;
        }
        var value;
        if (hasOther) {
          value = labels[key];
          if (value === void 0) return "";
        } else {
          var obj, i;
          for (i = 3; i < args.length; i++) {
            obj = args[i];
            if (!obj) continue;
            if (obj.hasOwnProperty(key)) {
              value = obj[key];
              break;
            }
            if (!SIMPLE_PROPERTY_REGEX.test(key)) {
              value = lib.nestedProperty(obj, key).get();
              value = getterCache[key] || lib.nestedProperty(obj, key).get();
              if (value) getterCache[key] = value;
            }
            if (value !== void 0) break;
          }
        }
        if (value !== void 0) {
          if (parsedOp === "*") value *= parsedNumber;
          if (parsedOp === "/") value /= parsedNumber;
        }
        if (value === void 0 && opts) {
          if (opts.count < opts.max) {
            lib.warn("Variable '" + key + "' in " + opts.name + " could not be found!");
            value = match;
          }
          if (opts.count === opts.max) {
            lib.warn("Too many " + opts.name + " warnings - additional warnings will be suppressed");
          }
          opts.count++;
          return match;
        }
        if (format2) {
          var fmt;
          if (format2[0] === ":") {
            fmt = d3locale ? d3locale.numberFormat : lib.numberFormat;
            if (value !== "") {
              value = fmt(format2.replace(TEMPLATE_STRING_FORMAT_SEPARATOR, ""))(value);
            }
          }
          if (format2[0] === "|") {
            fmt = d3locale ? d3locale.timeFormat : utcFormat2;
            var ms2 = lib.dateTime2ms(value);
            value = lib.formatDate(ms2, format2.replace(TEMPLATE_STRING_FORMAT_SEPARATOR, ""), false, fmt);
          }
        } else {
          var keyLabel = key + "Label";
          if (labels.hasOwnProperty(keyLabel)) value = labels[keyLabel];
        }
        if (hasOther) {
          value = "(" + value + ")";
          if (isSpaceOther || isSpaceOtherSpace) value = " " + value;
          if (isOtherSpace || isSpaceOtherSpace) value = value + " ";
        }
        return value;
      });
    }
    var char0 = 48;
    var char9 = 57;
    lib.subplotSort = function(a, b) {
      var l = Math.min(a.length, b.length) + 1;
      var numA = 0;
      var numB = 0;
      for (var i = 0; i < l; i++) {
        var charA = a.charCodeAt(i) || 0;
        var charB = b.charCodeAt(i) || 0;
        var isNumA = charA >= char0 && charA <= char9;
        var isNumB = charB >= char0 && charB <= char9;
        if (isNumA) numA = 10 * numA + charA - char0;
        if (isNumB) numB = 10 * numB + charB - char0;
        if (!isNumA || !isNumB) {
          if (numA !== numB) return numA - numB;
          if (charA !== charB) return charA - charB;
        }
      }
      return numB - numA;
    };
    var randSeed = 2e9;
    lib.seedPseudoRandom = function() {
      randSeed = 2e9;
    };
    lib.pseudoRandom = function() {
      var lastVal = randSeed;
      randSeed = (69069 * randSeed + 1) % 4294967296;
      if (Math.abs(randSeed - lastVal) < 429496729) return lib.pseudoRandom();
      return randSeed / 4294967296;
    };
    lib.fillText = function(calcPt, trace, contOut) {
      var fill = Array.isArray(contOut) ? function(v) {
        contOut.push(v);
      } : function(v) {
        contOut.text = v;
      };
      var htx = lib.extractOption(calcPt, trace, "htx", "hovertext");
      if (lib.isValidTextValue(htx)) return fill(htx);
      var tx = lib.extractOption(calcPt, trace, "tx", "text");
      if (lib.isValidTextValue(tx)) return fill(tx);
    };
    lib.isValidTextValue = function(v) {
      return v || v === 0;
    };
    lib.formatPercent = function(ratio, n) {
      n = n || 0;
      var str = (Math.round(100 * ratio * Math.pow(10, n)) * Math.pow(0.1, n)).toFixed(n) + "%";
      for (var i = 0; i < n; i++) {
        if (str.indexOf(".") !== -1) {
          str = str.replace("0%", "%");
          str = str.replace(".%", "%");
        }
      }
      return str;
    };
    lib.isHidden = function(gd2) {
      var display = window.getComputedStyle(gd2).display;
      return !display || display === "none";
    };
    lib.strTranslate = function(x, y) {
      return x || y ? "translate(" + x + "," + y + ")" : "";
    };
    lib.strRotate = function(a) {
      return a ? "rotate(" + a + ")" : "";
    };
    lib.strScale = function(s) {
      return s !== 1 ? "scale(" + s + ")" : "";
    };
    lib.getTextTransform = function(transform) {
      var noCenter = transform.noCenter;
      var textX = transform.textX;
      var textY = transform.textY;
      var targetX = transform.targetX;
      var targetY = transform.targetY;
      var anchorX = transform.anchorX || 0;
      var anchorY = transform.anchorY || 0;
      var rotate = transform.rotate;
      var scale = transform.scale;
      if (!scale) scale = 0;
      else if (scale > 1) scale = 1;
      return lib.strTranslate(
        targetX - scale * (textX + anchorX),
        targetY - scale * (textY + anchorY)
      ) + lib.strScale(scale) + (rotate ? "rotate(" + rotate + (noCenter ? "" : " " + textX + " " + textY) + ")" : "");
    };
    lib.setTransormAndDisplay = function(s, transform) {
      s.attr("transform", lib.getTextTransform(transform));
      s.style("display", transform.scale ? null : "none");
    };
    lib.ensureUniformFontSize = function(gd2, baseFont) {
      var out = lib.extendFlat({}, baseFont);
      out.size = Math.max(
        baseFont.size,
        gd2._fullLayout.uniformtext.minsize || 0
      );
      return out;
    };
    lib.join2 = function(arr, mainSeparator, lastSeparator) {
      var len = arr.length;
      if (len > 1) {
        return arr.slice(0, -1).join(mainSeparator) + lastSeparator + arr[len - 1];
      }
      return arr.join(mainSeparator);
    };
    lib.bigFont = function(size) {
      return Math.round(1.2 * size);
    };
    var firefoxVersion = lib.getFirefoxVersion();
    var isProblematicFirefox = firefoxVersion !== null && firefoxVersion < 86;
    lib.getPositionFromD3Event = function() {
      if (isProblematicFirefox) {
        return [
          d3.event.layerX,
          d3.event.layerY
        ];
      } else {
        return [
          d3.event.offsetX,
          d3.event.offsetY
        ];
      }
    };
  }
});

// node_modules/plotly.js/build/plotcss.js
var require_plotcss = __commonJS({
  "node_modules/plotly.js/build/plotcss.js"() {
    "use strict";
    var Lib = require_lib();
    var rules = {
      "X,X div": 'direction:ltr;font-family:"Open Sans",verdana,arial,sans-serif;margin:0;padding:0;',
      "X input,X button": 'font-family:"Open Sans",verdana,arial,sans-serif;',
      "X input:focus,X button:focus": "outline:none;",
      "X a": "text-decoration:none;",
      "X a:hover": "text-decoration:none;",
      "X .crisp": "shape-rendering:crispEdges;",
      "X .user-select-none": "-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;-o-user-select:none;user-select:none;",
      "X svg": "overflow:hidden;",
      "X svg a": "fill:#447adb;",
      "X svg a:hover": "fill:#3c6dc5;",
      "X .main-svg": "position:absolute;top:0;left:0;pointer-events:none;",
      "X .main-svg .draglayer": "pointer-events:all;",
      "X .cursor-default": "cursor:default;",
      "X .cursor-pointer": "cursor:pointer;",
      "X .cursor-crosshair": "cursor:crosshair;",
      "X .cursor-move": "cursor:move;",
      "X .cursor-col-resize": "cursor:col-resize;",
      "X .cursor-row-resize": "cursor:row-resize;",
      "X .cursor-ns-resize": "cursor:ns-resize;",
      "X .cursor-ew-resize": "cursor:ew-resize;",
      "X .cursor-sw-resize": "cursor:sw-resize;",
      "X .cursor-s-resize": "cursor:s-resize;",
      "X .cursor-se-resize": "cursor:se-resize;",
      "X .cursor-w-resize": "cursor:w-resize;",
      "X .cursor-e-resize": "cursor:e-resize;",
      "X .cursor-nw-resize": "cursor:nw-resize;",
      "X .cursor-n-resize": "cursor:n-resize;",
      "X .cursor-ne-resize": "cursor:ne-resize;",
      "X .cursor-grab": "cursor:-webkit-grab;cursor:grab;",
      "X .modebar": "position:absolute;top:2px;right:2px;",
      "X .ease-bg": "-webkit-transition:background-color .3s ease 0s;-moz-transition:background-color .3s ease 0s;-ms-transition:background-color .3s ease 0s;-o-transition:background-color .3s ease 0s;transition:background-color .3s ease 0s;",
      "X .modebar--hover>:not(.watermark)": "opacity:0;-webkit-transition:opacity .3s ease 0s;-moz-transition:opacity .3s ease 0s;-ms-transition:opacity .3s ease 0s;-o-transition:opacity .3s ease 0s;transition:opacity .3s ease 0s;",
      "X:hover .modebar--hover .modebar-group": "opacity:1;",
      "X .modebar-group": "float:left;display:inline-block;box-sizing:border-box;padding-left:8px;position:relative;vertical-align:middle;white-space:nowrap;",
      "X .modebar-btn": "position:relative;font-size:16px;padding:3px 4px;height:22px;cursor:pointer;line-height:normal;box-sizing:border-box;",
      "X .modebar-btn svg": "position:relative;top:2px;",
      "X .modebar.vertical": "display:flex;flex-direction:column;flex-wrap:wrap;align-content:flex-end;max-height:100%;",
      "X .modebar.vertical svg": "top:-1px;",
      "X .modebar.vertical .modebar-group": "display:block;float:none;padding-left:0px;padding-bottom:8px;",
      "X .modebar.vertical .modebar-group .modebar-btn": "display:block;text-align:center;",
      "X [data-title]:before,X [data-title]:after": "position:absolute;-webkit-transform:translate3d(0, 0, 0);-moz-transform:translate3d(0, 0, 0);-ms-transform:translate3d(0, 0, 0);-o-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);display:none;opacity:0;z-index:1001;pointer-events:none;top:110%;right:50%;",
      "X [data-title]:hover:before,X [data-title]:hover:after": "display:block;opacity:1;",
      "X [data-title]:before": 'content:"";position:absolute;background:rgba(0,0,0,0);border:6px solid rgba(0,0,0,0);z-index:1002;margin-top:-12px;border-bottom-color:#69738a;margin-right:-6px;',
      "X [data-title]:after": "content:attr(data-title);background:#69738a;color:#fff;padding:8px 10px;font-size:12px;line-height:12px;white-space:nowrap;margin-right:-18px;border-radius:2px;",
      "X .vertical [data-title]:before,X .vertical [data-title]:after": "top:0%;right:200%;",
      "X .vertical [data-title]:before": "border:6px solid rgba(0,0,0,0);border-left-color:#69738a;margin-top:8px;margin-right:-30px;",
      Y: 'font-family:"Open Sans",verdana,arial,sans-serif;position:fixed;top:50px;right:20px;z-index:10000;font-size:10pt;max-width:180px;',
      "Y p": "margin:0;",
      "Y .notifier-note": "min-width:180px;max-width:250px;border:1px solid #fff;z-index:3000;margin:0;background-color:#8c97af;background-color:rgba(140,151,175,.9);color:#fff;padding:10px;overflow-wrap:break-word;word-wrap:break-word;-ms-hyphens:auto;-webkit-hyphens:auto;hyphens:auto;",
      "Y .notifier-close": "color:#fff;opacity:.8;float:right;padding:0 5px;background:none;border:none;font-size:20px;font-weight:bold;line-height:20px;",
      "Y .notifier-close:hover": "color:#444;text-decoration:none;cursor:pointer;"
    };
    for (selector in rules) {
      fullSelector = selector.replace(/^,/, " ,").replace(/X/g, ".js-plotly-plot .plotly").replace(/Y/g, ".plotly-notifier");
      Lib.addStyleRule(fullSelector, rules[selector]);
    }
    var fullSelector;
    var selector;
  }
});

// node_modules/is-browser/client.js
var require_client = __commonJS({
  "node_modules/is-browser/client.js"(exports2, module2) {
    module2.exports = true;
  }
});

// node_modules/has-hover/index.js
var require_has_hover = __commonJS({
  "node_modules/has-hover/index.js"(exports2, module2) {
    "use strict";
    var isBrowser = require_client();
    var hasHover;
    if (typeof global.matchMedia === "function") {
      hasHover = !global.matchMedia("(hover: none)").matches;
    } else {
      hasHover = isBrowser;
    }
    module2.exports = hasHover;
  }
});

// node_modules/events/events.js
var require_events = __commonJS({
  "node_modules/events/events.js"(exports2, module2) {
    "use strict";
    var R = typeof Reflect === "object" ? Reflect : null;
    var ReflectApply = R && typeof R.apply === "function" ? R.apply : function ReflectApply2(target, receiver, args) {
      return Function.prototype.apply.call(target, receiver, args);
    };
    var ReflectOwnKeys;
    if (R && typeof R.ownKeys === "function") {
      ReflectOwnKeys = R.ownKeys;
    } else if (Object.getOwnPropertySymbols) {
      ReflectOwnKeys = function ReflectOwnKeys2(target) {
        return Object.getOwnPropertyNames(target).concat(Object.getOwnPropertySymbols(target));
      };
    } else {
      ReflectOwnKeys = function ReflectOwnKeys2(target) {
        return Object.getOwnPropertyNames(target);
      };
    }
    function ProcessEmitWarning(warning) {
      if (console && console.warn) console.warn(warning);
    }
    var NumberIsNaN = Number.isNaN || function NumberIsNaN2(value) {
      return value !== value;
    };
    function EventEmitter() {
      EventEmitter.init.call(this);
    }
    module2.exports = EventEmitter;
    module2.exports.once = once;
    EventEmitter.EventEmitter = EventEmitter;
    EventEmitter.prototype._events = void 0;
    EventEmitter.prototype._eventsCount = 0;
    EventEmitter.prototype._maxListeners = void 0;
    var defaultMaxListeners = 10;
    function checkListener(listener) {
      if (typeof listener !== "function") {
        throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
      }
    }
    Object.defineProperty(EventEmitter, "defaultMaxListeners", {
      enumerable: true,
      get: function() {
        return defaultMaxListeners;
      },
      set: function(arg) {
        if (typeof arg !== "number" || arg < 0 || NumberIsNaN(arg)) {
          throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received ' + arg + ".");
        }
        defaultMaxListeners = arg;
      }
    });
    EventEmitter.init = function() {
      if (this._events === void 0 || this._events === Object.getPrototypeOf(this)._events) {
        this._events = /* @__PURE__ */ Object.create(null);
        this._eventsCount = 0;
      }
      this._maxListeners = this._maxListeners || void 0;
    };
    EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
      if (typeof n !== "number" || n < 0 || NumberIsNaN(n)) {
        throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + n + ".");
      }
      this._maxListeners = n;
      return this;
    };
    function _getMaxListeners(that) {
      if (that._maxListeners === void 0)
        return EventEmitter.defaultMaxListeners;
      return that._maxListeners;
    }
    EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
      return _getMaxListeners(this);
    };
    EventEmitter.prototype.emit = function emit(type) {
      var args = [];
      for (var i = 1; i < arguments.length; i++) args.push(arguments[i]);
      var doError = type === "error";
      var events = this._events;
      if (events !== void 0)
        doError = doError && events.error === void 0;
      else if (!doError)
        return false;
      if (doError) {
        var er2;
        if (args.length > 0)
          er2 = args[0];
        if (er2 instanceof Error) {
          throw er2;
        }
        var err = new Error("Unhandled error." + (er2 ? " (" + er2.message + ")" : ""));
        err.context = er2;
        throw err;
      }
      var handler = events[type];
      if (handler === void 0)
        return false;
      if (typeof handler === "function") {
        ReflectApply(handler, this, args);
      } else {
        var len = handler.length;
        var listeners = arrayClone(handler, len);
        for (var i = 0; i < len; ++i)
          ReflectApply(listeners[i], this, args);
      }
      return true;
    };
    function _addListener(target, type, listener, prepend) {
      var m;
      var events;
      var existing;
      checkListener(listener);
      events = target._events;
      if (events === void 0) {
        events = target._events = /* @__PURE__ */ Object.create(null);
        target._eventsCount = 0;
      } else {
        if (events.newListener !== void 0) {
          target.emit(
            "newListener",
            type,
            listener.listener ? listener.listener : listener
          );
          events = target._events;
        }
        existing = events[type];
      }
      if (existing === void 0) {
        existing = events[type] = listener;
        ++target._eventsCount;
      } else {
        if (typeof existing === "function") {
          existing = events[type] = prepend ? [listener, existing] : [existing, listener];
        } else if (prepend) {
          existing.unshift(listener);
        } else {
          existing.push(listener);
        }
        m = _getMaxListeners(target);
        if (m > 0 && existing.length > m && !existing.warned) {
          existing.warned = true;
          var w = new Error("Possible EventEmitter memory leak detected. " + existing.length + " " + String(type) + " listeners added. Use emitter.setMaxListeners() to increase limit");
          w.name = "MaxListenersExceededWarning";
          w.emitter = target;
          w.type = type;
          w.count = existing.length;
          ProcessEmitWarning(w);
        }
      }
      return target;
    }
    EventEmitter.prototype.addListener = function addListener(type, listener) {
      return _addListener(this, type, listener, false);
    };
    EventEmitter.prototype.on = EventEmitter.prototype.addListener;
    EventEmitter.prototype.prependListener = function prependListener(type, listener) {
      return _addListener(this, type, listener, true);
    };
    function onceWrapper() {
      if (!this.fired) {
        this.target.removeListener(this.type, this.wrapFn);
        this.fired = true;
        if (arguments.length === 0)
          return this.listener.call(this.target);
        return this.listener.apply(this.target, arguments);
      }
    }
    function _onceWrap(target, type, listener) {
      var state = { fired: false, wrapFn: void 0, target, type, listener };
      var wrapped = onceWrapper.bind(state);
      wrapped.listener = listener;
      state.wrapFn = wrapped;
      return wrapped;
    }
    EventEmitter.prototype.once = function once2(type, listener) {
      checkListener(listener);
      this.on(type, _onceWrap(this, type, listener));
      return this;
    };
    EventEmitter.prototype.prependOnceListener = function prependOnceListener(type, listener) {
      checkListener(listener);
      this.prependListener(type, _onceWrap(this, type, listener));
      return this;
    };
    EventEmitter.prototype.removeListener = function removeListener(type, listener) {
      var list, events, position, i, originalListener;
      checkListener(listener);
      events = this._events;
      if (events === void 0)
        return this;
      list = events[type];
      if (list === void 0)
        return this;
      if (list === listener || list.listener === listener) {
        if (--this._eventsCount === 0)
          this._events = /* @__PURE__ */ Object.create(null);
        else {
          delete events[type];
          if (events.removeListener)
            this.emit("removeListener", type, list.listener || listener);
        }
      } else if (typeof list !== "function") {
        position = -1;
        for (i = list.length - 1; i >= 0; i--) {
          if (list[i] === listener || list[i].listener === listener) {
            originalListener = list[i].listener;
            position = i;
            break;
          }
        }
        if (position < 0)
          return this;
        if (position === 0)
          list.shift();
        else {
          spliceOne(list, position);
        }
        if (list.length === 1)
          events[type] = list[0];
        if (events.removeListener !== void 0)
          this.emit("removeListener", type, originalListener || listener);
      }
      return this;
    };
    EventEmitter.prototype.off = EventEmitter.prototype.removeListener;
    EventEmitter.prototype.removeAllListeners = function removeAllListeners(type) {
      var listeners, events, i;
      events = this._events;
      if (events === void 0)
        return this;
      if (events.removeListener === void 0) {
        if (arguments.length === 0) {
          this._events = /* @__PURE__ */ Object.create(null);
          this._eventsCount = 0;
        } else if (events[type] !== void 0) {
          if (--this._eventsCount === 0)
            this._events = /* @__PURE__ */ Object.create(null);
          else
            delete events[type];
        }
        return this;
      }
      if (arguments.length === 0) {
        var keys = Object.keys(events);
        var key;
        for (i = 0; i < keys.length; ++i) {
          key = keys[i];
          if (key === "removeListener") continue;
          this.removeAllListeners(key);
        }
        this.removeAllListeners("removeListener");
        this._events = /* @__PURE__ */ Object.create(null);
        this._eventsCount = 0;
        return this;
      }
      listeners = events[type];
      if (typeof listeners === "function") {
        this.removeListener(type, listeners);
      } else if (listeners !== void 0) {
        for (i = listeners.length - 1; i >= 0; i--) {
          this.removeListener(type, listeners[i]);
        }
      }
      return this;
    };
    function _listeners(target, type, unwrap) {
      var events = target._events;
      if (events === void 0)
        return [];
      var evlistener = events[type];
      if (evlistener === void 0)
        return [];
      if (typeof evlistener === "function")
        return unwrap ? [evlistener.listener || evlistener] : [evlistener];
      return unwrap ? unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);
    }
    EventEmitter.prototype.listeners = function listeners(type) {
      return _listeners(this, type, true);
    };
    EventEmitter.prototype.rawListeners = function rawListeners(type) {
      return _listeners(this, type, false);
    };
    EventEmitter.listenerCount = function(emitter, type) {
      if (typeof emitter.listenerCount === "function") {
        return emitter.listenerCount(type);
      } else {
        return listenerCount.call(emitter, type);
      }
    };
    EventEmitter.prototype.listenerCount = listenerCount;
    function listenerCount(type) {
      var events = this._events;
      if (events !== void 0) {
        var evlistener = events[type];
        if (typeof evlistener === "function") {
          return 1;
        } else if (evlistener !== void 0) {
          return evlistener.length;
        }
      }
      return 0;
    }
    EventEmitter.prototype.eventNames = function eventNames() {
      return this._eventsCount > 0 ? ReflectOwnKeys(this._events) : [];
    };
    function arrayClone(arr, n) {
      var copy = new Array(n);
      for (var i = 0; i < n; ++i)
        copy[i] = arr[i];
      return copy;
    }
    function spliceOne(list, index) {
      for (; index + 1 < list.length; index++)
        list[index] = list[index + 1];
      list.pop();
    }
    function unwrapListeners(arr) {
      var ret = new Array(arr.length);
      for (var i = 0; i < ret.length; ++i) {
        ret[i] = arr[i].listener || arr[i];
      }
      return ret;
    }
    function once(emitter, name) {
      return new Promise(function(resolve, reject) {
        function errorListener(err) {
          emitter.removeListener(name, resolver);
          reject(err);
        }
        function resolver() {
          if (typeof emitter.removeListener === "function") {
            emitter.removeListener("error", errorListener);
          }
          resolve([].slice.call(arguments));
        }
        ;
        eventTargetAgnosticAddListener(emitter, name, resolver, { once: true });
        if (name !== "error") {
          addErrorHandlerIfEventEmitter(emitter, errorListener, { once: true });
        }
      });
    }
    function addErrorHandlerIfEventEmitter(emitter, handler, flags) {
      if (typeof emitter.on === "function") {
        eventTargetAgnosticAddListener(emitter, "error", handler, flags);
      }
    }
    function eventTargetAgnosticAddListener(emitter, name, listener, flags) {
      if (typeof emitter.on === "function") {
        if (flags.once) {
          emitter.once(name, listener);
        } else {
          emitter.on(name, listener);
        }
      } else if (typeof emitter.addEventListener === "function") {
        emitter.addEventListener(name, function wrapListener(arg) {
          if (flags.once) {
            emitter.removeEventListener(name, wrapListener);
          }
          listener(arg);
        });
      } else {
        throw new TypeError('The "emitter" argument must be of type EventEmitter. Received type ' + typeof emitter);
      }
    }
  }
});

// node_modules/plotly.js/src/lib/events.js
var require_events2 = __commonJS({
  "node_modules/plotly.js/src/lib/events.js"(exports2, module2) {
    "use strict";
    var EventEmitter = require_events().EventEmitter;
    var Events = {
      init: function(plotObj) {
        if (plotObj._ev instanceof EventEmitter) return plotObj;
        var ev2 = new EventEmitter();
        var internalEv = new EventEmitter();
        plotObj._ev = ev2;
        plotObj._internalEv = internalEv;
        plotObj.on = ev2.on.bind(ev2);
        plotObj.once = ev2.once.bind(ev2);
        plotObj.removeListener = ev2.removeListener.bind(ev2);
        plotObj.removeAllListeners = ev2.removeAllListeners.bind(ev2);
        plotObj._internalOn = internalEv.on.bind(internalEv);
        plotObj._internalOnce = internalEv.once.bind(internalEv);
        plotObj._removeInternalListener = internalEv.removeListener.bind(internalEv);
        plotObj._removeAllInternalListeners = internalEv.removeAllListeners.bind(internalEv);
        plotObj.emit = function(event, data) {
          if (typeof jQuery !== "undefined") {
            jQuery(plotObj).trigger(event, data);
          }
          ev2.emit(event, data);
          internalEv.emit(event, data);
        };
        return plotObj;
      },
      /*
       * This function behaves like jQuery's triggerHandler. It calls
       * all handlers for a particular event and returns the return value
       * of the LAST handler. This function also triggers jQuery's
       * triggerHandler for backwards compatibility.
       */
      triggerHandler: function(plotObj, event, data) {
        var jQueryHandlerValue;
        var nodeEventHandlerValue;
        if (typeof jQuery !== "undefined") {
          jQueryHandlerValue = jQuery(plotObj).triggerHandler(event, data);
        }
        var ev2 = plotObj._ev;
        if (!ev2) return jQueryHandlerValue;
        var handlers = ev2._events[event];
        if (!handlers) return jQueryHandlerValue;
        function apply(handler) {
          if (handler.listener) {
            ev2.removeListener(event, handler.listener);
            if (!handler.fired) {
              handler.fired = true;
              return handler.listener.apply(ev2, [data]);
            }
          } else {
            return handler.apply(ev2, [data]);
          }
        }
        handlers = Array.isArray(handlers) ? handlers : [handlers];
        var i;
        for (i = 0; i < handlers.length - 1; i++) {
          apply(handlers[i]);
        }
        nodeEventHandlerValue = apply(handlers[i]);
        return jQueryHandlerValue !== void 0 ? jQueryHandlerValue : nodeEventHandlerValue;
      },
      purge: function(plotObj) {
        delete plotObj._ev;
        delete plotObj.on;
        delete plotObj.once;
        delete plotObj.removeListener;
        delete plotObj.removeAllListeners;
        delete plotObj.emit;
        delete plotObj._ev;
        delete plotObj._internalEv;
        delete plotObj._internalOn;
        delete plotObj._internalOnce;
        delete plotObj._removeInternalListener;
        delete plotObj._removeAllInternalListeners;
        return plotObj;
      }
    };
    module2.exports = Events;
  }
});

// node_modules/plotly.js/src/lib/queue.js
var require_queue = __commonJS({
  "node_modules/plotly.js/src/lib/queue.js"(exports2, module2) {
    "use strict";
    var Lib = require_lib();
    var dfltConfig = require_plot_config().dfltConfig;
    function copyArgArray(gd2, args) {
      var copy = [];
      var arg;
      for (var i = 0; i < args.length; i++) {
        arg = args[i];
        if (arg === gd2) copy[i] = arg;
        else if (typeof arg === "object") {
          copy[i] = Array.isArray(arg) ? Lib.extendDeep([], arg) : Lib.extendDeepAll({}, arg);
        } else copy[i] = arg;
      }
      return copy;
    }
    var queue = {};
    queue.add = function(gd2, undoFunc, undoArgs, redoFunc, redoArgs) {
      var queueObj, queueIndex;
      gd2.undoQueue = gd2.undoQueue || { index: 0, queue: [], sequence: false };
      queueIndex = gd2.undoQueue.index;
      if (gd2.autoplay) {
        if (!gd2.undoQueue.inSequence) gd2.autoplay = false;
        return;
      }
      if (!gd2.undoQueue.sequence || gd2.undoQueue.beginSequence) {
        queueObj = { undo: { calls: [], args: [] }, redo: { calls: [], args: [] } };
        gd2.undoQueue.queue.splice(queueIndex, gd2.undoQueue.queue.length - queueIndex, queueObj);
        gd2.undoQueue.index += 1;
      } else {
        queueObj = gd2.undoQueue.queue[queueIndex - 1];
      }
      gd2.undoQueue.beginSequence = false;
      if (queueObj) {
        queueObj.undo.calls.unshift(undoFunc);
        queueObj.undo.args.unshift(undoArgs);
        queueObj.redo.calls.push(redoFunc);
        queueObj.redo.args.push(redoArgs);
      }
      if (gd2.undoQueue.queue.length > dfltConfig.queueLength) {
        gd2.undoQueue.queue.shift();
        gd2.undoQueue.index--;
      }
    };
    queue.startSequence = function(gd2) {
      gd2.undoQueue = gd2.undoQueue || { index: 0, queue: [], sequence: false };
      gd2.undoQueue.sequence = true;
      gd2.undoQueue.beginSequence = true;
    };
    queue.stopSequence = function(gd2) {
      gd2.undoQueue = gd2.undoQueue || { index: 0, queue: [], sequence: false };
      gd2.undoQueue.sequence = false;
      gd2.undoQueue.beginSequence = false;
    };
    queue.undo = function undo(gd2) {
      var queueObj, i;
      if (gd2.undoQueue === void 0 || isNaN(gd2.undoQueue.index) || gd2.undoQueue.index <= 0) {
        return;
      }
      gd2.undoQueue.index--;
      queueObj = gd2.undoQueue.queue[gd2.undoQueue.index];
      gd2.undoQueue.inSequence = true;
      for (i = 0; i < queueObj.undo.calls.length; i++) {
        queue.plotDo(gd2, queueObj.undo.calls[i], queueObj.undo.args[i]);
      }
      gd2.undoQueue.inSequence = false;
      gd2.autoplay = false;
    };
    queue.redo = function redo(gd2) {
      var queueObj, i;
      if (gd2.undoQueue === void 0 || isNaN(gd2.undoQueue.index) || gd2.undoQueue.index >= gd2.undoQueue.queue.length) {
        return;
      }
      queueObj = gd2.undoQueue.queue[gd2.undoQueue.index];
      gd2.undoQueue.inSequence = true;
      for (i = 0; i < queueObj.redo.calls.length; i++) {
        queue.plotDo(gd2, queueObj.redo.calls[i], queueObj.redo.args[i]);
      }
      gd2.undoQueue.inSequence = false;
      gd2.autoplay = false;
      gd2.undoQueue.index++;
    };
    queue.plotDo = function(gd2, func, args) {
      gd2.autoplay = true;
      args = copyArgArray(gd2, args);
      func.apply(null, args);
    };
    module2.exports = queue;
  }
});

// node_modules/plotly.js/src/plots/frame_attributes.js
var require_frame_attributes = __commonJS({
  "node_modules/plotly.js/src/plots/frame_attributes.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      _isLinkedToArray: "frames_entry",
      group: {
        valType: "string",
        description: [
          "An identifier that specifies the group to which the frame belongs,",
          "used by animate to select a subset of frames."
        ].join(" ")
      },
      name: {
        valType: "string",
        description: "A label by which to identify the frame"
      },
      traces: {
        valType: "any",
        description: [
          "A list of trace indices that identify the respective traces in the",
          "data attribute"
        ].join(" ")
      },
      baseframe: {
        valType: "string",
        description: [
          "The name of the frame into which this frame's properties are merged",
          "before applying. This is used to unify properties and avoid needing",
          "to specify the same values for the same properties in multiple frames."
        ].join(" ")
      },
      data: {
        valType: "any",
        description: [
          "A list of traces this frame modifies. The format is identical to the",
          "normal trace definition."
        ].join(" ")
      },
      layout: {
        valType: "any",
        description: [
          "Layout properties which this frame modifies. The format is identical",
          "to the normal layout definition."
        ].join(" ")
      }
    };
  }
});

// node_modules/plotly.js/src/plot_api/plot_schema.js
var require_plot_schema = __commonJS({
  "node_modules/plotly.js/src/plot_api/plot_schema.js"(exports2) {
    "use strict";
    var Registry = require_registry();
    var Lib = require_lib();
    var baseAttributes = require_attributes2();
    var baseLayoutAttributes = require_layout_attributes2();
    var frameAttributes = require_frame_attributes();
    var animationAttributes = require_animation_attributes();
    var configAttributes = require_plot_config().configAttributes;
    var editTypes = require_edit_types();
    var extendDeepAll = Lib.extendDeepAll;
    var isPlainObject = Lib.isPlainObject;
    var isArrayOrTypedArray = Lib.isArrayOrTypedArray;
    var nestedProperty = Lib.nestedProperty;
    var valObjectMeta = Lib.valObjectMeta;
    var IS_SUBPLOT_OBJ = "_isSubplotObj";
    var IS_LINKED_TO_ARRAY = "_isLinkedToArray";
    var ARRAY_ATTR_REGEXPS = "_arrayAttrRegexps";
    var DEPRECATED = "_deprecated";
    var UNDERSCORE_ATTRS = [IS_SUBPLOT_OBJ, IS_LINKED_TO_ARRAY, ARRAY_ATTR_REGEXPS, DEPRECATED];
    exports2.IS_SUBPLOT_OBJ = IS_SUBPLOT_OBJ;
    exports2.IS_LINKED_TO_ARRAY = IS_LINKED_TO_ARRAY;
    exports2.DEPRECATED = DEPRECATED;
    exports2.UNDERSCORE_ATTRS = UNDERSCORE_ATTRS;
    exports2.get = function() {
      var traces = {};
      Registry.allTypes.forEach(function(type) {
        traces[type] = getTraceAttributes(type);
      });
      var transforms = {};
      Object.keys(Registry.transformsRegistry).forEach(function(type) {
        transforms[type] = getTransformAttributes(type);
      });
      return {
        defs: {
          valObjects: valObjectMeta,
          metaKeys: UNDERSCORE_ATTRS.concat(["description", "role", "editType", "impliedEdits"]),
          editType: {
            traces: editTypes.traces,
            layout: editTypes.layout
          },
          impliedEdits: {
            description: [
              "Sometimes when an attribute is changed, other attributes",
              "must be altered as well in order to achieve the intended",
              "result. For example, when `range` is specified, it is",
              "important to set `autorange` to `false` or the new `range`",
              "value would be lost in the redraw. `impliedEdits` is the",
              "mechanism to do this: `impliedEdits: {autorange: false}`.",
              "Each key is a relative paths to the attribute string to",
              "change, using *^* to ascend into the parent container,",
              "for example `range[0]` has `impliedEdits: {*^autorange*: false}`.",
              "A value of `undefined` means that the attribute will not be",
              "changed, but its previous value should be recorded in case",
              "we want to reverse this change later. For example, `autorange`",
              "has `impliedEdits: {*range[0]*: undefined, *range[1]*:undefined}",
              "because the range will likely be changed by redraw."
            ].join(" ")
          }
        },
        traces,
        layout: getLayoutAttributes(),
        transforms,
        frames: getFramesAttributes(),
        animation: formatAttributes(animationAttributes),
        config: formatAttributes(configAttributes)
      };
    };
    exports2.crawl = function(attrs, callback, specifiedLevel, attrString) {
      var level = specifiedLevel || 0;
      attrString = attrString || "";
      Object.keys(attrs).forEach(function(attrName) {
        var attr = attrs[attrName];
        if (UNDERSCORE_ATTRS.indexOf(attrName) !== -1) return;
        var fullAttrString = (attrString ? attrString + "." : "") + attrName;
        callback(attr, attrName, attrs, level, fullAttrString);
        if (exports2.isValObject(attr)) return;
        if (isPlainObject(attr) && attrName !== "impliedEdits") {
          exports2.crawl(attr, callback, level + 1, fullAttrString);
        }
      });
    };
    exports2.isValObject = function(obj) {
      return obj && obj.valType !== void 0;
    };
    exports2.findArrayAttributes = function(trace) {
      var arrayAttributes = [];
      var stack = [];
      var isArrayStack = [];
      var baseContainer, baseAttrName;
      function callback(attr, attrName, attrs, level) {
        stack = stack.slice(0, level).concat([attrName]);
        isArrayStack = isArrayStack.slice(0, level).concat([attr && attr._isLinkedToArray]);
        var splittableAttr = attr && (attr.valType === "data_array" || attr.arrayOk === true) && !(stack[level - 1] === "colorbar" && (attrName === "ticktext" || attrName === "tickvals"));
        if (!splittableAttr) return;
        crawlIntoTrace(baseContainer, 0, "");
      }
      function crawlIntoTrace(container, i2, astrPartial) {
        var item = container[stack[i2]];
        var newAstrPartial = astrPartial + stack[i2];
        if (i2 === stack.length - 1) {
          if (isArrayOrTypedArray(item)) {
            arrayAttributes.push(baseAttrName + newAstrPartial);
          }
        } else {
          if (isArrayStack[i2]) {
            if (Array.isArray(item)) {
              for (var j = 0; j < item.length; j++) {
                if (isPlainObject(item[j])) {
                  crawlIntoTrace(item[j], i2 + 1, newAstrPartial + "[" + j + "].");
                }
              }
            }
          } else if (isPlainObject(item)) {
            crawlIntoTrace(item, i2 + 1, newAstrPartial + ".");
          }
        }
      }
      baseContainer = trace;
      baseAttrName = "";
      exports2.crawl(baseAttributes, callback);
      if (trace._module && trace._module.attributes) {
        exports2.crawl(trace._module.attributes, callback);
      }
      var transforms = trace.transforms;
      if (transforms) {
        for (var i = 0; i < transforms.length; i++) {
          var transform = transforms[i];
          var module3 = transform._module;
          if (module3) {
            baseAttrName = "transforms[" + i + "].";
            baseContainer = transform;
            exports2.crawl(module3.attributes, callback);
          }
        }
      }
      return arrayAttributes;
    };
    exports2.getTraceValObject = function(trace, parts) {
      var head = parts[0];
      var i = 1;
      var moduleAttrs, valObject;
      if (head === "transforms") {
        if (parts.length === 1) {
          return baseAttributes.transforms;
        }
        var transforms = trace.transforms;
        if (!Array.isArray(transforms) || !transforms.length) return false;
        var tNum = parts[1];
        if (!isIndex(tNum) || tNum >= transforms.length) {
          return false;
        }
        moduleAttrs = (Registry.transformsRegistry[transforms[tNum].type] || {}).attributes;
        valObject = moduleAttrs && moduleAttrs[parts[2]];
        i = 3;
      } else {
        var _module = trace._module;
        if (!_module) _module = (Registry.modules[trace.type || baseAttributes.type.dflt] || {})._module;
        if (!_module) return false;
        moduleAttrs = _module.attributes;
        valObject = moduleAttrs && moduleAttrs[head];
        if (!valObject) {
          var subplotModule = _module.basePlotModule;
          if (subplotModule && subplotModule.attributes) {
            valObject = subplotModule.attributes[head];
          }
        }
        if (!valObject) valObject = baseAttributes[head];
      }
      return recurseIntoValObject(valObject, parts, i);
    };
    exports2.getLayoutValObject = function(fullLayout, parts) {
      var valObject = layoutHeadAttr(fullLayout, parts[0]);
      return recurseIntoValObject(valObject, parts, 1);
    };
    function layoutHeadAttr(fullLayout, head) {
      var i, key, _module, attributes;
      var basePlotModules = fullLayout._basePlotModules;
      if (basePlotModules) {
        var out;
        for (i = 0; i < basePlotModules.length; i++) {
          _module = basePlotModules[i];
          if (_module.attrRegex && _module.attrRegex.test(head)) {
            if (_module.layoutAttrOverrides) return _module.layoutAttrOverrides;
            if (!out && _module.layoutAttributes) out = _module.layoutAttributes;
          }
          var baseOverrides = _module.baseLayoutAttrOverrides;
          if (baseOverrides && head in baseOverrides) return baseOverrides[head];
        }
        if (out) return out;
      }
      var modules = fullLayout._modules;
      if (modules) {
        for (i = 0; i < modules.length; i++) {
          attributes = modules[i].layoutAttributes;
          if (attributes && head in attributes) {
            return attributes[head];
          }
        }
      }
      for (key in Registry.componentsRegistry) {
        _module = Registry.componentsRegistry[key];
        if (_module.name === "colorscale" && head.indexOf("coloraxis") === 0) {
          return _module.layoutAttributes[head];
        } else if (!_module.schema && head === _module.name) {
          return _module.layoutAttributes;
        }
      }
      if (head in baseLayoutAttributes) return baseLayoutAttributes[head];
      return false;
    }
    function recurseIntoValObject(valObject, parts, i) {
      if (!valObject) return false;
      if (valObject._isLinkedToArray) {
        if (isIndex(parts[i])) i++;
        else if (i < parts.length) return false;
      }
      for (; i < parts.length; i++) {
        var newValObject = valObject[parts[i]];
        if (isPlainObject(newValObject)) valObject = newValObject;
        else break;
        if (i === parts.length - 1) break;
        if (valObject._isLinkedToArray) {
          i++;
          if (!isIndex(parts[i])) return false;
        } else if (valObject.valType === "info_array") {
          i++;
          var index = parts[i];
          if (!isIndex(index)) return false;
          var items = valObject.items;
          if (Array.isArray(items)) {
            if (index >= items.length) return false;
            if (valObject.dimensions === 2) {
              i++;
              if (parts.length === i) return valObject;
              var index2 = parts[i];
              if (!isIndex(index2)) return false;
              valObject = items[index][index2];
            } else valObject = items[index];
          } else {
            valObject = items;
          }
        }
      }
      return valObject;
    }
    function isIndex(val) {
      return val === Math.round(val) && val >= 0;
    }
    function getTraceAttributes(type) {
      var _module, basePlotModule;
      _module = Registry.modules[type]._module, basePlotModule = _module.basePlotModule;
      var attributes = {};
      attributes.type = null;
      var copyBaseAttributes = extendDeepAll({}, baseAttributes);
      var copyModuleAttributes = extendDeepAll({}, _module.attributes);
      exports2.crawl(copyModuleAttributes, function(attr, attrName, attrs, level, fullAttrString) {
        nestedProperty(copyBaseAttributes, fullAttrString).set(void 0);
        if (attr === void 0) nestedProperty(copyModuleAttributes, fullAttrString).set(void 0);
      });
      extendDeepAll(attributes, copyBaseAttributes);
      if (Registry.traceIs(type, "noOpacity")) {
        delete attributes.opacity;
      }
      if (!Registry.traceIs(type, "showLegend")) {
        delete attributes.showlegend;
        delete attributes.legendgroup;
      }
      if (Registry.traceIs(type, "noHover")) {
        delete attributes.hoverinfo;
        delete attributes.hoverlabel;
      }
      if (!_module.selectPoints) {
        delete attributes.selectedpoints;
      }
      extendDeepAll(attributes, copyModuleAttributes);
      if (basePlotModule.attributes) {
        extendDeepAll(attributes, basePlotModule.attributes);
      }
      attributes.type = type;
      var out = {
        meta: _module.meta || {},
        categories: _module.categories || {},
        animatable: Boolean(_module.animatable),
        type,
        attributes: formatAttributes(attributes)
      };
      if (_module.layoutAttributes) {
        var layoutAttributes = {};
        extendDeepAll(layoutAttributes, _module.layoutAttributes);
        out.layoutAttributes = formatAttributes(layoutAttributes);
      }
      if (!_module.animatable) {
        exports2.crawl(out, function(attr) {
          if (exports2.isValObject(attr) && "anim" in attr) {
            delete attr.anim;
          }
        });
      }
      return out;
    }
    function getLayoutAttributes() {
      var layoutAttributes = {};
      var key, _module;
      extendDeepAll(layoutAttributes, baseLayoutAttributes);
      for (key in Registry.subplotsRegistry) {
        _module = Registry.subplotsRegistry[key];
        if (!_module.layoutAttributes) continue;
        if (Array.isArray(_module.attr)) {
          for (var i = 0; i < _module.attr.length; i++) {
            handleBasePlotModule(layoutAttributes, _module, _module.attr[i]);
          }
        } else {
          var astr = _module.attr === "subplot" ? _module.name : _module.attr;
          handleBasePlotModule(layoutAttributes, _module, astr);
        }
      }
      for (key in Registry.componentsRegistry) {
        _module = Registry.componentsRegistry[key];
        var schema = _module.schema;
        if (schema && (schema.subplots || schema.layout)) {
          var subplots = schema.subplots;
          if (subplots && subplots.xaxis && !subplots.yaxis) {
            for (var xkey in subplots.xaxis) {
              delete layoutAttributes.yaxis[xkey];
            }
          }
          delete layoutAttributes.xaxis.shift;
          delete layoutAttributes.xaxis.autoshift;
        } else if (_module.name === "colorscale") {
          extendDeepAll(layoutAttributes, _module.layoutAttributes);
        } else if (_module.layoutAttributes) {
          insertAttrs(layoutAttributes, _module.layoutAttributes, _module.name);
        }
      }
      return {
        layoutAttributes: formatAttributes(layoutAttributes)
      };
    }
    function getTransformAttributes(type) {
      var _module = Registry.transformsRegistry[type];
      var attributes = extendDeepAll({}, _module.attributes);
      Object.keys(Registry.componentsRegistry).forEach(function(k) {
        var _module2 = Registry.componentsRegistry[k];
        if (_module2.schema && _module2.schema.transforms && _module2.schema.transforms[type]) {
          Object.keys(_module2.schema.transforms[type]).forEach(function(v) {
            insertAttrs(attributes, _module2.schema.transforms[type][v], v);
          });
        }
      });
      return {
        attributes: formatAttributes(attributes)
      };
    }
    function getFramesAttributes() {
      var attrs = {
        frames: extendDeepAll({}, frameAttributes)
      };
      formatAttributes(attrs);
      return attrs.frames;
    }
    function formatAttributes(attrs) {
      mergeValTypeAndRole(attrs);
      formatArrayContainers(attrs);
      stringify(attrs);
      return attrs;
    }
    function mergeValTypeAndRole(attrs) {
      function makeSrcAttr(attrName) {
        return {
          valType: "string",
          description: "Sets the source reference on Chart Studio Cloud for `" + attrName + "`.",
          editType: "none"
        };
      }
      function callback(attr, attrName, attrs2) {
        if (exports2.isValObject(attr)) {
          if (attr.arrayOk === true || attr.valType === "data_array") {
            attrs2[attrName + "src"] = makeSrcAttr(attrName);
          }
        } else if (isPlainObject(attr)) {
          attr.role = "object";
        }
      }
      exports2.crawl(attrs, callback);
    }
    function formatArrayContainers(attrs) {
      function callback(attr, attrName, attrs2) {
        if (!attr) return;
        var itemName = attr[IS_LINKED_TO_ARRAY];
        if (!itemName) return;
        delete attr[IS_LINKED_TO_ARRAY];
        attrs2[attrName] = { items: {} };
        attrs2[attrName].items[itemName] = attr;
        attrs2[attrName].role = "object";
      }
      exports2.crawl(attrs, callback);
    }
    function stringify(attrs) {
      function walk(attr) {
        for (var k in attr) {
          if (isPlainObject(attr[k])) {
            walk(attr[k]);
          } else if (Array.isArray(attr[k])) {
            for (var i = 0; i < attr[k].length; i++) {
              walk(attr[k][i]);
            }
          } else {
            if (attr[k] instanceof RegExp) {
              attr[k] = attr[k].toString();
            }
          }
        }
      }
      walk(attrs);
    }
    function handleBasePlotModule(layoutAttributes, _module, astr) {
      var np2 = nestedProperty(layoutAttributes, astr);
      var attrs = extendDeepAll({}, _module.layoutAttributes);
      attrs[IS_SUBPLOT_OBJ] = true;
      np2.set(attrs);
    }
    function insertAttrs(baseAttrs, newAttrs, astr) {
      var np2 = nestedProperty(baseAttrs, astr);
      np2.set(extendDeepAll(np2.get() || {}, newAttrs));
    }
  }
});

// node_modules/plotly.js/src/plot_api/plot_template.js
var require_plot_template = __commonJS({
  "node_modules/plotly.js/src/plot_api/plot_template.js"(exports2) {
    "use strict";
    var Lib = require_lib();
    var plotAttributes = require_attributes2();
    var TEMPLATEITEMNAME = "templateitemname";
    var templateAttrs = {
      name: {
        valType: "string",
        editType: "none",
        description: [
          "When used in a template, named items are created in the output figure",
          "in addition to any items the figure already has in this array.",
          "You can modify these items in the output figure by making your own",
          "item with `templateitemname` matching this `name`",
          "alongside your modifications (including `visible: false` or",
          "`enabled: false` to hide it).",
          "Has no effect outside of a template."
        ].join(" ")
      }
    };
    templateAttrs[TEMPLATEITEMNAME] = {
      valType: "string",
      editType: "calc",
      description: [
        "Used to refer to a named item in this array in the template. Named",
        "items from the template will be created even without a matching item",
        "in the input figure, but you can modify one by making an item with",
        "`templateitemname` matching its `name`, alongside your modifications",
        "(including `visible: false` or `enabled: false` to hide it).",
        "If there is no template or no matching item, this item will be",
        "hidden unless you explicitly show it with `visible: true`."
      ].join(" ")
    };
    exports2.templatedArray = function(name, attrs) {
      attrs._isLinkedToArray = name;
      attrs.name = templateAttrs.name;
      attrs[TEMPLATEITEMNAME] = templateAttrs[TEMPLATEITEMNAME];
      return attrs;
    };
    exports2.traceTemplater = function(dataTemplate) {
      var traceCounts = {};
      var traceType, typeTemplates;
      for (traceType in dataTemplate) {
        typeTemplates = dataTemplate[traceType];
        if (Array.isArray(typeTemplates) && typeTemplates.length) {
          traceCounts[traceType] = 0;
        }
      }
      function newTrace(traceIn) {
        traceType = Lib.coerce(traceIn, {}, plotAttributes, "type");
        var traceOut = { type: traceType, _template: null };
        if (traceType in traceCounts) {
          typeTemplates = dataTemplate[traceType];
          var typei = traceCounts[traceType] % typeTemplates.length;
          traceCounts[traceType]++;
          traceOut._template = typeTemplates[typei];
        } else {
        }
        return traceOut;
      }
      return {
        newTrace
        // TODO: function to figure out what's left & what didn't work
      };
    };
    exports2.newContainer = function(container, name, baseName) {
      var template = container._template;
      var part = template && (template[name] || baseName && template[baseName]);
      if (!Lib.isPlainObject(part)) part = null;
      var out = container[name] = { _template: part };
      return out;
    };
    exports2.arrayTemplater = function(container, name, inclusionAttr) {
      var template = container._template;
      var defaultsTemplate = template && template[arrayDefaultKey(name)];
      var templateItems = template && template[name];
      if (!Array.isArray(templateItems) || !templateItems.length) {
        templateItems = [];
      }
      var usedNames = {};
      function newItem(itemIn) {
        var out = { name: itemIn.name, _input: itemIn };
        var templateItemName = out[TEMPLATEITEMNAME] = itemIn[TEMPLATEITEMNAME];
        if (!validItemName(templateItemName)) {
          out._template = defaultsTemplate;
          return out;
        }
        for (var i = 0; i < templateItems.length; i++) {
          var templateItem = templateItems[i];
          if (templateItem.name === templateItemName) {
            usedNames[templateItemName] = 1;
            out._template = templateItem;
            return out;
          }
        }
        out[inclusionAttr] = itemIn[inclusionAttr] || false;
        out._template = false;
        return out;
      }
      function defaultItems() {
        var out = [];
        for (var i = 0; i < templateItems.length; i++) {
          var templateItem = templateItems[i];
          var name2 = templateItem.name;
          if (validItemName(name2) && !usedNames[name2]) {
            var outi = {
              _template: templateItem,
              name: name2,
              _input: { _templateitemname: name2 }
            };
            outi[TEMPLATEITEMNAME] = templateItem[TEMPLATEITEMNAME];
            out.push(outi);
            usedNames[name2] = 1;
          }
        }
        return out;
      }
      return {
        newItem,
        defaultItems
      };
    };
    function validItemName(name) {
      return name && typeof name === "string";
    }
    function arrayDefaultKey(name) {
      var lastChar = name.length - 1;
      if (name.charAt(lastChar) !== "s") {
        Lib.warn("bad argument to arrayDefaultKey: " + name);
      }
      return name.substr(0, name.length - 1) + "defaults";
    }
    exports2.arrayDefaultKey = arrayDefaultKey;
    exports2.arrayEditor = function(parentIn, containerStr, itemOut) {
      var lengthIn = (Lib.nestedProperty(parentIn, containerStr).get() || []).length;
      var index = itemOut._index;
      var templateItemName = index >= lengthIn && (itemOut._input || {})._templateitemname;
      if (templateItemName) index = lengthIn;
      var itemStr = containerStr + "[" + index + "]";
      var update;
      function resetUpdate() {
        update = {};
        if (templateItemName) {
          update[itemStr] = {};
          update[itemStr][TEMPLATEITEMNAME] = templateItemName;
        }
      }
      resetUpdate();
      function modifyBase(attr, value) {
        update[attr] = value;
      }
      function modifyItem(attr, value) {
        if (templateItemName) {
          Lib.nestedProperty(update[itemStr], attr).set(value);
        } else {
          update[itemStr + "." + attr] = value;
        }
      }
      function getUpdateObj() {
        var updateOut = update;
        resetUpdate();
        return updateOut;
      }
      function applyUpdate(attr, value) {
        if (attr) modifyItem(attr, value);
        var updateToApply = getUpdateObj();
        for (var key in updateToApply) {
          Lib.nestedProperty(parentIn, key).set(updateToApply[key]);
        }
      }
      return {
        modifyBase,
        modifyItem,
        getUpdateObj,
        applyUpdate
      };
    };
  }
});

// node_modules/plotly.js/src/plots/cartesian/constants.js
var require_constants2 = __commonJS({
  "node_modules/plotly.js/src/plots/cartesian/constants.js"(exports2, module2) {
    "use strict";
    var counterRegex = require_regex().counter;
    module2.exports = {
      idRegex: {
        x: counterRegex("x", "( domain)?"),
        y: counterRegex("y", "( domain)?")
      },
      attrRegex: counterRegex("[xy]axis"),
      // axis match regular expression
      xAxisMatch: counterRegex("xaxis"),
      yAxisMatch: counterRegex("yaxis"),
      // pattern matching axis ids and names
      // note that this is more permissive than counterRegex, as
      // id2name, name2id, and cleanId accept "x1" etc
      AX_ID_PATTERN: /^[xyz][0-9]*( domain)?$/,
      AX_NAME_PATTERN: /^[xyz]axis[0-9]*$/,
      // and for 2D subplots
      SUBPLOT_PATTERN: /^x([0-9]*)y([0-9]*)$/,
      HOUR_PATTERN: "hour",
      WEEKDAY_PATTERN: "day of week",
      // pixels to move mouse before you stop clamping to starting point
      MINDRAG: 8,
      // smallest dimension allowed for a zoombox
      MINZOOM: 20,
      // width of axis drag regions
      DRAGGERSIZE: 20,
      // delay before a redraw (relayout) after smooth panning and zooming
      REDRAWDELAY: 50,
      // last resort axis ranges for x and y axes if we have no data
      DFLTRANGEX: [-1, 6],
      DFLTRANGEY: [-1, 4],
      // Layers to keep trace types in the right order
      // N.B. each  'unique' plot method must have its own layer
      traceLayerClasses: [
        "imagelayer",
        "heatmaplayer",
        "contourcarpetlayer",
        "contourlayer",
        "funnellayer",
        "waterfalllayer",
        "barlayer",
        "carpetlayer",
        "violinlayer",
        "boxlayer",
        "ohlclayer",
        "scattercarpetlayer",
        "scatterlayer"
      ],
      clipOnAxisFalseQuery: [
        ".scatterlayer",
        ".barlayer",
        ".funnellayer",
        ".waterfalllayer"
      ],
      layerValue2layerClass: {
        "above traces": "above",
        "below traces": "below"
      },
      zindexSeparator: "z"
      // used for zindex of cartesian subplots e.g. xy, xyz2, xyz3, etc.
    };
  }
});

// node_modules/plotly.js/src/plots/cartesian/axis_ids.js
var require_axis_ids = __commonJS({
  "node_modules/plotly.js/src/plots/cartesian/axis_ids.js"(exports2) {
    "use strict";
    var Registry = require_registry();
    var constants = require_constants2();
    exports2.id2name = function id2name(id2) {
      if (typeof id2 !== "string" || !id2.match(constants.AX_ID_PATTERN)) return;
      var axNum = id2.split(" ")[0].substr(1);
      if (axNum === "1") axNum = "";
      return id2.charAt(0) + "axis" + axNum;
    };
    exports2.name2id = function name2id(name) {
      if (!name.match(constants.AX_NAME_PATTERN)) return;
      var axNum = name.substr(5);
      if (axNum === "1") axNum = "";
      return name.charAt(0) + axNum;
    };
    exports2.cleanId = function cleanId(id2, axLetter, domainId) {
      var domainTest = /( domain)$/.test(id2);
      if (typeof id2 !== "string" || !id2.match(constants.AX_ID_PATTERN)) return;
      if (axLetter && id2.charAt(0) !== axLetter) return;
      if (domainTest && !domainId) return;
      var axNum = id2.split(" ")[0].substr(1).replace(/^0+/, "");
      if (axNum === "1") axNum = "";
      return id2.charAt(0) + axNum + (domainTest && domainId ? " domain" : "");
    };
    exports2.list = function(gd2, axLetter, only2d) {
      var fullLayout = gd2._fullLayout;
      if (!fullLayout) return [];
      var idList = exports2.listIds(gd2, axLetter);
      var out = new Array(idList.length);
      var i;
      for (i = 0; i < idList.length; i++) {
        var idi = idList[i];
        out[i] = fullLayout[idi.charAt(0) + "axis" + idi.substr(1)];
      }
      if (!only2d) {
        var sceneIds3D = fullLayout._subplots.gl3d || [];
        for (i = 0; i < sceneIds3D.length; i++) {
          var scene = fullLayout[sceneIds3D[i]];
          if (axLetter) out.push(scene[axLetter + "axis"]);
          else out.push(scene.xaxis, scene.yaxis, scene.zaxis);
        }
      }
      return out;
    };
    exports2.listIds = function(gd2, axLetter) {
      var fullLayout = gd2._fullLayout;
      if (!fullLayout) return [];
      var subplotLists = fullLayout._subplots;
      if (axLetter) return subplotLists[axLetter + "axis"];
      return subplotLists.xaxis.concat(subplotLists.yaxis);
    };
    exports2.getFromId = function(gd2, id2, type) {
      var fullLayout = gd2._fullLayout;
      id2 = id2 === void 0 || typeof id2 !== "string" ? id2 : id2.replace(" domain", "");
      if (type === "x") id2 = id2.replace(/y[0-9]*/, "");
      else if (type === "y") id2 = id2.replace(/x[0-9]*/, "");
      return fullLayout[exports2.id2name(id2)];
    };
    exports2.getFromTrace = function(gd2, fullTrace, type) {
      var fullLayout = gd2._fullLayout;
      var ax = null;
      if (Registry.traceIs(fullTrace, "gl3d")) {
        var scene = fullTrace.scene;
        if (scene.substr(0, 5) === "scene") {
          ax = fullLayout[scene][type + "axis"];
        }
      } else {
        ax = exports2.getFromId(gd2, fullTrace[type + "axis"] || type);
      }
      return ax;
    };
    exports2.idSort = function(id1, id2) {
      var letter1 = id1.charAt(0);
      var letter2 = id2.charAt(0);
      if (letter1 !== letter2) return letter1 > letter2 ? 1 : -1;
      return +(id1.substr(1) || 1) - +(id2.substr(1) || 1);
    };
    exports2.ref2id = function(ar2) {
      return /^[xyz]/.test(ar2) ? ar2.split(" ")[0] : false;
    };
    function isFound(axId, list) {
      if (list && list.length) {
        for (var i = 0; i < list.length; i++) {
          if (list[i][axId]) return true;
        }
      }
      return false;
    }
    exports2.isLinked = function(fullLayout, axId) {
      return isFound(axId, fullLayout._axisMatchGroups) || isFound(axId, fullLayout._axisConstraintGroups);
    };
  }
});

// node_modules/plotly.js/src/components/shapes/handle_outline.js
var require_handle_outline = __commonJS({
  "node_modules/plotly.js/src/components/shapes/handle_outline.js"(exports2, module2) {
    "use strict";
    function clearOutlineControllers(gd2) {
      var zoomLayer = gd2._fullLayout._zoomlayer;
      if (zoomLayer) {
        zoomLayer.selectAll(".outline-controllers").remove();
      }
    }
    function clearOutline(gd2) {
      var zoomLayer = gd2._fullLayout._zoomlayer;
      if (zoomLayer) {
        zoomLayer.selectAll(".select-outline").remove();
      }
      gd2._fullLayout._outlining = false;
    }
    module2.exports = {
      clearOutlineControllers,
      clearOutline
    };
  }
});

// node_modules/plotly.js/src/traces/scatter/layout_attributes.js
var require_layout_attributes3 = __commonJS({
  "node_modules/plotly.js/src/traces/scatter/layout_attributes.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      scattermode: {
        valType: "enumerated",
        values: ["group", "overlay"],
        dflt: "overlay",
        editType: "calc",
        description: [
          "Determines how scatter points at the same location coordinate",
          "are displayed on the graph.",
          "With *group*, the scatter points are plotted next to one another",
          "centered around the shared location.",
          "With *overlay*, the scatter points are plotted over one another,",
          "you might need to reduce *opacity* to see multiple scatter points."
        ].join(" ")
      },
      scattergap: {
        valType: "number",
        min: 0,
        max: 1,
        editType: "calc",
        description: [
          "Sets the gap (in plot fraction) between scatter points of",
          "adjacent location coordinates.",
          "Defaults to `bargap`."
        ].join(" ")
      }
    };
  }
});

// node_modules/plotly.js/src/plots/get_data.js
var require_get_data = __commonJS({
  "node_modules/plotly.js/src/plots/get_data.js"(exports2) {
    "use strict";
    var Registry = require_registry();
    var SUBPLOT_PATTERN = require_constants2().SUBPLOT_PATTERN;
    exports2.getSubplotCalcData = function(calcData, type, subplotId) {
      var basePlotModule = Registry.subplotsRegistry[type];
      if (!basePlotModule) return [];
      var attr = basePlotModule.attr;
      var subplotCalcData = [];
      for (var i = 0; i < calcData.length; i++) {
        var calcTrace = calcData[i];
        var trace = calcTrace[0].trace;
        if (trace[attr] === subplotId) subplotCalcData.push(calcTrace);
      }
      return subplotCalcData;
    };
    exports2.getModuleCalcData = function(calcdata, arg1, arg2) {
      var moduleCalcData = [];
      var remainingCalcData = [];
      var plotMethod;
      if (typeof arg1 === "string") {
        plotMethod = Registry.getModule(arg1).plot;
      } else if (typeof arg1 === "function") {
        plotMethod = arg1;
      } else {
        plotMethod = arg1.plot;
      }
      if (!plotMethod) {
        return [moduleCalcData, calcdata];
      }
      var zorder = arg2;
      for (var i = 0; i < calcdata.length; i++) {
        var cd2 = calcdata[i];
        var trace = cd2[0].trace;
        var filterByZ = trace.zorder !== void 0;
        if (trace.visible !== true || trace._length === 0) continue;
        if (trace._module && trace._module.plot === plotMethod && (!filterByZ || trace.zorder === zorder)) {
          moduleCalcData.push(cd2);
        } else {
          remainingCalcData.push(cd2);
        }
      }
      return [moduleCalcData, remainingCalcData];
    };
    exports2.getSubplotData = function getSubplotData(data, type, subplotId) {
      if (!Registry.subplotsRegistry[type]) return [];
      var attr = Registry.subplotsRegistry[type].attr;
      var subplotData = [];
      var trace, subplotX, subplotY;
      if (type === "gl2d") {
        var spmatch = subplotId.match(SUBPLOT_PATTERN);
        subplotX = "x" + spmatch[1];
        subplotY = "y" + spmatch[2];
      }
      for (var i = 0; i < data.length; i++) {
        trace = data[i];
        if (type === "gl2d" && Registry.traceIs(trace, "gl2d")) {
          if (trace[attr[0]] === subplotX && trace[attr[1]] === subplotY) {
            subplotData.push(trace);
          }
        } else {
          if (trace[attr] === subplotId) subplotData.push(trace);
        }
      }
      return subplotData;
    };
  }
});

// node_modules/plotly.js/src/plots/command.js
var require_command = __commonJS({
  "node_modules/plotly.js/src/plots/command.js"(exports2) {
    "use strict";
    var Registry = require_registry();
    var Lib = require_lib();
    exports2.manageCommandObserver = function(gd2, container, commandList, onchange) {
      var ret = {};
      var enabled = true;
      if (container && container._commandObserver) {
        ret = container._commandObserver;
      }
      if (!ret.cache) {
        ret.cache = {};
      }
      ret.lookupTable = {};
      var binding = exports2.hasSimpleAPICommandBindings(gd2, commandList, ret.lookupTable);
      if (container && container._commandObserver) {
        if (!binding) {
          if (container._commandObserver.remove) {
            container._commandObserver.remove();
            container._commandObserver = null;
            return ret;
          }
        } else {
          return ret;
        }
      }
      if (binding) {
        bindingValueHasChanged(gd2, binding, ret.cache);
        ret.check = function check() {
          if (!enabled) return;
          var update = bindingValueHasChanged(gd2, binding, ret.cache);
          if (update.changed && onchange) {
            if (ret.lookupTable[update.value] !== void 0) {
              ret.disable();
              Promise.resolve(onchange({
                value: update.value,
                type: binding.type,
                prop: binding.prop,
                traces: binding.traces,
                index: ret.lookupTable[update.value]
              })).then(ret.enable, ret.enable);
            }
          }
          return update.changed;
        };
        var checkEvents = [
          "plotly_relayout",
          "plotly_redraw",
          "plotly_restyle",
          "plotly_update",
          "plotly_animatingframe",
          "plotly_afterplot"
        ];
        for (var i = 0; i < checkEvents.length; i++) {
          gd2._internalOn(checkEvents[i], ret.check);
        }
        ret.remove = function() {
          for (var i2 = 0; i2 < checkEvents.length; i2++) {
            gd2._removeInternalListener(checkEvents[i2], ret.check);
          }
        };
      } else {
        Lib.log("Unable to automatically bind plot updates to API command");
        ret.lookupTable = {};
        ret.remove = function() {
        };
      }
      ret.disable = function disable() {
        enabled = false;
      };
      ret.enable = function enable() {
        enabled = true;
      };
      if (container) {
        container._commandObserver = ret;
      }
      return ret;
    };
    exports2.hasSimpleAPICommandBindings = function(gd2, commandList, bindingsByValue) {
      var i;
      var n = commandList.length;
      var refBinding;
      for (i = 0; i < n; i++) {
        var binding;
        var command = commandList[i];
        var method = command.method;
        var args = command.args;
        if (!Array.isArray(args)) args = [];
        if (!method) {
          return false;
        }
        var bindings = exports2.computeAPICommandBindings(gd2, method, args);
        if (bindings.length !== 1) {
          return false;
        }
        if (!refBinding) {
          refBinding = bindings[0];
          if (Array.isArray(refBinding.traces)) {
            refBinding.traces.sort();
          }
        } else {
          binding = bindings[0];
          if (binding.type !== refBinding.type) {
            return false;
          }
          if (binding.prop !== refBinding.prop) {
            return false;
          }
          if (Array.isArray(refBinding.traces)) {
            if (Array.isArray(binding.traces)) {
              binding.traces.sort();
              for (var j = 0; j < refBinding.traces.length; j++) {
                if (refBinding.traces[j] !== binding.traces[j]) {
                  return false;
                }
              }
            } else {
              return false;
            }
          } else {
            if (binding.prop !== refBinding.prop) {
              return false;
            }
          }
        }
        binding = bindings[0];
        var value = binding.value;
        if (Array.isArray(value)) {
          if (value.length === 1) {
            value = value[0];
          } else {
            return false;
          }
        }
        if (bindingsByValue) {
          bindingsByValue[value] = i;
        }
      }
      return refBinding;
    };
    function bindingValueHasChanged(gd2, binding, cache) {
      var container, value, obj;
      var changed = false;
      if (binding.type === "data") {
        container = gd2._fullData[binding.traces !== null ? binding.traces[0] : 0];
      } else if (binding.type === "layout") {
        container = gd2._fullLayout;
      } else {
        return false;
      }
      value = Lib.nestedProperty(container, binding.prop).get();
      obj = cache[binding.type] = cache[binding.type] || {};
      if (obj.hasOwnProperty(binding.prop)) {
        if (obj[binding.prop] !== value) {
          changed = true;
        }
      }
      obj[binding.prop] = value;
      return {
        changed,
        value
      };
    }
    exports2.executeAPICommand = function(gd2, method, args) {
      if (method === "skip") return Promise.resolve();
      var _method = Registry.apiMethodRegistry[method];
      var allArgs = [gd2];
      if (!Array.isArray(args)) args = [];
      for (var i = 0; i < args.length; i++) {
        allArgs.push(args[i]);
      }
      return _method.apply(null, allArgs).catch(function(err) {
        Lib.warn("API call to Plotly." + method + " rejected.", err);
        return Promise.reject(err);
      });
    };
    exports2.computeAPICommandBindings = function(gd2, method, args) {
      var bindings;
      if (!Array.isArray(args)) args = [];
      switch (method) {
        case "restyle":
          bindings = computeDataBindings(gd2, args);
          break;
        case "relayout":
          bindings = computeLayoutBindings(gd2, args);
          break;
        case "update":
          bindings = computeDataBindings(gd2, [args[0], args[2]]).concat(computeLayoutBindings(gd2, [args[1]]));
          break;
        case "animate":
          bindings = computeAnimateBindings(gd2, args);
          break;
        default:
          bindings = [];
      }
      return bindings;
    };
    function computeAnimateBindings(gd2, args) {
      if (Array.isArray(args[0]) && args[0].length === 1 && ["string", "number"].indexOf(typeof args[0][0]) !== -1) {
        return [{ type: "layout", prop: "_currentFrame", value: args[0][0].toString() }];
      } else {
        return [];
      }
    }
    function computeLayoutBindings(gd2, args) {
      var bindings = [];
      var astr = args[0];
      var aobj = {};
      if (typeof astr === "string") {
        aobj[astr] = args[1];
      } else if (Lib.isPlainObject(astr)) {
        aobj = astr;
      } else {
        return bindings;
      }
      crawl(aobj, function(path, attrName, attr) {
        bindings.push({ type: "layout", prop: path, value: attr });
      }, "", 0);
      return bindings;
    }
    function computeDataBindings(gd2, args) {
      var traces, astr, val, aobj;
      var bindings = [];
      astr = args[0];
      val = args[1];
      traces = args[2];
      aobj = {};
      if (typeof astr === "string") {
        aobj[astr] = val;
      } else if (Lib.isPlainObject(astr)) {
        aobj = astr;
        if (traces === void 0) {
          traces = val;
        }
      } else {
        return bindings;
      }
      if (traces === void 0) {
        traces = null;
      }
      crawl(aobj, function(path, attrName, _attr) {
        var thisTraces;
        var attr;
        if (Array.isArray(_attr)) {
          attr = _attr.slice();
          var nAttr = Math.min(attr.length, gd2.data.length);
          if (traces) {
            nAttr = Math.min(nAttr, traces.length);
          }
          thisTraces = [];
          for (var j = 0; j < nAttr; j++) {
            thisTraces[j] = traces ? traces[j] : j;
          }
        } else {
          attr = _attr;
          thisTraces = traces ? traces.slice() : null;
        }
        if (thisTraces === null) {
          if (Array.isArray(attr)) {
            attr = attr[0];
          }
        } else if (Array.isArray(thisTraces)) {
          if (!Array.isArray(attr)) {
            var tmp = attr;
            attr = [];
            for (var i = 0; i < thisTraces.length; i++) {
              attr[i] = tmp;
            }
          }
          attr.length = Math.min(thisTraces.length, attr.length);
        }
        bindings.push({
          type: "data",
          prop: path,
          traces: thisTraces,
          value: attr
        });
      }, "", 0);
      return bindings;
    }
    function crawl(attrs, callback, path, depth) {
      Object.keys(attrs).forEach(function(attrName) {
        var attr = attrs[attrName];
        if (attrName[0] === "_") return;
        var thisPath = path + (depth > 0 ? "." : "") + attrName;
        if (Lib.isPlainObject(attr)) {
          crawl(attr, callback, thisPath, depth + 1);
        } else {
          callback(thisPath, attrName, attr);
        }
      });
    }
  }
});

// node_modules/plotly.js/src/plots/plots.js
var require_plots = __commonJS({
  "node_modules/plotly.js/src/plots/plots.js"(exports2, module2) {
    "use strict";
    var d3 = require_d3();
    var timeFormatLocale = (init_src2(), __toCommonJS(src_exports2)).timeFormatLocale;
    var formatLocale2 = (init_src3(), __toCommonJS(src_exports3)).formatLocale;
    var isNumeric = require_fast_isnumeric();
    var b64encode = (init_base64_arraybuffer_es5(), __toCommonJS(base64_arraybuffer_es5_exports));
    var Registry = require_registry();
    var PlotSchema = require_plot_schema();
    var Template = require_plot_template();
    var Lib = require_lib();
    var Color = require_color();
    var BADNUM = require_numerical().BADNUM;
    var axisIDs = require_axis_ids();
    var clearOutline = require_handle_outline().clearOutline;
    var scatterAttrs = require_layout_attributes3();
    var animationAttrs = require_animation_attributes();
    var frameAttrs = require_frame_attributes();
    var getModuleCalcData = require_get_data().getModuleCalcData;
    var relinkPrivateKeys = Lib.relinkPrivateKeys;
    var _ = Lib._;
    var plots = module2.exports = {};
    Lib.extendFlat(plots, Registry);
    plots.attributes = require_attributes2();
    plots.attributes.type.values = plots.allTypes;
    plots.fontAttrs = require_font_attributes();
    plots.layoutAttributes = require_layout_attributes2();
    var transformsRegistry = plots.transformsRegistry;
    var commandModule = require_command();
    plots.executeAPICommand = commandModule.executeAPICommand;
    plots.computeAPICommandBindings = commandModule.computeAPICommandBindings;
    plots.manageCommandObserver = commandModule.manageCommandObserver;
    plots.hasSimpleAPICommandBindings = commandModule.hasSimpleAPICommandBindings;
    plots.redrawText = function(gd2) {
      gd2 = Lib.getGraphDiv(gd2);
      return new Promise(function(resolve) {
        setTimeout(function() {
          if (!gd2._fullLayout) return;
          Registry.getComponentMethod("annotations", "draw")(gd2);
          Registry.getComponentMethod("legend", "draw")(gd2);
          Registry.getComponentMethod("colorbar", "draw")(gd2);
          resolve(plots.previousPromises(gd2));
        }, 300);
      });
    };
    plots.resize = function(gd2) {
      gd2 = Lib.getGraphDiv(gd2);
      var resolveLastResize;
      var p = new Promise(function(resolve, reject) {
        if (!gd2 || Lib.isHidden(gd2)) {
          reject(new Error("Resize must be passed a displayed plot div element."));
        }
        if (gd2._redrawTimer) clearTimeout(gd2._redrawTimer);
        if (gd2._resolveResize) resolveLastResize = gd2._resolveResize;
        gd2._resolveResize = resolve;
        gd2._redrawTimer = setTimeout(function() {
          if (!gd2.layout || gd2.layout.width && gd2.layout.height || Lib.isHidden(gd2)) {
            resolve(gd2);
            return;
          }
          delete gd2.layout.width;
          delete gd2.layout.height;
          var oldchanged = gd2.changed;
          gd2.autoplay = true;
          Registry.call("relayout", gd2, { autosize: true }).then(function() {
            gd2.changed = oldchanged;
            if (gd2._resolveResize === resolve) {
              delete gd2._resolveResize;
              resolve(gd2);
            }
          });
        }, 100);
      });
      if (resolveLastResize) resolveLastResize(p);
      return p;
    };
    plots.previousPromises = function(gd2) {
      if ((gd2._promises || []).length) {
        return Promise.all(gd2._promises).then(function() {
          gd2._promises = [];
        });
      }
    };
    plots.addLinks = function(gd2) {
      if (!gd2._context.showLink && !gd2._context.showSources) return;
      var fullLayout = gd2._fullLayout;
      var linkContainer = Lib.ensureSingle(fullLayout._paper, "text", "js-plot-link-container", function(s) {
        s.style({
          "font-family": '"Open Sans", Arial, sans-serif',
          "font-size": "12px",
          fill: Color.defaultLine,
          "pointer-events": "all"
        }).each(function() {
          var links = d3.select(this);
          links.append("tspan").classed("js-link-to-tool", true);
          links.append("tspan").classed("js-link-spacer", true);
          links.append("tspan").classed("js-sourcelinks", true);
        });
      });
      var text = linkContainer.node();
      var attrs = { y: fullLayout._paper.attr("height") - 9 };
      if (document.body.contains(text) && text.getComputedTextLength() >= fullLayout.width - 20) {
        attrs["text-anchor"] = "start";
        attrs.x = 5;
      } else {
        attrs["text-anchor"] = "end";
        attrs.x = fullLayout._paper.attr("width") - 7;
      }
      linkContainer.attr(attrs);
      var toolspan = linkContainer.select(".js-link-to-tool");
      var spacespan = linkContainer.select(".js-link-spacer");
      var sourcespan = linkContainer.select(".js-sourcelinks");
      if (gd2._context.showSources) gd2._context.showSources(gd2);
      if (gd2._context.showLink) positionPlayWithData(gd2, toolspan);
      spacespan.text(toolspan.text() && sourcespan.text() ? " - " : "");
    };
    function positionPlayWithData(gd2, container) {
      container.text("");
      var link = container.append("a").attr({
        "xlink:xlink:href": "#",
        class: "link--impt link--embedview",
        "font-weight": "bold"
      }).text(gd2._context.linkText + " " + String.fromCharCode(187));
      if (gd2._context.sendData) {
        link.on("click", function() {
          plots.sendDataToCloud(gd2);
        });
      } else {
        var path = window.location.pathname.split("/");
        var query = window.location.search;
        link.attr({
          "xlink:xlink:show": "new",
          "xlink:xlink:href": "/" + path[2].split(".")[0] + "/" + path[1] + query
        });
      }
    }
    plots.sendDataToCloud = function(gd2) {
      var baseUrl = (window.PLOTLYENV || {}).BASE_URL || gd2._context.plotlyServerURL;
      if (!baseUrl) return;
      gd2.emit("plotly_beforeexport");
      var hiddenformDiv = d3.select(gd2).append("div").attr("id", "hiddenform").style("display", "none");
      var hiddenform = hiddenformDiv.append("form").attr({
        action: baseUrl + "/external",
        method: "post",
        target: "_blank"
      });
      var hiddenformInput = hiddenform.append("input").attr({
        type: "text",
        name: "data"
      });
      hiddenformInput.node().value = plots.graphJson(gd2, false, "keepdata");
      hiddenform.node().submit();
      hiddenformDiv.remove();
      gd2.emit("plotly_afterexport");
      return false;
    };
    var d3FormatKeys = [
      "days",
      "shortDays",
      "months",
      "shortMonths",
      "periods",
      "dateTime",
      "date",
      "time",
      "decimal",
      "thousands",
      "grouping",
      "currency"
    ];
    var extraFormatKeys = [
      "year",
      "month",
      "dayMonth",
      "dayMonthYear"
    ];
    plots.supplyDefaults = function(gd2, opts) {
      var skipUpdateCalc = opts && opts.skipUpdateCalc;
      var oldFullLayout = gd2._fullLayout || {};
      if (oldFullLayout._skipDefaults) {
        delete oldFullLayout._skipDefaults;
        return;
      }
      var newFullLayout = gd2._fullLayout = {};
      var newLayout = gd2.layout || {};
      var oldFullData = gd2._fullData || [];
      var newFullData = gd2._fullData = [];
      var newData = gd2.data || [];
      var oldCalcdata = gd2.calcdata || [];
      var context = gd2._context || {};
      var i;
      if (!gd2._transitionData) plots.createTransitionData(gd2);
      newFullLayout._dfltTitle = {
        plot: _(gd2, "Click to enter Plot title"),
        subtitle: _(gd2, "Click to enter Plot subtitle"),
        x: _(gd2, "Click to enter X axis title"),
        y: _(gd2, "Click to enter Y axis title"),
        colorbar: _(gd2, "Click to enter Colorscale title"),
        annotation: _(gd2, "new text")
      };
      newFullLayout._traceWord = _(gd2, "trace");
      var formatObj = getFormatObj(gd2, d3FormatKeys);
      newFullLayout._mapboxAccessToken = context.mapboxAccessToken;
      if (oldFullLayout._initialAutoSizeIsDone) {
        var oldWidth = oldFullLayout.width;
        var oldHeight = oldFullLayout.height;
        plots.supplyLayoutGlobalDefaults(newLayout, newFullLayout, formatObj);
        if (!newLayout.width) newFullLayout.width = oldWidth;
        if (!newLayout.height) newFullLayout.height = oldHeight;
        plots.sanitizeMargins(newFullLayout);
      } else {
        plots.supplyLayoutGlobalDefaults(newLayout, newFullLayout, formatObj);
        var missingWidthOrHeight = !newLayout.width || !newLayout.height;
        var autosize = newFullLayout.autosize;
        var autosizable = context.autosizable;
        var initialAutoSize = missingWidthOrHeight && (autosize || autosizable);
        if (initialAutoSize) plots.plotAutoSize(gd2, newLayout, newFullLayout);
        else if (missingWidthOrHeight) plots.sanitizeMargins(newFullLayout);
        if (!autosize && missingWidthOrHeight) {
          newLayout.width = newFullLayout.width;
          newLayout.height = newFullLayout.height;
        }
      }
      newFullLayout._d3locale = getFormatter(formatObj, newFullLayout.separators);
      newFullLayout._extraFormat = getFormatObj(gd2, extraFormatKeys);
      newFullLayout._initialAutoSizeIsDone = true;
      newFullLayout._dataLength = newData.length;
      newFullLayout._modules = [];
      newFullLayout._visibleModules = [];
      newFullLayout._basePlotModules = [];
      var subplots = newFullLayout._subplots = emptySubplotLists();
      var splomAxes = newFullLayout._splomAxes = { x: {}, y: {} };
      var splomSubplots = newFullLayout._splomSubplots = {};
      newFullLayout._splomGridDflt = {};
      newFullLayout._scatterStackOpts = {};
      newFullLayout._firstScatter = {};
      newFullLayout._alignmentOpts = {};
      newFullLayout._colorAxes = {};
      newFullLayout._requestRangeslider = {};
      newFullLayout._traceUids = getTraceUids(oldFullData, newData);
      newFullLayout._globalTransforms = (gd2._context || {}).globalTransforms;
      plots.supplyDataDefaults(newData, newFullData, newLayout, newFullLayout);
      var splomXa = Object.keys(splomAxes.x);
      var splomYa = Object.keys(splomAxes.y);
      if (splomXa.length > 1 && splomYa.length > 1) {
        Registry.getComponentMethod("grid", "sizeDefaults")(newLayout, newFullLayout);
        for (i = 0; i < splomXa.length; i++) {
          Lib.pushUnique(subplots.xaxis, splomXa[i]);
        }
        for (i = 0; i < splomYa.length; i++) {
          Lib.pushUnique(subplots.yaxis, splomYa[i]);
        }
        for (var k in splomSubplots) {
          Lib.pushUnique(subplots.cartesian, k);
        }
      }
      newFullLayout._has = plots._hasPlotType.bind(newFullLayout);
      if (oldFullData.length === newFullData.length) {
        for (i = 0; i < newFullData.length; i++) {
          relinkPrivateKeys(newFullData[i], oldFullData[i]);
        }
      }
      plots.supplyLayoutModuleDefaults(newLayout, newFullLayout, newFullData, gd2._transitionData);
      var _modules = newFullLayout._visibleModules;
      var crossTraceDefaultsFuncs = [];
      for (i = 0; i < _modules.length; i++) {
        var funci = _modules[i].crossTraceDefaults;
        if (funci) Lib.pushUnique(crossTraceDefaultsFuncs, funci);
      }
      for (i = 0; i < crossTraceDefaultsFuncs.length; i++) {
        crossTraceDefaultsFuncs[i](newFullData, newFullLayout);
      }
      newFullLayout._hasOnlyLargeSploms = newFullLayout._basePlotModules.length === 1 && newFullLayout._basePlotModules[0].name === "splom" && splomXa.length > 15 && splomYa.length > 15 && newFullLayout.shapes.length === 0 && newFullLayout.images.length === 0;
      plots.linkSubplots(newFullData, newFullLayout, oldFullData, oldFullLayout);
      plots.cleanPlot(newFullData, newFullLayout, oldFullData, oldFullLayout);
      var hadGL2D = !!(oldFullLayout._has && oldFullLayout._has("gl2d"));
      var hasGL2D = !!(newFullLayout._has && newFullLayout._has("gl2d"));
      var hadCartesian = !!(oldFullLayout._has && oldFullLayout._has("cartesian"));
      var hasCartesian = !!(newFullLayout._has && newFullLayout._has("cartesian"));
      var hadBgLayer = hadCartesian || hadGL2D;
      var hasBgLayer = hasCartesian || hasGL2D;
      if (hadBgLayer && !hasBgLayer) {
        oldFullLayout._bgLayer.remove();
      } else if (hasBgLayer && !hadBgLayer) {
        newFullLayout._shouldCreateBgLayer = true;
      }
      if (oldFullLayout._zoomlayer && !gd2._dragging) {
        clearOutline({
          // mock old gd
          _fullLayout: oldFullLayout
        });
      }
      fillMetaTextHelpers(newFullData, newFullLayout);
      relinkPrivateKeys(newFullLayout, oldFullLayout);
      Registry.getComponentMethod("colorscale", "crossTraceDefaults")(newFullData, newFullLayout);
      if (!newFullLayout._preGUI) newFullLayout._preGUI = {};
      if (!newFullLayout._tracePreGUI) newFullLayout._tracePreGUI = {};
      var tracePreGUI = newFullLayout._tracePreGUI;
      var uids = {};
      var uid;
      for (uid in tracePreGUI) uids[uid] = "old";
      for (i = 0; i < newFullData.length; i++) {
        uid = newFullData[i]._fullInput.uid;
        if (!uids[uid]) tracePreGUI[uid] = {};
        uids[uid] = "new";
      }
      for (uid in uids) {
        if (uids[uid] === "old") delete tracePreGUI[uid];
      }
      initMargins(newFullLayout);
      Registry.getComponentMethod("rangeslider", "makeData")(newFullLayout);
      if (!skipUpdateCalc && oldCalcdata.length === newFullData.length) {
        plots.supplyDefaultsUpdateCalc(oldCalcdata, newFullData);
      }
    };
    plots.supplyDefaultsUpdateCalc = function(oldCalcdata, newFullData) {
      for (var i = 0; i < newFullData.length; i++) {
        var newTrace = newFullData[i];
        var cd0 = (oldCalcdata[i] || [])[0];
        if (cd0 && cd0.trace) {
          var oldTrace = cd0.trace;
          if (oldTrace._hasCalcTransform) {
            var arrayAttrs = oldTrace._arrayAttrs;
            var j, astr, oldArrayVal;
            for (j = 0; j < arrayAttrs.length; j++) {
              astr = arrayAttrs[j];
              oldArrayVal = Lib.nestedProperty(oldTrace, astr).get().slice();
              Lib.nestedProperty(newTrace, astr).set(oldArrayVal);
            }
          }
          cd0.trace = newTrace;
        }
      }
    };
    function getTraceUids(oldFullData, newData) {
      var len = newData.length;
      var oldFullInput = [];
      var i, prevFullInput;
      for (i = 0; i < oldFullData.length; i++) {
        var thisFullInput = oldFullData[i]._fullInput;
        if (thisFullInput !== prevFullInput) oldFullInput.push(thisFullInput);
        prevFullInput = thisFullInput;
      }
      var oldLen = oldFullInput.length;
      var out = new Array(len);
      var seenUids = {};
      function setUid(uid, i2) {
        out[i2] = uid;
        seenUids[uid] = 1;
      }
      function tryUid(uid, i2) {
        if (uid && typeof uid === "string" && !seenUids[uid]) {
          setUid(uid, i2);
          return true;
        }
      }
      for (i = 0; i < len; i++) {
        var newUid = newData[i].uid;
        if (typeof newUid === "number") newUid = String(newUid);
        if (tryUid(newUid, i)) continue;
        if (i < oldLen && tryUid(oldFullInput[i].uid, i)) continue;
        setUid(Lib.randstr(seenUids), i);
      }
      return out;
    }
    function emptySubplotLists() {
      var collectableSubplotTypes = Registry.collectableSubplotTypes;
      var out = {};
      var i, j;
      if (!collectableSubplotTypes) {
        collectableSubplotTypes = [];
        var subplotsRegistry = Registry.subplotsRegistry;
        for (var subplotType in subplotsRegistry) {
          var subplotModule = subplotsRegistry[subplotType];
          var subplotAttr = subplotModule.attr;
          if (subplotAttr) {
            collectableSubplotTypes.push(subplotType);
            if (Array.isArray(subplotAttr)) {
              for (j = 0; j < subplotAttr.length; j++) {
                Lib.pushUnique(collectableSubplotTypes, subplotAttr[j]);
              }
            }
          }
        }
      }
      for (i = 0; i < collectableSubplotTypes.length; i++) {
        out[collectableSubplotTypes[i]] = [];
      }
      return out;
    }
    function getFormatObj(gd2, formatKeys) {
      var locale3 = gd2._context.locale;
      if (!locale3) locale3 = "en-US";
      var formatDone = false;
      var formatObj = {};
      function includeFormat(newFormat) {
        var formatFinished = true;
        for (var i2 = 0; i2 < formatKeys.length; i2++) {
          var formatKey = formatKeys[i2];
          if (!formatObj[formatKey]) {
            if (newFormat[formatKey]) {
              formatObj[formatKey] = newFormat[formatKey];
            } else formatFinished = false;
          }
        }
        if (formatFinished) formatDone = true;
      }
      for (var i = 0; i < 2; i++) {
        var locales = gd2._context.locales;
        for (var j = 0; j < 2; j++) {
          var formatj = (locales[locale3] || {}).format;
          if (formatj) {
            includeFormat(formatj);
            if (formatDone) break;
          }
          locales = Registry.localeRegistry;
        }
        var baseLocale = locale3.split("-")[0];
        if (formatDone || baseLocale === locale3) break;
        locale3 = baseLocale;
      }
      if (!formatDone) includeFormat(Registry.localeRegistry.en.format);
      return formatObj;
    }
    function getFormatter(formatObj, separators) {
      formatObj.decimal = separators.charAt(0);
      formatObj.thousands = separators.charAt(1);
      return {
        numberFormat: function(formatStr) {
          try {
            formatStr = formatLocale2(formatObj).format(
              Lib.adjustFormat(formatStr)
            );
          } catch (e) {
            Lib.warnBadFormat(formatStr);
            return Lib.noFormat;
          }
          return formatStr;
        },
        timeFormat: timeFormatLocale(formatObj).utcFormat
      };
    }
    function fillMetaTextHelpers(newFullData, newFullLayout) {
      var _meta;
      var meta4data = [];
      if (newFullLayout.meta) {
        _meta = newFullLayout._meta = {
          meta: newFullLayout.meta,
          layout: { meta: newFullLayout.meta }
        };
      }
      for (var i = 0; i < newFullData.length; i++) {
        var trace = newFullData[i];
        if (trace.meta) {
          meta4data[trace.index] = trace._meta = { meta: trace.meta };
        } else if (newFullLayout.meta) {
          trace._meta = { meta: newFullLayout.meta };
        }
        if (newFullLayout.meta) {
          trace._meta.layout = { meta: newFullLayout.meta };
        }
      }
      if (meta4data.length) {
        if (!_meta) {
          _meta = newFullLayout._meta = {};
        }
        _meta.data = meta4data;
      }
    }
    plots.createTransitionData = function(gd2) {
      if (!gd2._transitionData) {
        gd2._transitionData = {};
      }
      if (!gd2._transitionData._frames) {
        gd2._transitionData._frames = [];
      }
      if (!gd2._transitionData._frameHash) {
        gd2._transitionData._frameHash = {};
      }
      if (!gd2._transitionData._counter) {
        gd2._transitionData._counter = 0;
      }
      if (!gd2._transitionData._interruptCallbacks) {
        gd2._transitionData._interruptCallbacks = [];
      }
    };
    plots._hasPlotType = function(category) {
      var i;
      var basePlotModules = this._basePlotModules || [];
      for (i = 0; i < basePlotModules.length; i++) {
        if (basePlotModules[i].name === category) return true;
      }
      var modules = this._modules || [];
      for (i = 0; i < modules.length; i++) {
        var name = modules[i].name;
        if (name === category) return true;
        var _module = Registry.modules[name];
        if (_module && _module.categories[category]) return true;
      }
      return false;
    };
    plots.cleanPlot = function(newFullData, newFullLayout, oldFullData, oldFullLayout) {
      var i, j;
      var basePlotModules = oldFullLayout._basePlotModules || [];
      for (i = 0; i < basePlotModules.length; i++) {
        var _module = basePlotModules[i];
        if (_module.clean) {
          _module.clean(newFullData, newFullLayout, oldFullData, oldFullLayout);
        }
      }
      var hadGl = oldFullLayout._has && oldFullLayout._has("gl");
      var hasGl = newFullLayout._has && newFullLayout._has("gl");
      if (hadGl && !hasGl) {
        if (oldFullLayout._glcontainer !== void 0) {
          oldFullLayout._glcontainer.selectAll(".gl-canvas").remove();
          oldFullLayout._glcontainer.selectAll(".no-webgl").remove();
          oldFullLayout._glcanvas = null;
        }
      }
      var hasInfoLayer = !!oldFullLayout._infolayer;
      oldLoop:
        for (i = 0; i < oldFullData.length; i++) {
          var oldTrace = oldFullData[i];
          var oldUid = oldTrace.uid;
          for (j = 0; j < newFullData.length; j++) {
            var newTrace = newFullData[j];
            if (oldUid === newTrace.uid) continue oldLoop;
          }
          if (hasInfoLayer) {
            oldFullLayout._infolayer.select(".cb" + oldUid).remove();
          }
        }
    };
    plots.linkSubplots = function(newFullData, newFullLayout, oldFullData, oldFullLayout) {
      var i, j;
      var oldSubplots = oldFullLayout._plots || {};
      var newSubplots = newFullLayout._plots = {};
      var newSubplotList = newFullLayout._subplots;
      var mockGd = {
        _fullData: newFullData,
        _fullLayout: newFullLayout
      };
      var ids = newSubplotList.cartesian.concat(newSubplotList.gl2d || []);
      for (i = 0; i < ids.length; i++) {
        var id2 = ids[i];
        var oldSubplot = oldSubplots[id2];
        var xaxis = axisIDs.getFromId(mockGd, id2, "x");
        var yaxis = axisIDs.getFromId(mockGd, id2, "y");
        var plotinfo;
        if (oldSubplot) {
          plotinfo = newSubplots[id2] = oldSubplot;
        } else {
          plotinfo = newSubplots[id2] = {};
          plotinfo.id = id2;
        }
        xaxis._counterAxes.push(yaxis._id);
        yaxis._counterAxes.push(xaxis._id);
        xaxis._subplotsWith.push(id2);
        yaxis._subplotsWith.push(id2);
        plotinfo.xaxis = xaxis;
        plotinfo.yaxis = yaxis;
        plotinfo._hasClipOnAxisFalse = false;
        for (j = 0; j < newFullData.length; j++) {
          var trace = newFullData[j];
          if (trace.xaxis === plotinfo.xaxis._id && trace.yaxis === plotinfo.yaxis._id && trace.cliponaxis === false) {
            plotinfo._hasClipOnAxisFalse = true;
            break;
          }
        }
      }
      var axList = axisIDs.list(mockGd, null, true);
      var ax;
      for (i = 0; i < axList.length; i++) {
        ax = axList[i];
        var mainAx = null;
        if (ax.overlaying) {
          mainAx = axisIDs.getFromId(mockGd, ax.overlaying);
          if (mainAx && mainAx.overlaying) {
            ax.overlaying = false;
            mainAx = null;
          }
        }
        ax._mainAxis = mainAx || ax;
        if (mainAx) ax.domain = mainAx.domain.slice();
        ax._anchorAxis = ax.anchor === "free" ? null : axisIDs.getFromId(mockGd, ax.anchor);
      }
      for (i = 0; i < axList.length; i++) {
        ax = axList[i];
        ax._counterAxes.sort(axisIDs.idSort);
        ax._subplotsWith.sort(Lib.subplotSort);
        ax._mainSubplot = findMainSubplot(ax, newFullLayout);
        if (ax._counterAxes.length && (ax.spikemode && ax.spikemode.indexOf("across") !== -1 || ax.automargin && ax.mirror && ax.anchor !== "free" || Registry.getComponentMethod("rangeslider", "isVisible")(ax))) {
          var min = 1;
          var max = 0;
          for (j = 0; j < ax._counterAxes.length; j++) {
            var ax2 = axisIDs.getFromId(mockGd, ax._counterAxes[j]);
            min = Math.min(min, ax2.domain[0]);
            max = Math.max(max, ax2.domain[1]);
          }
          if (min < max) {
            ax._counterDomainMin = min;
            ax._counterDomainMax = max;
          }
        }
      }
    };
    function findMainSubplot(ax, fullLayout) {
      var mockGd = { _fullLayout: fullLayout };
      var isX = ax._id.charAt(0) === "x";
      var anchorAx = ax._mainAxis._anchorAxis;
      var mainSubplotID = "";
      var nextBestMainSubplotID = "";
      var anchorID = "";
      if (anchorAx) {
        anchorID = anchorAx._mainAxis._id;
        mainSubplotID = isX ? ax._id + anchorID : anchorID + ax._id;
      }
      if (!mainSubplotID || !fullLayout._plots[mainSubplotID]) {
        mainSubplotID = "";
        var counterIDs = ax._counterAxes;
        for (var j = 0; j < counterIDs.length; j++) {
          var counterPart = counterIDs[j];
          var id2 = isX ? ax._id + counterPart : counterPart + ax._id;
          if (!nextBestMainSubplotID) nextBestMainSubplotID = id2;
          var counterAx = axisIDs.getFromId(mockGd, counterPart);
          if (anchorID && counterAx.overlaying === anchorID) {
            mainSubplotID = id2;
            break;
          }
        }
      }
      return mainSubplotID || nextBestMainSubplotID;
    }
    plots.clearExpandedTraceDefaultColors = function(trace) {
      var colorAttrs, path, i;
      function locateColorAttrs(attr, attrName, attrs, level) {
        path[level] = attrName;
        path.length = level + 1;
        if (attr.valType === "color" && attr.dflt === void 0) {
          colorAttrs.push(path.join("."));
        }
      }
      path = [];
      colorAttrs = trace._module._colorAttrs;
      if (!colorAttrs) {
        trace._module._colorAttrs = colorAttrs = [];
        PlotSchema.crawl(
          trace._module.attributes,
          locateColorAttrs
        );
      }
      for (i = 0; i < colorAttrs.length; i++) {
        var origprop = Lib.nestedProperty(trace, "_input." + colorAttrs[i]);
        if (!origprop.get()) {
          Lib.nestedProperty(trace, colorAttrs[i]).set(null);
        }
      }
    };
    plots.supplyDataDefaults = function(dataIn, dataOut, layout, fullLayout) {
      var modules = fullLayout._modules;
      var visibleModules = fullLayout._visibleModules;
      var basePlotModules = fullLayout._basePlotModules;
      var cnt = 0;
      var colorCnt = 0;
      var i, fullTrace, trace;
      fullLayout._transformModules = [];
      function pushModule(fullTrace2) {
        dataOut.push(fullTrace2);
        var _module = fullTrace2._module;
        if (!_module) return;
        Lib.pushUnique(modules, _module);
        if (fullTrace2.visible === true) Lib.pushUnique(visibleModules, _module);
        Lib.pushUnique(basePlotModules, fullTrace2._module.basePlotModule);
        cnt++;
        if (fullTrace2._input.visible !== false) colorCnt++;
      }
      var carpetIndex = {};
      var carpetDependents = [];
      var dataTemplate = (layout.template || {}).data || {};
      var templater = Template.traceTemplater(dataTemplate);
      for (i = 0; i < dataIn.length; i++) {
        trace = dataIn[i];
        fullTrace = templater.newTrace(trace);
        fullTrace.uid = fullLayout._traceUids[i];
        plots.supplyTraceDefaults(trace, fullTrace, colorCnt, fullLayout, i);
        fullTrace.index = i;
        fullTrace._input = trace;
        fullTrace._expandedIndex = cnt;
        if (fullTrace.transforms && fullTrace.transforms.length) {
          var sdInvisible = trace.visible !== false && fullTrace.visible === false;
          var expandedTraces = applyTransforms(fullTrace, dataOut, layout, fullLayout);
          for (var j = 0; j < expandedTraces.length; j++) {
            var expandedTrace = expandedTraces[j];
            var fullExpandedTrace = {
              _template: fullTrace._template,
              type: fullTrace.type,
              // set uid using parent uid and expanded index
              // to promote consistency between update calls
              uid: fullTrace.uid + j
            };
            if (sdInvisible && expandedTrace.visible === false) {
              delete expandedTrace.visible;
            }
            plots.supplyTraceDefaults(expandedTrace, fullExpandedTrace, cnt, fullLayout, i);
            relinkPrivateKeys(fullExpandedTrace, expandedTrace);
            fullExpandedTrace.index = i;
            fullExpandedTrace._input = trace;
            fullExpandedTrace._fullInput = fullTrace;
            fullExpandedTrace._expandedIndex = cnt;
            fullExpandedTrace._expandedInput = expandedTrace;
            pushModule(fullExpandedTrace);
          }
        } else {
          fullTrace._fullInput = fullTrace;
          fullTrace._expandedInput = fullTrace;
          pushModule(fullTrace);
        }
        if (Registry.traceIs(fullTrace, "carpetAxis")) {
          carpetIndex[fullTrace.carpet] = fullTrace;
        }
        if (Registry.traceIs(fullTrace, "carpetDependent")) {
          carpetDependents.push(i);
        }
      }
      for (i = 0; i < carpetDependents.length; i++) {
        fullTrace = dataOut[carpetDependents[i]];
        if (!fullTrace.visible) continue;
        var carpetAxis = carpetIndex[fullTrace.carpet];
        fullTrace._carpet = carpetAxis;
        if (!carpetAxis || !carpetAxis.visible) {
          fullTrace.visible = false;
          continue;
        }
        fullTrace.xaxis = carpetAxis.xaxis;
        fullTrace.yaxis = carpetAxis.yaxis;
      }
    };
    plots.supplyAnimationDefaults = function(opts) {
      opts = opts || {};
      var i;
      var optsOut = {};
      function coerce(attr, dflt) {
        return Lib.coerce(opts || {}, optsOut, animationAttrs, attr, dflt);
      }
      coerce("mode");
      coerce("direction");
      coerce("fromcurrent");
      if (Array.isArray(opts.frame)) {
        optsOut.frame = [];
        for (i = 0; i < opts.frame.length; i++) {
          optsOut.frame[i] = plots.supplyAnimationFrameDefaults(opts.frame[i] || {});
        }
      } else {
        optsOut.frame = plots.supplyAnimationFrameDefaults(opts.frame || {});
      }
      if (Array.isArray(opts.transition)) {
        optsOut.transition = [];
        for (i = 0; i < opts.transition.length; i++) {
          optsOut.transition[i] = plots.supplyAnimationTransitionDefaults(opts.transition[i] || {});
        }
      } else {
        optsOut.transition = plots.supplyAnimationTransitionDefaults(opts.transition || {});
      }
      return optsOut;
    };
    plots.supplyAnimationFrameDefaults = function(opts) {
      var optsOut = {};
      function coerce(attr, dflt) {
        return Lib.coerce(opts || {}, optsOut, animationAttrs.frame, attr, dflt);
      }
      coerce("duration");
      coerce("redraw");
      return optsOut;
    };
    plots.supplyAnimationTransitionDefaults = function(opts) {
      var optsOut = {};
      function coerce(attr, dflt) {
        return Lib.coerce(opts || {}, optsOut, animationAttrs.transition, attr, dflt);
      }
      coerce("duration");
      coerce("easing");
      return optsOut;
    };
    plots.supplyFrameDefaults = function(frameIn) {
      var frameOut = {};
      function coerce(attr, dflt) {
        return Lib.coerce(frameIn, frameOut, frameAttrs, attr, dflt);
      }
      coerce("group");
      coerce("name");
      coerce("traces");
      coerce("baseframe");
      coerce("data");
      coerce("layout");
      return frameOut;
    };
    plots.supplyTraceDefaults = function(traceIn, traceOut, colorIndex, layout, traceInIndex) {
      var colorway = layout.colorway || Color.defaults;
      var defaultColor = colorway[colorIndex % colorway.length];
      var i;
      function coerce(attr, dflt) {
        return Lib.coerce(traceIn, traceOut, plots.attributes, attr, dflt);
      }
      var visible = coerce("visible");
      coerce("type");
      coerce("name", layout._traceWord + " " + traceInIndex);
      coerce("uirevision", layout.uirevision);
      var _module = plots.getModule(traceOut);
      traceOut._module = _module;
      if (_module) {
        var basePlotModule = _module.basePlotModule;
        var subplotAttr = basePlotModule.attr;
        var subplotAttrs = basePlotModule.attributes;
        if (subplotAttr && subplotAttrs) {
          var subplots = layout._subplots;
          var subplotId = "";
          if (visible || basePlotModule.name !== "gl2d") {
            if (Array.isArray(subplotAttr)) {
              for (i = 0; i < subplotAttr.length; i++) {
                var attri = subplotAttr[i];
                var vali = Lib.coerce(traceIn, traceOut, subplotAttrs, attri);
                if (subplots[attri]) Lib.pushUnique(subplots[attri], vali);
                subplotId += vali;
              }
            } else {
              subplotId = Lib.coerce(traceIn, traceOut, subplotAttrs, subplotAttr);
            }
            if (subplots[basePlotModule.name]) {
              Lib.pushUnique(subplots[basePlotModule.name], subplotId);
            }
          }
        }
      }
      if (visible) {
        coerce("customdata");
        coerce("ids");
        coerce("meta");
        if (Registry.traceIs(traceOut, "showLegend")) {
          Lib.coerce(
            traceIn,
            traceOut,
            _module.attributes.showlegend ? _module.attributes : plots.attributes,
            "showlegend"
          );
          coerce("legend");
          coerce("legendwidth");
          coerce("legendgroup");
          coerce("legendgrouptitle.text");
          coerce("legendrank");
          traceOut._dfltShowLegend = true;
        } else {
          traceOut._dfltShowLegend = false;
        }
        if (_module) {
          _module.supplyDefaults(traceIn, traceOut, defaultColor, layout);
        }
        if (!Registry.traceIs(traceOut, "noOpacity")) {
          coerce("opacity");
        }
        if (Registry.traceIs(traceOut, "notLegendIsolatable")) {
          traceOut.visible = !!traceOut.visible;
        }
        if (!Registry.traceIs(traceOut, "noHover")) {
          if (!traceOut.hovertemplate) Lib.coerceHoverinfo(traceIn, traceOut, layout);
          if (traceOut.type !== "parcats") {
            Registry.getComponentMethod("fx", "supplyDefaults")(traceIn, traceOut, defaultColor, layout);
          }
        }
        if (_module && _module.selectPoints) {
          var selectedpoints = coerce("selectedpoints");
          if (Lib.isTypedArray(selectedpoints)) {
            traceOut.selectedpoints = Array.from(selectedpoints);
          }
        }
        plots.supplyTransformDefaults(traceIn, traceOut, layout);
      }
      return traceOut;
    };
    function hasMakesDataTransform(trace) {
      var transforms = trace.transforms;
      if (Array.isArray(transforms) && transforms.length) {
        for (var i = 0; i < transforms.length; i++) {
          var ti2 = transforms[i];
          var _module = ti2._module || transformsRegistry[ti2.type];
          if (_module && _module.makesData) return true;
        }
      }
      return false;
    }
    plots.hasMakesDataTransform = hasMakesDataTransform;
    plots.supplyTransformDefaults = function(traceIn, traceOut, layout) {
      if (!(traceOut._length || hasMakesDataTransform(traceIn))) return;
      var globalTransforms = layout._globalTransforms || [];
      var transformModules = layout._transformModules || [];
      if (!Array.isArray(traceIn.transforms) && globalTransforms.length === 0) return;
      var containerIn = traceIn.transforms || [];
      var transformList = globalTransforms.concat(containerIn);
      var containerOut = traceOut.transforms = [];
      for (var i = 0; i < transformList.length; i++) {
        var transformIn = transformList[i];
        var type = transformIn.type;
        var _module = transformsRegistry[type];
        var transformOut;
        var isFirstStage = !(transformIn._module && transformIn._module === _module);
        var doLaterStages = _module && typeof _module.transform === "function";
        if (!_module) Lib.warn("Unrecognized transform type " + type + ".");
        if (_module && _module.supplyDefaults && (isFirstStage || doLaterStages)) {
          transformOut = _module.supplyDefaults(transformIn, traceOut, layout, traceIn);
          transformOut.type = type;
          transformOut._module = _module;
          Lib.pushUnique(transformModules, _module);
        } else {
          transformOut = Lib.extendFlat({}, transformIn);
        }
        containerOut.push(transformOut);
      }
    };
    function applyTransforms(fullTrace, fullData, layout, fullLayout) {
      var container = fullTrace.transforms;
      var dataOut = [fullTrace];
      for (var i = 0; i < container.length; i++) {
        var transform = container[i];
        var _module = transformsRegistry[transform.type];
        if (_module && _module.transform) {
          dataOut = _module.transform(dataOut, {
            transform,
            fullTrace,
            fullData,
            layout,
            fullLayout,
            transformIndex: i
          });
        }
      }
      return dataOut;
    }
    plots.supplyLayoutGlobalDefaults = function(layoutIn, layoutOut, formatObj) {
      function coerce(attr, dflt) {
        return Lib.coerce(layoutIn, layoutOut, plots.layoutAttributes, attr, dflt);
      }
      var template = layoutIn.template;
      if (Lib.isPlainObject(template)) {
        layoutOut.template = template;
        layoutOut._template = template.layout;
        layoutOut._dataTemplate = template.data;
      }
      coerce("autotypenumbers");
      var font = Lib.coerceFont(coerce, "font");
      var fontSize = font.size;
      Lib.coerceFont(coerce, "title.font", font, { overrideDflt: {
        size: Math.round(fontSize * 1.4)
      } });
      coerce("title.text", layoutOut._dfltTitle.plot);
      coerce("title.xref");
      var titleYref = coerce("title.yref");
      coerce("title.pad.t");
      coerce("title.pad.r");
      coerce("title.pad.b");
      coerce("title.pad.l");
      var titleAutomargin = coerce("title.automargin");
      coerce("title.x");
      coerce("title.xanchor");
      coerce("title.y");
      coerce("title.yanchor");
      coerce("title.subtitle.text", layoutOut._dfltTitle.subtitle);
      Lib.coerceFont(coerce, "title.subtitle.font", font, {
        overrideDflt: {
          size: Math.round(layoutOut.title.font.size * 0.7)
        }
      });
      if (titleAutomargin) {
        if (titleYref === "paper") {
          if (layoutOut.title.y !== 0) layoutOut.title.y = 1;
          if (layoutOut.title.yanchor === "auto") {
            layoutOut.title.yanchor = layoutOut.title.y === 0 ? "top" : "bottom";
          }
        }
        if (titleYref === "container") {
          if (layoutOut.title.y === "auto") layoutOut.title.y = 1;
          if (layoutOut.title.yanchor === "auto") {
            layoutOut.title.yanchor = layoutOut.title.y < 0.5 ? "bottom" : "top";
          }
        }
      }
      var uniformtextMode = coerce("uniformtext.mode");
      if (uniformtextMode) {
        coerce("uniformtext.minsize");
      }
      coerce("autosize", !(layoutIn.width && layoutIn.height));
      coerce("width");
      coerce("height");
      coerce("minreducedwidth");
      coerce("minreducedheight");
      coerce("margin.l");
      coerce("margin.r");
      coerce("margin.t");
      coerce("margin.b");
      coerce("margin.pad");
      coerce("margin.autoexpand");
      if (layoutIn.width && layoutIn.height) plots.sanitizeMargins(layoutOut);
      Registry.getComponentMethod("grid", "sizeDefaults")(layoutIn, layoutOut);
      coerce("paper_bgcolor");
      coerce("separators", formatObj.decimal + formatObj.thousands);
      coerce("hidesources");
      coerce("colorway");
      coerce("datarevision");
      var uirevision = coerce("uirevision");
      coerce("editrevision", uirevision);
      coerce("selectionrevision", uirevision);
      Registry.getComponentMethod(
        "modebar",
        "supplyLayoutDefaults"
      )(layoutIn, layoutOut);
      Registry.getComponentMethod(
        "shapes",
        "supplyDrawNewShapeDefaults"
      )(layoutIn, layoutOut, coerce);
      Registry.getComponentMethod(
        "selections",
        "supplyDrawNewSelectionDefaults"
      )(layoutIn, layoutOut, coerce);
      coerce("meta");
      if (Lib.isPlainObject(layoutIn.transition)) {
        coerce("transition.duration");
        coerce("transition.easing");
        coerce("transition.ordering");
      }
      Registry.getComponentMethod(
        "calendars",
        "handleDefaults"
      )(layoutIn, layoutOut, "calendar");
      Registry.getComponentMethod(
        "fx",
        "supplyLayoutGlobalDefaults"
      )(layoutIn, layoutOut, coerce);
      Lib.coerce(layoutIn, layoutOut, scatterAttrs, "scattermode");
    };
    function getComputedSize(attr) {
      return typeof attr === "string" && attr.substr(attr.length - 2) === "px" && parseFloat(attr);
    }
    plots.plotAutoSize = function plotAutoSize(gd2, layout, fullLayout) {
      var context = gd2._context || {};
      var frameMargins = context.frameMargins;
      var newWidth;
      var newHeight;
      var isPlotDiv = Lib.isPlotDiv(gd2);
      if (isPlotDiv) gd2.emit("plotly_autosize");
      if (context.fillFrame) {
        newWidth = window.innerWidth;
        newHeight = window.innerHeight;
        document.body.style.overflow = "hidden";
      } else {
        var computedStyle = isPlotDiv ? window.getComputedStyle(gd2) : {};
        newWidth = getComputedSize(computedStyle.width) || getComputedSize(computedStyle.maxWidth) || fullLayout.width;
        newHeight = getComputedSize(computedStyle.height) || getComputedSize(computedStyle.maxHeight) || fullLayout.height;
        if (isNumeric(frameMargins) && frameMargins > 0) {
          var factor = 1 - 2 * frameMargins;
          newWidth = Math.round(factor * newWidth);
          newHeight = Math.round(factor * newHeight);
        }
      }
      var minWidth = plots.layoutAttributes.width.min;
      var minHeight = plots.layoutAttributes.height.min;
      if (newWidth < minWidth) newWidth = minWidth;
      if (newHeight < minHeight) newHeight = minHeight;
      var widthHasChanged = !layout.width && Math.abs(fullLayout.width - newWidth) > 1;
      var heightHasChanged = !layout.height && Math.abs(fullLayout.height - newHeight) > 1;
      if (heightHasChanged || widthHasChanged) {
        if (widthHasChanged) fullLayout.width = newWidth;
        if (heightHasChanged) fullLayout.height = newHeight;
      }
      if (!gd2._initialAutoSize) {
        gd2._initialAutoSize = { width: newWidth, height: newHeight };
      }
      plots.sanitizeMargins(fullLayout);
    };
    plots.supplyLayoutModuleDefaults = function(layoutIn, layoutOut, fullData, transitionData) {
      var componentsRegistry = Registry.componentsRegistry;
      var basePlotModules = layoutOut._basePlotModules;
      var component, i, _module;
      var Cartesian = Registry.subplotsRegistry.cartesian;
      for (component in componentsRegistry) {
        _module = componentsRegistry[component];
        if (_module.includeBasePlot) {
          _module.includeBasePlot(layoutIn, layoutOut);
        }
      }
      if (!basePlotModules.length) {
        basePlotModules.push(Cartesian);
      }
      if (layoutOut._has("cartesian")) {
        Registry.getComponentMethod("grid", "contentDefaults")(layoutIn, layoutOut);
        Cartesian.finalizeSubplots(layoutIn, layoutOut);
      }
      for (var subplotType in layoutOut._subplots) {
        layoutOut._subplots[subplotType].sort(Lib.subplotSort);
      }
      for (i = 0; i < basePlotModules.length; i++) {
        _module = basePlotModules[i];
        if (_module.supplyLayoutDefaults) {
          _module.supplyLayoutDefaults(layoutIn, layoutOut, fullData);
        }
      }
      var modules = layoutOut._modules;
      for (i = 0; i < modules.length; i++) {
        _module = modules[i];
        if (_module.supplyLayoutDefaults) {
          _module.supplyLayoutDefaults(layoutIn, layoutOut, fullData);
        }
      }
      var transformModules = layoutOut._transformModules;
      for (i = 0; i < transformModules.length; i++) {
        _module = transformModules[i];
        if (_module.supplyLayoutDefaults) {
          _module.supplyLayoutDefaults(layoutIn, layoutOut, fullData, transitionData);
        }
      }
      for (component in componentsRegistry) {
        _module = componentsRegistry[component];
        if (_module.supplyLayoutDefaults) {
          _module.supplyLayoutDefaults(layoutIn, layoutOut, fullData);
        }
      }
    };
    plots.purge = function(gd2) {
      var fullLayout = gd2._fullLayout || {};
      if (fullLayout._glcontainer !== void 0) {
        fullLayout._glcontainer.selectAll(".gl-canvas").remove();
        fullLayout._glcontainer.remove();
        fullLayout._glcanvas = null;
      }
      if (fullLayout._modeBar) fullLayout._modeBar.destroy();
      if (gd2._transitionData) {
        if (gd2._transitionData._interruptCallbacks) {
          gd2._transitionData._interruptCallbacks.length = 0;
        }
        if (gd2._transitionData._animationRaf) {
          window.cancelAnimationFrame(gd2._transitionData._animationRaf);
        }
      }
      Lib.clearThrottle();
      Lib.clearResponsive(gd2);
      delete gd2.data;
      delete gd2.layout;
      delete gd2._fullData;
      delete gd2._fullLayout;
      delete gd2.calcdata;
      delete gd2.empty;
      delete gd2.fid;
      delete gd2.undoqueue;
      delete gd2.undonum;
      delete gd2.autoplay;
      delete gd2.changed;
      delete gd2._promises;
      delete gd2._redrawTimer;
      delete gd2._hmlumcount;
      delete gd2._hmpixcount;
      delete gd2._transitionData;
      delete gd2._transitioning;
      delete gd2._initialAutoSize;
      delete gd2._transitioningWithDuration;
      delete gd2._dragging;
      delete gd2._dragged;
      delete gd2._dragdata;
      delete gd2._hoverdata;
      delete gd2._snapshotInProgress;
      delete gd2._editing;
      delete gd2._mouseDownTime;
      delete gd2._legendMouseDownTime;
      if (gd2.removeAllListeners) gd2.removeAllListeners();
    };
    plots.style = function(gd2) {
      var _modules = gd2._fullLayout._visibleModules;
      var styleModules = [];
      var i;
      for (i = 0; i < _modules.length; i++) {
        var _module = _modules[i];
        if (_module.style) {
          Lib.pushUnique(styleModules, _module.style);
        }
      }
      for (i = 0; i < styleModules.length; i++) {
        styleModules[i](gd2);
      }
    };
    plots.sanitizeMargins = function(fullLayout) {
      if (!fullLayout || !fullLayout.margin) return;
      var width = fullLayout.width;
      var height = fullLayout.height;
      var margin = fullLayout.margin;
      var plotWidth = width - (margin.l + margin.r);
      var plotHeight = height - (margin.t + margin.b);
      var correction;
      if (plotWidth < 0) {
        correction = (width - 1) / (margin.l + margin.r);
        margin.l = Math.floor(correction * margin.l);
        margin.r = Math.floor(correction * margin.r);
      }
      if (plotHeight < 0) {
        correction = (height - 1) / (margin.t + margin.b);
        margin.t = Math.floor(correction * margin.t);
        margin.b = Math.floor(correction * margin.b);
      }
    };
    plots.clearAutoMarginIds = function(gd2) {
      gd2._fullLayout._pushmarginIds = {};
    };
    plots.allowAutoMargin = function(gd2, id2) {
      gd2._fullLayout._pushmarginIds[id2] = 1;
    };
    function initMargins(fullLayout) {
      var margin = fullLayout.margin;
      if (!fullLayout._size) {
        var gs2 = fullLayout._size = {
          l: Math.round(margin.l),
          r: Math.round(margin.r),
          t: Math.round(margin.t),
          b: Math.round(margin.b),
          p: Math.round(margin.pad)
        };
        gs2.w = Math.round(fullLayout.width) - gs2.l - gs2.r;
        gs2.h = Math.round(fullLayout.height) - gs2.t - gs2.b;
      }
      if (!fullLayout._pushmargin) fullLayout._pushmargin = {};
      if (!fullLayout._pushmarginIds) fullLayout._pushmarginIds = {};
      if (!fullLayout._reservedMargin) fullLayout._reservedMargin = {};
    }
    var MIN_SPECIFIED_WIDTH = 2;
    var MIN_SPECIFIED_HEIGHT = 2;
    plots.autoMargin = function(gd2, id2, o) {
      var fullLayout = gd2._fullLayout;
      var width = fullLayout.width;
      var height = fullLayout.height;
      var margin = fullLayout.margin;
      var minreducedwidth = fullLayout.minreducedwidth;
      var minreducedheight = fullLayout.minreducedheight;
      var minFinalWidth = Lib.constrain(
        width - margin.l - margin.r,
        MIN_SPECIFIED_WIDTH,
        minreducedwidth
      );
      var minFinalHeight = Lib.constrain(
        height - margin.t - margin.b,
        MIN_SPECIFIED_HEIGHT,
        minreducedheight
      );
      var maxSpaceW = Math.max(0, width - minFinalWidth);
      var maxSpaceH = Math.max(0, height - minFinalHeight);
      var pushMargin = fullLayout._pushmargin;
      var pushMarginIds = fullLayout._pushmarginIds;
      if (margin.autoexpand !== false) {
        if (!o) {
          delete pushMargin[id2];
          delete pushMarginIds[id2];
        } else {
          var pad2 = o.pad;
          if (pad2 === void 0) {
            pad2 = Math.min(12, margin.l, margin.r, margin.t, margin.b);
          }
          if (maxSpaceW) {
            var rW = (o.l + o.r) / maxSpaceW;
            if (rW > 1) {
              o.l /= rW;
              o.r /= rW;
            }
          }
          if (maxSpaceH) {
            var rH = (o.t + o.b) / maxSpaceH;
            if (rH > 1) {
              o.t /= rH;
              o.b /= rH;
            }
          }
          var xl = o.xl !== void 0 ? o.xl : o.x;
          var xr2 = o.xr !== void 0 ? o.xr : o.x;
          var yt2 = o.yt !== void 0 ? o.yt : o.y;
          var yb = o.yb !== void 0 ? o.yb : o.y;
          pushMargin[id2] = {
            l: { val: xl, size: o.l + pad2 },
            r: { val: xr2, size: o.r + pad2 },
            b: { val: yb, size: o.b + pad2 },
            t: { val: yt2, size: o.t + pad2 }
          };
          pushMarginIds[id2] = 1;
        }
        if (!fullLayout._replotting) {
          return plots.doAutoMargin(gd2);
        }
      }
    };
    function needsRedrawForShift(gd2) {
      if ("_redrawFromAutoMarginCount" in gd2._fullLayout) {
        return false;
      }
      var axList = axisIDs.list(gd2, "", true);
      for (var ax in axList) {
        if (axList[ax].autoshift || axList[ax].shift) return true;
      }
      return false;
    }
    plots.doAutoMargin = function(gd2) {
      var fullLayout = gd2._fullLayout;
      var width = fullLayout.width;
      var height = fullLayout.height;
      if (!fullLayout._size) fullLayout._size = {};
      initMargins(fullLayout);
      var gs2 = fullLayout._size;
      var margin = fullLayout.margin;
      var reservedMargins = { t: 0, b: 0, l: 0, r: 0 };
      var oldMargins = Lib.extendFlat({}, gs2);
      var ml = margin.l;
      var mr2 = margin.r;
      var mt2 = margin.t;
      var mb = margin.b;
      var pushMargin = fullLayout._pushmargin;
      var pushMarginIds = fullLayout._pushmarginIds;
      var minreducedwidth = fullLayout.minreducedwidth;
      var minreducedheight = fullLayout.minreducedheight;
      if (margin.autoexpand !== false) {
        for (var k in pushMargin) {
          if (!pushMarginIds[k]) delete pushMargin[k];
        }
        var margins = gd2._fullLayout._reservedMargin;
        for (var key in margins) {
          for (var side in margins[key]) {
            var val = margins[key][side];
            reservedMargins[side] = Math.max(reservedMargins[side], val);
          }
        }
        pushMargin.base = {
          l: { val: 0, size: ml },
          r: { val: 1, size: mr2 },
          t: { val: 1, size: mt2 },
          b: { val: 0, size: mb }
        };
        for (var s in reservedMargins) {
          var autoMarginPush = 0;
          for (var m in pushMargin) {
            if (m !== "base") {
              if (isNumeric(pushMargin[m][s].size)) {
                autoMarginPush = pushMargin[m][s].size > autoMarginPush ? pushMargin[m][s].size : autoMarginPush;
              }
            }
          }
          var extraMargin = Math.max(0, margin[s] - autoMarginPush);
          reservedMargins[s] = Math.max(0, reservedMargins[s] - extraMargin);
        }
        for (var k1 in pushMargin) {
          var pushleft = pushMargin[k1].l || {};
          var pushbottom = pushMargin[k1].b || {};
          var fl = pushleft.val;
          var pl = pushleft.size;
          var fb = pushbottom.val;
          var pb = pushbottom.size;
          var availableWidth = width - reservedMargins.r - reservedMargins.l;
          var availableHeight = height - reservedMargins.t - reservedMargins.b;
          for (var k2 in pushMargin) {
            if (isNumeric(pl) && pushMargin[k2].r) {
              var fr2 = pushMargin[k2].r.val;
              var pr2 = pushMargin[k2].r.size;
              if (fr2 > fl) {
                var newL = (pl * fr2 + (pr2 - availableWidth) * fl) / (fr2 - fl);
                var newR = (pr2 * (1 - fl) + (pl - availableWidth) * (1 - fr2)) / (fr2 - fl);
                if (newL + newR > ml + mr2) {
                  ml = newL;
                  mr2 = newR;
                }
              }
            }
            if (isNumeric(pb) && pushMargin[k2].t) {
              var ft2 = pushMargin[k2].t.val;
              var pt2 = pushMargin[k2].t.size;
              if (ft2 > fb) {
                var newB = (pb * ft2 + (pt2 - availableHeight) * fb) / (ft2 - fb);
                var newT = (pt2 * (1 - fb) + (pb - availableHeight) * (1 - ft2)) / (ft2 - fb);
                if (newB + newT > mb + mt2) {
                  mb = newB;
                  mt2 = newT;
                }
              }
            }
          }
        }
      }
      var minFinalWidth = Lib.constrain(
        width - margin.l - margin.r,
        MIN_SPECIFIED_WIDTH,
        minreducedwidth
      );
      var minFinalHeight = Lib.constrain(
        height - margin.t - margin.b,
        MIN_SPECIFIED_HEIGHT,
        minreducedheight
      );
      var maxSpaceW = Math.max(0, width - minFinalWidth);
      var maxSpaceH = Math.max(0, height - minFinalHeight);
      if (maxSpaceW) {
        var rW = (ml + mr2) / maxSpaceW;
        if (rW > 1) {
          ml /= rW;
          mr2 /= rW;
        }
      }
      if (maxSpaceH) {
        var rH = (mb + mt2) / maxSpaceH;
        if (rH > 1) {
          mb /= rH;
          mt2 /= rH;
        }
      }
      gs2.l = Math.round(ml) + reservedMargins.l;
      gs2.r = Math.round(mr2) + reservedMargins.r;
      gs2.t = Math.round(mt2) + reservedMargins.t;
      gs2.b = Math.round(mb) + reservedMargins.b;
      gs2.p = Math.round(margin.pad);
      gs2.w = Math.round(width) - gs2.l - gs2.r;
      gs2.h = Math.round(height) - gs2.t - gs2.b;
      if (!fullLayout._replotting && (plots.didMarginChange(oldMargins, gs2) || needsRedrawForShift(gd2))) {
        if ("_redrawFromAutoMarginCount" in fullLayout) {
          fullLayout._redrawFromAutoMarginCount++;
        } else {
          fullLayout._redrawFromAutoMarginCount = 1;
        }
        var maxNumberOfRedraws = 3 * (1 + Object.keys(pushMarginIds).length);
        if (fullLayout._redrawFromAutoMarginCount < maxNumberOfRedraws) {
          return Registry.call("_doPlot", gd2);
        } else {
          fullLayout._size = oldMargins;
          Lib.warn("Too many auto-margin redraws.");
        }
      }
      refineTicks(gd2);
    };
    function refineTicks(gd2) {
      var axList = axisIDs.list(gd2, "", true);
      [
        "_adjustTickLabelsOverflow",
        "_hideCounterAxisInsideTickLabels"
      ].forEach(function(k) {
        for (var i = 0; i < axList.length; i++) {
          var hideFn = axList[i][k];
          if (hideFn) hideFn();
        }
      });
    }
    var marginKeys = ["l", "r", "t", "b", "p", "w", "h"];
    plots.didMarginChange = function(margin0, margin1) {
      for (var i = 0; i < marginKeys.length; i++) {
        var k = marginKeys[i];
        var m02 = margin0[k];
        var m12 = margin1[k];
        if (!isNumeric(m02) || Math.abs(m12 - m02) > 1) {
          return true;
        }
      }
      return false;
    };
    plots.graphJson = function(gd2, dataonly, mode, output, useDefaults, includeConfig) {
      if (useDefaults && dataonly && !gd2._fullData || useDefaults && !dataonly && !gd2._fullLayout) {
        plots.supplyDefaults(gd2);
      }
      var data = useDefaults ? gd2._fullData : gd2.data;
      var layout = useDefaults ? gd2._fullLayout : gd2.layout;
      var frames = (gd2._transitionData || {})._frames;
      function stripObj(d, keepFunction) {
        if (typeof d === "function") {
          return keepFunction ? "_function_" : null;
        }
        if (Lib.isPlainObject(d)) {
          var o = {};
          var src;
          Object.keys(d).sort().forEach(function(v) {
            if (["_", "["].indexOf(v.charAt(0)) !== -1) return;
            if (typeof d[v] === "function") {
              if (keepFunction) o[v] = "_function";
              return;
            }
            if (mode === "keepdata") {
              if (v.substr(v.length - 3) === "src") {
                return;
              }
            } else if (mode === "keepstream") {
              src = d[v + "src"];
              if (typeof src === "string" && src.indexOf(":") > 0) {
                if (!Lib.isPlainObject(d.stream)) {
                  return;
                }
              }
            } else if (mode !== "keepall") {
              src = d[v + "src"];
              if (typeof src === "string" && src.indexOf(":") > 0) {
                return;
              }
            }
            o[v] = stripObj(d[v], keepFunction);
          });
          return o;
        }
        var dIsArray = Array.isArray(d);
        var dIsTypedArray = Lib.isTypedArray(d);
        if ((dIsArray || dIsTypedArray) && d.dtype && d.shape) {
          var bdata = d.bdata;
          return stripObj({
            dtype: d.dtype,
            shape: d.shape,
            bdata: (
              // case of ArrayBuffer
              Lib.isArrayBuffer(bdata) ? b64encode.encode(bdata) : (
                // case of b64 string
                bdata
              )
            )
          }, keepFunction);
        }
        if (dIsArray) {
          return d.map(function(x) {
            return stripObj(x, keepFunction);
          });
        }
        if (dIsTypedArray) {
          return Lib.simpleMap(d, Lib.identity);
        }
        if (Lib.isJSDate(d)) return Lib.ms2DateTimeLocal(+d);
        return d;
      }
      var obj = {
        data: (data || []).map(function(v) {
          var d = stripObj(v);
          if (dataonly) {
            delete d.fit;
          }
          return d;
        })
      };
      if (!dataonly) {
        obj.layout = stripObj(layout);
        if (useDefaults) {
          var gs2 = layout._size;
          obj.layout.computed = {
            margin: {
              b: gs2.b,
              l: gs2.l,
              r: gs2.r,
              t: gs2.t
            }
          };
        }
      }
      if (frames) obj.frames = stripObj(frames);
      if (includeConfig) obj.config = stripObj(gd2._context, true);
      return output === "object" ? obj : JSON.stringify(obj);
    };
    plots.modifyFrames = function(gd2, operations) {
      var i, op2, frame;
      var _frames = gd2._transitionData._frames;
      var _frameHash = gd2._transitionData._frameHash;
      for (i = 0; i < operations.length; i++) {
        op2 = operations[i];
        switch (op2.type) {
          case "replace":
            frame = op2.value;
            var oldName = (_frames[op2.index] || {}).name;
            var newName = frame.name;
            _frames[op2.index] = _frameHash[newName] = frame;
            if (newName !== oldName) {
              delete _frameHash[oldName];
              _frameHash[newName] = frame;
            }
            break;
          case "insert":
            frame = op2.value;
            _frameHash[frame.name] = frame;
            _frames.splice(op2.index, 0, frame);
            break;
          case "delete":
            frame = _frames[op2.index];
            delete _frameHash[frame.name];
            _frames.splice(op2.index, 1);
            break;
        }
      }
      return Promise.resolve();
    };
    plots.computeFrame = function(gd2, frameName) {
      var frameLookup = gd2._transitionData._frameHash;
      var i, traceIndices, traceIndex, destIndex;
      if (!frameName) {
        throw new Error("computeFrame must be given a string frame name");
      }
      var framePtr = frameLookup[frameName.toString()];
      if (!framePtr) {
        return false;
      }
      var frameStack = [framePtr];
      var frameNameStack = [framePtr.name];
      while (framePtr.baseframe && (framePtr = frameLookup[framePtr.baseframe.toString()])) {
        if (frameNameStack.indexOf(framePtr.name) !== -1) break;
        frameStack.push(framePtr);
        frameNameStack.push(framePtr.name);
      }
      var result = {};
      while (framePtr = frameStack.pop()) {
        if (framePtr.layout) {
          result.layout = plots.extendLayout(result.layout, framePtr.layout);
        }
        if (framePtr.data) {
          if (!result.data) {
            result.data = [];
          }
          traceIndices = framePtr.traces;
          if (!traceIndices) {
            traceIndices = [];
            for (i = 0; i < framePtr.data.length; i++) {
              traceIndices[i] = i;
            }
          }
          if (!result.traces) {
            result.traces = [];
          }
          for (i = 0; i < framePtr.data.length; i++) {
            traceIndex = traceIndices[i];
            if (traceIndex === void 0 || traceIndex === null) {
              continue;
            }
            destIndex = result.traces.indexOf(traceIndex);
            if (destIndex === -1) {
              destIndex = result.data.length;
              result.traces[destIndex] = traceIndex;
            }
            result.data[destIndex] = plots.extendTrace(result.data[destIndex], framePtr.data[i]);
          }
        }
      }
      return result;
    };
    plots.recomputeFrameHash = function(gd2) {
      var hash = gd2._transitionData._frameHash = {};
      var frames = gd2._transitionData._frames;
      for (var i = 0; i < frames.length; i++) {
        var frame = frames[i];
        if (frame && frame.name) {
          hash[frame.name] = frame;
        }
      }
    };
    plots.extendObjectWithContainers = function(dest, src, containerPaths) {
      var containerProp, containerVal, i, j, srcProp, destProp, srcContainer, destContainer;
      var copy = Lib.extendDeepNoArrays({}, src || {});
      var expandedObj = Lib.expandObjectPaths(copy);
      var containerObj = {};
      if (containerPaths && containerPaths.length) {
        for (i = 0; i < containerPaths.length; i++) {
          containerProp = Lib.nestedProperty(expandedObj, containerPaths[i]);
          containerVal = containerProp.get();
          if (containerVal === void 0) {
            Lib.nestedProperty(containerObj, containerPaths[i]).set(null);
          } else {
            containerProp.set(null);
            Lib.nestedProperty(containerObj, containerPaths[i]).set(containerVal);
          }
        }
      }
      dest = Lib.extendDeepNoArrays(dest || {}, expandedObj);
      if (containerPaths && containerPaths.length) {
        for (i = 0; i < containerPaths.length; i++) {
          srcProp = Lib.nestedProperty(containerObj, containerPaths[i]);
          srcContainer = srcProp.get();
          if (!srcContainer) continue;
          destProp = Lib.nestedProperty(dest, containerPaths[i]);
          destContainer = destProp.get();
          if (!Array.isArray(destContainer)) {
            destContainer = [];
            destProp.set(destContainer);
          }
          for (j = 0; j < srcContainer.length; j++) {
            var srcObj = srcContainer[j];
            if (srcObj === null) destContainer[j] = null;
            else {
              destContainer[j] = plots.extendObjectWithContainers(destContainer[j], srcObj);
            }
          }
          destProp.set(destContainer);
        }
      }
      return dest;
    };
    plots.dataArrayContainers = ["transforms", "dimensions"];
    plots.layoutArrayContainers = Registry.layoutArrayContainers;
    plots.extendTrace = function(destTrace, srcTrace) {
      return plots.extendObjectWithContainers(destTrace, srcTrace, plots.dataArrayContainers);
    };
    plots.extendLayout = function(destLayout, srcLayout) {
      return plots.extendObjectWithContainers(destLayout, srcLayout, plots.layoutArrayContainers);
    };
    plots.transition = function(gd2, data, layout, traces, frameOpts, transitionOpts) {
      var opts = { redraw: frameOpts.redraw };
      var transitionedTraces = {};
      var axEdits = [];
      opts.prepareFn = function() {
        var dataLength = Array.isArray(data) ? data.length : 0;
        var traceIndices = traces.slice(0, dataLength);
        for (var i = 0; i < traceIndices.length; i++) {
          var traceIdx = traceIndices[i];
          var trace = gd2._fullData[traceIdx];
          var _module = trace._module;
          if (!_module) continue;
          if (_module.animatable) {
            var n = _module.basePlotModule.name;
            if (!transitionedTraces[n]) transitionedTraces[n] = [];
            transitionedTraces[n].push(traceIdx);
          }
          gd2.data[traceIndices[i]] = plots.extendTrace(gd2.data[traceIndices[i]], data[i]);
        }
        var layoutUpdate = Lib.expandObjectPaths(Lib.extendDeepNoArrays({}, layout));
        var axisAttrRe = /^[xy]axis[0-9]*$/;
        for (var attr in layoutUpdate) {
          if (!axisAttrRe.test(attr)) continue;
          delete layoutUpdate[attr].range;
        }
        plots.extendLayout(gd2.layout, layoutUpdate);
        delete gd2.calcdata;
        plots.supplyDefaults(gd2);
        plots.doCalcdata(gd2);
        var newLayout = Lib.expandObjectPaths(layout);
        if (newLayout) {
          var subplots = gd2._fullLayout._plots;
          for (var k in subplots) {
            var plotinfo = subplots[k];
            var xa2 = plotinfo.xaxis;
            var ya2 = plotinfo.yaxis;
            var xr0 = xa2.range.slice();
            var yr0 = ya2.range.slice();
            var xr1 = null;
            var yr1 = null;
            var editX = null;
            var editY = null;
            if (Array.isArray(newLayout[xa2._name + ".range"])) {
              xr1 = newLayout[xa2._name + ".range"].slice();
            } else if (Array.isArray((newLayout[xa2._name] || {}).range)) {
              xr1 = newLayout[xa2._name].range.slice();
            }
            if (Array.isArray(newLayout[ya2._name + ".range"])) {
              yr1 = newLayout[ya2._name + ".range"].slice();
            } else if (Array.isArray((newLayout[ya2._name] || {}).range)) {
              yr1 = newLayout[ya2._name].range.slice();
            }
            if (xr0 && xr1 && (xa2.r2l(xr0[0]) !== xa2.r2l(xr1[0]) || xa2.r2l(xr0[1]) !== xa2.r2l(xr1[1]))) {
              editX = { xr0, xr1 };
            }
            if (yr0 && yr1 && (ya2.r2l(yr0[0]) !== ya2.r2l(yr1[0]) || ya2.r2l(yr0[1]) !== ya2.r2l(yr1[1]))) {
              editY = { yr0, yr1 };
            }
            if (editX || editY) {
              axEdits.push(Lib.extendFlat({ plotinfo }, editX, editY));
            }
          }
        }
        return Promise.resolve();
      };
      opts.runFn = function(makeCallback) {
        var traceTransitionOpts;
        var basePlotModules = gd2._fullLayout._basePlotModules;
        var hasAxisTransition = axEdits.length;
        var i;
        if (layout) {
          for (i = 0; i < basePlotModules.length; i++) {
            if (basePlotModules[i].transitionAxes) {
              basePlotModules[i].transitionAxes(gd2, axEdits, transitionOpts, makeCallback);
            }
          }
        }
        if (hasAxisTransition) {
          traceTransitionOpts = Lib.extendFlat({}, transitionOpts);
          traceTransitionOpts.duration = 0;
          delete transitionedTraces.cartesian;
        } else {
          traceTransitionOpts = transitionOpts;
        }
        for (var n in transitionedTraces) {
          var traceIndices = transitionedTraces[n];
          var _module = gd2._fullData[traceIndices[0]]._module;
          _module.basePlotModule.plot(gd2, traceIndices, traceTransitionOpts, makeCallback);
        }
      };
      return _transition(gd2, transitionOpts, opts);
    };
    plots.transitionFromReact = function(gd2, restyleFlags, relayoutFlags, oldFullLayout) {
      var fullLayout = gd2._fullLayout;
      var transitionOpts = fullLayout.transition;
      var opts = {};
      var axEdits = [];
      opts.prepareFn = function() {
        var subplots = fullLayout._plots;
        opts.redraw = false;
        if (restyleFlags.anim === "some") opts.redraw = true;
        if (relayoutFlags.anim === "some") opts.redraw = true;
        for (var k in subplots) {
          var plotinfo = subplots[k];
          var xa2 = plotinfo.xaxis;
          var ya2 = plotinfo.yaxis;
          var xr0 = oldFullLayout[xa2._name].range.slice();
          var yr0 = oldFullLayout[ya2._name].range.slice();
          var xr1 = xa2.range.slice();
          var yr1 = ya2.range.slice();
          xa2.setScale();
          ya2.setScale();
          var editX = null;
          var editY = null;
          if (xa2.r2l(xr0[0]) !== xa2.r2l(xr1[0]) || xa2.r2l(xr0[1]) !== xa2.r2l(xr1[1])) {
            editX = { xr0, xr1 };
          }
          if (ya2.r2l(yr0[0]) !== ya2.r2l(yr1[0]) || ya2.r2l(yr0[1]) !== ya2.r2l(yr1[1])) {
            editY = { yr0, yr1 };
          }
          if (editX || editY) {
            axEdits.push(Lib.extendFlat({ plotinfo }, editX, editY));
          }
        }
        return Promise.resolve();
      };
      opts.runFn = function(makeCallback) {
        var fullData = gd2._fullData;
        var fullLayout2 = gd2._fullLayout;
        var basePlotModules = fullLayout2._basePlotModules;
        var axisTransitionOpts;
        var traceTransitionOpts;
        var transitionedTraces;
        var allTraceIndices = [];
        for (var i = 0; i < fullData.length; i++) {
          allTraceIndices.push(i);
        }
        function transitionAxes() {
          if (!gd2._fullLayout) return;
          for (var j = 0; j < basePlotModules.length; j++) {
            if (basePlotModules[j].transitionAxes) {
              basePlotModules[j].transitionAxes(gd2, axEdits, axisTransitionOpts, makeCallback);
            }
          }
        }
        function transitionTraces() {
          if (!gd2._fullLayout) return;
          for (var j = 0; j < basePlotModules.length; j++) {
            basePlotModules[j].plot(gd2, transitionedTraces, traceTransitionOpts, makeCallback);
          }
        }
        if (axEdits.length && restyleFlags.anim) {
          if (transitionOpts.ordering === "traces first") {
            axisTransitionOpts = Lib.extendFlat({}, transitionOpts, { duration: 0 });
            transitionedTraces = allTraceIndices;
            traceTransitionOpts = transitionOpts;
            setTimeout(transitionAxes, transitionOpts.duration);
            transitionTraces();
          } else {
            axisTransitionOpts = transitionOpts;
            transitionedTraces = null;
            traceTransitionOpts = Lib.extendFlat({}, transitionOpts, { duration: 0 });
            setTimeout(transitionTraces, axisTransitionOpts.duration);
            transitionAxes();
          }
        } else if (axEdits.length) {
          axisTransitionOpts = transitionOpts;
          transitionAxes();
        } else if (restyleFlags.anim) {
          transitionedTraces = allTraceIndices;
          traceTransitionOpts = transitionOpts;
          transitionTraces();
        }
      };
      return _transition(gd2, transitionOpts, opts);
    };
    function _transition(gd2, transitionOpts, opts) {
      var aborted = false;
      function executeCallbacks(list) {
        var p = Promise.resolve();
        if (!list) return p;
        while (list.length) {
          p = p.then(list.shift());
        }
        return p;
      }
      function flushCallbacks(list) {
        if (!list) return;
        while (list.length) {
          list.shift();
        }
      }
      function executeTransitions() {
        gd2.emit("plotly_transitioning", []);
        return new Promise(function(resolve) {
          gd2._transitioning = true;
          if (transitionOpts.duration > 0) {
            gd2._transitioningWithDuration = true;
          }
          gd2._transitionData._interruptCallbacks.push(function() {
            aborted = true;
          });
          if (opts.redraw) {
            gd2._transitionData._interruptCallbacks.push(function() {
              return Registry.call("redraw", gd2);
            });
          }
          gd2._transitionData._interruptCallbacks.push(function() {
            gd2.emit("plotly_transitioninterrupted", []);
          });
          var numCallbacks = 0;
          var numCompleted = 0;
          function makeCallback() {
            numCallbacks++;
            return function() {
              numCompleted++;
              if (!aborted && numCompleted === numCallbacks) {
                completeTransition(resolve);
              }
            };
          }
          opts.runFn(makeCallback);
          setTimeout(makeCallback());
        });
      }
      function completeTransition(callback) {
        if (!gd2._transitionData) return;
        flushCallbacks(gd2._transitionData._interruptCallbacks);
        return Promise.resolve().then(function() {
          if (opts.redraw) {
            return Registry.call("redraw", gd2);
          }
        }).then(function() {
          gd2._transitioning = false;
          gd2._transitioningWithDuration = false;
          gd2.emit("plotly_transitioned", []);
        }).then(callback);
      }
      function interruptPreviousTransitions() {
        if (!gd2._transitionData) return;
        gd2._transitioning = false;
        return executeCallbacks(gd2._transitionData._interruptCallbacks);
      }
      var seq = [
        plots.previousPromises,
        interruptPreviousTransitions,
        opts.prepareFn,
        plots.rehover,
        plots.reselect,
        executeTransitions
      ];
      var transitionStarting = Lib.syncOrAsync(seq, gd2);
      if (!transitionStarting || !transitionStarting.then) {
        transitionStarting = Promise.resolve();
      }
      return transitionStarting.then(function() {
        return gd2;
      });
    }
    plots.doCalcdata = function(gd2, traces) {
      var axList = axisIDs.list(gd2);
      var fullData = gd2._fullData;
      var fullLayout = gd2._fullLayout;
      var trace, _module, i, j;
      var calcdata = new Array(fullData.length);
      var oldCalcdata = (gd2.calcdata || []).slice();
      gd2.calcdata = calcdata;
      fullLayout._numBoxes = 0;
      fullLayout._numViolins = 0;
      fullLayout._violinScaleGroupStats = {};
      gd2._hmpixcount = 0;
      gd2._hmlumcount = 0;
      fullLayout._piecolormap = {};
      fullLayout._sunburstcolormap = {};
      fullLayout._treemapcolormap = {};
      fullLayout._iciclecolormap = {};
      fullLayout._funnelareacolormap = {};
      for (i = 0; i < fullData.length; i++) {
        if (Array.isArray(traces) && traces.indexOf(i) === -1) {
          calcdata[i] = oldCalcdata[i];
          continue;
        }
      }
      for (i = 0; i < fullData.length; i++) {
        trace = fullData[i];
        trace._arrayAttrs = PlotSchema.findArrayAttributes(trace);
        trace._extremes = {};
      }
      var polarIds = fullLayout._subplots.polar || [];
      for (i = 0; i < polarIds.length; i++) {
        axList.push(
          fullLayout[polarIds[i]].radialaxis,
          fullLayout[polarIds[i]].angularaxis
        );
      }
      for (var k in fullLayout._colorAxes) {
        var cOpts = fullLayout[k];
        if (cOpts.cauto !== false) {
          delete cOpts.cmin;
          delete cOpts.cmax;
        }
      }
      var hasCalcTransform = false;
      function transformCalci(i2) {
        trace = fullData[i2];
        _module = trace._module;
        if (trace.visible === true && trace.transforms) {
          if (_module && _module.calc) {
            var cdi = _module.calc(gd2, trace);
            if (cdi[0] && cdi[0].t && cdi[0].t._scene) {
              delete cdi[0].t._scene.dirty;
            }
          }
          for (j = 0; j < trace.transforms.length; j++) {
            var transform = trace.transforms[j];
            _module = transformsRegistry[transform.type];
            if (_module && _module.calcTransform) {
              trace._hasCalcTransform = true;
              hasCalcTransform = true;
              _module.calcTransform(gd2, trace, transform);
            }
          }
        }
      }
      function calci(i2, isContainer) {
        trace = fullData[i2];
        _module = trace._module;
        if (!!_module.isContainer !== isContainer) return;
        var cd2 = [];
        if (trace.visible === true && trace._length !== 0) {
          delete trace._indexToPoints;
          var transforms = trace.transforms || [];
          for (j = transforms.length - 1; j >= 0; j--) {
            if (transforms[j].enabled) {
              trace._indexToPoints = transforms[j]._indexToPoints;
              break;
            }
          }
          if (_module && _module.calc) {
            cd2 = _module.calc(gd2, trace);
          }
        }
        if (!Array.isArray(cd2) || !cd2[0]) {
          cd2 = [{ x: BADNUM, y: BADNUM }];
        }
        if (!cd2[0].t) cd2[0].t = {};
        cd2[0].trace = trace;
        calcdata[i2] = cd2;
      }
      setupAxisCategories(axList, fullData, fullLayout);
      for (i = 0; i < fullData.length; i++) calci(i, true);
      for (i = 0; i < fullData.length; i++) transformCalci(i);
      if (hasCalcTransform) setupAxisCategories(axList, fullData, fullLayout);
      for (i = 0; i < fullData.length; i++) calci(i, true);
      for (i = 0; i < fullData.length; i++) calci(i, false);
      doCrossTraceCalc(gd2);
      var sorted = sortAxisCategoriesByValue(axList, gd2);
      if (sorted.length) {
        fullLayout._numBoxes = 0;
        fullLayout._numViolins = 0;
        for (i = 0; i < sorted.length; i++) calci(sorted[i], true);
        for (i = 0; i < sorted.length; i++) calci(sorted[i], false);
        doCrossTraceCalc(gd2);
      }
      Registry.getComponentMethod("fx", "calc")(gd2);
      Registry.getComponentMethod("errorbars", "calc")(gd2);
    };
    var sortAxisCategoriesByValueRegex = /(total|sum|min|max|mean|geometric mean|median) (ascending|descending)/;
    function sortAxisCategoriesByValue(axList, gd2) {
      var affectedTraces = [];
      var i, j, k, l, o;
      function zMapCategory(type2, ax2, value2) {
        var axLetter2 = ax2._id.charAt(0);
        if (type2 === "histogram2dcontour") {
          var counterAxLetter = ax2._counterAxes[0];
          var counterAx = axisIDs.getFromId(gd2, counterAxLetter);
          var xCategorical = axLetter2 === "x" || counterAxLetter === "x" && counterAx.type === "category";
          var yCategorical = axLetter2 === "y" || counterAxLetter === "y" && counterAx.type === "category";
          return function(o2, l2) {
            if (o2 === 0 || l2 === 0) return -1;
            if (xCategorical && o2 === value2[l2].length - 1) return -1;
            if (yCategorical && l2 === value2.length - 1) return -1;
            return (axLetter2 === "y" ? l2 : o2) - 1;
          };
        } else {
          return function(o2, l2) {
            return axLetter2 === "y" ? l2 : o2;
          };
        }
      }
      var aggFn = {
        min: function(values) {
          return Lib.aggNums(Math.min, null, values);
        },
        max: function(values) {
          return Lib.aggNums(Math.max, null, values);
        },
        sum: function(values) {
          return Lib.aggNums(function(a, b) {
            return a + b;
          }, null, values);
        },
        total: function(values) {
          return Lib.aggNums(function(a, b) {
            return a + b;
          }, null, values);
        },
        mean: function(values) {
          return Lib.mean(values);
        },
        "geometric mean": function(values) {
          return Lib.geometricMean(values);
        },
        median: function(values) {
          return Lib.median(values);
        }
      };
      function sortAscending(a, b) {
        return a[1] - b[1];
      }
      function sortDescending(a, b) {
        return b[1] - a[1];
      }
      for (i = 0; i < axList.length; i++) {
        var ax = axList[i];
        if (ax.type !== "category") continue;
        var match = ax.categoryorder.match(sortAxisCategoriesByValueRegex);
        if (match) {
          var aggregator = match[1];
          var order = match[2];
          var axLetter = ax._id.charAt(0);
          var isX = axLetter === "x";
          var categoriesValue = [];
          for (j = 0; j < ax._categories.length; j++) {
            categoriesValue.push([ax._categories[j], []]);
          }
          for (j = 0; j < ax._traceIndices.length; j++) {
            var traceIndex = ax._traceIndices[j];
            var fullTrace = gd2._fullData[traceIndex];
            if (fullTrace.visible !== true) continue;
            var type = fullTrace.type;
            if (Registry.traceIs(fullTrace, "histogram")) {
              delete fullTrace._xautoBinFinished;
              delete fullTrace._yautoBinFinished;
            }
            var isSplom = type === "splom";
            var isScattergl = type === "scattergl";
            var cd2 = gd2.calcdata[traceIndex];
            for (k = 0; k < cd2.length; k++) {
              var cdi = cd2[k];
              var catIndex, value;
              if (isSplom) {
                var currentDimensionIndex = fullTrace._axesDim[ax._id];
                if (!isX) {
                  var associatedXAxisID = fullTrace._diag[currentDimensionIndex][0];
                  if (associatedXAxisID) ax = gd2._fullLayout[axisIDs.id2name(associatedXAxisID)];
                }
                var categories = cdi.trace.dimensions[currentDimensionIndex].values;
                for (l = 0; l < categories.length; l++) {
                  catIndex = ax._categoriesMap[categories[l]];
                  for (o = 0; o < cdi.trace.dimensions.length; o++) {
                    if (o === currentDimensionIndex) continue;
                    var dimension = cdi.trace.dimensions[o];
                    categoriesValue[catIndex][1].push(dimension.values[l]);
                  }
                }
              } else if (isScattergl) {
                for (l = 0; l < cdi.t.x.length; l++) {
                  if (isX) {
                    catIndex = cdi.t.x[l];
                    value = cdi.t.y[l];
                  } else {
                    catIndex = cdi.t.y[l];
                    value = cdi.t.x[l];
                  }
                  categoriesValue[catIndex][1].push(value);
                }
                if (cdi.t && cdi.t._scene) {
                  delete cdi.t._scene.dirty;
                }
              } else if (cdi.hasOwnProperty("z")) {
                value = cdi.z;
                var mapping = zMapCategory(fullTrace.type, ax, value);
                for (l = 0; l < value.length; l++) {
                  for (o = 0; o < value[l].length; o++) {
                    catIndex = mapping(o, l);
                    if (catIndex + 1) categoriesValue[catIndex][1].push(value[l][o]);
                  }
                }
              } else {
                catIndex = cdi.p;
                if (catIndex === void 0) catIndex = cdi[axLetter];
                value = cdi.s;
                if (value === void 0) value = cdi.v;
                if (value === void 0) value = isX ? cdi.y : cdi.x;
                if (!Array.isArray(value)) {
                  if (value === void 0) value = [];
                  else value = [value];
                }
                for (l = 0; l < value.length; l++) {
                  categoriesValue[catIndex][1].push(value[l]);
                }
              }
            }
          }
          ax._categoriesValue = categoriesValue;
          var categoriesAggregatedValue = [];
          for (j = 0; j < categoriesValue.length; j++) {
            categoriesAggregatedValue.push([
              categoriesValue[j][0],
              aggFn[aggregator](categoriesValue[j][1])
            ]);
          }
          categoriesAggregatedValue.sort(order === "descending" ? sortDescending : sortAscending);
          ax._categoriesAggregatedValue = categoriesAggregatedValue;
          ax._initialCategories = categoriesAggregatedValue.map(function(c) {
            return c[0];
          });
          affectedTraces = affectedTraces.concat(ax.sortByInitialCategories());
        }
      }
      return affectedTraces;
    }
    function setupAxisCategories(axList, fullData, fullLayout) {
      var axLookup = {};
      function setupOne(ax) {
        ax.clearCalc();
        if (ax.type === "multicategory") {
          ax.setupMultiCategory(fullData);
        }
        axLookup[ax._id] = 1;
      }
      Lib.simpleMap(axList, setupOne);
      var matchGroups = fullLayout._axisMatchGroups || [];
      for (var i = 0; i < matchGroups.length; i++) {
        for (var axId in matchGroups[i]) {
          if (!axLookup[axId]) {
            setupOne(fullLayout[axisIDs.id2name(axId)]);
          }
        }
      }
    }
    function doCrossTraceCalc(gd2) {
      var fullLayout = gd2._fullLayout;
      var modules = fullLayout._visibleModules;
      var hash = {};
      var i, j, k;
      for (j = 0; j < modules.length; j++) {
        var _module = modules[j];
        var fn = _module.crossTraceCalc;
        if (fn) {
          var spType = _module.basePlotModule.name;
          if (hash[spType]) {
            Lib.pushUnique(hash[spType], fn);
          } else {
            hash[spType] = [fn];
          }
        }
      }
      for (k in hash) {
        var methods = hash[k];
        var subplots = fullLayout._subplots[k];
        if (Array.isArray(subplots)) {
          for (i = 0; i < subplots.length; i++) {
            var sp2 = subplots[i];
            var spInfo = k === "cartesian" ? fullLayout._plots[sp2] : fullLayout[sp2];
            for (j = 0; j < methods.length; j++) {
              methods[j](gd2, spInfo, sp2);
            }
          }
        } else {
          for (j = 0; j < methods.length; j++) {
            methods[j](gd2);
          }
        }
      }
    }
    plots.rehover = function(gd2) {
      if (gd2._fullLayout._rehover) {
        gd2._fullLayout._rehover();
      }
    };
    plots.redrag = function(gd2) {
      if (gd2._fullLayout._redrag) {
        gd2._fullLayout._redrag();
      }
    };
    plots.reselect = function(gd2) {
      var fullLayout = gd2._fullLayout;
      var A = (gd2.layout || {}).selections;
      var B = fullLayout._previousSelections;
      fullLayout._previousSelections = A;
      var mayEmitSelected = fullLayout._reselect || JSON.stringify(A) !== JSON.stringify(B);
      Registry.getComponentMethod("selections", "reselect")(gd2, mayEmitSelected);
    };
    plots.generalUpdatePerTraceModule = function(gd2, subplot, subplotCalcData, subplotLayout) {
      var traceHashOld = subplot.traceHash;
      var traceHash = {};
      var i;
      for (i = 0; i < subplotCalcData.length; i++) {
        var calcTraces = subplotCalcData[i];
        var trace = calcTraces[0].trace;
        if (trace.visible) {
          traceHash[trace.type] = traceHash[trace.type] || [];
          traceHash[trace.type].push(calcTraces);
        }
      }
      for (var moduleNameOld in traceHashOld) {
        if (!traceHash[moduleNameOld]) {
          var fakeCalcTrace = traceHashOld[moduleNameOld][0];
          var fakeTrace = fakeCalcTrace[0].trace;
          fakeTrace.visible = false;
          traceHash[moduleNameOld] = [fakeCalcTrace];
        }
      }
      for (var moduleName in traceHash) {
        var moduleCalcData = traceHash[moduleName];
        var _module = moduleCalcData[0][0].trace._module;
        _module.plot(gd2, subplot, Lib.filterVisible(moduleCalcData), subplotLayout);
      }
      subplot.traceHash = traceHash;
    };
    plots.plotBasePlot = function(desiredType, gd2, traces, transitionOpts, makeOnCompleteCallback) {
      var _module = Registry.getModule(desiredType);
      var cdmodule = getModuleCalcData(gd2.calcdata, _module)[0];
      _module.plot(gd2, cdmodule, transitionOpts, makeOnCompleteCallback);
    };
    plots.cleanBasePlot = function(desiredType, newFullData, newFullLayout, oldFullData, oldFullLayout) {
      var had = oldFullLayout._has && oldFullLayout._has(desiredType);
      var has = newFullLayout._has && newFullLayout._has(desiredType);
      if (had && !has) {
        oldFullLayout["_" + desiredType + "layer"].selectAll("g.trace").remove();
      }
    };
  }
});

// node_modules/plotly.js/src/constants/xmlns_namespaces.js
var require_xmlns_namespaces = __commonJS({
  "node_modules/plotly.js/src/constants/xmlns_namespaces.js"(exports2) {
    "use strict";
    exports2.xmlns = "http://www.w3.org/2000/xmlns/";
    exports2.svg = "http://www.w3.org/2000/svg";
    exports2.xlink = "http://www.w3.org/1999/xlink";
    exports2.svgAttrs = {
      xmlns: exports2.svg,
      "xmlns:xlink": exports2.xlink
    };
  }
});

// node_modules/plotly.js/src/constants/alignment.js
var require_alignment = __commonJS({
  "node_modules/plotly.js/src/constants/alignment.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      // from bottom left: this is the origin of our paper-reference
      // positioning system
      FROM_BL: {
        left: 0,
        center: 0.5,
        right: 1,
        bottom: 0,
        middle: 0.5,
        top: 1
      },
      // from top left: this is the screen pixel positioning origin
      FROM_TL: {
        left: 0,
        center: 0.5,
        right: 1,
        bottom: 1,
        middle: 0.5,
        top: 0
      },
      // from bottom right: sometimes you just need the opposite of ^^
      FROM_BR: {
        left: 1,
        center: 0.5,
        right: 0,
        bottom: 0,
        middle: 0.5,
        top: 1
      },
      // multiple of fontSize to get the vertical offset between lines
      LINE_SPACING: 1.3,
      // multiple of fontSize to shift from the baseline
      // to the cap (captical letter) line
      // (to use when we don't calculate this shift from Drawing.bBox)
      // This is an approximation since in reality cap height can differ
      // from font to font. However, according to Wikipedia
      //   an "average" font might have a cap height of 70% of the em
      // https://en.wikipedia.org/wiki/Em_(typography)#History
      CAP_SHIFT: 0.7,
      // half the cap height (distance between baseline and cap line)
      // of an "average" font (for more info see above).
      MID_SHIFT: 0.35,
      OPPOSITE_SIDE: {
        left: "right",
        right: "left",
        top: "bottom",
        bottom: "top"
      }
    };
  }
});

// node_modules/plotly.js/src/lib/svg_text_utils.js
var require_svg_text_utils = __commonJS({
  "node_modules/plotly.js/src/lib/svg_text_utils.js"(exports2) {
    "use strict";
    var d3 = require_d3();
    var Lib = require_lib();
    var strTranslate = Lib.strTranslate;
    var xmlnsNamespaces = require_xmlns_namespaces();
    var LINE_SPACING = require_alignment().LINE_SPACING;
    var FIND_TEX = /([^$]*)([$]+[^$]*[$]+)([^$]*)/;
    exports2.convertToTspans = function(_context, gd2, _callback) {
      var str = _context.text();
      var tex = !_context.attr("data-notex") && gd2 && gd2._context.typesetMath && typeof MathJax !== "undefined" && str.match(FIND_TEX);
      var parent = d3.select(_context.node().parentNode);
      if (parent.empty()) return;
      var svgClass = _context.attr("class") ? _context.attr("class").split(" ")[0] : "text";
      svgClass += "-math";
      parent.selectAll("svg." + svgClass).remove();
      parent.selectAll("g." + svgClass + "-group").remove();
      _context.style("display", null).attr({
        // some callers use data-unformatted *from the <text> element* in 'cancel'
        // so we need it here even if we're going to turn it into math
        // these two (plus style and text-anchor attributes) form the key we're
        // going to use for Drawing.bBox
        "data-unformatted": str,
        "data-math": "N"
      });
      function showText() {
        if (!parent.empty()) {
          svgClass = _context.attr("class") + "-math";
          parent.select("svg." + svgClass).remove();
        }
        _context.text("").style("white-space", "pre");
        var hasLink = buildSVGText(_context.node(), str);
        if (hasLink) {
          _context.style("pointer-events", "all");
        }
        exports2.positionText(_context);
        if (_callback) _callback.call(_context);
      }
      if (tex) {
        (gd2 && gd2._promises || []).push(new Promise(function(resolve) {
          _context.style("display", "none");
          var fontSize = parseInt(_context.node().style.fontSize, 10);
          var config = { fontSize };
          texToSVG(tex[2], config, function(_svgEl, _glyphDefs, _svgBBox) {
            parent.selectAll("svg." + svgClass).remove();
            parent.selectAll("g." + svgClass + "-group").remove();
            var newSvg = _svgEl && _svgEl.select("svg");
            if (!newSvg || !newSvg.node()) {
              showText();
              resolve();
              return;
            }
            var mathjaxGroup = parent.append("g").classed(svgClass + "-group", true).attr({
              "pointer-events": "none",
              "data-unformatted": str,
              "data-math": "Y"
            });
            mathjaxGroup.node().appendChild(newSvg.node());
            if (_glyphDefs && _glyphDefs.node()) {
              newSvg.node().insertBefore(
                _glyphDefs.node().cloneNode(true),
                newSvg.node().firstChild
              );
            }
            var w02 = _svgBBox.width;
            var h02 = _svgBBox.height;
            newSvg.attr({
              class: svgClass,
              height: h02,
              preserveAspectRatio: "xMinYMin meet"
            }).style({ overflow: "visible", "pointer-events": "none" });
            var fill = _context.node().style.fill || "black";
            var g = newSvg.select("g");
            g.attr({ fill, stroke: fill });
            var bb = g.node().getBoundingClientRect();
            var w = bb.width;
            var h = bb.height;
            if (w > w02 || h > h02) {
              newSvg.style("overflow", "hidden");
              bb = newSvg.node().getBoundingClientRect();
              w = bb.width;
              h = bb.height;
            }
            var x = +_context.attr("x");
            var y = +_context.attr("y");
            var textHeight = fontSize || _context.node().getBoundingClientRect().height;
            var dy = -textHeight / 4;
            if (svgClass[0] === "y") {
              mathjaxGroup.attr({
                transform: "rotate(" + [-90, x, y] + ")" + strTranslate(-w / 2, dy - h / 2)
              });
            } else if (svgClass[0] === "l") {
              y = dy - h / 2;
            } else if (svgClass[0] === "a" && svgClass.indexOf("atitle") !== 0) {
              x = 0;
              y = dy;
            } else {
              var anchor = _context.attr("text-anchor");
              x = x - w * (anchor === "middle" ? 0.5 : anchor === "end" ? 1 : 0);
              y = y + dy - h / 2;
            }
            newSvg.attr({
              x,
              y
            });
            if (_callback) _callback.call(_context, mathjaxGroup);
            resolve(mathjaxGroup);
          });
        }));
      } else showText();
      return _context;
    };
    var LT_MATCH = /(<|&lt;|&#60;)/g;
    var GT_MATCH = /(>|&gt;|&#62;)/g;
    function cleanEscapesForTex(s) {
      return s.replace(LT_MATCH, "\\lt ").replace(GT_MATCH, "\\gt ");
    }
    var inlineMath = [["$", "$"], ["\\(", "\\)"]];
    function texToSVG(_texString, _config, _callback) {
      var MathJaxVersion = parseInt(
        (MathJax.version || "").split(".")[0]
      );
      if (MathJaxVersion !== 2 && MathJaxVersion !== 3) {
        Lib.warn("No MathJax version:", MathJax.version);
        return;
      }
      var originalRenderer, originalConfig, originalProcessSectionDelay, tmpDiv;
      var setConfig2 = function() {
        originalConfig = Lib.extendDeepAll({}, MathJax.Hub.config);
        originalProcessSectionDelay = MathJax.Hub.processSectionDelay;
        if (MathJax.Hub.processSectionDelay !== void 0) {
          MathJax.Hub.processSectionDelay = 0;
        }
        return MathJax.Hub.Config({
          messageStyle: "none",
          tex2jax: {
            inlineMath
          },
          displayAlign: "left"
        });
      };
      var setConfig3 = function() {
        originalConfig = Lib.extendDeepAll({}, MathJax.config);
        if (!MathJax.config.tex) {
          MathJax.config.tex = {};
        }
        MathJax.config.tex.inlineMath = inlineMath;
      };
      var setRenderer2 = function() {
        originalRenderer = MathJax.Hub.config.menuSettings.renderer;
        if (originalRenderer !== "SVG") {
          return MathJax.Hub.setRenderer("SVG");
        }
      };
      var setRenderer3 = function() {
        originalRenderer = MathJax.config.startup.output;
        if (originalRenderer !== "svg") {
          MathJax.config.startup.output = "svg";
        }
      };
      var initiateMathJax = function() {
        var randomID = "math-output-" + Lib.randstr({}, 64);
        tmpDiv = d3.select("body").append("div").attr({ id: randomID }).style({
          visibility: "hidden",
          position: "absolute",
          "font-size": _config.fontSize + "px"
        }).text(cleanEscapesForTex(_texString));
        var tmpNode = tmpDiv.node();
        return MathJaxVersion === 2 ? MathJax.Hub.Typeset(tmpNode) : MathJax.typeset([tmpNode]);
      };
      var finalizeMathJax = function() {
        var sel = tmpDiv.select(
          MathJaxVersion === 2 ? ".MathJax_SVG" : ".MathJax"
        );
        var node = !sel.empty() && tmpDiv.select("svg").node();
        if (!node) {
          Lib.log("There was an error in the tex syntax.", _texString);
          _callback();
        } else {
          var nodeBBox = node.getBoundingClientRect();
          var glyphDefs;
          if (MathJaxVersion === 2) {
            glyphDefs = d3.select("body").select("#MathJax_SVG_glyphs");
          } else {
            glyphDefs = sel.select("defs");
          }
          _callback(sel, glyphDefs, nodeBBox);
        }
        tmpDiv.remove();
      };
      var resetRenderer2 = function() {
        if (originalRenderer !== "SVG") {
          return MathJax.Hub.setRenderer(originalRenderer);
        }
      };
      var resetRenderer3 = function() {
        if (originalRenderer !== "svg") {
          MathJax.config.startup.output = originalRenderer;
        }
      };
      var resetConfig2 = function() {
        if (originalProcessSectionDelay !== void 0) {
          MathJax.Hub.processSectionDelay = originalProcessSectionDelay;
        }
        return MathJax.Hub.Config(originalConfig);
      };
      var resetConfig3 = function() {
        MathJax.config = originalConfig;
      };
      if (MathJaxVersion === 2) {
        MathJax.Hub.Queue(
          setConfig2,
          setRenderer2,
          initiateMathJax,
          finalizeMathJax,
          resetRenderer2,
          resetConfig2
        );
      } else if (MathJaxVersion === 3) {
        setConfig3();
        setRenderer3();
        MathJax.startup.defaultReady();
        MathJax.startup.promise.then(function() {
          initiateMathJax();
          finalizeMathJax();
          resetRenderer3();
          resetConfig3();
        });
      }
    }
    var TAG_STYLES = {
      // would like to use baseline-shift for sub/sup but FF doesn't support it
      // so we need to use dy along with the uber hacky shift-back-to
      // baseline below
      sup: "font-size:70%",
      sub: "font-size:70%",
      s: "text-decoration:line-through",
      u: "text-decoration:underline",
      b: "font-weight:bold",
      i: "font-style:italic",
      a: "cursor:pointer",
      span: "",
      em: "font-style:italic;font-weight:bold"
    };
    var SHIFT_DY = {
      sub: "0.3em",
      sup: "-0.6em"
    };
    var RESET_DY = {
      sub: "-0.21em",
      sup: "0.42em"
    };
    var ZERO_WIDTH_SPACE = "​";
    var PROTOCOLS = ["http:", "https:", "mailto:", "", void 0, ":"];
    var NEWLINES = exports2.NEWLINES = /(\r\n?|\n)/g;
    var SPLIT_TAGS = /(<[^<>]*>)/;
    var ONE_TAG = /<(\/?)([^ >]*)(\s+(.*))?>/i;
    var BR_TAG = /<br(\s+.*)?>/i;
    exports2.BR_TAG_ALL = /<br(\s+.*)?>/gi;
    var STYLEMATCH = /(^|[\s"'])style\s*=\s*("([^"]*);?"|'([^']*);?')/i;
    var HREFMATCH = /(^|[\s"'])href\s*=\s*("([^"]*)"|'([^']*)')/i;
    var TARGETMATCH = /(^|[\s"'])target\s*=\s*("([^"\s]*)"|'([^'\s]*)')/i;
    var POPUPMATCH = /(^|[\s"'])popup\s*=\s*("([\w=,]*)"|'([\w=,]*)')/i;
    function getQuotedMatch(_str, re2) {
      if (!_str) return null;
      var match = _str.match(re2);
      var result = match && (match[3] || match[4]);
      return result && convertEntities(result);
    }
    var COLORMATCH = /(^|;)\s*color:/;
    exports2.plainText = function(_str, opts) {
      opts = opts || {};
      var len = opts.len !== void 0 && opts.len !== -1 ? opts.len : Infinity;
      var allowedTags = opts.allowedTags !== void 0 ? opts.allowedTags : ["br"];
      var ellipsis = "...";
      var eLen = ellipsis.length;
      var oldParts = _str.split(SPLIT_TAGS);
      var newParts = [];
      var prevTag = "";
      var l = 0;
      for (var i = 0; i < oldParts.length; i++) {
        var p = oldParts[i];
        var match = p.match(ONE_TAG);
        var tagType = match && match[2].toLowerCase();
        if (tagType) {
          if (allowedTags.indexOf(tagType) !== -1) {
            newParts.push(p);
            prevTag = tagType;
          }
        } else {
          var pLen = p.length;
          if (l + pLen < len) {
            newParts.push(p);
            l += pLen;
          } else if (l < len) {
            var pLen2 = len - l;
            if (prevTag && (prevTag !== "br" || pLen2 <= eLen || pLen <= eLen)) {
              newParts.pop();
            }
            if (len > eLen) {
              newParts.push(p.substr(0, pLen2 - eLen) + ellipsis);
            } else {
              newParts.push(p.substr(0, pLen2));
            }
            break;
          }
          prevTag = "";
        }
      }
      return newParts.join("");
    };
    var entityToUnicode = {
      mu: "μ",
      amp: "&",
      lt: "<",
      gt: ">",
      nbsp: " ",
      times: "×",
      plusmn: "±",
      deg: "°"
    };
    var ENTITY_MATCH = /&(#\d+|#x[\da-fA-F]+|[a-z]+);/g;
    function convertEntities(_str) {
      return _str.replace(ENTITY_MATCH, function(fullMatch, innerMatch) {
        var outChar;
        if (innerMatch.charAt(0) === "#") {
          outChar = fromCodePoint(
            innerMatch.charAt(1) === "x" ? parseInt(innerMatch.substr(2), 16) : parseInt(innerMatch.substr(1), 10)
          );
        } else outChar = entityToUnicode[innerMatch];
        return outChar || fullMatch;
      });
    }
    exports2.convertEntities = convertEntities;
    function fromCodePoint(code) {
      if (code > 1114111) return;
      var stringFromCodePoint = String.fromCodePoint;
      if (stringFromCodePoint) return stringFromCodePoint(code);
      var stringFromCharCode = String.fromCharCode;
      if (code <= 65535) return stringFromCharCode(code);
      return stringFromCharCode(
        (code >> 10) + 55232,
        code % 1024 + 56320
      );
    }
    function buildSVGText(containerNode, str) {
      str = str.replace(NEWLINES, " ");
      var hasLink = false;
      var nodeStack = [];
      var currentNode;
      var currentLine = -1;
      function newLine() {
        currentLine++;
        var lineNode = document.createElementNS(xmlnsNamespaces.svg, "tspan");
        d3.select(lineNode).attr({
          class: "line",
          dy: currentLine * LINE_SPACING + "em"
        });
        containerNode.appendChild(lineNode);
        currentNode = lineNode;
        var oldNodeStack = nodeStack;
        nodeStack = [{ node: lineNode }];
        if (oldNodeStack.length > 1) {
          for (var i2 = 1; i2 < oldNodeStack.length; i2++) {
            enterNode(oldNodeStack[i2]);
          }
        }
      }
      function enterNode(nodeSpec2) {
        var type = nodeSpec2.type;
        var nodeAttrs = {};
        var nodeType;
        if (type === "a") {
          nodeType = "a";
          var target = nodeSpec2.target;
          var href2 = nodeSpec2.href;
          var popup = nodeSpec2.popup;
          if (href2) {
            nodeAttrs = {
              "xlink:xlink:show": target === "_blank" || target.charAt(0) !== "_" ? "new" : "replace",
              target,
              "xlink:xlink:href": href2
            };
            if (popup) {
              nodeAttrs.onclick = 'window.open(this.href.baseVal,this.target.baseVal,"' + popup + '");return false;';
            }
          }
        } else nodeType = "tspan";
        if (nodeSpec2.style) nodeAttrs.style = nodeSpec2.style;
        var newNode = document.createElementNS(xmlnsNamespaces.svg, nodeType);
        if (type === "sup" || type === "sub") {
          addTextNode(currentNode, ZERO_WIDTH_SPACE);
          currentNode.appendChild(newNode);
          var resetter = document.createElementNS(xmlnsNamespaces.svg, "tspan");
          addTextNode(resetter, ZERO_WIDTH_SPACE);
          d3.select(resetter).attr("dy", RESET_DY[type]);
          nodeAttrs.dy = SHIFT_DY[type];
          currentNode.appendChild(newNode);
          currentNode.appendChild(resetter);
        } else {
          currentNode.appendChild(newNode);
        }
        d3.select(newNode).attr(nodeAttrs);
        currentNode = nodeSpec2.node = newNode;
        nodeStack.push(nodeSpec2);
      }
      function addTextNode(node, text) {
        node.appendChild(document.createTextNode(text));
      }
      function exitNode(type) {
        if (nodeStack.length === 1) {
          Lib.log("Ignoring unexpected end tag </" + type + ">.", str);
          return;
        }
        var innerNode = nodeStack.pop();
        if (type !== innerNode.type) {
          Lib.log("Start tag <" + innerNode.type + "> doesnt match end tag <" + type + ">. Pretending it did match.", str);
        }
        currentNode = nodeStack[nodeStack.length - 1].node;
      }
      var hasLines = BR_TAG.test(str);
      if (hasLines) newLine();
      else {
        currentNode = containerNode;
        nodeStack = [{ node: containerNode }];
      }
      var parts = str.split(SPLIT_TAGS);
      for (var i = 0; i < parts.length; i++) {
        var parti = parts[i];
        var match = parti.match(ONE_TAG);
        var tagType = match && match[2].toLowerCase();
        var tagStyle = TAG_STYLES[tagType];
        if (tagType === "br") {
          newLine();
        } else if (tagStyle === void 0) {
          addTextNode(currentNode, convertEntities(parti));
        } else {
          if (match[1]) {
            exitNode(tagType);
          } else {
            var extra = match[4];
            var nodeSpec = { type: tagType };
            var css = getQuotedMatch(extra, STYLEMATCH);
            if (css) {
              css = css.replace(COLORMATCH, "$1 fill:");
              if (tagStyle) css += ";" + tagStyle;
            } else if (tagStyle) css = tagStyle;
            if (css) nodeSpec.style = css;
            if (tagType === "a") {
              hasLink = true;
              var href = getQuotedMatch(extra, HREFMATCH);
              if (href) {
                var safeHref = sanitizeHref(href);
                if (safeHref) {
                  nodeSpec.href = safeHref;
                  nodeSpec.target = getQuotedMatch(extra, TARGETMATCH) || "_blank";
                  nodeSpec.popup = getQuotedMatch(extra, POPUPMATCH);
                }
              }
            }
            enterNode(nodeSpec);
          }
        }
      }
      return hasLink;
    }
    function sanitizeHref(href) {
      var decodedHref = encodeURI(decodeURI(href));
      var dummyAnchor1 = document.createElement("a");
      var dummyAnchor2 = document.createElement("a");
      dummyAnchor1.href = href;
      dummyAnchor2.href = decodedHref;
      var p12 = dummyAnchor1.protocol;
      var p2 = dummyAnchor2.protocol;
      if (PROTOCOLS.indexOf(p12) !== -1 && PROTOCOLS.indexOf(p2) !== -1) {
        return decodedHref;
      } else {
        return "";
      }
    }
    exports2.sanitizeHTML = function sanitizeHTML(str) {
      str = str.replace(NEWLINES, " ");
      var rootNode = document.createElement("p");
      var currentNode = rootNode;
      var nodeStack = [];
      var parts = str.split(SPLIT_TAGS);
      for (var i = 0; i < parts.length; i++) {
        var parti = parts[i];
        var match = parti.match(ONE_TAG);
        var tagType = match && match[2].toLowerCase();
        if (tagType in TAG_STYLES) {
          if (match[1]) {
            if (nodeStack.length) {
              currentNode = nodeStack.pop();
            }
          } else {
            var extra = match[4];
            var css = getQuotedMatch(extra, STYLEMATCH);
            var nodeAttrs = css ? { style: css } : {};
            if (tagType === "a") {
              var href = getQuotedMatch(extra, HREFMATCH);
              if (href) {
                var safeHref = sanitizeHref(href);
                if (safeHref) {
                  nodeAttrs.href = safeHref;
                  var target = getQuotedMatch(extra, TARGETMATCH);
                  if (target) {
                    nodeAttrs.target = target;
                  }
                }
              }
            }
            var newNode = document.createElement(tagType);
            currentNode.appendChild(newNode);
            d3.select(newNode).attr(nodeAttrs);
            currentNode = newNode;
            nodeStack.push(newNode);
          }
        } else {
          currentNode.appendChild(
            document.createTextNode(convertEntities(parti))
          );
        }
      }
      var key = "innerHTML";
      return rootNode[key];
    };
    exports2.lineCount = function lineCount(s) {
      return s.selectAll("tspan.line").size() || 1;
    };
    exports2.positionText = function positionText(s, x, y) {
      return s.each(function() {
        var text = d3.select(this);
        function setOrGet(attr, val) {
          if (val === void 0) {
            val = text.attr(attr);
            if (val === null) {
              text.attr(attr, 0);
              val = 0;
            }
          } else text.attr(attr, val);
          return val;
        }
        var thisX = setOrGet("x", x);
        var thisY = setOrGet("y", y);
        if (this.nodeName === "text") {
          text.selectAll("tspan.line").attr({ x: thisX, y: thisY });
        }
      });
    };
    function alignHTMLWith(_base, container, options) {
      var alignH = options.horizontalAlign;
      var alignV = options.verticalAlign || "top";
      var bRect = _base.node().getBoundingClientRect();
      var cRect = container.node().getBoundingClientRect();
      var thisRect;
      var getTop;
      var getLeft;
      if (alignV === "bottom") {
        getTop = function() {
          return bRect.bottom - thisRect.height;
        };
      } else if (alignV === "middle") {
        getTop = function() {
          return bRect.top + (bRect.height - thisRect.height) / 2;
        };
      } else {
        getTop = function() {
          return bRect.top;
        };
      }
      if (alignH === "right") {
        getLeft = function() {
          return bRect.right - thisRect.width;
        };
      } else if (alignH === "center") {
        getLeft = function() {
          return bRect.left + (bRect.width - thisRect.width) / 2;
        };
      } else {
        getLeft = function() {
          return bRect.left;
        };
      }
      return function() {
        thisRect = this.node().getBoundingClientRect();
        var x02 = getLeft() - cRect.left;
        var y02 = getTop() - cRect.top;
        var gd2 = options.gd || {};
        if (options.gd) {
          gd2._fullLayout._calcInverseTransform(gd2);
          var transformedCoords = Lib.apply3DTransform(gd2._fullLayout._invTransform)(x02, y02);
          x02 = transformedCoords[0];
          y02 = transformedCoords[1];
        }
        this.style({
          top: y02 + "px",
          left: x02 + "px",
          "z-index": 1e3
        });
        return this;
      };
    }
    var onePx = "1px ";
    exports2.makeTextShadow = function(color) {
      var x = onePx;
      var y = onePx;
      var b = onePx;
      return x + y + b + color + ", -" + x + "-" + y + b + color + ", " + x + "-" + y + b + color + ", -" + x + y + b + color;
    };
    exports2.makeEditable = function(context, options) {
      var gd2 = options.gd;
      var _delegate = options.delegate;
      var dispatch = d3.dispatch("edit", "input", "cancel");
      var handlerElement = _delegate || context;
      context.style({ "pointer-events": _delegate ? "none" : "all" });
      if (context.size() !== 1) throw new Error("boo");
      function handleClick() {
        appendEditable();
        context.style({ opacity: 0 });
        var svgClass = handlerElement.attr("class");
        var mathjaxClass;
        if (svgClass) mathjaxClass = "." + svgClass.split(" ")[0] + "-math-group";
        else mathjaxClass = "[class*=-math-group]";
        if (mathjaxClass) {
          d3.select(context.node().parentNode).select(mathjaxClass).style({ opacity: 0 });
        }
      }
      function selectElementContents(_el) {
        var el = _el.node();
        var range = document.createRange();
        range.selectNodeContents(el);
        var sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange(range);
        el.focus();
      }
      function appendEditable() {
        var plotDiv = d3.select(gd2);
        var container = plotDiv.select(".svg-container");
        var div = container.append("div");
        var cStyle = context.node().style;
        var fontSize = parseFloat(cStyle.fontSize || 12);
        var initialText = options.text;
        if (initialText === void 0) initialText = context.attr("data-unformatted");
        div.classed("plugin-editable editable", true).style({
          position: "absolute",
          "font-family": cStyle.fontFamily || "Arial",
          "font-size": fontSize,
          color: options.fill || cStyle.fill || "black",
          opacity: 1,
          "background-color": options.background || "transparent",
          outline: "#ffffff33 1px solid",
          margin: [-fontSize / 8 + 1, 0, 0, -1].join("px ") + "px",
          padding: "0",
          "box-sizing": "border-box"
        }).attr({ contenteditable: true }).text(initialText).call(alignHTMLWith(context, container, options)).on("blur", function() {
          gd2._editing = false;
          context.text(this.textContent).style({ opacity: 1 });
          var svgClass = d3.select(this).attr("class");
          var mathjaxClass;
          if (svgClass) mathjaxClass = "." + svgClass.split(" ")[0] + "-math-group";
          else mathjaxClass = "[class*=-math-group]";
          if (mathjaxClass) {
            d3.select(context.node().parentNode).select(mathjaxClass).style({ opacity: 0 });
          }
          var text = this.textContent;
          d3.select(this).transition().duration(0).remove();
          d3.select(document).on("mouseup", null);
          dispatch.edit.call(context, text);
        }).on("focus", function() {
          var editDiv = this;
          gd2._editing = true;
          d3.select(document).on("mouseup", function() {
            if (d3.event.target === editDiv) return false;
            if (document.activeElement === div.node()) div.node().blur();
          });
        }).on("keyup", function() {
          if (d3.event.which === 27) {
            gd2._editing = false;
            context.style({ opacity: 1 });
            d3.select(this).style({ opacity: 0 }).on("blur", function() {
              return false;
            }).transition().remove();
            dispatch.cancel.call(context, this.textContent);
          } else {
            dispatch.input.call(context, this.textContent);
            d3.select(this).call(alignHTMLWith(context, container, options));
          }
        }).on("keydown", function() {
          if (d3.event.which === 13) this.blur();
        }).call(selectElementContents);
      }
      if (options.immediate) handleClick();
      else handlerElement.on("click", handleClick);
      return d3.rebind(context, dispatch, "on");
    };
  }
});

// node_modules/plotly.js/src/components/colorscale/helpers.js
var require_helpers = __commonJS({
  "node_modules/plotly.js/src/components/colorscale/helpers.js"(exports2, module2) {
    "use strict";
    var d3 = require_d3();
    var tinycolor = require_tinycolor();
    var isNumeric = require_fast_isnumeric();
    var Lib = require_lib();
    var Color = require_color();
    var isValidScale = require_scales().isValid;
    function hasColorscale(trace, containerStr, colorKey) {
      var container = containerStr ? Lib.nestedProperty(trace, containerStr).get() || {} : trace;
      var color = container[colorKey || "color"];
      if (color && color._inputArray) color = color._inputArray;
      var isArrayWithOneNumber = false;
      if (Lib.isArrayOrTypedArray(color)) {
        for (var i = 0; i < color.length; i++) {
          if (isNumeric(color[i])) {
            isArrayWithOneNumber = true;
            break;
          }
        }
      }
      return Lib.isPlainObject(container) && (isArrayWithOneNumber || container.showscale === true || isNumeric(container.cmin) && isNumeric(container.cmax) || isValidScale(container.colorscale) || Lib.isPlainObject(container.colorbar));
    }
    var constantAttrs = ["showscale", "autocolorscale", "colorscale", "reversescale", "colorbar"];
    var letterAttrs = ["min", "max", "mid", "auto"];
    function extractOpts(cont) {
      var colorAx = cont._colorAx;
      var cont2 = colorAx ? colorAx : cont;
      var out = {};
      var cLetter;
      var i, k;
      for (i = 0; i < constantAttrs.length; i++) {
        k = constantAttrs[i];
        out[k] = cont2[k];
      }
      if (colorAx) {
        cLetter = "c";
        for (i = 0; i < letterAttrs.length; i++) {
          k = letterAttrs[i];
          out[k] = cont2["c" + k];
        }
      } else {
        var k2;
        for (i = 0; i < letterAttrs.length; i++) {
          k = letterAttrs[i];
          k2 = "c" + k;
          if (k2 in cont2) {
            out[k] = cont2[k2];
            continue;
          }
          k2 = "z" + k;
          if (k2 in cont2) {
            out[k] = cont2[k2];
          }
        }
        cLetter = k2.charAt(0);
      }
      out._sync = function(k3, v) {
        var k22 = letterAttrs.indexOf(k3) !== -1 ? cLetter + k3 : k3;
        cont2[k22] = cont2["_" + k22] = v;
      };
      return out;
    }
    function extractScale(cont) {
      var cOpts = extractOpts(cont);
      var cmin = cOpts.min;
      var cmax = cOpts.max;
      var scl = cOpts.reversescale ? flipScale(cOpts.colorscale) : cOpts.colorscale;
      var N = scl.length;
      var domain = new Array(N);
      var range = new Array(N);
      for (var i = 0; i < N; i++) {
        var si2 = scl[i];
        domain[i] = cmin + si2[0] * (cmax - cmin);
        range[i] = si2[1];
      }
      return { domain, range };
    }
    function flipScale(scl) {
      var N = scl.length;
      var sclNew = new Array(N);
      for (var i = N - 1, j = 0; i >= 0; i--, j++) {
        var si2 = scl[i];
        sclNew[j] = [1 - si2[0], si2[1]];
      }
      return sclNew;
    }
    function makeColorScaleFunc(specs, opts) {
      opts = opts || {};
      var domain = specs.domain;
      var range = specs.range;
      var N = range.length;
      var _range = new Array(N);
      for (var i = 0; i < N; i++) {
        var rgba = tinycolor(range[i]).toRgb();
        _range[i] = [rgba.r, rgba.g, rgba.b, rgba.a];
      }
      var _sclFunc = d3.scale.linear().domain(domain).range(_range).clamp(true);
      var noNumericCheck = opts.noNumericCheck;
      var returnArray = opts.returnArray;
      var sclFunc;
      if (noNumericCheck && returnArray) {
        sclFunc = _sclFunc;
      } else if (noNumericCheck) {
        sclFunc = function(v) {
          return colorArray2rbga(_sclFunc(v));
        };
      } else if (returnArray) {
        sclFunc = function(v) {
          if (isNumeric(v)) return _sclFunc(v);
          else if (tinycolor(v).isValid()) return v;
          else return Color.defaultLine;
        };
      } else {
        sclFunc = function(v) {
          if (isNumeric(v)) return colorArray2rbga(_sclFunc(v));
          else if (tinycolor(v).isValid()) return v;
          else return Color.defaultLine;
        };
      }
      sclFunc.domain = _sclFunc.domain;
      sclFunc.range = function() {
        return range;
      };
      return sclFunc;
    }
    function makeColorScaleFuncFromTrace(trace, opts) {
      return makeColorScaleFunc(extractScale(trace), opts);
    }
    function colorArray2rbga(colorArray) {
      var colorObj = {
        r: colorArray[0],
        g: colorArray[1],
        b: colorArray[2],
        a: colorArray[3]
      };
      return tinycolor(colorObj).toRgbString();
    }
    module2.exports = {
      hasColorscale,
      extractOpts,
      extractScale,
      flipScale,
      makeColorScaleFunc,
      makeColorScaleFuncFromTrace
    };
  }
});

// node_modules/plotly.js/src/plots/cartesian/axis_format_attributes.js
var require_axis_format_attributes = __commonJS({
  "node_modules/plotly.js/src/plots/cartesian/axis_format_attributes.js"(exports2, module2) {
    "use strict";
    var docs = require_docs();
    var FORMAT_LINK = docs.FORMAT_LINK;
    var DATE_FORMAT_LINK = docs.DATE_FORMAT_LINK;
    function axisHoverFormat(x, noDates) {
      return {
        valType: "string",
        dflt: "",
        editType: "none",
        description: (noDates ? descriptionOnlyNumbers : descriptionWithDates)("hover text", x) + [
          "By default the values are formatted using " + (noDates ? "generic number format" : "`" + x + "axis.hoverformat`") + "."
        ].join(" ")
      };
    }
    function descriptionOnlyNumbers(label, x) {
      return [
        "Sets the " + label + " formatting rule" + (x ? "for `" + x + "` " : ""),
        "using d3 formatting mini-languages",
        "which are very similar to those in Python. For numbers, see: " + FORMAT_LINK + "."
      ].join(" ");
    }
    function descriptionWithDates(label, x) {
      return descriptionOnlyNumbers(label, x) + [
        " And for dates see: " + DATE_FORMAT_LINK + ".",
        "We add two items to d3's date formatter:",
        "*%h* for half of the year as a decimal number as well as",
        "*%{n}f* for fractional seconds",
        "with n digits. For example, *2016-10-13 09:15:23.456* with tickformat",
        "*%H~%M~%S.%2f* would display *09~15~23.46*"
      ].join(" ");
    }
    module2.exports = {
      axisHoverFormat,
      descriptionOnlyNumbers,
      descriptionWithDates
    };
  }
});

// node_modules/plotly.js/src/plots/cartesian/layout_attributes.js
var require_layout_attributes4 = __commonJS({
  "node_modules/plotly.js/src/plots/cartesian/layout_attributes.js"(exports2, module2) {
    "use strict";
    var fontAttrs = require_font_attributes();
    var colorAttrs = require_attributes3();
    var dash = require_attributes4().dash;
    var extendFlat = require_extend().extendFlat;
    var templatedArray = require_plot_template().templatedArray;
    var descriptionWithDates = require_axis_format_attributes().descriptionWithDates;
    var ONEDAY = require_numerical().ONEDAY;
    var constants = require_constants2();
    var HOUR = constants.HOUR_PATTERN;
    var DAY_OF_WEEK = constants.WEEKDAY_PATTERN;
    var minorTickmode = {
      valType: "enumerated",
      values: ["auto", "linear", "array"],
      editType: "ticks",
      impliedEdits: { tick0: void 0, dtick: void 0 },
      description: [
        "Sets the tick mode for this axis.",
        "If *auto*, the number of ticks is set via `nticks`.",
        "If *linear*, the placement of the ticks is determined by",
        "a starting position `tick0` and a tick step `dtick`",
        "(*linear* is the default value if `tick0` and `dtick` are provided).",
        "If *array*, the placement of the ticks is set via `tickvals`",
        "and the tick text is `ticktext`.",
        "(*array* is the default value if `tickvals` is provided)."
      ].join(" ")
    };
    var tickmode = extendFlat({}, minorTickmode, {
      values: minorTickmode.values.slice().concat(["sync"]),
      description: [
        minorTickmode.description,
        "If *sync*, the number of ticks will sync with the overlayed axis",
        "set by `overlaying` property."
      ].join(" ")
    });
    function makeNticks(minor) {
      return {
        valType: "integer",
        min: 0,
        dflt: minor ? 5 : 0,
        editType: "ticks",
        description: [
          "Specifies the maximum number of ticks for the particular axis.",
          "The actual number of ticks will be chosen automatically to be",
          "less than or equal to `nticks`.",
          "Has an effect only if `tickmode` is set to *auto*."
        ].join(" ")
      };
    }
    var tick0 = {
      valType: "any",
      editType: "ticks",
      impliedEdits: { tickmode: "linear" },
      description: [
        "Sets the placement of the first tick on this axis.",
        "Use with `dtick`.",
        "If the axis `type` is *log*, then you must take the log of your starting tick",
        "(e.g. to set the starting tick to 100, set the `tick0` to 2)",
        "except when `dtick`=*L<f>* (see `dtick` for more info).",
        "If the axis `type` is *date*, it should be a date string, like date data.",
        "If the axis `type` is *category*, it should be a number, using the scale where",
        "each category is assigned a serial number from zero in the order it appears."
      ].join(" ")
    };
    var dtick = {
      valType: "any",
      editType: "ticks",
      impliedEdits: { tickmode: "linear" },
      description: [
        "Sets the step in-between ticks on this axis. Use with `tick0`.",
        "Must be a positive number, or special strings available to *log* and *date* axes.",
        "If the axis `type` is *log*, then ticks are set every 10^(n*dtick) where n",
        "is the tick number. For example,",
        "to set a tick mark at 1, 10, 100, 1000, ... set dtick to 1.",
        "To set tick marks at 1, 100, 10000, ... set dtick to 2.",
        "To set tick marks at 1, 5, 25, 125, 625, 3125, ... set dtick to log_10(5), or 0.69897000433.",
        "*log* has several special values; *L<f>*, where `f` is a positive number,",
        "gives ticks linearly spaced in value (but not position).",
        "For example `tick0` = 0.1, `dtick` = *L0.5* will put ticks at 0.1, 0.6, 1.1, 1.6 etc.",
        "To show powers of 10 plus small digits between, use *D1* (all digits) or *D2* (only 2 and 5).",
        "`tick0` is ignored for *D1* and *D2*.",
        "If the axis `type` is *date*, then you must convert the time to milliseconds.",
        "For example, to set the interval between ticks to one day,",
        "set `dtick` to 86400000.0.",
        "*date* also has special values *M<n>* gives ticks spaced by a number of months.",
        "`n` must be a positive integer.",
        "To set ticks on the 15th of every third month, set `tick0` to *2000-01-15* and `dtick` to *M3*.",
        "To set ticks every 4 years, set `dtick` to *M48*"
      ].join(" ")
    };
    var tickvals = {
      valType: "data_array",
      editType: "ticks",
      description: [
        "Sets the values at which ticks on this axis appear.",
        "Only has an effect if `tickmode` is set to *array*.",
        "Used with `ticktext`."
      ].join(" ")
    };
    var ticks = {
      valType: "enumerated",
      values: ["outside", "inside", ""],
      editType: "ticks",
      description: [
        "Determines whether ticks are drawn or not.",
        "If **, this axis' ticks are not drawn.",
        "If *outside* (*inside*), this axis' are drawn outside (inside)",
        "the axis lines."
      ].join(" ")
    };
    function makeTicklen(minor) {
      var obj = {
        valType: "number",
        min: 0,
        editType: "ticks",
        description: "Sets the tick length (in px)."
      };
      if (!minor) obj.dflt = 5;
      return obj;
    }
    function makeTickwidth(minor) {
      var obj = {
        valType: "number",
        min: 0,
        editType: "ticks",
        description: "Sets the tick width (in px)."
      };
      if (!minor) obj.dflt = 1;
      return obj;
    }
    var tickcolor = {
      valType: "color",
      dflt: colorAttrs.defaultLine,
      editType: "ticks",
      description: "Sets the tick color."
    };
    var gridcolor = {
      valType: "color",
      dflt: colorAttrs.lightLine,
      editType: "ticks",
      description: "Sets the color of the grid lines."
    };
    function makeGridwidth(minor) {
      var obj = {
        valType: "number",
        min: 0,
        editType: "ticks",
        description: "Sets the width (in px) of the grid lines."
      };
      if (!minor) obj.dflt = 1;
      return obj;
    }
    var griddash = extendFlat({}, dash, { editType: "ticks" });
    var showgrid = {
      valType: "boolean",
      editType: "ticks",
      description: [
        "Determines whether or not grid lines are drawn.",
        "If *true*, the grid lines are drawn at every tick mark."
      ].join(" ")
    };
    module2.exports = {
      visible: {
        valType: "boolean",
        editType: "plot",
        description: [
          "A single toggle to hide the axis while preserving interaction like dragging.",
          "Default is true when a cheater plot is present on the axis, otherwise",
          "false"
        ].join(" ")
      },
      color: {
        valType: "color",
        dflt: colorAttrs.defaultLine,
        editType: "ticks",
        description: [
          "Sets default for all colors associated with this axis",
          "all at once: line, font, tick, and grid colors.",
          "Grid color is lightened by blending this with the plot background",
          "Individual pieces can override this."
        ].join(" ")
      },
      title: {
        text: {
          valType: "string",
          editType: "ticks",
          description: [
            "Sets the title of this axis.",
            "Note that before the existence of `title.text`, the title's",
            "contents used to be defined as the `title` attribute itself.",
            "This behavior has been deprecated."
          ].join(" ")
        },
        font: fontAttrs({
          editType: "ticks",
          description: [
            "Sets this axis' title font.",
            "Note that the title's font used to be customized",
            "by the now deprecated `titlefont` attribute."
          ].join(" ")
        }),
        standoff: {
          valType: "number",
          min: 0,
          editType: "ticks",
          description: [
            "Sets the standoff distance (in px) between the axis labels and the title text",
            "The default value is a function of the axis tick labels, the title `font.size`",
            "and the axis `linewidth`.",
            "Note that the axis title position is always constrained within the margins,",
            "so the actual standoff distance is always less than the set or default value.",
            "By setting `standoff` and turning on `automargin`, plotly.js will push the",
            "margins to fit the axis title at given standoff distance."
          ].join(" ")
        },
        editType: "ticks"
      },
      type: {
        valType: "enumerated",
        // '-' means we haven't yet run autotype or couldn't find any data
        // it gets turned into linear in gd._fullLayout but not copied back
        // to gd.data like the others are.
        values: ["-", "linear", "log", "date", "category", "multicategory"],
        dflt: "-",
        editType: "calc",
        // we forget when an axis has been autotyped, just writing the auto
        // value back to the input - so it doesn't make sense to template this.
        // Note: we do NOT prohibit this in `coerce`, so if someone enters a
        // type in the template explicitly it will be honored as the default.
        _noTemplating: true,
        description: [
          "Sets the axis type.",
          "By default, plotly attempts to determined the axis type",
          "by looking into the data of the traces that referenced",
          "the axis in question."
        ].join(" ")
      },
      autotypenumbers: {
        valType: "enumerated",
        values: ["convert types", "strict"],
        dflt: "convert types",
        editType: "calc",
        description: [
          "Using *strict* a numeric string in trace data is not converted to a number.",
          "Using *convert types* a numeric string in trace data may be",
          "treated as a number during automatic axis `type` detection.",
          "Defaults to layout.autotypenumbers."
        ].join(" ")
      },
      autorange: {
        valType: "enumerated",
        values: [true, false, "reversed", "min reversed", "max reversed", "min", "max"],
        dflt: true,
        editType: "axrange",
        impliedEdits: { "range[0]": void 0, "range[1]": void 0 },
        description: [
          "Determines whether or not the range of this axis is",
          "computed in relation to the input data.",
          "See `rangemode` for more info.",
          "If `range` is provided and it has a value for both the",
          "lower and upper bound, `autorange` is set to *false*.",
          "Using *min* applies autorange only to set the minimum.",
          "Using *max* applies autorange only to set the maximum.",
          "Using *min reversed* applies autorange only to set the minimum on a reversed axis.",
          "Using *max reversed* applies autorange only to set the maximum on a reversed axis.",
          "Using *reversed* applies autorange on both ends and reverses the axis direction."
        ].join(" ")
      },
      autorangeoptions: {
        minallowed: {
          valType: "any",
          editType: "plot",
          impliedEdits: { "range[0]": void 0, "range[1]": void 0 },
          description: [
            "Use this value exactly as autorange minimum."
          ].join(" ")
        },
        maxallowed: {
          valType: "any",
          editType: "plot",
          impliedEdits: { "range[0]": void 0, "range[1]": void 0 },
          description: [
            "Use this value exactly as autorange maximum."
          ].join(" ")
        },
        clipmin: {
          valType: "any",
          editType: "plot",
          impliedEdits: { "range[0]": void 0, "range[1]": void 0 },
          description: [
            "Clip autorange minimum if it goes beyond this value.",
            "Has no effect when `autorangeoptions.minallowed` is provided."
          ].join(" ")
        },
        clipmax: {
          valType: "any",
          editType: "plot",
          impliedEdits: { "range[0]": void 0, "range[1]": void 0 },
          description: [
            "Clip autorange maximum if it goes beyond this value.",
            "Has no effect when `autorangeoptions.maxallowed` is provided."
          ].join(" ")
        },
        include: {
          valType: "any",
          arrayOk: true,
          editType: "plot",
          impliedEdits: { "range[0]": void 0, "range[1]": void 0 },
          description: [
            "Ensure this value is included in autorange."
          ].join(" ")
        },
        editType: "plot"
      },
      rangemode: {
        valType: "enumerated",
        values: ["normal", "tozero", "nonnegative"],
        dflt: "normal",
        editType: "plot",
        description: [
          "If *normal*, the range is computed in relation to the extrema",
          "of the input data.",
          "If *tozero*`, the range extends to 0,",
          "regardless of the input data",
          "If *nonnegative*, the range is non-negative,",
          "regardless of the input data.",
          "Applies only to linear axes."
        ].join(" ")
      },
      range: {
        valType: "info_array",
        items: [
          { valType: "any", editType: "axrange", impliedEdits: { "^autorange": false }, anim: true },
          { valType: "any", editType: "axrange", impliedEdits: { "^autorange": false }, anim: true }
        ],
        editType: "axrange",
        impliedEdits: { autorange: false },
        anim: true,
        description: [
          "Sets the range of this axis.",
          "If the axis `type` is *log*, then you must take the log of your",
          "desired range (e.g. to set the range from 1 to 100,",
          "set the range from 0 to 2).",
          "If the axis `type` is *date*, it should be date strings,",
          "like date data, though Date objects and unix milliseconds",
          "will be accepted and converted to strings.",
          "If the axis `type` is *category*, it should be numbers,",
          "using the scale where each category is assigned a serial",
          "number from zero in the order it appears.",
          "Leaving either or both elements `null` impacts the default `autorange`."
        ].join(" ")
      },
      minallowed: {
        valType: "any",
        editType: "plot",
        impliedEdits: { "^autorange": false },
        description: [
          "Determines the minimum range of this axis."
        ].join(" ")
      },
      maxallowed: {
        valType: "any",
        editType: "plot",
        impliedEdits: { "^autorange": false },
        description: [
          "Determines the maximum range of this axis."
        ].join(" ")
      },
      fixedrange: {
        valType: "boolean",
        dflt: false,
        editType: "calc",
        description: [
          "Determines whether or not this axis is zoom-able.",
          "If true, then zoom is disabled."
        ].join(" ")
      },
      insiderange: {
        valType: "info_array",
        items: [
          { valType: "any", editType: "plot" },
          { valType: "any", editType: "plot" }
        ],
        editType: "plot",
        description: [
          "Could be used to set the desired inside range of this axis",
          "(excluding the labels) when `ticklabelposition` of",
          "the anchored axis has *inside*.",
          "Not implemented for axes with `type` *log*.",
          "This would be ignored when `range` is provided."
        ].join(" ")
      },
      // scaleanchor: not used directly, just put here for reference
      // values are any opposite-letter axis id, or `false`.
      scaleanchor: {
        valType: "enumerated",
        values: [
          constants.idRegex.x.toString(),
          constants.idRegex.y.toString(),
          false
        ],
        editType: "plot",
        description: [
          "If set to another axis id (e.g. `x2`, `y`), the range of this axis",
          "changes together with the range of the corresponding axis",
          "such that the scale of pixels per unit is in a constant ratio.",
          "Both axes are still zoomable, but when you zoom one, the other will",
          "zoom the same amount, keeping a fixed midpoint.",
          "`constrain` and `constraintoward` determine how we enforce the constraint.",
          "You can chain these, ie `yaxis: {scaleanchor: *x*}, xaxis2: {scaleanchor: *y*}`",
          "but you can only link axes of the same `type`.",
          "The linked axis can have the opposite letter (to constrain the aspect ratio)",
          "or the same letter (to match scales across subplots).",
          "Loops (`yaxis: {scaleanchor: *x*}, xaxis: {scaleanchor: *y*}` or longer) are redundant",
          "and the last constraint encountered will be ignored to avoid possible",
          "inconsistent constraints via `scaleratio`.",
          "Note that setting axes simultaneously in both a `scaleanchor` and a `matches` constraint",
          "is currently forbidden.",
          "Setting `false` allows to remove a default constraint (occasionally,",
          "you may need to prevent a default `scaleanchor` constraint from",
          'being applied, eg. when having an image trace `yaxis: {scaleanchor: "x"}`',
          "is set automatically in order for pixels to be rendered as squares,",
          "setting `yaxis: {scaleanchor: false}` allows to remove the constraint)."
        ].join(" ")
      },
      scaleratio: {
        valType: "number",
        min: 0,
        dflt: 1,
        editType: "plot",
        description: [
          "If this axis is linked to another by `scaleanchor`, this determines the pixel",
          "to unit scale ratio. For example, if this value is 10, then every unit on",
          "this axis spans 10 times the number of pixels as a unit on the linked axis.",
          "Use this for example to create an elevation profile where the vertical scale",
          "is exaggerated a fixed amount with respect to the horizontal."
        ].join(" ")
      },
      constrain: {
        valType: "enumerated",
        values: ["range", "domain"],
        editType: "plot",
        description: [
          "If this axis needs to be compressed (either due to its own `scaleanchor` and",
          "`scaleratio` or those of the other axis), determines how that happens:",
          "by increasing the *range*, or by decreasing the *domain*.",
          "Default is *domain* for axes containing image traces, *range* otherwise."
        ].join(" ")
      },
      // constraintoward: not used directly, just put here for reference
      constraintoward: {
        valType: "enumerated",
        values: ["left", "center", "right", "top", "middle", "bottom"],
        editType: "plot",
        description: [
          "If this axis needs to be compressed (either due to its own `scaleanchor` and",
          "`scaleratio` or those of the other axis), determines which direction we push",
          "the originally specified plot area. Options are *left*, *center* (default),",
          "and *right* for x axes, and *top*, *middle* (default), and *bottom* for y axes."
        ].join(" ")
      },
      matches: {
        valType: "enumerated",
        values: [
          constants.idRegex.x.toString(),
          constants.idRegex.y.toString()
        ],
        editType: "calc",
        description: [
          "If set to another axis id (e.g. `x2`, `y`), the range of this axis",
          "will match the range of the corresponding axis in data-coordinates space.",
          "Moreover, matching axes share auto-range values, category lists and",
          "histogram auto-bins.",
          "Note that setting axes simultaneously in both a `scaleanchor` and a `matches` constraint",
          "is currently forbidden.",
          "Moreover, note that matching axes must have the same `type`."
        ].join(" ")
      },
      rangebreaks: templatedArray("rangebreak", {
        enabled: {
          valType: "boolean",
          dflt: true,
          editType: "calc",
          description: [
            "Determines whether this axis rangebreak is enabled or disabled.",
            "Please note that `rangebreaks` only work for *date* axis type."
          ].join(" ")
        },
        bounds: {
          valType: "info_array",
          items: [
            { valType: "any", editType: "calc" },
            { valType: "any", editType: "calc" }
          ],
          editType: "calc",
          description: [
            "Sets the lower and upper bounds of this axis rangebreak.",
            "Can be used with `pattern`."
          ].join(" ")
        },
        pattern: {
          valType: "enumerated",
          values: [DAY_OF_WEEK, HOUR, ""],
          editType: "calc",
          description: [
            "Determines a pattern on the time line that generates breaks.",
            "If *" + DAY_OF_WEEK + "* - days of the week in English e.g. 'Sunday' or `sun`",
            "(matching is case-insensitive and considers only the first three characters),",
            "as well as Sunday-based integers between 0 and 6.",
            "If *" + HOUR + "* - hour (24-hour clock) as decimal numbers between 0 and 24.",
            "for more info.",
            "Examples:",
            "- { pattern: '" + DAY_OF_WEEK + "', bounds: [6, 1] }",
            " or simply { bounds: ['sat', 'mon'] }",
            "  breaks from Saturday to Monday (i.e. skips the weekends).",
            "- { pattern: '" + HOUR + "', bounds: [17, 8] }",
            "  breaks from 5pm to 8am (i.e. skips non-work hours)."
          ].join(" ")
        },
        values: {
          valType: "info_array",
          freeLength: true,
          editType: "calc",
          items: {
            valType: "any",
            editType: "calc"
          },
          description: [
            "Sets the coordinate values corresponding to the rangebreaks.",
            "An alternative to `bounds`.",
            "Use `dvalue` to set the size of the values along the axis."
          ].join(" ")
        },
        dvalue: {
          // TODO could become 'any' to add support for 'months', 'years'
          valType: "number",
          editType: "calc",
          min: 0,
          dflt: ONEDAY,
          description: [
            "Sets the size of each `values` item.",
            "The default is one day in milliseconds."
          ].join(" ")
        },
        /*
        gap: {
            valType: 'number',
            min: 0,
            dflt: 0, // for *date* axes, maybe something else for *linear*
            editType: 'calc',
            description: [
                'Sets the gap distance between the start and the end of this rangebreak.',
                'Use with `gapmode` to set the unit of measurement.'
            ].join(' ')
        },
        gapmode: {
            valType: 'enumerated',
            values: ['pixels', 'fraction'],
            dflt: 'pixels',
            editType: 'calc',
            description: [
                'Determines if the `gap` value corresponds to a pixel length',
                'or a fraction of the plot area.'
            ].join(' ')
        },
        */
        // To complete https://github.com/plotly/plotly.js/issues/4210
        // we additionally need `gap` and make this work on *linear*, and
        // possibly all other cartesian axis types. We possibly would also need
        // some style attributes controlling the zig-zag on the corresponding
        // axis.
        editType: "calc"
      }),
      // ticks
      tickmode,
      nticks: makeNticks(),
      tick0,
      dtick,
      ticklabelstep: {
        valType: "integer",
        min: 1,
        dflt: 1,
        editType: "ticks",
        description: [
          "Sets the spacing between tick labels as compared to the spacing between ticks.",
          "A value of 1 (default) means each tick gets a label.",
          "A value of 2 means shows every 2nd label.",
          "A larger value n means only every nth tick is labeled.",
          "`tick0` determines which labels are shown.",
          "Not implemented for axes with `type` *log* or *multicategory*, or when `tickmode` is *array*."
        ].join(" ")
      },
      tickvals,
      ticktext: {
        valType: "data_array",
        editType: "ticks",
        description: [
          "Sets the text displayed at the ticks position via `tickvals`.",
          "Only has an effect if `tickmode` is set to *array*.",
          "Used with `tickvals`."
        ].join(" ")
      },
      ticks,
      tickson: {
        valType: "enumerated",
        values: ["labels", "boundaries"],
        dflt: "labels",
        editType: "ticks",
        description: [
          "Determines where ticks and grid lines are drawn with respect to their",
          "corresponding tick labels.",
          "Only has an effect for axes of `type` *category* or *multicategory*.",
          "When set to *boundaries*, ticks and grid lines are drawn half a category",
          "to the left/bottom of labels."
        ].join(" ")
      },
      ticklabelmode: {
        valType: "enumerated",
        values: ["instant", "period"],
        dflt: "instant",
        editType: "ticks",
        description: [
          "Determines where tick labels are drawn with respect to their",
          "corresponding ticks and grid lines.",
          "Only has an effect for axes of `type` *date*",
          "When set to *period*, tick labels are drawn in the middle of the period",
          "between ticks."
        ].join(" ")
      },
      // ticklabelposition: not used directly, as values depend on direction (similar to side)
      // left/right options are for x axes, and top/bottom options are for y axes
      ticklabelposition: {
        valType: "enumerated",
        values: [
          "outside",
          "inside",
          "outside top",
          "inside top",
          "outside left",
          "inside left",
          "outside right",
          "inside right",
          "outside bottom",
          "inside bottom"
        ],
        dflt: "outside",
        editType: "calc",
        description: [
          "Determines where tick labels are drawn with respect to the axis",
          "Please note that",
          "top or bottom has no effect on x axes or when `ticklabelmode` is set to *period*.",
          "Similarly",
          "left or right has no effect on y axes or when `ticklabelmode` is set to *period*.",
          "Has no effect on *multicategory* axes or when `tickson` is set to *boundaries*.",
          "When used on axes linked by `matches` or `scaleanchor`,",
          "no extra padding for inside labels would be added by autorange,",
          "so that the scales could match."
        ].join(" ")
      },
      ticklabeloverflow: {
        valType: "enumerated",
        values: [
          "allow",
          "hide past div",
          "hide past domain"
        ],
        editType: "calc",
        description: [
          "Determines how we handle tick labels that would overflow either the graph div or the domain of the axis.",
          "The default value for inside tick labels is *hide past domain*.",
          "Otherwise on *category* and *multicategory* axes the default is *allow*.",
          "In other cases the default is *hide past div*."
        ].join(" ")
      },
      ticklabelshift: {
        valType: "integer",
        dflt: 0,
        editType: "ticks",
        description: [
          "Shifts the tick labels by the specified number of pixels in parallel to the axis.",
          "Positive values move the labels in the positive direction of the axis."
        ].join(" ")
      },
      ticklabelstandoff: {
        valType: "integer",
        dflt: 0,
        editType: "ticks",
        description: [
          "Sets the standoff distance (in px) between the axis tick labels and their default position.",
          "A positive `ticklabelstandoff` moves the labels farther away from the plot area",
          "if `ticklabelposition` is *outside*, and deeper into the plot area if",
          "`ticklabelposition` is *inside*. A negative `ticklabelstandoff` works in the opposite",
          "direction, moving outside ticks towards the plot area and inside ticks towards",
          "the outside. If the negative value is large enough, inside ticks can even end up",
          "outside and vice versa."
        ].join(" ")
      },
      ticklabelindex: {
        // in the future maybe add `extras: ['all', 'minor']` to allow showing labels for all ticks
        // or for all minor ticks.
        valType: "integer",
        arrayOk: true,
        editType: "calc",
        description: [
          "Only for axes with `type` *date* or *linear*.",
          "Instead of drawing the major tick label, draw the label for the minor tick",
          "that is n positions away from the major tick. E.g. to always draw the label for the",
          "minor tick before each major tick, choose `ticklabelindex` -1. This is useful for date",
          "axes with `ticklabelmode` *period* if you want to label the period that ends with each",
          "major tick instead of the period that begins there."
        ].join(" ")
      },
      mirror: {
        valType: "enumerated",
        values: [true, "ticks", false, "all", "allticks"],
        dflt: false,
        editType: "ticks+layoutstyle",
        description: [
          "Determines if the axis lines or/and ticks are mirrored to",
          "the opposite side of the plotting area.",
          "If *true*, the axis lines are mirrored.",
          "If *ticks*, the axis lines and ticks are mirrored.",
          "If *false*, mirroring is disable.",
          "If *all*, axis lines are mirrored on all shared-axes subplots.",
          "If *allticks*, axis lines and ticks are mirrored",
          "on all shared-axes subplots."
        ].join(" ")
      },
      ticklen: makeTicklen(),
      tickwidth: makeTickwidth(),
      tickcolor,
      showticklabels: {
        valType: "boolean",
        dflt: true,
        editType: "ticks",
        description: "Determines whether or not the tick labels are drawn."
      },
      labelalias: {
        valType: "any",
        dflt: false,
        editType: "ticks",
        description: [
          "Replacement text for specific tick or hover labels.",
          "For example using {US: 'USA', CA: 'Canada'} changes US to USA",
          "and CA to Canada. The labels we would have shown must match",
          "the keys exactly, after adding any tickprefix or ticksuffix.",
          "For negative numbers the minus sign symbol used (U+2212) is wider than the regular ascii dash.",
          "That means you need to use −1 instead of -1.",
          "labelalias can be used with any axis type, and both keys (if needed)",
          "and values (if desired) can include html-like tags or MathJax."
        ].join(" ")
      },
      automargin: {
        valType: "flaglist",
        flags: ["height", "width", "left", "right", "top", "bottom"],
        extras: [true, false],
        dflt: false,
        editType: "ticks",
        description: [
          "Determines whether long tick labels automatically grow the figure",
          "margins."
        ].join(" ")
      },
      showspikes: {
        valType: "boolean",
        dflt: false,
        editType: "modebar",
        description: [
          "Determines whether or not spikes (aka droplines) are drawn for this axis.",
          "Note: This only takes affect when hovermode = closest"
        ].join(" ")
      },
      spikecolor: {
        valType: "color",
        dflt: null,
        editType: "none",
        description: "Sets the spike color. If undefined, will use the series color"
      },
      spikethickness: {
        valType: "number",
        dflt: 3,
        editType: "none",
        description: "Sets the width (in px) of the zero line."
      },
      spikedash: extendFlat({}, dash, { dflt: "dash", editType: "none" }),
      spikemode: {
        valType: "flaglist",
        flags: ["toaxis", "across", "marker"],
        dflt: "toaxis",
        editType: "none",
        description: [
          "Determines the drawing mode for the spike line",
          "If *toaxis*, the line is drawn from the data point to the axis the ",
          "series is plotted on.",
          "If *across*, the line is drawn across the entire plot area, and",
          "supercedes *toaxis*.",
          "If *marker*, then a marker dot is drawn on the axis the series is",
          "plotted on"
        ].join(" ")
      },
      spikesnap: {
        valType: "enumerated",
        values: ["data", "cursor", "hovered data"],
        dflt: "hovered data",
        editType: "none",
        description: "Determines whether spikelines are stuck to the cursor or to the closest datapoints."
      },
      tickfont: fontAttrs({
        editType: "ticks",
        description: "Sets the tick font."
      }),
      tickangle: {
        valType: "angle",
        dflt: "auto",
        editType: "ticks",
        description: [
          "Sets the angle of the tick labels with respect to the horizontal.",
          "For example, a `tickangle` of -90 draws the tick labels",
          "vertically."
        ].join(" ")
      },
      autotickangles: {
        valType: "info_array",
        freeLength: true,
        items: {
          valType: "angle"
        },
        dflt: [0, 30, 90],
        editType: "ticks",
        description: [
          "When `tickangle` is set to *auto*, it will be set to the first",
          "angle in this array that is large enough to prevent label",
          "overlap."
        ].join(" ")
      },
      tickprefix: {
        valType: "string",
        dflt: "",
        editType: "ticks",
        description: "Sets a tick label prefix."
      },
      showtickprefix: {
        valType: "enumerated",
        values: ["all", "first", "last", "none"],
        dflt: "all",
        editType: "ticks",
        description: [
          "If *all*, all tick labels are displayed with a prefix.",
          "If *first*, only the first tick is displayed with a prefix.",
          "If *last*, only the last tick is displayed with a suffix.",
          "If *none*, tick prefixes are hidden."
        ].join(" ")
      },
      ticksuffix: {
        valType: "string",
        dflt: "",
        editType: "ticks",
        description: "Sets a tick label suffix."
      },
      showticksuffix: {
        valType: "enumerated",
        values: ["all", "first", "last", "none"],
        dflt: "all",
        editType: "ticks",
        description: "Same as `showtickprefix` but for tick suffixes."
      },
      showexponent: {
        valType: "enumerated",
        values: ["all", "first", "last", "none"],
        dflt: "all",
        editType: "ticks",
        description: [
          "If *all*, all exponents are shown besides their significands.",
          "If *first*, only the exponent of the first tick is shown.",
          "If *last*, only the exponent of the last tick is shown.",
          "If *none*, no exponents appear."
        ].join(" ")
      },
      exponentformat: {
        valType: "enumerated",
        values: ["none", "e", "E", "power", "SI", "B"],
        dflt: "B",
        editType: "ticks",
        description: [
          "Determines a formatting rule for the tick exponents.",
          "For example, consider the number 1,000,000,000.",
          "If *none*, it appears as 1,000,000,000.",
          "If *e*, 1e+9.",
          "If *E*, 1E+9.",
          "If *power*, 1x10^9 (with 9 in a super script).",
          "If *SI*, 1G.",
          "If *B*, 1B."
        ].join(" ")
      },
      minexponent: {
        valType: "number",
        dflt: 3,
        min: 0,
        editType: "ticks",
        description: [
          "Hide SI prefix for 10^n if |n| is below this number.",
          "This only has an effect when `tickformat` is *SI* or *B*."
        ].join(" ")
      },
      separatethousands: {
        valType: "boolean",
        dflt: false,
        editType: "ticks",
        description: [
          'If "true", even 4-digit integers are separated'
        ].join(" ")
      },
      tickformat: {
        valType: "string",
        dflt: "",
        editType: "ticks",
        description: descriptionWithDates("tick label")
      },
      tickformatstops: templatedArray("tickformatstop", {
        enabled: {
          valType: "boolean",
          dflt: true,
          editType: "ticks",
          description: [
            "Determines whether or not this stop is used.",
            "If `false`, this stop is ignored even within its `dtickrange`."
          ].join(" ")
        },
        dtickrange: {
          valType: "info_array",
          items: [
            { valType: "any", editType: "ticks" },
            { valType: "any", editType: "ticks" }
          ],
          editType: "ticks",
          description: [
            "range [*min*, *max*], where *min*, *max* - dtick values",
            "which describe some zoom level, it is possible to omit *min*",
            "or *max* value by passing *null*"
          ].join(" ")
        },
        value: {
          valType: "string",
          dflt: "",
          editType: "ticks",
          description: [
            "string - dtickformat for described zoom level, the same as *tickformat*"
          ].join(" ")
        },
        editType: "ticks"
      }),
      hoverformat: {
        valType: "string",
        dflt: "",
        editType: "none",
        description: descriptionWithDates("hover text")
      },
      // lines and grids
      showline: {
        valType: "boolean",
        dflt: false,
        editType: "ticks+layoutstyle",
        description: [
          "Determines whether or not a line bounding this axis is drawn."
        ].join(" ")
      },
      linecolor: {
        valType: "color",
        dflt: colorAttrs.defaultLine,
        editType: "layoutstyle",
        description: "Sets the axis line color."
      },
      linewidth: {
        valType: "number",
        min: 0,
        dflt: 1,
        editType: "ticks+layoutstyle",
        description: "Sets the width (in px) of the axis line."
      },
      showgrid,
      gridcolor,
      gridwidth: makeGridwidth(),
      griddash,
      zeroline: {
        valType: "boolean",
        editType: "ticks",
        description: [
          "Determines whether or not a line is drawn at along the 0 value",
          "of this axis.",
          "If *true*, the zero line is drawn on top of the grid lines."
        ].join(" ")
      },
      zerolinecolor: {
        valType: "color",
        dflt: colorAttrs.defaultLine,
        editType: "ticks",
        description: "Sets the line color of the zero line."
      },
      zerolinewidth: {
        valType: "number",
        dflt: 1,
        editType: "ticks",
        description: "Sets the width (in px) of the zero line."
      },
      showdividers: {
        valType: "boolean",
        dflt: true,
        editType: "ticks",
        description: [
          "Determines whether or not a dividers are drawn",
          "between the category levels of this axis.",
          "Only has an effect on *multicategory* axes."
        ].join(" ")
      },
      dividercolor: {
        valType: "color",
        dflt: colorAttrs.defaultLine,
        editType: "ticks",
        description: [
          "Sets the color of the dividers",
          "Only has an effect on *multicategory* axes."
        ].join(" ")
      },
      dividerwidth: {
        valType: "number",
        dflt: 1,
        editType: "ticks",
        description: [
          "Sets the width (in px) of the dividers",
          "Only has an effect on *multicategory* axes."
        ].join(" ")
      },
      // TODO dividerlen: that would override "to label base" length?
      // positioning attributes
      // anchor: not used directly, just put here for reference
      // values are any opposite-letter axis id
      anchor: {
        valType: "enumerated",
        values: [
          "free",
          constants.idRegex.x.toString(),
          constants.idRegex.y.toString()
        ],
        editType: "plot",
        description: [
          "If set to an opposite-letter axis id (e.g. `x2`, `y`), this axis is bound to",
          "the corresponding opposite-letter axis.",
          "If set to *free*, this axis' position is determined by `position`."
        ].join(" ")
      },
      // side: not used directly, as values depend on direction
      // values are top, bottom for x axes, and left, right for y
      side: {
        valType: "enumerated",
        values: ["top", "bottom", "left", "right"],
        editType: "plot",
        description: [
          "Determines whether a x (y) axis is positioned",
          "at the *bottom* (*left*) or *top* (*right*)",
          "of the plotting area."
        ].join(" ")
      },
      // overlaying: not used directly, just put here for reference
      // values are false and any other same-letter axis id that's not
      // itself overlaying anything
      overlaying: {
        valType: "enumerated",
        values: [
          "free",
          constants.idRegex.x.toString(),
          constants.idRegex.y.toString()
        ],
        editType: "plot",
        description: [
          "If set a same-letter axis id, this axis is overlaid on top of",
          "the corresponding same-letter axis, with traces and axes visible for both",
          "axes.",
          "If *false*, this axis does not overlay any same-letter axes.",
          "In this case, for axes with overlapping domains only the highest-numbered",
          "axis will be visible."
        ].join(" ")
      },
      minor: {
        tickmode: minorTickmode,
        nticks: makeNticks("minor"),
        tick0,
        dtick,
        tickvals,
        ticks,
        ticklen: makeTicklen("minor"),
        tickwidth: makeTickwidth("minor"),
        tickcolor,
        gridcolor,
        gridwidth: makeGridwidth("minor"),
        griddash,
        showgrid,
        editType: "ticks"
      },
      layer: {
        valType: "enumerated",
        values: ["above traces", "below traces"],
        dflt: "above traces",
        editType: "plot",
        description: [
          "Sets the layer on which this axis is displayed.",
          "If *above traces*, this axis is displayed above all the subplot's traces",
          "If *below traces*, this axis is displayed below all the subplot's traces,",
          "but above the grid lines.",
          "Useful when used together with scatter-like traces with `cliponaxis`",
          "set to *false* to show markers and/or text nodes above this axis."
        ].join(" ")
      },
      domain: {
        valType: "info_array",
        items: [
          { valType: "number", min: 0, max: 1, editType: "plot" },
          { valType: "number", min: 0, max: 1, editType: "plot" }
        ],
        dflt: [0, 1],
        editType: "plot",
        description: [
          "Sets the domain of this axis (in plot fraction)."
        ].join(" ")
      },
      position: {
        valType: "number",
        min: 0,
        max: 1,
        dflt: 0,
        editType: "plot",
        description: [
          "Sets the position of this axis in the plotting space",
          "(in normalized coordinates).",
          "Only has an effect if `anchor` is set to *free*."
        ].join(" ")
      },
      autoshift: {
        valType: "boolean",
        dflt: false,
        editType: "plot",
        description: [
          "Automatically reposition the axis to avoid",
          "overlap with other axes with the same `overlaying` value.",
          "This repositioning will account for any `shift` amount applied to other",
          "axes on the same side with `autoshift` is set to true.",
          "Only has an effect if `anchor` is set to *free*."
        ].join(" ")
      },
      shift: {
        valType: "number",
        editType: "plot",
        description: [
          "Moves the axis a given number of pixels from where it would have been otherwise.",
          "Accepts both positive and negative values, which will shift the axis either right",
          "or left, respectively.",
          "If `autoshift` is set to true, then this defaults to a padding of -3 if `side` is set to *left*.",
          "and defaults to +3 if `side` is set to *right*. Defaults to 0 if `autoshift` is set to false.",
          "Only has an effect if `anchor` is set to *free*."
        ].join(" ")
      },
      categoryorder: {
        valType: "enumerated",
        values: [
          "trace",
          "category ascending",
          "category descending",
          "array",
          "total ascending",
          "total descending",
          "min ascending",
          "min descending",
          "max ascending",
          "max descending",
          "sum ascending",
          "sum descending",
          "mean ascending",
          "mean descending",
          "geometric mean ascending",
          "geometric mean descending",
          "median ascending",
          "median descending"
        ],
        dflt: "trace",
        editType: "calc",
        description: [
          "Specifies the ordering logic for the case of categorical variables.",
          "By default, plotly uses *trace*, which specifies the order that is present in the data supplied.",
          "Set `categoryorder` to *category ascending* or *category descending* if order should be determined by",
          "the alphanumerical order of the category names.",
          "Set `categoryorder` to *array* to derive the ordering from the attribute `categoryarray`. If a category",
          "is not found in the `categoryarray` array, the sorting behavior for that attribute will be identical to",
          "the *trace* mode. The unspecified categories will follow the categories in `categoryarray`.",
          "Set `categoryorder` to *total ascending* or *total descending* if order should be determined by the",
          "numerical order of the values.",
          "Similarly, the order can be determined by the min, max, sum, mean, geometric mean or median of all the values."
        ].join(" ")
      },
      categoryarray: {
        valType: "data_array",
        editType: "calc",
        description: [
          "Sets the order in which categories on this axis appear.",
          "Only has an effect if `categoryorder` is set to *array*.",
          "Used with `categoryorder`."
        ].join(" ")
      },
      uirevision: {
        valType: "any",
        editType: "none",
        description: [
          "Controls persistence of user-driven changes in axis `range`,",
          "`autorange`, and `title` if in `editable: true` configuration.",
          "Defaults to `layout.uirevision`."
        ].join(" ")
      },
      editType: "calc",
      _deprecated: {
        autotick: {
          valType: "boolean",
          editType: "ticks",
          description: [
            "Obsolete.",
            "Set `tickmode` to *auto* for old `autotick` *true* behavior.",
            "Set `tickmode` to *linear* for `autotick` *false*."
          ].join(" ")
        },
        title: {
          valType: "string",
          editType: "ticks",
          description: [
            "Value of `title` is no longer a simple *string* but a set of sub-attributes.",
            "To set the axis' title, please use `title.text` now."
          ].join(" ")
        },
        titlefont: fontAttrs({
          editType: "ticks",
          description: [
            "Former `titlefont` is now the sub-attribute `font` of `title`.",
            "To customize title font properties, please use `title.font` now."
          ].join(" ")
        })
      }
    };
  }
});

// node_modules/plotly.js/src/components/colorbar/attributes.js
var require_attributes7 = __commonJS({
  "node_modules/plotly.js/src/components/colorbar/attributes.js"(exports2, module2) {
    "use strict";
    var axesAttrs = require_layout_attributes4();
    var fontAttrs = require_font_attributes();
    var extendFlat = require_extend().extendFlat;
    var overrideAll = require_edit_types().overrideAll;
    module2.exports = overrideAll({
      orientation: {
        valType: "enumerated",
        values: ["h", "v"],
        dflt: "v",
        description: "Sets the orientation of the colorbar."
      },
      thicknessmode: {
        valType: "enumerated",
        values: ["fraction", "pixels"],
        dflt: "pixels",
        description: [
          "Determines whether this color bar's thickness",
          "(i.e. the measure in the constant color direction)",
          "is set in units of plot *fraction* or in *pixels*.",
          "Use `thickness` to set the value."
        ].join(" ")
      },
      thickness: {
        valType: "number",
        min: 0,
        dflt: 30,
        description: [
          "Sets the thickness of the color bar",
          "This measure excludes the size of the padding, ticks and labels."
        ].join(" ")
      },
      lenmode: {
        valType: "enumerated",
        values: ["fraction", "pixels"],
        dflt: "fraction",
        description: [
          "Determines whether this color bar's length",
          "(i.e. the measure in the color variation direction)",
          "is set in units of plot *fraction* or in *pixels.",
          "Use `len` to set the value."
        ].join(" ")
      },
      len: {
        valType: "number",
        min: 0,
        dflt: 1,
        description: [
          "Sets the length of the color bar",
          "This measure excludes the padding of both ends.",
          "That is, the color bar length is this length minus the",
          "padding on both ends."
        ].join(" ")
      },
      x: {
        valType: "number",
        description: [
          "Sets the x position with respect to `xref` of the color bar (in plot fraction).",
          "When `xref` is *paper*, defaults to 1.02 when `orientation` is *v* and",
          "0.5 when `orientation` is *h*.",
          "When `xref` is *container*, defaults to *1* when `orientation` is *v* and",
          "0.5 when `orientation` is *h*.",
          "Must be between *0* and *1* if `xref` is *container*",
          "and between *-2* and *3* if `xref` is *paper*."
        ].join(" ")
      },
      xref: {
        valType: "enumerated",
        dflt: "paper",
        values: ["container", "paper"],
        editType: "layoutstyle",
        description: [
          "Sets the container `x` refers to.",
          "*container* spans the entire `width` of the plot.",
          "*paper* refers to the width of the plotting area only."
        ].join(" ")
      },
      xanchor: {
        valType: "enumerated",
        values: ["left", "center", "right"],
        description: [
          "Sets this color bar's horizontal position anchor.",
          "This anchor binds the `x` position to the *left*, *center*",
          "or *right* of the color bar.",
          "Defaults to *left* when `orientation` is *v* and",
          "*center* when `orientation` is *h*."
        ].join(" ")
      },
      xpad: {
        valType: "number",
        min: 0,
        dflt: 10,
        description: "Sets the amount of padding (in px) along the x direction."
      },
      y: {
        valType: "number",
        description: [
          "Sets the y position with respect to `yref` of the color bar (in plot fraction).",
          "When `yref` is *paper*, defaults to 0.5 when `orientation` is *v* and",
          "1.02 when `orientation` is *h*.",
          "When `yref` is *container*, defaults to 0.5 when `orientation` is *v* and",
          "1 when `orientation` is *h*.",
          "Must be between *0* and *1* if `yref` is *container*",
          "and between *-2* and *3* if `yref` is *paper*."
        ].join(" ")
      },
      yref: {
        valType: "enumerated",
        dflt: "paper",
        values: ["container", "paper"],
        editType: "layoutstyle",
        description: [
          "Sets the container `y` refers to.",
          "*container* spans the entire `height` of the plot.",
          "*paper* refers to the height of the plotting area only."
        ].join(" ")
      },
      yanchor: {
        valType: "enumerated",
        values: ["top", "middle", "bottom"],
        description: [
          "Sets this color bar's vertical position anchor",
          "This anchor binds the `y` position to the *top*, *middle*",
          "or *bottom* of the color bar.",
          "Defaults to *middle* when `orientation` is *v* and",
          "*bottom* when `orientation` is *h*."
        ].join(" ")
      },
      ypad: {
        valType: "number",
        min: 0,
        dflt: 10,
        description: "Sets the amount of padding (in px) along the y direction."
      },
      // a possible line around the bar itself
      outlinecolor: axesAttrs.linecolor,
      outlinewidth: axesAttrs.linewidth,
      // Should outlinewidth have {dflt: 0} ?
      // another possible line outside the padding and tick labels
      bordercolor: axesAttrs.linecolor,
      borderwidth: {
        valType: "number",
        min: 0,
        dflt: 0,
        description: [
          "Sets the width (in px) or the border enclosing this color bar."
        ].join(" ")
      },
      bgcolor: {
        valType: "color",
        dflt: "rgba(0,0,0,0)",
        description: "Sets the color of padded area."
      },
      // tick and title properties named and function exactly as in axes
      tickmode: axesAttrs.minor.tickmode,
      nticks: axesAttrs.nticks,
      tick0: axesAttrs.tick0,
      dtick: axesAttrs.dtick,
      tickvals: axesAttrs.tickvals,
      ticktext: axesAttrs.ticktext,
      ticks: extendFlat({}, axesAttrs.ticks, { dflt: "" }),
      ticklabeloverflow: extendFlat({}, axesAttrs.ticklabeloverflow, {
        description: [
          "Determines how we handle tick labels that would overflow either the graph div or the domain of the axis.",
          "The default value for inside tick labels is *hide past domain*.",
          "In other cases the default is *hide past div*."
        ].join(" ")
      }),
      // ticklabelposition: not used directly, as values depend on orientation
      // left/right options are for x axes, and top/bottom options are for y axes
      ticklabelposition: {
        valType: "enumerated",
        values: [
          "outside",
          "inside",
          "outside top",
          "inside top",
          "outside left",
          "inside left",
          "outside right",
          "inside right",
          "outside bottom",
          "inside bottom"
        ],
        dflt: "outside",
        description: [
          "Determines where tick labels are drawn relative to the ticks.",
          "Left and right options are used when `orientation` is *h*,",
          "top and bottom when `orientation` is *v*."
        ].join(" ")
      },
      ticklen: axesAttrs.ticklen,
      tickwidth: axesAttrs.tickwidth,
      tickcolor: axesAttrs.tickcolor,
      ticklabelstep: axesAttrs.ticklabelstep,
      showticklabels: axesAttrs.showticklabels,
      labelalias: axesAttrs.labelalias,
      tickfont: fontAttrs({
        description: "Sets the color bar's tick label font"
      }),
      tickangle: axesAttrs.tickangle,
      tickformat: axesAttrs.tickformat,
      tickformatstops: axesAttrs.tickformatstops,
      tickprefix: axesAttrs.tickprefix,
      showtickprefix: axesAttrs.showtickprefix,
      ticksuffix: axesAttrs.ticksuffix,
      showticksuffix: axesAttrs.showticksuffix,
      separatethousands: axesAttrs.separatethousands,
      exponentformat: axesAttrs.exponentformat,
      minexponent: axesAttrs.minexponent,
      showexponent: axesAttrs.showexponent,
      title: {
        text: {
          valType: "string",
          description: [
            "Sets the title of the color bar.",
            "Note that before the existence of `title.text`, the title's",
            "contents used to be defined as the `title` attribute itself.",
            "This behavior has been deprecated."
          ].join(" ")
        },
        font: fontAttrs({
          description: [
            "Sets this color bar's title font.",
            "Note that the title's font used to be set",
            "by the now deprecated `titlefont` attribute."
          ].join(" ")
        }),
        side: {
          valType: "enumerated",
          values: ["right", "top", "bottom"],
          description: [
            "Determines the location of color bar's title",
            "with respect to the color bar.",
            "Defaults to *top* when `orientation` if *v* and ",
            "defaults to *right* when `orientation` if *h*.",
            "Note that the title's location used to be set",
            "by the now deprecated `titleside` attribute."
          ].join(" ")
        }
      },
      _deprecated: {
        title: {
          valType: "string",
          description: [
            "Deprecated in favor of color bar's `title.text`.",
            "Note that value of color bar's `title` is no longer a simple",
            "*string* but a set of sub-attributes."
          ].join(" ")
        },
        titlefont: fontAttrs({
          description: "Deprecated in favor of color bar's `title.font`."
        }),
        titleside: {
          valType: "enumerated",
          values: ["right", "top", "bottom"],
          dflt: "top",
          description: "Deprecated in favor of color bar's `title.side`."
        }
      }
    }, "colorbars", "from-root");
  }
});

// node_modules/plotly.js/src/components/colorscale/attributes.js
var require_attributes8 = __commonJS({
  "node_modules/plotly.js/src/components/colorscale/attributes.js"(exports2, module2) {
    "use strict";
    var colorbarAttrs = require_attributes7();
    var counterRegex = require_regex().counter;
    var sortObjectKeys = require_sort_object_keys();
    var palettes = require_scales().scales;
    var paletteStr = sortObjectKeys(palettes);
    function code(s) {
      return "`" + s + "`";
    }
    module2.exports = function colorScaleAttrs(context, opts) {
      context = context || "";
      opts = opts || {};
      var cLetter = opts.cLetter || "c";
      var onlyIfNumerical = "onlyIfNumerical" in opts ? opts.onlyIfNumerical : Boolean(context);
      var noScale = "noScale" in opts ? opts.noScale : context === "marker.line";
      var showScaleDflt = "showScaleDflt" in opts ? opts.showScaleDflt : cLetter === "z";
      var colorscaleDflt = typeof opts.colorscaleDflt === "string" ? palettes[opts.colorscaleDflt] : null;
      var editTypeOverride = opts.editTypeOverride || "";
      var contextHead = context ? context + "." : "";
      var colorAttr, colorAttrFull;
      if ("colorAttr" in opts) {
        colorAttr = opts.colorAttr;
        colorAttrFull = opts.colorAttr;
      } else {
        colorAttr = { z: "z", c: "color" }[cLetter];
        colorAttrFull = "in " + code(contextHead + colorAttr);
      }
      var effectDesc = onlyIfNumerical ? " Has an effect only if " + colorAttrFull + " is set to a numerical array." : "";
      var auto = cLetter + "auto";
      var min = cLetter + "min";
      var max = cLetter + "max";
      var mid = cLetter + "mid";
      var autoFull = code(contextHead + auto);
      var minFull = code(contextHead + min);
      var maxFull = code(contextHead + max);
      var minmaxFull = minFull + " and " + maxFull;
      var autoImpliedEdits = {};
      autoImpliedEdits[min] = autoImpliedEdits[max] = void 0;
      var minmaxImpliedEdits = {};
      minmaxImpliedEdits[auto] = false;
      var attrs = {};
      if (colorAttr === "color") {
        attrs.color = {
          valType: "color",
          arrayOk: true,
          editType: editTypeOverride || "style",
          description: [
            "Sets the",
            context,
            "color.",
            "It accepts either a specific color",
            "or an array of numbers that are mapped to the colorscale",
            "relative to the max and min values of the array or relative to",
            minmaxFull,
            "if set."
          ].join(" ")
        };
        if (opts.anim) {
          attrs.color.anim = true;
        }
      }
      attrs[auto] = {
        valType: "boolean",
        dflt: true,
        editType: "calc",
        impliedEdits: autoImpliedEdits,
        description: [
          "Determines whether or not the color domain is computed",
          "with respect to the input data (here " + colorAttrFull + ") or the bounds set in",
          minmaxFull + effectDesc,
          "Defaults to `false` when",
          minmaxFull,
          "are set by the user."
        ].join(" ")
      };
      attrs[min] = {
        valType: "number",
        dflt: null,
        editType: editTypeOverride || "plot",
        impliedEdits: minmaxImpliedEdits,
        description: [
          "Sets the lower bound of the color domain." + effectDesc,
          "Value should have the same units as",
          colorAttrFull,
          "and if set,",
          maxFull,
          "must be set as well."
        ].join(" ")
      };
      attrs[max] = {
        valType: "number",
        dflt: null,
        editType: editTypeOverride || "plot",
        impliedEdits: minmaxImpliedEdits,
        description: [
          "Sets the upper bound of the color domain." + effectDesc,
          "Value should have the same units as",
          colorAttrFull,
          "and if set,",
          minFull,
          "must be set as well."
        ].join(" ")
      };
      attrs[mid] = {
        valType: "number",
        dflt: null,
        editType: "calc",
        impliedEdits: autoImpliedEdits,
        description: [
          "Sets the mid-point of the color domain by scaling",
          minFull,
          "and/or",
          maxFull,
          "to be equidistant to this point." + effectDesc,
          "Value should have the same units as",
          colorAttrFull + ".",
          "Has no effect when",
          autoFull,
          "is `false`."
        ].join(" ")
      };
      attrs.colorscale = {
        valType: "colorscale",
        editType: "calc",
        dflt: colorscaleDflt,
        impliedEdits: { autocolorscale: false },
        description: [
          "Sets the colorscale." + effectDesc,
          "The colorscale must be an array containing",
          "arrays mapping a normalized value to an",
          "rgb, rgba, hex, hsl, hsv, or named color string.",
          "At minimum, a mapping for the lowest (0) and highest (1)",
          "values are required. For example,",
          "`[[0, 'rgb(0,0,255)'], [1, 'rgb(255,0,0)']]`.",
          "To control the bounds of the colorscale in color space,",
          "use",
          minmaxFull + ".",
          "Alternatively, `colorscale` may be a palette name string",
          "of the following list: " + paletteStr + "."
        ].join(" ")
      };
      attrs.autocolorscale = {
        valType: "boolean",
        // gets overrode in 'heatmap' & 'surface' for backwards comp.
        dflt: opts.autoColorDflt === false ? false : true,
        editType: "calc",
        impliedEdits: { colorscale: void 0 },
        description: [
          "Determines whether the colorscale is a default palette (`autocolorscale: true`)",
          "or the palette determined by",
          code(contextHead + "colorscale") + "." + effectDesc,
          "In case `colorscale` is unspecified or `autocolorscale` is true, the default",
          "palette will be chosen according to whether numbers in the `color` array are",
          "all positive, all negative or mixed."
        ].join(" ")
      };
      attrs.reversescale = {
        valType: "boolean",
        dflt: false,
        editType: "plot",
        description: [
          "Reverses the color mapping if true." + effectDesc,
          "If true,",
          minFull,
          "will correspond to the last color",
          "in the array and",
          maxFull,
          "will correspond to the first color."
        ].join(" ")
      };
      if (!noScale) {
        attrs.showscale = {
          valType: "boolean",
          dflt: showScaleDflt,
          editType: "calc",
          description: [
            "Determines whether or not a colorbar is displayed for this trace." + effectDesc
          ].join(" ")
        };
        attrs.colorbar = colorbarAttrs;
      }
      if (!opts.noColorAxis) {
        attrs.coloraxis = {
          valType: "subplotid",
          regex: counterRegex("coloraxis"),
          dflt: null,
          editType: "calc",
          description: [
            "Sets a reference to a shared color axis.",
            "References to these shared color axes are *coloraxis*, *coloraxis2*, *coloraxis3*, etc.",
            "Settings for these shared color axes are set in the layout, under",
            "`layout.coloraxis`, `layout.coloraxis2`, etc.",
            "Note that multiple color scales can be linked to the same color axis."
          ].join(" ")
        };
      }
      return attrs;
    };
  }
});

// node_modules/plotly.js/src/components/colorscale/layout_attributes.js
var require_layout_attributes5 = __commonJS({
  "node_modules/plotly.js/src/components/colorscale/layout_attributes.js"(exports2, module2) {
    "use strict";
    var extendFlat = require_extend().extendFlat;
    var colorScaleAttrs = require_attributes8();
    var scales = require_scales().scales;
    var msg = "Note that `autocolorscale` must be true for this attribute to work.";
    module2.exports = {
      editType: "calc",
      colorscale: {
        editType: "calc",
        sequential: {
          valType: "colorscale",
          dflt: scales.Reds,
          editType: "calc",
          description: [
            "Sets the default sequential colorscale for positive values.",
            msg
          ].join(" ")
        },
        sequentialminus: {
          valType: "colorscale",
          dflt: scales.Blues,
          editType: "calc",
          description: [
            "Sets the default sequential colorscale for negative values.",
            msg
          ].join(" ")
        },
        diverging: {
          valType: "colorscale",
          dflt: scales.RdBu,
          editType: "calc",
          description: [
            "Sets the default diverging colorscale.",
            msg
          ].join(" ")
        }
      },
      coloraxis: extendFlat({
        // not really a 'subplot' attribute container,
        // but this is the flag we use to denote attributes that
        // support yaxis, yaxis2, yaxis3, ... counters
        _isSubplotObj: true,
        editType: "calc",
        description: [
          ""
        ].join(" ")
      }, colorScaleAttrs("", {
        colorAttr: "corresponding trace color array(s)",
        noColorAxis: true,
        showScaleDflt: true
      }))
    };
  }
});

// node_modules/plotly.js/src/components/colorbar/has_colorbar.js
var require_has_colorbar = __commonJS({
  "node_modules/plotly.js/src/components/colorbar/has_colorbar.js"(exports2, module2) {
    "use strict";
    var Lib = require_lib();
    module2.exports = function hasColorbar(container) {
      return Lib.isPlainObject(container.colorbar);
    };
  }
});

// node_modules/plotly.js/src/plots/cartesian/clean_ticks.js
var require_clean_ticks = __commonJS({
  "node_modules/plotly.js/src/plots/cartesian/clean_ticks.js"(exports2) {
    "use strict";
    var isNumeric = require_fast_isnumeric();
    var Lib = require_lib();
    var constants = require_numerical();
    var ONEDAY = constants.ONEDAY;
    var ONEWEEK = constants.ONEWEEK;
    exports2.dtick = function(dtick, axType) {
      var isLog = axType === "log";
      var isDate = axType === "date";
      var isCat = axType === "category";
      var dtickDflt = isDate ? ONEDAY : 1;
      if (!dtick) return dtickDflt;
      if (isNumeric(dtick)) {
        dtick = Number(dtick);
        if (dtick <= 0) return dtickDflt;
        if (isCat) {
          return Math.max(1, Math.round(dtick));
        }
        if (isDate) {
          return Math.max(0.1, dtick);
        }
        return dtick;
      }
      if (typeof dtick !== "string" || !(isDate || isLog)) {
        return dtickDflt;
      }
      var prefix = dtick.charAt(0);
      var dtickNum = dtick.substr(1);
      dtickNum = isNumeric(dtickNum) ? Number(dtickNum) : 0;
      if (dtickNum <= 0 || !// "M<n>" gives ticks every (integer) n months
      (isDate && prefix === "M" && dtickNum === Math.round(dtickNum) || // "L<f>" gives ticks linearly spaced in data (not in position) every (float) f
      isLog && prefix === "L" || // "D1" gives powers of 10 with all small digits between, "D2" gives only 2 and 5
      isLog && prefix === "D" && (dtickNum === 1 || dtickNum === 2))) {
        return dtickDflt;
      }
      return dtick;
    };
    exports2.tick0 = function(tick0, axType, calendar, dtick) {
      if (axType === "date") {
        return Lib.cleanDate(
          tick0,
          Lib.dateTick0(calendar, dtick % ONEWEEK === 0 ? 1 : 0)
        );
      }
      if (dtick === "D1" || dtick === "D2") {
        return void 0;
      }
      return isNumeric(tick0) ? Number(tick0) : 0;
    };
  }
});

// node_modules/plotly.js/src/plots/cartesian/tick_value_defaults.js
var require_tick_value_defaults = __commonJS({
  "node_modules/plotly.js/src/plots/cartesian/tick_value_defaults.js"(exports2, module2) {
    "use strict";
    var cleanTicks = require_clean_ticks();
    var isArrayOrTypedArray = require_lib().isArrayOrTypedArray;
    var isTypedArraySpec = require_array().isTypedArraySpec;
    var decodeTypedArraySpec = require_array().decodeTypedArraySpec;
    module2.exports = function handleTickValueDefaults(containerIn, containerOut, coerce, axType, opts) {
      if (!opts) opts = {};
      var isMinor = opts.isMinor;
      var cIn = isMinor ? containerIn.minor || {} : containerIn;
      var cOut = isMinor ? containerOut.minor : containerOut;
      var prefix = isMinor ? "minor." : "";
      function readInput(attr) {
        var v = cIn[attr];
        if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
        return v !== void 0 ? v : (cOut._template || {})[attr];
      }
      var _tick0 = readInput("tick0");
      var _dtick = readInput("dtick");
      var _tickvals = readInput("tickvals");
      var tickmodeDefault = isArrayOrTypedArray(_tickvals) ? "array" : _dtick ? "linear" : "auto";
      var tickmode = coerce(prefix + "tickmode", tickmodeDefault);
      if (tickmode === "auto" || tickmode === "sync") {
        coerce(prefix + "nticks");
      } else if (tickmode === "linear") {
        var dtick = cOut.dtick = cleanTicks.dtick(
          _dtick,
          axType
        );
        cOut.tick0 = cleanTicks.tick0(
          _tick0,
          axType,
          containerOut.calendar,
          dtick
        );
      } else if (axType !== "multicategory") {
        var tickvals = coerce(prefix + "tickvals");
        if (tickvals === void 0) cOut.tickmode = "auto";
        else if (!isMinor) coerce("ticktext");
      }
    };
  }
});

// node_modules/plotly.js/src/plots/cartesian/tick_mark_defaults.js
var require_tick_mark_defaults = __commonJS({
  "node_modules/plotly.js/src/plots/cartesian/tick_mark_defaults.js"(exports2, module2) {
    "use strict";
    var Lib = require_lib();
    var layoutAttributes = require_layout_attributes4();
    module2.exports = function handleTickMarkDefaults(containerIn, containerOut, coerce, options) {
      var isMinor = options.isMinor;
      var cIn = isMinor ? containerIn.minor || {} : containerIn;
      var cOut = isMinor ? containerOut.minor : containerOut;
      var lAttr = isMinor ? layoutAttributes.minor : layoutAttributes;
      var prefix = isMinor ? "minor." : "";
      var tickLen = Lib.coerce2(cIn, cOut, lAttr, "ticklen", isMinor ? (containerOut.ticklen || 5) * 0.6 : void 0);
      var tickWidth = Lib.coerce2(cIn, cOut, lAttr, "tickwidth", isMinor ? containerOut.tickwidth || 1 : void 0);
      var tickColor = Lib.coerce2(cIn, cOut, lAttr, "tickcolor", (isMinor ? containerOut.tickcolor : void 0) || cOut.color);
      var showTicks = coerce(prefix + "ticks", !isMinor && options.outerTicks || tickLen || tickWidth || tickColor ? "outside" : "");
      if (!showTicks) {
        delete cOut.ticklen;
        delete cOut.tickwidth;
        delete cOut.tickcolor;
      }
    };
  }
});

// node_modules/plotly.js/src/plots/cartesian/show_dflt.js
var require_show_dflt = __commonJS({
  "node_modules/plotly.js/src/plots/cartesian/show_dflt.js"(exports2, module2) {
    "use strict";
    module2.exports = function getShowAttrDflt(containerIn) {
      var showAttrsAll = ["showexponent", "showtickprefix", "showticksuffix"];
      var showAttrs = showAttrsAll.filter(function(a) {
        return containerIn[a] !== void 0;
      });
      var sameVal = function(a) {
        return containerIn[a] === containerIn[showAttrs[0]];
      };
      if (showAttrs.every(sameVal) || showAttrs.length === 1) {
        return containerIn[showAttrs[0]];
      }
    };
  }
});

// node_modules/plotly.js/src/plots/array_container_defaults.js
var require_array_container_defaults = __commonJS({
  "node_modules/plotly.js/src/plots/array_container_defaults.js"(exports2, module2) {
    "use strict";
    var Lib = require_lib();
    var Template = require_plot_template();
    module2.exports = function handleArrayContainerDefaults(parentObjIn, parentObjOut, opts) {
      var name = opts.name;
      var inclusionAttr = opts.inclusionAttr || "visible";
      var previousContOut = parentObjOut[name];
      var contIn = Lib.isArrayOrTypedArray(parentObjIn[name]) ? parentObjIn[name] : [];
      var contOut = parentObjOut[name] = [];
      var templater = Template.arrayTemplater(parentObjOut, name, inclusionAttr);
      var i, itemOut;
      for (i = 0; i < contIn.length; i++) {
        var itemIn = contIn[i];
        if (!Lib.isPlainObject(itemIn)) {
          itemOut = templater.newItem({});
          itemOut[inclusionAttr] = false;
        } else {
          itemOut = templater.newItem(itemIn);
        }
        itemOut._index = i;
        if (itemOut[inclusionAttr] !== false) {
          opts.handleItemDefaults(itemIn, itemOut, parentObjOut, opts);
        }
        contOut.push(itemOut);
      }
      var defaultItems = templater.defaultItems();
      for (i = 0; i < defaultItems.length; i++) {
        itemOut = defaultItems[i];
        itemOut._index = contOut.length;
        opts.handleItemDefaults({}, itemOut, parentObjOut, opts, {});
        contOut.push(itemOut);
      }
      if (Lib.isArrayOrTypedArray(previousContOut)) {
        var len = Math.min(previousContOut.length, contOut.length);
        for (i = 0; i < len; i++) {
          Lib.relinkPrivateKeys(contOut[i], previousContOut[i]);
        }
      }
      return contOut;
    };
  }
});

// node_modules/plotly.js/src/plots/cartesian/tick_label_defaults.js
var require_tick_label_defaults = __commonJS({
  "node_modules/plotly.js/src/plots/cartesian/tick_label_defaults.js"(exports2, module2) {
    "use strict";
    var Lib = require_lib();
    var contrast = require_color().contrast;
    var layoutAttributes = require_layout_attributes4();
    var getShowAttrDflt = require_show_dflt();
    var handleArrayContainerDefaults = require_array_container_defaults();
    module2.exports = function handleTickLabelDefaults(containerIn, containerOut, coerce, axType, options) {
      if (!options) options = {};
      var labelalias = coerce("labelalias");
      if (!Lib.isPlainObject(labelalias)) delete containerOut.labelalias;
      var showAttrDflt = getShowAttrDflt(containerIn);
      var showTickLabels = coerce("showticklabels");
      if (showTickLabels) {
        if (!options.noTicklabelshift) {
          coerce("ticklabelshift");
        }
        if (!options.noTicklabelstandoff) {
          coerce("ticklabelstandoff");
        }
        var font = options.font || {};
        var contColor = containerOut.color;
        var position = containerOut.ticklabelposition || "";
        var dfltFontColor = position.indexOf("inside") !== -1 ? contrast(options.bgColor) : (
          // as with titlefont.color, inherit axis.color only if one was
          // explicitly provided
          contColor && contColor !== layoutAttributes.color.dflt ? contColor : font.color
        );
        Lib.coerceFont(coerce, "tickfont", font, { overrideDflt: {
          color: dfltFontColor
        } });
        if (!options.noTicklabelstep && axType !== "multicategory" && axType !== "log") {
          coerce("ticklabelstep");
        }
        if (!options.noAng) {
          var tickAngle = coerce("tickangle");
          if (!options.noAutotickangles && tickAngle === "auto") {
            coerce("autotickangles");
          }
        }
        if (axType !== "category") {
          var tickFormat = coerce("tickformat");
          handleArrayContainerDefaults(containerIn, containerOut, {
            name: "tickformatstops",
            inclusionAttr: "enabled",
            handleItemDefaults: tickformatstopDefaults
          });
          if (!containerOut.tickformatstops.length) {
            delete containerOut.tickformatstops;
          }
          if (!options.noExp && !tickFormat && axType !== "date") {
            coerce("showexponent", showAttrDflt);
            coerce("exponentformat");
            coerce("minexponent");
            coerce("separatethousands");
          }
        }
      }
    };
    function tickformatstopDefaults(valueIn, valueOut) {
      function coerce(attr, dflt) {
        return Lib.coerce(valueIn, valueOut, layoutAttributes.tickformatstops, attr, dflt);
      }
      var enabled = coerce("enabled");
      if (enabled) {
        coerce("dtickrange");
        coerce("value");
      }
    }
  }
});

// node_modules/plotly.js/src/plots/cartesian/prefix_suffix_defaults.js
var require_prefix_suffix_defaults = __commonJS({
  "node_modules/plotly.js/src/plots/cartesian/prefix_suffix_defaults.js"(exports2, module2) {
    "use strict";
    var getShowAttrDflt = require_show_dflt();
    module2.exports = function handlePrefixSuffixDefaults(containerIn, containerOut, coerce, axType, options) {
      if (!options) options = {};
      var tickSuffixDflt = options.tickSuffixDflt;
      var showAttrDflt = getShowAttrDflt(containerIn);
      var tickPrefix = coerce("tickprefix");
      if (tickPrefix) coerce("showtickprefix", showAttrDflt);
      var tickSuffix = coerce("ticksuffix", tickSuffixDflt);
      if (tickSuffix) coerce("showticksuffix", showAttrDflt);
    };
  }
});

// node_modules/plotly.js/src/components/colorbar/defaults.js
var require_defaults = __commonJS({
  "node_modules/plotly.js/src/components/colorbar/defaults.js"(exports2, module2) {
    "use strict";
    var Lib = require_lib();
    var Template = require_plot_template();
    var handleTickValueDefaults = require_tick_value_defaults();
    var handleTickMarkDefaults = require_tick_mark_defaults();
    var handleTickLabelDefaults = require_tick_label_defaults();
    var handlePrefixSuffixDefaults = require_prefix_suffix_defaults();
    var attributes = require_attributes7();
    module2.exports = function colorbarDefaults(containerIn, containerOut, layout) {
      var colorbarOut = Template.newContainer(containerOut, "colorbar");
      var colorbarIn = containerIn.colorbar || {};
      function coerce(attr, dflt) {
        return Lib.coerce(colorbarIn, colorbarOut, attributes, attr, dflt);
      }
      var margin = layout.margin || { t: 0, b: 0, l: 0, r: 0 };
      var w = layout.width - margin.l - margin.r;
      var h = layout.height - margin.t - margin.b;
      var orientation = coerce("orientation");
      var isVertical = orientation === "v";
      var thicknessmode = coerce("thicknessmode");
      coerce(
        "thickness",
        thicknessmode === "fraction" ? 30 / (isVertical ? w : h) : 30
      );
      var lenmode = coerce("lenmode");
      coerce(
        "len",
        lenmode === "fraction" ? 1 : isVertical ? h : w
      );
      var yref = coerce("yref");
      var xref = coerce("xref");
      var isPaperY = yref === "paper";
      var isPaperX = xref === "paper";
      var defaultX, defaultY, defaultYAnchor;
      var defaultXAnchor = "left";
      if (isVertical) {
        defaultYAnchor = "middle";
        defaultXAnchor = isPaperX ? "left" : "right";
        defaultX = isPaperX ? 1.02 : 1;
        defaultY = 0.5;
      } else {
        defaultYAnchor = isPaperY ? "bottom" : "top";
        defaultXAnchor = "center";
        defaultX = 0.5;
        defaultY = isPaperY ? 1.02 : 1;
      }
      Lib.coerce(colorbarIn, colorbarOut, {
        x: {
          valType: "number",
          min: isPaperX ? -2 : 0,
          max: isPaperX ? 3 : 1,
          dflt: defaultX
        }
      }, "x");
      Lib.coerce(colorbarIn, colorbarOut, {
        y: {
          valType: "number",
          min: isPaperY ? -2 : 0,
          max: isPaperY ? 3 : 1,
          dflt: defaultY
        }
      }, "y");
      coerce("xanchor", defaultXAnchor);
      coerce("xpad");
      coerce("yanchor", defaultYAnchor);
      coerce("ypad");
      Lib.noneOrAll(colorbarIn, colorbarOut, ["x", "y"]);
      coerce("outlinecolor");
      coerce("outlinewidth");
      coerce("bordercolor");
      coerce("borderwidth");
      coerce("bgcolor");
      var ticklabelposition = Lib.coerce(colorbarIn, colorbarOut, {
        ticklabelposition: {
          valType: "enumerated",
          dflt: "outside",
          values: isVertical ? [
            "outside",
            "inside",
            "outside top",
            "inside top",
            "outside bottom",
            "inside bottom"
          ] : [
            "outside",
            "inside",
            "outside left",
            "inside left",
            "outside right",
            "inside right"
          ]
        }
      }, "ticklabelposition");
      coerce("ticklabeloverflow", ticklabelposition.indexOf("inside") !== -1 ? "hide past domain" : "hide past div");
      handleTickValueDefaults(colorbarIn, colorbarOut, coerce, "linear");
      var font = layout.font;
      var opts = {
        noAutotickangles: true,
        noTicklabelshift: true,
        noTicklabelstandoff: true,
        outerTicks: false,
        font
      };
      if (ticklabelposition.indexOf("inside") !== -1) {
        opts.bgColor = "black";
      }
      handlePrefixSuffixDefaults(colorbarIn, colorbarOut, coerce, "linear", opts);
      handleTickLabelDefaults(colorbarIn, colorbarOut, coerce, "linear", opts);
      handleTickMarkDefaults(colorbarIn, colorbarOut, coerce, "linear", opts);
      coerce("title.text", layout._dfltTitle.colorbar);
      var tickFont = colorbarOut.showticklabels ? colorbarOut.tickfont : font;
      var dfltTitleFont = Lib.extendFlat({}, font, {
        family: tickFont.family,
        size: Lib.bigFont(tickFont.size)
      });
      Lib.coerceFont(coerce, "title.font", dfltTitleFont);
      coerce("title.side", isVertical ? "top" : "right");
    };
  }
});

// node_modules/plotly.js/src/components/colorscale/defaults.js
var require_defaults2 = __commonJS({
  "node_modules/plotly.js/src/components/colorscale/defaults.js"(exports2, module2) {
    "use strict";
    var isNumeric = require_fast_isnumeric();
    var Lib = require_lib();
    var hasColorbar = require_has_colorbar();
    var colorbarDefaults = require_defaults();
    var isValidScale = require_scales().isValid;
    var traceIs = require_registry().traceIs;
    function npMaybe(parentCont, prefix) {
      var containerStr = prefix.slice(0, prefix.length - 1);
      return prefix ? Lib.nestedProperty(parentCont, containerStr).get() || {} : parentCont;
    }
    module2.exports = function colorScaleDefaults(parentContIn, parentContOut, layout, coerce, opts) {
      var prefix = opts.prefix;
      var cLetter = opts.cLetter;
      var inTrace = "_module" in parentContOut;
      var containerIn = npMaybe(parentContIn, prefix);
      var containerOut = npMaybe(parentContOut, prefix);
      var template = npMaybe(parentContOut._template || {}, prefix) || {};
      var thisFn = function() {
        delete parentContIn.coloraxis;
        delete parentContOut.coloraxis;
        return colorScaleDefaults(parentContIn, parentContOut, layout, coerce, opts);
      };
      if (inTrace) {
        var colorAxes = layout._colorAxes || {};
        var colorAx = coerce(prefix + "coloraxis");
        if (colorAx) {
          var colorbarVisuals = traceIs(parentContOut, "contour") && Lib.nestedProperty(parentContOut, "contours.coloring").get() || "heatmap";
          var stash = colorAxes[colorAx];
          if (stash) {
            stash[2].push(thisFn);
            if (stash[0] !== colorbarVisuals) {
              stash[0] = false;
              Lib.warn([
                "Ignoring coloraxis:",
                colorAx,
                "setting",
                "as it is linked to incompatible colorscales."
              ].join(" "));
            }
          } else {
            colorAxes[colorAx] = [colorbarVisuals, parentContOut, [thisFn]];
          }
          return;
        }
      }
      var minIn = containerIn[cLetter + "min"];
      var maxIn = containerIn[cLetter + "max"];
      var validMinMax = isNumeric(minIn) && isNumeric(maxIn) && minIn < maxIn;
      var auto = coerce(prefix + cLetter + "auto", !validMinMax);
      if (auto) {
        coerce(prefix + cLetter + "mid");
      } else {
        coerce(prefix + cLetter + "min");
        coerce(prefix + cLetter + "max");
      }
      var sclIn = containerIn.colorscale;
      var sclTemplate = template.colorscale;
      var autoColorscaleDflt;
      if (sclIn !== void 0) autoColorscaleDflt = !isValidScale(sclIn);
      if (sclTemplate !== void 0) autoColorscaleDflt = !isValidScale(sclTemplate);
      coerce(prefix + "autocolorscale", autoColorscaleDflt);
      coerce(prefix + "colorscale");
      coerce(prefix + "reversescale");
      if (prefix !== "marker.line.") {
        var showScaleDflt;
        if (prefix && inTrace) showScaleDflt = hasColorbar(containerIn);
        var showScale = coerce(prefix + "showscale", showScaleDflt);
        if (showScale) {
          if (prefix && template) containerOut._template = template;
          colorbarDefaults(containerIn, containerOut, layout);
        }
      }
    };
  }
});

// node_modules/plotly.js/src/components/colorscale/layout_defaults.js
var require_layout_defaults = __commonJS({
  "node_modules/plotly.js/src/components/colorscale/layout_defaults.js"(exports2, module2) {
    "use strict";
    var Lib = require_lib();
    var Template = require_plot_template();
    var colorScaleAttrs = require_layout_attributes5();
    var colorScaleDefaults = require_defaults2();
    module2.exports = function supplyLayoutDefaults(layoutIn, layoutOut) {
      function coerce(attr, dflt) {
        return Lib.coerce(layoutIn, layoutOut, colorScaleAttrs, attr, dflt);
      }
      coerce("colorscale.sequential");
      coerce("colorscale.sequentialminus");
      coerce("colorscale.diverging");
      var colorAxes = layoutOut._colorAxes;
      var colorAxIn, colorAxOut;
      function coerceAx(attr, dflt) {
        return Lib.coerce(colorAxIn, colorAxOut, colorScaleAttrs.coloraxis, attr, dflt);
      }
      for (var k in colorAxes) {
        var stash = colorAxes[k];
        if (stash[0]) {
          colorAxIn = layoutIn[k] || {};
          colorAxOut = Template.newContainer(layoutOut, k, "coloraxis");
          colorAxOut._name = k;
          colorScaleDefaults(colorAxIn, colorAxOut, layoutOut, coerceAx, { prefix: "", cLetter: "c" });
        } else {
          for (var i = 0; i < stash[2].length; i++) {
            stash[2][i]();
          }
          delete layoutOut._colorAxes[k];
        }
      }
    };
  }
});

// node_modules/plotly.js/src/components/colorscale/cross_trace_defaults.js
var require_cross_trace_defaults = __commonJS({
  "node_modules/plotly.js/src/components/colorscale/cross_trace_defaults.js"(exports2, module2) {
    "use strict";
    var Lib = require_lib();
    var hasColorscale = require_helpers().hasColorscale;
    var extractOpts = require_helpers().extractOpts;
    module2.exports = function crossTraceDefaults(fullData, fullLayout) {
      function replace(cont, k2) {
        var val = cont["_" + k2];
        if (val !== void 0) {
          cont[k2] = val;
        }
      }
      function relinkColorAttrs(outerCont, cbOpt) {
        var cont = cbOpt.container ? Lib.nestedProperty(outerCont, cbOpt.container).get() : outerCont;
        if (cont) {
          if (cont.coloraxis) {
            cont._colorAx = fullLayout[cont.coloraxis];
          } else {
            var cOpts = extractOpts(cont);
            var isAuto = cOpts.auto;
            if (isAuto || cOpts.min === void 0) {
              replace(cont, cbOpt.min);
            }
            if (isAuto || cOpts.max === void 0) {
              replace(cont, cbOpt.max);
            }
            if (cOpts.autocolorscale) {
              replace(cont, "colorscale");
            }
          }
        }
      }
      for (var i = 0; i < fullData.length; i++) {
        var trace = fullData[i];
        var cbOpts = trace._module.colorbar;
        if (cbOpts) {
          if (Array.isArray(cbOpts)) {
            for (var j = 0; j < cbOpts.length; j++) {
              relinkColorAttrs(trace, cbOpts[j]);
            }
          } else {
            relinkColorAttrs(trace, cbOpts);
          }
        }
        if (hasColorscale(trace, "marker.line")) {
          relinkColorAttrs(trace, {
            container: "marker.line",
            min: "cmin",
            max: "cmax"
          });
        }
      }
      for (var k in fullLayout._colorAxes) {
        relinkColorAttrs(fullLayout[k], { min: "cmin", max: "cmax" });
      }
    };
  }
});

// node_modules/plotly.js/src/components/colorscale/calc.js
var require_calc = __commonJS({
  "node_modules/plotly.js/src/components/colorscale/calc.js"(exports2, module2) {
    "use strict";
    var isNumeric = require_fast_isnumeric();
    var Lib = require_lib();
    var extractOpts = require_helpers().extractOpts;
    module2.exports = function calc(gd2, trace, opts) {
      var fullLayout = gd2._fullLayout;
      var vals = opts.vals;
      var containerStr = opts.containerStr;
      var container = containerStr ? Lib.nestedProperty(trace, containerStr).get() : trace;
      var cOpts = extractOpts(container);
      var auto = cOpts.auto !== false;
      var min = cOpts.min;
      var max = cOpts.max;
      var mid = cOpts.mid;
      var minVal = function() {
        return Lib.aggNums(Math.min, null, vals);
      };
      var maxVal = function() {
        return Lib.aggNums(Math.max, null, vals);
      };
      if (min === void 0) {
        min = minVal();
      } else if (auto) {
        if (container._colorAx && isNumeric(min)) {
          min = Math.min(min, minVal());
        } else {
          min = minVal();
        }
      }
      if (max === void 0) {
        max = maxVal();
      } else if (auto) {
        if (container._colorAx && isNumeric(max)) {
          max = Math.max(max, maxVal());
        } else {
          max = maxVal();
        }
      }
      if (auto && mid !== void 0) {
        if (max - mid > mid - min) {
          min = mid - (max - mid);
        } else if (max - mid < mid - min) {
          max = mid + (mid - min);
        }
      }
      if (min === max) {
        min -= 0.5;
        max += 0.5;
      }
      cOpts._sync("min", min);
      cOpts._sync("max", max);
      if (cOpts.autocolorscale) {
        var scl;
        if (min * max < 0) scl = fullLayout.colorscale.diverging;
        else if (min >= 0) scl = fullLayout.colorscale.sequential;
        else scl = fullLayout.colorscale.sequentialminus;
        cOpts._sync("colorscale", scl);
      }
    };
  }
});

// node_modules/plotly.js/src/components/colorscale/index.js
var require_colorscale = __commonJS({
  "node_modules/plotly.js/src/components/colorscale/index.js"(exports2, module2) {
    "use strict";
    var scales = require_scales();
    var helpers = require_helpers();
    module2.exports = {
      moduleType: "component",
      name: "colorscale",
      attributes: require_attributes8(),
      layoutAttributes: require_layout_attributes5(),
      supplyLayoutDefaults: require_layout_defaults(),
      handleDefaults: require_defaults2(),
      crossTraceDefaults: require_cross_trace_defaults(),
      calc: require_calc(),
      // ./scales.js is required in lib/coerce.js ;
      // it needs to be a separate module to avoid a circular dependency
      scales: scales.scales,
      defaultScale: scales.defaultScale,
      getScale: scales.get,
      isValidScale: scales.isValid,
      hasColorscale: helpers.hasColorscale,
      extractOpts: helpers.extractOpts,
      extractScale: helpers.extractScale,
      flipScale: helpers.flipScale,
      makeColorScaleFunc: helpers.makeColorScaleFunc,
      makeColorScaleFuncFromTrace: helpers.makeColorScaleFuncFromTrace
    };
  }
});

// node_modules/plotly.js/src/traces/scatter/subtypes.js
var require_subtypes = __commonJS({
  "node_modules/plotly.js/src/traces/scatter/subtypes.js"(exports2, module2) {
    "use strict";
    var Lib = require_lib();
    var isTypedArraySpec = require_array().isTypedArraySpec;
    module2.exports = {
      hasLines: function(trace) {
        return trace.visible && trace.mode && trace.mode.indexOf("lines") !== -1;
      },
      hasMarkers: function(trace) {
        return trace.visible && (trace.mode && trace.mode.indexOf("markers") !== -1 || // until splom implements 'mode'
        trace.type === "splom");
      },
      hasText: function(trace) {
        return trace.visible && trace.mode && trace.mode.indexOf("text") !== -1;
      },
      isBubble: function(trace) {
        var marker = trace.marker;
        return Lib.isPlainObject(marker) && (Lib.isArrayOrTypedArray(marker.size) || isTypedArraySpec(marker.size));
      }
    };
  }
});

// node_modules/plotly.js/src/traces/scatter/make_bubble_size_func.js
var require_make_bubble_size_func = __commonJS({
  "node_modules/plotly.js/src/traces/scatter/make_bubble_size_func.js"(exports2, module2) {
    "use strict";
    var isNumeric = require_fast_isnumeric();
    module2.exports = function makeBubbleSizeFn(trace, factor) {
      if (!factor) {
        factor = 2;
      }
      var marker = trace.marker;
      var sizeRef = marker.sizeref || 1;
      var sizeMin = marker.sizemin || 0;
      var baseFn = marker.sizemode === "area" ? function(v) {
        return Math.sqrt(v / sizeRef);
      } : function(v) {
        return v / sizeRef;
      };
      return function(v) {
        var baseSize = baseFn(v / factor);
        return isNumeric(baseSize) && baseSize > 0 ? Math.max(baseSize, sizeMin) : 0;
      };
    };
  }
});

// node_modules/plotly.js/src/components/fx/helpers.js
var require_helpers2 = __commonJS({
  "node_modules/plotly.js/src/components/fx/helpers.js"(exports2) {
    "use strict";
    var Lib = require_lib();
    exports2.getSubplot = function(trace) {
      return trace.subplot || trace.xaxis + trace.yaxis || trace.geo;
    };
    exports2.isTraceInSubplots = function(trace, subplots) {
      if (trace.type === "splom") {
        var xaxes = trace.xaxes || [];
        var yaxes = trace.yaxes || [];
        for (var i = 0; i < xaxes.length; i++) {
          for (var j = 0; j < yaxes.length; j++) {
            if (subplots.indexOf(xaxes[i] + yaxes[j]) !== -1) {
              return true;
            }
          }
        }
        return false;
      }
      return subplots.indexOf(exports2.getSubplot(trace)) !== -1;
    };
    exports2.flat = function(subplots, v) {
      var out = new Array(subplots.length);
      for (var i = 0; i < subplots.length; i++) {
        out[i] = v;
      }
      return out;
    };
    exports2.p2c = function(axArray, v) {
      var out = new Array(axArray.length);
      for (var i = 0; i < axArray.length; i++) {
        out[i] = axArray[i].p2c(v);
      }
      return out;
    };
    exports2.getDistanceFunction = function(mode, dx, dy, dxy) {
      if (mode === "closest") return dxy || exports2.quadrature(dx, dy);
      return mode.charAt(0) === "x" ? dx : dy;
    };
    exports2.getClosest = function(cd2, distfn, pointData) {
      if (pointData.index !== false) {
        if (pointData.index >= 0 && pointData.index < cd2.length) {
          pointData.distance = 0;
        } else pointData.index = false;
      } else {
        for (var i = 0; i < cd2.length; i++) {
          var newDistance = distfn(cd2[i]);
          if (newDistance <= pointData.distance) {
            pointData.index = i;
            pointData.distance = newDistance;
          }
        }
      }
      return pointData;
    };
    exports2.inbox = function(v02, v12, passVal) {
      return v02 * v12 < 0 || v02 === 0 ? passVal : Infinity;
    };
    exports2.quadrature = function(dx, dy) {
      return function(di2) {
        var x = dx(di2);
        var y = dy(di2);
        return Math.sqrt(x * x + y * y);
      };
    };
    exports2.makeEventData = function(pt2, trace, cd2) {
      var pointNumber = "index" in pt2 ? pt2.index : pt2.pointNumber;
      var out = {
        data: trace._input,
        fullData: trace,
        curveNumber: trace.index,
        pointNumber
      };
      if (trace._indexToPoints) {
        var pointIndices = trace._indexToPoints[pointNumber];
        if (pointIndices.length === 1) {
          out.pointIndex = pointIndices[0];
        } else {
          out.pointIndices = pointIndices;
        }
      } else {
        out.pointIndex = pointNumber;
      }
      if (trace._module.eventData) {
        out = trace._module.eventData(out, pt2, trace, cd2, pointNumber);
      } else {
        if ("xVal" in pt2) out.x = pt2.xVal;
        else if ("x" in pt2) out.x = pt2.x;
        if ("yVal" in pt2) out.y = pt2.yVal;
        else if ("y" in pt2) out.y = pt2.y;
        if (pt2.xa) out.xaxis = pt2.xa;
        if (pt2.ya) out.yaxis = pt2.ya;
        if (pt2.zLabelVal !== void 0) out.z = pt2.zLabelVal;
      }
      exports2.appendArrayPointValue(out, trace, pointNumber);
      return out;
    };
    exports2.appendArrayPointValue = function(pointData, trace, pointNumber) {
      var arrayAttrs = trace._arrayAttrs;
      if (!arrayAttrs) {
        return;
      }
      for (var i = 0; i < arrayAttrs.length; i++) {
        var astr = arrayAttrs[i];
        var key = getPointKey(astr);
        if (pointData[key] === void 0) {
          var val = Lib.nestedProperty(trace, astr).get();
          var pointVal = getPointData(val, pointNumber);
          if (pointVal !== void 0) pointData[key] = pointVal;
        }
      }
    };
    exports2.appendArrayMultiPointValues = function(pointData, trace, pointNumbers) {
      var arrayAttrs = trace._arrayAttrs;
      if (!arrayAttrs) {
        return;
      }
      for (var i = 0; i < arrayAttrs.length; i++) {
        var astr = arrayAttrs[i];
        var key = getPointKey(astr);
        if (pointData[key] === void 0) {
          var val = Lib.nestedProperty(trace, astr).get();
          var keyVal = new Array(pointNumbers.length);
          for (var j = 0; j < pointNumbers.length; j++) {
            keyVal[j] = getPointData(val, pointNumbers[j]);
          }
          pointData[key] = keyVal;
        }
      }
    };
    var pointKeyMap = {
      ids: "id",
      locations: "location",
      labels: "label",
      values: "value",
      "marker.colors": "color",
      parents: "parent"
    };
    function getPointKey(astr) {
      return pointKeyMap[astr] || astr;
    }
    function getPointData(val, pointNumber) {
      if (Array.isArray(pointNumber)) {
        if (Array.isArray(val) && Array.isArray(val[pointNumber[0]])) {
          return val[pointNumber[0]][pointNumber[1]];
        }
      } else {
        return val[pointNumber];
      }
    }
    var xyHoverMode = {
      x: true,
      y: true
    };
    var unifiedHoverMode = {
      "x unified": true,
      "y unified": true
    };
    exports2.isUnifiedHover = function(hovermode) {
      if (typeof hovermode !== "string") return false;
      return !!unifiedHoverMode[hovermode];
    };
    exports2.isXYhover = function(hovermode) {
      if (typeof hovermode !== "string") return false;
      return !!xyHoverMode[hovermode];
    };
  }
});

// node_modules/parse-svg-path/index.js
var require_parse_svg_path = __commonJS({
  "node_modules/parse-svg-path/index.js"(exports2, module2) {
    module2.exports = parse;
    var length = { a: 7, c: 6, h: 1, l: 2, m: 2, q: 4, s: 4, t: 2, v: 1, z: 0 };
    var segment = /([astvzqmhlc])([^astvzqmhlc]*)/ig;
    function parse(path) {
      var data = [];
      path.replace(segment, function(_, command, args) {
        var type = command.toLowerCase();
        args = parseValues(args);
        if (type == "m" && args.length > 2) {
          data.push([command].concat(args.splice(0, 2)));
          type = "l";
          command = command == "m" ? "l" : "L";
        }
        while (true) {
          if (args.length == length[type]) {
            args.unshift(command);
            return data.push(args);
          }
          if (args.length < length[type]) throw new Error("malformed path data");
          data.push([command].concat(args.splice(0, length[type])));
        }
      });
      return data;
    }
    var number = /-?[0-9]*\.?[0-9]+(?:e[-+]?\d+)?/ig;
    function parseValues(args) {
      var numbers = args.match(number);
      return numbers ? numbers.map(Number) : [];
    }
  }
});

// node_modules/plotly.js/src/components/drawing/symbol_defs.js
var require_symbol_defs = __commonJS({
  "node_modules/plotly.js/src/components/drawing/symbol_defs.js"(exports2, module2) {
    "use strict";
    var parseSvgPath = require_parse_svg_path();
    var round = require_d3().round;
    var emptyPath = "M0,0Z";
    var sqrt2 = Math.sqrt(2);
    var sqrt3 = Math.sqrt(3);
    var PI = Math.PI;
    var cos = Math.cos;
    var sin = Math.sin;
    module2.exports = {
      circle: {
        n: 0,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rs2 = round(r, 2);
          var circle = "M" + rs2 + ",0A" + rs2 + "," + rs2 + " 0 1,1 0,-" + rs2 + "A" + rs2 + "," + rs2 + " 0 0,1 " + rs2 + ",0Z";
          return standoff ? align(angle, standoff, circle) : circle;
        }
      },
      square: {
        n: 1,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rs2 = round(r, 2);
          return align(angle, standoff, "M" + rs2 + "," + rs2 + "H-" + rs2 + "V-" + rs2 + "H" + rs2 + "Z");
        }
      },
      diamond: {
        n: 2,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rd2 = round(r * 1.3, 2);
          return align(angle, standoff, "M" + rd2 + ",0L0," + rd2 + "L-" + rd2 + ",0L0,-" + rd2 + "Z");
        }
      },
      cross: {
        n: 3,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rc2 = round(r * 0.4, 2);
          var rc22 = round(r * 1.2, 2);
          return align(angle, standoff, "M" + rc22 + "," + rc2 + "H" + rc2 + "V" + rc22 + "H-" + rc2 + "V" + rc2 + "H-" + rc22 + "V-" + rc2 + "H-" + rc2 + "V-" + rc22 + "H" + rc2 + "V-" + rc2 + "H" + rc22 + "Z");
        }
      },
      x: {
        n: 4,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rx = round(r * 0.8 / sqrt2, 2);
          var ne2 = "l" + rx + "," + rx;
          var se2 = "l" + rx + ",-" + rx;
          var sw = "l-" + rx + ",-" + rx;
          var nw = "l-" + rx + "," + rx;
          return align(angle, standoff, "M0," + rx + ne2 + se2 + sw + se2 + sw + nw + sw + nw + ne2 + nw + ne2 + "Z");
        }
      },
      "triangle-up": {
        n: 5,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rt2 = round(r * 2 / sqrt3, 2);
          var r2 = round(r / 2, 2);
          var rs2 = round(r, 2);
          return align(angle, standoff, "M-" + rt2 + "," + r2 + "H" + rt2 + "L0,-" + rs2 + "Z");
        }
      },
      "triangle-down": {
        n: 6,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rt2 = round(r * 2 / sqrt3, 2);
          var r2 = round(r / 2, 2);
          var rs2 = round(r, 2);
          return align(angle, standoff, "M-" + rt2 + ",-" + r2 + "H" + rt2 + "L0," + rs2 + "Z");
        }
      },
      "triangle-left": {
        n: 7,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rt2 = round(r * 2 / sqrt3, 2);
          var r2 = round(r / 2, 2);
          var rs2 = round(r, 2);
          return align(angle, standoff, "M" + r2 + ",-" + rt2 + "V" + rt2 + "L-" + rs2 + ",0Z");
        }
      },
      "triangle-right": {
        n: 8,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rt2 = round(r * 2 / sqrt3, 2);
          var r2 = round(r / 2, 2);
          var rs2 = round(r, 2);
          return align(angle, standoff, "M-" + r2 + ",-" + rt2 + "V" + rt2 + "L" + rs2 + ",0Z");
        }
      },
      "triangle-ne": {
        n: 9,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var r12 = round(r * 0.6, 2);
          var r2 = round(r * 1.2, 2);
          return align(angle, standoff, "M-" + r2 + ",-" + r12 + "H" + r12 + "V" + r2 + "Z");
        }
      },
      "triangle-se": {
        n: 10,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var r12 = round(r * 0.6, 2);
          var r2 = round(r * 1.2, 2);
          return align(angle, standoff, "M" + r12 + ",-" + r2 + "V" + r12 + "H-" + r2 + "Z");
        }
      },
      "triangle-sw": {
        n: 11,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var r12 = round(r * 0.6, 2);
          var r2 = round(r * 1.2, 2);
          return align(angle, standoff, "M" + r2 + "," + r12 + "H-" + r12 + "V-" + r2 + "Z");
        }
      },
      "triangle-nw": {
        n: 12,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var r12 = round(r * 0.6, 2);
          var r2 = round(r * 1.2, 2);
          return align(angle, standoff, "M-" + r12 + "," + r2 + "V-" + r12 + "H" + r2 + "Z");
        }
      },
      pentagon: {
        n: 13,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var x12 = round(r * 0.951, 2);
          var x2 = round(r * 0.588, 2);
          var y02 = round(-r, 2);
          var y12 = round(r * -0.309, 2);
          var y2 = round(r * 0.809, 2);
          return align(angle, standoff, "M" + x12 + "," + y12 + "L" + x2 + "," + y2 + "H-" + x2 + "L-" + x12 + "," + y12 + "L0," + y02 + "Z");
        }
      },
      hexagon: {
        n: 14,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var y02 = round(r, 2);
          var y12 = round(r / 2, 2);
          var x = round(r * sqrt3 / 2, 2);
          return align(angle, standoff, "M" + x + ",-" + y12 + "V" + y12 + "L0," + y02 + "L-" + x + "," + y12 + "V-" + y12 + "L0,-" + y02 + "Z");
        }
      },
      hexagon2: {
        n: 15,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var x02 = round(r, 2);
          var x12 = round(r / 2, 2);
          var y = round(r * sqrt3 / 2, 2);
          return align(angle, standoff, "M-" + x12 + "," + y + "H" + x12 + "L" + x02 + ",0L" + x12 + ",-" + y + "H-" + x12 + "L-" + x02 + ",0Z");
        }
      },
      octagon: {
        n: 16,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var a = round(r * 0.924, 2);
          var b = round(r * 0.383, 2);
          return align(angle, standoff, "M-" + b + ",-" + a + "H" + b + "L" + a + ",-" + b + "V" + b + "L" + b + "," + a + "H-" + b + "L-" + a + "," + b + "V-" + b + "Z");
        }
      },
      star: {
        n: 17,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rs2 = r * 1.4;
          var x12 = round(rs2 * 0.225, 2);
          var x2 = round(rs2 * 0.951, 2);
          var x3 = round(rs2 * 0.363, 2);
          var x4 = round(rs2 * 0.588, 2);
          var y02 = round(-rs2, 2);
          var y12 = round(rs2 * -0.309, 2);
          var y3 = round(rs2 * 0.118, 2);
          var y4 = round(rs2 * 0.809, 2);
          var y5 = round(rs2 * 0.382, 2);
          return align(angle, standoff, "M" + x12 + "," + y12 + "H" + x2 + "L" + x3 + "," + y3 + "L" + x4 + "," + y4 + "L0," + y5 + "L-" + x4 + "," + y4 + "L-" + x3 + "," + y3 + "L-" + x2 + "," + y12 + "H-" + x12 + "L0," + y02 + "Z");
        }
      },
      hexagram: {
        n: 18,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var y = round(r * 0.66, 2);
          var x12 = round(r * 0.38, 2);
          var x2 = round(r * 0.76, 2);
          return align(angle, standoff, "M-" + x2 + ",0l-" + x12 + ",-" + y + "h" + x2 + "l" + x12 + ",-" + y + "l" + x12 + "," + y + "h" + x2 + "l-" + x12 + "," + y + "l" + x12 + "," + y + "h-" + x2 + "l-" + x12 + "," + y + "l-" + x12 + ",-" + y + "h-" + x2 + "Z");
        }
      },
      "star-triangle-up": {
        n: 19,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var x = round(r * sqrt3 * 0.8, 2);
          var y12 = round(r * 0.8, 2);
          var y2 = round(r * 1.6, 2);
          var rc2 = round(r * 4, 2);
          var aPart = "A " + rc2 + "," + rc2 + " 0 0 1 ";
          return align(angle, standoff, "M-" + x + "," + y12 + aPart + x + "," + y12 + aPart + "0,-" + y2 + aPart + "-" + x + "," + y12 + "Z");
        }
      },
      "star-triangle-down": {
        n: 20,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var x = round(r * sqrt3 * 0.8, 2);
          var y12 = round(r * 0.8, 2);
          var y2 = round(r * 1.6, 2);
          var rc2 = round(r * 4, 2);
          var aPart = "A " + rc2 + "," + rc2 + " 0 0 1 ";
          return align(angle, standoff, "M" + x + ",-" + y12 + aPart + "-" + x + ",-" + y12 + aPart + "0," + y2 + aPart + x + ",-" + y12 + "Z");
        }
      },
      "star-square": {
        n: 21,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rp2 = round(r * 1.1, 2);
          var rc2 = round(r * 2, 2);
          var aPart = "A " + rc2 + "," + rc2 + " 0 0 1 ";
          return align(angle, standoff, "M-" + rp2 + ",-" + rp2 + aPart + "-" + rp2 + "," + rp2 + aPart + rp2 + "," + rp2 + aPart + rp2 + ",-" + rp2 + aPart + "-" + rp2 + ",-" + rp2 + "Z");
        }
      },
      "star-diamond": {
        n: 22,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rp2 = round(r * 1.4, 2);
          var rc2 = round(r * 1.9, 2);
          var aPart = "A " + rc2 + "," + rc2 + " 0 0 1 ";
          return align(angle, standoff, "M-" + rp2 + ",0" + aPart + "0," + rp2 + aPart + rp2 + ",0" + aPart + "0,-" + rp2 + aPart + "-" + rp2 + ",0Z");
        }
      },
      "diamond-tall": {
        n: 23,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var x = round(r * 0.7, 2);
          var y = round(r * 1.4, 2);
          return align(angle, standoff, "M0," + y + "L" + x + ",0L0,-" + y + "L-" + x + ",0Z");
        }
      },
      "diamond-wide": {
        n: 24,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var x = round(r * 1.4, 2);
          var y = round(r * 0.7, 2);
          return align(angle, standoff, "M0," + y + "L" + x + ",0L0,-" + y + "L-" + x + ",0Z");
        }
      },
      hourglass: {
        n: 25,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rs2 = round(r, 2);
          return align(angle, standoff, "M" + rs2 + "," + rs2 + "H-" + rs2 + "L" + rs2 + ",-" + rs2 + "H-" + rs2 + "Z");
        },
        noDot: true
      },
      bowtie: {
        n: 26,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rs2 = round(r, 2);
          return align(angle, standoff, "M" + rs2 + "," + rs2 + "V-" + rs2 + "L-" + rs2 + "," + rs2 + "V-" + rs2 + "Z");
        },
        noDot: true
      },
      "circle-cross": {
        n: 27,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rs2 = round(r, 2);
          return align(angle, standoff, "M0," + rs2 + "V-" + rs2 + "M" + rs2 + ",0H-" + rs2 + "M" + rs2 + ",0A" + rs2 + "," + rs2 + " 0 1,1 0,-" + rs2 + "A" + rs2 + "," + rs2 + " 0 0,1 " + rs2 + ",0Z");
        },
        needLine: true,
        noDot: true
      },
      "circle-x": {
        n: 28,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rs2 = round(r, 2);
          var rc2 = round(r / sqrt2, 2);
          return align(angle, standoff, "M" + rc2 + "," + rc2 + "L-" + rc2 + ",-" + rc2 + "M" + rc2 + ",-" + rc2 + "L-" + rc2 + "," + rc2 + "M" + rs2 + ",0A" + rs2 + "," + rs2 + " 0 1,1 0,-" + rs2 + "A" + rs2 + "," + rs2 + " 0 0,1 " + rs2 + ",0Z");
        },
        needLine: true,
        noDot: true
      },
      "square-cross": {
        n: 29,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rs2 = round(r, 2);
          return align(angle, standoff, "M0," + rs2 + "V-" + rs2 + "M" + rs2 + ",0H-" + rs2 + "M" + rs2 + "," + rs2 + "H-" + rs2 + "V-" + rs2 + "H" + rs2 + "Z");
        },
        needLine: true,
        noDot: true
      },
      "square-x": {
        n: 30,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rs2 = round(r, 2);
          return align(angle, standoff, "M" + rs2 + "," + rs2 + "L-" + rs2 + ",-" + rs2 + "M" + rs2 + ",-" + rs2 + "L-" + rs2 + "," + rs2 + "M" + rs2 + "," + rs2 + "H-" + rs2 + "V-" + rs2 + "H" + rs2 + "Z");
        },
        needLine: true,
        noDot: true
      },
      "diamond-cross": {
        n: 31,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rd2 = round(r * 1.3, 2);
          return align(angle, standoff, "M" + rd2 + ",0L0," + rd2 + "L-" + rd2 + ",0L0,-" + rd2 + "ZM0,-" + rd2 + "V" + rd2 + "M-" + rd2 + ",0H" + rd2);
        },
        needLine: true,
        noDot: true
      },
      "diamond-x": {
        n: 32,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rd2 = round(r * 1.3, 2);
          var r2 = round(r * 0.65, 2);
          return align(angle, standoff, "M" + rd2 + ",0L0," + rd2 + "L-" + rd2 + ",0L0,-" + rd2 + "ZM-" + r2 + ",-" + r2 + "L" + r2 + "," + r2 + "M-" + r2 + "," + r2 + "L" + r2 + ",-" + r2);
        },
        needLine: true,
        noDot: true
      },
      "cross-thin": {
        n: 33,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rc2 = round(r * 1.4, 2);
          return align(angle, standoff, "M0," + rc2 + "V-" + rc2 + "M" + rc2 + ",0H-" + rc2);
        },
        needLine: true,
        noDot: true,
        noFill: true
      },
      "x-thin": {
        n: 34,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rx = round(r, 2);
          return align(angle, standoff, "M" + rx + "," + rx + "L-" + rx + ",-" + rx + "M" + rx + ",-" + rx + "L-" + rx + "," + rx);
        },
        needLine: true,
        noDot: true,
        noFill: true
      },
      asterisk: {
        n: 35,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rc2 = round(r * 1.2, 2);
          var rs2 = round(r * 0.85, 2);
          return align(angle, standoff, "M0," + rc2 + "V-" + rc2 + "M" + rc2 + ",0H-" + rc2 + "M" + rs2 + "," + rs2 + "L-" + rs2 + ",-" + rs2 + "M" + rs2 + ",-" + rs2 + "L-" + rs2 + "," + rs2);
        },
        needLine: true,
        noDot: true,
        noFill: true
      },
      hash: {
        n: 36,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var r12 = round(r / 2, 2);
          var r2 = round(r, 2);
          return align(angle, standoff, "M" + r12 + "," + r2 + "V-" + r2 + "M" + (r12 - r2) + ",-" + r2 + "V" + r2 + "M" + r2 + "," + r12 + "H-" + r2 + "M-" + r2 + "," + (r12 - r2) + "H" + r2);
        },
        needLine: true,
        noFill: true
      },
      "y-up": {
        n: 37,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var x = round(r * 1.2, 2);
          var y02 = round(r * 1.6, 2);
          var y12 = round(r * 0.8, 2);
          return align(angle, standoff, "M-" + x + "," + y12 + "L0,0M" + x + "," + y12 + "L0,0M0,-" + y02 + "L0,0");
        },
        needLine: true,
        noDot: true,
        noFill: true
      },
      "y-down": {
        n: 38,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var x = round(r * 1.2, 2);
          var y02 = round(r * 1.6, 2);
          var y12 = round(r * 0.8, 2);
          return align(angle, standoff, "M-" + x + ",-" + y12 + "L0,0M" + x + ",-" + y12 + "L0,0M0," + y02 + "L0,0");
        },
        needLine: true,
        noDot: true,
        noFill: true
      },
      "y-left": {
        n: 39,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var y = round(r * 1.2, 2);
          var x02 = round(r * 1.6, 2);
          var x12 = round(r * 0.8, 2);
          return align(angle, standoff, "M" + x12 + "," + y + "L0,0M" + x12 + ",-" + y + "L0,0M-" + x02 + ",0L0,0");
        },
        needLine: true,
        noDot: true,
        noFill: true
      },
      "y-right": {
        n: 40,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var y = round(r * 1.2, 2);
          var x02 = round(r * 1.6, 2);
          var x12 = round(r * 0.8, 2);
          return align(angle, standoff, "M-" + x12 + "," + y + "L0,0M-" + x12 + ",-" + y + "L0,0M" + x02 + ",0L0,0");
        },
        needLine: true,
        noDot: true,
        noFill: true
      },
      "line-ew": {
        n: 41,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rc2 = round(r * 1.4, 2);
          return align(angle, standoff, "M" + rc2 + ",0H-" + rc2);
        },
        needLine: true,
        noDot: true,
        noFill: true
      },
      "line-ns": {
        n: 42,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rc2 = round(r * 1.4, 2);
          return align(angle, standoff, "M0," + rc2 + "V-" + rc2);
        },
        needLine: true,
        noDot: true,
        noFill: true
      },
      "line-ne": {
        n: 43,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rx = round(r, 2);
          return align(angle, standoff, "M" + rx + ",-" + rx + "L-" + rx + "," + rx);
        },
        needLine: true,
        noDot: true,
        noFill: true
      },
      "line-nw": {
        n: 44,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rx = round(r, 2);
          return align(angle, standoff, "M" + rx + "," + rx + "L-" + rx + ",-" + rx);
        },
        needLine: true,
        noDot: true,
        noFill: true
      },
      "arrow-up": {
        n: 45,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rx = round(r, 2);
          var ry = round(r * 2, 2);
          return align(angle, standoff, "M0,0L-" + rx + "," + ry + "H" + rx + "Z");
        },
        backoff: 1,
        noDot: true
      },
      "arrow-down": {
        n: 46,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rx = round(r, 2);
          var ry = round(r * 2, 2);
          return align(angle, standoff, "M0,0L-" + rx + ",-" + ry + "H" + rx + "Z");
        },
        noDot: true
      },
      "arrow-left": {
        n: 47,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rx = round(r * 2, 2);
          var ry = round(r, 2);
          return align(angle, standoff, "M0,0L" + rx + ",-" + ry + "V" + ry + "Z");
        },
        noDot: true
      },
      "arrow-right": {
        n: 48,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rx = round(r * 2, 2);
          var ry = round(r, 2);
          return align(angle, standoff, "M0,0L-" + rx + ",-" + ry + "V" + ry + "Z");
        },
        noDot: true
      },
      "arrow-bar-up": {
        n: 49,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rx = round(r, 2);
          var ry = round(r * 2, 2);
          return align(angle, standoff, "M-" + rx + ",0H" + rx + "M0,0L-" + rx + "," + ry + "H" + rx + "Z");
        },
        backoff: 1,
        needLine: true,
        noDot: true
      },
      "arrow-bar-down": {
        n: 50,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rx = round(r, 2);
          var ry = round(r * 2, 2);
          return align(angle, standoff, "M-" + rx + ",0H" + rx + "M0,0L-" + rx + ",-" + ry + "H" + rx + "Z");
        },
        needLine: true,
        noDot: true
      },
      "arrow-bar-left": {
        n: 51,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rx = round(r * 2, 2);
          var ry = round(r, 2);
          return align(angle, standoff, "M0,-" + ry + "V" + ry + "M0,0L" + rx + ",-" + ry + "V" + ry + "Z");
        },
        needLine: true,
        noDot: true
      },
      "arrow-bar-right": {
        n: 52,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var rx = round(r * 2, 2);
          var ry = round(r, 2);
          return align(angle, standoff, "M0,-" + ry + "V" + ry + "M0,0L-" + rx + ",-" + ry + "V" + ry + "Z");
        },
        needLine: true,
        noDot: true
      },
      arrow: {
        n: 53,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var headAngle = PI / 2.5;
          var x = 2 * r * cos(headAngle);
          var y = 2 * r * sin(headAngle);
          return align(
            angle,
            standoff,
            "M0,0L" + -x + "," + y + "L" + x + "," + y + "Z"
          );
        },
        backoff: 0.9,
        noDot: true
      },
      "arrow-wide": {
        n: 54,
        f: function(r, angle, standoff) {
          if (skipAngle(angle)) return emptyPath;
          var headAngle = PI / 4;
          var x = 2 * r * cos(headAngle);
          var y = 2 * r * sin(headAngle);
          return align(
            angle,
            standoff,
            "M0,0L" + -x + "," + y + "A " + 2 * r + "," + 2 * r + " 0 0 1 " + x + "," + y + "Z"
          );
        },
        backoff: 0.4,
        noDot: true
      }
    };
    function skipAngle(angle) {
      return angle === null;
    }
    var lastPathIn;
    var lastPathOut;
    var lastAngle;
    var lastStandoff;
    function align(angle, standoff, path) {
      if ((!angle || angle % 360 === 0) && !standoff) return path;
      if (lastAngle === angle && lastStandoff === standoff && lastPathIn === path) return lastPathOut;
      lastAngle = angle;
      lastStandoff = standoff;
      lastPathIn = path;
      function rotate(t2, xy) {
        var cosT = cos(t2);
        var sinT = sin(t2);
        var x2 = xy[0];
        var y2 = xy[1] + (standoff || 0);
        return [
          x2 * cosT - y2 * sinT,
          x2 * sinT + y2 * cosT
        ];
      }
      var t = angle / 180 * PI;
      var x = 0;
      var y = 0;
      var cmd = parseSvgPath(path);
      var str = "";
      for (var i = 0; i < cmd.length; i++) {
        var cmdI = cmd[i];
        var op2 = cmdI[0];
        var x02 = x;
        var y02 = y;
        if (op2 === "M" || op2 === "L") {
          x = +cmdI[1];
          y = +cmdI[2];
        } else if (op2 === "m" || op2 === "l") {
          x += +cmdI[1];
          y += +cmdI[2];
        } else if (op2 === "H") {
          x = +cmdI[1];
        } else if (op2 === "h") {
          x += +cmdI[1];
        } else if (op2 === "V") {
          y = +cmdI[1];
        } else if (op2 === "v") {
          y += +cmdI[1];
        } else if (op2 === "A") {
          x = +cmdI[1];
          y = +cmdI[2];
          var E = rotate(t, [+cmdI[6], +cmdI[7]]);
          cmdI[6] = E[0];
          cmdI[7] = E[1];
          cmdI[3] = +cmdI[3] + angle;
        }
        if (op2 === "H" || op2 === "V") op2 = "L";
        if (op2 === "h" || op2 === "v") op2 = "l";
        if (op2 === "m" || op2 === "l") {
          x -= x02;
          y -= y02;
        }
        var B = rotate(t, [x, y]);
        if (op2 === "H" || op2 === "V") op2 = "L";
        if (op2 === "M" || op2 === "L" || op2 === "m" || op2 === "l") {
          cmdI[1] = B[0];
          cmdI[2] = B[1];
        }
        cmdI[0] = op2;
        str += cmdI[0] + cmdI.slice(1).join(",");
      }
      lastPathOut = str;
      return str;
    }
  }
});

// node_modules/plotly.js/src/components/drawing/index.js
var require_drawing = __commonJS({
  "node_modules/plotly.js/src/components/drawing/index.js"(exports2, module2) {
    "use strict";
    var d3 = require_d3();
    var Lib = require_lib();
    var numberFormat = Lib.numberFormat;
    var isNumeric = require_fast_isnumeric();
    var tinycolor = require_tinycolor();
    var Registry = require_registry();
    var Color = require_color();
    var Colorscale = require_colorscale();
    var strTranslate = Lib.strTranslate;
    var svgTextUtils = require_svg_text_utils();
    var xmlnsNamespaces = require_xmlns_namespaces();
    var alignment = require_alignment();
    var LINE_SPACING = alignment.LINE_SPACING;
    var DESELECTDIM = require_interactions().DESELECTDIM;
    var subTypes = require_subtypes();
    var makeBubbleSizeFn = require_make_bubble_size_func();
    var appendArrayPointValue = require_helpers2().appendArrayPointValue;
    var drawing = module2.exports = {};
    drawing.font = function(s, font) {
      var variant = font.variant;
      var style = font.style;
      var weight = font.weight;
      var color = font.color;
      var size = font.size;
      var family = font.family;
      var shadow = font.shadow;
      var lineposition = font.lineposition;
      var textcase = font.textcase;
      if (family) s.style("font-family", family);
      if (size + 1) s.style("font-size", size + "px");
      if (color) s.call(Color.fill, color);
      if (weight) s.style("font-weight", weight);
      if (style) s.style("font-style", style);
      if (variant) s.style("font-variant", variant);
      if (textcase) s.style("text-transform", dropNone(textcase2transform(textcase)));
      if (shadow) s.style("text-shadow", shadow === "auto" ? svgTextUtils.makeTextShadow(Color.contrast(color)) : dropNone(shadow));
      if (lineposition) s.style("text-decoration-line", dropNone(lineposition2decorationLine(lineposition)));
    };
    function dropNone(a) {
      return a === "none" ? void 0 : a;
    }
    var textcase2transformOptions = {
      normal: "none",
      lower: "lowercase",
      upper: "uppercase",
      "word caps": "capitalize"
    };
    function textcase2transform(textcase) {
      return textcase2transformOptions[textcase];
    }
    function lineposition2decorationLine(lineposition) {
      return lineposition.replace("under", "underline").replace("over", "overline").replace("through", "line-through").split("+").join(" ");
    }
    drawing.setPosition = function(s, x, y) {
      s.attr("x", x).attr("y", y);
    };
    drawing.setSize = function(s, w, h) {
      s.attr("width", w).attr("height", h);
    };
    drawing.setRect = function(s, x, y, w, h) {
      s.call(drawing.setPosition, x, y).call(drawing.setSize, w, h);
    };
    drawing.translatePoint = function(d, sel, xa2, ya2) {
      var x = xa2.c2p(d.x);
      var y = ya2.c2p(d.y);
      if (isNumeric(x) && isNumeric(y) && sel.node()) {
        if (sel.node().nodeName === "text") {
          sel.attr("x", x).attr("y", y);
        } else {
          sel.attr("transform", strTranslate(x, y));
        }
      } else {
        return false;
      }
      return true;
    };
    drawing.translatePoints = function(s, xa2, ya2) {
      s.each(function(d) {
        var sel = d3.select(this);
        drawing.translatePoint(d, sel, xa2, ya2);
      });
    };
    drawing.hideOutsideRangePoint = function(d, sel, xa2, ya2, xcalendar, ycalendar) {
      sel.attr(
        "display",
        xa2.isPtWithinRange(d, xcalendar) && ya2.isPtWithinRange(d, ycalendar) ? null : "none"
      );
    };
    drawing.hideOutsideRangePoints = function(traceGroups, subplot) {
      if (!subplot._hasClipOnAxisFalse) return;
      var xa2 = subplot.xaxis;
      var ya2 = subplot.yaxis;
      traceGroups.each(function(d) {
        var trace = d[0].trace;
        var xcalendar = trace.xcalendar;
        var ycalendar = trace.ycalendar;
        var selector = Registry.traceIs(trace, "bar-like") ? ".bartext" : ".point,.textpoint";
        traceGroups.selectAll(selector).each(function(d2) {
          drawing.hideOutsideRangePoint(d2, d3.select(this), xa2, ya2, xcalendar, ycalendar);
        });
      });
    };
    drawing.crispRound = function(gd2, lineWidth, dflt) {
      if (!lineWidth || !isNumeric(lineWidth)) return dflt || 0;
      if (gd2._context.staticPlot) return lineWidth;
      if (lineWidth < 1) return 1;
      return Math.round(lineWidth);
    };
    drawing.singleLineStyle = function(d, s, lw, lc2, ld2) {
      s.style("fill", "none");
      var line = (((d || [])[0] || {}).trace || {}).line || {};
      var lw1 = lw || line.width || 0;
      var dash = ld2 || line.dash || "";
      Color.stroke(s, lc2 || line.color);
      drawing.dashLine(s, dash, lw1);
    };
    drawing.lineGroupStyle = function(s, lw, lc2, ld2) {
      s.style("fill", "none").each(function(d) {
        var line = (((d || [])[0] || {}).trace || {}).line || {};
        var lw1 = lw || line.width || 0;
        var dash = ld2 || line.dash || "";
        d3.select(this).call(Color.stroke, lc2 || line.color).call(drawing.dashLine, dash, lw1);
      });
    };
    drawing.dashLine = function(s, dash, lineWidth) {
      lineWidth = +lineWidth || 0;
      dash = drawing.dashStyle(dash, lineWidth);
      s.style({
        "stroke-dasharray": dash,
        "stroke-width": lineWidth + "px"
      });
    };
    drawing.dashStyle = function(dash, lineWidth) {
      lineWidth = +lineWidth || 1;
      var dlw = Math.max(lineWidth, 3);
      if (dash === "solid") dash = "";
      else if (dash === "dot") dash = dlw + "px," + dlw + "px";
      else if (dash === "dash") dash = 3 * dlw + "px," + 3 * dlw + "px";
      else if (dash === "longdash") dash = 5 * dlw + "px," + 5 * dlw + "px";
      else if (dash === "dashdot") {
        dash = 3 * dlw + "px," + dlw + "px," + dlw + "px," + dlw + "px";
      } else if (dash === "longdashdot") {
        dash = 5 * dlw + "px," + 2 * dlw + "px," + dlw + "px," + 2 * dlw + "px";
      }
      return dash;
    };
    function setFillStyle(sel, trace, gd2, forLegend) {
      var markerPattern = trace.fillpattern;
      var fillgradient = trace.fillgradient;
      var patternShape = markerPattern && drawing.getPatternAttr(markerPattern.shape, 0, "");
      if (patternShape) {
        var patternBGColor = drawing.getPatternAttr(markerPattern.bgcolor, 0, null);
        var patternFGColor = drawing.getPatternAttr(markerPattern.fgcolor, 0, null);
        var patternFGOpacity = markerPattern.fgopacity;
        var patternSize = drawing.getPatternAttr(markerPattern.size, 0, 8);
        var patternSolidity = drawing.getPatternAttr(markerPattern.solidity, 0, 0.3);
        var patternID = trace.uid;
        drawing.pattern(
          sel,
          "point",
          gd2,
          patternID,
          patternShape,
          patternSize,
          patternSolidity,
          void 0,
          markerPattern.fillmode,
          patternBGColor,
          patternFGColor,
          patternFGOpacity
        );
      } else if (fillgradient && fillgradient.type !== "none") {
        var direction = fillgradient.type;
        var gradientID = "scatterfill-" + trace.uid;
        if (forLegend) {
          gradientID = "legendfill-" + trace.uid;
        }
        if (!forLegend && (fillgradient.start !== void 0 || fillgradient.stop !== void 0)) {
          var start, stop;
          if (direction === "horizontal") {
            start = {
              x: fillgradient.start,
              y: 0
            };
            stop = {
              x: fillgradient.stop,
              y: 0
            };
          } else if (direction === "vertical") {
            start = {
              x: 0,
              y: fillgradient.start
            };
            stop = {
              x: 0,
              y: fillgradient.stop
            };
          }
          start.x = trace._xA.c2p(
            start.x === void 0 ? trace._extremes.x.min[0].val : start.x,
            true
          );
          start.y = trace._yA.c2p(
            start.y === void 0 ? trace._extremes.y.min[0].val : start.y,
            true
          );
          stop.x = trace._xA.c2p(
            stop.x === void 0 ? trace._extremes.x.max[0].val : stop.x,
            true
          );
          stop.y = trace._yA.c2p(
            stop.y === void 0 ? trace._extremes.y.max[0].val : stop.y,
            true
          );
          sel.call(gradientWithBounds, gd2, gradientID, "linear", fillgradient.colorscale, "fill", start, stop, true, false);
        } else {
          if (direction === "horizontal") {
            direction = direction + "reversed";
          }
          sel.call(drawing.gradient, gd2, gradientID, direction, fillgradient.colorscale, "fill");
        }
      } else if (trace.fillcolor) {
        sel.call(Color.fill, trace.fillcolor);
      }
    }
    drawing.singleFillStyle = function(sel, gd2) {
      var node = d3.select(sel.node());
      var data = node.data();
      var trace = ((data[0] || [])[0] || {}).trace || {};
      setFillStyle(sel, trace, gd2, false);
    };
    drawing.fillGroupStyle = function(s, gd2, forLegend) {
      s.style("stroke-width", 0).each(function(d) {
        var shape = d3.select(this);
        if (d[0].trace) {
          setFillStyle(shape, d[0].trace, gd2, forLegend);
        }
      });
    };
    var SYMBOLDEFS = require_symbol_defs();
    drawing.symbolNames = [];
    drawing.symbolFuncs = [];
    drawing.symbolBackOffs = [];
    drawing.symbolNeedLines = {};
    drawing.symbolNoDot = {};
    drawing.symbolNoFill = {};
    drawing.symbolList = [];
    Object.keys(SYMBOLDEFS).forEach(function(k) {
      var symDef = SYMBOLDEFS[k];
      var n = symDef.n;
      drawing.symbolList.push(
        n,
        String(n),
        k,
        n + 100,
        String(n + 100),
        k + "-open"
      );
      drawing.symbolNames[n] = k;
      drawing.symbolFuncs[n] = symDef.f;
      drawing.symbolBackOffs[n] = symDef.backoff || 0;
      if (symDef.needLine) {
        drawing.symbolNeedLines[n] = true;
      }
      if (symDef.noDot) {
        drawing.symbolNoDot[n] = true;
      } else {
        drawing.symbolList.push(
          n + 200,
          String(n + 200),
          k + "-dot",
          n + 300,
          String(n + 300),
          k + "-open-dot"
        );
      }
      if (symDef.noFill) {
        drawing.symbolNoFill[n] = true;
      }
    });
    var MAXSYMBOL = drawing.symbolNames.length;
    var DOTPATH = "M0,0.5L0.5,0L0,-0.5L-0.5,0Z";
    drawing.symbolNumber = function(v) {
      if (isNumeric(v)) {
        v = +v;
      } else if (typeof v === "string") {
        var vbase = 0;
        if (v.indexOf("-open") > 0) {
          vbase = 100;
          v = v.replace("-open", "");
        }
        if (v.indexOf("-dot") > 0) {
          vbase += 200;
          v = v.replace("-dot", "");
        }
        v = drawing.symbolNames.indexOf(v);
        if (v >= 0) {
          v += vbase;
        }
      }
      return v % 100 >= MAXSYMBOL || v >= 400 ? 0 : Math.floor(Math.max(v, 0));
    };
    function makePointPath(symbolNumber, r, t, s) {
      var base = symbolNumber % 100;
      return drawing.symbolFuncs[base](r, t, s) + (symbolNumber >= 200 ? DOTPATH : "");
    }
    var stopFormatter = numberFormat("~f");
    var gradientInfo = {
      radial: { type: "radial" },
      radialreversed: { type: "radial", reversed: true },
      horizontal: { type: "linear", start: { x: 1, y: 0 }, stop: { x: 0, y: 0 } },
      horizontalreversed: { type: "linear", start: { x: 1, y: 0 }, stop: { x: 0, y: 0 }, reversed: true },
      vertical: { type: "linear", start: { x: 0, y: 1 }, stop: { x: 0, y: 0 } },
      verticalreversed: { type: "linear", start: { x: 0, y: 1 }, stop: { x: 0, y: 0 }, reversed: true }
    };
    drawing.gradient = function(sel, gd2, gradientID, type, colorscale, prop) {
      var info = gradientInfo[type];
      return gradientWithBounds(
        sel,
        gd2,
        gradientID,
        info.type,
        colorscale,
        prop,
        info.start,
        info.stop,
        false,
        info.reversed
      );
    };
    function gradientWithBounds(sel, gd2, gradientID, type, colorscale, prop, start, stop, inUserSpace, reversed) {
      var len = colorscale.length;
      var info;
      if (type === "linear") {
        info = {
          node: "linearGradient",
          attrs: {
            x1: start.x,
            y1: start.y,
            x2: stop.x,
            y2: stop.y,
            gradientUnits: inUserSpace ? "userSpaceOnUse" : "objectBoundingBox"
          },
          reversed
        };
      } else if (type === "radial") {
        info = {
          node: "radialGradient",
          reversed
        };
      }
      var colorStops = new Array(len);
      for (var i = 0; i < len; i++) {
        if (info.reversed) {
          colorStops[len - 1 - i] = [stopFormatter((1 - colorscale[i][0]) * 100), colorscale[i][1]];
        } else {
          colorStops[i] = [stopFormatter(colorscale[i][0] * 100), colorscale[i][1]];
        }
      }
      var fullLayout = gd2._fullLayout;
      var fullID = "g" + fullLayout._uid + "-" + gradientID;
      var gradient = fullLayout._defs.select(".gradients").selectAll("#" + fullID).data([type + colorStops.join(";")], Lib.identity);
      gradient.exit().remove();
      gradient.enter().append(info.node).each(function() {
        var el = d3.select(this);
        if (info.attrs) el.attr(info.attrs);
        el.attr("id", fullID);
        var stops = el.selectAll("stop").data(colorStops);
        stops.exit().remove();
        stops.enter().append("stop");
        stops.each(function(d) {
          var tc2 = tinycolor(d[1]);
          d3.select(this).attr({
            offset: d[0] + "%",
            "stop-color": Color.tinyRGB(tc2),
            "stop-opacity": tc2.getAlpha()
          });
        });
      });
      sel.style(prop, getFullUrl(fullID, gd2)).style(prop + "-opacity", null);
      sel.classed("gradient_filled", true);
    }
    drawing.pattern = function(sel, calledBy, gd2, patternID, shape, size, solidity, mcc, fillmode, bgcolor, fgcolor, fgopacity) {
      var isLegend = calledBy === "legend";
      if (mcc) {
        if (fillmode === "overlay") {
          bgcolor = mcc;
          fgcolor = Color.contrast(bgcolor);
        } else {
          bgcolor = void 0;
          fgcolor = mcc;
        }
      }
      var fullLayout = gd2._fullLayout;
      var fullID = "p" + fullLayout._uid + "-" + patternID;
      var width, height;
      var linearFn = function(x, x02, x12, y02, y12) {
        return y02 + (y12 - y02) * (x - x02) / (x12 - x02);
      };
      var path, linewidth, radius;
      var patternTag;
      var patternAttrs = {};
      var fgC = tinycolor(fgcolor);
      var fgRGB = Color.tinyRGB(fgC);
      var fgAlpha = fgC.getAlpha();
      var opacity = fgopacity * fgAlpha;
      switch (shape) {
        case "/":
          width = size * Math.sqrt(2);
          height = size * Math.sqrt(2);
          path = "M-" + width / 4 + "," + height / 4 + "l" + width / 2 + ",-" + height / 2 + "M0," + height + "L" + width + ",0M" + width / 4 * 3 + "," + height / 4 * 5 + "l" + width / 2 + ",-" + height / 2;
          linewidth = solidity * size;
          patternTag = "path";
          patternAttrs = {
            d: path,
            opacity,
            stroke: fgRGB,
            "stroke-width": linewidth + "px"
          };
          break;
        case "\\":
          width = size * Math.sqrt(2);
          height = size * Math.sqrt(2);
          path = "M" + width / 4 * 3 + ",-" + height / 4 + "l" + width / 2 + "," + height / 2 + "M0,0L" + width + "," + height + "M-" + width / 4 + "," + height / 4 * 3 + "l" + width / 2 + "," + height / 2;
          linewidth = solidity * size;
          patternTag = "path";
          patternAttrs = {
            d: path,
            opacity,
            stroke: fgRGB,
            "stroke-width": linewidth + "px"
          };
          break;
        case "x":
          width = size * Math.sqrt(2);
          height = size * Math.sqrt(2);
          path = "M-" + width / 4 + "," + height / 4 + "l" + width / 2 + ",-" + height / 2 + "M0," + height + "L" + width + ",0M" + width / 4 * 3 + "," + height / 4 * 5 + "l" + width / 2 + ",-" + height / 2 + "M" + width / 4 * 3 + ",-" + height / 4 + "l" + width / 2 + "," + height / 2 + "M0,0L" + width + "," + height + "M-" + width / 4 + "," + height / 4 * 3 + "l" + width / 2 + "," + height / 2;
          linewidth = size - size * Math.sqrt(1 - solidity);
          patternTag = "path";
          patternAttrs = {
            d: path,
            opacity,
            stroke: fgRGB,
            "stroke-width": linewidth + "px"
          };
          break;
        case "|":
          width = size;
          height = size;
          patternTag = "path";
          path = "M" + width / 2 + ",0L" + width / 2 + "," + height;
          linewidth = solidity * size;
          patternTag = "path";
          patternAttrs = {
            d: path,
            opacity,
            stroke: fgRGB,
            "stroke-width": linewidth + "px"
          };
          break;
        case "-":
          width = size;
          height = size;
          patternTag = "path";
          path = "M0," + height / 2 + "L" + width + "," + height / 2;
          linewidth = solidity * size;
          patternTag = "path";
          patternAttrs = {
            d: path,
            opacity,
            stroke: fgRGB,
            "stroke-width": linewidth + "px"
          };
          break;
        case "+":
          width = size;
          height = size;
          patternTag = "path";
          path = "M" + width / 2 + ",0L" + width / 2 + "," + height + "M0," + height / 2 + "L" + width + "," + height / 2;
          linewidth = size - size * Math.sqrt(1 - solidity);
          patternTag = "path";
          patternAttrs = {
            d: path,
            opacity,
            stroke: fgRGB,
            "stroke-width": linewidth + "px"
          };
          break;
        case ".":
          width = size;
          height = size;
          if (solidity < Math.PI / 4) {
            radius = Math.sqrt(solidity * size * size / Math.PI);
          } else {
            radius = linearFn(solidity, Math.PI / 4, 1, size / 2, size / Math.sqrt(2));
          }
          patternTag = "circle";
          patternAttrs = {
            cx: width / 2,
            cy: height / 2,
            r: radius,
            opacity,
            fill: fgRGB
          };
          break;
      }
      var str = [
        shape || "noSh",
        bgcolor || "noBg",
        fgcolor || "noFg",
        size,
        solidity
      ].join(";");
      var pattern = fullLayout._defs.select(".patterns").selectAll("#" + fullID).data([str], Lib.identity);
      pattern.exit().remove();
      pattern.enter().append("pattern").each(function() {
        var el = d3.select(this);
        el.attr({
          id: fullID,
          width: width + "px",
          height: height + "px",
          patternUnits: "userSpaceOnUse",
          // for legends scale down patterns just a bit so that default size (i.e 8) nicely fit in small icons
          patternTransform: isLegend ? "scale(0.8)" : ""
        });
        if (bgcolor) {
          var bgC = tinycolor(bgcolor);
          var bgRGB = Color.tinyRGB(bgC);
          var bgAlpha = bgC.getAlpha();
          var rects = el.selectAll("rect").data([0]);
          rects.exit().remove();
          rects.enter().append("rect").attr({
            width: width + "px",
            height: height + "px",
            fill: bgRGB,
            "fill-opacity": bgAlpha
          });
        }
        var patterns = el.selectAll(patternTag).data([0]);
        patterns.exit().remove();
        patterns.enter().append(patternTag).attr(patternAttrs);
      });
      sel.style("fill", getFullUrl(fullID, gd2)).style("fill-opacity", null);
      sel.classed("pattern_filled", true);
    };
    drawing.initGradients = function(gd2) {
      var fullLayout = gd2._fullLayout;
      var gradientsGroup = Lib.ensureSingle(fullLayout._defs, "g", "gradients");
      gradientsGroup.selectAll("linearGradient,radialGradient").remove();
      d3.select(gd2).selectAll(".gradient_filled").classed("gradient_filled", false);
    };
    drawing.initPatterns = function(gd2) {
      var fullLayout = gd2._fullLayout;
      var patternsGroup = Lib.ensureSingle(fullLayout._defs, "g", "patterns");
      patternsGroup.selectAll("pattern").remove();
      d3.select(gd2).selectAll(".pattern_filled").classed("pattern_filled", false);
    };
    drawing.getPatternAttr = function(mp2, i, dflt) {
      if (mp2 && Lib.isArrayOrTypedArray(mp2)) {
        return i < mp2.length ? mp2[i] : dflt;
      }
      return mp2;
    };
    drawing.pointStyle = function(s, trace, gd2, pt2) {
      if (!s.size()) return;
      var fns = drawing.makePointStyleFns(trace);
      s.each(function(d) {
        drawing.singlePointStyle(d, d3.select(this), trace, fns, gd2, pt2);
      });
    };
    drawing.singlePointStyle = function(d, sel, trace, fns, gd2, pt2) {
      var marker = trace.marker;
      var markerLine = marker.line;
      if (pt2 && pt2.i >= 0 && d.i === void 0) d.i = pt2.i;
      sel.style(
        "opacity",
        fns.selectedOpacityFn ? fns.selectedOpacityFn(d) : d.mo === void 0 ? marker.opacity : d.mo
      );
      if (fns.ms2mrc) {
        var r;
        if (d.ms === "various" || marker.size === "various") {
          r = 3;
        } else {
          r = fns.ms2mrc(d.ms);
        }
        d.mrc = r;
        if (fns.selectedSizeFn) {
          r = d.mrc = fns.selectedSizeFn(d);
        }
        var x = drawing.symbolNumber(d.mx || marker.symbol) || 0;
        d.om = x % 200 >= 100;
        var angle = getMarkerAngle(d, trace);
        var standoff = getMarkerStandoff(d, trace);
        sel.attr("d", makePointPath(x, r, angle, standoff));
      }
      var perPointGradient = false;
      var fillColor, lineColor, lineWidth;
      if (d.so) {
        lineWidth = markerLine.outlierwidth;
        lineColor = markerLine.outliercolor;
        fillColor = marker.outliercolor;
      } else {
        var markerLineWidth = (markerLine || {}).width;
        lineWidth = (d.mlw + 1 || markerLineWidth + 1 || // TODO: we need the latter for legends... can we get rid of it?
        (d.trace ? (d.trace.marker.line || {}).width : 0) + 1) - 1 || 0;
        if ("mlc" in d) lineColor = d.mlcc = fns.lineScale(d.mlc);
        else if (Lib.isArrayOrTypedArray(markerLine.color)) lineColor = Color.defaultLine;
        else lineColor = markerLine.color;
        if (Lib.isArrayOrTypedArray(marker.color)) {
          fillColor = Color.defaultLine;
          perPointGradient = true;
        }
        if ("mc" in d) {
          fillColor = d.mcc = fns.markerScale(d.mc);
        } else {
          fillColor = marker.color || marker.colors || "rgba(0,0,0,0)";
        }
        if (fns.selectedColorFn) {
          fillColor = fns.selectedColorFn(d);
        }
      }
      if (d.om) {
        sel.call(Color.stroke, fillColor).style({
          "stroke-width": (lineWidth || 1) + "px",
          fill: "none"
        });
      } else {
        sel.style("stroke-width", (d.isBlank ? 0 : lineWidth) + "px");
        var markerGradient = marker.gradient;
        var gradientType = d.mgt;
        if (gradientType) perPointGradient = true;
        else gradientType = markerGradient && markerGradient.type;
        if (Lib.isArrayOrTypedArray(gradientType)) {
          gradientType = gradientType[0];
          if (!gradientInfo[gradientType]) gradientType = 0;
        }
        var markerPattern = marker.pattern;
        var patternShape = markerPattern && drawing.getPatternAttr(markerPattern.shape, d.i, "");
        if (gradientType && gradientType !== "none") {
          var gradientColor = d.mgc;
          if (gradientColor) perPointGradient = true;
          else gradientColor = markerGradient.color;
          var gradientID = trace.uid;
          if (perPointGradient) gradientID += "-" + d.i;
          drawing.gradient(
            sel,
            gd2,
            gradientID,
            gradientType,
            [[0, gradientColor], [1, fillColor]],
            "fill"
          );
        } else if (patternShape) {
          var perPointPattern = false;
          var fgcolor = markerPattern.fgcolor;
          if (!fgcolor && pt2 && pt2.color) {
            fgcolor = pt2.color;
            perPointPattern = true;
          }
          var patternFGColor = drawing.getPatternAttr(fgcolor, d.i, pt2 && pt2.color || null);
          var patternBGColor = drawing.getPatternAttr(markerPattern.bgcolor, d.i, null);
          var patternFGOpacity = markerPattern.fgopacity;
          var patternSize = drawing.getPatternAttr(markerPattern.size, d.i, 8);
          var patternSolidity = drawing.getPatternAttr(markerPattern.solidity, d.i, 0.3);
          perPointPattern = perPointPattern || d.mcc || Lib.isArrayOrTypedArray(markerPattern.shape) || Lib.isArrayOrTypedArray(markerPattern.bgcolor) || Lib.isArrayOrTypedArray(markerPattern.fgcolor) || Lib.isArrayOrTypedArray(markerPattern.size) || Lib.isArrayOrTypedArray(markerPattern.solidity);
          var patternID = trace.uid;
          if (perPointPattern) patternID += "-" + d.i;
          drawing.pattern(
            sel,
            "point",
            gd2,
            patternID,
            patternShape,
            patternSize,
            patternSolidity,
            d.mcc,
            markerPattern.fillmode,
            patternBGColor,
            patternFGColor,
            patternFGOpacity
          );
        } else {
          Lib.isArrayOrTypedArray(fillColor) ? Color.fill(sel, fillColor[d.i]) : Color.fill(sel, fillColor);
        }
        if (lineWidth) {
          Color.stroke(sel, lineColor);
        }
      }
    };
    drawing.makePointStyleFns = function(trace) {
      var out = {};
      var marker = trace.marker;
      out.markerScale = drawing.tryColorscale(marker, "");
      out.lineScale = drawing.tryColorscale(marker, "line");
      if (Registry.traceIs(trace, "symbols")) {
        out.ms2mrc = subTypes.isBubble(trace) ? makeBubbleSizeFn(trace) : function() {
          return (marker.size || 6) / 2;
        };
      }
      if (trace.selectedpoints) {
        Lib.extendFlat(out, drawing.makeSelectedPointStyleFns(trace));
      }
      return out;
    };
    drawing.makeSelectedPointStyleFns = function(trace) {
      var out = {};
      var selectedAttrs = trace.selected || {};
      var unselectedAttrs = trace.unselected || {};
      var marker = trace.marker || {};
      var selectedMarker = selectedAttrs.marker || {};
      var unselectedMarker = unselectedAttrs.marker || {};
      var mo2 = marker.opacity;
      var smo = selectedMarker.opacity;
      var usmo = unselectedMarker.opacity;
      var smoIsDefined = smo !== void 0;
      var usmoIsDefined = usmo !== void 0;
      if (Lib.isArrayOrTypedArray(mo2) || smoIsDefined || usmoIsDefined) {
        out.selectedOpacityFn = function(d) {
          var base = d.mo === void 0 ? marker.opacity : d.mo;
          if (d.selected) {
            return smoIsDefined ? smo : base;
          } else {
            return usmoIsDefined ? usmo : DESELECTDIM * base;
          }
        };
      }
      var mc2 = marker.color;
      var smc = selectedMarker.color;
      var usmc = unselectedMarker.color;
      if (smc || usmc) {
        out.selectedColorFn = function(d) {
          var base = d.mcc || mc2;
          if (d.selected) {
            return smc || base;
          } else {
            return usmc || base;
          }
        };
      }
      var ms2 = marker.size;
      var sms = selectedMarker.size;
      var usms = unselectedMarker.size;
      var smsIsDefined = sms !== void 0;
      var usmsIsDefined = usms !== void 0;
      if (Registry.traceIs(trace, "symbols") && (smsIsDefined || usmsIsDefined)) {
        out.selectedSizeFn = function(d) {
          var base = d.mrc || ms2 / 2;
          if (d.selected) {
            return smsIsDefined ? sms / 2 : base;
          } else {
            return usmsIsDefined ? usms / 2 : base;
          }
        };
      }
      return out;
    };
    drawing.makeSelectedTextStyleFns = function(trace) {
      var out = {};
      var selectedAttrs = trace.selected || {};
      var unselectedAttrs = trace.unselected || {};
      var textFont = trace.textfont || {};
      var selectedTextFont = selectedAttrs.textfont || {};
      var unselectedTextFont = unselectedAttrs.textfont || {};
      var tc2 = textFont.color;
      var stc = selectedTextFont.color;
      var utc = unselectedTextFont.color;
      out.selectedTextColorFn = function(d) {
        var base = d.tc || tc2;
        if (d.selected) {
          return stc || base;
        } else {
          if (utc) return utc;
          else return stc ? base : Color.addOpacity(base, DESELECTDIM);
        }
      };
      return out;
    };
    drawing.selectedPointStyle = function(s, trace) {
      if (!s.size() || !trace.selectedpoints) return;
      var fns = drawing.makeSelectedPointStyleFns(trace);
      var marker = trace.marker || {};
      var seq = [];
      if (fns.selectedOpacityFn) {
        seq.push(function(pt2, d) {
          pt2.style("opacity", fns.selectedOpacityFn(d));
        });
      }
      if (fns.selectedColorFn) {
        seq.push(function(pt2, d) {
          Color.fill(pt2, fns.selectedColorFn(d));
        });
      }
      if (fns.selectedSizeFn) {
        seq.push(function(pt2, d) {
          var mx = d.mx || marker.symbol || 0;
          var mrc2 = fns.selectedSizeFn(d);
          pt2.attr("d", makePointPath(drawing.symbolNumber(mx), mrc2, getMarkerAngle(d, trace), getMarkerStandoff(d, trace)));
          d.mrc2 = mrc2;
        });
      }
      if (seq.length) {
        s.each(function(d) {
          var pt2 = d3.select(this);
          for (var i = 0; i < seq.length; i++) {
            seq[i](pt2, d);
          }
        });
      }
    };
    drawing.tryColorscale = function(marker, prefix) {
      var cont = prefix ? Lib.nestedProperty(marker, prefix).get() : marker;
      if (cont) {
        var colorArray = cont.color;
        if ((cont.colorscale || cont._colorAx) && Lib.isArrayOrTypedArray(colorArray)) {
          return Colorscale.makeColorScaleFuncFromTrace(cont);
        }
      }
      return Lib.identity;
    };
    var TEXTOFFSETSIGN = {
      start: 1,
      end: -1,
      middle: 0,
      bottom: 1,
      top: -1
    };
    function textPointPosition(s, textPosition, fontSize, markerRadius, dontTouchParent) {
      var group = d3.select(s.node().parentNode);
      var v = textPosition.indexOf("top") !== -1 ? "top" : textPosition.indexOf("bottom") !== -1 ? "bottom" : "middle";
      var h = textPosition.indexOf("left") !== -1 ? "end" : textPosition.indexOf("right") !== -1 ? "start" : "middle";
      var r = markerRadius ? markerRadius / 0.8 + 1 : 0;
      var numLines = (svgTextUtils.lineCount(s) - 1) * LINE_SPACING + 1;
      var dx = TEXTOFFSETSIGN[h] * r;
      var dy = fontSize * 0.75 + TEXTOFFSETSIGN[v] * r + (TEXTOFFSETSIGN[v] - 1) * numLines * fontSize / 2;
      s.attr("text-anchor", h);
      if (!dontTouchParent) {
        group.attr("transform", strTranslate(dx, dy));
      }
    }
    function extracTextFontSize(d, trace) {
      var fontSize = d.ts || trace.textfont.size;
      return isNumeric(fontSize) && fontSize > 0 ? fontSize : 0;
    }
    drawing.textPointStyle = function(s, trace, gd2) {
      if (!s.size()) return;
      var selectedTextColorFn;
      if (trace.selectedpoints) {
        var fns = drawing.makeSelectedTextStyleFns(trace);
        selectedTextColorFn = fns.selectedTextColorFn;
      }
      var texttemplate = trace.texttemplate;
      var fullLayout = gd2._fullLayout;
      s.each(function(d) {
        var p = d3.select(this);
        var text = texttemplate ? Lib.extractOption(d, trace, "txt", "texttemplate") : Lib.extractOption(d, trace, "tx", "text");
        if (!text && text !== 0) {
          p.remove();
          return;
        }
        if (texttemplate) {
          var fn = trace._module.formatLabels;
          var labels = fn ? fn(d, trace, fullLayout) : {};
          var pointValues = {};
          appendArrayPointValue(pointValues, trace, d.i);
          var meta = trace._meta || {};
          text = Lib.texttemplateString(text, labels, fullLayout._d3locale, pointValues, d, meta);
        }
        var pos = d.tp || trace.textposition;
        var fontSize = extracTextFontSize(d, trace);
        var fontColor = selectedTextColorFn ? selectedTextColorFn(d) : d.tc || trace.textfont.color;
        p.call(drawing.font, {
          family: d.tf || trace.textfont.family,
          weight: d.tw || trace.textfont.weight,
          style: d.ty || trace.textfont.style,
          variant: d.tv || trace.textfont.variant,
          textcase: d.tC || trace.textfont.textcase,
          lineposition: d.tE || trace.textfont.lineposition,
          shadow: d.tS || trace.textfont.shadow,
          size: fontSize,
          color: fontColor
        }).text(text).call(svgTextUtils.convertToTspans, gd2).call(textPointPosition, pos, fontSize, d.mrc);
      });
    };
    drawing.selectedTextStyle = function(s, trace) {
      if (!s.size() || !trace.selectedpoints) return;
      var fns = drawing.makeSelectedTextStyleFns(trace);
      s.each(function(d) {
        var tx = d3.select(this);
        var tc2 = fns.selectedTextColorFn(d);
        var tp2 = d.tp || trace.textposition;
        var fontSize = extracTextFontSize(d, trace);
        Color.fill(tx, tc2);
        var dontTouchParent = Registry.traceIs(trace, "bar-like");
        textPointPosition(tx, tp2, fontSize, d.mrc2 || d.mrc, dontTouchParent);
      });
    };
    var CatmullRomExp = 0.5;
    drawing.smoothopen = function(pts, smoothness) {
      if (pts.length < 3) {
        return "M" + pts.join("L");
      }
      var path = "M" + pts[0];
      var tangents = [];
      var i;
      for (i = 1; i < pts.length - 1; i++) {
        tangents.push(makeTangent(pts[i - 1], pts[i], pts[i + 1], smoothness));
      }
      path += "Q" + tangents[0][0] + " " + pts[1];
      for (i = 2; i < pts.length - 1; i++) {
        path += "C" + tangents[i - 2][1] + " " + tangents[i - 1][0] + " " + pts[i];
      }
      path += "Q" + tangents[pts.length - 3][1] + " " + pts[pts.length - 1];
      return path;
    };
    drawing.smoothclosed = function(pts, smoothness) {
      if (pts.length < 3) {
        return "M" + pts.join("L") + "Z";
      }
      var path = "M" + pts[0];
      var pLast = pts.length - 1;
      var tangents = [makeTangent(pts[pLast], pts[0], pts[1], smoothness)];
      var i;
      for (i = 1; i < pLast; i++) {
        tangents.push(makeTangent(pts[i - 1], pts[i], pts[i + 1], smoothness));
      }
      tangents.push(
        makeTangent(pts[pLast - 1], pts[pLast], pts[0], smoothness)
      );
      for (i = 1; i <= pLast; i++) {
        path += "C" + tangents[i - 1][1] + " " + tangents[i][0] + " " + pts[i];
      }
      path += "C" + tangents[pLast][1] + " " + tangents[0][0] + " " + pts[0] + "Z";
      return path;
    };
    var lastDrawnX;
    var lastDrawnY;
    function roundEnd(pt2, isY, isLastPoint) {
      if (isLastPoint) pt2 = applyBackoff(pt2);
      return isY ? roundY(pt2[1]) : roundX(pt2[0]);
    }
    function roundX(p) {
      var v = d3.round(p, 2);
      lastDrawnX = v;
      return v;
    }
    function roundY(p) {
      var v = d3.round(p, 2);
      lastDrawnY = v;
      return v;
    }
    function makeTangent(prevpt, thispt, nextpt, smoothness) {
      var d1x = prevpt[0] - thispt[0];
      var d1y = prevpt[1] - thispt[1];
      var d2x = nextpt[0] - thispt[0];
      var d2y = nextpt[1] - thispt[1];
      var d1a = Math.pow(d1x * d1x + d1y * d1y, CatmullRomExp / 2);
      var d2a = Math.pow(d2x * d2x + d2y * d2y, CatmullRomExp / 2);
      var numx = (d2a * d2a * d1x - d1a * d1a * d2x) * smoothness;
      var numy = (d2a * d2a * d1y - d1a * d1a * d2y) * smoothness;
      var denom1 = 3 * d2a * (d1a + d2a);
      var denom2 = 3 * d1a * (d1a + d2a);
      return [
        [
          roundX(thispt[0] + (denom1 && numx / denom1)),
          roundY(thispt[1] + (denom1 && numy / denom1))
        ],
        [
          roundX(thispt[0] - (denom2 && numx / denom2)),
          roundY(thispt[1] - (denom2 && numy / denom2))
        ]
      ];
    }
    var STEPPATH = {
      hv: function(p02, p12, isLastPoint) {
        return "H" + roundX(p12[0]) + "V" + roundEnd(p12, 1, isLastPoint);
      },
      vh: function(p02, p12, isLastPoint) {
        return "V" + roundY(p12[1]) + "H" + roundEnd(p12, 0, isLastPoint);
      },
      hvh: function(p02, p12, isLastPoint) {
        return "H" + roundX((p02[0] + p12[0]) / 2) + "V" + roundY(p12[1]) + "H" + roundEnd(p12, 0, isLastPoint);
      },
      vhv: function(p02, p12, isLastPoint) {
        return "V" + roundY((p02[1] + p12[1]) / 2) + "H" + roundX(p12[0]) + "V" + roundEnd(p12, 1, isLastPoint);
      }
    };
    var STEPLINEAR = function(p02, p12, isLastPoint) {
      return "L" + roundEnd(p12, 0, isLastPoint) + "," + roundEnd(p12, 1, isLastPoint);
    };
    drawing.steps = function(shape) {
      var onestep = STEPPATH[shape] || STEPLINEAR;
      return function(pts) {
        var path = "M" + roundX(pts[0][0]) + "," + roundY(pts[0][1]);
        var len = pts.length;
        for (var i = 1; i < len; i++) {
          path += onestep(pts[i - 1], pts[i], i === len - 1);
        }
        return path;
      };
    };
    function applyBackoff(pt2, start) {
      var backoff = pt2.backoff;
      var trace = pt2.trace;
      var d = pt2.d;
      var i = pt2.i;
      if (backoff && trace && trace.marker && trace.marker.angle % 360 === 0 && trace.line && trace.line.shape !== "spline") {
        var arrayBackoff = Lib.isArrayOrTypedArray(backoff);
        var end = pt2;
        var x12 = start ? start[0] : lastDrawnX || 0;
        var y12 = start ? start[1] : lastDrawnY || 0;
        var x2 = end[0];
        var y2 = end[1];
        var dx = x2 - x12;
        var dy = y2 - y12;
        var t = Math.atan2(dy, dx);
        var b = arrayBackoff ? backoff[i] : backoff;
        if (b === "auto") {
          var endI = end.i;
          if (trace.type === "scatter") endI--;
          var endMarker = end.marker;
          var endMarkerSymbol = endMarker.symbol;
          if (Lib.isArrayOrTypedArray(endMarkerSymbol)) endMarkerSymbol = endMarkerSymbol[endI];
          var endMarkerSize = endMarker.size;
          if (Lib.isArrayOrTypedArray(endMarkerSize)) endMarkerSize = endMarkerSize[endI];
          b = endMarker ? drawing.symbolBackOffs[drawing.symbolNumber(endMarkerSymbol)] * endMarkerSize : 0;
          b += drawing.getMarkerStandoff(d[endI], trace) || 0;
        }
        var x = x2 - b * Math.cos(t);
        var y = y2 - b * Math.sin(t);
        if ((x <= x2 && x >= x12 || x >= x2 && x <= x12) && (y <= y2 && y >= y12 || y >= y2 && y <= y12)) {
          pt2 = [x, y];
        }
      }
      return pt2;
    }
    drawing.applyBackoff = applyBackoff;
    drawing.makeTester = function() {
      var tester = Lib.ensureSingleById(d3.select("body"), "svg", "js-plotly-tester", function(s) {
        s.attr(xmlnsNamespaces.svgAttrs).style({
          position: "absolute",
          left: "-10000px",
          top: "-10000px",
          width: "9000px",
          height: "9000px",
          "z-index": "1"
        });
      });
      var testref = Lib.ensureSingle(tester, "path", "js-reference-point", function(s) {
        s.attr("d", "M0,0H1V1H0Z").style({
          "stroke-width": 0,
          fill: "black"
        });
      });
      drawing.tester = tester;
      drawing.testref = testref;
    };
    drawing.savedBBoxes = {};
    var savedBBoxesCount = 0;
    var maxSavedBBoxes = 1e4;
    drawing.bBox = function(node, inTester, hash) {
      if (!hash) hash = nodeHash(node);
      var out;
      if (hash) {
        out = drawing.savedBBoxes[hash];
        if (out) return Lib.extendFlat({}, out);
      } else if (node.childNodes.length === 1) {
        var innerNode = node.childNodes[0];
        hash = nodeHash(innerNode);
        if (hash) {
          var x = +innerNode.getAttribute("x") || 0;
          var y = +innerNode.getAttribute("y") || 0;
          var transform = innerNode.getAttribute("transform");
          if (!transform) {
            var innerBB = drawing.bBox(innerNode, false, hash);
            if (x) {
              innerBB.left += x;
              innerBB.right += x;
            }
            if (y) {
              innerBB.top += y;
              innerBB.bottom += y;
            }
            return innerBB;
          }
          hash += "~" + x + "~" + y + "~" + transform;
          out = drawing.savedBBoxes[hash];
          if (out) return Lib.extendFlat({}, out);
        }
      }
      var testNode, tester;
      if (inTester) {
        testNode = node;
      } else {
        tester = drawing.tester.node();
        testNode = node.cloneNode(true);
        tester.appendChild(testNode);
      }
      d3.select(testNode).attr("transform", null).call(svgTextUtils.positionText, 0, 0);
      var testRect = testNode.getBoundingClientRect();
      var refRect = drawing.testref.node().getBoundingClientRect();
      if (!inTester) tester.removeChild(testNode);
      var bb = {
        height: testRect.height,
        width: testRect.width,
        left: testRect.left - refRect.left,
        top: testRect.top - refRect.top,
        right: testRect.right - refRect.left,
        bottom: testRect.bottom - refRect.top
      };
      if (savedBBoxesCount >= maxSavedBBoxes) {
        drawing.savedBBoxes = {};
        savedBBoxesCount = 0;
      }
      if (hash) drawing.savedBBoxes[hash] = bb;
      savedBBoxesCount++;
      return Lib.extendFlat({}, bb);
    };
    function nodeHash(node) {
      var inputText = node.getAttribute("data-unformatted");
      if (inputText === null) return;
      return inputText + node.getAttribute("data-math") + node.getAttribute("text-anchor") + node.getAttribute("style");
    }
    drawing.setClipUrl = function(s, localId, gd2) {
      s.attr("clip-path", getFullUrl(localId, gd2));
    };
    function getFullUrl(localId, gd2) {
      if (!localId) return null;
      var context = gd2._context;
      var baseUrl = context._exportedPlot ? "" : context._baseUrl || "";
      return baseUrl ? "url('" + baseUrl + "#" + localId + "')" : "url(#" + localId + ")";
    }
    drawing.getTranslate = function(element) {
      var re2 = /.*\btranslate\((-?\d*\.?\d*)[^-\d]*(-?\d*\.?\d*)[^\d].*/;
      var getter = element.attr ? "attr" : "getAttribute";
      var transform = element[getter]("transform") || "";
      var translate = transform.replace(re2, function(match, p12, p2) {
        return [p12, p2].join(" ");
      }).split(" ");
      return {
        x: +translate[0] || 0,
        y: +translate[1] || 0
      };
    };
    drawing.setTranslate = function(element, x, y) {
      var re2 = /(\btranslate\(.*?\);?)/;
      var getter = element.attr ? "attr" : "getAttribute";
      var setter = element.attr ? "attr" : "setAttribute";
      var transform = element[getter]("transform") || "";
      x = x || 0;
      y = y || 0;
      transform = transform.replace(re2, "").trim();
      transform += strTranslate(x, y);
      transform = transform.trim();
      element[setter]("transform", transform);
      return transform;
    };
    drawing.getScale = function(element) {
      var re2 = /.*\bscale\((\d*\.?\d*)[^\d]*(\d*\.?\d*)[^\d].*/;
      var getter = element.attr ? "attr" : "getAttribute";
      var transform = element[getter]("transform") || "";
      var translate = transform.replace(re2, function(match, p12, p2) {
        return [p12, p2].join(" ");
      }).split(" ");
      return {
        x: +translate[0] || 1,
        y: +translate[1] || 1
      };
    };
    drawing.setScale = function(element, x, y) {
      var re2 = /(\bscale\(.*?\);?)/;
      var getter = element.attr ? "attr" : "getAttribute";
      var setter = element.attr ? "attr" : "setAttribute";
      var transform = element[getter]("transform") || "";
      x = x || 1;
      y = y || 1;
      transform = transform.replace(re2, "").trim();
      transform += "scale(" + x + "," + y + ")";
      transform = transform.trim();
      element[setter]("transform", transform);
      return transform;
    };
    var SCALE_RE = /\s*sc.*/;
    drawing.setPointGroupScale = function(selection, xScale, yScale) {
      xScale = xScale || 1;
      yScale = yScale || 1;
      if (!selection) return;
      var scale = xScale === 1 && yScale === 1 ? "" : "scale(" + xScale + "," + yScale + ")";
      selection.each(function() {
        var t = (this.getAttribute("transform") || "").replace(SCALE_RE, "");
        t += scale;
        t = t.trim();
        this.setAttribute("transform", t);
      });
    };
    var TEXT_POINT_LAST_TRANSLATION_RE = /translate\([^)]*\)\s*$/;
    drawing.setTextPointsScale = function(selection, xScale, yScale) {
      if (!selection) return;
      selection.each(function() {
        var transforms;
        var el = d3.select(this);
        var text = el.select("text");
        if (!text.node()) return;
        var x = parseFloat(text.attr("x") || 0);
        var y = parseFloat(text.attr("y") || 0);
        var existingTransform = (el.attr("transform") || "").match(TEXT_POINT_LAST_TRANSLATION_RE);
        if (xScale === 1 && yScale === 1) {
          transforms = [];
        } else {
          transforms = [
            strTranslate(x, y),
            "scale(" + xScale + "," + yScale + ")",
            strTranslate(-x, -y)
          ];
        }
        if (existingTransform) {
          transforms.push(existingTransform);
        }
        el.attr("transform", transforms.join(""));
      });
    };
    function getMarkerStandoff(d, trace) {
      var standoff;
      if (d) standoff = d.mf;
      if (standoff 