import { _ as g, q as m, g as v, b as y, E as d } from "./index-B04zLAsd.js";
import { C as w } from "./ContentMixin-BituPimg.js";
import { ScaffoldVuer as b } from "@abi-software/scaffoldvuer";
import { resolveComponent as p, openBlock as u, createElementBlock as S, createVNode as M, createBlock as N, createCommentVNode as $ } from "vue";
const C = {
  name: "Scaffold",
  mixins: [w],
  components: {
    ScaffoldVuer: b,
    HelpModeDialog: m
  },
  methods: {
    showConnectivitiesByReference: async function(e) {
      const t = sessionStorage.getItem("flatmap-knowledge");
      let n = [];
      t ? n = await v(e) : n = await y(this.flatmapService.mapImp, e, this.flatmapService.flatmapQueries);
      const o = [];
      for (const s of n) {
        const i = this.nervesKnowledge.find((l) => l.id === s);
        if (!i) continue;
        const f = i["nerve-label"];
        if (f) {
          const l = f.flatMap((a) => a.subNerves);
          o.push(...l);
        }
      }
      this.$refs.scaffold.changeHighlightedByName(o, "", !1);
    },
    setNerveGreyScale: function() {
      if (this.nervesKnowledge.length) {
        const t = this.nervesKnowledge.reduce((n, o) => n.concat(o["nerve-label"] || []), []).reduce((n, o) => n.concat(o.subNerves || []), []);
        this.$refs.scaffold.setGreyScale(!0, t);
      }
    },
    setVisibilityFilter: function(e) {
      let t = [];
      const n = !!e;
      if (e) {
        const o = [];
        e.OR.forEach((s) => {
          "AND" in s && s.AND.length >= 2 && "models" in s.AND[1] && o.push(...s.AND[1].models);
        });
        for (const s of o) {
          const i = this.nervesKnowledge.find((f) => f.id === s);
          if (i) {
            const f = i["nerve-label"].map((l) => l.subNerves).flat(1 / 0);
            t.push(...f);
          }
        }
      }
      this.$refs.scaffold.zoomToNerves(t, n);
    },
    syncFilter: function(e) {
      this.$refs.scaffold.viewingMode === "Neuron Connection" && (this.filter = e.filter((t) => {
        var n;
        return ((n = t.facet) == null ? void 0 : n.toLowerCase()) !== "show all";
      }));
    },
    scaffoldResourceSelected: async function(e, t) {
      if (this.resourceSelected(e, t, !0), t.length === 1) {
        if (this.clickedObject = t[0].data, this.clickedObject.isNerves || this.clickedObject.anatomicalId) {
          const n = this.clickedObject.id.toLowerCase();
          if (this.$refs.scaffold.viewingMode === "Neuron Connection") {
            const o = this.settingsStore.globalSettings.connectionType;
            if (this.clickedObject.isNerves)
              this.filter.push({
                facet: n,
                term: "Nerves",
                facetPropPath: "scaffold.connectivity.nerve"
              });
            else {
              const s = o.toLowerCase();
              let i = this.clickedObject.anatomicalId || "";
              if (i)
                this.filter.push({
                  facet: `["${i}",[]]`,
                  facetPropPath: `flatmap.connectivity.source.${s}`,
                  tagLabel: n.charAt(0).toUpperCase() + n.slice(1),
                  term: o
                });
              else {
                const l = this.connectivitiesStore.filterOptions[this.entry.resource].find((r) => r.key === `flatmap.connectivity.source.${s}`);
                let a;
                l == null || l.children.forEach((r) => {
                  var c;
                  r.label.toLowerCase() === n && (a = r), (c = r.children) == null || c.forEach((h) => {
                    h.label.toLowerCase() === n && (a = h);
                  });
                }), a && (i = a.key.replace(`flatmap.connectivity.source.${s}.`, ""), this.filter.push({
                  facet: i,
                  facetPropPath: `flatmap.connectivity.source.${s}`,
                  tagLabel: a.tagLabel,
                  term: o
                }));
              }
            }
            d.emit("neuron-connection-feature-click", {
              filters: this.filter,
              search: this.filter.length ? "" : n
            });
          } else if (this.$refs.scaffold.viewingMode === "Exploration") {
            const o = this.nervesKnowledge.filter((s) => JSON.stringify(s["nerve-label"]).includes(n));
            o.length && this.getKnowledgeTooltip({ data: o, type: this.entry });
          }
        }
      } else t.length > 1 ? this.$refs.scaffold.viewingMode === "Exploration" && this.clickedObject && this.$refs.scaffold.$module.setIgnorePicking(!1) : (this.clickedObject = void 0, d.emit("connectivity-info-close"));
    },
    onResize: function() {
      this.scaffoldCamera.onResize();
    },
    getState: function() {
      return this.$refs.scaffold.getState();
    },
    /**
     * Perform a local search on this contentvuer
     */
    search: function(e) {
      return this.$refs.scaffold.search(e, !0);
    },
    searchSuggestions: function(e, t) {
      if (e === "" || !this.$refs.scaffold)
        return t;
      this.$refs.scaffold.fetchSuggestions(e).forEach((o) => {
        o.suggestion && t.push(o.suggestion);
      });
    },
    showConnectivityTooltips: function(e) {
      if (e.label)
        this.$refs.scaffold.changeHighlightedByName([e.label], "", !1), this.$refs.scaffold.showRegionTooltip(e.label, !1, !1);
      else {
        const t = e.connectivityInfo["nerve-label"];
        if (t) {
          const n = t.flatMap((o) => o.subNerves);
          this.$refs.scaffold.changeHighlightedByName(n, "", !1);
        }
        this.$refs.scaffold.hideRegionTooltip();
      }
    },
    zoomToFeatures: function(e, t) {
      let n;
      Array.isArray(e) ? n = e : n = [e.name], t && this.$refs.scaffold.changeActiveByName(n, "", !1), this.$refs.scaffold.viewRegion(n);
    },
    scaffoldIsReady: function() {
      this.scaffoldLoaded = !0, this.$refs.scaffold.$module.graphicsHighlight.highlightColour = [1, 0, 1], this.visible && this.entry.rotation && this.entry.rotation, this.updateViewerSettings(), d.emit("mapLoaded", this.$refs.scaffold), setTimeout(() => {
        this.setNerveGreyScale();
      }, 500);
    },
    /**
     * Callback when the vuers emit a selected event.
     */
    scaffoldHighlighted: function(e, t) {
      var o, s, i;
      const n = {
        paneIndex: this.entry.id,
        type: e,
        resource: t,
        internalName: void 0
      };
      t && t[0] && ((((o = t[0].data) == null ? void 0 : o.id) === void 0 || ((s = t[0].data) == null ? void 0 : s.id) === "") && (t[0].data.id = (i = t[0].data) == null ? void 0 : i.group), n.internalName = t[0].data.id, n.eventType = "highlighted"), this.$emit("resource-selected", n);
    },
    /**
     * Callback when the vuers emit a selected event.
     */
    scaffoldNavigated: function(e, t) {
      if (this.mouseHovered) {
        const n = {
          paneIndex: this.entry.id,
          eventType: "panZoom",
          payload: t,
          type: e
        };
        this.$emit("resource-selected", n);
      }
    },
    updateWithViewUrl: function(e) {
      this.$refs.scaffold.updateViewURL(e);
    },
    /**
     * Change the view mode of the current scaffold
     */
    changeViewingMode: function(e) {
      this.$refs.scaffold.changeViewingMode(e);
    },
    updateViewerSettings: function() {
      const {
        backgroundDisplay: e,
        organsDisplay: t,
        outlinesDisplay: n,
        viewingMode: o
      } = this.settingsStore.globalSettings;
      this.$refs.scaffold.backgroundChangeCallback(e), this.$refs.scaffold.changeViewingMode(o), this.$refs.scaffold.setColour(t), this.$refs.scaffold.setOutlines(n);
    }
  },
  computed: {
    warningMessage: function() {
      return this.entry.discoverId === "307" || this.entry.discoverId === 307 ? "This map displays the anatomical location and connectivity of nerves, through which the neuron populations from the ApiNATOMY models available in SCKAN can be routed." : "Under active development";
    },
    markerLabels: function() {
      return this.settingsStore.globalSettings.displayMarkers ? this.settingsStore.numberOfDatasetsForFacets : {};
    }
  },
  watch: {
    connectivityKnowledge: {
      handler(e, t) {
        if (this.entry.resource in e) {
          const n = e[this.entry.resource];
          n.length !== this.nervesKnowledge.length && (this.nervesKnowledge = n, this.scaffoldLoaded && this.setNerveGreyScale());
        }
      },
      deep: !0,
      immediate: !0
    }
  },
  data: function() {
    return {
      apiLocation: process.env.VUE_APP_API_LOCATION,
      scaffoldCamera: void 0,
      scaffoldLoaded: !1,
      nervesKnowledge: [],
      clickedObject: void 0,
      filter: [],
      query: ""
    };
  },
  mounted: function() {
    this.scaffoldCamera = this.$refs.scaffold.$module.scene.getZincCameraControls();
  }
}, I = { class: "viewer-container" };
function O(e, t, n, o, s, i) {
  const f = p("ScaffoldVuer"), l = p("HelpModeDialog");
  return u(), S("div", I, [
    M(f, {
      state: e.entry.state,
      url: e.entry.resource,
      region: e.entry.region,
      onScaffoldSelected: t[0] || (t[0] = (a) => i.scaffoldResourceSelected(e.entry.type, a)),
      onScaffoldHighlighted: t[1] || (t[1] = (a) => i.scaffoldHighlighted(e.entry.type, a)),
      onScaffoldNavigated: t[2] || (t[2] = (a) => i.scaffoldNavigated(e.entry.type, a)),
      onOnReady: i.scaffoldIsReady,
      onOpenMap: e.openMap,
      ref: "scaffold",
      "background-toggle": !0,
      traditional: !0,
      helpMode: e.helpMode,
      helpModeActiveItem: e.helpModeActiveItem,
      helpModeDialog: e.useHelpModeDialog,
      onAnnotationOpen: e.onAnnotationOpen,
      onAnnotationClose: e.onAnnotationClose,
      onUpdateOfflineAnnotationEnabled: e.updateOfflineAnnotationEnabled,
      annotationSidebar: e.annotationSidebar,
      onHelpModeLastItem: e.onHelpModeLastItem,
      onShownTooltip: e.onTooltipShown,
      onShownMapTooltip: e.onMapTooltipShown,
      render: e.visible,
      "display-latest-message": !0,
      "warning-message": i.warningMessage,
      "display-minimap": !1,
      "display-markers": !1,
      enableOpenMapUI: !0,
      "view-u-r-l": e.entry.viewUrl,
      markerCluster: !0,
      markerLabels: i.markerLabels,
      flatmapAPI: e.flatmapAPI,
      showLocalSettings: e.showLocalSettings,
      showOpenMapButton: e.showOpenMapButton,
      usageConfig: {
        showTubeLinesControls: !1,
        tubeLines: e.entry.discoverId === "307" || e.entry.discoverId === 307
      }
    }, null, 8, ["state", "url", "region", "onOnReady", "onOpenMap", "helpMode", "helpModeActiveItem", "helpModeDialog", "onAnnotationOpen", "onAnnotationClose", "onUpdateOfflineAnnotationEnabled", "annotationSidebar", "onHelpModeLastItem", "onShownTooltip", "onShownMapTooltip", "render", "warning-message", "view-u-r-l", "markerLabels", "flatmapAPI", "showLocalSettings", "showOpenMapButton", "usageConfig"]),
    e.helpMode && e.useHelpModeDialog ? (u(), N(l, {
      key: 0,
      ref: "scaffoldHelp",
      scaffoldRef: e.scaffoldRef,
      lastItem: e.helpModeLastItem,
      onShowNext: e.onHelpModeShowNext,
      onFinishHelpMode: e.onFinishHelpMode
    }, null, 8, ["scaffoldRef", "lastItem", "onShowNext", "onFinishHelpMode"])) : $("", !0)
  ]);
}
const H = /* @__PURE__ */ g(C, [["render", O], ["__scopeId", "data-v-5de11cee"]]);
export {
  H as default
};
