import { _ as d, q as c, E as l, T as h } from "./index-B04zLAsd.js";
import { C as u } from "./ContentMixin-BituPimg.js";
import { D as y } from "./style-48GmCpQg.js";
import { FlatmapVuer as g } from "@abi-software/flatmapvuer";
import { resolveComponent as r, openBlock as p, createElementBlock as M, createVNode as C, createBlock as v, createCommentVNode as I } from "vue";
const S = {
  name: "Flatmap",
  mixins: [u, y],
  components: {
    FlatmapVuer: g,
    HelpModeDialog: c
  },
  data: function() {
    return {
      flatmapReady: !1,
      displayMinimap: !1
    };
  },
  methods: {
    getState: function() {
      return this.$refs.flatmap.getState();
    },
    /**
     * Perform a local search on this contentvuer
     * This is similar to directly clicking onthe map
     */
    search: function(e) {
      return this.$refs.flatmap.searchAndShowResult(e, !0, !0);
    },
    getFlatmapImp() {
      var e;
      return (e = this.$refs.flatmap) == null ? void 0 : e.mapImp;
    },
    contextRestored(e) {
      this.flatmapReadyForMarkerUpdates(e), this.updateViewerSettings();
    },
    flatmapReadyCall: function(e) {
      var n, i, o;
      this.flatmapReady = !0;
      const t = this.getFlatmapImp();
      (n = t == null ? void 0 : t.mapMetadata) != null && n.name && (this.updateEntryLabel((i = t == null ? void 0 : t.mapMetadata) == null ? void 0 : i.name), this.updateEntryTitle((o = t == null ? void 0 : t.mapMetadata) == null ? void 0 : o.name));
      let a = { id: this.entry.id, prov: t.mapMetadata };
      l.emit("mapImpProv", a), this.$emit("flatmap-provenance-ready", a), this.flatmapReadyForMarkerUpdates(e), this.updateViewerSettings(), this.loadConnectivityExplorerConfig(e).then(() => {
        l.emit("mapLoaded", e);
      });
    },
    onPathwaySelectionChanged: function(e) {
      const { label: t, property: a, checked: n, selectionsTitle: i } = e;
      h.sendEvent({
        event: "interaction_event",
        event_name: "portal_maps_pathway_change",
        category: t + " [" + a + "] " + n,
        location: i
      });
    },
    onSidebarAnnotationClose: function() {
      this.flatmapReady && this.$refs.flatmap && this.$refs.flatmap.annotationEventCallback({}, { type: "aborted" });
    },
    /**
     * Append the list of suggested terms to suggestions
     */
    searchSuggestions: function(e, t) {
      if (e && this.$refs.flatmap.mapImp) {
        const a = this.$refs.flatmap.mapImp.search(e);
        (a.__featureIds || a.featureIds).forEach((i) => {
          const o = this.$refs.flatmap.mapImp.annotation(i);
          o && o.label && t.push(o.label);
        });
      }
    },
    showConnectivity: function(e) {
      if (this != null && this.alive) {
        const { featureIds: t, offset: a } = e, n = this.$refs.flatmap;
        n && n.moveMap(t, {
          offsetX: a ? -150 : 0,
          zoom: 4
        });
      }
    },
    showConnectivityTooltips: function(e) {
      this != null && this.alive && this.flatmapReady && this.$refs.multiflatmap.getCurrentFlatmap().showConnectivityTooltips(e);
    },
    showConnectivitiesByReference: function(e) {
      if (this != null && this.alive) {
        const t = this.$refs.flatmap;
        t && t.showConnectivitiesByReference(e);
      }
    },
    changeConnectivitySource: function(e, t) {
      if (this != null && this.alive && this.flatmapReady) {
        const a = this.$refs.flatmap, n = a.mapImp.mapMetadata.uuid;
        t.includes(n) || (t.push(n), a.changeConnectivitySource(e));
      }
    },
    zoomToFeatures: function(e, t) {
      let a = e.name;
      const n = this.$refs.flatmap.mapImp;
      if (a) {
        const i = n.search(a);
        if (i.featureIds.length) {
          let o = n.modelForFeature(i.featureIds[0]);
          o ? (t && n.selectFeatures(o), n.zoomToFeatures(o)) : n.clearSearchResults();
        }
      } else
        n.clearSearchResults();
    },
    changeViewingMode: function(e) {
      this.$refs.flatmap.changeViewingMode(e);
    },
    updateViewerSettings: function() {
      const {
        backgroundDisplay: e,
        viewingMode: t,
        flightPathDisplay: a,
        organsDisplay: n,
        outlinesDisplay: i,
        connectionType: o
      } = this.settingsStore.globalSettings, s = this.$refs.flatmap;
      s.changeViewingMode(t), s.setFlightPath3D(a), s.setColour(n), s.setOutlines(i), s.backgroundChangeCallback(e), s.setConnectionType(o);
    },
    setVisibilityFilter: function(e) {
      if (this != null && this.alive) {
        const t = this.$refs.flatmap;
        t && t.setVisibilityFilter(e);
      }
    },
    getKnowledgeTooltip: async function(e) {
      if (this != null && this.alive) {
        const t = this.$refs.flatmap;
        if (t) {
          const a = e.data[0];
          t.searchAndShowResult(a.id, !0, !1);
        }
      }
    }
  },
  computed: {
    facetSpecies() {
      return this.settingsStore.facets.species;
    }
  }
}, w = { class: "viewer-container" };
function F(e, t, a, n, i, o) {
  const s = r("FlatmapVuer"), f = r("HelpModeDialog");
  return p(), M("div", w, [
    C(s, {
      state: e.entry.state,
      entry: e.entry.resource,
      mapManager: e.mapManager,
      onResourceSelected: t[0] || (t[0] = (m) => e.flatmapResourceSelected(e.entry.type, m)),
      onPanZoomCallback: e.flatmapPanZoomCallback,
      name: e.entry.resource,
      style: { height: "100%", width: "100%" },
      minZoom: e.entry.minZoom,
      helpMode: e.helpMode,
      helpModeActiveItem: e.helpModeActiveItem,
      helpModeInitialIndex: -1,
      helpModeDialog: e.useHelpModeDialog,
      onHelpModeLastItem: e.onHelpModeLastItem,
      onShownTooltip: e.onTooltipShown,
      onShownMapTooltip: e.onMapTooltipShown,
      onAnnotationOpen: e.onAnnotationOpen,
      onAnnotationClose: e.onAnnotationClose,
      onUpdateOfflineAnnotationEnabled: e.updateOfflineAnnotationEnabled,
      annotationSidebar: e.annotationSidebar,
      onConnectivityInfoOpen: e.onConnectivityInfoOpen,
      onConnectivityError: e.onConnectivityError,
      onConnectivityInfoClose: e.onConnectivityInfoClose,
      onNeuronConnectionFeatureClick: e.onNeuronConnectionFeatureClick,
      connectivityInfoSidebar: e.connectivityInfoSidebar,
      pathControls: !0,
      ref: "flatmap",
      onContextRestored: o.contextRestored,
      onReady: o.flatmapReadyCall,
      displayMinimap: e.displayMinimap,
      displayWarning: !0,
      enableOpenMapUI: !0,
      flatmapAPI: e.flatmapAPI,
      render: e.visible,
      sparcAPI: e.apiLocation,
      showLocalSettings: e.showLocalSettings,
      showOpenMapButton: e.showOpenMapButton,
      onOpenMap: e.openMap,
      onPathwaySelectionChanged: o.onPathwaySelectionChanged,
      onMapmanagerLoaded: e.onMapmanagerLoaded,
      showPathwayFilter: !1,
      onTrackEvent: e.trackEvent
    }, null, 8, ["state", "entry", "mapManager", "onPanZoomCallback", "name", "minZoom", "helpMode", "helpModeActiveItem", "helpModeDialog", "onHelpModeLastItem", "onShownTooltip", "onShownMapTooltip", "onAnnotationOpen", "onAnnotationClose", "onUpdateOfflineAnnotationEnabled", "annotationSidebar", "onConnectivityInfoOpen", "onConnectivityError", "onConnectivityInfoClose", "onNeuronConnectionFeatureClick", "connectivityInfoSidebar", "onContextRestored", "onReady", "displayMinimap", "flatmapAPI", "render", "sparcAPI", "showLocalSettings", "showOpenMapButton", "onOpenMap", "onPathwaySelectionChanged", "onMapmanagerLoaded", "onTrackEvent"]),
    e.helpMode && e.useHelpModeDialog ? (p(), v(f, {
      key: 0,
      ref: "flatmapHelp",
      flatmapRef: e.flatmapRef,
      lastItem: e.helpModeLastItem,
      onShowNext: e.onHelpModeShowNext,
      onFinishHelpMode: e.onFinishHelpMode
    }, null, 8, ["flatmapRef", "lastItem", "onShowNext", "onFinishHelpMode"])) : I("", !0)
  ]);
}
const $ = /* @__PURE__ */ d(S, [["render", F], ["__scopeId", "data-v-a87dcfac"]]);
export {
  $ as default
};
