sparc_logo_base64 = "data:image/png;base64,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"