/*
 * World Calendars
 * https://github.com/alexcjohnson/world-calendars
 *
 * Batch-converted from kbwood/calendars
 * Many thanks to Keith Wood and all of the contributors to the original project!
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

﻿/* http://keith-wood.name/calendars.html
   Tatar localisation for Gregorian/Julian calendars for jQuery.
   Written by Ирек Хаҗиев (khazirek@gmail.com). */
var main = require('../main');
var _gregorian = main.calendars.gregorian;
var _julian = main.calendars.julian;

_gregorian.prototype.regionalOptions['tt'] = {
    name: 'Gregorian',
    epochs: ['BCE', 'CE'],
    monthNames: ['Гынвар','Февраль','Март','Апрель','Май','Июнь',
    'Июль','Август','Сентябрь','Октябрь','Ноябрь','Декабрь'],
    monthNamesShort: ['Гыйн','Фев','Мар','Апр','Май','Июн',
    'Июл','Авг','Сен','Окт','Ноя','Дек'],
    dayNames: ['якшәмбе','дүшәмбе','сишәмбе','чәршәмбе','пәнҗешәмбе','җомга','шимбә'],
    dayNamesShort: ['якш','дүш','сиш','чәр','пән','җом','шим'],
    dayNamesMin: ['Як','Дү','Си','Чә','Пә','Җо','Ши'],
    digits: null,
    dateFormat: 'dd.mm.yyyy',
    firstDay: 1,
    isRTL: false
};
if (_julian) {
    _julian.prototype.regionalOptions['tt'] =
        _gregorian.prototype.regionalOptions['tt'];
}
