"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var fs_1 = require("fs");
var util_1 = require("util");
var recast_1 = require("recast");
var babel_parser_1 = __importDefault(require("../babel-parser"));
var cacher_1 = __importDefault(require("./cacher"));
var read = (0, util_1.promisify)(fs_1.readFile);
function getPathOfExportedValue(pathResolver, exportName, filePath, options) {
    return __awaiter(this, void 0, void 0, function () {
        var plugins, filePathIndex, exportedPath, _loop_1, state_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    plugins = options.lang === 'ts' ? ['typescript'] : ['flow'];
                    if (options.jsx) {
                        plugins.push('jsx');
                    }
                    filePathIndex = filePath.length;
                    exportedPath = undefined;
                    _loop_1 = function () {
                        var currentFilePath, filePlugins, source, ast;
                        return __generator(this, function (_b) {
                            switch (_b.label) {
                                case 0:
                                    currentFilePath = pathResolver(filePath[filePathIndex]);
                                    if (!currentFilePath) {
                                        return [2 /*return*/, { value: undefined }];
                                    }
                                    filePlugins = plugins;
                                    // Fixes SFCs written in JS having their imported modules being assumed to also be JS
                                    if (/.tsx?$/.test(currentFilePath)) {
                                        filePlugins = filePlugins.map(function (plugin) { return (plugin === 'flow' ? 'typescript' : plugin); });
                                    }
                                    return [4 /*yield*/, read(currentFilePath, {
                                            encoding: 'utf-8'
                                        })];
                                case 1:
                                    source = _b.sent();
                                    ast = (0, cacher_1.default)(function () { return (0, recast_1.parse)(source, { parser: (0, babel_parser_1.default)({ plugins: filePlugins }) }); }, source);
                                    (0, recast_1.visit)(ast, {
                                        visitExportNamedDeclaration: function (p) {
                                            var masterDeclaration = p.node.declaration;
                                            if ((masterDeclaration === null || masterDeclaration === void 0 ? void 0 : masterDeclaration.type) === 'VariableDeclaration') {
                                                masterDeclaration.declarations.forEach(function (declaration, i) {
                                                    if (declaration.type === 'VariableDeclarator' &&
                                                        declaration.id.type === 'Identifier' &&
                                                        declaration.id.name === exportName) {
                                                        exportedPath = p.get('declaration', 'declarations', i, 'init');
                                                    }
                                                });
                                            }
                                            return false;
                                        },
                                        visitExportDefaultDeclaration: function (p) {
                                            if (exportName === 'default') {
                                                var masterDeclaration = p.node.declaration;
                                                if (masterDeclaration) {
                                                    exportedPath = p.get('declaration');
                                                }
                                            }
                                            return false;
                                        }
                                    });
                                    if (exportedPath) {
                                        return [2 /*return*/, { value: exportedPath }];
                                    }
                                    return [2 /*return*/];
                            }
                        });
                    };
                    _a.label = 1;
                case 1:
                    if (!filePathIndex--) return [3 /*break*/, 3];
                    return [5 /*yield**/, _loop_1()];
                case 2:
                    state_1 = _a.sent();
                    if (typeof state_1 === "object")
                        return [2 /*return*/, state_1.value];
                    return [3 /*break*/, 1];
                case 3: return [2 /*return*/, undefined];
            }
        });
    });
}
exports.default = getPathOfExportedValue;
