"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var path_1 = __importDefault(require("path"));
var source_map_support_1 = __importDefault(require("source-map-support"));
var memory_fs_1 = __importDefault(require("memory-fs"));
var registerRequireHook_1 = __importDefault(require("../../util/registerRequireHook"));
var paths_1 = require("../../util/paths");
var constants_1 = require("../../util/constants");
function registerInMemoryCompiler(compiler) {
    // register memory fs to webpack
    var memoryFs = new memory_fs_1["default"]();
    // the flag is used for integration tests that need to read compiled files
    if (!process.env.MOCHAPACK_WRITE_TO_DISK) {
        compiler.outputFileSystem = memoryFs; // eslint-disable-line no-param-reassign
    }
    // build asset map to allow fast checks for file existence
    var assetMap = new Map();
    compiler.hooks.done.tap(constants_1.MOCHAPACK_NAME, function (stats) {
        assetMap.clear();
        if (!stats.hasErrors()) {
            Object.keys(stats.compilation.assets).forEach(function (assetPath) {
                return assetMap.set(paths_1.ensureAbsolutePath(assetPath, compiler.options.output.path), true);
            });
        }
    });
    // provide file reader to read from memory fs
    var readFile = function (filePath) {
        if (assetMap.has(filePath)) {
            try {
                var code = memoryFs.readFileSync(filePath, 'utf8');
                return code;
            }
            catch (e) {
                return null;
            }
        }
        return null;
    };
    // module resolver for require calls from memory fs
    var resolveFile = function (filePath, requireCaller) {
        // try to read file from memory-fs as it is
        var code = readFile(filePath);
        var resolvedPath = filePath;
        if (code === null && requireCaller != null) {
            var filename = requireCaller.filename;
            if (filename != null) {
                // if that didn't work, resolve the file relative to it's parent
                resolvedPath = path_1["default"].resolve(path_1["default"].dirname(filename), filePath);
                code = readFile(resolvedPath);
            }
        }
        return { path: code !== null ? resolvedPath : null, source: code };
    };
    // install require hook to be able to require webpack bundles from memory
    var unmountHook = registerRequireHook_1["default"]('.js', resolveFile);
    // install source map support to read source map from memory
    source_map_support_1["default"].install({
        emptyCacheBetweenOperations: true,
        handleUncaughtExceptions: false,
        environment: 'node',
        retrieveFile: function (f) { return readFile(f); } // wrapper function to fake an unmount function
    });
    return function unmount() {
        unmountHook();
        readFile = function (filePath) { return null; }; // eslint-disable-line no-unused-vars
    };
}
exports["default"] = registerInMemoryCompiler;
//# sourceMappingURL=registerInMemoryCompiler.js.map