"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var path_1 = require("path");
var lodash_1 = require("lodash");
var glob_1 = require("../../../util/glob");
var entryLoader_1 = require("../../../webpack/loader/entryLoader");
var buildProgressPlugin_1 = require("../../../webpack/plugin/buildProgressPlugin");
var constants_1 = require("../../../util/constants");
var buildEntryConfig = function (entries, cwd) { return __awaiter(void 0, void 0, void 0, function () {
    var entryConfig, files;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                entryConfig = new entryLoader_1.EntryConfig();
                return [4 /*yield*/, glob_1.glob(entries, {
                        cwd: cwd,
                        absolute: true
                    })];
            case 1:
                files = _a.sent();
                files.forEach(function (f) { return entryConfig.addFile(f); });
                return [2 /*return*/, entryConfig];
        }
    });
}); };
var makeTemporaryPath = function (cwd) {
    return path_1.join(cwd, '.tmp', constants_1.MOCHAPACK_NAME, Date.now().toString());
};
var getOutputPath = function (webpackConfig, tmpPath) {
    return path_1.normalize(lodash_1.get(webpackConfig, 'output.path', tmpPath));
};
var getPublicPath = function (webpackConfig, outputPath) {
    return lodash_1.has(webpackConfig, 'output.path')
        ? lodash_1.get(webpackConfig, 'output.publicPath', undefined)
        : outputPath + path_1.sep;
};
var buildPluginsArray = function (webpackConfig, interactive) {
    var plugins = webpackConfig.plugins || [];
    if (interactive) {
        plugins.push(buildProgressPlugin_1.buildProgressPlugin());
    }
    return plugins;
};
var buildLoaderRulesArray = function (options) {
    var webpackConfig = options.webpackConfig, entryPath = options.entryPath, includeLoaderPath = options.includeLoaderPath, includes = options.includes, entryLoaderPath = options.entryLoaderPath, entryConfig = options.entryConfig;
    var loaderRules = lodash_1.get(webpackConfig, 'module.rules', []);
    loaderRules.unshift({
        test: entryPath,
        use: [
            {
                loader: includeLoaderPath,
                options: {
                    include: includes
                }
            },
            {
                loader: entryLoaderPath,
                options: {
                    entryConfig: entryConfig
                }
            }
        ]
    });
    return loaderRules;
};
var buildWebpackConfig = function (options) {
    return lodash_1.merge({}, options.webpackConfig, {
        entry: options.entryPath,
        module: {
            rules: options.loaderRules
        },
        output: {
            path: options.outputPath,
            publicPath: options.publicPath
        },
        plugins: options.plugins
    });
};
var createWebpackConfig = function (options) { return __awaiter(void 0, void 0, void 0, function () {
    var cwd, entries, interactive, webpackConfig, entryConfig, tmpPath, outputPath, publicPath, plugins, loaderRules, mochapackWebpackConfig;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                cwd = options.cwd, entries = options.entries, interactive = options.interactive, webpackConfig = options.webpackConfig;
                return [4 /*yield*/, buildEntryConfig(entries, cwd)];
            case 1:
                entryConfig = _a.sent();
                tmpPath = makeTemporaryPath(cwd);
                outputPath = getOutputPath(webpackConfig, tmpPath);
                publicPath = getPublicPath(webpackConfig, outputPath);
                plugins = buildPluginsArray(webpackConfig, interactive);
                loaderRules = buildLoaderRulesArray(__assign(__assign({}, options), { entryConfig: entryConfig }));
                mochapackWebpackConfig = buildWebpackConfig(__assign(__assign({}, options), { entryConfig: entryConfig,
                    loaderRules: loaderRules,
                    outputPath: outputPath,
                    plugins: plugins,
                    publicPath: publicPath }));
                return [2 /*return*/, {
                        webpackConfig: mochapackWebpackConfig,
                        entryConfig: entryConfig
                    }];
        }
    });
}); };
exports["default"] = createWebpackConfig;
//# sourceMappingURL=index.js.map