"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var lodash_1 = require("lodash");
var yargs_1 = __importDefault(require("yargs"));
var parseMochaArgs_1 = require("./mocha/parseMochaArgs");
var mochapackOptions_1 = __importDefault(require("./mochapack/mochapackOptions"));
var webpackOptions_1 = __importDefault(require("./webpack/webpackOptions"));
/**
 * Picks a subset of parsed arguments that applies to the provided option set
 *
 * @param parsedArgs Args that have already been parsed
 * @param options The set of options to derive a set of keys from to select
 *   values from the parsed args
 */
var pickParsedArgs = function (parsedArgs, options) { return lodash_1.pick(parsedArgs, Object.keys(options)); };
/**
 * Parses the incoming arguments using the options
 * @param argv An array of arguments to parse
 */
var parse = function (argv) {
    return yargs_1["default"]
        .help('help')
        .alias('help', 'h')
        .version()
        .options(__assign(__assign({}, webpackOptions_1["default"]), mochapackOptions_1["default"] /* ...mochaOptions */))
        .parse(argv);
};
/**
 * Parses arguments passed in via CLI and provides a `MochaCliOptions` object
 *   as output
 *
 * @param argv Arguments passed in via CLI
 */
var parseArgv = function (argv) {
    var parsedArgs = parse(argv);
    var webpack = pickParsedArgs(parsedArgs, webpackOptions_1["default"]);
    var mochapack = pickParsedArgs(parsedArgs, mochapackOptions_1["default"]);
    return {
        mocha: parseMochaArgs_1.pruneMochaYargsOutput(parseMochaArgs_1.parseMochaArgs(argv)),
        webpack: webpack,
        mochapack: mochapack
    };
};
exports["default"] = parseArgv;
//# sourceMappingURL=index.js.map