import { MochapackMochaOptions } from '../types';
import { ParsedArgs } from '../../parseArgv/types';
/**
 * Keep track of which keys are not applicable to the Mocha constructor here.
 */
export declare const mochaCliOptionArgs: string[];
/**
 * Translates incoming arguments relevant to Mocha into options to be used in
 *   constructor of Mocha instance and in CLI run by Mochapack
 *
 * @param parsedArgs Arguments that have been parsed from CLI
 */
declare const mochaOptionsFromParsedArgs: (parsedArgs: ParsedArgs) => MochapackMochaOptions;
export default mochaOptionsFromParsedArgs;
