"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var path_1 = __importDefault(require("path"));
var sortChunks_1 = __importDefault(require("./sortChunks"));
var webpack4GetAffectedModuleIds_1 = __importDefault(require("./webpack4GetAffectedModuleIds"));
function getBuildStats(stats, outputPath) {
    var _a = stats.compilation, chunks = _a.chunks, chunkGroups = _a.chunkGroups, modules = _a.modules;
    var sortedChunks = sortChunks_1["default"](chunks, chunkGroups);
    var affectedModules = webpack4GetAffectedModuleIds_1["default"](chunks, modules);
    var entries = [];
    var js = [];
    var pathHelper = function (f) { return path_1["default"].join(outputPath, f); };
    sortedChunks.forEach(function (chunk) {
        var files = Array.isArray(chunk.files) ? chunk.files : [chunk.files];
        if (chunk.isOnlyInitial()) {
            // only entry files
            var entry = files[0];
            entries.push(entry);
        }
        if (chunk
            .getModules()
            .some(function (module) { return affectedModules.indexOf(module.id) !== -1; })) {
            files.forEach(function (file) {
                if (/\.js$/.test(file)) {
                    js.push(file);
                }
            });
        }
    });
    var buildStats = {
        affectedModules: affectedModules,
        affectedFiles: js.map(pathHelper),
        entries: entries.map(pathHelper)
    };
    return buildStats;
}
exports["default"] = getBuildStats;
//# sourceMappingURL=webpack4GetBuildStats.js.map