"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var toposort_1 = __importDefault(require("toposort"));
// see https://github.com/jantimon/html-webpack-plugin/blob/8131d8bb1dc9b185b3c1709264a3baf32ef799bc/lib/chunksorter.js
function sortChunks(chunks, chunkGroups) {
    // We build a map (chunk-id -> chunk) for faster access during graph building.
    var nodeMap = {};
    chunks.forEach(function (chunk) {
        nodeMap[chunk.id] = chunk;
    });
    // Add an edge for each parent (parent -> child)
    var edges = chunkGroups.reduce(function (result, chunkGroup) {
        return result.concat(Array.from(chunkGroup.parentsIterable, function (parentGroup) { return [
            parentGroup,
            chunkGroup
        ]; }));
    }, []);
    var sortedGroups = toposort_1["default"].array(chunkGroups, edges);
    // flatten chunkGroup into chunks
    var sortedChunks = sortedGroups
        .reduce(function (result, chunkGroup) { return result.concat(chunkGroup.chunks); }, [])
        .map(function (chunk // use the chunk from the list passed in, since it may be a filtered list
    ) { return nodeMap[chunk.id]; })
        .filter(function (chunk, index, self) {
        // make sure exists (ie excluded chunks not in nodeMap)
        var exists = !!chunk;
        // make sure we have a unique list
        var unique = self.indexOf(chunk) === index;
        return exists && unique;
    });
    return sortedChunks;
}
exports["default"] = sortChunks;
//# sourceMappingURL=sortChunks.js.map