"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
exports.__esModule = true;
var isBuilt = function (module, webpackBuiltModules) {
    if (webpackBuiltModules) {
        return webpackBuiltModules.has(module);
    }
    return module.built;
};
var getId = function (module) { return module.id; };
var affectedModules = function (chunkGraph, map, usageMap, affected, moduleId) {
    if (typeof affected[moduleId] !== 'undefined') {
        // module was already inspected, stop here otherwise we get into endless recursion
        return;
    }
    // module is identified as affected by this function call
    var module = map[moduleId];
    affected[moduleId] = module; // eslint-disable-line no-param-reassign
    // next we need to mark all usages aka parents also as affected
    var usages = usageMap[moduleId];
    if (typeof usages !== 'undefined') {
        var ids = Object.keys(usages);
        ids.forEach(function (id) { return affectedModules(chunkGraph, map, usageMap, affected, id); });
    }
};
/**
 * Builds a map where all modules are indexed by it's id
 * {
 *   [moduleId]: Module
 * }
 */
var buildModuleMap = function (chunkGraph, modules) {
    var moduleMap = Array.from(modules).reduce(function (memo, module) {
        var _a;
        return (__assign(__assign({}, memo), (_a = {}, _a[chunkGraph.getModuleId(module)] = module, _a)));
    }, {});
    return moduleMap;
};
/**
 * Builds a map with all modules that are used in other modules (child -> parent relation)
 *
 * {
 *  [childModuleId]: {
 *    [parentModuleId]: ParentModule
 *  }
 * }
 *
 * @param chunks Set<Chunk>
 * @param modules Set<Module>
 * @return ModuleUsageMap
 */
var buildModuleUsageMap = function (chunks, chunkGraph, modules, moduleGraph) {
    // build a map of all modules with their parent
    // {
    //    [childModuleId]: {
    //      [parentModuleId]: ParentModule
    //    }
    // }
    //
    var moduleUsageMap = Array.from(modules).reduce(function (memo, module) {
        module.dependencies.forEach(function (dependency) {
            var dependentModule = moduleGraph.getModule(dependency);
            if (!dependentModule) {
                return;
            }
            var dependentModuleId = chunkGraph.getModuleId(dependentModule);
            if (typeof memo[dependentModuleId] === 'undefined') {
                memo[dependentModuleId] = {}; // eslint-disable-line no-param-reassign
            }
            var moduleId = chunkGraph.getModuleId(module);
            memo[dependentModuleId][moduleId] = module; // eslint-disable-line no-param-reassign
        });
        return memo;
    }, {});
    // build a map of all chunks with their modules
    // {
    //    [chunkId]: {
    //      [moduleId]: Module
    //    }
    // }
    var chunkModuleMap = Array.from(chunks).reduce(function (memo, chunk) {
        // build chunk map first to get also empty chunks (without modules)
        memo[chunk.id] = {}; // eslint-disable-line no-param-reassign
        return memo;
    }, {});
    Array.from(modules).reduce(function (memo, module) {
        chunkGraph.getModuleChunksIterable(module).forEach(function (chunk) {
            var moduleId = chunkGraph.getModuleId(module);
            memo[chunk.id][moduleId] = module; // eslint-disable-line no-param-reassign
        });
        return memo;
    }, chunkModuleMap);
    // detect modules with code split points (e.g. require.ensure) and enhance moduleUsageMap with that information
    modules.forEach(function (module) {
        module.blocks // chunkGroup can be invalid in in some cases
            .filter(function (block) { return block.chunkGroup != null; })
            .forEach(function (block) {
            // loop through all generated chunks by this module
            Array.from(block.chunkGroup.chunks).map(getId).forEach(function (chunkId) {
                // and mark all modules of this chunk as a direct dependency of the original module
                Object.values(chunkModuleMap[chunkId]).forEach(function (childModule) {
                    var childModuleId = chunkGraph.getModuleId(childModule);
                    if (typeof moduleUsageMap[childModuleId] === 'undefined') {
                        moduleUsageMap[childModuleId] = {};
                    }
                    var moduleId = chunkGraph.getModuleId(module);
                    moduleUsageMap[childModuleId][moduleId] = module;
                });
            });
        });
    });
    return moduleUsageMap;
};
/**
 * Builds a list with ids of all affected modules in the following way:
 *  - affected directly by a file change
 *  - affected indirectly by a change of it's dependencies and so on
 *
 * @param chunks Set<Chunk>
 * @param modules Set<Module>
 * @return {Array.<number>}
 */
function getAffectedModuleIds(chunks, chunkGraph, modules, moduleGraph, webpackBuiltModules) {
    var moduleMap = buildModuleMap(chunkGraph, modules);
    var moduleUsageMap = buildModuleUsageMap(chunks, chunkGraph, modules, moduleGraph);
    var builtModules = Array.from(modules).filter(function (m) { return isBuilt(m, webpackBuiltModules); });
    var affectedMap = {};
    builtModules.forEach(function (module) {
        var moduleId = chunkGraph.getModuleId(module);
        affectedModules(chunkGraph, moduleMap, moduleUsageMap, affectedMap, moduleId);
    });
    return Object.values(affectedMap).map(function (m) { return chunkGraph.getModuleId(m); });
}
exports["default"] = getAffectedModuleIds;
//# sourceMappingURL=getAffectedModuleIds.js.map