"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var loader_utils_1 = __importDefault(require("loader-utils"));
// Note: no export default here cause of Babel 6
module.exports = function includeFilesLoader(sourceCode) {
    var _this = this;
    if (this.cacheable) {
        this.cacheable();
    }
    var loaderOptions = loader_utils_1["default"].getOptions(this);
    if (loaderOptions.include && loaderOptions.include.length) {
        var includes = loaderOptions.include
            .map(function (modPath) { return "require(" + loader_utils_1["default"].stringifyRequest(_this, modPath) + ");"; })
            .join('\n');
        var code = [includes, sourceCode].join('\n');
        this.callback(null, code, null);
        return;
    }
    this.callback(null, sourceCode, null);
};
//# sourceMappingURL=includeFilesLoader.js.map