"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var lodash_1 = __importDefault(require("lodash"));
var Watching_1 = __importDefault(require("webpack/lib/Watching"));
var noop = function () { return undefined; };
function createWatchCompiler(compiler, watchOptions) {
    // this ugly statement to create a watch compiler is unfortunately necessary,
    // as webpack clears the file timestamps with the official compiler.watch()
    var createWatcher = function () { return new Watching_1["default"](compiler, watchOptions, noop); };
    var watchCompiler = null;
    return {
        watch: function () {
            if (watchCompiler === null) {
                watchCompiler = createWatcher();
            }
            else {
                // @ts-ignore
                var times_1 = compiler.watchFileSystem.watcher.getTimes();
                // check if we can store some collected file timestamps
                // the non-empty check is necessary as the times will be reseted after .close()
                // and we don't want to reset already existing timestamps
                if (Object.keys(times_1).length > 0) {
                    var timesMap = new Map(Object.keys(times_1).map(function (key) { return [key, times_1[key]]; }));
                    // set already collected file timestamps to cache compiled files
                    // webpack will do this only after a file change, but that will not happen when we add or delete files
                    // and this means that we have to test the whole test suite again ...
                    compiler.fileTimestamps = timesMap; // eslint-disable-line no-param-reassign
                    compiler.contextTimestamps = timesMap; // eslint-disable-line no-param-reassign
                }
                watchCompiler.close(function () {
                    watchCompiler = createWatcher();
                });
            }
        },
        pause: function () {
            if (watchCompiler !== null && watchCompiler.watcher) {
                watchCompiler.watcher.pause();
            }
        },
        getWatchOptions: function () {
            // 200 is the default value by webpack
            return lodash_1["default"].get(watchCompiler, 'watchOptions', { aggregateTimeout: 200 });
        }
    };
}
exports["default"] = createWatchCompiler;
//# sourceMappingURL=createWatchCompiler.js.map