"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var path_1 = __importDefault(require("path"));
var mocha_1 = require("mocha");
function loadUI(ui, cwd) {
    // try to load built-in ui like 'bdd'
    if (typeof mocha_1.interfaces[ui] !== 'undefined') {
        return ui;
    }
    var loadedUI = null;
    try {
        // try to load reporter from node_modules
        loadedUI = require.resolve(ui);
    }
    catch (e) {
        // try to load reporter from cwd
        loadedUI = require.resolve(path_1["default"].resolve(cwd, ui));
    }
    return loadedUI;
}
exports["default"] = loadUI;
//# sourceMappingURL=loadUI.js.map