"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var lodash_1 = require("lodash");
var TestRunner_1 = __importDefault(require("./runner/TestRunner"));
var testRunnerReporter_1 = __importDefault(require("./runner/testRunnerReporter"));
var Mochapack = /** @class */ (function () {
    function Mochapack(options) {
        var _this = this;
        /**
         * Current working directory of Mochapack when initialized
         */
        this.cwd = process.cwd();
        /**
         * Files to run test against
         *
         * @private
         */
        this.entries = [];
        /**
         * Files to include into the bundle
         *
         * @private
         */
        this.includes = [];
        /**
         * Default options
         *
         * @private
         */
        this.defaultOptions = {
            mocha: {
                constructor: {
                    bail: false,
                    reporter: 'spec',
                    reporterOptions: {},
                    ui: 'bdd',
                    ignoreLeaks: true,
                    fullStackTrace: false,
                    inlineDiffs: false,
                    timeout: 2000,
                    slow: 75,
                    asyncOnly: false,
                    delay: false,
                    forbidOnly: false
                },
                cli: {
                    invert: false
                }
            }
        };
        /**
         * Builds a test runner that can be used for run or watch mode
         */
        this.buildTestRunner = function () {
            var runner = new TestRunner_1["default"](_this.entries, _this.includes, _this.options, process.cwd());
            testRunnerReporter_1["default"]({
                eventEmitter: runner,
                interactive: _this.options.mochapack.interactive,
                quiet: _this.options.mochapack.quiet,
                cwd: _this.cwd,
                clearTerminal: _this.options.mochapack.clearTerminal
            });
            return runner;
        };
        this.options = options;
        var webpack = this.options.webpack;
        this.includes = webpack.include || [];
        this.options = lodash_1.defaults({}, this.options, this.defaultOptions);
    }
    /**
     * Add file run test against
     *
     * @public
     * @param {string} file file or glob
     * @return {Mochapack}
     */
    Mochapack.prototype.addEntry = function (file) {
        this.entries = __spreadArrays(this.entries, [file]);
        return this;
    };
    /**
     * Add file to include into the test bundle
     *
     * @public
     * @param {string} file absolute path to module
     * @return {Mochapack}
     */
    Mochapack.prototype.addInclude = function (file) {
        this.includes = __spreadArrays(this.includes, [file]);
        return this;
    };
    /**
     * Run tests
     *
     * @public
     * @return {Promise<number>} a Promise that gets resolved with the number of failed tests or rejected with build error
     */
    Mochapack.prototype.run = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.buildTestRunner().run()];
            });
        });
    };
    /**
     * Run tests and rerun them on changes
     * @public
     */
    Mochapack.prototype.watch = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.buildTestRunner().watch()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    return Mochapack;
}());
exports["default"] = Mochapack;
//# sourceMappingURL=Mochapack.js.map