/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v4.7.1/LICENSE.txt
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).maplibregl={})}(this,(function(t){"use strict";var e="4.7.1";function i(t,e,i,r){return new(i||(i=Promise))((function(s,n){function a(t){try{l(r.next(t))}catch(t){n(t)}}function o(t){try{l(r.throw(t))}catch(t){n(t)}}function l(t){var e;t.done?s(t.value):(e=t.value,e instanceof i?e:new i((function(t){t(e)}))).then(a,o)}l((r=r.apply(t,e||[])).next())}))}function r(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}"function"==typeof SuppressedError&&SuppressedError;var s=n;function n(t,e){this.x=t,this.y=e}n.prototype={clone:function(){return new n(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,i=t.y-this.y;return e*e+i*i},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),i=Math.sin(t),r=i*this.x+e*this.y;return this.x=e*this.x-i*this.y,this.y=r,this},_rotateAround:function(t,e){var i=Math.cos(t),r=Math.sin(t),s=e.y+r*(this.x-e.x)+i*(this.y-e.y);return this.x=e.x+i*(this.x-e.x)-r*(this.y-e.y),this.y=s,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},n.convert=function(t){return t instanceof n?t:Array.isArray(t)?new n(t[0],t[1]):t};var a=r(s),o=l;function l(t,e,i,r){this.cx=3*t,this.bx=3*(i-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(r-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=i,this.p2y=r}l.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var i=t,r=0;r<8;r++){var s=this.sampleCurveX(i)-t;if(Math.abs(s)<e)return i;var n=this.sampleCurveDerivativeX(i);if(Math.abs(n)<1e-6)break;i-=s/n}var a=0,o=1;for(i=t,r=0;r<20&&(s=this.sampleCurveX(i),!(Math.abs(s-t)<e));r++)t>s?a=i:o=i,i=.5*(o-a)+a;return i},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}};var c=r(o);let h,u;function p(){return null==h&&(h="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),h}function d(t){let e=1/0,i=1/0,r=-1/0,s=-1/0;for(const n of t)e=Math.min(e,n.x),i=Math.min(i,n.y),r=Math.max(r,n.x),s=Math.max(s,n.y);return[e,i,r,s]}function f(t,e,i,r){const s=new c(t,e,i,r);return t=>s.solve(t)}const m=f(.25,.1,.25,1);function _(t,e,i){return Math.min(i,Math.max(e,t))}function g(t,e,i){const r=i-e,s=((t-e)%r+r)%r+e;return s===e?i:s}function y(t,...e){for(const i of e)for(const e in i)t[e]=i[e];return t}function x(t,e){const i={};for(let r=0;r<e.length;r++){const s=e[r];s in t&&(i[s]=t[s])}return i}let v=1;function b(){return v++}function w(t,e,i){const r={};for(const i in t)r[i]=e.call(this,t[i],i,t);return r}function T(t,e,i){const r={};for(const i in t)e.call(this,t[i],i,t)&&(r[i]=t[i]);return r}function S(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return!1;for(let i=0;i<t.length;i++)if(!S(t[i],e[i]))return!1;return!0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return!1;if(Object.keys(t).length!==Object.keys(e).length)return!1;for(const i in t)if(!S(t[i],e[i]))return!1;return!0}return t===e}function I(t){return Array.isArray(t)?t.map(I):"object"==typeof t&&t?w(t,I):t}const A={};function C(t){A[t]||("undefined"!=typeof console&&console.warn(t),A[t]=!0)}function E(t,e,i){return(i.y-t.y)*(e.x-t.x)>(e.y-t.y)*(i.x-t.x)}function z(t){return"undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}let P=null;function M(t){return"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}const k="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function D(t){return t*Math.PI/180}function L(){return new Error("AbortError")}let R,B;const F={now:"undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),frameAsync:t=>new Promise(((e,i)=>{const r=requestAnimationFrame(e);t.signal.addEventListener("abort",(()=>{cancelAnimationFrame(r),i(L())}))})),getImageData(t,e=0){return this.getImageCanvasContext(t).getImageData(-e,-e,t.width+2*e,t.height+2*e)},getImageCanvasContext(t){const e=window.document.createElement("canvas"),i=e.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return e.width=t.width,e.height=t.height,i.drawImage(t,0,0,t.width,t.height),i},resolveURL:t=>(R||(R=document.createElement("a")),R.href=t,R.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return!!matchMedia&&(null==B&&(B=matchMedia("(prefers-reduced-motion: reduce)")),B.matches)}};class O{static testProp(t){if(!O.docStyle)return t[0];for(let e=0;e<t.length;e++)if(t[e]in O.docStyle)return t[e];return t[0]}static create(t,e,i){const r=window.document.createElement(t);return void 0!==e&&(r.className=e),i&&i.appendChild(r),r}static createNS(t,e){return window.document.createElementNS(t,e)}static disableDrag(){O.docStyle&&O.selectProp&&(O.userSelect=O.docStyle[O.selectProp],O.docStyle[O.selectProp]="none")}static enableDrag(){O.docStyle&&O.selectProp&&(O.docStyle[O.selectProp]=O.userSelect)}static setTransform(t,e){t.style[O.transformProp]=e}static addEventListener(t,e,i,r={}){t.addEventListener(e,i,"passive"in r?r:r.capture)}static removeEventListener(t,e,i,r={}){t.removeEventListener(e,i,"passive"in r?r:r.capture)}static suppressClickInternal(t){t.preventDefault(),t.stopPropagation(),window.removeEventListener("click",O.suppressClickInternal,!0)}static suppressClick(){window.addEventListener("click",O.suppressClickInternal,!0),window.setTimeout((()=>{window.removeEventListener("click",O.suppressClickInternal,!0)}),0)}static getScale(t){const e=t.getBoundingClientRect();return{x:e.width/t.offsetWidth||1,y:e.height/t.offsetHeight||1,boundingClientRect:e}}static getPoint(t,e,i){const r=e.boundingClientRect;return new a((i.clientX-r.left)/e.x-t.clientLeft,(i.clientY-r.top)/e.y-t.clientTop)}static mousePos(t,e){const i=O.getScale(t);return O.getPoint(t,i,e)}static touchPos(t,e){const i=[],r=O.getScale(t);for(let s=0;s<e.length;s++)i.push(O.getPoint(t,r,e[s]));return i}static mouseButton(t){return t.button}static remove(t){t.parentNode&&t.parentNode.removeChild(t)}}O.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,O.selectProp=O.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),O.transformProp=O.testProp(["transform","WebkitTransform"]);const V={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function U(t){return V.REGISTERED_PROTOCOLS[t.substring(0,t.indexOf("://"))]}const N="global-dispatcher";class j extends Error{constructor(t,e,i,r){super(`AJAXError: ${e} (${t}): ${i}`),this.status=t,this.statusText=e,this.url=i,this.body=r}}const $=()=>z(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,q=function(t,e){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){const i=U(t.url);if(i)return i(t,e);if(z(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,targetMapId:N},e)}if(!(/^file:/.test(r=t.url)||/^file:/.test($())&&!/^\w+:/.test(r))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(t,e){return i(this,void 0,void 0,(function*(){const i=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,cache:t.cache,referrer:$(),signal:e.signal});"json"!==t.type||i.headers.has("Accept")||i.headers.set("Accept","application/json");const r=yield fetch(i);if(!r.ok){const e=yield r.blob();throw new j(r.status,r.statusText,t.url,e)}let s;s="arrayBuffer"===t.type||"image"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text();const n=yield s;if(e.signal.aborted)throw L();return{data:n,cacheControl:r.headers.get("Cache-Control"),expires:r.headers.get("Expires")}}))}(t,e);if(z(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,mustQueue:!0,targetMapId:N},e)}var r;return function(t,e){return new Promise(((i,r)=>{var s;const n=new XMLHttpRequest;n.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(n.responseType="arraybuffer");for(const e in t.headers)n.setRequestHeader(e,t.headers[e]);"json"===t.type&&(n.responseType="text",(null===(s=t.headers)||void 0===s?void 0:s.Accept)||n.setRequestHeader("Accept","application/json")),n.withCredentials="include"===t.credentials,n.onerror=()=>{r(new Error(n.statusText))},n.onload=()=>{if(!e.signal.aborted)if((n.status>=200&&n.status<300||0===n.status)&&null!==n.response){let e=n.response;if("json"===t.type)try{e=JSON.parse(n.response)}catch(t){return void r(t)}i({data:e,cacheControl:n.getResponseHeader("Cache-Control"),expires:n.getResponseHeader("Expires")})}else{const e=new Blob([n.response],{type:n.getResponseHeader("Content-Type")});r(new j(n.status,n.statusText,t.url,e))}},e.signal.addEventListener("abort",(()=>{n.abort(),r(L())})),n.send(t.body)}))}(t,e)},Z=(t,e)=>q(y(t,{type:"json"}),e);function G(t){if(!t||t.indexOf("://")<=0||0===t.indexOf("data:image/")||0===t.indexOf("blob:"))return!0;const e=new URL(t),i=window.location;return e.protocol===i.protocol&&e.host===i.host}const W={supported:!1,testSupport:function(t){!K&&X&&(Y?J(t):H=t)}};let H,X,K=!1,Y=!1;function J(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,X),t.isContextLost())return;W.supported=!0}catch(t){}t.deleteTexture(e),K=!0}var Q;"undefined"!=typeof document&&(X=document.createElement("img"),X.onload=()=>{H&&J(H),H=null,Y=!0},X.onerror=()=>{K=!0,H=null},X.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(t){let e,r,s,n;t.resetRequestQueue=()=>{e=[],r=0,s=0,n={}},t.addThrottleControl=t=>{const e=s++;return n[e]=t,e},t.removeThrottleControl=t=>{delete n[t],o()},t.getImage=(t,i,r=!0)=>new Promise(((s,n)=>{W.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),y(t,{type:"image"});const a={abortController:i,requestParameters:t,supportImageRefresh:r,state:"queued",onError:t=>{n(t)},onSuccess:t=>{s(t)}};e.push(a),o()}));const a=t=>i(this,void 0,void 0,(function*(){t.state="running";const{requestParameters:e,supportImageRefresh:s,onError:n,onSuccess:a,abortController:c}=t,h=!1===s&&!z(self)&&!U(e.url)&&(!e.headers||Object.keys(e.headers).reduce(((t,e)=>t&&"accept"===e),!0));r++;const u=h?l(e,c):q(e,c);try{const e=yield u;delete t.abortController,t.state="completed",e.data instanceof HTMLImageElement||M(e.data)?a(e):e.data&&a({data:yield(p=e.data,"function"==typeof createImageBitmap?(t=>i(void 0,void 0,void 0,(function*(){if(0===t.byteLength)return createImageBitmap(new ImageData(1,1));const e=new Blob([new Uint8Array(t)],{type:"image/png"});try{return createImageBitmap(e)}catch(t){throw new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`)}})))(p):(t=>new Promise(((e,i)=>{const r=new Image;r.onload=()=>{e(r),URL.revokeObjectURL(r.src),r.onload=null,window.requestAnimationFrame((()=>{r.src=k}))},r.onerror=()=>i(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const s=new Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?URL.createObjectURL(s):k})))(p)),cacheControl:e.cacheControl,expires:e.expires})}catch(e){delete t.abortController,n(e)}finally{r--,o()}var p})),o=()=>{const t=(()=>{for(const t of Object.keys(n))if(n[t]())return!0;return!1})()?V.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:V.MAX_PARALLEL_IMAGE_REQUESTS;for(let i=r;i<t&&e.length>0;i++){const t=e.shift();t.abortController.signal.aborted?i--:a(t)}},l=(t,e)=>new Promise(((i,r)=>{const s=new Image,n=t.url,a=t.credentials;a&&"include"===a?s.crossOrigin="use-credentials":(a&&"same-origin"===a||!G(n))&&(s.crossOrigin="anonymous"),e.signal.addEventListener("abort",(()=>{s.src="",r(L())})),s.fetchPriority="high",s.onload=()=>{s.onerror=s.onload=null,i({data:s})},s.onerror=()=>{s.onerror=s.onload=null,e.signal.aborted||r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."))},s.src=n}))}(Q||(Q={})),Q.resetRequestQueue();class tt{constructor(t){this._transformRequestFn=t}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}setTransformRequest(t){this._transformRequestFn=t}}function et(t,e,i){i[t]&&-1!==i[t].indexOf(e)||(i[t]=i[t]||[],i[t].push(e))}function it(t,e,i){if(i&&i[t]){const r=i[t].indexOf(e);-1!==r&&i[t].splice(r,1)}}class rt{constructor(t,e={}){y(this,e),this.type=t}}class st extends rt{constructor(t,e={}){super("error",y({error:t},e))}}class nt{on(t,e){return this._listeners=this._listeners||{},et(t,e,this._listeners),this}off(t,e){return it(t,e,this._listeners),it(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},et(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new rt(t,e||{}));const i=t.type;if(this.listens(i)){t.target=this;const e=this._listeners&&this._listeners[i]?this._listeners[i].slice():[];for(const i of e)i.call(this,t);const r=this._oneTimeListeners&&this._oneTimeListeners[i]?this._oneTimeListeners[i].slice():[];for(const e of r)it(i,e,this._oneTimeListeners),e.call(this,t);const s=this._eventedParent;s&&(y(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),s.fire(t))}else t instanceof st&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var at={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"enum",default:"mercator",values:{mercator:{},globe:{}}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"number",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"color",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const ot=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function lt(t,e){const i={};for(const e in t)"ref"!==e&&(i[e]=t[e]);return ot.forEach((t=>{t in e&&(i[t]=e[t])})),i}function ct(t){t=t.slice();const e=Object.create(null);for(let i=0;i<t.length;i++)e[t[i].id]=t[i];for(let i=0;i<t.length;i++)"ref"in t[i]&&(t[i]=lt(t[i],e[t[i].ref]));return t}function ht(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return!1;for(let i=0;i<t.length;i++)if(!ht(t[i],e[i]))return!1;return!0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return!1;if(Object.keys(t).length!==Object.keys(e).length)return!1;for(const i in t)if(!ht(t[i],e[i]))return!1;return!0}return t===e}function ut(t,e){t.push(e)}function pt(t,e,i){ut(i,{command:"addSource",args:[t,e[t]]})}function dt(t,e,i){ut(e,{command:"removeSource",args:[t]}),i[t]=!0}function ft(t,e,i,r){dt(t,i,r),pt(t,e,i)}function mt(t,e,i){let r;for(r in t[i])if(Object.prototype.hasOwnProperty.call(t[i],r)&&"data"!==r&&!ht(t[i][r],e[i][r]))return!1;for(r in e[i])if(Object.prototype.hasOwnProperty.call(e[i],r)&&"data"!==r&&!ht(t[i][r],e[i][r]))return!1;return!0}function _t(t,e,i,r,s,n){t=t||{},e=e||{};for(const a in t)Object.prototype.hasOwnProperty.call(t,a)&&(ht(t[a],e[a])||i.push({command:n,args:[r,a,e[a],s]}));for(const a in e)Object.prototype.hasOwnProperty.call(e,a)&&!Object.prototype.hasOwnProperty.call(t,a)&&(ht(t[a],e[a])||i.push({command:n,args:[r,a,e[a],s]}))}function gt(t){return t.id}function yt(t,e){return t[e.id]=e,t}class xt{constructor(t,e,i,r){this.message=(t?`${t}: `:"")+i,r&&(this.identifier=r),null!=e&&e.__line__&&(this.line=e.__line__)}}function vt(t,...e){for(const i of e)for(const e in i)t[e]=i[e];return t}class bt extends Error{constructor(t,e){super(e),this.message=e,this.key=t}}class wt{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,i]of e)this.bindings[t]=i}concat(t){return new wt(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return!!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const Tt={kind:"null"},St={kind:"number"},It={kind:"string"},At={kind:"boolean"},Ct={kind:"color"},Et={kind:"object"},zt={kind:"value"},Pt={kind:"collator"},Mt={kind:"formatted"},kt={kind:"padding"},Dt={kind:"resolvedImage"},Lt={kind:"variableAnchorOffsetCollection"};function Rt(t,e){return{kind:"array",itemType:t,N:e}}function Bt(t){if("array"===t.kind){const e=Bt(t.itemType);return"number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const Ft=[Tt,St,It,At,Ct,Mt,Et,Rt(zt),kt,Dt,Lt];function Ot(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!Ot(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else{if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of Ft)if(!Ot(t,e))return null}return`Expected ${Bt(t)} but found ${Bt(e)} instead.`}function Vt(t,e){return e.some((e=>e.kind===t.kind))}function Ut(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function Nt(t,e){return"array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const jt=.96422,$t=.82521,qt=4/29,Zt=6/29,Gt=3*Zt*Zt,Wt=Zt*Zt*Zt,Ht=Math.PI/180,Xt=180/Math.PI;function Kt(t){return(t%=360)<0&&(t+=360),t}function Yt([t,e,i,r]){let s,n;const a=Qt((.2225045*(t=Jt(t))+.7168786*(e=Jt(e))+.0606169*(i=Jt(i)))/1);t===e&&e===i?s=n=a:(s=Qt((.4360747*t+.3850649*e+.1430804*i)/jt),n=Qt((.0139322*t+.0971045*e+.7141733*i)/$t));const o=116*a-16;return[o<0?0:o,500*(s-a),200*(a-n),r]}function Jt(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function Qt(t){return t>Wt?Math.pow(t,1/3):t/Gt+qt}function te([t,e,i,r]){let s=(t+16)/116,n=isNaN(e)?s:s+e/500,a=isNaN(i)?s:s-i/200;return s=1*ie(s),n=jt*ie(n),a=$t*ie(a),[ee(3.1338561*n-1.6168667*s-.4906146*a),ee(-.9787684*n+1.9161415*s+.033454*a),ee(.0719453*n-.2289914*s+1.4052427*a),r]}function ee(t){return(t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function ie(t){return t>Zt?t*t*t:Gt*(t-qt)}function re(t){return parseInt(t.padEnd(2,t),16)/255}function se(t,e){return ne(e?t/100:t,0,1)}function ne(t,e,i){return Math.min(Math.max(e,t),i)}function ae(t){return!t.some(Number.isNaN)}const oe={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};class le{constructor(t,e,i,r=1,s=!0){this.r=t,this.g=e,this.b=i,this.a=r,s||(this.r*=r,this.g*=r,this.b*=r,r||this.overwriteGetter("rgb",[t,e,i,r]))}static parse(t){if(t instanceof le)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return[0,0,0,0];const e=oe[t];if(e){const[t,i,r]=e;return[t/255,i/255,r/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let i=1;return[re(t.slice(i,i+=e)),re(t.slice(i,i+=e)),re(t.slice(i,i+=e)),re(t.slice(i,i+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,i,r,s,n,a,o,l,c,h,u,p]=e,d=[s||" ",o||" ",h].join("");if("  "===d||"  /"===d||",,"===d||",,,"===d){const t=[r,a,c].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[ne(+i/e,0,1),ne(+n/e,0,1),ne(+l/e,0,1),u?se(+u,p):1];if(ae(t))return t}}return}}const i=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(i){const[t,e,r,s,n,a,o,l,c]=i,h=[r||" ",n||" ",o].join("");if("  "===h||"  /"===h||",,"===h||",,,"===h){const t=[+e,ne(+s,0,100),ne(+a,0,100),l?se(+l,c):1];if(ae(t))return function([t,e,i,r]){function s(r){const s=(r+t/30)%12,n=e*Math.min(i,1-i);return i-n*Math.max(-1,Math.min(s-3,9-s,1))}return t=Kt(t),e/=100,i/=100,[s(0),s(8),s(4),r]}(t)}}}(t);return e?new le(...e,!1):void 0}get rgb(){const{r:t,g:e,b:i,a:r}=this,s=r||1/0;return this.overwriteGetter("rgb",[t/s,e/s,i/s,r])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,i,r,s]=Yt(t),n=Math.sqrt(i*i+r*r);return[Math.round(1e4*n)?Kt(Math.atan2(r,i)*Xt):NaN,n,e,s]}(this.rgb))}get lab(){return this.overwriteGetter("lab",Yt(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,i,r]=this.rgb;return`rgba(${[t,e,i].map((t=>Math.round(255*t))).join(",")},${r})`}}le.black=new le(0,0,0,1),le.white=new le(1,1,1,1),le.transparent=new le(0,0,0,0),le.red=new le(1,0,0,1);class ce{constructor(t,e,i){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=i,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"})}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class he{constructor(t,e,i,r,s){this.text=t,this.image=e,this.scale=i,this.fontStack=r,this.textColor=s}}class ue{constructor(t){this.sections=t}static fromString(t){return new ue([new he(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof ue?t:ue.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class pe{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof pe)return t;if("number"==typeof t)return new pe([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]]}return new pe(t)}}toString(){return JSON.stringify(this.values)}}const de=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class fe{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof fe)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const i=t[e],r=t[e+1];if("string"!=typeof i||!de.has(i))return;if(!Array.isArray(r)||2!==r.length||"number"!=typeof r[0]||"number"!=typeof r[1])return}return new fe(t)}}toString(){return JSON.stringify(this.values)}}class me{constructor(t){this.name=t.name,this.available=t.available}toString(){return this.name}static fromString(t){return t?new me({name:t,available:!1}):null}}function _e(t,e,i,r){return"number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof i&&i>=0&&i<=255?void 0===r||"number"==typeof r&&r>=0&&r<=1?null:`Invalid rgba value [${[t,e,i,r].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof r?[t,e,i,r]:[t,e,i]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function ge(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof le||t instanceof ce||t instanceof ue||t instanceof pe||t instanceof fe||t instanceof me)return!0;if(Array.isArray(t)){for(const e of t)if(!ge(e))return!1;return!0}if("object"==typeof t){for(const e in t)if(!ge(t[e]))return!1;return!0}return!1}function ye(t){if(null===t)return Tt;if("string"==typeof t)return It;if("boolean"==typeof t)return At;if("number"==typeof t)return St;if(t instanceof le)return Ct;if(t instanceof ce)return Pt;if(t instanceof ue)return Mt;if(t instanceof pe)return kt;if(t instanceof fe)return Lt;if(t instanceof me)return Dt;if(Array.isArray(t)){const e=t.length;let i;for(const e of t){const t=ye(e);if(i){if(i===t)continue;i=zt;break}i=t}return Rt(i||zt,e)}return Et}function xe(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof le||t instanceof ue||t instanceof pe||t instanceof fe||t instanceof me?t.toString():JSON.stringify(t)}class ve{constructor(t,e){this.type=t,this.value=e}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!ge(t[1]))return e.error("invalid value");const i=t[1];let r=ye(i);const s=e.expectedType;return"array"!==r.kind||0!==r.N||!s||"array"!==s.kind||"number"==typeof s.N&&0!==s.N||(r=s),new ve(r,i)}evaluate(){return this.value}eachChild(){}outputDefined(){return!0}}class be{constructor(t){this.name="ExpressionEvaluationError",this.message=t}toJSON(){return this.message}}const we={string:It,number:St,boolean:At,object:Et};class Te{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let i,r=1;const s=t[0];if("array"===s){let s,n;if(t.length>2){const i=t[1];if("string"!=typeof i||!(i in we)||"object"===i)return e.error('The item type argument of "array" must be one of string, number, boolean',1);s=we[i],r++}else s=zt;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);n=t[2],r++}i=Rt(s,n)}else{if(!we[s])throw new Error(`Types doesn't contain name = ${s}`);i=we[s]}const n=[];for(;r<t.length;r++){const i=e.parse(t[r],r,zt);if(!i)return null;n.push(i)}return new Te(i,n)}evaluate(t){for(let e=0;e<this.args.length;e++){const i=this.args[e].evaluate(t);if(!Ot(this.type,ye(i)))return i;if(e===this.args.length-1)throw new be(`Expected value to be of type ${Bt(this.type)}, but found ${Bt(ye(i))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Se={"to-boolean":At,"to-color":Ct,"to-number":St,"to-string":It};class Ie{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const i=t[0];if(!Se[i])throw new Error(`Can't parse ${i} as it is not part of the known types`);if(("to-boolean"===i||"to-string"===i)&&2!==t.length)return e.error("Expected one argument.");const r=Se[i],s=[];for(let i=1;i<t.length;i++){const r=e.parse(t[i],i,zt);if(!r)return null;s.push(r)}return new Ie(r,s)}evaluate(t){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(t));case"color":{let e,i;for(const r of this.args){if(e=r.evaluate(t),i=null,e instanceof le)return e;if("string"==typeof e){const i=t.parseColor(e);if(i)return i}else if(Array.isArray(e)&&(i=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:_e(e[0],e[1],e[2],e[3]),!i))return new le(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new be(i||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"padding":{let e;for(const i of this.args){e=i.evaluate(t);const r=pe.parse(e);if(r)return r}throw new be(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"variableAnchorOffsetCollection":{let e;for(const i of this.args){e=i.evaluate(t);const r=fe.parse(e);if(r)return r}throw new be(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"number":{let e=null;for(const i of this.args){if(e=i.evaluate(t),null===e)return 0;const r=Number(e);if(!isNaN(r))return r}throw new be(`Could not convert ${JSON.stringify(e)} to number.`)}case"formatted":return ue.fromString(xe(this.args[0].evaluate(t)));case"resolvedImage":return me.fromString(xe(this.args[0].evaluate(t)));default:return xe(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Ae=["Unknown","Point","LineString","Polygon"];class Ce{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Ae[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=le.parse(t)),e}}class Ee{constructor(t,e,i=[],r,s=new wt,n=[]){this.registry=t,this.path=i,this.key=i.map((t=>`[${t}]`)).join(""),this.scope=s,this.errors=n,this.expectedType=r,this._isConstant=e}parse(t,e,i,r,s={}){return e?this.concat(e,i,r)._parse(t,s):this._parse(t,s)}_parse(t,e){function i(t,e,i){return"assert"===i?new Te(e,[t]):"coerce"===i?new Ie(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const r=t[0];if("string"!=typeof r)return this.error(`Expression name must be a string, but found ${typeof r} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const s=this.registry[r];if(s){let r=s.parse(t,this);if(!r)return null;if(this.expectedType){const t=this.expectedType,s=r.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==s.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==s.kind&&"string"!==s.kind)if("padding"!==t.kind||"value"!==s.kind&&"number"!==s.kind&&"array"!==s.kind)if("variableAnchorOffsetCollection"!==t.kind||"value"!==s.kind&&"array"!==s.kind){if(this.checkSubtype(t,s))return null}else r=i(r,t,e.typeAnnotation||"coerce");else r=i(r,t,e.typeAnnotation||"coerce");else r=i(r,t,e.typeAnnotation||"coerce");else r=i(r,t,e.typeAnnotation||"assert")}if(!(r instanceof ve)&&"resolvedImage"!==r.type.kind&&this._isConstant(r)){const t=new Ce;try{r=new ve(r.type,r.evaluate(t))}catch(t){return this.error(t.message),null}}return r}return this.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,i){const r="number"==typeof t?this.path.concat(t):this.path,s=i?this.scope.concat(i):this.scope;return new Ee(this.registry,this._isConstant,r,e||null,s,this.errors)}error(t,...e){const i=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new bt(i,t))}checkSubtype(t,e){const i=Ot(t,e);return i&&this.error(i),i}}class ze{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result)}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const i=[];for(let r=1;r<t.length-1;r+=2){const s=t[r];if("string"!=typeof s)return e.error(`Expected string, but found ${typeof s} instead.`,r);if(/[^a-zA-Z0-9_]/.test(s))return e.error("Variable names must contain only alphanumeric characters or '_'.",r);const n=e.parse(t[r+1],r+1);if(!n)return null;i.push([s,n])}const r=e.parse(t[t.length-1],t.length-1,e.expectedType,i);return r?new ze(i,r):null}outputDefined(){return this.result.outputDefined()}}class Pe{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const i=t[1];return e.scope.has(i)?new Pe(i,e.scope.get(i)):e.error(`Unknown variable "${i}". Make sure "${i}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return!1}}class Me{constructor(t,e,i){this.type=t,this.index=e,this.input=i}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,St),r=e.parse(t[2],2,Rt(e.expectedType||zt));return i&&r?new Me(r.type.itemType,i,r):null}evaluate(t){const e=this.index.evaluate(t),i=this.input.evaluate(t);if(e<0)throw new be(`Array index out of bounds: ${e} < 0.`);if(e>=i.length)throw new be(`Array index out of bounds: ${e} > ${i.length-1}.`);if(e!==Math.floor(e))throw new be(`Array index must be an integer, but found ${e} instead.`);return i[e]}eachChild(t){t(this.index),t(this.input)}outputDefined(){return!1}}class ke{constructor(t,e){this.type=At,this.needle=t,this.haystack=e}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,zt),r=e.parse(t[2],2,zt);return i&&r?Vt(i.type,[At,It,St,Tt,zt])?new ke(i,r):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Bt(i.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),i=this.haystack.evaluate(t);if(!i)return!1;if(!Ut(e,["boolean","string","number","null"]))throw new be(`Expected first argument to be of type boolean, string, number or null, but found ${Bt(ye(e))} instead.`);if(!Ut(i,["string","array"]))throw new be(`Expected second argument to be of type array or string, but found ${Bt(ye(i))} instead.`);return i.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack)}outputDefined(){return!0}}class De{constructor(t,e,i){this.type=St,this.needle=t,this.haystack=e,this.fromIndex=i}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,zt),r=e.parse(t[2],2,zt);if(!i||!r)return null;if(!Vt(i.type,[At,It,St,Tt,zt]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Bt(i.type)} instead`);if(4===t.length){const s=e.parse(t[3],3,St);return s?new De(i,r,s):null}return new De(i,r)}evaluate(t){const e=this.needle.evaluate(t),i=this.haystack.evaluate(t);if(!Ut(e,["boolean","string","number","null"]))throw new be(`Expected first argument to be of type boolean, string, number or null, but found ${Bt(ye(e))} instead.`);let r;if(this.fromIndex&&(r=this.fromIndex.evaluate(t)),Ut(i,["string"])){const t=i.indexOf(e,r);return-1===t?-1:[...i.slice(0,t)].length}if(Ut(i,["array"]))return i.indexOf(e,r);throw new be(`Expected second argument to be of type array or string, but found ${Bt(ye(i))} instead.`)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex)}outputDefined(){return!1}}class Le{constructor(t,e,i,r,s,n){this.inputType=t,this.type=e,this.input=i,this.cases=r,this.outputs=s,this.otherwise=n}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let i,r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const s={},n=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const c=e.concat(a);if(0===o.length)return c.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return c.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return c.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return c.error("Numeric branch labels must be integer values.");if(i){if(c.checkSubtype(i,ye(t)))return null}else i=ye(t);if(void 0!==s[String(t)])return c.error("Branch labels must be unique.");s[String(t)]=n.length}const h=e.parse(l,a,r);if(!h)return null;r=r||h.type,n.push(h)}const a=e.parse(t[1],1,zt);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,r);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(i,a.type)?null:new Le(i,r,a,s,n,o):null}evaluate(t){const e=this.input.evaluate(t);return(ye(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class Re{constructor(t,e,i){this.type=t,this.branches=e,this.otherwise=i}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let i;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);const r=[];for(let s=1;s<t.length-1;s+=2){const n=e.parse(t[s],s,At);if(!n)return null;const a=e.parse(t[s+1],s+1,i);if(!a)return null;r.push([n,a]),i=i||a.type}const s=e.parse(t[t.length-1],t.length-1,i);if(!s)return null;if(!i)throw new Error("Can't infer output type");return new Re(i,r,s)}evaluate(t){for(const[e,i]of this.branches)if(e.evaluate(t))return i.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,i]of this.branches)t(e),t(i);t(this.otherwise)}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class Be{constructor(t,e,i,r){this.type=t,this.input=e,this.beginIndex=i,this.endIndex=r}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,zt),r=e.parse(t[2],2,St);if(!i||!r)return null;if(!Vt(i.type,[Rt(zt),It,zt]))return e.error(`Expected first argument to be of type array or string, but found ${Bt(i.type)} instead`);if(4===t.length){const s=e.parse(t[3],3,St);return s?new Be(i.type,i,r,s):null}return new Be(i.type,i,r)}evaluate(t){const e=this.input.evaluate(t),i=this.beginIndex.evaluate(t);let r;if(this.endIndex&&(r=this.endIndex.evaluate(t)),Ut(e,["string"]))return[...e].slice(i,r).join("");if(Ut(e,["array"]))return e.slice(i,r);throw new be(`Expected first argument to be of type array or string, but found ${Bt(ye(e))} instead.`)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex)}outputDefined(){return!1}}function Fe(t,e){const i=t.length-1;let r,s,n=0,a=i,o=0;for(;n<=a;)if(o=Math.floor((n+a)/2),r=t[o],s=t[o+1],r<=e){if(o===i||e<s)return o;n=o+1}else{if(!(r>e))throw new be("Input is not a number.");a=o-1}return 0}class Oe{constructor(t,e,i){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e)}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const i=e.parse(t[1],1,St);if(!i)return null;const r=[];let s=null;e.expectedType&&"value"!==e.expectedType.kind&&(s=e.expectedType);for(let i=1;i<t.length;i+=2){const n=1===i?-1/0:t[i],a=t[i+1],o=i,l=i+1;if("number"!=typeof n)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(r.length&&r[r.length-1][0]>=n)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const c=e.parse(a,l,s);if(!c)return null;s=s||c.type,r.push([n,c])}return new Oe(s,i,r)}evaluate(t){const e=this.labels,i=this.outputs;if(1===e.length)return i[0].evaluate(t);const r=this.input.evaluate(t);if(r<=e[0])return i[0].evaluate(t);const s=e.length;return r>=e[s-1]?i[s-1].evaluate(t):i[Fe(e,r)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function Ve(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var Ue=Ne;function Ne(t,e,i,r){this.cx=3*t,this.bx=3*(i-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(r-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=i,this.p2y=r}Ne.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var i=t,r=0;r<8;r++){var s=this.sampleCurveX(i)-t;if(Math.abs(s)<e)return i;var n=this.sampleCurveDerivativeX(i);if(Math.abs(n)<1e-6)break;i-=s/n}var a=0,o=1;for(i=t,r=0;r<20&&(s=this.sampleCurveX(i),!(Math.abs(s-t)<e));r++)t>s?a=i:o=i,i=.5*(o-a)+a;return i},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}};var je=Ve(Ue);function $e(t,e,i){return t+i*(e-t)}function qe(t,e,i){return t.map(((t,r)=>$e(t,e[r],i)))}const Ze={number:$e,color:function(t,e,i,r="rgb"){switch(r){case"rgb":{const[r,s,n,a]=qe(t.rgb,e.rgb,i);return new le(r,s,n,a,!1)}case"hcl":{const[r,s,n,a]=t.hcl,[o,l,c,h]=e.hcl;let u,p;if(isNaN(r)||isNaN(o))isNaN(r)?isNaN(o)?u=NaN:(u=o,1!==n&&0!==n||(p=l)):(u=r,1!==c&&0!==c||(p=s));else{let t=o-r;o>r&&t>180?t-=360:o<r&&r-o>180&&(t+=360),u=r+i*t}const[d,f,m,_]=function([t,e,i,r]){return t=isNaN(t)?0:t*Ht,te([i,Math.cos(t)*e,Math.sin(t)*e,r])}([u,null!=p?p:$e(s,l,i),$e(n,c,i),$e(a,h,i)]);return new le(d,f,m,_,!1)}case"lab":{const[r,s,n,a]=te(qe(t.lab,e.lab,i));return new le(r,s,n,a,!1)}}},array:qe,padding:function(t,e,i){return new pe(qe(t.values,e.values,i))},variableAnchorOffsetCollection:function(t,e,i){const r=t.values,s=e.values;if(r.length!==s.length)throw new be(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const n=[];for(let t=0;t<r.length;t+=2){if(r[t]!==s[t])throw new be(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${r[t]}, to[${t}]: ${s[t]}`);n.push(r[t]);const[e,a]=r[t+1],[o,l]=s[t+1];n.push([$e(e,o,i),$e(a,l,i)])}return new fe(n)}};class Ge{constructor(t,e,i,r,s){this.type=t,this.operator=e,this.interpolation=i,this.input=r,this.labels=[],this.outputs=[];for(const[t,e]of s)this.labels.push(t),this.outputs.push(e)}static interpolationFactor(t,e,i,r){let s=0;if("exponential"===t.name)s=We(e,t.base,i,r);else if("linear"===t.name)s=We(e,1,i,r);else if("cubic-bezier"===t.name){const n=t.controlPoints;s=new je(n[0],n[1],n[2],n[3]).solve(We(e,1,i,r))}return s}static parse(t,e){let[i,r,s,...n]=t;if(!Array.isArray(r)||0===r.length)return e.error("Expected an interpolation type expression.",1);if("linear"===r[0])r={name:"linear"};else if("exponential"===r[0]){const t=r[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);r={name:"exponential",base:t}}else{if("cubic-bezier"!==r[0])return e.error(`Unknown interpolation type ${String(r[0])}`,1,0);{const t=r.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);r={name:"cubic-bezier",controlPoints:t}}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(s=e.parse(s,2,St),!s)return null;const a=[];let o=null;"interpolate-hcl"===i||"interpolate-lab"===i?o=Ct:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<n.length;t+=2){const i=n[t],r=n[t+1],s=t+3,l=t+4;if("number"!=typeof i)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',s);if(a.length&&a[a.length-1][0]>=i)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',s);const c=e.parse(r,l,o);if(!c)return null;o=o||c.type,a.push([i,c])}return Nt(o,St)||Nt(o,Ct)||Nt(o,kt)||Nt(o,Lt)||Nt(o,Rt(St))?new Ge(o,i,r,s,a):e.error(`Type ${Bt(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,i=this.outputs;if(1===e.length)return i[0].evaluate(t);const r=this.input.evaluate(t);if(r<=e[0])return i[0].evaluate(t);const s=e.length;if(r>=e[s-1])return i[s-1].evaluate(t);const n=Fe(e,r),a=Ge.interpolationFactor(this.interpolation,r,e[n],e[n+1]),o=i[n].evaluate(t),l=i[n+1].evaluate(t);switch(this.operator){case"interpolate":return Ze[this.type.kind](o,l,a);case"interpolate-hcl":return Ze.color(o,l,a,"hcl");case"interpolate-lab":return Ze.color(o,l,a,"lab")}}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function We(t,e,i,r){const s=r-i,n=t-i;return 0===s?0:1===e?n/s:(Math.pow(e,n)-1)/(Math.pow(e,s)-1)}class He{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let i=null;const r=e.expectedType;r&&"value"!==r.kind&&(i=r);const s=[];for(const r of t.slice(1)){const t=e.parse(r,1+s.length,i,void 0,{typeAnnotation:"omit"});if(!t)return null;i=i||t.type,s.push(t)}if(!i)throw new Error("No output type");const n=r&&s.some((t=>Ot(r,t.type)));return new He(n?zt:i,s)}evaluate(t){let e,i=null,r=0;for(const s of this.args)if(r++,i=s.evaluate(t),i&&i instanceof me&&!i.available&&(e||(e=i.name),i=null,r===this.args.length&&(i=e)),null!==i)break;return i}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}function Xe(t,e){return"=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function Ke(t,e,i,r){return 0===r.compare(e,i)}function Ye(t,e,i){const r="=="!==t&&"!="!==t;return class s{constructor(t,e,i){this.type=At,this.lhs=t,this.rhs=e,this.collator=i,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const i=t[0];let n=e.parse(t[1],1,zt);if(!n)return null;if(!Xe(i,n.type))return e.concat(1).error(`"${i}" comparisons are not supported for type '${Bt(n.type)}'.`);let a=e.parse(t[2],2,zt);if(!a)return null;if(!Xe(i,a.type))return e.concat(2).error(`"${i}" comparisons are not supported for type '${Bt(a.type)}'.`);if(n.type.kind!==a.type.kind&&"value"!==n.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${Bt(n.type)}' and '${Bt(a.type)}'.`);r&&("value"===n.type.kind&&"value"!==a.type.kind?n=new Te(a.type,[n]):"value"!==n.type.kind&&"value"===a.type.kind&&(a=new Te(n.type,[a])));let o=null;if(4===t.length){if("string"!==n.type.kind&&"string"!==a.type.kind&&"value"!==n.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,Pt),!o)return null}return new s(n,a,o)}evaluate(s){const n=this.lhs.evaluate(s),a=this.rhs.evaluate(s);if(r&&this.hasUntypedArgument){const e=ye(n),i=ye(a);if(e.kind!==i.kind||"string"!==e.kind&&"number"!==e.kind)throw new be(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${i.kind}) instead.`)}if(this.collator&&!r&&this.hasUntypedArgument){const t=ye(n),i=ye(a);if("string"!==t.kind||"string"!==i.kind)return e(s,n,a)}return this.collator?i(s,n,a,this.collator.evaluate(s)):e(s,n,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator)}outputDefined(){return!0}}}const Je=Ye("==",(function(t,e,i){return e===i}),Ke),Qe=Ye("!=",(function(t,e,i){return e!==i}),(function(t,e,i,r){return!Ke(0,e,i,r)})),ti=Ye("<",(function(t,e,i){return e<i}),(function(t,e,i,r){return r.compare(e,i)<0})),ei=Ye(">",(function(t,e,i){return e>i}),(function(t,e,i,r){return r.compare(e,i)>0})),ii=Ye("<=",(function(t,e,i){return e<=i}),(function(t,e,i,r){return r.compare(e,i)<=0})),ri=Ye(">=",(function(t,e,i){return e>=i}),(function(t,e,i,r){return r.compare(e,i)>=0}));class si{constructor(t,e,i){this.type=Pt,this.locale=i,this.caseSensitive=t,this.diacriticSensitive=e}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const i=t[1];if("object"!=typeof i||Array.isArray(i))return e.error("Collator options argument must be an object.");const r=e.parse(void 0!==i["case-sensitive"]&&i["case-sensitive"],1,At);if(!r)return null;const s=e.parse(void 0!==i["diacritic-sensitive"]&&i["diacritic-sensitive"],1,At);if(!s)return null;let n=null;return i.locale&&(n=e.parse(i.locale,1,It),!n)?null:new si(r,s,n)}evaluate(t){return new ce(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale)}outputDefined(){return!1}}class ni{constructor(t,e,i,r,s){this.type=It,this.number=t,this.locale=e,this.currency=i,this.minFractionDigits=r,this.maxFractionDigits=s}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const i=e.parse(t[1],1,St);if(!i)return null;const r=t[2];if("object"!=typeof r||Array.isArray(r))return e.error("NumberFormat options argument must be an object.");let s=null;if(r.locale&&(s=e.parse(r.locale,1,It),!s))return null;let n=null;if(r.currency&&(n=e.parse(r.currency,1,It),!n))return null;let a=null;if(r["min-fraction-digits"]&&(a=e.parse(r["min-fraction-digits"],1,St),!a))return null;let o=null;return r["max-fraction-digits"]&&(o=e.parse(r["max-fraction-digits"],1,St),!o)?null:new ni(i,s,n,a,o)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits)}outputDefined(){return!1}}class ai{constructor(t){this.type=Mt,this.sections=t}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const i=t[1];if(!Array.isArray(i)&&"object"==typeof i)return e.error("First argument must be an image or text section.");const r=[];let s=!1;for(let i=1;i<=t.length-1;++i){const n=t[i];if(s&&"object"==typeof n&&!Array.isArray(n)){s=!1;let t=null;if(n["font-scale"]&&(t=e.parse(n["font-scale"],1,St),!t))return null;let i=null;if(n["text-font"]&&(i=e.parse(n["text-font"],1,Rt(It)),!i))return null;let a=null;if(n["text-color"]&&(a=e.parse(n["text-color"],1,Ct),!a))return null;const o=r[r.length-1];o.scale=t,o.font=i,o.textColor=a}else{const n=e.parse(t[i],1,zt);if(!n)return null;const a=n.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");s=!0,r.push({content:n,scale:null,font:null,textColor:null})}}return new ai(r)}evaluate(t){return new ue(this.sections.map((e=>{const i=e.content.evaluate(t);return ye(i)===Dt?new he("",i,null,null,null):new he(xe(i),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor)}outputDefined(){return!1}}class oi{constructor(t){this.type=Dt,this.input=t}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const i=e.parse(t[1],1,It);return i?new oi(i):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),i=me.fromString(e);return i&&t.availableImages&&(i.available=t.availableImages.indexOf(e)>-1),i}eachChild(t){t(this.input)}outputDefined(){return!1}}class li{constructor(t){this.type=St,this.input=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const i=e.parse(t[1],1);return i?"array"!==i.type.kind&&"string"!==i.type.kind&&"value"!==i.type.kind?e.error(`Expected argument of type string or array, but found ${Bt(i.type)} instead.`):new li(i):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return[...e].length;if(Array.isArray(e))return e.length;throw new be(`Expected value to be of type string or array, but found ${Bt(ye(e))} instead.`)}eachChild(t){t(this.input)}outputDefined(){return!1}}const ci=8192;function hi(t,e){const i=(180+t[0])/360,r=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,s=Math.pow(2,e.z);return[Math.round(i*s*ci),Math.round(r*s*ci)]}function ui(t,e){const i=Math.pow(2,e.z);return[(s=(t[0]/ci+e.x)/i,360*s-180),(r=(t[1]/ci+e.y)/i,360/Math.PI*Math.atan(Math.exp((180-360*r)*Math.PI/180))-90)];var r,s}function pi(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1])}function di(t,e){return!(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function fi(t,e,i){const r=t[0]-e[0],s=t[1]-e[1],n=t[0]-i[0],a=t[1]-i[1];return r*a-n*s==0&&r*n<=0&&s*a<=0}function mi(t,e,i,r){return 0!=(s=[r[0]-i[0],r[1]-i[1]])[0]*(n=[e[0]-t[0],e[1]-t[1]])[1]-s[1]*n[0]&&!(!bi(t,e,i,r)||!bi(i,r,t,e));var s,n}function _i(t,e,i){for(const r of i)for(let i=0;i<r.length-1;++i)if(mi(t,e,r[i],r[i+1]))return!0;return!1}function gi(t,e,i=!1){let r=!1;for(const o of e)for(let e=0;e<o.length-1;e++){if(fi(t,o[e],o[e+1]))return i;(n=o[e])[1]>(s=t)[1]!=(a=o[e+1])[1]>s[1]&&s[0]<(a[0]-n[0])*(s[1]-n[1])/(a[1]-n[1])+n[0]&&(r=!r)}var s,n,a;return r}function yi(t,e){for(const i of e)if(gi(t,i))return!0;return!1}function xi(t,e){for(const i of t)if(!gi(i,e))return!1;for(let i=0;i<t.length-1;++i)if(_i(t[i],t[i+1],e))return!1;return!0}function vi(t,e){for(const i of e)if(xi(t,i))return!0;return!1}function bi(t,e,i,r){const s=r[0]-i[0],n=r[1]-i[1],a=(t[0]-i[0])*n-s*(t[1]-i[1]),o=(e[0]-i[0])*n-s*(e[1]-i[1]);return a>0&&o<0||a<0&&o>0}function wi(t,e,i){const r=[];for(let s=0;s<t.length;s++){const n=[];for(let r=0;r<t[s].length;r++){const a=hi(t[s][r],i);pi(e,a),n.push(a)}r.push(n)}return r}function Ti(t,e,i){const r=[];for(let s=0;s<t.length;s++){const n=wi(t[s],e,i);r.push(n)}return r}function Si(t,e,i,r){if(t[0]<i[0]||t[0]>i[2]){const e=.5*r;let s=t[0]-i[0]>e?-r:i[0]-t[0]>e?r:0;0===s&&(s=t[0]-i[2]>e?-r:i[2]-t[0]>e?r:0),t[0]+=s}pi(e,t)}function Ii(t,e,i,r){const s=Math.pow(2,r.z)*ci,n=[r.x*ci,r.y*ci],a=[];for(const r of t)for(const t of r){const r=[t.x+n[0],t.y+n[1]];Si(r,e,i,s),a.push(r)}return a}function Ai(t,e,i,r){const s=Math.pow(2,r.z)*ci,n=[r.x*ci,r.y*ci],a=[];for(const i of t){const t=[];for(const r of i){const i=[r.x+n[0],r.y+n[1]];pi(e,i),t.push(i)}a.push(t)}if(e[2]-e[0]<=s/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const r of t)Si(r,e,i,s)}var o;return a}class Ci{constructor(t,e){this.type=At,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(ge(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const i of e.features){const{type:e,coordinates:r}=i.geometry;"Polygon"===e&&t.push(r),"MultiPolygon"===e&&t.push(...r)}if(t.length)return new Ci(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Ci(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Ci(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],s=t.canonicalID();if("Polygon"===e.type){const n=wi(e.coordinates,r,s),a=Ii(t.geometry(),i,r,s);if(!di(i,r))return!1;for(const t of a)if(!gi(t,n))return!1}if("MultiPolygon"===e.type){const n=Ti(e.coordinates,r,s),a=Ii(t.geometry(),i,r,s);if(!di(i,r))return!1;for(const t of a)if(!yi(t,n))return!1}return!0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],s=t.canonicalID();if("Polygon"===e.type){const n=wi(e.coordinates,r,s),a=Ai(t.geometry(),i,r,s);if(!di(i,r))return!1;for(const t of a)if(!xi(t,n))return!1}if("MultiPolygon"===e.type){const n=Ti(e.coordinates,r,s),a=Ai(t.geometry(),i,r,s);if(!di(i,r))return!1;for(const t of a)if(!vi(t,n))return!1}return!0}(t,this.geometries)}return!1}eachChild(){}outputDefined(){return!0}}class Ei{constructor(t=[],e=((t,e)=>t<e?-1:t>e?1:0)){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t)}push(t){this.data.push(t),this._up(this.length++)}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:i}=this,r=e[t];for(;t>0;){const s=t-1>>1,n=e[s];if(i(r,n)>=0)break;e[t]=n,t=s}e[t]=r}_down(t){const{data:e,compare:i}=this,r=this.length>>1,s=e[t];for(;t<r;){let r=1+(t<<1);const n=r+1;if(n<this.length&&i(e[n],e[r])<0&&(r=n),i(e[r],s)>=0)break;e[t]=e[r],t=r}e[t]=s}}function zi(t,e,i,r,s){Pi(t,e,i,r||t.length-1,s||ki)}function Pi(t,e,i,r,s){for(;r>i;){if(r-i>600){var n=r-i+1,a=e-i+1,o=Math.log(n),l=.5*Math.exp(2*o/3),c=.5*Math.sqrt(o*l*(n-l)/n)*(a-n/2<0?-1:1);Pi(t,e,Math.max(i,Math.floor(e-a*l/n+c)),Math.min(r,Math.floor(e+(n-a)*l/n+c)),s)}var h=t[e],u=i,p=r;for(Mi(t,i,e),s(t[r],h)>0&&Mi(t,i,r);u<p;){for(Mi(t,u,p),u++,p--;s(t[u],h)<0;)u++;for(;s(t[p],h)>0;)p--}0===s(t[i],h)?Mi(t,i,p):Mi(t,++p,r),p<=e&&(i=p+1),e<=p&&(r=p-1)}}function Mi(t,e,i){var r=t[e];t[e]=t[i],t[i]=r}function ki(t,e){return t<e?-1:t>e?1:0}function Di(t,e){if(t.length<=1)return[t];const i=[];let r,s;for(const e of t){const t=Ri(e);0!==t&&(e.area=Math.abs(t),void 0===s&&(s=t<0),s===t<0?(r&&i.push(r),r=[e]):r.push(e))}if(r&&i.push(r),e>1)for(let t=0;t<i.length;t++)i[t].length<=e||(zi(i[t],e,1,i[t].length-1,Li),i[t]=i[t].slice(0,e));return i}function Li(t,e){return e.area-t.area}function Ri(t){let e=0;for(let i,r,s=0,n=t.length,a=n-1;s<n;a=s++)i=t[s],r=t[a],e+=(r.x-i.x)*(i.y+r.y);return e}const Bi=1/298.257223563,Fi=Bi*(2-Bi),Oi=Math.PI/180;class Vi{constructor(t){const e=6378.137*Oi*1e3,i=Math.cos(t*Oi),r=1/(1-Fi*(1-i*i)),s=Math.sqrt(r);this.kx=e*s*i,this.ky=e*s*r*(1-Fi)}distance(t,e){const i=this.wrap(t[0]-e[0])*this.kx,r=(t[1]-e[1])*this.ky;return Math.sqrt(i*i+r*r)}pointOnLine(t,e){let i,r,s,n,a=1/0;for(let o=0;o<t.length-1;o++){let l=t[o][0],c=t[o][1],h=this.wrap(t[o+1][0]-l)*this.kx,u=(t[o+1][1]-c)*this.ky,p=0;0===h&&0===u||(p=(this.wrap(e[0]-l)*this.kx*h+(e[1]-c)*this.ky*u)/(h*h+u*u),p>1?(l=t[o+1][0],c=t[o+1][1]):p>0&&(l+=h/this.kx*p,c+=u/this.ky*p)),h=this.wrap(e[0]-l)*this.kx,u=(e[1]-c)*this.ky;const d=h*h+u*u;d<a&&(a=d,i=l,r=c,s=o,n=p)}return{point:[i,r],index:s,t:Math.max(0,Math.min(1,n))}}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}}function Ui(t,e){return e[0]-t[0]}function Ni(t){return t[1]-t[0]+1}function ji(t,e){return t[1]>=t[0]&&t[1]<e}function $i(t,e){if(t[0]>t[1])return[null,null];const i=Ni(t);if(e){if(2===i)return[t,null];const e=Math.floor(i/2);return[[t[0],t[0]+e],[t[0]+e,t[1]]]}if(1===i)return[t,null];const r=Math.floor(i/2)-1;return[[t[0],t[0]+r],[t[0]+r+1,t[1]]]}function qi(t,e){if(!ji(e,t.length))return[1/0,1/0,-1/0,-1/0];const i=[1/0,1/0,-1/0,-1/0];for(let r=e[0];r<=e[1];++r)pi(i,t[r]);return i}function Zi(t){const e=[1/0,1/0,-1/0,-1/0];for(const i of t)for(const t of i)pi(e,t);return e}function Gi(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0}function Wi(t,e,i){if(!Gi(t)||!Gi(e))return NaN;let r=0,s=0;return t[2]<e[0]&&(r=e[0]-t[2]),t[0]>e[2]&&(r=t[0]-e[2]),t[1]>e[3]&&(s=t[1]-e[3]),t[3]<e[1]&&(s=e[1]-t[3]),i.distance([0,0],[r,s])}function Hi(t,e,i){const r=i.pointOnLine(e,t);return i.distance(t,r.point)}function Xi(t,e,i,r,s){const n=Math.min(Hi(t,[i,r],s),Hi(e,[i,r],s)),a=Math.min(Hi(i,[t,e],s),Hi(r,[t,e],s));return Math.min(n,a)}function Ki(t,e,i,r,s){if(!ji(e,t.length)||!ji(r,i.length))return 1/0;let n=1/0;for(let a=e[0];a<e[1];++a){const e=t[a],o=t[a+1];for(let t=r[0];t<r[1];++t){const r=i[t],a=i[t+1];if(mi(e,o,r,a))return 0;n=Math.min(n,Xi(e,o,r,a,s))}}return n}function Yi(t,e,i,r,s){if(!ji(e,t.length)||!ji(r,i.length))return NaN;let n=1/0;for(let a=e[0];a<=e[1];++a)for(let e=r[0];e<=r[1];++e)if(n=Math.min(n,s.distance(t[a],i[e])),0===n)return n;return n}function Ji(t,e,i){if(gi(t,e,!0))return 0;let r=1/0;for(const s of e){const e=s[0],n=s[s.length-1];if(e!==n&&(r=Math.min(r,Hi(t,[n,e],i)),0===r))return r;const a=i.pointOnLine(s,t);if(r=Math.min(r,i.distance(t,a.point)),0===r)return r}return r}function Qi(t,e,i,r){if(!ji(e,t.length))return NaN;for(let r=e[0];r<=e[1];++r)if(gi(t[r],i,!0))return 0;let s=1/0;for(let n=e[0];n<e[1];++n){const e=t[n],a=t[n+1];for(const t of i)for(let i=0,n=t.length,o=n-1;i<n;o=i++){const n=t[o],l=t[i];if(mi(e,a,n,l))return 0;s=Math.min(s,Xi(e,a,n,l,r))}}return s}function tr(t,e){for(const i of t)for(const t of i)if(gi(t,e,!0))return!0;return!1}function er(t,e,i,r=1/0){const s=Zi(t),n=Zi(e);if(r!==1/0&&Wi(s,n,i)>=r)return r;if(di(s,n)){if(tr(t,e))return 0}else if(tr(e,t))return 0;let a=1/0;for(const r of t)for(let t=0,s=r.length,n=s-1;t<s;n=t++){const s=r[n],o=r[t];for(const t of e)for(let e=0,r=t.length,n=r-1;e<r;n=e++){const r=t[n],l=t[e];if(mi(s,o,r,l))return 0;a=Math.min(a,Xi(s,o,r,l,i))}}return a}function ir(t,e,i,r,s,n){if(!n)return;const a=Wi(qi(r,n),s,i);a<e&&t.push([a,n,[0,0]])}function rr(t,e,i,r,s,n,a){if(!n||!a)return;const o=Wi(qi(r,n),qi(s,a),i);o<e&&t.push([o,n,a])}function sr(t,e,i,r,s=1/0){let n=Math.min(r.distance(t[0],i[0][0]),s);if(0===n)return n;const a=new Ei([[0,[0,t.length-1],[0,0]]],Ui),o=Zi(i);for(;a.length>0;){const s=a.pop();if(s[0]>=n)continue;const l=s[1],c=e?50:100;if(Ni(l)<=c){if(!ji(l,t.length))return NaN;if(e){const e=Qi(t,l,i,r);if(isNaN(e)||0===e)return e;n=Math.min(n,e)}else for(let e=l[0];e<=l[1];++e){const s=Ji(t[e],i,r);if(n=Math.min(n,s),0===n)return 0}}else{const i=$i(l,e);ir(a,n,r,t,o,i[0]),ir(a,n,r,t,o,i[1])}}return n}function nr(t,e,i,r,s,n=1/0){let a=Math.min(n,s.distance(t[0],i[0]));if(0===a)return a;const o=new Ei([[0,[0,t.length-1],[0,i.length-1]]],Ui);for(;o.length>0;){const n=o.pop();if(n[0]>=a)continue;const l=n[1],c=n[2],h=e?50:100,u=r?50:100;if(Ni(l)<=h&&Ni(c)<=u){if(!ji(l,t.length)&&ji(c,i.length))return NaN;let n;if(e&&r)n=Ki(t,l,i,c,s),a=Math.min(a,n);else if(e&&!r){const e=t.slice(l[0],l[1]+1);for(let t=c[0];t<=c[1];++t)if(n=Hi(i[t],e,s),a=Math.min(a,n),0===a)return a}else if(!e&&r){const e=i.slice(c[0],c[1]+1);for(let i=l[0];i<=l[1];++i)if(n=Hi(t[i],e,s),a=Math.min(a,n),0===a)return a}else n=Yi(t,l,i,c,s),a=Math.min(a,n)}else{const n=$i(l,e),h=$i(c,r);rr(o,a,s,t,i,n[0],h[0]),rr(o,a,s,t,i,n[0],h[1]),rr(o,a,s,t,i,n[1],h[0]),rr(o,a,s,t,i,n[1],h[1])}}return a}function ar(t){return"MultiPolygon"===t.type?t.coordinates.map((t=>({type:"Polygon",coordinates:t}))):"MultiLineString"===t.type?t.coordinates.map((t=>({type:"LineString",coordinates:t}))):"MultiPoint"===t.type?t.coordinates.map((t=>({type:"Point",coordinates:t}))):[t]}class or{constructor(t,e){this.type=St,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if(ge(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new or(e,e.features.map((t=>ar(t.geometry))).flat());if("Feature"===e.type)return new or(e,ar(e.geometry));if("type"in e&&"coordinates"in e)return new or(e,ar(e))}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const i=t.geometry(),r=i.flat().map((e=>ui([e.x,e.y],t.canonical)));if(0===i.length)return NaN;const s=new Vi(r[0][1]);let n=1/0;for(const t of e){switch(t.type){case"Point":n=Math.min(n,nr(r,!1,[t.coordinates],!1,s,n));break;case"LineString":n=Math.min(n,nr(r,!1,t.coordinates,!0,s,n));break;case"Polygon":n=Math.min(n,sr(r,!1,t.coordinates,s,n))}if(0===n)return n}return n}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const i=t.geometry(),r=i.flat().map((e=>ui([e.x,e.y],t.canonical)));if(0===i.length)return NaN;const s=new Vi(r[0][1]);let n=1/0;for(const t of e){switch(t.type){case"Point":n=Math.min(n,nr(r,!0,[t.coordinates],!1,s,n));break;case"LineString":n=Math.min(n,nr(r,!0,t.coordinates,!0,s,n));break;case"Polygon":n=Math.min(n,sr(r,!0,t.coordinates,s,n))}if(0===n)return n}return n}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const i=t.geometry();if(0===i.length||0===i[0].length)return NaN;const r=Di(i,0).map((e=>e.map((e=>e.map((e=>ui([e.x,e.y],t.canonical))))))),s=new Vi(r[0][0][0][1]);let n=1/0;for(const t of e)for(const e of r){switch(t.type){case"Point":n=Math.min(n,sr([t.coordinates],!1,e,s,n));break;case"LineString":n=Math.min(n,sr(t.coordinates,!0,e,s,n));break;case"Polygon":n=Math.min(n,er(e,t.coordinates,s,n))}if(0===n)return n}return n}(t,this.geometries)}return NaN}eachChild(){}outputDefined(){return!0}}const lr={"==":Je,"!=":Qe,">":ei,"<":ti,">=":ri,"<=":ii,array:Te,at:Me,boolean:Te,case:Re,coalesce:He,collator:si,format:ai,image:oi,in:ke,"index-of":De,interpolate:Ge,"interpolate-hcl":Ge,"interpolate-lab":Ge,length:li,let:ze,literal:ve,match:Le,number:Te,"number-format":ni,object:Te,slice:Be,step:Oe,string:Te,"to-boolean":Ie,"to-color":Ie,"to-number":Ie,"to-string":Ie,var:Pe,within:Ci,distance:or};class cr{constructor(t,e,i,r){this.name=t,this.type=e,this._evaluate=i,this.args=r}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t)}outputDefined(){return!1}static parse(t,e){const i=t[0],r=cr.definitions[i];if(!r)return e.error(`Unknown expression "${i}". If you wanted a literal array, use ["literal", [...]].`,0);const s=Array.isArray(r)?r[0]:r.type,n=Array.isArray(r)?[[r[1],r[2]]]:r.overloads,a=n.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let o=null;for(const[r,n]of a){o=new Ee(e.registry,fr,e.path,null,e.scope);const a=[];let l=!1;for(let e=1;e<t.length;e++){const i=t[e],s=Array.isArray(r)?r[e-1]:r.type,n=o.parse(i,1+a.length,s);if(!n){l=!0;break}a.push(n)}if(!l)if(Array.isArray(r)&&r.length!==a.length)o.error(`Expected ${r.length} arguments, but found ${a.length} instead.`);else{for(let t=0;t<a.length;t++){const e=Array.isArray(r)?r[t]:r.type,i=a[t];o.concat(t+1).checkSubtype(e,i.type)}if(0===o.errors.length)return new cr(i,s,n,a)}}if(1===a.length)e.errors.push(...o.errors);else{const i=(a.length?a:n).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(Bt).join(", ")})`:`(${Bt(e.type)}...)`;var e})).join(" | "),r=[];for(let i=1;i<t.length;i++){const s=e.parse(t[i],1+r.length);if(!s)return null;r.push(Bt(s.type))}e.error(`Expected arguments of type ${i}, but found (${r.join(", ")}) instead.`)}return null}static register(t,e){cr.definitions=e;for(const i in e)t[i]=cr}}function hr(t,[e,i,r,s]){e=e.evaluate(t),i=i.evaluate(t),r=r.evaluate(t);const n=s?s.evaluate(t):1,a=_e(e,i,r,n);if(a)throw new be(a);return new le(e/255,i/255,r/255,n,!1)}function ur(t,e){return t in e}function pr(t,e){const i=e[t];return void 0===i?null:i}function dr(t){return{type:t}}function fr(t){if(t instanceof Pe)return fr(t.boundExpression);if(t instanceof cr&&"error"===t.name)return!1;if(t instanceof si)return!1;if(t instanceof Ci)return!1;if(t instanceof or)return!1;const e=t instanceof Ie||t instanceof Te;let i=!0;return t.eachChild((t=>{i=e?i&&fr(t):i&&t instanceof ve})),!!i&&mr(t)&&gr(t,["zoom","heatmap-density","line-progress","accumulated","is-supported-script"])}function mr(t){if(t instanceof cr){if("get"===t.name&&1===t.args.length)return!1;if("feature-state"===t.name)return!1;if("has"===t.name&&1===t.args.length)return!1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return!1;if(/^filter-/.test(t.name))return!1}if(t instanceof Ci)return!1;if(t instanceof or)return!1;let e=!0;return t.eachChild((t=>{e&&!mr(t)&&(e=!1)})),e}function _r(t){if(t instanceof cr&&"feature-state"===t.name)return!1;let e=!0;return t.eachChild((t=>{e&&!_r(t)&&(e=!1)})),e}function gr(t,e){if(t instanceof cr&&e.indexOf(t.name)>=0)return!1;let i=!0;return t.eachChild((t=>{i&&!gr(t,e)&&(i=!1)})),i}function yr(t){return{result:"success",value:t}}function xr(t){return{result:"error",value:t}}function vr(t){return"data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function br(t){return!!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function wr(t){return!!t.expression&&t.expression.interpolated}function Tr(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Sr(t){return"object"==typeof t&&null!==t&&!Array.isArray(t)}function Ir(t){return t}function Ar(t,e){const i="color"===e.type,r=t.stops&&"object"==typeof t.stops[0][0],s=r||!(r||void 0!==t.property),n=t.type||(wr(e)?"exponential":"interval");if(i||"padding"===e.type){const r=i?le.parse:pe.parse;(t=vt({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],r(t[1])]))),t.default=r(t.default?t.default:e.default)}if(t.colorSpace&&"rgb"!==(a=t.colorSpace)&&"hcl"!==a&&"lab"!==a)throw new Error(`Unknown color space: "${t.colorSpace}"`);var a;let o,l,c;if("exponential"===n)o=Pr;else if("interval"===n)o=zr;else if("categorical"===n){o=Er,l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];c=typeof t.stops[0][0]}else{if("identity"!==n)throw new Error(`Unknown function type "${n}"`);o=Mr}if(r){const i={},r=[];for(let e=0;e<t.stops.length;e++){const s=t.stops[e],n=s[0].zoom;void 0===i[n]&&(i[n]={zoom:n,type:t.type,property:t.property,default:t.default,stops:[]},r.push(n)),i[n].stops.push([s[0].value,s[1]])}const s=[];for(const t of r)s.push([i[t].zoom,Ar(i[t],e)]);const n={name:"linear"};return{kind:"composite",interpolationType:n,interpolationFactor:Ge.interpolationFactor.bind(void 0,n),zoomStops:s.map((t=>t[0])),evaluate:({zoom:i},r)=>Pr({stops:s,base:t.base},e,i).evaluate(i,r)}}if(s){const i="exponential"===n?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return{kind:"camera",interpolationType:i,interpolationFactor:Ge.interpolationFactor.bind(void 0,i),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:i})=>o(t,e,i,l,c)}}return{kind:"source",evaluate(i,r){const s=r&&r.properties?r.properties[t.property]:void 0;return void 0===s?Cr(t.default,e.default):o(t,e,s,l,c)}}}function Cr(t,e,i){return void 0!==t?t:void 0!==e?e:void 0!==i?i:void 0}function Er(t,e,i,r,s){return Cr(typeof i===s?r[i]:void 0,t.default,e.default)}function zr(t,e,i){if("number"!==Tr(i))return Cr(t.default,e.default);const r=t.stops.length;if(1===r)return t.stops[0][1];if(i<=t.stops[0][0])return t.stops[0][1];if(i>=t.stops[r-1][0])return t.stops[r-1][1];const s=Fe(t.stops.map((t=>t[0])),i);return t.stops[s][1]}function Pr(t,e,i){const r=void 0!==t.base?t.base:1;if("number"!==Tr(i))return Cr(t.default,e.default);const s=t.stops.length;if(1===s)return t.stops[0][1];if(i<=t.stops[0][0])return t.stops[0][1];if(i>=t.stops[s-1][0])return t.stops[s-1][1];const n=Fe(t.stops.map((t=>t[0])),i),a=function(t,e,i,r){const s=r-i,n=t-i;return 0===s?0:1===e?n/s:(Math.pow(e,n)-1)/(Math.pow(e,s)-1)}(i,r,t.stops[n][0],t.stops[n+1][0]),o=t.stops[n][1],l=t.stops[n+1][1],c=Ze[e.type]||Ir;return"function"==typeof o.evaluate?{evaluate(...e){const i=o.evaluate.apply(void 0,e),r=l.evaluate.apply(void 0,e);if(void 0!==i&&void 0!==r)return c(i,r,a,t.colorSpace)}}:c(o,l,a,t.colorSpace)}function Mr(t,e,i){switch(e.type){case"color":i=le.parse(i);break;case"formatted":i=ue.fromString(i.toString());break;case"resolvedImage":i=me.fromString(i.toString());break;case"padding":i=pe.parse(i);break;default:Tr(i)===e.type||"enum"===e.type&&e.values[i]||(i=void 0)}return Cr(i,t.default,e.default)}cr.register(lr,{error:[{kind:"error"},[It],(t,[e])=>{throw new be(e.evaluate(t))}],typeof:[It,[zt],(t,[e])=>Bt(ye(e.evaluate(t)))],"to-rgba":[Rt(St,4),[Ct],(t,[e])=>{const[i,r,s,n]=e.evaluate(t).rgb;return[255*i,255*r,255*s,n]}],rgb:[Ct,[St,St,St],hr],rgba:[Ct,[St,St,St,St],hr],has:{type:At,overloads:[[[It],(t,[e])=>ur(e.evaluate(t),t.properties())],[[It,Et],(t,[e,i])=>ur(e.evaluate(t),i.evaluate(t))]]},get:{type:zt,overloads:[[[It],(t,[e])=>pr(e.evaluate(t),t.properties())],[[It,Et],(t,[e,i])=>pr(e.evaluate(t),i.evaluate(t))]]},"feature-state":[zt,[It],(t,[e])=>pr(e.evaluate(t),t.featureState||{})],properties:[Et,[],t=>t.properties()],"geometry-type":[It,[],t=>t.geometryType()],id:[zt,[],t=>t.id()],zoom:[St,[],t=>t.globals.zoom],"heatmap-density":[St,[],t=>t.globals.heatmapDensity||0],"line-progress":[St,[],t=>t.globals.lineProgress||0],accumulated:[zt,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[St,dr(St),(t,e)=>{let i=0;for(const r of e)i+=r.evaluate(t);return i}],"*":[St,dr(St),(t,e)=>{let i=1;for(const r of e)i*=r.evaluate(t);return i}],"-":{type:St,overloads:[[[St,St],(t,[e,i])=>e.evaluate(t)-i.evaluate(t)],[[St],(t,[e])=>-e.evaluate(t)]]},"/":[St,[St,St],(t,[e,i])=>e.evaluate(t)/i.evaluate(t)],"%":[St,[St,St],(t,[e,i])=>e.evaluate(t)%i.evaluate(t)],ln2:[St,[],()=>Math.LN2],pi:[St,[],()=>Math.PI],e:[St,[],()=>Math.E],"^":[St,[St,St],(t,[e,i])=>Math.pow(e.evaluate(t),i.evaluate(t))],sqrt:[St,[St],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[St,[St],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[St,[St],(t,[e])=>Math.log(e.evaluate(t))],log2:[St,[St],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[St,[St],(t,[e])=>Math.sin(e.evaluate(t))],cos:[St,[St],(t,[e])=>Math.cos(e.evaluate(t))],tan:[St,[St],(t,[e])=>Math.tan(e.evaluate(t))],asin:[St,[St],(t,[e])=>Math.asin(e.evaluate(t))],acos:[St,[St],(t,[e])=>Math.acos(e.evaluate(t))],atan:[St,[St],(t,[e])=>Math.atan(e.evaluate(t))],min:[St,dr(St),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[St,dr(St),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[St,[St],(t,[e])=>Math.abs(e.evaluate(t))],round:[St,[St],(t,[e])=>{const i=e.evaluate(t);return i<0?-Math.round(-i):Math.round(i)}],floor:[St,[St],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[St,[St],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[At,[It,zt],(t,[e,i])=>t.properties()[e.value]===i.value],"filter-id-==":[At,[zt],(t,[e])=>t.id()===e.value],"filter-type-==":[At,[It],(t,[e])=>t.geometryType()===e.value],"filter-<":[At,[It,zt],(t,[e,i])=>{const r=t.properties()[e.value],s=i.value;return typeof r==typeof s&&r<s}],"filter-id-<":[At,[zt],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i<r}],"filter->":[At,[It,zt],(t,[e,i])=>{const r=t.properties()[e.value],s=i.value;return typeof r==typeof s&&r>s}],"filter-id->":[At,[zt],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i>r}],"filter-<=":[At,[It,zt],(t,[e,i])=>{const r=t.properties()[e.value],s=i.value;return typeof r==typeof s&&r<=s}],"filter-id-<=":[At,[zt],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i<=r}],"filter->=":[At,[It,zt],(t,[e,i])=>{const r=t.properties()[e.value],s=i.value;return typeof r==typeof s&&r>=s}],"filter-id->=":[At,[zt],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i>=r}],"filter-has":[At,[zt],(t,[e])=>e.value in t.properties()],"filter-has-id":[At,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[At,[Rt(It)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[At,[Rt(zt)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[At,[It,Rt(zt)],(t,[e,i])=>i.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[At,[It,Rt(zt)],(t,[e,i])=>function(t,e,i,r){for(;i<=r;){const s=i+r>>1;if(e[s]===t)return!0;e[s]>t?r=s-1:i=s+1}return!1}(t.properties()[e.value],i.value,0,i.value.length-1)],all:{type:At,overloads:[[[At,At],(t,[e,i])=>e.evaluate(t)&&i.evaluate(t)],[dr(At),(t,e)=>{for(const i of e)if(!i.evaluate(t))return!1;return!0}]]},any:{type:At,overloads:[[[At,At],(t,[e,i])=>e.evaluate(t)||i.evaluate(t)],[dr(At),(t,e)=>{for(const i of e)if(i.evaluate(t))return!0;return!1}]]},"!":[At,[At],(t,[e])=>!e.evaluate(t)],"is-supported-script":[At,[It],(t,[e])=>{const i=t.globals&&t.globals.isSupportedScript;return!i||i(e.evaluate(t))}],upcase:[It,[It],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[It,[It],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[It,dr(zt),(t,e)=>e.map((e=>xe(e.evaluate(t)))).join("")],"resolved-locale":[It,[Pt],(t,[e])=>e.evaluate(t).resolvedLocale()]});class kr{constructor(t,e){var i;this.expression=t,this._warningHistory={},this._evaluator=new Ce,this._defaultValue=e?"color"===(i=e).type&&Sr(i.default)?new le(0,0,0,0):"color"===i.type?le.parse(i.default)||null:"padding"===i.type?pe.parse(i.default)||null:"variableAnchorOffsetCollection"===i.type?fe.parse(i.default)||null:void 0===i.default?null:i.default:null,this._enumValues=e&&"enum"===e.type?e.values:null}evaluateWithoutErrorHandling(t,e,i,r,s,n){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=i,this._evaluator.canonical=r,this._evaluator.availableImages=s||null,this._evaluator.formattedSection=n,this.expression.evaluate(this._evaluator)}evaluate(t,e,i,r,s,n){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=i||null,this._evaluator.canonical=r,this._evaluator.availableImages=s||null,this._evaluator.formattedSection=n||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new be(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function Dr(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in lr}function Lr(t,e){const i=new Ee(lr,fr,[],e?function(t){const e={color:Ct,string:It,number:St,enum:It,boolean:At,formatted:Mt,padding:kt,resolvedImage:Dt,variableAnchorOffsetCollection:Lt};return"array"===t.type?Rt(e[t.value]||zt,t.length):e[t.type]}(e):void 0),r=i.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return r?yr(new kr(r,e)):xr(i.errors)}class Rr{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!_r(e.expression)}evaluateWithoutErrorHandling(t,e,i,r,s,n){return this._styleExpression.evaluateWithoutErrorHandling(t,e,i,r,s,n)}evaluate(t,e,i,r,s,n){return this._styleExpression.evaluate(t,e,i,r,s,n)}}class Br{constructor(t,e,i,r){this.kind=t,this.zoomStops=i,this._styleExpression=e,this.isStateDependent="camera"!==t&&!_r(e.expression),this.interpolationType=r}evaluateWithoutErrorHandling(t,e,i,r,s,n){return this._styleExpression.evaluateWithoutErrorHandling(t,e,i,r,s,n)}evaluate(t,e,i,r,s,n){return this._styleExpression.evaluate(t,e,i,r,s,n)}interpolationFactor(t,e,i){return this.interpolationType?Ge.interpolationFactor(this.interpolationType,t,e,i):0}}function Fr(t,e){const i=Lr(t,e);if("error"===i.result)return i;const r=i.value.expression,s=mr(r);if(!s&&!vr(e))return xr([new bt("","data expressions not supported")]);const n=gr(r,["zoom"]);if(!n&&!br(e))return xr([new bt("","zoom expressions not supported")]);const a=Vr(r);return a||n?a instanceof bt?xr([a]):a instanceof Ge&&!wr(e)?xr([new bt("",'"interpolate" expressions cannot be used with this property')]):yr(a?new Br(s?"camera":"composite",i.value,a.labels,a instanceof Ge?a.interpolation:void 0):new Rr(s?"constant":"source",i.value)):xr([new bt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class Or{constructor(t,e){this._parameters=t,this._specification=e,vt(this,Ar(this._parameters,this._specification))}static deserialize(t){return new Or(t._parameters,t._specification)}static serialize(t){return{_parameters:t._parameters,_specification:t._specification}}}function Vr(t){let e=null;if(t instanceof ze)e=Vr(t.result);else if(t instanceof He){for(const i of t.args)if(e=Vr(i),e)break}else(t instanceof Oe||t instanceof Ge)&&t.input instanceof cr&&"zoom"===t.input.name&&(e=t);return e instanceof bt||t.eachChild((t=>{const i=Vr(t);i instanceof bt?e=i:!e&&i?e=new bt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&i&&e!==i&&(e=new bt("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'))})),e}function Ur(t){if(!0===t||!1===t)return!0;if(!Array.isArray(t)||0===t.length)return!1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!Ur(e)&&"boolean"!=typeof e)return!1;return!0;default:return!0}}const Nr={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function jr(t){if(null==t)return{filter:()=>!0,needGeometry:!1};Ur(t)||(t=Zr(t));const e=Lr(t,Nr);if("error"===e.result)throw new Error(e.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return{filter:(t,i,r)=>e.value.evaluate(t,i,{},r),needGeometry:qr(t)}}function $r(t,e){return t<e?-1:t>e?1:0}function qr(t){if(!Array.isArray(t))return!1;if("within"===t[0]||"distance"===t[0])return!0;for(let e=1;e<t.length;e++)if(qr(t[e]))return!0;return!1}function Zr(t){if(!t)return!0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?Gr(t[1],t[2],"=="):"!="===e?Xr(Gr(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?Gr(t[1],t[2],e):"any"===e?(i=t.slice(1),["any"].concat(i.map(Zr))):"all"===e?["all"].concat(t.slice(1).map(Zr)):"none"===e?["all"].concat(t.slice(1).map(Zr).map(Xr)):"in"===e?Wr(t[1],t.slice(2)):"!in"===e?Xr(Wr(t[1],t.slice(2))):"has"===e?Hr(t[1]):"!has"!==e||Xr(Hr(t[1]));var i}function Gr(t,e,i){switch(t){case"$type":return[`filter-type-${i}`,e];case"$id":return[`filter-id-${i}`,e];default:return[`filter-${i}`,t,e]}}function Wr(t,e){if(0===e.length)return!1;switch(t){case"$type":return["filter-type-in",["literal",e]];case"$id":return["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort($r)]]:["filter-in-small",t,["literal",e]]}}function Hr(t){switch(t){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",t]}}function Xr(t){return["!",t]}function Kr(t){const e=t.value;return e?[new xt(t.key,e,"constants have been deprecated as of v8")]:[]}function Yr(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function Jr(t){if(Array.isArray(t))return t.map(Jr);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const i in t)e[i]=Jr(t[i]);return e}return Yr(t)}function Qr(t){const e=t.key,i=t.value,r=t.valueSpec||{},s=t.objectElementValidators||{},n=t.style,a=t.styleSpec,o=t.validateSpec;let l=[];const c=Tr(i);if("object"!==c)return[new xt(e,i,`object expected, ${c} found`)];for(const t in i){const c=t.split(".")[0],h=r[c]||r["*"];let u;if(s[c])u=s[c];else if(r[c])u=o;else if(s["*"])u=s["*"];else{if(!r["*"]){l.push(new xt(e,i[t],`unknown property "${t}"`));continue}u=o}l=l.concat(u({key:(e?`${e}.`:e)+t,value:i[t],valueSpec:h,style:n,styleSpec:a,object:i,objectKey:t,validateSpec:o},i))}for(const t in r)s[t]||r[t].required&&void 0===r[t].default&&void 0===i[t]&&l.push(new xt(e,i,`missing required property "${t}"`));return l}function ts(t){const e=t.value,i=t.valueSpec,r=t.style,s=t.styleSpec,n=t.key,a=t.arrayElementValidator||t.validateSpec;if("array"!==Tr(e))return[new xt(n,e,`array expected, ${Tr(e)} found`)];if(i.length&&e.length!==i.length)return[new xt(n,e,`array length ${i.length} expected, length ${e.length} found`)];if(i["min-length"]&&e.length<i["min-length"])return[new xt(n,e,`array length at least ${i["min-length"]} expected, length ${e.length} found`)];let o={type:i.value,values:i.values};s.$version<7&&(o.function=i.function),"object"===Tr(i.value)&&(o=i.value);let l=[];for(let i=0;i<e.length;i++)l=l.concat(a({array:e,arrayIndex:i,value:e[i],valueSpec:o,validateSpec:t.validateSpec,style:r,styleSpec:s,key:`${n}[${i}]`}));return l}function es(t){const e=t.key,i=t.value,r=t.valueSpec;let s=Tr(i);return"number"===s&&i!=i&&(s="NaN"),"number"!==s?[new xt(e,i,`number expected, ${s} found`)]:"minimum"in r&&i<r.minimum?[new xt(e,i,`${i} is less than the minimum value ${r.minimum}`)]:"maximum"in r&&i>r.maximum?[new xt(e,i,`${i} is greater than the maximum value ${r.maximum}`)]:[]}function is(t){const e=t.valueSpec,i=Yr(t.value.type);let r,s,n,a={};const o="categorical"!==i&&void 0===t.value.property,l=!o,c="array"===Tr(t.value.stops)&&"array"===Tr(t.value.stops[0])&&"object"===Tr(t.value.stops[0][0]),h=Qr({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===i)return[new xt(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const r=t.value;return e=e.concat(ts({key:t.key,value:r,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:u})),"array"===Tr(r)&&0===r.length&&e.push(new xt(t.key,r,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return"identity"===i&&o&&h.push(new xt(t.key,t.value,'missing required property "property"')),"identity"===i||t.value.stops||h.push(new xt(t.key,t.value,'missing required property "stops"')),"exponential"===i&&t.valueSpec.expression&&!wr(t.valueSpec)&&h.push(new xt(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!vr(t.valueSpec)?h.push(new xt(t.key,t.value,"property functions not supported")):o&&!br(t.valueSpec)&&h.push(new xt(t.key,t.value,"zoom functions not supported"))),"categorical"!==i&&!c||void 0!==t.value.property||h.push(new xt(t.key,t.value,'"property" property is required')),h;function u(t){let i=[];const r=t.value,o=t.key;if("array"!==Tr(r))return[new xt(o,r,`array expected, ${Tr(r)} found`)];if(2!==r.length)return[new xt(o,r,`array length 2 expected, length ${r.length} found`)];if(c){if("object"!==Tr(r[0]))return[new xt(o,r,`object expected, ${Tr(r[0])} found`)];if(void 0===r[0].zoom)return[new xt(o,r,"object stop key must have zoom")];if(void 0===r[0].value)return[new xt(o,r,"object stop key must have value")];if(n&&n>Yr(r[0].zoom))return[new xt(o,r[0].zoom,"stop zoom values must appear in ascending order")];Yr(r[0].zoom)!==n&&(n=Yr(r[0].zoom),s=void 0,a={}),i=i.concat(Qr({key:`${o}[0]`,value:r[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:es,value:p}}))}else i=i.concat(p({key:`${o}[0]`,value:r[0],valueSpec:{},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},r));return Dr(Jr(r[1]))?i.concat([new xt(`${o}[1]`,r[1],"expressions are not allowed in function stops.")]):i.concat(t.validateSpec({key:`${o}[1]`,value:r[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function p(t,n){const o=Tr(t.value),l=Yr(t.value),c=null!==t.value?t.value:n;if(r){if(o!==r)return[new xt(t.key,c,`${o} stop domain type must match previous stop domain type ${r}`)]}else r=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return[new xt(t.key,c,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==i){let r=`number expected, ${o} found`;return vr(e)&&void 0===i&&(r+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new xt(t.key,c,r)]}return"categorical"!==i||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==i&&"number"===o&&void 0!==s&&l<s?[new xt(t.key,c,"stop domain values must appear in ascending order")]:(s=l,"categorical"===i&&l in a?[new xt(t.key,c,"stop domain values must be unique")]:(a[l]=!0,[])):[new xt(t.key,c,`integer expected, found ${l}`)]}}function rs(t){const e=("property"===t.expressionContext?Fr:Lr)(Jr(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new xt(`${t.key}${e.key}`,t.value,e.message)));const i=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!i.outputDefined())return[new xt(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!_r(i))return[new xt(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!_r(i))return[new xt(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!gr(i,["zoom","feature-state"]))return[new xt(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!mr(i))return[new xt(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return[]}function ss(t){const e=t.key,i=t.value,r=t.valueSpec,s=[];return Array.isArray(r.values)?-1===r.values.indexOf(Yr(i))&&s.push(new xt(e,i,`expected one of [${r.values.join(", ")}], ${JSON.stringify(i)} found`)):-1===Object.keys(r.values).indexOf(Yr(i))&&s.push(new xt(e,i,`expected one of [${Object.keys(r.values).join(", ")}], ${JSON.stringify(i)} found`)),s}function ns(t){return Ur(Jr(t.value))?rs(vt({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):as(t)}function as(t){const e=t.value,i=t.key;if("array"!==Tr(e))return[new xt(i,e,`array expected, ${Tr(e)} found`)];const r=t.styleSpec;let s,n=[];if(e.length<1)return[new xt(i,e,"filter array must have at least 1 element")];switch(n=n.concat(ss({key:`${i}[0]`,value:e[0],valueSpec:r.filter_operator,style:t.style,styleSpec:t.styleSpec})),Yr(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===Yr(e[1])&&n.push(new xt(i,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&n.push(new xt(i,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(s=Tr(e[1]),"string"!==s&&n.push(new xt(`${i}[1]`,e[1],`string expected, ${s} found`)));for(let a=2;a<e.length;a++)s=Tr(e[a]),"$type"===Yr(e[1])?n=n.concat(ss({key:`${i}[${a}]`,value:e[a],valueSpec:r.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==s&&"number"!==s&&"boolean"!==s&&n.push(new xt(`${i}[${a}]`,e[a],`string, number, or boolean expected, ${s} found`));break;case"any":case"all":case"none":for(let r=1;r<e.length;r++)n=n.concat(as({key:`${i}[${r}]`,value:e[r],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":s=Tr(e[1]),2!==e.length?n.push(new xt(i,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==s&&n.push(new xt(`${i}[1]`,e[1],`string expected, ${s} found`))}return n}function os(t,e){const i=t.key,r=t.validateSpec,s=t.style,n=t.styleSpec,a=t.value,o=t.objectKey,l=n[`${e}_${t.layerType}`];if(!l)return[];const c=o.match(/^(.*)-transition$/);if("paint"===e&&c&&l[c[1]]&&l[c[1]].transition)return r({key:i,value:a,valueSpec:n.transition,style:s,styleSpec:n});const h=t.valueSpec||l[o];if(!h)return[new xt(i,a,`unknown property "${o}"`)];let u;if("string"===Tr(a)&&vr(h)&&!h.tokens&&(u=/^{([^}]+)}$/.exec(a)))return[new xt(i,a,`"${o}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(u[1])} }\`.`)];const p=[];return"symbol"===t.layerType&&("text-field"===o&&s&&!s.glyphs&&p.push(new xt(i,a,'use of "text-field" requires a style "glyphs" property')),"text-font"===o&&Sr(Jr(a))&&"identity"===Yr(a.type)&&p.push(new xt(i,a,'"text-font" does not support identity functions'))),p.concat(r({key:t.key,value:a,valueSpec:h,style:s,styleSpec:n,expressionContext:"property",propertyType:e,propertyKey:o}))}function ls(t){return os(t,"paint")}function cs(t){return os(t,"layout")}function hs(t){let e=[];const i=t.value,r=t.key,s=t.style,n=t.styleSpec;i.type||i.ref||e.push(new xt(r,i,'either "type" or "ref" is required'));let a=Yr(i.type);const o=Yr(i.ref);if(i.id){const n=Yr(i.id);for(let a=0;a<t.arrayIndex;a++){const t=s.layers[a];Yr(t.id)===n&&e.push(new xt(r,i.id,`duplicate layer id "${i.id}", previously used at line ${t.id.__line__}`))}}if("ref"in i){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in i&&e.push(new xt(r,i[t],`"${t}" is prohibited for ref layers`))})),s.layers.forEach((e=>{Yr(e.id)===o&&(t=e)})),t?t.ref?e.push(new xt(r,i.ref,"ref cannot reference another ref layer")):a=Yr(t.type):e.push(new xt(r,i.ref,`ref layer "${o}" not found`))}else if("background"!==a)if(i.source){const t=s.sources&&s.sources[i.source],n=t&&Yr(t.type);t?"vector"===n&&"raster"===a?e.push(new xt(r,i.source,`layer "${i.id}" requires a raster source`)):"raster-dem"!==n&&"hillshade"===a?e.push(new xt(r,i.source,`layer "${i.id}" requires a raster-dem source`)):"raster"===n&&"raster"!==a?e.push(new xt(r,i.source,`layer "${i.id}" requires a vector source`)):"vector"!==n||i["source-layer"]?"raster-dem"===n&&"hillshade"!==a?e.push(new xt(r,i.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==a||!i.paint||!i.paint["line-gradient"]||"geojson"===n&&t.lineMetrics||e.push(new xt(r,i,`layer "${i.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new xt(r,i,`layer "${i.id}" must specify a "source-layer"`)):e.push(new xt(r,i.source,`source "${i.source}" not found`))}else e.push(new xt(r,i,'missing required property "source"'));return e=e.concat(Qr({key:r,value:i,valueSpec:n.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${r}.type`,value:i.type,valueSpec:n.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:i,objectKey:"type"}),filter:ns,layout:t=>Qr({layer:i,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>cs(vt({layerType:a},t))}}),paint:t=>Qr({layer:i,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>ls(vt({layerType:a},t))}})}})),e}function us(t){const e=t.value,i=t.key,r=Tr(e);return"string"!==r?[new xt(i,e,`string expected, ${r} found`)]:[]}const ps={promoteId:function({key:t,value:e}){if("string"===Tr(e))return us({key:t,value:e});{const i=[];for(const r in e)i.push(...us({key:`${t}.${r}`,value:e[r]}));return i}}};function ds(t){const e=t.value,i=t.key,r=t.styleSpec,s=t.style,n=t.validateSpec;if(!e.type)return[new xt(i,e,'"type" is required')];const a=Yr(e.type);let o;switch(a){case"vector":case"raster":return o=Qr({key:i,value:e,valueSpec:r[`source_${a.replace("-","_")}`],style:t.style,styleSpec:r,objectElementValidators:ps,validateSpec:n}),o;case"raster-dem":return o=function(t){var e;const i=null!==(e=t.sourceName)&&void 0!==e?e:"",r=t.value,s=t.styleSpec,n=s.source_raster_dem,a=t.style;let o=[];const l=Tr(r);if(void 0===r)return o;if("object"!==l)return o.push(new xt("source_raster_dem",r,`object expected, ${l} found`)),o;const c="custom"===Yr(r.encoding),h=["redFactor","greenFactor","blueFactor","baseShift"],u=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in r)!c&&h.includes(e)?o.push(new xt(e,r[e],`In "${i}": "${e}" is only valid when "encoding" is set to "custom". ${u} encoding found`)):n[e]?o=o.concat(t.validateSpec({key:e,value:r[e],valueSpec:n[e],validateSpec:t.validateSpec,style:a,styleSpec:s})):o.push(new xt(e,r[e],`unknown property "${e}"`));return o}({sourceName:i,value:e,style:t.style,styleSpec:r,validateSpec:n}),o;case"geojson":if(o=Qr({key:i,value:e,valueSpec:r.source_geojson,style:s,styleSpec:r,validateSpec:n,objectElementValidators:ps}),e.cluster)for(const t in e.clusterProperties){const[r,s]=e.clusterProperties[t],a="string"==typeof r?[r,["accumulated"],["get",t]]:r;o.push(...rs({key:`${i}.${t}.map`,value:s,validateSpec:n,expressionContext:"cluster-map"})),o.push(...rs({key:`${i}.${t}.reduce`,value:a,validateSpec:n,expressionContext:"cluster-reduce"}))}return o;case"video":return Qr({key:i,value:e,valueSpec:r.source_video,style:s,validateSpec:n,styleSpec:r});case"image":return Qr({key:i,value:e,valueSpec:r.source_image,style:s,validateSpec:n,styleSpec:r});case"canvas":return[new xt(i,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return ss({key:`${i}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]},style:s,validateSpec:n,styleSpec:r})}}function fs(t){const e=t.value,i=t.styleSpec,r=i.light,s=t.style;let n=[];const a=Tr(e);if(void 0===e)return n;if("object"!==a)return n=n.concat([new xt("light",e,`object expected, ${a} found`)]),n;for(const a in e){const o=a.match(/^(.*)-transition$/);n=n.concat(o&&r[o[1]]&&r[o[1]].transition?t.validateSpec({key:a,value:e[a],valueSpec:i.transition,validateSpec:t.validateSpec,style:s,styleSpec:i}):r[a]?t.validateSpec({key:a,value:e[a],valueSpec:r[a],validateSpec:t.validateSpec,style:s,styleSpec:i}):[new xt(a,e[a],`unknown property "${a}"`)])}return n}function ms(t){const e=t.value,i=t.styleSpec,r=i.sky,s=t.style,n=Tr(e);if(void 0===e)return[];if("object"!==n)return[new xt("sky",e,`object expected, ${n} found`)];let a=[];for(const n in e)a=a.concat(r[n]?t.validateSpec({key:n,value:e[n],valueSpec:r[n],style:s,styleSpec:i}):[new xt(n,e[n],`unknown property "${n}"`)]);return a}function _s(t){const e=t.value,i=t.styleSpec,r=i.terrain,s=t.style;let n=[];const a=Tr(e);if(void 0===e)return n;if("object"!==a)return n=n.concat([new xt("terrain",e,`object expected, ${a} found`)]),n;for(const a in e)n=n.concat(r[a]?t.validateSpec({key:a,value:e[a],valueSpec:r[a],validateSpec:t.validateSpec,style:s,styleSpec:i}):[new xt(a,e[a],`unknown property "${a}"`)]);return n}function gs(t){let e=[];const i=t.value,r=t.key;if(Array.isArray(i)){const s=[],n=[];for(const a in i)i[a].id&&s.includes(i[a].id)&&e.push(new xt(r,i,`all the sprites' ids must be unique, but ${i[a].id} is duplicated`)),s.push(i[a].id),i[a].url&&n.includes(i[a].url)&&e.push(new xt(r,i,`all the sprites' URLs must be unique, but ${i[a].url} is duplicated`)),n.push(i[a].url),e=e.concat(Qr({key:`${r}[${a}]`,value:i[a],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return us({key:r,value:i})}const ys={"*":()=>[],array:ts,boolean:function(t){const e=t.value,i=t.key,r=Tr(e);return"boolean"!==r?[new xt(i,e,`boolean expected, ${r} found`)]:[]},number:es,color:function(t){const e=t.key,i=t.value,r=Tr(i);return"string"!==r?[new xt(e,i,`color expected, ${r} found`)]:le.parse(String(i))?[]:[new xt(e,i,`color expected, "${i}" found`)]},constants:Kr,enum:ss,filter:ns,function:is,layer:hs,object:Qr,source:ds,light:fs,sky:ms,terrain:_s,projection:function(t){const e=t.value,i=t.styleSpec,r=i.projection,s=t.style,n=Tr(e);if(void 0===e)return[];if("object"!==n)return[new xt("projection",e,`object expected, ${n} found`)];let a=[];for(const n in e)a=a.concat(r[n]?t.validateSpec({key:n,value:e[n],valueSpec:r[n],style:s,styleSpec:i}):[new xt(n,e[n],`unknown property "${n}"`)]);return a},string:us,formatted:function(t){return 0===us(t).length?[]:rs(t)},resolvedImage:function(t){return 0===us(t).length?[]:rs(t)},padding:function(t){const e=t.key,i=t.value;if("array"===Tr(i)){if(i.length<1||i.length>4)return[new xt(e,i,`padding requires 1 to 4 values; ${i.length} values found`)];const r={type:"number"};let s=[];for(let n=0;n<i.length;n++)s=s.concat(t.validateSpec({key:`${e}[${n}]`,value:i[n],validateSpec:t.validateSpec,valueSpec:r}));return s}return es({key:e,value:i,valueSpec:{}})},variableAnchorOffsetCollection:function(t){const e=t.key,i=t.value,r=Tr(i),s=t.styleSpec;if("array"!==r||i.length<1||i.length%2!=0)return[new xt(e,i,"variableAnchorOffsetCollection requires a non-empty array of even length")];let n=[];for(let r=0;r<i.length;r+=2)n=n.concat(ss({key:`${e}[${r}]`,value:i[r],valueSpec:s.layout_symbol["text-anchor"]})),n=n.concat(ts({key:`${e}[${r+1}]`,value:i[r+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:s}));return n},sprite:gs};function xs(t){const e=t.value,i=t.valueSpec,r=t.styleSpec;return t.validateSpec=xs,i.expression&&Sr(Yr(e))?is(t):i.expression&&Dr(Jr(e))?rs(t):i.type&&ys[i.type]?ys[i.type](t):Qr(vt({},t,{valueSpec:i.type?r[i.type]:i}))}function vs(t){const e=t.value,i=t.key,r=us(t);return r.length||(-1===e.indexOf("{fontstack}")&&r.push(new xt(i,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&r.push(new xt(i,e,'"glyphs" url must include a "{range}" token'))),r}function bs(t,e=at){let i=[];return i=i.concat(xs({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:xs,objectElementValidators:{glyphs:vs,"*":()=>[]}})),t.constants&&(i=i.concat(Kr({key:"constants",value:t.constants,style:t,styleSpec:e,validateSpec:xs}))),Ts(i)}function ws(t){return function(e){return t({...e,validateSpec:xs})}}function Ts(t){return[].concat(t).sort(((t,e)=>t.line-e.line))}function Ss(t){return function(...e){return Ts(t.apply(this,e))}}bs.source=Ss(ws(ds)),bs.sprite=Ss(ws(gs)),bs.glyphs=Ss(ws(vs)),bs.light=Ss(ws(fs)),bs.sky=Ss(ws(ms)),bs.terrain=Ss(ws(_s)),bs.layer=Ss(ws(hs)),bs.filter=Ss(ws(ns)),bs.paintProperty=Ss(ws(ls)),bs.layoutProperty=Ss(ws(cs));const Is=bs,As=Is.light,Cs=Is.sky,Es=Is.paintProperty,zs=Is.layoutProperty;function Ps(t,e){let i=!1;if(e&&e.length)for(const r of e)t.fire(new st(new Error(r.message))),i=!0;return i}class Ms{constructor(t,e,i){const r=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const s=new Int32Array(this.arrayBuffer);t=s[0],this.d=(e=s[1])+2*(i=s[2]);for(let t=0;t<this.d*this.d;t++){const e=s[3+t],i=s[3+t+1];r.push(e===i?null:s.subarray(e,i))}const n=s[3+r.length+1];this.keys=s.subarray(s[3+r.length],n),this.bboxes=s.subarray(n),this.insert=this._insertReadonly}else{this.d=e+2*i;for(let t=0;t<this.d*this.d;t++)r.push([]);this.keys=[],this.bboxes=[]}this.n=e,this.extent=t,this.padding=i,this.scale=e/t,this.uid=0;const s=i/e*t;this.min=-s,this.max=t+s}insert(t,e,i,r,s){this._forEachCell(e,i,r,s,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(s)}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,i,r,s,n){this.cells[s].push(n)}query(t,e,i,r,s){const n=this.min,a=this.max;if(t<=n&&e<=n&&a<=i&&a<=r&&!s)return Array.prototype.slice.call(this.keys);{const n=[];return this._forEachCell(t,e,i,r,this._queryCell,n,{},s),n}}_queryCell(t,e,i,r,s,n,a,o){const l=this.cells[s];if(null!==l){const s=this.keys,c=this.bboxes;for(let h=0;h<l.length;h++){const u=l[h];if(void 0===a[u]){const l=4*u;(o?o(c[l+0],c[l+1],c[l+2],c[l+3]):t<=c[l+2]&&e<=c[l+3]&&i>=c[l+0]&&r>=c[l+1])?(a[u]=!0,n.push(s[u])):a[u]=!1}}}}_forEachCell(t,e,i,r,s,n,a,o){const l=this._convertToCellCoord(t),c=this._convertToCellCoord(e),h=this._convertToCellCoord(i),u=this._convertToCellCoord(r);for(let p=l;p<=h;p++)for(let l=c;l<=u;l++){const c=this.d*l+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&s.call(this,t,e,i,r,c,n,a,o))return}}_convertFromCellCoord(t){return(t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let i=0;for(let t=0;t<this.cells.length;t++)i+=this.cells[t].length;const r=new Int32Array(e+i+this.keys.length+this.bboxes.length);r[0]=this.extent,r[1]=this.n,r[2]=this.padding;let s=e;for(let e=0;e<t.length;e++){const i=t[e];r[3+e]=s,r.set(i,s),s+=i.length}return r[3+t.length]=s,r.set(this.keys,s),s+=this.keys.length,r[3+t.length+1]=s,r.set(this.bboxes,s),s+=this.bboxes.length,r.buffer}static serialize(t,e){const i=t.toArrayBuffer();return e&&e.push(i),{buffer:i}}static deserialize(t){return new Ms(t.buffer)}}const ks={};function Ds(t,e,i={}){if(ks[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),ks[t]={klass:e,omit:i.omit||[],shallow:i.shallow||[]}}Ds("Object",Object),Ds("TransferableGridIndex",Ms),Ds("Color",le),Ds("Error",Error),Ds("AJAXError",j),Ds("ResolvedImage",me),Ds("StylePropertyFunction",Or),Ds("StyleExpression",kr,{omit:["_evaluator"]}),Ds("ZoomDependentExpression",Br),Ds("ZoomConstantExpression",Rr),Ds("CompoundExpression",cr,{omit:["_evaluate"]});for(const t in lr)lr[t]._classRegistryKey||Ds(`Expression_${t}`,lr[t]);function Ls(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function Rs(t){return t.$name||t.constructor._classRegistryKey}function Bs(t){return!function(t){if(null===t||"object"!=typeof t)return!1;const e=Rs(t);return!(!e||"Object"===e)}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||Ls(t)||M(t)||ArrayBuffer.isView(t)||t instanceof ImageData)}function Fs(t,e){if(Bs(t))return(Ls(t)||M(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const i=[];for(const r of t)i.push(Fs(r,e));return i}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const i=Rs(t);if(!i)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!ks[i])throw new Error(`${i} is not registered.`);const{klass:r}=ks[i],s=r.serialize?r.serialize(t,e):{};if(r.serialize){if(e&&s===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else{for(const r in t){if(!t.hasOwnProperty(r))continue;if(ks[i].omit.indexOf(r)>=0)continue;const n=t[r];s[r]=ks[i].shallow.indexOf(r)>=0?n:Fs(n,e)}t instanceof Error&&(s.message=t.message)}if(s.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==i&&(s.$name=i),s}function Os(t){if(Bs(t))return t;if(Array.isArray(t))return t.map(Os);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=Rs(t)||"Object";if(!ks[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:i}=ks[e];if(!i)throw new Error(`can't deserialize unregistered class ${e}`);if(i.deserialize)return i.deserialize(t);const r=Object.create(i.prototype);for(const i of Object.keys(t)){if("$name"===i)continue;const s=t[i];r[i]=ks[e].shallow.indexOf(i)>=0?s:Os(s)}return r}class Vs{constructor(){this.first=!0}update(t,e){const i=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=i,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=i,!0):(this.lastFloorZoom>i?(this.lastIntegerZoom=i+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<i&&(this.lastIntegerZoom=i,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=i,!0))}}const Us={"Latin-1 Supplement":t=>t>=128&&t<=255,"Hangul Jamo":t=>t>=4352&&t<=4607,Khmer:t=>t>=6016&&t<=6143,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Katakana:t=>t>=12448&&t<=12543,Kanbun:t=>t>=12688&&t<=12703,"CJK Strokes":t=>t>=12736&&t<=12783,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"Private Use Area":t=>t>=57344&&t<=63743,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519};function Ns(t){for(const e of t)if(qs(e.charCodeAt(0)))return!0;return!1}function js(t){const e=t.map((t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source}catch(t){return null}})).filter((t=>t));return new RegExp(e.join("|"),"u")}js(["Arab","Dupl","Mong","Ougr","Syrc"]);const $s=js(["Bopo","Hani","Hira","Kana","Kits","Nshu","Tang","Yiii"]);function qs(t){return!(746!==t&&747!==t&&(t<4352||!(Us["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||Us["CJK Compatibility"](t)||Us["CJK Strokes"](t)||!(!Us["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||Us["Enclosed CJK Letters and Months"](t)||Us["Ideographic Description Characters"](t)||Us.Kanbun(t)||Us.Katakana(t)&&12540!==t||!(!Us["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!Us["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||Us["Vertical Forms"](t)||Us["Yijing Hexagram Symbols"](t)||/\p{sc=Cans}/u.test(String.fromCodePoint(t))||/\p{sc=Hang}/u.test(String.fromCodePoint(t))||$s.test(String.fromCodePoint(t)))))}const Zs=js(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function Gs(t){return Zs.test(String.fromCodePoint(t))}function Ws(t,e){return!(!e&&Gs(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||Us.Khmer(t))}function Hs(t){for(const e of t)if(Gs(e.charCodeAt(0)))return!0;return!1}const Xs=new class{constructor(){this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL}getState(){return{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(t){this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getPluginURL(){return this.pluginURL}getRTLTextPluginStatus(){return this.pluginStatus}};class Ks{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.zoomHistory=e.zoomHistory,this.transition=e.transition):(this.now=0,this.fadeDuration=0,this.zoomHistory=new Vs,this.transition={})}isSupportedScript(t){return function(t,e){for(const i of t)if(!Ws(i.charCodeAt(0),e))return!1;return!0}(t,"loaded"===Xs.getRTLTextPluginStatus())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),i=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*i}:{fromScale:.5,toScale:1,t:1-(1-i)*e}}}class Ys{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(Sr(t))return new Or(t,e);if(Dr(t)){const i=Fr(t,e);if("error"===i.result)throw new Error(i.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return i.value}{let i=t;return"color"===e.type&&"string"==typeof t?i=le.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)&&(i=fe.parse(t)):i=pe.parse(t),{kind:"constant",evaluate:()=>i}}}(void 0===e?t.specification.default:e,t.specification)}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,i){return this.property.possiblyEvaluate(this,t,e,i)}}class Js{constructor(t){this.property=t,this.value=new Ys(t,void 0)}transitioned(t,e){return new tn(this.property,this.value,e,y({},t.transition,this.transition),t.now)}untransitioned(){return new tn(this.property,this.value,null,{},0)}}class Qs{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues)}getValue(t){return I(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Js(this._values[t].property)),this._values[t].value=new Ys(this._values[t].property,null===e?void 0:I(e))}getTransition(t){return I(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Js(this._values[t].property)),this._values[t].transition=I(e)||void 0}serialize(){const t={};for(const e of Object.keys(this._values)){const i=this.getValue(e);void 0!==i&&(t[e]=i);const r=this.getTransition(e);void 0!==r&&(t[`${e}-transition`]=r)}return t}transitioned(t,e){const i=new en(this._properties);for(const r of Object.keys(this._values))i._values[r]=this._values[r].transitioned(t,e._values[r]);return i}untransitioned(){const t=new en(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class tn{constructor(t,e,i,r,s){this.property=t,this.value=e,this.begin=s+r.delay||0,this.end=this.begin+r.duration||0,t.specification.transition&&(r.delay||r.duration)&&(this.prior=i)}possiblyEvaluate(t,e,i){const r=t.now||0,s=this.value.possiblyEvaluate(t,e,i),n=this.prior;if(n){if(r>this.end)return this.prior=null,s;if(this.value.isDataDriven())return this.prior=null,s;if(r<this.begin)return n.possiblyEvaluate(t,e,i);{const a=(r-this.begin)/(this.end-this.begin);return this.property.interpolate(n.possiblyEvaluate(t,e,i),s,function(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,i=e*t;return 4*(t<.5?i:3*(t-e)+i-.75)}(a))}}return s}}class en{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues)}possiblyEvaluate(t,e,i){const r=new nn(this._properties);for(const s of Object.keys(this._values))r._values[s]=this._values[s].possiblyEvaluate(t,e,i);return r}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return!0;return!1}}class rn{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues)}hasValue(t){return void 0!==this._values[t].value}getValue(t){return I(this._values[t].value)}setValue(t,e){this._values[t]=new Ys(this._values[t].property,null===e?void 0:I(e))}serialize(){const t={};for(const e of Object.keys(this._values)){const i=this.getValue(e);void 0!==i&&(t[e]=i)}return t}possiblyEvaluate(t,e,i){const r=new nn(this._properties);for(const s of Object.keys(this._values))r._values[s]=this._values[s].possiblyEvaluate(t,e,i);return r}}class sn{constructor(t,e,i){this.property=t,this.value=e,this.parameters=i}isConstant(){return"constant"===this.value.kind}constantOr(t){return"constant"===this.value.kind?this.value.value:t}evaluate(t,e,i,r){return this.property.evaluate(this.value,this.parameters,t,e,i,r)}}class nn{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues)}get(t){return this._values[t]}}class an{constructor(t){this.specification=t}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,i){const r=Ze[this.specification.type];return r?r(t,e,i):t}}class on{constructor(t,e){this.specification=t,this.overrides=e}possiblyEvaluate(t,e,i,r){return new sn(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},i,r)}:t.expression,e)}interpolate(t,e,i){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new sn(this,{kind:"constant",value:void 0},t.parameters);const r=Ze[this.specification.type];if(r){const s=r(t.value.value,e.value.value,i);return new sn(this,{kind:"constant",value:s},t.parameters)}return t}evaluate(t,e,i,r,s,n){return"constant"===t.kind?t.value:t.evaluate(e,i,r,s,n)}}class ln extends on{possiblyEvaluate(t,e,i,r){if(void 0===t.value)return new sn(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const s=t.expression.evaluate(e,null,{},i,r),n="resolvedImage"===t.property.specification.type&&"string"!=typeof s?s.name:s,a=this._calculate(n,n,n,e);return new sn(this,{kind:"constant",value:a},e)}if("camera"===t.expression.kind){const i=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new sn(this,{kind:"constant",value:i},e)}return new sn(this,t.expression,e)}evaluate(t,e,i,r,s,n){if("source"===t.kind){const a=t.evaluate(e,i,r,s,n);return this._calculate(a,a,a,e)}return"composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},i,r),t.evaluate({zoom:Math.floor(e.zoom)},i,r),t.evaluate({zoom:Math.floor(e.zoom)+1},i,r),e):t.value}_calculate(t,e,i,r){return r.zoom>r.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:i,to:e}}interpolate(t){return t}}class cn{constructor(t){this.specification=t}possiblyEvaluate(t,e,i,r){if(void 0!==t.value){if("constant"===t.expression.kind){const s=t.expression.evaluate(e,null,{},i,r);return this._calculate(s,s,s,e)}return this._calculate(t.expression.evaluate(new Ks(Math.floor(e.zoom-1),e)),t.expression.evaluate(new Ks(Math.floor(e.zoom),e)),t.expression.evaluate(new Ks(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,i,r){return r.zoom>r.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:i,to:e}}interpolate(t){return t}}class hn{constructor(t){this.specification=t}possiblyEvaluate(t,e,i,r){return!!t.expression.evaluate(e,null,{},i,r)}interpolate(){return!1}}class un{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const i=t[e];i.specification.overridable&&this.overridableProperties.push(e);const r=this.defaultPropertyValues[e]=new Ys(i,void 0),s=this.defaultTransitionablePropertyValues[e]=new Js(i);this.defaultTransitioningPropertyValues[e]=s.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=r.possiblyEvaluate({})}}}Ds("DataDrivenProperty",on),Ds("DataConstantProperty",an),Ds("CrossFadedDataDrivenProperty",ln),Ds("CrossFadedProperty",cn),Ds("ColorRampProperty",hn);const pn="-transition";class dn extends nt{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),e.layout&&(this._unevaluatedLayout=new rn(e.layout)),e.paint)){this._transitionablePaint=new Qs(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new nn(e.paint)}}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return"visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e,i={}){null!=e&&this._validate(zs,`layers.${this.id}.layout.${t}`,t,e,i)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e)}getPaintProperty(t){return t.endsWith(pn)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,i={}){if(null!=e&&this._validate(Es,`layers.${this.id}.paint.${t}`,t,e,i))return!1;if(t.endsWith(pn))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const i=this._transitionablePaint._values[t],r="cross-faded-data-driven"===i.property.specification["property-type"],s=i.value.isDataDriven(),n=i.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const a=this._transitionablePaint._values[t].value;return a.isDataDriven()||s||r||this._handleOverridablePaintPropertyUpdate(t,n,a)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,i){return!1}isHidden(t){return!!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint)}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e)}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),T(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,i,r,s={}){return(!s||!1!==s.validate)&&Ps(this,t.call(Is,{key:e,layerType:this.type,objectKey:i,value:r,styleSpec:at,style:{glyphs:!0,sprite:!0}}))}is3D(){return!1}isTileClipped(){return!1}hasOffscreenPass(){return!1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof sn&&vr(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return!0}return!1}}const fn={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class mn{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8}}class _n{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0)}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews())}clear(){this.length=0}resize(t){this.reserve(t),this.length=t}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e)}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function gn(t,e=1){let i=0,r=0;return{members:t.map((t=>{const s=fn[t.type].BYTES_PER_ELEMENT,n=i=yn(i,Math.max(e,s)),a=t.components||1;return r=Math.max(r,s),i+=s*a,{name:t.name,type:t.type,components:a,offset:n}})),size:yn(i,Math.max(r,e)),alignment:e}}function yn(t,e){return Math.ceil(t/e)*e}class xn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.int16[r+0]=e,this.int16[r+1]=i,t}}xn.prototype.bytesPerElement=4,Ds("StructArrayLayout2i4",xn);class vn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const s=3*t;return this.int16[s+0]=e,this.int16[s+1]=i,this.int16[s+2]=r,t}}vn.prototype.bytesPerElement=6,Ds("StructArrayLayout3i6",vn);class bn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,i,r)}emplace(t,e,i,r,s){const n=4*t;return this.int16[n+0]=e,this.int16[n+1]=i,this.int16[n+2]=r,this.int16[n+3]=s,t}}bn.prototype.bytesPerElement=8,Ds("StructArrayLayout4i8",bn);class wn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,s,n){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,i,r,s,n)}emplace(t,e,i,r,s,n,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=i,this.int16[o+2]=r,this.int16[o+3]=s,this.int16[o+4]=n,this.int16[o+5]=a,t}}wn.prototype.bytesPerElement=12,Ds("StructArrayLayout2i4i12",wn);class Tn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,s,n){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,i,r,s,n)}emplace(t,e,i,r,s,n,a){const o=4*t,l=8*t;return this.int16[o+0]=e,this.int16[o+1]=i,this.uint8[l+4]=r,this.uint8[l+5]=s,this.uint8[l+6]=n,this.uint8[l+7]=a,t}}Tn.prototype.bytesPerElement=8,Ds("StructArrayLayout2i4ub8",Tn);class Sn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.float32[r+0]=e,this.float32[r+1]=i,t}}Sn.prototype.bytesPerElement=8,Ds("StructArrayLayout2f8",Sn);class In extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,s,n,a,o,l,c){const h=this.length;return this.resize(h+1),this.emplace(h,t,e,i,r,s,n,a,o,l,c)}emplace(t,e,i,r,s,n,a,o,l,c,h){const u=10*t;return this.uint16[u+0]=e,this.uint16[u+1]=i,this.uint16[u+2]=r,this.uint16[u+3]=s,this.uint16[u+4]=n,this.uint16[u+5]=a,this.uint16[u+6]=o,this.uint16[u+7]=l,this.uint16[u+8]=c,this.uint16[u+9]=h,t}}In.prototype.bytesPerElement=20,Ds("StructArrayLayout10ui20",In);class An extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,s,n,a,o,l,c,h,u){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,i,r,s,n,a,o,l,c,h,u)}emplace(t,e,i,r,s,n,a,o,l,c,h,u,p){const d=12*t;return this.int16[d+0]=e,this.int16[d+1]=i,this.int16[d+2]=r,this.int16[d+3]=s,this.uint16[d+4]=n,this.uint16[d+5]=a,this.uint16[d+6]=o,this.uint16[d+7]=l,this.int16[d+8]=c,this.int16[d+9]=h,this.int16[d+10]=u,this.int16[d+11]=p,t}}An.prototype.bytesPerElement=24,Ds("StructArrayLayout4i4ui4i24",An);class Cn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const s=3*t;return this.float32[s+0]=e,this.float32[s+1]=i,this.float32[s+2]=r,t}}Cn.prototype.bytesPerElement=12,Ds("StructArrayLayout3f12",Cn);class En extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}En.prototype.bytesPerElement=4,Ds("StructArrayLayout1ul4",En);class zn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,s,n,a,o,l){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,i,r,s,n,a,o,l)}emplace(t,e,i,r,s,n,a,o,l,c){const h=10*t,u=5*t;return this.int16[h+0]=e,this.int16[h+1]=i,this.int16[h+2]=r,this.int16[h+3]=s,this.int16[h+4]=n,this.int16[h+5]=a,this.uint32[u+3]=o,this.uint16[h+8]=l,this.uint16[h+9]=c,t}}zn.prototype.bytesPerElement=20,Ds("StructArrayLayout6i1ul2ui20",zn);class Pn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,s,n){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,i,r,s,n)}emplace(t,e,i,r,s,n,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=i,this.int16[o+2]=r,this.int16[o+3]=s,this.int16[o+4]=n,this.int16[o+5]=a,t}}Pn.prototype.bytesPerElement=12,Ds("StructArrayLayout2i2i2i12",Pn);class Mn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,s){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,i,r,s)}emplace(t,e,i,r,s,n){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=i,this.float32[a+2]=r,this.int16[o+6]=s,this.int16[o+7]=n,t}}Mn.prototype.bytesPerElement=16,Ds("StructArrayLayout2f1f2i16",Mn);class kn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,s,n){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,i,r,s,n)}emplace(t,e,i,r,s,n,a){const o=16*t,l=4*t,c=8*t;return this.uint8[o+0]=e,this.uint8[o+1]=i,this.float32[l+1]=r,this.float32[l+2]=s,this.int16[c+6]=n,this.int16[c+7]=a,t}}kn.prototype.bytesPerElement=16,Ds("StructArrayLayout2ub2f2i16",kn);class Dn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const s=3*t;return this.uint16[s+0]=e,this.uint16[s+1]=i,this.uint16[s+2]=r,t}}Dn.prototype.bytesPerElement=6,Ds("StructArrayLayout3ui6",Dn);class Ln extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r,s,n,a,o,l,c,h,u,p,d,f,m,_){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,i,r,s,n,a,o,l,c,h,u,p,d,f,m,_)}emplace(t,e,i,r,s,n,a,o,l,c,h,u,p,d,f,m,_,g){const y=24*t,x=12*t,v=48*t;return this.int16[y+0]=e,this.int16[y+1]=i,this.uint16[y+2]=r,this.uint16[y+3]=s,this.uint32[x+2]=n,this.uint32[x+3]=a,this.uint32[x+4]=o,this.uint16[y+10]=l,this.uint16[y+11]=c,this.uint16[y+12]=h,this.float32[x+7]=u,this.float32[x+8]=p,this.uint8[v+36]=d,this.uint8[v+37]=f,this.uint8[v+38]=m,this.uint32[x+10]=_,this.int16[y+22]=g,t}}Ln.prototype.bytesPerElement=48,Ds("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",Ln);class Rn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r,s,n,a,o,l,c,h,u,p,d,f,m,_,g,y,x,v,b,w,T,S,I,A,C){const E=this.length;return this.resize(E+1),this.emplace(E,t,e,i,r,s,n,a,o,l,c,h,u,p,d,f,m,_,g,y,x,v,b,w,T,S,I,A,C)}emplace(t,e,i,r,s,n,a,o,l,c,h,u,p,d,f,m,_,g,y,x,v,b,w,T,S,I,A,C,E){const z=32*t,P=16*t;return this.int16[z+0]=e,this.int16[z+1]=i,this.int16[z+2]=r,this.int16[z+3]=s,this.int16[z+4]=n,this.int16[z+5]=a,this.int16[z+6]=o,this.int16[z+7]=l,this.uint16[z+8]=c,this.uint16[z+9]=h,this.uint16[z+10]=u,this.uint16[z+11]=p,this.uint16[z+12]=d,this.uint16[z+13]=f,this.uint16[z+14]=m,this.uint16[z+15]=_,this.uint16[z+16]=g,this.uint16[z+17]=y,this.uint16[z+18]=x,this.uint16[z+19]=v,this.uint16[z+20]=b,this.uint16[z+21]=w,this.uint16[z+22]=T,this.uint32[P+12]=S,this.float32[P+13]=I,this.float32[P+14]=A,this.uint16[z+30]=C,this.uint16[z+31]=E,t}}Rn.prototype.bytesPerElement=64,Ds("StructArrayLayout8i15ui1ul2f2ui64",Rn);class Bn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Bn.prototype.bytesPerElement=4,Ds("StructArrayLayout1f4",Bn);class Fn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const s=3*t;return this.uint16[6*t+0]=e,this.float32[s+1]=i,this.float32[s+2]=r,t}}Fn.prototype.bytesPerElement=12,Ds("StructArrayLayout1ui2f12",Fn);class On extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const s=4*t;return this.uint32[2*t+0]=e,this.uint16[s+2]=i,this.uint16[s+3]=r,t}}On.prototype.bytesPerElement=8,Ds("StructArrayLayout1ul2ui8",On);class Vn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.uint16[r+0]=e,this.uint16[r+1]=i,t}}Vn.prototype.bytesPerElement=4,Ds("StructArrayLayout2ui4",Vn);class Un extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Un.prototype.bytesPerElement=2,Ds("StructArrayLayout1ui2",Un);class Nn extends _n{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,i,r)}emplace(t,e,i,r,s){const n=4*t;return this.float32[n+0]=e,this.float32[n+1]=i,this.float32[n+2]=r,this.float32[n+3]=s,t}}Nn.prototype.bytesPerElement=16,Ds("StructArrayLayout4f16",Nn);class jn extends mn{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new a(this.anchorPointX,this.anchorPointY)}}jn.prototype.size=20;class $n extends zn{get(t){return new jn(this,t)}}Ds("CollisionBoxArray",$n);class qn extends mn{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}qn.prototype.size=48;class Zn extends Ln{get(t){return new qn(this,t)}}Ds("PlacedSymbolArray",Zn);class Gn extends mn{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}Gn.prototype.size=64;class Wn extends Rn{get(t){return new Gn(this,t)}}Ds("SymbolInstanceArray",Wn);class Hn extends Bn{getoffsetX(t){return this.float32[1*t+0]}}Ds("GlyphOffsetArray",Hn);class Xn extends vn{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}Ds("SymbolLineVertexArray",Xn);class Kn extends mn{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}Kn.prototype.size=12;class Yn extends Fn{get(t){return new Kn(this,t)}}Ds("TextAnchorOffsetArray",Yn);class Jn extends mn{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}Jn.prototype.size=8;class Qn extends On{get(t){return new Jn(this,t)}}Ds("FeatureIndexArray",Qn);class ta extends xn{}class ea extends vn{}class ia extends bn{}class ra extends xn{}class sa extends xn{}class na extends wn{}class aa extends Tn{}class oa extends Sn{}class la extends In{}class ca extends An{}class ha extends Cn{}class ua extends En{}class pa extends Pn{}class da extends Mn{}class fa extends kn{}class ma extends Dn{}class _a extends Dn{}class ga extends Vn{}class ya extends Un{}const xa=gn([{name:"a_pos",components:2,type:"Int16"}],4),{members:va}=xa;class ba{constructor(t=[]){this.segments=t}prepareSegment(t,e,i,r){let s=this.segments[this.segments.length-1];return t>ba.MAX_VERTEX_ARRAY_LENGTH&&C(`Max vertices per segment is ${ba.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!s||s.vertexLength+t>ba.MAX_VERTEX_ARRAY_LENGTH||s.sortKey!==r)&&(s={vertexOffset:e.length,primitiveOffset:i.length,vertexLength:0,primitiveLength:0},void 0!==r&&(s.sortKey=r),this.segments.push(s)),s}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy()}static simpleSegment(t,e,i,r){return new ba([{vertexOffset:t,primitiveOffset:e,vertexLength:i,primitiveLength:r,vaos:{},sortKey:0}])}}function wa(t,e){return 256*(t=_(Math.floor(t),0,255))+_(Math.floor(e),0,255)}ba.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,Ds("SegmentVector",ba);const Ta=gn([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var Sa={exports:{}},Ia={exports:{}};!function(t){t.exports=function(t,e){var i,r,s,n,a,o,l,c;for(r=t.length-(i=3&t.length),s=e,a=3432918353,o=461845907,c=0;c<r;)l=255&t.charCodeAt(c)|(255&t.charCodeAt(++c))<<8|(255&t.charCodeAt(++c))<<16|(255&t.charCodeAt(++c))<<24,++c,s=27492+(65535&(n=5*(65535&(s=(s^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|s>>>19))+((5*(s>>>16)&65535)<<16)&4294967295))+((58964+(n>>>16)&65535)<<16);switch(l=0,i){case 3:l^=(255&t.charCodeAt(c+2))<<16;case 2:l^=(255&t.charCodeAt(c+1))<<8;case 1:s^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(c)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295}return s^=t.length,s=2246822507*(65535&(s^=s>>>16))+((2246822507*(s>>>16)&65535)<<16)&4294967295,s=3266489909*(65535&(s^=s>>>13))+((3266489909*(s>>>16)&65535)<<16)&4294967295,(s^=s>>>16)>>>0}}(Ia);var Aa=Ia.exports,Ca={exports:{}};!function(t){t.exports=function(t,e){for(var i,r=t.length,s=e^r,n=0;r>=4;)i=1540483477*(65535&(i=255&t.charCodeAt(n)|(255&t.charCodeAt(++n))<<8|(255&t.charCodeAt(++n))<<16|(255&t.charCodeAt(++n))<<24))+((1540483477*(i>>>16)&65535)<<16),s=1540483477*(65535&s)+((1540483477*(s>>>16)&65535)<<16)^(i=1540483477*(65535&(i^=i>>>24))+((1540483477*(i>>>16)&65535)<<16)),r-=4,++n;switch(r){case 3:s^=(255&t.charCodeAt(n+2))<<16;case 2:s^=(255&t.charCodeAt(n+1))<<8;case 1:s=1540483477*(65535&(s^=255&t.charCodeAt(n)))+((1540483477*(s>>>16)&65535)<<16)}return s=1540483477*(65535&(s^=s>>>13))+((1540483477*(s>>>16)&65535)<<16),(s^=s>>>15)>>>0}}(Ca);var Ea=Aa,za=Ca.exports;Sa.exports=Ea,Sa.exports.murmur3=Ea,Sa.exports.murmur2=za;var Pa=r(Sa.exports);class Ma{constructor(){this.ids=[],this.positions=[],this.indexed=!1}add(t,e,i,r){this.ids.push(ka(t)),this.positions.push(e,i,r)}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=ka(t);let i=0,r=this.ids.length-1;for(;i<r;){const t=i+r>>1;this.ids[t]>=e?r=t:i=t+1}const s=[];for(;this.ids[i]===e;)s.push({index:this.positions[3*i],start:this.positions[3*i+1],end:this.positions[3*i+2]}),i++;return s}static serialize(t,e){const i=new Float64Array(t.ids),r=new Uint32Array(t.positions);return Da(i,r,0,i.length-1),e&&e.push(i.buffer,r.buffer),{ids:i,positions:r}}static deserialize(t){const e=new Ma;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function ka(t){const e=+t;return!isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:Pa(String(t))}function Da(t,e,i,r){for(;i<r;){const s=t[i+r>>1];let n=i-1,a=r+1;for(;;){do{n++}while(t[n]<s);do{a--}while(t[a]>s);if(n>=a)break;La(t,n,a),La(e,3*n,3*a),La(e,3*n+1,3*a+1),La(e,3*n+2,3*a+2)}a-i<r-a?(Da(t,e,i,a),i=a+1):(Da(t,e,a+1,r),r=a)}}function La(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}Ds("FeaturePositionMap",Ma);class Ra{constructor(t,e){this.gl=t.gl,this.location=e}}class Ba extends Ra{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t))}}class Fa extends Ra{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t))}}class Oa extends Ra{constructor(t,e){super(t,e),this.current=[0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]))}}class Va extends Ra{constructor(t,e){super(t,e),this.current=[0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]))}}class Ua extends Ra{constructor(t,e){super(t,e),this.current=[0,0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]))}}class Na extends Ra{constructor(t,e){super(t,e),this.current=le.transparent}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a))}}const ja=new Float32Array(16);class $a extends Ra{constructor(t,e){super(t,e),this.current=ja}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}}function qa(t){return[wa(255*t.r,255*t.g),wa(255*t.b,255*t.a)]}class Za{constructor(t,e,i){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=i}setUniform(t,e,i){t.set(i.constantOr(this.value))}getBinding(t,e,i){return"color"===this.type?new Na(t,e):new Fa(t,e)}}class Ga{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr}setUniform(t,e,i,r){const s="u_pattern_to"===r?this.patternTo:"u_pattern_from"===r?this.patternFrom:"u_pixel_ratio_to"===r?this.pixelRatioTo:"u_pixel_ratio_from"===r?this.pixelRatioFrom:null;s&&t.set(s)}getBinding(t,e,i){return"u_pattern"===i.substr(0,9)?new Ua(t,e):new Fa(t,e)}}class Wa{constructor(t,e,i,r){this.expression=t,this.type=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===i?2:1,offset:0}))),this.paintVertexArray=new r}populatePaintArray(t,e,i,r,s){const n=this.paintVertexArray.length,a=this.expression.evaluate(new Ks(0),e,{},r,[],s);this.paintVertexArray.resize(t),this._setPaintValue(n,t,a)}updatePaintArray(t,e,i,r){const s=this.expression.evaluate({zoom:0},i,r);this._setPaintValue(t,e,s)}_setPaintValue(t,e,i){if("color"===this.type){const r=qa(i);for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r[0],r[1])}else{for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i);this.maxValue=Math.max(this.maxValue,Math.abs(i))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class Ha{constructor(t,e,i,r,s,n){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=i,this.useIntegerZoom=r,this.zoom=s,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===i?4:2,offset:0}))),this.paintVertexArray=new n}populatePaintArray(t,e,i,r,s){const n=this.expression.evaluate(new Ks(this.zoom),e,{},r,[],s),a=this.expression.evaluate(new Ks(this.zoom+1),e,{},r,[],s),o=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(o,t,n,a)}updatePaintArray(t,e,i,r){const s=this.expression.evaluate({zoom:this.zoom},i,r),n=this.expression.evaluate({zoom:this.zoom+1},i,r);this._setPaintValue(t,e,s,n)}_setPaintValue(t,e,i,r){if("color"===this.type){const s=qa(i),n=qa(r);for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,s[0],s[1],n[0],n[1])}else{for(let s=t;s<e;s++)this.paintVertexArray.emplace(s,i,r);this.maxValue=Math.max(this.maxValue,Math.abs(i),Math.abs(r))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}setUniform(t,e){const i=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,r=_(this.expression.interpolationFactor(i,this.zoom,this.zoom+1),0,1);t.set(r)}getBinding(t,e,i){return new Fa(t,e)}}class Xa{constructor(t,e,i,r,s,n){this.expression=t,this.type=e,this.useIntegerZoom=i,this.zoom=r,this.layerId=n,this.zoomInPaintVertexArray=new s,this.zoomOutPaintVertexArray=new s}populatePaintArray(t,e,i){const r=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(r,t,e.patterns&&e.patterns[this.layerId],i)}updatePaintArray(t,e,i,r,s){this._setPaintValues(t,e,i.patterns&&i.patterns[this.layerId],s)}_setPaintValues(t,e,i,r){if(!r||!i)return;const{min:s,mid:n,max:a}=i,o=r[s],l=r[n],c=r[a];if(o&&l&&c)for(let i=t;i<e;i++)this.zoomInPaintVertexArray.emplace(i,l.tl[0],l.tl[1],l.br[0],l.br[1],o.tl[0],o.tl[1],o.br[0],o.br[1],l.pixelRatio,o.pixelRatio),this.zoomOutPaintVertexArray.emplace(i,l.tl[0],l.tl[1],l.br[0],l.br[1],c.tl[0],c.tl[1],c.br[0],c.br[1],l.pixelRatio,c.pixelRatio)}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,Ta.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,Ta.members,this.expression.isStateDependent))}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy()}}class Ka{constructor(t,e,i){this.binders={},this._buffers=[];const r=[];for(const s in t.paint._values){if(!i(s))continue;const n=t.paint.get(s);if(!(n instanceof sn&&vr(n.property.specification)))continue;const a=Ja(s,t.type),o=n.value,l=n.property.specification.type,c=n.property.useIntegerZoom,h=n.property.specification["property-type"],u="cross-faded"===h||"cross-faded-data-driven"===h;if("constant"===o.kind)this.binders[s]=u?new Ga(o.value,a):new Za(o.value,a,l),r.push(`/u_${s}`);else if("source"===o.kind||u){const i=Qa(s,l,"source");this.binders[s]=u?new Xa(o,l,c,e,i,t.id):new Wa(o,a,l,i),r.push(`/a_${s}`)}else{const t=Qa(s,l,"composite");this.binders[s]=new Ha(o,a,l,c,e,t),r.push(`/z_${s}`)}}this.cacheKey=r.sort().join("")}getMaxValue(t){const e=this.binders[t];return e instanceof Wa||e instanceof Ha?e.maxValue:0}populatePaintArrays(t,e,i,r,s){for(const n in this.binders){const a=this.binders[n];(a instanceof Wa||a instanceof Ha||a instanceof Xa)&&a.populatePaintArray(t,e,i,r,s)}}setConstantPatternPositions(t,e){for(const i in this.binders){const r=this.binders[i];r instanceof Ga&&r.setConstantPatternPositions(t,e)}}updatePaintArrays(t,e,i,r,s){let n=!1;for(const a in t){const o=e.getPositions(a);for(const e of o){const o=i.feature(e.index);for(const i in this.binders){const l=this.binders[i];if((l instanceof Wa||l instanceof Ha||l instanceof Xa)&&!0===l.expression.isStateDependent){const c=r.paint.get(i);l.expression=c.value,l.updatePaintArray(e.start,e.end,o,t[a],s),n=!0}}}}return n}defines(){const t=[];for(const e in this.binders){const i=this.binders[e];(i instanceof Za||i instanceof Ga)&&t.push(...i.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)))}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const i=this.binders[e];if(i instanceof Wa||i instanceof Ha)for(let e=0;e<i.paintVertexAttributes.length;e++)t.push(i.paintVertexAttributes[e].name);else if(i instanceof Xa)for(let e=0;e<Ta.members.length;e++)t.push(Ta.members[e].name)}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const i=this.binders[e];if(i instanceof Za||i instanceof Ga||i instanceof Ha)for(const e of i.uniformNames)t.push(e)}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const i=[];for(const r in this.binders){const s=this.binders[r];if(s instanceof Za||s instanceof Ga||s instanceof Ha)for(const n of s.uniformNames)if(e[n]){const a=s.getBinding(t,e[n],n);i.push({name:n,property:r,binding:a})}}return i}setUniforms(t,e,i,r){for(const{name:t,property:s,binding:n}of e)this.binders[s].setUniform(n,r,i.get(s),t)}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const i=this.binders[e];if(t&&i instanceof Xa){const e=2===t.fromScale?i.zoomInPaintVertexBuffer:i.zoomOutPaintVertexBuffer;e&&this._buffers.push(e)}else(i instanceof Wa||i instanceof Ha)&&i.paintVertexBuffer&&this._buffers.push(i.paintVertexBuffer)}}upload(t){for(const e in this.binders){const i=this.binders[e];(i instanceof Wa||i instanceof Ha||i instanceof Xa)&&i.upload(t)}this.updatePaintBuffers()}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Wa||e instanceof Ha||e instanceof Xa)&&e.destroy()}}}class Ya{constructor(t,e,i=(()=>!0)){this.programConfigurations={};for(const r of t)this.programConfigurations[r.id]=new Ka(r,e,i);this.needsUpload=!1,this._featureMap=new Ma,this._bufferOffset=0}populatePaintArrays(t,e,i,r,s,n){for(const i in this.programConfigurations)this.programConfigurations[i].populatePaintArrays(t,e,r,s,n);void 0!==e.id&&this._featureMap.add(e.id,i,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0}updatePaintArrays(t,e,i,r){for(const s of i)this.needsUpload=this.programConfigurations[s.id].updatePaintArrays(t,this._featureMap,e,s,r)||this.needsUpload}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy()}}function Ja(t,e){return{"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function Qa(t,e,i){const r={color:{source:Sn,composite:Nn},number:{source:Bn,composite:Sn}},s=function(t){return{"line-pattern":{source:la,composite:la},"fill-pattern":{source:la,composite:la},"fill-extrusion-pattern":{source:la,composite:la}}[t]}(t);return s&&s[i]||r[e][i]}Ds("ConstantBinder",Za),Ds("CrossFadedConstantBinder",Ga),Ds("SourceExpressionBinder",Wa),Ds("CrossFadedCompositeBinder",Xa),Ds("CompositeExpressionBinder",Ha),Ds("ProgramConfiguration",Ka,{omit:["_buffers"]}),Ds("ProgramConfigurationSet",Ya);const to=8192,eo=Math.pow(2,14)-1,io=-eo-1;function ro(t){const e=to/t.extent,i=t.loadGeometry();for(let t=0;t<i.length;t++){const r=i[t];for(let t=0;t<r.length;t++){const i=r[t],s=Math.round(i.x*e),n=Math.round(i.y*e);i.x=_(s,io,eo),i.y=_(n,io,eo),(s<i.x||s>i.x+1||n<i.y||n>i.y+1)&&C("Geometry exceeds allowed extent, reduce your vector tile buffer size")}}return i}function so(t,e){return{type:t.type,id:t.id,properties:t.properties,geometry:e?ro(t):[]}}function no(t,e,i,r,s){t.emplaceBack(2*e+(r+1)/2,2*i+(s+1)/2)}class ao{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new ra,this.indexArray=new _a,this.segments=new ba,this.programConfigurations=new Ya(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){const r=this.layers[0],s=[];let n=null,a=!1;"circle"===r.type&&(n=r.layout.get("circle-sort-key"),a=!n.isConstant());for(const{feature:e,id:r,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,c=so(e,t);if(!this.layers[0]._featureFilter.filter(new Ks(this.zoom),c,i))continue;const h=a?n.evaluate(c,{},i):void 0,u={id:r,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?c.geometry:ro(e),patterns:{},sortKey:h};s.push(u)}a&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of s){const{geometry:s,index:n,sourceLayerIndex:a}=r,o=t[n].feature;this.addFeature(r,s,n,i),e.featureIndex.insert(o,s,n,a,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,i)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,va),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}addFeature(t,e,i,r){for(const i of e)for(const e of i){const i=e.x,r=e.y;if(i<0||i>=to||r<0||r>=to)continue;const s=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),n=s.vertexLength;no(this.layoutVertexArray,i,r,-1,-1),no(this.layoutVertexArray,i,r,1,-1),no(this.layoutVertexArray,i,r,1,1),no(this.layoutVertexArray,i,r,-1,1),this.indexArray.emplaceBack(n,n+1,n+2),this.indexArray.emplaceBack(n,n+3,n+2),s.vertexLength+=4,s.primitiveLength+=2}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,{},r)}}function oo(t,e){for(let i=0;i<t.length;i++)if(go(e,t[i]))return!0;for(let i=0;i<e.length;i++)if(go(t,e[i]))return!0;return!!uo(t,e)}function lo(t,e,i){return!!go(t,e)||!!fo(e,t,i)}function co(t,e){if(1===t.length)return _o(e,t[0]);for(let i=0;i<e.length;i++){const r=e[i];for(let e=0;e<r.length;e++)if(go(t,r[e]))return!0}for(let i=0;i<t.length;i++)if(_o(e,t[i]))return!0;for(let i=0;i<e.length;i++)if(uo(t,e[i]))return!0;return!1}function ho(t,e,i){if(t.length>1){if(uo(t,e))return!0;for(let r=0;r<e.length;r++)if(fo(e[r],t,i))return!0}for(let r=0;r<t.length;r++)if(fo(t[r],e,i))return!0;return!1}function uo(t,e){if(0===t.length||0===e.length)return!1;for(let i=0;i<t.length-1;i++){const r=t[i],s=t[i+1];for(let t=0;t<e.length-1;t++)if(po(r,s,e[t],e[t+1]))return!0}return!1}function po(t,e,i,r){return E(t,i,r)!==E(e,i,r)&&E(t,e,i)!==E(t,e,r)}function fo(t,e,i){const r=i*i;if(1===e.length)return t.distSqr(e[0])<r;for(let i=1;i<e.length;i++)if(mo(t,e[i-1],e[i])<r)return!0;return!1}function mo(t,e,i){const r=e.distSqr(i);if(0===r)return t.distSqr(e);const s=((t.x-e.x)*(i.x-e.x)+(t.y-e.y)*(i.y-e.y))/r;return t.distSqr(s<0?e:s>1?i:i.sub(e)._mult(s)._add(e))}function _o(t,e){let i,r,s,n=!1;for(let a=0;a<t.length;a++){i=t[a];for(let t=0,a=i.length-1;t<i.length;a=t++)r=i[t],s=i[a],r.y>e.y!=s.y>e.y&&e.x<(s.x-r.x)*(e.y-r.y)/(s.y-r.y)+r.x&&(n=!n)}return n}function go(t,e){let i=!1;for(let r=0,s=t.length-1;r<t.length;s=r++){const n=t[r],a=t[s];n.y>e.y!=a.y>e.y&&e.x<(a.x-n.x)*(e.y-n.y)/(a.y-n.y)+n.x&&(i=!i)}return i}function yo(t,e,i){const r=i[0],s=i[2];if(t.x<r.x&&e.x<r.x||t.x>s.x&&e.x>s.x||t.y<r.y&&e.y<r.y||t.y>s.y&&e.y>s.y)return!1;const n=E(t,e,i[0]);return n!==E(t,e,i[1])||n!==E(t,e,i[2])||n!==E(t,e,i[3])}function xo(t,e,i){const r=e.paint.get(t).value;return"constant"===r.kind?r.value:i.programConfigurations.get(e.id).getMaxValue(t)}function vo(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function bo(t,e,i,r,s){if(!e[0]&&!e[1])return t;const n=a.convert(e)._mult(s);"viewport"===i&&n._rotate(-r);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(n));return o}let wo,To;Ds("CircleBucket",ao,{omit:["layers"]});var So={get paint(){return To=To||new un({"circle-radius":new on(at.paint_circle["circle-radius"]),"circle-color":new on(at.paint_circle["circle-color"]),"circle-blur":new on(at.paint_circle["circle-blur"]),"circle-opacity":new on(at.paint_circle["circle-opacity"]),"circle-translate":new an(at.paint_circle["circle-translate"]),"circle-translate-anchor":new an(at.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new an(at.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new an(at.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new on(at.paint_circle["circle-stroke-width"]),"circle-stroke-color":new on(at.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new on(at.paint_circle["circle-stroke-opacity"])})},get layout(){return wo=wo||new un({"circle-sort-key":new on(at.layout_circle["circle-sort-key"])})}},Io=1e-6,Ao="undefined"!=typeof Float32Array?Float32Array:Array;function Co(){var t=new Ao(16);return Ao!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t}function Eo(t){var e=new Ao(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e}function zo(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function Po(t,e){var i=e[0],r=e[1],s=e[2],n=e[3],a=e[4],o=e[5],l=e[6],c=e[7],h=e[8],u=e[9],p=e[10],d=e[11],f=e[12],m=e[13],_=e[14],g=e[15],y=i*o-r*a,x=i*l-s*a,v=i*c-n*a,b=r*l-s*o,w=r*c-n*o,T=s*c-n*l,S=h*m-u*f,I=h*_-p*f,A=h*g-d*f,C=u*_-p*m,E=u*g-d*m,z=p*g-d*_,P=y*z-x*E+v*C+b*A-w*I+T*S;return P?(t[0]=(o*z-l*E+c*C)*(P=1/P),t[1]=(s*E-r*z-n*C)*P,t[2]=(m*T-_*w+g*b)*P,t[3]=(p*w-u*T-d*b)*P,t[4]=(l*A-a*z-c*I)*P,t[5]=(i*z-s*A+n*I)*P,t[6]=(_*v-f*T-g*x)*P,t[7]=(h*T-p*v+d*x)*P,t[8]=(a*E-o*A+c*S)*P,t[9]=(r*A-i*E-n*S)*P,t[10]=(f*w-m*v+g*y)*P,t[11]=(u*v-h*w-d*y)*P,t[12]=(o*I-a*C-l*S)*P,t[13]=(i*C-r*I+s*S)*P,t[14]=(m*x-f*b-_*y)*P,t[15]=(h*b-u*x+p*y)*P,t):null}function Mo(t,e,i){var r=e[0],s=e[1],n=e[2],a=e[3],o=e[4],l=e[5],c=e[6],h=e[7],u=e[8],p=e[9],d=e[10],f=e[11],m=e[12],_=e[13],g=e[14],y=e[15],x=i[0],v=i[1],b=i[2],w=i[3];return t[0]=x*r+v*o+b*u+w*m,t[1]=x*s+v*l+b*p+w*_,t[2]=x*n+v*c+b*d+w*g,t[3]=x*a+v*h+b*f+w*y,t[4]=(x=i[4])*r+(v=i[5])*o+(b=i[6])*u+(w=i[7])*m,t[5]=x*s+v*l+b*p+w*_,t[6]=x*n+v*c+b*d+w*g,t[7]=x*a+v*h+b*f+w*y,t[8]=(x=i[8])*r+(v=i[9])*o+(b=i[10])*u+(w=i[11])*m,t[9]=x*s+v*l+b*p+w*_,t[10]=x*n+v*c+b*d+w*g,t[11]=x*a+v*h+b*f+w*y,t[12]=(x=i[12])*r+(v=i[13])*o+(b=i[14])*u+(w=i[15])*m,t[13]=x*s+v*l+b*p+w*_,t[14]=x*n+v*c+b*d+w*g,t[15]=x*a+v*h+b*f+w*y,t}function ko(t,e,i){var r,s,n,a,o,l,c,h,u,p,d,f,m=i[0],_=i[1],g=i[2];return e===t?(t[12]=e[0]*m+e[4]*_+e[8]*g+e[12],t[13]=e[1]*m+e[5]*_+e[9]*g+e[13],t[14]=e[2]*m+e[6]*_+e[10]*g+e[14],t[15]=e[3]*m+e[7]*_+e[11]*g+e[15]):(s=e[1],n=e[2],a=e[3],o=e[4],l=e[5],c=e[6],h=e[7],u=e[8],p=e[9],d=e[10],f=e[11],t[0]=r=e[0],t[1]=s,t[2]=n,t[3]=a,t[4]=o,t[5]=l,t[6]=c,t[7]=h,t[8]=u,t[9]=p,t[10]=d,t[11]=f,t[12]=r*m+o*_+u*g+e[12],t[13]=s*m+l*_+p*g+e[13],t[14]=n*m+c*_+d*g+e[14],t[15]=a*m+h*_+f*g+e[15]),t}function Do(t,e,i){var r=i[0],s=i[1],n=i[2];return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*s,t[5]=e[5]*s,t[6]=e[6]*s,t[7]=e[7]*s,t[8]=e[8]*n,t[9]=e[9]*n,t[10]=e[10]*n,t[11]=e[11]*n,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t}function Lo(t,e,i){var r=Math.sin(i),s=Math.cos(i),n=e[4],a=e[5],o=e[6],l=e[7],c=e[8],h=e[9],u=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=n*s+c*r,t[5]=a*s+h*r,t[6]=o*s+u*r,t[7]=l*s+p*r,t[8]=c*s-n*r,t[9]=h*s-a*r,t[10]=u*s-o*r,t[11]=p*s-l*r,t}function Ro(t,e,i){var r=Math.sin(i),s=Math.cos(i),n=e[0],a=e[1],o=e[2],l=e[3],c=e[4],h=e[5],u=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=n*s+c*r,t[1]=a*s+h*r,t[2]=o*s+u*r,t[3]=l*s+p*r,t[4]=c*s-n*r,t[5]=h*s-a*r,t[6]=u*s-o*r,t[7]=p*s-l*r,t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var Bo=function(t,e,i,r,s){var n,a=1/Math.tan(e/2);return t[0]=a/i,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=s&&s!==1/0?(t[10]=(s+r)*(n=1/(r-s)),t[14]=2*s*r*n):(t[10]=-1,t[14]=-2*r),t},Fo=function(t,e,i,r,s,n,a){var o=1/(e-i),l=1/(r-s),c=1/(n-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*c,t[11]=0,t[12]=(e+i)*o,t[13]=(s+r)*l,t[14]=(a+n)*c,t[15]=1,t},Oo=Mo;function Vo(t){var e=new Ao(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e}var Uo,No=function(t,e,i){return t[0]=e[0]-i[0],t[1]=e[1]-i[1],t[2]=e[2]-i[2],t};function jo(t,e,i){var r=e[0],s=e[1],n=e[2],a=e[3];return t[0]=i[0]*r+i[4]*s+i[8]*n+i[12]*a,t[1]=i[1]*r+i[5]*s+i[9]*n+i[13]*a,t[2]=i[2]*r+i[6]*s+i[10]*n+i[14]*a,t[3]=i[3]*r+i[7]*s+i[11]*n+i[15]*a,t}Uo=new Ao(3),Ao!=Float32Array&&(Uo[0]=0,Uo[1]=0,Uo[2]=0),function(){var t=new Ao(4);Ao!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[3]=0)}();var $o=function(t){var e=t[0],i=t[1];return e*e+i*i};!function(){var t=new Ao(2);Ao!=Float32Array&&(t[0]=0,t[1]=0)}();class qo extends dn{constructor(t){super(t,So)}createBucket(t){return new ao(t)}queryRadius(t){const e=t;return xo("circle-radius",this,e)+xo("circle-stroke-width",this,e)+vo(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,i,r,s,n,a,o){const l=bo(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),n.angle,a),c=this.paint.get("circle-radius").evaluate(e,i)+this.paint.get("circle-stroke-width").evaluate(e,i),h="map"===this.paint.get("circle-pitch-alignment"),u=h?l:function(t,e){return t.map((t=>Zo(t,e)))}(l,o),p=h?c*a:c;for(const t of r)for(const e of t){const t=h?e:Zo(e,o);let i=p;const r=jo([],[e.x,e.y,0,1],o);if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?i*=r[3]/n.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(i*=n.cameraToCenterDistance/r[3]),lo(u,t,i))return!0}return!1}}function Zo(t,e){const i=jo([],[t.x,t.y,0,1],e);return new a(i[0]/i[3],i[1]/i[3])}class Go extends ao{}let Wo;Ds("HeatmapBucket",Go,{omit:["layers"]});var Ho={get paint(){return Wo=Wo||new un({"heatmap-radius":new on(at.paint_heatmap["heatmap-radius"]),"heatmap-weight":new on(at.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new an(at.paint_heatmap["heatmap-intensity"]),"heatmap-color":new hn(at.paint_heatmap["heatmap-color"]),"heatmap-opacity":new an(at.paint_heatmap["heatmap-opacity"])})}};function Xo(t,{width:e,height:i},r,s){if(s){if(s instanceof Uint8ClampedArray)s=new Uint8Array(s.buffer);else if(s.length!==e*i*r)throw new RangeError(`mismatched image size. expected: ${s.length} but got: ${e*i*r}`)}else s=new Uint8Array(e*i*r);return t.width=e,t.height=i,t.data=s,t}function Ko(t,{width:e,height:i},r){if(e===t.width&&i===t.height)return;const s=Xo({},{width:e,height:i},r);Yo(t,s,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,i)},r),t.width=e,t.height=i,t.data=s.data}function Yo(t,e,i,r,s,n){if(0===s.width||0===s.height)return e;if(s.width>t.width||s.height>t.height||i.x>t.width-s.width||i.y>t.height-s.height)throw new RangeError("out of range source coordinates for image copy");if(s.width>e.width||s.height>e.height||r.x>e.width-s.width||r.y>e.height-s.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,o=e.data;if(a===o)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<s.height;l++){const c=((i.y+l)*t.width+i.x)*n,h=((r.y+l)*e.width+r.x)*n;for(let t=0;t<s.width*n;t++)o[h+t]=a[c+t]}return e}class Jo{constructor(t,e){Xo(this,t,1,e)}resize(t){Ko(this,t,1)}clone(){return new Jo({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,i,r,s){Yo(t,e,i,r,s,1)}}class Qo{constructor(t,e){Xo(this,t,4,e)}resize(t){Ko(this,t,4)}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t}clone(){return new Qo({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,i,r,s){Yo(t,e,i,r,s,4)}}function tl(t){const e={},i=t.resolution||256,r=t.clips?t.clips.length:1,s=t.image||new Qo({width:i,height:r});if(Math.log(i)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${i}`);const n=(i,r,n)=>{e[t.evaluationKey]=n;const a=t.expression.evaluate(e);s.data[i+r+0]=Math.floor(255*a.r/a.a),s.data[i+r+1]=Math.floor(255*a.g/a.a),s.data[i+r+2]=Math.floor(255*a.b/a.a),s.data[i+r+3]=Math.floor(255*a.a)};if(t.clips)for(let e=0,s=0;e<r;++e,s+=4*i)for(let r=0,a=0;r<i;r++,a+=4){const o=r/(i-1),{start:l,end:c}=t.clips[e];n(s,a,l*(1-o)+c*o)}else for(let t=0,e=0;t<i;t++,e+=4)n(0,e,t/(i-1));return s}Ds("AlphaImage",Jo),Ds("RGBAImage",Qo);const el="big-fb";class il extends dn{createBucket(t){return new Go(t)}constructor(t){super(t,Ho),this.heatmapFbos=new Map,this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp()}_updateColorRamp(){this.colorRamp=tl({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null}resize(){this.heatmapFbos.has(el)&&this.heatmapFbos.delete(el)}queryRadius(){return 0}queryIntersectsFeature(){return!1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let rl;var sl={get paint(){return rl=rl||new un({"hillshade-illumination-direction":new an(at.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new an(at.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new an(at.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new an(at.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new an(at.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new an(at.paint_hillshade["hillshade-accent-color"])})}};class nl extends dn{constructor(t){super(t,sl)}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}const al=gn([{name:"a_pos",components:2,type:"Int16"}],4),{members:ol}=al;function ll(t,e,i=2){const r=e&&e.length,s=r?e[0]*i:t.length;let n=cl(t,0,s,i,!0);const a=[];if(!n||n.next===n.prev)return a;let o,l,c;if(r&&(n=function(t,e,i,r){const s=[];for(let i=0,n=e.length;i<n;i++){const a=cl(t,e[i]*r,i<n-1?e[i+1]*r:t.length,r,!1);a===a.next&&(a.steiner=!0),s.push(vl(a))}s.sort(_l);for(let t=0;t<s.length;t++)i=gl(s[t],i);return i}(t,e,n,i)),t.length>80*i){o=1/0,l=1/0;let e=-1/0,r=-1/0;for(let n=i;n<s;n+=i){const i=t[n],s=t[n+1];i<o&&(o=i),s<l&&(l=s),i>e&&(e=i),s>r&&(r=s)}c=Math.max(e-o,r-l),c=0!==c?32767/c:0}return ul(n,a,i,o,l,c,0),a}function cl(t,e,i,r,s){let n;if(s===function(t,e,i,r){let s=0;for(let n=e,a=i-r;n<i;n+=r)s+=(t[a]-t[n])*(t[n+1]+t[a+1]),a=n;return s}(t,e,i,r)>0)for(let s=e;s<i;s+=r)n=Pl(s/r|0,t[s],t[s+1],n);else for(let s=i-r;s>=e;s-=r)n=Pl(s/r|0,t[s],t[s+1],n);return n&&Sl(n,n.next)&&(Ml(n),n=n.next),n}function hl(t,e){if(!t)return t;e||(e=t);let i,r=t;do{if(i=!1,r.steiner||!Sl(r,r.next)&&0!==Tl(r.prev,r,r.next))r=r.next;else{if(Ml(r),r=e=r.prev,r===r.next)break;i=!0}}while(i||r!==e);return e}function ul(t,e,i,r,s,n,a){if(!t)return;!a&&n&&function(t,e,i,r){let s=t;do{0===s.z&&(s.z=xl(s.x,s.y,e,i,r)),s.prevZ=s.prev,s.nextZ=s.next,s=s.next}while(s!==t);s.prevZ.nextZ=null,s.prevZ=null,function(t){let e,i=1;do{let r,s=t;t=null;let n=null;for(e=0;s;){e++;let a=s,o=0;for(let t=0;t<i&&(o++,a=a.nextZ,a);t++);let l=i;for(;o>0||l>0&&a;)0!==o&&(0===l||!a||s.z<=a.z)?(r=s,s=s.nextZ,o--):(r=a,a=a.nextZ,l--),n?n.nextZ=r:t=r,r.prevZ=n,n=r;s=a}n.nextZ=null,i*=2}while(e>1)}(s)}(t,r,s,n);let o=t;for(;t.prev!==t.next;){const l=t.prev,c=t.next;if(n?dl(t,r,s,n):pl(t))e.push(l.i,t.i,c.i),Ml(t),t=c.next,o=c.next;else if((t=c)===o){a?1===a?ul(t=fl(hl(t),e),e,i,r,s,n,2):2===a&&ml(t,e,i,r,s,n):ul(hl(t),e,i,r,s,n,1);break}}}function pl(t){const e=t.prev,i=t,r=t.next;if(Tl(e,i,r)>=0)return!1;const s=e.x,n=i.x,a=r.x,o=e.y,l=i.y,c=r.y,h=s<n?s<a?s:a:n<a?n:a,u=o<l?o<c?o:c:l<c?l:c,p=s>n?s>a?s:a:n>a?n:a,d=o>l?o>c?o:c:l>c?l:c;let f=r.next;for(;f!==e;){if(f.x>=h&&f.x<=p&&f.y>=u&&f.y<=d&&bl(s,o,n,l,a,c,f.x,f.y)&&Tl(f.prev,f,f.next)>=0)return!1;f=f.next}return!0}function dl(t,e,i,r){const s=t.prev,n=t,a=t.next;if(Tl(s,n,a)>=0)return!1;const o=s.x,l=n.x,c=a.x,h=s.y,u=n.y,p=a.y,d=o<l?o<c?o:c:l<c?l:c,f=h<u?h<p?h:p:u<p?u:p,m=o>l?o>c?o:c:l>c?l:c,_=h>u?h>p?h:p:u>p?u:p,g=xl(d,f,e,i,r),y=xl(m,_,e,i,r);let x=t.prevZ,v=t.nextZ;for(;x&&x.z>=g&&v&&v.z<=y;){if(x.x>=d&&x.x<=m&&x.y>=f&&x.y<=_&&x!==s&&x!==a&&bl(o,h,l,u,c,p,x.x,x.y)&&Tl(x.prev,x,x.next)>=0)return!1;if(x=x.prevZ,v.x>=d&&v.x<=m&&v.y>=f&&v.y<=_&&v!==s&&v!==a&&bl(o,h,l,u,c,p,v.x,v.y)&&Tl(v.prev,v,v.next)>=0)return!1;v=v.nextZ}for(;x&&x.z>=g;){if(x.x>=d&&x.x<=m&&x.y>=f&&x.y<=_&&x!==s&&x!==a&&bl(o,h,l,u,c,p,x.x,x.y)&&Tl(x.prev,x,x.next)>=0)return!1;x=x.prevZ}for(;v&&v.z<=y;){if(v.x>=d&&v.x<=m&&v.y>=f&&v.y<=_&&v!==s&&v!==a&&bl(o,h,l,u,c,p,v.x,v.y)&&Tl(v.prev,v,v.next)>=0)return!1;v=v.nextZ}return!0}function fl(t,e){let i=t;do{const r=i.prev,s=i.next.next;!Sl(r,s)&&Il(r,i,i.next,s)&&El(r,s)&&El(s,r)&&(e.push(r.i,i.i,s.i),Ml(i),Ml(i.next),i=t=s),i=i.next}while(i!==t);return hl(i)}function ml(t,e,i,r,s,n){let a=t;do{let t=a.next.next;for(;t!==a.prev;){if(a.i!==t.i&&wl(a,t)){let o=zl(a,t);return a=hl(a,a.next),o=hl(o,o.next),ul(a,e,i,r,s,n,0),void ul(o,e,i,r,s,n,0)}t=t.next}a=a.next}while(a!==t)}function _l(t,e){return t.x-e.x}function gl(t,e){const i=function(t,e){let i=e;const r=t.x,s=t.y;let n,a=-1/0;do{if(s<=i.y&&s>=i.next.y&&i.next.y!==i.y){const t=i.x+(s-i.y)*(i.next.x-i.x)/(i.next.y-i.y);if(t<=r&&t>a&&(a=t,n=i.x<i.next.x?i:i.next,t===r))return n}i=i.next}while(i!==e);if(!n)return null;const o=n,l=n.x,c=n.y;let h=1/0;i=n;do{if(r>=i.x&&i.x>=l&&r!==i.x&&bl(s<c?r:a,s,l,c,s<c?a:r,s,i.x,i.y)){const e=Math.abs(s-i.y)/(r-i.x);El(i,t)&&(e<h||e===h&&(i.x>n.x||i.x===n.x&&yl(n,i)))&&(n=i,h=e)}i=i.next}while(i!==o);return n}(t,e);if(!i)return e;const r=zl(i,t);return hl(r,r.next),hl(i,i.next)}function yl(t,e){return Tl(t.prev,t,e.prev)<0&&Tl(e.next,t,t.next)<0}function xl(t,e,i,r,s){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-i)*s|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-r)*s|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function vl(t){let e=t,i=t;do{(e.x<i.x||e.x===i.x&&e.y<i.y)&&(i=e),e=e.next}while(e!==t);return i}function bl(t,e,i,r,s,n,a,o){return(s-a)*(e-o)>=(t-a)*(n-o)&&(t-a)*(r-o)>=(i-a)*(e-o)&&(i-a)*(n-o)>=(s-a)*(r-o)}function wl(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let i=t;do{if(i.i!==t.i&&i.next.i!==t.i&&i.i!==e.i&&i.next.i!==e.i&&Il(i,i.next,t,e))return!0;i=i.next}while(i!==t);return!1}(t,e)&&(El(t,e)&&El(e,t)&&function(t,e){let i=t,r=!1;const s=(t.x+e.x)/2,n=(t.y+e.y)/2;do{i.y>n!=i.next.y>n&&i.next.y!==i.y&&s<(i.next.x-i.x)*(n-i.y)/(i.next.y-i.y)+i.x&&(r=!r),i=i.next}while(i!==t);return r}(t,e)&&(Tl(t.prev,t,e.prev)||Tl(t,e.prev,e))||Sl(t,e)&&Tl(t.prev,t,t.next)>0&&Tl(e.prev,e,e.next)>0)}function Tl(t,e,i){return(e.y-t.y)*(i.x-e.x)-(e.x-t.x)*(i.y-e.y)}function Sl(t,e){return t.x===e.x&&t.y===e.y}function Il(t,e,i,r){const s=Cl(Tl(t,e,i)),n=Cl(Tl(t,e,r)),a=Cl(Tl(i,r,t)),o=Cl(Tl(i,r,e));return s!==n&&a!==o||!(0!==s||!Al(t,i,e))||!(0!==n||!Al(t,r,e))||!(0!==a||!Al(i,t,r))||!(0!==o||!Al(i,e,r))}function Al(t,e,i){return e.x<=Math.max(t.x,i.x)&&e.x>=Math.min(t.x,i.x)&&e.y<=Math.max(t.y,i.y)&&e.y>=Math.min(t.y,i.y)}function Cl(t){return t>0?1:t<0?-1:0}function El(t,e){return Tl(t.prev,t,t.next)<0?Tl(t,e,t.next)>=0&&Tl(t,t.prev,e)>=0:Tl(t,e,t.prev)<0||Tl(t,t.next,e)<0}function zl(t,e){const i=kl(t.i,t.x,t.y),r=kl(e.i,e.x,e.y),s=t.next,n=e.prev;return t.next=e,e.prev=t,i.next=s,s.prev=i,r.next=i,i.prev=r,n.next=r,r.prev=n,r}function Pl(t,e,i,r){const s=kl(t,e,i);return r?(s.next=r.next,s.prev=r,r.next.prev=s,r.next=s):(s.prev=s,s.next=s),s}function Ml(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function kl(t,e,i){return{i:t,x:e,y:i,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}function Dl(t,e,i){const r=i.patternDependencies;let s=!1;for(const i of e){const e=i.paint.get(`${t}-pattern`);e.isConstant()||(s=!0);const n=e.constantOr(null);n&&(s=!0,r[n.to]=!0,r[n.from]=!0)}return s}function Ll(t,e,i,r,s){const n=s.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:r-1},i,{},s.availableImages),o=e.evaluate({zoom:r},i,{},s.availableImages),l=e.evaluate({zoom:r+1},i,{},s.availableImages);t=t&&t.name?t.name:t,o=o&&o.name?o.name:o,l=l&&l.name?l.name:l,n[t]=!0,n[o]=!0,n[l]=!0,i.patterns[a.id]={min:t,mid:o,max:l}}}return i}class Rl{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new sa,this.indexArray=new _a,this.indexArray2=new ga,this.programConfigurations=new Ya(t.layers,t.zoom),this.segments=new ba,this.segments2=new ba,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.hasPattern=Dl("fill",this.layers,e);const r=this.layers[0].layout.get("fill-sort-key"),s=!r.isConstant(),n=[];for(const{feature:a,id:o,index:l,sourceLayerIndex:c}of t){const t=this.layers[0]._featureFilter.needGeometry,h=so(a,t);if(!this.layers[0]._featureFilter.filter(new Ks(this.zoom),h,i))continue;const u=s?r.evaluate(h,{},i,e.availableImages):void 0,p={id:o,properties:a.properties,type:a.type,sourceLayerIndex:c,index:l,geometry:t?h.geometry:ro(a),patterns:{},sortKey:u};n.push(p)}s&&n.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of n){const{geometry:s,index:n,sourceLayerIndex:a}=r;if(this.hasPattern){const t=Ll("fill",this.layers,r,this.zoom,e);this.patternFeatures.push(t)}else this.addFeature(r,s,n,i,{});e.featureIndex.insert(t[n].feature,s,n,a,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,i)}addFeatures(t,e,i){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,i)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,ol),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy())}addFeature(t,e,i,r,s){for(const t of Di(e,500)){let e=0;for(const i of t)e+=i.length;const i=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray),r=i.vertexLength,s=[],n=[];for(const e of t){if(0===e.length)continue;e!==t[0]&&n.push(s.length/2);const i=this.segments2.prepareSegment(e.length,this.layoutVertexArray,this.indexArray2),r=i.vertexLength;this.layoutVertexArray.emplaceBack(e[0].x,e[0].y),this.indexArray2.emplaceBack(r+e.length-1,r),s.push(e[0].x),s.push(e[0].y);for(let t=1;t<e.length;t++)this.layoutVertexArray.emplaceBack(e[t].x,e[t].y),this.indexArray2.emplaceBack(r+t-1,r+t),s.push(e[t].x),s.push(e[t].y);i.vertexLength+=e.length,i.primitiveLength+=e.length}const a=ll(s,n);for(let t=0;t<a.length;t+=3)this.indexArray.emplaceBack(r+a[t],r+a[t+1],r+a[t+2]);i.vertexLength+=e,i.primitiveLength+=a.length/3}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,s,r)}}let Bl,Fl;Ds("FillBucket",Rl,{omit:["layers","patternFeatures"]});var Ol={get paint(){return Fl=Fl||new un({"fill-antialias":new an(at.paint_fill["fill-antialias"]),"fill-opacity":new on(at.paint_fill["fill-opacity"]),"fill-color":new on(at.paint_fill["fill-color"]),"fill-outline-color":new on(at.paint_fill["fill-outline-color"]),"fill-translate":new an(at.paint_fill["fill-translate"]),"fill-translate-anchor":new an(at.paint_fill["fill-translate-anchor"]),"fill-pattern":new ln(at.paint_fill["fill-pattern"])})},get layout(){return Bl=Bl||new un({"fill-sort-key":new on(at.layout_fill["fill-sort-key"])})}};class Vl extends dn{constructor(t){super(t,Ol)}recalculate(t,e){super.recalculate(t,e);const i=this.paint._values["fill-outline-color"];"constant"===i.value.kind&&void 0===i.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"])}createBucket(t){return new Rl(t)}queryRadius(){return vo(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,i,r,s,n,a){return co(bo(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),n.angle,a),r)}isTileClipped(){return!0}}const Ul=gn([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),Nl=gn([{name:"a_centroid",components:2,type:"Int16"}],4),{members:jl}=Ul;var $l={},ql=s,Zl=Gl;function Gl(t,e,i,r,s){this.properties={},this.extent=i,this.type=0,this._pbf=t,this._geometry=-1,this._keys=r,this._values=s,t.readFields(Wl,this,e)}function Wl(t,e,i){1==t?e.id=i.readVarint():2==t?function(t,e){for(var i=t.readVarint()+t.pos;t.pos<i;){var r=e._keys[t.readVarint()],s=e._values[t.readVarint()];e.properties[r]=s}}(i,e):3==t?e.type=i.readVarint():4==t&&(e._geometry=i.pos)}function Hl(t){for(var e,i,r=0,s=0,n=t.length,a=n-1;s<n;a=s++)r+=((i=t[a]).x-(e=t[s]).x)*(e.y+i.y);return r}Gl.types=["Unknown","Point","LineString","Polygon"],Gl.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,i=t.readVarint()+t.pos,r=1,s=0,n=0,a=0,o=[];t.pos<i;){if(s<=0){var l=t.readVarint();r=7&l,s=l>>3}if(s--,1===r||2===r)n+=t.readSVarint(),a+=t.readSVarint(),1===r&&(e&&o.push(e),e=[]),e.push(new ql(n,a));else{if(7!==r)throw new Error("unknown command "+r);e&&e.push(e[0].clone())}}return e&&o.push(e),o},Gl.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,i=1,r=0,s=0,n=0,a=1/0,o=-1/0,l=1/0,c=-1/0;t.pos<e;){if(r<=0){var h=t.readVarint();i=7&h,r=h>>3}if(r--,1===i||2===i)(s+=t.readSVarint())<a&&(a=s),s>o&&(o=s),(n+=t.readSVarint())<l&&(l=n),n>c&&(c=n);else if(7!==i)throw new Error("unknown command "+i)}return[a,l,o,c]},Gl.prototype.toGeoJSON=function(t,e,i){var r,s,n=this.extent*Math.pow(2,i),a=this.extent*t,o=this.extent*e,l=this.loadGeometry(),c=Gl.types[this.type];function h(t){for(var e=0;e<t.length;e++){var i=t[e];t[e]=[360*(i.x+a)/n-180,360/Math.PI*Math.atan(Math.exp((180-360*(i.y+o)/n)*Math.PI/180))-90]}}switch(this.type){case 1:var u=[];for(r=0;r<l.length;r++)u[r]=l[r][0];h(l=u);break;case 2:for(r=0;r<l.length;r++)h(l[r]);break;case 3:for(l=function(t){var e=t.length;if(e<=1)return[t];for(var i,r,s=[],n=0;n<e;n++){var a=Hl(t[n]);0!==a&&(void 0===r&&(r=a<0),r===a<0?(i&&s.push(i),i=[t[n]]):i.push(t[n]))}return i&&s.push(i),s}(l),r=0;r<l.length;r++)for(s=0;s<l[r].length;s++)h(l[r][s])}1===l.length?l=l[0]:c="Multi"+c;var p={type:"Feature",geometry:{type:c,coordinates:l},properties:this.properties};return"id"in this&&(p.id=this.id),p};var Xl=Zl,Kl=Yl;function Yl(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(Jl,this,e),this.length=this._features.length}function Jl(t,e,i){15===t?e.version=i.readVarint():1===t?e.name=i.readString():5===t?e.extent=i.readVarint():2===t?e._features.push(i.pos):3===t?e._keys.push(i.readString()):4===t&&e._values.push(function(t){for(var e=null,i=t.readVarint()+t.pos;t.pos<i;){var r=t.readVarint()>>3;e=1===r?t.readString():2===r?t.readFloat():3===r?t.readDouble():4===r?t.readVarint64():5===r?t.readVarint():6===r?t.readSVarint():7===r?t.readBoolean():null}return e}(i))}Yl.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new Xl(this._pbf,e,this.extent,this._keys,this._values)};var Ql=Kl;function tc(t,e,i){if(3===t){var r=new Ql(i,i.readVarint()+i.pos);r.length&&(e[r.name]=r)}}$l.VectorTile=function(t,e){this.layers=t.readFields(tc,{},e)},$l.VectorTileFeature=Zl,$l.VectorTileLayer=Kl;const ec=$l.VectorTileFeature.types,ic=Math.pow(2,13);function rc(t,e,i,r,s,n,a,o){t.emplaceBack(e,i,2*Math.floor(r*ic)+a,s*ic*2,n*ic*2,Math.round(o))}class sc{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new na,this.centroidVertexArray=new ta,this.indexArray=new _a,this.programConfigurations=new Ya(t.layers,t.zoom),this.segments=new ba,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.features=[],this.hasPattern=Dl("fill-extrusion",this.layers,e);for(const{feature:r,id:s,index:n,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,o=so(r,t);if(!this.layers[0]._featureFilter.filter(new Ks(this.zoom),o,i))continue;const l={id:s,sourceLayerIndex:a,index:n,geometry:t?o.geometry:ro(r),properties:r.properties,type:r.type,patterns:{}};this.hasPattern?this.features.push(Ll("fill-extrusion",this.layers,l,this.zoom,e)):this.addFeature(l,l.geometry,n,i,{}),e.featureIndex.insert(r,l.geometry,n,a,this.index,!0)}}addFeatures(t,e,i){for(const t of this.features){const{geometry:r}=t;this.addFeature(t,r,t.index,e,i)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,i)}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,jl),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Nl.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy())}addFeature(t,e,i,r,s){for(const i of Di(e,500)){const e={x:0,y:0,vertexCount:0};let r=0;for(const t of i)r+=t.length;let s=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray);for(const t of i){if(0===t.length)continue;if(ac(t))continue;let i=0;for(let r=0;r<t.length;r++){const n=t[r];if(r>=1){const a=t[r-1];if(!nc(n,a)){s.vertexLength+4>ba.MAX_VERTEX_ARRAY_LENGTH&&(s=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const t=n.sub(a)._perp()._unit(),r=a.dist(n);i+r>32768&&(i=0),rc(this.layoutVertexArray,n.x,n.y,t.x,t.y,0,0,i),rc(this.layoutVertexArray,n.x,n.y,t.x,t.y,0,1,i),e.x+=2*n.x,e.y+=2*n.y,e.vertexCount+=2,i+=r,rc(this.layoutVertexArray,a.x,a.y,t.x,t.y,0,0,i),rc(this.layoutVertexArray,a.x,a.y,t.x,t.y,0,1,i),e.x+=2*a.x,e.y+=2*a.y,e.vertexCount+=2;const o=s.vertexLength;this.indexArray.emplaceBack(o,o+2,o+1),this.indexArray.emplaceBack(o+1,o+2,o+3),s.vertexLength+=4,s.primitiveLength+=2}}}}if(s.vertexLength+r>ba.MAX_VERTEX_ARRAY_LENGTH&&(s=this.segments.prepareSegment(r,this.layoutVertexArray,this.indexArray)),"Polygon"!==ec[t.type])continue;const n=[],a=[],o=s.vertexLength;for(const t of i)if(0!==t.length){t!==i[0]&&a.push(n.length/2);for(let i=0;i<t.length;i++){const r=t[i];rc(this.layoutVertexArray,r.x,r.y,0,0,1,1,0),e.x+=r.x,e.y+=r.y,e.vertexCount+=1,n.push(r.x),n.push(r.y)}}const l=ll(n,a);for(let t=0;t<l.length;t+=3)this.indexArray.emplaceBack(o+l[t],o+l[t+2],o+l[t+1]);s.primitiveLength+=l.length/3,s.vertexLength+=r;for(let t=0;t<e.vertexCount;t++){const t=Math.floor(e.x/e.vertexCount),i=Math.floor(e.y/e.vertexCount);this.centroidVertexArray.emplaceBack(t,i)}}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,s,r)}}function nc(t,e){return t.x===e.x&&(t.x<0||t.x>to)||t.y===e.y&&(t.y<0||t.y>to)}function ac(t){return t.every((t=>t.x<0))||t.every((t=>t.x>to))||t.every((t=>t.y<0))||t.every((t=>t.y>to))}let oc;Ds("FillExtrusionBucket",sc,{omit:["layers","features"]});var lc={get paint(){return oc=oc||new un({"fill-extrusion-opacity":new an(at["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new on(at["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new an(at["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new an(at["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new ln(at["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new on(at["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new on(at["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new an(at["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class cc extends dn{constructor(t){super(t,lc)}createBucket(t){return new sc(t)}queryRadius(){return vo(this.paint.get("fill-extrusion-translate"))}is3D(){return!0}queryIntersectsFeature(t,e,i,r,s,n,o,l){const c=bo(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),n.angle,o),h=this.paint.get("fill-extrusion-height").evaluate(e,i),u=this.paint.get("fill-extrusion-base").evaluate(e,i),p=function(t,e,i,r){const s=[];for(const i of t){const t=[i.x,i.y,0,1];jo(t,t,e),s.push(new a(t[0]/t[3],t[1]/t[3]))}return s}(c,l),d=function(t,e,i,r){const s=[],n=[],o=r[8]*e,l=r[9]*e,c=r[10]*e,h=r[11]*e,u=r[8]*i,p=r[9]*i,d=r[10]*i,f=r[11]*i;for(const e of t){const t=[],i=[];for(const s of e){const e=s.x,n=s.y,m=r[0]*e+r[4]*n+r[12],_=r[1]*e+r[5]*n+r[13],g=r[2]*e+r[6]*n+r[14],y=r[3]*e+r[7]*n+r[15],x=g+c,v=y+h,b=m+u,w=_+p,T=g+d,S=y+f,I=new a((m+o)/v,(_+l)/v);I.z=x/v,t.push(I);const A=new a(b/S,w/S);A.z=T/S,i.push(A)}s.push(t),n.push(i)}return[s,n]}(r,u,h,l);return function(t,e,i){let r=1/0;co(i,e)&&(r=uc(i,e[0]));for(let s=0;s<e.length;s++){const n=e[s],a=t[s];for(let t=0;t<n.length-1;t++){const e=n[t],s=[e,n[t+1],a[t+1],a[t],e];oo(i,s)&&(r=Math.min(r,uc(i,s)))}}return r!==1/0&&r}(d[0],d[1],p)}}function hc(t,e){return t.x*e.x+t.y*e.y}function uc(t,e){if(1===t.length){let i=0;const r=e[i++];let s;for(;!s||r.equals(s);)if(s=e[i++],!s)return 1/0;for(;i<e.length;i++){const n=e[i],a=t[0],o=s.sub(r),l=n.sub(r),c=a.sub(r),h=hc(o,o),u=hc(o,l),p=hc(l,l),d=hc(c,o),f=hc(c,l),m=h*p-u*u,_=(p*d-u*f)/m,g=(h*f-u*d)/m,y=r.z*(1-_-g)+s.z*_+n.z*g;if(isFinite(y))return y}return 1/0}{let t=1/0;for(const i of e)t=Math.min(t,i.z);return t}}const pc=gn([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:dc}=pc,fc=gn([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:mc}=fc,_c=$l.VectorTileFeature.types,gc=Math.cos(Math.PI/180*37.5),yc=Math.pow(2,14)/.5;class xc{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={}})),this.layoutVertexArray=new aa,this.layoutVertexArray2=new oa,this.indexArray=new _a,this.programConfigurations=new Ya(t.layers,t.zoom),this.segments=new ba,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.hasPattern=Dl("line",this.layers,e);const r=this.layers[0].layout.get("line-sort-key"),s=!r.isConstant(),n=[];for(const{feature:e,id:a,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,c=so(e,t);if(!this.layers[0]._featureFilter.filter(new Ks(this.zoom),c,i))continue;const h=s?r.evaluate(c,{},i):void 0,u={id:a,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?c.geometry:ro(e),patterns:{},sortKey:h};n.push(u)}s&&n.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of n){const{geometry:s,index:n,sourceLayerIndex:a}=r;if(this.hasPattern){const t=Ll("line",this.layers,r,this.zoom,e);this.patternFeatures.push(t)}else this.addFeature(r,s,n,i,{});e.featureIndex.insert(t[n].feature,s,n,a,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,i)}addFeatures(t,e,i){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,i)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,mc)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,dc),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return{start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,i,r,s){const n=this.layers[0].layout,a=n.get("line-join").evaluate(t,{}),o=n.get("line-cap"),l=n.get("line-miter-limit"),c=n.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const i of e)this.addLine(i,t,a,o,l,c);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,s,r)}addLine(t,e,i,r,s,n){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance)}const a="Polygon"===_c[e.type];let o=t.length;for(;o>=2&&t[o-1].equals(t[o-2]);)o--;let l=0;for(;l<o-1&&t[l].equals(t[l+1]);)l++;if(o<(a?3:2))return;"bevel"===i&&(s=1.05);const c=this.overscaling<=16?15*to/(512*this.overscaling):0,h=this.segments.prepareSegment(10*o,this.layoutVertexArray,this.indexArray);let u,p,d,f,m;this.e1=this.e2=-1,a&&(u=t[o-2],m=t[l].sub(u)._unit()._perp());for(let e=l;e<o;e++){if(d=e===o-1?a?t[l+1]:void 0:t[e+1],d&&t[e].equals(d))continue;m&&(f=m),u&&(p=u),u=t[e],m=d?d.sub(u)._unit()._perp():f,f=f||m;let _=f.add(m);0===_.x&&0===_.y||_._unit();const g=f.x*m.x+f.y*m.y,y=_.x*m.x+_.y*m.y,x=0!==y?1/y:1/0,v=2*Math.sqrt(2-2*y),b=y<gc&&p&&d,w=f.x*m.y-f.y*m.x>0;if(b&&e>l){const t=u.dist(p);if(t>2*c){const e=u.sub(u.sub(p)._mult(c/t)._round());this.updateDistance(p,e),this.addCurrentVertex(e,f,0,0,h),p=e}}const T=p&&d;let S=T?i:a?"butt":r;if(T&&"round"===S&&(x<n?S="miter":x<=2&&(S="fakeround")),"miter"===S&&x>s&&(S="bevel"),"bevel"===S&&(x>2&&(S="flipbevel"),x<s&&(S="miter")),p&&this.updateDistance(p,u),"miter"===S)_._mult(x),this.addCurrentVertex(u,_,0,0,h);else if("flipbevel"===S){if(x>100)_=m.mult(-1);else{const t=x*f.add(m).mag()/f.sub(m).mag();_._perp()._mult(t*(w?-1:1))}this.addCurrentVertex(u,_,0,0,h),this.addCurrentVertex(u,_.mult(-1),0,0,h)}else if("bevel"===S||"fakeround"===S){const t=-Math.sqrt(x*x-1),e=w?t:0,i=w?0:t;if(p&&this.addCurrentVertex(u,f,e,i,h),"fakeround"===S){const t=Math.round(180*v/Math.PI/20);for(let e=1;e<t;e++){let i=e/t;if(.5!==i){const t=i-.5;i+=i*t*(i-1)*((1.0904+g*(g*(3.55645-1.43519*g)-3.2452))*t*t+(.848013+g*(.215638*g-1.06021)))}const r=m.sub(f)._mult(i)._add(f)._unit()._mult(w?-1:1);this.addHalfVertex(u,r.x,r.y,!1,w,0,h)}}d&&this.addCurrentVertex(u,m,-e,-i,h)}else if("butt"===S)this.addCurrentVertex(u,_,0,0,h);else if("square"===S){const t=p?1:-1;this.addCurrentVertex(u,_,t,t,h)}else"round"===S&&(p&&(this.addCurrentVertex(u,f,0,0,h),this.addCurrentVertex(u,f,1,1,h,!0)),d&&(this.addCurrentVertex(u,m,-1,-1,h,!0),this.addCurrentVertex(u,m,0,0,h)));if(b&&e<o-1){const t=u.dist(d);if(t>2*c){const e=u.add(d.sub(u)._mult(c/t)._round());this.updateDistance(u,e),this.addCurrentVertex(e,m,0,0,h),u=e}}}}addCurrentVertex(t,e,i,r,s,n=!1){const a=e.y*r-e.x,o=-e.y-e.x*r;this.addHalfVertex(t,e.x+e.y*i,e.y-e.x*i,n,!1,i,s),this.addHalfVertex(t,a,o,n,!0,-r,s),this.distance>yc/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,i,r,s,n))}addHalfVertex({x:t,y:e},i,r,s,n,a,o){const l=.5*(this.lineClips?this.scaledDistance*(yc-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(s?1:0),(e<<1)+(n?1:0),Math.round(63*i)+128,Math.round(63*r)+128,1+(0===a?0:a<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const c=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,c),o.primitiveLength++),n?this.e2=c:this.e1=c}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance()}}let vc,bc;Ds("LineBucket",xc,{omit:["layers","patternFeatures"]});var wc={get paint(){return bc=bc||new un({"line-opacity":new on(at.paint_line["line-opacity"]),"line-color":new on(at.paint_line["line-color"]),"line-translate":new an(at.paint_line["line-translate"]),"line-translate-anchor":new an(at.paint_line["line-translate-anchor"]),"line-width":new on(at.paint_line["line-width"]),"line-gap-width":new on(at.paint_line["line-gap-width"]),"line-offset":new on(at.paint_line["line-offset"]),"line-blur":new on(at.paint_line["line-blur"]),"line-dasharray":new cn(at.paint_line["line-dasharray"]),"line-pattern":new ln(at.paint_line["line-pattern"]),"line-gradient":new hn(at.paint_line["line-gradient"])})},get layout(){return vc=vc||new un({"line-cap":new an(at.layout_line["line-cap"]),"line-join":new on(at.layout_line["line-join"]),"line-miter-limit":new an(at.layout_line["line-miter-limit"]),"line-round-limit":new an(at.layout_line["line-round-limit"]),"line-sort-key":new on(at.layout_line["line-sort-key"])})}};class Tc extends on{possiblyEvaluate(t,e){return e=new Ks(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,i,r){return e=y({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,i,r)}}let Sc;class Ic extends dn{constructor(t){super(t,wc),this.gradientVersion=0,Sc||(Sc=new Tc(wc.paint.properties["line-width"].specification),Sc.useIntegerZoom=!0)}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof Oe,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=Sc.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t)}createBucket(t){return new xc(t)}queryRadius(t){const e=t,i=Ac(xo("line-width",this,e),xo("line-gap-width",this,e)),r=xo("line-offset",this,e);return i/2+Math.abs(r)+vo(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,i,r,s,n,o){const l=bo(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),n.angle,o),c=o/2*Ac(this.paint.get("line-width").evaluate(e,i),this.paint.get("line-gap-width").evaluate(e,i)),h=this.paint.get("line-offset").evaluate(e,i);return h&&(r=function(t,e){const i=[];for(let r=0;r<t.length;r++){const s=t[r],n=[];for(let t=0;t<s.length;t++){const i=s[t-1],r=s[t],o=s[t+1],l=0===t?new a(0,0):r.sub(i)._unit()._perp(),c=t===s.length-1?new a(0,0):o.sub(r)._unit()._perp(),h=l._add(c)._unit(),u=h.x*c.x+h.y*c.y;0!==u&&h._mult(1/u),n.push(h._mult(e)._add(r))}i.push(n)}return i}(r,h*o)),function(t,e,i){for(let r=0;r<e.length;r++){const s=e[r];if(t.length>=3)for(let e=0;e<s.length;e++)if(go(t,s[e]))return!0;if(ho(t,s,i))return!0}return!1}(l,r,c)}isTileClipped(){return!0}}function Ac(t,e){return e>0?e+2*t:t}const Cc=gn([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),Ec=gn([{name:"a_projected_pos",components:3,type:"Float32"}],4);gn([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const zc=gn([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);gn([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const Pc=gn([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),Mc=gn([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function kc(t,e,i){return t.sections.forEach((t=>{t.text=function(t,e,i){const r=e.layout.get("text-transform").evaluate(i,{});return"uppercase"===r?t=t.toLocaleUpperCase():"lowercase"===r&&(t=t.toLocaleLowerCase()),Xs.applyArabicShaping&&(t=Xs.applyArabicShaping(t)),t}(t.text,e,i)})),t}gn([{name:"triangle",components:3,type:"Uint16"}]),gn([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),gn([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),gn([{type:"Float32",name:"offsetX"}]),gn([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),gn([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const Dc={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var Lc=Fc,Rc=function(t,e,i,r,s){var n,a,o=8*s-r-1,l=(1<<o)-1,c=l>>1,h=-7,u=i?s-1:0,p=i?-1:1,d=t[e+u];for(u+=p,n=d&(1<<-h)-1,d>>=-h,h+=o;h>0;n=256*n+t[e+u],u+=p,h-=8);for(a=n&(1<<-h)-1,n>>=-h,h+=r;h>0;a=256*a+t[e+u],u+=p,h-=8);if(0===n)n=1-c;else{if(n===l)return a?NaN:1/0*(d?-1:1);a+=Math.pow(2,r),n-=c}return(d?-1:1)*a*Math.pow(2,n-r)},Bc=function(t,e,i,r,s,n){var a,o,l,c=8*n-s-1,h=(1<<c)-1,u=h>>1,p=23===s?Math.pow(2,-24)-Math.pow(2,-77):0,d=r?0:n-1,f=r?1:-1,m=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,a=h):(a=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-a))<1&&(a--,l*=2),(e+=a+u>=1?p/l:p*Math.pow(2,1-u))*l>=2&&(a++,l/=2),a+u>=h?(o=0,a=h):a+u>=1?(o=(e*l-1)*Math.pow(2,s),a+=u):(o=e*Math.pow(2,u-1)*Math.pow(2,s),a=0));s>=8;t[i+d]=255&o,d+=f,o/=256,s-=8);for(a=a<<s|o,c+=s;c>0;t[i+d]=255&a,d+=f,a/=256,c-=8);t[i+d-f]|=128*m};function Fc(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length}Fc.Varint=0,Fc.Fixed64=1,Fc.Bytes=2,Fc.Fixed32=5;var Oc=4294967296,Vc=1/Oc,Uc="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");function Nc(t){return t.type===Fc.Bytes?t.readVarint()+t.pos:t.pos+1}function jc(t,e,i){return i?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function $c(t,e,i){var r=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));i.realloc(r);for(var s=i.pos-1;s>=t;s--)i.buf[s+r]=i.buf[s]}function qc(t,e){for(var i=0;i<t.length;i++)e.writeVarint(t[i])}function Zc(t,e){for(var i=0;i<t.length;i++)e.writeSVarint(t[i])}function Gc(t,e){for(var i=0;i<t.length;i++)e.writeFloat(t[i])}function Wc(t,e){for(var i=0;i<t.length;i++)e.writeDouble(t[i])}function Hc(t,e){for(var i=0;i<t.length;i++)e.writeBoolean(t[i])}function Xc(t,e){for(var i=0;i<t.length;i++)e.writeFixed32(t[i])}function Kc(t,e){for(var i=0;i<t.length;i++)e.writeSFixed32(t[i])}function Yc(t,e){for(var i=0;i<t.length;i++)e.writeFixed64(t[i])}function Jc(t,e){for(var i=0;i<t.length;i++)e.writeSFixed64(t[i])}function Qc(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function th(t,e,i){t[i]=e,t[i+1]=e>>>8,t[i+2]=e>>>16,t[i+3]=e>>>24}function eh(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}Fc.prototype={destroy:function(){this.buf=null},readFields:function(t,e,i){for(i=i||this.length;this.pos<i;){var r=this.readVarint(),s=r>>3,n=this.pos;this.type=7&r,t(s,e,this),this.pos===n&&this.skip(r)}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=Qc(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=eh(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=Qc(this.buf,this.pos)+Qc(this.buf,this.pos+4)*Oc;return this.pos+=8,t},readSFixed64:function(){var t=Qc(this.buf,this.pos)+eh(this.buf,this.pos+4)*Oc;return this.pos+=8,t},readFloat:function(){var t=Rc(this.buf,this.pos,!0,23,4);return this.pos+=4,t},readDouble:function(){var t=Rc(this.buf,this.pos,!0,52,8);return this.pos+=8,t},readVarint:function(t){var e,i,r=this.buf;return e=127&(i=r[this.pos++]),i<128?e:(e|=(127&(i=r[this.pos++]))<<7,i<128?e:(e|=(127&(i=r[this.pos++]))<<14,i<128?e:(e|=(127&(i=r[this.pos++]))<<21,i<128?e:function(t,e,i){var r,s,n=i.buf;if(r=(112&(s=n[i.pos++]))>>4,s<128)return jc(t,r,e);if(r|=(127&(s=n[i.pos++]))<<3,s<128)return jc(t,r,e);if(r|=(127&(s=n[i.pos++]))<<10,s<128)return jc(t,r,e);if(r|=(127&(s=n[i.pos++]))<<17,s<128)return jc(t,r,e);if(r|=(127&(s=n[i.pos++]))<<24,s<128)return jc(t,r,e);if(r|=(1&(s=n[i.pos++]))<<31,s<128)return jc(t,r,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(i=r[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&Uc?function(t,e,i){return Uc.decode(t.subarray(e,i))}(this.buf,e,t):function(t,e,i){for(var r="",s=e;s<i;){var n,a,o,l=t[s],c=null,h=l>239?4:l>223?3:l>191?2:1;if(s+h>i)break;1===h?l<128&&(c=l):2===h?128==(192&(n=t[s+1]))&&(c=(31&l)<<6|63&n)<=127&&(c=null):3===h?(a=t[s+2],128==(192&(n=t[s+1]))&&128==(192&a)&&((c=(15&l)<<12|(63&n)<<6|63&a)<=2047||c>=55296&&c<=57343)&&(c=null)):4===h&&(a=t[s+2],o=t[s+3],128==(192&(n=t[s+1]))&&128==(192&a)&&128==(192&o)&&((c=(15&l)<<18|(63&n)<<12|(63&a)<<6|63&o)<=65535||c>=1114112)&&(c=null)),null===c?(c=65533,h=1):c>65535&&(c-=65536,r+=String.fromCharCode(c>>>10&1023|55296),c=56320|1023&c),r+=String.fromCharCode(c),s+=h}return r}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,e){if(this.type!==Fc.Bytes)return t.push(this.readVarint(e));var i=Nc(this);for(t=t||[];this.pos<i;)t.push(this.readVarint(e));return t},readPackedSVarint:function(t){if(this.type!==Fc.Bytes)return t.push(this.readSVarint());var e=Nc(this);for(t=t||[];this.pos<e;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==Fc.Bytes)return t.push(this.readBoolean());var e=Nc(this);for(t=t||[];this.pos<e;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==Fc.Bytes)return t.push(this.readFloat());var e=Nc(this);for(t=t||[];this.pos<e;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==Fc.Bytes)return t.push(this.readDouble());var e=Nc(this);for(t=t||[];this.pos<e;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==Fc.Bytes)return t.push(this.readFixed32());var e=Nc(this);for(t=t||[];this.pos<e;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==Fc.Bytes)return t.push(this.readSFixed32());var e=Nc(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==Fc.Bytes)return t.push(this.readFixed64());var e=Nc(this);for(t=t||[];this.pos<e;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==Fc.Bytes)return t.push(this.readSFixed64());var e=Nc(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed64());return t},skip:function(t){var e=7&t;if(e===Fc.Varint)for(;this.buf[this.pos++]>127;);else if(e===Fc.Bytes)this.pos=this.readVarint()+this.pos;else if(e===Fc.Fixed32)this.pos+=4;else{if(e!==Fc.Fixed64)throw new Error("Unimplemented type: "+e);this.pos+=8}},writeTag:function(t,e){this.writeVarint(t<<3|e)},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var i=new Uint8Array(e);i.set(this.buf),this.buf=i,this.length=e}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),th(this.buf,t,this.pos),this.pos+=4},writeSFixed32:function(t){this.realloc(4),th(this.buf,t,this.pos),this.pos+=4},writeFixed64:function(t){this.realloc(8),th(this.buf,-1&t,this.pos),th(this.buf,Math.floor(t*Vc),this.pos+4),this.pos+=8},writeSFixed64:function(t){this.realloc(8),th(this.buf,-1&t,this.pos),th(this.buf,Math.floor(t*Vc),this.pos+4),this.pos+=8},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var i,r;if(t>=0?(i=t%4294967296|0,r=t/4294967296|0):(r=~(-t/4294967296),4294967295^(i=~(-t%4294967296))?i=i+1|0:(i=0,r=r+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,i){i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,i.buf[i.pos]=127&(t>>>=7)}(i,0,e),function(t,e){var i=(7&t)<<4;e.buf[e.pos++]|=i|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))))}(r,e)}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))))},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t)},writeBoolean:function(t){this.writeVarint(Boolean(t))},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,i){for(var r,s,n=0;n<e.length;n++){if((r=e.charCodeAt(n))>55295&&r<57344){if(!s){r>56319||n+1===e.length?(t[i++]=239,t[i++]=191,t[i++]=189):s=r;continue}if(r<56320){t[i++]=239,t[i++]=191,t[i++]=189,s=r;continue}r=s-55296<<10|r-56320|65536,s=null}else s&&(t[i++]=239,t[i++]=191,t[i++]=189,s=null);r<128?t[i++]=r:(r<2048?t[i++]=r>>6|192:(r<65536?t[i++]=r>>12|224:(t[i++]=r>>18|240,t[i++]=r>>12&63|128),t[i++]=r>>6&63|128),t[i++]=63&r|128)}return i}(this.buf,t,this.pos);var i=this.pos-e;i>=128&&$c(e,i,this),this.pos=e-1,this.writeVarint(i),this.pos+=i},writeFloat:function(t){this.realloc(4),Bc(this.buf,t,this.pos,!0,23,4),this.pos+=4},writeDouble:function(t){this.realloc(8),Bc(this.buf,t,this.pos,!0,52,8),this.pos+=8},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var i=0;i<e;i++)this.buf[this.pos++]=t[i]},writeRawMessage:function(t,e){this.pos++;var i=this.pos;t(e,this);var r=this.pos-i;r>=128&&$c(i,r,this),this.pos=i-1,this.writeVarint(r),this.pos+=r},writeMessage:function(t,e,i){this.writeTag(t,Fc.Bytes),this.writeRawMessage(e,i)},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,qc,e)},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,Zc,e)},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,Hc,e)},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,Gc,e)},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,Wc,e)},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,Xc,e)},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,Kc,e)},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,Yc,e)},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,Jc,e)},writeBytesField:function(t,e){this.writeTag(t,Fc.Bytes),this.writeBytes(e)},writeFixed32Field:function(t,e){this.writeTag(t,Fc.Fixed32),this.writeFixed32(e)},writeSFixed32Field:function(t,e){this.writeTag(t,Fc.Fixed32),this.writeSFixed32(e)},writeFixed64Field:function(t,e){this.writeTag(t,Fc.Fixed64),this.writeFixed64(e)},writeSFixed64Field:function(t,e){this.writeTag(t,Fc.Fixed64),this.writeSFixed64(e)},writeVarintField:function(t,e){this.writeTag(t,Fc.Varint),this.writeVarint(e)},writeSVarintField:function(t,e){this.writeTag(t,Fc.Varint),this.writeSVarint(e)},writeStringField:function(t,e){this.writeTag(t,Fc.Bytes),this.writeString(e)},writeFloatField:function(t,e){this.writeTag(t,Fc.Fixed32),this.writeFloat(e)},writeDoubleField:function(t,e){this.writeTag(t,Fc.Fixed64),this.writeDouble(e)},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e))}};var ih=r(Lc);const rh=3;function sh(t,e,i){1===t&&i.readMessage(nh,e)}function nh(t,e,i){if(3===t){const{id:t,bitmap:r,width:s,height:n,left:a,top:o,advance:l}=i.readMessage(ah,{});e.push({id:t,bitmap:new Jo({width:s+2*rh,height:n+2*rh},r),metrics:{width:s,height:n,left:a,top:o,advance:l}})}}function ah(t,e,i){1===t?e.id=i.readVarint():2===t?e.bitmap=i.readBytes():3===t?e.width=i.readVarint():4===t?e.height=i.readVarint():5===t?e.left=i.readSVarint():6===t?e.top=i.readSVarint():7===t&&(e.advance=i.readVarint())}function oh(t){let e=0,i=0;for(const r of t)e+=r.w*r.h,i=Math.max(i,r.w);t.sort(((t,e)=>e.h-t.h));const r=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),i),h:1/0}];let s=0,n=0;for(const e of t)for(let t=r.length-1;t>=0;t--){const i=r[t];if(!(e.w>i.w||e.h>i.h)){if(e.x=i.x,e.y=i.y,n=Math.max(n,e.y+e.h),s=Math.max(s,e.x+e.w),e.w===i.w&&e.h===i.h){const e=r.pop();t<r.length&&(r[t]=e)}else e.h===i.h?(i.x+=e.w,i.w-=e.w):e.w===i.w?(i.y+=e.h,i.h-=e.h):(r.push({x:i.x+e.w,y:i.y,w:i.w-e.w,h:e.h}),i.y+=e.h,i.h-=e.h);break}}return{w:s,h:n,fill:e/(s*n)||0}}class lh{constructor(t,{pixelRatio:e,version:i,stretchX:r,stretchY:s,content:n,textFitWidth:a,textFitHeight:o}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=r,this.stretchY=s,this.content=n,this.version=i,this.textFitWidth=a,this.textFitHeight=o}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}var ch;function hh(t){let e=.5,i=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0}switch(t){case"bottom":case"bottom-right":case"bottom-left":i=1;break;case"top":case"top-right":case"top-left":i=0}return{horizontalAlign:e,verticalAlign:i}}Ds("ImagePosition",lh),Ds("ImageAtlas",class{constructor(t,e){const i={},r={};this.haveRenderCallbacks=[];const s=[];this.addImages(t,i,s),this.addImages(e,r,s);const{w:n,h:a}=oh(s),o=new Qo({width:n||1,height:a||1});for(const e in t){const r=t[e],s=i[e].paddedRect;Qo.copy(r.data,o,{x:0,y:0},{x:s.x+1,y:s.y+1},r.data)}for(const t in e){const i=e[t],s=r[t].paddedRect,n=s.x+1,a=s.y+1,l=i.data.width,c=i.data.height;Qo.copy(i.data,o,{x:0,y:0},{x:n,y:a},i.data),Qo.copy(i.data,o,{x:0,y:c-1},{x:n,y:a-1},{width:l,height:1}),Qo.copy(i.data,o,{x:0,y:0},{x:n,y:a+c},{width:l,height:1}),Qo.copy(i.data,o,{x:l-1,y:0},{x:n-1,y:a},{width:1,height:c}),Qo.copy(i.data,o,{x:0,y:0},{x:n+l,y:a},{width:1,height:c})}this.image=o,this.iconPositions=i,this.patternPositions=r}addImages(t,e,i){for(const r in t){const s=t[r],n={x:0,y:0,w:s.data.width+2,h:s.data.height+2};i.push(n),e[r]=new lh(n,s),s.hasRenderCallback&&this.haveRenderCallbacks.push(r)}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const i in t.updatedImages)this.patchUpdatedImage(this.iconPositions[i],t.getImage(i),e),this.patchUpdatedImage(this.patternPositions[i],t.getImage(i),e)}patchUpdatedImage(t,e,i){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[r,s]=t.tl;i.update(e.data,void 0,{x:r,y:s})}}),function(t){t[t.none=0]="none",t[t.horizontal=1]="horizontal",t[t.vertical=2]="vertical",t[t.horizontalOnly=3]="horizontalOnly"}(ch||(ch={}));const uh=128,ph=255*uh;function dh(t,e){const{expression:i}=e;if("constant"===i.kind)return{kind:"constant",layoutSize:i.evaluate(new Ks(t+1))};if("source"===i.kind)return{kind:"source"};{const{zoomStops:e,interpolationType:r}=i;let s=0;for(;s<e.length&&e[s]<=t;)s++;s=Math.max(0,s-1);let n=s;for(;n<e.length&&e[n]<t+1;)n++;n=Math.min(e.length-1,n);const a=e[s],o=e[n];return"composite"===i.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:r}:{kind:"camera",minZoom:a,maxZoom:o,minSize:i.evaluate(new Ks(a)),maxSize:i.evaluate(new Ks(o)),interpolationType:r}}}function fh(t,{uSize:e,uSizeT:i},{lowerSize:r,upperSize:s}){return"source"===t.kind?r/uh:"composite"===t.kind?Ze.number(r/uh,s/uh,i):e}function mh(t,e){let i=0,r=0;if("constant"===t.kind)r=t.layoutSize;else if("source"!==t.kind){const{interpolationType:s,minZoom:n,maxZoom:a}=t,o=s?_(Ge.interpolationFactor(s,e,n,a),0,1):0;"camera"===t.kind?r=Ze.number(t.minSize,t.maxSize,o):i=o}return{uSizeT:i,uSize:r}}function _h(t,e,i){let r="never";const s=t.get(e);return s?r=s:t.get(i)&&(r="always"),r}const gh=$l.VectorTileFeature.types,yh=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function xh(t,e,i,r,s,n,a,o,l,c,h,u,p){const d=o?Math.min(ph,Math.round(o[0])):0,f=o?Math.min(ph,Math.round(o[1])):0;t.emplaceBack(e,i,Math.round(32*r),Math.round(32*s),n,a,(d<<1)+(l?1:0),f,16*c,16*h,256*u,256*p)}function vh(t,e,i){t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i)}function bh(t){for(const e of t.sections)if(Hs(e.text))return!0;return!1}class wh{constructor(t){this.layoutVertexArray=new ca,this.indexArray=new _a,this.programConfigurations=t,this.segments=new ba,this.dynamicLayoutVertexArray=new ha,this.opacityVertexArray=new ua,this.hasVisibleVertices=!1,this.placedSymbolArray=new Zn}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,i,r){this.isEmpty()||(i&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Cc.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,Ec.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,yh,!0),this.opacityVertexBuffer.itemSize=1),(i||r)&&this.programConfigurations.upload(t))}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy())}}Ds("SymbolBuffers",wh);class Th{constructor(t,e,i){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new i,this.segments=new ba,this.collisionVertexArray=new fa}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,zc.members,!0)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy())}}Ds("CollisionBuffers",Th);class Sh{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=zo([]),this.placementViewportMatrix=zo([]);const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=dh(this.zoom,e["text-size"]),this.iconSizeData=dh(this.zoom,e["icon-size"]);const i=this.layers[0].layout,r=i.get("symbol-sort-key"),s=i.get("symbol-z-order");this.canOverlap="never"!==_h(i,"text-overlap","text-allow-overlap")||"never"!==_h(i,"icon-overlap","icon-allow-overlap")||i.get("text-ignore-placement")||i.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==s&&!r.isConstant(),this.sortFeaturesByY=("viewport-y"===s||"auto"===s&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===i.get("symbol-placement")&&(this.writingModes=i.get("text-writing-mode").map((t=>ch[t]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID}createArrays(){this.text=new wh(new Ya(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new wh(new Ya(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Hn,this.lineVertexArray=new Xn,this.symbolInstances=new Wn,this.textAnchorOffsets=new Yn}calculateGlyphDependencies(t,e,i,r,s){for(let n=0;n<t.length;n++)if(e[t.charCodeAt(n)]=!0,(i||r)&&s){const i=Dc[t.charAt(n)];i&&(e[i.charCodeAt(0)]=!0)}}populate(t,e,i){const r=this.layers[0],s=r.layout,n=s.get("text-font"),a=s.get("text-field"),o=s.get("icon-image"),l=("constant"!==a.value.kind||a.value.value instanceof ue&&!a.value.value.isEmpty()||a.value.value.toString().length>0)&&("constant"!==n.value.kind||n.value.value.length>0),c="constant"!==o.value.kind||!!o.value.value||Object.keys(o.parameters).length>0,h=s.get("symbol-sort-key");if(this.features=[],!l&&!c)return;const u=e.iconDependencies,p=e.glyphDependencies,d=e.availableImages,f=new Ks(this.zoom);for(const{feature:e,id:a,index:o,sourceLayerIndex:m}of t){const t=r._featureFilter.needGeometry,_=so(e,t);if(!r._featureFilter.filter(f,_,i))continue;let g,y;if(t||(_.geometry=ro(e)),l){const t=r.getValueAndResolveTokens("text-field",_,i,d),e=ue.factory(t),s=this.hasRTLText=this.hasRTLText||bh(e);(!s||"unavailable"===Xs.getRTLTextPluginStatus()||s&&Xs.isParsed())&&(g=kc(e,r,_))}if(c){const t=r.getValueAndResolveTokens("icon-image",_,i,d);y=t instanceof me?t:me.fromString(t)}if(!g&&!y)continue;const x=this.sortFeaturesByKey?h.evaluate(_,{},i):void 0;if(this.features.push({id:a,text:g,icon:y,index:o,sourceLayerIndex:m,geometry:_.geometry,properties:e.properties,type:gh[e.type],sortKey:x}),y&&(u[y.name]=!0),g){const t=n.evaluate(_,{},i).join(","),e="viewport"!==s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(ch.vertical)>=0;for(const i of g.sections)if(i.image)u[i.image.name]=!0;else{const r=Ns(g.toString()),s=i.fontStack||t,n=p[s]=p[s]||{};this.calculateGlyphDependencies(i.text,n,e,this.allowVerticalPlacement,r)}}}"line"===s.get("symbol-placement")&&(this.features=function(t){const e={},i={},r=[];let s=0;function n(e){r.push(t[e]),s++}function a(t,e,s){const n=i[t];return delete i[t],i[e]=n,r[n].geometry[0].pop(),r[n].geometry[0]=r[n].geometry[0].concat(s[0]),n}function o(t,i,s){const n=e[i];return delete e[i],e[t]=n,r[n].geometry[0].shift(),r[n].geometry[0]=s[0].concat(r[n].geometry[0]),n}function l(t,e,i){const r=i?e[0][e[0].length-1]:e[0][0];return`${t}:${r.x}:${r.y}`}for(let c=0;c<t.length;c++){const h=t[c],u=h.geometry,p=h.text?h.text.toString():null;if(!p){n(c);continue}const d=l(p,u),f=l(p,u,!0);if(d in i&&f in e&&i[d]!==e[f]){const t=o(d,f,u),s=a(d,f,r[t].geometry);delete e[d],delete i[f],i[l(p,r[s].geometry,!0)]=s,r[t].geometry=null}else d in i?a(d,f,u):f in e?o(d,f,u):(n(c),e[d]=s-1,i[f]=s-1)}return r.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey))}update(t,e,i){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,i),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,i))}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy()}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData()}addToLineVertexArray(t,e){const i=this.lineVertexArray.length;if(void 0!==t.segment){let i=t.dist(e[t.segment+1]),r=t.dist(e[t.segment]);const s={};for(let r=t.segment+1;r<e.length;r++)s[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:i},r<e.length-1&&(i+=e[r+1].dist(e[r]));for(let i=t.segment||0;i>=0;i--)s[i]={x:e[i].x,y:e[i].y,tileUnitDistanceFromAnchor:r},i>0&&(r+=e[i-1].dist(e[i]));for(let t=0;t<e.length;t++){const e=s[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor)}}return{lineStartIndex:i,lineLength:this.lineVertexArray.length-i}}addSymbols(t,e,i,r,s,n,a,o,l,c,h,u){const p=t.indexArray,d=t.layoutVertexArray,f=t.segments.prepareSegment(4*e.length,d,p,this.canOverlap?n.sortKey:void 0),m=this.glyphOffsetArray.length,_=f.vertexLength,g=this.allowVerticalPlacement&&a===ch.vertical?Math.PI/2:0,y=n.text&&n.text.sections;for(let r=0;r<e.length;r++){const{tl:s,tr:a,bl:l,br:c,tex:h,pixelOffsetTL:m,pixelOffsetBR:_,minFontScaleX:x,minFontScaleY:v,glyphOffset:b,isSDF:w,sectionIndex:T}=e[r],S=f.vertexLength,I=b[1];xh(d,o.x,o.y,s.x,I+s.y,h.x,h.y,i,w,m.x,m.y,x,v),xh(d,o.x,o.y,a.x,I+a.y,h.x+h.w,h.y,i,w,_.x,m.y,x,v),xh(d,o.x,o.y,l.x,I+l.y,h.x,h.y+h.h,i,w,m.x,_.y,x,v),xh(d,o.x,o.y,c.x,I+c.y,h.x+h.w,h.y+h.h,i,w,_.x,_.y,x,v),vh(t.dynamicLayoutVertexArray,o,g),p.emplaceBack(S,S+1,S+2),p.emplaceBack(S+1,S+2,S+3),f.vertexLength+=4,f.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(b[0]),r!==e.length-1&&T===e[r+1].sectionIndex||t.programConfigurations.populatePaintArrays(d.length,n,n.index,{},u,y&&y[T])}t.placedSymbolArray.emplaceBack(o.x,o.y,m,this.glyphOffsetArray.length-m,_,l,c,o.segment,i?i[0]:0,i?i[1]:0,r[0],r[1],a,0,!1,0,h)}_addCollisionDebugVertex(t,e,i,r,s,n){return e.emplaceBack(0,0),t.emplaceBack(i.x,i.y,r,s,Math.round(n.x),Math.round(n.y))}addCollisionDebugVertices(t,e,i,r,s,n,o){const l=s.segments.prepareSegment(4,s.layoutVertexArray,s.indexArray),c=l.vertexLength,h=s.layoutVertexArray,u=s.collisionVertexArray,p=o.anchorX,d=o.anchorY;this._addCollisionDebugVertex(h,u,n,p,d,new a(t,e)),this._addCollisionDebugVertex(h,u,n,p,d,new a(i,e)),this._addCollisionDebugVertex(h,u,n,p,d,new a(i,r)),this._addCollisionDebugVertex(h,u,n,p,d,new a(t,r)),l.vertexLength+=4;const f=s.indexArray;f.emplaceBack(c,c+1),f.emplaceBack(c+1,c+2),f.emplaceBack(c+2,c+3),f.emplaceBack(c+3,c),l.primitiveLength+=4}addDebugCollisionBoxes(t,e,i,r){for(let s=t;s<e;s++){const t=this.collisionBoxArray.get(s);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,r?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,i)}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new Th(pa,Pc.members,ga),this.iconCollisionBox=new Th(pa,Pc.members,ga);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1)}}_deserializeCollisionBoxesForSymbol(t,e,i,r,s,n,a,o,l){const c={};for(let r=e;r<i;r++){const e=t.get(r);c.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},c.textFeatureIndex=e.featureIndex;break}for(let e=r;e<s;e++){const i=t.get(e);c.verticalTextBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.verticalTextFeatureIndex=i.featureIndex;break}for(let e=n;e<a;e++){const i=t.get(e);c.iconBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.iconFeatureIndex=i.featureIndex;break}for(let e=o;e<l;e++){const i=t.get(e);c.verticalIconBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.verticalIconFeatureIndex=i.featureIndex;break}return c}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const i=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,i.textBoxStartIndex,i.textBoxEndIndex,i.verticalTextBoxStartIndex,i.verticalTextBoxEndIndex,i.iconBoxStartIndex,i.iconBoxEndIndex,i.verticalIconBoxStartIndex,i.verticalIconBoxEndIndex))}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const i=t.placedSymbolArray.get(e),r=i.vertexStartIndex+4*i.numGlyphs;for(let e=i.vertexStartIndex;e<r;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3)}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),i=Math.cos(t),r=[],s=[],n=[];for(let t=0;t<this.symbolInstances.length;++t){n.push(t);const a=this.symbolInstances.get(t);r.push(0|Math.round(e*a.anchorX+i*a.anchorY)),s.push(a.featureIndex)}return n.sort(((t,e)=>r[t]-r[e]||s[e]-s[t])),n}addToSortKeyRanges(t,e){const i=this.sortKeyRanges[this.sortKeyRanges.length-1];i&&i.sortKey===e?i.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1})}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,i)=>{t>=0&&i.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t)})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex)}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray)}}}let Ih,Ah;Ds("SymbolBucket",Sh,{omit:["layers","collisionBoxArray","features","compareText"]}),Sh.MAX_GLYPHS=65535,Sh.addDynamicAttributes=vh;var Ch={get paint(){return Ah=Ah||new un({"icon-opacity":new on(at.paint_symbol["icon-opacity"]),"icon-color":new on(at.paint_symbol["icon-color"]),"icon-halo-color":new on(at.paint_symbol["icon-halo-color"]),"icon-halo-width":new on(at.paint_symbol["icon-halo-width"]),"icon-halo-blur":new on(at.paint_symbol["icon-halo-blur"]),"icon-translate":new an(at.paint_symbol["icon-translate"]),"icon-translate-anchor":new an(at.paint_symbol["icon-translate-anchor"]),"text-opacity":new on(at.paint_symbol["text-opacity"]),"text-color":new on(at.paint_symbol["text-color"],{runtimeType:Ct,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new on(at.paint_symbol["text-halo-color"]),"text-halo-width":new on(at.paint_symbol["text-halo-width"]),"text-halo-blur":new on(at.paint_symbol["text-halo-blur"]),"text-translate":new an(at.paint_symbol["text-translate"]),"text-translate-anchor":new an(at.paint_symbol["text-translate-anchor"])})},get layout(){return Ih=Ih||new un({"symbol-placement":new an(at.layout_symbol["symbol-placement"]),"symbol-spacing":new an(at.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new an(at.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new on(at.layout_symbol["symbol-sort-key"]),"symbol-z-order":new an(at.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new an(at.layout_symbol["icon-allow-overlap"]),"icon-overlap":new an(at.layout_symbol["icon-overlap"]),"icon-ignore-placement":new an(at.layout_symbol["icon-ignore-placement"]),"icon-optional":new an(at.layout_symbol["icon-optional"]),"icon-rotation-alignment":new an(at.layout_symbol["icon-rotation-alignment"]),"icon-size":new on(at.layout_symbol["icon-size"]),"icon-text-fit":new an(at.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new an(at.layout_symbol["icon-text-fit-padding"]),"icon-image":new on(at.layout_symbol["icon-image"]),"icon-rotate":new on(at.layout_symbol["icon-rotate"]),"icon-padding":new on(at.layout_symbol["icon-padding"]),"icon-keep-upright":new an(at.layout_symbol["icon-keep-upright"]),"icon-offset":new on(at.layout_symbol["icon-offset"]),"icon-anchor":new on(at.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new an(at.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new an(at.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new an(at.layout_symbol["text-rotation-alignment"]),"text-field":new on(at.layout_symbol["text-field"]),"text-font":new on(at.layout_symbol["text-font"]),"text-size":new on(at.layout_symbol["text-size"]),"text-max-width":new on(at.layout_symbol["text-max-width"]),"text-line-height":new an(at.layout_symbol["text-line-height"]),"text-letter-spacing":new on(at.layout_symbol["text-letter-spacing"]),"text-justify":new on(at.layout_symbol["text-justify"]),"text-radial-offset":new on(at.layout_symbol["text-radial-offset"]),"text-variable-anchor":new an(at.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new on(at.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new on(at.layout_symbol["text-anchor"]),"text-max-angle":new an(at.layout_symbol["text-max-angle"]),"text-writing-mode":new an(at.layout_symbol["text-writing-mode"]),"text-rotate":new on(at.layout_symbol["text-rotate"]),"text-padding":new an(at.layout_symbol["text-padding"]),"text-keep-upright":new an(at.layout_symbol["text-keep-upright"]),"text-transform":new on(at.layout_symbol["text-transform"]),"text-offset":new on(at.layout_symbol["text-offset"]),"text-allow-overlap":new an(at.layout_symbol["text-allow-overlap"]),"text-overlap":new an(at.layout_symbol["text-overlap"]),"text-ignore-placement":new an(at.layout_symbol["text-ignore-placement"]),"text-optional":new an(at.layout_symbol["text-optional"])})}};class Eh{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:Tt,this.defaultValue=t}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression)}outputDefined(){return!1}serialize(){return null}}Ds("FormatSectionOverride",Eh,{omit:["defaultValue"]});class zh extends dn{constructor(t){super(t,Ch)}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const i of t)e.indexOf(i)<0&&e.push(i);this.layout._values["text-writing-mode"]=e}else this.layout._values["text-writing-mode"]=["horizontal"]}this._setPaintOverrides()}getValueAndResolveTokens(t,e,i,r){const s=this.layout.get(t).evaluate(e,{},i,r),n=this._unevaluatedLayout._values[t];return n.isDataDriven()||Dr(n.value)||!s?s:function(t,e){return e.replace(/{([^{}]+)}/g,((e,i)=>t&&i in t?String(t[i]):""))}(e.properties,s)}createBucket(t){return new Sh(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of Ch.paint.overridableProperties){if(!zh.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),i=new Eh(e),r=new kr(i,e.property.specification);let s=null;s="constant"===e.value.kind||"source"===e.value.kind?new Rr("source",r):new Br("composite",r,e.value.zoomStops),this.paint._values[t]=new sn(e.property,s,e.parameters)}}_handleOverridablePaintPropertyUpdate(t,e,i){return!(!this.layout||e.isDataDriven()||i.isDataDriven())&&zh.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const i=t.get("text-field"),r=Ch.paint.properties[e];let s=!1;const n=t=>{for(const e of t)if(r.overrides&&r.overrides.hasOverride(e))return void(s=!0)};if("constant"===i.value.kind&&i.value.value instanceof ue)n(i.value.value.sections);else if("source"===i.value.kind){const t=e=>{s||(e instanceof ve&&ye(e.value)===Mt?n(e.value.sections):e instanceof ai?n(e.sections):e.eachChild(t))},e=i.value;e._styleExpression&&t(e._styleExpression.expression)}return s}}let Ph;var Mh={get paint(){return Ph=Ph||new un({"background-color":new an(at.paint_background["background-color"]),"background-pattern":new cn(at.paint_background["background-pattern"]),"background-opacity":new an(at.paint_background["background-opacity"])})}};class kh extends dn{constructor(t){super(t,Mh)}}let Dh;var Lh={get paint(){return Dh=Dh||new un({"raster-opacity":new an(at.paint_raster["raster-opacity"]),"raster-hue-rotate":new an(at.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new an(at.paint_raster["raster-brightness-min"]),"raster-brightness-max":new an(at.paint_raster["raster-brightness-max"]),"raster-saturation":new an(at.paint_raster["raster-saturation"]),"raster-contrast":new an(at.paint_raster["raster-contrast"]),"raster-resampling":new an(at.paint_raster["raster-resampling"]),"raster-fade-duration":new an(at.paint_raster["raster-fade-duration"])})}};class Rh extends dn{constructor(t){super(t,Lh)}}class Bh extends dn{constructor(t){super(t,{}),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl)},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl)},this.implementation=t}is3D(){return"3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return!1}serialize(){throw new Error("Custom layers cannot be serialized")}}function Fh(t){if("custom"===t.type)return new Bh(t);switch(t.type){case"background":return new kh(t);case"circle":return new qo(t);case"fill":return new Vl(t);case"fill-extrusion":return new cc(t);case"heatmap":return new il(t);case"hillshade":return new nl(t);case"line":return new Ic(t);case"raster":return new Rh(t);case"symbol":return new zh(t)}}function Oh(t){const e=[];if("string"==typeof t)e.push({id:"default",url:t});else if(t&&t.length>0){const i=[];for(const{id:r,url:s}of t){const t=`${r}${s}`;-1===i.indexOf(t)&&(i.push(t),e.push({id:r,url:s}))}}return e}function Vh(t,e,i){const r=t.split("?");return r[0]+=`${e}${i}`,r.join("?")}class Uh{constructor(t,e,i,r){this.context=t,this.format=i,this.texture=t.gl.createTexture(),this.update(e,r)}update(t,e,i){const{width:r,height:s}=t,n=!(this.size&&this.size[0]===r&&this.size[1]===s||i),{context:a}=this,{gl:o}=a;if(this.useMipmap=Boolean(e&&e.useMipmap),o.bindTexture(o.TEXTURE_2D,this.texture),a.pixelStoreUnpackFlipY.set(!1),a.pixelStoreUnpack.set(1),a.pixelStoreUnpackPremultiplyAlpha.set(this.format===o.RGBA&&(!e||!1!==e.premultiply)),n)this.size=[r,s],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||M(t)?o.texImage2D(o.TEXTURE_2D,0,this.format,this.format,o.UNSIGNED_BYTE,t):o.texImage2D(o.TEXTURE_2D,0,this.format,r,s,0,this.format,o.UNSIGNED_BYTE,t.data);else{const{x:e,y:n}=i||{x:0,y:0};t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||M(t)?o.texSubImage2D(o.TEXTURE_2D,0,e,n,o.RGBA,o.UNSIGNED_BYTE,t):o.texSubImage2D(o.TEXTURE_2D,0,e,n,r,s,o.RGBA,o.UNSIGNED_BYTE,t.data)}this.useMipmap&&this.isSizePowerOfTwo()&&o.generateMipmap(o.TEXTURE_2D)}bind(t,e,i){const{context:r}=this,{gl:s}=r;s.bindTexture(s.TEXTURE_2D,this.texture),i!==s.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(i=s.LINEAR),t!==this.filter&&(s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,t),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,i||t),this.filter=t),e!==this.wrap&&(s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,e),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,e),this.wrap=e)}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null}}function Nh(t){const{userImage:e}=t;return!!(e&&e.render&&e.render())&&(t.data.replace(new Uint8Array(e.data.buffer)),!0)}class jh extends nt{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new Qo({width:1,height:1}),this.dirty=!0}isLoaded(){return this.loaded}setLoaded(t){if(this.loaded!==t&&(this.loaded=t,t)){for(const{ids:t,promiseResolve:e}of this.requestors)e(this._getImagesForIds(t));this.requestors=[]}}getImage(t){const e=this.images[t];if(e&&!e.data&&e.spriteData){const t=e.spriteData;e.data=new Qo({width:t.width,height:t.height},t.context.getImageData(t.x,t.y,t.width,t.height).data),e.spriteData=null}return e}addImage(t,e){if(this.images[t])throw new Error(`Image id ${t} already exist, use updateImage instead`);this._validate(t,e)&&(this.images[t]=e)}_validate(t,e){let i=!0;const r=e.data||e.spriteData;return this._validateStretch(e.stretchX,r&&r.width)||(this.fire(new st(new Error(`Image "${t}" has invalid "stretchX" value`))),i=!1),this._validateStretch(e.stretchY,r&&r.height)||(this.fire(new st(new Error(`Image "${t}" has invalid "stretchY" value`))),i=!1),this._validateContent(e.content,e)||(this.fire(new st(new Error(`Image "${t}" has invalid "content" value`))),i=!1),i}_validateStretch(t,e){if(!t)return!0;let i=0;for(const r of t){if(r[0]<i||r[1]<r[0]||e<r[1])return!1;i=r[1]}return!0}_validateContent(t,e){if(!t)return!0;if(4!==t.length)return!1;const i=e.spriteData,r=i&&i.width||e.data.width,s=i&&i.height||e.data.height;return!(t[0]<0||r<t[0]||t[1]<0||s<t[1]||t[2]<0||r<t[2]||t[3]<0||s<t[3]||t[2]<t[0]||t[3]<t[1])}updateImage(t,e,i=!0){const r=this.getImage(t);if(i&&(r.data.width!==e.data.width||r.data.height!==e.data.height))throw new Error(`size mismatch between old image (${r.data.width}x${r.data.height}) and new image (${e.data.width}x${e.data.height}).`);e.version=r.version+1,this.images[t]=e,this.updatedImages[t]=!0}removeImage(t){const e=this.images[t];delete this.images[t],delete this.patterns[t],e.userImage&&e.userImage.onRemove&&e.userImage.onRemove()}listImages(){return Object.keys(this.images)}getImages(t){return new Promise(((e,i)=>{let r=!0;if(!this.isLoaded())for(const e of t)this.images[e]||(r=!1);this.isLoaded()||r?e(this._getImagesForIds(t)):this.requestors.push({ids:t,promiseResolve:e})}))}_getImagesForIds(t){const e={};for(const i of t){let t=this.getImage(i);t||(this.fire(new rt("styleimagemissing",{id:i})),t=this.getImage(i)),t?e[i]={data:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,textFitWidth:t.textFitWidth,textFitHeight:t.textFitHeight,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:C(`Image "${i}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`)}return e}getPixelSize(){const{width:t,height:e}=this.atlasImage;return{width:t,height:e}}getPattern(t){const e=this.patterns[t],i=this.getImage(t);if(!i)return null;if(e&&e.position.version===i.version)return e.position;if(e)e.position.version=i.version;else{const e={w:i.data.width+2,h:i.data.height+2,x:0,y:0},r=new lh(e,i);this.patterns[t]={bin:e,position:r}}return this._updatePatternAtlas(),this.patterns[t].position}bind(t){const e=t.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new Uh(t,this.atlasImage,e.RGBA),this.atlasTexture.bind(e.LINEAR,e.CLAMP_TO_EDGE)}_updatePatternAtlas(){const t=[];for(const e in this.patterns)t.push(this.patterns[e].bin);const{w:e,h:i}=oh(t),r=this.atlasImage;r.resize({width:e||1,height:i||1});for(const t in this.patterns){const{bin:e}=this.patterns[t],i=e.x+1,s=e.y+1,n=this.getImage(t).data,a=n.width,o=n.height;Qo.copy(n,r,{x:0,y:0},{x:i,y:s},{width:a,height:o}),Qo.copy(n,r,{x:0,y:o-1},{x:i,y:s-1},{width:a,height:1}),Qo.copy(n,r,{x:0,y:0},{x:i,y:s+o},{width:a,height:1}),Qo.copy(n,r,{x:a-1,y:0},{x:i-1,y:s},{width:1,height:o}),Qo.copy(n,r,{x:0,y:0},{x:i+a,y:s},{width:1,height:o})}this.dirty=!0}beginFrame(){this.callbackDispatchedThisFrame={}}dispatchRenderCallbacks(t){for(const e of t){if(this.callbackDispatchedThisFrame[e])continue;this.callbackDispatchedThisFrame[e]=!0;const t=this.getImage(e);t||C(`Image with ID: "${e}" was not found`),Nh(t)&&this.updateImage(e,t)}}}const $h=1e20;function qh(t,e,i,r,s,n,a,o,l){for(let c=e;c<e+r;c++)Zh(t,i*n+c,n,s,a,o,l);for(let c=i;c<i+s;c++)Zh(t,c*n+e,1,r,a,o,l)}function Zh(t,e,i,r,s,n,a){n[0]=0,a[0]=-$h,a[1]=$h,s[0]=t[e];for(let o=1,l=0,c=0;o<r;o++){s[o]=t[e+o*i];const r=o*o;do{const t=n[l];c=(s[o]-s[t]+r-t*t)/(o-t)/2}while(c<=a[l]&&--l>-1);l++,n[l]=o,a[l]=c,a[l+1]=$h}for(let o=0,l=0;o<r;o++){for(;a[l+1]<o;)l++;const r=n[l],c=o-r;t[e+o*i]=s[r]+c*c}}class Gh{constructor(t,e){this.requestManager=t,this.localIdeographFontFamily=e,this.entries={}}setURL(t){this.url=t}getGlyphs(t){return i(this,void 0,void 0,(function*(){const e=[];for(const i in t)for(const r of t[i])e.push(this._getAndCacheGlyphsPromise(i,r));const i=yield Promise.all(e),r={};for(const{stack:t,id:e,glyph:s}of i)r[t]||(r[t]={}),r[t][e]=s&&{id:s.id,bitmap:s.bitmap.clone(),metrics:s.metrics};return r}))}_getAndCacheGlyphsPromise(t,e){return i(this,void 0,void 0,(function*(){let i=this.entries[t];i||(i=this.entries[t]={glyphs:{},requests:{},ranges:{}});let r=i.glyphs[e];if(void 0!==r)return{stack:t,id:e,glyph:r};if(r=this._tinySDF(i,t,e),r)return i.glyphs[e]=r,{stack:t,id:e,glyph:r};const s=Math.floor(e/256);if(256*s>65535)throw new Error("glyphs > 65535 not supported");if(i.ranges[s])return{stack:t,id:e,glyph:r};if(!this.url)throw new Error("glyphsUrl is not set");if(!i.requests[s]){const e=Gh.loadGlyphRange(t,s,this.url,this.requestManager);i.requests[s]=e}const n=yield i.requests[s];for(const t in n)this._doesCharSupportLocalGlyph(+t)||(i.glyphs[+t]=n[+t]);return i.ranges[s]=!0,{stack:t,id:e,glyph:n[e]||null}}))}_doesCharSupportLocalGlyph(t){return!!this.localIdeographFontFamily&&/\p{Ideo}|\p{sc=Hang}|\p{sc=Hira}|\p{sc=Kana}/u.test(String.fromCodePoint(t))}_tinySDF(t,e,i){const r=this.localIdeographFontFamily;if(!r)return;if(!this._doesCharSupportLocalGlyph(i))return;let s=t.tinySDF;if(!s){let i="400";/bold/i.test(e)?i="900":/medium/i.test(e)?i="500":/light/i.test(e)&&(i="200"),s=t.tinySDF=new Gh.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,fontFamily:r,fontWeight:i})}const n=s.draw(String.fromCharCode(i));return{id:i,bitmap:new Jo({width:n.width||60,height:n.height||60},n.data),metrics:{width:n.glyphWidth/2||24,height:n.glyphHeight/2||24,left:n.glyphLeft/2+.5||0,top:n.glyphTop/2-27.5||-8,advance:n.glyphAdvance/2||24,isDoubleResolution:!0}}}}Gh.loadGlyphRange=function(t,e,r,s){return i(this,void 0,void 0,(function*(){const i=256*e,n=i+255,a=s.transformRequest(r.replace("{fontstack}",t).replace("{range}",`${i}-${n}`),"Glyphs"),o=yield(l=a,c=new AbortController,q(y(l,{type:"arrayBuffer"}),c));var l,c;if(!o||!o.data)throw new Error(`Could not load glyph range. range: ${e}, ${i}-${n}`);const h={};for(const t of new ih(o.data).readFields(sh,[]))h[t.id]=t;return h}))},Gh.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:i=8,cutoff:r=.25,fontFamily:s="sans-serif",fontWeight:n="normal",fontStyle:a="normal"}={}){this.buffer=e,this.cutoff=r,this.radius=i;const o=this.size=t+4*e,l=this._createCanvas(o),c=this.ctx=l.getContext("2d",{willReadFrequently:!0});c.font=`${a} ${n} ${t}px ${s}`,c.textBaseline="alphabetic",c.textAlign="left",c.fillStyle="black",this.gridOuter=new Float64Array(o*o),this.gridInner=new Float64Array(o*o),this.f=new Float64Array(o),this.z=new Float64Array(o+1),this.v=new Uint16Array(o)}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:i,actualBoundingBoxDescent:r,actualBoundingBoxLeft:s,actualBoundingBoxRight:n}=this.ctx.measureText(t),a=Math.ceil(i),o=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(n-s))),l=Math.min(this.size-this.buffer,a+Math.ceil(r)),c=o+2*this.buffer,h=l+2*this.buffer,u=Math.max(c*h,0),p=new Uint8ClampedArray(u),d={data:p,width:c,height:h,glyphWidth:o,glyphHeight:l,glyphTop:a,glyphLeft:0,glyphAdvance:e};if(0===o||0===l)return d;const{ctx:f,buffer:m,gridInner:_,gridOuter:g}=this;f.clearRect(m,m,o,l),f.fillText(t,m,m+a);const y=f.getImageData(m,m,o,l);g.fill($h,0,u),_.fill(0,0,u);for(let t=0;t<l;t++)for(let e=0;e<o;e++){const i=y.data[4*(t*o+e)+3]/255;if(0===i)continue;const r=(t+m)*c+e+m;if(1===i)g[r]=0,_[r]=$h;else{const t=.5-i;g[r]=t>0?t*t:0,_[r]=t<0?t*t:0}}qh(g,0,0,c,h,c,this.f,this.v,this.z),qh(_,m,m,o,l,c,this.f,this.v,this.z);for(let t=0;t<u;t++){const e=Math.sqrt(g[t])-Math.sqrt(_[t]);p[t]=Math.round(255-255*(e/this.radius+this.cutoff))}return d}};class Wh{constructor(){this.specification=at.light.position}possiblyEvaluate(t,e){return function([t,e,i]){return e+=90,e*=Math.PI/180,i*=Math.PI/180,{x:t*Math.cos(e)*Math.sin(i),y:t*Math.sin(e)*Math.sin(i),z:t*Math.cos(i)}}(t.expression.evaluate(e))}interpolate(t,e,i){return{x:Ze.number(t.x,e.x,i),y:Ze.number(t.y,e.y,i),z:Ze.number(t.z,e.z,i)}}}let Hh;class Xh extends nt{constructor(t){super(),Hh=Hh||new un({anchor:new an(at.light.anchor),position:new Wh,color:new an(at.light.color),intensity:new an(at.light.intensity)}),this._transitionable=new Qs(Hh),this.setLight(t),this._transitioning=this._transitionable.untransitioned()}getLight(){return this._transitionable.serialize()}setLight(t,e={}){if(!this._validate(As,t,e))for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i)}}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}_validate(t,e,i){return(!i||!1!==i.validate)&&Ps(this,t.call(Is,{value:e,style:{glyphs:!0,sprite:!0},styleSpec:at}))}}const Kh=new un({"sky-color":new an(at.sky["sky-color"]),"horizon-color":new an(at.sky["horizon-color"]),"fog-color":new an(at.sky["fog-color"]),"fog-ground-blend":new an(at.sky["fog-ground-blend"]),"horizon-fog-blend":new an(at.sky["horizon-fog-blend"]),"sky-horizon-blend":new an(at.sky["sky-horizon-blend"]),"atmosphere-blend":new an(at.sky["atmosphere-blend"])});class Yh extends nt{constructor(t){super(),this._transitionable=new Qs(Kh),this.setSky(t),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new Ks(0))}setSky(t,e={}){if(!this._validate(Cs,t,e)){t||(t={"sky-color":"transparent","horizon-color":"transparent","fog-color":"transparent","fog-ground-blend":1,"atmosphere-blend":0});for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i)}}}getSky(){return this._transitionable.serialize()}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}_validate(t,e,i={}){return!1!==(null==i?void 0:i.validate)&&Ps(this,t.call(Is,y({value:e,style:{glyphs:!0,sprite:!0},styleSpec:at})))}calculateFogBlendOpacity(t){return t<60?0:t<70?(t-60)/10:1}}class Jh{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={}}getDash(t,e){const i=t.join(",")+String(e);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(t,e)),this.dashEntry[i]}getDashRanges(t,e,i){const r=[];let s=t.length%2==1?-t[t.length-1]*i:0,n=t[0]*i,a=!0;r.push({left:s,right:n,isDash:a,zeroLength:0===t[0]});let o=t[0];for(let e=1;e<t.length;e++){a=!a;const l=t[e];s=o*i,o+=l,n=o*i,r.push({left:s,right:n,isDash:a,zeroLength:0===l})}return r}addRoundDash(t,e,i){const r=e/2;for(let e=-i;e<=i;e++){const s=this.width*(this.nextRow+i+e);let n=0,a=t[n];for(let o=0;o<this.width;o++){o/a.right>1&&(a=t[++n]);const l=Math.abs(o-a.left),c=Math.abs(o-a.right),h=Math.min(l,c);let u;const p=e/i*(r+1);if(a.isDash){const t=r-Math.abs(p);u=Math.sqrt(h*h+t*t)}else u=r-Math.sqrt(h*h+p*p);this.data[s+o]=Math.max(0,Math.min(255,u+128))}}}addRegularDash(t){for(let e=t.length-1;e>=0;--e){const i=t[e],r=t[e+1];i.zeroLength?t.splice(e,1):r&&r.isDash===i.isDash&&(r.left=i.left,t.splice(e,1))}const e=t[0],i=t[t.length-1];e.isDash===i.isDash&&(e.left=i.left-this.width,i.right=e.right+this.width);const r=this.width*this.nextRow;let s=0,n=t[s];for(let e=0;e<this.width;e++){e/n.right>1&&(n=t[++s]);const i=Math.abs(e-n.left),a=Math.abs(e-n.right),o=Math.min(i,a);this.data[r+e]=Math.max(0,Math.min(255,(n.isDash?o:-o)+128))}}addDash(t,e){const i=e?7:0,r=2*i+1;if(this.nextRow+r>this.height)return C("LineAtlas out of space"),null;let s=0;for(let e=0;e<t.length;e++)s+=t[e];if(0!==s){const r=this.width/s,n=this.getDashRanges(t,this.width,r);e?this.addRoundDash(n,r,i):this.addRegularDash(n)}const n={y:(this.nextRow+i+.5)/this.height,height:2*i/this.height,width:s};return this.nextRow+=r,this.dirty=!0,n}bind(t){const e=t.gl;this.texture?(e.bindTexture(e.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,e.texSubImage2D(e.TEXTURE_2D,0,0,0,this.width,this.height,e.ALPHA,e.UNSIGNED_BYTE,this.data))):(this.texture=e.createTexture(),e.bindTexture(e.TEXTURE_2D,this.texture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texImage2D(e.TEXTURE_2D,0,e.ALPHA,this.width,this.height,0,e.ALPHA,e.UNSIGNED_BYTE,this.data))}}class Qh{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle()})}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle()}),0))}remove(){delete this._channel,this._methodToThrottle=()=>{}}}class tu{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new Qh((()=>this.process())),this.subscription=function(t,e,i,r){return t.addEventListener(e,i,!1),{unsubscribe:()=>{t.removeEventListener(e,i,!1)}}}(this.target,"message",(t=>this.receive(t))),this.globalScope=z(self)?t:window}registerMessageHandler(t,e){this.messageHandlers[t]=e}sendAsync(t,e){return new Promise(((i,r)=>{const s=Math.round(1e18*Math.random()).toString(36).substring(0,10);this.resolveRejects[s]={resolve:i,reject:r},e&&e.signal.addEventListener("abort",(()=>{delete this.resolveRejects[s];const e={id:s,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e)}),{once:!0});const n=[],a=Object.assign(Object.assign({},t),{id:s,sourceMapId:this.mapId,origin:location.origin,data:Fs(t.data,n)});this.target.postMessage(a,{transfer:n})}))}receive(t){const e=t.data,i=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[i];const t=this.abortControllers[i];return delete this.abortControllers[i],void(t&&t.abort())}if(z(self)||e.mustQueue)return this.tasks[i]=e,this.taskQueue.push(i),void this.invoker.trigger();this.processTask(i,e)}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e)}processTask(t,e){return i(this,void 0,void 0,(function*(){if("<response>"===e.type){const i=this.resolveRejects[t];if(delete this.resolveRejects[t],!i)return;return void(e.error?i.reject(Os(e.error)):i.resolve(Os(e.data)))}if(!this.messageHandlers[e.type])return void this.completeTask(t,new Error(`Could not find a registered handler for ${e.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const i=Os(e.data),r=new AbortController;this.abortControllers[t]=r;try{const s=yield this.messageHandlers[e.type](e.sourceMapId,i,r);this.completeTask(t,null,s)}catch(e){this.completeTask(t,e)}}))}completeTask(t,e,i){const r=[];delete this.abortControllers[t];const s={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?Fs(e):null,data:Fs(i,r)};this.target.postMessage(s,{transfer:r})}remove(){this.invoker.remove(),this.subscription.unsubscribe()}}const eu="maplibre_preloaded_worker_pool";class iu{constructor(){this.active={}}acquire(t){if(!this.workers)for(this.workers=[];this.workers.length<iu.workerCount;)this.workers.push(new Worker(V.WORKER_URL));return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],0===this.numActive()&&(this.workers.forEach((t=>{t.terminate()})),this.workers=null)}isPreloaded(){return!!this.active[eu]}numActive(){return Object.keys(this.active).length}}const ru=Math.floor(F.hardwareConcurrency/2);let su,nu;function au(){return su||(su=new iu),su}iu.workerCount=function(t){if(null==P){const e=t.navigator?t.navigator.userAgent:null;P=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")))}return P}(globalThis)?Math.max(Math.min(ru,3),1):1;class ou{constructor(t,e){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=e;const i=this.workerPool.acquire(e);for(let t=0;t<i.length;t++){const r=new tu(i[t],e);r.name=`Worker ${t}`,this.actors.push(r)}if(!this.actors.length)throw new Error("No actors found")}broadcast(t,e){const i=[];for(const r of this.actors)i.push(r.sendAsync({type:t,data:e}));return Promise.all(i)}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(t=!0){this.actors.forEach((t=>{t.remove()})),this.actors=[],t&&this.workerPool.release(this.id)}registerMessageHandler(t,e){for(const i of this.actors)i.registerMessageHandler(t,e)}}function lu(){return nu||(nu=new ou(au(),N),nu.registerMessageHandler("GR",((t,e,i)=>q(e,i)))),nu}function cu(t,e){const i=Co();return ko(i,i,[1,1,0]),Do(i,i,[.5*t.width,.5*t.height,1]),Mo(i,i,t.calculatePosMatrix(e.toUnwrapped()))}function hu(t,e,i,r,s,n){const a=function(t,e,i){if(t)for(const r of t){const t=e[r];if(t&&t.source===i&&"fill-extrusion"===t.type)return!0}else for(const t in e){const r=e[t];if(r.source===i&&"fill-extrusion"===r.type)return!0}return!1}(s&&s.layers,e,t.id),o=n.maxPitchScaleFactor(),l=t.tilesIn(r,o,a);l.sort(uu);const c=[];for(const r of l)c.push({wrappedTileID:r.tileID.wrapped().key,queryResults:r.tile.queryRenderedFeatures(e,i,t._state,r.queryGeometry,r.cameraQueryGeometry,r.scale,s,n,o,cu(t.transform,r.tileID))});const h=function(t){const e={},i={};for(const r of t){const t=r.queryResults,s=r.wrappedTileID,n=i[s]=i[s]||{};for(const i in t){const r=t[i],s=n[i]=n[i]||{},a=e[i]=e[i]||[];for(const t of r)s[t.featureIndex]||(s[t.featureIndex]=!0,a.push(t))}}return e}(c);for(const e in h)h[e].forEach((e=>{const i=e.feature,r=t.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=r}));return h}function uu(t,e){const i=t.tileID,r=e.tileID;return i.overscaledZ-r.overscaledZ||i.canonical.y-r.canonical.y||i.wrap-r.wrap||i.canonical.x-r.canonical.x}function pu(t,e,r){return i(this,void 0,void 0,(function*(){let i=t;if(t.url?i=(yield Z(e.transformRequest(t.url,"Source"),r)).data:yield F.frameAsync(r),!i)return null;const s=x(y(i,t),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return"vector_layers"in i&&i.vector_layers&&(s.vectorLayerIds=i.vector_layers.map((t=>t.id))),s}))}const du=6371008.8;class fu{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new fu(g(this.lng,-180,180),this.lat)}toArray(){return[this.lng,this.lat]}toString(){return`LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,i=this.lat*e,r=t.lat*e,s=Math.sin(i)*Math.sin(r)+Math.cos(i)*Math.cos(r)*Math.cos((t.lng-this.lng)*e);return du*Math.acos(Math.min(s,1))}static convert(t){if(t instanceof fu)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new fu(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new fu(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class mu{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):Array.isArray(t)&&(4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1])))}setNorthEast(t){return this._ne=t instanceof fu?new fu(t.lng,t.lat):fu.convert(t),this}setSouthWest(t){return this._sw=t instanceof fu?new fu(t.lng,t.lat):fu.convert(t),this}extend(t){const e=this._sw,i=this._ne;let r,s;if(t instanceof fu)r=t,s=t;else{if(!(t instanceof mu))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(mu.convert(t)):this.extend(fu.convert(t)):t&&("lng"in t||"lon"in t)&&"lat"in t?this.extend(fu.convert(t)):this;if(r=t._sw,s=t._ne,!r||!s)return this}return e||i?(e.lng=Math.min(r.lng,e.lng),e.lat=Math.min(r.lat,e.lat),i.lng=Math.max(s.lng,i.lng),i.lat=Math.max(s.lat,i.lat)):(this._sw=new fu(r.lng,r.lat),this._ne=new fu(s.lng,s.lat)),this}getCenter(){return new fu((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new fu(this.getWest(),this.getNorth())}getSouthEast(){return new fu(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return[this._sw.toArray(),this._ne.toArray()]}toString(){return`LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return!(this._sw&&this._ne)}contains(t){const{lng:e,lat:i}=fu.convert(t);let r=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(r=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=i&&i<=this._ne.lat&&r}static convert(t){return t instanceof mu?t:t?new mu(t):t}static fromLngLat(t,e=0){const i=360*e/40075017,r=i/Math.cos(Math.PI/180*t.lat);return new mu(new fu(t.lng-r,t.lat-i),new fu(t.lng+r,t.lat+i))}adjustAntiMeridian(){const t=new fu(this._sw.lng,this._sw.lat),e=new fu(this._ne.lng,this._ne.lat);return new mu(t,t.lng>e.lng?new fu(e.lng+360,e.lat):e)}}const _u=2*Math.PI*du;function gu(t){return _u*Math.cos(t*Math.PI/180)}function yu(t){return(180+t)/360}function xu(t){return(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function vu(t,e){return t/gu(e)}function bu(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}class wu{constructor(t,e,i=0){this.x=+t,this.y=+e,this.z=+i}static fromLngLat(t,e=0){const i=fu.convert(t);return new wu(yu(i.lng),xu(i.lat),vu(e,i.lat))}toLngLat(){return new fu(360*this.x-180,bu(this.y))}toAltitude(){return this.z*gu(bu(this.y))}meterInMercatorCoordinateUnits(){return 1/_u*(t=bu(this.y),1/Math.cos(t*Math.PI/180));var t}}class Tu{constructor(t,e,i){this.bounds=mu.convert(this.validateBounds(t)),this.minzoom=e||0,this.maxzoom=i||24}validateBounds(t){return Array.isArray(t)&&4===t.length?[Math.max(-180,t[0]),Math.max(-90,t[1]),Math.min(180,t[2]),Math.min(90,t[3])]:[-180,-90,180,90]}contains(t){const e=Math.pow(2,t.z),i=Math.floor(yu(this.bounds.getWest())*e),r=Math.floor(xu(this.bounds.getNorth())*e),s=Math.ceil(yu(this.bounds.getEast())*e),n=Math.ceil(xu(this.bounds.getSouth())*e);return t.x>=i&&t.x<s&&t.y>=r&&t.y<n}}class Su extends nt{constructor(t,e,i,r){if(super(),this.id=t,this.dispatcher=i,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,y(this,x(e,["url","scheme","tileSize","promoteId"])),this._options=y({type:"vector"},e),this._collectResourceTiming=e.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r)}load(){return i(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new rt("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const t=yield pu(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.sourceCaches[this.id].clearTiles(),t&&(y(this,t),t.bounds&&(this.tileBounds=new Tu(t.bounds,this.minzoom,this.maxzoom)),this.fire(new rt("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new rt("data",{dataType:"source",sourceDataType:"content"})))}catch(t){this._tileJSONRequest=null,this.fire(new st(t))}}))}loaded(){return this._loaded}hasTile(t){return!this.tileBounds||this.tileBounds.contains(t.canonical)}onAdd(t){this.map=t,this.load()}setSourceProperty(t){this._tileJSONRequest&&this._tileJSONRequest.abort(),t(),this.load()}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null)}serialize(){return y({},this._options)}loadTile(t){return i(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(e,"Tile"),uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId};i.request.collectResourceTiming=this._collectResourceTiming;let r="RT";if(t.actor&&"expired"!==t.state){if("loading"===t.state)return new Promise(((e,i)=>{t.reloadPromise={resolve:e,reject:i}}))}else t.actor=this.dispatcher.getActor(),r="LT";t.abortController=new AbortController;try{const e=yield t.actor.sendAsync({type:r,data:i},t.abortController);if(delete t.abortController,t.aborted)return;this._afterTileLoadWorkerResponse(t,e)}catch(e){if(delete t.abortController,t.aborted)return;if(e&&404!==e.status)throw e;this._afterTileLoadWorkerResponse(t,null)}}))}_afterTileLoadWorkerResponse(t,e){if(e&&e.resourceTiming&&(t.resourceTiming=e.resourceTiming),e&&this.map._refreshExpiredTiles&&t.setExpiryData(e),t.loadVectorData(e,this.map.painter),t.reloadPromise){const e=t.reloadPromise;t.reloadPromise=null,this.loadTile(t).then(e.resolve).catch(e.reject)}}abortTile(t){return i(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.actor&&(yield t.actor.sendAsync({type:"AT",data:{uid:t.uid,type:this.type,source:this.id}}))}))}unloadTile(t){return i(this,void 0,void 0,(function*(){t.unloadVectorData(),t.actor&&(yield t.actor.sendAsync({type:"RMT",data:{uid:t.uid,type:this.type,source:this.id}}))}))}hasTransition(){return!1}}class Iu extends nt{constructor(t,e,i,r){super(),this.id=t,this.dispatcher=i,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=y({type:"raster"},e),y(this,x(e,["url","scheme","tileSize"]))}load(){return i(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new rt("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const t=yield pu(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,t&&(y(this,t),t.bounds&&(this.tileBounds=new Tu(t.bounds,this.minzoom,this.maxzoom)),this.fire(new rt("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new rt("data",{dataType:"source",sourceDataType:"content"})))}catch(t){this._tileJSONRequest=null,this.fire(new st(t))}}))}loaded(){return this._loaded}onAdd(t){this.map=t,this.load()}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null)}setSourceProperty(t){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),t(),this.load()}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t})),this}serialize(){return y({},this._options)}hasTile(t){return!this.tileBounds||this.tileBounds.contains(t.canonical)}loadTile(t){return i(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);t.abortController=new AbortController;try{const i=yield Q.getImage(this.map._requestManager.transformRequest(e,"Tile"),t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(i&&i.data){this.map._refreshExpiredTiles&&i.cacheControl&&i.expires&&t.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const e=this.map.painter.context,r=e.gl,s=i.data;t.texture=this.map.painter.getTileTexture(s.width),t.texture?t.texture.update(s,{useMipmap:!0}):(t.texture=new Uh(e,s,r.RGBA,{useMipmap:!0}),t.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST)),t.state="loaded"}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}abortTile(t){return i(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController)}))}unloadTile(t){return i(this,void 0,void 0,(function*(){t.texture&&this.map.painter.saveTileTexture(t.texture)}))}hasTransition(){return!1}}function Au(t,e,i){var r=2*Math.PI*6378137/256/Math.pow(2,i);return[t*r-2*Math.PI*6378137/2,e*r-2*Math.PI*6378137/2]}class Cu{constructor(t,e,i){if(!function(t,e,i){return!(t<0||t>25||i<0||i>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))}(t,e,i))throw new Error(`x=${e}, y=${i}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=i,this.key=Pu(0,t,t,e,i)}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,i){const r=(n=this.y,a=this.z,o=Au(256*(s=this.x),256*(n=Math.pow(2,a)-n-1),a),l=Au(256*(s+1),256*(n+1),a),o[0]+","+o[1]+","+l[0]+","+l[1]);var s,n,a,o,l;const c=function(t,e,i){let r,s="";for(let n=t;n>0;n--)r=1<<n-1,s+=(e&r?1:0)+(i&r?2:0);return s}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===i?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,c).replace(/{bbox-epsg-3857}/g,r)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new a((t.x*e-this.x)*to,(t.y*e-this.y)*to)}toString(){return`${this.z}/${this.x}/${this.y}`}}class Eu{constructor(t,e){this.wrap=t,this.canonical=e,this.key=Pu(t,e.z,e.z,e.x,e.y)}}class zu{constructor(t,e,i,r,s){if(t<i)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${i}`);this.overscaledZ=t,this.wrap=e,this.canonical=new Cu(i,+r,+s),this.key=Pu(e,t,i,r,s)}clone(){return new zu(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new zu(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new zu(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const i=this.canonical.z-t;return t>this.canonical.z?Pu(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):Pu(this.wrap*+e,t,t,this.canonical.x>>i,this.canonical.y>>i)}isChildOf(t){if(t.wrap!==this.wrap)return!1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return[new zu(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,i=2*this.canonical.x,r=2*this.canonical.y;return[new zu(e,this.wrap,e,i,r),new zu(e,this.wrap,e,i+1,r),new zu(e,this.wrap,e,i,r+1),new zu(e,this.wrap,e,i+1,r+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new zu(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new zu(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new Eu(this.wrap,this.canonical)}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new wu(t.x-this.wrap,t.y))}}function Pu(t,e,i,r,s){(t*=2)<0&&(t=-1*t-1);const n=1<<i;return(n*n*t+n*s+r).toString(36)+i.toString(36)+e.toString(36)}Ds("CanonicalTileID",Cu),Ds("OverscaledTileID",zu,{omit:["posMatrix"]}),Ds("DEMData",class{constructor(t,e,i,r=1,s=1,n=1,a=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(i&&!["mapbox","terrarium","custom"].includes(i))return void C(`"${i}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const o=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),i){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=r,this.greenFactor=s,this.blueFactor=n,this.baseShift=a;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4}for(let t=0;t<o;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(o,t)]=this.data[this._idx(o-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,o)]=this.data[this._idx(t,o-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(o,-1)]=this.data[this._idx(o-1,0)],this.data[this._idx(-1,o)]=this.data[this._idx(0,o-1)],this.data[this._idx(o,o)]=this.data[this._idx(o-1,o-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<o;t++)for(let e=0;e<o;e++){const i=this.get(t,e);i>this.max&&(this.max=i),i<this.min&&(this.min=i)}}get(t,e){const i=new Uint8Array(this.data.buffer),r=4*this._idx(t,e);return this.unpack(i[r],i[r+1],i[r+2])}getUnpackVector(){return[this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return(e+1)*this.stride+(t+1)}unpack(t,e,i){return t*this.redFactor+e*this.greenFactor+i*this.blueFactor-this.baseShift}getPixels(){return new Qo({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,i){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let r=e*this.dim,s=e*this.dim+this.dim,n=i*this.dim,a=i*this.dim+this.dim;switch(e){case-1:r=s-1;break;case 1:s=r+1}switch(i){case-1:n=a-1;break;case 1:a=n+1}const o=-e*this.dim,l=-i*this.dim;for(let e=n;e<a;e++)for(let i=r;i<s;i++)this.data[this._idx(i,e)]=t.data[this._idx(i+o,e+l)]}});class Mu extends Iu{constructor(t,e,i,r){super(t,e,i,r),this.type="raster-dem",this.maxzoom=22,this._options=y({type:"raster-dem"},e),this.encoding=e.encoding||"mapbox",this.redFactor=e.redFactor,this.greenFactor=e.greenFactor,this.blueFactor=e.blueFactor,this.baseShift=e.baseShift}loadTile(t){return i(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i=this.map._requestManager.transformRequest(e,"Tile");t.neighboringTiles=this._getNeighboringTiles(t.tileID),t.abortController=new AbortController;try{const e=yield Q.getImage(i,t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(e&&e.data){const i=e.data;this.map._refreshExpiredTiles&&e.cacheControl&&e.expires&&t.setExpiryData({cacheControl:e.cacheControl,expires:e.expires});const r=M(i)&&p()?i:yield this.readImageNow(i),s={type:this.type,uid:t.uid,source:this.id,rawImageData:r,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!t.actor||"expired"===t.state){t.actor=this.dispatcher.getActor();const e=yield t.actor.sendAsync({type:"LDT",data:s});t.dem=e,t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0,t.state="loaded"}}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}readImageNow(t){return i(this,void 0,void 0,(function*(){if("undefined"!=typeof VideoFrame&&function(){if(null==u&&(u=!1,p())){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let i=0;i<t*t;i++){const r=4*i;e.fillStyle=`rgb(${r},${r+1},${r+2})`,e.fillRect(i%t,Math.floor(i/t),1,1)}const i=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&i[e]!==e){u=!0;break}}}return u||!1}()){const e=t.width+2,r=t.height+2;try{return new Qo({width:e,height:r},yield function(t,e,r,s,n){return i(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const e=new VideoFrame(t,{timestamp:0});try{const i=null==e?void 0:e.format;if(!i||!i.startsWith("BGR")&&!i.startsWith("RGB"))throw new Error(`Unrecognized format ${i}`);const r=i.startsWith("BGR"),a=new Uint8ClampedArray(s*n*4);if(yield e.copyTo(a,function(t,e,i,r,s){const n=4*Math.max(1,0),a=(Math.max(0,-1)- -1)*r*4+n,o=4*r,l=Math.max(0,-1),c=Math.max(0,-1);return{rect:{x:l,y:c,width:Math.min(t.width,-1+r)-l,height:Math.min(t.height,-1+s)-c},layout:[{offset:a,stride:o}]}}(t,0,0,s,n)),r)for(let t=0;t<a.length;t+=4){const e=a[t];a[t]=a[t+2],a[t+2]=e}return a}finally{e.close()}}))}(t,0,0,e,r))}catch(t){}}return F.getImageData(t,1)}))}_getNeighboringTiles(t){const e=t.canonical,i=Math.pow(2,e.z),r=(e.x-1+i)%i,s=0===e.x?t.wrap-1:t.wrap,n=(e.x+1+i)%i,a=e.x+1===i?t.wrap+1:t.wrap,o={};return o[new zu(t.overscaledZ,s,e.z,r,e.y).key]={backfilled:!1},o[new zu(t.overscaledZ,a,e.z,n,e.y).key]={backfilled:!1},e.y>0&&(o[new zu(t.overscaledZ,s,e.z,r,e.y-1).key]={backfilled:!1},o[new zu(t.overscaledZ,t.wrap,e.z,e.x,e.y-1).key]={backfilled:!1},o[new zu(t.overscaledZ,a,e.z,n,e.y-1).key]={backfilled:!1}),e.y+1<i&&(o[new zu(t.overscaledZ,s,e.z,r,e.y+1).key]={backfilled:!1},o[new zu(t.overscaledZ,t.wrap,e.z,e.x,e.y+1).key]={backfilled:!1},o[new zu(t.overscaledZ,a,e.z,n,e.y+1).key]={backfilled:!1}),o}unloadTile(t){return i(this,void 0,void 0,(function*(){t.demTexture&&this.map.painter.saveTileTexture(t.demTexture),t.fbo&&(t.fbo.destroy(),delete t.fbo),t.dem&&delete t.dem,delete t.neighboringTiles,t.state="unloaded",t.actor&&(yield t.actor.sendAsync({type:"RDT",data:{type:this.type,uid:t.uid,source:this.id}}))}))}}class ku extends nt{constructor(t,e,i,r){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._pendingLoads=0,this.actor=i.getActor(),this.setEventedParent(r),this._data=e.data,this._options=y({},e),this._collectResourceTiming=e.collectResourceTiming,void 0!==e.maxzoom&&(this.maxzoom=e.maxzoom),e.type&&(this.type=e.type),e.attribution&&(this.attribution=e.attribution),this.promoteId=e.promoteId;const s=to/this.tileSize;void 0!==e.clusterMaxZoom&&this.maxzoom<=e.clusterMaxZoom&&C(`The maxzoom value "${this.maxzoom}" is expected to be greater than the clusterMaxZoom value "${e.clusterMaxZoom}".`),this.workerOptions=y({source:this.id,cluster:e.cluster||!1,geojsonVtOptions:{buffer:(void 0!==e.buffer?e.buffer:128)*s,tolerance:(void 0!==e.tolerance?e.tolerance:.375)*s,extent:to,maxZoom:this.maxzoom,lineMetrics:e.lineMetrics||!1,generateId:e.generateId||!1},superclusterOptions:{maxZoom:void 0!==e.clusterMaxZoom?e.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,e.clusterMinPoints||2),extent:to,radius:(e.clusterRadius||50)*s,log:!1,generateId:e.generateId||!1},clusterProperties:e.clusterProperties,filter:e.filter},e.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId)}load(){return i(this,void 0,void 0,(function*(){yield this._updateWorkerData()}))}onAdd(t){this.map=t,this.load()}setData(t){return this._data=t,this._updateWorkerData(),this}updateData(t){return this._updateWorkerData(t),this}getData(){return i(this,void 0,void 0,(function*(){const t=y({type:this.type},this.workerOptions);return this.actor.sendAsync({type:"GD",data:t})}))}setClusterOptions(t){return this.workerOptions.cluster=t.cluster,t&&(void 0!==t.clusterRadius&&(this.workerOptions.superclusterOptions.radius=t.clusterRadius),void 0!==t.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=t.clusterMaxZoom)),this._updateWorkerData(),this}getClusterExpansionZoom(t){return this.actor.sendAsync({type:"GCEZ",data:{type:this.type,clusterId:t,source:this.id}})}getClusterChildren(t){return this.actor.sendAsync({type:"GCC",data:{type:this.type,clusterId:t,source:this.id}})}getClusterLeaves(t,e,i){return this.actor.sendAsync({type:"GCL",data:{type:this.type,source:this.id,clusterId:t,limit:e,offset:i}})}_updateWorkerData(t){return i(this,void 0,void 0,(function*(){const e=y({type:this.type},this.workerOptions);t?e.dataDiff=t:"string"==typeof this._data?(e.request=this.map._requestManager.transformRequest(F.resolveURL(this._data),"Source"),e.request.collectResourceTiming=this._collectResourceTiming):e.data=JSON.stringify(this._data),this._pendingLoads++,this.fire(new rt("dataloading",{dataType:"source"}));try{const t=yield this.actor.sendAsync({type:"LD",data:e});if(this._pendingLoads--,this._removed||t.abandoned)return void this.fire(new rt("dataabort",{dataType:"source"}));let i=null;t.resourceTiming&&t.resourceTiming[this.id]&&(i=t.resourceTiming[this.id].slice(0));const r={dataType:"source"};this._collectResourceTiming&&i&&i.length>0&&y(r,{resourceTiming:i}),this.fire(new rt("data",Object.assign(Object.assign({},r),{sourceDataType:"metadata"}))),this.fire(new rt("data",Object.assign(Object.assign({},r),{sourceDataType:"content"})))}catch(t){if(this._pendingLoads--,this._removed)return void this.fire(new rt("dataabort",{dataType:"source"}));this.fire(new st(t))}}))}loaded(){return 0===this._pendingLoads}loadTile(t){return i(this,void 0,void 0,(function*(){const e=t.actor?"RT":"LT";t.actor=this.actor;const i={type:this.type,uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId};t.abortController=new AbortController;const r=yield this.actor.sendAsync({type:e,data:i},t.abortController);delete t.abortController,t.unloadVectorData(),t.aborted||t.loadVectorData(r,this.map.painter,"RT"===e)}))}abortTile(t){return i(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.aborted=!0}))}unloadTile(t){return i(this,void 0,void 0,(function*(){t.unloadVectorData(),yield this.actor.sendAsync({type:"RMT",data:{uid:t.uid,type:this.type,source:this.id}})}))}onRemove(){this._removed=!0,this.actor.sendAsync({type:"RS",data:{type:this.type,source:this.id}})}serialize(){return y({},this._options,{type:this.type,data:this._data})}hasTransition(){return!1}}var Du=gn([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class Lu extends nt{constructor(t,e,i,r){super(),this.id=t,this.dispatcher=i,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(r),this.options=e}load(t){return i(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new rt("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController;try{const e=yield Q.getImage(this.map._requestManager.transformRequest(this.url,"Image"),this._request);this._request=null,this._loaded=!0,e&&e.data&&(this.image=e.data,t&&(this.coordinates=t),this._finishLoading())}catch(t){this._request=null,this._loaded=!0,this.fire(new st(t))}}))}loaded(){return this._loaded}updateImage(t){return t.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=t.url,this.load(t.coordinates).finally((()=>{this.texture=null})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new rt("data",{dataType:"source",sourceDataType:"metadata"})))}onAdd(t){this.map=t,this.load()}onRemove(){this._request&&(this._request.abort(),this._request=null)}setCoordinates(t){this.coordinates=t;const e=t.map(wu.fromLngLat);this.tileID=function(t){let e=1/0,i=1/0,r=-1/0,s=-1/0;for(const n of t)e=Math.min(e,n.x),i=Math.min(i,n.y),r=Math.max(r,n.x),s=Math.max(s,n.y);const n=Math.max(r-e,s-i),a=Math.max(0,Math.floor(-Math.log(n)/Math.LN2)),o=Math.pow(2,a);return new Cu(a,Math.floor((e+r)/2*o),Math.floor((i+s)/2*o))}(e),this.minzoom=this.maxzoom=this.tileID.z;const i=e.map((t=>this.tileID.getTilePoint(t)._round()));return this._boundsArray=new ia,this._boundsArray.emplaceBack(i[0].x,i[0].y,0,0),this._boundsArray.emplaceBack(i[1].x,i[1].y,to,0),this._boundsArray.emplaceBack(i[3].x,i[3].y,0,to),this._boundsArray.emplaceBack(i[2].x,i[2].y,to,to),this.boundsBuffer&&(this.boundsBuffer.destroy(),delete this.boundsBuffer),this.fire(new rt("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const t=this.map.painter.context,e=t.gl;this.boundsBuffer||(this.boundsBuffer=t.createVertexBuffer(this._boundsArray,Du.members)),this.boundsSegments||(this.boundsSegments=ba.simpleSegment(0,0,4,2)),this.texture||(this.texture=new Uh(t,this.image,e.RGBA),this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE));let i=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,i=!0)}i&&this.fire(new rt("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}loadTile(t){return i(this,void 0,void 0,(function*(){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={}):t.state="errored"}))}serialize(){return{type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return!1}}class Ru extends Lu{constructor(t,e,i,r){super(t,e,i,r),this.roundZoom=!0,this.type="video",this.options=e}load(){return i(this,void 0,void 0,(function*(){this._loaded=!1;const t=this.options;this.urls=[];for(const e of t.urls)this.urls.push(this.map._requestManager.transformRequest(e,"Source").url);try{const t=yield(t=>{const e=window.document.createElement("video");return e.muted=!0,new Promise((i=>{e.onloadstart=()=>{i(e)};for(const i of t){const t=window.document.createElement("source");G(i)||(e.crossOrigin="Anonymous"),t.src=i,e.appendChild(t)}}))})(this.urls);if(this._loaded=!0,!t)return;this.video=t,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint()})),this.map&&this.video.play(),this._finishLoading()}catch(t){this.fire(new st(t))}}))}pause(){this.video&&this.video.pause()}play(){this.video&&this.video.play()}seek(t){if(this.video){const e=this.video.seekable;t<e.start(0)||t>e.end(0)?this.fire(new st(new xt(`sources.${this.id}`,null,`Playback for this video can be set only between the ${e.start(0)} and ${e.end(0)}-second mark.`))):this.video.currentTime=t}}getVideo(){return this.video}onAdd(t){this.map||(this.map=t,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)))}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,e=t.gl;this.boundsBuffer||(this.boundsBuffer=t.createVertexBuffer(this._boundsArray,Du.members)),this.boundsSegments||(this.boundsSegments=ba.simpleSegment(0,0,4,2)),this.texture?this.video.paused||(this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE),e.texSubImage2D(e.TEXTURE_2D,0,0,0,e.RGBA,e.UNSIGNED_BYTE,this.video)):(this.texture=new Uh(t,this.video,e.RGBA),this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE));let i=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,i=!0)}i&&this.fire(new rt("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}serialize(){return{type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}}class Bu extends Lu{constructor(t,e,i,r){super(t,e,i,r),e.coordinates?Array.isArray(e.coordinates)&&4===e.coordinates.length&&!e.coordinates.some((t=>!Array.isArray(t)||2!==t.length||t.some((t=>"number"!=typeof t))))||this.fire(new st(new xt(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new st(new xt(`sources.${t}`,null,'missing required property "coordinates"'))),e.animate&&"boolean"!=typeof e.animate&&this.fire(new st(new xt(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),e.canvas?"string"==typeof e.canvas||e.canvas instanceof HTMLCanvasElement||this.fire(new st(new xt(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new st(new xt(`sources.${t}`,null,'missing required property "canvas"'))),this.options=e,this.animate=void 0===e.animate||e.animate}load(){return i(this,void 0,void 0,(function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new st(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint()},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1)},this._finishLoading())}))}getCanvas(){return this.canvas}onAdd(t){this.map=t,this.load(),this.canvas&&this.animate&&this.play()}onRemove(){this.pause()}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const e=this.map.painter.context,i=e.gl;this.boundsBuffer||(this.boundsBuffer=e.createVertexBuffer(this._boundsArray,Du.members)),this.boundsSegments||(this.boundsSegments=ba.simpleSegment(0,0,4,2)),this.texture?(t||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new Uh(e,this.canvas,i.RGBA,{premultiply:!0});let r=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,r=!0)}r&&this.fire(new rt("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}serialize(){return{type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const t of[this.canvas.width,this.canvas.height])if(isNaN(t)||t<=0)return!0;return!1}}const Fu={},Ou=t=>{switch(t){case"geojson":return ku;case"image":return Lu;case"raster":return Iu;case"raster-dem":return Mu;case"vector":return Su;case"video":return Ru;case"canvas":return Bu}return Fu[t]};class Vu{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const i=t[e];this._stringToNumber[i]=e,this._numberToString[e]=i}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class Uu{constructor(t,e,i,r,s){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=i,t._y=r,this.properties=t.properties,this.id=s}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}function Nu(t,e,i,r,s){return w(t,((t,n)=>{const a=e instanceof nn?e.get(n):null;return a&&a.evaluate?a.evaluate(i,r,s):a}))}function ju(t){let e=1/0,i=1/0,r=-1/0,s=-1/0;for(const n of t)e=Math.min(e,n.x),i=Math.min(i,n.y),r=Math.max(r,n.x),s=Math.max(s,n.y);return{minX:e,minY:i,maxX:r,maxY:s}}function $u(t,e){return e-t}Ds("FeatureIndex",class{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new Ms(to,16,0),this.grid3D=new Ms(to,16,0),this.featureIndexArray=new Qn,this.promoteId=e}insert(t,e,i,r,s,n){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(i,r,s);const o=n?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const i=e[t],r=[1/0,1/0,-1/0,-1/0];for(let t=0;t<i.length;t++){const e=i[t];r[0]=Math.min(r[0],e.x),r[1]=Math.min(r[1],e.y),r[2]=Math.max(r[2],e.x),r[3]=Math.max(r[3],e.y)}r[0]<to&&r[1]<to&&r[2]>=0&&r[3]>=0&&o.insert(a,r[0],r[1],r[2],r[3])}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new $l.VectorTile(new ih(this.rawTileData)).layers,this.sourceLayerCoder=new Vu(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,i,r){this.loadVTLayers();const s=t.params||{},n=to/t.tileSize/t.scale,o=jr(s.filter),l=t.queryGeometry,c=t.queryPadding*n,h=ju(l),u=this.grid.query(h.minX-c,h.minY-c,h.maxX+c,h.maxY+c),p=ju(t.cameraQueryGeometry),d=this.grid3D.query(p.minX-c,p.minY-c,p.maxX+c,p.maxY+c,((e,i,r,s)=>function(t,e,i,r,s){for(const n of t)if(e<=n.x&&i<=n.y&&r>=n.x&&s>=n.y)return!0;const n=[new a(e,i),new a(e,s),new a(r,s),new a(r,i)];if(t.length>2)for(const e of n)if(go(t,e))return!0;for(let e=0;e<t.length-1;e++)if(yo(t[e],t[e+1],n))return!0;return!1}(t.cameraQueryGeometry,e-c,i-c,r+c,s+c)));for(const t of d)u.push(t);u.sort($u);const f={};let m;for(let a=0;a<u.length;a++){const c=u[a];if(c===m)continue;m=c;const h=this.featureIndexArray.get(c);let p=null;this.loadMatchingFeature(f,h.bucketIndex,h.sourceLayerIndex,h.featureIndex,o,s.layers,s.availableImages,e,i,r,((e,i,r)=>(p||(p=ro(e)),i.queryIntersectsFeature(l,e,r,p,this.z,t.transform,n,t.pixelPosMatrix))))}return f}loadMatchingFeature(t,e,i,r,s,n,a,o,l,c,h){const u=this.bucketLayerIDs[e];if(n&&!function(t,e){for(let i=0;i<t.length;i++)if(e.indexOf(t[i])>=0)return!0;return!1}(n,u))return;const p=this.sourceLayerCoder.decode(i),d=this.vtLayers[p].feature(r);if(s.needGeometry){const t=so(d,!0);if(!s.filter(new Ks(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!s.filter(new Ks(this.tileID.overscaledZ),d))return;const f=this.getId(d,p);for(let e=0;e<u.length;e++){const i=u[e];if(n&&n.indexOf(i)<0)continue;const s=o[i];if(!s)continue;let p={};f&&c&&(p=c.getState(s.sourceLayer||"_geojsonTileLayer",f));const m=y({},l[i]);m.paint=Nu(m.paint,s.paint,d,p,a),m.layout=Nu(m.layout,s.layout,d,p,a);const _=!h||h(d,s,p);if(!_)continue;const g=new Uu(d,this.z,this.x,this.y,f);g.layer=m;let x=t[i];void 0===x&&(x=t[i]=[]),x.push({featureIndex:r,feature:g,intersectionZ:_})}}lookupSymbolFeatures(t,e,i,r,s,n,a,o){const l={};this.loadVTLayers();const c=jr(s);for(const s of t)this.loadMatchingFeature(l,i,r,s,c,n,a,o,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const i of e)if(t===i)return!0;return!1}getId(t,e){let i=t.id;return this.promoteId&&(i=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof i&&(i=Number(i))),i}},{omit:["rawTileData","sourceLayerCoder"]});const qu="RTLPluginLoaded";class Zu extends nt{constructor(){super(...arguments),this.status="unavailable",this.url=null,this.dispatcher=lu()}_syncState(t){return this.status=t,this.dispatcher.broadcast("SRPS",{pluginStatus:t,pluginURL:this.url}).catch((t=>{throw this.status="error",t}))}getRTLTextPluginStatus(){return this.status}clearRTLTextPlugin(){this.status="unavailable",this.url=null}setRTLTextPlugin(t){return i(this,arguments,void 0,(function*(t,e=!1){if(this.url)throw new Error("setRTLTextPlugin cannot be called multiple times.");if(this.url=F.resolveURL(t),!this.url)throw new Error(`requested url ${t} is invalid`);if("unavailable"===this.status){if(!e)return this._requestImport();this.status="deferred",this._syncState(this.status)}else if("requested"===this.status)return this._requestImport()}))}_requestImport(){return i(this,void 0,void 0,(function*(){yield this._syncState("loading"),this.status="loaded",this.fire(new rt(qu))}))}lazyLoad(){"unavailable"===this.status?this.status="requested":"deferred"===this.status&&this._requestImport()}}let Gu=null;function Wu(){return Gu||(Gu=new Zu),Gu}class Hu{constructor(t,e){this.timeAdded=0,this.fadeEndTime=0,this.tileID=t,this.uid=b(),this.uses=0,this.tileSize=e,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading"}registerFadeDuration(t){const e=t+this.timeAdded;e<this.fadeEndTime||(this.fadeEndTime=e)}wasRequested(){return"errored"===this.state||"loaded"===this.state||"reloading"===this.state}clearTextures(t){this.demTexture&&t.saveTileTexture(this.demTexture),this.demTexture=null}loadVectorData(t,e,i){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const i={};if(!e)return i;for(const r of t){const t=r.layerIds.map((t=>e.getLayer(t))).filter(Boolean);if(0!==t.length){r.layers=t,r.stateDependentLayerIds&&(r.stateDependentLayers=r.stateDependentLayerIds.map((e=>t.filter((t=>t.id===e))[0])));for(const e of t)i[e.id]=r}}return i}(t.buckets,e.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const e=this.buckets[t];if(e instanceof Sh){if(this.hasSymbolBuckets=!0,!i)break;e.justReloaded=!0}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const e=this.buckets[t];if(e instanceof Sh&&e.hasRTLText){this.hasRTLText=!0,Wu().lazyLoad();break}}this.queryPadding=0;for(const t in this.buckets){const i=this.buckets[t];this.queryPadding=Math.max(this.queryPadding,e.style.getLayer(t).queryRadius(i))}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage)}else this.collisionBoxArray=new $n}unloadVectorData(){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.latestFeatureIndex=null,this.state="unloaded"}getBucket(t){return this.buckets[t.id]}upload(t){for(const e in this.buckets){const i=this.buckets[e];i.uploadPending()&&i.upload(t)}const e=t.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new Uh(t,this.imageAtlas.image,e.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new Uh(t,this.glyphAtlasImage,e.ALPHA),this.glyphAtlasImage=null)}prepare(t){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture)}queryRenderedFeatures(t,e,i,r,s,n,a,o,l,c){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:r,cameraQueryGeometry:s,scale:n,tileSize:this.tileSize,pixelPosMatrix:c,transform:o,params:a,queryPadding:this.queryPadding*l},t,e,i):{}}querySourceFeatures(t,e){const i=this.latestFeatureIndex;if(!i||!i.rawTileData)return;const r=i.loadVTLayers(),s=e&&e.sourceLayer?e.sourceLayer:"",n=r._geojsonTileLayer||r[s];if(!n)return;const a=jr(e&&e.filter),{z:o,x:l,y:c}=this.tileID.canonical,h={z:o,x:l,y:c};for(let e=0;e<n.length;e++){const r=n.feature(e);if(a.needGeometry){const t=so(r,!0);if(!a.filter(new Ks(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!a.filter(new Ks(this.tileID.overscaledZ),r))continue;const u=i.getId(r,s),p=new Uu(r,o,l,c,u);p.tile=h,t.push(p)}}hasData(){return"loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const e=this.expirationTime;if(t.cacheControl){const e=function(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,i,r,s)=>{const n=r||s;return e[i]=!n||n.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t}return e}(t.cacheControl);e["max-age"]&&(this.expirationTime=Date.now()+1e3*e["max-age"])}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let i=!1;if(this.expirationTime>t)i=!1;else if(e)if(this.expirationTime<e)i=!0;else{const r=this.expirationTime-e;r?this.expirationTime=t+Math.max(r,3e4):i=!0}else i=!0;i?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(t).length)return;const i=this.latestFeatureIndex.loadVTLayers();for(const r in this.buckets){if(!e.style.hasLayer(r))continue;const s=this.buckets[r],n=s.layers[0].sourceLayer||"_geojsonTileLayer",a=i[n],o=t[n];if(!a||!o||0===Object.keys(o).length)continue;s.update(o,a,this.imageAtlas&&this.imageAtlas.patternPositions||{});const l=e&&e.style&&e.style.getLayer(r);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(s)))}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return!this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<F.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0}setHoldDuration(t){this.symbolFadeHoldUntil=F.now()+t}setDependencies(t,e){const i={};for(const t of e)i[t]=!0;this.dependencies[t]=i}hasDependency(t,e){for(const i of t){const t=this.dependencies[i];if(t)for(const i of e)if(t[i])return!0}return!1}}class Xu{constructor(t,e){this.max=t,this.onRemove=e,this.reset()}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,i){const r=t.wrapped().key;void 0===this.data[r]&&(this.data[r]=[]);const s={value:e,timeout:void 0};if(void 0!==i&&(s.timeout=setTimeout((()=>{this.remove(t,s)}),i)),this.data[r].push(s),this.order.push(r),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t)}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const i=t.wrapped().key,r=void 0===e?0:this.data[i].indexOf(e),s=this.data[i][r];return this.data[i].splice(r,1),s.timeout&&clearTimeout(s.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(s.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t)}return this}filter(t){const e=[];for(const i in this.data)for(const r of this.data[i])t(r.value)||e.push(r);for(const t of e)this.remove(t.value.tileID,t)}}class Ku{constructor(){this.state={},this.stateChanges={},this.deletedStates={}}updateState(t,e,i){const r=String(e);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][r]=this.stateChanges[t][r]||{},y(this.stateChanges[t][r],i),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==r&&(this.deletedStates[t][e]=null)}else if(this.deletedStates[t]&&null===this.deletedStates[t][r]){this.deletedStates[t][r]={};for(const e in this.state[t][r])i[e]||(this.deletedStates[t][r][e]=null)}else for(const e in i)this.deletedStates[t]&&this.deletedStates[t][r]&&null===this.deletedStates[t][r][e]&&delete this.deletedStates[t][r][e]}removeFeatureState(t,e,i){if(null===this.deletedStates[t])return;const r=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},i&&void 0!==e)null!==this.deletedStates[t][r]&&(this.deletedStates[t][r]=this.deletedStates[t][r]||{},this.deletedStates[t][r][i]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][r])for(i in this.deletedStates[t][r]={},this.stateChanges[t][r])this.deletedStates[t][r][i]=null;else this.deletedStates[t][r]=null;else this.deletedStates[t]=null}getState(t,e){const i=String(e),r=y({},(this.state[t]||{})[i],(this.stateChanges[t]||{})[i]);if(null===this.deletedStates[t])return{};if(this.deletedStates[t]){const i=this.deletedStates[t][e];if(null===i)return{};for(const t in i)delete r[t]}return r}initializeTileState(t,e){t.setFeatureState(this.state,e)}coalesceChanges(t,e){const i={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const e={};for(const i in this.stateChanges[t])this.state[t][i]||(this.state[t][i]={}),y(this.state[t][i],this.stateChanges[t][i]),e[i]=this.state[t][i];i[t]=e}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const e={};if(null===this.deletedStates[t])for(const i in this.state[t])e[i]={},this.state[t][i]={};else for(const i in this.deletedStates[t]){if(null===this.deletedStates[t][i])this.state[t][i]={};else for(const e of Object.keys(this.deletedStates[t][i]))delete this.state[t][i][e];e[i]=this.state[t][i]}i[t]=i[t]||{},y(i[t],e)}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(i).length)for(const r in t)t[r].setFeatureState(i,e)}}class Yu extends nt{constructor(t,e,i){super(),this.id=t,this.dispatcher=i,this.on("data",(t=>this._dataHandler(t))),this.on("dataloading",(()=>{this._sourceErrored=!1})),this.on("error",(()=>{this._sourceErrored=this._source.loaded()})),this._source=((t,e,i,r)=>{const s=new(Ou(e.type))(t,e,i,r);if(s.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${s.id}`);return s})(t,e,i,this),this._tiles={},this._cache=new Xu(0,(t=>this._unloadTile(t))),this._timers={},this._cacheTimers={},this._maxTileCacheSize=null,this._maxTileCacheZoomLevels=null,this._loadedParentTiles={},this._coveredTiles={},this._state=new Ku,this._didEmitContent=!1,this._updated=!1}onAdd(t){this.map=t,this._maxTileCacheSize=t?t._maxTileCacheSize:null,this._maxTileCacheZoomLevels=t?t._maxTileCacheZoomLevels:null,this._source&&this._source.onAdd&&this._source.onAdd(t)}onRemove(t){this.clearTiles(),this._source&&this._source.onRemove&&this._source.onRemove(t)}loaded(){if(this._sourceErrored)return!0;if(!this._sourceLoaded)return!1;if(!this._source.loaded())return!1;if(!(void 0===this.used&&void 0===this.usedForTerrain||this.used||this.usedForTerrain))return!0;if(!this._updated)return!1;for(const t in this._tiles){const e=this._tiles[t];if("loaded"!==e.state&&"errored"!==e.state)return!1}return!0}getSource(){return this._source}pause(){this._paused=!0}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform,this.terrain)}_loadTile(t,e,r){return i(this,void 0,void 0,(function*(){try{yield this._source.loadTile(t),this._tileLoaded(t,e,r)}catch(e){t.state="errored",404!==e.status?this._source.fire(new st(e,{tile:t})):this.update(this.transform,this.terrain)}}))}_unloadTile(t){this._source.unloadTile&&this._source.unloadTile(t)}_abortTile(t){this._source.abortTile&&this._source.abortTile(t),this._source.fire(new rt("dataabort",{tile:t,coord:t.tileID,dataType:"source"}))}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const i=this._tiles[e];i.upload(t),i.prepare(this.map.style.imageManager)}}getIds(){return Object.values(this._tiles).map((t=>t.tileID)).sort(Ju).map((t=>t.key))}getRenderableIds(t){const e=[];for(const i in this._tiles)this._isIdRenderable(i,t)&&e.push(this._tiles[i]);return t?e.sort(((t,e)=>{const i=t.tileID,r=e.tileID,s=new a(i.canonical.x,i.canonical.y)._rotate(this.transform.angle),n=new a(r.canonical.x,r.canonical.y)._rotate(this.transform.angle);return i.overscaledZ-r.overscaledZ||n.y-s.y||n.x-s.x})).map((t=>t.tileID.key)):e.map((t=>t.tileID)).sort(Ju).map((t=>t.key))}hasRenderableParent(t){const e=this.findLoadedParent(t,0);return!!e&&this._isIdRenderable(e.tileID.key)}_isIdRenderable(t,e){return this._tiles[t]&&this._tiles[t].hasData()&&!this._coveredTiles[t]&&(e||!this._tiles[t].holdingForFade())}reload(){if(this._paused)this._shouldReloadOnResume=!0;else{this._cache.reset();for(const t in this._tiles)"errored"!==this._tiles[t].state&&this._reloadTile(t,"reloading")}}_reloadTile(t,e){return i(this,void 0,void 0,(function*(){const i=this._tiles[t];i&&("loading"!==i.state&&(i.state=e),yield this._loadTile(i,t,e))}))}_tileLoaded(t,e,i){t.timeAdded=F.now(),"expired"===i&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(e,t),"raster-dem"===this.getSource().type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),t.aborted||this._source.fire(new rt("data",{dataType:"source",tile:t,coord:t.tileID}))}_backfillDEM(t){const e=this.getRenderableIds();for(let r=0;r<e.length;r++){const s=e[r];if(t.neighboringTiles&&t.neighboringTiles[s]){const e=this.getTileByID(s);i(t,e),i(e,t)}}function i(t,e){t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0;let i=e.tileID.canonical.x-t.tileID.canonical.x;const r=e.tileID.canonical.y-t.tileID.canonical.y,s=Math.pow(2,t.tileID.canonical.z),n=e.tileID.key;0===i&&0===r||Math.abs(r)>1||(Math.abs(i)>1&&(1===Math.abs(i+s)?i+=s:1===Math.abs(i-s)&&(i-=s)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,i,r),t.neighboringTiles&&t.neighboringTiles[n]&&(t.neighboringTiles[n].backfilled=!0)))}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e,i,r){for(const s in this._tiles){let n=this._tiles[s];if(r[s]||!n.hasData()||n.tileID.overscaledZ<=e||n.tileID.overscaledZ>i)continue;let a=n.tileID;for(;n&&n.tileID.overscaledZ>e+1;){const t=n.tileID.scaledTo(n.tileID.overscaledZ-1);n=this._tiles[t.key],n&&n.hasData()&&(a=t)}let o=a;for(;o.overscaledZ>e;)if(o=o.scaledTo(o.overscaledZ-1),t[o.key]){r[a.key]=a;break}}}findLoadedParent(t,e){if(t.key in this._loadedParentTiles){const i=this._loadedParentTiles[t.key];return i&&i.tileID.overscaledZ>=e?i:null}for(let i=t.overscaledZ-1;i>=e;i--){const e=t.scaledTo(i),r=this._getLoadedTile(e);if(r)return r}}findLoadedSibling(t){return this._getLoadedTile(t)}_getLoadedTile(t){const e=this._tiles[t.key];return e&&e.hasData()?e:this._cache.getByKey(t.wrapped().key)}updateCacheSize(t){const e=Math.ceil(t.width/this._source.tileSize)+1,i=Math.ceil(t.height/this._source.tileSize)+1,r=Math.floor(e*i*(null===this._maxTileCacheZoomLevels?V.MAX_TILE_CACHE_ZOOM_LEVELS:this._maxTileCacheZoomLevels)),s="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._cache.setMaxSize(s)}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const i in this._tiles){const r=this._tiles[i];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+e),t[r.tileID.key]=r}this._tiles=t;for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(t,this._tiles[t])}}_updateCoveredAndRetainedTiles(t,e,i,r,s,n){const a={},o={},l=Object.keys(t),c=F.now();for(const i of l){const r=t[i],s=this._tiles[i];if(!s||0!==s.fadeEndTime&&s.fadeEndTime<=c)continue;const n=this.findLoadedParent(r,e),l=this.findLoadedSibling(r),h=n||l||null;h&&(this._addTile(h.tileID),a[h.tileID.key]=h.tileID),o[i]=r}this._retainLoadedChildren(o,r,i,t);for(const e in a)t[e]||(this._coveredTiles[e]=!0,t[e]=a[e]);if(n){const e={},i={};for(const t of s)this._tiles[t.key].hasData()?e[t.key]=t:i[t.key]=t;for(const r in i){const s=i[r].children(this._source.maxzoom);this._tiles[s[0].key]&&this._tiles[s[1].key]&&this._tiles[s[2].key]&&this._tiles[s[3].key]&&(e[s[0].key]=t[s[0].key]=s[0],e[s[1].key]=t[s[1].key]=s[1],e[s[2].key]=t[s[2].key]=s[2],e[s[3].key]=t[s[3].key]=s[3],delete i[r])}for(const r in i){const s=i[r],n=this.findLoadedParent(s,this._source.minzoom),a=this.findLoadedSibling(s),o=n||a||null;if(o){e[o.tileID.key]=t[o.tileID.key]=o.tileID;for(const t in e)e[t].isChildOf(o.tileID)&&delete e[t]}}for(const t in this._tiles)e[t]||(this._coveredTiles[t]=!0)}}update(t,e){if(!this._sourceLoaded||this._paused)return;let i;this.transform=t,this.terrain=e,this.updateCacheSize(t),this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?i=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new zu(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y))):(i=t.coveringTiles({tileSize:this.usedForTerrain?this.tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:!this.usedForTerrain&&this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,terrain:e}),this._source.hasTile&&(i=i.filter((t=>this._source.hasTile(t))))):i=[];const r=t.coveringZoomLevel(this._source),s=Math.max(r-Yu.maxOverzooming,this._source.minzoom),n=Math.max(r+Yu.maxUnderzooming,this._source.minzoom);if(this.usedForTerrain){const t={};for(const e of i)if(e.canonical.z>this._source.minzoom){const i=e.scaledTo(e.canonical.z-1);t[i.key]=i;const r=e.scaledTo(Math.max(this._source.minzoom,Math.min(e.canonical.z,5)));t[r.key]=r}i=i.concat(Object.values(t))}const a=0===i.length&&!this._updated&&this._didEmitContent;this._updated=!0,a&&this.fire(new rt("data",{sourceDataType:"idle",dataType:"source",sourceId:this.id}));const o=this._updateRetainedTiles(i,r);Qu(this._source.type)&&this._updateCoveredAndRetainedTiles(o,s,n,r,i,e);for(const t in o)this._tiles[t].clearFadeHold();const l=function(t,e){const i=[];for(const r in t)r in e||i.push(r);return i}(this._tiles,o);for(const t of l){const e=this._tiles[t];e.hasSymbolBuckets&&!e.holdingForFade()?e.setHoldDuration(this.map._fadeDuration):e.hasSymbolBuckets&&!e.symbolFadeFinished()||this._removeTile(t)}this._updateLoadedParentTileCache(),this._updateLoadedSiblingTileCache()}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForFade()&&this._removeTile(t)}_updateRetainedTiles(t,e){var i;const r={},s={},n=Math.max(e-Yu.maxOverzooming,this._source.minzoom),a=Math.max(e+Yu.maxUnderzooming,this._source.minzoom),o={};for(const i of t){const t=this._addTile(i);r[i.key]=i,t.hasData()||e<this._source.maxzoom&&(o[i.key]=i)}this._retainLoadedChildren(o,e,a,r);for(const a of t){let t=this._tiles[a.key];if(t.hasData())continue;if(e+1>this._source.maxzoom){const t=a.children(this._source.maxzoom)[0],e=this.getTile(t);if(e&&e.hasData()){r[t.key]=t;continue}}else{const t=a.children(this._source.maxzoom);if(r[t[0].key]&&r[t[1].key]&&r[t[2].key]&&r[t[3].key])continue}let o=t.wasRequested();for(let e=a.overscaledZ-1;e>=n;--e){const n=a.scaledTo(e);if(s[n.key])break;if(s[n.key]=!0,t=this.getTile(n),!t&&o&&(t=this._addTile(n)),t){const e=t.hasData();if((e||!(null===(i=this.map)||void 0===i?void 0:i.cancelPendingTileRequestsWhileZooming)||o)&&(r[n.key]=n),o=t.wasRequested(),e)break}}}return r}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const t in this._tiles){const e=[];let i,r=this._tiles[t].tileID;for(;r.overscaledZ>0;){if(r.key in this._loadedParentTiles){i=this._loadedParentTiles[r.key];break}e.push(r.key);const t=r.scaledTo(r.overscaledZ-1);if(i=this._getLoadedTile(t),i)break;r=t}for(const t of e)this._loadedParentTiles[t]=i}}_updateLoadedSiblingTileCache(){this._loadedSiblingTiles={};for(const t in this._tiles){const e=this._tiles[t].tileID,i=this._getLoadedTile(e);this._loadedSiblingTiles[e.key]=i}}_addTile(t){let e=this._tiles[t.key];if(e)return e;e=this._cache.getAndRemove(t),e&&(this._setTileReloadTimer(t.key,e),e.tileID=t,this._state.initializeTileState(e,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,e)));const i=e;return e||(e=new Hu(t,this._source.tileSize*t.overscaleFactor()),this._loadTile(e,t.key,e.state)),e.uses++,this._tiles[t.key]=e,i||this._source.fire(new rt("dataloading",{tile:e,coord:e.tileID,dataType:"source"})),e}_setTileReloadTimer(t,e){t in this._timers&&(clearTimeout(this._timers[t]),delete this._timers[t]);const i=e.getExpiryTimeout();i&&(this._timers[t]=setTimeout((()=>{this._reloadTile(t,"expired"),delete this._timers[t]}),i))}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._timers[t]&&(clearTimeout(this._timers[t]),delete this._timers[t]),e.uses>0||(e.hasData()&&"reloading"!==e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))))}_dataHandler(t){const e=t.sourceDataType;"source"===t.dataType&&"metadata"===e&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===t.dataType&&"content"===e&&(this.reload(),this.transform&&this.update(this.transform,this.terrain),this._didEmitContent=!0)}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(t);this._cache.reset()}tilesIn(t,e,i){const r=[],s=this.transform;if(!s)return r;const n=i?s.getCameraQueryGeometry(t):t,a=t.map((t=>s.pointCoordinate(t,this.terrain))),o=n.map((t=>s.pointCoordinate(t,this.terrain))),l=this.getIds();let c=1/0,h=1/0,u=-1/0,p=-1/0;for(const t of o)c=Math.min(c,t.x),h=Math.min(h,t.y),u=Math.max(u,t.x),p=Math.max(p,t.y);for(let t=0;t<l.length;t++){const i=this._tiles[l[t]];if(i.holdingForFade())continue;const n=i.tileID,d=Math.pow(2,s.zoom-i.tileID.overscaledZ),f=e*i.queryPadding*to/i.tileSize/d,m=[n.getTilePoint(new wu(c,h)),n.getTilePoint(new wu(u,p))];if(m[0].x-f<to&&m[0].y-f<to&&m[1].x+f>=0&&m[1].y+f>=0){const t=a.map((t=>n.getTilePoint(t))),e=o.map((t=>n.getTilePoint(t)));r.push({tile:i,tileID:n,queryGeometry:t,cameraQueryGeometry:e,scale:d})}}return r}getVisibleCoordinates(t){const e=this.getRenderableIds(t).map((t=>this._tiles[t].tileID));for(const t of e)t.posMatrix=this.transform.calculatePosMatrix(t.toUnwrapped());return e}hasTransition(){if(this._source.hasTransition())return!0;if(Qu(this._source.type)){const t=F.now();for(const e in this._tiles)if(this._tiles[e].fadeEndTime>=t)return!0}return!1}setFeatureState(t,e,i){this._state.updateState(t=t||"_geojsonTileLayer",e,i)}removeFeatureState(t,e,i){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,i)}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,i){const r=this._tiles[t];r&&r.setDependencies(e,i)}reloadTilesForDependencies(t,e){for(const i in this._tiles)this._tiles[i].hasDependency(t,e)&&this._reloadTile(i,"reloading");this._cache.filter((i=>!i.hasDependency(t,e)))}}function Ju(t,e){const i=Math.abs(2*t.wrap)-+(t.wrap<0),r=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||r-i||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function Qu(t){return"raster"===t||"image"===t||"video"===t}Yu.maxOverzooming=10,Yu.maxUnderzooming=3;class tp{constructor(t,e){this.reset(t,e)}reset(t,e){this.points=t||[],this._distances=[0];for(let t=1;t<this.points.length;t++)this._distances[t]=this._distances[t-1]+this.points[t].dist(this.points[t-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(e||0,.5*this.length),this.paddedLength=this.length-2*this.padding}lerp(t){if(1===this.points.length)return this.points[0];t=_(t,0,1);let e=1,i=this._distances[e];const r=t*this.paddedLength+this.padding;for(;i<r&&e<this._distances.length;)i=this._distances[++e];const s=e-1,n=this._distances[s],a=i-n,o=a>0?(r-n)/a:0;return this.points[s].mult(1-o).add(this.points[e].mult(o))}}function ep(t,e){let i=!0;return"always"===t||"never"!==t&&"never"!==e||(i=!1),i}class ip{constructor(t,e,i){const r=this.boxCells=[],s=this.circleCells=[];this.xCellCount=Math.ceil(t/i),this.yCellCount=Math.ceil(e/i);for(let t=0;t<this.xCellCount*this.yCellCount;t++)r.push([]),s.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=t,this.height=e,this.xScale=this.xCellCount/t,this.yScale=this.yCellCount/e,this.boxUid=0,this.circleUid=0}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(t,e,i,r,s){this._forEachCell(e,i,r,s,this._insertBoxCell,this.boxUid++),this.boxKeys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(s)}insertCircle(t,e,i,r){this._forEachCell(e-r,i-r,e+r,i+r,this._insertCircleCell,this.circleUid++),this.circleKeys.push(t),this.circles.push(e),this.circles.push(i),this.circles.push(r)}_insertBoxCell(t,e,i,r,s,n){this.boxCells[s].push(n)}_insertCircleCell(t,e,i,r,s,n){this.circleCells[s].push(n)}_query(t,e,i,r,s,n,a){if(i<0||t>this.width||r<0||e>this.height)return[];const o=[];if(t<=0&&e<=0&&this.width<=i&&this.height<=r){if(s)return[{key:null,x1:t,y1:e,x2:i,y2:r}];for(let t=0;t<this.boxKeys.length;t++)o.push({key:this.boxKeys[t],x1:this.bboxes[4*t],y1:this.bboxes[4*t+1],x2:this.bboxes[4*t+2],y2:this.bboxes[4*t+3]});for(let t=0;t<this.circleKeys.length;t++){const e=this.circles[3*t],i=this.circles[3*t+1],r=this.circles[3*t+2];o.push({key:this.circleKeys[t],x1:e-r,y1:i-r,x2:e+r,y2:i+r})}}else this._forEachCell(t,e,i,r,this._queryCell,o,{hitTest:s,overlapMode:n,seenUids:{box:{},circle:{}}},a);return o}query(t,e,i,r){return this._query(t,e,i,r,!1,null)}hitTest(t,e,i,r,s,n){return this._query(t,e,i,r,!0,s,n).length>0}hitTestCircle(t,e,i,r,s){const n=t-i,a=t+i,o=e-i,l=e+i;if(a<0||n>this.width||l<0||o>this.height)return!1;const c=[];return this._forEachCell(n,o,a,l,this._queryCellCircle,c,{hitTest:!0,overlapMode:r,circle:{x:t,y:e,radius:i},seenUids:{box:{},circle:{}}},s),c.length>0}_queryCell(t,e,i,r,s,n,a,o){const{seenUids:l,hitTest:c,overlapMode:h}=a,u=this.boxCells[s];if(null!==u){const s=this.bboxes;for(const a of u)if(!l.box[a]){l.box[a]=!0;const u=4*a,p=this.boxKeys[a];if(t<=s[u+2]&&e<=s[u+3]&&i>=s[u+0]&&r>=s[u+1]&&(!o||o(p))&&(!c||!ep(h,p.overlapMode))&&(n.push({key:p,x1:s[u],y1:s[u+1],x2:s[u+2],y2:s[u+3]}),c))return!0}}const p=this.circleCells[s];if(null!==p){const s=this.circles;for(const a of p)if(!l.circle[a]){l.circle[a]=!0;const u=3*a,p=this.circleKeys[a];if(this._circleAndRectCollide(s[u],s[u+1],s[u+2],t,e,i,r)&&(!o||o(p))&&(!c||!ep(h,p.overlapMode))){const t=s[u],e=s[u+1],i=s[u+2];if(n.push({key:p,x1:t-i,y1:e-i,x2:t+i,y2:e+i}),c)return!0}}}return!1}_queryCellCircle(t,e,i,r,s,n,a,o){const{circle:l,seenUids:c,overlapMode:h}=a,u=this.boxCells[s];if(null!==u){const t=this.bboxes;for(const e of u)if(!c.box[e]){c.box[e]=!0;const i=4*e,r=this.boxKeys[e];if(this._circleAndRectCollide(l.x,l.y,l.radius,t[i+0],t[i+1],t[i+2],t[i+3])&&(!o||o(r))&&!ep(h,r.overlapMode))return n.push(!0),!0}}const p=this.circleCells[s];if(null!==p){const t=this.circles;for(const e of p)if(!c.circle[e]){c.circle[e]=!0;const i=3*e,r=this.circleKeys[e];if(this._circlesCollide(t[i],t[i+1],t[i+2],l.x,l.y,l.radius)&&(!o||o(r))&&!ep(h,r.overlapMode))return n.push(!0),!0}}}_forEachCell(t,e,i,r,s,n,a,o){const l=this._convertToXCellCoord(t),c=this._convertToYCellCoord(e),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(r);for(let p=l;p<=h;p++)for(let l=c;l<=u;l++)if(s.call(this,t,e,i,r,this.xCellCount*l+p,n,a,o))return}_convertToXCellCoord(t){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(t*this.xScale)))}_convertToYCellCoord(t){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(t*this.yScale)))}_circlesCollide(t,e,i,r,s,n){const a=r-t,o=s-e,l=i+n;return l*l>a*a+o*o}_circleAndRectCollide(t,e,i,r,s,n,a){const o=(n-r)/2,l=Math.abs(t-(r+o));if(l>o+i)return!1;const c=(a-s)/2,h=Math.abs(e-(s+c));if(h>c+i)return!1;if(l<=o||h<=c)return!0;const u=l-o,p=h-c;return u*u+p*p<=i*i}}function rp(t,e,i,r,s){const n=Co();return e?(Do(n,n,[1/s,1/s,1]),i||Ro(n,n,r.angle)):Mo(n,r.labelPlaneMatrix,t),n}function sp(t,e,i,r,s){if(e){const e=Eo(t);return Do(e,e,[s,s,1]),i||Ro(e,e,-r.angle),e}return r.glCoordMatrix}function np(t,e,i,r){let s;r?(s=[t,e,r(t,e),1],jo(s,s,i)):(s=[t,e,0,1],vp(s,s,i));const n=s[3];return{point:new a(s[0]/n,s[1]/n),signedDistanceFromCamera:n,isOccluded:!1}}function ap(t,e){return.5+t/e*.5}function op(t,e){return t.x>=-e[0]&&t.x<=e[0]&&t.y>=-e[1]&&t.y<=e[1]}function lp(t,e,i,r,s,n,o,l,c,h,u,p,d,f,m){const _=r?t.textSizeData:t.iconSizeData,g=mh(_,i.transform.zoom),y=[256/i.width*2+1,256/i.height*2+1],x=r?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;x.clear();const v=t.lineVertexArray,b=r?t.text.placedSymbolArray:t.icon.placedSymbolArray,w=i.transform.width/i.transform.height;let T=!1;for(let r=0;r<b.length;r++){const S=b.get(r);if(S.hidden||S.writingMode===ch.vertical&&!T){xp(S.numGlyphs,x);continue}T=!1;const I=np(S.anchorX,S.anchorY,e,m);if(!op(I.point,y)){xp(S.numGlyphs,x);continue}const A=ap(i.transform.cameraToCenterDistance,I.signedDistanceFromCamera),C=fh(_,g,S),E=o?C/A:C*A,z={getElevation:m,labelPlaneMatrix:s,lineVertexArray:v,pitchWithMap:o,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},projection:h,tileAnchorPoint:new a(S.anchorX,S.anchorY),unwrappedTileID:u,width:p,height:d,translation:f},P=up(z,S,E,!1,l,e,n,t.glyphOffsetArray,x,w,c);T=P.useVertical,(P.notEnoughRoom||T||P.needsFlipping&&up(z,S,E,!0,l,e,n,t.glyphOffsetArray,x,w,c).notEnoughRoom)&&xp(S.numGlyphs,x)}r?t.text.dynamicLayoutVertexBuffer.updateData(x):t.icon.dynamicLayoutVertexBuffer.updateData(x)}function cp(t,e,i,r,s,n,a,o){const l=n.glyphStartIndex+n.numGlyphs,c=n.lineStartIndex,h=n.lineStartIndex+n.lineLength,u=e.getoffsetX(n.glyphStartIndex),p=e.getoffsetX(l-1),d=gp(t*u,i,r,s,n.segment,c,h,o,a);if(!d)return null;const f=gp(t*p,i,r,s,n.segment,c,h,o,a);return f?o.projectionCache.anyProjectionOccluded?null:{first:d,last:f}:null}function hp(t,e,i,r){return t===ch.horizontal&&Math.abs(i.y-e.y)>Math.abs(i.x-e.x)*r?{useVertical:!0}:(t===ch.vertical?e.y<i.y:e.x>i.x)?{needsFlipping:!0}:null}function up(t,e,i,r,s,n,o,l,c,h,u){const p=i/24,d=e.lineOffsetX*p,f=e.lineOffsetY*p;let m;if(e.numGlyphs>1){const i=e.glyphStartIndex+e.numGlyphs,n=e.lineStartIndex,a=e.lineStartIndex+e.lineLength,c=cp(p,l,d,f,r,e,u,t);if(!c)return{notEnoughRoom:!0};const _=np(c.first.point.x,c.first.point.y,o,t.getElevation).point,g=np(c.last.point.x,c.last.point.y,o,t.getElevation).point;if(s&&!r){const t=hp(e.writingMode,_,g,h);if(t)return t}m=[c.first];for(let s=e.glyphStartIndex+1;s<i-1;s++)m.push(gp(p*l.getoffsetX(s),d,f,r,e.segment,n,a,t,u));m.push(c.last)}else{if(s&&!r){const i=np(t.tileAnchorPoint.x,t.tileAnchorPoint.y,n,t.getElevation).point,r=e.lineStartIndex+e.segment+1,s=new a(t.lineVertexArray.getx(r),t.lineVertexArray.gety(r)),o=np(s.x,s.y,n,t.getElevation),l=o.signedDistanceFromCamera>0?o.point:function(t,e,i,r,s,n){return pp(t,e,i,1,s,n)}(t.tileAnchorPoint,s,i,0,n,t),c=hp(e.writingMode,i,l,h);if(c)return c}const i=gp(p*l.getoffsetX(e.glyphStartIndex),d,f,r,e.segment,e.lineStartIndex,e.lineStartIndex+e.lineLength,t,u);if(!i||t.projectionCache.anyProjectionOccluded)return{notEnoughRoom:!0};m=[i]}for(const t of m)vh(c,t.point,t.angle);return{}}function pp(t,e,i,r,s,n){const a=t.add(t.sub(e)._unit()),o=void 0!==s?np(a.x,a.y,s,n.getElevation).point:fp(a.x,a.y,n).point,l=i.sub(o);return i.add(l._mult(r/l.mag()))}function dp(t,e,i){const r=e.projectionCache;if(r.projections[t])return r.projections[t];const s=new a(e.lineVertexArray.getx(t),e.lineVertexArray.gety(t)),n=fp(s.x,s.y,e);if(n.signedDistanceFromCamera>0)return r.projections[t]=n.point,r.anyProjectionOccluded=r.anyProjectionOccluded||n.isOccluded,n.point;const o=t-i.direction;return function(t,e,i,r,s){return pp(t,e,i,r,void 0,s)}(0===i.distanceFromAnchor?e.tileAnchorPoint:new a(e.lineVertexArray.getx(o),e.lineVertexArray.gety(o)),s,i.previousVertex,i.absOffsetX-i.distanceFromAnchor+1,e)}function fp(t,e,i){const r=t+i.translation[0],s=e+i.translation[1];let n;return!i.pitchWithMap&&i.projection.useSpecialProjectionForSymbols?(n=i.projection.projectTileCoordinates(r,s,i.unwrappedTileID,i.getElevation),n.point.x=(.5*n.point.x+.5)*i.width,n.point.y=(.5*-n.point.y+.5)*i.height):(n=np(r,s,i.labelPlaneMatrix,i.getElevation),n.isOccluded=!1),n}function mp(t,e,i){return t._unit()._perp()._mult(e*i)}function _p(t,e,i,r,s,n,o,l,c){if(l.projectionCache.offsets[t])return l.projectionCache.offsets[t];const h=i.add(e);if(t+c.direction<r||t+c.direction>=s)return l.projectionCache.offsets[t]=h,h;const u=dp(t+c.direction,l,c),p=mp(u.sub(i),o,c.direction),d=i.add(p),f=u.add(p);return l.projectionCache.offsets[t]=function(t,e,i,r){const s=e.y-t.y,n=e.x-t.x,o=r.y-i.y,l=r.x-i.x,c=o*n-l*s;if(0===c)return null;const h=(l*(t.y-i.y)-o*(t.x-i.x))/c;return new a(t.x+h*n,t.y+h*s)}(n,h,d,f)||h,l.projectionCache.offsets[t]}function gp(t,e,i,r,s,n,a,o,l){const c=r?t-e:t+e;let h=c>0?1:-1,u=0;r&&(h*=-1,u=Math.PI),h<0&&(u+=Math.PI);let p,d=h>0?n+s:n+s+1;o.projectionCache.cachedAnchorPoint?p=o.projectionCache.cachedAnchorPoint:(p=fp(o.tileAnchorPoint.x,o.tileAnchorPoint.y,o).point,o.projectionCache.cachedAnchorPoint=p);let f,m,_=p,g=p,y=0,x=0;const v=Math.abs(c),b=[];let w;for(;y+x<=v;){if(d+=h,d<n||d>=a)return null;y+=x,g=_,m=f;const t={absOffsetX:v,direction:h,distanceFromAnchor:y,previousVertex:g};if(_=dp(d,o,t),0===i)b.push(g),w=_.sub(g);else{let e;const r=_.sub(g);e=0===r.mag()?mp(dp(d+h,o,t).sub(_),i,h):mp(r,i,h),m||(m=g.add(e)),f=_p(d,e,_,n,a,m,i,o,t),b.push(m),w=f.sub(m)}x=w.mag()}const T=w._mult((v-y)/x)._add(m||g),S=u+Math.atan2(_.y-g.y,_.x-g.x);return b.push(T),{point:T,angle:l?S:0,path:b}}const yp=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function xp(t,e){for(let i=0;i<t;i++){const t=e.length;e.resize(t+4),e.float32.set(yp,3*t)}}function vp(t,e,i){const r=e[0],s=e[1];return t[0]=i[0]*r+i[4]*s+i[12],t[1]=i[1]*r+i[5]*s+i[13],t[3]=i[3]*r+i[7]*s+i[15],t}const bp=100;class wp{constructor(t,e,i=new ip(t.width+200,t.height+200,25),r=new ip(t.width+200,t.height+200,25)){this.transform=t,this.mapProjection=e,this.grid=i,this.ignoredGrid=r,this.pitchFactor=Math.cos(t._pitch)*t.cameraToCenterDistance,this.screenRightBoundary=t.width+bp,this.screenBottomBoundary=t.height+bp,this.gridRightBoundary=t.width+200,this.gridBottomBoundary=t.height+200,this.perspectiveRatioCutoff=.6}placeCollisionBox(t,e,i,r,s,n,a,o,l,c,h){const u=t.anchorPointX+o[0],p=t.anchorPointY+o[1],d=this.projectAndGetPerspectiveRatio(r,u,p,s,c),f=i*d.perspectiveRatio;let m;if(n||a)m=this._projectCollisionBox(t,f,r,s,n,a,o,d,c,h);else{const e=d.point.x+(h?h.x*f:0),i=d.point.y+(h?h.y*f:0);m={allPointsOccluded:!1,box:[e+t.x1*f,i+t.y1*f,e+t.x2*f,i+t.y2*f]}}const[_,g,y,x]=m.box;return this.mapProjection.useSpecialProjectionForSymbols&&(n?m.allPointsOccluded:this.mapProjection.isOccluded(u,p,s))||d.perspectiveRatio<this.perspectiveRatioCutoff||!this.isInsideGrid(_,g,y,x)||"always"!==e&&this.grid.hitTest(_,g,y,x,e,l)?{box:[_,g,y,x],placeable:!1,offscreen:!1}:{box:[_,g,y,x],placeable:!0,offscreen:this.isOffscreen(_,g,y,x)}}placeCollisionCircles(t,e,i,r,s,n,o,l,c,h,u,p,d,f,m,_){const g=[],y=new a(e.anchorX,e.anchorY),x=this.getPerspectiveRatio(n,y.x,y.y,o,_),v=(u?s/x:s*x)/24,b={getElevation:_,labelPlaneMatrix:l,lineVertexArray:i,pitchWithMap:u,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},projection:this.mapProjection,tileAnchorPoint:y,unwrappedTileID:o,width:this.transform.width,height:this.transform.height,translation:m},w=cp(v,r,e.lineOffsetX*v,e.lineOffsetY*v,!1,e,!1,b);let T=!1,S=!1,I=!0;if(w){const e=.5*d*x+f,i=new a(-100,-100),r=new a(this.screenRightBoundary,this.screenBottomBoundary),s=new tp,n=w.first,o=w.last;let l=[];for(let t=n.path.length-1;t>=1;t--)l.push(n.path[t]);for(let t=1;t<o.path.length;t++)l.push(o.path[t]);const u=2.5*e;if(c){const t=this.projectPathToScreenSpace(l,b,c);l=t.some((t=>t.signedDistanceFromCamera<=0))?[]:t.map((t=>t.point))}let m=[];if(l.length>0){const t=l[0].clone(),e=l[0].clone();for(let i=1;i<l.length;i++)t.x=Math.min(t.x,l[i].x),t.y=Math.min(t.y,l[i].y),e.x=Math.max(e.x,l[i].x),e.y=Math.max(e.y,l[i].y);m=t.x>=i.x&&e.x<=r.x&&t.y>=i.y&&e.y<=r.y?[l]:e.x<i.x||t.x>r.x||e.y<i.y||t.y>r.y?[]:function(t,e,i,r,s){const n=[];for(let o=0;o<t.length;o++){const l=t[o];let c;for(let t=0;t<l.length-1;t++){let o=l[t],h=l[t+1];o.x<e&&h.x<e||(o.x<e?o=new a(e,o.y+(e-o.x)/(h.x-o.x)*(h.y-o.y))._round():h.x<e&&(h=new a(e,o.y+(e-o.x)/(h.x-o.x)*(h.y-o.y))._round()),o.y<i&&h.y<i||(o.y<i?o=new a(o.x+(i-o.y)/(h.y-o.y)*(h.x-o.x),i)._round():h.y<i&&(h=new a(o.x+(i-o.y)/(h.y-o.y)*(h.x-o.x),i)._round()),o.x>=r&&h.x>=r||(o.x>=r?o=new a(r,o.y+(r-o.x)/(h.x-o.x)*(h.y-o.y))._round():h.x>=r&&(h=new a(r,o.y+(r-o.x)/(h.x-o.x)*(h.y-o.y))._round()),o.y>=s&&h.y>=s||(o.y>=s?o=new a(o.x+(s-o.y)/(h.y-o.y)*(h.x-o.x),s)._round():h.y>=s&&(h=new a(o.x+(s-o.y)/(h.y-o.y)*(h.x-o.x),s)._round()),c&&o.equals(c[c.length-1])||(c=[o],n.push(c)),c.push(h)))))}}return n}([l],i.x,i.y,r.x,r.y)}for(const i of m){s.reset(i,.25*e);let r=0;r=s.length<=.5*e?1:Math.ceil(s.paddedLength/u)+1;for(let i=0;i<r;i++){const n=i/Math.max(r-1,1),a=s.lerp(n),o=a.x+bp,l=a.y+bp;g.push(o,l,e,0);const c=o-e,u=l-e,d=o+e,f=l+e;if(I=I&&this.isOffscreen(c,u,d,f),S=S||this.isInsideGrid(c,u,d,f),"always"!==t&&this.grid.hitTestCircle(o,l,e,t,p)&&(T=!0,!h))return{circles:[],offscreen:!1,collisionDetected:T}}}}return{circles:!h&&T||!S||x<this.perspectiveRatioCutoff?[]:g,offscreen:I,collisionDetected:T}}projectPathToScreenSpace(t,e,i){return t.map((t=>np(t.x,t.y,i,e.getElevation)))}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return{};const e=[];let i=1/0,r=1/0,s=-1/0,n=-1/0;for(const o of t){const t=new a(o.x+bp,o.y+bp);i=Math.min(i,t.x),r=Math.min(r,t.y),s=Math.max(s,t.x),n=Math.max(n,t.y),e.push(t)}const o=this.grid.query(i,r,s,n).concat(this.ignoredGrid.query(i,r,s,n)),l={},c={};for(const t of o){const i=t.key;void 0===l[i.bucketInstanceId]&&(l[i.bucketInstanceId]={}),l[i.bucketInstanceId][i.featureIndex]||oo(e,[new a(t.x1,t.y1),new a(t.x2,t.y1),new a(t.x2,t.y2),new a(t.x1,t.y2)])&&(l[i.bucketInstanceId][i.featureIndex]=!0,void 0===c[i.bucketInstanceId]&&(c[i.bucketInstanceId]=[]),c[i.bucketInstanceId].push(i.featureIndex))}return c}insertCollisionBox(t,e,i,r,s,n){(i?this.ignoredGrid:this.grid).insert({bucketInstanceId:r,featureIndex:s,collisionGroupID:n,overlapMode:e},t[0],t[1],t[2],t[3])}insertCollisionCircles(t,e,i,r,s,n){const a=i?this.ignoredGrid:this.grid,o={bucketInstanceId:r,featureIndex:s,collisionGroupID:n,overlapMode:e};for(let e=0;e<t.length;e+=4)a.insertCircle(o,t[e],t[e+1],t[e+2])}projectAndGetPerspectiveRatio(t,e,i,r,s){let n;s?(n=[e,i,s(e,i),1],jo(n,n,t)):(n=[e,i,0,1],vp(n,n,t));const o=n[3];return{point:new a((n[0]/o+1)/2*this.transform.width+bp,(-n[1]/o+1)/2*this.transform.height+bp),perspectiveRatio:.5+this.transform.cameraToCenterDistance/o*.5,isOccluded:!1,signedDistanceFromCamera:o}}getPerspectiveRatio(t,e,i,r,s){const n=this.mapProjection.useSpecialProjectionForSymbols?this.mapProjection.projectTileCoordinates(e,i,r,s):np(e,i,t,s);return.5+this.transform.cameraToCenterDistance/n.signedDistanceFromCamera*.5}isOffscreen(t,e,i,r){return i<bp||t>=this.screenRightBoundary||r<bp||e>this.screenBottomBoundary}isInsideGrid(t,e,i,r){return i>=0&&t<this.gridRightBoundary&&r>=0&&e<this.gridBottomBoundary}getViewportMatrix(){const t=zo([]);return ko(t,t,[-100,-100,0]),t}_projectCollisionBox(t,e,i,r,s,n,o,l,c,h){let u=new a(1,0),p=new a(0,1);const f=new a(t.anchorPointX+o[0],t.anchorPointY+o[1]);if(n&&!s){const t=this.projectAndGetPerspectiveRatio(i,f.x+1,f.y,r,c).point.sub(l.point).unit(),e=Math.atan(t.y/t.x)+(t.x<0?Math.PI:0),s=Math.sin(e),n=Math.cos(e);u=new a(n,s),p=new a(-s,n)}else if(!n&&s){const t=-this.transform.angle,e=Math.sin(t),i=Math.cos(t);u=new a(i,e),p=new a(-e,i)}let m=l.point,g=e;if(s){m=f;const t=this.transform.zoom-Math.floor(this.transform.zoom);g=Math.pow(2,-t),g*=this.mapProjection.getPitchedTextCorrection(this.transform,f,r),h||(g*=_(.5+l.signedDistanceFromCamera/this.transform.cameraToCenterDistance*.5,0,4))}h&&(m=m.add(u.mult(h.x*g)).add(p.mult(h.y*g)));const y=t.x1*g,x=t.x2*g,v=(y+x)/2,b=t.y1*g,w=t.y2*g,T=(b+w)/2,S=[{offsetX:y,offsetY:b},{offsetX:v,offsetY:b},{offsetX:x,offsetY:b},{offsetX:x,offsetY:T},{offsetX:x,offsetY:w},{offsetX:v,offsetY:w},{offsetX:y,offsetY:w},{offsetX:y,offsetY:T}];let I=[];for(const{offsetX:t,offsetY:e}of S)I.push(new a(m.x+u.x*t+p.x*e,m.y+u.y*t+p.y*e));let A=!1;if(s){const t=I.map((t=>this.projectAndGetPerspectiveRatio(i,t.x,t.y,r,c)));A=t.some((t=>!t.isOccluded)),I=t.map((t=>t.point))}else A=!0;return{box:d(I),allPointsOccluded:!A}}}class Tp extends a{constructor(t,e,i,r){super(t,e),this.angle=i,void 0!==r&&(this.segment=r)}clone(){return new Tp(this.x,this.y,this.angle,this.segment)}}var Sp;function Ip(t,e,i){return e*(to/(t.tileSize*Math.pow(2,i-t.tileID.overscaledZ)))}Ds("Anchor",Tp),function(t){t[t.center=1]="center",t[t.left=2]="left",t[t.right=3]="right",t[t.top=4]="top",t[t.bottom=5]="bottom",t[t["top-left"]=6]="top-left",t[t["top-right"]=7]="top-right",t[t["bottom-left"]=8]="bottom-left",t[t["bottom-right"]=9]="bottom-right"}(Sp||(Sp={}));class Ap{constructor(t,e,i,r){this.opacity=t?Math.max(0,Math.min(1,t.opacity+(t.placed?e:-e))):r&&i?1:0,this.placed=i}isHidden(){return 0===this.opacity&&!this.placed}}class Cp{constructor(t,e,i,r,s){this.text=new Ap(t?t.text:null,e,i,s),this.icon=new Ap(t?t.icon:null,e,r,s)}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class Ep{constructor(t,e,i){this.text=t,this.icon=e,this.skipFade=i}}class zp{constructor(){this.invProjMatrix=Co(),this.viewportMatrix=Co(),this.circles=[]}}class Pp{constructor(t,e,i,r,s){this.bucketInstanceId=t,this.featureIndex=e,this.sourceLayerIndex=i,this.bucketIndex=r,this.tileID=s}}class Mp{constructor(t){this.crossSourceCollisions=t,this.maxGroupID=0,this.collisionGroups={}}get(t){if(this.crossSourceCollisions)return{ID:0,predicate:null};if(!this.collisionGroups[t]){const e=++this.maxGroupID;this.collisionGroups[t]={ID:e,predicate:t=>t.collisionGroupID===e}}return this.collisionGroups[t]}}function kp(t,e,i,r,s){const{horizontalAlign:n,verticalAlign:o}=hh(t);return new a(-(n-.5)*e+r[0]*s,-(o-.5)*i+r[1]*s)}class Dp{constructor(t,e,i,r,s,n){this.transform=t.clone(),this.terrain=i,this.collisionIndex=new wp(this.transform,e),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=r,this.retainedQueryData={},this.collisionGroups=new Mp(s),this.collisionCircleArrays={},this.collisionBoxArrays=new Map,this.prevPlacement=n,n&&(n.prevPlacement=void 0),this.placedOrientations={}}_getTerrainElevationFunc(t){const e=this.terrain;return e?(i,r)=>e.getElevation(t,i,r):null}getBucketParts(t,e,i,r){const s=i.getBucket(e),n=i.latestFeatureIndex;if(!s||!n||e.id!==s.layerIds[0])return;const a=i.collisionBoxArray,o=s.layers[0].layout,l=s.layers[0].paint,c=Math.pow(2,this.transform.zoom-i.tileID.overscaledZ),h=i.tileSize/to,u=i.tileID.toUnwrapped(),p=this.transform.calculatePosMatrix(u),d="map"===o.get("text-pitch-alignment"),f="map"===o.get("text-rotation-alignment"),m=Ip(i,1,this.transform.zoom),_=this.collisionIndex.mapProjection.translatePosition(this.transform,i,l.get("text-translate"),l.get("text-translate-anchor")),g=this.collisionIndex.mapProjection.translatePosition(this.transform,i,l.get("icon-translate"),l.get("icon-translate-anchor")),y=rp(p,d,f,this.transform,m);let x=null;if(d){const t=sp(p,d,f,this.transform,m);x=Mo([],this.transform.labelPlaneMatrix,t)}this.retainedQueryData[s.bucketInstanceId]=new Pp(s.bucketInstanceId,n,s.sourceLayerIndex,s.index,i.tileID);const v={bucket:s,layout:o,translationText:_,translationIcon:g,posMatrix:p,unwrappedTileID:u,textLabelPlaneMatrix:y,labelToScreenMatrix:x,scale:c,textPixelRatio:h,holdingForFade:i.holdingForFade(),collisionBoxArray:a,partiallyEvaluatedTextSize:mh(s.textSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(s.sourceID)};if(r)for(const e of s.sortKeyRanges){const{sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:s}=e;t.push({sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:s,parameters:v})}else t.push({symbolInstanceStart:0,symbolInstanceEnd:s.symbolInstances.length,parameters:v})}attemptAnchorPlacement(t,e,i,r,s,n,a,o,l,c,h,u,p,d,f,m,_,g,y){const x=Sp[t.textAnchor],v=[t.textOffset0,t.textOffset1],b=kp(x,i,r,v,s),w=this.collisionIndex.placeCollisionBox(e,u,o,l,c,a,n,m,h.predicate,y,b);if((!g||this.collisionIndex.placeCollisionBox(g,u,o,l,c,a,n,_,h.predicate,y,b).placeable)&&w.placeable){let t;if(this.prevPlacement&&this.prevPlacement.variableOffsets[p.crossTileID]&&this.prevPlacement.placements[p.crossTileID]&&this.prevPlacement.placements[p.crossTileID].text&&(t=this.prevPlacement.variableOffsets[p.crossTileID].anchor),0===p.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");return this.variableOffsets[p.crossTileID]={textOffset:v,width:i,height:r,anchor:x,textBoxScale:s,prevAnchor:t},this.markUsedJustification(d,x,p,f),d.allowVerticalPlacement&&(this.markUsedOrientation(d,f,p),this.placedOrientations[p.crossTileID]=f),{shift:b,placedGlyphBoxes:w}}}placeLayerBucketPart(t,e,i){const{bucket:r,layout:s,translationText:n,translationIcon:o,posMatrix:l,unwrappedTileID:c,textLabelPlaneMatrix:h,labelToScreenMatrix:u,textPixelRatio:p,holdingForFade:d,collisionBoxArray:f,partiallyEvaluatedTextSize:m,collisionGroup:_}=t.parameters,g=s.get("text-optional"),y=s.get("icon-optional"),x=_h(s,"text-overlap","text-allow-overlap"),v="always"===x,b=_h(s,"icon-overlap","icon-allow-overlap"),w="always"===b,T="map"===s.get("text-rotation-alignment"),S="map"===s.get("text-pitch-alignment"),I="none"!==s.get("icon-text-fit"),A="viewport-y"===s.get("symbol-z-order"),E=v&&(w||!r.hasIconData()||y),z=w&&(v||!r.hasTextData()||g);!r.collisionArrays&&f&&r.deserializeCollisionBoxes(f);const P=this._getTerrainElevationFunc(this.retainedQueryData[r.bucketInstanceId].tileID),M=(t,f,w)=>{var A,M;if(e[t.crossTileID])return;if(d)return void(this.placements[t.crossTileID]=new Ep(!1,!1,!1));let k=!1,D=!1,L=!0,R=null,B={box:null,placeable:!1,offscreen:null},F={box:null,placeable:!1,offscreen:null},O=null,V=null,U=null,N=0,j=0,$=0;f.textFeatureIndex?N=f.textFeatureIndex:t.useRuntimeCollisionCircles&&(N=t.featureIndex),f.verticalTextFeatureIndex&&(j=f.verticalTextFeatureIndex);const q=f.textBox;if(q){const e=e=>{let i=ch.horizontal;if(r.allowVerticalPlacement&&!e&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[t.crossTileID];e&&(this.placedOrientations[t.crossTileID]=e,i=e,this.markUsedOrientation(r,i,t))}return i},s=(e,i)=>{if(r.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&f.verticalTextBox){for(const t of r.writingModes)if(t===ch.vertical?(B=i(),F=B):B=e(),B&&B.placeable)break}else B=e()},h=t.textAnchorOffsetStartIndex,u=t.textAnchorOffsetEndIndex;if(u===h){const i=(e,i)=>{const s=this.collisionIndex.placeCollisionBox(e,x,p,l,c,S,T,n,_.predicate,P);return s&&s.placeable&&(this.markUsedOrientation(r,i,t),this.placedOrientations[t.crossTileID]=i),s};s((()=>i(q,ch.horizontal)),(()=>{const e=f.verticalTextBox;return r.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&e?i(e,ch.vertical):{box:null,offscreen:null}})),e(B&&B.placeable)}else{let d=Sp[null===(M=null===(A=this.prevPlacement)||void 0===A?void 0:A.variableOffsets[t.crossTileID])||void 0===M?void 0:M.anchor];const m=(e,s,f)=>{const m=e.x2-e.x1,g=e.y2-e.y1,y=t.textBoxScale,v=I&&"never"===b?s:null;let w=null,A="never"===x?1:2,C="never";d&&A++;for(let i=0;i<A;i++){for(let i=h;i<u;i++){const s=r.textAnchorOffsets.get(i);if(d&&s.textAnchor!==d)continue;const a=this.attemptAnchorPlacement(s,e,m,g,y,T,S,p,l,c,_,C,t,r,f,n,o,v,P);if(a&&(w=a.placedGlyphBoxes,w&&w.placeable))return k=!0,R=a.shift,w}d?d=null:C=x}return i&&!w&&(w={box:this.collisionIndex.placeCollisionBox(q,"always",p,l,c,S,T,n,_.predicate,P,new a(0,0)).box,offscreen:!1,placeable:!1}),w};s((()=>m(q,f.iconBox,ch.horizontal)),(()=>{const e=f.verticalTextBox;return r.allowVerticalPlacement&&(!B||!B.placeable)&&t.numVerticalGlyphVertices>0&&e?m(e,f.verticalIconBox,ch.vertical):{box:null,occluded:!0,offscreen:null}})),B&&(k=B.placeable,L=B.offscreen);const g=e(B&&B.placeable);if(!k&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[t.crossTileID];e&&(this.variableOffsets[t.crossTileID]=e,this.markUsedJustification(r,e.anchor,t,g))}}}if(O=B,k=O&&O.placeable,L=O&&O.offscreen,t.useRuntimeCollisionCircles){const e=r.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex),a=fh(r.textSizeData,m,e),o=s.get("text-padding");V=this.collisionIndex.placeCollisionCircles(x,e,r.lineVertexArray,r.glyphOffsetArray,a,l,c,h,u,i,S,_.predicate,t.collisionCircleDiameter,o,n,P),V.circles.length&&V.collisionDetected&&!i&&C("Collisions detected, but collision boxes are not shown"),k=v||V.circles.length>0&&!V.collisionDetected,L=L&&V.offscreen}if(f.iconFeatureIndex&&($=f.iconFeatureIndex),f.iconBox){const t=t=>this.collisionIndex.placeCollisionBox(t,b,p,l,c,S,T,o,_.predicate,P,I&&R?R:void 0);F&&F.placeable&&f.verticalIconBox?(U=t(f.verticalIconBox),D=U.placeable):(U=t(f.iconBox),D=U.placeable),L=L&&U.offscreen}const Z=g||0===t.numHorizontalGlyphVertices&&0===t.numVerticalGlyphVertices,G=y||0===t.numIconVertices;Z||G?G?Z||(D=D&&k):k=D&&k:D=k=D&&k;const W=D&&U.placeable;if(k&&O.placeable&&this.collisionIndex.insertCollisionBox(O.box,x,s.get("text-ignore-placement"),r.bucketInstanceId,F&&F.placeable&&j?j:N,_.ID),W&&this.collisionIndex.insertCollisionBox(U.box,b,s.get("icon-ignore-placement"),r.bucketInstanceId,$,_.ID),V&&k&&this.collisionIndex.insertCollisionCircles(V.circles,x,s.get("text-ignore-placement"),r.bucketInstanceId,N,_.ID),i&&this.storeCollisionData(r.bucketInstanceId,w,f,O,U,V),0===t.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");if(0===r.bucketInstanceId)throw new Error("bucket.bucketInstanceId can't be 0");this.placements[t.crossTileID]=new Ep(k||E,D||z,L||r.justReloaded),e[t.crossTileID]=!0};if(A){if(0!==t.symbolInstanceStart)throw new Error("bucket.bucketInstanceId should be 0");const e=r.getSortedSymbolIndexes(this.transform.angle);for(let t=e.length-1;t>=0;--t){const i=e[t];M(r.symbolInstances.get(i),r.collisionArrays[i],i)}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)M(r.symbolInstances.get(e),r.collisionArrays[e],e);if(i&&r.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[r.bucketInstanceId];Po(t.invProjMatrix,l),t.viewportMatrix=this.collisionIndex.getViewportMatrix()}r.justReloaded=!1}storeCollisionData(t,e,i,r,s,n){if(i.textBox||i.iconBox){let n,a;this.collisionBoxArrays.has(t)?n=this.collisionBoxArrays.get(t):(n=new Map,this.collisionBoxArrays.set(t,n)),n.has(e)?a=n.get(e):(a={text:null,icon:null},n.set(e,a)),i.textBox&&(a.text=r.box),i.iconBox&&(a.icon=s.box)}if(n){let e=this.collisionCircleArrays[t];void 0===e&&(e=this.collisionCircleArrays[t]=new zp);for(let t=0;t<n.circles.length;t+=4)e.circles.push(n.circles[t+0]),e.circles.push(n.circles[t+1]),e.circles.push(n.circles[t+2]),e.circles.push(n.collisionDetected?1:0)}}markUsedJustification(t,e,i,r){let s;s=r===ch.vertical?i.verticalPlacedTextSymbolIndex:{left:i.leftJustifiedTextSymbolIndex,center:i.centerJustifiedTextSymbolIndex,right:i.rightJustifiedTextSymbolIndex}[function(t){switch(t){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left"}return"center"}(e)];const n=[i.leftJustifiedTextSymbolIndex,i.centerJustifiedTextSymbolIndex,i.rightJustifiedTextSymbolIndex,i.verticalPlacedTextSymbolIndex];for(const e of n)e>=0&&(t.text.placedSymbolArray.get(e).crossTileID=s>=0&&e!==s?0:i.crossTileID)}markUsedOrientation(t,e,i){const r=e===ch.horizontal||e===ch.horizontalOnly?e:0,s=e===ch.vertical?e:0,n=[i.leftJustifiedTextSymbolIndex,i.centerJustifiedTextSymbolIndex,i.rightJustifiedTextSymbolIndex];for(const e of n)t.text.placedSymbolArray.get(e).placedOrientation=r;i.verticalPlacedTextSymbolIndex&&(t.text.placedSymbolArray.get(i.verticalPlacedTextSymbolIndex).placedOrientation=s)}commit(t){this.commitTime=t,this.zoomAtLastRecencyCheck=this.transform.zoom;const e=this.prevPlacement;let i=!1;this.prevZoomAdjustment=e?e.zoomAdjustment(this.transform.zoom):0;const r=e?e.symbolFadeChange(t):1,s=e?e.opacities:{},n=e?e.variableOffsets:{},a=e?e.placedOrientations:{};for(const t in this.placements){const e=this.placements[t],n=s[t];n?(this.opacities[t]=new Cp(n,r,e.text,e.icon),i=i||e.text!==n.text.placed||e.icon!==n.icon.placed):(this.opacities[t]=new Cp(null,r,e.text,e.icon,e.skipFade),i=i||e.text||e.icon)}for(const t in s){const e=s[t];if(!this.opacities[t]){const s=new Cp(e,r,!1,!1);s.isHidden()||(this.opacities[t]=s,i=i||e.text.placed||e.icon.placed)}}for(const t in n)this.variableOffsets[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.variableOffsets[t]=n[t]);for(const t in a)this.placedOrientations[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.placedOrientations[t]=a[t]);if(e&&void 0===e.lastPlacementChangeTime)throw new Error("Last placement time for previous placement is not defined");i?this.lastPlacementChangeTime=t:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=e?e.lastPlacementChangeTime:t)}updateLayerOpacities(t,e){const i={};for(const r of e){const e=r.getBucket(t);e&&r.latestFeatureIndex&&t.id===e.layerIds[0]&&this.updateBucketOpacities(e,r.tileID,i,r.collisionBoxArray)}}updateBucketOpacities(t,e,i,r){t.hasTextData()&&(t.text.opacityVertexArray.clear(),t.text.hasVisibleVertices=!1),t.hasIconData()&&(t.icon.opacityVertexArray.clear(),t.icon.hasVisibleVertices=!1),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const s=t.layers[0],n=s.layout,o=new Cp(null,0,!1,!1,!0),l=n.get("text-allow-overlap"),c=n.get("icon-allow-overlap"),h=s._unevaluatedLayout.hasValue("text-variable-anchor")||s._unevaluatedLayout.hasValue("text-variable-anchor-offset"),u="map"===n.get("text-rotation-alignment"),p="map"===n.get("text-pitch-alignment"),d="none"!==n.get("icon-text-fit"),f=new Cp(null,0,l&&(c||!t.hasIconData()||n.get("icon-optional")),c&&(l||!t.hasTextData()||n.get("text-optional")),!0);!t.collisionArrays&&r&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(r);const m=(t,e,i)=>{for(let r=0;r<e/4;r++)t.opacityVertexArray.emplaceBack(i);t.hasVisibleVertices=t.hasVisibleVertices||i!==$p},_=this.collisionBoxArrays.get(t.bucketInstanceId);for(let e=0;e<t.symbolInstances.length;e++){const r=t.symbolInstances.get(e),{numHorizontalGlyphVertices:s,numVerticalGlyphVertices:n,crossTileID:l}=r;let c=this.opacities[l];i[l]?c=o:c||(c=f,this.opacities[l]=c),i[l]=!0;const g=r.numIconVertices>0,y=this.placedOrientations[r.crossTileID],x=y===ch.vertical,v=y===ch.horizontal||y===ch.horizontalOnly;if(s>0||n>0){const e=jp(c.text);m(t.text,s,x?$p:e),m(t.text,n,v?$p:e);const i=c.text.isHidden();[r.rightJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.leftJustifiedTextSymbolIndex].forEach((e=>{e>=0&&(t.text.placedSymbolArray.get(e).hidden=i||x?1:0)})),r.verticalPlacedTextSymbolIndex>=0&&(t.text.placedSymbolArray.get(r.verticalPlacedTextSymbolIndex).hidden=i||v?1:0);const a=this.variableOffsets[r.crossTileID];a&&this.markUsedJustification(t,a.anchor,r,y);const o=this.placedOrientations[r.crossTileID];o&&(this.markUsedJustification(t,"left",r,o),this.markUsedOrientation(t,o,r))}if(g){const e=jp(c.icon),i=!(d&&r.verticalPlacedIconSymbolIndex&&x);r.placedIconSymbolIndex>=0&&(m(t.icon,r.numIconVertices,i?e:$p),t.icon.placedSymbolArray.get(r.placedIconSymbolIndex).hidden=c.icon.isHidden()),r.verticalPlacedIconSymbolIndex>=0&&(m(t.icon,r.numVerticalIconVertices,i?$p:e),t.icon.placedSymbolArray.get(r.verticalPlacedIconSymbolIndex).hidden=c.icon.isHidden())}const b=_&&_.has(e)?_.get(e):{text:null,icon:null};if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[e];if(i){let e=new a(0,0);if(i.textBox||i.verticalTextBox){let r=!0;if(h){const t=this.variableOffsets[l];t?(e=kp(t.anchor,t.width,t.height,t.textOffset,t.textBoxScale),u&&e._rotate(p?this.transform.angle:-this.transform.angle)):r=!1}if(i.textBox||i.verticalTextBox){let s;i.textBox&&(s=x),i.verticalTextBox&&(s=v),Lp(t.textCollisionBox.collisionVertexArray,c.text.placed,!r||s,b.text,e.x,e.y)}}if(i.iconBox||i.verticalIconBox){const r=Boolean(!v&&i.verticalIconBox);let s;i.iconBox&&(s=r),i.verticalIconBox&&(s=!r),Lp(t.iconCollisionBox.collisionVertexArray,c.icon.placed,s,b.icon,d?e.x:0,d?e.y:0)}}}}if(t.sortFeatures(this.transform.angle),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.text.opacityVertexArray.length!==t.text.layoutVertexArray.length/4)throw new Error(`bucket.text.opacityVertexArray.length (= ${t.text.opacityVertexArray.length}) !== bucket.text.layoutVertexArray.length (= ${t.text.layoutVertexArray.length}) / 4`);if(t.icon.opacityVertexArray.length!==t.icon.layoutVertexArray.length/4)throw new Error(`bucket.icon.opacityVertexArray.length (= ${t.icon.opacityVertexArray.length}) !== bucket.icon.layoutVertexArray.length (= ${t.icon.layoutVertexArray.length}) / 4`);if(t.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[t.bucketInstanceId];t.placementInvProjMatrix=e.invProjMatrix,t.placementViewportMatrix=e.viewportMatrix,t.collisionCircleArray=e.circles,delete this.collisionCircleArrays[t.bucketInstanceId]}}symbolFadeChange(t){return 0===this.fadeDuration?1:(t-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(t){return Math.max(0,(this.transform.zoom-t)/1.5)}hasTransitions(t){return this.stale||t-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(t,e){const i=this.zoomAtLastRecencyCheck===e?1-this.zoomAdjustment(e):1;return this.zoomAtLastRecencyCheck=e,this.commitTime+this.fadeDuration*i>t}setStale(){this.stale=!0}}function Lp(t,e,i,r,s,n){r&&0!==r.length||(r=[0,0,0,0]);const a=r[0]-bp,o=r[1]-bp,l=r[2]-bp,c=r[3]-bp;t.emplaceBack(e?1:0,i?1:0,s||0,n||0,a,o),t.emplaceBack(e?1:0,i?1:0,s||0,n||0,l,o),t.emplaceBack(e?1:0,i?1:0,s||0,n||0,l,c),t.emplaceBack(e?1:0,i?1:0,s||0,n||0,a,c)}const Rp=Math.pow(2,25),Bp=Math.pow(2,24),Fp=Math.pow(2,17),Op=Math.pow(2,16),Vp=Math.pow(2,9),Up=Math.pow(2,8),Np=Math.pow(2,1);function jp(t){if(0===t.opacity&&!t.placed)return 0;if(1===t.opacity&&t.placed)return 4294967295;const e=t.placed?1:0,i=Math.floor(127*t.opacity);return i*Rp+e*Bp+i*Fp+e*Op+i*Vp+e*Up+i*Np+e}const $p=0;function qp(){return{isOccluded:(t,e,i)=>!1,getPitchedTextCorrection:(t,e,i)=>1,get useSpecialProjectionForSymbols(){return!1},projectTileCoordinates(t,e,i,r){throw new Error("Not implemented.")},translatePosition:(t,e,i,r)=>function(t,e,i,r,s=!1){if(!i[0]&&!i[1])return[0,0];const n=s?"map"===r?t.angle:0:"viewport"===r?-t.angle:0;if(n){const t=Math.sin(n),e=Math.cos(n);i=[i[0]*e-i[1]*t,i[0]*t+i[1]*e]}return[s?i[0]:Ip(e,i[0],t.zoom),s?i[1]:Ip(e,i[1],t.zoom)]}(t,e,i,r),getCircleRadiusCorrection:t=>1}}class Zp{constructor(t){this._sortAcrossTiles="viewport-y"!==t.layout.get("symbol-z-order")&&!t.layout.get("symbol-sort-key").isConstant(),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[]}continuePlacement(t,e,i,r,s){const n=this._bucketParts;for(;this._currentTileIndex<t.length;)if(e.getBucketParts(n,r,t[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,s())return!0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,n.sort(((t,e)=>t.sortKey-e.sortKey)));this._currentPartIndex<n.length;)if(e.placeLayerBucketPart(n[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,s())return!0;return!1}}class Gp{constructor(t,e,i,r,s,n,a,o){this.placement=new Dp(t,qp(),e,n,a,o),this._currentPlacementIndex=i.length-1,this._forceFullPlacement=r,this._showCollisionBoxes=s,this._done=!1}isDone(){return this._done}continuePlacement(t,e,i){const r=F.now(),s=()=>!this._forceFullPlacement&&F.now()-r>2;for(;this._currentPlacementIndex>=0;){const r=e[t[this._currentPlacementIndex]],n=this.placement.collisionIndex.transform.zoom;if("symbol"===r.type&&(!r.minzoom||r.minzoom<=n)&&(!r.maxzoom||r.maxzoom>n)){if(this._inProgressLayer||(this._inProgressLayer=new Zp(r)),this._inProgressLayer.continuePlacement(i[r.source],this.placement,this._showCollisionBoxes,r,s))return;delete this._inProgressLayer}this._currentPlacementIndex--}this._done=!0}commit(t){return this.placement.commit(t),this.placement}}const Wp=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class Hp{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,i]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const r=i>>4;if(1!==r)throw new Error(`Got v${r} data when expected v1.`);const s=Wp[15&i];if(!s)throw new Error("Unrecognized array type.");const[n]=new Uint16Array(t,2,1),[a]=new Uint32Array(t,4,1);return new Hp(a,n,s,t)}constructor(t,e=64,i=Float64Array,r){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=i,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const s=Wp.indexOf(this.ArrayType),n=2*t*this.ArrayType.BYTES_PER_ELEMENT,a=t*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-a%8)%8;if(s<0)throw new Error(`Unexpected typed array class: ${i}.`);r&&r instanceof ArrayBuffer?(this.data=r,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+n+a+o),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+s]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t)}add(t,e){const i=this._pos>>1;return this.ids[i]=i,this.coords[this._pos++]=t,this.coords[this._pos++]=e,i}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return Xp(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,i,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:s,coords:n,nodeSize:a}=this,o=[0,s.length-1,0],l=[];for(;o.length;){const c=o.pop()||0,h=o.pop()||0,u=o.pop()||0;if(h-u<=a){for(let a=u;a<=h;a++){const o=n[2*a],c=n[2*a+1];o>=t&&o<=i&&c>=e&&c<=r&&l.push(s[a])}continue}const p=u+h>>1,d=n[2*p],f=n[2*p+1];d>=t&&d<=i&&f>=e&&f<=r&&l.push(s[p]),(0===c?t<=d:e<=f)&&(o.push(u),o.push(p-1),o.push(1-c)),(0===c?i>=d:r>=f)&&(o.push(p+1),o.push(h),o.push(1-c))}return l}within(t,e,i){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:r,coords:s,nodeSize:n}=this,a=[0,r.length-1,0],o=[],l=i*i;for(;a.length;){const c=a.pop()||0,h=a.pop()||0,u=a.pop()||0;if(h-u<=n){for(let i=u;i<=h;i++)Qp(s[2*i],s[2*i+1],t,e)<=l&&o.push(r[i]);continue}const p=u+h>>1,d=s[2*p],f=s[2*p+1];Qp(d,f,t,e)<=l&&o.push(r[p]),(0===c?t-i<=d:e-i<=f)&&(a.push(u),a.push(p-1),a.push(1-c)),(0===c?t+i>=d:e+i>=f)&&(a.push(p+1),a.push(h),a.push(1-c))}return o}}function Xp(t,e,i,r,s,n){if(s-r<=i)return;const a=r+s>>1;Kp(t,e,a,r,s,n),Xp(t,e,i,r,a-1,1-n),Xp(t,e,i,a+1,s,1-n)}function Kp(t,e,i,r,s,n){for(;s>r;){if(s-r>600){const a=s-r+1,o=i-r+1,l=Math.log(a),c=.5*Math.exp(2*l/3),h=.5*Math.sqrt(l*c*(a-c)/a)*(o-a/2<0?-1:1);Kp(t,e,i,Math.max(r,Math.floor(i-o*c/a+h)),Math.min(s,Math.floor(i+(a-o)*c/a+h)),n)}const a=e[2*i+n];let o=r,l=s;for(Yp(t,e,r,i),e[2*s+n]>a&&Yp(t,e,r,s);o<l;){for(Yp(t,e,o,l),o++,l--;e[2*o+n]<a;)o++;for(;e[2*l+n]>a;)l--}e[2*r+n]===a?Yp(t,e,r,l):(l++,Yp(t,e,l,s)),l<=i&&(r=l+1),i<=l&&(s=l-1)}}function Yp(t,e,i,r){Jp(t,i,r),Jp(e,2*i,2*r),Jp(e,2*i+1,2*r+1)}function Jp(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}function Qp(t,e,i,r){const s=t-i,n=e-r;return s*s+n*n}const td=512/to/2;class ed{constructor(t,e,i){this.tileID=t,this.bucketInstanceId=i,this._symbolsByKey={};const r=new Map;for(let t=0;t<e.length;t++){const i=e.get(t),s=i.key,n=r.get(s);n?n.push(i):r.set(s,[i])}for(const[t,e]of r){const i={positions:e.map((t=>({x:Math.floor(t.anchorX*td),y:Math.floor(t.anchorY*td)}))),crossTileIDs:e.map((t=>t.crossTileID))};if(i.positions.length>128){const t=new Hp(i.positions.length,16,Uint16Array);for(const{x:e,y:r}of i.positions)t.add(e,r);t.finish(),delete i.positions,i.index=t}this._symbolsByKey[t]=i}}getScaledCoordinates(t,e){const{x:i,y:r,z:s}=this.tileID.canonical,{x:n,y:a,z:o}=e.canonical,l=td/Math.pow(2,o-s),c=(a*to+t.anchorY)*l,h=r*to*td;return{x:Math.floor((n*to+t.anchorX)*l-i*to*td),y:Math.floor(c-h)}}findMatches(t,e,i){const r=this.tileID.canonical.z<e.canonical.z?1:Math.pow(2,this.tileID.canonical.z-e.canonical.z);for(let s=0;s<t.length;s++){const n=t.get(s);if(n.crossTileID)continue;const a=this._symbolsByKey[n.key];if(!a)continue;const o=this.getScaledCoordinates(n,e);if(a.index){const t=a.index.range(o.x-r,o.y-r,o.x+r,o.y+r).sort();for(const e of t){const t=a.crossTileIDs[e];if(!i[t]){i[t]=!0,n.crossTileID=t;break}}}else if(a.positions)for(let t=0;t<a.positions.length;t++){const e=a.positions[t],s=a.crossTileIDs[t];if(Math.abs(e.x-o.x)<=r&&Math.abs(e.y-o.y)<=r&&!i[s]){i[s]=!0,n.crossTileID=s;break}}}}getCrossTileIDsLists(){return Object.values(this._symbolsByKey).map((({crossTileIDs:t})=>t))}}class id{constructor(){this.maxCrossTileID=0}generate(){return++this.maxCrossTileID}}class rd{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0}handleWrapJump(t){const e=Math.round((t-this.lng)/360);if(0!==e)for(const t in this.indexes){const i=this.indexes[t],r={};for(const t in i){const s=i[t];s.tileID=s.tileID.unwrapTo(s.tileID.wrap+e),r[s.tileID.key]=s}this.indexes[t]=r}this.lng=t}addBucket(t,e,i){if(this.indexes[t.overscaledZ]&&this.indexes[t.overscaledZ][t.key]){if(this.indexes[t.overscaledZ][t.key].bucketInstanceId===e.bucketInstanceId)return!1;this.removeBucketCrossTileIDs(t.overscaledZ,this.indexes[t.overscaledZ][t.key])}for(let t=0;t<e.symbolInstances.length;t++)e.symbolInstances.get(t).crossTileID=0;this.usedCrossTileIDs[t.overscaledZ]||(this.usedCrossTileIDs[t.overscaledZ]={});const r=this.usedCrossTileIDs[t.overscaledZ];for(const i in this.indexes){const s=this.indexes[i];if(Number(i)>t.overscaledZ)for(const i in s){const n=s[i];n.tileID.isChildOf(t)&&n.findMatches(e.symbolInstances,t,r)}else{const n=s[t.scaledTo(Number(i)).key];n&&n.findMatches(e.symbolInstances,t,r)}}for(let t=0;t<e.symbolInstances.length;t++){const s=e.symbolInstances.get(t);s.crossTileID||(s.crossTileID=i.generate(),r[s.crossTileID]=!0)}return void 0===this.indexes[t.overscaledZ]&&(this.indexes[t.overscaledZ]={}),this.indexes[t.overscaledZ][t.key]=new ed(t,e.symbolInstances,e.bucketInstanceId),!0}removeBucketCrossTileIDs(t,e){for(const i of e.getCrossTileIDsLists())for(const e of i)delete this.usedCrossTileIDs[t][e]}removeStaleBuckets(t){let e=!1;for(const i in this.indexes){const r=this.indexes[i];for(const s in r)t[r[s].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,r[s]),delete r[s],e=!0)}return e}}class sd{constructor(){this.layerIndexes={},this.crossTileIDs=new id,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={}}addLayer(t,e,i){let r=this.layerIndexes[t.id];void 0===r&&(r=this.layerIndexes[t.id]=new rd);let s=!1;const n={};r.handleWrapJump(i);for(const i of e){const e=i.getBucket(t);e&&t.id===e.layerIds[0]&&(e.bucketInstanceId||(e.bucketInstanceId=++this.maxBucketInstanceId),r.addBucket(i.tileID,e,this.crossTileIDs)&&(s=!0),n[e.bucketInstanceId]=!0)}return r.removeStaleBuckets(n)&&(s=!0),s}pruneUnusedLayers(t){const e={};t.forEach((t=>{e[t]=!0}));for(const t in this.layerIndexes)e[t]||delete this.layerIndexes[t]}}const nd=(t,e)=>Ps(t,e&&e.filter((t=>"source.canvas"!==t.identifier))),ad=function(){const t={},e=at.$version;for(const i in at.$root){const r=at.$root[i];if(r.required){let s=null;s="version"===i?e:"array"===r.type?[]:{},null!=s&&(t[i]=s)}}return t}();class od extends nt{constructor(t,e={}){super(),this._rtlPluginLoaded=()=>{for(const t in this.sourceCaches){const e=this.sourceCaches[t].getSource().type;"vector"!==e&&"geojson"!==e||this.sourceCaches[t].reload()}},this.map=t,this.dispatcher=new ou(au(),t._getMapId()),this.dispatcher.registerMessageHandler("GG",((t,e)=>this.getGlyphs(t,e))),this.dispatcher.registerMessageHandler("GI",((t,e)=>this.getImages(t,e))),this.imageManager=new jh,this.imageManager.setEventedParent(this),this.glyphManager=new Gh(t._requestManager,e.localIdeographFontFamily),this.lineAtlas=new Jh(256,512),this.crossTileSymbolIndex=new sd,this._spritesImagesIds={},this._layers={},this._order=[],this.sourceCaches={},this.zoomHistory=new Vs,this._loaded=!1,this._availableImages=[],this._resetUpdates(),this.dispatcher.broadcast("SR",$()),Wu().on(qu,this._rtlPluginLoaded),this.on("data",(t=>{if("source"!==t.dataType||"metadata"!==t.sourceDataType)return;const e=this.sourceCaches[t.sourceId];if(!e)return;const i=e.getSource();if(i&&i.vectorLayerIds)for(const t in this._layers){const e=this._layers[t];e.source===i.id&&this._validateLayer(e)}}))}loadURL(t,e={},i){this.fire(new rt("dataloading",{dataType:"style"})),e.validate="boolean"!=typeof e.validate||e.validate;const r=this.map._requestManager.transformRequest(t,"Style");this._loadStyleRequest=new AbortController;const s=this._loadStyleRequest;Z(r,this._loadStyleRequest).then((t=>{this._loadStyleRequest=null,this._load(t.data,e,i)})).catch((t=>{this._loadStyleRequest=null,t&&!s.signal.aborted&&this.fire(new st(t))}))}loadJSON(t,e={},i){this.fire(new rt("dataloading",{dataType:"style"})),this._frameRequest=new AbortController,F.frameAsync(this._frameRequest).then((()=>{this._frameRequest=null,e.validate=!1!==e.validate,this._load(t,e,i)})).catch((()=>{}))}loadEmpty(){this.fire(new rt("dataloading",{dataType:"style"})),this._load(ad,{validate:!1})}_load(t,e,i){var r;const s=e.transformStyle?e.transformStyle(i,t):t;if(!e.validate||!nd(this,Is(s))){this._loaded=!0,this.stylesheet=s;for(const t in s.sources)this.addSource(t,s.sources[t],{validate:!1});s.sprite?this._loadSprite(s.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(s.glyphs),this._createLayers(),this.light=new Xh(this.stylesheet.light),this.sky=new Yh(this.stylesheet.sky),this.map.setTerrain(null!==(r=this.stylesheet.terrain)&&void 0!==r?r:null),this.fire(new rt("data",{dataType:"style"})),this.fire(new rt("style.load"))}}_createLayers(){const t=ct(this.stylesheet.layers);this.dispatcher.broadcast("SL",t),this._order=t.map((t=>t.id)),this._layers={},this._serializedLayers=null;for(const e of t){const t=Fh(e);t.setEventedParent(this,{layer:{id:e.id}}),this._layers[e.id]=t}}_loadSprite(t,e=!1,r=void 0){let s;this.imageManager.setLoaded(!1),this._spriteRequest=new AbortController,function(t,e,r,s){return i(this,void 0,void 0,(function*(){const n=Oh(t),a=r>1?"@2x":"",o={},l={};for(const{id:t,url:i}of n){const r=e.transformRequest(Vh(i,a,".json"),"SpriteJSON");o[t]=Z(r,s);const n=e.transformRequest(Vh(i,a,".png"),"SpriteImage");l[t]=Q.getImage(n,s)}return yield Promise.all([...Object.values(o),...Object.values(l)]),function(t,e){return i(this,void 0,void 0,(function*(){const i={};for(const r in t){i[r]={};const s=F.getImageCanvasContext((yield e[r]).data),n=(yield t[r]).data;for(const t in n){const{width:e,height:a,x:o,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:p,content:d,textFitWidth:f,textFitHeight:m}=n[t];i[r][t]={data:null,pixelRatio:h,sdf:c,stretchX:u,stretchY:p,content:d,textFitWidth:f,textFitHeight:m,spriteData:{width:e,height:a,x:o,y:l,context:s}}}}return i}))}(o,l)}))}(t,this.map._requestManager,this.map.getPixelRatio(),this._spriteRequest).then((t=>{if(this._spriteRequest=null,t)for(const i in t){this._spritesImagesIds[i]=[];const r=this._spritesImagesIds[i]?this._spritesImagesIds[i].filter((e=>!(e in t))):[];for(const t of r)this.imageManager.removeImage(t),this._changedImages[t]=!0;for(const r in t[i]){const s="default"===i?r:`${i}:${r}`;this._spritesImagesIds[i].push(s),s in this.imageManager.images?this.imageManager.updateImage(s,t[i][r],!1):this.imageManager.addImage(s,t[i][r]),e&&(this._changedImages[s]=!0)}}})).catch((t=>{this._spriteRequest=null,s=t,this.fire(new st(s))})).finally((()=>{this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),e&&(this._changed=!0),this.dispatcher.broadcast("SI",this._availableImages),this.fire(new rt("data",{dataType:"style"})),r&&r(s)}))}_unloadSprite(){for(const t of Object.values(this._spritesImagesIds).flat())this.imageManager.removeImage(t),this._changedImages[t]=!0;this._spritesImagesIds={},this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new rt("data",{dataType:"style"}))}_validateLayer(t){const e=this.sourceCaches[t.source];if(!e)return;const i=t.sourceLayer;if(!i)return;const r=e.getSource();("geojson"===r.type||r.vectorLayerIds&&-1===r.vectorLayerIds.indexOf(i))&&this.fire(new st(new Error(`Source layer "${i}" does not exist on source "${r.id}" as specified by style layer "${t.id}".`)))}loaded(){if(!this._loaded)return!1;if(Object.keys(this._updatedSources).length)return!1;for(const t in this.sourceCaches)if(!this.sourceCaches[t].loaded())return!1;return!!this.imageManager.isLoaded()}_serializeByIds(t,e=!1){const i=this._serializedAllLayers();if(!t||0===t.length)return Object.values(e?I(i):i);const r=[];for(const s of t)if(i[s]){const t=e?I(i[s]):i[s];r.push(t)}return r}_serializedAllLayers(){let t=this._serializedLayers;if(t)return t;t=this._serializedLayers={};const e=Object.keys(this._layers);for(const i of e){const e=this._layers[i];"custom"!==e.type&&(t[i]=e.serialize())}return t}hasTransitions(){if(this.light&&this.light.hasTransition())return!0;if(this.sky&&this.sky.hasTransition())return!0;for(const t in this.sourceCaches)if(this.sourceCaches[t].hasTransition())return!0;for(const t in this._layers)if(this._layers[t].hasTransition())return!0;return!1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading.")}update(t){if(!this._loaded)return;const e=this._changed;if(e){const e=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(e.length||i.length)&&this._updateWorkerLayers(e,i);for(const t in this._updatedSources){const e=this._updatedSources[t];if("reload"===e)this._reloadSource(t);else{if("clear"!==e)throw new Error(`Invalid action ${e}`);this._clearSource(t)}}this._updateTilesForChangedImages(),this._updateTilesForChangedGlyphs();for(const e in this._updatedPaintProps)this._layers[e].updateTransitions(t);this.light.updateTransitions(t),this.sky.updateTransitions(t),this._resetUpdates()}const i={};for(const t in this.sourceCaches){const e=this.sourceCaches[t];i[t]=e.used,e.used=!1}for(const e of this._order){const i=this._layers[e];i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)&&i.source&&(this.sourceCaches[i.source].used=!0)}for(const t in i){const e=this.sourceCaches[t];!!i[t]!=!!e.used&&e.fire(new rt("data",{sourceDataType:"visibility",dataType:"source",sourceId:t}))}this.light.recalculate(t),this.sky.recalculate(t),this.z=t.zoom,e&&this.fire(new rt("data",{dataType:"style"}))}_updateTilesForChangedImages(){const t=Object.keys(this._changedImages);if(t.length){for(const e in this.sourceCaches)this.sourceCaches[e].reloadTilesForDependencies(["icons","patterns"],t);this._changedImages={}}}_updateTilesForChangedGlyphs(){if(this._glyphsDidChange){for(const t in this.sourceCaches)this.sourceCaches[t].reloadTilesForDependencies(["glyphs"],[""]);this._glyphsDidChange=!1}}_updateWorkerLayers(t,e){this.dispatcher.broadcast("UL",{layers:this._serializeByIds(t,!1),removedIds:e})}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={},this._glyphsDidChange=!1}setState(t,e={}){var i;this._checkLoaded();const r=this.serialize();if(t=e.transformStyle?e.transformStyle(r,t):t,(null===(i=e.validate)||void 0===i||i)&&nd(this,Is(t)))return!1;(t=I(t)).layers=ct(t.layers);const s=function(t,e){if(!t)return[{command:"setStyle",args:[e]}];let i=[];try{if(!ht(t.version,e.version))return[{command:"setStyle",args:[e]}];ht(t.center,e.center)||i.push({command:"setCenter",args:[e.center]}),ht(t.zoom,e.zoom)||i.push({command:"setZoom",args:[e.zoom]}),ht(t.bearing,e.bearing)||i.push({command:"setBearing",args:[e.bearing]}),ht(t.pitch,e.pitch)||i.push({command:"setPitch",args:[e.pitch]}),ht(t.sprite,e.sprite)||i.push({command:"setSprite",args:[e.sprite]}),ht(t.glyphs,e.glyphs)||i.push({command:"setGlyphs",args:[e.glyphs]}),ht(t.transition,e.transition)||i.push({command:"setTransition",args:[e.transition]}),ht(t.light,e.light)||i.push({command:"setLight",args:[e.light]}),ht(t.terrain,e.terrain)||i.push({command:"setTerrain",args:[e.terrain]}),ht(t.sky,e.sky)||i.push({command:"setSky",args:[e.sky]}),ht(t.projection,e.projection)||i.push({command:"setProjection",args:[e.projection]});const r={},s=[];!function(t,e,i,r){let s;for(s in e=e||{},t=t||{})Object.prototype.hasOwnProperty.call(t,s)&&(Object.prototype.hasOwnProperty.call(e,s)||dt(s,i,r));for(s in e)Object.prototype.hasOwnProperty.call(e,s)&&(Object.prototype.hasOwnProperty.call(t,s)?ht(t[s],e[s])||("geojson"===t[s].type&&"geojson"===e[s].type&&mt(t,e,s)?ut(i,{command:"setGeoJSONSourceData",args:[s,e[s].data]}):ft(s,e,i,r)):pt(s,e,i))}(t.sources,e.sources,s,r);const n=[];t.layers&&t.layers.forEach((t=>{"source"in t&&r[t.source]?i.push({command:"removeLayer",args:[t.id]}):n.push(t)})),i=i.concat(s),function(t,e,i){e=e||[];const r=(t=t||[]).map(gt),s=e.map(gt),n=t.reduce(yt,{}),a=e.reduce(yt,{}),o=r.slice(),l=Object.create(null);let c,h,u,p,d;for(let t=0,e=0;t<r.length;t++)c=r[t],Object.prototype.hasOwnProperty.call(a,c)?e++:(ut(i,{command:"removeLayer",args:[c]}),o.splice(o.indexOf(c,e),1));for(let t=0,e=0;t<s.length;t++)c=s[s.length-1-t],o[o.length-1-t]!==c&&(Object.prototype.hasOwnProperty.call(n,c)?(ut(i,{command:"removeLayer",args:[c]}),o.splice(o.lastIndexOf(c,o.length-e),1)):e++,p=o[o.length-t],ut(i,{command:"addLayer",args:[a[c],p]}),o.splice(o.length-t,0,c),l[c]=!0);for(let t=0;t<s.length;t++)if(c=s[t],h=n[c],u=a[c],!l[c]&&!ht(h,u))if(ht(h.source,u.source)&&ht(h["source-layer"],u["source-layer"])&&ht(h.type,u.type)){for(d in _t(h.layout,u.layout,i,c,null,"setLayoutProperty"),_t(h.paint,u.paint,i,c,null,"setPaintProperty"),ht(h.filter,u.filter)||ut(i,{command:"setFilter",args:[c,u.filter]}),ht(h.minzoom,u.minzoom)&&ht(h.maxzoom,u.maxzoom)||ut(i,{command:"setLayerZoomRange",args:[c,u.minzoom,u.maxzoom]}),h)Object.prototype.hasOwnProperty.call(h,d)&&"layout"!==d&&"paint"!==d&&"filter"!==d&&"metadata"!==d&&"minzoom"!==d&&"maxzoom"!==d&&(0===d.indexOf("paint.")?_t(h[d],u[d],i,c,d.slice(6),"setPaintProperty"):ht(h[d],u[d])||ut(i,{command:"setLayerProperty",args:[c,d,u[d]]}));for(d in u)Object.prototype.hasOwnProperty.call(u,d)&&!Object.prototype.hasOwnProperty.call(h,d)&&"layout"!==d&&"paint"!==d&&"filter"!==d&&"metadata"!==d&&"minzoom"!==d&&"maxzoom"!==d&&(0===d.indexOf("paint.")?_t(h[d],u[d],i,c,d.slice(6),"setPaintProperty"):ht(h[d],u[d])||ut(i,{command:"setLayerProperty",args:[c,d,u[d]]}))}else ut(i,{command:"removeLayer",args:[c]}),p=o[o.lastIndexOf(c)+1],ut(i,{command:"addLayer",args:[u,p]})}(n,e.layers,i)}catch(t){console.warn("Unable to compute style diff:",t),i=[{command:"setStyle",args:[e]}]}return i}(r,t),n=this._getOperationsToPerform(s);if(n.unimplemented.length>0)throw new Error(`Unimplemented: ${n.unimplemented.join(", ")}.`);if(0===n.operations.length)return!1;for(const t of n.operations)t();return this.stylesheet=t,this._serializedLayers=null,!0}_getOperationsToPerform(t){const e=[],i=[];for(const r of t)switch(r.command){case"setCenter":case"setZoom":case"setBearing":case"setPitch":continue;case"addLayer":e.push((()=>this.addLayer.apply(this,r.args)));break;case"removeLayer":e.push((()=>this.removeLayer.apply(this,r.args)));break;case"setPaintProperty":e.push((()=>this.setPaintProperty.apply(this,r.args)));break;case"setLayoutProperty":e.push((()=>this.setLayoutProperty.apply(this,r.args)));break;case"setFilter":e.push((()=>this.setFilter.apply(this,r.args)));break;case"addSource":e.push((()=>this.addSource.apply(this,r.args)));break;case"removeSource":e.push((()=>this.removeSource.apply(this,r.args)));break;case"setLayerZoomRange":e.push((()=>this.setLayerZoomRange.apply(this,r.args)));break;case"setLight":e.push((()=>this.setLight.apply(this,r.args)));break;case"setGeoJSONSourceData":e.push((()=>this.setGeoJSONSourceData.apply(this,r.args)));break;case"setGlyphs":e.push((()=>this.setGlyphs.apply(this,r.args)));break;case"setSprite":e.push((()=>this.setSprite.apply(this,r.args)));break;case"setSky":e.push((()=>this.setSky.apply(this,r.args)));break;case"setTerrain":e.push((()=>this.map.setTerrain.apply(this,r.args)));break;case"setTransition":e.push((()=>{}));break;default:i.push(r.command)}return{operations:e,unimplemented:i}}addImage(t,e){if(this.getImage(t))return this.fire(new st(new Error(`An image named "${t}" already exists.`)));this.imageManager.addImage(t,e),this._afterImageUpdated(t)}updateImage(t,e){this.imageManager.updateImage(t,e)}getImage(t){return this.imageManager.getImage(t)}removeImage(t){if(!this.getImage(t))return this.fire(new st(new Error(`An image named "${t}" does not exist.`)));this.imageManager.removeImage(t),this._afterImageUpdated(t)}_afterImageUpdated(t){this._availableImages=this.imageManager.listImages(),this._changedImages[t]=!0,this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new rt("data",{dataType:"style"}))}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(t,e,i={}){if(this._checkLoaded(),void 0!==this.sourceCaches[t])throw new Error(`Source "${t}" already exists.`);if(!e.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(e).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(e.type)>=0&&this._validate(Is.source,`sources.${t}`,e,null,i))return;this.map&&this.map._collectResourceTiming&&(e.collectResourceTiming=!0);const r=this.sourceCaches[t]=new Yu(t,e,this.dispatcher);r.style=this,r.setEventedParent(this,(()=>({isSourceLoaded:r.loaded(),source:r.serialize(),sourceId:t}))),r.onAdd(this.map),this._changed=!0}removeSource(t){if(this._checkLoaded(),void 0===this.sourceCaches[t])throw new Error("There is no source with this ID");for(const e in this._layers)if(this._layers[e].source===t)return this.fire(new st(new Error(`Source "${t}" cannot be removed while layer "${e}" is using it.`)));const e=this.sourceCaches[t];delete this.sourceCaches[t],delete this._updatedSources[t],e.fire(new rt("data",{sourceDataType:"metadata",dataType:"source",sourceId:t})),e.setEventedParent(null),e.onRemove(this.map),this._changed=!0}setGeoJSONSourceData(t,e){if(this._checkLoaded(),void 0===this.sourceCaches[t])throw new Error(`There is no source with this ID=${t}`);const i=this.sourceCaches[t].getSource();if("geojson"!==i.type)throw new Error(`geojsonSource.type is ${i.type}, which is !== 'geojson`);i.setData(e),this._changed=!0}getSource(t){return this.sourceCaches[t]&&this.sourceCaches[t].getSource()}addLayer(t,e,i={}){this._checkLoaded();const r=t.id;if(this.getLayer(r))return void this.fire(new st(new Error(`Layer "${r}" already exists on this map.`)));let s;if("custom"===t.type){if(nd(this,function(t){const e=[],i=t.id;return void 0===i&&e.push({message:`layers.${i}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${i}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${i}: property "renderingMode" must be either "2d" or "3d"`}),e}(t)))return;s=Fh(t)}else{if("source"in t&&"object"==typeof t.source&&(this.addSource(r,t.source),t=y(t=I(t),{source:r})),this._validate(Is.layer,`layers.${r}`,t,{arrayIndex:-1},i))return;s=Fh(t),this._validateLayer(s),s.setEventedParent(this,{layer:{id:r}})}const n=e?this._order.indexOf(e):this._order.length;if(e&&-1===n)this.fire(new st(new Error(`Cannot add layer "${r}" before non-existing layer "${e}".`)));else{if(this._order.splice(n,0,r),this._layerOrderChanged=!0,this._layers[r]=s,this._removedLayers[r]&&s.source&&"custom"!==s.type){const t=this._removedLayers[r];delete this._removedLayers[r],t.type!==s.type?this._updatedSources[s.source]="clear":(this._updatedSources[s.source]="reload",this.sourceCaches[s.source].pause())}this._updateLayer(s),s.onAdd&&s.onAdd(this.map)}}moveLayer(t,e){if(this._checkLoaded(),this._changed=!0,!this._layers[t])return void this.fire(new st(new Error(`The layer '${t}' does not exist in the map's style and cannot be moved.`)));if(t===e)return;const i=this._order.indexOf(t);this._order.splice(i,1);const r=e?this._order.indexOf(e):this._order.length;e&&-1===r?this.fire(new st(new Error(`Cannot move layer "${t}" before non-existing layer "${e}".`))):(this._order.splice(r,0,t),this._layerOrderChanged=!0)}removeLayer(t){this._checkLoaded();const e=this._layers[t];if(!e)return void this.fire(new st(new Error(`Cannot remove non-existing layer "${t}".`)));e.setEventedParent(null);const i=this._order.indexOf(t);this._order.splice(i,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[t]=e,delete this._layers[t],this._serializedLayers&&delete this._serializedLayers[t],delete this._updatedLayers[t],delete this._updatedPaintProps[t],e.onRemove&&e.onRemove(this.map)}getLayer(t){return this._layers[t]}getLayersOrder(){return[...this._order]}hasLayer(t){return t in this._layers}setLayerZoomRange(t,e,i){this._checkLoaded();const r=this.getLayer(t);r?r.minzoom===e&&r.maxzoom===i||(null!=e&&(r.minzoom=e),null!=i&&(r.maxzoom=i),this._updateLayer(r)):this.fire(new st(new Error(`Cannot set the zoom range of non-existing layer "${t}".`)))}setFilter(t,e,i={}){this._checkLoaded();const r=this.getLayer(t);if(r){if(!S(r.filter,e))return null==e?(r.filter=void 0,void this._updateLayer(r)):void(this._validate(Is.filter,`layers.${r.id}.filter`,e,null,i)||(r.filter=I(e),this._updateLayer(r)))}else this.fire(new st(new Error(`Cannot filter non-existing layer "${t}".`)))}getFilter(t){return I(this.getLayer(t).filter)}setLayoutProperty(t,e,i,r={}){this._checkLoaded();const s=this.getLayer(t);s?S(s.getLayoutProperty(e),i)||(s.setLayoutProperty(e,i,r),this._updateLayer(s)):this.fire(new st(new Error(`Cannot style non-existing layer "${t}".`)))}getLayoutProperty(t,e){const i=this.getLayer(t);if(i)return i.getLayoutProperty(e);this.fire(new st(new Error(`Cannot get style of non-existing layer "${t}".`)))}setPaintProperty(t,e,i,r={}){this._checkLoaded();const s=this.getLayer(t);s?S(s.getPaintProperty(e),i)||(s.setPaintProperty(e,i,r)&&this._updateLayer(s),this._changed=!0,this._updatedPaintProps[t]=!0,this._serializedLayers=null):this.fire(new st(new Error(`Cannot style non-existing layer "${t}".`)))}getPaintProperty(t,e){return this.getLayer(t).getPaintProperty(e)}setFeatureState(t,e){this._checkLoaded();const i=t.source,r=t.sourceLayer,s=this.sourceCaches[i];if(void 0===s)return void this.fire(new st(new Error(`The source '${i}' does not exist in the map's style.`)));const n=s.getSource().type;"geojson"===n&&r?this.fire(new st(new Error("GeoJSON sources cannot have a sourceLayer parameter."))):"vector"!==n||r?(void 0===t.id&&this.fire(new st(new Error("The feature id parameter must be provided."))),s.setFeatureState(r,t.id,e)):this.fire(new st(new Error("The sourceLayer parameter must be provided for vector source types.")))}removeFeatureState(t,e){this._checkLoaded();const i=t.source,r=this.sourceCaches[i];if(void 0===r)return void this.fire(new st(new Error(`The source '${i}' does not exist in the map's style.`)));const s=r.getSource().type,n="vector"===s?t.sourceLayer:void 0;"vector"!==s||n?e&&"string"!=typeof t.id&&"number"!=typeof t.id?this.fire(new st(new Error("A feature id is required to remove its specific state property."))):r.removeFeatureState(n,t.id,e):this.fire(new st(new Error("The sourceLayer parameter must be provided for vector source types.")))}getFeatureState(t){this._checkLoaded();const e=t.source,i=t.sourceLayer,r=this.sourceCaches[e];if(void 0!==r)return"vector"!==r.getSource().type||i?(void 0===t.id&&this.fire(new st(new Error("The feature id parameter must be provided."))),r.getFeatureState(i,t.id)):void this.fire(new st(new Error("The sourceLayer parameter must be provided for vector source types.")));this.fire(new st(new Error(`The source '${e}' does not exist in the map's style.`)))}getTransition(){return y({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){if(!this._loaded)return;const t=w(this.sourceCaches,(t=>t.serialize())),e=this._serializeByIds(this._order,!0),i=this.map.getTerrain()||void 0,r=this.stylesheet;return T({version:r.version,name:r.name,metadata:r.metadata,light:r.light,sky:r.sky,center:r.center,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,sprite:r.sprite,glyphs:r.glyphs,transition:r.transition,sources:t,layers:e,terrain:i},(t=>void 0!==t))}_updateLayer(t){this._updatedLayers[t.id]=!0,t.source&&!this._updatedSources[t.source]&&"raster"!==this.sourceCaches[t.source].getSource().type&&(this._updatedSources[t.source]="reload",this.sourceCaches[t.source].pause()),this._serializedLayers=null,this._changed=!0}_flattenAndSortRenderedFeatures(t){const e=t=>"fill-extrusion"===this._layers[t].type,i={},r=[];for(let s=this._order.length-1;s>=0;s--){const n=this._order[s];if(e(n)){i[n]=s;for(const e of t){const t=e[n];if(t)for(const e of t)r.push(e)}}}r.sort(((t,e)=>e.intersectionZ-t.intersectionZ));const s=[];for(let n=this._order.length-1;n>=0;n--){const a=this._order[n];if(e(a))for(let t=r.length-1;t>=0;t--){const e=r[t].feature;if(i[e.layer.id]<n)break;s.push(e),r.pop()}else for(const e of t){const t=e[a];if(t)for(const e of t)s.push(e.feature)}}return s}queryRenderedFeatures(t,e,i){e&&e.filter&&this._validate(Is.filter,"queryRenderedFeatures.filter",e.filter,null,e);const r={};if(e&&e.layers){if(!Array.isArray(e.layers))return this.fire(new st(new Error("parameters.layers must be an Array."))),[];for(const t of e.layers){const e=this._layers[t];if(!e)return this.fire(new st(new Error(`The layer '${t}' does not exist in the map's style and cannot be queried for features.`))),[];r[e.source]=!0}}const s=[];e.availableImages=this._availableImages;const n=this._serializedAllLayers();for(const a in this.sourceCaches)e.layers&&!r[a]||s.push(hu(this.sourceCaches[a],this._layers,n,t,e,i));return this.placement&&s.push(function(t,e,i,r,s,n,a){const o={},l=n.queryRenderedSymbols(r),c=[];for(const t of Object.keys(l).map(Number))c.push(a[t]);c.sort(uu);for(const i of c){const r=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],e,i.bucketIndex,i.sourceLayerIndex,s.filter,s.layers,s.availableImages,t);for(const t in r){const e=o[t]=o[t]||[],s=r[t];s.sort(((t,e)=>{const r=i.featureSortOrder;if(r){const i=r.indexOf(t.featureIndex);return r.indexOf(e.featureIndex)-i}return e.featureIndex-t.featureIndex}));for(const t of s)e.push(t)}}for(const e in o)o[e].forEach((r=>{const s=r.feature,n=i[t[e].source].getFeatureState(s.layer["source-layer"],s.id);s.source=s.layer.source,s.layer["source-layer"]&&(s.sourceLayer=s.layer["source-layer"]),s.state=n}));return o}(this._layers,n,this.sourceCaches,t,e,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(s)}querySourceFeatures(t,e){e&&e.filter&&this._validate(Is.filter,"querySourceFeatures.filter",e.filter,null,e);const i=this.sourceCaches[t];return i?function(t,e){const i=t.getRenderableIds().map((e=>t.getTileByID(e))),r=[],s={};for(let t=0;t<i.length;t++){const n=i[t],a=n.tileID.canonical.key;s[a]||(s[a]=!0,n.querySourceFeatures(r,e))}return r}(i,e):[]}getLight(){return this.light.getLight()}setLight(t,e={}){this._checkLoaded();const i=this.light.getLight();let r=!1;for(const e in t)if(!S(t[e],i[e])){r=!0;break}if(!r)return;const s={now:F.now(),transition:y({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(t,e),this.light.updateTransitions(s)}getSky(){var t;return null===(t=this.stylesheet)||void 0===t?void 0:t.sky}setSky(t,e={}){const i=this.getSky();let r=!1;if(!t&&!i)return;if(t&&!i)r=!0;else if(!t&&i)r=!0;else for(const e in t)if(!S(t[e],i[e])){r=!0;break}if(!r)return;const s={now:F.now(),transition:y({duration:300,delay:0},this.stylesheet.transition)};this.stylesheet.sky=t,this.sky.setSky(t,e),this.sky.updateTransitions(s)}_validate(t,e,i,r,s={}){return(!s||!1!==s.validate)&&nd(this,t.call(Is,y({key:e,style:this.serialize(),value:i,styleSpec:at},r)))}_remove(t=!0){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null),Wu().off(qu,this._rtlPluginLoaded);for(const t in this._layers)this._layers[t].setEventedParent(null);for(const t in this.sourceCaches){const e=this.sourceCaches[t];e.setEventedParent(null),e.onRemove(this.map)}this.imageManager.setEventedParent(null),this.setEventedParent(null),t&&this.dispatcher.broadcast("RM",void 0),this.dispatcher.remove(t)}_clearSource(t){this.sourceCaches[t].clearTiles()}_reloadSource(t){this.sourceCaches[t].resume(),this.sourceCaches[t].reload()}_updateSources(t){for(const e in this.sourceCaches)this.sourceCaches[e].update(t,this.map.terrain)}_generateCollisionBoxes(){for(const t in this.sourceCaches)this._reloadSource(t)}_updatePlacement(t,e,i,r,s=!1){let n=!1,a=!1;const o={};for(const e of this._order){const i=this._layers[e];if("symbol"!==i.type)continue;if(!o[i.source]){const t=this.sourceCaches[i.source];o[i.source]=t.getRenderableIds(!0).map((e=>t.getTileByID(e))).sort(((t,e)=>e.tileID.overscaledZ-t.tileID.overscaledZ||(t.tileID.isLessThan(e.tileID)?-1:1)))}const r=this.crossTileSymbolIndex.addLayer(i,o[i.source],t.center.lng);n=n||r}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((s=s||this._layerOrderChanged||0===i)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(F.now(),t.zoom))&&(this.pauseablePlacement=new Gp(t,this.map.terrain,this._order,s,e,i,r,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,o),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(F.now()),a=!0),n&&this.pauseablePlacement.placement.setStale()),a||n)for(const t of this._order){const e=this._layers[t];"symbol"===e.type&&this.placement.updateLayerOpacities(e,o[e.source])}return!this.pauseablePlacement.isDone()||this.placement.hasTransitions(F.now())}_releaseSymbolFadeTiles(){for(const t in this.sourceCaches)this.sourceCaches[t].releaseSymbolFadeTiles()}getImages(t,e){return i(this,void 0,void 0,(function*(){const t=yield this.imageManager.getImages(e.icons);this._updateTilesForChangedImages();const i=this.sourceCaches[e.source];return i&&i.setDependencies(e.tileID.key,e.type,e.icons),t}))}getGlyphs(t,e){return i(this,void 0,void 0,(function*(){const t=yield this.glyphManager.getGlyphs(e.stacks),i=this.sourceCaches[e.source];return i&&i.setDependencies(e.tileID.key,e.type,[""]),t}))}getGlyphsUrl(){return this.stylesheet.glyphs||null}setGlyphs(t,e={}){this._checkLoaded(),t&&this._validate(Is.glyphs,"glyphs",t,null,e)||(this._glyphsDidChange=!0,this.stylesheet.glyphs=t,this.glyphManager.entries={},this.glyphManager.setURL(t))}addSprite(t,e,i={},r){this._checkLoaded();const s=[{id:t,url:e}],n=[...Oh(this.stylesheet.sprite),...s];this._validate(Is.sprite,"sprite",n,null,i)||(this.stylesheet.sprite=n,this._loadSprite(s,!0,r))}removeSprite(t){this._checkLoaded();const e=Oh(this.stylesheet.sprite);if(e.find((e=>e.id===t))){if(this._spritesImagesIds[t])for(const e of this._spritesImagesIds[t])this.imageManager.removeImage(e),this._changedImages[e]=!0;e.splice(e.findIndex((e=>e.id===t)),1),this.stylesheet.sprite=e.length>0?e:void 0,delete this._spritesImagesIds[t],this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new rt("data",{dataType:"style"}))}else this.fire(new st(new Error(`Sprite "${t}" doesn't exists on this map.`)))}getSprite(){return Oh(this.stylesheet.sprite)}setSprite(t,e={},i){this._checkLoaded(),t&&this._validate(Is.sprite,"sprite",t,null,e)||(this.stylesheet.sprite=t,t?this._loadSprite(t,!0,i):(this._unloadSprite(),i&&i(null)))}}var ld=gn([{name:"a_pos",type:"Int16",components:2}]);const cd={prelude:hd("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\n","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(unpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}\n#ifdef TERRAIN3D\nuniform sampler2D u_terrain;uniform float u_terrain_dim;uniform mat4 u_terrain_matrix;uniform vec4 u_terrain_unpack;uniform float u_terrain_exaggeration;uniform highp sampler2D u_depth;\n#endif\nconst highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitShifts=vec4(1.)/bitSh;highp float unpack(highp vec4 color) {return dot(color,bitShifts);}highp float depthOpacity(vec3 frag) {\n#ifdef TERRAIN3D\nhighp float d=unpack(texture2D(u_depth,frag.xy*0.5+0.5))+0.0001-frag.z;return 1.0-max(0.0,min(1.0,-d*500.0));\n#else\nreturn 1.0;\n#endif\n}float calculate_visibility(vec4 pos) {\n#ifdef TERRAIN3D\nvec3 frag=pos.xyz/pos.w;highp float d=depthOpacity(frag);if (d > 0.95) return 1.0;return (d+depthOpacity(frag+vec3(0.0,0.01,0.0)))/2.0;\n#else\nreturn 1.0;\n#endif\n}float ele(vec2 pos) {\n#ifdef TERRAIN3D\nvec4 rgb=(texture2D(u_terrain,pos)*255.0)*u_terrain_unpack;return rgb.r+rgb.g+rgb.b-u_terrain_unpack.a;\n#else\nreturn 0.0;\n#endif\n}float get_elevation(vec2 pos) {\n#ifdef TERRAIN3D\nvec2 coord=(u_terrain_matrix*vec4(pos,0.0,1.0)).xy*u_terrain_dim+1.0;vec2 f=fract(coord);vec2 c=(floor(coord)+0.5)/(u_terrain_dim+2.0);float d=1.0/(u_terrain_dim+2.0);float tl=ele(c);float tr=ele(c+vec2(d,0.0));float bl=ele(c+vec2(0.0,d));float br=ele(c+vec2(d,d));float elevation=mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);return elevation*u_terrain_exaggeration;\n#else\nreturn 0.0;\n#endif\n}"),background:hd("uniform vec4 u_color;uniform float u_opacity;void main() {gl_FragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),backgroundPattern:hd("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);gl_FragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:hd("varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);float antialiased_blur=v_data.z;float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(antialiased_blur,0.0,extrude_length-radius/(radius+stroke_width));gl_FragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform bool u_scale_with_map;uniform bool u_pitch_with_map;uniform vec2 u_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;attribute vec2 a_pos;varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=vec2(mod(a_pos,2.0)*2.0-1.0);vec2 circle_center=floor(a_pos*0.5);float ele=get_elevation(circle_center);v_visibility=calculate_visibility(u_matrix*vec4(circle_center,ele,1.0));if (u_pitch_with_map) {vec2 corner_position=circle_center;if (u_scale_with_map) {corner_position+=extrude*(radius+stroke_width)*u_extrude_scale;} else {vec4 projected_center=u_matrix*vec4(circle_center,0,1);corner_position+=extrude*(radius+stroke_width)*u_extrude_scale*(projected_center.w/u_camera_to_center_distance);}gl_Position=u_matrix*vec4(corner_position,ele,1);} else {gl_Position=u_matrix*vec4(circle_center,ele,1);if (u_scale_with_map) {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*u_camera_to_center_distance;} else {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*gl_Position.w;}}float antialiasblur=-max(1.0/u_device_pixel_ratio/(radius+stroke_width),blur);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:hd("void main() {gl_FragColor=vec4(1.0);}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),heatmap:hd("uniform highp float u_intensity;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);gl_FragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;attribute vec2 a_pos;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 unscaled_extrude=vec2(mod(a_pos,2.0)*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec4 pos=vec4(floor(a_pos*0.5)+extrude,get_elevation(floor(a_pos*0.5)),1);gl_Position=u_matrix*pos;}"),heatmapTexture:hd("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;varying vec2 v_pos;void main() {float t=texture2D(u_image,v_pos).r;vec4 color=texture2D(u_color_ramp,vec2(t,0.5));gl_FragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:hd("varying float v_placed;varying float v_notUsed;void main() {float alpha=0.5;gl_FragColor=vec4(1.0,0.0,0.0,1.0)*alpha;if (v_placed > 0.5) {gl_FragColor=vec4(0.0,0.0,1.0,0.5)*alpha;}if (v_notUsed > 0.5) {gl_FragColor*=.1;}}","attribute vec2 a_anchor_pos;attribute vec2 a_placed;attribute vec2 a_box_real;uniform mat4 u_matrix;uniform vec2 u_pixel_extrude_scale;varying float v_placed;varying float v_notUsed;vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_matrix*vec4(posInTile,elevation,1.0);}void main() {gl_Position=projectTileWithElevation(a_anchor_pos,get_elevation(a_anchor_pos));gl_Position.xy=((a_box_real+0.5)*u_pixel_extrude_scale*2.0-1.0)*vec2(1.0,-1.0)*gl_Position.w;if (gl_Position.z/gl_Position.w < 1.1) {gl_Position.z=0.5;}v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:hd("varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;void main() {float alpha=0.5*min(v_perspective_ratio,1.0);float stroke_radius=0.9*max(v_perspective_ratio,1.0);float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);gl_FragColor=color*alpha*opacity_t;}","attribute vec2 a_pos;attribute float a_radius;attribute vec2 a_flags;uniform mat4 u_matrix;uniform mat4 u_inv_matrix;uniform vec2 u_viewport_size;uniform float u_camera_to_center_distance;varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;vec3 toTilePosition(vec2 screenPos) {vec4 rayStart=u_inv_matrix*vec4(screenPos,-1.0,1.0);vec4 rayEnd  =u_inv_matrix*vec4(screenPos, 1.0,1.0);rayStart.xyz/=rayStart.w;rayEnd.xyz  /=rayEnd.w;highp float t=(0.0-rayStart.z)/(rayEnd.z-rayStart.z);return mix(rayStart.xyz,rayEnd.xyz,t);}void main() {vec2 quadCenterPos=a_pos;float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(mix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;vec3 tilePos=toTilePosition(quadCenterPos);vec4 clipPos=u_matrix*vec4(tilePos,1.0);highp float camera_to_anchor_distance=clipPos.w;highp float collision_perspective_ratio=clamp(0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_perspective_ratio=collision_perspective_ratio;v_collision=collision;gl_Position=vec4(clipPos.xyz/clipPos.w,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),debug:hd("uniform highp vec4 u_color;uniform sampler2D u_overlay;varying vec2 v_uv;void main() {vec4 overlay_color=texture2D(u_overlay,v_uv);gl_FragColor=mix(u_color,overlay_color,overlay_color.a);}","attribute vec2 a_pos;varying vec2 v_uv;uniform mat4 u_matrix;uniform float u_overlay_scale;void main() {v_uv=a_pos/8192.0;gl_Position=u_matrix*vec4(a_pos*u_overlay_scale,get_elevation(a_pos),1);}"),fill:hd("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_FragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);}"),fillOutline:hd("varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);gl_FragColor=outline_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;uniform vec2 u_world;varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;}"),fillOutlinePattern:hd("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);gl_FragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=u_matrix*vec4(a_pos,0,1);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;}"),fillPattern:hd("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);gl_FragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:hd("varying vec4 v_color;void main() {gl_FragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;attribute vec2 a_pos;attribute vec4 a_normal_ed;\n#ifdef TERRAIN3D\nattribute vec2 a_centroid;\n#endif\nvarying vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 normal=a_normal_ed.xyz;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);gl_Position=u_matrix*vec4(a_pos,t > 0.0 ? height : base,1);float colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;float directional=clamp(dot(normal/16384.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:hd("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);gl_FragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;attribute vec2 a_pos;attribute vec4 a_normal_ed;\n#ifdef TERRAIN3D\nattribute vec2 a_centroid;\n#endif\nvarying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 normal=a_normal_ed.xyz;float edgedistance=a_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float z=t > 0.0 ? height : base;gl_Position=u_matrix*vec4(a_pos,z,1);vec2 pos=normal.x==1.0 && normal.y==0.0 && normal.z==16384.0\n? a_pos\n: vec2(edgedistance,z*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal/16383.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:hd("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture2D(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack)/4.0;}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2((c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c))/pow(2.0,exaggeration+(19.2562-u_zoom));gl_FragColor=clamp(vec4(deriv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:hd("uniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;\n#define PI 3.141592653589793\nvoid main() {vec4 pixel=texture2D(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);gl_FragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=a_texture_pos/8192.0;}"),line:hd("uniform lowp float u_device_pixel_ratio;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;varying highp float v_linesofar;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;v_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*2.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:hd("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;varying highp vec2 v_uv;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture2D(u_image,v_uv);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_uv_x;attribute float a_split_index;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;varying highp vec2 v_uv;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:hd("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture2D(u_image,pos_a),texture2D(u_image,pos_b),u_fade);gl_FragColor=color*alpha*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nattribute vec2 a_pos_normal;attribute vec4 a_data;uniform mat4 u_matrix;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:hd("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform float u_sdfgamma;uniform float u_mix;varying vec2 v_normal;varying vec2 v_width2;varying vec2 v_tex_a;varying vec2 v_tex_b;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture2D(u_image,v_tex_a).a;float sdfdist_b=texture2D(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);alpha*=smoothstep(0.5-u_sdfgamma/floorwidth,0.5+u_sdfgamma/floorwidth,sdfdist);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nattribute vec2 a_pos_normal;attribute vec4 a_data;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_patternscale_a;uniform float u_tex_y_a;uniform vec2 u_patternscale_b;uniform float u_tex_y_b;uniform vec2 u_units_to_pixels;varying vec2 v_normal;varying vec2 v_width2;varying vec2 v_tex_a;varying vec2 v_tex_b;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_tex_a=vec2(a_linesofar*u_patternscale_a.x/floorwidth,normal.y*u_patternscale_a.y+u_tex_y_a);v_tex_b=vec2(a_linesofar*u_patternscale_b.x/floorwidth,normal.y*u_patternscale_b.y+u_tex_y_b);v_width2=vec2(outset,inset);}"),raster:hd("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;varying vec2 v_pos0;varying vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture2D(u_image0,v_pos0);vec4 color1=texture2D(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(dot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);gl_FragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;varying vec2 v_pos1;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos0=(((a_texture_pos/8192.0)-0.5)/u_buffer_scale )+0.5;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:hd("uniform sampler2D u_texture;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;gl_FragColor=texture2D(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec4 a_pixeloffset;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;varying vec2 v_tex;varying float v_fade_opacity;vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_matrix*vec4(posInTile,elevation,1.0);}\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;vec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}gl_Position=finalPos;v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float visibility=calculate_visibility(projectedPoint);v_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));}"),symbolSDF:hd("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float inner_edge=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);inner_edge=inner_edge+gamma*gamma_scale;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(inner_edge-gamma_scaled,inner_edge+gamma_scaled,dist);if (u_is_halo) {lowp float halo_edge=(6.0-halo_width/fontScale)/SDF_PX;alpha=min(smoothstep(halo_edge-gamma_scaled,halo_edge+gamma_scaled,dist),1.0-alpha);}gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec4 a_pixeloffset;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_translation;uniform float u_pitched_scale;varying vec2 v_data0;varying vec3 v_data1;vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_matrix*vec4(posInTile,elevation,1.0);}\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;vec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:hd("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;gl_FragColor=texture2D(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;varying vec4 v_data0;varying vec4 v_data1;vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_matrix*vec4(posInTile,elevation,1.0);}\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;vec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrain:hd("uniform sampler2D u_texture;uniform vec4 u_fog_color;uniform vec4 u_horizon_color;uniform float u_fog_ground_blend;uniform float u_fog_ground_blend_opacity;uniform float u_horizon_fog_blend;varying vec2 v_texture_pos;varying float v_fog_depth;const float gamma=2.2;vec4 gammaToLinear(vec4 color) {return pow(color,vec4(gamma));}vec4 linearToGamma(vec4 color) {return pow(color,vec4(1.0/gamma));}void main() {vec4 surface_color=texture2D(u_texture,v_texture_pos);if (v_fog_depth > u_fog_ground_blend) {vec4 surface_color_linear=gammaToLinear(surface_color);float blend_color=smoothstep(0.0,1.0,max((v_fog_depth-u_horizon_fog_blend)/(1.0-u_horizon_fog_blend),0.0));vec4 fog_horizon_color_linear=mix(gammaToLinear(u_fog_color),gammaToLinear(u_horizon_color),blend_color);float factor_fog=max(v_fog_depth-u_fog_ground_blend,0.0)/(1.0-u_fog_ground_blend);gl_FragColor=linearToGamma(mix(surface_color_linear,fog_horizon_color_linear,pow(factor_fog,2.0)*u_fog_ground_blend_opacity));} else {gl_FragColor=surface_color;}}","attribute vec3 a_pos3d;uniform mat4 u_matrix;uniform mat4 u_fog_matrix;uniform float u_ele_delta;varying vec2 v_texture_pos;varying float v_fog_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=u_matrix*vec4(a_pos3d.xy,ele-ele_delta,1.0);vec4 pos=u_fog_matrix*vec4(a_pos3d.xy,ele,1.0);v_fog_depth=pos.z/pos.w*0.5+0.5;}"),terrainDepth:hd("varying float v_depth;const highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitMsk=vec4(0.,vec3(1./256.0));highp vec4 pack(highp float value) {highp vec4 comp=fract(value*bitSh);comp-=comp.xxyz*bitMsk;return comp;}void main() {gl_FragColor=pack(v_depth);}","attribute vec3 a_pos3d;uniform mat4 u_matrix;uniform float u_ele_delta;varying float v_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;gl_Position=u_matrix*vec4(a_pos3d.xy,ele-ele_delta,1.0);v_depth=gl_Position.z/gl_Position.w;}"),terrainCoords:hd("precision mediump float;uniform sampler2D u_texture;uniform float u_terrain_coords_id;varying vec2 v_texture_pos;void main() {vec4 rgba=texture2D(u_texture,v_texture_pos);gl_FragColor=vec4(rgba.r,rgba.g,rgba.b,u_terrain_coords_id);}","attribute vec3 a_pos3d;uniform mat4 u_matrix;uniform float u_ele_delta;varying vec2 v_texture_pos;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=u_matrix*vec4(a_pos3d.xy,ele-ele_delta,1.0);}"),sky:hd("uniform vec4 u_sky_color;uniform vec4 u_horizon_color;uniform float u_horizon;uniform float u_sky_horizon_blend;void main() {float y=gl_FragCoord.y;if (y > u_horizon) {float blend=y-u_horizon;if (blend < u_sky_horizon_blend) {gl_FragColor=mix(u_sky_color,u_horizon_color,pow(1.0-blend/u_sky_horizon_blend,2.0));} else {gl_FragColor=u_sky_color;}}}","attribute vec2 a_pos;void main() {gl_Position=vec4(a_pos,1.0,1.0);}")};function hd(t,e){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,r=e.match(/attribute ([\w]+) ([\w]+)/g),s=t.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),n=e.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),a=n?n.concat(s):s,o={};return{fragmentSource:t=t.replace(i,((t,e,i,r,s)=>(o[s]=!0,"define"===e?`\n#ifndef HAS_UNIFORM_u_${s}\nvarying ${i} ${r} ${s};\n#else\nuniform ${i} ${r} u_${s};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${s}\n    ${i} ${r} ${s} = u_${s};\n#endif\n`))),vertexSource:e=e.replace(i,((t,e,i,r,s)=>{const n="float"===r?"vec2":"vec4",a=s.match(/color/)?"color":n;return o[s]?"define"===e?`\n#ifndef HAS_UNIFORM_u_${s}\nuniform lowp float u_${s}_t;\nattribute ${i} ${n} a_${s};\nvarying ${i} ${r} ${s};\n#else\nuniform ${i} ${r} u_${s};\n#endif\n`:"vec4"===a?`\n#ifndef HAS_UNIFORM_u_${s}\n    ${s} = a_${s};\n#else\n    ${i} ${r} ${s} = u_${s};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${s}\n    ${s} = unpack_mix_${a}(a_${s}, u_${s}_t);\n#else\n    ${i} ${r} ${s} = u_${s};\n#endif\n`:"define"===e?`\n#ifndef HAS_UNIFORM_u_${s}\nuniform lowp float u_${s}_t;\nattribute ${i} ${n} a_${s};\n#else\nuniform ${i} ${r} u_${s};\n#endif\n`:"vec4"===a?`\n#ifndef HAS_UNIFORM_u_${s}\n    ${i} ${r} ${s} = a_${s};\n#else\n    ${i} ${r} ${s} = u_${s};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${s}\n    ${i} ${r} ${s} = unpack_mix_${a}(a_${s}, u_${s}_t);\n#else\n    ${i} ${r} ${s} = u_${s};\n#endif\n`})),staticAttributes:r,staticUniforms:a}}class ud{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null}bind(t,e,i,r,s,n,a,o,l){this.context=t;let c=this.boundPaintVertexBuffers.length!==r.length;for(let t=0;!c&&t<r.length;t++)this.boundPaintVertexBuffers[t]!==r[t]&&(c=!0);!this.vao||this.boundProgram!==e||this.boundLayoutVertexBuffer!==i||c||this.boundIndexBuffer!==s||this.boundVertexOffset!==n||this.boundDynamicVertexBuffer!==a||this.boundDynamicVertexBuffer2!==o||this.boundDynamicVertexBuffer3!==l?this.freshBind(e,i,r,s,n,a,o,l):(t.bindVertexArray.set(this.vao),a&&a.bind(),s&&s.dynamicDraw&&s.bind(),o&&o.bind(),l&&l.bind())}freshBind(t,e,i,r,s,n,a,o){const l=t.numAttributes,c=this.context,h=c.gl;this.vao&&this.destroy(),this.vao=c.createVertexArray(),c.bindVertexArray.set(this.vao),this.boundProgram=t,this.boundLayoutVertexBuffer=e,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=r,this.boundVertexOffset=s,this.boundDynamicVertexBuffer=n,this.boundDynamicVertexBuffer2=a,this.boundDynamicVertexBuffer3=o,e.enableAttributes(h,t);for(const e of i)e.enableAttributes(h,t);n&&n.enableAttributes(h,t),a&&a.enableAttributes(h,t),o&&o.enableAttributes(h,t),e.bind(),e.setVertexAttribPointers(h,t,s);for(const e of i)e.bind(),e.setVertexAttribPointers(h,t,s);n&&(n.bind(),n.setVertexAttribPointers(h,t,s)),r&&r.bind(),a&&(a.bind(),a.setVertexAttribPointers(h,t,s)),o&&(o.bind(),o.setVertexAttribPointers(h,t,s)),c.currentNumAttributes=l}destroy(){this.vao&&(this.context.deleteVertexArray(this.vao),this.vao=null)}}const pd=(t,e,i,r,s)=>({u_matrix:t,u_texture:0,u_ele_delta:e,u_fog_matrix:i,u_fog_color:r?r.properties.get("fog-color"):le.white,u_fog_ground_blend:r?r.properties.get("fog-ground-blend"):1,u_fog_ground_blend_opacity:r?r.calculateFogBlendOpacity(s):0,u_horizon_color:r?r.properties.get("horizon-color"):le.white,u_horizon_fog_blend:r?r.properties.get("horizon-fog-blend"):1});function dd(t){const e=[];for(let i=0;i<t.length;i++){if(null===t[i])continue;const r=t[i].split(" ");e.push(r.pop())}return e}class fd{constructor(t,e,i,r,s,n){const a=t.gl;this.program=a.createProgram();const o=dd(e.staticAttributes),l=i?i.getBinderAttributes():[],c=o.concat(l),h=cd.prelude.staticUniforms?dd(cd.prelude.staticUniforms):[],u=e.staticUniforms?dd(e.staticUniforms):[],p=i?i.getBinderUniforms():[],d=h.concat(u).concat(p),f=[];for(const t of d)f.indexOf(t)<0&&f.push(t);const m=i?i.defines():[];s&&m.push("#define OVERDRAW_INSPECTOR;"),n&&m.push("#define TERRAIN3D;");const _=m.concat(cd.prelude.fragmentSource,e.fragmentSource).join("\n"),g=m.concat(cd.prelude.vertexSource,e.vertexSource).join("\n"),y=a.createShader(a.FRAGMENT_SHADER);if(a.isContextLost())return void(this.failedToCreate=!0);if(a.shaderSource(y,_),a.compileShader(y),!a.getShaderParameter(y,a.COMPILE_STATUS))throw new Error(`Could not compile fragment shader: ${a.getShaderInfoLog(y)}`);a.attachShader(this.program,y);const x=a.createShader(a.VERTEX_SHADER);if(a.isContextLost())return void(this.failedToCreate=!0);if(a.shaderSource(x,g),a.compileShader(x),!a.getShaderParameter(x,a.COMPILE_STATUS))throw new Error(`Could not compile vertex shader: ${a.getShaderInfoLog(x)}`);a.attachShader(this.program,x),this.attributes={};const v={};this.numAttributes=c.length;for(let t=0;t<this.numAttributes;t++)c[t]&&(a.bindAttribLocation(this.program,t,c[t]),this.attributes[c[t]]=t);if(a.linkProgram(this.program),!a.getProgramParameter(this.program,a.LINK_STATUS))throw new Error(`Program failed to link: ${a.getProgramInfoLog(this.program)}`);a.deleteShader(x),a.deleteShader(y);for(let t=0;t<f.length;t++){const e=f[t];if(e&&!v[e]){const t=a.getUniformLocation(this.program,e);t&&(v[e]=t)}}this.fixedUniforms=r(t,v),this.terrainUniforms=((t,e)=>({u_depth:new Ba(t,e.u_depth),u_terrain:new Ba(t,e.u_terrain),u_terrain_dim:new Fa(t,e.u_terrain_dim),u_terrain_matrix:new $a(t,e.u_terrain_matrix),u_terrain_unpack:new Ua(t,e.u_terrain_unpack),u_terrain_exaggeration:new Fa(t,e.u_terrain_exaggeration)}))(t,v),this.binderUniforms=i?i.getUniforms(t,v):[]}draw(t,e,i,r,s,n,a,o,l,c,h,u,p,d,f,m,_,g){const y=t.gl;if(this.failedToCreate)return;if(t.program.set(this.program),t.setDepthMode(i),t.setStencilMode(r),t.setColorMode(s),t.setCullFace(n),o){t.activeTexture.set(y.TEXTURE2),y.bindTexture(y.TEXTURE_2D,o.depthTexture),t.activeTexture.set(y.TEXTURE3),y.bindTexture(y.TEXTURE_2D,o.texture);for(const t in this.terrainUniforms)this.terrainUniforms[t].set(o[t])}for(const t in this.fixedUniforms)this.fixedUniforms[t].set(a[t]);f&&f.setUniforms(t,this.binderUniforms,p,{zoom:d});let x=0;switch(e){case y.LINES:x=2;break;case y.TRIANGLES:x=3;break;case y.LINE_STRIP:x=1}for(const i of u.get()){const r=i.vaos||(i.vaos={});(r[l]||(r[l]=new ud)).bind(t,this,c,f?f.getPaintVertexBuffers():[],h,i.vertexOffset,m,_,g),y.drawElements(e,i.primitiveLength*x,y.UNSIGNED_SHORT,i.primitiveOffset*x*2)}}}function md(t,e,i){const r=1/Ip(i,1,e.transform.tileZoom),s=Math.pow(2,i.tileID.overscaledZ),n=i.tileSize*Math.pow(2,e.transform.tileZoom)/s,a=n*(i.tileID.canonical.x+i.tileID.wrap*s),o=n*i.tileID.canonical.y;return{u_image:0,u_texsize:i.imageAtlasTexture.size,u_scale:[r,t.fromScale,t.toScale],u_fade:t.t,u_pixel_coord_upper:[a>>16,o>>16],u_pixel_coord_lower:[65535&a,65535&o]}}const _d=(t,e,i,r)=>{const s=e.style.light,n=s.properties.get("position"),a=[n.x,n.y,n.z],o=function(){var t=new Ao(9);return Ao!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}();"viewport"===s.properties.get("anchor")&&function(t,e){var i=Math.sin(e),r=Math.cos(e);t[0]=r,t[1]=i,t[2]=0,t[3]=-i,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1}(o,-e.transform.angle),function(t,e,i){var r=e[0],s=e[1],n=e[2];t[0]=r*i[0]+s*i[3]+n*i[6],t[1]=r*i[1]+s*i[4]+n*i[7],t[2]=r*i[2]+s*i[5]+n*i[8]}(a,a,o);const l=s.properties.get("color");return{u_matrix:t,u_lightpos:a,u_lightintensity:s.properties.get("intensity"),u_lightcolor:[l.r,l.g,l.b],u_vertical_gradient:+i,u_opacity:r}},gd=(t,e,i,r,s,n,a)=>y(_d(t,e,i,r),md(n,e,a),{u_height_factor:-Math.pow(2,s.overscaledZ)/a.tileSize/8}),yd=t=>({u_matrix:t}),xd=(t,e,i,r)=>y(yd(t),md(i,e,r)),vd=(t,e)=>({u_matrix:t,u_world:e}),bd=(t,e,i,r,s)=>y(xd(t,e,i,r),{u_world:s}),wd=(t,e,i,r)=>{const s=t.transform;let n,a;if("map"===r.paint.get("circle-pitch-alignment")){const t=Ip(i,1,s.zoom);n=!0,a=[t,t]}else n=!1,a=s.pixelsToGLUnits;return{u_camera_to_center_distance:s.cameraToCenterDistance,u_scale_with_map:+("map"===r.paint.get("circle-pitch-scale")),u_matrix:t.translatePosMatrix(e.posMatrix,i,r.paint.get("circle-translate"),r.paint.get("circle-translate-anchor")),u_pitch_with_map:+n,u_device_pixel_ratio:t.pixelRatio,u_extrude_scale:a}},Td=(t,e,i)=>({u_matrix:t,u_inv_matrix:e,u_camera_to_center_distance:i.cameraToCenterDistance,u_viewport_size:[i.width,i.height]}),Sd=(t,e,i=1)=>({u_matrix:t,u_color:e,u_overlay:0,u_overlay_scale:i}),Id=t=>({u_matrix:t}),Ad=(t,e,i,r)=>({u_matrix:t,u_extrude_scale:Ip(e,1,i),u_intensity:r}),Cd=(t,e,i,r)=>{const s=Co();Fo(s,0,t.width,t.height,0,0,1);const n=t.context.gl;return{u_matrix:s,u_world:[n.drawingBufferWidth,n.drawingBufferHeight],u_image:i,u_color_ramp:r,u_opacity:e.paint.get("heatmap-opacity")}};function Ed(t,e){const i=Math.pow(2,e.canonical.z),r=e.canonical.y;return[new wu(0,r/i).toLngLat().lat,new wu(0,(r+1)/i).toLngLat().lat]}const zd=(t,e,i,r)=>{const s=t.transform;return{u_matrix:Ld(t,e,i,r),u_ratio:1/Ip(e,1,s.zoom),u_device_pixel_ratio:t.pixelRatio,u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]]}},Pd=(t,e,i,r,s)=>y(zd(t,e,i,s),{u_image:0,u_image_height:r}),Md=(t,e,i,r,s)=>{const n=t.transform,a=Dd(e,n);return{u_matrix:Ld(t,e,i,s),u_texsize:e.imageAtlasTexture.size,u_ratio:1/Ip(e,1,n.zoom),u_device_pixel_ratio:t.pixelRatio,u_image:0,u_scale:[a,r.fromScale,r.toScale],u_fade:r.t,u_units_to_pixels:[1/n.pixelsToGLUnits[0],1/n.pixelsToGLUnits[1]]}},kd=(t,e,i,r,s,n)=>{const a=t.lineAtlas,o=Dd(e,t.transform),l="round"===i.layout.get("line-cap"),c=a.getDash(r.from,l),h=a.getDash(r.to,l),u=c.width*s.fromScale,p=h.width*s.toScale;return y(zd(t,e,i,n),{u_patternscale_a:[o/u,-c.height/2],u_patternscale_b:[o/p,-h.height/2],u_sdfgamma:a.width/(256*Math.min(u,p)*t.pixelRatio)/2,u_image:0,u_tex_y_a:c.y,u_tex_y_b:h.y,u_mix:s.t})};function Dd(t,e){return 1/Ip(t,1,e.tileZoom)}function Ld(t,e,i,r){return t.translatePosMatrix(r?r.posMatrix:e.tileID.posMatrix,e,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}const Rd=(t,e,i,r,s)=>{return{u_matrix:t,u_tl_parent:e,u_scale_parent:i,u_buffer_scale:1,u_fade_t:r.mix,u_opacity:r.opacity*s.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:s.paint.get("raster-brightness-min"),u_brightness_high:s.paint.get("raster-brightness-max"),u_saturation_factor:(a=s.paint.get("raster-saturation"),a>0?1-1/(1.001-a):-a),u_contrast_factor:(n=s.paint.get("raster-contrast"),n>0?1/(1-n):1+n),u_spin_weights:Bd(s.paint.get("raster-hue-rotate"))};var n,a};function Bd(t){t*=Math.PI/180;const e=Math.sin(t),i=Math.cos(t);return[(2*i+1)/3,(-Math.sqrt(3)*e-i+1)/3,(Math.sqrt(3)*e-i+1)/3]}const Fd=(t,e,i,r,s,n,a,o,l,c,h,u,p,d)=>{const f=a.transform;return{u_is_size_zoom_constant:+("constant"===t||"source"===t),u_is_size_feature_constant:+("constant"===t||"camera"===t),u_size_t:e?e.uSizeT:0,u_size:e?e.uSize:0,u_camera_to_center_distance:f.cameraToCenterDistance,u_pitch:f.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:f.width/f.height,u_fade_change:a.options.fadeDuration?a.symbolFadeChange:1,u_matrix:o,u_label_plane_matrix:l,u_coord_matrix:c,u_is_text:+u,u_pitch_with_map:+r,u_is_along_line:s,u_is_variable_anchor:n,u_texsize:p,u_texture:0,u_translation:h,u_pitched_scale:d}},Od=(t,e,i,r,s,n,a,o,l,c,h,u,p,d,f)=>{const m=a.transform;return y(Fd(t,e,i,r,s,n,a,o,l,c,h,u,p,f),{u_gamma_scale:r?Math.cos(m._pitch)*m.cameraToCenterDistance:1,u_device_pixel_ratio:a.pixelRatio,u_is_halo:+d})},Vd=(t,e,i,r,s,n,a,o,l,c,h,u,p,d)=>y(Od(t,e,i,r,s,n,a,o,l,c,h,!0,u,!0,d),{u_texsize_icon:p,u_texture_icon:1}),Ud=(t,e,i)=>({u_matrix:t,u_opacity:e,u_color:i}),Nd=(t,e,i,r,s,n)=>y(function(t,e,i,r){const s=i.imageManager.getPattern(t.from.toString()),n=i.imageManager.getPattern(t.to.toString()),{width:a,height:o}=i.imageManager.getPixelSize(),l=Math.pow(2,r.tileID.overscaledZ),c=r.tileSize*Math.pow(2,i.transform.tileZoom)/l,h=c*(r.tileID.canonical.x+r.tileID.wrap*l),u=c*r.tileID.canonical.y;return{u_image:0,u_pattern_tl_a:s.tl,u_pattern_br_a:s.br,u_pattern_tl_b:n.tl,u_pattern_br_b:n.br,u_texsize:[a,o],u_mix:e.t,u_pattern_size_a:s.displaySize,u_pattern_size_b:n.displaySize,u_scale_a:e.fromScale,u_scale_b:e.toScale,u_tile_units_to_pixels:1/Ip(r,1,i.transform.tileZoom),u_pixel_coord_upper:[h>>16,u>>16],u_pixel_coord_lower:[65535&h,65535&u]}}(r,n,i,s),{u_matrix:t,u_opacity:e}),jd={fillExtrusion:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_lightpos:new Va(t,e.u_lightpos),u_lightintensity:new Fa(t,e.u_lightintensity),u_lightcolor:new Va(t,e.u_lightcolor),u_vertical_gradient:new Fa(t,e.u_vertical_gradient),u_opacity:new Fa(t,e.u_opacity)}),fillExtrusionPattern:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_lightpos:new Va(t,e.u_lightpos),u_lightintensity:new Fa(t,e.u_lightintensity),u_lightcolor:new Va(t,e.u_lightcolor),u_vertical_gradient:new Fa(t,e.u_vertical_gradient),u_height_factor:new Fa(t,e.u_height_factor),u_image:new Ba(t,e.u_image),u_texsize:new Oa(t,e.u_texsize),u_pixel_coord_upper:new Oa(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new Oa(t,e.u_pixel_coord_lower),u_scale:new Va(t,e.u_scale),u_fade:new Fa(t,e.u_fade),u_opacity:new Fa(t,e.u_opacity)}),fill:(t,e)=>({u_matrix:new $a(t,e.u_matrix)}),fillPattern:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_image:new Ba(t,e.u_image),u_texsize:new Oa(t,e.u_texsize),u_pixel_coord_upper:new Oa(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new Oa(t,e.u_pixel_coord_lower),u_scale:new Va(t,e.u_scale),u_fade:new Fa(t,e.u_fade)}),fillOutline:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_world:new Oa(t,e.u_world)}),fillOutlinePattern:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_world:new Oa(t,e.u_world),u_image:new Ba(t,e.u_image),u_texsize:new Oa(t,e.u_texsize),u_pixel_coord_upper:new Oa(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new Oa(t,e.u_pixel_coord_lower),u_scale:new Va(t,e.u_scale),u_fade:new Fa(t,e.u_fade)}),circle:(t,e)=>({u_camera_to_center_distance:new Fa(t,e.u_camera_to_center_distance),u_scale_with_map:new Ba(t,e.u_scale_with_map),u_pitch_with_map:new Ba(t,e.u_pitch_with_map),u_extrude_scale:new Oa(t,e.u_extrude_scale),u_device_pixel_ratio:new Fa(t,e.u_device_pixel_ratio),u_matrix:new $a(t,e.u_matrix)}),collisionBox:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_pixel_extrude_scale:new Oa(t,e.u_pixel_extrude_scale)}),collisionCircle:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_inv_matrix:new $a(t,e.u_inv_matrix),u_camera_to_center_distance:new Fa(t,e.u_camera_to_center_distance),u_viewport_size:new Oa(t,e.u_viewport_size)}),debug:(t,e)=>({u_color:new Na(t,e.u_color),u_matrix:new $a(t,e.u_matrix),u_overlay:new Ba(t,e.u_overlay),u_overlay_scale:new Fa(t,e.u_overlay_scale)}),clippingMask:(t,e)=>({u_matrix:new $a(t,e.u_matrix)}),heatmap:(t,e)=>({u_extrude_scale:new Fa(t,e.u_extrude_scale),u_intensity:new Fa(t,e.u_intensity),u_matrix:new $a(t,e.u_matrix)}),heatmapTexture:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_world:new Oa(t,e.u_world),u_image:new Ba(t,e.u_image),u_color_ramp:new Ba(t,e.u_color_ramp),u_opacity:new Fa(t,e.u_opacity)}),hillshade:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_image:new Ba(t,e.u_image),u_latrange:new Oa(t,e.u_latrange),u_light:new Oa(t,e.u_light),u_shadow:new Na(t,e.u_shadow),u_highlight:new Na(t,e.u_highlight),u_accent:new Na(t,e.u_accent)}),hillshadePrepare:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_image:new Ba(t,e.u_image),u_dimension:new Oa(t,e.u_dimension),u_zoom:new Fa(t,e.u_zoom),u_unpack:new Ua(t,e.u_unpack)}),line:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_ratio:new Fa(t,e.u_ratio),u_device_pixel_ratio:new Fa(t,e.u_device_pixel_ratio),u_units_to_pixels:new Oa(t,e.u_units_to_pixels)}),lineGradient:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_ratio:new Fa(t,e.u_ratio),u_device_pixel_ratio:new Fa(t,e.u_device_pixel_ratio),u_units_to_pixels:new Oa(t,e.u_units_to_pixels),u_image:new Ba(t,e.u_image),u_image_height:new Fa(t,e.u_image_height)}),linePattern:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_texsize:new Oa(t,e.u_texsize),u_ratio:new Fa(t,e.u_ratio),u_device_pixel_ratio:new Fa(t,e.u_device_pixel_ratio),u_image:new Ba(t,e.u_image),u_units_to_pixels:new Oa(t,e.u_units_to_pixels),u_scale:new Va(t,e.u_scale),u_fade:new Fa(t,e.u_fade)}),lineSDF:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_ratio:new Fa(t,e.u_ratio),u_device_pixel_ratio:new Fa(t,e.u_device_pixel_ratio),u_units_to_pixels:new Oa(t,e.u_units_to_pixels),u_patternscale_a:new Oa(t,e.u_patternscale_a),u_patternscale_b:new Oa(t,e.u_patternscale_b),u_sdfgamma:new Fa(t,e.u_sdfgamma),u_image:new Ba(t,e.u_image),u_tex_y_a:new Fa(t,e.u_tex_y_a),u_tex_y_b:new Fa(t,e.u_tex_y_b),u_mix:new Fa(t,e.u_mix)}),raster:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_tl_parent:new Oa(t,e.u_tl_parent),u_scale_parent:new Fa(t,e.u_scale_parent),u_buffer_scale:new Fa(t,e.u_buffer_scale),u_fade_t:new Fa(t,e.u_fade_t),u_opacity:new Fa(t,e.u_opacity),u_image0:new Ba(t,e.u_image0),u_image1:new Ba(t,e.u_image1),u_brightness_low:new Fa(t,e.u_brightness_low),u_brightness_high:new Fa(t,e.u_brightness_high),u_saturation_factor:new Fa(t,e.u_saturation_factor),u_contrast_factor:new Fa(t,e.u_contrast_factor),u_spin_weights:new Va(t,e.u_spin_weights)}),symbolIcon:(t,e)=>({u_is_size_zoom_constant:new Ba(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new Ba(t,e.u_is_size_feature_constant),u_size_t:new Fa(t,e.u_size_t),u_size:new Fa(t,e.u_size),u_camera_to_center_distance:new Fa(t,e.u_camera_to_center_distance),u_pitch:new Fa(t,e.u_pitch),u_rotate_symbol:new Ba(t,e.u_rotate_symbol),u_aspect_ratio:new Fa(t,e.u_aspect_ratio),u_fade_change:new Fa(t,e.u_fade_change),u_matrix:new $a(t,e.u_matrix),u_label_plane_matrix:new $a(t,e.u_label_plane_matrix),u_coord_matrix:new $a(t,e.u_coord_matrix),u_is_text:new Ba(t,e.u_is_text),u_pitch_with_map:new Ba(t,e.u_pitch_with_map),u_is_along_line:new Ba(t,e.u_is_along_line),u_is_variable_anchor:new Ba(t,e.u_is_variable_anchor),u_texsize:new Oa(t,e.u_texsize),u_texture:new Ba(t,e.u_texture),u_translation:new Oa(t,e.u_translation),u_pitched_scale:new Fa(t,e.u_pitched_scale)}),symbolSDF:(t,e)=>({u_is_size_zoom_constant:new Ba(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new Ba(t,e.u_is_size_feature_constant),u_size_t:new Fa(t,e.u_size_t),u_size:new Fa(t,e.u_size),u_camera_to_center_distance:new Fa(t,e.u_camera_to_center_distance),u_pitch:new Fa(t,e.u_pitch),u_rotate_symbol:new Ba(t,e.u_rotate_symbol),u_aspect_ratio:new Fa(t,e.u_aspect_ratio),u_fade_change:new Fa(t,e.u_fade_change),u_matrix:new $a(t,e.u_matrix),u_label_plane_matrix:new $a(t,e.u_label_plane_matrix),u_coord_matrix:new $a(t,e.u_coord_matrix),u_is_text:new Ba(t,e.u_is_text),u_pitch_with_map:new Ba(t,e.u_pitch_with_map),u_is_along_line:new Ba(t,e.u_is_along_line),u_is_variable_anchor:new Ba(t,e.u_is_variable_anchor),u_texsize:new Oa(t,e.u_texsize),u_texture:new Ba(t,e.u_texture),u_gamma_scale:new Fa(t,e.u_gamma_scale),u_device_pixel_ratio:new Fa(t,e.u_device_pixel_ratio),u_is_halo:new Ba(t,e.u_is_halo),u_translation:new Oa(t,e.u_translation),u_pitched_scale:new Fa(t,e.u_pitched_scale)}),symbolTextAndIcon:(t,e)=>({u_is_size_zoom_constant:new Ba(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new Ba(t,e.u_is_size_feature_constant),u_size_t:new Fa(t,e.u_size_t),u_size:new Fa(t,e.u_size),u_camera_to_center_distance:new Fa(t,e.u_camera_to_center_distance),u_pitch:new Fa(t,e.u_pitch),u_rotate_symbol:new Ba(t,e.u_rotate_symbol),u_aspect_ratio:new Fa(t,e.u_aspect_ratio),u_fade_change:new Fa(t,e.u_fade_change),u_matrix:new $a(t,e.u_matrix),u_label_plane_matrix:new $a(t,e.u_label_plane_matrix),u_coord_matrix:new $a(t,e.u_coord_matrix),u_is_text:new Ba(t,e.u_is_text),u_pitch_with_map:new Ba(t,e.u_pitch_with_map),u_is_along_line:new Ba(t,e.u_is_along_line),u_is_variable_anchor:new Ba(t,e.u_is_variable_anchor),u_texsize:new Oa(t,e.u_texsize),u_texsize_icon:new Oa(t,e.u_texsize_icon),u_texture:new Ba(t,e.u_texture),u_texture_icon:new Ba(t,e.u_texture_icon),u_gamma_scale:new Fa(t,e.u_gamma_scale),u_device_pixel_ratio:new Fa(t,e.u_device_pixel_ratio),u_is_halo:new Ba(t,e.u_is_halo),u_translation:new Oa(t,e.u_translation),u_pitched_scale:new Fa(t,e.u_pitched_scale)}),background:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_opacity:new Fa(t,e.u_opacity),u_color:new Na(t,e.u_color)}),backgroundPattern:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_opacity:new Fa(t,e.u_opacity),u_image:new Ba(t,e.u_image),u_pattern_tl_a:new Oa(t,e.u_pattern_tl_a),u_pattern_br_a:new Oa(t,e.u_pattern_br_a),u_pattern_tl_b:new Oa(t,e.u_pattern_tl_b),u_pattern_br_b:new Oa(t,e.u_pattern_br_b),u_texsize:new Oa(t,e.u_texsize),u_mix:new Fa(t,e.u_mix),u_pattern_size_a:new Oa(t,e.u_pattern_size_a),u_pattern_size_b:new Oa(t,e.u_pattern_size_b),u_scale_a:new Fa(t,e.u_scale_a),u_scale_b:new Fa(t,e.u_scale_b),u_pixel_coord_upper:new Oa(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new Oa(t,e.u_pixel_coord_lower),u_tile_units_to_pixels:new Fa(t,e.u_tile_units_to_pixels)}),terrain:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_texture:new Ba(t,e.u_texture),u_ele_delta:new Fa(t,e.u_ele_delta),u_fog_matrix:new $a(t,e.u_fog_matrix),u_fog_color:new Na(t,e.u_fog_color),u_fog_ground_blend:new Fa(t,e.u_fog_ground_blend),u_fog_ground_blend_opacity:new Fa(t,e.u_fog_ground_blend_opacity),u_horizon_color:new Na(t,e.u_horizon_color),u_horizon_fog_blend:new Fa(t,e.u_horizon_fog_blend)}),terrainDepth:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_ele_delta:new Fa(t,e.u_ele_delta)}),terrainCoords:(t,e)=>({u_matrix:new $a(t,e.u_matrix),u_texture:new Ba(t,e.u_texture),u_terrain_coords_id:new Fa(t,e.u_terrain_coords_id),u_ele_delta:new Fa(t,e.u_ele_delta)}),sky:(t,e)=>({u_sky_color:new Na(t,e.u_sky_color),u_horizon_color:new Na(t,e.u_horizon_color),u_horizon:new Fa(t,e.u_horizon),u_sky_horizon_blend:new Fa(t,e.u_sky_horizon_blend)})};class $d{constructor(t,e,i){this.context=t;const r=t.gl;this.buffer=r.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),t.bindElementBuffer.set(this.buffer),r.bufferData(r.ELEMENT_ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer}bind(){this.context.bindElementBuffer.set(this.buffer)}updateData(t){const e=this.context.gl;if(!this.dynamicDraw)throw new Error("Attempted to update data while not in dynamic mode.");this.context.unbindVAO(),this.bind(),e.bufferSubData(e.ELEMENT_ARRAY_BUFFER,0,t.arrayBuffer)}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}const qd={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class Zd{constructor(t,e,i,r){this.length=e.length,this.attributes=i,this.itemSize=e.bytesPerElement,this.dynamicDraw=r,this.context=t;const s=t.gl;this.buffer=s.createBuffer(),t.bindVertexBuffer.set(this.buffer),s.bufferData(s.ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?s.DYNAMIC_DRAW:s.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer}bind(){this.context.bindVertexBuffer.set(this.buffer)}updateData(t){if(t.length!==this.length)throw new Error(`Length of new data is ${t.length}, which doesn't match current length of ${this.length}`);const e=this.context.gl;this.bind(),e.bufferSubData(e.ARRAY_BUFFER,0,t.arrayBuffer)}enableAttributes(t,e){for(let i=0;i<this.attributes.length;i++){const r=e.attributes[this.attributes[i].name];void 0!==r&&t.enableVertexAttribArray(r)}}setVertexAttribPointers(t,e,i){for(let r=0;r<this.attributes.length;r++){const s=this.attributes[r],n=e.attributes[s.name];void 0!==n&&t.vertexAttribPointer(n,s.components,t[qd[s.type]],!1,this.itemSize,s.offset+this.itemSize*(i||0))}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}const Gd=new WeakMap;function Wd(t){var e;if(Gd.has(t))return Gd.get(t);{const i=null===(e=t.getParameter(t.VERSION))||void 0===e?void 0:e.startsWith("WebGL 2.0");return Gd.set(t,i),i}}class Hd{constructor(t){this.gl=t.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1}get(){return this.current}set(t){}getDefault(){return this.default}setDefault(){this.set(this.default)}}class Xd extends Hd{getDefault(){return le.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.clearColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1)}}class Kd extends Hd{getDefault(){return 1}set(t){(t!==this.current||this.dirty)&&(this.gl.clearDepth(t),this.current=t,this.dirty=!1)}}class Yd extends Hd{getDefault(){return 0}set(t){(t!==this.current||this.dirty)&&(this.gl.clearStencil(t),this.current=t,this.dirty=!1)}}class Jd extends Hd{getDefault(){return[!0,!0,!0,!0]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.colorMask(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1)}}class Qd extends Hd{getDefault(){return!0}set(t){(t!==this.current||this.dirty)&&(this.gl.depthMask(t),this.current=t,this.dirty=!1)}}class tf extends Hd{getDefault(){return 255}set(t){(t!==this.current||this.dirty)&&(this.gl.stencilMask(t),this.current=t,this.dirty=!1)}}class ef extends Hd{getDefault(){return{func:this.gl.ALWAYS,ref:0,mask:255}}set(t){const e=this.current;(t.func!==e.func||t.ref!==e.ref||t.mask!==e.mask||this.dirty)&&(this.gl.stencilFunc(t.func,t.ref,t.mask),this.current=t,this.dirty=!1)}}class rf extends Hd{getDefault(){const t=this.gl;return[t.KEEP,t.KEEP,t.KEEP]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||this.dirty)&&(this.gl.stencilOp(t[0],t[1],t[2]),this.current=t,this.dirty=!1)}}class sf extends Hd{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.STENCIL_TEST):e.disable(e.STENCIL_TEST),this.current=t,this.dirty=!1}}class nf extends Hd{getDefault(){return[0,1]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.depthRange(t[0],t[1]),this.current=t,this.dirty=!1)}}class af extends Hd{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST),this.current=t,this.dirty=!1}}class of extends Hd{getDefault(){return this.gl.LESS}set(t){(t!==this.current||this.dirty)&&(this.gl.depthFunc(t),this.current=t,this.dirty=!1)}}class lf extends Hd{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.BLEND):e.disable(e.BLEND),this.current=t,this.dirty=!1}}class cf extends Hd{getDefault(){const t=this.gl;return[t.ONE,t.ZERO]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.blendFunc(t[0],t[1]),this.current=t,this.dirty=!1)}}class hf extends Hd{getDefault(){return le.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.blendColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1)}}class uf extends Hd{getDefault(){return this.gl.FUNC_ADD}set(t){(t!==this.current||this.dirty)&&(this.gl.blendEquation(t),this.current=t,this.dirty=!1)}}class pf extends Hd{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.CULL_FACE):e.disable(e.CULL_FACE),this.current=t,this.dirty=!1}}class df extends Hd{getDefault(){return this.gl.BACK}set(t){(t!==this.current||this.dirty)&&(this.gl.cullFace(t),this.current=t,this.dirty=!1)}}class ff extends Hd{getDefault(){return this.gl.CCW}set(t){(t!==this.current||this.dirty)&&(this.gl.frontFace(t),this.current=t,this.dirty=!1)}}class mf extends Hd{getDefault(){return null}set(t){(t!==this.current||this.dirty)&&(this.gl.useProgram(t),this.current=t,this.dirty=!1)}}class _f extends Hd{getDefault(){return this.gl.TEXTURE0}set(t){(t!==this.current||this.dirty)&&(this.gl.activeTexture(t),this.current=t,this.dirty=!1)}}class gf extends Hd{getDefault(){const t=this.gl;return[0,0,t.drawingBufferWidth,t.drawingBufferHeight]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.viewport(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1)}}class yf extends Hd{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindFramebuffer(e.FRAMEBUFFER,t),this.current=t,this.dirty=!1}}class xf extends Hd{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindRenderbuffer(e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}class vf extends Hd{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindTexture(e.TEXTURE_2D,t),this.current=t,this.dirty=!1}}class bf extends Hd{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindBuffer(e.ARRAY_BUFFER,t),this.current=t,this.dirty=!1}}class wf extends Hd{getDefault(){return null}set(t){const e=this.gl;e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t),this.current=t,this.dirty=!1}}class Tf extends Hd{getDefault(){return null}set(t){var e;if(t===this.current&&!this.dirty)return;const i=this.gl;Wd(i)?i.bindVertexArray(t):null===(e=i.getExtension("OES_vertex_array_object"))||void 0===e||e.bindVertexArrayOES(t),this.current=t,this.dirty=!1}}class Sf extends Hd{getDefault(){return 4}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_ALIGNMENT,t),this.current=t,this.dirty=!1}}class If extends Hd{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t),this.current=t,this.dirty=!1}}class Af extends Hd{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,t),this.current=t,this.dirty=!1}}class Cf extends Hd{constructor(t,e){super(t),this.context=t,this.parent=e}getDefault(){return null}}class Ef extends Cf{setDirty(){this.dirty=!0}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0),this.current=t,this.dirty=!1}}class zf extends Cf{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}class Pf extends Cf{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_STENCIL_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}class Mf{constructor(t,e,i,r,s){this.context=t,this.width=e,this.height=i;const n=t.gl,a=this.framebuffer=n.createFramebuffer();if(this.colorAttachment=new Ef(t,a),r)this.depthAttachment=s?new Pf(t,a):new zf(t,a);else if(s)throw new Error("Stencil cannot be set without depth");if(n.checkFramebufferStatus(n.FRAMEBUFFER)!==n.FRAMEBUFFER_COMPLETE)throw new Error("Framebuffer is not complete")}destroy(){const t=this.context.gl,e=this.colorAttachment.get();if(e&&t.deleteTexture(e),this.depthAttachment){const e=this.depthAttachment.get();e&&t.deleteRenderbuffer(e)}t.deleteFramebuffer(this.framebuffer)}}class kf{constructor(t,e,i){this.blendFunction=t,this.blendColor=e,this.mask=i}}kf.Replace=[1,0],kf.disabled=new kf(kf.Replace,le.transparent,[!1,!1,!1,!1]),kf.unblended=new kf(kf.Replace,le.transparent,[!0,!0,!0,!0]),kf.alphaBlended=new kf([1,771],le.transparent,[!0,!0,!0,!0]);class Df{constructor(t){var e,i;if(this.gl=t,this.clearColor=new Xd(this),this.clearDepth=new Kd(this),this.clearStencil=new Yd(this),this.colorMask=new Jd(this),this.depthMask=new Qd(this),this.stencilMask=new tf(this),this.stencilFunc=new ef(this),this.stencilOp=new rf(this),this.stencilTest=new sf(this),this.depthRange=new nf(this),this.depthTest=new af(this),this.depthFunc=new of(this),this.blend=new lf(this),this.blendFunc=new cf(this),this.blendColor=new hf(this),this.blendEquation=new uf(this),this.cullFace=new pf(this),this.cullFaceSide=new df(this),this.frontFace=new ff(this),this.program=new mf(this),this.activeTexture=new _f(this),this.viewport=new gf(this),this.bindFramebuffer=new yf(this),this.bindRenderbuffer=new xf(this),this.bindTexture=new vf(this),this.bindVertexBuffer=new bf(this),this.bindElementBuffer=new wf(this),this.bindVertexArray=new Tf(this),this.pixelStoreUnpack=new Sf(this),this.pixelStoreUnpackPremultiplyAlpha=new If(this),this.pixelStoreUnpackFlipY=new Af(this),this.extTextureFilterAnisotropic=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=t.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.maxTextureSize=t.getParameter(t.MAX_TEXTURE_SIZE),Wd(t)){this.HALF_FLOAT=t.HALF_FLOAT;const r=t.getExtension("EXT_color_buffer_half_float");this.RGBA16F=null!==(e=t.RGBA16F)&&void 0!==e?e:null==r?void 0:r.RGBA16F_EXT,this.RGB16F=null!==(i=t.RGB16F)&&void 0!==i?i:null==r?void 0:r.RGB16F_EXT,t.getExtension("EXT_color_buffer_float")}else{t.getExtension("EXT_color_buffer_half_float"),t.getExtension("OES_texture_half_float_linear");const e=t.getExtension("OES_texture_half_float");this.HALF_FLOAT=null==e?void 0:e.HALF_FLOAT_OES}}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault()}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArray.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0}createIndexBuffer(t,e){return new $d(this,t,e)}createVertexBuffer(t,e,i){return new Zd(this,t,e,i)}createRenderbuffer(t,e,i){const r=this.gl,s=r.createRenderbuffer();return this.bindRenderbuffer.set(s),r.renderbufferStorage(r.RENDERBUFFER,t,e,i),this.bindRenderbuffer.set(null),s}createFramebuffer(t,e,i,r){return new Mf(this,t,e,i,r)}clear({color:t,depth:e,stencil:i}){const r=this.gl;let s=0;t&&(s|=r.COLOR_BUFFER_BIT,this.clearColor.set(t),this.colorMask.set([!0,!0,!0,!0])),void 0!==e&&(s|=r.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(e),this.depthMask.set(!0)),void 0!==i&&(s|=r.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),r.clear(s)}setCullFace(t){!1===t.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(t.mode),this.frontFace.set(t.frontFace))}setDepthMode(t){t.func!==this.gl.ALWAYS||t.mask?(this.depthTest.set(!0),this.depthFunc.set(t.func),this.depthMask.set(t.mask),this.depthRange.set(t.range)):this.depthTest.set(!1)}setStencilMode(t){t.test.func!==this.gl.ALWAYS||t.mask?(this.stencilTest.set(!0),this.stencilMask.set(t.mask),this.stencilOp.set([t.fail,t.depthFail,t.pass]),this.stencilFunc.set({func:t.test.func,ref:t.ref,mask:t.test.mask})):this.stencilTest.set(!1)}setColorMode(t){S(t.blendFunction,kf.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(t.blendFunction),this.blendColor.set(t.blendColor)),this.colorMask.set(t.mask)}createVertexArray(){var t;return Wd(this.gl)?this.gl.createVertexArray():null===(t=this.gl.getExtension("OES_vertex_array_object"))||void 0===t?void 0:t.createVertexArrayOES()}deleteVertexArray(t){var e;return Wd(this.gl)?this.gl.deleteVertexArray(t):null===(e=this.gl.getExtension("OES_vertex_array_object"))||void 0===e?void 0:e.deleteVertexArrayOES(t)}unbindVAO(){this.bindVertexArray.set(null)}}class Lf{constructor(t,e,i){this.func=t,this.mask=e,this.range=i}}Lf.ReadOnly=!1,Lf.ReadWrite=!0,Lf.disabled=new Lf(519,Lf.ReadOnly,[0,1]);const Rf=7680;class Bf{constructor(t,e,i,r,s,n){this.test=t,this.ref=e,this.mask=i,this.fail=r,this.depthFail=s,this.pass=n}}Bf.disabled=new Bf({func:519,mask:0},0,0,Rf,Rf,Rf);class Ff{constructor(t,e,i){this.enable=t,this.mode=e,this.frontFace=i}}let Of;function Vf(t,e,i,r,s){const n=t.context,a=n.gl,o=t.useProgram("collisionBox"),l=[];let c=0,h=0;for(let p=0;p<r.length;p++){const d=r[p],f=e.getTile(d).getBucket(i);if(!f)continue;const m=s?f.textCollisionBox:f.iconCollisionBox,_=f.collisionCircleArray;if(_.length>0){const e=Co();Oo(e,f.placementInvProjMatrix,t.transform.glCoordMatrix),Oo(e,e,f.placementViewportMatrix),l.push({circleArray:_,circleOffset:h,transform:d.posMatrix,invTransform:e,coord:d}),c+=_.length/4,h=c}m&&o.draw(n,a.LINES,Lf.disabled,Bf.disabled,t.colorModeForRenderPass(),Ff.disabled,{u_matrix:d.posMatrix,u_pixel_extrude_scale:[1/(u=t.transform).width,1/u.height]},t.style.map.terrain&&t.style.map.terrain.getTerrainData(d),i.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,null,t.transform.zoom,null,null,m.collisionVertexBuffer)}var u;if(!s||!l.length)return;const p=t.useProgram("collisionCircle"),d=new da;d.resize(4*c),d._trim();let f=0;for(const t of l)for(let e=0;e<t.circleArray.length/4;e++){const i=4*e,r=t.circleArray[i+0],s=t.circleArray[i+1],n=t.circleArray[i+2],a=t.circleArray[i+3];d.emplace(f++,r,s,n,a,0),d.emplace(f++,r,s,n,a,1),d.emplace(f++,r,s,n,a,2),d.emplace(f++,r,s,n,a,3)}(!Of||Of.length<2*c)&&(Of=function(t){const e=2*t,i=new ma;i.resize(e),i._trim();for(let t=0;t<e;t++){const e=6*t;i.uint16[e+0]=4*t+0,i.uint16[e+1]=4*t+1,i.uint16[e+2]=4*t+2,i.uint16[e+3]=4*t+2,i.uint16[e+4]=4*t+3,i.uint16[e+5]=4*t+0}return i}(c));const m=n.createIndexBuffer(Of,!0),_=n.createVertexBuffer(d,Mc.members,!0);for(const e of l){const r=Td(e.transform,e.invTransform,t.transform);p.draw(n,a.TRIANGLES,Lf.disabled,Bf.disabled,t.colorModeForRenderPass(),Ff.disabled,r,t.style.map.terrain&&t.style.map.terrain.getTerrainData(e.coord),i.id,_,m,ba.simpleSegment(0,2*e.circleOffset,e.circleArray.length,e.circleArray.length/2),null,t.transform.zoom,null,null,null)}_.destroy(),m.destroy()}Ff.disabled=new Ff(!1,1029,2305),Ff.backCCW=new Ff(!0,1029,2305);const Uf=zo(new Float32Array(16));function Nf(t,e,i,r,s,n){const{horizontalAlign:o,verticalAlign:l}=hh(t);return new a((-(o-.5)*e/s+r[0])*n,(-(l-.5)*i/s+r[1])*n)}function jf(t,e,i,r,s,n){const o=e.tileAnchorPoint.add(new a(e.translation[0],e.translation[1]));if(e.pitchWithMap){let t=r.mult(n);i||(t=t.rotate(-s));const a=o.add(t);return np(a.x,a.y,e.labelPlaneMatrix,e.getElevation).point}if(i){const i=fp(e.tileAnchorPoint.x+1,e.tileAnchorPoint.y,e).point.sub(t),s=Math.atan(i.y/i.x)+(i.x<0?Math.PI:0);return t.add(r.rotate(s))}return t.add(r)}function $f(t,e,i,r,s,n,o,l,c,h,u,p,d,f){const m=t.text.placedSymbolArray,_=t.text.dynamicLayoutVertexArray,g=t.icon.dynamicLayoutVertexArray,y={};_.clear();for(let g=0;g<m.length;g++){const x=m.get(g),v=x.hidden||!x.crossTileID||t.allowVerticalPlacement&&!x.placedOrientation?null:r[x.crossTileID];if(v){const r=new a(x.anchorX,x.anchorY),m={getElevation:f,width:s.width,height:s.height,labelPlaneMatrix:n,lineVertexArray:null,pitchWithMap:i,projection:u,projectionCache:null,tileAnchorPoint:r,translation:p,unwrappedTileID:d},g=i?np(r.x,r.y,o,f):fp(r.x,r.y,m),b=ap(s.cameraToCenterDistance,g.signedDistanceFromCamera);let w=fh(t.textSizeData,c,x)*b/24;i&&(w*=t.tilePixelRatio/l);const{width:T,height:S,anchor:I,textOffset:A,textBoxScale:C}=v,E=Nf(I,T,S,A,C,w),z=u.getPitchedTextCorrection(s,r.add(new a(p[0],p[1])),d),P=jf(g.point,m,e,E,s.angle,z),M=t.allowVerticalPlacement&&x.placedOrientation===ch.vertical?Math.PI/2:0;for(let t=0;t<x.numGlyphs;t++)vh(_,P,M);h&&x.associatedIconIndex>=0&&(y[x.associatedIconIndex]={shiftedAnchor:P,angle:M})}else xp(x.numGlyphs,_)}if(h){g.clear();const e=t.icon.placedSymbolArray;for(let t=0;t<e.length;t++){const i=e.get(t);if(i.hidden)xp(i.numGlyphs,g);else{const e=y[t];if(e)for(let t=0;t<i.numGlyphs;t++)vh(g,e.shiftedAnchor,e.angle);else xp(i.numGlyphs,g)}}t.icon.dynamicLayoutVertexBuffer.updateData(g)}t.text.dynamicLayoutVertexBuffer.updateData(_)}function qf(t,e,i){return i.iconsInText&&e?"symbolTextAndIcon":t?"symbolSDF":"symbolIcon"}function Zf(t,e,i,r,s,n,a,o,l,c,h,u){const p=t.context,d=p.gl,f=t.transform,m=qp(),_="map"===o,g="map"===l,y="viewport"!==o&&"point"!==i.layout.get("symbol-placement"),x=_&&!g&&!y,v=!g&&y,b=!i.layout.get("symbol-sort-key").isConstant();let w=!1;const T=t.depthModeForSublayer(0,Lf.ReadOnly),S=i._unevaluatedLayout.hasValue("text-variable-anchor")||i._unevaluatedLayout.hasValue("text-variable-anchor-offset"),I=[],A=m.getCircleRadiusCorrection(f);for(const o of r){const r=e.getTile(o),l=r.getBucket(i);if(!l)continue;const h=s?l.text:l.icon;if(!h||!h.segments.get().length||!h.hasVisibleVertices)continue;const u=h.programConfigurations.get(i.id),p=s||l.sdfIcons,T=s?l.textSizeData:l.iconSizeData,C=g||0!==f.pitch,E=t.useProgram(qf(p,s,l),u),z=mh(T,f.zoom),P=t.style.map.terrain&&t.style.map.terrain.getTerrainData(o);let M,k,D,L,R=[0,0],B=null;if(s)k=r.glyphAtlasTexture,D=d.LINEAR,M=r.glyphAtlasTexture.size,l.iconsInText&&(R=r.imageAtlasTexture.size,B=r.imageAtlasTexture,L=C||t.options.rotating||t.options.zooming||"composite"===T.kind||"camera"===T.kind?d.LINEAR:d.NEAREST);else{const e=1!==i.layout.get("icon-size").constantOr(0)||l.iconsNeedLinear;k=r.imageAtlasTexture,D=p||t.options.rotating||t.options.zooming||e||C?d.LINEAR:d.NEAREST,M=r.imageAtlasTexture.size}const F=Ip(r,1,t.transform.zoom),O=v?o.posMatrix:Uf,V=rp(O,g,_,t.transform,F),U=sp(O,g,_,t.transform,F),N=sp(o.posMatrix,g,_,t.transform,F),j=m.translatePosition(t.transform,r,n,a),$=S&&l.hasTextData(),q="none"!==i.layout.get("icon-text-fit")&&$&&l.hasIconData();if(y){const e=t.style.map.terrain?(e,i)=>t.style.map.terrain.getElevation(o,e,i):null,r="map"===i.layout.get("text-rotation-alignment");lp(l,o.posMatrix,t,s,V,N,g,c,r,m,o.toUnwrapped(),f.width,f.height,j,e)}const Z=o.posMatrix,G=s&&S||q,W=y||G?Uf:V,H=U,X=p&&0!==i.paint.get(s?"text-halo-width":"icon-halo-width").constantOr(1);let K;K=p?l.iconsInText?Vd(T.kind,z,x,g,y,G,t,Z,W,H,j,M,R,A):Od(T.kind,z,x,g,y,G,t,Z,W,H,j,s,M,!0,A):Fd(T.kind,z,x,g,y,G,t,Z,W,H,j,s,M,A);const Y={program:E,buffers:h,uniformValues:K,atlasTexture:k,atlasTextureIcon:B,atlasInterpolation:D,atlasInterpolationIcon:L,isSDF:p,hasHalo:X};if(b&&l.canOverlap){w=!0;const t=h.segments.get();for(const e of t)I.push({segments:new ba([e]),sortKey:e.sortKey,state:Y,terrainData:P})}else I.push({segments:h.segments,sortKey:0,state:Y,terrainData:P})}w&&I.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of I){const r=e.state;if(p.activeTexture.set(d.TEXTURE0),r.atlasTexture.bind(r.atlasInterpolation,d.CLAMP_TO_EDGE),r.atlasTextureIcon&&(p.activeTexture.set(d.TEXTURE1),r.atlasTextureIcon&&r.atlasTextureIcon.bind(r.atlasInterpolationIcon,d.CLAMP_TO_EDGE)),r.isSDF){const s=r.uniformValues;r.hasHalo&&(s.u_is_halo=1,Gf(r.buffers,e.segments,i,t,r.program,T,h,u,s,e.terrainData)),s.u_is_halo=0}Gf(r.buffers,e.segments,i,t,r.program,T,h,u,r.uniformValues,e.terrainData)}}function Gf(t,e,i,r,s,n,a,o,l,c){const h=r.context;s.draw(h,h.gl.TRIANGLES,n,a,o,Ff.disabled,l,c,i.id,t.layoutVertexBuffer,t.indexBuffer,e,i.paint,r.transform.zoom,t.programConfigurations.get(i.id),t.dynamicLayoutVertexBuffer,t.opacityVertexBuffer)}function Wf(t,e,i,r){const s=t.context,n=s.gl,a=Bf.disabled,o=new kf([n.ONE,n.ONE],le.transparent,[!0,!0,!0,!0]),l=e.getBucket(i);if(!l)return;const c=r.key;let h=i.heatmapFbos.get(c);h||(h=Xf(s,e.tileSize,e.tileSize),i.heatmapFbos.set(c,h)),s.bindFramebuffer.set(h.framebuffer),s.viewport.set([0,0,e.tileSize,e.tileSize]),s.clear({color:le.transparent});const u=l.programConfigurations.get(i.id),p=t.useProgram("heatmap",u),d=t.style.map.terrain.getTerrainData(r);p.draw(s,n.TRIANGLES,Lf.disabled,a,o,Ff.disabled,Ad(r.posMatrix,e,t.transform.zoom,i.paint.get("heatmap-intensity")),d,i.id,l.layoutVertexBuffer,l.indexBuffer,l.segments,i.paint,t.transform.zoom,u)}function Hf(t,e,i){const r=t.context,s=r.gl;r.setColorMode(t.colorModeForRenderPass());const n=Kf(r,e),a=i.key,o=e.heatmapFbos.get(a);o&&(r.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,o.colorAttachment.get()),r.activeTexture.set(s.TEXTURE1),n.bind(s.LINEAR,s.CLAMP_TO_EDGE),t.useProgram("heatmapTexture").draw(r,s.TRIANGLES,Lf.disabled,Bf.disabled,t.colorModeForRenderPass(),Ff.disabled,Cd(t,e,0,1),null,e.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments,e.paint,t.transform.zoom),o.destroy(),e.heatmapFbos.delete(a))}function Xf(t,e,i){var r,s;const n=t.gl,a=n.createTexture();n.bindTexture(n.TEXTURE_2D,a),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,n.LINEAR),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,n.LINEAR);const o=null!==(r=t.HALF_FLOAT)&&void 0!==r?r:n.UNSIGNED_BYTE,l=null!==(s=t.RGBA16F)&&void 0!==s?s:n.RGBA;n.texImage2D(n.TEXTURE_2D,0,l,e,i,0,n.RGBA,o,null);const c=t.createFramebuffer(e,i,!1,!1);return c.colorAttachment.set(a),c}function Kf(t,e){return e.colorRampTexture||(e.colorRampTexture=new Uh(t,e.colorRamp,t.gl.RGBA)),e.colorRampTexture}function Yf(t,e,i,r,s){if(!i||!r||!r.imageAtlas)return;const n=r.imageAtlas.patternPositions;let a=n[i.to.toString()],o=n[i.from.toString()];if(!a&&o&&(a=o),!o&&a&&(o=a),!a||!o){const t=s.getPaintProperty(e);a=n[t],o=n[t]}a&&o&&t.setConstantPatternPositions(a,o)}function Jf(t,e,i,r,s,n,a){const o=t.context.gl,l="fill-pattern",c=i.paint.get(l),h=c&&c.constantOr(1),u=i.getCrossfadeParameters();let p,d,f,m,_;a?(d=h&&!i.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",p=o.LINES):(d=h?"fillPattern":"fill",p=o.TRIANGLES);const g=c.constantOr(null);for(const c of r){const r=e.getTile(c);if(h&&!r.patternsLoaded())continue;const y=r.getBucket(i);if(!y)continue;const x=y.programConfigurations.get(i.id),v=t.useProgram(d,x),b=t.style.map.terrain&&t.style.map.terrain.getTerrainData(c);h&&(t.context.activeTexture.set(o.TEXTURE0),r.imageAtlasTexture.bind(o.LINEAR,o.CLAMP_TO_EDGE),x.updatePaintBuffers(u)),Yf(x,l,g,r,i);const w=b?c:null,T=t.translatePosMatrix(w?w.posMatrix:c.posMatrix,r,i.paint.get("fill-translate"),i.paint.get("fill-translate-anchor"));if(a){m=y.indexBuffer2,_=y.segments2;const e=[o.drawingBufferWidth,o.drawingBufferHeight];f="fillOutlinePattern"===d&&h?bd(T,t,u,r,e):vd(T,e)}else m=y.indexBuffer,_=y.segments,f=h?xd(T,t,u,r):yd(T);v.draw(t.context,p,s,t.stencilModeForClipping(c),n,Ff.disabled,f,b,i.id,y.layoutVertexBuffer,m,_,i.paint,t.transform.zoom,x)}}function Qf(t,e,i,r,s,n,a){const o=t.context,l=o.gl,c="fill-extrusion-pattern",h=i.paint.get(c),u=h.constantOr(1),p=i.getCrossfadeParameters(),d=i.paint.get("fill-extrusion-opacity"),f=h.constantOr(null);for(const h of r){const r=e.getTile(h),m=r.getBucket(i);if(!m)continue;const _=t.style.map.terrain&&t.style.map.terrain.getTerrainData(h),g=m.programConfigurations.get(i.id),y=t.useProgram(u?"fillExtrusionPattern":"fillExtrusion",g);u&&(t.context.activeTexture.set(l.TEXTURE0),r.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),g.updatePaintBuffers(p)),Yf(g,c,f,r,i);const x=t.translatePosMatrix(h.posMatrix,r,i.paint.get("fill-extrusion-translate"),i.paint.get("fill-extrusion-translate-anchor")),v=i.paint.get("fill-extrusion-vertical-gradient"),b=u?gd(x,t,v,d,h,p,r):_d(x,t,v,d);y.draw(o,o.gl.TRIANGLES,s,n,a,Ff.backCCW,b,_,i.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,i.paint,t.transform.zoom,g,t.style.map.terrain&&m.centroidVertexBuffer)}}function tm(t,e,i,r,s,n,a){const o=t.context,l=o.gl,c=i.fbo;if(!c)return;const h=t.useProgram("hillshade"),u=t.style.map.terrain&&t.style.map.terrain.getTerrainData(e);o.activeTexture.set(l.TEXTURE0),l.bindTexture(l.TEXTURE_2D,c.colorAttachment.get()),h.draw(o,l.TRIANGLES,s,n,a,Ff.disabled,((t,e,i,r)=>{const s=i.paint.get("hillshade-shadow-color"),n=i.paint.get("hillshade-highlight-color"),a=i.paint.get("hillshade-accent-color");let o=i.paint.get("hillshade-illumination-direction")*(Math.PI/180);"viewport"===i.paint.get("hillshade-illumination-anchor")&&(o-=t.transform.angle);const l=!t.options.moving;return{u_matrix:r?r.posMatrix:t.transform.calculatePosMatrix(e.tileID.toUnwrapped(),l),u_image:0,u_latrange:Ed(0,e.tileID),u_light:[i.paint.get("hillshade-exaggeration"),o],u_shadow:s,u_highlight:n,u_accent:a}})(t,i,r,u?e:null),u,r.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments)}function em(t,e,i,r,s,n){const a=t.context,o=a.gl,l=e.dem;if(l&&l.data){const c=l.dim,h=l.stride,u=l.getPixels();if(a.activeTexture.set(o.TEXTURE1),a.pixelStoreUnpackPremultiplyAlpha.set(!1),e.demTexture=e.demTexture||t.getTileTexture(h),e.demTexture){const t=e.demTexture;t.update(u,{premultiply:!1}),t.bind(o.NEAREST,o.CLAMP_TO_EDGE)}else e.demTexture=new Uh(a,u,o.RGBA,{premultiply:!1}),e.demTexture.bind(o.NEAREST,o.CLAMP_TO_EDGE);a.activeTexture.set(o.TEXTURE0);let p=e.fbo;if(!p){const t=new Uh(a,{width:c,height:c,data:null},o.RGBA);t.bind(o.LINEAR,o.CLAMP_TO_EDGE),p=e.fbo=a.createFramebuffer(c,c,!0,!1),p.colorAttachment.set(t.texture)}a.bindFramebuffer.set(p.framebuffer),a.viewport.set([0,0,c,c]),t.useProgram("hillshadePrepare").draw(a,o.TRIANGLES,r,s,n,Ff.disabled,((t,e)=>{const i=e.stride,r=Co();return Fo(r,0,to,-to,0,0,1),ko(r,r,[0,-to,0]),{u_matrix:r,u_image:1,u_dimension:[i,i],u_zoom:t.overscaledZ,u_unpack:e.getUnpackVector()}})(e.tileID,l),null,i.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments),e.needsHillshadePrepare=!1}}function im(t,e,i,r,s,n){const a=r.paint.get("raster-fade-duration");if(!n&&a>0){const r=F.now(),n=(r-t.timeAdded)/a,o=e?(r-e.timeAdded)/a:-1,l=i.getSource(),c=s.coveringZoomLevel({tileSize:l.tileSize,roundZoom:l.roundZoom}),h=!e||Math.abs(e.tileID.overscaledZ-c)>Math.abs(t.tileID.overscaledZ-c),u=h&&t.refreshedUponExpiration?1:_(h?n:1-o,0,1);return t.refreshedUponExpiration&&n>=1&&(t.refreshedUponExpiration=!1),e?{opacity:1,mix:1-u}:{opacity:u,mix:0}}return{opacity:1,mix:0}}const rm=new le(1,0,0,1),sm=new le(0,1,0,1),nm=new le(0,0,1,1),am=new le(1,0,1,1),om=new le(0,1,1,1);function lm(t,e,i,r){hm(t,0,e+i/2,t.transform.width,i,r)}function cm(t,e,i,r){hm(t,e-i/2,0,i,t.transform.height,r)}function hm(t,e,i,r,s,n){const a=t.context,o=a.gl;o.enable(o.SCISSOR_TEST),o.scissor(e*t.pixelRatio,i*t.pixelRatio,r*t.pixelRatio,s*t.pixelRatio),a.clear({color:n}),o.disable(o.SCISSOR_TEST)}function um(t,e,i){const r=t.context,s=r.gl,n=i.posMatrix,a=t.useProgram("debug"),o=Lf.disabled,l=Bf.disabled,c=t.colorModeForRenderPass(),h="$debug",u=t.style.map.terrain&&t.style.map.terrain.getTerrainData(i);r.activeTexture.set(s.TEXTURE0);const p=e.getTileByID(i.key).latestRawTileData,d=Math.floor((p&&p.byteLength||0)/1024),f=e.getTile(i).tileSize,m=512/Math.min(f,512)*(i.overscaledZ/t.transform.zoom)*.5;let _=i.canonical.toString();i.overscaledZ!==i.canonical.z&&(_+=` => ${i.overscaledZ}`),function(t,e){t.initDebugOverlayCanvas();const i=t.debugOverlayCanvas,r=t.context.gl,s=t.debugOverlayCanvas.getContext("2d");s.clearRect(0,0,i.width,i.height),s.shadowColor="white",s.shadowBlur=2,s.lineWidth=1.5,s.strokeStyle="white",s.textBaseline="top",s.font="bold 36px Open Sans, sans-serif",s.fillText(e,5,5),s.strokeText(e,5,5),t.debugOverlayTexture.update(i),t.debugOverlayTexture.bind(r.LINEAR,r.CLAMP_TO_EDGE)}(t,`${_} ${d}kB`),a.draw(r,s.TRIANGLES,o,l,kf.alphaBlended,Ff.disabled,Sd(n,le.transparent,m),null,h,t.debugBuffer,t.quadTriangleIndexBuffer,t.debugSegments),a.draw(r,s.LINE_STRIP,o,l,c,Ff.disabled,Sd(n,le.red),u,h,t.debugBuffer,t.tileBorderIndexBuffer,t.debugSegments)}function pm(t,e,i){const r=t.context,s=r.gl,n=t.colorModeForRenderPass(),a=new Lf(s.LEQUAL,Lf.ReadWrite,t.depthRangeFor3D),o=t.useProgram("terrain"),l=e.getTerrainMesh();r.bindFramebuffer.set(null),r.viewport.set([0,0,t.width,t.height]);for(const c of i){const i=t.renderToTexture.getTexture(c),h=e.getTerrainData(c.tileID);r.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,i.texture);const u=t.transform.calculatePosMatrix(c.tileID.toUnwrapped()),p=e.getMeshFrameDelta(t.transform.zoom),d=t.transform.calculateFogMatrix(c.tileID.toUnwrapped()),f=pd(u,p,d,t.style.sky,t.transform.pitch);o.draw(r,s.TRIANGLES,a,Bf.disabled,n,Ff.backCCW,f,h,"terrain",l.vertexBuffer,l.indexBuffer,l.segments)}}class dm{constructor(t,e,i){this.vertexBuffer=t,this.indexBuffer=e,this.segments=i}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.vertexBuffer=null,this.indexBuffer=null,this.segments=null}}class fm{constructor(t,e){this.context=new Df(t),this.transform=e,this._tileTextures={},this.terrainFacilitator={dirty:!0,matrix:zo(new Float64Array(16)),renderTime:0},this.setup(),this.numSublayers=Yu.maxUnderzooming+Yu.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new sd}resize(t,e,i){if(this.width=Math.floor(t*i),this.height=Math.floor(e*i),this.pixelRatio=i,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const t of this.style._order)this.style._layers[t].resize()}setup(){const t=this.context,e=new ta;e.emplaceBack(0,0),e.emplaceBack(to,0),e.emplaceBack(0,to),e.emplaceBack(to,to),this.tileExtentBuffer=t.createVertexBuffer(e,ld.members),this.tileExtentSegments=ba.simpleSegment(0,0,4,2);const i=new ta;i.emplaceBack(0,0),i.emplaceBack(to,0),i.emplaceBack(0,to),i.emplaceBack(to,to),this.debugBuffer=t.createVertexBuffer(i,ld.members),this.debugSegments=ba.simpleSegment(0,0,4,5);const r=new ia;r.emplaceBack(0,0,0,0),r.emplaceBack(to,0,to,0),r.emplaceBack(0,to,0,to),r.emplaceBack(to,to,to,to),this.rasterBoundsBuffer=t.createVertexBuffer(r,Du.members),this.rasterBoundsSegments=ba.simpleSegment(0,0,4,2);const s=new ta;s.emplaceBack(0,0),s.emplaceBack(1,0),s.emplaceBack(0,1),s.emplaceBack(1,1),this.viewportBuffer=t.createVertexBuffer(s,ld.members),this.viewportSegments=ba.simpleSegment(0,0,4,2);const n=new ya;n.emplaceBack(0),n.emplaceBack(1),n.emplaceBack(3),n.emplaceBack(2),n.emplaceBack(0),this.tileBorderIndexBuffer=t.createIndexBuffer(n);const a=new _a;a.emplaceBack(0,1,2),a.emplaceBack(2,1,3),this.quadTriangleIndexBuffer=t.createIndexBuffer(a);const o=this.context.gl;this.stencilClearMode=new Bf({func:o.ALWAYS,mask:0},0,255,o.ZERO,o.ZERO,o.ZERO)}clearStencil(){const t=this.context,e=t.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const i=Co();Fo(i,0,this.width,this.height,0,0,1),Do(i,i,[e.drawingBufferWidth,e.drawingBufferHeight,0]),this.useProgram("clippingMask").draw(t,e.TRIANGLES,Lf.disabled,this.stencilClearMode,kf.disabled,Ff.disabled,Id(i),null,"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments)}_renderTileClippingMasks(t,e){if(this.currentStencilSource===t.source||!t.isTileClipped()||!e||!e.length)return;this.currentStencilSource=t.source;const i=this.context,r=i.gl;this.nextStencilID+e.length>256&&this.clearStencil(),i.setColorMode(kf.disabled),i.setDepthMode(Lf.disabled);const s=this.useProgram("clippingMask");this._tileClippingMaskIDs={};for(const t of e){const e=this._tileClippingMaskIDs[t.key]=this.nextStencilID++,n=this.style.map.terrain&&this.style.map.terrain.getTerrainData(t);s.draw(i,r.TRIANGLES,Lf.disabled,new Bf({func:r.ALWAYS,mask:0},e,255,r.KEEP,r.KEEP,r.REPLACE),kf.disabled,Ff.disabled,Id(t.posMatrix),n,"$clipping",this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments)}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const t=this.nextStencilID++,e=this.context.gl;return new Bf({func:e.NOTEQUAL,mask:255},t,255,e.KEEP,e.KEEP,e.REPLACE)}stencilModeForClipping(t){const e=this.context.gl;return new Bf({func:e.EQUAL,mask:255},this._tileClippingMaskIDs[t.key],0,e.KEEP,e.KEEP,e.REPLACE)}stencilConfigForOverlap(t){const e=this.context.gl,i=t.sort(((t,e)=>e.overscaledZ-t.overscaledZ)),r=i[i.length-1].overscaledZ,s=i[0].overscaledZ-r+1;if(s>1){this.currentStencilSource=void 0,this.nextStencilID+s>256&&this.clearStencil();const t={};for(let i=0;i<s;i++)t[i+r]=new Bf({func:e.GEQUAL,mask:255},i+this.nextStencilID,255,e.KEEP,e.KEEP,e.REPLACE);return this.nextStencilID+=s,[t,i]}return[{[r]:Bf.disabled},i]}colorModeForRenderPass(){const t=this.context.gl;if(this._showOverdrawInspector){const e=1/8;return new kf([t.CONSTANT_COLOR,t.ONE],new le(e,e,e,0),[!0,!0,!0,!0])}return"opaque"===this.renderPass?kf.unblended:kf.alphaBlended}depthModeForSublayer(t,e,i){if(!this.opaquePassEnabledForLayer())return Lf.disabled;const r=1-((1+this.currentLayer)*this.numSublayers+t)*this.depthEpsilon;return new Lf(i||this.context.gl.LEQUAL,e,[r,r])}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(t,e){this.style=t,this.options=e,this.lineAtlas=t.lineAtlas,this.imageManager=t.imageManager,this.glyphManager=t.glyphManager,this.symbolFadeChange=t.placement.symbolFadeChange(F.now()),this.imageManager.beginFrame();const i=this.style._order,r=this.style.sourceCaches,s={},n={},a={};for(const t in r){const e=r[t];e.used&&e.prepare(this.context),s[t]=e.getVisibleCoordinates(),n[t]=s[t].slice().reverse(),a[t]=e.getVisibleCoordinates(!0).reverse()}this.opaquePassCutoff=1/0;for(let t=0;t<i.length;t++)if(this.style._layers[i[t]].is3D()){this.opaquePassCutoff=t;break}this.maybeDrawDepthAndCoords(!1),this.renderToTexture&&(this.renderToTexture.prepareForRender(this.style,this.transform.zoom),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const t of i){const e=this.style._layers[t];if(!e.hasOffscreenPass()||e.isHidden(this.transform.zoom))continue;const i=n[e.source];("custom"===e.type||i.length)&&this.renderLayer(this,r[e.source],e,i)}if(this.context.bindFramebuffer.set(null),this.context.clear({color:e.showOverdrawInspector?le.black:le.transparent,depth:1}),this.clearStencil(),this.style.sky&&function(t,e){const i=t.context,r=i.gl,s=((t,e,i)=>({u_sky_color:t.properties.get("sky-color"),u_horizon_color:t.properties.get("horizon-color"),u_horizon:(e.height/2+e.getHorizon())*i,u_sky_horizon_blend:t.properties.get("sky-horizon-blend")*e.height/2*i}))(e,t.style.map.transform,t.pixelRatio),n=new Lf(r.LEQUAL,Lf.ReadWrite,[0,1]),a=Bf.disabled,o=t.colorModeForRenderPass(),l=t.useProgram("sky");if(!e.mesh){const t=new ta;t.emplaceBack(-1,-1),t.emplaceBack(1,-1),t.emplaceBack(1,1),t.emplaceBack(-1,1);const r=new _a;r.emplaceBack(0,1,2),r.emplaceBack(0,2,3),e.mesh=new dm(i.createVertexBuffer(t,ld.members),i.createIndexBuffer(r),ba.simpleSegment(0,0,t.length,r.length))}l.draw(i,r.TRIANGLES,n,a,o,Ff.disabled,s,void 0,"sky",e.mesh.vertexBuffer,e.mesh.indexBuffer,e.mesh.segments)}(this,this.style.sky),this._showOverdrawInspector=e.showOverdrawInspector,this.depthRangeFor3D=[0,1-(t._order.length+2)*this.numSublayers*this.depthEpsilon],!this.renderToTexture)for(this.renderPass="opaque",this.currentLayer=i.length-1;this.currentLayer>=0;this.currentLayer--){const t=this.style._layers[i[this.currentLayer]],e=r[t.source],n=s[t.source];this._renderTileClippingMasks(t,n),this.renderLayer(this,e,t,n)}for(this.renderPass="translucent",this.currentLayer=0;this.currentLayer<i.length;this.currentLayer++){const t=this.style._layers[i[this.currentLayer]],e=r[t.source];if(this.renderToTexture&&this.renderToTexture.renderLayer(t))continue;const o=("symbol"===t.type?a:n)[t.source];this._renderTileClippingMasks(t,s[t.source]),this.renderLayer(this,e,t,o)}if(this.options.showTileBoundaries){const t=function(t,e){let i=null;const r=Object.values(t._layers).flatMap((i=>i.source&&!i.isHidden(e)?[t.sourceCaches[i.source]]:[])),s=r.filter((t=>"vector"===t.getSource().type)),n=r.filter((t=>"vector"!==t.getSource().type)),a=t=>{(!i||i.getSource().maxzoom<t.getSource().maxzoom)&&(i=t)};return s.forEach((t=>a(t))),i||n.forEach((t=>a(t))),i}(this.style,this.transform.zoom);t&&function(t,e,i){for(let r=0;r<i.length;r++)um(t,e,i[r])}(this,t,t.getVisibleCoordinates())}this.options.showPadding&&function(t){const e=t.transform.padding;lm(t,t.transform.height-(e.top||0),3,rm),lm(t,e.bottom||0,3,sm),cm(t,e.left||0,3,nm),cm(t,t.transform.width-(e.right||0),3,am);const i=t.transform.centerPoint;!function(t,e,i,r){hm(t,e-1,i-10,2,20,r),hm(t,e-10,i-1,20,2,r)}(t,i.x,t.transform.height-i.y,om)}(this),this.context.setDefault()}maybeDrawDepthAndCoords(t){if(!this.style||!this.style.map||!this.style.map.terrain)return;const e=this.terrainFacilitator.matrix,i=this.transform.modelViewProjectionMatrix;let r=this.terrainFacilitator.dirty;var s,n;r||(r=t?!((s=e)[0]===(n=i)[0]&&s[1]===n[1]&&s[2]===n[2]&&s[3]===n[3]&&s[4]===n[4]&&s[5]===n[5]&&s[6]===n[6]&&s[7]===n[7]&&s[8]===n[8]&&s[9]===n[9]&&s[10]===n[10]&&s[11]===n[11]&&s[12]===n[12]&&s[13]===n[13]&&s[14]===n[14]&&s[15]===n[15]):!function(t,e){var i=t[0],r=t[1],s=t[2],n=t[3],a=t[4],o=t[5],l=t[6],c=t[7],h=t[8],u=t[9],p=t[10],d=t[11],f=t[12],m=t[13],_=t[14],g=t[15],y=e[0],x=e[1],v=e[2],b=e[3],w=e[4],T=e[5],S=e[6],I=e[7],A=e[8],C=e[9],E=e[10],z=e[11],P=e[12],M=e[13],k=e[14],D=e[15];return Math.abs(i-y)<=Io*Math.max(1,Math.abs(i),Math.abs(y))&&Math.abs(r-x)<=Io*Math.max(1,Math.abs(r),Math.abs(x))&&Math.abs(s-v)<=Io*Math.max(1,Math.abs(s),Math.abs(v))&&Math.abs(n-b)<=Io*Math.max(1,Math.abs(n),Math.abs(b))&&Math.abs(a-w)<=Io*Math.max(1,Math.abs(a),Math.abs(w))&&Math.abs(o-T)<=Io*Math.max(1,Math.abs(o),Math.abs(T))&&Math.abs(l-S)<=Io*Math.max(1,Math.abs(l),Math.abs(S))&&Math.abs(c-I)<=Io*Math.max(1,Math.abs(c),Math.abs(I))&&Math.abs(h-A)<=Io*Math.max(1,Math.abs(h),Math.abs(A))&&Math.abs(u-C)<=Io*Math.max(1,Math.abs(u),Math.abs(C))&&Math.abs(p-E)<=Io*Math.max(1,Math.abs(p),Math.abs(E))&&Math.abs(d-z)<=Io*Math.max(1,Math.abs(d),Math.abs(z))&&Math.abs(f-P)<=Io*Math.max(1,Math.abs(f),Math.abs(P))&&Math.abs(m-M)<=Io*Math.max(1,Math.abs(m),Math.abs(M))&&Math.abs(_-k)<=Io*Math.max(1,Math.abs(_),Math.abs(k))&&Math.abs(g-D)<=Io*Math.max(1,Math.abs(g),Math.abs(D))}(e,i)),r||(r=this.style.map.terrain.sourceCache.tilesAfterTime(this.terrainFacilitator.renderTime).length>0),r&&(function(t,e){t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]}(e,i),this.terrainFacilitator.renderTime=Date.now(),this.terrainFacilitator.dirty=!1,function(t,e){const i=t.context,r=i.gl,s=kf.unblended,n=new Lf(r.LEQUAL,Lf.ReadWrite,[0,1]),a=e.getTerrainMesh(),o=e.sourceCache.getRenderableTiles(),l=t.useProgram("terrainDepth");i.bindFramebuffer.set(e.getFramebuffer("depth").framebuffer),i.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),i.clear({color:le.transparent,depth:1});for(const c of o){const o=e.getTerrainData(c.tileID),h={u_matrix:t.transform.calculatePosMatrix(c.tileID.toUnwrapped()),u_ele_delta:e.getMeshFrameDelta(t.transform.zoom)};l.draw(i,r.TRIANGLES,n,Bf.disabled,s,Ff.backCCW,h,o,"terrain",a.vertexBuffer,a.indexBuffer,a.segments)}i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height])}(this,this.style.map.terrain),function(t,e){const i=t.context,r=i.gl,s=kf.unblended,n=new Lf(r.LEQUAL,Lf.ReadWrite,[0,1]),a=e.getTerrainMesh(),o=e.getCoordsTexture(),l=e.sourceCache.getRenderableTiles(),c=t.useProgram("terrainCoords");i.bindFramebuffer.set(e.getFramebuffer("coords").framebuffer),i.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),i.clear({color:le.transparent,depth:1}),e.coordsIndex=[];for(const h of l){const l=e.getTerrainData(h.tileID);i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,o.texture);const u={u_matrix:t.transform.calculatePosMatrix(h.tileID.toUnwrapped()),u_terrain_coords_id:(255-e.coordsIndex.length)/255,u_texture:0,u_ele_delta:e.getMeshFrameDelta(t.transform.zoom)};c.draw(i,r.TRIANGLES,n,Bf.disabled,s,Ff.backCCW,u,l,"terrain",a.vertexBuffer,a.indexBuffer,a.segments),e.coordsIndex.push(h.tileID.key)}i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height])}(this,this.style.map.terrain))}renderLayer(t,e,i,r){if(!i.isHidden(this.transform.zoom)&&("background"===i.type||"custom"===i.type||(r||[]).length))switch(this.id=i.id,i.type){case"symbol":!function(t,e,i,r,s){if("translucent"!==t.renderPass)return;const n=Bf.disabled,a=t.colorModeForRenderPass();(i._unevaluatedLayout.hasValue("text-variable-anchor")||i._unevaluatedLayout.hasValue("text-variable-anchor-offset"))&&function(t,e,i,r,s,n,a,o,l){const c=e.transform,h=qp(),u="map"===s,p="map"===n;for(const s of t){const t=r.getTile(s),n=t.getBucket(i);if(!n||!n.text||!n.text.segments.get().length)continue;const d=mh(n.textSizeData,c.zoom),f=Ip(t,1,e.transform.zoom),m=rp(s.posMatrix,p,u,e.transform,f),_="none"!==i.layout.get("icon-text-fit")&&n.hasIconData();if(d){const i=Math.pow(2,c.zoom-t.tileID.overscaledZ),r=e.style.map.terrain?(t,i)=>e.style.map.terrain.getElevation(s,t,i):null,f=h.translatePosition(c,t,a,o);$f(n,u,p,l,c,m,s.posMatrix,i,d,_,h,f,s.toUnwrapped(),r)}}}(r,t,i,e,i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),s),0!==i.paint.get("icon-opacity").constantOr(1)&&Zf(t,e,i,r,!1,i.paint.get("icon-translate"),i.paint.get("icon-translate-anchor"),i.layout.get("icon-rotation-alignment"),i.layout.get("icon-pitch-alignment"),i.layout.get("icon-keep-upright"),n,a),0!==i.paint.get("text-opacity").constantOr(1)&&Zf(t,e,i,r,!0,i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.layout.get("text-keep-upright"),n,a),e.map.showCollisionBoxes&&(Vf(t,e,i,r,!0),Vf(t,e,i,r,!1))}(t,e,i,r,this.style.placement.variableOffsets);break;case"circle":!function(t,e,i,r){if("translucent"!==t.renderPass)return;const s=i.paint.get("circle-opacity"),n=i.paint.get("circle-stroke-width"),a=i.paint.get("circle-stroke-opacity"),o=!i.layout.get("circle-sort-key").isConstant();if(0===s.constantOr(1)&&(0===n.constantOr(1)||0===a.constantOr(1)))return;const l=t.context,c=l.gl,h=t.depthModeForSublayer(0,Lf.ReadOnly),u=Bf.disabled,p=t.colorModeForRenderPass(),d=[];for(let s=0;s<r.length;s++){const n=r[s],a=e.getTile(n),l=a.getBucket(i);if(!l)continue;const c=l.programConfigurations.get(i.id),h=t.useProgram("circle",c),u=l.layoutVertexBuffer,p=l.indexBuffer,f=t.style.map.terrain&&t.style.map.terrain.getTerrainData(n),m={programConfiguration:c,program:h,layoutVertexBuffer:u,indexBuffer:p,uniformValues:wd(t,n,a,i),terrainData:f};if(o){const t=l.segments.get();for(const e of t)d.push({segments:new ba([e]),sortKey:e.sortKey,state:m})}else d.push({segments:l.segments,sortKey:0,state:m})}o&&d.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of d){const{programConfiguration:r,program:s,layoutVertexBuffer:n,indexBuffer:a,uniformValues:o,terrainData:d}=e.state;s.draw(l,c.TRIANGLES,h,u,p,Ff.disabled,o,d,i.id,n,a,e.segments,i.paint,t.transform.zoom,r)}}(t,e,i,r);break;case"heatmap":!function(t,e,i,r){if(0===i.paint.get("heatmap-opacity"))return;const s=t.context;if(t.style.map.terrain){for(const s of r){const r=e.getTile(s);e.hasRenderableParent(s)||("offscreen"===t.renderPass?Wf(t,r,i,s):"translucent"===t.renderPass&&Hf(t,i,s))}s.viewport.set([0,0,t.width,t.height])}else"offscreen"===t.renderPass?function(t,e,i,r){const s=t.context,n=s.gl,a=Bf.disabled,o=new kf([n.ONE,n.ONE],le.transparent,[!0,!0,!0,!0]);(function(t,e,i){const r=t.gl;t.activeTexture.set(r.TEXTURE1),t.viewport.set([0,0,e.width/4,e.height/4]);let s=i.heatmapFbos.get(el);s?(r.bindTexture(r.TEXTURE_2D,s.colorAttachment.get()),t.bindFramebuffer.set(s.framebuffer)):(s=Xf(t,e.width/4,e.height/4),i.heatmapFbos.set(el,s))})(s,t,i),s.clear({color:le.transparent});for(let l=0;l<r.length;l++){const c=r[l];if(e.hasRenderableParent(c))continue;const h=e.getTile(c),u=h.getBucket(i);if(!u)continue;const p=u.programConfigurations.get(i.id),d=t.useProgram("heatmap",p),{zoom:f}=t.transform;d.draw(s,n.TRIANGLES,Lf.disabled,a,o,Ff.disabled,Ad(c.posMatrix,h,f,i.paint.get("heatmap-intensity")),null,i.id,u.layoutVertexBuffer,u.indexBuffer,u.segments,i.paint,t.transform.zoom,p)}s.viewport.set([0,0,t.width,t.height])}(t,e,i,r):"translucent"===t.renderPass&&function(t,e){const i=t.context,r=i.gl;i.setColorMode(t.colorModeForRenderPass());const s=e.heatmapFbos.get(el);s&&(i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,s.colorAttachment.get()),i.activeTexture.set(r.TEXTURE1),Kf(i,e).bind(r.LINEAR,r.CLAMP_TO_EDGE),t.useProgram("heatmapTexture").draw(i,r.TRIANGLES,Lf.disabled,Bf.disabled,t.colorModeForRenderPass(),Ff.disabled,Cd(t,e,0,1),null,e.id,t.viewportBuffer,t.quadTriangleIndexBuffer,t.viewportSegments,e.paint,t.transform.zoom))}(t,i)}(t,e,i,r);break;case"line":!function(t,e,i,r){if("translucent"!==t.renderPass)return;const s=i.paint.get("line-opacity"),n=i.paint.get("line-width");if(0===s.constantOr(1)||0===n.constantOr(1))return;const a=t.depthModeForSublayer(0,Lf.ReadOnly),o=t.colorModeForRenderPass(),l=i.paint.get("line-dasharray"),c=i.paint.get("line-pattern"),h=c.constantOr(1),u=i.paint.get("line-gradient"),p=i.getCrossfadeParameters(),d=h?"linePattern":l?"lineSDF":u?"lineGradient":"line",f=t.context,m=f.gl;let g=!0;for(const s of r){const r=e.getTile(s);if(h&&!r.patternsLoaded())continue;const n=r.getBucket(i);if(!n)continue;const x=n.programConfigurations.get(i.id),v=t.context.program.get(),b=t.useProgram(d,x),w=g||b.program!==v,T=t.style.map.terrain&&t.style.map.terrain.getTerrainData(s),S=c.constantOr(null);if(S&&r.imageAtlas){const t=r.imageAtlas,e=t.patternPositions[S.to.toString()],i=t.patternPositions[S.from.toString()];e&&i&&x.setConstantPatternPositions(e,i)}const I=T?s:null,A=h?Md(t,r,i,p,I):l?kd(t,r,i,l,p,I):u?Pd(t,r,i,n.lineClipsArray.length,I):zd(t,r,i,I);if(h)f.activeTexture.set(m.TEXTURE0),r.imageAtlasTexture.bind(m.LINEAR,m.CLAMP_TO_EDGE),x.updatePaintBuffers(p);else if(l&&(w||t.lineAtlas.dirty))f.activeTexture.set(m.TEXTURE0),t.lineAtlas.bind(f);else if(u){const r=n.gradients[i.id];let a=r.texture;if(i.gradientVersion!==r.version){let o=256;if(i.stepInterpolant){const i=e.getSource().maxzoom,r=s.canonical.z===i?Math.ceil(1<<t.transform.maxZoom-s.canonical.z):1;o=_((y=n.maxLineLength/to*1024*r)<=1?1:Math.pow(2,Math.ceil(Math.log(y)/Math.LN2)),256,f.maxTextureSize)}r.gradient=tl({expression:i.gradientExpression(),evaluationKey:"lineProgress",resolution:o,image:r.gradient||void 0,clips:n.lineClipsArray}),r.texture?r.texture.update(r.gradient):r.texture=new Uh(f,r.gradient,m.RGBA),r.version=i.gradientVersion,a=r.texture}f.activeTexture.set(m.TEXTURE0),a.bind(i.stepInterpolant?m.NEAREST:m.LINEAR,m.CLAMP_TO_EDGE)}b.draw(f,m.TRIANGLES,a,t.stencilModeForClipping(s),o,Ff.disabled,A,T,i.id,n.layoutVertexBuffer,n.indexBuffer,n.segments,i.paint,t.transform.zoom,x,n.layoutVertexBuffer2),g=!1}var y}(t,e,i,r);break;case"fill":!function(t,e,i,r){const s=i.paint.get("fill-color"),n=i.paint.get("fill-opacity");if(0===n.constantOr(1))return;const a=t.colorModeForRenderPass(),o=i.paint.get("fill-pattern"),l=t.opaquePassEnabledForLayer()&&!o.constantOr(1)&&1===s.constantOr(le.transparent).a&&1===n.constantOr(0)?"opaque":"translucent";if(t.renderPass===l){const s=t.depthModeForSublayer(1,"opaque"===t.renderPass?Lf.ReadWrite:Lf.ReadOnly);Jf(t,e,i,r,s,a,!1)}if("translucent"===t.renderPass&&i.paint.get("fill-antialias")){const s=t.depthModeForSublayer(i.getPaintProperty("fill-outline-color")?2:0,Lf.ReadOnly);Jf(t,e,i,r,s,a,!0)}}(t,e,i,r);break;case"fill-extrusion":!function(t,e,i,r){const s=i.paint.get("fill-extrusion-opacity");if(0!==s&&"translucent"===t.renderPass){const n=new Lf(t.context.gl.LEQUAL,Lf.ReadWrite,t.depthRangeFor3D);if(1!==s||i.paint.get("fill-extrusion-pattern").constantOr(1))Qf(t,e,i,r,n,Bf.disabled,kf.disabled),Qf(t,e,i,r,n,t.stencilModeFor3D(),t.colorModeForRenderPass());else{const s=t.colorModeForRenderPass();Qf(t,e,i,r,n,Bf.disabled,s)}}}(t,e,i,r);break;case"hillshade":!function(t,e,i,r){if("offscreen"!==t.renderPass&&"translucent"!==t.renderPass)return;const s=t.context,n=t.depthModeForSublayer(0,Lf.ReadOnly),a=t.colorModeForRenderPass(),[o,l]="translucent"===t.renderPass?t.stencilConfigForOverlap(r):[{},r];for(const r of l){const s=e.getTile(r);void 0!==s.needsHillshadePrepare&&s.needsHillshadePrepare&&"offscreen"===t.renderPass?em(t,s,i,n,Bf.disabled,a):"translucent"===t.renderPass&&tm(t,r,s,i,n,o[r.overscaledZ],a)}s.viewport.set([0,0,t.width,t.height])}(t,e,i,r);break;case"raster":!function(t,e,i,r){if("translucent"!==t.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!r.length)return;const s=t.context,n=s.gl,a=e.getSource(),o=t.useProgram("raster"),l=t.colorModeForRenderPass(),[c,h]=a instanceof Lu?[{},r]:t.stencilConfigForOverlap(r),u=h[h.length-1].overscaledZ,p=!t.options.moving;for(const r of h){const h=t.depthModeForSublayer(r.overscaledZ-u,1===i.paint.get("raster-opacity")?Lf.ReadWrite:Lf.ReadOnly,n.LESS),d=e.getTile(r);d.registerFadeDuration(i.paint.get("raster-fade-duration"));const f=e.findLoadedParent(r,0),m=e.findLoadedSibling(r),_=im(d,f||m||null,e,i,t.transform,t.style.map.terrain);let g,y;const x="nearest"===i.paint.get("raster-resampling")?n.NEAREST:n.LINEAR;s.activeTexture.set(n.TEXTURE0),d.texture.bind(x,n.CLAMP_TO_EDGE,n.LINEAR_MIPMAP_NEAREST),s.activeTexture.set(n.TEXTURE1),f?(f.texture.bind(x,n.CLAMP_TO_EDGE,n.LINEAR_MIPMAP_NEAREST),g=Math.pow(2,f.tileID.overscaledZ-d.tileID.overscaledZ),y=[d.tileID.canonical.x*g%1,d.tileID.canonical.y*g%1]):d.texture.bind(x,n.CLAMP_TO_EDGE,n.LINEAR_MIPMAP_NEAREST),d.texture.useMipmap&&s.extTextureFilterAnisotropic&&t.transform.pitch>20&&n.texParameterf(n.TEXTURE_2D,s.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,s.extTextureFilterAnisotropicMax);const v=t.style.map.terrain&&t.style.map.terrain.getTerrainData(r),b=v?r:null,w=b?b.posMatrix:t.transform.calculatePosMatrix(r.toUnwrapped(),p),T=Rd(w,y||[0,0],g||1,_,i);a instanceof Lu?o.draw(s,n.TRIANGLES,h,Bf.disabled,l,Ff.disabled,T,v,i.id,a.boundsBuffer,t.quadTriangleIndexBuffer,a.boundsSegments):o.draw(s,n.TRIANGLES,h,c[r.overscaledZ],l,Ff.disabled,T,v,i.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments)}}(t,e,i,r);break;case"background":!function(t,e,i,r){const s=i.paint.get("background-color"),n=i.paint.get("background-opacity");if(0===n)return;const a=t.context,o=a.gl,l=t.transform,c=l.tileSize,h=i.paint.get("background-pattern");if(t.isPatternMissing(h))return;const u=!h&&1===s.a&&1===n&&t.opaquePassEnabledForLayer()?"opaque":"translucent";if(t.renderPass!==u)return;const p=Bf.disabled,d=t.depthModeForSublayer(0,"opaque"===u?Lf.ReadWrite:Lf.ReadOnly),f=t.colorModeForRenderPass(),m=t.useProgram(h?"backgroundPattern":"background"),_=r||l.coveringTiles({tileSize:c,terrain:t.style.map.terrain});h&&(a.activeTexture.set(o.TEXTURE0),t.imageManager.bind(t.context));const g=i.getCrossfadeParameters();for(const e of _){const l=r?e.posMatrix:t.transform.calculatePosMatrix(e.toUnwrapped()),u=h?Nd(l,n,t,h,{tileID:e,tileSize:c},g):Ud(l,n,s),_=t.style.map.terrain&&t.style.map.terrain.getTerrainData(e);m.draw(a,o.TRIANGLES,d,p,f,Ff.disabled,u,_,i.id,t.tileExtentBuffer,t.quadTriangleIndexBuffer,t.tileExtentSegments)}}(t,0,i,r);break;case"custom":!function(t,e,i){const r=t.context,s=i.implementation;if("offscreen"===t.renderPass){const e=s.prerender;e&&(t.setCustomLayerDefaults(),r.setColorMode(t.colorModeForRenderPass()),e.call(s,r.gl,t.transform.customLayerMatrix()),r.setDirty(),t.setBaseState())}else if("translucent"===t.renderPass){t.setCustomLayerDefaults(),r.setColorMode(t.colorModeForRenderPass()),r.setStencilMode(Bf.disabled);const e="3d"===s.renderingMode?new Lf(t.context.gl.LEQUAL,Lf.ReadWrite,t.depthRangeFor3D):t.depthModeForSublayer(0,Lf.ReadOnly);r.setDepthMode(e),s.render(r.gl,t.transform.customLayerMatrix(),{farZ:t.transform.farZ,nearZ:t.transform.nearZ,fov:t.transform._fov,modelViewProjectionMatrix:t.transform.modelViewProjectionMatrix,projectionMatrix:t.transform.projectionMatrix}),r.setDirty(),t.setBaseState(),r.bindFramebuffer.set(null)}}(t,0,i)}}translatePosMatrix(t,e,i,r,s){if(!i[0]&&!i[1])return t;const n=s?"map"===r?this.transform.angle:0:"viewport"===r?-this.transform.angle:0;if(n){const t=Math.sin(n),e=Math.cos(n);i=[i[0]*e-i[1]*t,i[0]*t+i[1]*e]}const a=[s?i[0]:Ip(e,i[0],this.transform.zoom),s?i[1]:Ip(e,i[1],this.transform.zoom),0],o=new Float32Array(16);return ko(o,t,a),o}saveTileTexture(t){const e=this._tileTextures[t.size[0]];e?e.push(t):this._tileTextures[t.size[0]]=[t]}getTileTexture(t){const e=this._tileTextures[t];return e&&e.length>0?e.pop():null}isPatternMissing(t){if(!t)return!1;if(!t.from||!t.to)return!0;const e=this.imageManager.getPattern(t.from.toString()),i=this.imageManager.getPattern(t.to.toString());return!e||!i}useProgram(t,e){this.cache=this.cache||{};const i=t+(e?e.cacheKey:"")+(this._showOverdrawInspector?"/overdraw":"")+(this.style.map.terrain?"/terrain":"");return this.cache[i]||(this.cache[i]=new fd(this.context,cd[t],e,jd[t],this._showOverdrawInspector,this.style.map.terrain)),this.cache[i]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault()}setBaseState(){const t=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(t.FUNC_ADD)}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new Uh(this.context,this.debugOverlayCanvas,this.context.gl.RGBA))}destroy(){this.debugOverlayTexture&&this.debugOverlayTexture.destroy()}overLimit(){const{drawingBufferWidth:t,drawingBufferHeight:e}=this.context.gl;return this.width!==t||this.height!==e}}class mm{constructor(t,e){this.points=t,this.planes=e}static fromInvProjectionMatrix(t,e,i){const r=Math.pow(2,i),s=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((i=>{const s=1/(i=jo([],i,t))[3]/e*r;return function(t,e,i){return t[0]=e[0]*i[0],t[1]=e[1]*i[1],t[2]=e[2]*i[2],t[3]=e[3]*i[3],t}(i,i,[s,s,1/i[3],s])})),n=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((t=>{const e=function(t,e){var i=e[0],r=e[1],s=e[2],n=i*i+r*r+s*s;return n>0&&(n=1/Math.sqrt(n)),t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t}([],function(t,e,i){var r=e[0],s=e[1],n=e[2],a=i[0],o=i[1],l=i[2];return t[0]=s*l-n*o,t[1]=n*a-r*l,t[2]=r*o-s*a,t}([],No([],s[t[0]],s[t[1]]),No([],s[t[2]],s[t[1]]))),i=-((r=e)[0]*(n=s[t[1]])[0]+r[1]*n[1]+r[2]*n[2]);var r,n;return e.concat(i)}));return new mm(s,n)}}class _m{constructor(t,e){this.min=t,this.max=e,this.center=function(t,e,i){return t[0]=.5*e[0],t[1]=.5*e[1],t[2]=.5*e[2],t}([],function(t,e,i){return t[0]=e[0]+i[0],t[1]=e[1]+i[1],t[2]=e[2]+i[2],t}([],this.min,this.max))}quadrant(t){const e=[t%2==0,t<2],i=Vo(this.min),r=Vo(this.max);for(let t=0;t<e.length;t++)i[t]=e[t]?this.min[t]:this.center[t],r[t]=e[t]?this.center[t]:this.max[t];return r[2]=this.max[2],new _m(i,r)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}intersects(t){const e=[[this.min[0],this.min[1],this.min[2],1],[this.max[0],this.min[1],this.min[2],1],[this.max[0],this.max[1],this.min[2],1],[this.min[0],this.max[1],this.min[2],1],[this.min[0],this.min[1],this.max[2],1],[this.max[0],this.min[1],this.max[2],1],[this.max[0],this.max[1],this.max[2],1],[this.min[0],this.max[1],this.max[2],1]];let i=!0;for(let n=0;n<t.planes.length;n++){const a=t.planes[n];let o=0;for(let t=0;t<e.length;t++)(r=a)[0]*(s=e[t])[0]+r[1]*s[1]+r[2]*s[2]+r[3]*s[3]>=0&&o++;if(0===o)return 0;o!==e.length&&(i=!1)}var r,s;if(i)return 2;for(let e=0;e<3;e++){let i=Number.MAX_VALUE,r=-Number.MAX_VALUE;for(let s=0;s<t.points.length;s++){const n=t.points[s][e]-this.min[e];i=Math.min(i,n),r=Math.max(r,n)}if(r<0||i>this.max[e]-this.min[e])return 0}return 1}}class gm{constructor(t=0,e=0,i=0,r=0){if(isNaN(t)||t<0||isNaN(e)||e<0||isNaN(i)||i<0||isNaN(r)||r<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=t,this.bottom=e,this.left=i,this.right=r}interpolate(t,e,i){return null!=e.top&&null!=t.top&&(this.top=Ze.number(t.top,e.top,i)),null!=e.bottom&&null!=t.bottom&&(this.bottom=Ze.number(t.bottom,e.bottom,i)),null!=e.left&&null!=t.left&&(this.left=Ze.number(t.left,e.left,i)),null!=e.right&&null!=t.right&&(this.right=Ze.number(t.right,e.right,i)),this}getCenter(t,e){const i=_((this.left+t-this.right)/2,0,t),r=_((this.top+e-this.bottom)/2,0,e);return new a(i,r)}equals(t){return this.top===t.top&&this.bottom===t.bottom&&this.left===t.left&&this.right===t.right}clone(){return new gm(this.top,this.bottom,this.left,this.right)}toJSON(){return{top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}const ym=85.051129;class xm{constructor(t,e,i,r,s){this.tileSize=512,this._renderWorldCopies=void 0===s||!!s,this._minZoom=t||0,this._maxZoom=e||22,this._minPitch=null==i?0:i,this._maxPitch=null==r?60:r,this.setMaxBounds(),this.width=0,this.height=0,this._center=new fu(0,0),this._elevation=0,this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._unmodified=!0,this._edgeInsets=new gm,this._posMatrixCache={},this._alignedPosMatrixCache={},this._fogMatrixCache={},this.minElevationForCurrentTile=0}clone(){const t=new xm(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies);return t.apply(this),t}apply(t){this.tileSize=t.tileSize,this.latRange=t.latRange,this.lngRange=t.lngRange,this.width=t.width,this.height=t.height,this._center=t._center,this._elevation=t._elevation,this.minElevationForCurrentTile=t.minElevationForCurrentTile,this.zoom=t.zoom,this.angle=t.angle,this._fov=t._fov,this._pitch=t._pitch,this._unmodified=t._unmodified,this._edgeInsets=t._edgeInsets.clone(),this._calcMatrices()}get minZoom(){return this._minZoom}set minZoom(t){this._minZoom!==t&&(this._minZoom=t,this.zoom=Math.max(this.zoom,t))}get maxZoom(){return this._maxZoom}set maxZoom(t){this._maxZoom!==t&&(this._maxZoom=t,this.zoom=Math.min(this.zoom,t))}get minPitch(){return this._minPitch}set minPitch(t){this._minPitch!==t&&(this._minPitch=t,this.pitch=Math.max(this.pitch,t))}get maxPitch(){return this._maxPitch}set maxPitch(t){this._maxPitch!==t&&(this._maxPitch=t,this.pitch=Math.min(this.pitch,t))}get renderWorldCopies(){return this._renderWorldCopies}set renderWorldCopies(t){void 0===t?t=!0:null===t&&(t=!1),this._renderWorldCopies=t}get worldSize(){return this.tileSize*this.scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new a(this.width,this.height)}get bearing(){return-this.angle/Math.PI*180}set bearing(t){const e=-g(t,-180,180)*Math.PI/180;this.angle!==e&&(this._unmodified=!1,this.angle=e,this._calcMatrices(),this.rotationMatrix=function(){var t=new Ao(4);return Ao!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t}(),function(t,e,i){var r=e[0],s=e[1],n=e[2],a=e[3],o=Math.sin(i),l=Math.cos(i);t[0]=r*l+n*o,t[1]=s*l+a*o,t[2]=r*-o+n*l,t[3]=s*-o+a*l}(this.rotationMatrix,this.rotationMatrix,this.angle))}get pitch(){return this._pitch/Math.PI*180}set pitch(t){const e=_(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==e&&(this._unmodified=!1,this._pitch=e,this._calcMatrices())}get fov(){return this._fov/Math.PI*180}set fov(t){t=Math.max(.01,Math.min(60,t)),this._fov!==t&&(this._unmodified=!1,this._fov=t/180*Math.PI,this._calcMatrices())}get zoom(){return this._zoom}set zoom(t){const e=Math.min(Math.max(t,this.minZoom),this.maxZoom);this._zoom!==e&&(this._unmodified=!1,this._zoom=e,this.tileZoom=Math.max(0,Math.floor(e)),this.scale=this.zoomScale(e),this._constrain(),this._calcMatrices())}get center(){return this._center}set center(t){t.lat===this._center.lat&&t.lng===this._center.lng||(this._unmodified=!1,this._center=t,this._constrain(),this._calcMatrices())}get elevation(){return this._elevation}set elevation(t){t!==this._elevation&&(this._elevation=t,this._constrain(),this._calcMatrices())}get padding(){return this._edgeInsets.toJSON()}set padding(t){this._edgeInsets.equals(t)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,t,1),this._calcMatrices())}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}isPaddingEqual(t){return this._edgeInsets.equals(t)}interpolatePadding(t,e,i){this._unmodified=!1,this._edgeInsets.interpolate(t,e,i),this._constrain(),this._calcMatrices()}coveringZoomLevel(t){const e=(t.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/t.tileSize));return Math.max(0,e)}getVisibleUnwrappedCoordinates(t){const e=[new Eu(0,t)];if(this._renderWorldCopies){const i=this.pointCoordinate(new a(0,0)),r=this.pointCoordinate(new a(this.width,0)),s=this.pointCoordinate(new a(this.width,this.height)),n=this.pointCoordinate(new a(0,this.height)),o=Math.floor(Math.min(i.x,r.x,s.x,n.x)),l=Math.floor(Math.max(i.x,r.x,s.x,n.x)),c=1;for(let i=o-c;i<=l+c;i++)0!==i&&e.push(new Eu(i,t))}return e}coveringTiles(t){var e,i;let r=this.coveringZoomLevel(t);const s=r;if(void 0!==t.minzoom&&r<t.minzoom)return[];void 0!==t.maxzoom&&r>t.maxzoom&&(r=t.maxzoom);const n=this.pointCoordinate(this.getCameraPoint()),a=wu.fromLngLat(this.center),o=Math.pow(2,r),l=[o*n.x,o*n.y,0],c=[o*a.x,o*a.y,0],h=mm.fromInvProjectionMatrix(this.invModelViewProjectionMatrix,this.worldSize,r);let u=t.minzoom||0;!t.terrain&&this.pitch<=60&&this._edgeInsets.top<.1&&(u=r);const p=t.terrain?2/Math.min(this.tileSize,t.tileSize)*this.tileSize:3,d=t=>({aabb:new _m([t*o,0,0],[(t+1)*o,o,0]),zoom:0,x:0,y:0,wrap:t,fullyVisible:!1}),f=[],m=[],_=r,g=t.reparseOverscaled?s:r;if(this._renderWorldCopies)for(let t=1;t<=3;t++)f.push(d(-t)),f.push(d(t));for(f.push(d(0));f.length>0;){const r=f.pop(),s=r.x,n=r.y;let a=r.fullyVisible;if(!a){const t=r.aabb.intersects(h);if(0===t)continue;a=2===t}const o=t.terrain?l:c,d=r.aabb.distanceX(o),y=r.aabb.distanceY(o),x=Math.max(Math.abs(d),Math.abs(y));if(r.zoom===_||x>p+(1<<_-r.zoom)-2&&r.zoom>=u){const t=_-r.zoom,e=l[0]-.5-(s<<t),i=l[1]-.5-(n<<t);m.push({tileID:new zu(r.zoom===_?g:r.zoom,r.wrap,r.zoom,s,n),distanceSq:$o([c[0]-.5-s,c[1]-.5-n]),tileDistanceToCamera:Math.sqrt(e*e+i*i)})}else for(let o=0;o<4;o++){const l=(s<<1)+o%2,c=(n<<1)+(o>>1),h=r.zoom+1;let u=r.aabb.quadrant(o);if(t.terrain){const s=new zu(h,r.wrap,h,l,c),n=t.terrain.getMinMaxElevation(s),a=null!==(e=n.minElevation)&&void 0!==e?e:this.elevation,o=null!==(i=n.maxElevation)&&void 0!==i?i:this.elevation;u=new _m([u.min[0],u.min[1],a],[u.max[0],u.max[1],o])}f.push({aabb:u,zoom:h,x:l,y:c,wrap:r.wrap,fullyVisible:a})}}return m.sort(((t,e)=>t.distanceSq-e.distanceSq)).map((t=>t.tileID))}resize(t,e){this.width=t,this.height=e,this.pixelsToGLUnits=[2/t,-2/e],this._constrain(),this._calcMatrices()}get unmodified(){return this._unmodified}zoomScale(t){return Math.pow(2,t)}scaleZoom(t){return Math.log(t)/Math.LN2}project(t){const e=_(t.lat,-85.051129,ym);return new a(yu(t.lng)*this.worldSize,xu(e)*this.worldSize)}unproject(t){return new wu(t.x/this.worldSize,t.y/this.worldSize).toLngLat()}get point(){return this.project(this.center)}getCameraPosition(){return{lngLat:this.pointLocation(this.getCameraPoint()),altitude:Math.cos(this._pitch)*this.cameraToCenterDistance/this._pixelPerMeter+this.elevation}}recalculateZoom(t){const e=this.elevation,i=Math.cos(this._pitch)*this.cameraToCenterDistance/this._pixelPerMeter,r=this.pointLocation(this.centerPoint,t),s=t.getElevationForLngLatZoom(r,this.tileZoom);if(!(this.elevation-s))return;const n=i+e-s,a=Math.cos(this._pitch)*this.cameraToCenterDistance/n/vu(1,r.lat),o=this.scaleZoom(a/this.tileSize);this._elevation=s,this._center=r,this.zoom=o}setLocationAtPoint(t,e){const i=this.pointCoordinate(e),r=this.pointCoordinate(this.centerPoint),s=this.locationCoordinate(t),n=new wu(s.x-(i.x-r.x),s.y-(i.y-r.y));this.center=this.coordinateLocation(n),this._renderWorldCopies&&(this.center=this.center.wrap())}locationPoint(t,e){return e?this.coordinatePoint(this.locationCoordinate(t),e.getElevationForLngLatZoom(t,this.tileZoom),this.pixelMatrix3D):this.coordinatePoint(this.locationCoordinate(t))}pointLocation(t,e){return this.coordinateLocation(this.pointCoordinate(t,e))}locationCoordinate(t){return wu.fromLngLat(t)}coordinateLocation(t){return t&&t.toLngLat()}pointCoordinate(t,e){if(e){const i=e.pointCoordinate(t);if(null!=i)return i}const i=[t.x,t.y,0,1],r=[t.x,t.y,1,1];jo(i,i,this.pixelMatrixInverse),jo(r,r,this.pixelMatrixInverse);const s=i[3],n=r[3],a=i[1]/s,o=r[1]/n,l=i[2]/s,c=r[2]/n,h=l===c?0:(0-l)/(c-l);return new wu(Ze.number(i[0]/s,r[0]/n,h)/this.worldSize,Ze.number(a,o,h)/this.worldSize)}coordinatePoint(t,e=0,i=this.pixelMatrix){const r=[t.x*this.worldSize,t.y*this.worldSize,e,1];return jo(r,r,i),new a(r[0]/r[3],r[1]/r[3])}getBounds(){const t=Math.max(0,this.height/2-this.getHorizon());return(new mu).extend(this.pointLocation(new a(0,t))).extend(this.pointLocation(new a(this.width,t))).extend(this.pointLocation(new a(this.width,this.height))).extend(this.pointLocation(new a(0,this.height)))}getMaxBounds(){return this.latRange&&2===this.latRange.length&&this.lngRange&&2===this.lngRange.length?new mu([this.lngRange[0],this.latRange[0]],[this.lngRange[1],this.latRange[1]]):null}getHorizon(){return Math.tan(Math.PI/2-this._pitch)*this.cameraToCenterDistance*.85}setMaxBounds(t){t?(this.lngRange=[t.getWest(),t.getEast()],this.latRange=[t.getSouth(),t.getNorth()],this._constrain()):(this.lngRange=null,this.latRange=[-85.051129,ym])}calculateTileMatrix(t){const e=t.canonical,i=this.worldSize/this.zoomScale(e.z),r=e.x+Math.pow(2,e.z)*t.wrap,s=zo(new Float64Array(16));return ko(s,s,[r*i,e.y*i,0]),Do(s,s,[i/to,i/to,1]),s}calculatePosMatrix(t,e=!1){const i=t.key,r=e?this._alignedPosMatrixCache:this._posMatrixCache;if(r[i])return r[i];const s=this.calculateTileMatrix(t);return Mo(s,e?this.alignedModelViewProjectionMatrix:this.modelViewProjectionMatrix,s),r[i]=new Float32Array(s),r[i]}calculateFogMatrix(t){const e=t.key,i=this._fogMatrixCache;if(i[e])return i[e];const r=this.calculateTileMatrix(t);return Mo(r,this.fogMatrix,r),i[e]=new Float32Array(r),i[e]}customLayerMatrix(){return this.mercatorMatrix.slice()}getConstrained(t,e){e=_(+e,this.minZoom,this.maxZoom);const i={center:new fu(t.lng,t.lat),zoom:e};let r=this.lngRange;if(!this._renderWorldCopies&&null===r){const t=180-1e-10;r=[-t,t]}const s=this.tileSize*this.zoomScale(i.zoom);let n=0,o=s,l=0,c=s,h=0,u=0;const{x:p,y:d}=this.size;if(this.latRange){const t=this.latRange;n=xu(t[1])*s,o=xu(t[0])*s,o-n<d&&(h=d/(o-n))}r&&(l=g(yu(r[0])*s,0,s),c=g(yu(r[1])*s,0,s),c<l&&(c+=s),c-l<p&&(u=p/(c-l)));const{x:f,y:m}=this.project.call({worldSize:s},t);let y,x;const v=Math.max(u||0,h||0);if(v){const t=new a(u?(c+l)/2:f,h?(o+n)/2:m);return i.center=this.unproject.call({worldSize:s},t).wrap(),i.zoom+=this.scaleZoom(v),i}if(this.latRange){const t=d/2;m-t<n&&(x=n+t),m+t>o&&(x=o-t)}if(r){const t=(l+c)/2;let e=f;this._renderWorldCopies&&(e=g(f,t-s/2,t+s/2));const i=p/2;e-i<l&&(y=l+i),e+i>c&&(y=c-i)}if(void 0!==y||void 0!==x){const t=new a(null!=y?y:f,null!=x?x:m);i.center=this.unproject.call({worldSize:s},t).wrap()}return i}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;const t=this._unmodified,{center:e,zoom:i}=this.getConstrained(this.center,this.zoom);this.center=e,this.zoom=i,this._unmodified=t,this._constraining=!1}_calcMatrices(){if(!this.height)return;const t=this.centerOffset,e=this.point.x,i=this.point.y;this.cameraToCenterDistance=.5/Math.tan(this._fov/2)*this.height,this._pixelPerMeter=vu(1,this.center.lat)*this.worldSize;let r=zo(new Float64Array(16));Do(r,r,[this.width/2,-this.height/2,1]),ko(r,r,[1,-1,0]),this.labelPlaneMatrix=r,r=zo(new Float64Array(16)),Do(r,r,[1,-1,1]),ko(r,r,[-1,-1,0]),Do(r,r,[2/this.width,2/this.height,1]),this.glCoordMatrix=r;const s=this.cameraToCenterDistance+this._elevation*this._pixelPerMeter/Math.cos(this._pitch),n=Math.min(this.elevation,this.minElevationForCurrentTile),a=s-n*this._pixelPerMeter/Math.cos(this._pitch),o=n<0?a:s,l=Math.PI/2+this._pitch,c=this._fov*(.5+t.y/this.height),h=Math.sin(c)*o/Math.sin(_(Math.PI-l-c,.01,Math.PI-.01)),u=this.getHorizon(),p=2*Math.atan(u/this.cameraToCenterDistance)*(.5+t.y/(2*u)),d=Math.sin(p)*o/Math.sin(_(Math.PI-l-p,.01,Math.PI-.01)),f=Math.min(h,d);this.farZ=1.01*(Math.cos(Math.PI/2-this._pitch)*f+o),this.nearZ=this.height/50,r=new Float64Array(16),Bo(r,this._fov,this.width/this.height,this.nearZ,this.farZ),r[8]=2*-t.x/this.width,r[9]=2*t.y/this.height,this.projectionMatrix=Eo(r),Do(r,r,[1,-1,1]),ko(r,r,[0,0,-this.cameraToCenterDistance]),Lo(r,r,this._pitch),Ro(r,r,this.angle),ko(r,r,[-e,-i,0]),this.mercatorMatrix=Do([],r,[this.worldSize,this.worldSize,this.worldSize]),Do(r,r,[1,1,this._pixelPerMeter]),this.pixelMatrix=Mo(new Float64Array(16),this.labelPlaneMatrix,r),ko(r,r,[0,0,-this.elevation]),this.modelViewProjectionMatrix=r,this.invModelViewProjectionMatrix=Po([],r),this.fogMatrix=new Float64Array(16),Bo(this.fogMatrix,this._fov,this.width/this.height,s,this.farZ),this.fogMatrix[8]=2*-t.x/this.width,this.fogMatrix[9]=2*t.y/this.height,Do(this.fogMatrix,this.fogMatrix,[1,-1,1]),ko(this.fogMatrix,this.fogMatrix,[0,0,-this.cameraToCenterDistance]),Lo(this.fogMatrix,this.fogMatrix,this._pitch),Ro(this.fogMatrix,this.fogMatrix,this.angle),ko(this.fogMatrix,this.fogMatrix,[-e,-i,0]),Do(this.fogMatrix,this.fogMatrix,[1,1,this._pixelPerMeter]),ko(this.fogMatrix,this.fogMatrix,[0,0,-this.elevation]),this.pixelMatrix3D=Mo(new Float64Array(16),this.labelPlaneMatrix,r);const m=this.width%2/2,g=this.height%2/2,y=Math.cos(this.angle),x=Math.sin(this.angle),v=e-Math.round(e)+y*m+x*g,b=i-Math.round(i)+y*g+x*m,w=new Float64Array(r);if(ko(w,w,[v>.5?v-1:v,b>.5?b-1:b,0]),this.alignedModelViewProjectionMatrix=w,r=Po(new Float64Array(16),this.pixelMatrix),!r)throw new Error("failed to invert matrix");this.pixelMatrixInverse=r,this._posMatrixCache={},this._alignedPosMatrixCache={},this._fogMatrixCache={}}maxPitchScaleFactor(){if(!this.pixelMatrixInverse)return 1;const t=this.pointCoordinate(new a(0,0)),e=[t.x*this.worldSize,t.y*this.worldSize,0,1];return jo(e,e,this.pixelMatrix)[3]/this.cameraToCenterDistance}getCameraPoint(){const t=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new a(0,t))}getCameraQueryGeometry(t){const e=this.getCameraPoint();if(1===t.length)return[t[0],e];{let i=e.x,r=e.y,s=e.x,n=e.y;for(const e of t)i=Math.min(i,e.x),r=Math.min(r,e.y),s=Math.max(s,e.x),n=Math.max(n,e.y);return[new a(i,r),new a(s,r),new a(s,n),new a(i,n),new a(i,r)]}}lngLatToCameraDepth(t,e){const i=this.locationCoordinate(t),r=[i.x*this.worldSize,i.y*this.worldSize,e,1];return jo(r,r,this.modelViewProjectionMatrix),r[2]/r[3]}}function vm(t,e){let i,r=!1,s=null,n=null;const a=()=>{s=null,r&&(t.apply(n,i),s=setTimeout(a,e),r=!1)};return(...t)=>(r=!0,n=this,i=t,s||a(),s)}class bm{constructor(t){this._getCurrentHash=()=>{const t=window.location.hash.replace("#","");if(this._hashName){let e;return t.split("&").map((t=>t.split("="))).forEach((t=>{t[0]===this._hashName&&(e=t)})),(e&&e[1]||"").split("/")}return t.split("/")},this._onHashChange=()=>{const t=this._getCurrentHash();if(t.length>=3&&!t.some((t=>isNaN(t)))){const e=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(t[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+t[2],+t[1]],zoom:+t[0],bearing:e,pitch:+(t[4]||0)}),!0}return!1},this._updateHashUnthrottled=()=>{const t=window.location.href.replace(/(#.*)?$/,this.getHashString());window.history.replaceState(window.history.state,null,t)},this._removeHash=()=>{const t=this._getCurrentHash();if(0===t.length)return;const e=t.join("/");let i=e;i.split("&").length>0&&(i=i.split("&")[0]),this._hashName&&(i=`${this._hashName}=${e}`);let r=window.location.hash.replace(i,"");r.startsWith("#&")?r=r.slice(0,1)+r.slice(2):"#"===r&&(r="");let s=window.location.href.replace(/(#.+)?$/,r);s=s.replace("&&","&"),window.history.replaceState(window.history.state,null,s)},this._updateHash=vm(this._updateHashUnthrottled,300),this._hashName=t&&encodeURIComponent(t)}addTo(t){return this._map=t,addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),this._removeHash(),delete this._map,this}getHashString(t){const e=this._map.getCenter(),i=Math.round(100*this._map.getZoom())/100,r=Math.ceil((i*Math.LN2+Math.log(512/360/.5))/Math.LN10),s=Math.pow(10,r),n=Math.round(e.lng*s)/s,a=Math.round(e.lat*s)/s,o=this._map.getBearing(),l=this._map.getPitch();let c="";if(c+=t?`/${n}/${a}/${i}`:`${i}/${a}/${n}`,(o||l)&&(c+="/"+Math.round(10*o)/10),l&&(c+=`/${Math.round(l)}`),this._hashName){const t=this._hashName;let e=!1;const i=window.location.hash.slice(1).split("&").map((i=>{const r=i.split("=")[0];return r===t?(e=!0,`${r}=${c}`):i})).filter((t=>t));return e||i.push(`${t}=${c}`),`#${i.join("&")}`}return`#${c}`}}const wm={linearity:.3,easing:f(0,0,.3,1)},Tm=y({deceleration:2500,maxSpeed:1400},wm),Sm=y({deceleration:20,maxSpeed:1400},wm),Im=y({deceleration:1e3,maxSpeed:360},wm),Am=y({deceleration:1e3,maxSpeed:90},wm);class Cm{constructor(t){this._map=t,this.clear()}clear(){this._inertiaBuffer=[]}record(t){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:F.now(),settings:t})}_drainInertiaBuffer(){const t=this._inertiaBuffer,e=F.now();for(;t.length>0&&e-t[0].time>160;)t.shift()}_onMoveEnd(t){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const e={zoom:0,bearing:0,pitch:0,pan:new a(0,0),pinchAround:void 0,around:void 0};for(const{settings:t}of this._inertiaBuffer)e.zoom+=t.zoomDelta||0,e.bearing+=t.bearingDelta||0,e.pitch+=t.pitchDelta||0,t.panDelta&&e.pan._add(t.panDelta),t.around&&(e.around=t.around),t.pinchAround&&(e.pinchAround=t.pinchAround);const i=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(e.pan.mag()){const s=zm(e.pan.mag(),i,y({},Tm,t||{}));r.offset=e.pan.mult(s.amount/e.pan.mag()),r.center=this._map.transform.center,Em(r,s)}if(e.zoom){const t=zm(e.zoom,i,Sm);r.zoom=this._map.transform.zoom+t.amount,Em(r,t)}if(e.bearing){const t=zm(e.bearing,i,Im);r.bearing=this._map.transform.bearing+_(t.amount,-179,179),Em(r,t)}if(e.pitch){const t=zm(e.pitch,i,Am);r.pitch=this._map.transform.pitch+t.amount,Em(r,t)}if(r.zoom||r.bearing){const t=void 0===e.pinchAround?e.around:e.pinchAround;r.around=t?this._map.unproject(t):this._map.getCenter()}return this.clear(),y(r,{noMoveStart:!0})}}function Em(t,e){(!t.duration||t.duration<e.duration)&&(t.duration=e.duration,t.easing=e.easing)}function zm(t,e,i){const{maxSpeed:r,linearity:s,deceleration:n}=i,a=_(t*s/(e/1e3),-r,r),o=Math.abs(a)/(n*s);return{easing:i.easing,duration:1e3*o,amount:a*(o/2)}}class Pm extends rt{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i,r={}){const s=O.mousePos(e.getCanvas(),i);super(t,y({point:s,lngLat:e.unproject(s),originalEvent:i},r)),this._defaultPrevented=!1,this.target=e}}class Mm extends rt{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){const r="touchend"===t?i.changedTouches:i.touches,s=O.touchPos(e.getCanvasContainer(),r),n=s.map((t=>e.unproject(t))),o=s.reduce(((t,e,i,r)=>t.add(e.div(r.length))),new a(0,0));super(t,{points:s,point:o,lngLats:n,lngLat:e.unproject(o),originalEvent:i}),this._defaultPrevented=!1}}class km extends rt{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){super(t,{originalEvent:i}),this._defaultPrevented=!1}}class Dm{constructor(t,e){this._map=t,this._clickTolerance=e.clickTolerance}reset(){delete this._mousedownPos}wheel(t){return this._firePreventable(new km(t.type,this._map,t))}mousedown(t,e){return this._mousedownPos=e,this._firePreventable(new Pm(t.type,this._map,t))}mouseup(t){this._map.fire(new Pm(t.type,this._map,t))}click(t,e){this._mousedownPos&&this._mousedownPos.dist(e)>=this._clickTolerance||this._map.fire(new Pm(t.type,this._map,t))}dblclick(t){return this._firePreventable(new Pm(t.type,this._map,t))}mouseover(t){this._map.fire(new Pm(t.type,this._map,t))}mouseout(t){this._map.fire(new Pm(t.type,this._map,t))}touchstart(t){return this._firePreventable(new Mm(t.type,this._map,t))}touchmove(t){this._map.fire(new Mm(t.type,this._map,t))}touchend(t){this._map.fire(new Mm(t.type,this._map,t))}touchcancel(t){this._map.fire(new Mm(t.type,this._map,t))}_firePreventable(t){if(this._map.fire(t),t.defaultPrevented)return{}}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class Lm{constructor(t){this._map=t}reset(){this._delayContextMenu=!1,this._ignoreContextMenu=!0,delete this._contextMenuEvent}mousemove(t){this._map.fire(new Pm(t.type,this._map,t))}mousedown(){this._delayContextMenu=!0,this._ignoreContextMenu=!1}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new Pm("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent)}contextmenu(t){this._delayContextMenu?this._contextMenuEvent=t:this._ignoreContextMenu||this._map.fire(new Pm(t.type,this._map,t)),this._map.listens("contextmenu")&&t.preventDefault()}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class Rm{constructor(t){this._map=t}get transform(){return this._map._requestedCameraState||this._map.transform}get center(){return{lng:this.transform.center.lng,lat:this.transform.center.lat}}get zoom(){return this.transform.zoom}get pitch(){return this.transform.pitch}get bearing(){return this.transform.bearing}unproject(t){return this.transform.pointLocation(a.convert(t),this._map.terrain)}}class Bm{constructor(t,e){this._map=t,this._tr=new Rm(t),this._el=t.getCanvasContainer(),this._container=t.getContainer(),this._clickTolerance=e.clickTolerance||1}isEnabled(){return!!this._enabled}isActive(){return!!this._active}enable(){this.isEnabled()||(this._enabled=!0)}disable(){this.isEnabled()&&(this._enabled=!1)}mousedown(t,e){this.isEnabled()&&t.shiftKey&&0===t.button&&(O.disableDrag(),this._startPos=this._lastPos=e,this._active=!0)}mousemoveWindow(t,e){if(!this._active)return;const i=e;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const r=this._startPos;this._lastPos=i,this._box||(this._box=O.create("div","maplibregl-boxzoom",this._container),this._container.classList.add("maplibregl-crosshair"),this._fireEvent("boxzoomstart",t));const s=Math.min(r.x,i.x),n=Math.max(r.x,i.x),a=Math.min(r.y,i.y),o=Math.max(r.y,i.y);O.setTransform(this._box,`translate(${s}px,${a}px)`),this._box.style.width=n-s+"px",this._box.style.height=o-a+"px"}mouseupWindow(t,e){if(!this._active)return;if(0!==t.button)return;const i=this._startPos,r=e;if(this.reset(),O.suppressClick(),i.x!==r.x||i.y!==r.y)return this._map.fire(new rt("boxzoomend",{originalEvent:t})),{cameraAnimation:t=>t.fitScreenCoordinates(i,r,this._tr.bearing,{linear:!0})};this._fireEvent("boxzoomcancel",t)}keydown(t){this._active&&27===t.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",t))}reset(){this._active=!1,this._container.classList.remove("maplibregl-crosshair"),this._box&&(O.remove(this._box),this._box=null),O.enableDrag(),delete this._startPos,delete this._lastPos}_fireEvent(t,e){return this._map.fire(new rt(t,{originalEvent:e}))}}function Fm(t,e){if(t.length!==e.length)throw new Error(`The number of touches and points are not equal - touches ${t.length}, points ${e.length}`);const i={};for(let r=0;r<t.length;r++)i[t[r].identifier]=e[r];return i}class Om{constructor(t){this.reset(),this.numTouches=t.numTouches}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1}touchstart(t,e,i){(this.centroid||i.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=t.timeStamp),i.length===this.numTouches&&(this.centroid=function(t){const e=new a(0,0);for(const i of t)e._add(i);return e.div(t.length)}(e),this.touches=Fm(i,e)))}touchmove(t,e,i){if(this.aborted||!this.centroid)return;const r=Fm(i,e);for(const t in this.touches){const e=r[t];(!e||e.dist(this.touches[t])>30)&&(this.aborted=!0)}}touchend(t,e,i){if((!this.centroid||t.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const t=!this.aborted&&this.centroid;if(this.reset(),t)return t}}}class Vm{constructor(t){this.singleTap=new Om(t),this.numTaps=t.numTaps,this.reset()}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset()}touchstart(t,e,i){this.singleTap.touchstart(t,e,i)}touchmove(t,e,i){this.singleTap.touchmove(t,e,i)}touchend(t,e,i){const r=this.singleTap.touchend(t,e,i);if(r){const e=t.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(r)<30;if(e&&i||this.reset(),this.count++,this.lastTime=t.timeStamp,this.lastTap=r,this.count===this.numTaps)return this.reset(),r}}}class Um{constructor(t){this._tr=new Rm(t),this._zoomIn=new Vm({numTouches:1,numTaps:2}),this._zoomOut=new Vm({numTouches:2,numTaps:1}),this.reset()}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset()}touchstart(t,e,i){this._zoomIn.touchstart(t,e,i),this._zoomOut.touchstart(t,e,i)}touchmove(t,e,i){this._zoomIn.touchmove(t,e,i),this._zoomOut.touchmove(t,e,i)}touchend(t,e,i){const r=this._zoomIn.touchend(t,e,i),s=this._zoomOut.touchend(t,e,i),n=this._tr;return r?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:n.zoom+1,around:n.unproject(r)},{originalEvent:t})}):s?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:n.zoom-1,around:n.unproject(s)},{originalEvent:t})}):void 0}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class Nm{constructor(t){this._enabled=!!t.enable,this._moveStateManager=t.moveStateManager,this._clickTolerance=t.clickTolerance||1,this._moveFunction=t.move,this._activateOnStart=!!t.activateOnStart,t.assignEvents(this),this.reset()}reset(t){this._active=!1,this._moved=!1,delete this._lastPoint,this._moveStateManager.endMove(t)}_move(...t){const e=this._moveFunction(...t);if(e.bearingDelta||e.pitchDelta||e.around||e.panDelta)return this._active=!0,e}dragStart(t,e){this.isEnabled()&&!this._lastPoint&&this._moveStateManager.isValidStartEvent(t)&&(this._moveStateManager.startMove(t),this._lastPoint=e.length?e[0]:e,this._activateOnStart&&this._lastPoint&&(this._active=!0))}dragMove(t,e){if(!this.isEnabled())return;const i=this._lastPoint;if(!i)return;if(t.preventDefault(),!this._moveStateManager.isValidMoveEvent(t))return void this.reset(t);const r=e.length?e[0]:e;return!this._moved&&r.dist(i)<this._clickTolerance?void 0:(this._moved=!0,this._lastPoint=r,this._move(i,r))}dragEnd(t){this.isEnabled()&&this._lastPoint&&this._moveStateManager.isValidEndEvent(t)&&(this._moved&&O.suppressClick(),this.reset(t))}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}getClickTolerance(){return this._clickTolerance}}const jm={0:1,2:2};class $m{constructor(t){this._correctEvent=t.checkCorrectEvent}startMove(t){const e=O.mouseButton(t);this._eventButton=e}endMove(t){delete this._eventButton}isValidStartEvent(t){return this._correctEvent(t)}isValidMoveEvent(t){return!function(t,e){const i=jm[e];return void 0===t.buttons||(t.buttons&i)!==i}(t,this._eventButton)}isValidEndEvent(t){return O.mouseButton(t)===this._eventButton}}class qm{constructor(){this._firstTouch=void 0}_isOneFingerTouch(t){return 1===t.targetTouches.length}_isSameTouchEvent(t){return t.targetTouches[0].identifier===this._firstTouch}startMove(t){this._firstTouch=t.targetTouches[0].identifier}endMove(t){delete this._firstTouch}isValidStartEvent(t){return this._isOneFingerTouch(t)}isValidMoveEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}isValidEndEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}}const Zm=t=>{t.mousedown=t.dragStart,t.mousemoveWindow=t.dragMove,t.mouseup=t.dragEnd,t.contextmenu=t=>{t.preventDefault()}},Gm=({enable:t,clickTolerance:e,bearingDegreesPerPixelMoved:i=.8})=>{const r=new $m({checkCorrectEvent:t=>0===O.mouseButton(t)&&t.ctrlKey||2===O.mouseButton(t)});return new Nm({clickTolerance:e,move:(t,e)=>({bearingDelta:(e.x-t.x)*i}),moveStateManager:r,enable:t,assignEvents:Zm})},Wm=({enable:t,clickTolerance:e,pitchDegreesPerPixelMoved:i=-.5})=>{const r=new $m({checkCorrectEvent:t=>0===O.mouseButton(t)&&t.ctrlKey||2===O.mouseButton(t)});return new Nm({clickTolerance:e,move:(t,e)=>({pitchDelta:(e.y-t.y)*i}),moveStateManager:r,enable:t,assignEvents:Zm})};class Hm{constructor(t,e){this._clickTolerance=t.clickTolerance||1,this._map=e,this.reset()}reset(){this._active=!1,this._touches={},this._sum=new a(0,0)}_shouldBePrevented(t){return t<(this._map.cooperativeGestures.isEnabled()?2:1)}touchstart(t,e,i){return this._calculateTransform(t,e,i)}touchmove(t,e,i){if(this._active){if(!this._shouldBePrevented(i.length))return t.preventDefault(),this._calculateTransform(t,e,i);this._map.cooperativeGestures.notifyGestureBlocked("touch_pan",t)}}touchend(t,e,i){this._calculateTransform(t,e,i),this._active&&this._shouldBePrevented(i.length)&&this.reset()}touchcancel(){this.reset()}_calculateTransform(t,e,i){i.length>0&&(this._active=!0);const r=Fm(i,e),s=new a(0,0),n=new a(0,0);let o=0;for(const t in r){const e=r[t],i=this._touches[t];i&&(s._add(e),n._add(e.sub(i)),o++,r[t]=e)}if(this._touches=r,this._shouldBePrevented(o)||!n.mag())return;const l=n.div(o);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:s.div(o),panDelta:l}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class Xm{constructor(){this.reset()}reset(){this._active=!1,delete this._firstTwoTouches}touchstart(t,e,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([e[0],e[1]]))}touchmove(t,e,i){if(!this._firstTwoTouches)return;t.preventDefault();const[r,s]=this._firstTwoTouches,n=Km(i,e,r),a=Km(i,e,s);if(!n||!a)return;const o=this._aroundCenter?null:n.add(a).div(2);return this._move([n,a],o,t)}touchend(t,e,i){if(!this._firstTwoTouches)return;const[r,s]=this._firstTwoTouches,n=Km(i,e,r),a=Km(i,e,s);n&&a||(this._active&&O.suppressClick(),this.reset())}touchcancel(){this.reset()}enable(t){this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around}disable(){this._enabled=!1,this.reset()}isEnabled(){return!!this._enabled}isActive(){return!!this._active}}function Km(t,e,i){for(let r=0;r<t.length;r++)if(t[r].identifier===i)return e[r]}function Ym(t,e){return Math.log(t/e)/Math.LN2}class Jm extends Xm{reset(){super.reset(),delete this._distance,delete this._startDistance}_start(t){this._startDistance=this._distance=t[0].dist(t[1])}_move(t,e){const i=this._distance;if(this._distance=t[0].dist(t[1]),this._active||!(Math.abs(Ym(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:Ym(this._distance,i),pinchAround:e}}}function Qm(t,e){return 180*t.angleWith(e)/Math.PI}class t_ extends Xm{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector}_start(t){this._startVector=this._vector=t[0].sub(t[1]),this._minDiameter=t[0].dist(t[1])}_move(t,e,i){const r=this._vector;if(this._vector=t[0].sub(t[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:Qm(this._vector,r),pinchAround:e}}_isBelowThreshold(t){this._minDiameter=Math.min(this._minDiameter,t.mag());const e=25/(Math.PI*this._minDiameter)*360,i=Qm(t,this._startVector);return Math.abs(i)<e}}function e_(t){return Math.abs(t.y)>Math.abs(t.x)}class i_ extends Xm{constructor(t){super(),this._currentTouchCount=0,this._map=t}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints}touchstart(t,e,i){super.touchstart(t,e,i),this._currentTouchCount=i.length}_start(t){this._lastPoints=t,e_(t[0].sub(t[1]))&&(this._valid=!1)}_move(t,e,i){if(this._map.cooperativeGestures.isEnabled()&&this._currentTouchCount<3)return;const r=t[0].sub(this._lastPoints[0]),s=t[1].sub(this._lastPoints[1]);return this._valid=this.gestureBeginsVertically(r,s,i.timeStamp),this._valid?(this._lastPoints=t,this._active=!0,{pitchDelta:(r.y+s.y)/2*-.5}):void 0}gestureBeginsVertically(t,e,i){if(void 0!==this._valid)return this._valid;const r=t.mag()>=2,s=e.mag()>=2;if(!r&&!s)return;if(!r||!s)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const n=t.y>0==e.y>0;return e_(t)&&e_(e)&&n}}const r_={panStep:100,bearingStep:15,pitchStep:10};class s_{constructor(t){this._tr=new Rm(t);const e=r_;this._panStep=e.panStep,this._bearingStep=e.bearingStep,this._pitchStep=e.pitchStep,this._rotationDisabled=!1}reset(){this._active=!1}keydown(t){if(t.altKey||t.ctrlKey||t.metaKey)return;let e=0,i=0,r=0,s=0,n=0;switch(t.keyCode){case 61:case 107:case 171:case 187:e=1;break;case 189:case 109:case 173:e=-1;break;case 37:t.shiftKey?i=-1:(t.preventDefault(),s=-1);break;case 39:t.shiftKey?i=1:(t.preventDefault(),s=1);break;case 38:t.shiftKey?r=1:(t.preventDefault(),n=-1);break;case 40:t.shiftKey?r=-1:(t.preventDefault(),n=1);break;default:return}return this._rotationDisabled&&(i=0,r=0),{cameraAnimation:a=>{const o=this._tr;a.easeTo({duration:300,easeId:"keyboardHandler",easing:n_,zoom:e?Math.round(o.zoom)+e*(t.shiftKey?2:1):o.zoom,bearing:o.bearing+i*this._bearingStep,pitch:o.pitch+r*this._pitchStep,offset:[-s*this._panStep,-n*this._panStep],center:o.center},{originalEvent:t})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0}enableRotation(){this._rotationDisabled=!1}}function n_(t){return t*(2-t)}const a_=4.000244140625;class o_{constructor(t,e){this._onTimeout=t=>{this._type="wheel",this._delta-=this._lastValue,this._active||this._start(t)},this._map=t,this._tr=new Rm(t),this._triggerRenderFrame=e,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=.0022222222222222222}setZoomRate(t){this._defaultZoomRate=t}setWheelZoomRate(t){this._wheelZoomRate=t}isEnabled(){return!!this._enabled}isActive(){return!!this._active||void 0!==this._finishTimeout}isZooming(){return!!this._zooming}enable(t){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around)}disable(){this.isEnabled()&&(this._enabled=!1)}_shouldBePrevented(t){return!!this._map.cooperativeGestures.isEnabled()&&!(t.ctrlKey||this._map.cooperativeGestures.isBypassed(t))}wheel(t){if(!this.isEnabled())return;if(this._shouldBePrevented(t))return void this._map.cooperativeGestures.notifyGestureBlocked("wheel_zoom",t);let e=t.deltaMode===WheelEvent.DOM_DELTA_LINE?40*t.deltaY:t.deltaY;const i=F.now(),r=i-(this._lastWheelEventTime||0);this._lastWheelEventTime=i,0!==e&&e%a_==0?this._type="wheel":0!==e&&Math.abs(e)<4?this._type="trackpad":r>400?(this._type=null,this._lastValue=e,this._timeout=setTimeout(this._onTimeout,40,t)):this._type||(this._type=Math.abs(r*e)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,e+=this._lastValue)),t.shiftKey&&e&&(e/=4),this._type&&(this._lastWheelEvent=t,this._delta-=e,this._active||this._start(t)),t.preventDefault()}_start(t){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const e=O.mousePos(this._map.getCanvas(),t),i=this._tr;this._around=e.y>i.transform.height/2-i.transform.getHorizon()?fu.convert(this._aroundCenter?i.center:i.unproject(e)):fu.convert(i.center),this._aroundPoint=i.transform.locationPoint(this._around),this._frameId||(this._frameId=!0,this._triggerRenderFrame())}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const t=this._tr.transform;if(0!==this._delta){const e="wheel"===this._type&&Math.abs(this._delta)>a_?this._wheelZoomRate:this._defaultZoomRate;let i=2/(1+Math.exp(-Math.abs(this._delta*e)));this._delta<0&&0!==i&&(i=1/i);const r="number"==typeof this._targetZoom?t.zoomScale(this._targetZoom):t.scale;this._targetZoom=Math.min(t.maxZoom,Math.max(t.minZoom,t.scaleZoom(r*i))),"wheel"===this._type&&(this._startZoom=t.zoom,this._easing=this._smoothOutEasing(200)),this._delta=0}const e="number"==typeof this._targetZoom?this._targetZoom:t.zoom,i=this._startZoom,r=this._easing;let s,n=!1;const a=F.now()-this._lastWheelEventTime;if("wheel"===this._type&&i&&r&&a){const t=Math.min(a/200,1),o=r(t);s=Ze.number(i,e,o),t<1?this._frameId||(this._frameId=!0):n=!0}else s=e,n=!0;return this._active=!0,n&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._triggerRenderFrame(),delete this._targetZoom,delete this._finishTimeout}),200)),{noInertia:!0,needsRenderFrame:!n,zoomDelta:s-t.zoom,around:this._aroundPoint,originalEvent:this._lastWheelEvent}}_smoothOutEasing(t){let e=m;if(this._prevEase){const t=this._prevEase,i=(F.now()-t.start)/t.duration,r=t.easing(i+.01)-t.easing(i),s=.27/Math.sqrt(r*r+1e-4)*.01;e=f(s,Math.sqrt(.0729-s*s),.25,1)}return this._prevEase={start:F.now(),duration:t,easing:e},e}reset(){this._active=!1,this._zooming=!1,delete this._targetZoom,this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout)}}class l_{constructor(t,e){this._clickZoom=t,this._tapZoom=e}enable(){this._clickZoom.enable(),this._tapZoom.enable()}disable(){this._clickZoom.disable(),this._tapZoom.disable()}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class c_{constructor(t){this._tr=new Rm(t),this.reset()}reset(){this._active=!1}dblclick(t,e){return t.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:this._tr.zoom+(t.shiftKey?-1:1),around:this._tr.unproject(e)},{originalEvent:t})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class h_{constructor(){this._tap=new Vm({numTouches:1,numTaps:1}),this.reset()}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,delete this._tapPoint,this._tap.reset()}touchstart(t,e,i){if(!this._swipePoint)if(this._tapTime){const r=e[0],s=t.timeStamp-this._tapTime<500,n=this._tapPoint.dist(r)<30;s&&n?i.length>0&&(this._swipePoint=r,this._swipeTouch=i[0].identifier):this.reset()}else this._tap.touchstart(t,e,i)}touchmove(t,e,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const r=e[0],s=r.y-this._swipePoint.y;return this._swipePoint=r,t.preventDefault(),this._active=!0,{zoomDelta:s/128}}}else this._tap.touchmove(t,e,i)}touchend(t,e,i){if(this._tapTime)this._swipePoint&&0===i.length&&this.reset();else{const r=this._tap.touchend(t,e,i);r&&(this._tapTime=t.timeStamp,this._tapPoint=r)}}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class u_{constructor(t,e,i){this._el=t,this._mousePan=e,this._touchPan=i}enable(t){this._inertiaOptions=t||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("maplibregl-touch-drag-pan")}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("maplibregl-touch-drag-pan")}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class p_{constructor(t,e,i){this._pitchWithRotate=t.pitchWithRotate,this._mouseRotate=e,this._mousePitch=i}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable()}disable(){this._mouseRotate.disable(),this._mousePitch.disable()}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()}}class d_{constructor(t,e,i,r){this._el=t,this._touchZoom=e,this._touchRotate=i,this._tapDragZoom=r,this._rotationDisabled=!1,this._enabled=!0}enable(t){this._touchZoom.enable(t),this._rotationDisabled||this._touchRotate.enable(t),this._tapDragZoom.enable(),this._el.classList.add("maplibregl-touch-zoom-rotate")}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("maplibregl-touch-zoom-rotate")}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable()}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable()}}class f_{constructor(t,e){this._bypassKey=-1!==navigator.userAgent.indexOf("Mac")?"metaKey":"ctrlKey",this._map=t,this._options=e,this._enabled=!1}isActive(){return!1}reset(){}_setupUI(){if(this._container)return;const t=this._map.getCanvasContainer();t.classList.add("maplibregl-cooperative-gestures"),this._container=O.create("div","maplibregl-cooperative-gesture-screen",t);let e=this._map._getUIString("CooperativeGesturesHandler.WindowsHelpText");"metaKey"===this._bypassKey&&(e=this._map._getUIString("CooperativeGesturesHandler.MacHelpText"));const i=this._map._getUIString("CooperativeGesturesHandler.MobileHelpText"),r=document.createElement("div");r.className="maplibregl-desktop-message",r.textContent=e,this._container.appendChild(r);const s=document.createElement("div");s.className="maplibregl-mobile-message",s.textContent=i,this._container.appendChild(s),this._container.setAttribute("aria-hidden","true")}_destroyUI(){this._container&&(O.remove(this._container),this._map.getCanvasContainer().classList.remove("maplibregl-cooperative-gestures")),delete this._container}enable(){this._setupUI(),this._enabled=!0}disable(){this._enabled=!1,this._destroyUI()}isEnabled(){return this._enabled}isBypassed(t){return t[this._bypassKey]}notifyGestureBlocked(t,e){this._enabled&&(this._map.fire(new rt("cooperativegestureprevented",{gestureType:t,originalEvent:e})),this._container.classList.add("maplibregl-show"),setTimeout((()=>{this._container.classList.remove("maplibregl-show")}),100))}}const m_=t=>t.zoom||t.drag||t.pitch||t.rotate;class __ extends rt{}function g_(t){return t.panDelta&&t.panDelta.mag()||t.zoomDelta||t.bearingDelta||t.pitchDelta}class y_{constructor(t,e){this.handleWindowEvent=t=>{this.handleEvent(t,`${t.type}Window`)},this.handleEvent=(t,e)=>{if("blur"===t.type)return void this.stop(!0);this._updatingCamera=!0;const i="renderFrame"===t.type?void 0:t,r={needsRenderFrame:!1},s={},n={},a=t.touches,o=a?this._getMapTouches(a):void 0,l=o?O.touchPos(this._map.getCanvas(),o):O.mousePos(this._map.getCanvas(),t);for(const{handlerName:a,handler:c,allowed:h}of this._handlers){if(!c.isEnabled())continue;let u;this._blockedByActive(n,h,a)?c.reset():c[e||t.type]&&(u=c[e||t.type](t,l,o),this.mergeHandlerResult(r,s,u,a,i),u&&u.needsRenderFrame&&this._triggerRenderFrame()),(u||c.isActive())&&(n[a]=c)}const c={};for(const t in this._previousActiveHandlers)n[t]||(c[t]=i);this._previousActiveHandlers=n,(Object.keys(c).length||g_(r))&&(this._changes.push([r,s,c]),this._triggerRenderFrame()),(Object.keys(n).length||g_(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:h}=r;h&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],h(this._map))},this._map=t,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new Cm(t),this._bearingSnap=e.bearingSnap,this._previousActiveHandlers={},this._eventsInProgress={},this._addDefaultHandlers(e);const i=this._el;this._listeners=[[i,"touchstart",{passive:!0}],[i,"touchmove",{passive:!1}],[i,"touchend",void 0],[i,"touchcancel",void 0],[i,"mousedown",void 0],[i,"mousemove",void 0],[i,"mouseup",void 0],[document,"mousemove",{capture:!0}],[document,"mouseup",void 0],[i,"mouseover",void 0],[i,"mouseout",void 0],[i,"dblclick",void 0],[i,"click",void 0],[i,"keydown",{capture:!1}],[i,"keyup",void 0],[i,"wheel",{passive:!1}],[i,"contextmenu",void 0],[window,"blur",void 0]];for(const[t,e,i]of this._listeners)O.addEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i)}destroy(){for(const[t,e,i]of this._listeners)O.removeEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i)}_addDefaultHandlers(t){const e=this._map,i=e.getCanvasContainer();this._add("mapEvent",new Dm(e,t));const r=e.boxZoom=new Bm(e,t);this._add("boxZoom",r),t.interactive&&t.boxZoom&&r.enable();const s=e.cooperativeGestures=new f_(e,t.cooperativeGestures);this._add("cooperativeGestures",s),t.cooperativeGestures&&s.enable();const n=new Um(e),a=new c_(e);e.doubleClickZoom=new l_(a,n),this._add("tapZoom",n),this._add("clickZoom",a),t.interactive&&t.doubleClickZoom&&e.doubleClickZoom.enable();const o=new h_;this._add("tapDragZoom",o);const l=e.touchPitch=new i_(e);this._add("touchPitch",l),t.interactive&&t.touchPitch&&e.touchPitch.enable(t.touchPitch);const c=Gm(t),h=Wm(t);e.dragRotate=new p_(t,c,h),this._add("mouseRotate",c,["mousePitch"]),this._add("mousePitch",h,["mouseRotate"]),t.interactive&&t.dragRotate&&e.dragRotate.enable();const u=(({enable:t,clickTolerance:e})=>{const i=new $m({checkCorrectEvent:t=>0===O.mouseButton(t)&&!t.ctrlKey});return new Nm({clickTolerance:e,move:(t,e)=>({around:e,panDelta:e.sub(t)}),activateOnStart:!0,moveStateManager:i,enable:t,assignEvents:Zm})})(t),p=new Hm(t,e);e.dragPan=new u_(i,u,p),this._add("mousePan",u),this._add("touchPan",p,["touchZoom","touchRotate"]),t.interactive&&t.dragPan&&e.dragPan.enable(t.dragPan);const d=new t_,f=new Jm;e.touchZoomRotate=new d_(i,f,d,o),this._add("touchRotate",d,["touchPan","touchZoom"]),this._add("touchZoom",f,["touchPan","touchRotate"]),t.interactive&&t.touchZoomRotate&&e.touchZoomRotate.enable(t.touchZoomRotate);const m=e.scrollZoom=new o_(e,(()=>this._triggerRenderFrame()));this._add("scrollZoom",m,["mousePan"]),t.interactive&&t.scrollZoom&&e.scrollZoom.enable(t.scrollZoom);const _=e.keyboard=new s_(e);this._add("keyboard",_),t.interactive&&t.keyboard&&e.keyboard.enable(),this._add("blockableMapEvent",new Lm(e))}_add(t,e,i){this._handlers.push({handlerName:t,handler:e,allowed:i}),this._handlersById[t]=e}stop(t){if(!this._updatingCamera){for(const{handler:t}of this._handlers)t.reset();this._inertia.clear(),this._fireEvents({},{},t),this._changes=[]}}isActive(){for(const{handler:t}of this._handlers)if(t.isActive())return!0;return!1}isZooming(){return!!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return!!this._eventsInProgress.rotate}isMoving(){return Boolean(m_(this._eventsInProgress))||this.isZooming()}_blockedByActive(t,e,i){for(const r in t)if(r!==i&&(!e||e.indexOf(r)<0))return!0;return!1}_getMapTouches(t){const e=[];for(const i of t)this._el.contains(i.target)&&e.push(i);return e}mergeHandlerResult(t,e,i,r,s){if(!i)return;y(t,i);const n={handlerName:r,originalEvent:i.originalEvent||s};void 0!==i.zoomDelta&&(e.zoom=n),void 0!==i.panDelta&&(e.drag=n),void 0!==i.pitchDelta&&(e.pitch=n),void 0!==i.bearingDelta&&(e.rotate=n)}_applyChanges(){const t={},e={},i={};for(const[r,s,n]of this._changes)r.panDelta&&(t.panDelta=(t.panDelta||new a(0,0))._add(r.panDelta)),r.zoomDelta&&(t.zoomDelta=(t.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(t.bearingDelta=(t.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(t.pitchDelta=(t.pitchDelta||0)+r.pitchDelta),void 0!==r.around&&(t.around=r.around),void 0!==r.pinchAround&&(t.pinchAround=r.pinchAround),r.noInertia&&(t.noInertia=r.noInertia),y(e,s),y(i,n);this._updateMapTransform(t,e,i),this._changes=[]}_updateMapTransform(t,e,i){const r=this._map,s=r._getTransformForUpdate(),n=r.terrain;if(!(g_(t)||n&&this._terrainMovement))return this._fireEvents(e,i,!0);let{panDelta:a,zoomDelta:o,bearingDelta:l,pitchDelta:c,around:h,pinchAround:u}=t;void 0!==u&&(h=u),r._stop(!0),h=h||r.transform.centerPoint;const p=s.pointLocation(a?h.sub(a):h);l&&(s.bearing+=l),c&&(s.pitch+=c),o&&(s.zoom+=o),n?this._terrainMovement||!e.drag&&!e.zoom?e.drag&&this._terrainMovement?s.center=s.pointLocation(s.centerPoint.sub(a)):s.setLocationAtPoint(p,h):(this._terrainMovement=!0,this._map._elevationFreeze=!0,s.setLocationAtPoint(p,h)):s.setLocationAtPoint(p,h),r._applyUpdatedTransform(s),this._map._update(),t.noInertia||this._inertia.record(t),this._fireEvents(e,i,!0)}_fireEvents(t,e,i){const r=m_(this._eventsInProgress),s=m_(t),n={};for(const e in t){const{originalEvent:i}=t[e];this._eventsInProgress[e]||(n[`${e}start`]=i),this._eventsInProgress[e]=t[e]}!r&&s&&this._fireEvent("movestart",s.originalEvent);for(const t in n)this._fireEvent(t,n[t]);s&&this._fireEvent("move",s.originalEvent);for(const e in t){const{originalEvent:i}=t[e];this._fireEvent(e,i)}const a={};let o;for(const t in this._eventsInProgress){const{handlerName:i,originalEvent:r}=this._eventsInProgress[t];this._handlersById[i].isActive()||(delete this._eventsInProgress[t],o=e[i]||r,a[`${t}end`]=o)}for(const t in a)this._fireEvent(t,a[t]);const l=m_(this._eventsInProgress),c=(r||s)&&!l;if(c&&this._terrainMovement){this._map._elevationFreeze=!1,this._terrainMovement=!1;const t=this._map._getTransformForUpdate();t.recalculateZoom(this._map.terrain),this._map._applyUpdatedTransform(t)}if(i&&c){this._updatingCamera=!0;const t=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),e=t=>0!==t&&-this._bearingSnap<t&&t<this._bearingSnap;!t||!t.essential&&F.prefersReducedMotion?(this._map.fire(new rt("moveend",{originalEvent:o})),e(this._map.getBearing())&&this._map.resetNorth()):(e(t.bearing||this._map.getBearing())&&(t.bearing=0),t.freezeElevation=!0,this._map.easeTo(t,{originalEvent:o})),this._updatingCamera=!1}}_fireEvent(t,e){this._map.fire(new rt(t,e?{originalEvent:e}:{}))}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((t=>{delete this._frameId,this.handleEvent(new __("renderFrame",{timeStamp:t})),this._applyChanges()}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame())}}class x_ extends nt{constructor(t,e){super(),this._renderFrameCallback=()=>{const t=Math.min((F.now()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(t)),t<1&&this._easeFrameId?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop()},this._moving=!1,this._zooming=!1,this.transform=t,this._bearingSnap=e.bearingSnap,this.on("moveend",(()=>{delete this._requestedCameraState}))}getCenter(){return new fu(this.transform.center.lng,this.transform.center.lat)}setCenter(t,e){return this.jumpTo({center:t},e)}panBy(t,e,i){return t=a.convert(t).mult(-1),this.panTo(this.transform.center,y({offset:t},e),i)}panTo(t,e,i){return this.easeTo(y({center:t},e),i)}getZoom(){return this.transform.zoom}setZoom(t,e){return this.jumpTo({zoom:t},e),this}zoomTo(t,e,i){return this.easeTo(y({zoom:t},e),i)}zoomIn(t,e){return this.zoomTo(this.getZoom()+1,t,e),this}zoomOut(t,e){return this.zoomTo(this.getZoom()-1,t,e),this}getBearing(){return this.transform.bearing}setBearing(t,e){return this.jumpTo({bearing:t},e),this}getPadding(){return this.transform.padding}setPadding(t,e){return this.jumpTo({padding:t},e),this}rotateTo(t,e,i){return this.easeTo(y({bearing:t},e),i)}resetNorth(t,e){return this.rotateTo(0,y({duration:1e3},t),e),this}resetNorthPitch(t,e){return this.easeTo(y({bearing:0,pitch:0,duration:1e3},t),e),this}snapToNorth(t,e){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(t,e):this}getPitch(){return this.transform.pitch}setPitch(t,e){return this.jumpTo({pitch:t},e),this}cameraForBounds(t,e){t=mu.convert(t).adjustAntiMeridian();const i=e&&e.bearing||0;return this._cameraForBoxAndBearing(t.getNorthWest(),t.getSouthEast(),i,e)}_cameraForBoxAndBearing(t,e,i,r){const s={top:0,bottom:0,right:0,left:0};if("number"==typeof(r=y({padding:s,offset:[0,0],maxZoom:this.transform.maxZoom},r)).padding){const t=r.padding;r.padding={top:t,bottom:t,right:t,left:t}}r.padding=y(s,r.padding);const n=this.transform,o=n.padding,l=new mu(t,e),c=n.project(l.getNorthWest()),h=n.project(l.getNorthEast()),u=n.project(l.getSouthEast()),p=n.project(l.getSouthWest()),d=D(-i),f=c.rotate(d),m=h.rotate(d),_=u.rotate(d),g=p.rotate(d),x=new a(Math.max(f.x,m.x,g.x,_.x),Math.max(f.y,m.y,g.y,_.y)),v=new a(Math.min(f.x,m.x,g.x,_.x),Math.min(f.y,m.y,g.y,_.y)),b=x.sub(v),w=(n.width-(o.left+o.right+r.padding.left+r.padding.right))/b.x,T=(n.height-(o.top+o.bottom+r.padding.top+r.padding.bottom))/b.y;if(T<0||w<0)return void C("Map cannot fit within canvas with the given bounds, padding, and/or offset.");const S=Math.min(n.scaleZoom(n.scale*Math.min(w,T)),r.maxZoom),I=a.convert(r.offset),A=new a((r.padding.left-r.padding.right)/2,(r.padding.top-r.padding.bottom)/2).rotate(D(i)),E=I.add(A).mult(n.scale/n.zoomScale(S));return{center:n.unproject(c.add(u).div(2).sub(E)),zoom:S,bearing:i}}fitBounds(t,e,i){return this._fitInternal(this.cameraForBounds(t,e),e,i)}fitScreenCoordinates(t,e,i,r,s){return this._fitInternal(this._cameraForBoxAndBearing(this.transform.pointLocation(a.convert(t)),this.transform.pointLocation(a.convert(e)),i,r),r,s)}_fitInternal(t,e,i){return t?(delete(e=y(t,e)).padding,e.linear?this.easeTo(e,i):this.flyTo(e,i)):this}jumpTo(t,e){this.stop();const i=this._getTransformForUpdate();let r=!1,s=!1,n=!1;return"zoom"in t&&i.zoom!==+t.zoom&&(r=!0,i.zoom=+t.zoom),void 0!==t.center&&(i.center=fu.convert(t.center)),"bearing"in t&&i.bearing!==+t.bearing&&(s=!0,i.bearing=+t.bearing),"pitch"in t&&i.pitch!==+t.pitch&&(n=!0,i.pitch=+t.pitch),null==t.padding||i.isPaddingEqual(t.padding)||(i.padding=t.padding),this._applyUpdatedTransform(i),this.fire(new rt("movestart",e)).fire(new rt("move",e)),r&&this.fire(new rt("zoomstart",e)).fire(new rt("zoom",e)).fire(new rt("zoomend",e)),s&&this.fire(new rt("rotatestart",e)).fire(new rt("rotate",e)).fire(new rt("rotateend",e)),n&&this.fire(new rt("pitchstart",e)).fire(new rt("pitch",e)).fire(new rt("pitchend",e)),this.fire(new rt("moveend",e))}calculateCameraOptionsFromTo(t,e,i,r=0){const s=wu.fromLngLat(t,e),n=wu.fromLngLat(i,r),a=n.x-s.x,o=n.y-s.y,l=n.z-s.z,c=Math.hypot(a,o,l);if(0===c)throw new Error("Can't calculate camera options with same From and To");const h=Math.hypot(a,o),u=this.transform.scaleZoom(this.transform.cameraToCenterDistance/c/this.transform.tileSize),p=180*Math.atan2(a,-o)/Math.PI;let d=180*Math.acos(h/c)/Math.PI;return d=l<0?90-d:90+d,{center:n.toLngLat(),zoom:u,pitch:d,bearing:p}}easeTo(t,e){var i;this._stop(!1,t.easeId),(!1===(t=y({offset:[0,0],duration:500,easing:m},t)).animate||!t.essential&&F.prefersReducedMotion)&&(t.duration=0);const r=this._getTransformForUpdate(),s=r.zoom,n=r.bearing,o=r.pitch,l=r.padding,c="bearing"in t?this._normalizeBearing(t.bearing,n):n,h="pitch"in t?+t.pitch:o,u="padding"in t?t.padding:r.padding,p=a.convert(t.offset);let d=r.centerPoint.add(p);const f=r.pointLocation(d),{center:_,zoom:g}=r.getConstrained(fu.convert(t.center||f),null!==(i=t.zoom)&&void 0!==i?i:s);this._normalizeCenter(_,r);const x=r.project(f),v=r.project(_).sub(x),b=r.zoomScale(g-s);let w,T;t.around&&(w=fu.convert(t.around),T=r.locationPoint(w));const S={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching};return this._zooming=this._zooming||g!==s,this._rotating=this._rotating||n!==c,this._pitching=this._pitching||h!==o,this._padding=!r.isPaddingEqual(u),this._easeId=t.easeId,this._prepareEase(e,t.noMoveStart,S),this.terrain&&this._prepareElevation(_),this._ease((i=>{if(this._zooming&&(r.zoom=Ze.number(s,g,i)),this._rotating&&(r.bearing=Ze.number(n,c,i)),this._pitching&&(r.pitch=Ze.number(o,h,i)),this._padding&&(r.interpolatePadding(l,u,i),d=r.centerPoint.add(p)),this.terrain&&!t.freezeElevation&&this._updateElevation(i),w)r.setLocationAtPoint(w,T);else{const t=r.zoomScale(r.zoom-s),e=g>s?Math.min(2,b):Math.max(.5,b),n=Math.pow(e,1-i),a=r.unproject(x.add(v.mult(i*n)).mult(t));r.setLocationAtPoint(r.renderWorldCopies?a.wrap():a,d)}this._applyUpdatedTransform(r),this._fireMoveEvents(e)}),(i=>{this.terrain&&t.freezeElevation&&this._finalizeElevation(),this._afterEase(e,i)}),t),this}_prepareEase(t,e,i={}){this._moving=!0,e||i.moving||this.fire(new rt("movestart",t)),this._zooming&&!i.zooming&&this.fire(new rt("zoomstart",t)),this._rotating&&!i.rotating&&this.fire(new rt("rotatestart",t)),this._pitching&&!i.pitching&&this.fire(new rt("pitchstart",t))}_prepareElevation(t){this._elevationCenter=t,this._elevationStart=this.transform.elevation,this._elevationTarget=this.terrain.getElevationForLngLatZoom(t,this.transform.tileZoom),this._elevationFreeze=!0}_updateElevation(t){this.transform.minElevationForCurrentTile=this.terrain.getMinTileElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);const e=this.terrain.getElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);if(t<1&&e!==this._elevationTarget){const i=this._elevationTarget-this._elevationStart;this._elevationStart+=t*(i-(e-(i*t+this._elevationStart))/(1-t)),this._elevationTarget=e}this.transform.elevation=Ze.number(this._elevationStart,this._elevationTarget,t)}_finalizeElevation(){this._elevationFreeze=!1,this.transform.recalculateZoom(this.terrain)}_getTransformForUpdate(){return this.transformCameraUpdate||this.terrain?(this._requestedCameraState||(this._requestedCameraState=this.transform.clone()),this._requestedCameraState):this.transform}_elevateCameraIfInsideTerrain(t){const e=t.getCameraPosition(),i=this.terrain.getElevationForLngLatZoom(e.lngLat,t.zoom);if(e.altitude<i){const r=this.calculateCameraOptionsFromTo(e.lngLat,i,t.center,t.elevation);return{pitch:r.pitch,zoom:r.zoom}}return{}}_applyUpdatedTransform(t){const e=[];if(this.terrain&&e.push((t=>this._elevateCameraIfInsideTerrain(t))),this.transformCameraUpdate&&e.push((t=>this.transformCameraUpdate(t))),!e.length)return;const i=t.clone();for(const t of e){const e=i.clone(),{center:r,zoom:s,pitch:n,bearing:a,elevation:o}=t(e);r&&(e.center=r),void 0!==s&&(e.zoom=s),void 0!==n&&(e.pitch=n),void 0!==a&&(e.bearing=a),void 0!==o&&(e.elevation=o),i.apply(e)}this.transform.apply(i)}_fireMoveEvents(t){this.fire(new rt("move",t)),this._zooming&&this.fire(new rt("zoom",t)),this._rotating&&this.fire(new rt("rotate",t)),this._pitching&&this.fire(new rt("pitch",t))}_afterEase(t,e){if(this._easeId&&e&&this._easeId===e)return;delete this._easeId;const i=this._zooming,r=this._rotating,s=this._pitching;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._padding=!1,i&&this.fire(new rt("zoomend",t)),r&&this.fire(new rt("rotateend",t)),s&&this.fire(new rt("pitchend",t)),this.fire(new rt("moveend",t))}flyTo(t,e){var i;if(!t.essential&&F.prefersReducedMotion){const i=x(t,["center","zoom","bearing","pitch","around"]);return this.jumpTo(i,e)}this.stop(),t=y({offset:[0,0],speed:1.2,curve:1.42,easing:m},t);const r=this._getTransformForUpdate(),s=r.zoom,n=r.bearing,o=r.pitch,l=r.padding,c="bearing"in t?this._normalizeBearing(t.bearing,n):n,h="pitch"in t?+t.pitch:o,u="padding"in t?t.padding:r.padding,p=a.convert(t.offset);let d=r.centerPoint.add(p);const f=r.pointLocation(d),{center:g,zoom:v}=r.getConstrained(fu.convert(t.center||f),null!==(i=t.zoom)&&void 0!==i?i:s);this._normalizeCenter(g,r);const b=r.zoomScale(v-s),w=r.project(f),T=r.project(g).sub(w);let S=t.curve;const I=Math.max(r.width,r.height),A=I/b,C=T.mag();if("minZoom"in t){const e=_(Math.min(t.minZoom,s,v),r.minZoom,r.maxZoom),i=I/r.zoomScale(e-s);S=Math.sqrt(i/C*2)}const E=S*S;function z(t){const e=(A*A-I*I+(t?-1:1)*E*E*C*C)/(2*(t?A:I)*E*C);return Math.log(Math.sqrt(e*e+1)-e)}function P(t){return(Math.exp(t)-Math.exp(-t))/2}function M(t){return(Math.exp(t)+Math.exp(-t))/2}const k=z(!1);let D=function(t){return M(k)/M(k+S*t)},L=function(t){return I*((M(k)*(P(e=k+S*t)/M(e))-P(k))/E)/C;var e},R=(z(!0)-k)/S;if(Math.abs(C)<1e-6||!isFinite(R)){if(Math.abs(I-A)<1e-6)return this.easeTo(t,e);const i=A<I?-1:1;R=Math.abs(Math.log(A/I))/S,L=()=>0,D=t=>Math.exp(i*S*t)}return t.duration="duration"in t?+t.duration:1e3*R/("screenSpeed"in t?+t.screenSpeed/S:+t.speed),t.maxDuration&&t.duration>t.maxDuration&&(t.duration=0),this._zooming=!0,this._rotating=n!==c,this._pitching=h!==o,this._padding=!r.isPaddingEqual(u),this._prepareEase(e,!1),this.terrain&&this._prepareElevation(g),this._ease((i=>{const a=i*R,f=1/D(a);r.zoom=1===i?v:s+r.scaleZoom(f),this._rotating&&(r.bearing=Ze.number(n,c,i)),this._pitching&&(r.pitch=Ze.number(o,h,i)),this._padding&&(r.interpolatePadding(l,u,i),d=r.centerPoint.add(p)),this.terrain&&!t.freezeElevation&&this._updateElevation(i);const m=1===i?g:r.unproject(w.add(T.mult(L(a))).mult(f));r.setLocationAtPoint(r.renderWorldCopies?m.wrap():m,d),this._applyUpdatedTransform(r),this._fireMoveEvents(e)}),(()=>{this.terrain&&t.freezeElevation&&this._finalizeElevation(),this._afterEase(e)}),t),this}isEasing(){return!!this._easeFrameId}stop(){return this._stop()}_stop(t,e){var i;if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const t=this._onEaseEnd;delete this._onEaseEnd,t.call(this,e)}return t||null===(i=this.handlers)||void 0===i||i.stop(!1),this}_ease(t,e,i){!1===i.animate||0===i.duration?(t(1),e()):(this._easeStart=F.now(),this._easeOptions=i,this._onEaseFrame=t,this._onEaseEnd=e,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback))}_normalizeBearing(t,e){t=g(t,-180,180);const i=Math.abs(t-e);return Math.abs(t-360-e)<i&&(t-=360),Math.abs(t+360-e)<i&&(t+=360),t}_normalizeCenter(t,e){if(!e.renderWorldCopies||e.lngRange)return;const i=t.lng-e.center.lng;t.lng+=i>180?-360:i<-180?360:0}queryTerrainElevation(t){return this.terrain?this.terrain.getElevationForLngLatZoom(fu.convert(t),this.transform.tileZoom)-this.transform.elevation:null}}const v_={compact:!0,customAttribution:'<a href="https://maplibre.org/" target="_blank">MapLibre</a>'};class b_{constructor(t=v_){this._toggleAttribution=()=>{this._container.classList.contains("maplibregl-compact")&&(this._container.classList.contains("maplibregl-compact-show")?(this._container.setAttribute("open",""),this._container.classList.remove("maplibregl-compact-show")):(this._container.classList.add("maplibregl-compact-show"),this._container.removeAttribute("open")))},this._updateData=t=>{!t||"metadata"!==t.sourceDataType&&"visibility"!==t.sourceDataType&&"style"!==t.dataType&&"terrain"!==t.type||this._updateAttributions()},this._updateCompact=()=>{this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1===this._compact?this._container.setAttribute("open",""):this._container.classList.contains("maplibregl-compact")||this._container.classList.contains("maplibregl-attrib-empty")||(this._container.setAttribute("open",""),this._container.classList.add("maplibregl-compact","maplibregl-compact-show")):(this._container.setAttribute("open",""),this._container.classList.contains("maplibregl-compact")&&this._container.classList.remove("maplibregl-compact","maplibregl-compact-show"))},this._updateCompactMinimize=()=>{this._container.classList.contains("maplibregl-compact")&&this._container.classList.contains("maplibregl-compact-show")&&this._container.classList.remove("maplibregl-compact-show")},this.options=t}getDefaultPosition(){return"bottom-right"}onAdd(t){return this._map=t,this._compact=this.options.compact,this._container=O.create("details","maplibregl-ctrl maplibregl-ctrl-attrib"),this._compactButton=O.create("summary","maplibregl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=O.create("div","maplibregl-ctrl-attrib-inner",this._container),this._updateAttributions(),this._updateCompact(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("terrain",this._updateData),this._map.on("resize",this._updateCompact),this._map.on("drag",this._updateCompactMinimize),this._container}onRemove(){O.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("terrain",this._updateData),this._map.off("resize",this._updateCompact),this._map.off("drag",this._updateCompactMinimize),this._map=void 0,this._compact=void 0,this._attribHTML=void 0}_setElementTitle(t,e){const i=this._map._getUIString(`AttributionControl.${e}`);t.title=i,t.setAttribute("aria-label",i)}_updateAttributions(){if(!this._map.style)return;let t=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?t=t.concat(this.options.customAttribution.map((t=>"string"!=typeof t?"":t))):"string"==typeof this.options.customAttribution&&t.push(this.options.customAttribution)),this._map.style.stylesheet){const t=this._map.style.stylesheet;this.styleOwner=t.owner,this.styleId=t.id}const e=this._map.style.sourceCaches;for(const i in e){const r=e[i];if(r.used||r.usedForTerrain){const e=r.getSource();e.attribution&&t.indexOf(e.attribution)<0&&t.push(e.attribution)}}t=t.filter((t=>String(t).trim())),t.sort(((t,e)=>t.length-e.length)),t=t.filter(((e,i)=>{for(let r=i+1;r<t.length;r++)if(t[r].indexOf(e)>=0)return!1;return!0}));const i=t.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,t.length?(this._innerContainer.innerHTML=i,this._container.classList.remove("maplibregl-attrib-empty")):this._container.classList.add("maplibregl-attrib-empty"),this._updateCompact(),this._editLink=null)}}class w_{constructor(t={}){this._updateCompact=()=>{const t=this._container.children;if(t.length){const e=t[0];this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1!==this._compact&&e.classList.add("maplibregl-compact"):e.classList.remove("maplibregl-compact")}},this.options=t}getDefaultPosition(){return"bottom-left"}onAdd(t){this._map=t,this._compact=this.options&&this.options.compact,this._container=O.create("div","maplibregl-ctrl");const e=O.create("a","maplibregl-ctrl-logo");return e.target="_blank",e.rel="noopener nofollow",e.href="https://maplibre.org/",e.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),e.setAttribute("rel","noopener nofollow"),this._container.appendChild(e),this._container.style.display="block",this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){O.remove(this._container),this._map.off("resize",this._updateCompact),this._map=void 0,this._compact=void 0}}class T_{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1}add(t){const e=++this._id;return this._queue.push({callback:t,id:e,cancelled:!1}),e}remove(t){const e=this._currentlyRunning,i=e?this._queue.concat(e):this._queue;for(const e of i)if(e.id===t)return void(e.cancelled=!0)}run(t=0){if(this._currentlyRunning)throw new Error("Attempting to run(), but is already running.");const e=this._currentlyRunning=this._queue;this._queue=[];for(const i of e)if(!i.cancelled&&(i.callback(t),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[]}}var S_;!function(t){t.create="create",t.load="load",t.fullLoad="fullLoad"}(S_||(S_={}));let I_=null,A_=[];const C_=1e3/60,E_="loadTime",z_="fullLoadTime",P_={mark(t){performance.mark(t)},frame(t){const e=t;null!=I_&&A_.push(e-I_),I_=e},clearMetrics(){I_=null,A_=[],performance.clearMeasures(E_),performance.clearMeasures(z_);for(const t in S_)performance.clearMarks(S_[t])},getPerformanceMetrics(){performance.measure(E_,S_.create,S_.load),performance.measure(z_,S_.create,S_.fullLoad);const t=performance.getEntriesByName(E_)[0].duration,e=performance.getEntriesByName(z_)[0].duration,i=A_.length,r=1/(A_.reduce(((t,e)=>t+e),0)/i/1e3),s=A_.filter((t=>t>C_)).reduce(((t,e)=>t+(e-C_)/C_),0);return{loadTime:t,fullLoadTime:e,fps:r,percentDroppedFrames:s/(i+s)*100,totalFrames:i}}};var M_=gn([{name:"a_pos3d",type:"Int16",components:3}]);class k_ extends nt{constructor(t){super(),this.sourceCache=t,this._tiles={},this._renderableTilesKeys=[],this._sourceTileCache={},this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.deltaZoom=1,t.usedForTerrain=!0,t.tileSize=this.tileSize*2**this.deltaZoom}destruct(){this.sourceCache.usedForTerrain=!1,this.sourceCache.tileSize=null}update(t,e){this.sourceCache.update(t,e),this._renderableTilesKeys=[];const i={};for(const r of t.coveringTiles({tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,reparseOverscaled:!1,terrain:e}))i[r.key]=!0,this._renderableTilesKeys.push(r.key),this._tiles[r.key]||(r.posMatrix=new Float64Array(16),Fo(r.posMatrix,0,to,0,to,0,1),this._tiles[r.key]=new Hu(r,this.tileSize));for(const t in this._tiles)i[t]||delete this._tiles[t]}freeRtt(t){for(const e in this._tiles){const i=this._tiles[e];(!t||i.tileID.equals(t)||i.tileID.isChildOf(t)||t.isChildOf(i.tileID))&&(i.rtt=[])}}getRenderableTiles(){return this._renderableTilesKeys.map((t=>this.getTileByID(t)))}getTileByID(t){return this._tiles[t]}getTerrainCoords(t){const e={};for(const i of this._renderableTilesKeys){const r=this._tiles[i].tileID;if(r.canonical.equals(t.canonical)){const r=t.clone();r.posMatrix=new Float64Array(16),Fo(r.posMatrix,0,to,0,to,0,1),e[i]=r}else if(r.canonical.isChildOf(t.canonical)){const s=t.clone();s.posMatrix=new Float64Array(16);const n=r.canonical.z-t.canonical.z,a=r.canonical.x-(r.canonical.x>>n<<n),o=r.canonical.y-(r.canonical.y>>n<<n),l=to>>n;Fo(s.posMatrix,0,l,0,l,0,1),ko(s.posMatrix,s.posMatrix,[-a*l,-o*l,0]),e[i]=s}else if(t.canonical.isChildOf(r.canonical)){const s=t.clone();s.posMatrix=new Float64Array(16);const n=t.canonical.z-r.canonical.z,a=t.canonical.x-(t.canonical.x>>n<<n),o=t.canonical.y-(t.canonical.y>>n<<n),l=to>>n;Fo(s.posMatrix,0,to,0,to,0,1),ko(s.posMatrix,s.posMatrix,[a*l,o*l,0]),Do(s.posMatrix,s.posMatrix,[1/2**n,1/2**n,0]),e[i]=s}}return e}getSourceTile(t,e){const i=this.sourceCache._source;let r=t.overscaledZ-this.deltaZoom;if(r>i.maxzoom&&(r=i.maxzoom),r<i.minzoom)return null;this._sourceTileCache[t.key]||(this._sourceTileCache[t.key]=t.scaledTo(r).key);let s=this.sourceCache.getTileByID(this._sourceTileCache[t.key]);if((!s||!s.dem)&&e)for(;r>=i.minzoom&&(!s||!s.dem);)s=this.sourceCache.getTileByID(t.scaledTo(r--).key);return s}tilesAfterTime(t=Date.now()){return Object.values(this._tiles).filter((e=>e.timeAdded>=t))}}class D_{constructor(t,e,i){this.painter=t,this.sourceCache=new k_(e),this.options=i,this.exaggeration="number"==typeof i.exaggeration?i.exaggeration:1,this.qualityFactor=2,this.meshSize=128,this._demMatrixCache={},this.coordsIndex=[],this._coordsTextureSize=1024}getDEMElevation(t,e,i,r=to){var s;if(!(e>=0&&e<r&&i>=0&&i<r))return 0;const n=this.getTerrainData(t),a=null===(s=n.tile)||void 0===s?void 0:s.dem;if(!a)return 0;const o=function(t,e,i){var r=e[0],s=e[1];return t[0]=i[0]*r+i[4]*s+i[12],t[1]=i[1]*r+i[5]*s+i[13],t}([],[e/r*to,i/r*to],n.u_terrain_matrix),l=[o[0]*a.dim,o[1]*a.dim],c=Math.floor(l[0]),h=Math.floor(l[1]),u=l[0]-c,p=l[1]-h;return a.get(c,h)*(1-u)*(1-p)+a.get(c+1,h)*u*(1-p)+a.get(c,h+1)*(1-u)*p+a.get(c+1,h+1)*u*p}getElevationForLngLatZoom(t,e){if(!function(t,e){const{x:i,y:r}=wu.fromLngLat(e);return!(t<0||t>25||r<0||r>=1||i<0||i>=1)}(e,t.wrap()))return 0;const{tileID:i,mercatorX:r,mercatorY:s}=this._getOverscaledTileIDFromLngLatZoom(t,e);return this.getElevation(i,r%to,s%to,to)}getElevation(t,e,i,r=to){return this.getDEMElevation(t,e,i,r)*this.exaggeration}getTerrainData(t){if(!this._emptyDemTexture){const t=this.painter.context,e=new Qo({width:1,height:1},new Uint8Array(4));this._emptyDepthTexture=new Uh(t,e,t.gl.RGBA,{premultiply:!1}),this._emptyDemUnpack=[0,0,0,0],this._emptyDemTexture=new Uh(t,new Qo({width:1,height:1}),t.gl.RGBA,{premultiply:!1}),this._emptyDemTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._emptyDemMatrix=zo([])}const e=this.sourceCache.getSourceTile(t,!0);if(e&&e.dem&&(!e.demTexture||e.needsTerrainPrepare)){const t=this.painter.context;e.demTexture=this.painter.getTileTexture(e.dem.stride),e.demTexture?e.demTexture.update(e.dem.getPixels(),{premultiply:!1}):e.demTexture=new Uh(t,e.dem.getPixels(),t.gl.RGBA,{premultiply:!1}),e.demTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),e.needsTerrainPrepare=!1}const i=e&&e+e.tileID.key+t.key;if(i&&!this._demMatrixCache[i]){const i=this.sourceCache.sourceCache._source.maxzoom;let r=t.canonical.z-e.tileID.canonical.z;t.overscaledZ>t.canonical.z&&(t.canonical.z>=i?r=t.canonical.z-i:C("cannot calculate elevation if elevation maxzoom > source.maxzoom"));const s=t.canonical.x-(t.canonical.x>>r<<r),n=t.canonical.y-(t.canonical.y>>r<<r),a=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}(new Float64Array(16),[1/(to<<r),1/(to<<r),0]);ko(a,a,[s*to,n*to,0]),this._demMatrixCache[t.key]={matrix:a,coord:t}}return{u_depth:2,u_terrain:3,u_terrain_dim:e&&e.dem&&e.dem.dim||1,u_terrain_matrix:i?this._demMatrixCache[t.key].matrix:this._emptyDemMatrix,u_terrain_unpack:e&&e.dem&&e.dem.getUnpackVector()||this._emptyDemUnpack,u_terrain_exaggeration:this.exaggeration,texture:(e&&e.demTexture||this._emptyDemTexture).texture,depthTexture:(this._fboDepthTexture||this._emptyDepthTexture).texture,tile:e}}getFramebuffer(t){const e=this.painter,i=e.width/devicePixelRatio,r=e.height/devicePixelRatio;return!this._fbo||this._fbo.width===i&&this._fbo.height===r||(this._fbo.destroy(),this._fboCoordsTexture.destroy(),this._fboDepthTexture.destroy(),delete this._fbo,delete this._fboDepthTexture,delete this._fboCoordsTexture),this._fboCoordsTexture||(this._fboCoordsTexture=new Uh(e.context,{width:i,height:r,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboCoordsTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fboDepthTexture||(this._fboDepthTexture=new Uh(e.context,{width:i,height:r,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboDepthTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fbo||(this._fbo=e.context.createFramebuffer(i,r,!0,!1),this._fbo.depthAttachment.set(e.context.createRenderbuffer(e.context.gl.DEPTH_COMPONENT16,i,r))),this._fbo.colorAttachment.set("coords"===t?this._fboCoordsTexture.texture:this._fboDepthTexture.texture),this._fbo}getCoordsTexture(){const t=this.painter.context;if(this._coordsTexture)return this._coordsTexture;const e=new Uint8Array(this._coordsTextureSize*this._coordsTextureSize*4);for(let t=0,i=0;t<this._coordsTextureSize;t++)for(let r=0;r<this._coordsTextureSize;r++,i+=4)e[i+0]=255&r,e[i+1]=255&t,e[i+2]=r>>8<<4|t>>8,e[i+3]=0;const i=new Qo({width:this._coordsTextureSize,height:this._coordsTextureSize},new Uint8Array(e.buffer)),r=new Uh(t,i,t.gl.RGBA,{premultiply:!1});return r.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._coordsTexture=r,r}pointCoordinate(t){this.painter.maybeDrawDepthAndCoords(!0);const e=new Uint8Array(4),i=this.painter.context,r=i.gl,s=Math.round(t.x*this.painter.pixelRatio/devicePixelRatio),n=Math.round(t.y*this.painter.pixelRatio/devicePixelRatio),a=Math.round(this.painter.height/devicePixelRatio);i.bindFramebuffer.set(this.getFramebuffer("coords").framebuffer),r.readPixels(s,a-n-1,1,1,r.RGBA,r.UNSIGNED_BYTE,e),i.bindFramebuffer.set(null);const o=e[0]+(e[2]>>4<<8),l=e[1]+((15&e[2])<<8),c=this.coordsIndex[255-e[3]],h=c&&this.sourceCache.getTileByID(c);if(!h)return null;const u=this._coordsTextureSize,p=(1<<h.tileID.canonical.z)*u;return new wu((h.tileID.canonical.x*u+o)/p+h.tileID.wrap,(h.tileID.canonical.y*u+l)/p,this.getElevation(h.tileID,o,l,u))}depthAtPoint(t){const e=new Uint8Array(4),i=this.painter.context,r=i.gl;return i.bindFramebuffer.set(this.getFramebuffer("depth").framebuffer),r.readPixels(t.x,this.painter.height/devicePixelRatio-t.y-1,1,1,r.RGBA,r.UNSIGNED_BYTE,e),i.bindFramebuffer.set(null),(e[0]/16777216+e[1]/65536+e[2]/256+e[3])/256}getTerrainMesh(){if(this._mesh)return this._mesh;const t=this.painter.context,e=new ea,i=new _a,r=this.meshSize,s=to/r,n=r*r;for(let t=0;t<=r;t++)for(let i=0;i<=r;i++)e.emplaceBack(i*s,t*s,0);for(let t=0;t<n;t+=r+1)for(let e=0;e<r;e++)i.emplaceBack(e+t,r+e+t+1,r+e+t+2),i.emplaceBack(e+t,r+e+t+2,e+t+1);const a=e.length,o=a+2*(r+1);for(const t of[0,1])for(let i=0;i<=r;i++)for(const r of[0,1])e.emplaceBack(i*s,t*to,r);for(let t=0;t<2*r;t+=2)i.emplaceBack(o+t,o+t+1,o+t+3),i.emplaceBack(o+t,o+t+3,o+t+2),i.emplaceBack(a+t,a+t+3,a+t+1),i.emplaceBack(a+t,a+t+2,a+t+3);const l=e.length,c=l+2*(r+1);for(const t of[0,1])for(let i=0;i<=r;i++)for(const r of[0,1])e.emplaceBack(t*to,i*s,r);for(let t=0;t<2*r;t+=2)i.emplaceBack(l+t,l+t+1,l+t+3),i.emplaceBack(l+t,l+t+3,l+t+2),i.emplaceBack(c+t,c+t+3,c+t+1),i.emplaceBack(c+t,c+t+2,c+t+3);return this._mesh=new dm(t.createVertexBuffer(e,M_.members),t.createIndexBuffer(i),ba.simpleSegment(0,0,e.length,i.length)),this._mesh}getMeshFrameDelta(t){return 2*Math.PI*du/Math.pow(2,t)/5}getMinTileElevationForLngLatZoom(t,e){var i;const{tileID:r}=this._getOverscaledTileIDFromLngLatZoom(t,e);return null!==(i=this.getMinMaxElevation(r).minElevation)&&void 0!==i?i:0}getMinMaxElevation(t){const e=this.getTerrainData(t).tile,i={minElevation:null,maxElevation:null};return e&&e.dem&&(i.minElevation=e.dem.min*this.exaggeration,i.maxElevation=e.dem.max*this.exaggeration),i}_getOverscaledTileIDFromLngLatZoom(t,e){const i=wu.fromLngLat(t.wrap()),r=(1<<e)*to,s=i.x*r,n=i.y*r,a=Math.floor(s/to),o=Math.floor(n/to);return{tileID:new zu(e,0,e,a,o),mercatorX:s,mercatorY:n}}}class L_{constructor(t,e,i){this._context=t,this._size=e,this._tileSize=i,this._objects=[],this._recentlyUsed=[],this._stamp=0}destruct(){for(const t of this._objects)t.texture.destroy(),t.fbo.destroy()}_createObject(t){const e=this._context.createFramebuffer(this._tileSize,this._tileSize,!0,!0),i=new Uh(this._context,{width:this._tileSize,height:this._tileSize,data:null},this._context.gl.RGBA);return i.bind(this._context.gl.LINEAR,this._context.gl.CLAMP_TO_EDGE),e.depthAttachment.set(this._context.createRenderbuffer(this._context.gl.DEPTH_STENCIL,this._tileSize,this._tileSize)),e.colorAttachment.set(i.texture),{id:t,fbo:e,texture:i,stamp:-1,inUse:!1}}getObjectForId(t){return this._objects[t]}useObject(t){t.inUse=!0,this._recentlyUsed=this._recentlyUsed.filter((e=>t.id!==e)),this._recentlyUsed.push(t.id)}stampObject(t){t.stamp=++this._stamp}getOrCreateFreeObject(){for(const t of this._recentlyUsed)if(!this._objects[t].inUse)return this._objects[t];if(this._objects.length>=this._size)throw new Error("No free RenderPool available, call freeAllObjects() required!");const t=this._createObject(this._objects.length);return this._objects.push(t),t}freeObject(t){t.inUse=!1}freeAllObjects(){for(const t of this._objects)this.freeObject(t)}isFull(){return!(this._objects.length<this._size)&&!1===this._objects.some((t=>!t.inUse))}}const R_={background:!0,fill:!0,line:!0,raster:!0,hillshade:!0};class B_{constructor(t,e){this.painter=t,this.terrain=e,this.pool=new L_(t.context,30,e.sourceCache.tileSize*e.qualityFactor)}destruct(){this.pool.destruct()}getTexture(t){return this.pool.getObjectForId(t.rtt[this._stacks.length-1].id).texture}prepareForRender(t,e){this._stacks=[],this._prevType=null,this._rttTiles=[],this._renderableTiles=this.terrain.sourceCache.getRenderableTiles(),this._renderableLayerIds=t._order.filter((i=>!t._layers[i].isHidden(e))),this._coordsDescendingInv={};for(const e in t.sourceCaches){this._coordsDescendingInv[e]={};const i=t.sourceCaches[e].getVisibleCoordinates();for(const t of i){const i=this.terrain.sourceCache.getTerrainCoords(t);for(const t in i)this._coordsDescendingInv[e][t]||(this._coordsDescendingInv[e][t]=[]),this._coordsDescendingInv[e][t].push(i[t])}}this._coordsDescendingInvStr={};for(const e of t._order){const i=t._layers[e],r=i.source;if(R_[i.type]&&!this._coordsDescendingInvStr[r]){this._coordsDescendingInvStr[r]={};for(const t in this._coordsDescendingInv[r])this._coordsDescendingInvStr[r][t]=this._coordsDescendingInv[r][t].map((t=>t.key)).sort().join()}}for(const t of this._renderableTiles)for(const e in this._coordsDescendingInvStr){const i=this._coordsDescendingInvStr[e][t.tileID.key];i&&i!==t.rttCoords[e]&&(t.rtt=[])}}renderLayer(t){if(t.isHidden(this.painter.transform.zoom))return!1;const e=t.type,i=this.painter,r=this._renderableLayerIds[this._renderableLayerIds.length-1]===t.id;if(R_[e]&&(this._prevType&&R_[this._prevType]||this._stacks.push([]),this._prevType=e,this._stacks[this._stacks.length-1].push(t.id),!r))return!0;if(R_[this._prevType]||R_[e]&&r){this._prevType=e;const t=this._stacks.length-1,r=this._stacks[t]||[];for(const e of this._renderableTiles){if(this.pool.isFull()&&(pm(this.painter,this.terrain,this._rttTiles),this._rttTiles=[],this.pool.freeAllObjects()),this._rttTiles.push(e),e.rtt[t]){const i=this.pool.getObjectForId(e.rtt[t].id);if(i.stamp===e.rtt[t].stamp){this.pool.useObject(i);continue}}const s=this.pool.getOrCreateFreeObject();this.pool.useObject(s),this.pool.stampObject(s),e.rtt[t]={id:s.id,stamp:s.stamp},i.context.bindFramebuffer.set(s.fbo.framebuffer),i.context.clear({color:le.transparent,stencil:0}),i.currentStencilSource=void 0;for(let t=0;t<r.length;t++){const n=i.style._layers[r[t]],a=n.source?this._coordsDescendingInv[n.source][e.tileID.key]:[e.tileID];i.context.viewport.set([0,0,s.fbo.width,s.fbo.height]),i._renderTileClippingMasks(n,a),i.renderLayer(i,i.style.sourceCaches[n.source],n,a),n.source&&(e.rttCoords[n.source]=this._coordsDescendingInvStr[n.source][e.tileID.key])}}return pm(this.painter,this.terrain,this._rttTiles),this._rttTiles=[],this.pool.freeAllObjects(),R_[e]}return!1}}const F_={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"MapLibre logo","Map.Title":"Map","Marker.Title":"Map marker","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","Popup.Close":"Close popup","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","TerrainControl.Enable":"Enable terrain","TerrainControl.Disable":"Disable terrain","CooperativeGesturesHandler.WindowsHelpText":"Use Ctrl + scroll to zoom the map","CooperativeGesturesHandler.MacHelpText":"Use ⌘ + scroll to zoom the map","CooperativeGesturesHandler.MobileHelpText":"Use two fingers to move the map"},O_=e,V_={hash:!1,interactive:!0,bearingSnap:7,attributionControl:v_,maplibreLogo:!1,failIfMajorPerformanceCaveat:!1,preserveDrawingBuffer:!1,refreshExpiredTiles:!0,scrollZoom:!0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:60,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,trackResize:!0,center:[0,0],zoom:0,bearing:0,pitch:0,renderWorldCopies:!0,maxTileCacheSize:null,maxTileCacheZoomLevels:V.MAX_TILE_CACHE_ZOOM_LEVELS,transformRequest:null,transformCameraUpdate:null,fadeDuration:300,crossSourceCollisions:!0,clickTolerance:3,localIdeographFontFamily:"sans-serif",pitchWithRotate:!0,validateStyle:!0,maxCanvasSize:[4096,4096],cancelPendingTileRequestsWhileZooming:!0},U_=t=>{t.touchstart=t.dragStart,t.touchmoveWindow=t.dragMove,t.touchend=t.dragEnd},N_={showCompass:!0,showZoom:!0,visualizePitch:!1};class j_{constructor(t,e,i=!1){this.mousedown=t=>{this.startMouse(y({},t,{ctrlKey:!0,preventDefault:()=>t.preventDefault()}),O.mousePos(this.element,t)),O.addEventListener(window,"mousemove",this.mousemove),O.addEventListener(window,"mouseup",this.mouseup)},this.mousemove=t=>{this.moveMouse(t,O.mousePos(this.element,t))},this.mouseup=t=>{this.mouseRotate.dragEnd(t),this.mousePitch&&this.mousePitch.dragEnd(t),this.offTemp()},this.touchstart=t=>{1!==t.targetTouches.length?this.reset():(this._startPos=this._lastPos=O.touchPos(this.element,t.targetTouches)[0],this.startTouch(t,this._startPos),O.addEventListener(window,"touchmove",this.touchmove,{passive:!1}),O.addEventListener(window,"touchend",this.touchend))},this.touchmove=t=>{1!==t.targetTouches.length?this.reset():(this._lastPos=O.touchPos(this.element,t.targetTouches)[0],this.moveTouch(t,this._lastPos))},this.touchend=t=>{0===t.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),delete this._startPos,delete this._lastPos,this.offTemp()},this.reset=()=>{this.mouseRotate.reset(),this.mousePitch&&this.mousePitch.reset(),this.touchRotate.reset(),this.touchPitch&&this.touchPitch.reset(),delete this._startPos,delete this._lastPos,this.offTemp()},this._clickTolerance=10;const r=t.dragRotate._mouseRotate.getClickTolerance(),s=t.dragRotate._mousePitch.getClickTolerance();this.element=e,this.mouseRotate=Gm({clickTolerance:r,enable:!0}),this.touchRotate=(({enable:t,clickTolerance:e,bearingDegreesPerPixelMoved:i=.8})=>{const r=new qm;return new Nm({clickTolerance:e,move:(t,e)=>({bearingDelta:(e.x-t.x)*i}),moveStateManager:r,enable:t,assignEvents:U_})})({clickTolerance:r,enable:!0}),this.map=t,i&&(this.mousePitch=Wm({clickTolerance:s,enable:!0}),this.touchPitch=(({enable:t,clickTolerance:e,pitchDegreesPerPixelMoved:i=-.5})=>{const r=new qm;return new Nm({clickTolerance:e,move:(t,e)=>({pitchDelta:(e.y-t.y)*i}),moveStateManager:r,enable:t,assignEvents:U_})})({clickTolerance:s,enable:!0})),O.addEventListener(e,"mousedown",this.mousedown),O.addEventListener(e,"touchstart",this.touchstart,{passive:!1}),O.addEventListener(e,"touchcancel",this.reset)}startMouse(t,e){this.mouseRotate.dragStart(t,e),this.mousePitch&&this.mousePitch.dragStart(t,e),O.disableDrag()}startTouch(t,e){this.touchRotate.dragStart(t,e),this.touchPitch&&this.touchPitch.dragStart(t,e),O.disableDrag()}moveMouse(t,e){const i=this.map,{bearingDelta:r}=this.mouseRotate.dragMove(t,e)||{};if(r&&i.setBearing(i.getBearing()+r),this.mousePitch){const{pitchDelta:r}=this.mousePitch.dragMove(t,e)||{};r&&i.setPitch(i.getPitch()+r)}}moveTouch(t,e){const i=this.map,{bearingDelta:r}=this.touchRotate.dragMove(t,e)||{};if(r&&i.setBearing(i.getBearing()+r),this.touchPitch){const{pitchDelta:r}=this.touchPitch.dragMove(t,e)||{};r&&i.setPitch(i.getPitch()+r)}}off(){const t=this.element;O.removeEventListener(t,"mousedown",this.mousedown),O.removeEventListener(t,"touchstart",this.touchstart,{passive:!1}),O.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),O.removeEventListener(window,"touchend",this.touchend),O.removeEventListener(t,"touchcancel",this.reset),this.offTemp()}offTemp(){O.enableDrag(),O.removeEventListener(window,"mousemove",this.mousemove),O.removeEventListener(window,"mouseup",this.mouseup),O.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),O.removeEventListener(window,"touchend",this.touchend)}}let $_;function q_(t,e,i){const r=new fu(t.lng,t.lat);if(t=new fu(t.lng,t.lat),e){const r=new fu(t.lng-360,t.lat),s=new fu(t.lng+360,t.lat),n=i.locationPoint(t).distSqr(e);i.locationPoint(r).distSqr(e)<n?t=r:i.locationPoint(s).distSqr(e)<n&&(t=s)}for(;Math.abs(t.lng-i.center.lng)>180;){const e=i.locationPoint(t);if(e.x>=0&&e.y>=0&&e.x<=i.width&&e.y<=i.height)break;t.lng>i.center.lng?t.lng-=360:t.lng+=360}return t.lng!==r.lng&&i.locationPoint(t).y>i.height/2-i.getHorizon()?t:r}const Z_={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function G_(t,e,i){const r=t.classList;for(const t in Z_)r.remove(`maplibregl-${i}-anchor-${t}`);r.add(`maplibregl-${i}-anchor-${e}`)}class W_ extends nt{constructor(t){if(super(),this._onKeyPress=t=>{const e=t.code,i=t.charCode||t.keyCode;"Space"!==e&&"Enter"!==e&&32!==i&&13!==i||this.togglePopup()},this._onMapClick=t=>{const e=t.originalEvent.target,i=this._element;this._popup&&(e===i||i.contains(e))&&this.togglePopup()},this._update=t=>{var e;if(!this._map)return;const i=this._map.loaded()&&!this._map.isMoving();("terrain"===(null==t?void 0:t.type)||"render"===(null==t?void 0:t.type)&&!i)&&this._map.once("render",this._update),this._lngLat=this._map.transform.renderWorldCopies?q_(this._lngLat,this._flatPos,this._map.transform):null===(e=this._lngLat)||void 0===e?void 0:e.wrap(),this._flatPos=this._pos=this._map.project(this._lngLat)._add(this._offset),this._map.terrain&&(this._flatPos=this._map.transform.locationPoint(this._lngLat)._add(this._offset));let r="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?r=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(r=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let s="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?s="rotateX(0deg)":"map"===this._pitchAlignment&&(s=`rotateX(${this._map.getPitch()}deg)`),this._subpixelPositioning||t&&"moveend"!==t.type||(this._pos=this._pos.round()),O.setTransform(this._element,`${Z_[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${s} ${r}`),F.frameAsync(new AbortController).then((()=>{this._updateOpacity(t&&"moveend"===t.type)})).catch((()=>{}))},this._onMove=t=>{if(!this._isDragging){const e=this._clickTolerance||this._map._clickTolerance;this._isDragging=t.point.dist(this._pointerdownPos)>=e}this._isDragging&&(this._pos=t.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new rt("dragstart"))),this.fire(new rt("drag")))},this._onUp=()=>{this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new rt("dragend")),this._state="inactive"},this._addDragHandler=t=>{this._element.contains(t.originalEvent.target)&&(t.preventDefault(),this._positionDelta=t.point.sub(this._pos).add(this._offset),this._pointerdownPos=t.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp))},this._anchor=t&&t.anchor||"center",this._color=t&&t.color||"#3FB1CE",this._scale=t&&t.scale||1,this._draggable=t&&t.draggable||!1,this._clickTolerance=t&&t.clickTolerance||0,this._subpixelPositioning=t&&t.subpixelPositioning||!1,this._isDragging=!1,this._state="inactive",this._rotation=t&&t.rotation||0,this._rotationAlignment=t&&t.rotationAlignment||"auto",this._pitchAlignment=t&&t.pitchAlignment&&"auto"!==t.pitchAlignment?t.pitchAlignment:this._rotationAlignment,this.setOpacity(),this.setOpacity(null==t?void 0:t.opacity,null==t?void 0:t.opacityWhenCovered),t&&t.element)this._element=t.element,this._offset=a.convert(t&&t.offset||[0,0]);else{this._defaultMarker=!0,this._element=O.create("div");const e=O.createNS("http://www.w3.org/2000/svg","svg"),i=41,r=27;e.setAttributeNS(null,"display","block"),e.setAttributeNS(null,"height",`${i}px`),e.setAttributeNS(null,"width",`${r}px`),e.setAttributeNS(null,"viewBox",`0 0 ${r} ${i}`);const s=O.createNS("http://www.w3.org/2000/svg","g");s.setAttributeNS(null,"stroke","none"),s.setAttributeNS(null,"stroke-width","1"),s.setAttributeNS(null,"fill","none"),s.setAttributeNS(null,"fill-rule","evenodd");const n=O.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"fill-rule","nonzero");const o=O.createNS("http://www.w3.org/2000/svg","g");o.setAttributeNS(null,"transform","translate(3.0, 29.0)"),o.setAttributeNS(null,"fill","#000000");const l=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const t of l){const e=O.createNS("http://www.w3.org/2000/svg","ellipse");e.setAttributeNS(null,"opacity","0.04"),e.setAttributeNS(null,"cx","10.5"),e.setAttributeNS(null,"cy","5.80029008"),e.setAttributeNS(null,"rx",t.rx),e.setAttributeNS(null,"ry",t.ry),o.appendChild(e)}const c=O.createNS("http://www.w3.org/2000/svg","g");c.setAttributeNS(null,"fill",this._color);const h=O.createNS("http://www.w3.org/2000/svg","path");h.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),c.appendChild(h);const u=O.createNS("http://www.w3.org/2000/svg","g");u.setAttributeNS(null,"opacity","0.25"),u.setAttributeNS(null,"fill","#000000");const p=O.createNS("http://www.w3.org/2000/svg","path");p.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),u.appendChild(p);const d=O.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"transform","translate(6.0, 7.0)"),d.setAttributeNS(null,"fill","#FFFFFF");const f=O.createNS("http://www.w3.org/2000/svg","g");f.setAttributeNS(null,"transform","translate(8.0, 8.0)");const m=O.createNS("http://www.w3.org/2000/svg","circle");m.setAttributeNS(null,"fill","#000000"),m.setAttributeNS(null,"opacity","0.25"),m.setAttributeNS(null,"cx","5.5"),m.setAttributeNS(null,"cy","5.5"),m.setAttributeNS(null,"r","5.4999962");const _=O.createNS("http://www.w3.org/2000/svg","circle");_.setAttributeNS(null,"fill","#FFFFFF"),_.setAttributeNS(null,"cx","5.5"),_.setAttributeNS(null,"cy","5.5"),_.setAttributeNS(null,"r","5.4999962"),f.appendChild(m),f.appendChild(_),n.appendChild(o),n.appendChild(c),n.appendChild(u),n.appendChild(d),n.appendChild(f),e.appendChild(n),e.setAttributeNS(null,"height",i*this._scale+"px"),e.setAttributeNS(null,"width",r*this._scale+"px"),this._element.appendChild(e),this._offset=a.convert(t&&t.offset||[0,-14])}if(this._element.classList.add("maplibregl-marker"),this._element.addEventListener("dragstart",(t=>{t.preventDefault()})),this._element.addEventListener("mousedown",(t=>{t.preventDefault()})),G_(this._element,this._anchor,"marker"),t&&t.className)for(const e of t.className.split(" "))this._element.classList.add(e);this._popup=null}addTo(t){return this.remove(),this._map=t,this._element.setAttribute("aria-label",t._getUIString("Marker.Title")),t.getCanvasContainer().appendChild(this._element),t.on("move",this._update),t.on("moveend",this._update),t.on("terrain",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._opacityTimeout&&(clearTimeout(this._opacityTimeout),delete this._opacityTimeout),this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("terrain",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),O.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=fu.convert(t),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(t){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),t){if(!("offset"in t.options)){const e=38.1,i=13.5,r=Math.abs(i)/Math.SQRT2;t.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-e],"bottom-left":[r,-1*(e-i+r)],"bottom-right":[-r,-1*(e-i+r)],left:[i,-1*(e-i)],right:[-i,-1*(e-i)]}:this._offset}this._popup=t,this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress)}return this}setSubpixelPositioning(t){return this._subpixelPositioning=t,this}getPopup(){return this._popup}togglePopup(){const t=this._popup;return this._element.style.opacity===this._opacityWhenCovered?this:t?(t.isOpen()?t.remove():(t.setLngLat(this._lngLat),t.addTo(this._map)),this):this}_updateOpacity(t=!1){var e,i;if(!(null===(e=this._map)||void 0===e?void 0:e.terrain))return void(this._element.style.opacity!==this._opacity&&(this._element.style.opacity=this._opacity));if(t)this._opacityTimeout=null;else{if(this._opacityTimeout)return;this._opacityTimeout=setTimeout((()=>{this._opacityTimeout=null}),100)}const r=this._map,s=r.terrain.depthAtPoint(this._pos),n=r.terrain.getElevationForLngLatZoom(this._lngLat,r.transform.tileZoom);if(r.transform.lngLatToCameraDepth(this._lngLat,n)-s<.006)return void(this._element.style.opacity=this._opacity);const o=-this._offset.y/r.transform._pixelPerMeter,l=Math.sin(r.getPitch()*Math.PI/180)*o,c=r.terrain.depthAtPoint(new a(this._pos.x,this._pos.y-this._offset.y)),h=r.transform.lngLatToCameraDepth(this._lngLat,n+l)-c>.006;(null===(i=this._popup)||void 0===i?void 0:i.isOpen())&&h&&this._popup.remove(),this._element.style.opacity=h?this._opacityWhenCovered:this._opacity}getOffset(){return this._offset}setOffset(t){return this._offset=a.convert(t),this._update(),this}addClassName(t){this._element.classList.add(t)}removeClassName(t){this._element.classList.remove(t)}toggleClassName(t){return this._element.classList.toggle(t)}setDraggable(t){return this._draggable=!!t,this._map&&(t?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(t){return this._rotation=t||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(t){return this._rotationAlignment=t||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(t){return this._pitchAlignment=t&&"auto"!==t?t:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}setOpacity(t,e){return void 0===t&&void 0===e&&(this._opacity="1",this._opacityWhenCovered="0.2"),void 0!==t&&(this._opacity=t),void 0!==e&&(this._opacityWhenCovered=e),this._map&&this._updateOpacity(!0),this}}const H_={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let X_=0,K_=!1;const Y_={maxWidth:100,unit:"metric"};function J_(t,e,i){const r=i&&i.maxWidth||100,s=t._container.clientHeight/2,n=t.unproject([0,s]),a=t.unproject([r,s]),o=n.distanceTo(a);if(i&&"imperial"===i.unit){const i=3.2808*o;i>5280?Q_(e,r,i/5280,t._getUIString("ScaleControl.Miles")):Q_(e,r,i,t._getUIString("ScaleControl.Feet"))}else i&&"nautical"===i.unit?Q_(e,r,o/1852,t._getUIString("ScaleControl.NauticalMiles")):o>=1e3?Q_(e,r,o/1e3,t._getUIString("ScaleControl.Kilometers")):Q_(e,r,o,t._getUIString("ScaleControl.Meters"))}function Q_(t,e,i,r){const s=function(t){const e=Math.pow(10,`${Math.floor(t)}`.length-1);let i=t/e;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(t){const e=Math.pow(10,Math.ceil(-Math.log(t)/Math.LN10));return Math.round(t*e)/e}(i),e*i}(i);t.style.width=e*(s/i)+"px",t.innerHTML=`${s}&nbsp;${r}`}const tg={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px",subpixelPositioning:!1},eg=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function ig(t){if(t){if("number"==typeof t){const e=Math.round(Math.abs(t)/Math.SQRT2);return{center:new a(0,0),top:new a(0,t),"top-left":new a(e,e),"top-right":new a(-e,e),bottom:new a(0,-t),"bottom-left":new a(e,-e),"bottom-right":new a(-e,-e),left:new a(t,0),right:new a(-t,0)}}if(t instanceof a||Array.isArray(t)){const e=a.convert(t);return{center:e,top:e,"top-left":e,"top-right":e,bottom:e,"bottom-left":e,"bottom-right":e,left:e,right:e}}return{center:a.convert(t.center||[0,0]),top:a.convert(t.top||[0,0]),"top-left":a.convert(t["top-left"]||[0,0]),"top-right":a.convert(t["top-right"]||[0,0]),bottom:a.convert(t.bottom||[0,0]),"bottom-left":a.convert(t["bottom-left"]||[0,0]),"bottom-right":a.convert(t["bottom-right"]||[0,0]),left:a.convert(t.left||[0,0]),right:a.convert(t.right||[0,0])}}return ig(new a(0,0))}const rg=e;t.AJAXError=j,t.AttributionControl=b_,t.BoxZoomHandler=Bm,t.CanvasSource=Bu,t.CooperativeGesturesHandler=f_,t.DoubleClickZoomHandler=l_,t.DragPanHandler=u_,t.DragRotateHandler=p_,t.EdgeInsets=gm,t.Evented=nt,t.FullscreenControl=class extends nt{constructor(t={}){super(),this._onFullscreenChange=()=>{var t;let e=window.document.fullscreenElement||window.document.mozFullScreenElement||window.document.webkitFullscreenElement||window.document.msFullscreenElement;for(;null===(t=null==e?void 0:e.shadowRoot)||void 0===t?void 0:t.fullscreenElement;)e=e.shadowRoot.fullscreenElement;e===this._container!==this._fullscreen&&this._handleFullscreenChange()},this._onClickFullscreen=()=>{this._isFullscreen()?this._exitFullscreen():this._requestFullscreen()},this._fullscreen=!1,t&&t.container&&(t.container instanceof HTMLElement?this._container=t.container:C("Full screen control 'container' must be a DOM element.")),"onfullscreenchange"in document?this._fullscreenchange="fullscreenchange":"onmozfullscreenchange"in document?this._fullscreenchange="mozfullscreenchange":"onwebkitfullscreenchange"in document?this._fullscreenchange="webkitfullscreenchange":"onmsfullscreenchange"in document&&(this._fullscreenchange="MSFullscreenChange")}onAdd(t){return this._map=t,this._container||(this._container=this._map.getContainer()),this._controlContainer=O.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),this._controlContainer}onRemove(){O.remove(this._controlContainer),this._map=null,window.document.removeEventListener(this._fullscreenchange,this._onFullscreenChange)}_setupUI(){const t=this._fullscreenButton=O.create("button","maplibregl-ctrl-fullscreen",this._controlContainer);O.create("span","maplibregl-ctrl-icon",t).setAttribute("aria-hidden","true"),t.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),window.document.addEventListener(this._fullscreenchange,this._onFullscreenChange)}_updateTitle(){const t=this._getTitle();this._fullscreenButton.setAttribute("aria-label",t),this._fullscreenButton.title=t}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_handleFullscreenChange(){this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("maplibregl-ctrl-shrink"),this._fullscreenButton.classList.toggle("maplibregl-ctrl-fullscreen"),this._updateTitle(),this._fullscreen?(this.fire(new rt("fullscreenstart")),this._prevCooperativeGesturesEnabled=this._map.cooperativeGestures.isEnabled(),this._map.cooperativeGestures.disable()):(this.fire(new rt("fullscreenend")),this._prevCooperativeGesturesEnabled&&this._map.cooperativeGestures.enable())}_exitFullscreen(){window.document.exitFullscreen?window.document.exitFullscreen():window.document.mozCancelFullScreen?window.document.mozCancelFullScreen():window.document.msExitFullscreen?window.document.msExitFullscreen():window.document.webkitCancelFullScreen?window.document.webkitCancelFullScreen():this._togglePseudoFullScreen()}_requestFullscreen(){this._container.requestFullscreen?this._container.requestFullscreen():this._container.mozRequestFullScreen?this._container.mozRequestFullScreen():this._container.msRequestFullscreen?this._container.msRequestFullscreen():this._container.webkitRequestFullscreen?this._container.webkitRequestFullscreen():this._togglePseudoFullScreen()}_togglePseudoFullScreen(){this._container.classList.toggle("maplibregl-pseudo-fullscreen"),this._handleFullscreenChange(),this._map.resize()}},t.GeoJSONSource=ku,t.GeolocateControl=class extends nt{constructor(t){super(),this._onSuccess=t=>{if(this._map){if(this._isOutOfMapMaxBounds(t))return this._setErrorState(),this.fire(new rt("outofmaxbounds",t)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=t,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background");break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(t),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(t),this.options.showUserLocation&&this._dotElement.classList.remove("maplibregl-user-location-dot-stale"),this.fire(new rt("geolocate",t)),this._finish()}},this._updateCamera=t=>{const e=new fu(t.coords.longitude,t.coords.latitude),i=t.coords.accuracy,r=y({bearing:this._map.getBearing()},this.options.fitBoundsOptions),s=mu.fromLngLat(e,i);this._map.fitBounds(s,r,{geolocateSource:!0})},this._updateMarker=t=>{if(t){const e=new fu(t.coords.longitude,t.coords.latitude);this._accuracyCircleMarker.setLngLat(e).addTo(this._map),this._userLocationDotMarker.setLngLat(e).addTo(this._map),this._accuracy=t.coords.accuracy,this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius()}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove()},this._onZoom=()=>{this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius()},this._onError=t=>{if(this._map){if(this.options.trackUserLocation)if(1===t.code){this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t),void 0!==this._geolocationWatchID&&this._clearWatch()}else{if(3===t.code&&K_)return;this._setErrorState()}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("maplibregl-user-location-dot-stale"),this.fire(new rt("error",t)),this._finish()}},this._finish=()=>{this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0},this._setupUI=()=>{this._map&&(this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this._geolocateButton=O.create("button","maplibregl-ctrl-geolocate",this._container),O.create("span","maplibregl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",this._geolocateButton.disabled=!0)},this._finishSetupUI=t=>{if(this._map){if(!1===t){C("Geolocation support is not available so the GeolocateControl will be disabled.");const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t)}else{const t=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.disabled=!1,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t)}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=O.create("div","maplibregl-user-location-dot"),this._userLocationDotMarker=new W_({element:this._dotElement}),this._circleElement=O.create("div","maplibregl-user-location-accuracy-circle"),this._accuracyCircleMarker=new W_({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onZoom)),this._geolocateButton.addEventListener("click",(()=>this.trigger())),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(t=>{t.geolocateSource||"ACTIVE_LOCK"!==this._watchState||t.originalEvent&&"resize"===t.originalEvent.type||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this.fire(new rt("trackuserlocationend")),this.fire(new rt("userlocationlostfocus")))}))}},this.options=y({},H_,t)}onAdd(t){return this._map=t,this._container=O.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),function(){return i(this,arguments,void 0,(function*(t=!1){if(void 0!==$_&&!t)return $_;if(void 0===window.navigator.permissions)return $_=!!window.navigator.geolocation,$_;try{const t=yield window.navigator.permissions.query({name:"geolocation"});$_="denied"!==t.state}catch(t){$_=!!window.navigator.geolocation}return $_}))}().then((t=>this._finishSetupUI(t))),this._container}onRemove(){void 0!==this._geolocationWatchID&&(window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),O.remove(this._container),this._map.off("zoom",this._onZoom),this._map=void 0,X_=0,K_=!1}_isOutOfMapMaxBounds(t){const e=this._map.getMaxBounds(),i=t.coords;return e&&(i.longitude<e.getWest()||i.longitude>e.getEast()||i.latitude<e.getSouth()||i.latitude>e.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"ACTIVE_ERROR":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}}_updateCircleRadius(){const t=this._map.getBounds(),e=t.getSouthEast(),i=t.getNorthEast(),r=e.distanceTo(i),s=Math.ceil(this._accuracy/(r/this._map._container.clientHeight)*2);this._circleElement.style.width=`${s}px`,this._circleElement.style.height=`${s}px`}trigger(){if(!this._setup)return C("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new rt("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":X_--,K_=!1,this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this.fire(new rt("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new rt("trackuserlocationstart")),this.fire(new rt("userlocationfocus"));break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"OFF":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let t;this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),X_++,X_>1?(t={maximumAge:6e5,timeout:0},K_=!0):(t=this.options.positionOptions,K_=!1),this._geolocationWatchID=window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,t)}}else window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return!0}_clearWatch(){window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null)}},t.Hash=bm,t.ImageSource=Lu,t.KeyboardHandler=s_,t.LngLat=fu,t.LngLatBounds=mu,t.LogoControl=w_,t.Map=class extends x_{constructor(t){P_.mark(S_.create);const e=Object.assign(Object.assign({},V_),t);if(null!=e.minZoom&&null!=e.maxZoom&&e.minZoom>e.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=e.minPitch&&null!=e.maxPitch&&e.minPitch>e.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=e.minPitch&&e.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=e.maxPitch&&e.maxPitch>85)throw new Error("maxPitch must be less than or equal to 85");if(super(new xm(e.minZoom,e.maxZoom,e.minPitch,e.maxPitch,e.renderWorldCopies),{bearingSnap:e.bearingSnap}),this._idleTriggered=!1,this._crossFadingFactor=1,this._renderTaskQueue=new T_,this._controls=[],this._mapId=b(),this._contextLost=t=>{t.preventDefault(),this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this.fire(new rt("webglcontextlost",{originalEvent:t}))},this._contextRestored=t=>{this._setupPainter(),this.resize(),this._update(),this.fire(new rt("webglcontextrestored",{originalEvent:t}))},this._onMapScroll=t=>{if(t.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1},this._onWindowOnline=()=>{this._update()},this._interactive=e.interactive,this._maxTileCacheSize=e.maxTileCacheSize,this._maxTileCacheZoomLevels=e.maxTileCacheZoomLevels,this._failIfMajorPerformanceCaveat=!0===e.failIfMajorPerformanceCaveat,this._preserveDrawingBuffer=!0===e.preserveDrawingBuffer,this._antialias=!0===e.antialias,this._trackResize=!0===e.trackResize,this._bearingSnap=e.bearingSnap,this._refreshExpiredTiles=!0===e.refreshExpiredTiles,this._fadeDuration=e.fadeDuration,this._crossSourceCollisions=!0===e.crossSourceCollisions,this._collectResourceTiming=!0===e.collectResourceTiming,this._locale=Object.assign(Object.assign({},F_),e.locale),this._clickTolerance=e.clickTolerance,this._overridePixelRatio=e.pixelRatio,this._maxCanvasSize=e.maxCanvasSize,this.transformCameraUpdate=e.transformCameraUpdate,this.cancelPendingTileRequestsWhileZooming=!0===e.cancelPendingTileRequestsWhileZooming,this._imageQueueHandle=Q.addThrottleControl((()=>this.isMoving())),this._requestManager=new tt(e.transformRequest),"string"==typeof e.container){if(this._container=document.getElementById(e.container),!this._container)throw new Error(`Container '${e.container}' not found.`)}else{if(!(e.container instanceof HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=e.container}if(e.maxBounds&&this.setMaxBounds(e.maxBounds),this._setupContainer(),this._setupPainter(),this.on("move",(()=>this._update(!1))).on("moveend",(()=>this._update(!1))).on("zoom",(()=>this._update(!0))).on("terrain",(()=>{this.painter.terrainFacilitator.dirty=!0,this._update(!0)})).once("idle",(()=>{this._idleTriggered=!0})),"undefined"!=typeof window){addEventListener("online",this._onWindowOnline,!1);let t=!1;const e=vm((t=>{this._trackResize&&!this._removed&&(this.resize(t),this.redraw())}),50);this._resizeObserver=new ResizeObserver((i=>{t?e(i):t=!0})),this._resizeObserver.observe(this._container)}this.handlers=new y_(this,e),this._hash=e.hash&&new bm("string"==typeof e.hash&&e.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:e.center,zoom:e.zoom,bearing:e.bearing,pitch:e.pitch}),e.bounds&&(this.resize(),this.fitBounds(e.bounds,y({},e.fitBoundsOptions,{duration:0})))),this.resize(),this._localIdeographFontFamily=e.localIdeographFontFamily,this._validateStyle=e.validateStyle,e.style&&this.setStyle(e.style,{localIdeographFontFamily:e.localIdeographFontFamily}),e.attributionControl&&this.addControl(new b_("boolean"==typeof e.attributionControl?void 0:e.attributionControl)),e.maplibreLogo&&this.addControl(new w_,e.logoPosition),this.on("style.load",(()=>{this.transform.unmodified&&this.jumpTo(this.style.stylesheet)})),this.on("data",(t=>{this._update("style"===t.dataType),this.fire(new rt(`${t.dataType}data`,t))})),this.on("dataloading",(t=>{this.fire(new rt(`${t.dataType}dataloading`,t))})),this.on("dataabort",(t=>{this.fire(new rt("sourcedataabort",t))}))}_getMapId(){return this._mapId}addControl(t,e){if(void 0===e&&(e=t.getDefaultPosition?t.getDefaultPosition():"top-right"),!t||!t.onAdd)return this.fire(new st(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const i=t.onAdd(this);this._controls.push(t);const r=this._controlPositions[e];return-1!==e.indexOf("bottom")?r.insertBefore(i,r.firstChild):r.appendChild(i),this}removeControl(t){if(!t||!t.onRemove)return this.fire(new st(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const e=this._controls.indexOf(t);return e>-1&&this._controls.splice(e,1),t.onRemove(this),this}hasControl(t){return this._controls.indexOf(t)>-1}calculateCameraOptionsFromTo(t,e,i,r){return null==r&&this.terrain&&(r=this.terrain.getElevationForLngLatZoom(i,this.transform.tileZoom)),super.calculateCameraOptionsFromTo(t,e,i,r)}resize(t){var e;const i=this._containerDimensions(),r=i[0],s=i[1],n=this._getClampedPixelRatio(r,s);if(this._resizeCanvas(r,s,n),this.painter.resize(r,s,n),this.painter.overLimit()){const t=this.painter.context.gl;this._maxCanvasSize=[t.drawingBufferWidth,t.drawingBufferHeight];const e=this._getClampedPixelRatio(r,s);this._resizeCanvas(r,s,e),this.painter.resize(r,s,e)}this.transform.resize(r,s),null===(e=this._requestedCameraState)||void 0===e||e.resize(r,s);const a=!this._moving;return a&&(this.stop(),this.fire(new rt("movestart",t)).fire(new rt("move",t))),this.fire(new rt("resize",t)),a&&this.fire(new rt("moveend",t)),this}_getClampedPixelRatio(t,e){const{0:i,1:r}=this._maxCanvasSize,s=this.getPixelRatio(),n=t*s,a=e*s;return Math.min(n>i?i/n:1,a>r?r/a:1)*s}getPixelRatio(){var t;return null!==(t=this._overridePixelRatio)&&void 0!==t?t:devicePixelRatio}setPixelRatio(t){this._overridePixelRatio=t,this.resize()}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(t){return this.transform.setMaxBounds(mu.convert(t)),this._update()}setMinZoom(t){if((t=null==t?-2:t)>=-2&&t<=this.transform.maxZoom)return this.transform.minZoom=t,this._update(),this.getZoom()<t&&this.setZoom(t),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(t){if((t=null==t?22:t)>=this.transform.minZoom)return this.transform.maxZoom=t,this._update(),this.getZoom()>t&&this.setZoom(t),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(t){if((t=null==t?0:t)<0)throw new Error("minPitch must be greater than or equal to 0");if(t>=0&&t<=this.transform.maxPitch)return this.transform.minPitch=t,this._update(),this.getPitch()<t&&this.setPitch(t),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(t){if((t=null==t?60:t)>85)throw new Error("maxPitch must be less than or equal to 85");if(t>=this.transform.minPitch)return this.transform.maxPitch=t,this._update(),this.getPitch()>t&&this.setPitch(t),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(t){return this.transform.renderWorldCopies=t,this._update()}project(t){return this.transform.locationPoint(fu.convert(t),this.style&&this.terrain)}unproject(t){return this.transform.pointLocation(a.convert(t),this.terrain)}isMoving(){var t;return this._moving||(null===(t=this.handlers)||void 0===t?void 0:t.isMoving())}isZooming(){var t;return this._zooming||(null===(t=this.handlers)||void 0===t?void 0:t.isZooming())}isRotating(){var t;return this._rotating||(null===(t=this.handlers)||void 0===t?void 0:t.isRotating())}_createDelegatedListener(t,e,i){if("mouseenter"===t||"mouseover"===t){let r=!1;const s=s=>{const n=e.filter((t=>this.getLayer(t))),a=0!==n.length?this.queryRenderedFeatures(s.point,{layers:n}):[];a.length?r||(r=!0,i.call(this,new Pm(t,this,s.originalEvent,{features:a}))):r=!1};return{layers:e,listener:i,delegates:{mousemove:s,mouseout:()=>{r=!1}}}}if("mouseleave"===t||"mouseout"===t){let r=!1;const s=s=>{const n=e.filter((t=>this.getLayer(t)));(0!==n.length?this.queryRenderedFeatures(s.point,{layers:n}):[]).length?r=!0:r&&(r=!1,i.call(this,new Pm(t,this,s.originalEvent)))},n=e=>{r&&(r=!1,i.call(this,new Pm(t,this,e.originalEvent)))};return{layers:e,listener:i,delegates:{mousemove:s,mouseout:n}}}{const r=t=>{const r=e.filter((t=>this.getLayer(t))),s=0!==r.length?this.queryRenderedFeatures(t.point,{layers:r}):[];s.length&&(t.features=s,i.call(this,t),delete t.features)};return{layers:e,listener:i,delegates:{[t]:r}}}}_saveDelegatedListener(t,e){this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[t]=this._delegatedListeners[t]||[],this._delegatedListeners[t].push(e)}_removeDelegatedListener(t,e,i){if(!this._delegatedListeners||!this._delegatedListeners[t])return;const r=this._delegatedListeners[t];for(let t=0;t<r.length;t++){const s=r[t];if(s.listener===i&&s.layers.length===e.length&&s.layers.every((t=>e.includes(t)))){for(const t in s.delegates)this.off(t,s.delegates[t]);return void r.splice(t,1)}}}on(t,e,i){if(void 0===i)return super.on(t,e);const r=this._createDelegatedListener(t,"string"==typeof e?[e]:e,i);this._saveDelegatedListener(t,r);for(const t in r.delegates)this.on(t,r.delegates[t]);return this}once(t,e,i){if(void 0===i)return super.once(t,e);const r="string"==typeof e?[e]:e,s=this._createDelegatedListener(t,r,i);for(const e in s.delegates){const n=s.delegates[e];s.delegates[e]=(...e)=>{this._removeDelegatedListener(t,r,i),n(...e)}}this._saveDelegatedListener(t,s);for(const t in s.delegates)this.once(t,s.delegates[t]);return this}off(t,e,i){return void 0===i?super.off(t,e):(this._removeDelegatedListener(t,"string"==typeof e?[e]:e,i),this)}queryRenderedFeatures(t,e){if(!this.style)return[];let i;const r=t instanceof a||Array.isArray(t),s=r?t:[[0,0],[this.transform.width,this.transform.height]];if(e=e||(r?{}:t)||{},s instanceof a||"number"==typeof s[0])i=[a.convert(s)];else{const t=a.convert(s[0]),e=a.convert(s[1]);i=[t,new a(e.x,t.y),e,new a(t.x,e.y),t]}return this.style.queryRenderedFeatures(i,e,this.transform)}querySourceFeatures(t,e){return this.style.querySourceFeatures(t,e)}setStyle(t,e){return!1!==(e=y({},{localIdeographFontFamily:this._localIdeographFontFamily,validate:this._validateStyle},e)).diff&&e.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&t?(this._diffStyle(t,e),this):(this._localIdeographFontFamily=e.localIdeographFontFamily,this._updateStyle(t,e))}setTransformRequest(t){return this._requestManager.setTransformRequest(t),this}_getUIString(t){const e=this._locale[t];if(null==e)throw new Error(`Missing UI string '${t}'`);return e}_updateStyle(t,e){if(e.transformStyle&&this.style&&!this.style._loaded)return void this.style.once("style.load",(()=>this._updateStyle(t,e)));const i=this.style&&e.transformStyle?this.style.serialize():void 0;return this.style&&(this.style.setEventedParent(null),this.style._remove(!t)),t?(this.style=new od(this,e||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof t?this.style.loadURL(t,e,i):this.style.loadJSON(t,e,i),this):(delete this.style,this)}_lazyInitEmptyStyle(){this.style||(this.style=new od(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty())}_diffStyle(t,e){if("string"==typeof t){const i=this._requestManager.transformRequest(t,"Style");Z(i,new AbortController).then((t=>{this._updateDiff(t.data,e)})).catch((t=>{t&&this.fire(new st(t))}))}else"object"==typeof t&&this._updateDiff(t,e)}_updateDiff(t,e){try{this.style.setState(t,e)&&this._update(!0)}catch(i){C(`Unable to perform style diff: ${i.message||i.error||i}.  Rebuilding the style from scratch.`),this._updateStyle(t,e)}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():C("There is no style added to the map.")}addSource(t,e){return this._lazyInitEmptyStyle(),this.style.addSource(t,e),this._update(!0)}isSourceLoaded(t){const e=this.style&&this.style.sourceCaches[t];if(void 0!==e)return e.loaded();this.fire(new st(new Error(`There is no source with ID '${t}'`)))}setTerrain(t){if(this.style._checkLoaded(),this._terrainDataCallback&&this.style.off("data",this._terrainDataCallback),t){const e=this.style.sourceCaches[t.source];if(!e)throw new Error(`cannot load terrain, because there exists no source with ID: ${t.source}`);null===this.terrain&&e.reload();for(const e in this.style._layers){const i=this.style._layers[e];"hillshade"===i.type&&i.source===t.source&&C("You are using the same source for a hillshade layer and for 3D terrain. Please consider using two separate sources to improve rendering quality.")}this.terrain=new D_(this.painter,e,t),this.painter.renderToTexture=new B_(this.painter,this.terrain),this.transform.minElevationForCurrentTile=this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom),this.transform.elevation=this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom),this._terrainDataCallback=e=>{"style"===e.dataType?this.terrain.sourceCache.freeRtt():"source"===e.dataType&&e.tile&&(e.sourceId!==t.source||this._elevationFreeze||(this.transform.minElevationForCurrentTile=this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom),this.transform.elevation=this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this.terrain.sourceCache.freeRtt(e.tile.tileID))},this.style.on("data",this._terrainDataCallback)}else this.terrain&&this.terrain.sourceCache.destruct(),this.terrain=null,this.painter.renderToTexture&&this.painter.renderToTexture.destruct(),this.painter.renderToTexture=null,this.transform.minElevationForCurrentTile=0,this.transform.elevation=0;return this.fire(new rt("terrain",{terrain:t})),this}getTerrain(){var t,e;return null!==(e=null===(t=this.terrain)||void 0===t?void 0:t.options)&&void 0!==e?e:null}areTilesLoaded(){const t=this.style&&this.style.sourceCaches;for(const e in t){const i=t[e]._tiles;for(const t in i){const e=i[t];if("loaded"!==e.state&&"errored"!==e.state)return!1}}return!0}removeSource(t){return this.style.removeSource(t),this._update(!0)}getSource(t){return this.style.getSource(t)}addImage(t,e,i={}){const{pixelRatio:r=1,sdf:s=!1,stretchX:n,stretchY:a,content:o,textFitWidth:l,textFitHeight:c}=i;if(this._lazyInitEmptyStyle(),!(e instanceof HTMLImageElement||M(e))){if(void 0===e.width||void 0===e.height)return this.fire(new st(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:i,height:h,data:u}=e,p=e;return this.style.addImage(t,{data:new Qo({width:i,height:h},new Uint8Array(u)),pixelRatio:r,stretchX:n,stretchY:a,content:o,textFitWidth:l,textFitHeight:c,sdf:s,version:0,userImage:p}),p.onAdd&&p.onAdd(this,t),this}}{const{width:i,height:h,data:u}=F.getImageData(e);this.style.addImage(t,{data:new Qo({width:i,height:h},u),pixelRatio:r,stretchX:n,stretchY:a,content:o,textFitWidth:l,textFitHeight:c,sdf:s,version:0})}}updateImage(t,e){const i=this.style.getImage(t);if(!i)return this.fire(new st(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const r=e instanceof HTMLImageElement||M(e)?F.getImageData(e):e,{width:s,height:n,data:a}=r;if(void 0===s||void 0===n)return this.fire(new st(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));if(s!==i.data.width||n!==i.data.height)return this.fire(new st(new Error("The width and height of the updated image must be that same as the previous version of the image")));const o=!(e instanceof HTMLImageElement||M(e));return i.data.replace(a,o),this.style.updateImage(t,i),this}getImage(t){return this.style.getImage(t)}hasImage(t){return t?!!this.style.getImage(t):(this.fire(new st(new Error("Missing required image id"))),!1)}removeImage(t){this.style.removeImage(t)}loadImage(t){return Q.getImage(this._requestManager.transformRequest(t,"Image"),new AbortController)}listImages(){return this.style.listImages()}addLayer(t,e){return this._lazyInitEmptyStyle(),this.style.addLayer(t,e),this._update(!0)}moveLayer(t,e){return this.style.moveLayer(t,e),this._update(!0)}removeLayer(t){return this.style.removeLayer(t),this._update(!0)}getLayer(t){return this.style.getLayer(t)}getLayersOrder(){return this.style.getLayersOrder()}setLayerZoomRange(t,e,i){return this.style.setLayerZoomRange(t,e,i),this._update(!0)}setFilter(t,e,i={}){return this.style.setFilter(t,e,i),this._update(!0)}getFilter(t){return this.style.getFilter(t)}setPaintProperty(t,e,i,r={}){return this.style.setPaintProperty(t,e,i,r),this._update(!0)}getPaintProperty(t,e){return this.style.getPaintProperty(t,e)}setLayoutProperty(t,e,i,r={}){return this.style.setLayoutProperty(t,e,i,r),this._update(!0)}getLayoutProperty(t,e){return this.style.getLayoutProperty(t,e)}setGlyphs(t,e={}){return this._lazyInitEmptyStyle(),this.style.setGlyphs(t,e),this._update(!0)}getGlyphs(){return this.style.getGlyphsUrl()}addSprite(t,e,i={}){return this._lazyInitEmptyStyle(),this.style.addSprite(t,e,i,(t=>{t||this._update(!0)})),this}removeSprite(t){return this._lazyInitEmptyStyle(),this.style.removeSprite(t),this._update(!0)}getSprite(){return this.style.getSprite()}setSprite(t,e={}){return this._lazyInitEmptyStyle(),this.style.setSprite(t,e,(t=>{t||this._update(!0)})),this}setLight(t,e={}){return this._lazyInitEmptyStyle(),this.style.setLight(t,e),this._update(!0)}getLight(){return this.style.getLight()}setSky(t){return this._lazyInitEmptyStyle(),this.style.setSky(t),this._update(!0)}getSky(){return this.style.getSky()}setFeatureState(t,e){return this.style.setFeatureState(t,e),this._update()}removeFeatureState(t,e){return this.style.removeFeatureState(t,e),this._update()}getFeatureState(t){return this.style.getFeatureState(t)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let t=0,e=0;return this._container&&(t=this._container.clientWidth||400,e=this._container.clientHeight||300),[t,e]}_setupContainer(){const t=this._container;t.classList.add("maplibregl-map");const e=this._canvasContainer=O.create("div","maplibregl-canvas-container",t);this._interactive&&e.classList.add("maplibregl-interactive"),this._canvas=O.create("canvas","maplibregl-canvas",e),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex",this._interactive?"0":"-1"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region");const i=this._containerDimensions(),r=this._getClampedPixelRatio(i[0],i[1]);this._resizeCanvas(i[0],i[1],r);const s=this._controlContainer=O.create("div","maplibregl-control-container",t),n=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((t=>{n[t]=O.create("div",`maplibregl-ctrl-${t} `,s)})),this._container.addEventListener("scroll",this._onMapScroll,!1)}_resizeCanvas(t,e,i){this._canvas.width=Math.floor(i*t),this._canvas.height=Math.floor(i*e),this._canvas.style.width=`${t}px`,this._canvas.style.height=`${e}px`}_setupPainter(){const t={alpha:!0,stencil:!0,depth:!0,failIfMajorPerformanceCaveat:this._failIfMajorPerformanceCaveat,preserveDrawingBuffer:this._preserveDrawingBuffer,antialias:this._antialias||!1};let e=null;this._canvas.addEventListener("webglcontextcreationerror",(i=>{e={requestedAttributes:t},i&&(e.statusMessage=i.statusMessage,e.type=i.type)}),{once:!0});const i=this._canvas.getContext("webgl2",t)||this._canvas.getContext("webgl",t);if(!i){const t="Failed to initialize WebGL";throw e?(e.message=t,new Error(JSON.stringify(e))):new Error(t)}this.painter=new fm(i,this.transform),W.testSupport(i)}loaded(){return!this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(t){return this.style&&this.style._loaded?(this._styleDirty=this._styleDirty||t,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(t){return this._update(),this._renderTaskQueue.add(t)}_cancelRenderFrame(t){this._renderTaskQueue.remove(t)}_render(t){const e=this._idleTriggered?this._fadeDuration:0;if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(t),this._removed)return;let i=!1;if(this.style&&this._styleDirty){this._styleDirty=!1;const t=this.transform.zoom,r=F.now();this.style.zoomHistory.update(t,r);const s=new Ks(t,{now:r,fadeDuration:e,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),n=s.crossFadingFactor();1===n&&n===this._crossFadingFactor||(i=!0,this._crossFadingFactor=n),this.style.update(s)}this.style&&this._sourcesDirty&&(this._sourcesDirty=!1,this.style._updateSources(this.transform)),this.terrain?(this.terrain.sourceCache.update(this.transform,this.terrain),this.transform.minElevationForCurrentTile=this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom),this._elevationFreeze||(this.transform.elevation=this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))):(this.transform.minElevationForCurrentTile=0,this.transform.elevation=0),this._placementDirty=this.style&&this.style._updatePlacement(this.painter.transform,this.showCollisionBoxes,e,this._crossSourceCollisions),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:e,showPadding:this.showPadding}),this.fire(new rt("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,P_.mark(S_.load),this.fire(new rt("load"))),this.style&&(this.style.hasTransitions()||i)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles();const r=this._sourcesDirty||this._styleDirty||this._placementDirty;return r||this._repaint?this.triggerRepaint():!this.isMoving()&&this.loaded()&&this.fire(new rt("idle")),!this._loaded||this._fullyLoaded||r||(this._fullyLoaded=!0,P_.mark(S_.fullLoad)),this}redraw(){return this.style&&(this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._render(0)),this}remove(){var t;this._hash&&this._hash.remove();for(const t of this._controls)t.onRemove(this);this._controls=[],this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),"undefined"!=typeof window&&removeEventListener("online",this._onWindowOnline,!1),Q.removeThrottleControl(this._imageQueueHandle),null===(t=this._resizeObserver)||void 0===t||t.disconnect();const e=this.painter.context.gl.getExtension("WEBGL_lose_context");(null==e?void 0:e.loseContext)&&e.loseContext(),this._canvas.removeEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.removeEventListener("webglcontextlost",this._contextLost,!1),O.remove(this._canvasContainer),O.remove(this._controlContainer),this._container.classList.remove("maplibregl-map"),P_.clearMetrics(),this._removed=!0,this.fire(new rt("remove"))}triggerRepaint(){this.style&&!this._frameRequest&&(this._frameRequest=new AbortController,F.frameAsync(this._frameRequest).then((t=>{P_.frame(t),this._frameRequest=null,this._render(t)})).catch((()=>{})))}get showTileBoundaries(){return!!this._showTileBoundaries}set showTileBoundaries(t){this._showTileBoundaries!==t&&(this._showTileBoundaries=t,this._update())}get showPadding(){return!!this._showPadding}set showPadding(t){this._showPadding!==t&&(this._showPadding=t,this._update())}get showCollisionBoxes(){return!!this._showCollisionBoxes}set showCollisionBoxes(t){this._showCollisionBoxes!==t&&(this._showCollisionBoxes=t,t?this.style._generateCollisionBoxes():this._update())}get showOverdrawInspector(){return!!this._showOverdrawInspector}set showOverdrawInspector(t){this._showOverdrawInspector!==t&&(this._showOverdrawInspector=t,this._update())}get repaint(){return!!this._repaint}set repaint(t){this._repaint!==t&&(this._repaint=t,this.triggerRepaint())}get vertices(){return!!this._vertices}set vertices(t){this._vertices=t,this._update()}get version(){return O_}getCameraTargetElevation(){return this.transform.elevation}},t.MapMouseEvent=Pm,t.MapTouchEvent=Mm,t.MapWheelEvent=km,t.Marker=W_,t.MercatorCoordinate=wu,t.NavigationControl=class{constructor(t){this._updateZoomButtons=()=>{const t=this._map.getZoom(),e=t===this._map.getMaxZoom(),i=t===this._map.getMinZoom();this._zoomInButton.disabled=e,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",e.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString())},this._rotateCompassArrow=()=>{const t=this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitch*(Math.PI/180)),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${this._map.transform.angle*(180/Math.PI)}deg)`:`rotate(${this._map.transform.angle*(180/Math.PI)}deg)`;this._compassIcon.style.transform=t},this._setButtonTitle=(t,e)=>{const i=this._map._getUIString(`NavigationControl.${e}`);t.title=i,t.setAttribute("aria-label",i)},this.options=y({},N_,t),this._container=O.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this.options.showZoom&&(this._zoomInButton=this._createButton("maplibregl-ctrl-zoom-in",(t=>this._map.zoomIn({},{originalEvent:t}))),O.create("span","maplibregl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden","true"),this._zoomOutButton=this._createButton("maplibregl-ctrl-zoom-out",(t=>this._map.zoomOut({},{originalEvent:t}))),O.create("span","maplibregl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden","true")),this.options.showCompass&&(this._compass=this._createButton("maplibregl-ctrl-compass",(t=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:t}):this._map.resetNorth({},{originalEvent:t})})),this._compassIcon=O.create("span","maplibregl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden","true"))}onAdd(t){return this._map=t,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new j_(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){O.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map}_createButton(t,e){const i=O.create("button",t,this._container);return i.type="button",i.addEventListener("click",e),i}},t.Point=a,t.Popup=class extends nt{constructor(t){super(),this.remove=()=>(this._content&&O.remove(this._content),this._container&&(O.remove(this._container),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),this._map._canvasContainer.classList.remove("maplibregl-track-pointer"),delete this._map,this.fire(new rt("close"))),this),this._onMouseUp=t=>{this._update(t.point)},this._onMouseMove=t=>{this._update(t.point)},this._onDrag=t=>{this._update(t.point)},this._update=t=>{var e;if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(!this._container){if(this._container=O.create("div","maplibregl-popup",this._map.getContainer()),this._tip=O.create("div","maplibregl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className)for(const t of this.options.className.split(" "))this._container.classList.add(t);this._closeButton&&this._closeButton.setAttribute("aria-label",this._map._getUIString("Popup.Close")),this._trackPointer&&this._container.classList.add("maplibregl-popup-track-pointer")}if(this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._lngLat=this._map.transform.renderWorldCopies&&!this._trackPointer?q_(this._lngLat,this._flatPos,this._map.transform):null===(e=this._lngLat)||void 0===e?void 0:e.wrap(),this._trackPointer&&!t)return;const i=this._flatPos=this._pos=this._trackPointer&&t?t:this._map.project(this._lngLat);this._map.terrain&&(this._flatPos=this._trackPointer&&t?t:this._map.transform.locationPoint(this._lngLat));let r=this.options.anchor;const s=ig(this.options.offset);if(!r){const t=this._container.offsetWidth,e=this._container.offsetHeight;let n;n=i.y+s.bottom.y<e?["top"]:i.y>this._map.transform.height-e?["bottom"]:[],i.x<t/2?n.push("left"):i.x>this._map.transform.width-t/2&&n.push("right"),r=0===n.length?"bottom":n.join("-")}let n=i.add(s[r]);this.options.subpixelPositioning||(n=n.round()),O.setTransform(this._container,`${Z_[r]} translate(${n.x}px,${n.y}px)`),G_(this._container,r,"popup")},this._onClose=()=>{this.remove()},this.options=y(Object.create(tg),t)}addTo(t){return this._map&&this.remove(),this._map=t,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")):this._map.on("move",this._update),this.fire(new rt("open")),this}isOpen(){return!!this._map}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=fu.convert(t),this._pos=null,this._flatPos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.remove("maplibregl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._flatPos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")),this}getElement(){return this._container}setText(t){return this.setDOMContent(document.createTextNode(t))}setHTML(t){const e=document.createDocumentFragment(),i=document.createElement("body");let r;for(i.innerHTML=t;r=i.firstChild,r;)e.appendChild(r);return this.setDOMContent(e)}getMaxWidth(){var t;return null===(t=this._container)||void 0===t?void 0:t.style.maxWidth}setMaxWidth(t){return this.options.maxWidth=t,this._update(),this}setDOMContent(t){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=O.create("div","maplibregl-popup-content",this._container);return this._content.appendChild(t),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(t){return this._container&&this._container.classList.add(t),this}removeClassName(t){return this._container&&this._container.classList.remove(t),this}setOffset(t){return this.options.offset=t,this._update(),this}toggleClassName(t){if(this._container)return this._container.classList.toggle(t)}setSubpixelPositioning(t){this.options.subpixelPositioning=t}_createCloseButton(){this.options.closeButton&&(this._closeButton=O.create("button","maplibregl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose))}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const t=this._container.querySelector(eg);t&&t.focus()}},t.RasterDEMTileSource=Mu,t.RasterTileSource=Iu,t.ScaleControl=class{constructor(t){this._onMove=()=>{J_(this._map,this._container,this.options)},this.setUnit=t=>{this.options.unit=t,J_(this._map,this._container,this.options)},this.options=Object.assign(Object.assign({},Y_),t)}getDefaultPosition(){return"bottom-left"}onAdd(t){return this._map=t,this._container=O.create("div","maplibregl-ctrl maplibregl-ctrl-scale",t.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){O.remove(this._container),this._map.off("move",this._onMove),this._map=void 0}},t.ScrollZoomHandler=o_,t.Style=od,t.TerrainControl=class{constructor(t){this._toggleTerrain=()=>{this._map.getTerrain()?this._map.setTerrain(null):this._map.setTerrain(this.options),this._updateTerrainIcon()},this._updateTerrainIcon=()=>{this._terrainButton.classList.remove("maplibregl-ctrl-terrain"),this._terrainButton.classList.remove("maplibregl-ctrl-terrain-enabled"),this._map.terrain?(this._terrainButton.classList.add("maplibregl-ctrl-terrain-enabled"),this._terrainButton.title=this._map._getUIString("TerrainControl.Disable")):(this._terrainButton.classList.add("maplibregl-ctrl-terrain"),this._terrainButton.title=this._map._getUIString("TerrainControl.Enable"))},this.options=t}onAdd(t){return this._map=t,this._container=O.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._terrainButton=O.create("button","maplibregl-ctrl-terrain",this._container),O.create("span","maplibregl-ctrl-icon",this._terrainButton).setAttribute("aria-hidden","true"),this._terrainButton.type="button",this._terrainButton.addEventListener("click",this._toggleTerrain),this._updateTerrainIcon(),this._map.on("terrain",this._updateTerrainIcon),this._container}onRemove(){O.remove(this._container),this._map.off("terrain",this._updateTerrainIcon),this._map=void 0}},t.TwoFingersTouchPitchHandler=i_,t.TwoFingersTouchRotateHandler=t_,t.TwoFingersTouchZoomHandler=Jm,t.TwoFingersTouchZoomRotateHandler=d_,t.VectorTileSource=Su,t.VideoSource=Ru,t.addProtocol=function(t,e){V.REGISTERED_PROTOCOLS[t]=e},t.addSourceType=(t,e)=>i(void 0,void 0,void 0,(function*(){if(Ou(t))throw new Error(`A source type called "${t}" already exists.`);((t,e)=>{Fu[t]=e})(t,e)})),t.clearPrewarmedResources=function(){const t=su;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(eu),su=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"))},t.config=V,t.getMaxParallelImageRequests=function(){return V.MAX_PARALLEL_IMAGE_REQUESTS},t.getRTLTextPluginStatus=function(){return Wu().getRTLTextPluginStatus()},t.getVersion=function(){return rg},t.getWorkerCount=function(){return iu.workerCount},t.getWorkerUrl=function(){return V.WORKER_URL},t.importScriptInWorkers=function(t){return lu().broadcast("IS",t)},t.prewarm=function(){au().acquire(eu)},t.removeProtocol=function(t){delete V.REGISTERED_PROTOCOLS[t]},t.setMaxParallelImageRequests=function(t){V.MAX_PARALLEL_IMAGE_REQUESTS=t},t.setRTLTextPlugin=function(t,e){return Wu().setRTLTextPlugin(t,e)},t.setWorkerCount=function(t){iu.workerCount=t},t.setWorkerUrl=function(t){V.WORKER_URL=t}}));
//# sourceMappingURL=maplibre-gl-csp.js.map
