import HTMLElement from '../html-element/HTMLElement.js';
import * as PropertySymbol from '../../PropertySymbol.js';
import Event from '../../event/Event.js';
import HTMLFormControlsCollection from './HTMLFormControlsCollection.js';
import HTMLInputElement from '../html-input-element/HTMLInputElement.js';
import HTMLButtonElement from '../html-button-element/HTMLButtonElement.js';
import THTMLFormControlElement from './THTMLFormControlElement.js';
import RadioNodeList from './RadioNodeList.js';
/**
 * HTML Form Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLFormElement.
 */
export default class HTMLFormElement extends HTMLElement {
    #private;
    cloneNode: (deep?: boolean) => HTMLFormElement;
    [PropertySymbol.elements]: HTMLFormControlsCollection | null;
    [PropertySymbol.proxy]: HTMLFormElement;
    onformdata: (event: Event) => void | null;
    onreset: (event: Event) => void | null;
    onsubmit: (event: Event) => void | null;
    /**
     * Constructor.
     */
    constructor();
    /**
     * Returns elements.
     *
     * @returns Elements.
     */
    get elements(): HTMLFormControlsCollection;
    /**
     * Returns length.
     *
     * @returns Length.
     */
    get length(): number;
    /**
     * Returns name.
     *
     * @returns Name.
     */
    get name(): string;
    /**
     * Sets name.
     *
     * @param name Name.
     */
    set name(name: string);
    /**
     * Returns method.
     *
     * @returns Method.
     */
    get method(): string;
    /**
     * Sets method.
     *
     * @param method Method.
     */
    set method(method: string);
    /**
     * Returns target.
     *
     * @returns Target.
     */
    get target(): string;
    /**
     * Sets target.
     *
     * @param target Target.
     */
    set target(target: string);
    /**
     * Returns action.
     *
     * @returns Action.
     */
    get action(): string;
    /**
     * Sets action.
     *
     * @param action Action.
     */
    set action(action: string);
    /**
     * Returns encoding.
     *
     * @returns Encoding.
     */
    get encoding(): string;
    /**
     * Sets encoding.
     *
     * @param encoding Encoding.
     */
    set encoding(encoding: string);
    /**
     * Returns enctype.
     *
     * @returns Enctype.
     */
    get enctype(): string;
    /**
     * Sets enctype.
     *
     * @param enctype Enctype.
     */
    set enctype(enctype: string);
    /**
     * Returns autocomplete.
     *
     * @returns Autocomplete.
     */
    get autocomplete(): string;
    /**
     * Sets autocomplete.
     *
     * @param autocomplete Autocomplete.
     */
    set autocomplete(autocomplete: string);
    /**
     * Returns accept charset.
     *
     * @returns Accept charset.
     */
    get acceptCharset(): string;
    /**
     * Sets accept charset.
     *
     * @param acceptCharset Accept charset.
     */
    set acceptCharset(acceptCharset: string);
    /**
     * Returns no validate.
     *
     * @returns No validate.
     */
    get noValidate(): boolean;
    /**
     * Sets no validate.
     *
     * @param noValidate No validate.
     */
    set noValidate(noValidate: boolean);
    /**
     * Submits form. No submit event is raised. In particular, the form's "submit" event handler is not run.
     */
    submit(): void;
    /**
     * Submits form, reports validity and raises submit event.
     *
     * @param [submitter] Submitter.
     */
    requestSubmit(submitter?: HTMLInputElement | HTMLButtonElement): void;
    /**
     * Resets form.
     */
    reset(): void;
    /**
     * Checks validity.
     *
     * @returns "true" if validation does'nt fail.
     */
    checkValidity(): boolean;
    /**
     * Reports validity.
     *
     * @returns "true" if validation does'nt fail.
     */
    reportValidity(): boolean;
    /**
     * @override
     */
    [PropertySymbol.cloneNode](deep?: boolean): HTMLFormElement;
    /**
     * Returns form control items.
     *
     * @returns Form control items.
     */
    [PropertySymbol.getFormControlItems](): THTMLFormControlElement[];
    /**
     * Returns form control named item.
     *
     * @param name
     * @returns Form control named item.
     */
    [PropertySymbol.getFormControlNamedItem](name: string): THTMLFormControlElement | RadioNodeList | null;
}
//# sourceMappingURL=HTMLFormElement.d.ts.map