import HTMLElement from '../html-element/HTMLElement.js';
/**
 * HTMLEmbedElement
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/HTMLEmbedElement
 */
export default class HTMLEmbedElement extends HTMLElement {
    /**
     * Returns height.
     *
     * @returns Height.
     */
    get height(): string;
    /**
     * Sets height.
     *
     * @param height Height.
     */
    set height(height: string);
    /**
     * Returns width.
     *
     * @returns Width.
     */
    get width(): string;
    /**
     * Sets width.
     *
     * @param width Width.
     */
    set width(width: string);
    /**
     * Returns source.
     *
     * @returns Source.
     */
    get src(): string;
    /**
     * Sets source.
     *
     * @param src Source.
     */
    set src(src: string);
    /**
     * Returns type.
     *
     * @returns Type.
     */
    get type(): string;
    /**
     * Sets type.
     *
     * @param type Type.
     */
    set type(type: string);
}
//# sourceMappingURL=HTMLEmbedElement.d.ts.map