import * as PropertySymbol from '../../PropertySymbol.js';
import Attr from '../attr/Attr.js';
import Element from './Element.js';
/**
 * Named Node Map.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/NamedNodeMap
 */
export default class NamedNodeMap {
    [index: number]: Attr;
    [PropertySymbol.namespaceItems]: Map<string, Attr>;
    [PropertySymbol.namedItems]: Map<string, Attr>;
    [PropertySymbol.ownerElement]: Element;
    /**
     * Constructor.
     *
     * @param ownerElement Owner element.
     */
    constructor(ownerElement: Element);
    /**
     * Returns length.
     *
     * @returns Length.
     */
    get length(): number;
    /**
     * Returns string.
     *
     * @returns string.
     */
    get [Symbol.toStringTag](): string;
    /**
     * Returns string.
     *
     * @returns string.
     */
    toString(): string;
    /**
     * Iterator.
     *
     * @returns Iterator.
     */
    [Symbol.iterator](): IterableIterator<Attr>;
    /**
     * Returns item by index.
     *
     * @param index Index.
     */
    item(index: number): Attr | null;
    /**
     * Returns named item.
     *
     * @param name Name.
     * @returns Item.
     */
    getNamedItem(name: string): Attr | null;
    /**
     * Returns item by name and namespace.
     *
     * @param namespace Namespace.
     * @param localName Local name of the attribute.
     * @returns Item.
     */
    getNamedItemNS(namespace: string, localName: string): Attr | null;
    /**
     * Sets named item.
     *
     * @param item Item.
     * @returns Replaced item.
     */
    setNamedItem(item: Attr): Attr | null;
    /**
     * Adds a new namespaced item.
     *
     * @alias setNamedItem()
     * @param item Item.
     * @returns Replaced item.
     */
    setNamedItemNS(item: Attr): Attr | null;
    /**
     * Removes an item.
     *
     * @throws DOMException
     * @param name Name of item.
     * @returns Removed item.
     */
    removeNamedItem(name: string): Attr;
    /**
     * Removes a namespaced item.
     *
     * @param namespace Namespace.
     * @param localName Local name of the item.
     * @returns Removed item.
     */
    removeNamedItemNS(namespace: string, localName: string): Attr | null;
    /**
     * Sets named item.
     *
     * @param item Item.
     * @param [ignoreListeners] Ignore listeners.
     * @returns Replaced item.
     */
    [PropertySymbol.setNamedItem](item: Attr, ignoreListeners?: boolean): Attr;
    /**
     * Removes named item.
     *
     * @param item Item.
     * @param ignoreListeners
     */
    [PropertySymbol.removeNamedItem](item: Attr, ignoreListeners?: boolean): void;
    /**
     * Returns item name based on namespace.
     *
     * @param namespaceURI Namespace.
     * @param name Name.
     * @returns Item name based on namespace.
     */
    private [PropertySymbol.getNamedItemKey];
    /**
     * Returns item key.
     *
     * @param item Item.
     * @returns Key.
     */
    private [PropertySymbol.getNamespaceItemKey];
}
//# sourceMappingURL=NamedNodeMap.d.ts.map