"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const PropertySymbol = __importStar(require("../PropertySymbol.cjs"));
const XMLParser_js_1 = __importDefault(require("../xml-parser/XMLParser.cjs"));
const NodeTypeEnum_js_1 = __importDefault(require("../nodes/node/NodeTypeEnum.cjs"));
/**
 * DOM parser.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/DOMParser.
 */
class DOMParser {
    /**
     * Parses HTML and returns a root element.
     *
     * @param string HTML data.
     * @param mimeType Mime type.
     * @returns Root element.
     */
    parseFromString(string, mimeType) {
        if (!mimeType) {
            throw new this[PropertySymbol.window].DOMException('Second parameter "mimeType" is mandatory.');
        }
        const newDocument = this.#createDocument(mimeType);
        const documentChildNodes = newDocument[PropertySymbol.nodeArray];
        while (documentChildNodes.length) {
            newDocument.removeChild(documentChildNodes[0]);
        }
        const root = XMLParser_js_1.default.parse(newDocument, string, { evaluateScripts: true });
        let documentElement = null;
        let documentTypeNode = null;
        for (const node of root[PropertySymbol.nodeArray]) {
            if (node['tagName'] === 'HTML') {
                documentElement = node;
            }
            else if (node[PropertySymbol.nodeType] === NodeTypeEnum_js_1.default.documentTypeNode) {
                documentTypeNode = node;
            }
            if (documentElement && documentTypeNode) {
                break;
            }
        }
        if (documentElement) {
            if (documentTypeNode) {
                newDocument.appendChild(documentTypeNode);
            }
            newDocument.appendChild(documentElement);
            const body = newDocument.body;
            if (body) {
                while (root[PropertySymbol.nodeArray].length) {
                    body.appendChild(root[PropertySymbol.nodeArray][0]);
                }
            }
        }
        else {
            switch (mimeType) {
                case 'image/svg+xml':
                    {
                        while (root[PropertySymbol.nodeArray].length) {
                            newDocument.appendChild(root[PropertySymbol.nodeArray][0]);
                        }
                    }
                    break;
                case 'text/html':
                default:
                    {
                        const documentElement = newDocument.createElement('html');
                        const bodyElement = newDocument.createElement('body');
                        const headElement = newDocument.createElement('head');
                        documentElement.appendChild(headElement);
                        documentElement.appendChild(bodyElement);
                        newDocument.appendChild(documentElement);
                        while (root[PropertySymbol.nodeArray].length) {
                            bodyElement.appendChild(root[PropertySymbol.nodeArray][0]);
                        }
                    }
                    break;
            }
        }
        return newDocument;
    }
    /**
     *
     * @param mimeType Mime type.
     * @returns Document.
     */
    #createDocument(mimeType) {
        const window = this[PropertySymbol.window];
        switch (mimeType) {
            case 'text/html':
                return new window.HTMLDocument();
            case 'image/svg+xml':
            case 'text/xml':
            case 'application/xml':
            case 'application/xhtml+xml':
                return new window.XMLDocument();
            default:
                throw new window.DOMException(`Unknown mime type "${mimeType}".`);
        }
    }
}
exports.default = DOMParser;
//# sourceMappingURL=DOMParser.cjs.map